/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.provider.pki.cmp;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.certj.provider.pki.cmp.CMPException;
import com.rsa.certj.provider.pki.cmp.CMPResponseCommon;
import com.rsa.certj.provider.pki.cmp.PKIHeader;
import com.rsa.certj.spi.pki.PKIException;
import com.rsa.certj.spi.pki.PKIStatusInfo;

public final class CMPErrorMessage
extends CMPResponseCommon {
    private boolean a = false;
    private int b;
    private String[] c = null;

    private CMPErrorMessage(PKIHeader pKIHeader, PKIStatusInfo pKIStatusInfo, boolean bl2, int n2, String[] stringArray) throws CMPException {
        super(23, pKIHeader, pKIStatusInfo);
        this.a = bl2;
        this.b = n2;
        this.c = stringArray;
    }

    protected static CMPErrorMessage berDecodeBody(PKIHeader pKIHeader, byte[] byArray, int n2) throws CMPException {
        Object object;
        EncodedContainer encodedContainer = null;
        IntegerContainer integerContainer = null;
        OfContainer ofContainer = null;
        try {
            encodedContainer = new EncodedContainer(12288);
            integerContainer = new IntegerContainer(65536);
            ofContainer = new OfContainer(65536, 12288, new EncodedContainer(3072));
            object = new ASN1Container[]{new SequenceContainer(10551319), encodedContainer, integerContainer, ofContainer, new EndContainer()};
            ASN1.berDecode(byArray, n2, object);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CMPException("CMPErrorMessage.berDecodeBody: decoding ErrorMsgContent faild(" + aSN_Exception.getMessage() + ").");
        }
        try {
            object = new PKIStatusInfo(encodedContainer.data, encodedContainer.dataOffset, 0);
        }
        catch (PKIException pKIException) {
            throw new CMPException("CMPErrorMessage$ErrorMsgContent.ErrorMsgContent: unable to instantiate PKIStatusInfo(" + pKIException.getMessage() + ").");
        }
        boolean bl2 = integerContainer.dataPresent;
        int n3 = -1;
        if (bl2) {
            try {
                n3 = integerContainer.getValueAsInt();
            }
            catch (ASN_Exception aSN_Exception) {
                throw new CMPException("CMPErrorMessage$ErrorMsgContent.ErrorMsgContent: unable to get ErrorMsgContent.errorCode as int(" + aSN_Exception.getMessage() + ").");
            }
        }
        String[] stringArray = null;
        if (ofContainer.dataPresent) {
            int n4 = ofContainer.getContainerCount();
            stringArray = new String[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                try {
                    ASN1Container aSN1Container = ofContainer.containerAt(i2);
                    UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
                    ASN1Container[] aSN1ContainerArray = new ASN1Container[]{uTF8StringContainer};
                    ASN1.berDecode(aSN1Container.data, aSN1Container.dataOffset, aSN1ContainerArray);
                    if (uTF8StringContainer.dataPresent && uTF8StringContainer.dataLen != 0) {
                        stringArray[i2] = new String(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                        continue;
                    }
                    stringArray[i2] = null;
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    throw new CMPException("CMPErrorMessage$ErrorMsgContent.ErrorMsgContent: unable to extract and decode an errorDetails(" + aSN_Exception.getMessage() + ").");
                }
            }
        }
        return new CMPErrorMessage(pKIHeader, (PKIStatusInfo)object, bl2, n3, stringArray);
    }

    public boolean errorCodePresent() {
        return this.a;
    }

    public int getErrorCode() throws CMPException {
        if (!this.a) {
            throw new CMPException("CMPErrorMessage.getErrorCode: error code not returned.");
        }
        return this.b;
    }

    public String[] getErrorDetails() {
        return this.c;
    }
}

