/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.crmf;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.AlgorithmID;
import com.rsa.asn1.BitStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import com.rsa.certj.crmf.CRMFException;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MAC;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecretKey;
import java.io.Serializable;

public class POPOSigningKeyInput
implements Cloneable,
Serializable {
    private ASN1Template a = null;
    private byte[] b = null;
    private int c = 0;
    private GeneralName d = null;
    private byte[] e;
    private byte[] f = null;
    private char[] g = null;
    byte[] h = new byte[]{42, -122, 72, -122, -10, 125, 7, 66, 13};
    byte[] i = new byte[]{43, 6, 1, 5, 5, 8, 1, 2};

    public POPOSigningKeyInput() {
    }

    public POPOSigningKeyInput(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("POPOSigningKeyInput Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0x810000);
        ChoiceContainer choiceContainer = new ChoiceContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(0xA0FF00);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        EncodedContainer encodedContainer3 = new EncodedContainer(12288);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, choiceContainer, encodedContainer, encodedContainer2, endContainer, encodedContainer3, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("FIRST" + aSN_Exception.getMessage());
        }
        try {
            if (encodedContainer.dataPresent) {
                this.d = new GeneralName(encodedContainer.data, encodedContainer.dataOffset, 0xA00000);
            }
        }
        catch (NameException nameException) {
            throw new CRMFException("NAME " + nameException.getMessage());
        }
        if (encodedContainer2.dataPresent) {
            this.a(encodedContainer2.data, encodedContainer2.dataOffset);
        }
        this.setSubjectPublicKey(encodedContainer3.data, encodedContainer3.dataOffset);
    }

    private void a(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("PKMACValue Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        BitStringContainer bitStringContainer = new BitStringContainer(0);
        EndContainer endContainer = new EndContainer();
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, encodedContainer, bitStringContainer, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the PKMACValue." + aSN_Exception.getMessage());
        }
        this.b(encodedContainer.data, encodedContainer.dataOffset);
        this.f = new byte[bitStringContainer.dataLen];
        System.arraycopy(bitStringContainer.data, bitStringContainer.dataOffset, this.f, 0, bitStringContainer.dataLen);
    }

    public boolean verifyPKMACValue() throws CRMFException {
        if (this.g == null) {
            throw new CRMFException("Secret value is not set in POPOSigningKeyInput.");
        }
        if (this.e == null) {
            throw new CRMFException("Public Key is not set in POPOSigningKeyInput.");
        }
        try {
            String string = "PBE/HMAC/SHA1/PKIXPBE-" + this.c;
            JSAFE_MAC jSAFE_MAC = JSAFE_MAC.getInstance(string, "Java");
            jSAFE_MAC.setSalt(this.b, 0, this.b.length);
            JSAFE_SecretKey jSAFE_SecretKey = jSAFE_MAC.getBlankKey();
            jSAFE_SecretKey.setPassword(this.g, 0, this.g.length);
            jSAFE_MAC.verifyInit(jSAFE_SecretKey, null);
            jSAFE_MAC.verifyUpdate(this.e, 0, this.e.length);
            boolean bl2 = jSAFE_MAC.verifyFinal(this.f, 0, this.f.length);
            return bl2;
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException(jSAFE_Exception.getMessage());
        }
    }

    private void b(byte[] byArray, int n2) throws CRMFException {
        Object object;
        if (byArray == null) {
            throw new CRMFException("Password-Based MAC algorithm ID Encoding is null.");
        }
        SequenceContainer sequenceContainer = new SequenceContainer(0);
        EndContainer endContainer = new EndContainer();
        EncodedContainer encodedContainer = new EncodedContainer(12288);
        OIDContainer oIDContainer = new OIDContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{sequenceContainer, oIDContainer, encodedContainer, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the PKMAC algID." + aSN_Exception.getMessage());
        }
        if (this.h.length != oIDContainer.dataLen) {
            throw new CRMFException("Wrong OID for Password-Based MAC.");
        }
        for (int i2 = 0; i2 < oIDContainer.dataLen; ++i2) {
            if (this.h[i2] == oIDContainer.data[i2 + oIDContainer.dataOffset]) continue;
            throw new CRMFException("Wrong OID for Password-Based MAC.");
        }
        SequenceContainer sequenceContainer2 = new SequenceContainer(0);
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        EncodedContainer encodedContainer2 = new EncodedContainer(12288);
        IntegerContainer integerContainer = new IntegerContainer(0);
        EncodedContainer encodedContainer3 = new EncodedContainer(12288);
        ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer2, octetStringContainer, encodedContainer2, integerContainer, encodedContainer3, endContainer};
        try {
            ASN1.berDecode(encodedContainer.data, encodedContainer.dataOffset, aSN1ContainerArray2);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
        this.b = new byte[octetStringContainer.dataLen];
        System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.b, 0, octetStringContainer.dataLen);
        try {
            this.c = integerContainer.getValueAsInt();
            object = AlgorithmID.berDecodeAlgID(encodedContainer2.data, encodedContainer2.dataOffset, 10, null);
            if (object == null) {
                throw new CRMFException("Cannot recognize the digest algorithm.");
            }
            if (!((String)object).equals("SHA1")) {
                throw new CRMFException("Digest algorithm SHA1 was expected.");
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException(aSN_Exception.getMessage());
        }
        try {
            object = new SequenceContainer(0);
            EncodedContainer encodedContainer4 = new EncodedContainer(65280);
            OIDContainer oIDContainer2 = new OIDContainer(0);
            ASN1Container[] aSN1ContainerArray3 = new ASN1Container[]{object, oIDContainer2, encodedContainer4, endContainer};
            ASN1.berDecode(encodedContainer3.data, encodedContainer3.dataOffset, aSN1ContainerArray3);
            if (oIDContainer2.dataLen != this.i.length) {
                throw new CRMFException("Wrong HMAC OID.");
            }
            for (int i3 = 0; i3 < this.i.length; ++i3) {
                if (oIDContainer2.data[i3 + oIDContainer2.dataOffset] == this.i[i3]) continue;
                throw new CRMFException("Wrong HMAC OID.");
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not BER decode the HMAC algID." + aSN_Exception.getMessage());
        }
    }

    public void setSharedSecret(char[] cArray, int n2, int n3) throws CRMFException {
        if (cArray == null || n3 == 0) {
            throw new CRMFException("Shared secret is null in PBMParameter.");
        }
        this.g = new char[cArray.length];
        System.arraycopy(cArray, n2, this.g, 0, n3);
    }

    public void setSalt(byte[] byArray, int n2, int n3) throws CRMFException {
        if (byArray == null || n3 == 0) {
            throw new CRMFException("The Salt value is null in PBMParameter.");
        }
        this.b = new byte[n3];
        System.arraycopy(byArray, n2, this.b, 0, n3);
    }

    public byte[] getSalt() {
        if (this.b == null) {
            return null;
        }
        byte[] byArray = new byte[this.b.length];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        return byArray;
    }

    public int getIterationCount() {
        return this.c;
    }

    public void setIterationCount(int n2) {
        this.c = n2;
    }

    public GeneralName getSenderName() throws CRMFException {
        if (this.d == null) {
            return null;
        }
        try {
            return (GeneralName)this.d.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException(cloneNotSupportedException.getMessage());
        }
    }

    public void setSenderName(GeneralName generalName) throws CRMFException {
        if (generalName == null) {
            throw new CRMFException("Passed in SenderName is null.");
        }
        try {
            this.d = (GeneralName)generalName.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CRMFException(cloneNotSupportedException.getMessage());
        }
    }

    public void setSubjectPublicKey(JSAFE_PublicKey jSAFE_PublicKey) throws CRMFException {
        if (jSAFE_PublicKey == null) {
            throw new CRMFException("Public key is null in POPOSigningKeyInput.");
        }
        try {
            String string = null;
            string = jSAFE_PublicKey.getAlgorithm().compareTo("DSA") == 0 ? "DSAPublicKeyX957BER" : jSAFE_PublicKey.getAlgorithm() + "PublicKeyBER";
            byte[][] byArray = jSAFE_PublicKey.getKeyData(string);
            this.e = byArray[0];
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not read the public key in POPOSigningKeyInput. " + jSAFE_Exception.getMessage());
        }
    }

    public void setSubjectPublicKey(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Public key encoding is null in POPOSigningKeyInput.");
        }
        JSAFE_PublicKey jSAFE_PublicKey = null;
        try {
            byArray[n2] = 48;
            jSAFE_PublicKey = JSAFE_PublicKey.getInstance(byArray, n2, "Java");
            this.setSubjectPublicKey(jSAFE_PublicKey);
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Could not read the public key in POPOSigningKeyInput. " + jSAFE_Exception.getMessage());
        }
        finally {
            if (jSAFE_PublicKey != null) {
                jSAFE_PublicKey.clearSensitiveData();
            }
        }
    }

    public JSAFE_PublicKey getSubjectPublicKey() throws CRMFException {
        if (this.e == null) {
            return null;
        }
        try {
            return JSAFE_PublicKey.getInstance(this.e, 0, "Java");
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException("Cannot retrieve the public key in POPOSigningKeyInput: " + jSAFE_Exception.getMessage());
        }
    }

    public byte[] getSubjectPublicKeyBER() {
        if (this.e == null) {
            return null;
        }
        return (byte[])this.e.clone();
    }

    public byte[] getPKMACValue() {
        if (this.f == null) {
            return null;
        }
        byte[] byArray = new byte[this.f.length];
        System.arraycopy(this.f, 0, byArray, 0, this.f.length);
        return byArray;
    }

    private void a() throws CRMFException {
        if (this.g == null) {
            throw new CRMFException("Shared Secret is not set in PKMAC value.");
        }
        if (this.b == null) {
            throw new CRMFException("Salt value is not set in PKMAC value.");
        }
        if (this.e == null) {
            throw new CRMFException("Public Key is not set in PKMAC value.");
        }
        if (this.c == 0) {
            throw new CRMFException("Iteration count is not set in PKMAC value.");
        }
        try {
            String string = "PBE/HMAC/SHA1/PKIXPBE-" + this.c;
            JSAFE_MAC jSAFE_MAC = JSAFE_MAC.getInstance(string, "Java");
            jSAFE_MAC.setSalt(this.b, 0, this.b.length);
            JSAFE_SecretKey jSAFE_SecretKey = jSAFE_MAC.getBlankKey();
            jSAFE_SecretKey.setPassword(this.g, 0, this.g.length);
            jSAFE_MAC.macInit(jSAFE_SecretKey, null);
            jSAFE_MAC.macUpdate(this.e, 0, this.e.length);
            this.f = jSAFE_MAC.macFinal();
            jSAFE_MAC.clearSensitiveData();
        }
        catch (JSAFE_Exception jSAFE_Exception) {
            throw new CRMFException(jSAFE_Exception.getMessage());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        POPOSigningKeyInput pOPOSigningKeyInput = new POPOSigningKeyInput();
        pOPOSigningKeyInput.c = this.c;
        if (this.b != null) {
            pOPOSigningKeyInput.b = new byte[this.b.length];
            System.arraycopy(this.b, 0, pOPOSigningKeyInput.b, 0, this.b.length);
        }
        if (this.d != null) {
            pOPOSigningKeyInput.d = (GeneralName)this.d.clone();
        }
        if (this.e != null) {
            pOPOSigningKeyInput.e = new byte[this.e.length];
            System.arraycopy(this.e, 0, pOPOSigningKeyInput.e, 0, this.e.length);
        }
        if (this.f != null) {
            pOPOSigningKeyInput.f = new byte[this.f.length];
            System.arraycopy(this.f, 0, pOPOSigningKeyInput.f, 0, this.f.length);
        }
        if (this.g != null) {
            pOPOSigningKeyInput.g = new char[this.g.length];
            System.arraycopy(this.g, 0, pOPOSigningKeyInput.g, 0, this.g.length);
        }
        try {
            if (this.a != null) {
                pOPOSigningKeyInput.b();
            }
        }
        catch (CRMFException cRMFException) {
            throw new CloneNotSupportedException(cRMFException.getMessage());
        }
        return pOPOSigningKeyInput;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof POPOSigningKeyInput)) {
            return false;
        }
        POPOSigningKeyInput pOPOSigningKeyInput = (POPOSigningKeyInput)object;
        try {
            int n2 = this.getDERLen();
            int n3 = pOPOSigningKeyInput.getDERLen();
            if (n2 != n3) {
                return false;
            }
            if (n2 == 0 || n3 == 0) {
                return false;
            }
            byte[] byArray = new byte[n2];
            byte[] byArray2 = new byte[n3];
            n2 = this.getDEREncoding(byArray, 0);
            if (n2 != (n3 = pOPOSigningKeyInput.getDEREncoding(byArray2, 0))) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
        }
        catch (CRMFException cRMFException) {
            return false;
        }
        return true;
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("POPOSigningKeyInput Encoding is null.");
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Could not read the BER encoding." + aSN_Exception.getMessage());
        }
    }

    public int getDERLen() throws CRMFException {
        return this.b();
    }

    public int getDEREncoding(byte[] byArray, int n2) throws CRMFException {
        if (byArray == null) {
            throw new CRMFException("Specified POPOSigningKeyInput array is null.");
        }
        int n3 = 0;
        try {
            if (this.a == null) {
                this.getDERLen();
            }
            n3 = this.a.derEncode(byArray, n2);
            this.a = null;
        }
        catch (ASN_Exception aSN_Exception) {
            this.a = null;
            throw new CRMFException("Unable to encode POPOSigningKeyInput." + aSN_Exception.getMessage());
        }
        return n3;
    }

    private int b() throws CRMFException {
        try {
            Object object;
            ASN1Container aSN1Container;
            EncodedContainer encodedContainer;
            ASN1Container aSN1Container2;
            ASN1Container aSN1Container3;
            Object object2;
            Object object3;
            boolean bl2 = true;
            boolean bl3 = true;
            byte[] byArray = null;
            int n2 = 0;
            byte[] byArray2 = null;
            int n3 = 0;
            if (this.e == null) {
                throw new CRMFException("Public key is not set.");
            }
            if (this.d != null) {
                bl3 = false;
                n2 = this.d.getDERLen(0xA00000);
                byArray = new byte[n2];
                n2 = this.d.getDEREncoding(byArray, 0, 0xA00000);
            } else {
                bl2 = false;
                if (this.f == null) {
                    this.a();
                }
                object3 = new byte[this.i.length + 6];
                object3[0] = 48;
                object3[1] = (byte)(this.i.length + 4);
                object3[2] = 6;
                object3[3] = (byte)this.i.length;
                System.arraycopy(this.i, 0, object3, 4, this.i.length);
                object3[this.i.length + 4] = 5;
                object3[this.i.length + 5] = 0;
                object2 = AlgorithmID.derEncodeAlgID("SHA1", 10, null, 0, 0);
                aSN1Container3 = new SequenceContainer(0, true, 0);
                aSN1Container2 = new OctetStringContainer(0, true, 0, this.b, 0, this.b.length);
                encodedContainer = new EncodedContainer(12288, true, 0, (byte[])object2, 0, ((Object)object2).length);
                aSN1Container = new IntegerContainer(0, true, 0, this.c);
                object = new EncodedContainer(12288, true, 0, (byte[])object3, 0, ((byte[])object3).length);
                EndContainer endContainer = new EndContainer();
                ASN1Container[] aSN1ContainerArray = new ASN1Container[]{aSN1Container3, aSN1Container2, encodedContainer, aSN1Container, object, endContainer};
                ASN1Template aSN1Template = new ASN1Template(aSN1ContainerArray);
                int n4 = aSN1Template.derEncodeInit();
                byte[] byArray3 = new byte[n4];
                n4 = aSN1Template.derEncode(byArray3, 0);
                byte[] byArray4 = new byte[this.h.length + n4 + 4];
                byArray4[0] = 48;
                byArray4[1] = (byte)(this.h.length + n4 + 2);
                byArray4[2] = 6;
                byArray4[3] = (byte)this.h.length;
                System.arraycopy(this.h, 0, byArray4, 4, this.h.length);
                System.arraycopy(byArray3, 0, byArray4, this.h.length + 4, byArray3.length);
                SequenceContainer sequenceContainer = new SequenceContainer(0, true, 0);
                EncodedContainer encodedContainer2 = new EncodedContainer(12288, true, 0, byArray4, 0, byArray4.length);
                BitStringContainer bitStringContainer = new BitStringContainer(0, true, 0, this.f, 0, this.f.length);
                ASN1Container[] aSN1ContainerArray2 = new ASN1Container[]{sequenceContainer, encodedContainer2, bitStringContainer, endContainer};
                ASN1Template aSN1Template2 = new ASN1Template(aSN1ContainerArray2);
                n3 = aSN1Template2.derEncodeInit();
                byArray2 = new byte[n3];
                n3 = aSN1Template2.derEncode(byArray2, 0);
            }
            object3 = new SequenceContainer(0x810000, true, 0);
            object2 = new EndContainer();
            aSN1Container3 = new ChoiceContainer(0, 0);
            aSN1Container2 = new EncodedContainer(0xA00000, bl2, 0, byArray, 0, n2);
            encodedContainer = new EncodedContainer(12288, bl3, 0, byArray2, 0, n3);
            aSN1Container = new EncodedContainer(12288, true, 0, this.e, 0, this.e.length);
            object = new ASN1Container[]{object3, aSN1Container3, aSN1Container2, encodedContainer, object2, aSN1Container, object2};
            this.a = new ASN1Template((ASN1Container[])object);
            return this.a.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            throw new CRMFException("Unable to encode POPOSigningKeyInput." + aSN_Exception.getMessage());
        }
        catch (NameException nameException) {
            throw new CRMFException("Unable to encode POPOSigningKeyInput." + nameException.getMessage());
        }
    }
}

