/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.extensions;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.OfContainer;
import com.rsa.certj.cert.NameException;
import com.rsa.certj.cert.extensions.GeneralName;
import java.io.Serializable;
import java.util.Vector;

public class GeneralNames
implements Cloneable,
Serializable {
    private Vector a = new Vector();
    protected static int special;
    private ASN1Template b = null;

    public GeneralNames(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        try {
            OfContainer ofContainer = new OfContainer(n3, 12288, new EncodedContainer(65280));
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{ofContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            int n4 = ofContainer.getContainerCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                ASN1Container aSN1Container = ofContainer.containerAt(i2);
                GeneralName generalName = new GeneralName(aSN1Container.data, aSN1Container.dataOffset, 0);
                this.a.addElement(generalName);
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Cannot decode the BER of the name.");
        }
        catch (NameException nameException) {
            throw new NameException("Cannot decode the BER of the name.");
        }
    }

    public GeneralNames() {
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.a.addElement(generalName);
        }
    }

    public Vector getGeneralNames() {
        return this.a;
    }

    public GeneralName getGeneralName(int n2) throws NameException {
        if (n2 < this.a.size()) {
            return (GeneralName)this.a.elementAt(n2);
        }
        throw new NameException("Invalid index.");
    }

    public void removeGeneralName(int n2) throws NameException {
        if (n2 >= this.a.size()) {
            throw new NameException("Invalid Index.");
        }
        this.a.removeElementAt(n2);
    }

    public void addGeneralName(GeneralName generalName, int n2) throws NameException {
        if (generalName == null) {
            throw new NameException("Specified name is null.");
        }
        if (n2 >= this.a.size()) {
            throw new NameException("Invalid index.");
        }
        this.a.setElementAt(generalName, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            string = ((GeneralName)this.a.elementAt(i2)).toString();
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public int getNameCount() {
        return this.a.size();
    }

    public static int getNextBEROffset(byte[] byArray, int n2) throws NameException {
        if (byArray == null) {
            throw new NameException("Encoding is null.");
        }
        if (byArray[n2] == 0 && byArray[n2 + 1] == 0) {
            return n2 + 2;
        }
        try {
            return n2 + 1 + ASN1Lengths.determineLengthLen(byArray, n2 + 1) + ASN1Lengths.determineLength(byArray, n2 + 1);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new NameException("Unable to determine length of the BER");
        }
    }

    public int getDERLen(int n2) throws NameException {
        special = n2;
        return this.a();
    }

    public int getDEREncoding(byte[] byArray, int n2, int n3) throws NameException {
        if (byArray == null) {
            throw new NameException("Specified array is null.");
        }
        try {
            int n4;
            block8: {
                block7: {
                    if (this.b == null) break block7;
                    if (n3 == special) break block8;
                }
                if ((n4 = this.getDERLen(n3)) == 0) {
                    throw new NameException("Cannot encode GeneralNames.");
                }
            }
            n4 = this.b.derEncode(byArray, n2);
            this.b = null;
            return n4;
        }
        catch (ASN_Exception aSN_Exception) {
            this.b = null;
            throw new NameException("Unable to encode GeneralNames.");
        }
    }

    private int a() {
        Vector<OfContainer> vector = new Vector<OfContainer>();
        try {
            OfContainer ofContainer = new OfContainer(special, true, 0, 12288, new EncodedContainer(65280));
            vector.addElement(ofContainer);
            EncodedContainer encodedContainer = null;
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                try {
                    GeneralName generalName = (GeneralName)this.a.elementAt(i2);
                    int n2 = generalName.getDERLen(0);
                    byte[] byArray = new byte[n2];
                    n2 = generalName.getDEREncoding(byArray, 0, 0);
                    encodedContainer = new EncodedContainer(0, true, 0, byArray, 0, n2);
                    ofContainer.addContainer(encodedContainer);
                    continue;
                }
                catch (ASN_Exception aSN_Exception) {
                    return 0;
                }
                catch (NameException nameException) {
                    return 0;
                }
            }
            Object[] objectArray = new ASN1Container[vector.size()];
            vector.copyInto(objectArray);
            this.b = new ASN1Template((ASN1Container[])objectArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    public boolean equals(Object object) {
        int n2;
        if (object == null || !(object instanceof GeneralNames)) {
            return false;
        }
        GeneralNames generalNames = (GeneralNames)object;
        int n3 = this.a.size();
        if (n3 != (n2 = generalNames.a.size())) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.a.elementAt(i2).equals(generalNames.a.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(GeneralName generalName) {
        if (generalName == null) {
            return false;
        }
        try {
            for (int i2 = 0; i2 < this.getNameCount(); ++i2) {
                if (!generalName.equals(this.getGeneralName(i2))) continue;
                return true;
            }
            return false;
        }
        catch (NameException nameException) {
            return false;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralNames generalNames = new GeneralNames();
        generalNames.a = (Vector)this.a.clone();
        if (this.b != null) {
            generalNames.a();
        }
        return generalNames;
    }
}

