/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

public class LocalKeyID
extends X501Attribute
implements Cloneable,
Serializable {
    private byte[] a;
    ASN1Template b;

    public LocalKeyID() {
        super(4, "LocalKeyID");
    }

    public LocalKeyID(byte[] byArray, int n2, int n3) {
        this();
        this.setLocalKeyID(byArray, n2, n3);
    }

    protected void decodeValue(byte[] byArray, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        SetContainer setContainer = new SetContainer(0);
        EndContainer endContainer = new EndContainer();
        OctetStringContainer octetStringContainer = new OctetStringContainer(0);
        ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, octetStringContainer, endContainer};
        try {
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not BER decode LocalKeyID.");
        }
        this.a = new byte[octetStringContainer.dataLen];
        System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, this.a, 0, octetStringContainer.dataLen);
    }

    public byte[] getLocalKeyID() {
        if (this.a == null) {
            return null;
        }
        byte[] byArray = new byte[this.a.length];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        return byArray;
    }

    public void setLocalKeyID(byte[] byArray, int n2, int n3) {
        if (byArray != null && n3 != 0) {
            this.a = new byte[n3];
            System.arraycopy(byArray, n2, this.a, 0, n3);
        }
    }

    protected int derEncodeValueInit() {
        this.b = null;
        if (this.a == null) {
            return 0;
        }
        try {
            EndContainer endContainer = new EndContainer();
            SetContainer setContainer = new SetContainer(0, true, 0);
            OctetStringContainer octetStringContainer = new OctetStringContainer(0, true, 0, this.a, 0, this.a.length);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, octetStringContainer, endContainer};
            this.b = new ASN1Template(aSN1ContainerArray);
            return this.b.derEncodeInit();
        }
        catch (ASN_Exception aSN_Exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.b == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.b.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        LocalKeyID localKeyID = new LocalKeyID();
        if (this.a != null) {
            localKeyID.a = (byte[])this.a.clone();
        }
        super.copyValues(localKeyID);
        return localKeyID;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LocalKeyID)) {
            return false;
        }
        LocalKeyID localKeyID = (LocalKeyID)object;
        return CertJUtils.byteArraysEqual(localKeyID.a, this.a);
    }

    protected void reset() {
        super.reset();
        this.b = null;
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = 0;
            }
            this.a = null;
        }
    }
}

