/*
 * Decompiled with CFR 0.152.
 */
package com.rsa.certj.cert.attributes;

import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.BMPStringContainer;
import com.rsa.asn1.ChoiceContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IA5StringContainer;
import com.rsa.asn1.PrintStringContainer;
import com.rsa.asn1.SetContainer;
import com.rsa.asn1.TeletexStringContainer;
import com.rsa.asn1.UTF8StringContainer;
import com.rsa.asn1.UniversalStringContainer;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.attributes.X501Attribute;
import java.io.Serializable;

public class ChallengePassword
extends X501Attribute
implements Cloneable,
Serializable {
    private char[] a;
    private int b;
    ASN1Template c;

    public ChallengePassword() {
        super(1, "ChallengePassword");
    }

    public ChallengePassword(char[] cArray, int n2, int n3, int n4) throws AttributeException {
        this();
        this.setChallengePassword(cArray, n2, n3, n4);
    }

    protected void decodeValue(byte[] byArray, int n2) throws AttributeException {
        if (byArray == null) {
            throw new AttributeException("Encoding is null.");
        }
        this.reset();
        SetContainer setContainer = new SetContainer(0);
        EndContainer endContainer = new EndContainer();
        ChoiceContainer choiceContainer = new ChoiceContainer(0);
        try {
            PrintStringContainer printStringContainer = new PrintStringContainer(0);
            TeletexStringContainer teletexStringContainer = new TeletexStringContainer(0);
            UniversalStringContainer universalStringContainer = new UniversalStringContainer(0);
            BMPStringContainer bMPStringContainer = new BMPStringContainer(0);
            UTF8StringContainer uTF8StringContainer = new UTF8StringContainer(0);
            IA5StringContainer iA5StringContainer = new IA5StringContainer(0);
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, choiceContainer, printStringContainer, teletexStringContainer, universalStringContainer, bMPStringContainer, uTF8StringContainer, iA5StringContainer, endContainer, endContainer};
            ASN1.berDecode(byArray, n2, aSN1ContainerArray);
            if (printStringContainer.dataPresent) {
                this.b = 4864;
                this.a = printStringContainer.getValueAsString().toCharArray();
            } else if (teletexStringContainer.dataPresent) {
                this.b = 5120;
                this.a = teletexStringContainer.getValueAsString().toCharArray();
            } else if (universalStringContainer.dataPresent) {
                this.b = 7168;
                this.a = universalStringContainer.getValueAsString().toCharArray();
            } else if (bMPStringContainer.dataPresent) {
                this.b = 7680;
                this.a = bMPStringContainer.getValueAsString().toCharArray();
            } else if (uTF8StringContainer.dataPresent) {
                this.b = 3072;
                String string = this.utf8Decode(uTF8StringContainer.data, uTF8StringContainer.dataOffset, uTF8StringContainer.dataLen);
                this.a = string.toCharArray();
            } else if (iA5StringContainer.dataPresent) {
                this.b = 5632;
                this.a = iA5StringContainer.getValueAsString().toCharArray();
            }
        }
        catch (ASN_Exception aSN_Exception) {
            throw new AttributeException("Could not BER decode ChallengePassword.");
        }
    }

    public void setChallengePassword(char[] cArray, int n2, int n3, int n4) throws AttributeException {
        if (cArray == null || n3 == 0) {
            throw new AttributeException("Password is null.");
        }
        this.a = new char[n3];
        System.arraycopy(cArray, n2, this.a, 0, n3);
        if (n4 != 4864 && n4 != 5120 && n4 != 7168 && n4 != 3072 && n4 != 7680 && n4 != 5632) {
            throw new AttributeException("Invalid String Type.");
        }
        this.b = n4;
    }

    public char[] getChallengePassword() {
        if (this.a == null) {
            return null;
        }
        char[] cArray = new char[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            cArray[i2] = (char)(this.a[i2] & 0xFF);
        }
        return cArray;
    }

    protected int derEncodeValueInit() {
        this.c = null;
        if (this.a == null) {
            return 0;
        }
        if (this.b == 0) {
            this.b = 3072;
        }
        try {
            EndContainer endContainer = new EndContainer();
            SetContainer setContainer = new SetContainer(0, true, 0);
            ChoiceContainer choiceContainer = new ChoiceContainer(0, 0);
            ASN1Container aSN1Container = null;
            byte[] byArray = new byte[this.a.length];
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                byArray[i2] = (byte)this.a[i2];
            }
            switch (this.b) {
                case 5120: {
                    aSN1Container = new TeletexStringContainer(0, true, 0, byArray, 0, byArray.length);
                    break;
                }
                case 4864: {
                    aSN1Container = new PrintStringContainer(0, true, 0, byArray, 0, byArray.length);
                    break;
                }
                case 7168: {
                    aSN1Container = new UniversalStringContainer(0, true, 0, byArray, 0, byArray.length, 1);
                    break;
                }
                case 5632: {
                    aSN1Container = new IA5StringContainer(0, true, 0, byArray, 0, byArray.length);
                    break;
                }
                case 3072: {
                    byte[] byArray2 = this.utf8Encode(new String(byArray));
                    if (byArray2.length < 2) {
                        return 0;
                    }
                    aSN1Container = new UTF8StringContainer(0, true, 0, byArray2, 2, byArray2.length - 2);
                    break;
                }
                case 7680: {
                    aSN1Container = new BMPStringContainer(0, true, 0, byArray, 0, byArray.length, 1);
                    break;
                }
                default: {
                    return 0;
                }
            }
            ASN1Container[] aSN1ContainerArray = new ASN1Container[]{setContainer, choiceContainer, aSN1Container, endContainer, endContainer};
            this.c = new ASN1Template(aSN1ContainerArray);
            return this.c.derEncodeInit();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    protected int derEncodeValue(byte[] byArray, int n2) {
        if (byArray == null) {
            return 0;
        }
        if (this.c == null && this.derEncodeValueInit() == 0) {
            return 0;
        }
        int n3 = 0;
        try {
            n3 = this.c.derEncode(byArray, n2);
            this.asn1Template = null;
            return n3;
        }
        catch (ASN_Exception aSN_Exception) {
            this.asn1Template = null;
            return 0;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ChallengePassword challengePassword = new ChallengePassword();
        if (this.a != null) {
            challengePassword.a = (char[])this.a.clone();
        }
        challengePassword.b = this.b;
        super.copyValues(challengePassword);
        return challengePassword;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == null || !(object instanceof ChallengePassword)) {
            return false;
        }
        ChallengePassword challengePassword = (ChallengePassword)object;
        if (this.a != null) {
            if (challengePassword.a == null) return false;
            if (this.a.length != challengePassword.a.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                if (this.a[i2] == challengePassword.a[i2]) continue;
                return false;
            }
            return true;
        } else {
            if (challengePassword.a == null) return true;
            return false;
        }
    }

    protected void reset() {
        super.reset();
        this.c = null;
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                this.a[i2] = '\u0000';
            }
            this.a = null;
        }
    }

    protected void finalize() {
        this.reset();
    }
}

