/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.validator;

import com.adobe.air.Listener;
import com.adobe.air.Message;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DescriptorValidator
extends DefaultHandler {
    private static final String FILENAME_PATTERN = "[^\\*\"/:<>\\?\\\\|\\. ]|[^\\*\"/:<>\\?\\\\| ][^\\*\"/:<>\\?\\\\|]*[^\\*\"/:<>\\?\\\\|\\. ]";
    private static final String APP_ID_PATTERN = "[A-Za-z0-9\\-\\.]{1,212}";
    private static final String PUB_ID_PATTERN = "[A-Fa-f0-9]{40}\\.1";
    private static final String FOLDER_TYPE_PATTERN = "[^\\*\"/:<>\\?\\\\|\\. ]|[^\\*\"/:<>\\?\\\\| ][^\\*\":<>\\?\\\\|]*[^\\*\":<>\\?\\\\|\\./ ]";
    private static final String FILE_TYPE_NAME_PATTERN = "[A-Za-z][A-Za-z0-9\\.]{0,38}";
    private static final String EXTENSION_PATTERN = "[A-Za-z0-9]{1,38}";
    private static final String LANGUAGE_PATTERN = "[A-Za-z]{2,3}([\\-\\_][A-Za-z]{4})?([\\-\\_]([A-Za-z]{2}|[0-9]{3}))?";
    protected static final String SYSTEM_CHROME_NONE = "none";
    protected static final String SYSTEM_CHROME_STANDARD = "standard";
    private static final String VERSION_NUMBER_PATTERN = "[0-9]{1,3}(\\.[0-9]{1,3}){0,2}";
    protected static final int CHUNK_HEADER_LENGTH = 8;
    protected static final int IHDR_HEADER = 1229472850;
    protected static final int IHDR_HEADER_SIZE = 13;
    protected static final int CGBI_HEADER = 1130840649;
    protected static final byte[] PNG_SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    protected static final int IHDR_WIDTH_FIELD_OFFSET = 0;
    protected static final int IHDR_HEIGHT_FIELD_OFFSET = 4;
    private Listener _listener;
    private Locator _locator;
    private String _descriptorName;
    private boolean _hasRootElement = false;
    private boolean _inErrorState = false;
    private int _errorElementLevel;
    private ElementInfo _currentElementInfo;
    private StringBuffer _content = new StringBuffer();

    private String getElementPath() {
        StringBuffer pathBuffer = new StringBuffer();
        ElementInfo elementInfo = this._currentElementInfo;
        while (elementInfo != null) {
            pathBuffer.insert(0, elementInfo.name);
            if ((elementInfo = elementInfo.parent) == null) continue;
            pathBuffer.insert(0, ".");
        }
        return pathBuffer.toString();
    }

    protected static int bytesToInt(byte[] bytes, int offset) {
        int value = bytes[offset];
        value = (value << 8) + (bytes[offset + 1] & 0xFF);
        value = (value << 8) + (bytes[offset + 2] & 0xFF);
        value = (value << 8) + (bytes[offset + 3] & 0xFF);
        return value;
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (!this._inErrorState) {
            this._content.append(ch, start, length);
            String newContent = new String(ch, start, length).trim();
            if (newContent.length() != 0) {
                if (this._currentElementInfo.contentTypeMixed) {
                    Collection<ElementInfo> allowableElements = this._currentElementInfo.getChildren();
                    for (ElementInfo nodeInfo : allowableElements) {
                        if (nodeInfo.count <= 0) continue;
                        this.dispatchError(105, new String[]{this.getElementPath()});
                    }
                } else if (this._currentElementInfo.hasChildren()) {
                    String elementPath = this.getElementPath();
                    if (elementPath.equals("application.android.manifestAdditions.manifest") || elementPath.equals("application.android.manifestAdditions.application") || elementPath.equals("application.android.manifestAdditions.launcherActivity")) {
                        this.dispatchError(104, new String[]{"Enclosing CDATA block of " + elementPath + " within <data></data> tag"});
                    } else {
                        this.dispatchError(105, new String[]{this.getElementPath()});
                    }
                }
            }
        }
    }

    public final void endDocument() throws SAXException {
        if (!this._hasRootElement) {
            this.dispatchError(104, new String[]{this.getRootElementInfo().name});
        }
        this.finalizeValidation();
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        --this._errorElementLevel;
        if (!this._inErrorState) {
            String elementPath = this.getElementPath();
            String elementValue = this._content.toString();
            if ((!this._currentElementInfo.hasChildren() || this._currentElementInfo.contentTypeMixed || this._currentElementInfo.validationRequired()) && !this.validateElement(elementPath, elementValue)) {
                this.dispatchError(105, new String[]{elementPath});
            }
            Collection<ElementInfo> allowableElements = this._currentElementInfo.getChildren();
            for (ElementInfo elementInfo : allowableElements) {
                if (elementInfo.count >= elementInfo.minOccurs) continue;
                this.dispatchError(104, new String[]{elementPath + "." + elementInfo.name});
            }
            this._content.setLength(0);
            this._currentElementInfo = this._currentElementInfo.parent;
        }
        if (this._inErrorState && this._errorElementLevel == 0) {
            this._inErrorState = false;
        }
    }

    public final void setDocumentLocator(Locator locator) {
        this._locator = locator;
    }

    public final void setDescriptorName(String name) {
        this._descriptorName = name;
    }

    public final void setListener(Listener listener) {
        this._listener = listener;
    }

    public boolean migrationGracePeriodInEffect() {
        return false;
    }

    public boolean usePackageSignatureForTimestamps() {
        return false;
    }

    public final void startDocument() throws SAXException {
    }

    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String elementPath = null;
        if (!this._inErrorState) {
            elementPath = this.getElementPath();
            if (this._currentElementInfo == null) {
                ElementInfo rootElementInfo = this.getRootElementInfo();
                if (!rootElementInfo.name.equals(localName)) {
                    this.dispatchError(103, new String[]{localName});
                    this._inErrorState = true;
                    this._errorElementLevel = 0;
                } else {
                    this._currentElementInfo = rootElementInfo;
                    this._hasRootElement = true;
                }
            } else {
                ElementInfo elementInfo;
                if (this._content.toString().trim().length() > 0) {
                    this.dispatchError(105, new String[]{elementPath});
                }
                if ((elementInfo = this._currentElementInfo.getChild(localName)) != null) {
                    ++elementInfo.count;
                    if (elementInfo.maxOccurs != -1 && elementInfo.count > elementInfo.maxOccurs) {
                        this.dispatchError(103, new String[]{elementPath + "." + localName});
                        this._inErrorState = true;
                        this._errorElementLevel = 0;
                    } else {
                        this._currentElementInfo = elementInfo;
                    }
                } else {
                    this.dispatchError(103, new String[]{elementPath + "." + localName});
                    this._inErrorState = true;
                    this._errorElementLevel = 0;
                }
            }
        }
        if (!this._inErrorState) {
            Collection<AttributeInfo> allowableAttributes = this._currentElementInfo.getAttributes();
            for (AttributeInfo nodeInfo : allowableAttributes) {
                nodeInfo.count = 0;
            }
            elementPath = this.getElementPath();
            for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
                String attributeName = attributes.getQName(i2);
                String attributePath = elementPath + "@" + attributeName;
                AttributeInfo attributeInfo = this._currentElementInfo.getAttribute(attributeName);
                if (attributeInfo != null) {
                    ++attributeInfo.count;
                    if (this.validateAttribute(attributePath, attributes.getValue(i2))) continue;
                    this.dispatchError(105, new String[]{attributePath});
                    continue;
                }
                this.dispatchError(103, new String[]{attributePath});
            }
            for (AttributeInfo attributeInfo : allowableAttributes) {
                if (!attributeInfo.required || attributeInfo.count != 0) continue;
                this.dispatchError(104, new String[]{elementPath + "@" + attributeInfo.name});
            }
            Collection<ElementInfo> allowableElements = this._currentElementInfo.getChildren();
            for (ElementInfo nodeInfo : allowableElements) {
                nodeInfo.count = 0;
            }
            this._content.setLength(0);
        }
        ++this._errorElementLevel;
    }

    protected void dispatchError(int code, String[] identifiers) {
        this._listener.message(new Message(code, "ERROR", this._descriptorName, this._locator.getLineNumber(), this._locator.getColumnNumber(), identifiers));
    }

    protected URI validateUri(String uriString) {
        URI APP_RESOURCE_URI = URI.create("app:/");
        String uriValue = uriString.trim();
        URI uri = null;
        try {
            uri = APP_RESOURCE_URI.resolve(uriValue);
        }
        catch (IllegalArgumentException e2) {
            // empty catch block
        }
        if (uri == null || !uri.getScheme().equals(APP_RESOURCE_URI.getScheme())) {
            this.dispatchError(105, new String[]{this.getElementPath()});
        }
        return uri;
    }

    protected static boolean validateFilename(String name) {
        return name.matches(FILENAME_PATTERN);
    }

    protected static boolean validateAppId(String appId) {
        return appId.matches(APP_ID_PATTERN);
    }

    protected static boolean validatePublisherId(String pubId) {
        return pubId.matches(PUB_ID_PATTERN);
    }

    protected static boolean validateSystemChrome(String systemChrome) {
        return systemChrome.equals(SYSTEM_CHROME_NONE) || systemChrome.equals(SYSTEM_CHROME_STANDARD);
    }

    protected static boolean validateFolderType(String folderValue) {
        return folderValue.matches(FOLDER_TYPE_PATTERN);
    }

    protected static boolean validateFileTypeName(String fileTypeName) {
        return fileTypeName.matches(FILE_TYPE_NAME_PATTERN) && fileTypeName.charAt(fileTypeName.length() - 1) != '.' && fileTypeName.indexOf("..") == -1;
    }

    protected static boolean validateExtension(String extensionValue) {
        return extensionValue.matches(EXTENSION_PATTERN) && !extensionValue.equalsIgnoreCase("air");
    }

    protected static boolean validateEmptyContentType(String emptyContentValue) {
        return emptyContentValue.length() == 0;
    }

    protected static boolean validateBooleanType(String booleanValue) {
        return booleanValue.equals("true") || booleanValue.equals("false") || booleanValue.equals("1") || booleanValue.equals("0");
    }

    protected static boolean evaluateBooleanType(String booleanValue) {
        return booleanValue.equals("true") || booleanValue.equals("1");
    }

    protected static boolean validateUnsignedIntType(String unsignedIntValue) {
        long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
        long value = -1L;
        try {
            value = Long.parseLong(unsignedIntValue);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        return value >= 0L && value <= 0xFFFFFFFFL;
    }

    protected static boolean validateUnsignedIntPairType(String inputString) {
        String[] list = inputString.split("\\s+");
        if (list.length == 2) {
            return DescriptorValidator.validateUnsignedIntType(list[0]) && DescriptorValidator.validateUnsignedIntType(list[1]);
        }
        return false;
    }

    protected static boolean validateSignedIntType(String unsignedIntValue) {
        long MAX_SIGNED_INT = Integer.MAX_VALUE;
        long MIN_SIGNED_INT = Integer.MIN_VALUE;
        long value = Long.MAX_VALUE;
        try {
            value = Long.parseLong(unsignedIntValue);
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        return value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE;
    }

    protected static boolean validateVersionNumber(String versionNumberValue) {
        return versionNumberValue.matches(VERSION_NUMBER_PATTERN);
    }

    protected static boolean validateLanguageType(String langTypeValue) {
        return langTypeValue.matches(LANGUAGE_PATTERN);
    }

    protected abstract ElementInfo getRootElementInfo();

    protected abstract boolean validateAttribute(String var1, String var2) throws SAXException;

    protected abstract boolean validateElement(String var1, String var2) throws SAXException;

    protected abstract void finalizeValidation() throws SAXException;

    protected abstract String getNamespace();

    static final class AttributeInfo
    extends NodeInfo {
        public boolean required;

        public AttributeInfo(String name, boolean required) {
            super(name);
            this.required = required;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ElementInfo
    extends NodeInfo {
        public int minOccurs;
        public int maxOccurs;
        public boolean contentTypeMixed = false;
        public static boolean VALIDATE = true;
        private ElementInfo parent;
        private Map<String, ElementInfo> children = new HashMap<String, ElementInfo>();
        private Map<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();
        private boolean validationRequired = false;

        public ElementInfo(String name, int minOccurs, int maxOccurs) {
            super(name);
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
        }

        public ElementInfo(String name, int minOccurs, int maxOccurs, boolean validationRequired) {
            super(name);
            this.minOccurs = minOccurs;
            this.maxOccurs = maxOccurs;
            this.validationRequired = validationRequired;
        }

        public void addAttribute(AttributeInfo attributeInfo) {
            this.attributes.put(attributeInfo.name, attributeInfo);
        }

        public void addChild(ElementInfo elementInfo) {
            elementInfo.parent = this;
            this.children.put(elementInfo.name, elementInfo);
        }

        public void removeChild(ElementInfo elementInfo) {
            elementInfo.parent = this;
            this.children.remove(elementInfo.name);
        }

        public AttributeInfo getAttribute(String name) {
            return this.attributes.get(name);
        }

        public Collection<AttributeInfo> getAttributes() {
            return Collections.unmodifiableCollection(this.attributes.values());
        }

        public ElementInfo getChild(String name) {
            return this.children.get(name);
        }

        public Collection<ElementInfo> getChildren() {
            return Collections.unmodifiableCollection(this.children.values());
        }

        public ElementInfo getParent() {
            return this.parent;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public void setValidationRequired(boolean value) {
            this.validationRequired = value;
        }

        public boolean validationRequired() {
            return this.validationRequired;
        }
    }

    static abstract class NodeInfo {
        public String name;
        public int count;

        protected NodeInfo(String name) {
            this.name = name;
        }

        public boolean equal(Object object) {
            if (!(object instanceof NodeInfo)) {
                return false;
            }
            return ((NodeInfo)object).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

