/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import com.adobe.air.ADTOutputStream;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.air.InvalidInputException;
import com.adobe.air.SDK;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.AOTCompiler;
import com.adobe.air.ipa.IPASigner;
import com.adobe.air.ipa.InfoPlist;
import com.adobe.air.ipa.ResponseFileDatabase;
import com.adobe.argv.Arguments;
import com.adobe.argv.UsageError;
import com.adobe.png.PNGUtils;
import com.adobe.ucf.CodeSigner;
import com.adobe.ucf.UCFOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;

public class IPAOutputStream
extends ADTOutputStream {
    protected static final String CODE_RESOURCES_LINK = "CodeResources";
    protected static final String MAIN_WINDOW_NIB = "MainWindow.nib";
    protected static final String MAIN_WINDOW_IPAD_NIB = "MainWindow-iPad.nib";
    protected static final String RESOURCE_RULES_PLIST = "ResourceRules.plist";
    protected static final String EMBEDDED_PROVISIONING_PROFILE = "embedded.mobileprovision";
    protected static final String INFO_PLIST = "Info.plist";
    protected static final String SIGNATURES_PATH = "_CodeSignature/CodeResources";
    protected static final String AOT_SDK_FOLDER_NAME = "lib/aot";
    protected static final String APP_CONTENT_PATH = "appContent/";
    protected static final String[] localizationLanguages = new String[]{"cs", "de", "en", "es", "fr", "it", "ja", "ko", "nl", "pl", "pt", "ru", "sv", "tr", "zh_Hans", "zh_Hant"};
    private String m_configType = "ipa-app-store";
    private File m_mobileProvisionProfile = null;
    private boolean m_compressSWF = false;
    private int m_verbose = 0;
    private boolean m_debug = false;
    private boolean m_debugRuntime = false;
    private boolean m_debugBuiltins = false;
    private boolean m_useInterpreter = false;
    private boolean m_dryRun = false;
    private boolean m_noStrip = false;
    private String m_target = "arm-air";
    private File m_SDKLocation = null;
    private int m_optimizeLevel = 0;
    private int m_timeoutSeconds = 0;
    private String m_remoteContentURI = null;
    private ArrayList<String> m_extraLinkerOptions = new ArrayList();
    private ArrayList<File> m_extraABCs = new ArrayList();
    private Set<String> m_addedFolders = new HashSet<String>();
    private File m_rootSwf = null;
    private File m_tempSwf = null;
    private String m_debugHost = null;
    private int m_debugPort = -1;

    protected CodeSigner getCodeSigner() {
        return new IPASigner();
    }

    private void addExtraLinkerArgsFromResponseFile() throws InvalidInputException {
        String[] responseFileArgs = ResponseFileDatabase.getArgumentsForAppId(this.getApplicationDescriptor().id());
        if (responseFileArgs != null) {
            ArrayList<String> extraLinkerOptions = new ArrayList<String>();
            Arguments args = new Arguments(responseFileArgs);
            try {
                while (args.peek()) {
                    if (args.acceptEquals("-Xlinker")) {
                        extraLinkerOptions.add(args.accept());
                        continue;
                    }
                    throw new UsageError("Unsupported option or argument in response file.");
                }
                for (String extraLinkerOption : extraLinkerOptions) {
                    this.addLinkerOption(extraLinkerOption);
                }
            }
            catch (UsageError e2) {
                throw new InvalidInputException(e2.getMessage());
            }
        }
    }

    public void addApplicationDescriptor(ApplicationDescriptor descriptor, boolean sign) throws IOException {
        super.addApplicationDescriptor(descriptor, sign);
        this.addExtraLinkerArgsFromResponseFile();
        this.addInfoPlist();
        this.addResourceRulesPlist();
        this.addCodeResources();
        this.addMainWindowNib();
        this.addData(descriptor.getBytes(), "META-INF/AIR/application.xml", new Date(), sign, true);
        for (String lang : this.getApplicationDescriptor().localizedNames().keySet()) {
            String name = this.getApplicationDescriptor().localizedNames().get(lang);
            String entry = "CFBundleDisplayName = \"" + name + "\";";
            this.addData(entry.getBytes("UTF-8"), lang + ".lproj/InfoPlist.strings", new Date(), true, true);
        }
        this.addLocalizationResources();
    }

    public void addHashFile(String path) throws IOException {
    }

    public void addMimeTypeFile(String mimeType, boolean addToSignature) throws IOException {
    }

    public void addDescriptorFromZipEntry(ZipEntry entry, InputStream data) throws IOException {
        this.addApplicationDescriptor(new ApplicationDescriptor(data), true);
        this.getApplicationDescriptor().validate(this.m_validationParams);
    }

    public void addIconFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.getApplicationDescriptor().validateIcon(data, entry.getName(), false);
        data.reset();
        this.addSpecialIcon(data, entry.getName());
        data.reset();
        this.addFileFromZipEntry(entry, data, permissions);
    }

    public void addInitialContentFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.getApplicationDescriptor().validateInitialContent(data, false);
        data.reset();
        this.m_rootSwf = this.m_tempSwf = File.createTempFile("swf", null, this.outputDir);
        Utils.writeOut(data, this.m_tempSwf);
    }

    public void addFile(File file, String path, boolean addToSignature) throws IOException {
        if (path.equals(this.getApplicationDescriptor().initialContent()) && !this.m_useInterpreter) {
            this.m_rootSwf = file;
        } else {
            FileInputStream in = new FileInputStream(file);
            this.addSpecialIcon(in, path);
            ((InputStream)in).close();
            super.addFile(file, path, addToSignature);
        }
    }

    private void addSpecialIcon(InputStream in, String path) throws IOException {
        ApplicationDescriptor appDescriptor = this.getApplicationDescriptor();
        if (!this.m_configType.equals("ipa-app-store") && path.equals(appDescriptor.getIcon(512)) && !path.equals("iTunesArtwork")) {
            this.addFileFromStream("iTunesArtwork", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(72)) && !path.equals("Icon-Large.png")) {
            this.addFileFromStream("Icon-Large.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(57)) && !path.equals("Icon.png")) {
            this.addFileFromStream("Icon.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(114)) && !path.equals("Icon@2x.png")) {
            this.addFileFromStream("Icon@2x.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(48)) && !path.equals("Icon-Small-50.png")) {
            this.addFileFromStream("Icon-Small-50.png", in, DEFAULT_FILE_PERMISSONS, true);
        } else if (path.equals(appDescriptor.getIcon(29)) && !path.equals("Icon-Small.png")) {
            this.addFileFromStream("Icon-Small.png", in, DEFAULT_FILE_PERMISSONS, true);
        }
    }

    public File compileRootSwf() throws IOException {
        if (this.m_useInterpreter) {
            File interpreter = new File(this.getAOTSDKDir() + "/lib/AIRInterpreter");
            if (!interpreter.exists()) {
                throw new SDKDamagedException(interpreter.getAbsolutePath());
            }
            File executable = File.createTempFile("non-aot", null, this.outputDir);
            Utils.copyTo(interpreter, executable);
            return executable;
        }
        InputStream data = null;
        try {
            if (this.m_optimizeLevel == 0 && (this.m_configType.equals("ipa-ad-hoc") || this.m_configType.equals("ipa-app-store"))) {
                this.m_optimizeLevel = 3;
            }
            this.m_noStrip |= this.m_configType.equals("ipa-debug");
            if (this.m_rootSwf != null) {
                data = new FileInputStream(this.m_rootSwf);
            }
            AOTCompiler compiler = new AOTCompiler(this.m_target, data, this.getAOTSDKDir().getAbsolutePath(), this.outputDir.getAbsolutePath(), this.m_optimizeLevel, this.m_verbose, this.m_compressSWF, this.m_debug, this.m_noStrip, this.m_debugRuntime, this.m_debugBuiltins, this.m_dryRun, this.m_useInterpreter, this.m_extraABCs, this.m_extraLinkerOptions, this.m_timeoutSeconds);
            if (this.m_listener != null) {
                compiler.setListener(this.m_listener);
            }
            compiler.GenerateMacBinary();
            File file = compiler.getExecutable();
            return file;
        }
        catch (InvalidInputException e2) {
            throw e2;
        }
        catch (SDKDamagedException e3) {
            throw e3;
        }
        catch (Exception e4) {
            e4.printStackTrace();
            throw new IOException("Error:" + e4.getMessage());
        }
        finally {
            if (data != null) {
                data.close();
            }
        }
    }

    private File getAOTSDKDir() throws IOException {
        if (this.m_SDKLocation == null) {
            this.m_SDKLocation = Utils.getSDKLibDir().getParentFile();
        }
        return new File(this.m_SDKLocation, AOT_SDK_FOLDER_NAME);
    }

    public void addInfoPlist() throws IOException {
        InfoPlist infoPlist = new InfoPlist();
        ApplicationDescriptor appDescriptor = this.getApplicationDescriptor();
        infoPlist.setName(appDescriptor.name());
        infoPlist.setExecutable(appDescriptor.filename());
        infoPlist.setIdentifier(appDescriptor.id());
        infoPlist.setFullscreen(appDescriptor.fullscreen());
        infoPlist.setInitialWindowTitle(appDescriptor.initialWindowTitle());
        if (appDescriptor.getIcon(72) != null) {
            infoPlist.setIconLarge("Icon-Large.png");
        }
        if (appDescriptor.getIcon(57) != null) {
            infoPlist.setIcon("Icon.png");
        }
        if (appDescriptor.getIcon(48) != null) {
            infoPlist.setIconSmall50("Icon-Small-50.png");
        }
        if (appDescriptor.getIcon(114) != null) {
            infoPlist.setIcon2x("Icon@2x.png");
        }
        if (this.m_remoteContentURI != null) {
            infoPlist.setInitialWindowContent(this.m_remoteContentURI);
        } else if (this.m_useInterpreter) {
            infoPlist.setInitialWindowContent(appDescriptor.name() + ".app/" + appDescriptor.initialContent());
        }
        infoPlist.setMaxSWFVersion(appDescriptor.maxSWFVersion());
        infoPlist.setVersionNumber(appDescriptor.versionNumber());
        infoPlist.setInfoAdditions(appDescriptor.iosInfoAdditions());
        infoPlist.setAspectRatio(appDescriptor.aspectRatio());
        infoPlist.setAutoOrients(appDescriptor.autoOrients());
        infoPlist.setRenderMode(appDescriptor.renderMode());
        infoPlist.setSoftKeyboardBehavior(appDescriptor.softKeyboardBehavior());
        infoPlist.setForOutgoingDebuggingConnection(this.m_debugHost, this.m_debugPort);
        infoPlist.setDisplayMode(appDescriptor.iosDisplayTagVal());
        this.addData(infoPlist.getXML().getBytes("UTF-8"), INFO_PLIST, new Date(), false, true);
    }

    public void addMainWindowNib() throws IOException, SDKDamagedException {
        File mainWindowNib = new File(new File(this.getAOTSDKDir(), "lib"), MAIN_WINDOW_NIB);
        if (!mainWindowNib.exists()) {
            throw new SDKDamagedException(MAIN_WINDOW_NIB);
        }
        this.addFile(mainWindowNib, MAIN_WINDOW_NIB, true, DEFAULT_FILE_PERMISSONS);
        File mainWindowIPadNib = new File(new File(this.getAOTSDKDir(), "lib"), MAIN_WINDOW_IPAD_NIB);
        if (!mainWindowIPadNib.exists()) {
            throw new SDKDamagedException(MAIN_WINDOW_IPAD_NIB);
        }
        this.addFile(mainWindowIPadNib, MAIN_WINDOW_IPAD_NIB, true, DEFAULT_FILE_PERMISSONS);
    }

    public void addResourceRulesPlist() throws IOException {
        this.addFileFromResource(RESOURCE_RULES_PLIST, false);
    }

    private void addFileFromResource(String name, boolean addToSignature) throws IOException {
        this.addFileFromStream(name, this.getClass().getResourceAsStream(name), DEFAULT_FILE_PERMISSONS, addToSignature);
    }

    public void addCodeResources() throws IOException {
        this.addFileFromStream(CODE_RESOURCES_LINK, new ByteArrayInputStream(SIGNATURES_PATH.getBytes()), SYMLINK_FILE_PERMISSIONS, false);
    }

    private void addLocalizationResources() throws IOException {
        for (int index = 0; index < localizationLanguages.length; ++index) {
            String localizationPath = localizationLanguages[index] + ".lproj/Localizable.strings";
            this.addFileFromResource(localizationPath, true);
        }
    }

    protected String getSignaturesPath() {
        return SIGNATURES_PATH;
    }

    protected void addFile(UCFOutputStream.FileRecord record, InputStream data, boolean addToSignature, boolean compress) throws IOException {
        String[] iconPaths;
        String[] pathParts = this.getZipPath(record).split("/");
        String currentFolder = "";
        for (int i2 = 0; i2 < pathParts.length - 1; ++i2) {
            if (this.m_addedFolders.contains(currentFolder = currentFolder + pathParts[i2] + "/")) continue;
            UCFOutputStream.FileRecord parentRecord = new UCFOutputStream.FileRecord(record);
            parentRecord.path = currentFolder;
            parentRecord.permissions = FOLDER_FILE_PERMISSIONS;
            parentRecord.absolute = true;
            super.addFile(parentRecord, new EmptyInputStream(), false, false);
            this.m_addedFolders.add(currentFolder);
        }
        if (record.path.equals("Icon-Small-50.png")) {
            data = PNGUtils.addTransparentBorder(data, 1);
        }
        if (Arrays.asList(iconPaths = new String[]{"Icon.png", "Icon@2x.png", "Icon-Small.png", "Icon-Large.png", "Icon-Small-50.png", "iTunesArtwork"}).contains(record.path)) {
            data = PNGUtils.updatePNGMetadata(data, "Software", "Adobe AIR for iOS ", SDK.getVersion());
        }
        super.addFile(record, data, addToSignature, compress);
    }

    protected String getZipPath(UCFOutputStream.FileRecord record) {
        if (record.absolute) {
            return record.path;
        }
        return "Payload/" + this.getApplicationDescriptor().filename() + ".app/" + record.path;
    }

    protected void processBytes(String path, byte[] bytes, int numBytes) {
        if (path.equals(INFO_PLIST)) {
            ((IPASigner)this.codeSigner).updateInfoPlistDigest(bytes, numBytes);
        } else if (path.equals(SIGNATURES_PATH)) {
            ((IPASigner)this.codeSigner).updateCodeResourcesDigest(bytes, numBytes);
        }
    }

    protected short versionMadeBy(UCFOutputStream.FileRecord r2) {
        return 791;
    }

    protected short getLFExtraFieldLength(UCFOutputStream.FileRecord r2) {
        return 21;
    }

    protected void writeLFExtraField(UCFOutputStream.FileRecord r2) throws IOException {
        this.os.writeShort(21589);
        this.os.writeShort(9);
        this.os.writeByte(3);
        this.os.writeLong(r2.lastModifiedUnixTime);
        this.os.writeLong(r2.lastModifiedUnixTime);
        this.os.writeShort(30805);
        this.os.writeShort(4);
        this.os.writeShort(203);
        this.os.writeShort(0);
    }

    protected short getCDExtraFieldLength() {
        return 13;
    }

    protected void writeCDExtraField(UCFOutputStream.FileRecord r2) throws IOException {
        this.os.writeShort(21589);
        this.os.writeShort(5);
        this.os.writeByte(3);
        this.os.writeLong(r2.lastModifiedUnixTime);
        this.os.writeShort(30805);
        this.os.writeShort(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeSig() throws IOException, GeneralSecurityException, InvalidInputException {
        File executable = null;
        try {
            if (this.m_mobileProvisionProfile == null) {
                throw new InvalidInputException("Mobile provisioning profile not specified.");
            }
            this.addFile(this.m_mobileProvisionProfile, EMBEDDED_PROVISIONING_PROFILE, true);
            ((IPASigner)this.codeSigner).setAppIdentifier(this.getApplicationDescriptor().id());
            ((IPASigner)this.codeSigner).setMobileProvisioningProfile(this.m_mobileProvisionProfile);
            super.finalizeSig();
            ((IPASigner)this.codeSigner).prepareToSign();
            executable = this.compileRootSwf();
            ((IPASigner)this.codeSigner).setMachoFile(executable);
            ((IPASigner)this.codeSigner).signMacho();
            this.addFile(executable, this.getApplicationDescriptor().filename(), false, EXECUTABLE_FILE_PERMISSIONS);
        }
        finally {
            if (executable != null) {
                executable.delete();
            }
        }
    }

    public void close() throws IOException {
        if (this.m_tempSwf != null) {
            this.m_tempSwf.delete();
        }
        super.close();
    }

    public void setOptimizeLevel(int optLevel) {
        this.m_optimizeLevel = optLevel;
    }

    protected long determineFilePermissions(File file) {
        return DEFAULT_FILE_PERMISSONS;
    }

    public void setVerbose(int verbosity) {
        this.m_verbose = verbosity;
    }

    public void setCompressSWF(boolean compressSWFFlag) {
        this.m_compressSWF = compressSWFFlag;
    }

    public void setDebug(boolean debugFlag) {
        this.m_debug = debugFlag;
    }

    public void setNoStrip(boolean stripFlag) {
        this.m_noStrip = stripFlag;
    }

    public void setDebugRuntime(boolean debugRuntimeFlag) {
        this.m_debugRuntime = debugRuntimeFlag;
    }

    public void setDebugBuiltins(boolean debugBuiltinsFlag) {
        this.m_debugBuiltins = debugBuiltinsFlag;
    }

    public void setForOutgoingDebuggingConnection(String debugHost, int debugPort) {
        this.m_debugHost = debugHost;
        this.m_debugPort = debugPort;
    }

    public void setUseInterpreter(boolean interpreterFlag) {
        this.m_useInterpreter = interpreterFlag;
    }

    public void setMobileProvisioningProfile(File mobileProvisionProfile) {
        this.m_mobileProvisionProfile = mobileProvisionProfile;
    }

    public void setDryRun(boolean dryRun) {
        this.m_dryRun = dryRun;
    }

    public void setTarget(String target) {
        this.m_target = target;
    }

    public void setSDKLocation(String location) {
        this.m_SDKLocation = new File(location);
    }

    public void setTimeout(int timeoutSeconds) {
        this.m_timeoutSeconds = timeoutSeconds;
    }

    public void addExtraABC(String abc) {
        this.m_extraABCs.add(new File(abc));
    }

    public void addLinkerOption(String linkoption) {
        this.m_extraLinkerOptions.add(linkoption);
    }

    public void compileShellApp() throws IOException {
        this.compileRootSwf();
    }

    public void setRemoteContentURI(String remoteContent) {
        this.m_remoteContentURI = remoteContent;
    }

    public void setPackageConfiguration(String configType) {
        assert (configType.equals("ipa-test") || configType.equals("ipa-debug") || configType.equals("ipa-app-store") || configType.equals("ipa-ad-hoc"));
        if (configType.equals("ipa-debug")) {
            this.m_debug = true;
        }
        this.m_configType = configType;
    }

    private class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

