/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.ipa;

import adobe.abc.LLVMEmitter;
import adobe.abc.LLVMEmitterOptions;
import com.adobe.air.InvalidInputException;
import com.adobe.air.Listener;
import com.adobe.air.SDKDamagedException;
import com.adobe.air.Utils;
import com.adobe.air.ipa.ProcessError;
import com.adobe.air.ipa.SWFUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Vector;
import llvm.Function;
import llvm.FunctionPassManager;
import llvm.Function_vector;
import llvm.JNIStringRef;
import llvm.LLVM;
import llvm.LLVMContext;
import llvm.Level;
import llvm.Linker;
import llvm.Module;
import llvm.Pass;
import llvm.PassManager;
import llvm.StringRef;
import llvm.Target;
import llvm.TargetData;
import llvm.TargetMachine;
import llvm.TargetRegistry;
import llvm.formatted_raw_ostream;
import llvm.raw_fd_ostream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AOTCompiler {
    private InputStream m_swfStream = null;
    private File m_strippedSWFFile = null;
    private File m_generatedBitcode = null;
    private File m_asmFile = null;
    private File m_macOFile = null;
    private File m_macExe = null;
    private String m_baseName = "AOTBuildOutput";
    private String m_targetArch = "arm";
    private String m_targetRuntime = "air";
    private String m_target = null;
    private int m_verbosity = 0;
    private boolean m_verbose = false;
    private boolean m_debugger = false;
    private boolean m_debugSDK = false;
    private boolean m_noStrip = false;
    private boolean m_debugRuntime = false;
    private boolean m_debugBuiltins = false;
    private boolean m_dryRun = false;
    private boolean m_interpreter = false;
    private boolean m_compressSWF = false;
    private int m_numstublibs = 10;
    private File m_tempFolder = null;
    private File m_outputFolder = null;
    private String m_captiveSdkRoot = null;
    private Module m_module = null;
    private LLVMContext m_ctx = null;
    private int m_optLevel = 0;
    private int m_timeoutSeconds = 0;
    private ArrayList<String> m_extraLinkerOpts = null;
    private int m_currStep;
    private int m_totalSteps;
    private Listener m_listener;
    private Vector<File> m_abcFiles = new Vector();
    private HashMap<String, String> m_tools = new HashMap();

    private static ArrayList<String> createArgs(String ... args) {
        return new ArrayList<String>(Arrays.asList(args));
    }

    private static void appendArgs(ArrayList<String> args, String ... moreargs) {
        args.addAll(Arrays.asList(moreargs));
    }

    public void setListener(Listener listener) {
        this.m_listener = listener;
    }

    private static void checkAndReportMissingGPLComponent(String path) throws SDKDamagedException {
        if (!new File(path).exists()) {
            throw new SDKDamagedException(path, true);
        }
    }

    public AOTCompiler(String target, InputStream swfFile, String AOTSdkDir, String outputPath, int optLevel, int verbose, boolean compressSWF, boolean debugger, boolean nostrip, boolean debugRuntime, boolean debugBuiltins, boolean dryRun, boolean interpreter, ArrayList<File> extraAbcs, ArrayList<String> extraLinkerOpts, int timeoutSeconds) throws IOException {
        this.m_swfStream = swfFile;
        this.m_target = target;
        this.m_verbose = verbose > 0;
        this.m_verbosity = verbose;
        this.m_debugger = debugger;
        this.m_noStrip = nostrip;
        this.m_debugRuntime = debugRuntime;
        this.m_debugBuiltins = debugBuiltins;
        this.m_outputFolder = new File(outputPath);
        this.m_captiveSdkRoot = AOTSdkDir;
        this.m_optLevel = optLevel;
        this.m_compressSWF = compressSWF;
        this.m_dryRun = dryRun;
        this.m_interpreter = interpreter;
        this.m_timeoutSeconds = timeoutSeconds;
        this.m_extraLinkerOpts = extraLinkerOpts;
        if (System.getProperty("os.name").contains("Windows") && System.getProperty("sun.arch.data.model").contains("64")) {
            throw new IOException("Only x32 JVM supported");
        }
        for (File f2 : extraAbcs) {
            this.m_abcFiles.add(f2);
        }
        if (this.m_swfStream == null) {
            this.m_baseName = extraAbcs.get(extraAbcs.size() - 1).getName();
            this.m_baseName = this.m_baseName.substring(0, this.m_baseName.lastIndexOf(46));
            this.m_tempFolder = new File(this.m_outputFolder, this.m_baseName + ".tmp");
            this.m_tempFolder.mkdirs();
            for (File abcFile : this.m_abcFiles) {
                Utils.copyTo(abcFile, new File(this.m_tempFolder, abcFile.getName()));
            }
        } else {
            this.m_tempFolder = File.createTempFile(this.m_baseName, null, this.m_outputFolder);
            this.m_tempFolder.delete();
            this.m_tempFolder.mkdirs();
        }
        String osName = System.getProperty("os.name");
        String exeSuffix = "";
        if (osName.contains("Windows")) {
            exeSuffix = ".exe";
        } else if (!osName.contains("Mac")) {
            throw new UnsupportedOperationException("Functionality not supported on : " + osName);
        }
        try {
            int delim = this.m_target.lastIndexOf(45);
            this.m_targetArch = this.m_target.substring(0, delim);
            this.m_targetRuntime = this.m_target.substring(delim + 1, this.m_target.length());
        }
        catch (Exception e2) {
            throw new UnsupportedOperationException("Invalid target '" + this.m_target + "'");
        }
        if (!(this.m_targetArch.equals("arm") || this.m_targetArch.equals("x86") || this.m_targetArch.equals("x86-simulator"))) {
            throw new UnsupportedOperationException("Unknown architechture '" + this.m_targetArch + "'");
        }
        if (!this.m_targetRuntime.equals("air") && !this.m_targetRuntime.equals("shell")) {
            throw new UnsupportedOperationException("Unknown runtime type '" + this.m_targetRuntime + "'");
        }
        if (this.m_targetArch.equals("x86-simulator")) {
            this.m_captiveSdkRoot = "${env.AIR_PATH_TO_SIMULATOR_SDK}";
        } else if (this.m_targetArch.equals("x86")) {
            this.m_captiveSdkRoot = "/Developer/SDKs/MacOSX10.5.sdk";
        }
        this.m_debugSDK = new File(AOTSdkDir + "/lib/libavmplus." + this.m_target + ".a").exists();
        this.m_tools.put("strip", AOTSdkDir + "/bin/strip/strip" + exeSuffix);
        this.m_tools.put("as", AOTSdkDir + "/bin/as/" + (this.m_targetArch.equals("arm") ? "arm" : "i686") + "-apple-darwin9-as" + exeSuffix);
        this.m_tools.put("ld64", AOTSdkDir + "/bin/ld64/i686-apple-darwin9-ld64" + exeSuffix);
        this.m_tools.put("builtin", AOTSdkDir + "/lib/builtin.abc");
        this.m_tools.put("avmglue", AOTSdkDir + "/lib/avmglue.abc");
        this.m_tools.put("bitcode.api", AOTSdkDir + "/lib/bitcode.api." + this.m_target + ".txt");
        this.m_tools.put("aotcompiler", AOTSdkDir + "/lib/AOTCompiler." + this.m_target + ".bc");
        for (int i2 = 0; i2 < this.m_numstublibs; ++i2) {
            this.m_tools.put("libaot" + i2, AOTSdkDir + "/lib/libAOTCompiler" + String.format("%02d", i2) + "." + this.m_target + ".bc.a");
        }
        this.m_tools.put("libavmplus", AOTSdkDir + "/lib/libavmplus." + this.m_target + (this.m_debugSDK ? ".a" : ".bc.a"));
        this.m_tools.put("libmmgc", AOTSdkDir + "/lib/libMMgc." + this.m_target + (this.m_debugSDK ? ".a" : ".bc.a"));
        AOTCompiler.checkAndReportMissingGPLComponent(this.m_tools.get("as"));
        AOTCompiler.checkAndReportMissingGPLComponent(AOTSdkDir + "/lib/gcc/libgcc.a");
        if (this.m_targetRuntime.equals("air")) {
            this.m_tools.put("libruntimeaot", AOTSdkDir + "/lib/libRuntimeAOT." + this.m_target + ".a");
            this.m_tools.put("libdebugger1", AOTSdkDir + "/lib/libDebugger1." + this.m_target + ".a");
            this.m_tools.put("libnodebugger1", AOTSdkDir + "/lib/libNoDebugger1." + this.m_target + ".a");
            this.m_tools.put("libdebugger2", AOTSdkDir + "/lib/libDebugger2." + this.m_target + ".a");
            this.m_tools.put("libnodebugger2", AOTSdkDir + "/lib/libNoDebugger2." + this.m_target + ".a");
        }
        if (this.m_swfStream == null) {
            this.m_tools.put("toplevel", AOTSdkDir + "/lib/shell_toplevel.abc");
        }
        if (this.m_interpreter) {
            this.m_tools.put("interpreter", AOTSdkDir + "/lib/libRuntimeInterpreter." + this.m_target + ".a");
        }
    }

    public void launchProcess(List<String> cmdLine, String name, String msg) throws ProcessError, IOException {
        int retcode = this.launchProcess(cmdLine);
        if (retcode != 0) {
            throw new ProcessError(name, msg, retcode);
        }
    }

    public int launchProcess(List<String> cmdLine) throws IOException {
        if (this.m_verbose) {
            for (String cmd : cmdLine) {
                System.out.print(cmd + " ");
            }
            System.out.println("");
        }
        if (this.m_dryRun) {
            return 0;
        }
        int retCode = 1;
        try {
            Process rProcess = Utils.execSafely(this.m_tempFolder, cmdLine);
            Utils.OutputEater consumeInput = new Utils.OutputEater(rProcess.getInputStream());
            Utils.OutputEater consumeErr = new Utils.OutputEater(rProcess.getErrorStream(), this.m_verbose ? System.out : null);
            consumeInput.start();
            consumeErr.start();
            retCode = rProcess.waitFor();
            consumeInput.join();
            consumeErr.join();
        }
        catch (InterruptedException e2) {
            retCode = 0;
        }
        return retCode;
    }

    public File getNewTempFile(String path) throws IOException {
        File rFile = new File(this.m_tempFolder, path);
        if (rFile.exists()) {
            rFile.delete();
        }
        rFile.createNewFile();
        return rFile;
    }

    protected void dumpBitcode(String name) throws IOException {
        if (this.m_verbosity > 2) {
            this.m_generatedBitcode = this.getNewTempFile(name);
            System.out.println("# Verifying bitcode...");
            LLVM.verifyModule(this.m_module);
            System.out.println("# Writing bitcode: " + this.m_generatedBitcode.getCanonicalPath());
            LLVM.WriteModuleToFile(this.m_generatedBitcode.getCanonicalPath(), this.m_module);
        }
    }

    protected void convertSwfToAbc() throws InvalidInputException {
        if (this.m_targetRuntime.equals("shell")) {
            return;
        }
        try {
            SWFUtils util = new SWFUtils(this.m_swfStream, this.m_compressSWF, true);
            int index = 0;
            for (byte[] abcData : util.getABCs()) {
                File temp = this.getNewTempFile(this.m_baseName + "-" + index + ".abc");
                this.m_abcFiles.add(temp);
                FileOutputStream fop = new FileOutputStream(temp);
                fop.write(abcData);
                fop.flush();
                fop.close();
                ++index;
            }
            this.m_strippedSWFFile = this.getNewTempFile(this.m_baseName + "-stripped.swf");
            util.exportToFile(this.m_strippedSWFFile);
        }
        catch (Exception e2) {
            throw new InvalidInputException("Invalid input. Not a valid swf file");
        }
    }

    protected void convertAbcToLlvmBitcode() throws IOException, ProcessError {
        if (this.m_verbose) {
            System.out.println("# Generating bitcode...");
        }
        LLVMEmitterOptions opts = new LLVMEmitterOptions();
        opts.useARMCallingConvention = this.m_targetArch.equals("arm");
        opts.debugger = this.m_debugger;
        opts.runtimeDebugging = this.m_debugRuntime;
        opts.debugBuiltins = this.m_debugBuiltins;
        opts.runtimeBitcode = new File(this.m_tools.get("aotcompiler"));
        opts.builtInABCs.add(this.m_tools.get("builtin"));
        opts.builtInABCs.add(this.m_targetRuntime.equals("shell") ? this.m_tools.get("toplevel") : this.m_tools.get("avmglue"));
        for (File abcFile : this.m_abcFiles) {
            opts.appABCs.add(new File(this.m_tempFolder, abcFile.getName()).getPath());
        }
        this.m_module = LLVMEmitter.generateBitcode(opts, false);
        this.m_ctx = this.m_module.getContext();
        if (this.m_verbosity > 2) {
            System.out.println("# Generating stub stats...");
            HashMap<String, Integer> stats = new HashMap<String, Integer>();
            Function_vector funcs = LLVM.toVector(this.m_module.getFunctionList());
            int size = (int)funcs.size();
            for (int i2 = 0; i2 < size; ++i2) {
                Function fn = funcs.get(i2);
                String fname = fn.getName().data();
                if (fname.indexOf("abcOP_") < 0) continue;
                stats.put(fname, (int)fn.getNumUses());
            }
            try {
                File file = this.getNewTempFile(this.m_baseName + ".stats.txt");
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                for (String k2 : stats.keySet()) {
                    writer.write(k2 + " | " + stats.get(k2) + "\n");
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e2) {
                System.out.println("# Generating stub stats... FAILED");
            }
        }
        this.dumpBitcode(this.m_baseName + ".bc");
    }

    protected void linkBitcodeFiles() throws IOException, ProcessError {
        if (this.m_verbose) {
            System.out.println("# Linking bitcode libraries...");
        }
        Linker lnk = new Linker((StringRef)new JNIStringRef("jni-llvm-ld"), this.m_module, this.m_verbose ? 1L : 0L);
        for (int i2 = 0; i2 < this.m_numstublibs; ++i2) {
            lnk.LinkInArchive(this.m_tools.get("libaot" + i2));
        }
        if (!this.m_debugSDK) {
            lnk.LinkInFile(this.m_tools.get("libavmplus"));
            lnk.LinkInFile(this.m_tools.get("libmmgc"));
        }
        this.m_module = lnk.releaseModule();
        lnk.delete();
        Function f2 = this.m_module.getFunction(new JNIStringRef("_ZNK7avmplus10PoolObject9getStringEi"));
        if (f2 == null && this.m_verbose) {
            System.out.println("Failed to find PoolObject->getString()...");
        } else {
            f2.setOnlyReadsMemory(true);
        }
        this.dumpBitcode(this.m_baseName + "-01-linked.bc");
    }

    protected void optimizeBitcode() throws IOException, ProcessError {
        PassManager pm = new PassManager();
        TargetData td = new TargetData(this.m_module);
        pm.add(td);
        pm.add(LLVM.createInternalizePass(this.m_tools.get("bitcode.api")));
        pm.add(LLVM.createGlobalDCEPass());
        pm.add(LLVM.createAggressiveDCEPass());
        if (this.m_optLevel > 0) {
            if (this.m_verbose) {
                System.out.println("# Optimizing functions...");
            }
            FunctionPassManager fpm = FunctionPassManager.create(this.m_module);
            fpm.add(new TargetData(td));
            LLVM.createStandardFunctionPasses(fpm, this.m_optLevel);
            Pass inliningPass = LLVM.createFunctionInliningPass(this.m_optLevel > 2 ? 250 : 200);
            LLVM.createStandardModulePasses(pm, this.m_optLevel, false, true, this.m_optLevel > 1, true, true, inliningPass);
            fpm.doInitialization();
            Function_vector funcs = LLVM.toVector(this.m_module.getFunctionList());
            int size = (int)funcs.size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (this.m_verbose && i2 % (size / 10) == 0) {
                    System.out.println("# -- function " + i2 + "/" + size + "...");
                }
                fpm.run(funcs.get(i2));
            }
            fpm.doFinalization();
        }
        pm.add(LLVM.createLowerInvokePass(null, true));
        if (this.m_verbose) {
            System.out.println("# Optimizing module...");
        }
        pm.run(this.m_module);
        this.dumpBitcode(this.m_baseName + "-opt.bc");
    }

    protected void compileBitcode() throws IOException, ProcessError {
        PriorityQueue<Timing> compileTimes = new PriorityQueue<Timing>();
        this.m_asmFile = this.getNewTempFile(this.m_baseName + ".asm");
        this.m_macOFile = this.getNewTempFile(this.m_baseName + ".o");
        if (this.m_verbose) {
            System.out.println("# Generating asm...");
        }
        LLVM.InitializeAllTargets();
        LLVM.InitializeAllAsmPrinters();
        LLVM.setNoFramePointerElim(true);
        Target thetarget = TargetRegistry.lookupTarget(this.m_module.getTargetTriple());
        TargetMachine themachine = thetarget.createTargetMachine(this.m_module.getTargetTriple(), this.m_targetArch.equals("arm") ? ",+v6,+vfp2" : "");
        FunctionPassManager fpm = FunctionPassManager.create(this.m_module);
        raw_fd_ostream rfdos = raw_fd_ostream.create(this.m_asmFile.getCanonicalPath());
        formatted_raw_ostream os = new formatted_raw_ostream(rfdos);
        if (this.m_optLevel == 0) {
            LLVM.setEnableFastISel(true);
        }
        fpm.add(new TargetData(themachine.getTargetData()));
        themachine.addPassesToEmitFile(fpm, os, TargetMachine.CodeGenFileType.CGFT_AssemblyFile, this.m_optLevel == 0 ? Level.None : Level.Aggressive, true);
        long startTime = System.currentTimeMillis();
        fpm.doInitialization();
        Function_vector funcs = LLVM.toVector(this.m_module.getFunctionList());
        int size = (int)funcs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.m_verbose) {
                if (i2 % (size / 10) == 0) {
                    System.out.println("# -- function " + i2 + "/" + size + "...");
                }
                long fstartTime = System.currentTimeMillis();
                fpm.run(funcs.get(i2));
                compileTimes.add(new Timing(System.currentTimeMillis() - fstartTime, funcs.get(i2).getName().data()));
                continue;
            }
            fpm.run(funcs.get(i2));
        }
        fpm.doFinalization();
        fpm.delete();
        os.flush();
        rfdos.flush();
        rfdos.close();
        if (this.m_verbose) {
            double llcTime = System.currentTimeMillis() - startTime;
            System.out.println("# llc took " + llcTime / 1000.0 + "s");
            long nonabctime = 0L;
            for (Timing t2 : compileTimes) {
                if (t2.name.startsWith("abcMethod")) continue;
                nonabctime += t2.timeMS;
            }
            System.out.println("# non-abcMethod functions took " + (double)nonabctime / 1000.0 + "s");
            for (int i3 = 0; i3 < 100; ++i3) {
                Timing t2;
                t2 = (Timing)compileTimes.poll();
                System.out.println("# " + (double)t2.timeMS / 1000.0 + "s (" + (double)t2.timeMS / llcTime * 100.0 + "%) for " + t2.name + "\n");
            }
        }
        this.launchProcess(AOTCompiler.createArgs(this.m_tools.get("as"), "-arch", this.m_targetArch.equals("arm") ? "armv6" : "i686", "-o", this.m_macOFile.getName(), this.m_asmFile.getName()), "as", "Assembler failed");
    }

    protected void linkMachO() throws IOException, ProcessError {
        this.m_macExe = this.m_swfStream == null ? new File(this.m_outputFolder, this.m_baseName) : File.createTempFile("aot", null, this.m_outputFolder);
        ArrayList<String> args = AOTCompiler.createArgs(this.m_tools.get("ld64"), "-ObjC", "-dead_strip", "-L" + this.m_captiveSdkRoot + "/lib", "-L" + this.m_captiveSdkRoot + "/lib/gcc", "-L" + this.m_captiveSdkRoot + "/usr/lib", "-L" + this.m_captiveSdkRoot + "/usr/lib/i686-apple-darwin9/4.2.1", "-L" + this.m_captiveSdkRoot + "/usr/lib/i686-apple-darwin10/4.2.1", "-L" + this.m_captiveSdkRoot + "/usr/lib/gcc/i686-apple-darwin9/4.2.1", "-L" + this.m_captiveSdkRoot + "/usr/lib/gcc/i686-apple-darwin10/4.2.1", "-L" + this.m_captiveSdkRoot + "/stub", "-o", "../" + this.m_macExe.getName(), "-exported_symbol", "_main");
        if (this.m_extraLinkerOpts != null) {
            args.addAll(this.m_extraLinkerOpts);
        }
        if (this.m_interpreter) {
            AOTCompiler.appendArgs(args, "-syslibroot", this.m_captiveSdkRoot, this.m_tools.get("interpreter"));
        } else {
            AOTCompiler.appendArgs(args, "-Z", "-F" + this.m_captiveSdkRoot + (this.m_targetArch.equals("arm") ? "/stub" : "/System/Library/Frameworks"), this.m_macOFile.getName());
            if (this.m_targetRuntime.equals("air")) {
                AOTCompiler.appendArgs(args, "-sectcreate", "__TEXT", "__ic", this.m_strippedSWFFile.getName(), this.m_tools.get(this.m_debugger ? "libdebugger1" : "libnodebugger1"), this.m_tools.get(this.m_debugger ? "libdebugger2" : "libnodebugger2"), this.m_tools.get("libruntimeaot"));
            }
        }
        if (this.m_debugSDK) {
            AOTCompiler.appendArgs(args, this.m_tools.get("libavmplus"), this.m_tools.get("libmmgc"));
        }
        if (this.m_targetArch.equals("x86")) {
            AOTCompiler.appendArgs(args, "-arch", "i386", "-lstdc++", "-lcrt3.o", "-lcrt1.10.5.o", "-lgcc_s.10.5", "-lgcc", "-lSystem.B_debug", "-lz", "-macosx_version_min", "10.5.6", "-framework", "CoreServices");
        } else {
            if (this.m_targetArch.equals("arm")) {
                AOTCompiler.appendArgs(args, "-lgcc", "-lgcc_s.1");
            } else {
                AOTCompiler.appendArgs(args, "-lgcc_s.10.5");
            }
            AOTCompiler.appendArgs(args, "-arch", this.m_targetArch.equals("arm") ? "arm" : "i386", "-lstdc++.6", "-lcrt1.o", "-lSystem.B", "-lz", "-lobjc", "-framework", "CoreFoundation", "-framework", "UIKit", "-framework", "MobileCoreServices", "-framework", "CoreGraphics", "-framework", "Foundation", "-framework", "SystemConfiguration", "-framework", "AudioToolbox", "-framework", "CFNetwork", "-framework", "QuartzCore", "-framework", "OpenGLES", "-framework", "CoreLocation", "-framework", "CoreMedia", "-framework", "CoreVideo", "-framework", "AVFoundation", "-framework", "Security");
        }
        this.launchProcess(args, "ld64", "Unable to generate executable");
    }

    protected void stripExeSymbols() throws IOException, ProcessError {
        if (!this.m_noStrip) {
            this.launchProcess(AOTCompiler.createArgs(this.m_tools.get("strip"), "-x", "-r", "../" + this.m_macExe.getName()), "strip", "Unable to strip symbols from executable");
        }
    }

    public void ValidateAOTSDK() throws SDKDamagedException {
        if (!this.m_target.equals("arm-air") || this.m_interpreter) {
            return;
        }
        for (String filePath : this.m_tools.values()) {
            if (filePath.indexOf(this.m_captiveSdkRoot) < 0 || new File(filePath).exists()) continue;
            throw new SDKDamagedException(filePath);
        }
    }

    public void GenerateMacBinary() throws IOException, InvalidInputException, SDKDamagedException {
        boolean success = false;
        try {
            if (this.m_interpreter) {
                this.linkMachO();
            } else {
                this.m_totalSteps = this.m_noStrip ? 6 : 7;
                this.m_currStep = 0;
                this.ValidateAOTSDK();
                this.convertSwfToAbc();
                this.reportProgress();
                this.convertAbcToLlvmBitcode();
                this.reportProgress();
                this.linkBitcodeFiles();
                this.reportProgress();
                this.optimizeBitcode();
                this.reportProgress();
                this.compileBitcode();
                this.reportProgress();
                this.linkMachO();
                this.reportProgress();
                if (!this.m_noStrip) {
                    this.stripExeSymbols();
                    this.reportProgress();
                }
                if (System.getProperty("os.name").contains("Mac")) {
                    Runtime.getRuntime().exec("chmod a+x " + this.m_macExe.getAbsolutePath());
                }
            }
            success = true;
        }
        catch (ProcessError e2) {
            if (this.m_verbose) {
                e2.printStackTrace();
            }
            throw new InvalidInputException("Compilation failed while executing : " + e2.getProcessName());
        }
        catch (SDKDamagedException e3) {
            throw e3;
        }
        catch (Exception e4) {
            if (this.m_verbose) {
                e4.printStackTrace();
            }
            throw new InvalidInputException("Compilation failed...");
        }
        finally {
            if (!this.m_verbose) {
                Utils.deleteAll(this.m_tempFolder);
                if (!success && this.m_macExe != null && this.m_macExe.exists()) {
                    this.m_macExe.delete();
                }
            }
        }
    }

    private void reportProgress() {
        int percentDone = (int)((float)(++this.m_currStep) / ((float)this.m_totalSteps + 1.0f) * 100.0f);
        if (this.m_listener != null) {
            this.m_listener.progress(percentDone, 100);
        }
    }

    public File getExecutable() {
        return this.m_macExe;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Timing
    implements Comparable<Timing> {
        public long timeMS;
        public String name;

        public Timing(long timeMS, String name) {
            this.timeMS = timeMS;
            this.name = name;
        }

        @Override
        public int compareTo(Timing t2) {
            return (int)(t2.timeMS - this.timeMS);
        }
    }
}

