/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.apk;

import com.adobe.air.Listener;
import com.adobe.air.Message;
import com.adobe.air.apk.AndroidManifestXMLParser;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OrderManifestHandler
extends DefaultHandler {
    static FileOutputStream mOutputFile;
    static PrintStream mPrintStream;
    static HashMap<String, Integer> mResourceMap;
    static String mNamespacePrefix;
    static String mNamespaceUri;
    static final String ANDROID_XML_ATTRIBUTE_NAME = "name";
    static final String ANDROID_XML_ATTRIBUTE_TYPE = "type";
    static final String ANDROID_XML_ATTRIBUTE_ID = "id";
    static final String ANDROID_XML_NODE_NAME_PUBLIC = "public";
    private Listener mListener = null;
    private String mDescriptorFileName = null;
    private final Comparator<Attribute> ID_ORDER = new Comparator<Attribute>(){

        @Override
        public int compare(Attribute a, Attribute b3) {
            return a.compareTo(b3);
        }
    };

    public OrderManifestHandler(Listener listener, String descriptorFile) {
        this.mListener = listener;
        this.mDescriptorFileName = descriptorFile;
    }

    private static void PopulateResourceMapFromFile(String path) throws IOException {
        try {
            FileInputStream attrInfo = new FileInputStream(path);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document manifestDoc = docBuilder.parse(attrInfo);
            NodeList attributeList = manifestDoc.getElementsByTagName(ANDROID_XML_NODE_NAME_PUBLIC);
            int length = attributeList.getLength();
            for (int j2 = 0; j2 < length; ++j2) {
                String type;
                Element e2 = (Element)attributeList.item(j2);
                if (!e2.hasAttribute(ANDROID_XML_ATTRIBUTE_TYPE) || !(type = e2.getAttribute(ANDROID_XML_ATTRIBUTE_TYPE)).equals("attr") || !e2.hasAttribute(ANDROID_XML_ATTRIBUTE_NAME) || !e2.hasAttribute(ANDROID_XML_ATTRIBUTE_ID)) continue;
                String attributeName = e2.getAttribute(ANDROID_XML_ATTRIBUTE_NAME);
                String attributeId = e2.getAttribute(ANDROID_XML_ATTRIBUTE_ID);
                int index = attributeId.toLowerCase().indexOf(120);
                if (index != -1) {
                    attributeId = attributeId.substring(index + 1);
                }
                Integer id = new Integer(Integer.parseInt(attributeId, 16));
                mResourceMap.put(attributeName, id);
            }
            ((InputStream)attrInfo).close();
        }
        catch (Exception ex) {
            System.err.println("\"AIR_ANDROID_SDK_HOME\" environment variable might not be set properly \n");
            throw new IOException("Error in reading the file " + path);
        }
    }

    private static void PopulateResourceMapSelf() {
        mResourceMap.put("versionCode", 16843291);
        mResourceMap.put("versionName", 16843292);
        mResourceMap.put(ANDROID_XML_ATTRIBUTE_NAME, 0x1010003);
        mResourceMap.put("label", 0x1010001);
        mResourceMap.put("icon", 0x1010002);
        mResourceMap.put("theme", 0x1010000);
        mResourceMap.put("value", 16842788);
        mResourceMap.put("priority", 0x101001C);
        mResourceMap.put("minSdkVersion", 16843276);
        mResourceMap.put("maxSdkVersion", 16843377);
        mResourceMap.put("targetSdkVersion", 16843376);
        mResourceMap.put("glEsVersion", 16843393);
        mResourceMap.put("resource", 16842789);
        mResourceMap.put("launchMode", 0x101001D);
        mResourceMap.put("configChanges", 0x101001F);
        mResourceMap.put("screenOrientation", 0x101001E);
        mResourceMap.put("windowSoftInputMode", 16843307);
        mResourceMap.put("allowTaskReparenting", 16843268);
        mResourceMap.put("alwaysRetainTaskState", 16843267);
        mResourceMap.put("clearTaskOnLaunch", 0x1010015);
        mResourceMap.put("enabled", 0x101000E);
        mResourceMap.put("excludeFromRecents", 0x1010017);
        mResourceMap.put("exported", 0x1010010);
        mResourceMap.put("finishOnTaskLaunch", 0x1010014);
        mResourceMap.put("multiprocess", 0x1010013);
        mResourceMap.put("noHistory", 16843309);
        mResourceMap.put("permission", 0x1010006);
        mResourceMap.put("process", 0x1010011);
        mResourceMap.put("stateNotNeeded", 0x1010016);
        mResourceMap.put("taskAffinity", 0x1010012);
        mResourceMap.put("reqTouchScreen", 16843303);
        mResourceMap.put("reqFiveWayNav", 16843314);
        mResourceMap.put("reqHardKeyboard", 16843305);
        mResourceMap.put("reqKeyboardType", 16843304);
        mResourceMap.put("reqNavigation", 16843306);
        mResourceMap.put("required", 16843406);
        mResourceMap.put("smallScreens", 16843396);
        mResourceMap.put("normalScreens", 16843397);
        mResourceMap.put("largeScreens", 16843398);
        mResourceMap.put("anyDensity", 16843372);
        mResourceMap.put("description", 0x1010020);
        mResourceMap.put("permissionGroup", 0x101000A);
        mResourceMap.put("protectionLevel", 0x1010009);
        mResourceMap.put("path", 16842794);
        mResourceMap.put("pathPattern", 16842796);
        mResourceMap.put("pathPrefix", 16842795);
        mResourceMap.put("host", 16842792);
        mResourceMap.put("mimeType", 16842790);
        mResourceMap.put("port", 16842793);
        mResourceMap.put("scheme", 16842791);
        mResourceMap.put("sharedUserId", 0x101000B);
        mResourceMap.put("sharedUserLabel", 16843361);
        mResourceMap.put("installLocation", 16843447);
        mResourceMap.put("allowClearUserData", 0x1010005);
        mResourceMap.put("backupAgent", 16843391);
        mResourceMap.put("debuggable", 0x101000F);
        mResourceMap.put("hasCode", 0x101000C);
        mResourceMap.put("killAfterRestore", 16843420);
        mResourceMap.put("manageSpaceActivity", 0x1010004);
        mResourceMap.put("persistent", 0x101000D);
        mResourceMap.put("restoreAnyVersion", 16843450);
        mResourceMap.put("targetActivity", 0x1010202);
        mResourceMap.put("authorities", 0x1010018);
        mResourceMap.put("grantUriPermissions", 0x101001B);
        mResourceMap.put("initOrder", 0x101001A);
        mResourceMap.put("readPermission", 0x1010007);
        mResourceMap.put("syncable", 0x1010019);
        mResourceMap.put("writePermission", 0x1010008);
        mResourceMap.put("functionalTest", 16842787);
        mResourceMap.put("handleProfiling", 0x1010022);
        mResourceMap.put("targetPackage", 0x1010021);
        mResourceMap.put("vmSafeMode", 16843448);
        mResourceMap.put("logo", 16843454);
        mResourceMap.put("xlargeScreens", 16843455);
        mResourceMap.put("immersive", 16843456);
        mResourceMap.put("screenSize", 16843466);
        mResourceMap.put("screenDensity", 16843467);
    }

    public static void PopulateResourceMap(String dataPath) throws IOException {
        if (dataPath != null) {
            OrderManifestHandler.PopulateResourceMapFromFile(dataPath + "/res/values/public.xml");
        } else {
            OrderManifestHandler.PopulateResourceMapSelf();
        }
    }

    public void startDocument() throws SAXException {
        try {
            mOutputFile = new FileOutputStream(AndroidManifestXMLParser.mOrderedFilePath);
            mPrintStream = new PrintStream(mOutputFile);
            mPrintStream.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        mNamespacePrefix = prefix;
        mNamespaceUri = uri;
    }

    public void startElement(String uri, String localName, String rawName, Attributes attrs) throws SAXException {
        int i2;
        mPrintStream.print("<" + rawName + " ");
        if (rawName.equals("manifest")) {
            mPrintStream.println("xmlns:" + mNamespacePrefix + "=\"" + mNamespaceUri + "\"");
        }
        ArrayList<Attribute> attrArray = new ArrayList<Attribute>();
        for (i2 = 0; i2 < attrs.getLength(); ++i2) {
            if (attrs.getURI(i2).equals("")) {
                mPrintStream.println(attrs.getLocalName(i2) + "=\"" + attrs.getValue(i2) + "\"");
                continue;
            }
            Integer val = mResourceMap.get(attrs.getLocalName(i2));
            if (val == null) {
                this.mListener.message(new Message(400, "ERROR", this.mDescriptorFileName, -1, -1, new String[]{attrs.getLocalName(i2)}));
                continue;
            }
            attrArray.add(new Attribute(attrs.getLocalName(i2), attrs.getURI(i2), attrs.getValue(i2), mResourceMap.get(attrs.getLocalName(i2)).intValue()));
        }
        Collections.sort(attrArray, this.ID_ORDER);
        for (i2 = 0; i2 < attrArray.size(); ++i2) {
            mPrintStream.println("android:" + ((Attribute)attrArray.get((int)i2)).name + "=\"" + ((Attribute)attrArray.get((int)i2)).value + "\"");
        }
        mPrintStream.println(">");
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        mPrintStream.println("</" + rawName + ">");
    }

    public void endDocument() throws SAXException {
        mPrintStream.close();
        try {
            mOutputFile.close();
        }
        catch (Exception e2) {
            throw new SAXException(e2.getMessage());
        }
    }

    static {
        mResourceMap = new HashMap();
        mNamespacePrefix = null;
        mNamespaceUri = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Attribute
    implements Comparable<Attribute> {
        public long id;
        public String name;
        public String uri;
        public String value;

        public Attribute(String n2, String u2, String v2, long i2) {
            this.name = n2;
            this.value = v2;
            this.uri = u2;
            this.id = i2;
        }

        public boolean equals(Attribute o2) {
            return o2.id == this.id;
        }

        @Override
        public int compareTo(Attribute n2) {
            if (n2.id > this.id) {
                return -1;
            }
            if (n2.id < this.id) {
                return 1;
            }
            return 0;
        }
    }
}

