/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import com.adobe.air.ADTOutputStream;
import com.adobe.air.AIRCodeSigner;
import com.adobe.air.ApplicationDescriptor;
import com.adobe.ucf.CodeSigner;
import com.adobe.ucf.UCFOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.zip.ZipEntry;

public class AIROutputStream
extends ADTOutputStream {
    private UCFOutputStream.FileRecord hashFileRecord;
    private MessageDigest hashDigest;

    public AIROutputStream() {
        try {
            this.hashDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e2) {
            throw new RuntimeException("SHA-256 digest algorithm not available");
        }
    }

    public void addHashFile(String path) throws IOException {
        int size = this.hashDigest.getDigestLength();
        this.hashFileRecord = new UCFOutputStream.FileRecord(new Date());
        this.hashFileRecord.path = path;
        this.hashFileRecord.lfhOffset = this.raf.getFilePointer();
        this.hashFileRecord.size = size;
        this.hashFileRecord.compressedSize = size;
        this.hashFileRecord.permissions = DEFAULT_FILE_PERMISSONS;
        byte[] lfh = this.getLocalFileHeader(this.hashFileRecord);
        this.raf.write(lfh);
        this.raf.write(new byte[size]);
        this.files.add(this.hashFileRecord);
    }

    public void addApplicationDescriptor(ApplicationDescriptor descriptor, boolean sign) throws IOException {
        super.addApplicationDescriptor(descriptor, sign);
        this.addData(descriptor.getBytes(), "META-INF/AIR/application.xml", new Date(), sign, true);
    }

    public void addDebugFile(String path, boolean addToSignature) throws IOException {
        boolean SIZE = false;
        byte[] data = new byte[]{};
        UCFOutputStream.FileRecord record = new UCFOutputStream.FileRecord(new Date());
        record.path = path;
        this.addFile(record, new ByteArrayInputStream(data), addToSignature, false);
    }

    public void addDescriptorFromZipEntry(ZipEntry entry, InputStream data) throws IOException {
        this.addApplicationDescriptor(new ApplicationDescriptor(data), true);
        this.validateDescriptor();
    }

    protected void validateDescriptor() throws IOException {
        this.getApplicationDescriptor().validate(this.m_validationParams);
    }

    public void addIconFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.getApplicationDescriptor().validateIcon(data, entry.getName(), false);
        data.reset();
        this.addFileFromZipEntry(entry, data, permissions);
    }

    public void addInitialContentFromZipEntry(ZipEntry entry, InputStream data, long permissions) throws IOException {
        this.getApplicationDescriptor().validateInitialContent(data, true);
        data.reset();
        this.addFileFromZipEntry(entry, data, permissions);
    }

    protected void beforeClose() throws IOException {
        if (this.hashFileRecord != null) {
            byte[] digest = this.hashDigest.digest();
            this.crc.reset();
            this.crc.update(digest);
            this.hashFileRecord.crc32 = this.crc.getValue();
            this.raf.seek(this.hashFileRecord.lfhOffset);
            this.os.reset();
            this.os.writeLong(67324752L);
            this.writeCommonHeaderBlock(this.hashFileRecord);
            this.os.writeShort(this.getLFExtraFieldLength(this.hashFileRecord));
            this.os.writeString(this.hashFileRecord.path);
            this.writeLFExtraField(this.hashFileRecord);
            byte[] lfh = this.os.getBytes();
            this.raf.write(lfh);
            this.raf.write(digest);
        }
    }

    protected CodeSigner getCodeSigner() {
        AIRCodeSigner signer = new AIRCodeSigner();
        return signer;
    }

    public void finalizeSig() throws IOException, GeneralSecurityException {
        if (this.codeSigner != null) {
            if (!(this.codeSigner instanceof AIRCodeSigner)) {
                throw new IllegalStateException("Air code files must be signed with an instance of AirCodeSigner");
            }
            if (this.getApplicationDescriptor() != null) {
                ((AIRCodeSigner)this.codeSigner).setUsePackageSignatureForTimestamps(this.getApplicationDescriptor().usePackageSignatureForTimestamps());
            }
        }
        super.finalizeSig();
    }

    protected void processBytes(String path, byte[] bytes, int numBytes) {
        this.hashDigest.update(bytes, 0, numBytes);
    }
}

