/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.BuiltinDomain;
import adobe.abc.Expr;
import adobe.abc.Namespace;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import adobe.abc.Typeref;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeAnalysis {
    private static boolean isPointer(Type t2) {
        return !t2.isAtom() && !t2.numeric;
    }

    public static Object eval_convert_i(Object v0) {
        return v0 instanceof Number ? Integer.valueOf(TypeAnalysis.intValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : OptimizerConstants.BOTTOM));
    }

    public static Object eval_convert_u(Object v0) {
        return v0 instanceof Number ? Long.valueOf(TypeAnalysis.uintValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : OptimizerConstants.BOTTOM));
    }

    public static Object eval_convert_d(Object v0) {
        return v0 instanceof Number ? Double.valueOf(TypeAnalysis.doubleValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : OptimizerConstants.BOTTOM));
    }

    public static Object eval_convert_b(Object v0) {
        return v0 == OptimizerConstants.BOTTOM ? OptimizerConstants.BOTTOM : (TypeAnalysis.booleanValue(v0) ? Boolean.TRUE : Boolean.FALSE);
    }

    public static Object eval_convert_s(Object v0) {
        if (v0 == BuiltinDomain.instance().NULL()) {
            return "null";
        }
        return v0 != OptimizerConstants.BOTTOM ? TypeAnalysis.stringValue(v0) : OptimizerConstants.BOTTOM;
    }

    public static Typeref eval_coerce_s(Typeref t0) {
        if (t0.nullable) {
            return t0.t == BuiltinDomain.instance().VOID() || t0.t == BuiltinDomain.instance().NULL() ? BuiltinDomain.instance().NULL().ref : BuiltinDomain.instance().STRING().ref;
        }
        return BuiltinDomain.instance().STRING().ref.exactnonnull();
    }

    public static Object eval_coerce_s(Object v0) {
        return v0 == OptimizerConstants.UNDEFINED || v0 == BuiltinDomain.instance().NULL() ? BuiltinDomain.instance().NULL() : (v0 != OptimizerConstants.BOTTOM ? TypeAnalysis.stringValue(v0) : OptimizerConstants.BOTTOM);
    }

    public static Typeref eval_coerce_o(Typeref t0) {
        if (t0.nullable) {
            return t0.t.extendsOrIsBase(BuiltinDomain.instance().OBJECT()) ? t0 : (t0.t == BuiltinDomain.instance().VOID() || t0.t == BuiltinDomain.instance().NULL() ? BuiltinDomain.instance().NULL().ref : BuiltinDomain.instance().OBJECT().ref);
        }
        return t0.t.extendsOrIsBase(BuiltinDomain.instance().OBJECT()) ? t0 : BuiltinDomain.instance().OBJECT().ref.nonnull();
    }

    public static Object eval_coerce_o(Object v0, Type t0) {
        return t0.extendsOrIsBase(BuiltinDomain.instance().OBJECT()) ? v0 : (t0 == BuiltinDomain.instance().VOID() || t0 == BuiltinDomain.instance().NULL() ? BuiltinDomain.instance().NULL() : OptimizerConstants.BOTTOM);
    }

    public static Object lessthan(Object v0, Object v1) {
        if (v0 instanceof String && v1 instanceof String) {
            return ((String)v0).compareTo((String)v1) < 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        double dv0 = TypeAnalysis.doubleValue(v0);
        double dv1 = TypeAnalysis.doubleValue(v1);
        if (Double.isNaN(dv0) || Double.isNaN(dv1)) {
            return OptimizerConstants.UNDEFINED;
        }
        return dv0 < dv1 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Type type(Map<Expr, Typeref> types, Expr e2) {
        assert (types.containsKey(e2));
        return types.get((Object)e2).t;
    }

    public static int intValue(Object o2) {
        double ad2;
        double d2 = ((Number)o2).doubleValue();
        if (Double.isNaN(d2) || Double.isInfinite(d2) || d2 == 0.0) {
            return 0;
        }
        double d3 = ad2 = d2 < 0.0 ? Math.floor(-d2) : Math.floor(d2);
        if (ad2 > 4.294967295E9) {
            ad2 %= 4.294967296E9;
        }
        if (ad2 >= 2.147483648E9) {
            if (d2 < 0.0) {
                int intVal = (int)(ad2 - 2.147483648E9);
                return Integer.MIN_VALUE - intVal;
            }
            int intVal = (int)(ad2 - 2.147483648E9);
            return Integer.MIN_VALUE + intVal;
        }
        return (int)(d2 < 0.0 ? -ad2 : ad2);
    }

    public static long uintValue(Object o2) {
        return ((Number)o2).longValue() & 0xFFFFFFFFL;
    }

    public static double doubleValue(Object o2) {
        if (o2 instanceof Boolean) {
            return o2 == Boolean.TRUE ? 1.0 : 0.0;
        }
        if (o2 instanceof Number) {
            return ((Number)o2).doubleValue();
        }
        if (o2 == BuiltinDomain.instance().NULL()) {
            return 0.0;
        }
        return Double.NaN;
    }

    public static boolean booleanValue(Object o2) {
        if (o2 instanceof Boolean) {
            return o2 == Boolean.TRUE;
        }
        if (o2 instanceof Namespace) {
            return true;
        }
        if (o2 instanceof String) {
            return ((String)o2).length() > 0;
        }
        if (o2 == BuiltinDomain.instance().NULL() || o2 == OptimizerConstants.UNDEFINED) {
            return false;
        }
        return TypeAnalysis.doubleValue(o2) != 0.0;
    }

    public static String stringValue(Object v0) {
        if (v0 instanceof Number) {
            System.err.println("ERROR: formatting double using non-ecmascript rules.");
        }
        return String.valueOf(v0);
    }

    public static Typeref mdb(Typeref a, Typeref b3) {
        assert (a != b3 && a != null && b3 != null);
        if (a.t == BuiltinDomain.instance().NULL() && TypeAnalysis.isPointer(b3.t)) {
            return b3;
        }
        if (b3.t == BuiltinDomain.instance().NULL() && TypeAnalysis.isPointer(a.t)) {
            return a;
        }
        HashSet<Type> bases = new HashSet<Type>();
        Type t2 = a.t;
        while (t2 != null) {
            bases.add(t2);
            t2 = t2.base;
        }
        t2 = b3.t;
        while (t2 != null) {
            if (bases.contains(t2)) {
                return new Typeref(t2, a.nullable | b3.nullable);
            }
            t2 = t2.base;
        }
        return new Typeref(BuiltinDomain.instance().ANY(), a.nullable | b3.nullable);
    }
}

