/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Domain;
import adobe.abc.GlobalOptimizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import macromedia.asc.util.APIVersions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Namespace
implements Comparable<Namespace> {
    final int kind;
    final String uri;
    private int api;
    private String comparableUri;
    private static ArrayList<Namespace> m_namespaces;
    private static final int NO_API = 0;
    private static final int MIN_API_MARK = 57344;
    private static final int LOWEST_API;
    private static final int HIGHEST_API;

    Namespace(int kind, String uri, int api) {
        this.kind = kind;
        this.api = api;
        this.uri = uri == null ? "" : uri;
        this.comparableUri = this.isPrivate() ? GlobalOptimizer.unique() : uri;
    }

    private Namespace(int kind, String uri, Domain domain) {
        this(kind, uri, 0);
        this.api = 0;
        if (Namespace.isPublicKind(kind)) {
            this.api = Namespace.getAPI(uri);
            if (this.api == 0) {
                this.api = domain.api;
            } else {
                this.comparableUri = this.comparableUri.substring(0, this.comparableUri.length() - 1);
            }
            if (this.uri.length() > 0 && Arrays.binarySearch(APIVersions.uris, this.comparableUri) < 0) {
                this.api = 0;
            }
        } else assert (Namespace.getAPI(this.uri) == 0);
    }

    public int getAPI() {
        return this.api;
    }

    static int getAPI(String uri) {
        char lastc;
        if (uri != null && uri.length() > 0 && (lastc = uri.charAt(uri.length() - 1)) >= LOWEST_API && lastc <= HIGHEST_API) {
            return Namespace.toAPI(lastc - 57344);
        }
        return 0;
    }

    public static int toAPI(int value) {
        return 1 << value - APIVersions.min_version_num;
    }

    public static int getCompatibleAPIs(int api) {
        int result = 0;
        if (api != 0) {
            switch (api) {
                case 1: {
                    result = 0;
                    break;
                }
                case 2: {
                    result = 1;
                    break;
                }
                case 4: {
                    result = 2;
                    break;
                }
                case 8: {
                    result = 3;
                    break;
                }
                case 16: {
                    result = 4;
                    break;
                }
                case 32: {
                    result = 5;
                    break;
                }
                case 64: {
                    result = 6;
                    break;
                }
                case 128: {
                    result = 7;
                    break;
                }
                case 256: {
                    result = 8;
                    break;
                }
                case 512: {
                    result = 9;
                    break;
                }
                case 1024: {
                    result = 10;
                    break;
                }
                case 2048: {
                    result = 11;
                    break;
                }
                case 4096: {
                    result = 12;
                    break;
                }
                case 8192: {
                    result = 13;
                    break;
                }
                case 16384: {
                    result = 14;
                    break;
                }
                case 32768: {
                    result = 15;
                    break;
                }
                case 65536: {
                    result = 16;
                    break;
                }
                case 131072: {
                    result = 17;
                    break;
                }
                case 262144: {
                    result = 18;
                    break;
                }
                case 524288: {
                    result = 19;
                    break;
                }
                case 0x100000: {
                    result = 20;
                    break;
                }
                case 0x200000: {
                    result = 21;
                    break;
                }
                case 0x400000: {
                    result = 22;
                    break;
                }
                case 0x800000: {
                    result = 23;
                    break;
                }
                case 0x1000000: {
                    result = 24;
                    break;
                }
                case 0x2000000: {
                    result = 25;
                    break;
                }
                case 0x4000000: {
                    result = 26;
                    break;
                }
                case 0x8000000: {
                    result = 27;
                    break;
                }
                case 0x10000000: {
                    result = 28;
                    break;
                }
                case 0x20000000: {
                    result = 29;
                    break;
                }
                case 0x40000000: {
                    result = 30;
                    break;
                }
                case -2147483648: {
                    result = 31;
                    break;
                }
                default: {
                    System.out.println("unknown api number: " + api);
                    assert (false);
                    break;
                }
            }
            result = APIVersions.api_compat[result];
        }
        return result;
    }

    boolean isPublic() {
        return this.kind == 8 || this.kind == 22;
    }

    boolean isInternal() {
        return this.kind == 23;
    }

    boolean isPrivate() {
        return this.kind == 5;
    }

    boolean isPrivateOrInternal() {
        return this.isPrivate() || this.isInternal();
    }

    boolean isProtected() {
        return this.kind == 24 || this.kind == 26;
    }

    boolean isVersioned() {
        return this.api > 0 && this.isPublic();
    }

    public String toString() {
        return this.uri.length() > 0 ? this.uri : "public";
    }

    public int hashCode() {
        return this.kind ^ this.uri.hashCode();
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace)o2;
        return this.kind == other.kind && this.comparableUri.equals(other.comparableUri);
    }

    @Override
    public int compareTo(Namespace other) {
        if (other == null) {
            return 1;
        }
        int i2 = this.kind - other.kind;
        if (i2 != 0) {
            return i2;
        }
        return this.comparableUri.compareTo(other.comparableUri);
    }

    public static int compareTo(Namespace a, Namespace b3) {
        if (a == null && b3 == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        return a.compareTo(b3);
    }

    public static boolean isPublicKind(int kind) {
        return kind == 8 || kind == 22;
    }

    public static Namespace findNamespace(int kind, String uri, int api) {
        Namespace result = null;
        ArrayList<Namespace> namespaces = Namespace.getNamespaces();
        boolean found = false;
        Iterator<Namespace> nsi = namespaces.iterator();
        while (!found && nsi.hasNext()) {
            result = nsi.next();
            found = result.kind == kind && result.comparableUri.equals(uri) && result.api == api;
        }
        return found ? result : null;
    }

    public static Namespace getNamespaceFromVersionedURI(int kind, String uri, Domain domain) {
        Namespace result = new Namespace(kind, uri, domain);
        if (Namespace.findNamespace(result.kind, result.uri, result.api) == null) {
            Namespace.getNamespaces().add(result);
        }
        return result;
    }

    public static Namespace getVersionedNamespace(int kind, String uri, int api) {
        Namespace result = Namespace.findNamespace(kind, uri, api);
        if (result == null) {
            result = Namespace.createNamespace(kind, uri, api);
        }
        return result;
    }

    public static Namespace getVersionedNamespace(Namespace ns, int api) {
        Namespace result = ns;
        if (!result.isVersioned()) {
            return result;
        }
        result = Namespace.findNamespace(ns.kind, ns.comparableUri, api);
        if (result == null) {
            result = Namespace.createNamespace(ns.kind, ns.comparableUri, api);
        }
        return result;
    }

    private static Namespace createNamespace(int kind, String uri, int api) {
        Namespace result = new Namespace(kind, uri, api);
        Namespace.getNamespaces().add(result);
        return result;
    }

    private static ArrayList<Namespace> getNamespaces() {
        if (m_namespaces == null) {
            m_namespaces = new ArrayList();
        }
        return m_namespaces;
    }

    static {
        LOWEST_API = 57344 + APIVersions.min_version_num;
        HIGHEST_API = 57344 + APIVersions.max_version_num + 1;
    }
}

