/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.LLVMEmitter;
import adobe.abc.LLVMTypeExtractor;
import adobe.abc.Pair;
import java.lang.reflect.Field;
import java.util.Map;
import llvm.CompositeType;
import llvm.DerivedType;
import llvm.GlobalVariable;
import llvm.PointerType;
import llvm.SequentialType;
import llvm.StructType;
import llvm.Type;

class LLVMStubTypes {
    private static final String s_typesStructGlobal = "abcTypes";
    public Type ExceptionFrameTy;
    public PointerType ExceptionFramePtrTy;
    public Type CallStackNodeTy;
    public PointerType CallStackNodePtrTy;
    public Type AtomTy;
    public Type AtomPtrTy;
    public Type BooleanTy;
    public Type intTy;
    public PointerType intPtrTy;
    public Type uintTy;
    public Type uintPtrTy;
    public PointerType MethodEnvPtrTy;
    public PointerType AbcEnvPtrTy;
    public PointerType MultinamePtrTy;
    public PointerType MultinamePtrMaybeIntTy;
    public Type MultinameIndexTy;
    public Type MultinameIndexMaybeIntTy;
    public Type NumberTy;
    public Type NumberPtrTy;
    public StructType ScriptObjectTy;
    public PointerType ScriptObjectPtrTy;
    public PointerType ArrayObjectPtrTy;
    public PointerType QNameObjectPtrTy;
    public PointerType StringPtrTy;
    public PointerType NamespacePtrTy;
    public Type NamespaceIdTy;
    public PointerType CompiledHandlerPtrTy;
    public PointerType InterfaceBindingFunctionPtrTy;
    public Type voidTy;
    public PointerType TraitsPtrTy;
    public PointerType TraitsIdTy;
    public PointerType TraitsIdPtrTy;
    public StructType AOTInfoTy;
    public Type UnsedParamTy;
    public StructType MethodDebugInfoTy;
    public PointerType charPtrTy;
    public StructType WrappedHandlerTy;
    public PointerType WrappedHandlerPtrTy;
    public StructType AOTMethodFrameTy;
    public PointerType AOTMethodFramePtrTy;
    public StructType AOTLazyEvalInfoTy;
    public PointerType AOTLazyEvalInfoPtrTy;
    public StructType ScriptObjectWBTy;
    public StructType AtomWBTy;
    public StructType StringWBTy;
    public StructType NamespaceWBTy;
    public StructType AOTActivationInfoTy;
    public PointerType DoubleVectorObjectPtrTy;
    public PointerType IntVectorObjectPtrTy;
    public PointerType UIntVectorObjectPtrTy;
    public PointerType ObjectVectorObjectPtrTy;

    private LLVMStubTypes() {
    }

    public static LLVMStubTypes extract(LLVMEmitter.Module m2) {
        LLVMStubTypes result = new LLVMStubTypes();
        GlobalVariable abcTypesGlobal = m2.getGlobal(s_typesStructGlobal, true);
        if (abcTypesGlobal == null) {
            return null;
        }
        Map<String, Field> fields = LLVMEmitter.publicFieldsMap(LLVMStubTypes.class);
        LLVMTypeExtractor typeExtractor = new LLVMTypeExtractor(abcTypesGlobal);
        for (Pair<String, Pair<PointerType, Type>> pt : typeExtractor) {
            String typeName = (String)pt.fst;
            String typeFieldName = typeName + "Ty";
            String ptrTypeFieldName = typeName + "PtrTy";
            Field fieldForType = fields.get(typeFieldName);
            Field fieldForPtrType = fields.get(ptrTypeFieldName);
            if (fieldForType == null && fieldForPtrType == null) continue;
            PointerType ptrType = (PointerType)((Pair)pt.snd).fst;
            assert (ptrType != null);
            try {
                if (fieldForPtrType != null) {
                    fieldForPtrType.set(result, ptrType);
                }
                if (fieldForType == null) continue;
                Type type = (Type)((Pair)pt.snd).snd;
                if (fieldForType.getType() == PointerType.class) {
                    PointerType fieldAsPtrType = PointerType.dyn_cast(SequentialType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast(type))));
                    if (fieldAsPtrType == null) {
                        throw new Error("Unable to cast " + typeName + " to a PointerType");
                    }
                    fieldForType.set(result, fieldAsPtrType);
                    continue;
                }
                if (fieldForType.getType() == StructType.class) {
                    StructType structType = StructType.dyn_cast(CompositeType.dyn_cast(DerivedType.dyn_cast(type)));
                    if (structType == null) {
                        throw new Error("Unable to cast " + typeName + " to a StructType");
                    }
                    fieldForType.set(result, structType);
                    continue;
                }
                fieldForType.set(result, type);
            }
            catch (IllegalArgumentException e2) {
            }
            catch (IllegalAccessException e3) {}
        }
        result.voidTy = m2.getVoidTy();
        return result;
    }

    public static boolean removeFromModule(LLVMEmitter.Module m2) {
        GlobalVariable abcTypesGlobal = m2.getGlobal(s_typesStructGlobal, true);
        if (abcTypesGlobal == null) {
            return false;
        }
        abcTypesGlobal.eraseFromParent();
        return true;
    }

    public static long getCPtr(Type a) {
        try {
            Field f2 = Type.class.getDeclaredField("swigCPtr");
            f2.setAccessible(true);
            if (a != null) {
                return (Long)f2.get(a);
            }
            return 0L;
        }
        catch (Throwable e2) {
            System.err.println(e2);
            return 0L;
        }
    }

    public static boolean compareTypes(Type a, Type b3) {
        return a == b3 || LLVMStubTypes.getCPtr(a) == LLVMStubTypes.getCPtr(b3);
    }
}

