/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import adobe.abc.Domain;
import adobe.abc.Name;
import adobe.abc.Namespace;
import adobe.abc.Nsset;
import adobe.abc.OptimizerConstants;
import adobe.abc.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class BuiltinDomain
extends Domain {
    private Type OBJECT;
    private Type FUNCTION;
    private Type CLASS;
    private Type ARRAY;
    private Type INT;
    private Type UINT;
    private Type NUMBER;
    private Type BOOLEAN;
    private Type STRING;
    private Type NAMESPACE;
    private Type XML;
    private Type XMLLIST;
    private Type QNAME;
    private Type NULL;
    private Type VOID;
    private Type ANY;
    private ArrayList<Type> defaultValueFixups = new ArrayList();
    public Set<Type> builtinTypes = new HashSet<Type>();
    public Set<Type> baseTypes = new HashSet<Type>();
    private static final BuiltinDomain the_instance = new BuiltinDomain();

    public static BuiltinDomain instance() {
        return the_instance;
    }

    public Type ANY() {
        if (this.ANY == null) {
            this.ANY = new Type(Name.ANY(this.PUBLIC), null);
            this.ANY.defaultValue = OptimizerConstants.UNDEFINED;
            this.ANY.atom = true;
        }
        return this.ANY;
    }

    public void addNamedType(Type t2) {
        super.addNamedType(t2);
        String typeName = t2.getName().name;
        if (this.OBJECT == null && typeName.equals("Object")) {
            Type tt = this.OBJECT();
            assert (tt != null);
        } else if (this.CLASS == null && typeName.equals("Class")) {
            Type tt = this.CLASS();
            assert (tt != null);
        } else if (this.FUNCTION == null && typeName.equals("Function")) {
            Type tt = this.FUNCTION();
            assert (tt != null);
        } else if (this.ARRAY == null && typeName.equals("Array")) {
            Type tt = this.ARRAY();
            assert (tt != null);
        } else if (this.INT == null && typeName.equals("int")) {
            Type tt = this.INT();
            assert (tt != null);
        } else if (this.UINT == null && typeName.equals("uint")) {
            Type tt = this.UINT();
            assert (tt != null);
        } else if (this.NUMBER == null && typeName.equals("Number")) {
            Type tt = this.NUMBER();
            assert (tt != null);
        } else if (this.BOOLEAN == null && typeName.equals("Boolean")) {
            Type tt = this.BOOLEAN();
            assert (tt != null);
        } else if (this.STRING == null && typeName.equals("String")) {
            Type tt = this.STRING();
            assert (tt != null);
        } else if (this.NAMESPACE == null && typeName.equals("Namespace")) {
            Type tt = this.NAMESPACE();
            assert (tt != null);
        } else if (this.XML == null && typeName.equals("XML")) {
            Type tt = this.XML();
            assert (tt != null);
        } else if (this.XMLLIST == null && typeName.equals("XMLList")) {
            Type tt = this.XMLLIST();
            assert (tt != null);
        } else if (this.QNAME == null && typeName.equals("QName")) {
            Type tt = this.QNAME();
            assert (tt != null);
        }
    }

    private Type resolveBuiltin(String name) {
        Name n2 = new Name(this.PUBLIC_PACKAGE(), name);
        return this.resolveTypeName(n2, this.OBJECT());
    }

    public void enabledFailedLookupExceptions() {
        this.m_throwOnFailedLookup = true;
    }

    public boolean isXmlBase(Type t2) {
        return t2.extendsOrIsBase(this.XML()) || t2.extendsOrIsBase(this.XMLLIST()) || t2 == this.ANY() || t2 == this.OBJECT();
    }

    public Type FUNCTION() {
        if (this.FUNCTION == null) {
            this.FUNCTION = this.resolveBuiltin("Function");
            this.builtinTypes.add(this.FUNCTION);
        }
        return this.FUNCTION;
    }

    public Type OBJECT() {
        if (this.OBJECT == null) {
            Name obj = new Name(this.PUBLIC_PACKAGE(), "Object");
            this.OBJECT = this.getNamedType(obj, false);
            Type tt = this.NULL();
            assert (tt != null);
            tt = this.VOID();
            assert (tt != null);
            assert (this.resolveBuiltin("Object") == this.OBJECT);
            this.OBJECT.atom = true;
            this.builtinTypes.add(this.OBJECT);
        }
        return this.OBJECT;
    }

    public Type CLASS() {
        if (this.CLASS == null) {
            assert (this.OBJECT() != null);
            this.CLASS = this.resolveBuiltin("Class");
            this.builtinTypes.add(this.CLASS);
        }
        return this.CLASS;
    }

    public Type ARRAY() {
        if (this.ARRAY == null) {
            this.ARRAY = this.resolveBuiltin("Array");
            this.builtinTypes.add(this.ARRAY);
        }
        return this.ARRAY;
    }

    public Type INT() {
        if (this.INT == null) {
            this.INT = this.resolveBuiltin("int");
            this.INT.numeric = true;
            this.INT.primitive = true;
            this.INT.ref = this.INT.ref.nonnull();
            this.INT.defaultValue = 0;
            this.builtinTypes.add(this.INT);
        }
        return this.INT;
    }

    public Type UINT() {
        if (this.UINT == null) {
            this.UINT = this.resolveBuiltin("uint");
            this.UINT.numeric = true;
            this.UINT.primitive = true;
            this.UINT.ref = this.UINT.ref.nonnull();
            this.UINT.defaultValue = 0;
            this.builtinTypes.add(this.UINT);
        }
        return this.UINT;
    }

    public Type NUMBER() {
        if (this.NUMBER == null) {
            this.NUMBER = this.resolveBuiltin("Number");
            this.NUMBER.numeric = true;
            this.NUMBER.primitive = true;
            this.NUMBER.ref = this.NUMBER.ref.nonnull();
            this.NUMBER.defaultValue = OptimizerConstants.NAN;
            this.builtinTypes.add(this.NUMBER);
        }
        return this.NUMBER;
    }

    public Type BOOLEAN() {
        if (this.BOOLEAN == null) {
            this.BOOLEAN = this.resolveBuiltin("Boolean");
            this.BOOLEAN.numeric = true;
            this.BOOLEAN.primitive = true;
            this.BOOLEAN.ref = this.BOOLEAN.ref.nonnull();
            this.BOOLEAN.defaultValue = Boolean.FALSE;
            this.builtinTypes.add(this.BOOLEAN);
        }
        return this.BOOLEAN;
    }

    public Type STRING() {
        if (this.STRING == null) {
            this.STRING = this.resolveBuiltin("String");
            this.STRING.primitive = true;
            this.STRING.defaultValue = this.NULL();
            this.builtinTypes.add(this.STRING);
        }
        return this.STRING;
    }

    public Type NAMESPACE() {
        if (this.NAMESPACE == null) {
            this.NAMESPACE = this.resolveBuiltin("Namespace");
            this.NAMESPACE.defaultValue = this.NULL();
            this.builtinTypes.add(this.NAMESPACE);
        }
        return this.NAMESPACE;
    }

    public Type XML() {
        if (this.XML == null) {
            this.XML = this.resolveBuiltin("XML");
            this.builtinTypes.add(this.XML);
        }
        return this.XML;
    }

    public Type XMLLIST() {
        if (this.XMLLIST == null) {
            this.XMLLIST = this.resolveBuiltin("XMLList");
            this.builtinTypes.add(this.XMLLIST);
        }
        return this.XMLLIST;
    }

    public Type QNAME() {
        if (this.QNAME == null) {
            this.QNAME = this.resolveBuiltin("QName");
            this.builtinTypes.add(this.QNAME);
        }
        return this.QNAME;
    }

    public Type NULL() {
        if (this.NULL == null) {
            assert (this.OBJECT != null);
            Name nameForNULL = new Name(this.PUBLIC_PACKAGE(), "null");
            this.NULL = new Type.StringValueIsName(nameForNULL, this.OBJECT);
            this.NULL.primitive = true;
            for (Type e2 : this.defaultValueFixups) {
                if (e2.defaultValue != null) continue;
                e2.defaultValue = this.NULL;
            }
            this.defaultValueFixups.clear();
            super.addNamedType(this.NULL);
            assert (this.resolveBuiltin("null") == this.NULL);
        }
        return this.NULL;
    }

    public Type VOID() {
        if (this.VOID == null) {
            assert (this.NULL != null);
            Namespace[] pns = new Namespace[]{new Namespace(22, "", 1)};
            Nsset nsset = new Nsset(pns);
            Name nameForVOID = new Name(7, "void", nsset);
            this.VOID = new Type(nameForVOID, null);
            this.VOID.defaultValue = this.NULL;
            this.VOID.primitive = true;
            this.VOID.atom = true;
            super.addNamedType(this.VOID);
            assert (this.resolveBuiltin("void") == this.VOID);
            this.builtinTypes.add(this.VOID);
        }
        return this.VOID;
    }

    public void assignNullDefaultValue(Type e2) {
        if (this.NULL == null) {
            this.defaultValueFixups.add(e2);
        } else {
            e2.defaultValue = this.NULL;
        }
    }
}

