#include <ccls.h>
#include <fx.h>
using namespace FX;

#include "cclfox.h"
#include "CashingFrame.h"
#include "NotpaidFrame.h"
#include "CCLWin.h"

FXDEFMAP(CashingFrame) CashingFrameMap[] =
{
  FXMAPFUNC(SEL_COMMAND,CashingFrame::ID_CASH,CashingFrame::onCash),
  FXMAPFUNC(SEL_COMMAND,CashingFrame::ID_CANCEL,CashingFrame::onCancel),
  FXMAPFUNC(SEL_COMMAND,CashingFrame::ID_EDITMEMBER,CashingFrame::onEditMember),
  FXMAPFUNC(SEL_COMMAND,CashingFrame::ID_EDITPRICE,CashingFrame::onEditPrice)
};

FXIMPLEMENT(CashingFrame,FXVerticalFrame,CashingFrameMap,
	    ARRAYNUMBER(CashingFrameMap))

extern CCLWin *mainwin;
extern NotpaidFrame *notpaidframe;

CashingFrame::CashingFrame(FXComposite * parent)
:FXVerticalFrame(parent,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN,
		0,0,0,0,0,0,0,0,0,0)
{
  FXHorizontalFrame *hframe1 =
    new FXHorizontalFrame(this,LAYOUT_FILL_X,0,0,0,0,4,4,0,0,5,0);
  new FXLabel(hframe1,_("Client:"));
  clientname = new FXLabel(hframe1,"");
  editmember = new FXButton(hframe1,_("Edit"),NULL,this,ID_EDITMEMBER,
			    LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK);

  FXHorizontalFrame *hframe2 =
    new FXHorizontalFrame(this,LAYOUT_FILL_X,0,0,0,0,4,4,0,0,5,0);
  new FXLabel(hframe2,_("Workstation usage:"));
  timeprice = new FX7Segment(hframe2,"-.--",FRAME_SUNKEN);
  timeprice->setCellHeight(14);
  timeprice->setCellWidth(10);
  timeprice->setTextColor(FXRGB(255,50,50));
  timeprice->setBackColor(FXRGB(0,0,0));
  editprice = new FXButton(hframe2,_("Edit"),NULL,this,ID_EDITPRICE,
			   LAYOUT_RIGHT|FRAME_RAISED|FRAME_THICK);
  
  FXHorizontalFrame *hframe3 =
    new FXHorizontalFrame(this,LAYOUT_FILL_X,0,0,0,0,4,4,0,0,5,0);
  new FXLabel(hframe3,_("Products:"));
  productsprice = new FX7Segment(hframe3,"-.--",FRAME_SUNKEN);
  productsprice->setCellHeight(14);
  productsprice->setCellWidth(10);
  productsprice->setTextColor(FXRGB(255,50,50));
  productsprice->setBackColor(FXRGB(0,0,0));

  FXVerticalFrame *listframe =
    new FXVerticalFrame(this,FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_FILL_Y,
			0,0,0,0,0,0,0,0);
  clprodlist = new FXFoldingList(listframe,NULL,0,
				 FOLDINGLIST_SINGLESELECT|LAYOUT_FILL_X|
				 LAYOUT_FILL_Y);
  clprodlist->appendHeader(_("Name"),NULL,160);
  clprodlist->appendHeader(_("Amount"),NULL,60);
  clprodlist->appendHeader(_("Price"),NULL,60);
  new FXLabel(this,_("Time intervals:"));

  FXVerticalFrame *intervalsframe =
    new FXVerticalFrame(this,FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_FILL_Y,
			0,0,0,0,0,0,0,0);
  timeintervals = new FXFoldingList(intervalsframe,NULL,0,
				    FOLDINGLIST_SINGLESELECT|LAYOUT_FILL_X|
				    LAYOUT_FILL_Y);
  timeintervals->appendHeader(_("Start"),NULL,210);
  timeintervals->appendHeader(_("Time"),NULL,60);

  FXHorizontalFrame *hframe4 =
    new FXHorizontalFrame(this,LAYOUT_FILL_X,0,0,0,0,4,4,0,0,5,0);
  new FXLabel(hframe4,_("Overall time:"));
  totaltime = new FX7Segment(hframe4,"--:--",FRAME_SUNKEN);
  totaltime->setCellHeight(14);
  totaltime->setCellWidth(10);
  totaltime->setTextColor(FXRGB(230,230,230));
  totaltime->setBackColor(FXRGB(0,0,0));

  FXHorizontalFrame *hframe5 =
    new FXHorizontalFrame(this,LAYOUT_FILL_X,0,0,0,0,4,4,0,0,5,0);
  new FXLabel(hframe5,_("Overall price:"));
  totalprice = new FX7Segment(hframe5,"-.--",FRAME_SUNKEN);
  totalprice->setCellHeight(14);
  totalprice->setCellWidth(10);
  totalprice->setTextColor(FXRGB(50,255,50));
  totalprice->setBackColor(FXRGB(0,0,0));
  new FXHorizontalSeparator(this);

  FXHorizontalFrame *hframe6 = new FXHorizontalFrame(this,LAYOUT_FILL_X);
  okbutton = new FXButton(hframe6,_("Cash"),NULL,this,ID_CASH,
			  FRAME_RAISED|FRAME_THICK);
  cancelbutton = new FXButton(hframe6,_("Log as cancelled"),NULL,this,
			      ID_CANCEL,FRAME_RAISED|FRAME_THICK);
  clear();
}

CashingFrame::~CashingFrame()
{
}

void
CashingFrame::create()
{
  FXVerticalFrame::create();
}

int CashingFrame::getSession()
{
  return csession;
}

void
CashingFrame::setSession(int session,FXbool forcashing)
{
  CCL_log_search_rules sr;
  CCL_log_session_entry *se = NULL;
  int num = 0;

  sr.session = csession = session;
  sr.rulemask = SR_SESSION;
  num = CCL_log_sessions_get(&sr,&se);
  clear();
  if (num < 1)
    return;

  csession = session;
  cprice = se[0].price;
  cclient = se[0].client;
  cmember = se[0].member;

  char buf[256];
  int time = se[0].time;
  double owed_terminal = cprice / 100.0;
  double owed_products = 0.0;
  const char *cname = CCL_client_name_get(cclient);
  const char *mname = CCL_member_exists(se[0].member)
			? CCL_member_name_get(se[0].member) : NULL;

  clientname->setText(cname);
  if (mname)
    clientname->setText(clientname->getText() + ":" + mname);
  snprintf(buf,64,"%.2d:%.2d:%.2d",
	   time / 3600,(time % 3600) / 60,(time % 3600) % 60);
  totaltime->setText(buf);

  // Fill Products List
  char *category;
  char *name;
  int id;
  FXuint amount;
  CCL_log_product_entry *pe = NULL;

  sr.rulemask = SR_SESSION;
  sr.session = session;
  num = CCL_log_products_get(&sr,&pe);

  for (int i = 0; i < num; i++) {
    owed_products += pe[i].price / 100.0;
    if (CCL_product_info_get(pe[i].product,&category,&name,NULL)) {
      snprintf(buf,256,"%s::%s\t%u\t%.2f",category,name,
	       pe[i].amount,pe[i].price / 100.0);
      clprodlist->prependItem(NULL,buf,NULL,NULL,NULL);
      CCL_free(category);
      CCL_free(name);
    }
  }
  CCL_free(pe);
  cpprice = (FXuint) (owed_products * 100);

  snprintf(buf,64,"%.2f",owed_terminal);
  timeprice->setText(buf);
  snprintf(buf,64,"%.2f",owed_products);
  productsprice->setText(buf);
  snprintf(buf,64,"%.2f",owed_terminal + owed_products);
  totalprice->setText(buf);

  // Fill Intervals List
  time_t *intervals = NULL;
  int inum = CCL_log_session_intervals_get(csession,&intervals);

  for (int i = 0; i < inum; i++) {
    time_t stime = intervals[i * 2];
    time_t etime = intervals[i * 2 + 1];
    char ststr[64];

    strftime(ststr,64,"%H:%M:%S -- %d/%m/%Y",localtime(&stime));
    snprintf(buf,256,"%s\t%.2d:%.2d:%.2d",ststr,(etime - stime) / 3600,
	     ((etime - stime) % 3600) / 60,((etime - stime) % 3600) % 60);
    timeintervals->prependItem(NULL,buf,NULL,NULL,NULL);
  }
  CCL_free(intervals);
  // Enable buttons
  if (forcashing) {
    okbutton->enable();
    cancelbutton->enable();
    editmember->enable();
    editprice->enable();
  }
  CCL_free(se);
}

void
CashingFrame::clear()
{
  csession = -1;
  cprice = 0;
  cpprice = 0;
  clientname->setText("-----");
  timeprice->setText("-.--");
  productsprice->setText("-.--");
  totalprice->setText("-.--");
  clprodlist->clearItems();
  timeintervals->clearItems();
  totaltime->setText("--:--");
  okbutton->disable();
  cancelbutton->disable();
  editmember->disable();
  editprice->disable();
}

long
CashingFrame::onCash(FXObject*,FXSelector,void*)
{
  if (csession != -1) {
    CCL_client_flags_toggle(cclient,USERSTOP,FALSE);
    mainwin->updateClientIcon(cclient);
    CCL_log_session_set_paid(csession,PAID,cprice);
    notpaidframe->readNotPaid();
  }

  clear();

  return 1;
}

long
CashingFrame::onCancel(FXObject*,FXSelector,void*)
{
  if (csession != -1) {
    CCL_client_flags_toggle(cclient,USERSTOP,FALSE);
    mainwin->updateClientIcon(cclient);
    CCL_log_session_set_paid(csession,CANCELED,cprice);
    notpaidframe->readNotPaid();
  }

  clear();

  return 1;
}

long
CashingFrame::onEditMember(FXObject*,FXSelector,void*)
{
  if (csession != -1) {
    int newmember = cmember;

    if (FXInputDialog::getInteger(newmember,this,_("Change member"),
				  _("Insert the member ID (0 for none):"),
				  NULL,0,999999)
	&& (CCL_member_exists(newmember) || newmember == 0)) {
      char buf[256];

      cmember = newmember;
      if (newmember == 0)
	snprintf(buf,256,"%s",CCL_client_name_get(cclient));
      else
	snprintf(buf,256,"%s:%s",CCL_client_name_get(cclient),
		 CCL_member_name_get(newmember));
      clientname->setText(buf);

      // Recalculate the price
      int oldtarif = -1;
      int perminafter = CCL_perminafter_get();
      int permin;
      time_t totaltime = 0;
      time_t *intervals = NULL;
      int inum = CCL_log_session_intervals_get(csession,&intervals);
      FXuint newprice = 0;

      if (newmember != 0 && 0 != CCL_member_tarif_get(newmember)) {
	oldtarif = CCL_tarif_get();
	CCL_tarif_set(CCL_member_tarif_get(newmember));
      }
     
      // Sum the time
      for (int i = 0; i < inum; i++)
	totaltime = intervals[i * 2 + 1] - intervals[i * 2];
      
      permin = ((totaltime / 60) >= perminafter && perminafter != -1);
      
      // Calculate it
      for (int i = 0; i < inum; i++) {
	int stime = intervals[i * 2];
	int etime = intervals[i * 2 + 1];
	double frac;

	if (!permin)
	  frac = (etime - stime) / (double) totaltime;
	else
	  frac = 1.0;
	newprice += (int) (CCL_tarif_calc(stime, etime, permin) * frac);
      }
      
      CCL_free(intervals);

      // Restore the old tarif
      if (1 <= oldtarif)
	CCL_tarif_set(oldtarif);

      // Save it
      CCL_log_session_set_paid(csession,NOTPAID,newprice);
      CCL_log_session_set_member(csession,newmember);
      notpaidframe->readNotPaid();
      setSession(csession);
    }
  }

  return 1;
}

long
CashingFrame::onEditPrice(FXObject*,FXSelector,void*)
{
  if (csession != -1) {
    double newprice = cprice / 100.0;

    if (FXInputDialog::getReal(newprice,this,_("New price"),
			       _("Insert the new price:"),NULL,0,999999)) {
      char buf[64];
      double newtotalprice = newprice + cpprice / 100.0;

      cprice = (FXuint) (newprice * 100);
      snprintf(buf,64,"%.2f",newprice);
      timeprice->setText(buf);
      snprintf(buf,64,"%.2f",newtotalprice);
      totalprice->setText(buf);
    }
  }

  return 1;
}
