#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXHash.h"
#include "FXThread.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXSize.h"
#include "FXPoint.h"
#include "FXObjectList.h"
#include "FXRectangle.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXButton.h"
#include "FXScrollBar.h"
#include "FXScrollArea.h"
#include "FXHeader.h"
#include "FXIconList.h"

#include "CCLIconItem.h"

FXIMPLEMENT(CCLIconItem,FXIconItem,NULL,0)

CCLIconItem::CCLIconItem(const FXString & text,FXIcon * bi,FXIcon * mi,
			 void * ptr,FXIcon * di)
:FXIconItem(text,bi,mi,ptr)
{
  disconIcon = di;
  flags = 0;
}

CCLIconItem::~CCLIconItem()
{
  disconIcon = (FXIcon *) - 1L;
}

void
CCLIconItem::create()
{
  FXIconItem::create();
  if (disconIcon)
    disconIcon->create();
}

void
CCLIconItem::draw(const FXIconList * list,FXDC & dc,FXint x,FXint y,
		  FXint w,FXint h) const
{
  register FXuint options = list->getListStyle();

  if (options & ICONLIST_BIG_ICONS)
    drawBigIcon(list,dc,x,y,w,h);
  else if (options & ICONLIST_MINI_ICONS)
    drawMiniIcon(list,dc,x,y,w,h);
  else
    drawDetails(list,dc,x,y,w,h);
  if (flags & FLAG_DISCONNECTED)
    drawFlagIcons(list,dc,x,y,w,h);
}

void
CCLIconItem::drawFlagIcons(const FXIconList * list,FXDC & dc,FXint x,
			   FXint y,FXint w,FXint h) const
{
  register FXuint options = list->getListStyle();

  if ((options & ICONLIST_BIG_ICONS) && (flags & FLAG_DISCONNECTED)
      && disconIcon && bigIcon) {
    FXint iw = disconIcon->getWidth();
    FXint ih = disconIcon->getHeight();
    FXint xi = x + (w - iw);
    FXint yi = y + bigIcon->getHeight() - ih;

    if (isSelected())
      dc.drawIconShaded(disconIcon,xi,yi);
    else
      dc.drawIcon(disconIcon,xi,yi);
  }
}

void
CCLIconItem::setShowDisconIcon(FXbool show)
{
  if (show)
    flags |= FLAG_DISCONNECTED;
  else
    flags &= ~FLAG_DISCONNECTED;
}
