/* ccm-window-animation.c generated by valac, the Vala compiler
 * generated from ccm-window-animation.vala, do not modify */

/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * cairo-compmgr
 * Copyright (C) Nicolas Bruguier 2007-2010 <gandalfn@club-internet.fr>
 * 
 * cairo-compmgr is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * cairo-compmgr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with cairo-compmgr.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ccm-plugin.h>
#include <float.h>
#include <math.h>
#include <ccm-config.h>
#include <ccm-debug.h>
#include <ccm.h>
#include <ccm-window.h>
#include <ccm-window-plugin.h>
#include <ccm-timeline.h>
#include <cairo.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <ccm-drawable.h>
#include <ccm-screen.h>
#include <config.h>
#include <ccm-preferences-page.h>
#include <ccm-preferences-page-plugin.h>
#include <ccm-config-adjustment.h>


#define CCM_TYPE_OPTIONS (ccm_options_get_type ())

#define CCM_TYPE_WINDOW_ANIMATION_OPTIONS (ccm_window_animation_options_get_type ())
#define CCM_WINDOW_ANIMATION_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_WINDOW_ANIMATION_OPTIONS, CCMWindowAnimationOptions))
#define CCM_WINDOW_ANIMATION_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_WINDOW_ANIMATION_OPTIONS, CCMWindowAnimationOptionsClass))
#define CCM_IS_WINDOW_ANIMATION_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_WINDOW_ANIMATION_OPTIONS))
#define CCM_IS_WINDOW_ANIMATION_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_WINDOW_ANIMATION_OPTIONS))
#define CCM_WINDOW_ANIMATION_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_WINDOW_ANIMATION_OPTIONS, CCMWindowAnimationOptionsClass))

typedef struct _CCMWindowAnimationOptions CCMWindowAnimationOptions;
typedef struct _CCMWindowAnimationOptionsClass CCMWindowAnimationOptionsClass;
typedef struct _CCMWindowAnimationOptionsPrivate CCMWindowAnimationOptionsPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CCM_TYPE_WINDOW_ANIMATION (ccm_window_animation_get_type ())
#define CCM_WINDOW_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_WINDOW_ANIMATION, CCMWindowAnimation))
#define CCM_WINDOW_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_WINDOW_ANIMATION, CCMWindowAnimationClass))
#define CCM_IS_WINDOW_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_WINDOW_ANIMATION))
#define CCM_IS_WINDOW_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_WINDOW_ANIMATION))
#define CCM_WINDOW_ANIMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_WINDOW_ANIMATION, CCMWindowAnimationClass))

typedef struct _CCMWindowAnimation CCMWindowAnimation;
typedef struct _CCMWindowAnimationClass CCMWindowAnimationClass;
typedef struct _CCMWindowAnimationPrivate CCMWindowAnimationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ccm_region_destroy0(var) ((var == NULL) ? NULL : (var = (ccm_region_destroy (var), NULL)))

typedef enum  {
	CCM_OPTIONS_DURATION,
	CCM_OPTIONS_N
} CCMOptions;

struct _CCMWindowAnimationOptions {
	CCMPluginOptions parent_instance;
	CCMWindowAnimationOptionsPrivate * priv;
	double duration;
};

struct _CCMWindowAnimationOptionsClass {
	CCMPluginOptionsClass parent_class;
};

struct _CCMWindowAnimation {
	CCMPlugin parent_instance;
	CCMWindowAnimationPrivate * priv;
};

struct _CCMWindowAnimationClass {
	CCMPluginClass parent_class;
};

struct _CCMWindowAnimationPrivate {
	CCMWindow* window;
	CCMWindowType type;
	gboolean desktop_changed;
	CCMTimeline* timeline;
	cairo_rectangle_t geometry;
	GtkBuilder* builder;
};


static gpointer ccm_window_animation_options_parent_class = NULL;
static GType ccm_window_animation_options_type_id = 0;
static gpointer ccm_window_animation_parent_class = NULL;
static CCMWindowPluginIface* ccm_window_animation_ccm_window_plugin_parent_iface = NULL;
static CCMPreferencesPagePluginIface* ccm_window_animation_ccm_preferences_page_plugin_parent_iface = NULL;
static GType ccm_window_animation_type_id = 0;

GType ccm_options_get_type (void);
GType ccm_window_animation_options_get_type (void);
GType ccm_window_animation_options_register_type (GTypeModule * module);
enum  {
	CCM_WINDOW_ANIMATION_OPTIONS_DUMMY_PROPERTY
};
static void ccm_window_animation_options_real_changed (CCMPluginOptions* base, CCMConfig* config);
CCMWindowAnimationOptions* ccm_window_animation_options_new (void);
CCMWindowAnimationOptions* ccm_window_animation_options_construct (GType object_type);
static void ccm_window_animation_options_finalize (GObject* obj);
GType ccm_window_animation_get_type (void);
GType ccm_window_animation_register_type (GTypeModule * module);
#define CCM_WINDOW_ANIMATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_WINDOW_ANIMATION, CCMWindowAnimationPrivate))
enum  {
	CCM_WINDOW_ANIMATION_DUMMY_PROPERTY
};
static void ccm_window_animation_option_changed (CCMWindowAnimation* self, gint index);
static void ccm_window_animation_on_property_changed (CCMWindowAnimation* self, CCMWindow* window, CCMPropertyType property_type);
static void ccm_window_animation_on_unlock (CCMWindowAnimation* self);
static void ccm_window_animation_on_desktop_changed (CCMWindowAnimation* self, gint desktop);
static void ccm_window_animation_on_new_frame (CCMWindowAnimation* self, gint frame);
static void ccm_window_animation_on_finish (CCMWindowAnimation* self);
static void _ccm_window_animation_on_property_changed_ccm_window_property_changed (CCMWindow* _sender, CCMPropertyType type, gpointer self);
static void _ccm_window_animation_on_desktop_changed_ccm_screen_desktop_changed (CCMScreen* _sender, gint desktop, gpointer self);
static void ccm_window_animation_real_window_load_options (CCMWindowPlugin* base, CCMWindow* window);
static CCMRegion* ccm_window_animation_real_query_geometry (CCMWindowPlugin* base, CCMWindow* window);
static void ccm_window_animation_real_resize (CCMWindowPlugin* base, CCMWindow* window, gint width, gint height);
static void _ccm_window_animation_on_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self);
static void _ccm_window_animation_on_finish_ccm_timeline_completed (CCMTimeline* _sender, gpointer self);
static void _ccm_window_animation_on_unlock_ccm_plugin_unlock_func (void* data);
static void ccm_window_animation_real_map (CCMWindowPlugin* base, CCMWindow* window);
static void ccm_window_animation_real_unmap (CCMWindowPlugin* base, CCMWindow* window);
static void ccm_window_animation_real_init_effects_section (CCMPreferencesPagePlugin* base, CCMPreferencesPage* preferences, GtkWidget* effects_section);
CCMWindowAnimation* ccm_window_animation_new (void);
CCMWindowAnimation* ccm_window_animation_construct (GType object_type);
static void ccm_window_animation_finalize (GObject* obj);
GType ccm_window_animation_get_plugin_type (GTypeModule* module);

static const char* CCM_WINDOW_ANIMATION_options_key[1] = {"duration"};



GType ccm_options_get_type (void) {
	static GType ccm_options_type_id = 0;
	if (G_UNLIKELY (ccm_options_type_id == 0)) {
		static const GEnumValue values[] = {{CCM_OPTIONS_DURATION, "CCM_OPTIONS_DURATION", "duration"}, {CCM_OPTIONS_N, "CCM_OPTIONS_N", "n"}, {0, NULL, NULL}};
		ccm_options_type_id = g_enum_register_static ("CCMOptions", values);
	}
	return ccm_options_type_id;
}


static void ccm_window_animation_options_real_changed (CCMPluginOptions* base, CCMConfig* config) {
	CCMWindowAnimationOptions * self;
	GError * _inner_error_;
	double real_duration;
	double duration;
	self = (CCMWindowAnimationOptions*) base;
	g_return_if_fail (config != NULL);
	_inner_error_ = NULL;
	real_duration = 0.4;
	{
		float _tmp0_;
		_tmp0_ = ccm_config_get_float (config, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		real_duration = (double) _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			real_duration = 0.4;
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	duration = MIN (2.0, real_duration);
	duration = MAX (0.1, duration);
	self->duration = duration;
	if (duration != real_duration) {
		{
			ccm_config_set_float (config, (float) duration, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				ccm_log ("Error on set duration config: %s", err->message, NULL);
				_g_error_free0 (err);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


CCMWindowAnimationOptions* ccm_window_animation_options_construct (GType object_type) {
	CCMWindowAnimationOptions * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CCMWindowAnimationOptions* ccm_window_animation_options_new (void) {
	return ccm_window_animation_options_construct (CCM_TYPE_WINDOW_ANIMATION_OPTIONS);
}


static void ccm_window_animation_options_class_init (CCMWindowAnimationOptionsClass * klass) {
	ccm_window_animation_options_parent_class = g_type_class_peek_parent (klass);
	CCM_PLUGIN_OPTIONS_CLASS (klass)->changed = ccm_window_animation_options_real_changed;
	G_OBJECT_CLASS (klass)->finalize = ccm_window_animation_options_finalize;
}


static void ccm_window_animation_options_instance_init (CCMWindowAnimationOptions * self) {
	self->duration = 0.4;
}


static void ccm_window_animation_options_finalize (GObject* obj) {
	CCMWindowAnimationOptions * self;
	self = CCM_WINDOW_ANIMATION_OPTIONS (obj);
	G_OBJECT_CLASS (ccm_window_animation_options_parent_class)->finalize (obj);
}


GType ccm_window_animation_options_get_type (void) {
	return ccm_window_animation_options_type_id;
}


GType ccm_window_animation_options_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMWindowAnimationOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_window_animation_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMWindowAnimationOptions), 0, (GInstanceInitFunc) ccm_window_animation_options_instance_init, NULL };
	ccm_window_animation_options_type_id = g_type_module_register_type (module, CCM_TYPE_PLUGIN_OPTIONS, "CCMWindowAnimationOptions", &g_define_type_info, 0);
	return ccm_window_animation_options_type_id;
}


static void ccm_window_animation_option_changed (CCMWindowAnimation* self, gint index) {
	g_return_if_fail (self != NULL);
	if (index == CCM_OPTIONS_DURATION) {
		CCMTimeline* _tmp0_;
		self->priv->timeline = (_tmp0_ = NULL, _g_object_unref0 (self->priv->timeline), _tmp0_);
	}
}


static void ccm_window_animation_on_property_changed (CCMWindowAnimation* self, CCMWindow* window, CCMPropertyType property_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (property_type == CCM_PROPERTY_HINT_TYPE) {
		self->priv->type = ccm_window_get_hint_type (window);
	}
}


static void ccm_window_animation_on_unlock (CCMWindowAnimation* self) {
	g_return_if_fail (self != NULL);
	ccm_drawable_pop_matrix ((CCMDrawable*) self->priv->window, "CCMWindowAnimation");
}


static void ccm_window_animation_on_desktop_changed (CCMWindowAnimation* self, gint desktop) {
	g_return_if_fail (self != NULL);
	self->priv->desktop_changed = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ccm_window_animation_on_new_frame (CCMWindowAnimation* self, gint frame) {
	double progress;
	double x0;
	double y0;
	cairo_matrix_t matrix = {0};
	CCMRegion* damaged;
	CCMRegion* geometry;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	progress = ccm_timeline_get_progress (self->priv->timeline);
	x0 = (self->priv->geometry.width / 2.0) * (1.0 - progress);
	y0 = (self->priv->geometry.height / 2.0) * (1.0 - progress);
	damaged = ccm_region_new ();
	if (ccm_timeline_get_direction (self->priv->timeline) == CCM_TIMELINE_FORWARD) {
		cairo_matrix_t _tmp0_ = {0};
		matrix = (cairo_matrix_init (&_tmp0_, progress, (double) 0, (double) 0, progress, x0, y0), _tmp0_);
	} else {
		cairo_matrix_t _tmp1_ = {0};
		matrix = (cairo_matrix_init (&_tmp1_, progress, (double) 0, (double) 0, (double) 1, x0, (double) 0), _tmp1_);
	}
	geometry = NULL;
	{
		GSList* transient_collection;
		GSList* transient_it;
		transient_collection = ccm_window_get_transients (self->priv->window);
		for (transient_it = transient_collection; transient_it != NULL; transient_it = transient_it->next) {
			CCMWindow* transient;
			transient = _g_object_ref0 ((CCMWindow*) transient_it->data);
			{
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				geometry = ccm_drawable_get_geometry ((CCMDrawable*) transient);
				if (ccm_window_is_viewable (transient)) {
					_tmp4_ = !ccm_window_is_input_only (transient);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					_tmp3_ = geometry != NULL;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					_tmp2_ = !ccm_region_empty (geometry);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					ccm_region_union (damaged, geometry);
				}
				_g_object_unref0 (transient);
			}
		}
	}
	geometry = ccm_drawable_get_geometry ((CCMDrawable*) self->priv->window);
	if (geometry != NULL) {
		_tmp5_ = !ccm_region_empty (geometry);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ccm_region_union (damaged, geometry);
	}
	ccm_drawable_push_matrix ((CCMDrawable*) self->priv->window, "CCMWindowAnimation", &matrix);
	{
		GSList* transient_collection;
		GSList* transient_it;
		transient_collection = ccm_window_get_transients (self->priv->window);
		for (transient_it = transient_collection; transient_it != NULL; transient_it = transient_it->next) {
			CCMWindow* transient;
			transient = _g_object_ref0 ((CCMWindow*) transient_it->data);
			{
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				geometry = ccm_drawable_get_geometry ((CCMDrawable*) transient);
				if (ccm_window_is_viewable (transient)) {
					_tmp8_ = !ccm_window_is_input_only (transient);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					_tmp7_ = geometry != NULL;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = !ccm_region_empty (geometry);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					ccm_region_union (damaged, geometry);
				}
				_g_object_unref0 (transient);
			}
		}
	}
	geometry = ccm_drawable_get_geometry ((CCMDrawable*) self->priv->window);
	if (geometry != NULL) {
		_tmp9_ = !ccm_region_empty (geometry);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ccm_region_union (damaged, geometry);
	}
	if (!ccm_region_empty (damaged)) {
		ccm_screen_damage_region (ccm_drawable_get_screen ((CCMDrawable*) self->priv->window), damaged);
	}
	_ccm_region_destroy0 (damaged);
}


static void ccm_window_animation_on_finish (CCMWindowAnimation* self) {
	g_return_if_fail (self != NULL);
	ccm_window_set_redirect (self->priv->window, TRUE);
	if (ccm_timeline_get_direction (self->priv->timeline) == CCM_TIMELINE_FORWARD) {
		CCMWindow* _tmp0_;
		ccm_window_plugin_unlock_map ((CCMWindowPlugin*) self);
		ccm_window_plugin_map ((_tmp0_ = self->priv->window, CCM_IS_WINDOW_PLUGIN (_tmp0_) ? ((CCMWindowPlugin*) _tmp0_) : NULL), self->priv->window);
	} else {
		CCMWindow* _tmp1_;
		ccm_window_plugin_unlock_unmap ((CCMWindowPlugin*) self);
		ccm_window_plugin_unmap ((_tmp1_ = self->priv->window, CCM_IS_WINDOW_PLUGIN (_tmp1_) ? ((CCMWindowPlugin*) _tmp1_) : NULL), self->priv->window);
	}
}


static void _ccm_window_animation_on_property_changed_ccm_window_property_changed (CCMWindow* _sender, CCMPropertyType type, gpointer self) {
	ccm_window_animation_on_property_changed (self, _sender, type);
}


static void _ccm_window_animation_on_desktop_changed_ccm_screen_desktop_changed (CCMScreen* _sender, gint desktop, gpointer self) {
	ccm_window_animation_on_desktop_changed (self, desktop);
}


static void ccm_window_animation_real_window_load_options (CCMWindowPlugin* base, CCMWindow* window) {
	CCMWindowAnimation * self;
	GObject* _tmp0_;
	self = (CCMWindowAnimation*) base;
	g_return_if_fail (window != NULL);
	self->priv->window = window;
	self->priv->type = CCM_WINDOW_TYPE_UNKNOWN;
	g_signal_connect_object (self->priv->window, "property-changed", (GCallback) _ccm_window_animation_on_property_changed_ccm_window_property_changed, self, 0);
	ccm_plugin_options_load ((CCMPlugin*) self, "window-animation", CCM_WINDOW_ANIMATION_options_key, G_N_ELEMENTS (CCM_WINDOW_ANIMATION_options_key), (CCMPluginOptionsChangedFunc) ccm_window_animation_option_changed);
	g_signal_connect_object (ccm_drawable_get_screen ((CCMDrawable*) window), "desktop-changed", (GCallback) _ccm_window_animation_on_desktop_changed_ccm_screen_desktop_changed, self, 0);
	self->priv->desktop_changed = FALSE;
	ccm_window_plugin_load_options ((_tmp0_ = ccm_plugin_get_parent ((CCMPlugin*) self), CCM_IS_WINDOW_PLUGIN (_tmp0_) ? ((CCMWindowPlugin*) _tmp0_) : NULL), window);
}


static CCMRegion* ccm_window_animation_real_query_geometry (CCMWindowPlugin* base, CCMWindow* window) {
	CCMWindowAnimation * self;
	CCMRegion* result;
	CCMRegion* region;
	CCMRegion* _tmp0_;
	self = (CCMWindowAnimation*) base;
	g_return_val_if_fail (window != NULL, NULL);
	region = NULL;
	region = (_tmp0_ = ccm_window_plugin_query_geometry (CCM_WINDOW_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), window), _ccm_region_destroy0 (region), _tmp0_);
	if (region != NULL) {
		ccm_region_get_clipbox (region, &self->priv->geometry);
	}
	result = region;
	return result;
}


static void ccm_window_animation_real_resize (CCMWindowPlugin* base, CCMWindow* window, gint width, gint height) {
	CCMWindowAnimation * self;
	GObject* _tmp0_;
	self = (CCMWindowAnimation*) base;
	g_return_if_fail (window != NULL);
	self->priv->geometry.width = (double) width;
	self->priv->geometry.height = (double) height;
	ccm_window_plugin_resize ((_tmp0_ = ccm_plugin_get_parent ((CCMPlugin*) self), CCM_IS_WINDOW_PLUGIN (_tmp0_) ? ((CCMWindowPlugin*) _tmp0_) : NULL), window, width, height);
}


static void _ccm_window_animation_on_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self) {
	ccm_window_animation_on_new_frame (self, object);
}


static void _ccm_window_animation_on_finish_ccm_timeline_completed (CCMTimeline* _sender, gpointer self) {
	ccm_window_animation_on_finish (self);
}


static void _ccm_window_animation_on_unlock_ccm_plugin_unlock_func (void* data) {
	ccm_window_animation_on_unlock (data);
}


static void ccm_window_animation_real_map (CCMWindowPlugin* base, CCMWindow* window) {
	CCMWindowAnimation * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GObject* _tmp5_;
	self = (CCMWindowAnimation*) base;
	g_return_if_fail (window != NULL);
	if (self->priv->type == CCM_WINDOW_TYPE_UNKNOWN) {
		self->priv->type = ccm_window_get_hint_type (window);
	}
	if (!self->priv->desktop_changed) {
		_tmp1_ = ccm_window_is_decorated (window);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		if (self->priv->type == CCM_WINDOW_TYPE_NORMAL) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->type == CCM_WINDOW_TYPE_DIALOG;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint current_frame;
		current_frame = 0;
		if (self->priv->timeline == NULL) {
			CCMTimeline* _tmp3_;
			self->priv->timeline = (_tmp3_ = ccm_timeline_new_for_duration ((guint) (CCM_WINDOW_ANIMATION_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->duration * 1000.0)), _g_object_unref0 (self->priv->timeline), _tmp3_);
			g_signal_connect_object (self->priv->timeline, "new-frame", (GCallback) _ccm_window_animation_on_new_frame_ccm_timeline_new_frame, self, 0);
			g_signal_connect_object (self->priv->timeline, "completed", (GCallback) _ccm_window_animation_on_finish_ccm_timeline_completed, self, 0);
		}
		if (ccm_timeline_is_playing (self->priv->timeline)) {
			current_frame = ccm_timeline_get_current_frame (self->priv->timeline);
			ccm_timeline_stop (self->priv->timeline);
			ccm_window_animation_on_finish (self);
		} else {
			cairo_matrix_t _tmp4_ = {0};
			cairo_matrix_t matrix;
			cairo_rectangle_t area = {0};
			matrix = (cairo_matrix_init_identity (&_tmp4_), _tmp4_);
			ccm_drawable_get_geometry_clipbox ((CCMDrawable*) window, &area);
			cairo_matrix_scale (&matrix, 0.0, 0.0);
			cairo_matrix_translate (&matrix, area.width / 2.0, area.height / 2.0);
			ccm_drawable_push_matrix ((CCMDrawable*) window, "CCMWindowAnimation", &matrix);
		}
		ccm_window_plugin_lock_map ((CCMWindowPlugin*) self, _ccm_window_animation_on_unlock_ccm_plugin_unlock_func);
		ccm_timeline_set_direction (self->priv->timeline, CCM_TIMELINE_FORWARD);
		ccm_timeline_rewind (self->priv->timeline);
		ccm_timeline_start (self->priv->timeline);
		if (current_frame > 0) {
			ccm_timeline_advance (self->priv->timeline, (guint) current_frame);
		}
		ccm_window_set_redirect (window, FALSE);
	}
	self->priv->desktop_changed = FALSE;
	ccm_window_plugin_map ((_tmp5_ = ccm_plugin_get_parent ((CCMPlugin*) self), CCM_IS_WINDOW_PLUGIN (_tmp5_) ? ((CCMWindowPlugin*) _tmp5_) : NULL), window);
}


static void ccm_window_animation_real_unmap (CCMWindowPlugin* base, CCMWindow* window) {
	CCMWindowAnimation * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GObject* _tmp4_;
	self = (CCMWindowAnimation*) base;
	g_return_if_fail (window != NULL);
	if (!self->priv->desktop_changed) {
		_tmp1_ = ccm_window_is_decorated (window);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		if (self->priv->type == CCM_WINDOW_TYPE_NORMAL) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->type == CCM_WINDOW_TYPE_DIALOG;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint current_frame;
		current_frame = 0;
		if (self->priv->timeline == NULL) {
			CCMTimeline* _tmp3_;
			self->priv->timeline = (_tmp3_ = ccm_timeline_new_for_duration ((guint) (CCM_WINDOW_ANIMATION_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->duration * 1000.0)), _g_object_unref0 (self->priv->timeline), _tmp3_);
			g_signal_connect_object (self->priv->timeline, "new-frame", (GCallback) _ccm_window_animation_on_new_frame_ccm_timeline_new_frame, self, 0);
			g_signal_connect_object (self->priv->timeline, "completed", (GCallback) _ccm_window_animation_on_finish_ccm_timeline_completed, self, 0);
		}
		if (ccm_timeline_is_playing (self->priv->timeline)) {
			current_frame = ccm_timeline_get_current_frame (self->priv->timeline);
			ccm_timeline_stop (self->priv->timeline);
			ccm_window_animation_on_finish (self);
		} else {
			ccm_drawable_pop_matrix ((CCMDrawable*) window, "CCMWindowAnimation");
		}
		ccm_window_plugin_lock_unmap ((CCMWindowPlugin*) self, _ccm_window_animation_on_unlock_ccm_plugin_unlock_func);
		ccm_timeline_set_direction (self->priv->timeline, CCM_TIMELINE_BACKWARD);
		ccm_timeline_rewind (self->priv->timeline);
		ccm_timeline_start (self->priv->timeline);
		if (current_frame > 0) {
			ccm_timeline_advance (self->priv->timeline, ccm_timeline_get_n_frames (self->priv->timeline) - current_frame);
		}
		ccm_window_set_redirect (window, FALSE);
	}
	self->priv->desktop_changed = FALSE;
	ccm_window_plugin_unmap ((_tmp4_ = ccm_plugin_get_parent ((CCMPlugin*) self), CCM_IS_WINDOW_PLUGIN (_tmp4_) ? ((CCMWindowPlugin*) _tmp4_) : NULL), window);
}


static void ccm_window_animation_real_init_effects_section (CCMPreferencesPagePlugin* base, CCMPreferencesPage* preferences, GtkWidget* effects_section) {
	CCMWindowAnimation * self;
	GError * _inner_error_;
	GtkBuilder* _tmp0_;
	GObject* _tmp3_;
	self = (CCMWindowAnimation*) base;
	g_return_if_fail (preferences != NULL);
	g_return_if_fail (effects_section != NULL);
	_inner_error_ = NULL;
	self->priv->builder = (_tmp0_ = gtk_builder_new (), _g_object_unref0 (self->priv->builder), _tmp0_);
	{
		GObject* _tmp1_;
		GtkWidget* widget;
		gtk_builder_add_from_file (self->priv->builder, UI_DIR "/ccm-window-animation.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		widget = _g_object_ref0 ((_tmp1_ = gtk_builder_get_object (self->priv->builder, "window-animation"), GTK_IS_WIDGET (_tmp1_) ? ((GtkWidget*) _tmp1_) : NULL));
		if (widget != NULL) {
			gint screen_num;
			GObject* _tmp2_;
			CCMConfigAdjustment* duration;
			screen_num = ccm_preferences_page_get_screen_num (preferences);
			gtk_box_pack_start (GTK_BOX (effects_section), widget, FALSE, TRUE, (guint) 0);
			duration = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (self->priv->builder, "duration-adjustment"), CCM_IS_CONFIG_ADJUSTMENT (_tmp2_) ? ((CCMConfigAdjustment*) _tmp2_) : NULL));
			g_object_set (duration, "screen", screen_num, NULL);
			ccm_preferences_page_section_register_widget (preferences, CCM_PREFERENCES_PAGE_SECTION_EFFECTS, widget, "window-animation");
			_g_object_unref0 (duration);
		}
		_g_object_unref0 (widget);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			ccm_log ("%s", err->message, NULL);
			_g_error_free0 (err);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ccm_preferences_page_plugin_init_effects_section ((_tmp3_ = ccm_plugin_get_parent ((CCMPlugin*) self), CCM_IS_PREFERENCES_PAGE_PLUGIN (_tmp3_) ? ((CCMPreferencesPagePlugin*) _tmp3_) : NULL), preferences, effects_section);
}


CCMWindowAnimation* ccm_window_animation_construct (GType object_type) {
	CCMWindowAnimation * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CCMWindowAnimation* ccm_window_animation_new (void) {
	return ccm_window_animation_construct (CCM_TYPE_WINDOW_ANIMATION);
}


static void ccm_window_animation_base_init (CCMWindowAnimationClass * klass) {
	{
		CCM_PLUGIN_CLASS (klass)->type_options = CCM_TYPE_WINDOW_ANIMATION_OPTIONS;
	}
}


static void ccm_window_animation_class_init (CCMWindowAnimationClass * klass) {
	ccm_window_animation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMWindowAnimationPrivate));
	G_OBJECT_CLASS (klass)->finalize = ccm_window_animation_finalize;
}


static void ccm_window_animation_ccm_window_plugin_interface_init (CCMWindowPluginIface * iface) {
	ccm_window_animation_ccm_window_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->load_options = ccm_window_animation_real_window_load_options;
	iface->query_geometry = ccm_window_animation_real_query_geometry;
	iface->resize = ccm_window_animation_real_resize;
	iface->map = ccm_window_animation_real_map;
	iface->unmap = ccm_window_animation_real_unmap;
}


static void ccm_window_animation_ccm_preferences_page_plugin_interface_init (CCMPreferencesPagePluginIface * iface) {
	ccm_window_animation_ccm_preferences_page_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->init_effects_section = ccm_window_animation_real_init_effects_section;
}


static void ccm_window_animation_instance_init (CCMWindowAnimation * self) {
	self->priv = CCM_WINDOW_ANIMATION_GET_PRIVATE (self);
}


static void ccm_window_animation_finalize (GObject* obj) {
	CCMWindowAnimation * self;
	self = CCM_WINDOW_ANIMATION (obj);
	{
		ccm_plugin_options_unload ((CCMPlugin*) self);
	}
	_g_object_unref0 (self->priv->timeline);
	_g_object_unref0 (self->priv->builder);
	G_OBJECT_CLASS (ccm_window_animation_parent_class)->finalize (obj);
}


GType ccm_window_animation_get_type (void) {
	return ccm_window_animation_type_id;
}


GType ccm_window_animation_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMWindowAnimationClass), (GBaseInitFunc) ccm_window_animation_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_window_animation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMWindowAnimation), 0, (GInstanceInitFunc) ccm_window_animation_instance_init, NULL };
	static const GInterfaceInfo ccm_window_plugin_info = { (GInterfaceInitFunc) ccm_window_animation_ccm_window_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo ccm_preferences_page_plugin_info = { (GInterfaceInitFunc) ccm_window_animation_ccm_preferences_page_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	ccm_window_animation_type_id = g_type_module_register_type (module, CCM_TYPE_PLUGIN, "CCMWindowAnimation", &g_define_type_info, 0);
	g_type_module_add_interface (module, ccm_window_animation_type_id, CCM_TYPE_WINDOW_PLUGIN, &ccm_window_plugin_info);
	g_type_module_add_interface (module, ccm_window_animation_type_id, CCM_TYPE_PREFERENCES_PAGE_PLUGIN, &ccm_preferences_page_plugin_info);
	return ccm_window_animation_type_id;
}


GType ccm_window_animation_get_plugin_type (GTypeModule* module) {
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	ccm_window_animation_options_register_type (module);
	ccm_window_animation_register_type (module);
	result = CCM_TYPE_WINDOW_ANIMATION;
	return result;
}




