/* ccm-vala-window-plugin.c generated by valac, the Vala compiler
 * generated from ccm-vala-window-plugin.vala, do not modify */

/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * cairo-compmgr
 * Copyright (C) Nicolas Bruguier 2007-2010 <gandalfn@club-internet.fr>
 * 
 * cairo-compmgr is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * cairo-compmgr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with cairo-compmgr.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ccm-plugin.h>
#include <ccm-config.h>
#include <ccm-debug.h>
#include <ccm.h>
#include <ccm-window.h>
#include <ccm-window-plugin.h>
#include <stdlib.h>
#include <string.h>
#include <ccm-drawable.h>
#include <ccm-screen.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define CCM_TYPE_OPTIONS (ccm_options_get_type ())

#define CCM_TYPE_VALA_WINDOW_OPTIONS (ccm_vala_window_options_get_type ())
#define CCM_VALA_WINDOW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_VALA_WINDOW_OPTIONS, CCMValaWindowOptions))
#define CCM_VALA_WINDOW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_VALA_WINDOW_OPTIONS, CCMValaWindowOptionsClass))
#define CCM_IS_VALA_WINDOW_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_VALA_WINDOW_OPTIONS))
#define CCM_IS_VALA_WINDOW_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_VALA_WINDOW_OPTIONS))
#define CCM_VALA_WINDOW_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_VALA_WINDOW_OPTIONS, CCMValaWindowOptionsClass))

typedef struct _CCMValaWindowOptions CCMValaWindowOptions;
typedef struct _CCMValaWindowOptionsClass CCMValaWindowOptionsClass;
typedef struct _CCMValaWindowOptionsPrivate CCMValaWindowOptionsPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CCM_TYPE_VALA_WINDOW_PLUGIN (ccm_vala_window_plugin_get_type ())
#define CCM_VALA_WINDOW_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_VALA_WINDOW_PLUGIN, CCMValaWindowPlugin))
#define CCM_VALA_WINDOW_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_VALA_WINDOW_PLUGIN, CCMValaWindowPluginClass))
#define CCM_IS_VALA_WINDOW_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_VALA_WINDOW_PLUGIN))
#define CCM_IS_VALA_WINDOW_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_VALA_WINDOW_PLUGIN))
#define CCM_VALA_WINDOW_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_VALA_WINDOW_PLUGIN, CCMValaWindowPluginClass))

typedef struct _CCMValaWindowPlugin CCMValaWindowPlugin;
typedef struct _CCMValaWindowPluginClass CCMValaWindowPluginClass;
typedef struct _CCMValaWindowPluginPrivate CCMValaWindowPluginPrivate;

typedef enum  {
	CCM_OPTIONS_ENABLED,
	CCM_OPTIONS_N
} CCMOptions;

struct _CCMValaWindowOptions {
	CCMPluginOptions parent_instance;
	CCMValaWindowOptionsPrivate * priv;
	gboolean enabled;
};

struct _CCMValaWindowOptionsClass {
	CCMPluginOptionsClass parent_class;
};

struct _CCMValaWindowPlugin {
	CCMPlugin parent_instance;
	CCMValaWindowPluginPrivate * priv;
};

struct _CCMValaWindowPluginClass {
	CCMPluginClass parent_class;
};

struct _CCMValaWindowPluginPrivate {
	CCMWindow* window;
	guint counter;
};


static gpointer ccm_vala_window_options_parent_class = NULL;
static GType ccm_vala_window_options_type_id = 0;
static gpointer ccm_vala_window_plugin_parent_class = NULL;
static CCMWindowPluginIface* ccm_vala_window_plugin_ccm_window_plugin_parent_iface = NULL;
static GType ccm_vala_window_plugin_type_id = 0;

GType ccm_options_get_type (void);
GType ccm_vala_window_options_get_type (void);
GType ccm_vala_window_options_register_type (GTypeModule * module);
enum  {
	CCM_VALA_WINDOW_OPTIONS_DUMMY_PROPERTY
};
static void ccm_vala_window_options_real_changed (CCMPluginOptions* base, CCMConfig* config);
CCMValaWindowOptions* ccm_vala_window_options_new (void);
CCMValaWindowOptions* ccm_vala_window_options_construct (GType object_type);
static void ccm_vala_window_options_finalize (GObject* obj);
GType ccm_vala_window_plugin_get_type (void);
GType ccm_vala_window_plugin_register_type (GTypeModule * module);
#define CCM_VALA_WINDOW_PLUGIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_VALA_WINDOW_PLUGIN, CCMValaWindowPluginPrivate))
enum  {
	CCM_VALA_WINDOW_PLUGIN_DUMMY_PROPERTY
};
static void ccm_vala_window_plugin_option_changed (CCMValaWindowPlugin* self, gint index);
static void ccm_vala_window_plugin_real_window_load_options (CCMWindowPlugin* base, CCMWindow* window);
static gboolean ccm_vala_window_plugin_real_window_paint (CCMWindowPlugin* base, CCMWindow* window, cairo_t* ctx, cairo_surface_t* surface, gboolean y_invert);
CCMValaWindowPlugin* ccm_vala_window_plugin_new (void);
CCMValaWindowPlugin* ccm_vala_window_plugin_construct (GType object_type);
static void ccm_vala_window_plugin_finalize (GObject* obj);
GType ccm_vala_window_plugin_get_plugin_type (GTypeModule* module);

static const char* CCM_VALA_WINDOW_PLUGIN_options_key[1] = {"enabled"};



GType ccm_options_get_type (void) {
	static GType ccm_options_type_id = 0;
	if (G_UNLIKELY (ccm_options_type_id == 0)) {
		static const GEnumValue values[] = {{CCM_OPTIONS_ENABLED, "CCM_OPTIONS_ENABLED", "enabled"}, {CCM_OPTIONS_N, "CCM_OPTIONS_N", "n"}, {0, NULL, NULL}};
		ccm_options_type_id = g_enum_register_static ("CCMOptions", values);
	}
	return ccm_options_type_id;
}


static void ccm_vala_window_options_real_changed (CCMPluginOptions* base, CCMConfig* config) {
	CCMValaWindowOptions * self;
	GError * _inner_error_;
	self = (CCMValaWindowOptions*) base;
	g_return_if_fail (config != NULL);
	_inner_error_ = NULL;
	{
		gboolean _tmp0_;
		_tmp0_ = ccm_config_get_boolean (config, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		self->enabled = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			ccm_log ("%s", err, NULL);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


CCMValaWindowOptions* ccm_vala_window_options_construct (GType object_type) {
	CCMValaWindowOptions * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CCMValaWindowOptions* ccm_vala_window_options_new (void) {
	return ccm_vala_window_options_construct (CCM_TYPE_VALA_WINDOW_OPTIONS);
}


static void ccm_vala_window_options_class_init (CCMValaWindowOptionsClass * klass) {
	ccm_vala_window_options_parent_class = g_type_class_peek_parent (klass);
	CCM_PLUGIN_OPTIONS_CLASS (klass)->changed = ccm_vala_window_options_real_changed;
	G_OBJECT_CLASS (klass)->finalize = ccm_vala_window_options_finalize;
}


static void ccm_vala_window_options_instance_init (CCMValaWindowOptions * self) {
	self->enabled = FALSE;
}


static void ccm_vala_window_options_finalize (GObject* obj) {
	CCMValaWindowOptions * self;
	self = CCM_VALA_WINDOW_OPTIONS (obj);
	G_OBJECT_CLASS (ccm_vala_window_options_parent_class)->finalize (obj);
}


GType ccm_vala_window_options_get_type (void) {
	return ccm_vala_window_options_type_id;
}


GType ccm_vala_window_options_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMValaWindowOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_vala_window_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMValaWindowOptions), 0, (GInstanceInitFunc) ccm_vala_window_options_instance_init, NULL };
	ccm_vala_window_options_type_id = g_type_module_register_type (module, CCM_TYPE_PLUGIN_OPTIONS, "CCMValaWindowOptions", &g_define_type_info, 0);
	return ccm_vala_window_options_type_id;
}


static void ccm_vala_window_plugin_option_changed (CCMValaWindowPlugin* self, gint index) {
	g_return_if_fail (self != NULL);
	if (!CCM_VALA_WINDOW_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->enabled) {
		ccm_screen_damage (ccm_drawable_get_screen ((CCMDrawable*) self->priv->window));
	}
}


static void ccm_vala_window_plugin_real_window_load_options (CCMWindowPlugin* base, CCMWindow* window) {
	CCMValaWindowPlugin * self;
	self = (CCMValaWindowPlugin*) base;
	g_return_if_fail (window != NULL);
	self->priv->window = window;
	ccm_plugin_options_load ((CCMPlugin*) self, "vala-window-plugin", CCM_VALA_WINDOW_PLUGIN_options_key, G_N_ELEMENTS (CCM_VALA_WINDOW_PLUGIN_options_key), (CCMPluginOptionsChangedFunc) ccm_vala_window_plugin_option_changed);
	ccm_window_plugin_load_options (CCM_WINDOW_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), window);
}


static gboolean ccm_vala_window_plugin_real_window_paint (CCMWindowPlugin* base, CCMWindow* window, cairo_t* ctx, cairo_surface_t* surface, gboolean y_invert) {
	CCMValaWindowPlugin * self;
	gboolean result;
	gboolean ret;
	self = (CCMValaWindowPlugin*) base;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	g_return_val_if_fail (surface != NULL, FALSE);
	ret = FALSE;
	ret = ccm_window_plugin_paint (CCM_WINDOW_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), window, ctx, surface, y_invert);
	if (CCM_VALA_WINDOW_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->enabled) {
		CCMRegion* damaged;
		damaged = ccm_drawable_get_damaged ((CCMDrawable*) window);
		if (damaged != NULL) {
			gint rectangles_size;
			gint rectangles_length1;
			cairo_rectangle_t* rectangles;
			rectangles = (rectangles_length1 = 0, NULL);
			ccm_region_get_rectangles (damaged, &rectangles, &rectangles_length1);
			switch (self->priv->counter) {
				case 0:
				{
					cairo_set_source_rgba (ctx, (double) 1, (double) 0, (double) 0, 0.5);
					break;
				}
				case 1:
				{
					cairo_set_source_rgba (ctx, (double) 0, (double) 1, (double) 0, 0.5);
					break;
				}
				case 2:
				{
					cairo_set_source_rgba (ctx, (double) 0, (double) 0, (double) 1, 0.5);
					break;
				}
				default:
				{
					break;
				}
			}
			if ((self->priv->counter = self->priv->counter + 1) > 2) {
				self->priv->counter = (guint) 0;
			}
			{
				cairo_rectangle_t* rectangle_collection;
				int rectangle_collection_length1;
				int rectangle_it;
				rectangle_collection = rectangles;
				rectangle_collection_length1 = rectangles_length1;
				for (rectangle_it = 0; rectangle_it < rectangles_length1; rectangle_it = rectangle_it + 1) {
					cairo_rectangle_t rectangle;
					rectangle = rectangle_collection[rectangle_it];
					{
						cairo_rectangle (ctx, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
						cairo_fill (ctx);
					}
				}
			}
			cairo_rectangles_free (rectangles, rectangles_length1);
		}
	}
	result = ret;
	return result;
}


CCMValaWindowPlugin* ccm_vala_window_plugin_construct (GType object_type) {
	CCMValaWindowPlugin * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CCMValaWindowPlugin* ccm_vala_window_plugin_new (void) {
	return ccm_vala_window_plugin_construct (CCM_TYPE_VALA_WINDOW_PLUGIN);
}


static void ccm_vala_window_plugin_base_init (CCMValaWindowPluginClass * klass) {
	{
		CCM_PLUGIN_CLASS (klass)->type_options = CCM_TYPE_VALA_WINDOW_OPTIONS;
	}
}


static void ccm_vala_window_plugin_class_init (CCMValaWindowPluginClass * klass) {
	ccm_vala_window_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMValaWindowPluginPrivate));
	G_OBJECT_CLASS (klass)->finalize = ccm_vala_window_plugin_finalize;
}


static void ccm_vala_window_plugin_ccm_window_plugin_interface_init (CCMWindowPluginIface * iface) {
	ccm_vala_window_plugin_ccm_window_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->load_options = ccm_vala_window_plugin_real_window_load_options;
	iface->paint = ccm_vala_window_plugin_real_window_paint;
}


static void ccm_vala_window_plugin_instance_init (CCMValaWindowPlugin * self) {
	self->priv = CCM_VALA_WINDOW_PLUGIN_GET_PRIVATE (self);
	self->priv->counter = (guint) 0;
}


static void ccm_vala_window_plugin_finalize (GObject* obj) {
	CCMValaWindowPlugin * self;
	self = CCM_VALA_WINDOW_PLUGIN (obj);
	{
		ccm_plugin_options_unload ((CCMPlugin*) self);
	}
	G_OBJECT_CLASS (ccm_vala_window_plugin_parent_class)->finalize (obj);
}


GType ccm_vala_window_plugin_get_type (void) {
	return ccm_vala_window_plugin_type_id;
}


GType ccm_vala_window_plugin_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMValaWindowPluginClass), (GBaseInitFunc) ccm_vala_window_plugin_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_vala_window_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMValaWindowPlugin), 0, (GInstanceInitFunc) ccm_vala_window_plugin_instance_init, NULL };
	static const GInterfaceInfo ccm_window_plugin_info = { (GInterfaceInitFunc) ccm_vala_window_plugin_ccm_window_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	ccm_vala_window_plugin_type_id = g_type_module_register_type (module, CCM_TYPE_PLUGIN, "CCMValaWindowPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, ccm_vala_window_plugin_type_id, CCM_TYPE_WINDOW_PLUGIN, &ccm_window_plugin_info);
	return ccm_vala_window_plugin_type_id;
}


GType ccm_vala_window_plugin_get_plugin_type (GTypeModule* module) {
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	ccm_vala_window_options_register_type (module);
	ccm_vala_window_plugin_register_type (module);
	result = CCM_TYPE_VALA_WINDOW_PLUGIN;
	return result;
}




