/* ccm-mosaic.c generated by valac, the Vala compiler
 * generated from ccm-mosaic.vala, do not modify */

/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * cairo-compmgr
 * Copyright (C) Nicolas Bruguier 2007-2010 <gandalfn@club-internet.fr>
 * 
 * cairo-compmgr is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * cairo-compmgr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with cairo-compmgr.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ccm-plugin.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <ccm-config.h>
#include <ccm-debug.h>
#include <cairo.h>
#include <ccm.h>
#include <ccm-window.h>
#include <ccm-window-plugin.h>
#include <ccm-screen-plugin.h>
#include <ccm-screen.h>
#include <ccm-keybind.h>
#include <valagee.h>
#include <ccm-timeline.h>
#include <gtk/gtk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <ccm-drawable.h>
#include <ccm-display.h>
#include <config.h>
#include <ccm-preferences-page.h>
#include <ccm-preferences-page-plugin.h>
#include <ccm-config-adjustment.h>
#include <ccm-config-entry-shortcut.h>
#include <gobject/gvaluecollector.h>


#define CCM_TYPE_OPTIONS (ccm_options_get_type ())

#define CCM_TYPE_MOSAIC_OPTIONS (ccm_mosaic_options_get_type ())
#define CCM_MOSAIC_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_MOSAIC_OPTIONS, CCMMosaicOptions))
#define CCM_MOSAIC_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_MOSAIC_OPTIONS, CCMMosaicOptionsClass))
#define CCM_IS_MOSAIC_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_MOSAIC_OPTIONS))
#define CCM_IS_MOSAIC_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_MOSAIC_OPTIONS))
#define CCM_MOSAIC_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_MOSAIC_OPTIONS, CCMMosaicOptionsClass))

typedef struct _CCMMosaicOptions CCMMosaicOptions;
typedef struct _CCMMosaicOptionsClass CCMMosaicOptionsClass;
typedef struct _CCMMosaicOptionsPrivate CCMMosaicOptionsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CCM_TYPE_MOSAIC_AREA (ccm_mosaic_area_get_type ())
#define CCM_MOSAIC_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_MOSAIC_AREA, CCMMosaicArea))
#define CCM_MOSAIC_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_MOSAIC_AREA, CCMMosaicAreaClass))
#define CCM_IS_MOSAIC_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_MOSAIC_AREA))
#define CCM_IS_MOSAIC_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_MOSAIC_AREA))
#define CCM_MOSAIC_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_MOSAIC_AREA, CCMMosaicAreaClass))

typedef struct _CCMMosaicArea CCMMosaicArea;
typedef struct _CCMMosaicAreaClass CCMMosaicAreaClass;
typedef struct _CCMMosaicAreaPrivate CCMMosaicAreaPrivate;

#define CCM_TYPE_MOSAIC (ccm_mosaic_get_type ())
#define CCM_MOSAIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_MOSAIC, CCMMosaic))
#define CCM_MOSAIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_MOSAIC, CCMMosaicClass))
#define CCM_IS_MOSAIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_MOSAIC))
#define CCM_IS_MOSAIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_MOSAIC))
#define CCM_MOSAIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_MOSAIC, CCMMosaicClass))

typedef struct _CCMMosaic CCMMosaic;
typedef struct _CCMMosaicClass CCMMosaicClass;
typedef struct _CCMParamSpecMosaicArea CCMParamSpecMosaicArea;
typedef struct _CCMMosaicPrivate CCMMosaicPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _ccm_mosaic_area_unref0(var) ((var == NULL) ? NULL : (var = (ccm_mosaic_area_unref (var), NULL)))
#define _ccm_region_destroy0(var) ((var == NULL) ? NULL : (var = (ccm_region_destroy (var), NULL)))

typedef enum  {
	CCM_OPTIONS_SPACING,
	CCM_OPTIONS_SHORTCUT,
	CCM_OPTIONS_DURATION,
	CCM_OPTIONS_N
} CCMOptions;

struct _CCMMosaicOptions {
	CCMPluginOptions parent_instance;
	CCMMosaicOptionsPrivate * priv;
	gint spacing;
	char* shortcut;
	double duration;
};

struct _CCMMosaicOptionsClass {
	CCMPluginOptionsClass parent_class;
};

struct _CCMMosaicArea {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CCMMosaicAreaPrivate * priv;
	cairo_rectangle_t geometry;
	CCMWindow* window;
	CCMMosaic* plugin;
};

struct _CCMMosaicAreaClass {
	GTypeClass parent_class;
	void (*finalize) (CCMMosaicArea *self);
};

struct _CCMParamSpecMosaicArea {
	GParamSpec parent_instance;
};

struct _CCMMosaic {
	CCMPlugin parent_instance;
	CCMMosaicPrivate * priv;
};

struct _CCMMosaicClass {
	CCMPluginClass parent_class;
};

struct _CCMMosaicPrivate {
	CCMMosaicArea* area;
	CCMScreen* screen;
	gboolean enabled;
	CCMKeybind* keybind;
	ValaArrayList* areas;
	gboolean mouse_over;
	CCMTimeline* timeline;
	double progress;
	GtkBuilder* builder;
};


static gpointer ccm_mosaic_options_parent_class = NULL;
static GType ccm_mosaic_options_type_id = 0;
static gpointer ccm_mosaic_area_parent_class = NULL;
static GType ccm_mosaic_area_type_id = 0;
static gpointer ccm_mosaic_parent_class = NULL;
static CCMScreenPluginIface* ccm_mosaic_ccm_screen_plugin_parent_iface = NULL;
static CCMWindowPluginIface* ccm_mosaic_ccm_window_plugin_parent_iface = NULL;
static CCMPreferencesPagePluginIface* ccm_mosaic_ccm_preferences_page_plugin_parent_iface = NULL;
static GType ccm_mosaic_type_id = 0;

GType ccm_options_get_type (void);
GType ccm_mosaic_options_get_type (void);
GType ccm_mosaic_options_register_type (GTypeModule * module);
enum  {
	CCM_MOSAIC_OPTIONS_DUMMY_PROPERTY
};
static void ccm_mosaic_options_real_changed (CCMPluginOptions* base, CCMConfig* config);
CCMMosaicOptions* ccm_mosaic_options_new (void);
CCMMosaicOptions* ccm_mosaic_options_construct (GType object_type);
static void ccm_mosaic_options_finalize (GObject* obj);
gpointer ccm_mosaic_area_ref (gpointer instance);
void ccm_mosaic_area_unref (gpointer instance);
GParamSpec* ccm_param_spec_mosaic_area (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void ccm_value_set_mosaic_area (GValue* value, gpointer v_object);
gpointer ccm_value_get_mosaic_area (const GValue* value);
GType ccm_mosaic_area_get_type (void);
GType ccm_mosaic_area_register_type (GTypeModule * module);
GType ccm_mosaic_get_type (void);
GType ccm_mosaic_register_type (GTypeModule * module);
enum  {
	CCM_MOSAIC_AREA_DUMMY_PROPERTY
};
CCMMosaicArea* ccm_mosaic_area_new (void);
CCMMosaicArea* ccm_mosaic_area_construct (GType object_type);
static void ccm_mosaic_area_finalize (CCMMosaicArea* obj);
#define CCM_MOSAIC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_MOSAIC, CCMMosaicPrivate))
enum  {
	CCM_MOSAIC_DUMMY_PROPERTY
};
static void ccm_mosaic_switch_keep_above (CCMMosaic* self, CCMWindow* window, gboolean keep_above);
static void ccm_mosaic_find_area (CCMMosaic* self, CCMWindow* window);
static void ccm_mosaic_on_window_animation_new_frame (CCMMosaic* self, gint frame);
static void _ccm_mosaic_on_window_animation_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self);
static void ccm_mosaic_create_areas (CCMMosaic* self);
static void ccm_mosaic_on_screen_animation_new_frame (CCMMosaic* self, gint frame);
static void ccm_mosaic_on_screen_animation_completed (CCMMosaic* self);
static void ccm_mosaic_on_window_activate_notify (CCMMosaic* self, CCMWindow* window);
static void ccm_mosaic_on_shortcut_pressed (CCMMosaic* self);
static void _ccm_mosaic_on_shortcut_pressed_ccm_keybind_key_press (CCMKeybind* _sender, gpointer self);
static void _ccm_mosaic_on_screen_animation_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self);
static void _ccm_mosaic_on_screen_animation_completed_ccm_timeline_completed (CCMTimeline* _sender, gpointer self);
static void ccm_mosaic_option_changed (CCMMosaic* self, gint index);
static void _lambda0_ (CCMWindow* window, CCMMosaic* self);
static void __lambda0__ccm_screen_enter_window_notify (CCMScreen* _sender, CCMWindow* window, gpointer self);
static void _lambda1_ (CCMWindow* window, CCMMosaic* self);
static void __lambda1__ccm_screen_leave_window_notify (CCMScreen* _sender, CCMWindow* window, gpointer self);
static void _ccm_mosaic_on_window_activate_notify_ccm_screen_activate_window_notify (CCMScreen* _sender, CCMWindow* window, gpointer self);
static void ccm_mosaic_real_screen_load_options (CCMScreenPlugin* base, CCMScreen* screen);
static gboolean ccm_mosaic_real_window_paint (CCMWindowPlugin* base, CCMWindow* window, cairo_t* ctx, cairo_surface_t* surface, gboolean y_invert);
static void ccm_mosaic_real_init_desktop_section (CCMPreferencesPagePlugin* base, CCMPreferencesPage* preferences, GtkWidget* desktop_section);
CCMMosaic* ccm_mosaic_new (void);
CCMMosaic* ccm_mosaic_construct (GType object_type);
static void ccm_mosaic_finalize (GObject* obj);
GType ccm_mosaic_get_plugin_type (GTypeModule* module);

static const char* CCM_MOSAIC_options_key[3] = {"spacing", "shortcut", "duration"};



GType ccm_options_get_type (void) {
	static GType ccm_options_type_id = 0;
	if (G_UNLIKELY (ccm_options_type_id == 0)) {
		static const GEnumValue values[] = {{CCM_OPTIONS_SPACING, "CCM_OPTIONS_SPACING", "spacing"}, {CCM_OPTIONS_SHORTCUT, "CCM_OPTIONS_SHORTCUT", "shortcut"}, {CCM_OPTIONS_DURATION, "CCM_OPTIONS_DURATION", "duration"}, {CCM_OPTIONS_N, "CCM_OPTIONS_N", "n"}, {0, NULL, NULL}};
		ccm_options_type_id = g_enum_register_static ("CCMOptions", values);
	}
	return ccm_options_type_id;
}


static void ccm_mosaic_options_real_changed (CCMPluginOptions* base, CCMConfig* config) {
	CCMMosaicOptions * self;
	GError * _inner_error_;
	self = (CCMMosaicOptions*) base;
	g_return_if_fail (config != NULL);
	_inner_error_ = NULL;
	if (config == ccm_plugin_options_get_config ((CCMPluginOptions*) self, (gint) CCM_OPTIONS_SPACING)) {
		gint real_spacing;
		gint spacing;
		real_spacing = 5;
		{
			gint _tmp0_;
			_tmp0_ = ccm_config_get_integer (config, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			real_spacing = _tmp0_;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				real_spacing = 5;
				_g_error_free0 (err);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		spacing = MIN (50, real_spacing);
		spacing = MAX (0, spacing);
		self->spacing = spacing;
		if (spacing != real_spacing) {
			{
				ccm_config_set_integer (config, spacing, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					ccm_log ("Error on set spacing config: %s", err->message, NULL);
					_g_error_free0 (err);
				}
			}
			__finally1:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	if (config == ccm_plugin_options_get_config ((CCMPluginOptions*) self, (gint) CCM_OPTIONS_SHORTCUT)) {
		char* _tmp1_;
		self->shortcut = (_tmp1_ = g_strdup ("<Super>Tab"), _g_free0 (self->shortcut), _tmp1_);
		{
			char* _tmp2_;
			char* _tmp3_;
			_tmp2_ = ccm_config_get_string (config, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
			self->shortcut = (_tmp3_ = _tmp2_, _g_free0 (self->shortcut), _tmp3_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * ex;
			ex = _inner_error_;
			_inner_error_ = NULL;
			{
				ccm_log ("Error on get shortcut config get default", NULL);
				_g_error_free0 (ex);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (config == ccm_plugin_options_get_config ((CCMPluginOptions*) self, (gint) CCM_OPTIONS_DURATION)) {
		double real_duration;
		double duration;
		real_duration = 0.3;
		{
			float _tmp4_;
			_tmp4_ = ccm_config_get_float (config, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			real_duration = (double) _tmp4_;
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				real_duration = 0.3;
				_g_error_free0 (err);
			}
		}
		__finally3:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		duration = MAX (0.1, real_duration);
		duration = MIN (0.9, duration);
		self->duration = duration;
		if (duration != real_duration) {
			{
				ccm_config_set_float (config, (float) duration, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
			}
			goto __finally4;
			__catch4_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					ccm_log ("Error on set duration config: %s", err->message, NULL);
					_g_error_free0 (err);
				}
			}
			__finally4:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


CCMMosaicOptions* ccm_mosaic_options_construct (GType object_type) {
	CCMMosaicOptions * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CCMMosaicOptions* ccm_mosaic_options_new (void) {
	return ccm_mosaic_options_construct (CCM_TYPE_MOSAIC_OPTIONS);
}


static void ccm_mosaic_options_class_init (CCMMosaicOptionsClass * klass) {
	ccm_mosaic_options_parent_class = g_type_class_peek_parent (klass);
	CCM_PLUGIN_OPTIONS_CLASS (klass)->changed = ccm_mosaic_options_real_changed;
	G_OBJECT_CLASS (klass)->finalize = ccm_mosaic_options_finalize;
}


static void ccm_mosaic_options_instance_init (CCMMosaicOptions * self) {
	self->spacing = 5;
	self->shortcut = g_strdup ("<Super>Tab");
	self->duration = 0.3;
}


static void ccm_mosaic_options_finalize (GObject* obj) {
	CCMMosaicOptions * self;
	self = CCM_MOSAIC_OPTIONS (obj);
	_g_free0 (self->shortcut);
	G_OBJECT_CLASS (ccm_mosaic_options_parent_class)->finalize (obj);
}


GType ccm_mosaic_options_get_type (void) {
	return ccm_mosaic_options_type_id;
}


GType ccm_mosaic_options_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMMosaicOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_mosaic_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMMosaicOptions), 0, (GInstanceInitFunc) ccm_mosaic_options_instance_init, NULL };
	ccm_mosaic_options_type_id = g_type_module_register_type (module, CCM_TYPE_PLUGIN_OPTIONS, "CCMMosaicOptions", &g_define_type_info, 0);
	return ccm_mosaic_options_type_id;
}


CCMMosaicArea* ccm_mosaic_area_construct (GType object_type) {
	CCMMosaicArea* self;
	self = (CCMMosaicArea*) g_type_create_instance (object_type);
	return self;
}


CCMMosaicArea* ccm_mosaic_area_new (void) {
	return ccm_mosaic_area_construct (CCM_TYPE_MOSAIC_AREA);
}


static void ccm_value_mosaic_area_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void ccm_value_mosaic_area_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		ccm_mosaic_area_unref (value->data[0].v_pointer);
	}
}


static void ccm_value_mosaic_area_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ccm_mosaic_area_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer ccm_value_mosaic_area_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* ccm_value_mosaic_area_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		CCMMosaicArea* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ccm_mosaic_area_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* ccm_value_mosaic_area_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CCMMosaicArea** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ccm_mosaic_area_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* ccm_param_spec_mosaic_area (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	CCMParamSpecMosaicArea* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CCM_TYPE_MOSAIC_AREA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer ccm_value_get_mosaic_area (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CCM_TYPE_MOSAIC_AREA), NULL);
	return value->data[0].v_pointer;
}


void ccm_value_set_mosaic_area (GValue* value, gpointer v_object) {
	CCMMosaicArea* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CCM_TYPE_MOSAIC_AREA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CCM_TYPE_MOSAIC_AREA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ccm_mosaic_area_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ccm_mosaic_area_unref (old);
	}
}


static void ccm_mosaic_area_class_init (CCMMosaicAreaClass * klass) {
	ccm_mosaic_area_parent_class = g_type_class_peek_parent (klass);
	CCM_MOSAIC_AREA_CLASS (klass)->finalize = ccm_mosaic_area_finalize;
}


static void ccm_mosaic_area_instance_init (CCMMosaicArea * self) {
	self->ref_count = 1;
}


static void ccm_mosaic_area_finalize (CCMMosaicArea* obj) {
	CCMMosaicArea * self;
	self = CCM_MOSAIC_AREA (obj);
}


GType ccm_mosaic_area_get_type (void) {
	return ccm_mosaic_area_type_id;
}


GType ccm_mosaic_area_register_type (GTypeModule * module) {
	static const GTypeValueTable g_define_type_value_table = { ccm_value_mosaic_area_init, ccm_value_mosaic_area_free_value, ccm_value_mosaic_area_copy_value, ccm_value_mosaic_area_peek_pointer, "p", ccm_value_mosaic_area_collect_value, "p", ccm_value_mosaic_area_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CCMMosaicAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_mosaic_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMMosaicArea), 0, (GInstanceInitFunc) ccm_mosaic_area_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	ccm_mosaic_area_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CCMMosaicArea", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return ccm_mosaic_area_type_id;
}


gpointer ccm_mosaic_area_ref (gpointer instance) {
	CCMMosaicArea* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void ccm_mosaic_area_unref (gpointer instance) {
	CCMMosaicArea* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CCM_MOSAIC_AREA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void ccm_mosaic_switch_keep_above (CCMMosaic* self, CCMWindow* window, gboolean keep_above) {
	XEvent _tmp0_ = {0};
	XEvent event;
	CCMDisplay* display;
	CCMScreen* screen;
	CCMWindow* root;
	Window _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	event = (memset (&_tmp0_, 0, sizeof (XEvent)), _tmp0_);
	display = ccm_drawable_get_display ((CCMDrawable*) window);
	screen = ccm_drawable_get_screen ((CCMDrawable*) window);
	root = ccm_screen_get_root_window (screen);
	event.xclient.type = (gint) ClientMessage;
	event.xclient.message_type = CCM_WINDOW_CLASS (G_OBJECT_GET_CLASS (window))->state_atom;
	event.xclient.display = ccm_display_get_xdisplay (display);
	if (_ccm_window_get_child (window) != None) {
		_tmp1_ = _ccm_window_get_child (window);
	} else {
		_tmp1_ = CCM_WINDOW_XWINDOW (window);
	}
	event.xclient.window = _tmp1_;
	event.xclient.send_event = TRUE;
	event.xclient.format = 32;
	if (keep_above) {
		_tmp2_ = 1;
	} else {
		_tmp2_ = 0;
	}
	event.xclient.data.l[0] = (glong) _tmp2_;
	event.xclient.data.l[1] = (glong) CCM_WINDOW_CLASS (G_OBJECT_GET_CLASS (window))->state_above_atom;
	event.xclient.data.l[2] = (glong) 0;
	event.xclient.data.l[3] = (glong) 0;
	event.xclient.data.l[4] = (glong) 0;
	XSendEvent (ccm_display_get_xdisplay (display), CCM_WINDOW_XWINDOW (root), TRUE, (glong) (SubstructureRedirectMask | SubstructureNotifyMask), &event);
	ccm_display_flush (display);
}


static void _ccm_mosaic_on_window_animation_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self) {
	ccm_mosaic_on_window_animation_new_frame (self, object);
}


static void ccm_mosaic_find_area (CCMMosaic* self, CCMWindow* window) {
	cairo_rectangle_t* win_area;
	CCMMosaicArea* found;
	double search;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	win_area = ccm_window_get_area (window);
	found = NULL;
	search = DBL_MAX;
	{
		ValaIterator* _area_it;
		_area_it = vala_iterable_iterator ((ValaIterable*) self->priv->areas);
		while (TRUE) {
			CCMMosaicArea* area;
			double dist;
			if (!vala_iterator_next (_area_it)) {
				break;
			}
			area = (CCMMosaicArea*) vala_iterator_get (_area_it);
			dist = pow (area->geometry.x - (*win_area).x, (double) 2) + pow (area->geometry.y - (*win_area).y, (double) 2);
			if (dist < search) {
				if (area->window == NULL) {
					found = area;
					search = dist;
					_ccm_mosaic_area_unref0 (area);
					break;
				} else {
					cairo_rectangle_t* awa;
					awa = ccm_window_get_area (area->window);
					if (dist < (pow (area->geometry.x - (*awa).x, (double) 2) + pow (area->geometry.y - (*awa).y, (double) 2))) {
						CCMWindow* conflict;
						conflict = area->window;
						area->window = window;
						ccm_mosaic_find_area (self, conflict);
						found = area;
						search = dist;
						_ccm_mosaic_area_unref0 (area);
						break;
					}
				}
			}
			_ccm_mosaic_area_unref0 (area);
		}
		_vala_collection_object_unref0 (_area_it);
	}
	if (found == NULL) {
		{
			ValaIterator* _area_it;
			_area_it = vala_iterable_iterator ((ValaIterable*) self->priv->areas);
			while (TRUE) {
				CCMMosaicArea* area;
				if (!vala_iterator_next (_area_it)) {
					break;
				}
				area = (CCMMosaicArea*) vala_iterator_get (_area_it);
				if (area->window == NULL) {
					CCMTimeline* _tmp0_;
					area->window = window;
					area->plugin = CCM_MOSAIC (_ccm_window_get_plugin (window, CCM_TYPE_MOSAIC));
					area->plugin->priv->area = area;
					area->plugin->priv->enabled = TRUE;
					area->plugin->priv->mouse_over = FALSE;
					area->plugin->priv->timeline = (_tmp0_ = ccm_timeline_new_for_duration ((guint) ((gint) (CCM_MOSAIC_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->duration * 1000.0))), _g_object_unref0 (area->plugin->priv->timeline), _tmp0_);
					g_signal_connect_object (area->plugin->priv->timeline, "new-frame", (GCallback) _ccm_mosaic_on_window_animation_new_frame_ccm_timeline_new_frame, area->plugin, 0);
					_ccm_mosaic_area_unref0 (area);
					break;
				}
				_ccm_mosaic_area_unref0 (area);
			}
			_vala_collection_object_unref0 (_area_it);
		}
	} else {
		CCMTimeline* _tmp1_;
		found->window = window;
		found->plugin = CCM_MOSAIC (_ccm_window_get_plugin (window, CCM_TYPE_MOSAIC));
		found->plugin->priv->area = found;
		found->plugin->priv->enabled = TRUE;
		found->plugin->priv->timeline = (_tmp1_ = ccm_timeline_new_for_duration ((guint) ((gint) (CCM_MOSAIC_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->duration * 1000.0))), _g_object_unref0 (found->plugin->priv->timeline), _tmp1_);
		g_signal_connect_object (found->plugin->priv->timeline, "new-frame", (GCallback) _ccm_mosaic_on_window_animation_new_frame_ccm_timeline_new_frame, found->plugin, 0);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ccm_mosaic_create_areas (CCMMosaic* self) {
	gint nb_windows;
	gint lines;
	gint x = 0;
	gint y = 0;
	gint width = 0;
	gint height = 0;
	gint spacing;
	g_return_if_fail (self != NULL);
	if (self->priv->areas == NULL) {
		ValaArrayList* _tmp0_;
		self->priv->areas = (_tmp0_ = vala_array_list_new (CCM_TYPE_MOSAIC_AREA, (GBoxedCopyFunc) ccm_mosaic_area_ref, ccm_mosaic_area_unref, g_direct_equal), _vala_collection_object_unref0 (self->priv->areas), _tmp0_);
	} else {
		vala_collection_clear ((ValaCollection*) self->priv->areas);
	}
	nb_windows = 0;
	{
		GList* window_collection;
		GList* window_it;
		window_collection = ccm_screen_get_windows (self->priv->screen);
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			CCMWindow* window;
			window = _g_object_ref0 ((CCMWindow*) window_it->data);
			{
				gboolean _tmp1_ = FALSE;
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				if (ccm_window_is_decorated (window)) {
					_tmp3_ = ccm_window_is_managed (window);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					_tmp2_ = ccm_window_is_viewable (window);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					_tmp1_ = ccm_window_get_hint_type (window) == CCM_WINDOW_TYPE_NORMAL;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					nb_windows++;
				}
				_g_object_unref0 (window);
			}
		}
	}
	lines = (gint) sqrt ((double) (nb_windows + 1));
	spacing = CCM_MOSAIC_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->spacing;
	y = spacing;
	height = (ccm_screen_get_xscreen (self->priv->screen)->height - ((lines + 1) * spacing)) / lines;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint n;
				if (!_tmp4_) {
					i = i + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < lines)) {
					break;
				}
				n = MIN (nb_windows - vala_collection_get_size ((ValaCollection*) self->priv->areas), (gint) ceilf (((float) nb_windows) / lines));
				x = spacing;
				width = (ccm_screen_get_xscreen (self->priv->screen)->width - ((n + 1) * spacing)) / n;
				{
					gint j;
					j = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							CCMMosaicArea* area;
							if (!_tmp5_) {
								j = j + 1;
							}
							_tmp5_ = FALSE;
							if (!(j < n)) {
								break;
							}
							area = ccm_mosaic_area_new ();
							area->geometry.x = (double) x;
							area->geometry.y = (double) y;
							area->geometry.width = (double) width;
							area->geometry.height = (double) height;
							vala_collection_add ((ValaCollection*) self->priv->areas, area);
							x = x + (width + spacing);
							_ccm_mosaic_area_unref0 (area);
						}
					}
				}
				y = y + (height + spacing);
			}
		}
	}
	{
		GList* window_collection;
		GList* window_it;
		window_collection = ccm_screen_get_windows (self->priv->screen);
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			CCMWindow* window;
			window = _g_object_ref0 ((CCMWindow*) window_it->data);
			{
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				if (ccm_window_is_decorated (window)) {
					_tmp8_ = ccm_window_is_managed (window);
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					_tmp7_ = ccm_window_is_viewable (window);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = ccm_window_get_hint_type (window) == CCM_WINDOW_TYPE_NORMAL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					ccm_mosaic_find_area (self, window);
				}
				_g_object_unref0 (window);
			}
		}
	}
}


static void ccm_mosaic_on_screen_animation_new_frame (CCMMosaic* self, gint frame) {
	g_return_if_fail (self != NULL);
	{
		ValaIterator* _area_it;
		_area_it = vala_iterable_iterator ((ValaIterable*) self->priv->areas);
		while (TRUE) {
			CCMMosaicArea* area;
			cairo_rectangle_t win_area = {0};
			if (!vala_iterator_next (_area_it)) {
				break;
			}
			area = (CCMMosaicArea*) vala_iterator_get (_area_it);
			if (ccm_drawable_get_device_geometry_clipbox ((CCMDrawable*) area->window, &win_area)) {
				double progress;
				double scale;
				double x;
				double y;
				cairo_matrix_t _tmp0_ = {0};
				cairo_matrix_t matrix;
				progress = ccm_timeline_get_progress (self->priv->timeline);
				scale = MIN (area->geometry.width / win_area.width, area->geometry.height / win_area.height);
				scale = scale + ((1.0 - scale) * progress);
				x = (area->geometry.x - win_area.x) - (((win_area.width * scale) - area->geometry.width) / 2.0);
				y = (area->geometry.y - win_area.y) - (((win_area.height * scale) - area->geometry.height) / 2.0);
				x = x + (((win_area.x - x) * progress) - (progress * win_area.x));
				y = y + (((win_area.y - y) * progress) - (progress * win_area.y));
				matrix = (cairo_matrix_init (&_tmp0_, scale, (double) 0, (double) 0, scale, x, y), _tmp0_);
				ccm_drawable_push_matrix ((CCMDrawable*) area->window, "CCMMosaic", &matrix);
				g_object_set (area->window, "block-mouse-redirect-event", TRUE, NULL);
				area->plugin->priv->progress = 1.0 - progress;
			}
			_ccm_mosaic_area_unref0 (area);
		}
		_vala_collection_object_unref0 (_area_it);
	}
	ccm_screen_damage (self->priv->screen);
}


static void ccm_mosaic_on_screen_animation_completed (CCMMosaic* self) {
	g_return_if_fail (self != NULL);
	if (ccm_timeline_get_direction (self->priv->timeline) == CCM_TIMELINE_BACKWARD) {
		CCMWindow* mouse;
		gint x_mouse = 0;
		gint y_mouse = 0;
		{
			ValaIterator* _area_it;
			_area_it = vala_iterable_iterator ((ValaIterable*) self->priv->areas);
			while (TRUE) {
				CCMMosaicArea* area;
				if (!vala_iterator_next (_area_it)) {
					break;
				}
				area = (CCMMosaicArea*) vala_iterator_get (_area_it);
				if (CCM_IS_WINDOW (area->window)) {
					cairo_rectangle_t win_area = {0};
					if (ccm_drawable_get_device_geometry_clipbox ((CCMDrawable*) area->window, &win_area)) {
						double scale;
						double x;
						double y;
						cairo_matrix_t _tmp0_ = {0};
						cairo_matrix_t matrix;
						scale = MIN (area->geometry.width / win_area.width, area->geometry.height / win_area.height);
						x = (area->geometry.x - win_area.x) - (((win_area.width * scale) - area->geometry.width) / 2.0);
						y = (area->geometry.y - win_area.y) - (((win_area.height * scale) - area->geometry.height) / 2.0);
						matrix = (cairo_matrix_init (&_tmp0_, scale, (double) 0, (double) 0, scale, x, y), _tmp0_);
						ccm_drawable_push_matrix ((CCMDrawable*) area->window, "CCMMosaic", &matrix);
					}
				}
				_ccm_mosaic_area_unref0 (area);
			}
			_vala_collection_object_unref0 (_area_it);
		}
		mouse = NULL;
		ccm_screen_query_pointer (self->priv->screen, &mouse, &x_mouse, &y_mouse);
		{
			ValaIterator* _area_it;
			_area_it = vala_iterable_iterator ((ValaIterable*) self->priv->areas);
			while (TRUE) {
				CCMMosaicArea* area;
				if (!vala_iterator_next (_area_it)) {
					break;
				}
				area = (CCMMosaicArea*) vala_iterator_get (_area_it);
				if (CCM_IS_WINDOW (area->window)) {
					area->plugin->priv->mouse_over = area->window == mouse;
					if (area->plugin->priv->mouse_over) {
						ccm_timeline_set_direction (area->plugin->priv->timeline, CCM_TIMELINE_FORWARD);
						ccm_timeline_rewind (area->plugin->priv->timeline);
						ccm_timeline_start (area->plugin->priv->timeline);
						ccm_mosaic_switch_keep_above (self, area->window, TRUE);
						ccm_drawable_damage ((CCMDrawable*) area->window);
					}
				}
				_ccm_mosaic_area_unref0 (area);
			}
			_vala_collection_object_unref0 (_area_it);
		}
	} else {
		{
			ValaIterator* _area_it;
			_area_it = vala_iterable_iterator ((ValaIterable*) self->priv->areas);
			while (TRUE) {
				CCMMosaicArea* area;
				if (!vala_iterator_next (_area_it)) {
					break;
				}
				area = (CCMMosaicArea*) vala_iterator_get (_area_it);
				if (CCM_IS_WINDOW (area->window)) {
					ccm_drawable_pop_matrix ((CCMDrawable*) area->window, "CCMMosaic");
					g_object_set (area->window, "block-mouse-redirect-event", FALSE, NULL);
					area->plugin->priv->enabled = FALSE;
					area->plugin->priv->area = NULL;
					ccm_mosaic_switch_keep_above (self, area->window, FALSE);
				}
				_ccm_mosaic_area_unref0 (area);
			}
			_vala_collection_object_unref0 (_area_it);
		}
		vala_collection_clear ((ValaCollection*) self->priv->areas);
	}
	ccm_screen_damage (self->priv->screen);
}


static void ccm_mosaic_on_window_animation_new_frame (CCMMosaic* self, gint frame) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->area != NULL) {
		_tmp0_ = CCM_IS_WINDOW (self->priv->area->window);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		cairo_rectangle_t win_area = {0};
		if (ccm_drawable_get_device_geometry_clipbox ((CCMDrawable*) self->priv->area->window, &win_area)) {
			double progress;
			double spacing;
			double width;
			double height;
			double scale;
			double x;
			double y;
			cairo_matrix_t _tmp1_ = {0};
			cairo_matrix_t matrix;
			progress = ccm_timeline_get_progress (self->priv->timeline);
			spacing = (double) CCM_MOSAIC_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->spacing;
			width = self->priv->area->geometry.width + ((2.5 * spacing) * progress);
			height = self->priv->area->geometry.height + ((2.5 * spacing) * progress);
			scale = MIN (width / win_area.width, height / win_area.height);
			x = (self->priv->area->geometry.x - win_area.x) - (((win_area.width * scale) - width) / 2.0);
			y = (self->priv->area->geometry.y - win_area.y) - (((win_area.height * scale) - height) / 2.0);
			x = x - ((width - self->priv->area->geometry.width) / 2.0);
			y = y - ((height - self->priv->area->geometry.height) / 2.0);
			ccm_drawable_damage ((CCMDrawable*) self->priv->area->window);
			matrix = (cairo_matrix_init (&_tmp1_, scale, (double) 0, (double) 0, scale, x, y), _tmp1_);
			ccm_drawable_push_matrix ((CCMDrawable*) self->priv->area->window, "CCMMosaic", &matrix);
			ccm_drawable_damage ((CCMDrawable*) self->priv->area->window);
			self->priv->progress = 1.0 - progress;
		}
	}
}


static void ccm_mosaic_on_window_activate_notify (CCMMosaic* self, CCMWindow* window) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	if (self->priv->enabled) {
		self->priv->enabled = FALSE;
		if (ccm_timeline_is_playing (self->priv->timeline)) {
			ccm_timeline_stop (self->priv->timeline);
		}
		ccm_timeline_set_direction (self->priv->timeline, CCM_TIMELINE_FORWARD);
		ccm_timeline_rewind (self->priv->timeline);
		ccm_timeline_start (self->priv->timeline);
	}
}


static void ccm_mosaic_on_shortcut_pressed (CCMMosaic* self) {
	CCMTimelineDirection _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	self->priv->enabled = !self->priv->enabled;
	if (ccm_timeline_is_playing (self->priv->timeline)) {
		ccm_timeline_stop (self->priv->timeline);
	}
	if (self->priv->enabled) {
		ccm_mosaic_create_areas (self);
	} else {
		{
			ValaIterator* _area_it;
			_area_it = vala_iterable_iterator ((ValaIterable*) self->priv->areas);
			while (TRUE) {
				CCMMosaicArea* area;
				gboolean _tmp0_ = FALSE;
				if (!vala_iterator_next (_area_it)) {
					break;
				}
				area = (CCMMosaicArea*) vala_iterator_get (_area_it);
				if (CCM_IS_WINDOW (area)) {
					_tmp0_ = ccm_window_keep_above (area->window);
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					ccm_mosaic_switch_keep_above (self, area->window, FALSE);
				}
				_ccm_mosaic_area_unref0 (area);
			}
			_vala_collection_object_unref0 (_area_it);
		}
	}
	if (self->priv->enabled) {
		_tmp1_ = CCM_TIMELINE_BACKWARD;
	} else {
		_tmp1_ = CCM_TIMELINE_FORWARD;
	}
	ccm_timeline_set_direction (self->priv->timeline, _tmp1_);
	ccm_timeline_rewind (self->priv->timeline);
	ccm_timeline_start (self->priv->timeline);
}


static void _ccm_mosaic_on_shortcut_pressed_ccm_keybind_key_press (CCMKeybind* _sender, gpointer self) {
	ccm_mosaic_on_shortcut_pressed (self);
}


static void _ccm_mosaic_on_screen_animation_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self) {
	ccm_mosaic_on_screen_animation_new_frame (self, object);
}


static void _ccm_mosaic_on_screen_animation_completed_ccm_timeline_completed (CCMTimeline* _sender, gpointer self) {
	ccm_mosaic_on_screen_animation_completed (self);
}


static void ccm_mosaic_option_changed (CCMMosaic* self, gint index) {
	g_return_if_fail (self != NULL);
	switch (index) {
		case CCM_OPTIONS_SHORTCUT:
		{
			CCMKeybind* _tmp0_;
			self->priv->keybind = (_tmp0_ = ccm_keybind_new (self->priv->screen, CCM_MOSAIC_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->shortcut, TRUE), _g_object_unref0 (self->priv->keybind), _tmp0_);
			g_signal_connect_object (self->priv->keybind, "key-press", (GCallback) _ccm_mosaic_on_shortcut_pressed_ccm_keybind_key_press, self, 0);
			break;
		}
		case CCM_OPTIONS_DURATION:
		{
			CCMTimeline* _tmp1_;
			self->priv->timeline = (_tmp1_ = ccm_timeline_new_for_duration ((guint) ((gint) (CCM_MOSAIC_OPTIONS (ccm_plugin_get_option ((CCMPlugin*) self))->duration * 1000.0))), _g_object_unref0 (self->priv->timeline), _tmp1_);
			g_signal_connect_object (self->priv->timeline, "new-frame", (GCallback) _ccm_mosaic_on_screen_animation_new_frame_ccm_timeline_new_frame, self, 0);
			g_signal_connect_object (self->priv->timeline, "completed", (GCallback) _ccm_mosaic_on_screen_animation_completed_ccm_timeline_completed, self, 0);
			break;
		}
		default:
		{
			break;
		}
	}
}


static void _lambda0_ (CCMWindow* window, CCMMosaic* self) {
	CCMMosaic* plugin;
	g_return_if_fail (window != NULL);
	plugin = _g_object_ref0 (CCM_MOSAIC (_ccm_window_get_plugin (window, CCM_TYPE_MOSAIC)));
	if (plugin->priv->enabled) {
		ccm_timeline_set_direction (plugin->priv->timeline, CCM_TIMELINE_FORWARD);
		ccm_timeline_rewind (plugin->priv->timeline);
		ccm_timeline_start (plugin->priv->timeline);
		ccm_mosaic_switch_keep_above (self, window, TRUE);
		plugin->priv->mouse_over = TRUE;
		ccm_drawable_damage ((CCMDrawable*) window);
	}
	_g_object_unref0 (plugin);
}


static void __lambda0__ccm_screen_enter_window_notify (CCMScreen* _sender, CCMWindow* window, gpointer self) {
	_lambda0_ (window, self);
}


static void _lambda1_ (CCMWindow* window, CCMMosaic* self) {
	CCMMosaic* plugin;
	g_return_if_fail (window != NULL);
	plugin = _g_object_ref0 (CCM_MOSAIC (_ccm_window_get_plugin (window, CCM_TYPE_MOSAIC)));
	if (plugin->priv->enabled) {
		plugin->priv->mouse_over = FALSE;
		ccm_timeline_set_direction (plugin->priv->timeline, CCM_TIMELINE_BACKWARD);
		ccm_timeline_rewind (plugin->priv->timeline);
		ccm_timeline_start (plugin->priv->timeline);
		ccm_mosaic_switch_keep_above (self, window, FALSE);
		ccm_drawable_damage ((CCMDrawable*) window);
	}
	_g_object_unref0 (plugin);
}


static void __lambda1__ccm_screen_leave_window_notify (CCMScreen* _sender, CCMWindow* window, gpointer self) {
	_lambda1_ (window, self);
}


static void _ccm_mosaic_on_window_activate_notify_ccm_screen_activate_window_notify (CCMScreen* _sender, CCMWindow* window, gpointer self) {
	ccm_mosaic_on_window_activate_notify (self, window);
}


static void ccm_mosaic_real_screen_load_options (CCMScreenPlugin* base, CCMScreen* screen) {
	CCMMosaic * self;
	self = (CCMMosaic*) base;
	g_return_if_fail (screen != NULL);
	self->priv->screen = screen;
	ccm_plugin_options_load ((CCMPlugin*) self, "mosaic", CCM_MOSAIC_options_key, G_N_ELEMENTS (CCM_MOSAIC_options_key), (CCMPluginOptionsChangedFunc) ccm_mosaic_option_changed);
	ccm_screen_plugin_load_options (CCM_SCREEN_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), screen);
	g_signal_connect_object (screen, "enter-window-notify", (GCallback) __lambda0__ccm_screen_enter_window_notify, self, 0);
	g_signal_connect_object (screen, "leave-window-notify", (GCallback) __lambda1__ccm_screen_leave_window_notify, self, 0);
	g_signal_connect_object (screen, "activate-window-notify", (GCallback) _ccm_mosaic_on_window_activate_notify_ccm_screen_activate_window_notify, self, 0);
}


static gboolean ccm_mosaic_real_window_paint (CCMWindowPlugin* base, CCMWindow* window, cairo_t* ctx, cairo_surface_t* surface, gboolean y_invert) {
	CCMMosaic * self;
	gboolean result;
	gboolean ret;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	self = (CCMMosaic*) base;
	g_return_val_if_fail (window != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	g_return_val_if_fail (surface != NULL, FALSE);
	ret = FALSE;
	ret = ccm_window_plugin_paint (CCM_WINDOW_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), window, ctx, surface, y_invert);
	if (ret) {
		_tmp1_ = self->priv->enabled;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !self->priv->mouse_over;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint rectangles_size;
		gint rectangles_length1;
		cairo_rectangle_t* rectangles;
		CCMRegion* area;
		rectangles = (rectangles_length1 = 0, NULL);
		area = ccm_window_get_area_geometry (window);
		cairo_save (ctx);
		cairo_set_source_rgba (ctx, (double) 0, (double) 0, (double) 0, 0.5 * self->priv->progress);
		ccm_region_get_rectangles (area, &rectangles, &rectangles_length1);
		{
			cairo_rectangle_t* rectangle_collection;
			int rectangle_collection_length1;
			int rectangle_it;
			rectangle_collection = rectangles;
			rectangle_collection_length1 = rectangles_length1;
			for (rectangle_it = 0; rectangle_it < rectangles_length1; rectangle_it = rectangle_it + 1) {
				cairo_rectangle_t rectangle;
				rectangle = rectangle_collection[rectangle_it];
				{
					cairo_rectangle (ctx, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
				}
			}
		}
		cairo_fill (ctx);
		cairo_rectangles_free (rectangles, rectangles_length1);
		cairo_restore (ctx);
		_ccm_region_destroy0 (area);
	}
	result = ret;
	return result;
}


static void ccm_mosaic_real_init_desktop_section (CCMPreferencesPagePlugin* base, CCMPreferencesPage* preferences, GtkWidget* desktop_section) {
	CCMMosaic * self;
	GError * _inner_error_;
	GtkBuilder* _tmp0_;
	self = (CCMMosaic*) base;
	g_return_if_fail (preferences != NULL);
	g_return_if_fail (desktop_section != NULL);
	_inner_error_ = NULL;
	self->priv->builder = (_tmp0_ = gtk_builder_new (), _g_object_unref0 (self->priv->builder), _tmp0_);
	{
		GObject* _tmp1_;
		GtkWidget* widget;
		gtk_builder_add_from_file (self->priv->builder, UI_DIR "/ccm-mosaic.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		widget = _g_object_ref0 ((_tmp1_ = gtk_builder_get_object (self->priv->builder, "mosaic"), GTK_IS_WIDGET (_tmp1_) ? ((GtkWidget*) _tmp1_) : NULL));
		if (widget != NULL) {
			gint screen_num;
			GObject* _tmp2_;
			CCMConfigAdjustment* duration;
			GObject* _tmp3_;
			CCMConfigAdjustment* spacing;
			GObject* _tmp4_;
			CCMConfigEntryShortcut* shortcut;
			screen_num = ccm_preferences_page_get_screen_num (preferences);
			gtk_box_pack_start (GTK_BOX (desktop_section), widget, FALSE, TRUE, (guint) 0);
			duration = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (self->priv->builder, "duration-adjustment"), CCM_IS_CONFIG_ADJUSTMENT (_tmp2_) ? ((CCMConfigAdjustment*) _tmp2_) : NULL));
			g_object_set (duration, "screen", screen_num, NULL);
			spacing = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (self->priv->builder, "spacing-adjustment"), CCM_IS_CONFIG_ADJUSTMENT (_tmp3_) ? ((CCMConfigAdjustment*) _tmp3_) : NULL));
			g_object_set (spacing, "screen", screen_num, NULL);
			shortcut = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (self->priv->builder, "shortcut"), CCM_IS_CONFIG_ENTRY_SHORTCUT (_tmp4_) ? ((CCMConfigEntryShortcut*) _tmp4_) : NULL));
			g_object_set (shortcut, "screen", screen_num, NULL);
			ccm_preferences_page_section_register_widget (preferences, CCM_PREFERENCES_PAGE_SECTION_DESKTOP, widget, "mosaic");
			_g_object_unref0 (duration);
			_g_object_unref0 (spacing);
			_g_object_unref0 (shortcut);
		}
		_g_object_unref0 (widget);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			ccm_log ("%s", err->message, NULL);
			_g_error_free0 (err);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	ccm_preferences_page_plugin_init_desktop_section (CCM_PREFERENCES_PAGE_PLUGIN (ccm_plugin_get_parent ((CCMPlugin*) self)), preferences, desktop_section);
}


CCMMosaic* ccm_mosaic_construct (GType object_type) {
	CCMMosaic * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CCMMosaic* ccm_mosaic_new (void) {
	return ccm_mosaic_construct (CCM_TYPE_MOSAIC);
}


static void ccm_mosaic_base_init (CCMMosaicClass * klass) {
	{
		CCM_PLUGIN_CLASS (klass)->type_options = CCM_TYPE_MOSAIC_OPTIONS;
	}
}


static void ccm_mosaic_class_init (CCMMosaicClass * klass) {
	ccm_mosaic_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMMosaicPrivate));
	G_OBJECT_CLASS (klass)->finalize = ccm_mosaic_finalize;
}


static void ccm_mosaic_ccm_screen_plugin_interface_init (CCMScreenPluginIface * iface) {
	ccm_mosaic_ccm_screen_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->load_options = ccm_mosaic_real_screen_load_options;
}


static void ccm_mosaic_ccm_window_plugin_interface_init (CCMWindowPluginIface * iface) {
	ccm_mosaic_ccm_window_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->paint = ccm_mosaic_real_window_paint;
}


static void ccm_mosaic_ccm_preferences_page_plugin_interface_init (CCMPreferencesPagePluginIface * iface) {
	ccm_mosaic_ccm_preferences_page_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->init_desktop_section = ccm_mosaic_real_init_desktop_section;
}


static void ccm_mosaic_instance_init (CCMMosaic * self) {
	self->priv = CCM_MOSAIC_GET_PRIVATE (self);
	self->priv->area = NULL;
	self->priv->enabled = FALSE;
	self->priv->mouse_over = FALSE;
	self->priv->builder = NULL;
}


static void ccm_mosaic_finalize (GObject* obj) {
	CCMMosaic * self;
	self = CCM_MOSAIC (obj);
	{
		if (self->priv->screen != NULL) {
			ccm_plugin_options_unload ((CCMPlugin*) self);
		}
	}
	_g_object_unref0 (self->priv->keybind);
	_vala_collection_object_unref0 (self->priv->areas);
	_g_object_unref0 (self->priv->timeline);
	_g_object_unref0 (self->priv->builder);
	G_OBJECT_CLASS (ccm_mosaic_parent_class)->finalize (obj);
}


GType ccm_mosaic_get_type (void) {
	return ccm_mosaic_type_id;
}


GType ccm_mosaic_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMMosaicClass), (GBaseInitFunc) ccm_mosaic_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_mosaic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMMosaic), 0, (GInstanceInitFunc) ccm_mosaic_instance_init, NULL };
	static const GInterfaceInfo ccm_screen_plugin_info = { (GInterfaceInitFunc) ccm_mosaic_ccm_screen_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo ccm_window_plugin_info = { (GInterfaceInitFunc) ccm_mosaic_ccm_window_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo ccm_preferences_page_plugin_info = { (GInterfaceInitFunc) ccm_mosaic_ccm_preferences_page_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	ccm_mosaic_type_id = g_type_module_register_type (module, CCM_TYPE_PLUGIN, "CCMMosaic", &g_define_type_info, 0);
	g_type_module_add_interface (module, ccm_mosaic_type_id, CCM_TYPE_SCREEN_PLUGIN, &ccm_screen_plugin_info);
	g_type_module_add_interface (module, ccm_mosaic_type_id, CCM_TYPE_WINDOW_PLUGIN, &ccm_window_plugin_info);
	g_type_module_add_interface (module, ccm_mosaic_type_id, CCM_TYPE_PREFERENCES_PAGE_PLUGIN, &ccm_preferences_page_plugin_info);
	return ccm_mosaic_type_id;
}


GType ccm_mosaic_get_plugin_type (GTypeModule* module) {
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	ccm_mosaic_options_register_type (module);
	ccm_mosaic_area_register_type (module);
	ccm_mosaic_register_type (module);
	result = CCM_TYPE_MOSAIC;
	return result;
}




