/* ccm-automate-dialog.c generated by valac, the Vala compiler
 * generated from ccm-automate-dialog.vala, do not modify */

/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * cairo-compmgr
 * Copyright (C) Nicolas Bruguier 2008 <gandalfn@club-internet.fr>
 * 
 * cairo-compmgr is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * cairo-compmgr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with cairo-compmgr.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <ccm.h>
#include <ccm-screen.h>
#include <ccm-timeline.h>
#include <gtk/gtk.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdkx.h>
#include <cairo.h>
#include <ccm-cairo-utils.h>
#include <ccm-window.h>
#include <ccm-window-plugin.h>
#include <stdio.h>
#include <ccm-debug.h>


#define CCM_TYPE_AUTOMATE_DIALOG (ccm_automate_dialog_get_type ())
#define CCM_AUTOMATE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_AUTOMATE_DIALOG, CCMAutomateDialog))
#define CCM_AUTOMATE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_AUTOMATE_DIALOG, CCMAutomateDialogClass))
#define CCM_IS_AUTOMATE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_AUTOMATE_DIALOG))
#define CCM_IS_AUTOMATE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_AUTOMATE_DIALOG))
#define CCM_AUTOMATE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_AUTOMATE_DIALOG, CCMAutomateDialogClass))

typedef struct _CCMAutomateDialog CCMAutomateDialog;
typedef struct _CCMAutomateDialogClass CCMAutomateDialogClass;
typedef struct _CCMAutomateDialogPrivate CCMAutomateDialogPrivate;

#define CCM_TYPE_STORY_BOARD (ccm_story_board_get_type ())
#define CCM_STORY_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_STORY_BOARD, CCMStoryBoard))
#define CCM_STORY_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_STORY_BOARD, CCMStoryBoardClass))
#define CCM_IS_STORY_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_STORY_BOARD))
#define CCM_IS_STORY_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_STORY_BOARD))
#define CCM_STORY_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_STORY_BOARD, CCMStoryBoardClass))

typedef struct _CCMStoryBoard CCMStoryBoard;
typedef struct _CCMStoryBoardClass CCMStoryBoardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CCMAutomateDialog {
	GObject parent_instance;
	CCMAutomateDialogPrivate * priv;
};

struct _CCMAutomateDialogClass {
	GObjectClass parent_class;
};

struct _CCMAutomateDialogPrivate {
	CCMScreen* screen;
	CCMTimeline* timeline;
	GtkWindow* main;
	GtkWidget* close;
	GtkImage* close_image;
	GtkCheckButton* hint_motion;
	CCMStoryBoard* story_board;
};


static gpointer ccm_automate_dialog_parent_class = NULL;
static GType ccm_automate_dialog_type_id = 0;

Window GDK_WINDOW_XWINDOW (GdkWindow* window);
GType ccm_automate_dialog_get_type (void);
GType ccm_automate_dialog_register_type (GTypeModule * module);
GType ccm_story_board_get_type (void);
GType ccm_story_board_register_type (GTypeModule * module);
#define CCM_AUTOMATE_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CCM_TYPE_AUTOMATE_DIALOG, CCMAutomateDialogPrivate))
enum  {
	CCM_AUTOMATE_DIALOG_DUMMY_PROPERTY
};
#define CCM_AUTOMATE_DIALOG_UI_FILE UI_DIR "/ccm-automate.ui"
static void ccm_automate_dialog_on_new_frame (CCMAutomateDialog* self, CCMTimeline* timeline, gint num_frame);
static void _ccm_automate_dialog_on_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self);
static void ccm_automate_dialog_on_completed (CCMAutomateDialog* self, CCMTimeline* timeline);
static void _ccm_automate_dialog_on_completed_ccm_timeline_completed (CCMTimeline* _sender, gpointer self);
static void ccm_automate_dialog_construct_ui (CCMAutomateDialog* self);
CCMAutomateDialog* ccm_automate_dialog_new (CCMScreen* screen);
CCMAutomateDialog* ccm_automate_dialog_construct (GType object_type, CCMScreen* screen);
static void ccm_automate_dialog_on_realize (CCMAutomateDialog* self, GtkWidget* widget);
static gboolean ccm_automate_dialog_on_expose_event (CCMAutomateDialog* self, GtkWidget* widget, GdkEventExpose* event);
static gboolean ccm_automate_dialog_on_close (CCMAutomateDialog* self, GtkWidget* widget, GdkEventButton* event);
CCMStoryBoard* ccm_story_board_new (CCMScreen* screen, const char* name, GList* ignore);
CCMStoryBoard* ccm_story_board_construct (GType object_type, CCMScreen* screen, const char* name, GList* ignore);
void ccm_story_board_set_hint_motion (CCMStoryBoard* self, gboolean value);
static void ccm_automate_dialog_on_record_clicked (CCMAutomateDialog* self, GtkButton* button);
char* ccm_story_board_to_string (CCMStoryBoard* self, const char* format);
static void ccm_automate_dialog_on_stop_clicked (CCMAutomateDialog* self, GtkButton* button);
static void _ccm_automate_dialog_on_realize_gtk_widget_realize (GtkWidget* _sender, gpointer self);
static gboolean _ccm_automate_dialog_on_expose_event_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self);
static gboolean _ccm_automate_dialog_on_close_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _ccm_automate_dialog_on_record_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _ccm_automate_dialog_on_stop_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void ccm_automate_dialog_show (CCMAutomateDialog* self);
void ccm_automate_dialog_hide (CCMAutomateDialog* self);
static void ccm_automate_dialog_finalize (GObject* obj);



static void _ccm_automate_dialog_on_new_frame_ccm_timeline_new_frame (CCMTimeline* _sender, gint object, gpointer self) {
	ccm_automate_dialog_on_new_frame (self, _sender, object);
}


static void _ccm_automate_dialog_on_completed_ccm_timeline_completed (CCMTimeline* _sender, gpointer self) {
	ccm_automate_dialog_on_completed (self, _sender);
}


CCMAutomateDialog* ccm_automate_dialog_construct (GType object_type, CCMScreen* screen) {
	CCMAutomateDialog * self;
	CCMTimeline* _tmp0_;
	g_return_val_if_fail (screen != NULL, NULL);
	self = (CCMAutomateDialog*) g_object_new (object_type, NULL);
	self->priv->screen = screen;
	self->priv->timeline = (_tmp0_ = ccm_timeline_new ((guint) 10, (guint) 60), _g_object_unref0 (self->priv->timeline), _tmp0_);
	ccm_timeline_set_direction (self->priv->timeline, CCM_TIMELINE_BACKWARD);
	g_signal_connect_object (self->priv->timeline, "new-frame", (GCallback) _ccm_automate_dialog_on_new_frame_ccm_timeline_new_frame, self, 0);
	g_signal_connect_object (self->priv->timeline, "completed", (GCallback) _ccm_automate_dialog_on_completed_ccm_timeline_completed, self, 0);
	ccm_automate_dialog_construct_ui (self);
	return self;
}


CCMAutomateDialog* ccm_automate_dialog_new (CCMScreen* screen) {
	return ccm_automate_dialog_construct (CCM_TYPE_AUTOMATE_DIALOG, screen);
}


static void ccm_automate_dialog_on_new_frame (CCMAutomateDialog* self, CCMTimeline* timeline, gint num_frame) {
	gint width = 0;
	gint height = 0;
	gint x = 0;
	gint y = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	gdk_window_get_origin (((GtkWidget*) self->priv->main)->window, &x, &y);
	gdk_drawable_get_size ((GdkDrawable*) ((GtkWidget*) self->priv->main)->window, &width, &height);
	height = height - self->priv->close->allocation.height;
	gtk_window_move (self->priv->main, x, -((gint) (((double) height) * ccm_timeline_get_progress (timeline))));
}


static void ccm_automate_dialog_on_completed (CCMAutomateDialog* self, CCMTimeline* timeline) {
	char* stock;
	g_return_if_fail (self != NULL);
	g_return_if_fail (timeline != NULL);
	stock = NULL;
	if (ccm_timeline_get_direction (timeline) == CCM_TIMELINE_FORWARD) {
		char* _tmp0_;
		stock = (_tmp0_ = g_strdup (GTK_STOCK_GO_DOWN), _g_free0 (stock), _tmp0_);
	} else {
		char* _tmp1_;
		stock = (_tmp1_ = g_strdup (GTK_STOCK_GO_UP), _g_free0 (stock), _tmp1_);
	}
	gtk_image_set_from_stock (self->priv->close_image, stock, GTK_ICON_SIZE_BUTTON);
	_g_free0 (stock);
}


static void ccm_automate_dialog_on_realize (CCMAutomateDialog* self, GtkWidget* widget) {
	gint width = 0;
	gint height = 0;
	GdkAtom atom_enable;
	guchar* _tmp1_;
	gint enable_size;
	gint enable_length1;
	guchar* _tmp0_ = NULL;
	guchar* enable;
	GdkPixmap* pixmap;
	cairo_t* ctx;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	atom_enable = gdk_atom_intern_static_string ("_CCM_SHADOW_ENABLED");
	enable = (_tmp1_ = (_tmp0_ = g_new0 (guchar, 1), _tmp0_[0] = (guchar) 1, _tmp0_), enable_length1 = 1, enable_size = enable_length1, _tmp1_);
	gdk_property_change (((GtkWidget*) self->priv->main)->window, atom_enable, gdk_x11_xatom_to_atom (gdk_x11_get_xatom_by_name ("CARDINAL")), 32, GDK_PROP_MODE_REPLACE, enable, 1);
	gdk_drawable_get_size ((GdkDrawable*) ((GtkWidget*) self->priv->main)->window, &width, &height);
	gdk_window_set_override_redirect (((GtkWidget*) self->priv->main)->window, TRUE);
	gtk_window_move (self->priv->main, (ccm_screen_get_xscreen (self->priv->screen)->width / 2) - (width / 2), 0);
	pixmap = gdk_pixmap_new (NULL, width, height, 1);
	ctx = gdk_cairo_create ((GdkDrawable*) pixmap);
	cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
	cairo_set_source_rgba (ctx, (double) 0, (double) 0, (double) 0, (double) 0);
	cairo_paint (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
	cairo_translate (ctx, (double) (width / 2), (double) (height / 2));
	cairo_rotate (ctx, -M_PI);
	cairo_translate (ctx, (double) ((-width) / 2), (double) ((-height) / 2));
	cairo_set_source_rgba (ctx, (double) 1, (double) 1, (double) 1, (double) 1);
	cairo_notebook_page_round ((cairo_t*) ctx, (double) 0, (double) 0, (double) width, (double) height, (double) 0, (double) self->priv->close->allocation.width, (double) self->priv->close->allocation.height, 6);
	cairo_fill (ctx);
	cairo_surface_finish (cairo_get_target (ctx));
	gdk_window_shape_combine_mask (widget->window, (GdkBitmap*) NULL, 0, 0);
	gdk_window_input_shape_combine_mask (widget->window, (GdkBitmap*) NULL, 0, 0);
	gdk_window_shape_combine_mask (widget->window, (GdkBitmap*) pixmap, 0, 0);
	gdk_window_input_shape_combine_mask (widget->window, (GdkBitmap*) pixmap, 0, 0);
	enable = (g_free (enable), NULL);
	_g_object_unref0 (pixmap);
	_cairo_destroy0 (ctx);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean ccm_automate_dialog_on_expose_event (CCMAutomateDialog* self, GtkWidget* widget, GdkEventExpose* event) {
	gboolean result;
	cairo_t* ctx;
	gint width = 0;
	gint height = 0;
	GtkWidget* child;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	ctx = gdk_cairo_create ((GdkDrawable*) widget->window);
	gdk_drawable_get_size ((GdkDrawable*) widget->window, &width, &height);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
	cairo_translate (ctx, (double) (width / 2), (double) (height / 2));
	cairo_rotate (ctx, -M_PI);
	cairo_translate (ctx, (double) ((-width) / 2), (double) ((-height) / 2));
	cairo_set_source_rgba (ctx, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_NORMAL].red) / 65535, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_NORMAL].green) / 65535, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_NORMAL].blue) / 65535, 0.85);
	cairo_notebook_page_round ((cairo_t*) ctx, (double) 0, (double) 0, (double) width, (double) height, (double) 0, (double) self->priv->close->allocation.width, (double) self->priv->close->allocation.height, 6);
	cairo_fill (ctx);
	cairo_set_source_rgba (ctx, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_SELECTED].red) / 65535, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_SELECTED].green) / 65535, ((double) gtk_widget_get_style (widget)->bg[GTK_STATE_SELECTED].blue) / 65535, (double) 1);
	cairo_notebook_page_round ((cairo_t*) ctx, (double) 0, (double) 0, (double) width, (double) height, (double) 0, (double) self->priv->close->allocation.width, (double) self->priv->close->allocation.height, 6);
	cairo_stroke (ctx);
	child = _g_object_ref0 (gtk_bin_get_child ((GtkBin*) GTK_WINDOW (widget)));
	gtk_container_propagate_expose (GTK_CONTAINER (widget), child, event);
	result = TRUE;
	_cairo_destroy0 (ctx);
	_g_object_unref0 (child);
	return result;
}


static gboolean ccm_automate_dialog_on_close (CCMAutomateDialog* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if (ccm_timeline_get_direction (self->priv->timeline) == CCM_TIMELINE_FORWARD) {
		ccm_timeline_set_direction (self->priv->timeline, CCM_TIMELINE_BACKWARD);
	} else {
		ccm_timeline_set_direction (self->priv->timeline, CCM_TIMELINE_FORWARD);
	}
	ccm_timeline_stop (self->priv->timeline);
	ccm_timeline_start (self->priv->timeline);
	result = FALSE;
	return result;
}


static void ccm_automate_dialog_on_record_clicked (CCMAutomateDialog* self, GtkButton* button) {
	Window xwindow;
	GList* ignore;
	CCMWindow* window;
	CCMStoryBoard* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	xwindow = GDK_WINDOW_XWINDOW (((GtkWidget*) self->priv->main)->window);
	ignore = NULL;
	window = ccm_screen_find_window (self->priv->screen, xwindow);
	ignore = g_list_append (ignore, window);
	self->priv->story_board = (_tmp0_ = ccm_story_board_new (self->priv->screen, "test", ignore), _g_object_unref0 (self->priv->story_board), _tmp0_);
	ccm_story_board_set_hint_motion (self->priv->story_board, gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->hint_motion));
	_g_list_free0 (ignore);
}


static void ccm_automate_dialog_on_stop_clicked (CCMAutomateDialog* self, GtkButton* button) {
	CCMStoryBoard* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	if (self->priv->story_board != NULL) {
		char* _tmp0_;
		fprintf (stdout, "%s", _tmp0_ = ccm_story_board_to_string (self->priv->story_board, "%ccmsb"));
		_g_free0 (_tmp0_);
	}
	self->priv->story_board = (_tmp1_ = NULL, _g_object_unref0 (self->priv->story_board), _tmp1_);
}


static void _ccm_automate_dialog_on_realize_gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	ccm_automate_dialog_on_realize (self, _sender);
}


static gboolean _ccm_automate_dialog_on_expose_event_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self) {
	return ccm_automate_dialog_on_expose_event (self, _sender, event);
}


static gboolean _ccm_automate_dialog_on_close_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	return ccm_automate_dialog_on_close (self, _sender, event);
}


static void _ccm_automate_dialog_on_record_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	ccm_automate_dialog_on_record_clicked (self, _sender);
}


static void _ccm_automate_dialog_on_stop_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	ccm_automate_dialog_on_stop_clicked (self, _sender);
}


static void ccm_automate_dialog_construct_ui (CCMAutomateDialog* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		GtkBuilder* builder;
		GtkWindow* _tmp1_;
		GObject* _tmp0_;
		GdkScreen* screen;
		GdkColormap* colormap;
		GtkWidget* _tmp3_;
		GObject* _tmp2_;
		GtkImage* _tmp5_;
		GObject* _tmp4_;
		GObject* _tmp6_;
		GtkButton* record;
		GObject* _tmp7_;
		GtkButton* stop;
		GtkCheckButton* _tmp9_;
		GObject* _tmp8_;
		builder = gtk_builder_new ();
		gtk_builder_add_from_file (builder, CCM_AUTOMATE_DIALOG_UI_FILE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (builder);
			goto __catch2_g_error;
		}
		self->priv->main = (_tmp1_ = _g_object_ref0 ((_tmp0_ = gtk_builder_get_object (builder, "main"), GTK_IS_WINDOW (_tmp0_) ? ((GtkWindow*) _tmp0_) : NULL)), _g_object_unref0 (self->priv->main), _tmp1_);
		gtk_window_set_keep_above (self->priv->main, TRUE);
		screen = _g_object_ref0 (gdk_screen_get_default ());
		colormap = _g_object_ref0 (gdk_screen_get_rgba_colormap (screen));
		gtk_widget_set_colormap ((GtkWidget*) self->priv->main, colormap);
		g_signal_connect_object (GTK_WIDGET (self->priv->main), "realize", (GCallback) _ccm_automate_dialog_on_realize_gtk_widget_realize, self, 0);
		g_signal_connect_object (GTK_WIDGET (self->priv->main), "expose-event", (GCallback) _ccm_automate_dialog_on_expose_event_gtk_widget_expose_event, self, 0);
		self->priv->close = (_tmp3_ = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (builder, "close"), GTK_IS_WIDGET (_tmp2_) ? ((GtkWidget*) _tmp2_) : NULL)), _g_object_unref0 (self->priv->close), _tmp3_);
		g_signal_connect_object (self->priv->close, "button-press-event", (GCallback) _ccm_automate_dialog_on_close_gtk_widget_button_press_event, self, 0);
		self->priv->close_image = (_tmp5_ = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (builder, "close_image"), GTK_IS_IMAGE (_tmp4_) ? ((GtkImage*) _tmp4_) : NULL)), _g_object_unref0 (self->priv->close_image), _tmp5_);
		record = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (builder, "record"), GTK_IS_BUTTON (_tmp6_) ? ((GtkButton*) _tmp6_) : NULL));
		g_signal_connect_object (record, "clicked", (GCallback) _ccm_automate_dialog_on_record_clicked_gtk_button_clicked, self, 0);
		stop = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (builder, "stop"), GTK_IS_BUTTON (_tmp7_) ? ((GtkButton*) _tmp7_) : NULL));
		g_signal_connect_object (stop, "clicked", (GCallback) _ccm_automate_dialog_on_stop_clicked_gtk_button_clicked, self, 0);
		self->priv->hint_motion = (_tmp9_ = _g_object_ref0 ((_tmp8_ = gtk_builder_get_object (builder, "hint_motion"), GTK_IS_CHECK_BUTTON (_tmp8_) ? ((GtkCheckButton*) _tmp8_) : NULL)), _g_object_unref0 (self->priv->hint_motion), _tmp9_);
		_g_object_unref0 (builder);
		_g_object_unref0 (screen);
		_g_object_unref0 (colormap);
		_g_object_unref0 (record);
		_g_object_unref0 (stop);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * ex;
		ex = _inner_error_;
		_inner_error_ = NULL;
		{
			ccm_log ("Error on create automate dialog: %s", ex->message, NULL);
			_g_error_free0 (ex);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void ccm_automate_dialog_show (CCMAutomateDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_show ((GtkWidget*) self->priv->main);
}


void ccm_automate_dialog_hide (CCMAutomateDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->main);
}


static void ccm_automate_dialog_class_init (CCMAutomateDialogClass * klass) {
	ccm_automate_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CCMAutomateDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = ccm_automate_dialog_finalize;
}


static void ccm_automate_dialog_instance_init (CCMAutomateDialog * self) {
	self->priv = CCM_AUTOMATE_DIALOG_GET_PRIVATE (self);
}


static void ccm_automate_dialog_finalize (GObject* obj) {
	CCMAutomateDialog * self;
	self = CCM_AUTOMATE_DIALOG (obj);
	{
		gtk_object_destroy ((GtkObject*) self->priv->main);
	}
	_g_object_unref0 (self->priv->timeline);
	_g_object_unref0 (self->priv->main);
	_g_object_unref0 (self->priv->close);
	_g_object_unref0 (self->priv->close_image);
	_g_object_unref0 (self->priv->hint_motion);
	_g_object_unref0 (self->priv->story_board);
	G_OBJECT_CLASS (ccm_automate_dialog_parent_class)->finalize (obj);
}


GType ccm_automate_dialog_get_type (void) {
	return ccm_automate_dialog_type_id;
}


GType ccm_automate_dialog_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMAutomateDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_automate_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMAutomateDialog), 0, (GInstanceInitFunc) ccm_automate_dialog_instance_init, NULL };
	ccm_automate_dialog_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "CCMAutomateDialog", &g_define_type_info, 0);
	return ccm_automate_dialog_type_id;
}




