/* ccm-action-pointer-release.c generated by valac, the Vala compiler
 * generated from ccm-action-pointer-release.vala, do not modify */

/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * cairo-compmgr
 * Copyright (C) Nicolas Bruguier 2008 <gandalfn@club-internet.fr>
 * 
 * cairo-compmgr is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * cairo-compmgr is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with cairo-compmgr.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ccm.h>
#include <ccm-screen.h>
#include <ccm-window.h>
#include <ccm-window-plugin.h>
#include <float.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>


#define CCM_TYPE_ACTION (ccm_action_get_type ())
#define CCM_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_ACTION, CCMAction))
#define CCM_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_ACTION, CCMActionClass))
#define CCM_IS_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_ACTION))
#define CCM_IS_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_ACTION))
#define CCM_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_ACTION, CCMActionClass))

typedef struct _CCMAction CCMAction;
typedef struct _CCMActionClass CCMActionClass;
typedef struct _CCMActionPrivate CCMActionPrivate;

#define CCM_TYPE_ACTION_POINTER (ccm_action_pointer_get_type ())
#define CCM_ACTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_ACTION_POINTER, CCMActionPointer))
#define CCM_ACTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_ACTION_POINTER, CCMActionPointerClass))
#define CCM_IS_ACTION_POINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_ACTION_POINTER))
#define CCM_IS_ACTION_POINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_ACTION_POINTER))
#define CCM_ACTION_POINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_ACTION_POINTER, CCMActionPointerClass))

typedef struct _CCMActionPointer CCMActionPointer;
typedef struct _CCMActionPointerClass CCMActionPointerClass;
typedef struct _CCMActionPointerPrivate CCMActionPointerPrivate;

#define CCM_TYPE_ACTION_POINTER_RELEASE (ccm_action_pointer_release_get_type ())
#define CCM_ACTION_POINTER_RELEASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CCM_TYPE_ACTION_POINTER_RELEASE, CCMActionPointerRelease))
#define CCM_ACTION_POINTER_RELEASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CCM_TYPE_ACTION_POINTER_RELEASE, CCMActionPointerReleaseClass))
#define CCM_IS_ACTION_POINTER_RELEASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CCM_TYPE_ACTION_POINTER_RELEASE))
#define CCM_IS_ACTION_POINTER_RELEASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CCM_TYPE_ACTION_POINTER_RELEASE))
#define CCM_ACTION_POINTER_RELEASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CCM_TYPE_ACTION_POINTER_RELEASE, CCMActionPointerReleaseClass))

typedef struct _CCMActionPointerRelease CCMActionPointerRelease;
typedef struct _CCMActionPointerReleaseClass CCMActionPointerReleaseClass;
typedef struct _CCMActionPointerReleasePrivate CCMActionPointerReleasePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CCMAction {
	GObject parent_instance;
	CCMActionPrivate * priv;
};

struct _CCMActionClass {
	GObjectClass parent_class;
	char* (*to_string) (CCMAction* self, const char* format);
};

struct _CCMActionPointer {
	CCMAction parent_instance;
	CCMActionPointerPrivate * priv;
};

struct _CCMActionPointerClass {
	CCMActionClass parent_class;
};

struct _CCMActionPointerRelease {
	CCMActionPointer parent_instance;
	CCMActionPointerReleasePrivate * priv;
};

struct _CCMActionPointerReleaseClass {
	CCMActionPointerClass parent_class;
};

typedef enum  {
	CCM_ACTION_ERROR_WINDOW_IGNORE,
	CCM_ACTION_ERROR_WINDOW_NOT_FOUND
} CCMActionError;
#define CCM_ACTION_ERROR ccm_action_error_quark ()

static gpointer ccm_action_pointer_release_parent_class = NULL;
static GType ccm_action_pointer_release_type_id = 0;

GType ccm_action_get_type (void);
GType ccm_action_register_type (GTypeModule * module);
GType ccm_action_pointer_get_type (void);
GType ccm_action_pointer_register_type (GTypeModule * module);
GType ccm_action_pointer_release_get_type (void);
GType ccm_action_pointer_release_register_type (GTypeModule * module);
enum  {
	CCM_ACTION_POINTER_RELEASE_DUMMY_PROPERTY
};
CCMActionPointer* ccm_action_pointer_construct (GType object_type);
void ccm_action_pointer_set_button (CCMActionPointer* self, guint value);
void ccm_action_pointer_set_x (CCMActionPointer* self, gint value);
void ccm_action_pointer_set_y (CCMActionPointer* self, gint value);
void ccm_action_set_time (CCMAction* self, glong value);
GQuark ccm_action_error_quark (void);
CCMActionPointerRelease* ccm_action_pointer_release_new (CCMScreen* screen, XEvent* event, glong time, GList* ignore, GError** error);
CCMActionPointerRelease* ccm_action_pointer_release_construct (GType object_type, CCMScreen* screen, XEvent* event, glong time, GList* ignore, GError** error);
guint ccm_action_pointer_get_button (CCMActionPointer* self);
gint ccm_action_pointer_get_x (CCMActionPointer* self);
gint ccm_action_pointer_get_y (CCMActionPointer* self);
glong ccm_action_get_time (CCMAction* self);
static char* ccm_action_pointer_release_real_to_string (CCMAction* base, const char* format);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CCMActionPointerRelease* ccm_action_pointer_release_construct (GType object_type, CCMScreen* screen, XEvent* event, glong time, GList* ignore, GError** error) {
	GError * _inner_error_;
	CCMActionPointerRelease * self;
	CCMWindow* window;
	g_return_val_if_fail (screen != NULL, NULL);
	_inner_error_ = NULL;
	self = (CCMActionPointerRelease*) ccm_action_pointer_construct (object_type);
	window = _g_object_ref0 (ccm_screen_find_window_at_pos (screen, (*event).xbutton.y_root, (*event).xbutton.x_root));
	if (window != NULL) {
		gboolean found;
		found = FALSE;
		{
			GList* item_collection;
			GList* item_it;
			item_collection = ignore;
			for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
				CCMWindow* item;
				item = _g_object_ref0 ((CCMWindow*) item_it->data);
				{
					found = found | (CCM_WINDOW_XWINDOW (item) == CCM_WINDOW_XWINDOW (window));
					_g_object_unref0 (item);
				}
			}
		}
		if (!found) {
			ccm_action_pointer_set_button ((CCMActionPointer*) self, ((guint) (*event).xbutton.state) >> 8);
			ccm_action_pointer_set_x ((CCMActionPointer*) self, (*event).xbutton.y_root);
			ccm_action_pointer_set_y ((CCMActionPointer*) self, (*event).xbutton.x_root);
			ccm_action_set_time ((CCMAction*) self, (glong) (((double) time) / ((double) 1000)));
		} else {
			g_object_unref ((GObject*) self);
			_inner_error_ = g_error_new (CCM_ACTION_ERROR, CCM_ACTION_ERROR_WINDOW_IGNORE, "Window is ignored at pos %i,%i", (*event).xbutton.y_root, (*event).xbutton.x_root);
			{
				if (_inner_error_->domain == CCM_ACTION_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (window);
					g_object_unref (self);
					return NULL;
				} else {
					_g_object_unref0 (window);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
		}
	} else {
		g_object_unref ((GObject*) self);
		_inner_error_ = g_error_new (CCM_ACTION_ERROR, CCM_ACTION_ERROR_WINDOW_NOT_FOUND, "Window not found at pos %i,%i", (*event).xbutton.y_root, (*event).xbutton.x_root);
		{
			if (_inner_error_->domain == CCM_ACTION_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (window);
				g_object_unref (self);
				return NULL;
			} else {
				_g_object_unref0 (window);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_g_object_unref0 (window);
	return self;
}


CCMActionPointerRelease* ccm_action_pointer_release_new (CCMScreen* screen, XEvent* event, glong time, GList* ignore, GError** error) {
	return ccm_action_pointer_release_construct (CCM_TYPE_ACTION_POINTER_RELEASE, screen, event, time, ignore, error);
}


static char* ccm_action_pointer_release_real_to_string (CCMAction* base, const char* format) {
	CCMActionPointerRelease * self;
	char* result;
	char* _tmp10_;
	char* _tmp9_;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp11_;
	char* val;
	self = (CCMActionPointerRelease*) base;
	g_return_val_if_fail (format != NULL, NULL);
	val = (_tmp11_ = g_strconcat (_tmp10_ = g_strconcat (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("<pointer-release button=\"", _tmp0_ = g_strdup_printf ("%u", ccm_action_pointer_get_button ((CCMActionPointer*) self)), NULL), "\" x=\"", NULL), _tmp3_ = g_strdup_printf ("%i", ccm_action_pointer_get_x ((CCMActionPointer*) self)), NULL), "\" y=\"", NULL), _tmp6_ = g_strdup_printf ("%i", ccm_action_pointer_get_y ((CCMActionPointer*) self)), NULL), "\" time=\"", NULL), _tmp9_ = g_strdup_printf ("%li", ccm_action_get_time ((CCMAction*) self)), NULL), "\"/>", NULL), _g_free0 (_tmp10_), _g_free0 (_tmp9_), _g_free0 (_tmp8_), _g_free0 (_tmp7_), _g_free0 (_tmp6_), _g_free0 (_tmp5_), _g_free0 (_tmp4_), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp11_);
	result = val;
	return result;
}


static void ccm_action_pointer_release_class_init (CCMActionPointerReleaseClass * klass) {
	ccm_action_pointer_release_parent_class = g_type_class_peek_parent (klass);
	CCM_ACTION_CLASS (klass)->to_string = ccm_action_pointer_release_real_to_string;
}


static void ccm_action_pointer_release_instance_init (CCMActionPointerRelease * self) {
}


GType ccm_action_pointer_release_get_type (void) {
	return ccm_action_pointer_release_type_id;
}


GType ccm_action_pointer_release_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (CCMActionPointerReleaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ccm_action_pointer_release_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CCMActionPointerRelease), 0, (GInstanceInitFunc) ccm_action_pointer_release_instance_init, NULL };
	ccm_action_pointer_release_type_id = g_type_module_register_type (module, CCM_TYPE_ACTION_POINTER, "CCMActionPointerRelease", &g_define_type_info, 0);
	return ccm_action_pointer_release_type_id;
}




