/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-embed-event.h"
#include "gobject-utils.h"

KZ_BOXED_GET_TYPE(kz_embed_event_key, "KzEmbedEventKey",
		  kz_embed_event_copy, kz_embed_event_free)
KZ_BOXED_GET_TYPE(kz_embed_event_mouse, "KzEmbedEventMouse",
		  kz_embed_event_copy, kz_embed_event_free)

KzEmbedEvent *
kz_embed_event_new (KzEmbedEventType type)
{
	KzEmbedEvent *event;

	switch (type) {
	case KZ_EMBED_EVENT_KEY:
		event = (KzEmbedEvent *) g_slice_new0(KzEmbedEventKey);
		break;
	case KZ_EMBED_EVENT_MOUSE:
		event = (KzEmbedEvent *) g_slice_new0(KzEmbedEventMouse);
		break;
	default:
		g_warning("invalid event type: %d\n", type);
		return NULL;
	}

	event->type      = type;
	event->link      = NULL;
	event->linktext  = NULL;
	event->img       = NULL;
	event->frame_src = NULL;
	event->element   = NULL;

	return event;
}


KzEmbedEvent *
kz_embed_event_copy (KzEmbedEvent *event)
{
	KzEmbedEvent *newevent;

	g_return_val_if_fail(event, NULL);

	newevent = kz_embed_event_new(event->type);
	switch (event->type) {
	case KZ_EMBED_EVENT_KEY:
		*((KzEmbedEventKey*)newevent) = *((KzEmbedEventKey*)event);
		break;
	case KZ_EMBED_EVENT_MOUSE:
		*((KzEmbedEventMouse*)newevent) = *((KzEmbedEventMouse*)event);
		break;
	default:
		g_warning("invalid event type: %d\n", event->type);
		kz_embed_event_free(event);
		return NULL;
	}

	if (event->link)
		newevent->link = g_strdup(event->link);
	if (event->linktext)
		newevent->linktext = g_strdup(event->linktext);
	if (event->img)
		newevent->img = g_strdup(event->img);
	if (event->frame_src)
		newevent->frame_src = g_strdup(event->frame_src);

	return newevent;
}


void
kz_embed_event_free (KzEmbedEvent *event)
{
	g_free(event->link);
	event->link = NULL;

	g_free(event->linktext);
	event->linktext = NULL;

	g_free(event->img);
	event->img = NULL;

	g_free(event->frame_src);
	event->frame_src = NULL;

	event->element = NULL;

	switch (event->type)
	{
	case KZ_EMBED_EVENT_KEY:
		g_slice_free(KzEmbedEventKey, (KzEmbedEventKey*)event);
		break;
	case KZ_EMBED_EVENT_MOUSE:
		g_slice_free(KzEmbedEventMouse, (KzEmbedEventMouse*)event);
		break;
	default:
		break;
	}
}
