#!/usr/bin/env perl
# $Id: katarina-scheduler-status.pl,v 1.2 2014/01/15 14:47:55 updater Exp $
#
# KATARINA
# (C)2011 C.Bellot
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 

# 
use strict;

my $version = q($Revision: 1.2 $);
my $log_dir = "/var/log/katarina";
my @thread_list;
my @thread_details;
open(S, "< $log_dir/katarina-scheduler.out");
while(<S>) {
    if (/^\d\d\d\d-\d\d-\d\d-(\d\d):(\d\d):(\d\d) .* Starting thread (\d+)$/) {
	push @thread_list, $4;
    } elsif (/^\d\d\d\d-\d\d-\d\d-(\d\d):(\d\d):(\d\d) .* Thread (\d+) : Starting job (.+?)$/) {
	$thread_details[$4] .= "$1:$2 $5 ";
    } elsif (/^\d\d\d\d-\d\d-\d\d-(\d\d):(\d\d):(\d\d) .* Ending thread (\d+) /) {
	$thread_details[$4] .= "$1:$2 [fin]";
    }
}
close(S);

# Summary thread by thread
for my $thread (sort @thread_list) {
    print "Thread $thread: ".$thread_details[$thread]."\n";
}
