#ifndef PRODUCTSFRAME_H
#define PRODUCTSFRAME_H

class ProductsFrame : public FXVerticalFrame
{
FXDECLARE(ProductsFrame)
protected:
  FXSplitter    *phsplitter;
  FXFoldingList *prodlist;
  FXFoldingList *clprodlist;
  FXToolBar	*ptoolbar;
protected:
  ProductsFrame(){}
public:
  ProductsFrame(FXComposite *parent);
  ~ProductsFrame();
  void create();
public:
  void loadProducts();
  void addProduct(int id);
  void delProduct(int id);
  void updateClientProducts(int client);
public:
  long onNewProduct(FXObject*,FXSelector,void*);
  long onDelProduct(FXObject*,FXSelector,void*);
  long onEditProduct(FXObject*,FXSelector,void*);
  long onSellProduct(FXObject*,FXSelector,void*);
  long onSetStock(FXObject*,FXSelector,void*);
  long onAddProduct(FXObject*,FXSelector,void* ptr);
  long onSubProduct(FXObject*,FXSelector,void* ptr);
public:
  enum {
    ID_NEWPRODUCT = FXVerticalFrame::ID_LAST,ID_DELPRODUCT,ID_SETSTOCK,
    ID_EDITPRODUCT,ID_SELLPRODUCT,ID_PRODLIST,ID_CLPRODLIST,
    ID_LAST
  };
};
#endif
