#ifndef WIN32
#  include <X11/Xlib.h>
#else
#  include <windows.h>
#  include <winuser.h>
#endif

#include <fx.h>
#include <FXRex.h>
#include <fxkeys.h>
using namespace FX;

#include "cclcfox.h"
#include "lockpix.h"
#include "locker.h"

extern CCLCFox *cclcfox;

FXDEFMAP(Locker) LockerMap[] =
{
  FXMAPFUNC(SEL_PAINT,0,Locker::onPaint),
  FXMAPFUNC(SEL_LEFTBUTTONRELEASE,0,Locker::onButtonRelease),
  FXMAPFUNC(SEL_KEYPRESS,0,Locker::onKeyPress)
};

FXIMPLEMENT(Locker,FXShell,LockerMap,ARRAYNUMBER(LockerMap))
#ifdef WIN32
static FXuint ps;
static HHOOK kHook = NULL;
static HHOOK mHook = NULL;

static LRESULT CALLBACK mylpfn(int nCode,WPARAM wp,LPARAM lp)
{
  KBDLLHOOKSTRUCT *kbh = (KBDLLHOOKSTRUCT *) lp;
  BOOL ctrlDown = FALSE;

  if (cclcfox->isLocked()) {
    if (nCode == HC_ACTION) {
      ctrlDown = GetAsyncKeyState(VK_CONTROL) >> ((sizeof(SHORT) * 8) - 1);
      if (kbh->vkCode == VK_TAB && kbh->flags & LLKHF_ALTDOWN)
	return 1; // Alt+Tab
      if (kbh->vkCode == VK_ESCAPE && ctrlDown)
	return 1; // Ctrl+Escape
      if (kbh->vkCode == VK_ESCAPE && kbh->flags & LLKHF_ALTDOWN)
	return 1; // Alt+Escape
      if (kbh->vkCode == VK_LWIN || kbh->vkCode == VK_RWIN)
	return 1; // Win
      // otherwise
      return CallNextHookEx(kHook,nCode,wp,lp);
    } 
  } else
    return CallNextHookEx(kHook,nCode,wp,lp);
}
#endif

Locker::Locker(FXApp * app)
:FXShell(app,0,0,0,0,0)
{
  enable();
  ctext = fxstrdup(_("Click here to start"));
  mid = -1;
  input.clear();
  font = new FXFont(getApp(),"arial",20,FONTWEIGHT_BOLD);

  box.h = 80;
  box.w = 400;
  box.x = getRoot()->getDefaultWidth()/2 - box.w/2;
  box.y = getRoot()->getDefaultHeight()/2 - box.h/2;

  // If "lockpix.gif" exists, lets show it when the screen is locked
  if (FXFile::exists("lockpix.gif")) {
    lockpix = new FXGIFImage(getApp(),NULL,IMAGE_OPAQUE);
    FXFileStream stream;

    stream.open("lockpix.gif",FXStreamLoad);
    lockpix->loadPixels(stream);
    stream.close();
  } else // If not, lets show the CCL logo
    lockpix = new FXGIFImage(getApp(),lockscreen_gif,IMAGE_OPAQUE);
}

Locker::~Locker()
{
  delete lockpix;
  delete font;

  FXFREE(&ctext);
}

FXbool
Locker::doesOverrideRedirect() const
{
  return TRUE;
}

void
Locker::create()
{
  FXShell::create();
  lockpix->create();
  font->create();
}

void
Locker::lock()
{
  int width = getRoot()->getDefaultWidth();
  int height = getRoot()->getDefaultHeight();

  position(0,0,width,height);
  show();
  grabKeyboard();
#ifdef WIN32
  SetForegroundWindow((HWND) id());
  OSVERSIONINFO osversion;

  osversion.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
  GetVersionEx(&osversion);
  
  SetWindowPos((HWND) id(),HWND_TOPMOST,0,0,width,height,
		SWP_NOMOVE|SWP_NOACTIVATE|SWP_NOOWNERZORDER);

  if (osversion.dwPlatformId == VER_PLATFORM_WIN32_NT) {	// NT/2000/XP
    HWND hwnd = FindWindow("Shell_traywnd",NULL);

    EnableWindow(hwnd,FALSE);
    // Disable the task manager
    HKEY hk;
    DWORD val = 1;
    const char *key =
      "Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\System";
    
    if (RegOpenKey(HKEY_CURRENT_USER,key,&hk) != ERROR_SUCCESS)
      RegCreateKey(HKEY_CURRENT_USER,key,&hk);
    RegSetValueEx(hk,"DisableTaskMgr",0,REG_DWORD,(BYTE *) &val,sizeof(val));
    // Add Hooks
    if (!kHook)
      kHook = SetWindowsHookEx(WH_KEYBOARD_LL,(HOOKPROC) mylpfn,
			       (HINSTANCE) GetModuleHandle(NULL),0);
    /*  if (!mHook)
     *   mHook = SetWindowsHookEx (WH_MOUSE,(HOOKPROC)mylpfn,
     *    (HINSTANCE)GetModuleHandle(NULL),0);
     */
  } else // All the above was only for NT/2000/XP, this is for Win 9x/Me
    SystemParametersInfo(SPI_SETSCREENSAVERRUNNING,TRUE,&ps,0);
#endif
}

void
Locker::unlock()
{
  hide();
  ungrabKeyboard();
#ifdef WIN32
  SetWindowPos((HWND) id(),HWND_BOTTOM,0,0,0,0,
	       SWP_HIDEWINDOW|SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE|
	       SWP_NOOWNERZORDER);

  OSVERSIONINFO osversion;

  osversion.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
  GetVersionEx(&osversion);

  if (osversion.dwPlatformId == VER_PLATFORM_WIN32_NT) {	// NT/2000/XP
    // Show the taskbar
    HWND hwnd = FindWindow("Shell_traywnd",NULL);

    EnableWindow(hwnd,TRUE);
    // Reenable the task manager
    HKEY hk;
    const char *key =
      "Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\System";
    if (RegOpenKey(HKEY_CURRENT_USER,key,&hk) != ERROR_SUCCESS)
      RegCreateKey(HKEY_CURRENT_USER,key,&hk);
    RegDeleteValue(hk,"DisableTaskMgr");
    // Remove Hooks
    if (kHook) {
      UnhookWindowsHookEx(kHook);
      kHook = NULL;
    }
    if (mHook) {
      UnhookWindowsHookEx(mHook);
      mHook = NULL;
    }
  } else // 9x/Me
    SystemParametersInfo(SPI_SETSCREENSAVERRUNNING,FALSE,&ps,0);
#endif
}

void
Locker::drawPasswordBox(FXEvent* event)
{
  const char *title = (-1 == mid) ? _("Member ID:") : _("Password:");
  FXString txt = input + "|";
  if (-1 != mid)
    txt.replace(0,txt.length()-1,'*',txt.length()-1);
  int theight = font->getTextHeight(title);
  int twidth = font->getTextWidth(title);
  int iwidth = font->getTextWidth(txt.text());
  FXDCWindow dc(this,event);

  dc.begin(this);
  dc.setClipRectangle(box.x,box.y,box.w+1,box.h+1);
  // Main box
  dc.setForeground(FXRGB(0,0,0));
  dc.fillRectangle(box.x,box.y,box.w,box.h);
  dc.setForeground(FXRGB(100,100,140));
  dc.fillRectangle(box.x,box.y,box.w,theight);
  dc.setForeground(FXRGB(255,255,255));
  dc.drawRectangle(box.x,box.y,box.w,box.h);
  // Password/ID
  dc.setFont(font);
  dc.setForeground(FXRGB(0,0,0));
  dc.drawText(box.x + box.w/2 - twidth/2 + 2,box.y + 10 + theight/2 + 2,
	      title,strlen(title));
  dc.setForeground(FXRGB(255,255,255));
  dc.drawText(box.x + box.w/2 - twidth/2,box.y + 10 + theight/2,
	      title,strlen(title));
  // User input
  dc.drawText(box.x + box.w/2 - iwidth/2,box.y + 30 + theight,
	      txt.text(),txt.length());
  dc.end();
}

void
Locker::clearPasswordBox()
{
  update(box.x,box.y,box.w+1,box.h+1);
}

long
Locker::onPaint(FXObject*,FXSelector,void* ptr)
{
  int textheight = font->getTextHeight(ctext,strlen(ctext));
  int textwidth = font->getTextWidth(ctext,strlen(ctext));
  int width = getRoot()->getDefaultWidth();
  int height = getRoot()->getDefaultHeight();
  FXEvent *event = (FXEvent *) ptr;
  FXDCWindow dc(this,event);

  dc.begin(this);
  dc.setForeground(FXRGB(0,0,0));
  dc.fillRectangle(0,0,width,height);
  dc.drawImage(lockpix,(width - lockpix->getWidth()) / 2,
	       (height - lockpix->getHeight()) / 2);
  // If the user clicks on this section,I will send
  // a "start session" request to the server
  dc.setForeground(FXRGB(50,50,50));
  dc.fillRectangle(0,0,width,textheight);
  dc.drawRectangle(0,0,width,textheight);
  dc.setForeground(FXRGB(0,0,0));
  dc.setFont(font);
  dc.drawText((width - textwidth) / 2,textheight,ctext,strlen(ctext));
  dc.setForeground(FXRGB(255,255,255));
  dc.drawText((width - textwidth) / 2 - 3,textheight - 3,ctext,strlen(ctext));
  dc.end();
  
  return 1;
}

long
Locker::onButtonRelease(FXObject*,FXSelector,void* ptr)
{
  FXEvent *event = (FXEvent *) ptr;

  if (font->getTextHeight(ctext) >= event->win_y) {
    mid = -1;
    input.clear();
    cclcfox->userStart();
  }

  return 1;
}

long
Locker::onKeyPress(FXObject*,FXSelector,void* ptr)
{
  FXEvent *event = (FXEvent *) ptr;
 
  if ((event->code >= 0x0020 && event->code <= 0x00FF)
      || (event->code >= 0xFFB0 && event->code <= 0xFFB9)) {
      FXRex numeric("^\\d*$",REX_NORMAL);
      
      if (mid != -1 || numeric.match(event->text)) {
	input.append(event->text);
	drawPasswordBox(event);
      }     
  } else if (event->code == KEY_Escape) {
    input.clear();
    mid = -1;
    clearPasswordBox();
  } else if (event->code == KEY_BackSpace || event->code == KEY_Delete) {
    input.trunc(input.length() - 1);
    drawPasswordBox(event);
  } else if (event->code == KEY_KP_Enter || event->code == KEY_Return) {
    if (mid == -1) {
      if (input.length()) {
	mid = FXIntVal(input);
	input.clear();
      }
      drawPasswordBox(event);
    } else {
      cclcfox->unlockWithPass(mid,input);
      input.clear();
      mid = -1;
      clearPasswordBox();
    }
  }
  
  return 1;
}
