/* 
 * cmds.h
 * commands sent by the server to the client from client to server
 */

#ifndef CMDS_H
#define CMDS_H
/* Commands sent by the server */
#define CS_STOP		  1UL   /* End session */
#define CS_START	  2UL   /* Start session */
#define CS_PAUSE	  3UL   /* Pause session */
#define CS_RESUME	  4UL   /* Resume last session */
#define CS_MONITOROFF	  5UL   /* Turn off client's monitor */
#define CS_SETTIMEOUT	  6UL   /* Set the clients timeout */
#define CS_SHUTDOWN	  7UL   /* Shutdown client's computer */
#define CS_REBOOT	  8UL   /* Reboot client's computer */
#define CS_SETTIME	  9UL   /* Set client's time */
#define CS_SETOWED	  10UL  /* Set client's owed */
#define CS_SETADDITIONAL  11UL  /* Set client's additional owed */
#define CS_QUITCLIENT	  12UL  /* Tells the client to close itself */
#define CS_SHOWMESSAGE	  13UL  /* Shows a message */
#define CS_UNLOCKSCREEN	  14UL	/* Unlock the screen */
#define CS_LOCKSCREEN	  15UL	/* Lock the screen */
#define CS_SETMEMBERPASS  16UL	/* Enable password edit */

/* Commands sent by the client */
#define CC_USEREXIT	  1UL	/* the user ended the session */
#define CC_USERSTART	  2UL	/* the user wants to start a new session */
#define CC_GETSTATUS	  4UL	/* request the status (time, owed, etc) */
#define CC_GETTIME	  5UL	/* request the used time */
#define CC_GETOWED	  6UL	/* reauest the amount owed by the user */
#define CC_GETTIMEOUT	  7UL	/* request the timeout */
#define CC_UNLOCKPASS	  8UL	/* Send a password to unlock the screen */
#define CC_SETMEMBERPASS  9UL	/* Change the password for this member */

#endif /* ifndef CMDS_H */
