"""Look up the country for a given IP address.

    >>> import ipfree
    >>> ipfree.lookup('129.97.128.15')
    ('CA', 'Canada')
    >>> ipfree.lookup('194.109.137.226')
    ('NL', 'Netherlands')
    >>> 

This module provides a single function, lookup(ipaddr), that returns the
two-letter country code and country name for an IP address given as a
string of four period-separated decimal numbers.  The database in this
module is derived from the free database in the Perl module Geo::IPfree."""

__author__ = 'Ka-Ping Yee'
__date__ = '2005-04-14'
__version__ = '$Revision: 1.3 $'


countries = {
    '--': 'unknown',
    'L0': 'localhost',
    'I0': 'intranet',
    'A1': 'anonymous proxy',
    'A2': 'satellite provider',
    'AD': 'Andorra',
    'AE': 'United Arab Emirates',
    'AF': 'Afghanistan',
    'AG': 'Antigua and Barbuda',
    'AI': 'Anguilla',
    'AL': 'Albania',
    'AM': 'Armenia',
    'AN': 'Netherlands Antilles',
    'AO': 'Angola',
    'AP': 'Asia/Pacific Region',
    'AQ': 'Antarctica',
    'AR': 'Argentina',
    'AS': 'American Samoa',
    'AT': 'Austria',
    'AU': 'Australia',
    'AW': 'Aruba',
    'AZ': 'Azerbaijan',
    'BA': 'Bosnia and Herzegovina',
    'BB': 'Barbados',
    'BD': 'Bangladesh',
    'BE': 'Belgium',
    'BF': 'Burkina Faso',
    'BG': 'Bulgaria',
    'BH': 'Bahrain',
    'BI': 'Burundi',
    'BJ': 'Benin',
    'BM': 'Bermuda',
    'BN': 'Brunei Darussalam',
    'BO': 'Bolivia',
    'BR': 'Brazil',
    'BS': 'Bahamas',
    'BT': 'Bhutan',
    'BV': 'Bouvet Island',
    'BW': 'Botswana',
    'BY': 'Belarus',
    'BZ': 'Belize',
    'CA': 'Canada',
    'CC': 'Cocos (Keeling) Islands',
    'CD': 'Congo, The Democratic Republic of the',
    'CF': 'Central African Republic',
    'CG': 'Congo',
    'CH': 'Switzerland',
    'CI': "Cote D'Ivoire",
    'CK': 'Cook Islands',
    'CL': 'Chile',
    'CM': 'Cameroon',
    'CN': 'China',
    'CO': 'Colombia',
    'CR': 'Costa Rica',
    'CU': 'Cuba',
    'CV': 'Cape Verde',
    'CX': 'Christmas Island',
    'CY': 'Cyprus',
    'CZ': 'Czech Republic',
    'DE': 'Germany',
    'DJ': 'Djibouti',
    'DK': 'Denmark',
    'DM': 'Dominica',
    'DO': 'Dominican Republic',
    'DZ': 'Algeria',
    'EC': 'Ecuador',
    'EE': 'Estonia',
    'EG': 'Egypt',
    'EH': 'Western Sahara',
    'ER': 'Eritrea',
    'ES': 'Spain',
    'ET': 'Ethiopia',
    'EU': 'Europe',
    'FI': 'Finland',
    'FJ': 'Fiji',
    'FK': 'Falkland Islands (Malvinas)',
    'FM': 'Micronesia, Federated States of',
    'FO': 'Faroe Islands',
    'FR': 'France',
    'FX': 'France, Metropolitan',
    'GA': 'Gabon',
    'GB': 'United Kingdom',
    'GD': 'Grenada',
    'GE': 'Georgia',
    'GF': 'French Guiana',
    'GH': 'Ghana',
    'GI': 'Gibraltar',
    'GL': 'Greenland',
    'GM': 'Gambia',
    'GN': 'Guinea',
    'GP': 'Guadeloupe',
    'GQ': 'Equatorial Guinea',
    'GR': 'Greece',
    'GS': 'South Georgia and the South Sandwich Islands',
    'GT': 'Guatemala',
    'GU': 'Guam',
    'GW': 'Guinea-Bissau',
    'GY': 'Guyana',
    'HK': 'Hong Kong',
    'HM': 'Heard Island and McDonald Islands',
    'HN': 'Honduras',
    'HR': 'Croatia',
    'HT': 'Haiti',
    'HU': 'Hungary',
    'ID': 'Indonesia',
    'IE': 'Ireland',
    'IL': 'Israel',
    'IN': 'India',
    'IO': 'British Indian Ocean Territory',
    'IQ': 'Iraq',
    'IR': 'Iran, Islamic Republic of',
    'IS': 'Iceland',
    'IT': 'Italy',
    'JM': 'Jamaica',
    'JO': 'Jordan',
    'JP': 'Japan',
    'KE': 'Kenya',
    'KG': 'Kyrgyzstan',
    'KH': 'Cambodia',
    'KI': 'Kiribati',
    'KM': 'Comoros',
    'KN': 'Saint Kitts and Nevis',
    'KP': "Korea, Democratic People's Republic of",
    'KR': 'Korea, Republic of',
    'KW': 'Kuwait',
    'KY': 'Cayman Islands',
    'KZ': 'Kazakhstan',
    'LA': "Lao People's Democratic Republic",
    'LB': 'Lebanon',
    'LC': 'Saint Lucia',
    'LI': 'Liechtenstein',
    'LK': 'Sri Lanka',
    'LR': 'Liberia',
    'LS': 'Lesotho',
    'LT': 'Lithuania',
    'LU': 'Luxembourg',
    'LV': 'Latvia',
    'LY': 'Libyan Arab Jamahiriya',
    'MA': 'Morocco',
    'MC': 'Monaco',
    'MD': 'Moldova, Republic of',
    'MG': 'Madagascar',
    'MH': 'Marshall Islands',
    'MK': 'Macedonia, the Former Yugoslav Republic of',
    'ML': 'Mali',
    'MM': 'Myanmar',
    'MN': 'Mongolia',
    'MO': 'Macau',
    'MP': 'Northern Mariana Islands',
    'MQ': 'Martinique',
    'MR': 'Mauritania',
    'MS': 'Montserrat',
    'MT': 'Malta',
    'MU': 'Mauritius',
    'MV': 'Maldives',
    'MW': 'Malawi',
    'MX': 'Mexico',
    'MY': 'Malaysia',
    'MZ': 'Mozambique',
    'NA': 'Namibia',
    'NC': 'New Caledonia',
    'NE': 'Niger',
    'NF': 'Norfolk Island',
    'NG': 'Nigeria',
    'NI': 'Nicaragua',
    'NL': 'Netherlands',
    'NO': 'Norway',
    'NP': 'Nepal',
    'NR': 'Nauru',
    'NU': 'Niue',
    'NZ': 'New Zealand',
    'OM': 'Oman',
    'PA': 'Panama',
    'PE': 'Peru',
    'PF': 'French Polynesia',
    'PG': 'Papua New Guinea',
    'PH': 'Philippines',
    'PK': 'Pakistan',
    'PL': 'Poland',
    'PM': 'Saint Pierre and Miquelon',
    'PN': 'Pitcairn',
    'PR': 'Puerto Rico',
    'PS': 'Palestinian Territory, Occupied',
    'PT': 'Portugal',
    'PW': 'Palau',
    'PY': 'Paraguay',
    'QA': 'Qatar',
    'RE': 'Reunion',
    'RO': 'Romania',
    'RU': 'Russian Federation',
    'RW': 'Rwanda',
    'SA': 'Saudi Arabia',
    'SB': 'Solomon Islands',
    'SC': 'Seychelles',
    'SD': 'Sudan',
    'SE': 'Sweden',
    'SG': 'Singapore',
    'SH': 'Saint Helena',
    'SI': 'Slovenia',
    'SJ': 'Svalbard and Jan Mayen',
    'SK': 'Slovakia',
    'SL': 'Sierra Leone',
    'SM': 'San Marino',
    'SN': 'Senegal',
    'SO': 'Somalia',
    'SR': 'Suriname',
    'ST': 'Sao Tome and Principe',
    'SV': 'El Salvador',
    'SY': 'Syrian Arab Republic',
    'SZ': 'Swaziland',
    'TC': 'Turks and Caicos Islands',
    'TD': 'Chad',
    'TF': 'French Southern Territories',
    'TG': 'Togo',
    'TH': 'Thailand',
    'TJ': 'Tajikistan',
    'TK': 'Tokelau',
    'TM': 'Turkmenistan',
    'TN': 'Tunisia',
    'TO': 'Tonga',
    'TP': 'East Timor',
    'TR': 'Turkey',
    'TT': 'Trinidad and Tobago',
    'TV': 'Tuvalu',
    'TW': 'Taiwan, Province of China',
    'TZ': 'Tanzania, United Republic of',
    'UA': 'Ukraine',
    'UG': 'Uganda',
    'UM': 'United States Minor Outlying Islands',
    'US': 'United States',
    'UY': 'Uruguay',
    'UZ': 'Uzbekistan',
    'VA': 'Holy See (Vatican City State)',
    'VC': 'Saint Vincent and the Grenadines',
    'VE': 'Venezuela',
    'VG': 'Virgin Islands, British',
    'VI': 'Virgin Islands, U.S.',
    'VN': 'Vietnam',
    'VU': 'Vanuatu',
    'WF': 'Wallis and Futuna',
    'WS': 'Samoa',
    'YE': 'Yemen',
    'YT': 'Mayotte',
    'YU': 'Yugoslavia',
    'ZA': 'South Africa',
    'ZM': 'Zambia',
    'ZR': 'Zaire',
    'ZW': 'Zimbabwe',
}

# addrmap could be ints instead, it would save about 600k of memory
addrmap = [
    ('000.000.000.000', 'US'),
    ('001.000.000.000', 'IN'),
    ('002.000.000.000', 'US'),
    ('004.018.066.000', 'MX'),
    ('004.018.068.000', 'US'),
    ('004.020.070.000', 'FR'),
    ('004.020.071.000', 'US'),
    ('004.022.197.000', 'CA'),
    ('004.022.198.000', 'US'),
    ('004.023.003.000', 'PH'),
    ('004.023.004.000', 'US'),
    ('009.020.000.000', 'GB'),
    ('009.020.128.000', 'US'),
    ('010.000.000.000', 'I0'),
    ('011.000.000.000', 'US'),
    ('012.008.184.000', 'PR'),
    ('012.008.185.000', 'US'),
    ('012.008.188.000', 'EC'),
    ('012.008.189.000', 'JM'),
    ('012.008.190.000', 'EC'),
    ('012.008.192.000', 'US'),
    ('012.010.192.000', 'IN'),
    ('012.010.200.000', 'US'),
    ('012.010.208.000', 'IN'),
    ('012.010.210.000', 'US'),
    ('012.013.184.000', 'CR'),
    ('012.013.186.000', 'US'),
    ('012.016.040.000', 'PR'),
    ('012.016.042.000', 'US'),
    ('012.023.144.000', 'CA'),
    ('012.023.145.000', 'US'),
    ('012.144.160.000', 'CN'),
    ('012.144.161.000', 'US'),
    ('012.144.162.000', 'IN'),
    ('012.144.164.000', 'US'),
    ('015.000.000.000', 'GB'),
    ('015.203.128.000', 'FR'),
    ('015.203.192.000', 'GB'),
    ('015.204.096.000', 'FR'),
    ('015.204.128.000', 'GB'),
    ('016.000.000.000', 'US'),
    ('021.249.133.000', 'ES'),
    ('021.249.134.000', 'US'),
    ('023.012.015.000', 'GB'),
    ('023.012.016.000', 'US'),
    ('024.042.000.000', 'CA'),
    ('024.044.000.000', 'US'),
    ('024.057.000.000', 'CA'),
    ('024.057.128.000', '--'),
    ('024.058.000.000', 'US'),
    ('024.059.000.000', '--'),
    ('024.060.000.000', 'US'),
    ('024.064.000.000', 'CA'),
    ('024.072.128.000', '--'),
    ('024.073.000.000', 'US'),
    ('024.074.128.000', '--'),
    ('024.076.000.000', 'CA'),
    ('024.088.000.000', 'US'),
    ('024.100.000.000', 'CA'),
    ('024.104.000.000', 'US'),
    ('024.106.000.000', '--'),
    ('024.108.000.000', 'CA'),
    ('024.110.000.000', '--'),
    ('024.112.000.000', 'CA'),
    ('024.116.000.000', 'US'),
    ('024.122.000.000', 'CA'),
    ('024.122.064.000', '--'),
    ('024.123.000.000', 'US'),
    ('024.123.128.000', '--'),
    ('024.124.000.000', 'US'),
    ('024.132.000.000', 'NL'),
    ('024.136.000.000', 'US'),
    ('024.138.000.000', 'CA'),
    ('024.140.000.000', 'US'),
    ('024.140.128.000', '--'),
    ('024.141.000.000', 'CA'),
    ('024.142.000.000', 'US'),
    ('024.146.000.000', 'CA'),
    ('024.146.032.000', '--'),
    ('024.147.000.000', 'US'),
    ('024.150.000.000', 'CA'),
    ('024.151.000.000', 'US'),
    ('024.151.128.000', '--'),
    ('024.152.000.000', 'CL'),
    ('024.152.128.000', '--'),
    ('024.153.000.000', 'CA'),
    ('024.153.064.000', 'US'),
    ('024.153.192.000', '--'),
    ('024.154.000.000', 'US'),
    ('024.156.000.000', 'CA'),
    ('024.158.000.000', 'US'),
    ('024.192.000.000', 'AU'),
    ('024.192.064.000', 'CA'),
    ('024.192.080.000', 'AU'),
    ('024.196.000.000', 'US'),
    ('024.200.000.000', 'CA'),
    ('024.204.000.000', 'US'),
    ('024.207.000.000', 'CA'),
    ('024.207.064.000', '--'),
    ('024.207.128.000', 'US'),
    ('024.210.000.000', '--'),
    ('024.212.000.000', 'CA'),
    ('024.212.064.000', '--'),
    ('024.213.000.000', 'US'),
    ('024.213.064.000', '--'),
    ('024.214.000.000', 'US'),
    ('024.215.000.000', 'CA'),
    ('024.215.064.000', '--'),
    ('024.216.000.000', 'US'),
    ('024.222.000.000', 'CA'),
    ('024.223.000.000', 'US'),
    ('024.223.128.000', '--'),
    ('024.224.000.000', 'US'),
    ('024.226.000.000', 'CA'),
    ('024.227.000.000', 'US'),
    ('024.227.032.000', '--'),
    ('024.228.000.000', 'US'),
    ('024.230.032.000', '--'),
    ('024.231.000.000', 'CA'),
    ('024.231.032.000', '--'),
    ('024.232.000.000', 'AR'),
    ('024.233.000.000', 'US'),
    ('024.233.032.000', '--'),
    ('024.234.000.000', 'US'),
    ('024.244.000.000', 'CA'),
    ('024.244.128.000', 'BS'),
    ('024.244.192.000', 'CA'),
    ('024.244.208.000', '--'),
    ('024.245.000.000', 'US'),
    ('024.245.128.000', '--'),
    ('024.246.000.000', 'US'),
    ('025.000.000.000', 'GB'),
    ('026.000.000.000', 'US'),
    ('032.000.000.000', 'GB'),
    ('032.096.034.000', 'US'),
    ('032.096.038.000', 'GB'),
    ('032.097.220.000', 'US'),
    ('032.097.221.000', 'GB'),
    ('033.000.000.000', 'US'),
    ('043.000.000.000', 'JP'),
    ('044.000.000.000', 'US'),
    ('046.000.000.000', '--'),
    ('047.000.000.000', 'CA'),
    ('048.000.000.000', 'US'),
    ('049.000.000.000', '--'),
    ('051.000.000.000', 'GB'),
    ('052.000.000.000', 'US'),
    ('053.000.000.000', 'DE'),
    ('054.000.000.000', 'US'),
    ('057.000.000.000', 'FR'),
    ('058.000.000.000', 'US'),
    ('061.000.000.000', 'IN'),
    ('061.004.000.000', 'HK'),
    ('061.004.064.000', 'AU'),
    ('061.004.128.000', 'JP'),
    ('061.004.160.000', 'AU'),
    ('061.005.000.000', 'ID'),
    ('061.005.128.000', 'AU'),
    ('061.005.192.000', 'ID'),
    ('061.005.208.000', 'AU'),
    ('061.006.000.000', 'MY'),
    ('061.006.192.000', 'AU'),
    ('061.008.224.000', 'SG'),
    ('061.009.000.000', 'PH'),
    ('061.009.128.000', 'AU'),
    ('061.010.000.000', 'HK'),
    ('061.011.000.000', 'IN'),
    ('061.011.128.000', 'AU'),
    ('061.011.224.000', 'TH'),
    ('061.012.000.000', 'AU'),
    ('061.013.000.000', 'TW'),
    ('061.014.000.000', 'US'),
    ('061.014.064.000', 'AU'),
    ('061.015.000.000', 'HK'),
    ('061.016.000.000', 'TW'),
    ('061.016.223.000', '--'),
    ('061.016.224.000', 'AU'),
    ('061.018.000.000', 'HK'),
    ('061.019.000.000', 'AU'),
    ('061.020.000.000', 'TW'),
    ('061.021.000.000', 'AU'),
    ('061.024.000.000', 'JP'),
    ('061.027.144.000', 'AU'),
    ('061.028.000.000', 'CN'),
    ('061.028.064.000', 'AU'),
    ('061.030.000.000', 'TW'),
    ('061.031.000.000', 'AU'),
    ('061.032.000.000', 'KR'),
    ('061.044.000.000', 'AU'),
    ('061.048.000.000', 'CN'),
    ('061.056.000.000', 'TW'),
    ('061.068.000.000', 'AU'),
    ('061.070.000.000', 'TW'),
    ('061.072.000.000', 'KR'),
    ('061.086.000.000', 'AU'),
    ('061.092.000.000', 'HK'),
    ('061.093.000.000', 'AU'),
    ('061.094.000.000', 'ID'),
    ('061.095.000.000', 'AU'),
    ('061.095.224.000', 'IN'),
    ('061.095.240.000', 'AU'),
    ('061.096.000.000', 'KR'),
    ('061.112.000.000', 'JP'),
    ('061.128.000.000', 'CN'),
    ('061.192.000.000', 'JP'),
    ('061.216.000.000', 'TW'),
    ('061.232.000.000', 'CN'),
    ('061.238.000.000', 'AU'),
    ('061.240.000.000', 'CN'),
    ('061.244.000.000', 'AU'),
    ('061.248.000.000', 'KR'),
    ('062.000.000.000', 'IL'),
    ('062.001.000.000', 'GR'),
    ('062.002.000.000', 'CH'),
    ('062.003.000.000', 'SA'),
    ('062.003.032.000', 'GB'),
    ('062.003.041.000', 'SA'),
    ('062.003.064.000', 'GB'),
    ('062.003.128.000', 'SE'),
    ('062.003.160.000', 'PL'),
    ('062.003.192.000', 'EU'),
    ('062.004.000.000', 'FR'),
    ('062.004.032.000', 'IT'),
    ('062.004.064.000', 'DE'),
    ('062.004.068.000', 'CA'),
    ('062.004.069.000', 'DE'),
    ('062.004.071.000', 'FR'),
    ('062.004.074.000', 'DE'),
    ('062.004.076.000', 'FR'),
    ('062.004.079.000', 'DE'),
    ('062.004.083.000', 'NL'),
    ('062.004.084.000', 'DE'),
    ('062.004.086.000', 'FR'),
    ('062.004.087.000', 'NL'),
    ('062.004.093.000', 'DE'),
    ('062.004.094.000', 'NL'),
    ('062.004.096.000', 'CZ'),
    ('062.004.128.000', 'BE'),
    ('062.005.000.000', 'SE'),
    ('062.005.128.000', 'RU'),
    ('062.006.000.000', 'GB'),
    ('062.008.000.000', 'FR'),
    ('062.008.032.000', 'NL'),
    ('062.008.064.000', 'KE'),
    ('062.008.096.000', 'GB'),
    ('062.008.128.000', 'DE'),
    ('062.009.000.000', 'IE'),
    ('062.010.000.000', 'IT'),
    ('062.012.000.000', 'NL'),
    ('062.012.032.000', 'DK'),
    ('062.012.064.000', 'GB'),
    ('062.012.096.000', 'EG'),
    ('062.012.128.000', 'CH'),
    ('062.013.000.000', 'SE'),
    ('062.013.048.000', 'NO'),
    ('062.013.049.000', 'SE'),
    ('062.013.050.000', 'NO'),
    ('062.013.051.000', 'SE'),
    ('062.013.128.000', 'GB'),
    ('062.013.160.000', 'IT'),
    ('062.013.192.000', 'AT'),
    ('062.013.224.000', 'ES'),
    ('062.016.000.000', 'UA'),
    ('062.016.032.000', 'DE'),
    ('062.016.064.000', 'TJ'),
    ('062.016.066.000', 'RU'),
    ('062.016.067.000', 'UZ'),
    ('062.016.069.000', 'RU'),
    ('062.016.128.000', 'DE'),
    ('062.017.000.000', 'GB'),
    ('062.017.001.000', 'IE'),
    ('062.017.002.000', 'GB'),
    ('062.017.003.000', 'IE'),
    ('062.017.020.000', 'GB'),
    ('062.017.021.000', 'IE'),
    ('062.017.022.000', 'GB'),
    ('062.017.025.000', 'IE'),
    ('062.017.027.000', 'GB'),
    ('062.017.028.000', 'IE'),
    ('062.017.029.000', 'GB'),
    ('062.017.030.000', 'IE'),
    ('062.017.033.000', 'GB'),
    ('062.017.034.000', 'IE'),
    ('062.017.128.000', 'GB'),
    ('062.017.129.000', 'IE'),
    ('062.017.130.000', 'GB'),
    ('062.017.131.000', 'IE'),
    ('062.017.132.000', 'GB'),
    ('062.017.136.000', 'IE'),
    ('062.017.138.000', 'GB'),
    ('062.017.143.000', 'IE'),
    ('062.017.145.000', 'GB'),
    ('062.017.149.000', 'IE'),
    ('062.017.150.000', 'GB'),
    ('062.017.151.000', 'IE'),
    ('062.017.152.000', 'GB'),
    ('062.017.155.000', 'IE'),
    ('062.017.159.000', 'GB'),
    ('062.017.165.000', 'IE'),
    ('062.017.166.000', 'GB'),
    ('062.017.168.000', 'IE'),
    ('062.018.000.000', 'GB'),
    ('062.020.000.000', 'SE'),
    ('062.021.000.000', 'PL'),
    ('062.021.128.000', 'NL'),
    ('062.022.000.000', 'ES'),
    ('062.023.000.000', 'FR'),
    ('062.024.000.000', 'DE'),
    ('062.024.032.000', 'FR'),
    ('062.024.064.000', 'CZ'),
    ('062.024.096.000', 'KE'),
    ('062.024.128.000', 'GB'),
    ('062.026.000.000', 'DE'),
    ('062.026.065.000', 'IT'),
    ('062.026.066.000', 'DE'),
    ('062.026.093.000', 'IE'),
    ('062.026.094.000', 'DE'),
    ('062.026.096.000', 'AT'),
    ('062.026.097.000', 'DE'),
    ('062.026.118.000', 'US'),
    ('062.026.119.000', 'DE'),
    ('062.026.127.000', 'SE'),
    ('062.026.128.000', 'DE'),
    ('062.026.172.000', 'NL'),
    ('062.026.173.000', 'DE'),
    ('062.026.189.000', 'NL'),
    ('062.026.190.000', 'DE'),
    ('062.026.210.000', 'AT'),
    ('062.026.211.000', 'DE'),
    ('062.027.007.000', 'GB'),
    ('062.027.008.000', 'DE'),
    ('062.027.010.000', 'US'),
    ('062.027.011.000', 'DE'),
    ('062.027.012.000', 'PT'),
    ('062.027.013.000', 'DE'),
    ('062.027.098.000', 'AT'),
    ('062.027.099.000', 'DE'),
    ('062.027.100.000', 'AT'),
    ('062.027.104.000', 'DE'),
    ('062.028.000.000', 'GB'),
    ('062.029.000.000', 'TR'),
    ('062.029.128.000', 'DE'),
    ('062.029.132.000', 'CH'),
    ('062.029.133.000', 'DE'),
    ('062.029.135.000', 'CH'),
    ('062.029.136.000', 'DE'),
    ('062.029.137.000', 'PL'),
    ('062.029.139.000', 'CH'),
    ('062.029.140.000', 'DE'),
    ('062.029.161.000', 'CH'),
    ('062.029.162.000', 'DE'),
    ('062.029.163.000', 'CH'),
    ('062.029.164.000', 'DE'),
    ('062.029.165.000', 'CH'),
    ('062.029.166.000', 'DE'),
    ('062.029.168.000', 'CH'),
    ('062.029.240.000', 'PL'),
    ('062.029.248.000', 'CH'),
    ('062.030.000.000', 'GB'),
    ('062.032.000.000', 'CH'),
    ('062.032.032.000', 'GB'),
    ('062.032.033.000', 'BY'),
    ('062.032.034.000', 'GB'),
    ('062.032.036.000', 'GE'),
    ('062.032.047.000', 'BY'),
    ('062.032.050.000', 'IR'),
    ('062.032.051.000', 'GB'),
    ('062.032.052.000', 'BG'),
    ('062.032.053.000', 'GB'),
    ('062.032.055.000', 'UA'),
    ('062.032.056.000', 'IR'),
    ('062.032.060.000', 'KW'),
    ('062.032.061.000', 'GB'),
    ('062.032.062.000', 'IR'),
    ('062.032.063.000', 'LT'),
    ('062.032.064.000', 'GB'),
    ('062.032.128.000', 'PL'),
    ('062.033.000.000', 'EU'),
    ('062.036.000.000', 'ES'),
    ('062.038.000.000', 'GR'),
    ('062.039.000.000', 'FR'),
    ('062.040.000.000', 'DE'),
    ('062.040.032.000', 'IE'),
    ('062.040.064.000', 'CZ'),
    ('062.040.096.000', 'GB'),
    ('062.040.128.000', 'AT'),
    ('062.041.000.000', 'NL'),
    ('062.041.003.000', 'CZ'),
    ('062.041.004.000', 'EU'),
    ('062.041.006.000', 'IR'),
    ('062.041.008.000', 'BE'),
    ('062.041.009.000', 'EU'),
    ('062.041.012.000', 'NL'),
    ('062.041.013.000', 'EU'),
    ('062.041.014.000', 'NL'),
    ('062.041.017.000', 'EU'),
    ('062.041.022.000', 'NL'),
    ('062.041.023.000', 'EU'),
    ('062.041.024.000', 'NL'),
    ('062.041.026.000', 'IR'),
    ('062.041.032.000', 'NL'),
    ('062.041.033.000', 'IR'),
    ('062.041.040.000', 'NA'),
    ('062.041.048.000', 'NL'),
    ('062.041.050.000', 'IR'),
    ('062.041.051.000', 'NL'),
    ('062.041.052.000', 'IR'),
    ('062.041.064.000', 'DE'),
    ('062.041.065.000', 'EU'),
    ('062.041.066.000', 'NL'),
    ('062.041.068.000', 'IR'),
    ('062.041.070.000', 'NL'),
    ('062.041.071.000', 'IR'),
    ('062.041.072.000', 'FR'),
    ('062.041.073.000', 'EU'),
    ('062.041.074.000', 'NL'),
    ('062.041.076.000', 'EU'),
    ('062.041.080.000', 'DE'),
    ('062.041.088.000', 'GB'),
    ('062.041.090.000', 'EU'),
    ('062.041.096.000', 'GB'),
    ('062.041.100.000', 'EU'),
    ('062.041.101.000', 'GB'),
    ('062.041.105.000', 'EU'),
    ('062.041.112.000', 'IE'),
    ('062.041.113.000', 'US'),
    ('062.041.115.000', 'EU'),
    ('062.041.116.000', 'NL'),
    ('062.041.118.000', 'EU'),
    ('062.041.120.000', 'PT'),
    ('062.041.122.000', 'EU'),
    ('062.041.128.000', 'DE'),
    ('062.041.130.000', 'EU'),
    ('062.041.136.000', 'FR'),
    ('062.041.138.000', 'EU'),
    ('062.041.144.000', 'FR'),
    ('062.041.146.000', 'DE'),
    ('062.041.148.000', 'AT'),
    ('062.041.150.000', 'EU'),
    ('062.041.152.000', 'GB'),
    ('062.041.154.000', 'EU'),
    ('062.041.156.000', 'GB'),
    ('062.041.160.000', 'IR'),
    ('062.041.161.000', 'DZ'),
    ('062.041.164.000', 'IR'),
    ('062.041.166.000', 'EU'),
    ('062.041.168.000', 'NL'),
    ('062.041.172.000', 'EU'),
    ('062.041.192.000', 'NL'),
    ('062.041.200.000', 'EU'),
    ('062.042.000.000', 'ES'),
    ('062.044.000.000', 'CZ'),
    ('062.044.032.000', 'ES'),
    ('062.044.064.000', 'GB'),
    ('062.044.096.000', 'BG'),
    ('062.044.128.000', 'DK'),
    ('062.044.192.000', 'FI'),
    ('062.045.000.000', 'NL'),
    ('062.046.000.000', 'AT'),
    ('062.048.000.000', 'CH'),
    ('062.048.032.000', 'IT'),
    ('062.048.064.000', 'DE'),
    ('062.048.096.000', 'CH'),
    ('062.048.128.000', 'PT'),
    ('062.048.192.000', 'EU'),
    ('062.049.000.000', 'GB'),
    ('062.050.000.000', 'NL'),
    ('062.050.004.000', 'GB'),
    ('062.052.000.000', 'DE'),
    ('062.052.020.000', 'FR'),
    ('062.052.023.000', 'DE'),
    ('062.052.028.000', 'GB'),
    ('062.052.029.000', 'DE'),
    ('062.052.032.000', 'NL'),
    ('062.052.033.000', 'DE'),
    ('062.052.078.000', 'CH'),
    ('062.052.079.000', 'DE'),
    ('062.052.087.000', 'CH'),
    ('062.052.088.000', 'DE'),
    ('062.052.095.000', 'GB'),
    ('062.052.096.000', 'IE'),
    ('062.052.097.000', 'DE'),
    ('062.052.114.000', 'FR'),
    ('062.052.115.000', 'DE'),
    ('062.052.116.000', 'GB'),
    ('062.052.117.000', 'DE'),
    ('062.052.120.000', 'FR'),
    ('062.052.121.000', 'DE'),
    ('062.052.127.000', 'GB'),
    ('062.052.128.000', 'DE'),
    ('062.052.150.000', 'FR'),
    ('062.052.151.000', 'DE'),
    ('062.053.012.000', 'GB'),
    ('062.053.013.000', 'DE'),
    ('062.053.225.000', 'IT'),
    ('062.053.226.000', 'DE'),
    ('062.055.001.000', 'GB'),
    ('062.055.008.000', 'DE'),
    ('062.055.009.000', 'GB'),
    ('062.055.021.000', 'DE'),
    ('062.055.024.000', 'GB'),
    ('062.055.027.000', 'DE'),
    ('062.055.029.000', 'GB'),
    ('062.055.032.000', 'DE'),
    ('062.055.033.000', 'GB'),
    ('062.055.045.000', 'DE'),
    ('062.055.048.000', 'GB'),
    ('062.055.060.000', 'DE'),
    ('062.055.064.000', 'GB'),
    ('062.055.079.000', 'DE'),
    ('062.055.081.000', 'GB'),
    ('062.055.095.000', 'DE'),
    ('062.055.097.000', 'GB'),
    ('062.055.109.000', 'DE'),
    ('062.055.112.000', 'GB'),
    ('062.055.116.000', 'DE'),
    ('062.055.120.000', 'GB'),
    ('062.055.128.000', 'DE'),
    ('062.056.000.000', 'GB'),
    ('062.056.128.000', 'TR'),
    ('062.056.140.000', 'CM'),
    ('062.056.143.000', 'IL'),
    ('062.056.144.000', 'CM'),
    ('062.056.152.000', 'GH'),
    ('062.056.156.000', 'KE'),
    ('062.056.158.000', 'ZW'),
    ('062.056.160.000', 'CD'),
    ('062.056.162.000', 'MG'),
    ('062.056.165.000', 'GH'),
    ('062.056.167.000', 'MG'),
    ('062.056.168.000', 'ZW'),
    ('062.056.170.000', 'CI'),
    ('062.056.173.000', 'BJ'),
    ('062.056.174.000', 'RW'),
    ('062.056.184.000', 'KE'),
    ('062.056.186.000', 'TG'),
    ('062.056.187.000', 'GH'),
    ('062.056.188.000', 'TG'),
    ('062.056.190.000', 'IL'),
    ('062.056.192.000', 'GH'),
    ('062.056.193.000', 'IL'),
    ('062.057.000.000', 'ES'),
    ('062.058.000.000', 'BE'),
    ('062.058.001.000', 'NL'),
    ('062.058.007.000', 'BE'),
    ('062.058.008.000', 'NL'),
    ('062.058.011.000', 'BE'),
    ('062.058.014.000', 'NL'),
    ('062.058.017.000', 'BE'),
    ('062.058.019.000', 'NL'),
    ('062.058.021.000', 'BE'),
    ('062.058.024.000', 'NL'),
    ('062.058.027.000', 'BE'),
    ('062.058.028.000', 'NL'),
    ('062.058.032.000', 'BE'),
    ('062.058.033.000', 'NL'),
    ('062.058.059.000', 'BE'),
    ('062.058.060.000', 'NL'),
    ('062.058.079.000', 'BE'),
    ('062.058.080.000', 'NL'),
    ('062.058.082.000', 'BE'),
    ('062.058.088.000', 'NL'),
    ('062.058.091.000', 'BE'),
    ('062.058.092.000', 'NL'),
    ('062.058.096.000', 'BE'),
    ('062.058.114.000', 'NL'),
    ('062.058.116.000', 'BE'),
    ('062.058.126.000', 'NL'),
    ('062.058.130.000', 'BE'),
    ('062.058.131.000', 'NL'),
    ('062.058.133.000', 'BE'),
    ('062.058.136.000', 'NL'),
    ('062.058.139.000', 'BE'),
    ('062.058.142.000', 'NL'),
    ('062.058.143.000', 'BE'),
    ('062.058.144.000', 'NL'),
    ('062.058.145.000', 'BE'),
    ('062.058.150.000', 'NL'),
    ('062.058.151.000', 'BE'),
    ('062.058.152.000', 'NL'),
    ('062.058.153.000', 'BE'),
    ('062.058.158.000', 'NL'),
    ('062.058.159.000', 'BE'),
    ('062.058.160.000', 'NL'),
    ('062.058.163.000', 'BE'),
    ('062.058.164.000', 'NL'),
    ('062.058.180.000', 'BE'),
    ('062.058.181.000', 'NL'),
    ('062.058.189.000', '--'),
    ('062.058.190.000', 'NL'),
    ('062.058.199.000', 'BE'),
    ('062.058.216.000', 'NL'),
    ('062.058.218.000', 'BE'),
    ('062.058.222.000', 'NL'),
    ('062.058.225.000', 'BE'),
    ('062.058.248.000', 'NL'),
    ('062.058.249.000', 'BE'),
    ('062.058.254.000', 'NL'),
    ('062.059.028.000', 'BE'),
    ('062.059.032.000', 'NL'),
    ('062.059.056.000', 'BE'),
    ('062.059.059.000', 'NL'),
    ('062.059.061.000', 'BE'),
    ('062.059.064.000', 'NL'),
    ('062.059.093.000', 'BE'),
    ('062.059.096.000', 'NL'),
    ('062.059.113.000', 'BE'),
    ('062.059.128.000', 'NL'),
    ('062.059.155.000', 'BE'),
    ('062.059.156.000', 'NL'),
    ('062.059.193.000', 'BE'),
    ('062.059.196.000', 'NL'),
    ('062.059.205.000', 'BE'),
    ('062.059.255.000', 'NL'),
    ('062.060.000.000', 'GB'),
    ('062.060.128.000', 'IR'),
    ('062.061.000.000', 'RU'),
    ('062.061.032.000', 'DE'),
    ('062.061.064.000', 'FI'),
    ('062.061.128.000', 'DK'),
    ('062.061.160.000', 'OM'),
    ('062.061.192.000', 'DZ'),
    ('062.062.000.000', 'BE'),
    ('062.062.003.000', 'EU'),
    ('062.062.004.000', 'BE'),
    ('062.062.007.000', 'EU'),
    ('062.062.009.000', 'BE'),
    ('062.062.011.000', 'EU'),
    ('062.062.012.000', 'BE'),
    ('062.062.015.000', 'EU'),
    ('062.062.017.000', 'BE'),
    ('062.062.019.000', 'EU'),
    ('062.062.021.000', 'BE'),
    ('062.062.023.000', 'EU'),
    ('062.062.024.000', 'BE'),
    ('062.062.027.000', 'EU'),
    ('062.062.028.000', 'BE'),
    ('062.062.031.000', 'EU'),
    ('062.062.033.000', 'BE'),
    ('062.062.035.000', 'EU'),
    ('062.062.037.000', 'BE'),
    ('062.062.043.000', 'EU'),
    ('062.062.045.000', 'BE'),
    ('062.062.046.000', 'EU'),
    ('062.062.049.000', 'BE'),
    ('062.062.050.000', 'EU'),
    ('062.062.053.000', 'BE'),
    ('062.062.054.000', 'EU'),
    ('062.062.057.000', 'BE'),
    ('062.062.058.000', 'EU'),
    ('062.062.060.000', 'BE'),
    ('062.062.063.000', 'EU'),
    ('062.062.066.000', 'BE'),
    ('062.062.074.000', 'EU'),
    ('062.062.076.000', 'BE'),
    ('062.062.082.000', 'EU'),
    ('062.062.084.000', 'BE'),
    ('062.062.085.000', 'EU'),
    ('062.062.087.000', 'BE'),
    ('062.062.088.000', 'EU'),
    ('062.062.089.000', 'BE'),
    ('062.062.090.000', 'EU'),
    ('062.062.091.000', 'BE'),
    ('062.062.092.000', 'EU'),
    ('062.062.128.000', 'FR'),
    ('062.063.000.000', 'PL'),
    ('062.064.000.000', 'RU'),
    ('062.064.032.000', 'GB'),
    ('062.064.064.000', 'UA'),
    ('062.064.128.000', 'GB'),
    ('062.065.000.000', 'SE'),
    ('062.065.017.000', 'NO'),
    ('062.065.018.000', 'SE'),
    ('062.065.028.000', 'NO'),
    ('062.065.032.000', 'EE'),
    ('062.065.064.000', 'SE'),
    ('062.065.128.000', 'CH'),
    ('062.065.160.000', 'CZ'),
    ('062.065.192.000', 'EE'),
    ('062.066.000.000', 'SE'),
    ('062.066.128.000', 'NO'),
    ('062.066.237.000', 'DK'),
    ('062.067.000.000', 'DE'),
    ('062.068.032.000', 'LY'),
    ('062.068.064.000', 'GR'),
    ('062.068.096.000', 'JO'),
    ('062.068.128.000', 'GR'),
    ('062.068.160.000', 'EU'),
    ('062.068.192.000', 'IL'),
    ('062.068.194.000', 'US'),
    ('062.068.196.000', 'GE'),
    ('062.068.199.000', 'IL'),
    ('062.068.200.000', 'GB'),
    ('062.068.203.000', 'IL'),
    ('062.068.212.000', 'US'),
    ('062.068.215.000', 'IL'),
    ('062.068.216.000', 'US'),
    ('062.068.219.000', 'IL'),
    ('062.068.220.000', 'US'),
    ('062.068.223.000', 'IL'),
    ('062.068.224.000', 'EU'),
    ('062.069.000.000', 'RU'),
    ('062.069.032.000', 'EU'),
    ('062.069.064.000', 'GB'),
    ('062.069.128.000', 'KW'),
    ('062.069.160.000', 'NL'),
    ('062.069.192.000', 'DE'),
    ('062.070.000.000', 'NO'),
    ('062.071.000.000', 'FI'),
    ('062.072.000.000', 'DE'),
    ('062.072.008.000', 'US'),
    ('062.072.012.000', 'DE'),
    ('062.072.032.000', 'GB'),
    ('062.072.042.000', 'DE'),
    ('062.072.044.000', 'GB'),
    ('062.072.045.000', 'DE'),
    ('062.072.046.000', 'GB'),
    ('062.072.047.000', 'DE'),
    ('062.072.048.000', 'GB'),
    ('062.072.049.000', 'DE'),
    ('062.072.056.000', 'US'),
    ('062.072.064.000', 'DE'),
    ('062.072.096.000', 'BE'),
    ('062.072.128.000', 'GB'),
    ('062.072.160.000', 'EU'),
    ('062.072.192.000', 'NL'),
    ('062.072.224.000', 'EU'),
    ('062.073.000.000', 'FR'),
    ('062.073.032.000', 'EU'),
    ('062.073.064.000', 'BG'),
    ('062.073.128.000', 'GB'),
    ('062.073.129.000', 'FR'),
    ('062.073.130.000', 'GB'),
    ('062.073.192.000', 'EU'),
    ('062.074.000.000', 'GR'),
    ('062.075.128.000', 'DE'),
    ('062.076.000.000', 'RU'),
    ('062.077.000.000', 'GB'),
    ('062.077.032.000', 'EU'),
    ('062.077.064.000', 'CZ'),
    ('062.077.128.000', 'HU'),
    ('062.077.160.000', 'IE'),
    ('062.077.192.000', 'EU'),
    ('062.078.000.000', 'GB'),
    ('062.078.012.000', 'EU'),
    ('062.078.128.000', 'FI'),
    ('062.079.000.000', 'DK'),
    ('062.080.000.000', 'DE'),
    ('062.080.064.000', 'HU'),
    ('062.080.065.000', 'SK'),
    ('062.080.066.000', 'HU'),
    ('062.080.071.000', 'SK'),
    ('062.080.072.000', 'HU'),
    ('062.080.076.000', 'CZ'),
    ('062.080.087.000', 'SK'),
    ('062.080.088.000', 'CZ'),
    ('062.080.096.000', 'DE'),
    ('062.080.119.000', 'NL'),
    ('062.080.120.000', 'FR'),
    ('062.080.122.000', 'DE'),
    ('062.080.123.000', 'FR'),
    ('062.080.124.000', 'DE'),
    ('062.080.128.000', 'FI'),
    ('062.080.160.000', 'EU'),
    ('062.080.192.000', 'SE'),
    ('062.080.224.000', 'EU'),
    ('062.081.000.000', 'ES'),
    ('062.084.000.000', 'LV'),
    ('062.084.032.000', 'DE'),
    ('062.084.064.000', 'LB'),
    ('062.084.096.000', 'RU'),
    ('062.084.128.000', 'CZ'),
    ('062.084.160.000', 'EU'),
    ('062.084.192.000', 'SE'),
    ('062.084.224.000', 'EU'),
    ('062.085.000.000', 'LV'),
    ('062.085.128.000', 'TR'),
    ('062.085.160.000', 'IT'),
    ('062.085.192.000', 'EU'),
    ('062.086.000.000', 'IT'),
    ('062.087.000.000', 'ES'),
    ('062.087.128.000', 'PL'),
    ('062.088.000.000', 'AT'),
    ('062.088.128.000', 'SE'),
    ('062.089.000.000', 'DK'),
    ('062.089.032.000', 'EU'),
    ('062.089.064.000', 'PL'),
    ('062.089.128.000', 'GI'),
    ('062.089.160.000', 'DE'),
    ('062.089.192.000', 'EU'),
    ('062.090.000.000', 'IL'),
    ('062.091.000.000', 'DE'),
    ('062.092.000.000', 'NO'),
    ('062.093.000.000', 'GB'),
    ('062.093.032.000', 'EU'),
    ('062.093.064.000', 'PL'),
    ('062.093.128.000', 'FR'),
    ('062.093.130.000', 'IT'),
    ('062.093.132.000', 'BE'),
    ('062.093.134.000', 'DK'),
    ('062.093.136.000', 'ES'),
    ('062.093.138.000', 'SE'),
    ('062.093.140.000', 'SZ'),
    ('062.093.142.000', 'IL'),
    ('062.093.144.000', 'GB'),
    ('062.093.160.000', 'ES'),
    ('062.093.192.000', 'EU'),
    ('062.094.000.000', 'IT'),
    ('062.095.000.000', 'SE'),
    ('062.095.128.000', 'EU'),
    ('062.096.000.000', 'DE'),
    ('062.097.000.000', 'IT'),
    ('062.097.032.000', 'EU'),
    ('062.097.064.000', 'ES'),
    ('062.097.160.000', 'NO'),
    ('062.097.192.000', 'EU'),
    ('062.098.000.000', 'IT'),
    ('062.099.000.000', 'ES'),
    ('062.099.128.000', 'AT'),
    ('062.100.000.000', 'NL'),
    ('062.100.064.000', 'IT'),
    ('062.100.096.000', 'ES'),
    ('062.100.128.000', 'SE'),
    ('062.100.160.000', 'EU'),
    ('062.100.192.000', 'KW'),
    ('062.100.224.000', 'EU'),
    ('062.101.000.000', 'IT'),
    ('062.101.032.000', 'EU'),
    ('062.101.064.000', 'IT'),
    ('062.101.160.000', 'ES'),
    ('062.101.192.000', 'EU'),
    ('062.102.000.000', 'BE'),
    ('062.102.003.000', 'GR'),
    ('062.102.004.000', 'BE'),
    ('062.102.128.000', 'RU'),
    ('062.103.000.000', 'GR'),
    ('062.104.000.000', 'DE'),
    ('062.105.000.000', 'CZ'),
    ('062.105.032.000', 'EU'),
    ('062.105.064.000', 'GB'),
    ('062.105.128.000', 'RU'),
    ('062.105.160.000', 'GB'),
    ('062.105.192.000', 'EU'),
    ('062.106.000.000', 'FR'),
    ('062.107.000.000', 'DK'),
    ('062.108.000.000', 'NL'),
    ('062.108.032.000', 'GB'),
    ('062.108.064.000', 'TR'),
    ('062.108.096.000', 'YU'),
    ('062.108.128.000', 'CH'),
    ('062.108.160.000', 'EU'),
    ('062.108.192.000', 'SE'),
    ('062.108.224.000', 'EU'),
    ('062.109.000.000', 'KZ'),
    ('062.109.032.000', 'EU'),
    ('062.109.064.000', 'DE'),
    ('062.109.160.000', 'RU'),
    ('062.109.192.000', 'EU'),
    ('062.110.000.000', 'IT'),
    ('062.111.000.000', 'DE'),
    ('062.111.128.000', 'EU'),
    ('062.112.000.000', 'BE'),
    ('062.112.032.000', 'DE'),
    ('062.112.096.000', 'EU'),
    ('062.112.128.000', 'DE'),
    ('062.112.160.000', 'EU'),
    ('062.112.192.000', 'HU'),
    ('062.112.224.000', 'EU'),
    ('062.113.000.000', 'TR'),
    ('062.113.032.000', 'EU'),
    ('062.113.064.000', 'RU'),
    ('062.113.128.000', 'NO'),
    ('062.113.160.000', 'EU'),
    ('062.114.000.000', 'EG'),
    ('062.115.000.000', 'GB'),
    ('062.115.250.000', 'SE'),
    ('062.115.251.000', 'GB'),
    ('062.115.255.000', 'SE'),
    ('062.116.000.000', 'AT'),
    ('062.116.128.000', 'DE'),
    ('062.116.192.000', 'BE'),
    ('062.116.224.000', 'EU'),
    ('062.117.000.000', 'DE'),
    ('062.117.032.000', 'EU'),
    ('062.117.064.000', 'RU'),
    ('062.117.128.000', 'ES'),
    ('062.118.000.000', 'RU'),
    ('062.119.000.000', 'SE'),
    ('062.119.044.000', 'NO'),
    ('062.119.045.000', 'SE'),
    ('062.120.000.000', 'FR'),
    ('062.121.000.000', 'GB'),
    ('062.121.032.000', 'EU'),
    ('062.121.064.000', 'PL'),
    ('062.121.160.000', 'EU'),
    ('062.122.000.000', 'IT'),
    ('062.124.000.000', 'GB'),
    ('062.127.000.000', 'EU'),
    ('062.128.000.000', 'DE'),
    ('062.128.032.000', 'IL'),
    ('062.128.064.000', 'IT'),
    ('062.128.096.000', 'EE'),
    ('062.128.128.000', 'GB'),
    ('062.128.160.000', 'EU'),
    ('062.128.192.000', 'GB'),
    ('062.128.224.000', 'EU'),
    ('062.129.000.000', 'IT'),
    ('062.129.032.000', 'EU'),
    ('062.129.064.000', 'GB'),
    ('062.129.128.000', 'NL'),
    ('062.129.160.000', 'EU'),
    ('062.130.000.000', 'GB'),
    ('062.131.000.000', 'NL'),
    ('062.132.000.000', 'DE'),
    ('062.133.032.000', 'EU'),
    ('062.133.064.000', 'NL'),
    ('062.133.160.000', 'EU'),
    ('062.134.000.000', 'DE'),
    ('062.135.000.000', 'EG'),
    ('062.135.128.000', 'EU'),
    ('062.136.000.000', 'GB'),
    ('062.138.000.000', 'DE'),
    ('062.139.000.000', 'EG'),
    ('062.140.000.000', 'DE'),
    ('062.140.032.000', 'AT'),
    ('062.140.064.000', 'EG'),
    ('062.140.128.000', 'NL'),
    ('062.140.160.000', 'EU'),
    ('062.140.192.000', 'GB'),
    ('062.140.224.000', 'EU'),
    ('062.141.000.000', 'CZ'),
    ('062.141.032.000', 'EU'),
    ('062.141.064.000', 'RU'),
    ('062.141.128.000', 'GB'),
    ('062.141.160.000', 'EU'),
    ('062.142.000.000', 'FI'),
    ('062.142.064.000', 'FR'),
    ('062.142.072.000', 'FI'),
    ('062.142.096.000', 'GB'),
    ('062.142.097.000', 'FI'),
    ('062.142.208.000', 'DE'),
    ('062.142.209.000', 'FI'),
    ('062.143.000.000', 'DE'),
    ('062.144.099.000', 'AT'),
    ('062.144.100.000', 'DE'),
    ('062.144.129.000', 'AT'),
    ('062.144.131.000', 'DE'),
    ('062.144.132.000', 'AT'),
    ('062.144.136.000', 'DE'),
    ('062.144.212.000', 'AT'),
    ('062.144.215.000', 'DE'),
    ('062.145.032.000', 'EU'),
    ('062.145.064.000', 'MK'),
    ('062.145.072.000', 'PK'),
    ('062.145.083.000', 'IR'),
    ('062.145.086.000', 'GB'),
    ('062.145.087.000', 'PK'),
    ('062.145.088.000', 'KG'),
    ('062.145.089.000', 'EG'),
    ('062.145.090.000', 'GB'),
    ('062.145.128.000', 'IS'),
    ('062.145.160.000', 'EU'),
    ('062.146.000.000', 'DE'),
    ('062.146.020.000', 'CH'),
    ('062.146.021.000', 'DE'),
    ('062.147.000.000', 'FR'),
    ('062.148.000.000', 'GB'),
    ('062.148.032.000', 'NO'),
    ('062.148.064.000', 'PL'),
    ('062.148.096.000', 'EU'),
    ('062.148.128.000', 'RU'),
    ('062.148.160.000', 'EU'),
    ('062.148.192.000', 'FI'),
    ('062.148.224.000', 'EU'),
    ('062.149.000.000', 'UA'),
    ('062.149.032.000', 'EU'),
    ('062.149.064.000', 'SA'),
    ('062.149.128.000', 'IT'),
    ('062.150.000.000', 'KW'),
    ('062.151.000.000', 'ES'),
    ('062.152.000.000', 'DE'),
    ('062.152.032.000', 'IT'),
    ('062.152.064.000', 'RU'),
    ('062.152.096.000', 'IT'),
    ('062.152.160.000', 'EU'),
    ('062.152.192.000', 'RU'),
    ('062.152.224.000', 'EU'),
    ('062.153.000.000', 'DE'),
    ('062.160.000.000', 'FR'),
    ('062.162.000.000', 'MK'),
    ('062.163.000.000', 'NL'),
    ('062.164.000.000', 'ES'),
    ('062.164.007.000', 'DE'),
    ('062.164.009.000', 'ES'),
    ('062.164.010.000', 'DE'),
    ('062.164.021.000', 'ES'),
    ('062.164.023.000', 'DE'),
    ('062.164.030.000', 'ES'),
    ('062.164.032.000', 'DE'),
    ('062.164.040.000', 'ES'),
    ('062.164.042.000', 'DE'),
    ('062.164.051.000', 'ES'),
    ('062.164.053.000', 'DE'),
    ('062.164.060.000', 'ES'),
    ('062.164.063.000', 'DE'),
    ('062.164.128.000', 'GB'),
    ('062.164.130.000', 'DE'),
    ('062.164.133.000', 'GB'),
    ('062.164.137.000', 'DE'),
    ('062.164.192.000', 'GB'),
    ('062.164.194.000', 'DE'),
    ('062.164.255.000', 'GB'),
    ('062.165.000.000', 'DE'),
    ('062.165.032.000', 'EU'),
    ('062.165.064.000', 'NL'),
    ('062.165.128.000', 'FI'),
    ('062.165.192.000', 'EU'),
    ('062.166.000.000', 'NL'),
    ('062.166.070.000', 'BE'),
    ('062.166.096.000', 'NL'),
    ('062.166.119.000', 'BE'),
    ('062.166.126.000', 'NL'),
    ('062.166.131.000', 'BE'),
    ('062.166.232.000', 'NL'),
    ('062.166.238.000', 'BE'),
    ('062.167.000.000', 'CH'),
    ('062.168.000.000', 'CZ'),
    ('062.168.064.000', 'SK'),
    ('062.168.128.000', 'SE'),
    ('062.168.160.000', 'EU'),
    ('062.168.192.000', 'DE'),
    ('062.168.224.000', 'EU'),
    ('062.169.000.000', 'DE'),
    ('062.169.032.000', 'EU'),
    ('062.169.064.000', 'PT'),
    ('062.169.128.000', 'GB'),
    ('062.169.160.000', 'EU'),
    ('062.170.000.000', 'GB'),
    ('062.172.002.000', 'ES'),
    ('062.172.003.000', 'GB'),
    ('062.172.004.000', 'ES'),
    ('062.172.005.000', 'GB'),
    ('062.173.000.000', 'MT'),
    ('062.173.032.000', 'EU'),
    ('062.173.064.000', 'GB'),
    ('062.173.128.000', 'AT'),
    ('062.173.160.000', 'EU'),
    ('062.174.000.000', 'ES'),
    ('062.176.000.000', 'SK'),
    ('062.176.032.000', 'FI'),
    ('062.176.064.000', 'BG'),
    ('062.176.128.000', 'DE'),
    ('062.176.160.000', 'EU'),
    ('062.176.192.000', 'NO'),
    ('062.176.224.000', 'EU'),
    ('062.177.000.000', 'IT'),
    ('062.177.032.000', 'EU'),
    ('062.177.064.000', 'CZ'),
    ('062.177.128.000', 'NL'),
    ('062.178.000.000', 'AT'),
    ('062.179.000.000', 'PL'),
    ('062.179.001.000', 'AT'),
    ('062.179.004.000', 'PL'),
    ('062.179.032.000', 'AT'),
    ('062.179.128.000', 'NO'),
    ('062.179.130.000', 'AT'),
    ('062.179.131.000', 'NO'),
    ('062.179.132.000', 'AT'),
    ('062.179.133.000', 'NO'),
    ('062.179.135.000', 'AT'),
    ('062.179.136.000', 'NO'),
    ('062.179.138.000', 'AT'),
    ('062.179.139.000', 'NO'),
    ('062.179.140.000', 'AT'),
    ('062.179.143.000', 'NO'),
    ('062.179.150.000', 'AT'),
    ('062.179.153.000', 'NO'),
    ('062.179.159.000', 'AT'),
    ('062.179.160.000', 'NO'),
    ('062.179.165.000', 'AT'),
    ('062.179.166.000', 'NO'),
    ('062.179.167.000', 'AT'),
    ('062.179.172.000', 'NO'),
    ('062.179.173.000', 'AT'),
    ('062.179.174.000', 'NO'),
    ('062.179.175.000', 'AT'),
    ('062.179.177.000', 'NO'),
    ('062.179.179.000', 'AT'),
    ('062.179.180.000', 'NO'),
    ('062.179.187.000', 'AT'),
    ('062.179.188.000', 'NO'),
    ('062.179.189.000', 'AT'),
    ('062.179.191.000', 'NO'),
    ('062.179.192.000', 'AT'),
    ('062.180.000.000', 'DE'),
    ('062.181.000.000', 'PL'),
    ('062.181.032.000', 'EU'),
    ('062.181.064.000', 'SE'),
    ('062.181.128.000', 'DE'),
    ('062.181.160.000', 'EU'),
    ('062.182.000.000', 'AT'),
    ('062.183.000.000', 'EU'),
    ('062.184.000.000', 'DE'),
    ('062.184.004.000', 'FR'),
    ('062.184.005.000', 'DE'),
    ('062.184.032.000', 'NL'),
    ('062.184.048.000', 'FR'),
    ('062.184.058.000', 'TR'),
    ('062.184.059.000', 'FR'),
    ('062.184.064.000', 'DK'),
    ('062.184.068.000', 'DE'),
    ('062.184.070.000', 'DK'),
    ('062.184.072.000', 'SE'),
    ('062.184.076.000', 'IT'),
    ('062.184.080.000', 'BE'),
    ('062.184.088.000', 'ZA'),
    ('062.184.096.000', 'FR'),
    ('062.184.101.000', 'BE'),
    ('062.184.102.000', 'FR'),
    ('062.184.110.000', 'ZA'),
    ('062.184.112.000', 'ES'),
    ('062.184.113.000', 'IT'),
    ('062.184.114.000', 'AT'),
    ('062.184.116.000', 'GB'),
    ('062.184.120.000', 'IT'),
    ('062.184.128.000', 'CH'),
    ('062.184.129.000', 'GB'),
    ('062.184.160.000', 'CH'),
    ('062.184.162.000', 'SE'),
    ('062.184.165.000', 'EU'),
    ('062.184.166.000', 'AT'),
    ('062.184.168.000', 'GB'),
    ('062.184.169.000', 'EU'),
    ('062.184.170.000', 'GB'),
    ('062.184.172.000', 'CH'),
    ('062.184.174.000', 'GB'),
    ('062.184.175.000', 'CH'),
    ('062.184.176.000', 'GB'),
    ('062.184.177.000', 'CH'),
    ('062.184.178.000', 'FI'),
    ('062.184.179.000', 'EU'),
    ('062.184.180.000', 'GB'),
    ('062.184.224.000', 'DE'),
    ('062.184.240.000', 'CH'),
    ('062.184.247.000', 'NO'),
    ('062.184.248.000', 'CH'),
    ('062.184.252.000', 'FR'),
    ('062.184.253.000', 'AT'),
    ('062.184.254.000', 'GB'),
    ('062.185.000.000', 'DE'),
    ('062.185.032.000', 'GB'),
    ('062.185.064.000', 'CH'),
    ('062.185.080.000', 'IT'),
    ('062.185.094.000', 'BE'),
    ('062.185.096.000', 'FR'),
    ('062.185.112.000', 'AT'),
    ('062.185.120.000', 'SE'),
    ('062.185.121.000', 'CH'),
    ('062.185.128.000', 'NL'),
    ('062.185.140.000', 'CH'),
    ('062.185.144.000', 'GB'),
    ('062.185.162.000', 'IT'),
    ('062.185.163.000', 'DE'),
    ('062.185.168.000', 'GB'),
    ('062.185.176.000', 'ZA'),
    ('062.185.193.000', 'FR'),
    ('062.185.194.000', 'ZA'),
    ('062.185.195.000', 'BE'),
    ('062.185.196.000', 'IT'),
    ('062.185.198.000', 'DK'),
    ('062.185.200.000', 'ES'),
    ('062.185.202.000', 'DE'),
    ('062.185.207.000', 'BE'),
    ('062.185.220.000', 'DK'),
    ('062.185.224.000', 'IE'),
    ('062.185.226.000', 'HU'),
    ('062.185.227.000', 'CZ'),
    ('062.185.228.000', 'NO'),
    ('062.185.229.000', 'DK'),
    ('062.185.230.000', 'SE'),
    ('062.185.231.000', 'DK'),
    ('062.185.232.000', 'GB'),
    ('062.185.244.000', 'CH'),
    ('062.185.248.000', 'DE'),
    ('062.185.251.000', 'EU'),
    ('062.185.253.000', 'DE'),
    ('062.185.255.000', 'ES'),
    ('062.186.000.000', 'DE'),
    ('062.186.002.000', 'FR'),
    ('062.186.003.000', 'DE'),
    ('062.186.011.000', 'GB'),
    ('062.186.012.000', 'DE'),
    ('062.186.023.000', 'GB'),
    ('062.186.027.000', 'NL'),
    ('062.186.028.000', 'GB'),
    ('062.186.046.000', 'NL'),
    ('062.186.047.000', 'GB'),
    ('062.186.051.000', 'EU'),
    ('062.186.052.000', 'GB'),
    ('062.186.064.000', 'CH'),
    ('062.186.071.000', 'GB'),
    ('062.186.073.000', 'NL'),
    ('062.186.074.000', 'CH'),
    ('062.186.076.000', 'SE'),
    ('062.186.077.000', 'TR'),
    ('062.186.078.000', 'HU'),
    ('062.186.080.000', 'IT'),
    ('062.186.094.000', 'BE'),
    ('062.186.096.000', 'FR'),
    ('062.186.112.000', 'AT'),
    ('062.186.122.000', 'GB'),
    ('062.186.123.000', 'AT'),
    ('062.186.124.000', 'GB'),
    ('062.186.128.000', 'NL'),
    ('062.186.144.000', 'CZ'),
    ('062.186.146.000', 'IE'),
    ('062.186.148.000', 'BE'),
    ('062.186.152.000', 'DE'),
    ('062.186.155.000', 'NO'),
    ('062.186.158.000', 'ZA'),
    ('062.186.160.000', 'BE'),
    ('062.186.166.000', 'IT'),
    ('062.186.168.000', 'GB'),
    ('062.186.176.000', 'ZA'),
    ('062.186.192.000', 'PT'),
    ('062.186.193.000', 'EU'),
    ('062.186.196.000', 'CH'),
    ('062.186.200.000', 'ES'),
    ('062.186.208.000', 'BE'),
    ('062.186.220.000', 'DK'),
    ('062.186.222.000', 'ZA'),
    ('062.186.224.000', 'GB'),
    ('062.186.228.000', 'NL'),
    ('062.186.232.000', 'DE'),
    ('062.186.236.000', 'CH'),
    ('062.186.238.000', 'BE'),
    ('062.186.240.000', 'AT'),
    ('062.186.244.000', 'FR'),
    ('062.186.248.000', 'DE'),
    ('062.186.251.000', 'EU'),
    ('062.186.252.000', 'GB'),
    ('062.187.000.000', 'DE'),
    ('062.187.004.000', 'EU'),
    ('062.187.012.000', 'DE'),
    ('062.187.016.000', 'CZ'),
    ('062.187.019.000', 'EU'),
    ('062.187.020.000', 'PL'),
    ('062.187.021.000', 'EU'),
    ('062.187.022.000', 'ZA'),
    ('062.187.032.000', 'DE'),
    ('062.187.036.000', 'NO'),
    ('062.187.038.000', 'ES'),
    ('062.187.040.000', 'EU'),
    ('062.187.041.000', 'FR'),
    ('062.187.042.000', 'AT'),
    ('062.187.044.000', 'GB'),
    ('062.187.048.000', 'EU'),
    ('062.187.056.000', 'NL'),
    ('062.187.059.000', 'EU'),
    ('062.187.064.000', 'GB'),
    ('062.187.068.000', 'NO'),
    ('062.187.069.000', 'EU'),
    ('062.187.072.000', 'FR'),
    ('062.187.080.000', 'ES'),
    ('062.187.082.000', 'GB'),
    ('062.187.086.000', 'EU'),
    ('062.187.092.000', 'DE'),
    ('062.187.093.000', 'FR'),
    ('062.187.096.000', 'EU'),
    ('062.187.104.000', 'FR'),
    ('062.187.106.000', 'EU'),
    ('062.187.112.000', 'GB'),
    ('062.187.128.000', 'FR'),
    ('062.187.144.000', 'NL'),
    ('062.187.160.000', 'IT'),
    ('062.187.164.000', 'EU'),
    ('062.187.165.000', 'IT'),
    ('062.187.168.000', 'GB'),
    ('062.187.170.000', 'EU'),
    ('062.187.176.000', 'CH'),
    ('062.187.180.000', 'GB'),
    ('062.187.184.000', 'IE'),
    ('062.187.186.000', 'SE'),
    ('062.187.188.000', 'AT'),
    ('062.187.192.000', 'BE'),
    ('062.187.202.000', 'NL'),
    ('062.187.203.000', 'BE'),
    ('062.187.205.000', 'EU'),
    ('062.187.208.000', 'UA'),
    ('062.187.209.000', 'DE'),
    ('062.187.210.000', 'EU'),
    ('062.187.212.000', 'DE'),
    ('062.187.216.000', 'ES'),
    ('062.187.218.000', 'RO'),
    ('062.187.219.000', 'EU'),
    ('062.187.220.000', 'GB'),
    ('062.187.224.000', 'DK'),
    ('062.187.225.000', 'EU'),
    ('062.187.228.000', 'FI'),
    ('062.187.229.000', 'EU'),
    ('062.187.232.000', 'IE'),
    ('062.187.235.000', 'EU'),
    ('062.187.240.000', 'GB'),
    ('062.187.241.000', 'BY'),
    ('062.187.242.000', 'GB'),
    ('062.188.001.000', 'EU'),
    ('062.188.032.000', 'GB'),
    ('062.188.072.000', 'EU'),
    ('062.188.079.000', 'GB'),
    ('062.188.140.000', 'EU'),
    ('062.188.142.000', 'GB'),
    ('062.188.148.000', 'EU'),
    ('062.188.150.000', 'GB'),
    ('062.188.158.000', 'EU'),
    ('062.188.162.000', 'GB'),
    ('062.188.164.000', 'EU'),
    ('062.188.166.000', 'GB'),
    ('062.188.176.000', 'EU'),
    ('062.188.178.000', 'GB'),
    ('062.192.000.000', 'DE'),
    ('062.192.023.000', 'IT'),
    ('062.192.024.000', 'DE'),
    ('062.192.064.000', 'NL'),
    ('062.192.128.000', 'DE'),
    ('062.192.160.000', 'EU'),
    ('062.192.192.000', 'DE'),
    ('062.192.224.000', 'EU'),
    ('062.193.000.000', 'IR'),
    ('062.193.032.000', 'EU'),
    ('062.193.064.000', 'EG'),
    ('062.193.128.000', 'YU'),
    ('062.193.160.000', 'EU'),
    ('062.194.000.000', 'NL'),
    ('062.196.000.000', 'IT'),
    ('062.197.000.000', 'DE'),
    ('062.197.032.000', 'EU'),
    ('062.197.064.000', 'BE'),
    ('062.197.128.000', 'NL'),
    ('062.197.160.000', 'EU'),
    ('062.198.000.000', 'DK'),
    ('062.200.000.000', 'AT'),
    ('062.200.001.000', 'EU'),
    ('062.200.002.000', 'AT'),
    ('062.200.008.000', 'IT'),
    ('062.200.011.000', 'EU'),
    ('062.200.012.000', 'CH'),
    ('062.200.013.000', 'EU'),
    ('062.200.016.000', 'CH'),
    ('062.200.022.000', 'EU'),
    ('062.200.024.000', 'CH'),
    ('062.200.025.000', 'EU'),
    ('062.200.041.000', 'GR'),
    ('062.200.046.000', 'EU'),
    ('062.200.056.000', 'ZA'),
    ('062.200.060.000', 'EU'),
    ('062.200.065.000', 'CZ'),
    ('062.200.066.000', 'EU'),
    ('062.200.068.000', 'DK'),
    ('062.200.070.000', 'EU'),
    ('062.200.080.000', 'GB'),
    ('062.200.085.000', 'EU'),
    ('062.200.088.000', 'ZA'),
    ('062.200.089.000', 'EU'),
    ('062.200.094.000', 'FI'),
    ('062.200.096.000', 'EU'),
    ('062.200.097.000', 'DE'),
    ('062.200.102.000', 'EU'),
    ('062.200.127.000', 'DK'),
    ('062.200.128.000', 'ZA'),
    ('062.200.136.000', 'ES'),
    ('062.200.141.000', 'EU'),
    ('062.200.144.000', 'NL'),
    ('062.200.148.000', 'EU'),
    ('062.200.150.000', 'BE'),
    ('062.200.154.000', 'DK'),
    ('062.200.156.000', 'SE'),
    ('062.200.157.000', 'EU'),
    ('062.200.160.000', 'ZA'),
    ('062.200.168.000', 'CH'),
    ('062.200.169.000', 'ZA'),
    ('062.200.170.000', 'FI'),
    ('062.200.172.000', 'NO'),
    ('062.200.176.000', 'AT'),
    ('062.200.177.000', 'EU'),
    ('062.200.178.000', 'ZA'),
    ('062.200.179.000', 'EU'),
    ('062.200.180.000', 'ZA'),
    ('062.200.182.000', 'EU'),
    ('062.200.192.000', 'FI'),
    ('062.200.194.000', 'EU'),
    ('062.200.195.000', 'BG'),
    ('062.200.196.000', 'EU'),
    ('062.200.198.000', 'PK'),
    ('062.200.199.000', 'EU'),
    ('062.200.200.000', 'GR'),
    ('062.200.204.000', 'NL'),
    ('062.200.211.000', 'PT'),
    ('062.200.212.000', 'EU'),
    ('062.200.213.000', 'NL'),
    ('062.200.216.000', 'IE'),
    ('062.200.218.000', 'BE'),
    ('062.200.219.000', 'EU'),
    ('062.201.000.000', 'ES'),
    ('062.201.032.000', 'EU'),
    ('062.201.064.000', 'HU'),
    ('062.201.128.000', 'FR'),
    ('062.201.160.000', 'EU'),
    ('062.202.000.000', 'CH'),
    ('062.204.000.000', 'DE'),
    ('062.204.005.000', 'BE'),
    ('062.204.032.000', 'GB'),
    ('062.204.064.000', 'NL'),
    ('062.204.096.000', 'CH'),
    ('062.204.128.000', 'IT'),
    ('062.204.160.000', 'EU'),
    ('062.204.192.000', 'ES'),
    ('062.204.224.000', 'EU'),
    ('062.205.000.000', 'BE'),
    ('062.205.032.000', 'EU'),
    ('062.205.064.000', 'BE'),
    ('062.205.128.000', 'IT'),
    ('062.205.160.000', 'EU'),
    ('062.206.000.000', 'DE'),
    ('062.207.000.000', 'IT'),
    ('062.208.000.000', 'DE'),
    ('062.209.000.000', 'NL'),
    ('062.209.032.000', 'EU'),
    ('062.209.128.000', 'GB'),
    ('062.209.160.000', 'EU'),
    ('062.210.000.000', 'FR'),
    ('062.211.000.000', 'IT'),
    ('062.212.032.000', 'RU'),
    ('062.212.064.000', 'NL'),
    ('062.212.096.000', 'FR'),
    ('062.212.128.000', 'NL'),
    ('062.212.160.000', 'EU'),
    ('062.212.192.000', 'GB'),
    ('062.212.224.000', 'EU'),
    ('062.213.000.000', 'RU'),
    ('062.213.032.000', 'EU'),
    ('062.213.064.000', 'RU'),
    ('062.213.128.000', 'GB'),
    ('062.213.160.000', 'EU'),
    ('062.214.000.000', 'DE'),
    ('062.215.000.000', 'KW'),
    ('062.216.000.000', 'NL'),
    ('062.216.032.000', 'GR'),
    ('062.216.064.000', 'GB'),
    ('062.216.096.000', 'FI'),
    ('062.216.128.000', 'GB'),
    ('062.216.145.000', 'ES'),
    ('062.216.146.000', 'GI'),
    ('062.216.149.000', 'EG'),
    ('062.216.150.000', 'GB'),
    ('062.216.152.000', 'EG'),
    ('062.216.154.000', 'GB'),
    ('062.216.160.000', 'EU'),
    ('062.216.192.000', 'IE'),
    ('062.216.224.000', 'EU'),
    ('062.217.000.000', 'FR'),
    ('062.217.032.000', 'EU'),
    ('062.217.064.000', 'IR'),
    ('062.217.128.000', 'AZ'),
    ('062.217.160.000', 'EU'),
    ('062.218.000.000', 'AT'),
    ('062.219.000.000', 'IL'),
    ('062.219.211.000', 'AT'),
    ('062.219.212.000', 'IL'),
    ('062.220.000.000', 'DE'),
    ('062.220.032.000', 'IT'),
    ('062.220.096.000', 'IR'),
    ('062.220.128.000', 'CH'),
    ('062.220.160.000', 'EU'),
    ('062.220.192.000', 'MK'),
    ('062.220.224.000', 'EU'),
    ('062.221.000.000', 'GB'),
    ('062.221.002.000', 'IE'),
    ('062.221.032.000', 'EU'),
    ('062.221.064.000', 'ES'),
    ('062.221.128.000', 'IT'),
    ('062.221.160.000', 'EU'),
    ('062.222.000.000', 'GB'),
    ('062.222.064.000', 'DE'),
    ('062.222.153.000', 'CH'),
    ('062.222.154.000', 'DE'),
    ('062.222.155.000', 'CH'),
    ('062.223.128.000', 'GB'),
    ('062.223.130.000', 'CH'),
    ('062.223.244.000', 'NL'),
    ('062.223.246.000', 'GB'),
    ('062.223.248.000', 'IT'),
    ('062.223.250.000', '--'),
    ('062.223.251.000', 'CH'),
    ('062.223.254.000', 'DE'),
    ('062.223.255.000', 'CH'),
    ('062.224.000.000', 'DE'),
    ('062.228.000.000', 'EU'),
    ('062.229.004.000', 'CH'),
    ('062.229.013.000', 'EU'),
    ('062.229.015.000', 'CH'),
    ('062.229.016.000', 'EU'),
    ('062.229.032.000', 'CZ'),
    ('062.229.036.000', 'PT'),
    ('062.229.037.000', 'CZ'),
    ('062.229.040.000', 'EU'),
    ('062.229.041.000', 'CZ'),
    ('062.229.042.000', 'EU'),
    ('062.229.045.000', 'CZ'),
    ('062.229.059.000', 'EU'),
    ('062.229.060.000', 'SK'),
    ('062.229.061.000', 'EU'),
    ('062.229.063.000', 'CZ'),
    ('062.229.064.000', 'EU'),
    ('062.229.065.000', 'PT'),
    ('062.229.067.000', 'EU'),
    ('062.229.068.000', 'PT'),
    ('062.229.069.000', 'EU'),
    ('062.229.070.000', 'PT'),
    ('062.229.077.000', 'EU'),
    ('062.229.079.000', 'PT'),
    ('062.229.084.000', 'EU'),
    ('062.229.085.000', 'PT'),
    ('062.229.088.000', 'EU'),
    ('062.229.090.000', 'PT'),
    ('062.229.096.000', 'EU'),
    ('062.229.097.000', 'NL'),
    ('062.229.099.000', 'EU'),
    ('062.229.100.000', 'NL'),
    ('062.229.102.000', 'EU'),
    ('062.229.103.000', 'BE'),
    ('062.229.104.000', 'NL'),
    ('062.229.105.000', 'EU'),
    ('062.229.107.000', 'NL'),
    ('062.229.112.000', 'LU'),
    ('062.229.117.000', 'EU'),
    ('062.229.120.000', 'ES'),
    ('062.229.123.000', 'EU'),
    ('062.229.128.000', 'TR'),
    ('062.229.133.000', 'EU'),
    ('062.229.144.000', 'NL'),
    ('062.229.145.000', 'EU'),
    ('062.229.146.000', 'NL'),
    ('062.229.150.000', 'EU'),
    ('062.229.151.000', 'NL'),
    ('062.229.152.000', 'EU'),
    ('062.229.154.000', 'NL'),
    ('062.229.156.000', 'EU'),
    ('062.229.176.000', 'GR'),
    ('062.229.178.000', 'EU'),
    ('062.229.183.000', 'GR'),
    ('062.229.184.000', 'EU'),
    ('062.229.192.000', 'CZ'),
    ('062.229.193.000', 'EU'),
    ('062.229.194.000', 'CZ'),
    ('062.229.203.000', 'EU'),
    ('062.229.204.000', 'CZ'),
    ('062.229.210.000', 'EU'),
    ('062.229.211.000', 'CZ'),
    ('062.229.212.000', 'EU'),
    ('062.229.224.000', 'ES'),
    ('062.229.225.000', 'EU'),
    ('062.229.226.000', 'ES'),
    ('062.229.227.000', 'EU'),
    ('062.230.000.000', 'SE'),
    ('062.231.000.000', 'RU'),
    ('062.231.032.000', 'EU'),
    ('062.231.064.000', 'RO'),
    ('062.231.128.000', 'GB'),
    ('062.231.160.000', 'EU'),
    ('062.232.000.000', 'GB'),
    ('062.233.000.000', 'BE'),
    ('062.233.032.000', 'EU'),
    ('062.233.064.000', 'GB'),
    ('062.233.128.000', 'PL'),
    ('062.234.000.000', 'NL'),
    ('062.235.000.000', 'BE'),
    ('062.236.000.000', 'FI'),
    ('062.236.196.000', 'SE'),
    ('062.236.197.000', 'FI'),
    ('062.238.000.000', 'NL'),
    ('062.239.000.000', 'GB'),
    ('062.240.000.000', 'DE'),
    ('062.240.032.000', 'LY'),
    ('062.240.064.000', 'FI'),
    ('062.240.096.000', 'EG'),
    ('062.240.128.000', 'DE'),
    ('062.240.160.000', 'EU'),
    ('062.240.192.000', 'CH'),
    ('062.240.224.000', 'EU'),
    ('062.241.000.000', 'IT'),
    ('062.241.032.000', 'EU'),
    ('062.241.128.000', 'EG'),
    ('062.241.160.000', 'EU'),
    ('062.242.000.000', 'DK'),
    ('062.244.000.000', 'UA'),
    ('062.244.064.000', 'EU'),
    ('062.244.128.000', 'PL'),
    ('062.244.160.000', 'EU'),
    ('062.245.000.000', 'MC'),
    ('062.245.032.000', 'EU'),
    ('062.245.064.000', 'CZ'),
    ('062.245.128.000', 'DE'),
    ('062.245.192.000', 'EU'),
    ('062.246.000.000', 'DE'),
    ('062.247.000.000', 'SE'),
    ('062.248.000.000', 'TR'),
    ('062.248.128.000', 'FI'),
    ('062.248.253.000', 'SE'),
    ('062.248.255.000', 'FI'),
    ('062.249.000.000', 'PT'),
    ('062.249.032.000', 'EU'),
    ('062.249.064.000', 'AT'),
    ('062.249.128.000', 'DE'),
    ('062.249.160.000', 'EU'),
    ('062.250.000.000', 'NL'),
    ('062.251.128.000', 'MA'),
    ('062.252.000.000', 'GB'),
    ('062.254.163.000', 'IE'),
    ('062.254.164.000', 'GB'),
    ('062.254.166.000', 'IE'),
    ('062.254.167.000', 'GB'),
    ('063.000.000.000', 'US'),
    ('063.064.076.000', 'VI'),
    ('063.064.080.000', 'US'),
    ('063.065.010.000', 'HT'),
    ('063.065.011.000', 'BO'),
    ('063.065.013.000', 'US'),
    ('063.065.171.000', 'PK'),
    ('063.065.172.000', 'US'),
    ('063.065.214.000', 'HT'),
    ('063.065.215.000', 'US'),
    ('063.065.248.000', 'AR'),
    ('063.065.252.000', 'US'),
    ('063.066.205.000', 'IN'),
    ('063.066.206.000', 'US'),
    ('063.067.252.000', 'SV'),
    ('063.068.000.000', 'US'),
    ('063.068.223.000', 'BO'),
    ('063.068.224.000', 'US'),
    ('063.068.246.000', 'IN'),
    ('063.068.252.000', 'US'),
    ('063.069.228.000', 'AR'),
    ('063.069.232.000', 'US'),
    ('063.070.024.000', 'PK'),
    ('063.070.028.000', 'US'),
    ('063.070.072.000', 'MX'),
    ('063.070.074.000', 'US'),
    ('063.070.178.000', 'NG'),
    ('063.070.179.000', 'US'),
    ('063.070.234.000', 'MX'),
    ('063.070.236.000', 'US'),
    ('063.071.198.000', 'EC'),
    ('063.071.200.000', 'US'),
    ('063.071.205.000', 'CO'),
    ('063.071.210.000', 'US'),
    ('063.072.016.000', 'VI'),
    ('063.072.020.000', 'US'),
    ('063.072.216.000', 'PR'),
    ('063.072.217.000', 'US'),
    ('063.073.052.000', 'FR'),
    ('063.073.053.000', 'US'),
    ('063.073.058.000', 'NG'),
    ('063.073.059.000', 'US'),
    ('063.073.136.000', 'PR'),
    ('063.073.140.000', 'US'),
    ('063.074.024.000', 'CO'),
    ('063.074.032.000', 'US'),
    ('063.074.154.000', 'GB'),
    ('063.074.156.000', 'US'),
    ('063.074.247.000', 'MX'),
    ('063.074.248.000', 'US'),
    ('063.075.176.000', 'AO'),
    ('063.075.177.000', 'US'),
    ('063.075.234.000', 'JM'),
    ('063.075.236.000', 'US'),
    ('063.077.111.000', 'PR'),
    ('063.077.112.000', 'US'),
    ('063.077.228.000', 'PR'),
    ('063.077.232.000', 'US'),
    ('063.080.041.000', 'EG'),
    ('063.080.042.000', 'US'),
    ('063.080.132.000', 'NI'),
    ('063.080.134.000', 'US'),
    ('063.081.036.000', 'SV'),
    ('063.081.040.000', 'US'),
    ('063.081.103.000', 'TR'),
    ('063.081.104.000', 'US'),
    ('063.081.198.000', 'PR'),
    ('063.081.200.000', 'US'),
    ('063.082.040.000', 'AR'),
    ('063.082.048.000', 'US'),
    ('063.083.090.000', 'DM'),
    ('063.083.091.000', 'US'),
    ('063.083.200.000', 'CL'),
    ('063.083.202.000', 'US'),
    ('063.084.064.000', 'MX'),
    ('063.084.068.000', 'US'),
    ('063.084.110.000', 'FM'),
    ('063.084.112.000', 'US'),
    ('063.085.042.000', 'CA'),
    ('063.085.044.000', 'US'),
    ('063.085.243.000', 'PR'),
    ('063.085.244.000', 'US'),
    ('063.089.032.000', '--'),
    ('063.089.033.000', 'HT'),
    ('063.089.034.000', '--'),
    ('063.089.035.000', 'HT'),
    ('063.089.036.000', '--'),
    ('063.089.037.000', 'HT'),
    ('063.089.040.000', 'US'),
    ('063.089.041.000', 'HT'),
    ('063.089.042.000', 'US'),
    ('063.089.043.000', '--'),
    ('063.089.046.000', 'US'),
    ('063.089.047.000', 'HT'),
    ('063.089.048.000', 'US'),
    ('063.091.208.000', 'PR'),
    ('063.092.000.000', 'US'),
    ('063.097.016.000', 'BR'),
    ('063.097.032.000', 'US'),
    ('063.097.052.000', 'CO'),
    ('063.097.054.000', 'US'),
    ('063.101.128.000', 'SV'),
    ('063.101.144.000', 'US'),
    ('063.103.046.000', 'AR'),
    ('063.103.048.000', 'US'),
    ('063.103.129.000', 'UG'),
    ('063.103.130.000', 'US'),
    ('063.103.132.000', 'GH'),
    ('063.103.134.000', 'US'),
    ('063.103.136.000', 'LR'),
    ('063.103.137.000', 'SA'),
    ('063.103.138.000', 'NG'),
    ('063.103.139.000', 'SA'),
    ('063.103.140.000', 'NG'),
    ('063.103.144.000', 'US'),
    ('063.103.244.000', 'PR'),
    ('063.103.248.000', 'US'),
    ('063.105.192.000', 'KR'),
    ('063.105.208.000', 'US'),
    ('063.106.032.000', 'AR'),
    ('063.106.036.000', 'US'),
    ('063.109.066.000', 'EC'),
    ('063.109.069.000', 'US'),
    ('063.109.070.000', 'PE'),
    ('063.109.071.000', 'US'),
    ('063.109.240.000', 'IN'),
    ('063.109.245.000', 'US'),
    ('063.109.246.000', 'NG'),
    ('063.109.249.000', 'US'),
    ('063.109.250.000', 'IN'),
    ('063.110.000.000', 'US'),
    ('063.110.188.000', 'MX'),
    ('063.110.190.000', 'US'),
    ('063.111.023.000', 'CA'),
    ('063.111.024.000', 'US'),
    ('063.111.026.000', 'CA'),
    ('063.111.029.000', 'US'),
    ('063.113.232.000', 'CO'),
    ('063.113.240.000', 'US'),
    ('063.114.037.000', 'PK'),
    ('063.114.038.000', 'US'),
    ('063.119.197.000', 'MX'),
    ('063.119.198.000', 'US'),
    ('063.119.200.000', 'PY'),
    ('063.119.202.000', 'US'),
    ('063.122.051.000', 'AU'),
    ('063.122.052.000', 'US'),
    ('063.122.154.000', 'NG'),
    ('063.122.155.000', 'US'),
    ('063.132.000.000', '--'),
    ('063.136.000.000', 'US'),
    ('063.136.112.000', 'KY'),
    ('063.136.120.000', 'US'),
    ('063.136.126.000', 'JM'),
    ('063.136.128.000', 'US'),
    ('063.138.000.000', '--'),
    ('063.140.000.000', 'US'),
    ('063.146.106.000', 'AR'),
    ('063.146.107.000', 'US'),
    ('063.146.200.000', 'PE'),
    ('063.146.208.000', 'US'),
    ('063.149.031.000', 'DE'),
    ('063.149.032.000', 'US'),
    ('063.151.166.000', 'KW'),
    ('063.151.167.000', 'US'),
    ('063.165.242.000', 'CA'),
    ('063.165.243.000', 'US'),
    ('063.170.172.000', 'CU'),
    ('063.170.176.000', 'US'),
    ('063.170.184.000', 'CU'),
    ('063.170.185.000', 'US'),
    ('063.171.148.000', 'GB'),
    ('063.171.149.000', 'US'),
    ('063.171.158.000', 'GB'),
    ('063.171.159.000', 'US'),
    ('063.174.079.000', 'CA'),
    ('063.174.080.000', 'US'),
    ('063.210.009.000', 'CA'),
    ('063.210.010.000', 'US'),
    ('063.243.128.000', 'CO'),
    ('063.243.130.000', 'PH'),
    ('063.243.131.000', 'TZ'),
    ('063.243.132.000', 'US'),
    ('063.243.133.000', 'MX'),
    ('063.243.134.000', 'HT'),
    ('063.243.136.000', 'US'),
    ('063.243.140.000', 'MX'),
    ('063.243.142.000', 'PR'),
    ('063.243.143.000', 'CA'),
    ('063.243.144.000', 'US'),
    ('063.243.145.000', 'HN'),
    ('063.243.146.000', 'EC'),
    ('063.243.149.000', 'US'),
    ('063.243.151.000', 'PY'),
    ('063.243.155.000', 'MX'),
    ('063.243.156.000', 'US'),
    ('063.244.000.000', '--'),
    ('063.248.000.000', 'US'),
    ('063.250.128.000', 'NL'),
    ('063.250.132.000', 'US'),
    ('063.250.133.000', 'NL'),
    ('063.250.144.000', 'US'),
    ('063.250.176.000', '--'),
    ('063.250.192.000', 'US'),
    ('063.250.224.000', '--'),
    ('063.251.000.000', 'US'),
    ('063.251.205.000', 'PH'),
    ('063.251.206.000', 'US'),
    ('064.004.064.000', 'CA'),
    ('064.004.096.000', 'US'),
    ('064.005.160.000', '--'),
    ('064.005.192.000', 'CA'),
    ('064.006.000.000', 'US'),
    ('064.006.230.000', '--'),
    ('064.006.231.000', 'US'),
    ('064.006.233.000', 'DE'),
    ('064.006.234.000', 'US'),
    ('064.007.128.000', 'CA'),
    ('064.007.144.000', '--'),
    ('064.007.160.000', 'US'),
    ('064.010.000.000', 'CA'),
    ('064.012.000.000', 'US'),
    ('064.015.016.000', '--'),
    ('064.015.032.000', 'JP'),
    ('064.015.048.000', '--'),
    ('064.015.064.000', 'US'),
    ('064.016.000.000', 'CA'),
    ('064.016.064.000', 'US'),
    ('064.017.096.000', '--'),
    ('064.017.128.000', 'US'),
    ('064.019.192.000', 'MX'),
    ('064.020.000.000', 'US'),
    ('064.020.190.000', 'GB'),
    ('064.020.191.000', 'US'),
    ('064.022.224.000', '--'),
    ('064.023.000.000', 'US'),
    ('064.025.000.000', '--'),
    ('064.026.000.000', 'US'),
    ('064.026.128.000', 'CA'),
    ('064.026.192.000', 'US'),
    ('064.028.000.000', 'GB'),
    ('064.028.016.000', 'NL'),
    ('064.028.024.000', 'NO'),
    ('064.028.025.000', 'NL'),
    ('064.028.026.000', 'NO'),
    ('064.028.027.000', 'NL'),
    ('064.028.032.000', 'US'),
    ('064.028.048.000', '--'),
    ('064.028.064.000', 'US'),
    ('064.028.128.000', 'TT'),
    ('064.028.144.000', 'US'),
    ('064.029.070.000', 'AS'),
    ('064.029.071.000', 'US'),
    ('064.032.064.000', 'DO'),
    ('064.032.128.000', 'US'),
    ('064.035.003.000', 'ES'),
    ('064.035.004.000', 'US'),
    ('064.035.032.000', 'CA'),
    ('064.035.033.000', 'US'),
    ('064.035.051.000', 'MX'),
    ('064.035.052.000', 'US'),
    ('064.035.053.000', 'DE'),
    ('064.035.054.000', 'CA'),
    ('064.035.055.000', 'US'),
    ('064.035.056.000', 'IL'),
    ('064.035.057.000', 'US'),
    ('064.035.144.000', '--'),
    ('064.035.160.000', 'CR'),
    ('064.035.165.000', 'AG'),
    ('064.035.166.000', 'CR'),
    ('064.035.167.000', 'US'),
    ('064.035.175.000', 'CR'),
    ('064.035.176.000', '--'),
    ('064.035.192.000', 'US'),
    ('064.037.064.000', 'IN'),
    ('064.037.065.000', 'US'),
    ('064.037.067.000', 'CA'),
    ('064.037.068.000', 'US'),
    ('064.037.070.000', 'SG'),
    ('064.037.071.000', 'US'),
    ('064.037.074.000', 'MY'),
    ('064.037.075.000', 'US'),
    ('064.037.077.000', 'CA'),
    ('064.037.078.000', 'AT'),
    ('064.037.080.000', 'US'),
    ('064.037.081.000', 'CA'),
    ('064.037.082.000', 'TZ'),
    ('064.037.083.000', 'CA'),
    ('064.037.084.000', 'GB'),
    ('064.037.085.000', 'MY'),
    ('064.037.086.000', 'CH'),
    ('064.037.087.000', 'US'),
    ('064.037.090.000', 'CA'),
    ('064.037.093.000', 'US'),
    ('064.037.095.000', 'CA'),
    ('064.037.096.000', 'US'),
    ('064.037.102.000', 'IN'),
    ('064.037.103.000', 'US'),
    ('064.037.109.000', 'CA'),
    ('064.037.110.000', 'US'),
    ('064.037.111.000', 'IN'),
    ('064.037.112.000', 'US'),
    ('064.037.115.000', 'CA'),
    ('064.037.116.000', 'US'),
    ('064.037.122.000', 'IN'),
    ('064.037.123.000', 'US'),
    ('064.037.125.000', 'AE'),
    ('064.037.126.000', 'US'),
    ('064.037.127.000', 'BE'),
    ('064.037.128.000', 'US'),
    ('064.039.005.000', 'IN'),
    ('064.039.006.000', 'US'),
    ('064.039.016.000', 'IN'),
    ('064.039.017.000', 'US'),
    ('064.039.020.000', 'NZ'),
    ('064.039.021.000', 'US'),
    ('064.039.022.000', 'BH'),
    ('064.039.023.000', 'US'),
    ('064.039.025.000', 'CA'),
    ('064.039.027.000', 'GB'),
    ('064.039.028.000', 'US'),
    ('064.039.160.000', 'CA'),
    ('064.039.192.000', 'US'),
    ('064.040.096.000', 'CA'),
    ('064.040.101.000', 'US'),
    ('064.040.102.000', 'CA'),
    ('064.040.112.000', '--'),
    ('064.040.128.000', 'US'),
    ('064.042.192.000', 'CA'),
    ('064.043.000.000', 'US'),
    ('064.046.107.000', '--'),
    ('064.046.108.000', 'US'),
    ('064.049.193.000', 'CA'),
    ('064.049.194.000', 'US'),
    ('064.049.201.000', 'CA'),
    ('064.049.203.000', 'US'),
    ('064.049.206.000', 'AU'),
    ('064.049.207.000', 'US'),
    ('064.049.210.000', 'CA'),
    ('064.049.211.000', 'NL'),
    ('064.049.212.000', 'US'),
    ('064.049.215.000', 'CA'),
    ('064.049.216.000', 'US'),
    ('064.049.224.000', 'HK'),
    ('064.049.225.000', 'US'),
    ('064.049.235.000', 'HK'),
    ('064.049.236.000', 'US'),
    ('064.049.240.000', '--'),
    ('064.050.000.000', 'US'),
    ('064.056.128.000', 'CA'),
    ('064.056.144.000', '--'),
    ('064.056.160.000', 'JP'),
    ('064.056.192.000', 'US'),
    ('064.056.224.000', 'CA'),
    ('064.056.240.000', '--'),
    ('064.057.000.000', 'US'),
    ('064.057.112.000', 'LS'),
    ('064.057.128.000', 'US'),
    ('064.057.240.000', '--'),
    ('064.058.000.000', 'US'),
    ('064.059.064.000', '--'),
    ('064.059.128.000', 'CA'),
    ('064.059.192.000', 'US'),
    ('064.069.064.000', 'CR'),
    ('064.069.066.000', 'CA'),
    ('064.069.079.000', 'BS'),
    ('064.069.080.000', 'CA'),
    ('064.069.096.000', 'US'),
    ('064.071.160.000', 'AU'),
    ('064.071.162.000', 'US'),
    ('064.071.166.000', 'AU'),
    ('064.071.167.000', 'US'),
    ('064.071.175.000', 'NL'),
    ('064.071.176.000', 'US'),
    ('064.072.208.000', '--'),
    ('064.072.224.000', 'CA'),
    ('064.072.240.000', '--'),
    ('064.073.000.000', 'US'),
    ('064.076.000.000', 'AR'),
    ('064.076.048.000', 'CO'),
    ('064.076.060.000', 'EC'),
    ('064.076.064.000', 'VE'),
    ('064.076.066.000', 'US'),
    ('064.076.068.000', 'SV'),
    ('064.076.080.000', 'US'),
    ('064.076.082.000', 'CO'),
    ('064.076.096.000', 'US'),
    ('064.076.099.000', 'SV'),
    ('064.076.100.000', 'US'),
    ('064.076.120.000', 'AR'),
    ('064.076.128.000', 'PE'),
    ('064.076.135.000', 'US'),
    ('064.076.140.000', 'CL'),
    ('064.076.176.000', 'CO'),
    ('064.076.180.000', 'US'),
    ('064.077.025.000', 'ZA'),
    ('064.077.026.000', 'US'),
    ('064.077.030.000', 'CA'),
    ('064.077.031.000', 'US'),
    ('064.084.021.000', 'CA'),
    ('064.084.022.000', 'US'),
    ('064.084.096.000', '--'),
    ('064.084.128.000', 'US'),
    ('064.085.007.000', 'GB'),
    ('064.085.008.000', 'US'),
    ('064.085.032.000', '--'),
    ('064.085.064.000', 'US'),
    ('064.086.000.000', 'CA'),
    ('064.086.004.000', 'US'),
    ('064.086.005.000', 'VE'),
    ('064.086.006.000', 'GT'),
    ('064.086.007.000', 'US'),
    ('064.086.008.000', 'PR'),
    ('064.086.011.000', 'US'),
    ('064.086.012.000', 'CA'),
    ('064.086.013.000', 'CO'),
    ('064.086.014.000', 'IL'),
    ('064.086.015.000', 'BS'),
    ('064.086.016.000', 'VE'),
    ('064.086.024.000', 'LR'),
    ('064.086.025.000', 'DZ'),
    ('064.086.026.000', 'PA'),
    ('064.086.027.000', 'AR'),
    ('064.086.028.000', 'US'),
    ('064.086.031.000', 'AN'),
    ('064.086.032.000', 'US'),
    ('064.086.040.000', 'PH'),
    ('064.086.045.000', 'US'),
    ('064.086.047.000', 'TZ'),
    ('064.086.052.000', 'FR'),
    ('064.086.053.000', 'US'),
    ('064.086.054.000', 'HT'),
    ('064.086.056.000', 'CA'),
    ('064.086.062.000', 'US'),
    ('064.086.064.000', 'EC'),
    ('064.086.068.000', 'EG'),
    ('064.086.070.000', 'US'),
    ('064.086.071.000', 'HN'),
    ('064.086.072.000', 'DE'),
    ('064.086.073.000', 'PR'),
    ('064.086.074.000', 'CO'),
    ('064.086.076.000', 'PR'),
    ('064.086.080.000', 'US'),
    ('064.086.096.000', 'RO'),
    ('064.086.097.000', 'US'),
    ('064.086.098.000', 'PK'),
    ('064.086.100.000', 'HN'),
    ('064.086.101.000', 'US'),
    ('064.086.108.000', 'DO'),
    ('064.086.112.000', 'CA'),
    ('064.086.113.000', 'US'),
    ('064.086.114.000', 'FR'),
    ('064.086.115.000', 'US'),
    ('064.086.116.000', 'CA'),
    ('064.086.117.000', 'MX'),
    ('064.086.118.000', 'US'),
    ('064.086.125.000', 'CA'),
    ('064.086.126.000', 'US'),
    ('064.086.128.000', 'IR'),
    ('064.086.129.000', 'US'),
    ('064.086.132.000', 'GL'),
    ('064.086.133.000', 'CA'),
    ('064.086.134.000', 'KW'),
    ('064.086.136.000', 'IN'),
    ('064.086.138.000', 'US'),
    ('064.086.140.000', 'CA'),
    ('064.086.142.000', 'CO'),
    ('064.086.143.000', 'PR'),
    ('064.086.144.000', 'CO'),
    ('064.086.145.000', 'US'),
    ('064.086.146.000', 'KR'),
    ('064.086.147.000', 'US'),
    ('064.086.149.000', 'PK'),
    ('064.086.150.000', 'US'),
    ('064.086.151.000', 'CA'),
    ('064.086.152.000', 'PY'),
    ('064.086.154.000', 'JO'),
    ('064.086.155.000', 'NG'),
    ('064.086.156.000', 'EG'),
    ('064.086.166.000', 'PR'),
    ('064.086.167.000', 'CO'),
    ('064.086.168.000', 'PR'),
    ('064.086.170.000', 'SV'),
    ('064.086.171.000', 'US'),
    ('064.086.172.000', 'PR'),
    ('064.086.173.000', 'CA'),
    ('064.086.178.000', 'US'),
    ('064.086.182.000', 'CO'),
    ('064.086.183.000', 'FR'),
    ('064.086.184.000', 'CO'),
    ('064.086.185.000', 'PA'),
    ('064.086.186.000', 'US'),
    ('064.086.191.000', 'CA'),
    ('064.086.192.000', 'US'),
    ('064.086.193.000', 'CO'),
    ('064.086.194.000', 'PW'),
    ('064.086.196.000', 'US'),
    ('064.086.198.000', 'CO'),
    ('064.086.199.000', 'PA'),
    ('064.086.200.000', 'CO'),
    ('064.086.202.000', 'CA'),
    ('064.086.203.000', 'MX'),
    ('064.086.204.000', 'CO'),
    ('064.086.205.000', 'US'),
    ('064.086.206.000', 'MX'),
    ('064.086.207.000', 'GA'),
    ('064.086.208.000', 'CO'),
    ('064.086.209.000', 'CA'),
    ('064.086.210.000', 'ZM'),
    ('064.086.212.000', 'CA'),
    ('064.086.215.000', 'PR'),
    ('064.086.216.000', 'US'),
    ('064.086.224.000', 'CO'),
    ('064.086.226.000', 'HT'),
    ('064.086.230.000', 'US'),
    ('064.086.231.000', 'KE'),
    ('064.086.239.000', 'PR'),
    ('064.086.240.000', 'US'),
    ('064.086.248.000', 'CO'),
    ('064.086.250.000', 'BO'),
    ('064.086.252.000', 'PR'),
    ('064.086.253.000', 'CO'),
    ('064.086.255.000', 'US'),
    ('064.087.128.000', 'CA'),
    ('064.088.000.000', 'US'),
    ('064.090.144.000', '--'),
    ('064.090.160.000', 'US'),
    ('064.090.179.000', 'NL'),
    ('064.090.180.000', 'US'),
    ('064.094.096.000', 'PH'),
    ('064.094.099.000', 'US'),
    ('064.094.101.000', 'PH'),
    ('064.094.102.000', 'US'),
    ('064.110.000.000', 'AN'),
    ('064.110.001.000', 'US'),
    ('064.110.003.000', 'SR'),
    ('064.110.005.000', 'PY'),
    ('064.110.006.000', 'JM'),
    ('064.110.007.000', 'BO'),
    ('064.110.008.000', 'HT'),
    ('064.110.009.000', 'US'),
    ('064.110.010.000', 'SV'),
    ('064.110.011.000', 'BB'),
    ('064.110.012.000', 'GY'),
    ('064.110.013.000', 'PY'),
    ('064.110.014.000', 'US'),
    ('064.110.015.000', 'AR'),
    ('064.110.017.000', 'US'),
    ('064.110.018.000', 'DO'),
    ('064.110.019.000', 'US'),
    ('064.110.021.000', 'DO'),
    ('064.110.022.000', 'BO'),
    ('064.110.023.000', 'US'),
    ('064.110.025.000', 'BZ'),
    ('064.110.026.000', 'US'),
    ('064.110.029.000', 'CI'),
    ('064.110.030.000', 'NG'),
    ('064.110.032.000', 'AU'),
    ('064.110.033.000', 'US'),
    ('064.110.035.000', 'AU'),
    ('064.110.036.000', 'BO'),
    ('064.110.038.000', 'US'),
    ('064.110.039.000', 'AU'),
    ('064.110.040.000', 'PH'),
    ('064.110.041.000', 'AU'),
    ('064.110.042.000', 'PH'),
    ('064.110.043.000', 'AU'),
    ('064.110.044.000', 'PH'),
    ('064.110.046.000', 'US'),
    ('064.110.047.000', 'PH'),
    ('064.110.048.000', 'GH'),
    ('064.110.049.000', 'US'),
    ('064.110.051.000', 'BO'),
    ('064.110.052.000', 'AR'),
    ('064.110.053.000', 'US'),
    ('064.110.054.000', 'CI'),
    ('064.110.056.000', 'US'),
    ('064.110.059.000', 'ID'),
    ('064.110.060.000', 'US'),
    ('064.110.061.000', 'DZ'),
    ('064.110.064.000', 'ES'),
    ('064.110.065.000', 'EG'),
    ('064.110.066.000', 'US'),
    ('064.110.067.000', 'UA'),
    ('064.110.068.000', 'DZ'),
    ('064.110.070.000', 'IN'),
    ('064.110.072.000', 'EG'),
    ('064.110.073.000', 'KE'),
    ('064.110.074.000', 'CM'),
    ('064.110.075.000', 'TR'),
    ('064.110.076.000', 'NG'),
    ('064.110.078.000', 'US'),
    ('064.110.079.000', 'GH'),
    ('064.110.080.000', 'US'),
    ('064.110.081.000', 'ZM'),
    ('064.110.082.000', 'TZ'),
    ('064.110.083.000', 'US'),
    ('064.110.086.000', 'IN'),
    ('064.110.087.000', 'PK'),
    ('064.110.088.000', 'LK'),
    ('064.110.089.000', 'US'),
    ('064.110.091.000', 'ID'),
    ('064.110.092.000', 'KE'),
    ('064.110.093.000', 'US'),
    ('064.110.095.000', 'PK'),
    ('064.110.096.000', 'IN'),
    ('064.110.097.000', 'ZW'),
    ('064.110.098.000', 'BD'),
    ('064.110.099.000', 'US'),
    ('064.110.101.000', 'SC'),
    ('064.110.102.000', 'ID'),
    ('064.110.103.000', 'PH'),
    ('064.110.104.000', 'ID'),
    ('064.110.105.000', 'US'),
    ('064.110.106.000', 'TZ'),
    ('064.110.107.000', 'ID'),
    ('064.110.108.000', 'US'),
    ('064.110.109.000', 'KE'),
    ('064.110.110.000', 'UG'),
    ('064.110.111.000', 'MG'),
    ('064.110.112.000', 'SV'),
    ('064.110.113.000', 'US'),
    ('064.110.117.000', 'AR'),
    ('064.110.118.000', 'NI'),
    ('064.110.120.000', 'SV'),
    ('064.110.121.000', 'GT'),
    ('064.110.122.000', 'BO'),
    ('064.110.123.000', 'AR'),
    ('064.110.124.000', 'BR'),
    ('064.110.125.000', 'DO'),
    ('064.110.126.000', 'BO'),
    ('064.110.127.000', 'PR'),
    ('064.110.128.000', 'BO'),
    ('064.110.131.000', 'ML'),
    ('064.110.132.000', 'US'),
    ('064.110.133.000', 'JM'),
    ('064.110.134.000', 'MX'),
    ('064.110.136.000', 'BO'),
    ('064.110.138.000', 'AR'),
    ('064.110.139.000', 'DZ'),
    ('064.110.140.000', 'US'),
    ('064.110.143.000', 'SA'),
    ('064.110.144.000', 'US'),
    ('064.110.147.000', 'NG'),
    ('064.110.148.000', 'US'),
    ('064.110.150.000', 'MG'),
    ('064.110.152.000', 'US'),
    ('064.110.158.000', 'GT'),
    ('064.110.159.000', 'VI'),
    ('064.110.160.000', 'US'),
    ('064.110.162.000', 'SA'),
    ('064.110.163.000', 'AR'),
    ('064.110.164.000', 'US'),
    ('064.110.167.000', 'MA'),
    ('064.110.168.000', 'AR'),
    ('064.110.170.000', 'US'),
    ('064.110.171.000', 'AR'),
    ('064.110.173.000', 'MA'),
    ('064.110.174.000', 'BO'),
    ('064.110.176.000', 'ID'),
    ('064.110.186.000', 'US'),
    ('064.110.188.000', 'ID'),
    ('064.110.189.000', 'US'),
    ('064.110.190.000', 'VI'),
    ('064.110.191.000', 'MX'),
    ('064.110.192.000', '--'),
    ('064.111.000.000', 'US'),
    ('064.113.195.000', 'CA'),
    ('064.113.196.000', 'US'),
    ('064.113.201.000', 'CA'),
    ('064.113.203.000', 'US'),
    ('064.113.210.000', 'CA'),
    ('064.113.212.000', 'US'),
    ('064.113.221.000', 'CA'),
    ('064.113.222.000', 'US'),
    ('064.113.223.000', 'CA'),
    ('064.113.224.000', 'US'),
    ('064.113.240.000', '--'),
    ('064.114.000.000', 'CA'),
    ('064.115.000.000', 'US'),
    ('064.116.129.000', 'VE'),
    ('064.116.130.000', 'US'),
    ('064.116.161.000', 'PA'),
    ('064.116.165.000', 'US'),
    ('064.116.193.000', 'CL'),
    ('064.116.196.000', 'US'),
    ('064.116.224.000', 'AR'),
    ('064.116.228.000', 'US'),
    ('064.116.229.000', 'AR'),
    ('064.116.230.000', 'US'),
    ('064.116.231.000', 'AR'),
    ('064.116.232.000', 'US'),
    ('064.119.080.000', '--'),
    ('064.119.096.000', 'CA'),
    ('064.119.112.000', '--'),
    ('064.119.128.000', 'US'),
    ('064.147.160.000', '--'),
    ('064.147.192.000', 'US'),
    ('064.147.208.000', '--'),
    ('064.147.224.000', 'US'),
    ('064.147.240.000', 'CA'),
    ('064.148.000.000', 'US'),
    ('064.180.000.000', 'CA'),
    ('064.181.000.000', 'US'),
    ('064.181.064.000', '--'),
    ('064.182.000.000', 'US'),
    ('064.184.000.000', '--'),
    ('064.185.000.000', 'US'),
    ('064.186.032.000', '--'),
    ('064.186.064.000', 'US'),
    ('064.186.080.000', '--'),
    ('064.186.096.000', 'US'),
    ('064.186.112.000', '--'),
    ('064.186.128.000', 'IL'),
    ('064.186.129.000', 'CA'),
    ('064.186.130.000', 'US'),
    ('064.186.144.000', '--'),
    ('064.186.160.000', 'US'),
    ('064.186.176.000', '--'),
    ('064.186.192.000', 'US'),
    ('064.187.000.000', 'CA'),
    ('064.187.064.000', '--'),
    ('064.187.128.000', 'US'),
    ('064.190.000.000', '--'),
    ('064.192.000.000', 'US'),
    ('064.209.186.000', 'CA'),
    ('064.209.188.000', 'US'),
    ('064.228.000.000', 'CA'),
    ('064.232.000.000', 'US'),
    ('064.243.038.000', 'CA'),
    ('064.243.039.000', 'US'),
    ('064.245.000.000', 'ZA'),
    ('064.245.016.000', 'US'),
    ('064.247.128.000', 'CA'),
    ('064.247.160.000', '--'),
    ('064.247.192.000', 'US'),
    ('064.247.224.000', '--'),
    ('064.248.000.000', 'US'),
    ('064.251.064.000', 'CA'),
    ('064.251.128.000', 'US'),
    ('064.254.000.000', 'CA'),
    ('064.254.032.000', 'US'),
    ('065.048.000.000', 'CA'),
    ('065.049.000.000', '--'),
    ('065.052.000.000', 'US'),
    ('065.060.000.000', '--'),
    ('065.064.000.000', 'US'),
    ('065.092.000.000', 'CA'),
    ('065.096.000.000', 'US'),
    ('065.105.192.000', 'KR'),
    ('065.105.208.000', 'US'),
    ('065.110.000.000', '--'),
    ('065.112.000.000', 'US'),
    ('065.167.024.000', 'HN'),
    ('065.167.032.000', 'US'),
    ('065.169.240.000', 'CU'),
    ('065.169.248.000', 'US'),
    ('065.173.056.000', 'UG'),
    ('065.173.064.000', 'US'),
    ('065.175.000.000', '--'),
    ('065.176.000.000', 'US'),
    ('065.192.032.000', 'SA'),
    ('065.192.033.000', 'US'),
    ('065.199.145.000', 'AE'),
    ('065.199.146.000', 'US'),
    ('065.199.148.000', 'JM'),
    ('065.199.149.000', 'US'),
    ('065.199.192.000', 'GY'),
    ('065.199.208.000', 'US'),
    ('065.209.192.000', 'PH'),
    ('065.209.194.000', 'US'),
    ('065.213.052.000', 'PH'),
    ('065.213.054.000', 'US'),
    ('066.007.192.000', '--'),
    ('066.007.224.000', 'US'),
    ('066.008.000.000', 'ZA'),
    ('066.008.128.000', 'US'),
    ('066.011.000.000', '--'),
    ('066.012.000.000', 'US'),
    ('066.035.000.000', 'CA'),
    ('066.035.016.000', '--'),
    ('066.035.064.000', 'US'),
    ('066.035.096.000', '--'),
    ('066.035.128.000', 'US'),
    ('066.038.128.000', 'CA'),
    ('066.039.000.000', 'US'),
    ('066.039.128.000', '--'),
    ('066.040.000.000', 'US'),
    ('066.040.003.000', 'CA'),
    ('066.040.004.000', 'PR'),
    ('066.040.005.000', 'US'),
    ('066.040.006.000', 'QA'),
    ('066.040.007.000', 'VG'),
    ('066.040.008.000', 'PR'),
    ('066.040.009.000', 'US'),
    ('066.040.010.000', 'AG'),
    ('066.040.011.000', 'US'),
    ('066.040.017.000', 'ES'),
    ('066.040.018.000', 'US'),
    ('066.040.022.000', 'RU'),
    ('066.040.023.000', 'US'),
    ('066.040.025.000', 'DK'),
    ('066.040.026.000', 'CA'),
    ('066.040.027.000', 'US'),
    ('066.040.028.000', 'RU'),
    ('066.040.029.000', 'US'),
    ('066.040.031.000', 'RU'),
    ('066.040.032.000', 'BG'),
    ('066.040.033.000', 'US'),
    ('066.040.034.000', 'PR'),
    ('066.040.035.000', 'CA'),
    ('066.040.037.000', 'AU'),
    ('066.040.038.000', 'US'),
    ('066.040.044.000', 'SA'),
    ('066.040.045.000', 'PR'),
    ('066.040.046.000', 'US'),
    ('066.040.053.000', 'GB'),
    ('066.040.054.000', 'US'),
    ('066.040.064.000', 'AU'),
    ('066.040.065.000', 'US'),
    ('066.040.069.000', 'PR'),
    ('066.040.070.000', 'US'),
    ('066.040.128.000', 'RU'),
    ('066.040.129.000', 'PR'),
    ('066.040.131.000', 'US'),
    ('066.040.151.000', 'PR'),
    ('066.040.152.000', 'US'),
    ('066.040.154.000', 'CA'),
    ('066.040.155.000', 'US'),
    ('066.046.000.000', 'CA'),
    ('066.047.000.000', 'US'),
    ('066.048.000.000', 'CA'),
    ('066.048.008.000', 'US'),
    ('066.048.009.000', 'CA'),
    ('066.048.018.000', 'US'),
    ('066.048.020.000', 'CA'),
    ('066.049.000.000', '--'),
    ('066.050.000.000', 'US'),
    ('066.050.089.000', 'PR'),
    ('066.050.100.000', 'US'),
    ('066.050.102.000', 'PR'),
    ('066.050.128.000', 'US'),
    ('066.050.165.000', 'PR'),
    ('066.051.000.000', 'US'),
    ('066.051.096.000', 'CA'),
    ('066.051.128.000', 'US'),
    ('066.051.144.000', '--'),
    ('066.051.160.000', 'CA'),
    ('066.051.176.000', '--'),
    ('066.051.192.000', 'US'),
    ('066.051.224.000', '--'),
    ('066.052.000.000', 'US'),
    ('066.054.064.000', '--'),
    ('066.054.128.000', 'US'),
    ('066.055.064.000', '--'),
    ('066.056.000.000', 'US'),
    ('066.059.128.000', 'CA'),
    ('066.059.192.000', 'US'),
    ('066.059.224.000', '--'),
    ('066.060.000.000', 'AR'),
    ('066.060.064.000', '--'),
    ('066.060.128.000', 'US'),
    ('066.060.192.000', '--'),
    ('066.061.000.000', 'US'),
    ('066.063.000.000', '--'),
    ('066.064.000.000', 'US'),
    ('066.077.128.000', '--'),
    ('066.078.000.000', 'US'),
    ('066.096.016.000', '--'),
    ('066.096.032.000', 'CL'),
    ('066.096.034.000', 'GT'),
    ('066.096.036.000', 'PE'),
    ('066.096.039.000', 'PA'),
    ('066.096.042.000', 'US'),
    ('066.096.046.000', 'VE'),
    ('066.096.048.000', 'US'),
    ('066.096.049.000', 'VE'),
    ('066.096.060.000', 'CL'),
    ('066.096.061.000', 'SV'),
    ('066.096.062.000', 'US'),
    ('066.096.063.000', 'CA'),
    ('066.096.064.000', 'US'),
    ('066.096.080.000', '--'),
    ('066.096.128.000', 'US'),
    ('066.098.000.000', 'DO'),
    ('066.098.128.000', '--'),
    ('066.099.000.000', 'US'),
    ('066.100.020.000', 'CA'),
    ('066.100.022.000', 'US'),
    ('066.100.029.000', 'CA'),
    ('066.100.030.000', 'US'),
    ('066.100.048.000', 'SG'),
    ('066.100.049.000', 'US'),
    ('066.100.217.000', 'CA'),
    ('066.100.218.000', 'US'),
    ('066.101.032.000', 'BR'),
    ('066.101.048.000', 'US'),
    ('066.102.000.000', '--'),
    ('066.104.000.000', 'US'),
    ('066.110.000.000', 'PR'),
    ('066.110.004.000', 'CA'),
    ('066.110.005.000', 'PR'),
    ('066.110.008.000', 'US'),
    ('066.110.011.000', 'CO'),
    ('066.110.012.000', 'US'),
    ('066.110.014.000', 'PR'),
    ('066.110.016.000', 'TZ'),
    ('066.110.020.000', 'CO'),
    ('066.110.023.000', 'US'),
    ('066.110.024.000', 'GH'),
    ('066.110.025.000', 'US'),
    ('066.110.026.000', 'LB'),
    ('066.110.027.000', 'US'),
    ('066.110.028.000', 'CO'),
    ('066.110.030.000', 'RW'),
    ('066.110.031.000', 'NG'),
    ('066.110.032.000', 'US'),
    ('066.110.058.000', 'PH'),
    ('066.110.059.000', 'CA'),
    ('066.110.060.000', 'PH'),
    ('066.110.061.000', 'CA'),
    ('066.110.062.000', 'US'),
    ('066.110.128.000', 'CA'),
    ('066.110.192.000', '--'),
    ('066.111.000.000', 'US'),
    ('066.111.220.000', 'CA'),
    ('066.111.221.000', 'US'),
    ('066.111.222.000', 'IN'),
    ('066.111.223.000', 'US'),
    ('066.117.000.000', '--'),
    ('066.118.000.000', 'US'),
    ('066.119.092.000', 'SV'),
    ('066.119.096.000', 'US'),
    ('066.119.112.000', '--'),
    ('066.119.128.000', 'US'),
    ('066.119.144.000', '--'),
    ('066.119.160.000', 'CA'),
    ('066.119.192.000', 'US'),
    ('066.128.016.000', '--'),
    ('066.128.032.000', 'CO'),
    ('066.128.048.000', '--'),
    ('066.128.064.000', 'US'),
    ('066.129.128.000', 'CA'),
    ('066.129.160.000', '--'),
    ('066.129.192.000', 'US'),
    ('066.129.224.000', '--'),
    ('066.130.000.000', 'CA'),
    ('066.130.128.000', 'US'),
    ('066.131.000.000', '--'),
    ('066.132.000.000', 'US'),
    ('066.150.158.000', 'PH'),
    ('066.150.159.000', 'US'),
    ('066.151.000.000', '--'),
    ('066.152.000.000', 'US'),
    ('066.152.032.000', '--'),
    ('066.152.064.000', 'US'),
    ('066.152.081.000', 'CA'),
    ('066.152.082.000', 'US'),
    ('066.152.096.000', '--'),
    ('066.152.128.000', 'US'),
    ('066.163.000.000', 'CA'),
    ('066.163.016.000', '--'),
    ('066.163.032.000', 'US'),
    ('066.163.048.000', '--'),
    ('066.163.064.000', 'CA'),
    ('066.163.080.000', '--'),
    ('066.163.096.000', 'US'),
    ('066.163.112.000', '--'),
    ('066.163.128.000', 'US'),
    ('066.163.192.000', 'CA'),
    ('066.163.208.000', '--'),
    ('066.163.224.000', 'US'),
    ('066.163.240.000', '--'),
    ('066.164.000.000', 'US'),
    ('066.164.200.000', 'NL'),
    ('066.164.216.000', 'US'),
    ('066.164.240.000', 'NL'),
    ('066.165.000.000', '--'),
    ('066.166.000.000', 'US'),
    ('066.166.128.000', '--'),
    ('066.168.000.000', 'US'),
    ('066.178.033.000', 'PY'),
    ('066.178.035.000', 'US'),
    ('066.178.064.000', '--'),
    ('066.178.128.000', 'US'),
    ('066.178.160.000', '--'),
    ('066.179.000.000', 'US'),
    ('066.179.128.000', '--'),
    ('066.180.000.000', 'US'),
    ('066.180.064.000', 'CA'),
    ('066.180.080.000', '--'),
    ('066.180.096.000', 'US'),
    ('066.180.112.000', '--'),
    ('066.180.128.000', 'US'),
    ('066.183.000.000', 'CA'),
    ('066.184.000.000', 'US'),
    ('066.184.128.000', '--'),
    ('066.185.000.000', 'US'),
    ('066.185.080.000', 'CA'),
    ('066.185.096.000', 'US'),
    ('066.185.112.000', '--'),
    ('066.185.128.000', 'US'),
    ('066.186.064.000', 'CA'),
    ('066.186.080.000', '--'),
    ('066.186.096.000', 'US'),
    ('066.186.112.000', '--'),
    ('066.186.128.000', 'US'),
    ('066.187.064.000', 'CA'),
    ('066.187.080.000', '--'),
    ('066.187.096.000', 'PH'),
    ('066.187.102.000', 'US'),
    ('066.187.112.000', '--'),
    ('066.187.128.000', 'US'),
    ('066.194.000.000', '--'),
    ('066.196.000.000', 'US'),
    ('066.197.131.000', 'AU'),
    ('066.197.132.000', 'US'),
    ('066.197.140.000', 'CA'),
    ('066.197.141.000', 'US'),
    ('066.197.170.000', 'CA'),
    ('066.197.171.000', 'US'),
    ('066.198.032.000', 'AR'),
    ('066.198.034.000', 'LB'),
    ('066.198.035.000', 'US'),
    ('066.198.041.000', 'SY'),
    ('066.198.042.000', 'US'),
    ('066.198.044.000', 'EC'),
    ('066.198.048.000', 'US'),
    ('066.198.064.000', '--'),
    ('066.199.000.000', 'US'),
    ('066.199.128.000', 'CA'),
    ('066.199.129.000', 'US'),
    ('066.199.130.000', 'CA'),
    ('066.199.132.000', 'US'),
    ('066.199.137.000', 'CA'),
    ('066.199.156.000', 'US'),
    ('066.199.160.000', 'CA'),
    ('066.199.192.000', 'US'),
    ('066.199.224.000', '--'),
    ('066.200.000.000', 'US'),
    ('066.201.032.000', '--'),
    ('066.201.064.000', 'IN'),
    ('066.201.065.000', 'US'),
    ('066.201.066.000', 'BE'),
    ('066.201.067.000', 'US'),
    ('066.201.068.000', 'CA'),
    ('066.201.070.000', 'US'),
    ('066.201.072.000', 'CA'),
    ('066.201.073.000', 'US'),
    ('066.201.074.000', 'CA'),
    ('066.201.077.000', 'US'),
    ('066.201.078.000', 'BE'),
    ('066.201.079.000', 'CA'),
    ('066.201.081.000', 'US'),
    ('066.201.082.000', 'AU'),
    ('066.201.083.000', 'CA'),
    ('066.201.085.000', 'US'),
    ('066.201.086.000', 'CA'),
    ('066.201.089.000', 'US'),
    ('066.201.092.000', 'CA'),
    ('066.201.093.000', 'US'),
    ('066.201.096.000', '--'),
    ('066.201.128.000', 'US'),
    ('066.201.160.000', '--'),
    ('066.201.192.000', 'CA'),
    ('066.201.224.000', '--'),
    ('066.202.000.000', 'US'),
    ('066.203.144.000', '--'),
    ('066.203.160.000', 'CA'),
    ('066.203.176.000', '--'),
    ('066.203.192.000', 'CA'),
    ('066.203.208.000', '--'),
    ('066.203.224.000', 'US'),
    ('066.203.240.000', '--'),
    ('066.204.000.000', 'US'),
    ('066.205.008.000', 'BB'),
    ('066.205.016.000', 'US'),
    ('066.205.017.000', 'BB'),
    ('066.205.018.000', 'US'),
    ('066.205.024.000', 'JM'),
    ('066.205.028.000', 'US'),
    ('066.205.032.000', '--'),
    ('066.205.064.000', 'US'),
    ('066.205.096.000', '--'),
    ('066.205.128.000', 'US'),
    ('066.206.208.000', '--'),
    ('066.206.224.000', 'CA'),
    ('066.206.240.000', '--'),
    ('066.207.000.000', 'US'),
    ('066.207.080.000', '--'),
    ('066.207.096.000', 'CA'),
    ('066.207.128.000', 'US'),
    ('066.207.192.000', 'CA'),
    ('066.207.208.000', '--'),
    ('066.207.224.000', 'US'),
    ('066.212.208.000', '--'),
    ('066.212.224.000', 'CA'),
    ('066.212.240.000', '--'),
    ('066.213.000.000', 'US'),
    ('066.215.000.000', '--'),
    ('066.216.000.000', 'US'),
    ('066.216.016.000', '--'),
    ('066.216.064.000', 'US'),
    ('066.216.096.000', '--'),
    ('066.216.128.000', 'US'),
    ('066.217.128.000', '--'),
    ('066.218.000.000', 'US'),
    ('066.222.064.000', '--'),
    ('066.222.128.000', 'CA'),
    ('066.222.160.000', '--'),
    ('066.223.000.000', 'US'),
    ('066.223.128.000', '--'),
    ('066.224.000.000', 'US'),
    ('066.225.000.000', '--'),
    ('066.226.000.000', 'US'),
    ('066.227.032.000', '--'),
    ('066.227.128.000', 'US'),
    ('066.227.192.000', '--'),
    ('066.228.000.000', 'US'),
    ('066.229.064.000', '--'),
    ('066.230.000.000', 'US'),
    ('066.231.144.000', '--'),
    ('066.231.160.000', 'PR'),
    ('066.231.176.000', '--'),
    ('066.231.192.000', 'US'),
    ('066.241.128.000', 'CA'),
    ('066.241.144.000', '--'),
    ('066.241.192.000', 'US'),
    ('066.241.208.000', '--'),
    ('066.242.000.000', 'US'),
    ('066.248.000.000', '--'),
    ('067.000.000.000', 'US'),
    ('067.128.000.000', '--'),
    ('067.160.000.000', 'US'),
    ('067.176.000.000', '--'),
    ('067.192.000.000', 'US'),
    ('080.000.000.000', 'GB'),
    ('080.008.000.000', 'FR'),
    ('080.015.240.000', 'LB'),
    ('080.015.241.000', 'FR'),
    ('080.016.000.000', 'IT'),
    ('080.024.000.000', 'ES'),
    ('080.040.000.000', 'GB'),
    ('080.048.000.000', 'PL'),
    ('080.056.000.000', 'NL'),
    ('080.058.000.000', 'ES'),
    ('080.060.000.000', 'NL'),
    ('080.062.000.000', 'DK'),
    ('080.064.000.000', 'FI'),
    ('080.064.016.000', 'EU'),
    ('080.064.032.000', 'ES'),
    ('080.064.048.000', 'EU'),
    ('080.064.064.000', 'HU'),
    ('080.064.080.000', 'EU'),
    ('080.064.096.000', 'RU'),
    ('080.064.112.000', 'EU'),
    ('080.064.128.000', 'AT'),
    ('080.064.144.000', 'EU'),
    ('080.064.160.000', 'GB'),
    ('080.064.176.000', 'EU'),
    ('080.064.192.000', 'NO'),
    ('080.064.208.000', 'EU'),
    ('080.064.224.000', 'FR'),
    ('080.064.240.000', 'EU'),
    ('080.065.000.000', 'NL'),
    ('080.065.016.000', 'EU'),
    ('080.065.032.000', 'DE'),
    ('080.065.048.000', 'EU'),
    ('080.065.064.000', 'BA'),
    ('080.065.080.000', 'EU'),
    ('080.065.096.000', 'NL'),
    ('080.065.128.000', 'BE'),
    ('080.065.144.000', 'EU'),
    ('080.065.160.000', 'BA'),
    ('080.065.176.000', 'EU'),
    ('080.065.192.000', 'SE'),
    ('080.065.208.000', 'EU'),
    ('080.065.224.000', 'FR'),
    ('080.065.240.000', 'EU'),
    ('080.066.000.000', 'DE'),
    ('080.066.016.000', 'EU'),
    ('080.066.032.000', 'AT'),
    ('080.066.048.000', 'EU'),
    ('080.066.064.000', 'RU'),
    ('080.066.080.000', 'EU'),
    ('080.066.096.000', 'DE'),
    ('080.066.112.000', 'EU'),
    ('080.066.128.000', 'BE'),
    ('080.066.144.000', 'EU'),
    ('080.066.160.000', 'FI'),
    ('080.066.176.000', 'EU'),
    ('080.066.192.000', 'DE'),
    ('080.066.208.000', 'EU'),
    ('080.066.224.000', 'LI'),
    ('080.066.240.000', 'EU'),
    ('080.067.000.000', 'DE'),
    ('080.067.016.000', 'EU'),
    ('080.067.032.000', 'DK'),
    ('080.067.048.000', 'EU'),
    ('080.067.096.000', 'ES'),
    ('080.067.112.000', 'EU'),
    ('080.067.128.000', 'DZ'),
    ('080.067.144.000', 'EU'),
    ('080.067.160.000', 'FR'),
    ('080.067.192.000', 'SE'),
    ('080.067.208.000', 'EU'),
    ('080.067.224.000', 'DE'),
    ('080.067.240.000', 'EU'),
    ('080.068.000.000', 'RU'),
    ('080.068.016.000', 'EU'),
    ('080.068.032.000', 'GB'),
    ('080.068.048.000', 'EU'),
    ('080.068.064.000', 'IT'),
    ('080.068.080.000', 'EU'),
    ('080.068.096.000', 'SE'),
    ('080.068.112.000', 'EU'),
    ('080.068.128.000', 'ES'),
    ('080.068.144.000', 'EU'),
    ('080.068.160.000', 'DE'),
    ('080.068.176.000', 'EU'),
    ('080.068.192.000', 'IT'),
    ('080.068.208.000', 'EU'),
    ('080.068.224.000', 'PL'),
    ('080.068.240.000', 'RU'),
    ('080.069.000.000', 'GB'),
    ('080.069.016.000', 'EU'),
    ('080.069.032.000', 'DE'),
    ('080.069.048.000', 'EU'),
    ('080.069.064.000', 'NL'),
    ('080.069.080.000', 'EU'),
    ('080.069.096.000', 'DE'),
    ('080.069.112.000', 'EU'),
    ('080.069.128.000', 'JO'),
    ('080.069.144.000', 'EU'),
    ('080.069.160.000', 'NL'),
    ('080.069.176.000', 'EU'),
    ('080.069.192.000', 'DE'),
    ('080.069.208.000', 'EU'),
    ('080.069.224.000', 'SE'),
    ('080.069.228.000', 'NO'),
    ('080.069.230.000', 'DK'),
    ('080.069.232.000', 'SE'),
    ('080.069.240.000', 'EU'),
    ('080.070.000.000', 'NL'),
    ('080.070.016.000', 'EU'),
    ('080.070.032.000', 'FR'),
    ('080.070.048.000', 'EU'),
    ('080.070.064.000', 'UA'),
    ('080.070.080.000', 'EU'),
    ('080.070.096.000', 'GB'),
    ('080.070.112.000', 'EU'),
    ('080.070.128.000', 'IL'),
    ('080.070.144.000', 'EU'),
    ('080.070.160.000', 'DE'),
    ('080.070.176.000', 'EU'),
    ('080.070.192.000', 'FR'),
    ('080.070.208.000', 'EU'),
    ('080.070.224.000', 'RU'),
    ('080.070.240.000', 'EU'),
    ('080.071.000.000', 'GB'),
    ('080.071.016.000', 'EU'),
    ('080.071.032.000', 'RU'),
    ('080.071.048.000', 'EU'),
    ('080.071.064.000', 'NL'),
    ('080.071.080.000', 'EU'),
    ('080.071.096.000', 'MT'),
    ('080.071.112.000', 'EU'),
    ('080.071.128.000', 'TR'),
    ('080.071.144.000', 'EU'),
    ('080.071.160.000', 'RU'),
    ('080.071.176.000', 'EU'),
    ('080.071.192.000', 'FI'),
    ('080.071.208.000', 'EU'),
    ('080.071.224.000', 'IT'),
    ('080.071.240.000', 'EU'),
    ('080.072.000.000', 'SE'),
    ('080.072.016.000', 'EU'),
    ('080.072.032.000', 'PL'),
    ('080.072.048.000', 'EU'),
    ('080.072.064.000', 'BG'),
    ('080.072.080.000', 'EU'),
    ('080.072.096.000', 'IT'),
    ('080.072.112.000', 'EU'),
    ('080.072.128.000', 'DE'),
    ('080.072.144.000', 'EU'),
    ('080.072.160.000', 'IT'),
    ('080.072.176.000', 'EU'),
    ('080.072.192.000', 'PL'),
    ('080.072.208.000', 'EU'),
    ('080.072.224.000', 'RU'),
    ('080.072.240.000', 'EU'),
    ('080.073.000.000', 'UA'),
    ('080.073.016.000', 'EU'),
    ('080.073.032.000', 'DE'),
    ('080.073.048.000', 'EU'),
    ('080.073.064.000', 'RU'),
    ('080.073.080.000', 'EU'),
    ('080.073.096.000', 'DE'),
    ('080.073.112.000', 'EU'),
    ('080.073.128.000', 'NL'),
    ('080.073.144.000', 'EU'),
    ('080.073.160.000', 'RU'),
    ('080.073.176.000', 'EU'),
    ('080.073.192.000', 'RU'),
    ('080.073.208.000', 'EU'),
    ('080.073.224.000', 'IT'),
    ('080.073.240.000', 'EU'),
    ('080.074.000.000', 'GB'),
    ('080.074.016.000', 'EU'),
    ('080.074.032.000', 'CZ'),
    ('080.074.048.000', 'EU'),
    ('080.074.064.000', 'FR'),
    ('080.074.080.000', 'EU'),
    ('080.074.096.000', 'LU'),
    ('080.074.112.000', 'EU'),
    ('080.074.128.000', 'CH'),
    ('080.074.144.000', 'EU'),
    ('080.074.160.000', 'GB'),
    ('080.074.176.000', 'EU'),
    ('080.074.192.000', 'FI'),
    ('080.074.224.000', 'GB'),
    ('080.074.240.000', 'EU'),
    ('080.075.000.000', 'IR'),
    ('080.075.016.000', 'EU'),
    ('080.075.032.000', 'AT'),
    ('080.075.048.000', 'EU'),
    ('080.075.064.000', 'GB'),
    ('080.075.080.000', 'EU'),
    ('080.075.096.000', 'FI'),
    ('080.075.112.000', 'EU'),
    ('080.075.128.000', 'RU'),
    ('080.075.144.000', 'EU'),
    ('080.075.160.000', 'EG'),
    ('080.075.192.000', 'CH'),
    ('080.075.208.000', 'EU'),
    ('080.075.224.000', 'HU'),
    ('080.075.240.000', 'EU'),
    ('080.076.000.000', 'CH'),
    ('080.076.016.000', 'EU'),
    ('080.076.032.000', 'GR'),
    ('080.076.048.000', 'EU'),
    ('080.076.064.000', 'IT'),
    ('080.076.080.000', 'EU'),
    ('080.076.096.000', 'IT'),
    ('080.076.112.000', 'EU'),
    ('080.076.128.000', 'FR'),
    ('080.076.144.000', 'EU'),
    ('080.076.160.000', 'BA'),
    ('080.076.176.000', 'EU'),
    ('080.076.192.000', 'GB'),
    ('080.076.208.000', 'EU'),
    ('080.076.224.000', 'DE'),
    ('080.076.240.000', 'EU'),
    ('080.077.000.000', 'ES'),
    ('080.077.001.000', 'EG'),
    ('080.077.016.000', 'EU'),
    ('080.077.032.000', 'UA'),
    ('080.077.048.000', 'EU'),
    ('080.077.064.000', 'DK'),
    ('080.077.080.000', 'EU'),
    ('080.077.096.000', 'SE'),
    ('080.077.112.000', 'EU'),
    ('080.077.128.000', 'FO'),
    ('080.077.144.000', 'EU'),
    ('080.077.160.000', 'JO'),
    ('080.077.176.000', 'EU'),
    ('080.077.192.000', 'MT'),
    ('080.077.208.000', 'EU'),
    ('080.077.224.000', 'FR'),
    ('080.077.240.000', 'EU'),
    ('080.078.000.000', 'FR'),
    ('080.078.016.000', 'EU'),
    ('080.078.032.000', 'UA'),
    ('080.078.048.000', 'EU'),
    ('080.078.064.000', 'AL'),
    ('080.078.080.000', 'EU'),
    ('080.078.096.000', 'RU'),
    ('080.078.112.000', 'EU'),
    ('080.078.128.000', 'KW'),
    ('080.078.130.000', 'DZ'),
    ('080.078.134.000', 'IR'),
    ('080.078.136.000', 'KW'),
    ('080.078.144.000', 'EU'),
    ('080.078.160.000', 'DE'),
    ('080.078.176.000', 'EU'),
    ('080.078.192.000', 'RU'),
    ('080.078.208.000', 'EU'),
    ('080.078.224.000', 'AT'),
    ('080.079.000.000', 'PT'),
    ('080.079.016.000', 'EU'),
    ('080.079.032.000', 'NL'),
    ('080.079.048.000', 'EU'),
    ('080.079.064.000', 'RU'),
    ('080.079.080.000', 'EU'),
    ('080.079.096.000', 'NL'),
    ('080.079.112.000', 'EU'),
    ('080.079.128.000', 'GB'),
    ('080.079.144.000', 'EU'),
    ('080.079.160.000', 'SE'),
    ('080.079.176.000', 'EU'),
    ('080.079.192.000', 'NL'),
    ('080.079.208.000', 'EU'),
    ('080.079.224.000', 'DE'),
    ('080.079.240.000', 'EU'),
    ('080.080.000.000', 'SE'),
    ('080.080.001.000', 'DK'),
    ('080.080.002.000', 'SE'),
    ('080.080.003.000', 'DK'),
    ('080.080.008.000', 'SE'),
    ('080.080.009.000', 'DK'),
    ('080.080.016.000', 'EU'),
    ('080.080.032.000', 'IT'),
    ('080.080.048.000', 'EU'),
    ('080.080.064.000', 'SE'),
    ('080.080.080.000', 'EU'),
    ('080.080.096.000', 'RU'),
    ('080.080.128.000', 'BG'),
    ('080.080.144.000', 'EU'),
    ('080.080.160.000', 'YU'),
    ('080.080.176.000', 'EU'),
    ('080.080.192.000', 'GB'),
    ('080.080.208.000', 'EU'),
    ('080.080.224.000', 'CH'),
    ('080.080.240.000', 'EU'),
    ('080.081.000.000', 'DE'),
    ('080.081.016.000', 'EU'),
    ('080.081.032.000', 'LV'),
    ('080.081.048.000', 'EU'),
    ('080.081.064.000', 'ES'),
    ('080.081.068.000', 'GB'),
    ('080.081.069.000', 'ES'),
    ('080.081.080.000', 'EU'),
    ('080.081.096.000', 'ES'),
    ('080.081.128.000', 'AT'),
    ('080.081.144.000', 'EU'),
    ('080.081.160.000', 'FI'),
    ('080.081.164.000', 'SE'),
    ('080.081.165.000', 'FI'),
    ('080.081.169.000', 'SE'),
    ('080.081.170.000', 'FI'),
    ('080.081.176.000', 'EU'),
    ('080.081.192.000', 'DE'),
    ('080.081.208.000', 'EU'),
    ('080.081.224.000', 'SK'),
    ('080.081.240.000', 'EU'),
    ('080.082.000.000', 'IT'),
    ('080.082.016.000', 'EU'),
    ('080.082.032.000', 'RU'),
    ('080.082.048.000', 'EU'),
    ('080.082.064.000', 'IT'),
    ('080.082.080.000', 'EU'),
    ('080.082.096.000', 'DK'),
    ('080.082.112.000', 'EU'),
    ('080.082.128.000', 'GB'),
    ('080.082.144.000', 'EU'),
    ('080.082.160.000', 'RU'),
    ('080.082.192.000', 'IT'),
    ('080.082.208.000', 'EU'),
    ('080.082.224.000', 'IR'),
    ('080.082.240.000', 'EU'),
    ('080.083.000.000', 'FI'),
    ('080.083.016.000', 'EU'),
    ('080.083.032.000', 'CH'),
    ('080.083.048.000', 'EU'),
    ('080.083.064.000', 'CZ'),
    ('080.083.080.000', 'EU'),
    ('080.083.096.000', 'DE'),
    ('080.083.112.000', 'EU'),
    ('080.083.128.000', 'GE'),
    ('080.083.144.000', 'EU'),
    ('080.083.160.000', 'IT'),
    ('080.083.176.000', 'EU'),
    ('080.083.192.000', 'IT'),
    ('080.083.208.000', 'EU'),
    ('080.083.224.000', 'RU'),
    ('080.083.240.000', 'EU'),
    ('080.084.000.000', 'DE'),
    ('080.084.016.000', 'EU'),
    ('080.084.032.000', 'SE'),
    ('080.084.048.000', 'EU'),
    ('080.084.064.000', 'GB'),
    ('080.084.080.000', 'EU'),
    ('080.084.096.000', 'IT'),
    ('080.084.112.000', 'EU'),
    ('080.084.128.000', 'ES'),
    ('080.084.130.000', 'KW'),
    ('080.084.132.000', 'ES'),
    ('080.084.134.000', 'IR'),
    ('080.084.135.000', 'ES'),
    ('080.084.144.000', 'EU'),
    ('080.084.160.000', 'GB'),
    ('080.084.176.000', 'EU'),
    ('080.084.192.000', 'DE'),
    ('080.084.224.000', 'NL'),
    ('080.085.000.000', 'DE'),
    ('080.085.016.000', 'EU'),
    ('080.085.032.000', 'NL'),
    ('080.085.048.000', 'EU'),
    ('080.085.064.000', 'GB'),
    ('080.085.080.000', 'EU'),
    ('080.085.096.000', 'MT'),
    ('080.085.112.000', 'EU'),
    ('080.085.128.000', 'NL'),
    ('080.085.144.000', 'EU'),
    ('080.085.160.000', 'NL'),
    ('080.085.176.000', 'EU'),
    ('080.085.192.000', 'DE'),
    ('080.085.208.000', 'EU'),
    ('080.085.224.000', 'PL'),
    ('080.085.240.000', 'EU'),
    ('080.086.000.000', 'DE'),
    ('080.086.016.000', 'EU'),
    ('080.086.032.000', 'GB'),
    ('080.086.048.000', 'EU'),
    ('080.086.064.000', 'SE'),
    ('080.086.080.000', 'EU'),
    ('080.086.096.000', 'RO'),
    ('080.086.112.000', 'EU'),
    ('080.086.128.000', 'NO'),
    ('080.086.144.000', 'EU'),
    ('080.086.160.000', 'DE'),
    ('080.086.176.000', 'EU'),
    ('080.086.192.000', 'CH'),
    ('080.086.208.000', 'EU'),
    ('080.086.224.000', 'AM'),
    ('080.086.240.000', 'EU'),
    ('080.087.000.000', 'GB'),
    ('080.087.016.000', 'EU'),
    ('080.087.032.000', 'RU'),
    ('080.087.048.000', 'EU'),
    ('080.087.064.000', 'GH'),
    ('080.087.080.000', 'EU'),
    ('080.087.096.000', 'FR'),
    ('080.087.112.000', 'EU'),
    ('080.087.128.000', 'GB'),
    ('080.087.144.000', 'EU'),
    ('080.087.160.000', 'DE'),
    ('080.087.176.000', 'EU'),
    ('080.087.192.000', 'RU'),
    ('080.087.208.000', 'EU'),
    ('080.087.224.000', 'FR'),
    ('080.087.240.000', 'EU'),
    ('080.088.000.000', 'DZ'),
    ('080.088.016.000', 'EU'),
    ('080.088.032.000', 'BE'),
    ('080.088.048.000', 'EU'),
    ('080.088.064.000', 'CH'),
    ('080.088.080.000', 'EU'),
    ('080.088.096.000', 'SE'),
    ('080.088.128.000', 'DK'),
    ('080.088.129.000', 'NG'),
    ('080.088.131.000', 'SA'),
    ('080.088.132.000', 'NG'),
    ('080.088.138.000', 'GH'),
    ('080.088.139.000', 'DK'),
    ('080.088.144.000', 'EU'),
    ('080.088.160.000', 'IT'),
    ('080.088.176.000', 'EU'),
    ('080.088.192.000', 'GB'),
    ('080.088.208.000', 'EU'),
    ('080.088.224.000', 'ES'),
    ('080.088.240.000', 'EU'),
    ('080.089.000.000', 'RU'),
    ('080.089.016.000', 'EU'),
    ('080.089.032.000', 'NO'),
    ('080.089.048.000', 'EU'),
    ('080.089.064.000', 'DE'),
    ('080.089.080.000', 'EU'),
    ('080.089.096.000', 'AT'),
    ('080.089.112.000', 'EU'),
    ('080.089.128.000', 'RU'),
    ('080.089.160.000', 'SE'),
    ('080.089.176.000', 'EU'),
    ('080.089.192.000', 'JO'),
    ('080.089.208.000', 'EU'),
    ('080.089.224.000', 'NL'),
    ('080.089.240.000', 'EU'),
    ('080.090.000.000', 'LV'),
    ('080.090.016.000', 'EU'),
    ('080.090.032.000', 'LU'),
    ('080.090.048.000', 'EU'),
    ('080.090.064.000', 'RU'),
    ('080.090.080.000', 'EU'),
    ('080.090.096.000', 'DE'),
    ('080.090.112.000', 'EU'),
    ('080.090.128.000', 'GB'),
    ('080.090.144.000', 'EU'),
    ('080.090.160.000', 'JO'),
    ('080.090.176.000', 'EU'),
    ('080.090.192.000', 'PT'),
    ('080.090.224.000', 'UA'),
    ('080.090.240.000', 'EU'),
    ('080.091.000.000', 'DK'),
    ('080.091.016.000', 'EU'),
    ('080.091.032.000', 'NO'),
    ('080.091.048.000', 'EU'),
    ('080.091.064.000', 'ES'),
    ('080.091.080.000', 'EU'),
    ('080.091.096.000', 'DE'),
    ('080.091.112.000', 'EU'),
    ('080.091.128.000', 'FI'),
    ('080.091.131.000', 'DK'),
    ('080.091.144.000', 'EU'),
    ('080.091.160.000', 'UA'),
    ('080.091.176.000', 'EU'),
    ('080.091.192.000', 'RU'),
    ('080.091.208.000', 'EU'),
    ('080.091.224.000', 'NO'),
    ('080.091.240.000', 'EU'),
    ('080.092.000.000', 'RU'),
    ('080.092.016.000', 'EU'),
    ('080.092.032.000', 'RU'),
    ('080.092.048.000', 'EU'),
    ('080.092.064.000', 'LU'),
    ('080.092.080.000', 'EU'),
    ('080.092.096.000', 'FR'),
    ('080.092.112.000', 'EU'),
    ('080.092.128.000', 'IE'),
    ('080.092.132.000', 'GB'),
    ('080.092.144.000', 'EU'),
    ('080.092.160.000', 'RU'),
    ('080.092.176.000', 'EU'),
    ('080.092.192.000', 'RU'),
    ('080.092.208.000', 'EU'),
    ('080.092.224.000', 'UA'),
    ('080.092.240.000', 'EU'),
    ('080.093.000.000', 'IE'),
    ('080.093.016.000', 'EU'),
    ('080.093.032.000', 'FR'),
    ('080.093.048.000', 'EU'),
    ('080.093.064.000', 'IT'),
    ('080.093.080.000', 'EU'),
    ('080.093.096.000', 'RU'),
    ('080.093.112.000', 'EU'),
    ('080.093.128.000', 'IT'),
    ('080.093.144.000', 'EU'),
    ('080.093.160.000', 'GB'),
    ('080.093.176.000', 'EU'),
    ('080.093.192.000', 'GB'),
    ('080.093.208.000', 'EU'),
    ('080.093.224.000', 'YU'),
    ('080.093.240.000', 'EU'),
    ('080.094.000.000', 'ES'),
    ('080.094.016.000', 'EU'),
    ('080.094.032.000', 'GB'),
    ('080.094.048.000', 'EU'),
    ('080.094.064.000', 'RU'),
    ('080.094.080.000', 'EU'),
    ('080.094.096.000', 'MC'),
    ('080.094.112.000', 'EU'),
    ('080.094.128.000', 'SE'),
    ('080.094.144.000', 'EU'),
    ('080.094.160.000', 'BY'),
    ('080.094.176.000', 'EU'),
    ('080.094.192.000', 'GB'),
    ('080.094.208.000', 'EU'),
    ('080.094.224.000', 'BY'),
    ('080.094.240.000', 'EU'),
    ('080.095.000.000', 'EG'),
    ('080.095.016.000', 'EU'),
    ('080.095.032.000', 'RU'),
    ('080.095.048.000', 'EU'),
    ('080.095.064.000', 'HU'),
    ('080.095.080.000', 'EU'),
    ('080.095.096.000', 'CZ'),
    ('080.095.112.000', 'EU'),
    ('080.095.128.000', 'FI'),
    ('080.095.144.000', 'EU'),
    ('080.095.160.000', 'NL'),
    ('080.095.176.000', 'EU'),
    ('080.095.192.000', 'GB'),
    ('080.095.208.000', 'EU'),
    ('080.095.224.000', 'SI'),
    ('080.095.240.000', 'EU'),
    ('080.096.000.000', 'RO'),
    ('080.098.000.000', 'HU'),
    ('080.100.000.000', 'NL'),
    ('080.102.000.000', 'ES'),
    ('080.104.000.000', 'IT'),
    ('080.106.000.000', 'GR'),
    ('080.108.000.000', 'AT'),
    ('080.112.000.000', 'NL'),
    ('080.116.000.000', 'IT'),
    ('080.118.000.000', 'FR'),
    ('080.120.000.000', 'AT'),
    ('080.124.000.000', 'FR'),
    ('080.126.000.000', 'NL'),
    ('080.128.000.000', 'DE'),
    ('080.160.000.000', 'EU'),
    ('080.192.000.000', 'GB'),
    ('080.196.000.000', 'DK'),
    ('080.198.000.000', 'EU'),
    ('080.200.000.000', 'BE'),
    ('080.202.000.000', 'NO'),
    ('080.204.000.000', 'IT'),
    ('080.208.000.000', 'DK'),
    ('080.212.000.000', 'NO'),
    ('080.214.000.000', 'FR'),
    ('080.216.000.000', 'EU'),
    ('080.224.000.000', 'ES'),
    ('080.225.000.000', 'GB'),
    ('080.226.000.000', 'DE'),
    ('080.227.000.000', 'AE'),
    ('080.228.000.000', 'DE'),
    ('080.228.128.000', 'EU'),
    ('080.229.000.000', 'GB'),
    ('080.229.128.000', 'EU'),
    ('080.232.000.000', 'NO'),
    ('080.232.128.000', 'LV'),
    ('080.233.000.000', 'DK'),
    ('080.233.128.000', 'LV'),
    ('080.234.000.000', 'IT'),
    ('080.234.128.000', 'GB'),
    ('080.235.000.000', 'EE'),
    ('080.235.128.000', 'GB'),
    ('080.236.000.000', 'FR'),
    ('080.236.128.000', 'BE'),
    ('080.237.000.000', 'RU'),
    ('080.237.128.000', 'DE'),
    ('080.238.000.000', 'CH'),
    ('080.239.000.000', 'NO'),
    ('080.239.128.000', 'DE'),
    ('080.239.144.000', 'EU'),
    ('080.239.160.000', 'FR'),
    ('080.239.174.000', 'NL'),
    ('080.239.175.000', 'FR'),
    ('080.239.176.000', 'EU'),
    ('080.239.192.000', 'PL'),
    ('080.239.208.000', 'EU'),
    ('080.240.000.000', 'LT'),
    ('080.240.016.000', 'EU'),
    ('080.240.032.000', 'RU'),
    ('080.240.048.000', 'EU'),
    ('080.240.064.000', 'SA'),
    ('080.240.080.000', 'EU'),
    ('080.240.096.000', 'RU'),
    ('080.240.112.000', 'EU'),
    ('080.240.128.000', 'CH'),
    ('080.240.144.000', 'EU'),
    ('080.240.160.000', 'PL'),
    ('080.240.176.000', 'EU'),
    ('080.240.192.000', 'KE'),
    ('080.240.208.000', 'EU'),
    ('080.240.224.000', 'AT'),
    ('080.240.240.000', 'EU'),
    ('080.241.000.000', 'KZ'),
    ('080.241.016.000', 'EU'),
    ('080.241.032.000', 'KZ'),
    ('080.241.048.000', 'EU'),
    ('080.241.064.000', 'US'),
    ('080.241.067.000', 'NL'),
    ('080.241.080.000', 'EU'),
    ('080.241.096.000', 'CH'),
    ('080.241.112.000', 'EU'),
    ('080.241.128.000', 'PL'),
    ('080.241.144.000', 'EU'),
    ('080.241.160.000', 'IT'),
    ('080.241.176.000', 'EU'),
    ('080.241.192.000', 'DE'),
    ('080.241.208.000', 'EU'),
    ('080.241.224.000', 'IT'),
    ('080.241.240.000', 'EU'),
    ('080.242.000.000', 'IR'),
    ('080.242.016.000', 'EU'),
    ('080.242.032.000', 'NL'),
    ('080.242.048.000', 'EU'),
    ('080.242.064.000', 'RU'),
    ('080.242.080.000', 'EU'),
    ('080.242.096.000', 'NL'),
    ('080.242.112.000', 'EU'),
    ('080.242.128.000', 'DE'),
    ('080.242.144.000', 'EU'),
    ('080.242.160.000', 'DE'),
    ('080.242.176.000', 'EU'),
    ('080.242.192.000', 'CH'),
    ('080.242.208.000', 'EU'),
    ('080.242.224.000', 'NL'),
    ('080.242.240.000', 'EU'),
    ('080.243.000.000', 'RU'),
    ('080.243.016.000', 'EU'),
    ('080.243.032.000', 'DE'),
    ('080.243.048.000', 'EU'),
    ('080.243.064.000', 'RU'),
    ('080.243.080.000', 'EU'),
    ('080.243.096.000', 'RU'),
    ('080.243.112.000', 'EU'),
    ('080.243.128.000', 'DE'),
    ('080.243.144.000', 'EU'),
    ('080.243.160.000', 'AT'),
    ('080.243.176.000', 'EU'),
    ('080.243.192.000', 'DE'),
    ('080.243.208.000', 'EU'),
    ('080.243.224.000', 'ES'),
    ('080.243.240.000', 'EU'),
    ('080.244.000.000', 'GB'),
    ('080.244.016.000', 'EU'),
    ('080.244.032.000', 'RU'),
    ('080.244.048.000', 'EU'),
    ('080.244.064.000', 'SE'),
    ('080.244.080.000', 'EU'),
    ('080.244.096.000', 'HU'),
    ('080.244.112.000', 'EU'),
    ('080.244.128.000', 'PL'),
    ('080.244.144.000', 'EU'),
    ('080.244.160.000', 'IL'),
    ('080.244.176.000', 'EU'),
    ('080.244.192.000', 'SE'),
    ('080.244.208.000', 'EU'),
    ('080.244.224.000', 'RU'),
    ('080.244.240.000', 'EU'),
    ('080.245.000.000', 'ES'),
    ('080.245.016.000', 'EU'),
    ('080.245.032.000', 'FR'),
    ('080.245.048.000', 'EU'),
    ('080.245.064.000', 'DE'),
    ('080.245.080.000', 'EU'),
    ('080.245.096.000', 'GB'),
    ('080.245.112.000', 'EU'),
    ('080.245.128.000', 'DE'),
    ('080.245.144.000', 'EU'),
    ('080.245.160.000', 'GR'),
    ('080.245.176.000', 'EU'),
    ('080.245.192.000', 'AT'),
    ('080.245.208.000', 'EU'),
    ('080.245.224.000', 'DE'),
    ('080.245.240.000', 'EU'),
    ('080.246.000.000', 'DZ'),
    ('080.246.016.000', 'EU'),
    ('080.246.032.000', 'DE'),
    ('080.246.048.000', 'EU'),
    ('080.246.064.000', 'RU'),
    ('080.246.080.000', 'EU'),
    ('080.246.096.000', 'LU'),
    ('080.246.112.000', 'EU'),
    ('080.246.128.000', 'IL'),
    ('080.246.144.000', 'EU'),
    ('080.246.160.000', 'FI'),
    ('080.246.176.000', 'EU'),
    ('080.246.192.000', 'BG'),
    ('080.246.208.000', 'EU'),
    ('080.246.224.000', 'SI'),
    ('080.246.240.000', 'EU'),
    ('080.247.000.000', 'GB'),
    ('080.247.016.000', 'EU'),
    ('080.247.032.000', 'PL'),
    ('080.247.048.000', 'EU'),
    ('080.247.064.000', 'IT'),
    ('080.247.074.000', 'FR'),
    ('080.247.075.000', 'IT'),
    ('080.247.076.000', 'FR'),
    ('080.247.077.000', 'IT'),
    ('080.247.080.000', 'EU'),
    ('080.247.096.000', 'RU'),
    ('080.247.112.000', 'EU'),
    ('080.247.128.000', 'GB'),
    ('080.247.136.000', 'NG'),
    ('080.247.138.000', 'PK'),
    ('080.247.139.000', 'GB'),
    ('080.247.142.000', 'NG'),
    ('080.247.143.000', 'GB'),
    ('080.247.144.000', 'EU'),
    ('080.247.160.000', 'IE'),
    ('080.247.176.000', 'EU'),
    ('080.247.192.000', 'NL'),
    ('080.247.203.000', 'BE'),
    ('080.247.204.000', 'NL'),
    ('080.247.205.000', 'BE'),
    ('080.247.206.000', 'NL'),
    ('080.247.224.000', 'FR'),
    ('080.247.240.000', 'EU'),
    ('080.248.000.000', 'NG'),
    ('080.248.016.000', 'EU'),
    ('080.248.032.000', 'NL'),
    ('080.248.036.000', 'GB'),
    ('080.248.048.000', 'EU'),
    ('080.248.064.000', 'TG'),
    ('080.248.080.000', 'EU'),
    ('080.248.096.000', 'FI'),
    ('080.248.128.000', 'SE'),
    ('080.248.144.000', 'EU'),
    ('080.248.160.000', 'FI'),
    ('080.248.176.000', 'EU'),
    ('080.248.192.000', 'LI'),
    ('080.248.208.000', 'EU'),
    ('080.248.224.000', 'SE'),
    ('080.248.240.000', 'EU'),
    ('080.249.000.000', 'PL'),
    ('080.249.016.000', 'EU'),
    ('080.249.032.000', 'ES'),
    ('080.249.048.000', 'EU'),
    ('080.249.064.000', 'DZ'),
    ('080.249.080.000', 'EU'),
    ('080.249.096.000', 'GB'),
    ('080.249.112.000', 'EU'),
    ('080.249.128.000', 'RU'),
    ('080.249.144.000', 'EU'),
    ('080.249.160.000', 'HU'),
    ('080.249.176.000', 'EU'),
    ('080.249.192.000', 'LV'),
    ('080.249.208.000', 'EU'),
    ('080.249.224.000', 'UA'),
    ('080.249.240.000', 'EU'),
    ('080.250.000.000', 'CZ'),
    ('080.250.016.000', 'EU'),
    ('080.250.032.000', 'NG'),
    ('080.250.048.000', 'EU'),
    ('080.250.064.000', 'RU'),
    ('080.250.080.000', 'EU'),
    ('080.250.096.000', 'GB'),
    ('080.250.112.000', 'EU'),
    ('080.250.128.000', 'DE'),
    ('080.250.144.000', 'EU'),
    ('080.250.160.000', 'RU'),
    ('080.250.176.000', 'EU'),
    ('080.250.192.000', 'RU'),
    ('080.250.208.000', 'EU'),
    ('080.250.224.000', 'RU'),
    ('080.250.240.000', 'EU'),
    ('080.251.000.000', 'TR'),
    ('080.251.016.000', 'EU'),
    ('080.251.032.000', 'TR'),
    ('080.251.048.000', 'EU'),
    ('080.251.064.000', 'ES'),
    ('080.251.080.000', 'EU'),
    ('080.251.096.000', 'NO'),
    ('080.251.112.000', 'EU'),
    ('080.251.128.000', 'RU'),
    ('080.251.144.000', 'EU'),
    ('080.251.160.000', 'PT'),
    ('080.251.176.000', 'EU'),
    ('080.251.192.000', 'SE'),
    ('080.251.208.000', 'EU'),
    ('080.251.224.000', 'SA'),
    ('080.251.240.000', 'EU'),
    ('080.252.000.000', 'PL'),
    ('080.252.016.000', 'EU'),
    ('080.252.032.000', 'AT'),
    ('080.252.048.000', 'EU'),
    ('080.252.064.000', 'GB'),
    ('080.252.080.000', 'EU'),
    ('080.252.096.000', 'DE'),
    ('080.252.112.000', 'EU'),
    ('080.252.128.000', 'RU'),
    ('080.252.144.000', 'EU'),
    ('080.252.160.000', 'SE'),
    ('080.252.176.000', 'EU'),
    ('080.252.192.000', 'IT'),
    ('080.252.208.000', 'EU'),
    ('080.252.224.000', 'IT'),
    ('080.252.240.000', 'EU'),
    ('080.253.000.000', 'RU'),
    ('080.253.016.000', 'EU'),
    ('080.253.032.000', 'IT'),
    ('080.253.048.000', 'EU'),
    ('080.253.064.000', 'ES'),
    ('080.253.080.000', 'EU'),
    ('080.253.096.000', 'GB'),
    ('080.253.112.000', 'EU'),
    ('080.253.128.000', 'IR'),
    ('080.253.136.000', 'GB'),
    ('080.253.144.000', 'EU'),
    ('080.253.160.000', 'GB'),
    ('080.253.170.000', 'HR'),
    ('080.253.174.000', 'GB'),
    ('080.253.176.000', 'EU'),
    ('080.253.192.000', 'RU'),
    ('080.253.208.000', 'EU'),
    ('080.253.224.000', 'RU'),
    ('080.253.240.000', 'EU'),
    ('080.254.000.000', 'UA'),
    ('080.254.016.000', 'EU'),
    ('080.254.032.000', 'NO'),
    ('080.254.048.000', 'EU'),
    ('080.254.064.000', 'CH'),
    ('080.254.080.000', 'EU'),
    ('080.254.096.000', 'RU'),
    ('080.254.112.000', 'EU'),
    ('080.254.128.000', 'DE'),
    ('080.254.144.000', 'EU'),
    ('080.254.160.000', 'CH'),
    ('080.254.176.000', 'EU'),
    ('080.254.192.000', 'IT'),
    ('080.254.208.000', 'EU'),
    ('080.254.224.000', 'GB'),
    ('080.254.240.000', 'EU'),
    ('080.255.000.000', 'FR'),
    ('080.255.016.000', 'EU'),
    ('080.255.032.000', 'GB'),
    ('080.255.048.000', 'EU'),
    ('080.255.064.000', 'UA'),
    ('080.255.080.000', 'EU'),
    ('080.255.096.000', 'CH'),
    ('080.255.112.000', 'EU'),
    ('080.255.128.000', 'RU'),
    ('080.255.144.000', 'EU'),
    ('080.255.160.000', 'LU'),
    ('080.255.176.000', 'EU'),
    ('080.255.192.000', 'GB'),
    ('080.255.208.000', 'EU'),
    ('080.255.224.000', 'DE'),
    ('080.255.240.000', 'EU'),
    ('081.000.000.000', 'ES'),
    ('081.000.064.000', 'HU'),
    ('081.000.128.000', 'NO'),
    ('081.000.192.000', 'SK'),
    ('081.000.193.000', 'CZ'),
    ('081.001.000.000', 'FR'),
    ('081.001.064.000', 'GB'),
    ('081.001.128.000', 'SE'),
    ('081.001.192.000', 'RU'),
    ('081.002.000.000', 'EU'),
    ('081.008.000.000', 'TR'),
    ('081.008.128.000', 'SE'),
    ('081.009.000.000', 'RU'),
    ('081.009.128.000', 'EU'),
    ('081.016.000.000', 'RU'),
    ('081.016.016.000', 'EU'),
    ('081.016.032.000', 'AT'),
    ('081.016.048.000', 'EU'),
    ('081.016.064.000', 'FI'),
    ('081.016.080.000', 'EU'),
    ('081.016.096.000', 'AT'),
    ('081.016.112.000', 'EU'),
    ('081.016.128.000', 'RU'),
    ('081.016.144.000', 'EU'),
    ('081.016.160.000', 'SE'),
    ('081.016.176.000', 'EU'),
    ('081.016.192.000', 'HU'),
    ('081.016.208.000', 'EU'),
    ('081.016.224.000', 'LT'),
    ('081.016.240.000', 'EU'),
    ('081.017.000.000', 'RU'),
    ('081.017.016.000', 'EU'),
    ('081.017.032.000', 'NL'),
    ('081.017.048.000', 'EU'),
    ('081.017.064.000', 'GB'),
    ('081.017.080.000', 'EU'),
    ('081.017.096.000', 'DE'),
    ('081.017.112.000', 'EU'),
    ('081.017.128.000', 'UA'),
    ('081.017.144.000', 'EU'),
    ('081.017.160.000', 'US'),
    ('081.017.166.000', 'GB'),
    ('081.017.176.000', 'EU'),
    ('081.017.192.000', 'FI'),
    ('081.017.208.000', 'EU'),
    ('081.017.224.000', 'SI'),
    ('081.017.240.000', 'EU'),
    ('081.018.000.000', 'NL'),
    ('081.018.016.000', 'EU'),
    ('081.018.032.000', 'NG'),
    ('081.018.048.000', 'EU'),
    ('081.018.064.000', 'RO'),
    ('081.018.080.000', 'EU'),
    ('081.018.096.000', 'DE'),
    ('081.018.112.000', 'EU'),
    ('081.018.128.000', 'RU'),
    ('081.018.144.000', 'EU'),
    ('081.018.160.000', 'NL'),
    ('081.018.176.000', 'EU'),
    ('081.018.192.000', 'PL'),
    ('081.018.208.000', 'EU'),
    ('081.018.224.000', 'FO'),
    ('081.018.240.000', 'EU'),
    ('081.019.000.000', 'CZ'),
    ('081.019.016.000', 'EU'),
    ('081.019.032.000', 'ES'),
    ('081.019.048.000', 'EU'),
    ('081.019.064.000', 'RU'),
    ('081.019.080.000', 'EU'),
    ('081.019.096.000', 'ES'),
    ('081.019.112.000', 'EU'),
    ('081.019.128.000', 'RU'),
    ('081.019.144.000', 'EU'),
    ('081.019.160.000', 'ES'),
    ('081.019.176.000', 'EU'),
    ('081.019.192.000', 'GB'),
    ('081.019.208.000', 'EU'),
    ('081.019.224.000', 'DK'),
    ('081.019.240.000', 'EU'),
    ('081.020.000.000', 'GB'),
    ('081.020.016.000', 'EU'),
    ('081.020.032.000', 'GB'),
    ('081.020.048.000', 'EU'),
    ('081.020.064.000', 'NL'),
    ('081.020.080.000', 'EU'),
    ('081.020.096.000', 'RU'),
    ('081.020.112.000', 'EU'),
    ('081.020.128.000', 'FR'),
    ('081.020.144.000', 'EU'),
    ('081.020.160.000', 'RU'),
    ('081.020.176.000', 'EU'),
    ('081.020.192.000', 'RU'),
    ('081.020.208.000', 'EU'),
    ('081.020.224.000', 'FI'),
    ('081.020.240.000', 'EU'),
    ('081.021.000.000', 'UA'),
    ('081.021.016.000', 'EU'),
    ('081.021.032.000', 'CY'),
    ('081.021.048.000', 'EU'),
    ('081.021.064.000', 'GB'),
    ('081.021.080.000', 'EU'),
    ('081.021.096.000', 'EG'),
    ('081.021.112.000', 'EU'),
    ('081.021.128.000', 'IT'),
    ('081.021.144.000', 'EU'),
    ('081.021.160.000', 'TR'),
    ('081.021.176.000', 'EU'),
    ('081.021.192.000', 'PL'),
    ('081.021.208.000', 'EU'),
    ('081.021.224.000', 'RU'),
    ('081.021.240.000', 'EU'),
    ('081.022.000.000', 'RU'),
    ('081.022.016.000', 'EU'),
    ('081.022.032.000', 'GB'),
    ('081.022.033.000', 'DE'),
    ('081.022.034.000', 'FR'),
    ('081.022.035.000', 'GB'),
    ('081.022.048.000', 'EU'),
    ('081.022.064.000', 'DZ'),
    ('081.022.080.000', 'EU'),
    ('081.022.096.000', 'TR'),
    ('081.022.112.000', 'EU'),
    ('081.022.128.000', 'DZ'),
    ('081.022.144.000', 'EU'),
    ('081.022.160.000', 'FI'),
    ('081.022.176.000', 'EU'),
    ('081.022.192.000', 'RU'),
    ('081.022.208.000', 'EU'),
    ('081.022.224.000', 'DE'),
    ('081.022.240.000', 'EU'),
    ('081.023.000.000', 'LT'),
    ('081.023.016.000', 'EU'),
    ('081.023.032.000', 'FR'),
    ('081.023.048.000', 'EU'),
    ('081.023.064.000', 'CH'),
    ('081.023.080.000', 'EU'),
    ('081.023.096.000', 'RU'),
    ('081.023.112.000', 'EU'),
    ('081.032.000.000', 'ES'),
    ('081.048.000.000', 'EU'),
    ('081.064.000.000', 'FR'),
    ('081.068.000.000', 'NL'),
    ('081.072.000.000', 'IT'),
    ('081.076.000.000', 'EU'),
    ('082.000.000.000', 'US'),
    ('127.000.000.000', 'L0'),
    ('128.000.000.000', 'US'),
    ('128.007.000.000', 'DE'),
    ('128.008.000.000', 'US'),
    ('128.016.000.000', 'GB'),
    ('128.017.000.000', 'US'),
    ('128.039.000.000', 'NO'),
    ('128.040.000.000', 'GB'),
    ('128.042.000.000', 'US'),
    ('128.043.000.000', 'CA'),
    ('128.044.000.000', 'US'),
    ('128.068.000.000', '--'),
    ('128.080.000.000', 'US'),
    ('128.086.000.000', 'GB'),
    ('128.088.000.000', 'US'),
    ('128.093.000.000', 'FR'),
    ('128.094.000.000', 'US'),
    ('128.098.000.000', 'GB'),
    ('128.099.000.000', 'US'),
    ('128.100.000.000', 'CA'),
    ('128.101.000.000', 'US'),
    ('128.130.000.000', 'AT'),
    ('128.132.000.000', 'US'),
    ('128.134.000.000', 'KR'),
    ('128.135.000.000', 'US'),
    ('128.139.000.000', 'IL'),
    ('128.140.000.000', '--'),
    ('128.141.000.000', 'CH'),
    ('128.142.000.000', 'BE'),
    ('128.143.000.000', 'US'),
    ('128.144.000.000', 'CA'),
    ('128.145.000.000', 'US'),
    ('128.176.000.000', 'DE'),
    ('128.177.000.000', 'US'),
    ('128.178.000.000', 'CH'),
    ('128.180.000.000', 'US'),
    ('128.184.000.000', 'AU'),
    ('128.185.000.000', 'US'),
    ('128.189.000.000', 'CA'),
    ('128.190.000.000', 'US'),
    ('128.199.000.000', 'GB'),
    ('128.200.000.000', 'US'),
    ('128.201.000.000', 'FR'),
    ('128.202.000.000', 'US'),
    ('128.214.000.000', 'FI'),
    ('128.215.000.000', 'US'),
    ('128.232.000.000', 'GB'),
    ('128.233.000.000', 'CA'),
    ('128.234.000.000', '--'),
    ('128.235.000.000', 'US'),
    ('128.240.000.000', 'GB'),
    ('128.241.000.000', 'US'),
    ('128.243.000.000', 'GB'),
    ('128.244.000.000', 'US'),
    ('128.246.000.000', 'CH'),
    ('128.247.000.000', 'US'),
    ('128.250.000.000', 'AU'),
    ('128.251.000.000', 'US'),
    ('129.011.000.000', 'GB'),
    ('129.013.000.000', 'DE'),
    ('129.014.000.000', 'US'),
    ('129.016.000.000', 'SE'),
    ('129.017.000.000', 'US'),
    ('129.018.000.000', '--'),
    ('129.019.000.000', 'US'),
    ('129.020.000.000', 'FR'),
    ('129.021.000.000', 'US'),
    ('129.026.000.000', 'DE'),
    ('129.027.000.000', 'AT'),
    ('129.028.000.000', 'US'),
    ('129.031.000.000', 'GB'),
    ('129.032.000.000', 'US'),
    ('129.035.000.000', 'FR'),
    ('129.035.255.000', '--'),
    ('129.036.000.000', 'US'),
    ('129.060.000.000', 'JP'),
    ('129.061.000.000', 'US'),
    ('129.067.000.000', 'GB'),
    ('129.068.000.000', 'US'),
    ('129.069.000.000', 'DE'),
    ('129.071.000.000', 'US'),
    ('129.078.000.000', 'AU'),
    ('129.079.000.000', 'US'),
    ('129.088.000.000', 'FR'),
    ('129.089.000.000', 'US'),
    ('129.090.000.000', 'VE'),
    ('129.091.000.000', 'US'),
    ('129.094.000.000', 'AU'),
    ('129.095.000.000', 'US'),
    ('129.096.000.000', 'AU'),
    ('129.097.000.000', 'CA'),
    ('129.098.000.000', 'US'),
    ('129.100.000.000', 'CA'),
    ('129.101.000.000', 'US'),
    ('129.102.000.000', 'FR'),
    ('129.103.000.000', 'DE'),
    ('129.104.000.000', 'FR'),
    ('129.105.000.000', 'US'),
    ('129.125.000.000', 'NL'),
    ('129.126.000.000', 'US'),
    ('129.127.000.000', 'AU'),
    ('129.128.000.000', 'CA'),
    ('129.129.000.000', 'CH'),
    ('129.130.000.000', 'US'),
    ('129.132.000.000', 'CH'),
    ('129.133.000.000', 'US'),
    ('129.136.000.000', 'JP'),
    ('129.137.000.000', 'US'),
    ('129.140.000.000', '--'),
    ('129.141.000.000', 'US'),
    ('129.142.000.000', 'DK'),
    ('129.143.000.000', 'DE'),
    ('129.144.000.000', 'US'),
    ('129.159.000.000', 'NL'),
    ('129.159.005.000', 'US'),
    ('129.169.000.000', 'GB'),
    ('129.170.000.000', 'US'),
    ('129.173.000.000', 'CA'),
    ('129.174.000.000', 'US'),
    ('129.175.000.000', 'FR'),
    ('129.176.000.000', 'US'),
    ('129.177.000.000', 'NO'),
    ('129.178.000.000', 'SE'),
    ('129.179.000.000', 'US'),
    ('129.180.000.000', 'AU'),
    ('129.181.000.000', 'FR'),
    ('129.186.000.000', 'US'),
    ('129.187.000.000', 'DE'),
    ('129.188.000.000', 'US'),
    ('129.194.000.000', 'CH'),
    ('129.196.000.000', 'US'),
    ('129.199.000.000', 'FR'),
    ('129.200.000.000', 'US'),
    ('129.205.000.000', '--'),
    ('129.206.000.000', 'DE'),
    ('129.207.000.000', 'US'),
    ('129.208.000.000', 'GB'),
    ('129.209.000.000', 'US'),
    ('129.215.000.000', 'GB'),
    ('129.216.000.000', 'US'),
    ('129.217.000.000', 'DE'),
    ('129.218.000.000', 'US'),
    ('129.226.000.000', 'GB'),
    ('129.228.000.000', 'US'),
    ('129.232.000.000', '--'),
    ('129.233.000.000', 'DE'),
    ('129.234.000.000', 'GB'),
    ('129.235.000.000', 'US'),
    ('129.240.000.000', 'NO'),
    ('129.243.000.000', 'US'),
    ('129.247.000.000', 'DE'),
    ('129.248.000.000', 'US'),
    ('129.249.000.000', 'JP'),
    ('129.250.000.000', 'US'),
    ('129.254.000.000', 'KR'),
    ('129.255.000.000', 'US'),
    ('130.000.000.000', '--'),
    ('130.001.000.000', 'FR'),
    ('130.001.001.000', 'US'),
    ('130.012.000.000', 'CA'),
    ('130.013.000.000', 'US'),
    ('130.015.000.000', 'CA'),
    ('130.016.000.000', 'US'),
    ('130.024.000.000', 'GB'),
    ('130.025.000.000', 'US'),
    ('130.032.000.000', 'GB'),
    ('130.033.000.000', 'US'),
    ('130.034.000.000', 'JP'),
    ('130.035.000.000', 'US'),
    ('130.037.000.000', 'NL'),
    ('130.038.000.000', 'US'),
    ('130.054.000.000', 'JP'),
    ('130.055.000.000', 'US'),
    ('130.056.000.000', 'AU'),
    ('130.057.000.000', 'US'),
    ('130.059.000.000', 'CH'),
    ('130.061.000.000', 'US'),
    ('130.063.000.000', 'CA'),
    ('130.064.000.000', 'US'),
    ('130.066.000.000', 'FR'),
    ('130.067.000.000', 'NO'),
    ('130.068.000.000', 'US'),
    ('130.069.000.000', 'JP'),
    ('130.070.000.000', 'US'),
    ('130.073.000.000', 'DE'),
    ('130.074.000.000', 'US'),
    ('130.075.000.000', 'DE'),
    ('130.076.000.000', 'US'),
    ('130.078.000.000', 'NL'),
    ('130.079.000.000', 'FR'),
    ('130.080.000.000', 'US'),
    ('130.082.000.000', 'CH'),
    ('130.083.000.000', 'DE'),
    ('130.084.000.000', 'FR'),
    ('130.085.000.000', 'US'),
    ('130.087.000.000', 'JP'),
    ('130.088.000.000', 'GB'),
    ('130.089.000.000', 'NL'),
    ('130.090.000.000', 'US'),
    ('130.092.000.000', 'CH'),
    ('130.093.000.000', 'US'),
    ('130.095.000.000', 'AU'),
    ('130.096.000.000', 'US'),
    ('130.098.000.000', 'FR'),
    ('130.099.000.000', 'US'),
    ('130.100.000.000', 'SE'),
    ('130.101.000.000', 'US'),
    ('130.102.000.000', 'AU'),
    ('130.103.000.000', 'US'),
    ('130.104.000.000', 'BE'),
    ('130.105.000.000', 'US'),
    ('130.112.000.000', 'NL'),
    ('130.113.000.000', 'CA'),
    ('130.114.000.000', 'US'),
    ('130.115.000.000', 'NL'),
    ('130.116.000.000', 'AU'),
    ('130.117.000.000', 'US'),
    ('130.120.000.000', 'FR'),
    ('130.121.000.000', 'US'),
    ('130.123.000.000', 'NZ'),
    ('130.124.000.000', 'US'),
    ('130.125.000.000', 'CH'),
    ('130.126.000.000', 'US'),
    ('130.130.000.000', 'AU'),
    ('130.131.000.000', 'US'),
    ('130.133.000.000', 'DE'),
    ('130.134.000.000', 'US'),
    ('130.136.000.000', 'IT'),
    ('130.137.000.000', 'US'),
    ('130.138.000.000', 'NL'),
    ('130.148.000.000', 'GB'),
    ('130.149.000.000', 'DE'),
    ('130.150.000.000', 'US'),
    ('130.153.000.000', 'JP'),
    ('130.154.000.000', 'US'),
    ('130.155.000.000', 'AU'),
    ('130.156.000.000', 'US'),
    ('130.158.000.000', 'JP'),
    ('130.159.000.000', 'GB'),
    ('130.160.000.000', 'US'),
    ('130.161.000.000', 'NL'),
    ('130.162.000.000', 'US'),
    ('130.179.000.000', 'CA'),
    ('130.180.000.000', '--'),
    ('130.181.000.000', 'US'),
    ('130.183.000.000', 'DE'),
    ('130.184.000.000', 'US'),
    ('130.185.000.000', 'CA'),
    ('130.186.000.000', 'IT'),
    ('130.187.000.000', 'US'),
    ('130.188.000.000', 'FI'),
    ('130.189.000.000', 'US'),
    ('130.190.000.000', 'FR'),
    ('130.191.000.000', 'US'),
    ('130.192.000.000', 'IT'),
    ('130.193.000.000', '--'),
    ('130.194.000.000', 'AU'),
    ('130.195.000.000', 'NZ'),
    ('130.196.000.000', 'US'),
    ('130.198.000.000', 'CH'),
    ('130.199.000.000', 'US'),
    ('130.206.000.000', 'ES'),
    ('130.207.000.000', 'US'),
    ('130.208.000.000', 'IS'),
    ('130.209.000.000', 'GB'),
    ('130.210.000.000', 'US'),
    ('130.216.000.000', 'NZ'),
    ('130.218.000.000', 'US'),
    ('130.220.000.000', 'AU'),
    ('130.221.000.000', 'US'),
    ('130.223.000.000', 'CH'),
    ('130.224.000.000', 'US'),
    ('130.225.000.000', 'DK'),
    ('130.229.000.000', 'SE'),
    ('130.230.000.000', 'FI'),
    ('130.235.000.000', 'SE'),
    ('130.245.000.000', 'US'),
    ('130.246.000.000', 'GB'),
    ('130.247.000.000', 'US'),
    ('130.251.000.000', 'IT'),
    ('130.252.000.000', 'US'),
    ('131.000.000.000', '--'),
    ('131.001.000.000', 'IT'),
    ('131.002.000.000', 'US'),
    ('131.021.000.000', 'DE'),
    ('131.022.000.000', 'US'),
    ('131.036.000.000', 'JP'),
    ('131.037.000.000', 'US'),
    ('131.047.000.000', 'GU'),
    ('131.048.000.000', 'US'),
    ('131.099.000.000', 'DE'),
    ('131.100.000.000', 'US'),
    ('131.102.000.000', 'CH'),
    ('131.103.000.000', 'US'),
    ('131.104.000.000', 'CA'),
    ('131.105.000.000', 'US'),
    ('131.108.000.000', '--'),
    ('131.109.000.000', 'US'),
    ('131.111.000.000', 'GB'),
    ('131.112.000.000', 'JP'),
    ('131.114.000.000', 'IT'),
    ('131.115.000.000', 'SE'),
    ('131.117.000.000', 'CH'),
    ('131.118.000.000', 'US'),
    ('131.129.000.000', 'CA'),
    ('131.130.000.000', 'AT'),
    ('131.131.000.000', 'US'),
    ('131.132.000.000', 'CA'),
    ('131.142.000.000', 'US'),
    ('131.147.000.000', 'CA'),
    ('131.151.000.000', 'US'),
    ('131.152.000.000', 'CH'),
    ('131.153.000.000', 'US'),
    ('131.154.000.000', 'IT'),
    ('131.155.000.000', 'NL'),
    ('131.156.000.000', 'US'),
    ('131.159.000.000', 'DE'),
    ('131.160.000.000', 'FI'),
    ('131.161.000.000', 'US'),
    ('131.162.000.000', 'CA'),
    ('131.164.000.000', 'DK'),
    ('131.167.000.000', 'US'),
    ('131.169.000.000', 'DE'),
    ('131.170.000.000', 'AU'),
    ('131.171.000.000', 'US'),
    ('131.172.000.000', 'AU'),
    ('131.173.000.000', 'DE'),
    ('131.174.000.000', 'NL'),
    ('131.175.000.000', 'IT'),
    ('131.176.000.000', 'EU'),
    ('131.177.000.000', 'FI'),
    ('131.178.000.000', 'MX'),
    ('131.179.000.000', 'US'),
    ('131.180.000.000', 'NL'),
    ('131.181.000.000', 'AU'),
    ('131.182.000.000', 'US'),
    ('131.185.000.000', 'AU'),
    ('131.186.000.000', 'US'),
    ('131.188.000.000', 'DE'),
    ('131.189.000.000', 'US'),
    ('131.195.000.000', 'CA'),
    ('131.196.000.000', 'FR'),
    ('131.197.000.000', 'US'),
    ('131.202.000.000', 'CA'),
    ('131.203.000.000', 'NZ'),
    ('131.204.000.000', 'US'),
    ('131.205.000.000', 'SE'),
    ('131.206.000.000', 'JP'),
    ('131.207.000.000', 'FI'),
    ('131.208.000.000', 'GB'),
    ('131.209.000.000', 'US'),
    ('131.211.000.000', 'NL'),
    ('131.212.000.000', 'US'),
    ('131.213.000.000', 'CA'),
    ('131.214.000.000', 'US'),
    ('131.217.000.000', 'AU'),
    ('131.218.000.000', 'US'),
    ('131.220.000.000', 'DE'),
    ('131.221.000.000', '--'),
    ('131.222.000.000', 'US'),
    ('131.224.000.000', 'NL'),
    ('131.225.000.000', 'US'),
    ('131.227.000.000', 'GB'),
    ('131.228.000.000', 'FI'),
    ('131.229.000.000', 'US'),
    ('131.231.000.000', 'GB'),
    ('131.232.000.000', 'CA'),
    ('131.233.000.000', 'US'),
    ('131.234.000.000', 'DE'),
    ('131.235.000.000', 'CA'),
    ('131.236.000.000', 'AU'),
    ('131.237.000.000', 'NL'),
    ('131.238.000.000', 'US'),
    ('131.242.000.000', 'AU'),
    ('131.243.000.000', 'US'),
    ('131.244.000.000', 'AU'),
    ('131.246.000.000', 'DE'),
    ('131.247.000.000', 'US'),
    ('131.248.000.000', 'JP'),
    ('131.249.000.000', 'US'),
    ('131.251.000.000', 'GB'),
    ('131.252.000.000', 'US'),
    ('131.254.000.000', 'FR'),
    ('131.255.000.000', '--'),
    ('132.000.000.000', 'US'),
    ('132.011.000.000', 'GR'),
    ('132.012.000.000', 'US'),
    ('132.016.000.000', 'KR'),
    ('132.017.000.000', 'DE'),
    ('132.018.000.000', 'US'),
    ('132.064.000.000', 'IL'),
    ('132.079.000.000', 'US'),
    ('132.146.000.000', 'GB'),
    ('132.147.000.000', 'US'),
    ('132.149.000.000', 'FR'),
    ('132.150.000.000', 'NO'),
    ('132.151.000.000', 'US'),
    ('132.153.000.000', 'GB'),
    ('132.154.000.000', 'US'),
    ('132.155.000.000', 'FI'),
    ('132.156.000.000', 'CA'),
    ('132.157.000.000', '--'),
    ('132.158.000.000', 'US'),
    ('132.165.000.000', 'FR'),
    ('132.170.000.000', 'US'),
    ('132.171.000.000', 'FI'),
    ('132.172.000.000', 'US'),
    ('132.176.000.000', 'DE'),
    ('132.177.000.000', 'US'),
    ('132.179.000.000', 'JP'),
    ('132.180.000.000', 'DE'),
    ('132.181.000.000', 'NZ'),
    ('132.182.000.000', 'JP'),
    ('132.183.000.000', 'US'),
    ('132.184.000.000', '--'),
    ('132.185.000.000', 'GB'),
    ('132.186.000.000', 'AU'),
    ('132.187.000.000', 'DE'),
    ('132.188.000.000', 'US'),
    ('132.195.000.000', 'DE'),
    ('132.196.000.000', 'SE'),
    ('132.197.000.000', 'US'),
    ('132.199.000.000', 'DE'),
    ('132.200.000.000', 'US'),
    ('132.202.000.000', 'CA'),
    ('132.222.000.000', 'JP'),
    ('132.223.000.000', 'US'),
    ('132.225.000.000', 'CA'),
    ('132.226.000.000', 'US'),
    ('132.227.000.000', 'FR'),
    ('132.228.000.000', 'US'),
    ('132.229.000.000', 'NL'),
    ('132.230.000.000', 'DE'),
    ('132.232.000.000', 'GB'),
    ('132.233.000.000', 'US'),
    ('132.234.000.000', 'AU'),
    ('132.235.000.000', 'US'),
    ('132.244.000.000', 'GB'),
    ('132.245.000.000', 'US'),
    ('132.246.000.000', 'CA'),
    ('132.247.000.000', 'MX'),
    ('132.249.000.000', 'US'),
    ('132.251.000.000', 'CA'),
    ('132.252.000.000', 'DE'),
    ('132.253.000.000', 'US'),
    ('132.254.000.000', 'MX'),
    ('132.255.000.000', '--'),
    ('133.000.000.000', 'JP'),
    ('134.000.000.000', 'DE'),
    ('134.004.000.000', 'US'),
    ('134.007.000.000', 'AU'),
    ('134.008.000.000', 'US'),
    ('134.013.000.000', 'FR'),
    ('134.014.000.000', 'US'),
    ('134.018.000.000', 'AU'),
    ('134.019.000.000', '--'),
    ('134.020.000.000', 'US'),
    ('134.021.000.000', 'CH'),
    ('134.022.000.000', 'CA'),
    ('134.023.000.000', 'US'),
    ('134.025.000.000', 'SE'),
    ('134.026.000.000', 'US'),
    ('134.027.000.000', 'NL'),
    ('134.028.000.000', 'DE'),
    ('134.029.000.000', 'US'),
    ('134.030.000.000', 'DE'),
    ('134.031.000.000', 'CA'),
    ('134.032.000.000', 'US'),
    ('134.034.000.000', 'DE'),
    ('134.035.000.000', 'US'),
    ('134.036.000.000', 'GB'),
    ('134.037.000.000', 'FI'),
    ('134.038.000.000', 'CH'),
    ('134.039.000.000', 'US'),
    ('134.046.000.000', 'DE'),
    ('134.047.000.000', 'NO'),
    ('134.048.000.000', 'US'),
    ('134.058.000.000', 'BE'),
    ('134.059.000.000', 'FR'),
    ('134.060.000.000', 'DE'),
    ('134.062.000.000', 'US'),
    ('134.075.000.000', 'KR'),
    ('134.076.000.000', 'DE'),
    ('134.077.000.000', 'US'),
    ('134.081.000.000', 'DE'),
    ('134.082.000.000', 'US'),
    ('134.083.000.000', 'GB'),
    ('134.084.000.000', 'US'),
    ('134.087.000.000', 'CA'),
    ('134.088.000.000', 'US'),
    ('134.090.000.000', '--'),
    ('134.091.000.000', 'DE'),
    ('134.111.000.000', 'US'),
    ('134.115.000.000', 'AU'),
    ('134.116.000.000', 'US'),
    ('134.117.000.000', 'CA'),
    ('134.118.000.000', 'US'),
    ('134.119.000.000', 'NO'),
    ('134.120.000.000', 'US'),
    ('134.130.000.000', 'DE'),
    ('134.131.000.000', 'US'),
    ('134.137.000.000', '--'),
    ('134.138.000.000', 'SE'),
    ('134.139.000.000', 'US'),
    ('134.142.000.000', 'GB'),
    ('134.143.000.000', 'NL'),
    ('134.144.000.000', 'AU'),
    ('134.145.000.000', 'NL'),
    ('134.147.000.000', 'DE'),
    ('134.148.000.000', 'AU'),
    ('134.149.000.000', 'US'),
    ('134.150.000.000', 'CA'),
    ('134.151.000.000', 'GB'),
    ('134.152.000.000', 'US'),
    ('134.153.000.000', 'CA'),
    ('134.154.000.000', 'US'),
    ('134.155.000.000', 'DE'),
    ('134.156.000.000', 'US'),
    ('134.157.000.000', 'FR'),
    ('134.159.000.000', 'AU'),
    ('134.160.000.000', 'JP'),
    ('134.161.000.000', 'US'),
    ('134.169.000.000', 'DE'),
    ('134.170.000.000', 'US'),
    ('134.171.000.000', 'DE'),
    ('134.172.000.000', 'US'),
    ('134.176.000.000', 'DE'),
    ('134.177.000.000', 'US'),
    ('134.178.000.000', 'AU'),
    ('134.179.000.000', 'US'),
    ('134.180.000.000', 'JP'),
    ('134.181.000.000', 'US'),
    ('134.183.000.000', 'GB'),
    ('134.184.000.000', 'BE'),
    ('134.185.000.000', 'US'),
    ('134.188.000.000', 'NL'),
    ('134.189.000.000', 'US'),
    ('134.190.000.000', 'CA'),
    ('134.191.000.000', 'GB'),
    ('134.192.000.000', 'US'),
    ('134.199.000.000', 'CA'),
    ('134.200.000.000', 'US'),
    ('134.202.000.000', 'PR'),
    ('134.203.000.000', 'NL'),
    ('134.204.000.000', 'US'),
    ('134.206.000.000', 'FR'),
    ('134.207.000.000', 'US'),
    ('134.208.000.000', 'TW'),
    ('134.209.000.000', 'US'),
    ('134.211.000.000', 'AU'),
    ('134.212.000.000', 'FR'),
    ('134.213.000.000', 'IE'),
    ('134.214.000.000', 'FR'),
    ('134.215.000.000', 'US'),
    ('134.219.000.000', 'GB'),
    ('134.221.000.000', 'NL'),
    ('134.223.000.000', 'US'),
    ('134.225.000.000', 'GB'),
    ('134.226.000.000', 'IE'),
    ('134.227.000.000', 'FR'),
    ('134.228.000.000', 'US'),
    ('134.237.000.000', 'JP'),
    ('134.238.000.000', 'US'),
    ('134.239.000.000', 'GB'),
    ('134.240.000.000', 'US'),
    ('134.245.000.000', 'DE'),
    ('134.246.000.000', 'FR'),
    ('134.247.000.000', 'DE'),
    ('134.248.000.000', 'US'),
    ('136.145.000.000', 'PR'),
    ('136.146.000.000', 'CA'),
    ('136.148.000.000', 'GB'),
    ('136.149.000.000', 'US'),
    ('136.153.000.000', 'AU'),
    ('136.155.000.000', 'SE'),
    ('136.156.000.000', 'GB'),
    ('136.157.000.000', 'US'),
    ('136.158.000.000', 'NO'),
    ('136.159.000.000', 'CA'),
    ('136.160.000.000', 'US'),
    ('136.163.000.000', 'SE'),
    ('136.164.000.000', 'NO'),
    ('136.165.000.000', 'US'),
    ('136.169.000.000', '--'),
    ('136.170.000.000', 'GB'),
    ('136.171.000.000', 'US'),
    ('136.172.000.000', 'DE'),
    ('136.173.000.000', 'LU'),
    ('136.174.000.000', 'US'),
    ('136.186.000.000', 'AU'),
    ('136.187.000.000', 'JP'),
    ('136.188.000.000', 'US'),
    ('136.198.000.000', 'JP'),
    ('136.199.000.000', 'DE'),
    ('136.200.000.000', 'US'),
    ('136.201.000.000', 'IE'),
    ('136.202.000.000', 'US'),
    ('136.206.000.000', 'IE'),
    ('136.207.000.000', 'US'),
    ('136.211.000.000', 'GB'),
    ('136.212.000.000', 'US'),
    ('136.225.000.000', 'SE'),
    ('136.226.000.000', 'US'),
    ('136.231.000.000', 'NL'),
    ('136.232.000.000', 'CH'),
    ('136.233.000.000', 'US'),
    ('136.236.000.000', 'AU'),
    ('136.237.000.000', 'US'),
    ('136.238.000.000', 'CH'),
    ('136.239.000.000', 'US'),
    ('136.243.000.000', 'DE'),
    ('136.244.000.000', 'US'),
    ('137.015.000.000', 'CA'),
    ('137.016.000.000', 'US'),
    ('137.017.000.000', 'NL'),
    ('137.018.000.000', 'US'),
    ('137.033.000.000', 'FI'),
    ('137.034.000.000', 'US'),
    ('137.043.000.000', 'IE'),
    ('137.044.000.000', 'GB'),
    ('137.045.000.000', 'US'),
    ('137.047.000.000', 'NO'),
    ('137.048.000.000', 'US'),
    ('137.050.000.000', 'GB'),
    ('137.051.000.000', 'US'),
    ('137.055.000.000', 'NL'),
    ('137.057.000.000', 'US'),
    ('137.058.000.000', 'FR'),
    ('137.059.000.000', 'SE'),
    ('137.062.000.000', 'CH'),
    ('137.063.000.000', '--'),
    ('137.064.000.000', 'US'),
    ('137.068.000.000', 'KR'),
    ('137.069.000.000', 'US'),
    ('137.073.000.000', 'GB'),
    ('137.074.000.000', 'CA'),
    ('137.075.000.000', 'US'),
    ('137.076.000.000', 'AU'),
    ('137.077.000.000', 'US'),
    ('137.082.000.000', 'CA'),
    ('137.083.000.000', 'US'),
    ('137.092.000.000', 'AU'),
    ('137.093.000.000', 'NO'),
    ('137.094.000.000', 'CA'),
    ('137.095.000.000', 'US'),
    ('137.096.000.000', 'SE'),
    ('137.097.000.000', 'US'),
    ('137.101.000.000', 'GB'),
    ('137.102.000.000', 'US'),
    ('137.105.000.000', 'GB'),
    ('137.106.000.000', 'US'),
    ('137.108.000.000', 'GB'),
    ('137.109.000.000', 'AU'),
    ('137.110.000.000', 'US'),
    ('137.111.000.000', 'AU'),
    ('137.112.000.000', 'US'),
    ('137.115.000.000', 'CA'),
    ('137.116.000.000', 'US'),
    ('137.117.000.000', 'CA'),
    ('137.118.000.000', 'US'),
    ('137.120.000.000', 'NL'),
    ('137.121.000.000', 'FR'),
    ('137.122.000.000', 'CA'),
    ('137.123.000.000', 'US'),
    ('137.129.000.000', 'FR'),
    ('137.130.000.000', 'US'),
    ('137.132.000.000', 'SG'),
    ('137.133.000.000', 'NO'),
    ('137.134.000.000', 'US'),
    ('137.138.000.000', 'CH'),
    ('137.139.000.000', 'US'),
    ('137.147.000.000', 'AU'),
    ('137.148.000.000', 'US'),
    ('137.149.000.000', 'CA'),
    ('137.150.000.000', 'US'),
    ('137.153.000.000', 'JP'),
    ('137.154.000.000', 'AU'),
    ('137.155.000.000', 'US'),
    ('137.156.000.000', 'CH'),
    ('137.157.000.000', 'AU'),
    ('137.158.000.000', 'ZA'),
    ('137.159.000.000', 'US'),
    ('137.163.000.000', 'FI'),
    ('137.164.000.000', 'US'),
    ('137.166.000.000', 'AU'),
    ('137.167.000.000', 'US'),
    ('137.172.000.000', 'AU'),
    ('137.173.000.000', 'US'),
    ('137.174.000.000', 'NL'),
    ('137.175.000.000', 'US'),
    ('137.186.000.000', 'CA'),
    ('137.187.000.000', 'US'),
    ('137.189.000.000', 'HK'),
    ('137.190.000.000', 'US'),
    ('137.191.000.000', 'IE'),
    ('137.192.000.000', 'US'),
    ('137.193.000.000', 'DE'),
    ('137.194.000.000', 'FR'),
    ('137.195.000.000', 'GB'),
    ('137.196.000.000', 'US'),
    ('137.204.000.000', 'IT'),
    ('137.205.000.000', 'GB'),
    ('137.206.000.000', 'US'),
    ('137.207.000.000', 'CA'),
    ('137.208.000.000', 'AT'),
    ('137.209.000.000', 'US'),
    ('137.213.000.000', 'GB'),
    ('137.214.000.000', 'ZA'),
    ('137.216.000.000', 'US'),
    ('137.217.000.000', 'NO'),
    ('137.218.000.000', 'US'),
    ('137.219.000.000', 'AU'),
    ('137.220.000.000', 'US'),
    ('137.221.000.000', 'GB'),
    ('137.224.000.000', 'NL'),
    ('137.225.000.000', 'US'),
    ('137.226.000.000', 'DE'),
    ('137.227.000.000', 'US'),
    ('137.248.000.000', 'DE'),
    ('137.249.000.000', 'US'),
    ('137.250.000.000', 'DE'),
    ('137.252.000.000', 'US'),
    ('137.253.000.000', 'GB'),
    ('137.254.000.000', 'US'),
    ('137.255.000.000', '--'),
    ('138.001.000.000', 'US'),
    ('138.003.000.000', 'GB'),
    ('138.004.000.000', 'ES'),
    ('138.005.000.000', 'US'),
    ('138.006.000.000', 'SE'),
    ('138.007.000.000', 'AU'),
    ('138.008.000.000', 'US'),
    ('138.010.000.000', 'CA'),
    ('138.012.000.000', 'US'),
    ('138.014.000.000', 'SE'),
    ('138.015.000.000', 'US'),
    ('138.019.000.000', 'AU'),
    ('138.020.000.000', 'US'),
    ('138.021.000.000', 'FR'),
    ('138.022.000.000', 'AT'),
    ('138.023.000.000', 'US'),
    ('138.024.000.000', 'AU'),
    ('138.026.000.000', 'US'),
    ('138.030.000.000', 'JP'),
    ('138.031.000.000', 'US'),
    ('138.036.000.000', '--'),
    ('138.037.000.000', 'GB'),
    ('138.039.000.000', 'US'),
    ('138.040.000.000', 'GB'),
    ('138.041.000.000', 'IT'),
    ('138.042.000.000', 'US'),
    ('138.044.000.000', 'AU'),
    ('138.045.000.000', 'US'),
    ('138.048.000.000', 'BE'),
    ('138.049.000.000', 'US'),
    ('138.051.000.000', 'CA'),
    ('138.052.000.000', 'US'),
    ('138.061.000.000', 'DE'),
    ('138.062.000.000', 'NO'),
    ('138.063.000.000', 'FR'),
    ('138.064.000.000', 'US'),
    ('138.066.000.000', 'IT'),
    ('138.067.000.000', 'US'),
    ('138.070.000.000', 'IT'),
    ('138.071.000.000', 'NZ'),
    ('138.072.000.000', 'US'),
    ('138.073.000.000', 'CA'),
    ('138.074.000.000', 'US'),
    ('138.075.000.000', 'NZ'),
    ('138.076.000.000', 'US'),
    ('138.077.000.000', 'AU'),
    ('138.078.000.000', 'US'),
    ('138.079.000.000', 'AU'),
    ('138.081.000.000', 'CH'),
    ('138.082.000.000', 'CA'),
    ('138.083.000.000', 'US'),
    ('138.096.000.000', 'FR'),
    ('138.097.000.000', '--'),
    ('138.098.000.000', 'US'),
    ('138.099.000.000', '--'),
    ('138.100.000.000', 'ES'),
    ('138.101.000.000', 'JP'),
    ('138.102.000.000', 'FR'),
    ('138.103.000.000', 'SE'),
    ('138.104.000.000', 'GB'),
    ('138.105.000.000', 'US'),
    ('138.106.000.000', 'SE'),
    ('138.107.000.000', 'JP'),
    ('138.108.000.000', 'US'),
    ('138.117.000.000', '--'),
    ('138.119.000.000', 'CA'),
    ('138.121.000.000', 'US'),
    ('138.122.000.000', '--'),
    ('138.123.000.000', 'US'),
    ('138.124.000.000', 'NO'),
    ('138.125.000.000', 'US'),
    ('138.130.000.000', 'AU'),
    ('138.131.000.000', 'CH'),
    ('138.132.000.000', 'IT'),
    ('138.133.000.000', 'US'),
    ('138.134.000.000', 'IL'),
    ('138.135.000.000', 'US'),
    ('138.153.000.000', 'JP'),
    ('138.154.000.000', 'US'),
    ('138.185.000.000', '--'),
    ('138.187.000.000', 'CH'),
    ('138.192.000.000', 'US'),
    ('138.194.000.000', 'AU'),
    ('138.195.000.000', 'FR'),
    ('138.196.000.000', 'US'),
    ('138.198.000.000', 'GB'),
    ('138.199.000.000', 'DE'),
    ('138.202.000.000', 'US'),
    ('138.203.000.000', 'BE'),
    ('138.204.000.000', 'NL'),
    ('138.206.000.000', 'AU'),
    ('138.207.000.000', 'US'),
    ('138.211.000.000', 'NZ'),
    ('138.212.000.000', 'JP'),
    ('138.214.000.000', 'CA'),
    ('138.215.000.000', 'SE'),
    ('138.216.000.000', 'FI'),
    ('138.217.000.000', 'AU'),
    ('138.218.000.000', 'CA'),
    ('138.219.000.000', '--'),
    ('138.220.000.000', 'US'),
    ('138.221.000.000', 'SE'),
    ('138.222.000.000', 'DE'),
    ('138.223.000.000', 'CH'),
    ('138.224.000.000', 'US'),
    ('138.231.000.000', 'FR'),
    ('138.232.000.000', 'AT'),
    ('138.233.000.000', 'SE'),
    ('138.234.000.000', 'US'),
    ('138.235.000.000', 'NZ'),
    ('138.236.000.000', 'US'),
    ('138.243.000.000', 'JP'),
    ('138.244.000.000', 'DE'),
    ('138.247.000.000', 'US'),
    ('138.248.000.000', 'GB'),
    ('138.248.120.000', 'DE'),
    ('138.248.121.000', 'GB'),
    ('138.249.000.000', 'FI'),
    ('138.250.000.000', 'GB'),
    ('138.252.000.000', 'AU'),
    ('138.253.000.000', 'GB'),
    ('138.254.000.000', 'US'),
    ('138.255.000.000', '--'),
    ('139.000.000.000', 'DE'),
    ('139.031.000.000', 'US'),
    ('139.039.000.000', 'GB'),
    ('139.041.000.000', 'US'),
    ('139.043.000.000', 'ES'),
    ('139.044.000.000', 'AU'),
    ('139.045.000.000', 'US'),
    ('139.048.000.000', 'CA'),
    ('139.049.000.000', 'US'),
    ('139.050.000.000', 'DE'),
    ('139.051.000.000', 'US'),
    ('139.053.000.000', 'ZA'),
    ('139.054.000.000', 'FR'),
    ('139.055.000.000', 'US'),
    ('139.057.000.000', 'CA'),
    ('139.058.000.000', 'SE'),
    ('139.059.000.000', 'AU'),
    ('139.060.000.000', 'US'),
    ('139.063.000.000', 'NL'),
    ('139.064.000.000', 'US'),
    ('139.066.000.000', 'FI'),
    ('139.067.000.000', 'US'),
    ('139.074.000.000', 'FI'),
    ('139.075.000.000', 'DE'),
    ('139.076.000.000', 'US'),
    ('139.079.000.000', 'CH'),
    ('139.080.000.000', 'NZ'),
    ('139.081.000.000', 'US'),
    ('139.082.000.000', 'BR'),
    ('139.083.000.000', 'PT'),
    ('139.084.000.000', 'US'),
    ('139.086.000.000', 'AU'),
    ('139.087.000.000', 'US'),
    ('139.089.000.000', 'DE'),
    ('139.090.000.000', 'BE'),
    ('139.091.000.000', 'GR'),
    ('139.092.000.000', 'EU'),
    ('139.092.088.000', 'IL'),
    ('139.092.090.000', 'EU'),
    ('139.092.091.000', 'IL'),
    ('139.092.093.000', 'EU'),
    ('139.092.098.000', 'IL'),
    ('139.092.099.000', 'EU'),
    ('139.092.182.000', 'IL'),
    ('139.092.186.000', 'EU'),
    ('139.092.206.000', 'IL'),
    ('139.092.209.000', 'EU'),
    ('139.092.251.000', 'IL'),
    ('139.092.254.000', 'EU'),
    ('139.093.000.000', 'US'),
    ('139.096.000.000', 'SE'),
    ('139.097.000.000', 'FI'),
    ('139.098.000.000', 'NO'),
    ('139.099.000.000', 'US'),
    ('139.100.000.000', 'FR'),
    ('139.101.000.000', '--'),
    ('139.102.000.000', 'US'),
    ('139.103.000.000', 'CA'),
    ('139.104.000.000', 'US'),
    ('139.105.000.000', 'NO'),
    ('139.121.000.000', 'US'),
    ('139.122.000.000', 'NL'),
    ('139.123.000.000', 'FI'),
    ('139.124.000.000', 'FR'),
    ('139.125.000.000', 'US'),
    ('139.128.000.000', 'IT'),
    ('139.129.000.000', '--'),
    ('139.130.000.000', 'AU'),
    ('139.131.000.000', 'US'),
    ('139.132.000.000', 'AU'),
    ('139.133.000.000', 'GB'),
    ('139.134.000.000', 'AU'),
    ('139.135.000.000', 'US'),
    ('139.141.000.000', 'KW'),
    ('139.142.000.000', 'CA'),
    ('139.143.000.000', 'GB'),
    ('139.144.000.000', 'US'),
    ('139.145.000.000', 'NO'),
    ('139.146.000.000', 'US'),
    ('139.148.000.000', '--'),
    ('139.149.000.000', 'GB'),
    ('139.150.000.000', '--'),
    ('139.151.000.000', 'US'),
    ('139.152.000.000', 'JP'),
    ('139.153.000.000', 'GB'),
    ('139.154.000.000', 'JP'),
    ('139.155.000.000', '--'),
    ('139.157.000.000', 'FI'),
    ('139.158.000.000', 'FR'),
    ('139.159.000.000', '--'),
    ('139.160.000.000', 'FR'),
    ('139.161.000.000', 'US'),
    ('139.162.000.000', 'NL'),
    ('139.163.000.000', 'AU'),
    ('139.164.000.000', 'NO'),
    ('139.165.000.000', 'BE'),
    ('139.166.000.000', 'GB'),
    ('139.167.000.000', 'US'),
    ('139.168.000.000', 'AU'),
    ('139.169.000.000', 'US'),
    ('139.170.000.000', '--'),
    ('139.171.000.000', 'US'),
    ('139.173.000.000', 'CA'),
    ('139.174.000.000', 'DE'),
    ('139.175.000.000', 'TW'),
    ('139.176.000.000', '--'),
    ('139.177.000.000', 'US'),
    ('139.178.000.000', 'NL'),
    ('139.179.000.000', 'TR'),
    ('139.180.000.000', 'US'),
    ('139.184.000.000', 'GB'),
    ('139.185.000.000', 'US'),
    ('139.186.000.000', '--'),
    ('139.187.000.000', 'US'),
    ('139.188.000.000', 'AU'),
    ('139.189.000.000', '--'),
    ('139.191.000.000', 'IT'),
    ('139.192.000.000', '--'),
    ('139.222.000.000', 'GB'),
    ('139.223.000.000', 'TW'),
    ('139.224.000.000', '--'),
    ('139.225.000.000', 'US'),
    ('139.226.000.000', '--'),
    ('139.229.000.000', 'CL'),
    ('139.230.000.000', 'AU'),
    ('139.231.000.000', 'US'),
    ('140.077.000.000', 'FR'),
    ('140.078.000.000', 'AT'),
    ('140.079.000.000', 'AU'),
    ('140.080.000.000', 'CA'),
    ('140.081.000.000', 'JP'),
    ('140.082.000.000', 'US'),
    ('140.083.000.000', 'AU'),
    ('140.084.000.000', 'DE'),
    ('140.085.000.000', 'NL'),
    ('140.086.000.000', 'FR'),
    ('140.087.000.000', 'CA'),
    ('140.088.000.000', 'US'),
    ('140.092.000.000', 'TW'),
    ('140.093.000.000', 'FR'),
    ('140.095.000.000', 'US'),
    ('140.096.000.000', 'TW'),
    ('140.097.000.000', 'GB'),
    ('140.098.000.000', 'US'),
    ('140.105.000.000', 'IT'),
    ('140.106.000.000', 'US'),
    ('140.109.000.000', 'TW'),
    ('140.139.000.000', 'US'),
    ('140.143.000.000', 'AU'),
    ('140.144.000.000', 'US'),
    ('140.148.000.000', 'MX'),
    ('140.149.000.000', '--'),
    ('140.150.000.000', 'SE'),
    ('140.151.000.000', 'FI'),
    ('140.152.000.000', 'US'),
    ('140.159.000.000', 'AU'),
    ('140.160.000.000', 'US'),
    ('140.161.000.000', 'CA'),
    ('140.162.000.000', 'US'),
    ('140.164.000.000', 'IT'),
    ('140.165.000.000', 'US'),
    ('140.166.000.000', 'SE'),
    ('140.167.000.000', 'CA'),
    ('140.168.000.000', 'AU'),
    ('140.169.000.000', 'US'),
    ('140.179.000.000', 'GB'),
    ('140.180.000.000', 'US'),
    ('140.181.000.000', 'DE'),
    ('140.182.000.000', 'US'),
    ('140.184.000.000', 'CA'),
    ('140.185.000.000', 'US'),
    ('140.191.000.000', 'AR'),
    ('140.192.000.000', 'US'),
    ('140.193.000.000', 'CA'),
    ('140.194.000.000', 'US'),
    ('140.200.000.000', 'NZ'),
    ('140.201.000.000', 'US'),
    ('140.203.000.000', 'IE'),
    ('140.204.000.000', 'GB'),
    ('140.205.000.000', '--'),
    ('140.208.000.000', 'US'),
    ('140.230.000.000', 'CA'),
    ('140.231.000.000', 'US'),
    ('140.253.000.000', 'AU'),
    ('140.254.000.000', 'US'),
    ('140.255.000.000', '--'),
    ('141.000.000.000', 'NL'),
    ('141.001.000.000', 'DE'),
    ('141.006.207.000', 'CH'),
    ('141.006.208.000', 'DE'),
    ('141.085.000.000', 'RO'),
    ('141.086.000.000', 'US'),
    ('141.087.000.000', 'DE'),
    ('141.092.000.000', 'GB'),
    ('141.093.000.000', 'NL'),
    ('141.094.000.000', 'GB'),
    ('141.096.000.000', 'BE'),
    ('141.097.000.000', 'GB'),
    ('141.098.000.000', 'CH'),
    ('141.099.000.000', 'DE'),
    ('141.101.000.000', '--'),
    ('141.102.000.000', 'US'),
    ('141.103.000.000', 'ID'),
    ('141.104.000.000', 'US'),
    ('141.108.000.000', 'IT'),
    ('141.109.000.000', 'CA'),
    ('141.110.000.000', 'US'),
    ('141.113.000.000', 'DE'),
    ('141.114.000.000', 'US'),
    ('141.115.000.000', 'FR'),
    ('141.116.000.000', 'US'),
    ('141.117.000.000', 'CA'),
    ('141.120.000.000', 'AU'),
    ('141.121.000.000', 'US'),
    ('141.122.000.000', 'CH'),
    ('141.123.000.000', 'US'),
    ('141.127.000.000', 'FI'),
    ('141.128.000.000', 'US'),
    ('141.130.000.000', 'DE'),
    ('141.131.000.000', 'US'),
    ('141.132.000.000', 'AU'),
    ('141.133.000.000', 'US'),
    ('141.134.000.000', '--'),
    ('141.137.000.000', 'IT'),
    ('141.138.000.000', '--'),
    ('141.139.000.000', 'US'),
    ('141.143.000.000', 'BE'),
    ('141.144.000.000', 'DK'),
    ('141.145.000.000', 'NO'),
    ('141.146.000.000', 'FI'),
    ('141.147.000.000', 'SE'),
    ('141.148.000.000', 'CH'),
    ('141.149.000.000', 'US'),
    ('141.163.000.000', 'GB'),
    ('141.164.000.000', 'US'),
    ('141.168.000.000', 'AU'),
    ('141.169.000.000', 'DE'),
    ('141.170.000.000', '--'),
    ('141.171.000.000', 'CH'),
    ('141.172.000.000', 'FI'),
    ('141.173.000.000', 'US'),
    ('141.175.000.000', 'FR'),
    ('141.176.000.000', 'NL'),
    ('141.177.000.000', 'US'),
    ('141.178.000.000', 'JP'),
    ('141.179.000.000', 'DE'),
    ('141.180.000.000', 'US'),
    ('141.181.000.000', 'FR'),
    ('141.182.000.000', 'US'),
    ('141.187.000.000', 'DE'),
    ('141.188.000.000', 'US'),
    ('141.192.000.000', 'FI'),
    ('141.193.000.000', 'US'),
    ('141.194.000.000', 'FR'),
    ('141.195.000.000', 'US'),
    ('141.196.000.000', 'GB'),
    ('141.197.000.000', 'US'),
    ('141.200.000.000', 'DE'),
    ('141.201.000.000', 'AT'),
    ('141.202.000.000', 'US'),
    ('141.203.000.000', 'AT'),
    ('141.204.000.000', 'US'),
    ('141.208.000.000', 'FI'),
    ('141.209.000.000', 'US'),
    ('141.220.000.000', 'DE'),
    ('141.221.000.000', 'US'),
    ('141.223.000.000', 'KR'),
    ('141.224.000.000', 'US'),
    ('141.226.000.000', 'IL'),
    ('141.227.000.000', 'FR'),
    ('141.228.000.000', 'GB'),
    ('141.229.000.000', 'JP'),
    ('141.230.000.000', 'US'),
    ('141.231.000.000', 'GB'),
    ('141.232.000.000', 'US'),
    ('141.241.000.000', 'GB'),
    ('141.242.000.000', 'US'),
    ('141.243.000.000', 'AU'),
    ('141.244.000.000', 'AT'),
    ('141.245.000.000', 'GB'),
    ('141.246.000.000', 'US'),
    ('141.249.000.000', 'CH'),
    ('141.250.000.000', 'IT'),
    ('141.251.000.000', 'US'),
    ('141.252.000.000', 'NL'),
    ('141.253.000.000', 'BE'),
    ('141.254.000.000', 'US'),
    ('141.255.000.000', '--'),
    ('142.000.000.000', 'CA'),
    ('142.079.000.000', 'US'),
    ('142.080.000.000', 'CA'),
    ('142.167.000.000', 'US'),
    ('142.168.000.000', 'CA'),
    ('142.192.000.000', 'US'),
    ('142.193.000.000', 'CA'),
    ('142.196.000.000', '--'),
    ('142.198.000.000', 'CA'),
    ('143.000.000.000', 'US'),
    ('143.041.000.000', 'GB'),
    ('143.042.000.000', 'US'),
    ('143.047.000.000', 'IE'),
    ('143.048.000.000', 'US'),
    ('143.050.000.000', 'AT'),
    ('143.051.000.000', 'FI'),
    ('143.052.000.000', 'GB'),
    ('143.054.000.000', 'BR'),
    ('143.055.000.000', 'US'),
    ('143.065.000.000', 'GB'),
    ('143.066.000.000', 'US'),
    ('143.089.000.000', 'HK'),
    ('143.090.000.000', 'JP'),
    ('143.091.000.000', 'US'),
    ('143.092.000.000', 'AU'),
    ('143.093.000.000', 'DE'),
    ('143.094.000.000', 'JP'),
    ('143.095.000.000', 'US'),
    ('143.096.000.000', 'NZ'),
    ('143.097.000.000', 'NO'),
    ('143.098.000.000', 'US'),
    ('143.099.000.000', 'CH'),
    ('143.100.000.000', 'US'),
    ('143.106.000.000', 'BR'),
    ('143.109.000.000', 'US'),
    ('143.117.000.000', 'GB'),
    ('143.118.000.000', 'SE'),
    ('143.119.000.000', 'AU'),
    ('143.120.000.000', 'US'),
    ('143.121.000.000', 'NL'),
    ('143.122.000.000', 'US'),
    ('143.125.000.000', 'JP'),
    ('143.126.000.000', 'FR'),
    ('143.127.000.000', 'US'),
    ('143.128.000.000', 'ZA'),
    ('143.129.000.000', 'BE'),
    ('143.130.000.000', 'AT'),
    ('143.131.000.000', 'US'),
    ('143.136.000.000', 'GB'),
    ('143.137.000.000', 'US'),
    ('143.160.000.000', 'ZA'),
    ('143.161.000.000', 'AT'),
    ('143.162.000.000', 'US'),
    ('143.163.000.000', 'DE'),
    ('143.165.000.000', 'US'),
    ('143.167.000.000', 'GB'),
    ('143.168.000.000', 'US'),
    ('143.169.000.000', 'BE'),
    ('143.170.000.000', 'US'),
    ('143.171.000.000', 'JP'),
    ('143.172.000.000', 'US'),
    ('143.174.000.000', 'AU'),
    ('143.175.000.000', 'US'),
    ('143.176.000.000', 'NL'),
    ('143.180.000.000', 'CH'),
    ('143.181.000.000', 'US'),
    ('143.188.000.000', 'AU'),
    ('143.190.000.000', 'US'),
    ('143.196.000.000', 'FR'),
    ('143.197.000.000', 'US'),
    ('143.201.000.000', 'JP'),
    ('143.202.000.000', '--'),
    ('143.203.000.000', 'US'),
    ('143.205.000.000', 'AT'),
    ('143.206.000.000', 'US'),
    ('143.208.000.000', '--'),
    ('143.209.000.000', 'US'),
    ('143.210.000.000', 'GB'),
    ('143.211.000.000', 'US'),
    ('143.216.000.000', 'AU'),
    ('143.217.000.000', 'SE'),
    ('143.218.000.000', 'AU'),
    ('143.219.000.000', 'US'),
    ('143.221.000.000', 'JP'),
    ('143.222.000.000', 'US'),
    ('143.224.000.000', 'AT'),
    ('143.225.000.000', 'IT'),
    ('143.226.000.000', 'US'),
    ('143.233.000.000', 'GR'),
    ('143.234.000.000', 'GB'),
    ('143.235.000.000', 'US'),
    ('143.237.000.000', 'SE'),
    ('143.238.000.000', 'AU'),
    ('143.239.000.000', 'IE'),
    ('143.240.000.000', 'US'),
    ('143.245.000.000', 'AT'),
    ('143.246.000.000', 'US'),
    ('143.248.000.000', 'KR'),
    ('143.249.000.000', 'US'),
    ('143.252.000.000', 'GB'),
    ('143.253.000.000', 'JP'),
    ('143.254.000.000', 'US'),
    ('143.255.000.000', '--'),
    ('144.001.000.000', 'JP'),
    ('144.002.000.000', 'NL'),
    ('144.003.000.000', 'US'),
    ('144.004.000.000', 'FI'),
    ('144.005.000.000', 'US'),
    ('144.006.000.000', 'AU'),
    ('144.007.000.000', '--'),
    ('144.008.000.000', 'US'),
    ('144.016.000.000', 'IN'),
    ('144.017.000.000', 'US'),
    ('144.020.000.000', 'ES'),
    ('144.021.000.000', 'PT'),
    ('144.022.000.000', 'MX'),
    ('144.023.000.000', 'BR'),
    ('144.024.000.000', 'GR'),
    ('144.025.000.000', 'US'),
    ('144.027.000.000', 'SE'),
    ('144.028.000.000', 'US'),
    ('144.032.000.000', 'GB'),
    ('144.033.000.000', 'US'),
    ('144.041.000.000', 'DE'),
    ('144.042.000.000', 'US'),
    ('144.043.000.000', 'NL'),
    ('144.045.000.000', 'US'),
    ('144.052.000.000', '--'),
    ('144.053.000.000', 'AU'),
    ('144.054.000.000', 'NL'),
    ('144.055.000.000', 'AU'),
    ('144.056.000.000', 'FR'),
    ('144.057.000.000', 'SE'),
    ('144.058.000.000', 'US'),
    ('144.063.000.000', 'SE'),
    ('144.064.000.000', 'PT'),
    ('144.065.000.000', 'AT'),
    ('144.066.000.000', 'NZ'),
    ('144.067.000.000', 'US'),
    ('144.072.000.000', 'CA'),
    ('144.073.000.000', 'US'),
    ('144.076.000.000', 'DE'),
    ('144.077.000.000', 'US'),
    ('144.079.000.000', 'AU'),
    ('144.080.000.000', 'US'),
    ('144.082.000.000', 'GB'),
    ('144.083.000.000', 'US'),
    ('144.084.000.000', 'NO'),
    ('144.085.000.000', 'CH'),
    ('144.086.000.000', 'US'),
    ('144.087.000.000', 'GB'),
    ('144.088.000.000', 'US'),
    ('144.095.000.000', 'SE'),
    ('144.096.000.000', 'US'),
    ('144.097.000.000', 'AU'),
    ('144.098.000.000', 'GB'),
    ('144.099.000.000', 'US'),
    ('144.102.000.000', 'NL'),
    ('144.104.000.000', 'US'),
    ('144.110.000.000', 'AU'),
    ('144.111.000.000', 'US'),
    ('144.119.000.000', 'NL'),
    ('144.120.000.000', 'FJ'),
    ('144.121.000.000', 'US'),
    ('144.122.000.000', 'TR'),
    ('144.123.000.000', '--'),
    ('144.124.000.000', 'GB'),
    ('144.125.000.000', 'US'),
    ('144.127.000.000', 'NO'),
    ('144.128.000.000', 'US'),
    ('144.130.000.000', 'AU'),
    ('144.141.000.000', 'US'),
    ('144.145.000.000', 'DE'),
    ('144.146.000.000', 'US'),
    ('144.164.000.000', 'NO'),
    ('144.165.000.000', 'FR'),
    ('144.166.000.000', 'US'),
    ('144.168.000.000', 'GB'),
    ('144.169.000.000', 'US'),
    ('144.173.000.000', 'GB'),
    ('144.174.000.000', 'US'),
    ('144.176.000.000', 'GB'),
    ('144.182.000.000', 'US'),
    ('144.193.000.000', 'NO'),
    ('144.194.000.000', 'CA'),
    ('144.195.000.000', 'US'),
    ('144.199.000.000', 'MY'),
    ('144.200.000.000', 'CH'),
    ('144.201.000.000', 'US'),
    ('144.204.000.000', 'FR'),
    ('144.205.000.000', 'AU'),
    ('144.206.000.000', 'RU'),
    ('144.207.000.000', 'US'),
    ('144.209.000.000', 'NL'),
    ('144.210.000.000', 'US'),
    ('144.213.000.000', 'JP'),
    ('144.214.000.000', 'HK'),
    ('144.215.000.000', 'US'),
    ('144.218.000.000', 'AU'),
    ('144.219.000.000', 'US'),
    ('144.248.000.000', 'BE'),
    ('144.249.000.000', 'US'),
    ('145.000.000.000', 'NL'),
    ('145.224.000.000', 'GB'),
    ('145.225.000.000', 'DE'),
    ('145.226.000.000', 'FR'),
    ('145.227.000.000', 'GB'),
    ('145.228.000.000', 'DE'),
    ('145.229.000.000', 'GB'),
    ('145.230.000.000', 'DE'),
    ('145.231.000.000', 'FR'),
    ('145.232.000.000', 'CH'),
    ('145.233.000.000', 'GB'),
    ('145.234.000.000', 'CH'),
    ('145.235.000.000', 'SE'),
    ('145.236.000.000', 'HU'),
    ('145.237.000.000', 'PL'),
    ('145.238.000.000', 'FR'),
    ('145.239.000.000', 'GB'),
    ('145.241.000.000', 'AT'),
    ('145.242.000.000', 'FR'),
    ('145.243.000.000', 'DE'),
    ('145.244.000.000', 'AT'),
    ('145.245.000.000', 'CH'),
    ('145.246.000.000', 'GB'),
    ('145.247.000.000', 'SE'),
    ('145.247.151.000', 'NO'),
    ('145.247.171.000', 'SE'),
    ('145.248.000.000', 'FR'),
    ('145.249.000.000', 'RU'),
    ('145.250.000.000', 'CH'),
    ('145.251.000.000', 'SE'),
    ('145.252.000.000', 'CH'),
    ('145.253.000.000', 'DE'),
    ('145.255.000.000', '--'),
    ('146.001.000.000', 'US'),
    ('146.002.000.000', 'NO'),
    ('146.003.000.000', 'BG'),
    ('146.004.000.000', 'CH'),
    ('146.005.000.000', 'US'),
    ('146.011.000.000', 'AU'),
    ('146.012.000.000', 'US'),
    ('146.019.000.000', 'FR'),
    ('146.020.000.000', 'US'),
    ('146.021.000.000', 'SE'),
    ('146.022.000.000', 'US'),
    ('146.048.000.000', 'IT'),
    ('146.049.000.000', 'US'),
    ('146.050.000.000', 'NL'),
    ('146.051.000.000', 'JP'),
    ('146.052.000.000', 'US'),
    ('146.056.000.000', 'JP'),
    ('146.057.000.000', 'US'),
    ('146.059.000.000', 'NO'),
    ('146.060.000.000', '--'),
    ('146.061.000.000', 'US'),
    ('146.062.000.000', 'AU'),
    ('146.063.000.000', 'US'),
    ('146.064.000.000', 'ZA'),
    ('146.065.000.000', 'US'),
    ('146.066.000.000', '--'),
    ('146.067.000.000', 'CH'),
    ('146.068.000.000', 'US'),
    ('146.070.000.000', 'GB'),
    ('146.071.000.000', 'US'),
    ('146.072.000.000', 'NO'),
    ('146.073.000.000', 'US'),
    ('146.075.000.000', 'SE'),
    ('146.076.000.000', 'US'),
    ('146.077.000.000', 'GB'),
    ('146.078.000.000', 'US'),
    ('146.080.000.000', 'GB'),
    ('146.081.000.000', 'FI'),
    ('146.082.000.000', 'US'),
    ('146.083.000.000', 'CL'),
    ('146.084.000.000', 'US'),
    ('146.087.000.000', 'GB'),
    ('146.088.000.000', 'US'),
    ('146.089.000.000', 'GB'),
    ('146.090.000.000', 'JP'),
    ('146.091.000.000', 'US'),
    ('146.097.000.000', 'GB'),
    ('146.098.000.000', 'DE'),
    ('146.099.000.000', 'US'),
    ('146.100.000.000', 'IT'),
    ('146.101.000.000', 'GB'),
    ('146.102.000.000', 'CZ'),
    ('146.103.000.000', 'BE'),
    ('146.104.000.000', 'NL'),
    ('146.105.000.000', 'GB'),
    ('146.106.000.000', 'NL'),
    ('146.107.000.000', 'DE'),
    ('146.108.000.000', 'AT'),
    ('146.109.000.000', 'CH'),
    ('146.110.000.000', 'HU'),
    ('146.111.000.000', 'US'),
    ('146.112.000.000', 'AT'),
    ('146.113.000.000', 'US'),
    ('146.116.000.000', 'AU'),
    ('146.117.000.000', 'JP'),
    ('146.118.000.000', 'AU'),
    ('146.119.000.000', 'FI'),
    ('146.120.000.000', '--'),
    ('146.121.000.000', 'US'),
    ('146.123.000.000', 'DK'),
    ('146.124.000.000', 'GR'),
    ('146.125.000.000', 'GB'),
    ('146.126.000.000', 'US'),
    ('146.131.000.000', 'CA'),
    ('146.132.000.000', 'US'),
    ('146.133.000.000', 'IT'),
    ('146.134.000.000', 'BR'),
    ('146.135.000.000', 'US'),
    ('146.136.000.000', 'CH'),
    ('146.137.000.000', 'US'),
    ('146.140.000.000', 'DE'),
    ('146.141.000.000', 'ZA'),
    ('146.142.000.000', 'US'),
    ('146.144.000.000', 'AU'),
    ('146.145.000.000', 'US'),
    ('146.155.000.000', 'CL'),
    ('146.156.000.000', 'US'),
    ('146.158.000.000', '--'),
    ('146.159.000.000', 'CH'),
    ('146.160.000.000', 'US'),
    ('146.161.000.000', 'FI'),
    ('146.162.000.000', 'GB'),
    ('146.163.000.000', 'US'),
    ('146.164.000.000', 'BR'),
    ('146.165.000.000', 'US'),
    ('146.169.000.000', 'GB'),
    ('146.170.000.000', 'US'),
    ('146.171.000.000', 'NZ'),
    ('146.172.000.000', 'NO'),
    ('146.173.000.000', 'SE'),
    ('146.174.000.000', 'US'),
    ('146.175.000.000', 'BE'),
    ('146.176.000.000', 'GB'),
    ('146.178.000.000', 'AU'),
    ('146.179.000.000', 'GB'),
    ('146.180.000.000', 'US'),
    ('146.182.000.000', 'ZA'),
    ('146.183.000.000', 'US'),
    ('146.188.000.000', 'GB'),
    ('146.189.000.000', 'US'),
    ('146.191.000.000', 'GB'),
    ('146.192.000.000', 'NO'),
    ('146.193.000.000', 'PT'),
    ('146.194.000.000', 'GB'),
    ('146.195.000.000', 'AU'),
    ('146.197.000.000', 'US'),
    ('146.204.000.000', 'FI'),
    ('146.205.000.000', 'US'),
    ('146.210.000.000', 'FI'),
    ('146.212.000.000', 'US'),
    ('146.213.000.000', 'NO'),
    ('146.214.000.000', 'US'),
    ('146.215.064.000', 'SG'),
    ('146.215.067.000', 'US'),
    ('146.216.000.000', 'CH'),
    ('146.217.000.000', 'US'),
    ('146.219.000.000', 'ES'),
    ('146.220.000.000', 'FR'),
    ('146.221.000.000', 'AU'),
    ('146.222.000.000', 'US'),
    ('146.222.201.000', 'GB'),
    ('146.222.202.000', 'US'),
    ('146.222.203.000', 'GB'),
    ('146.222.205.000', 'US'),
    ('146.222.210.000', 'GB'),
    ('146.222.211.000', 'US'),
    ('146.222.217.000', 'DE'),
    ('146.222.218.000', 'US'),
    ('146.222.220.000', 'DE'),
    ('146.222.222.000', 'US'),
    ('146.224.000.000', 'NO'),
    ('146.225.000.000', 'US'),
    ('146.227.000.000', 'GB'),
    ('146.228.000.000', 'CH'),
    ('146.229.000.000', 'US'),
    ('146.230.000.000', 'ZA'),
    ('146.233.000.000', 'US'),
    ('146.234.000.000', 'DE'),
    ('146.235.000.000', 'US'),
    ('146.248.000.000', 'CH'),
    ('146.249.000.000', 'FR'),
    ('146.250.000.000', 'US'),
    ('146.251.000.000', '--'),
    ('146.252.000.000', 'US'),
    ('146.253.000.000', 'SE'),
    ('146.254.000.000', 'DE'),
    ('146.255.000.000', '--'),
    ('147.000.000.000', 'US'),
    ('147.006.000.000', 'KR'),
    ('147.007.000.000', 'HU'),
    ('147.008.000.000', 'HK'),
    ('147.009.000.000', 'US'),
    ('147.010.000.000', 'AU'),
    ('147.011.000.000', 'US'),
    ('147.012.000.000', 'NL'),
    ('147.013.000.000', 'SE'),
    ('147.015.000.000', 'US'),
    ('147.027.000.000', 'GR'),
    ('147.028.000.000', 'US'),
    ('147.029.000.000', 'DK'),
    ('147.030.000.000', 'DE'),
    ('147.031.000.000', 'US'),
    ('147.032.000.000', 'CZ'),
    ('147.034.000.000', 'US'),
    ('147.041.000.000', 'AU'),
    ('147.042.000.000', 'US'),
    ('147.043.000.000', 'KR'),
    ('147.044.000.000', 'SE'),
    ('147.045.000.000', 'RU'),
    ('147.046.000.000', 'KR'),
    ('147.048.000.000', 'US'),
    ('147.052.000.000', 'GR'),
    ('147.053.000.000', 'US'),
    ('147.054.000.000', 'DE'),
    ('147.055.000.000', 'US'),
    ('147.060.000.000', 'JP'),
    ('147.061.000.000', 'US'),
    ('147.065.000.000', 'BR'),
    ('147.066.000.000', 'AU'),
    ('147.067.000.000', 'LU'),
    ('147.068.000.000', 'GB'),
    ('147.069.000.000', 'AU'),
    ('147.070.000.000', 'US'),
    ('147.075.000.000', 'CH'),
    ('147.076.000.000', 'AU'),
    ('147.077.000.000', 'GB'),
    ('147.078.000.000', 'CH'),
    ('147.079.000.000', 'US'),
    ('147.083.000.000', 'ES'),
    ('147.085.000.000', 'US'),
    ('147.086.000.000', 'CH'),
    ('147.089.000.000', 'GB'),
    ('147.090.000.000', 'US'),
    ('147.091.000.000', 'YU'),
    ('147.092.000.000', 'US'),
    ('147.093.000.000', 'BE'),
    ('147.094.000.000', 'FR'),
    ('147.095.000.000', 'GR'),
    ('147.096.000.000', 'ES'),
    ('147.097.000.000', 'US'),
    ('147.098.000.000', 'FR'),
    ('147.101.000.000', 'US'),
    ('147.102.000.000', 'GR'),
    ('147.103.000.000', 'US'),
    ('147.109.000.000', 'AU'),
    ('147.110.000.000', 'ZA'),
    ('147.111.000.000', 'NO'),
    ('147.113.000.000', 'US'),
    ('147.119.000.000', 'GB'),
    ('147.120.000.000', 'US'),
    ('147.122.000.000', 'IT'),
    ('147.124.000.000', 'US'),
    ('147.125.000.000', 'AT'),
    ('147.126.000.000', 'US'),
    ('147.127.000.000', 'FR'),
    ('147.128.000.000', 'US'),
    ('147.132.000.000', 'AU'),
    ('147.133.000.000', 'US'),
    ('147.142.000.000', 'DE'),
    ('147.143.000.000', 'GB'),
    ('147.144.000.000', 'US'),
    ('147.147.000.000', 'GB'),
    ('147.153.000.000', 'US'),
    ('147.156.000.000', 'ES'),
    ('147.157.000.000', 'JP'),
    ('147.158.000.000', 'NZ'),
    ('147.159.000.000', 'US'),
    ('147.161.000.000', 'IL'),
    ('147.162.000.000', 'IT'),
    ('147.164.000.000', 'US'),
    ('147.167.000.000', 'CH'),
    ('147.168.000.000', 'US'),
    ('147.171.000.000', 'FR'),
    ('147.172.000.000', 'DE'),
    ('147.173.000.000', 'FR'),
    ('147.174.000.000', 'US'),
    ('147.175.000.000', 'SK'),
    ('147.176.000.000', 'JP'),
    ('147.177.000.000', 'US'),
    ('147.180.000.000', 'SE'),
    ('147.181.000.000', 'NL'),
    ('147.182.000.000', 'US'),
    ('147.184.000.000', 'GB'),
    ('147.185.000.000', 'US'),
    ('147.186.000.000', 'SE'),
    ('147.187.000.000', 'US'),
    ('147.188.000.000', 'GB'),
    ('147.190.000.000', 'US'),
    ('147.193.000.000', 'GB'),
    ('147.194.000.000', '--'),
    ('147.195.000.000', 'US'),
    ('147.196.000.000', 'FR'),
    ('147.197.000.000', 'GB'),
    ('147.198.000.000', 'US'),
    ('147.200.000.000', 'AU'),
    ('147.201.000.000', 'GB'),
    ('147.202.000.000', 'US'),
    ('147.204.000.000', 'DE'),
    ('147.205.000.000', 'US'),
    ('147.209.000.000', 'AU'),
    ('147.210.000.000', 'FR'),
    ('147.211.000.000', 'AU'),
    ('147.213.000.000', 'SK'),
    ('147.214.000.000', 'SE'),
    ('147.215.000.000', 'FR'),
    ('147.216.000.000', 'US'),
    ('147.220.000.000', 'SE'),
    ('147.221.000.000', 'US'),
    ('147.228.000.000', 'CZ'),
    ('147.232.000.000', 'SK'),
    ('147.233.000.000', 'IL'),
    ('147.238.000.000', 'US'),
    ('147.250.000.000', 'FR'),
    ('147.251.000.000', 'CZ'),
    ('147.252.000.000', 'IE'),
    ('147.253.000.000', 'US'),
    ('147.255.000.000', '--'),
    ('148.001.000.000', 'US'),
    ('148.002.000.000', 'SE'),
    ('148.003.000.000', 'GB'),
    ('148.004.000.000', 'US'),
    ('148.006.000.000', 'HU'),
    ('148.007.000.000', 'US'),
    ('148.009.000.000', 'GB'),
    ('148.010.000.000', 'US'),
    ('148.054.000.000', 'DE'),
    ('148.055.000.000', 'US'),
    ('148.056.000.000', 'AT'),
    ('148.057.000.000', 'US'),
    ('148.060.000.000', 'FR'),
    ('148.061.000.000', 'US'),
    ('148.079.000.000', 'GB'),
    ('148.080.000.000', 'US'),
    ('148.081.000.000', 'PL'),
    ('148.082.000.000', 'NO'),
    ('148.084.000.000', 'US'),
    ('148.088.000.000', 'GB'),
    ('148.089.000.000', 'US'),
    ('148.110.000.000', 'LU'),
    ('148.111.000.000', 'US'),
    ('148.117.000.000', 'CA'),
    ('148.118.000.000', 'NO'),
    ('148.124.000.000', 'US'),
    ('148.135.000.000', 'NO'),
    ('148.136.000.000', 'SE'),
    ('148.137.000.000', 'US'),
    ('148.138.000.000', 'SE'),
    ('148.139.000.000', 'US'),
    ('148.140.000.000', 'NO'),
    ('148.141.000.000', 'US'),
    ('148.143.000.000', 'FR'),
    ('148.144.000.000', 'US'),
    ('148.145.000.000', 'AU'),
    ('148.146.000.000', 'US'),
    ('148.148.000.000', 'NL'),
    ('148.149.000.000', 'US'),
    ('148.151.000.000', 'OM'),
    ('148.152.000.000', 'US'),
    ('148.160.000.000', 'SE'),
    ('148.161.000.000', 'JP'),
    ('148.162.000.000', 'US'),
    ('148.169.000.000', 'FR'),
    ('148.170.000.000', 'US'),
    ('148.176.000.000', 'GB'),
    ('148.177.000.000', 'US'),
    ('148.181.000.000', 'GB'),
    ('148.182.000.000', 'AU'),
    ('148.183.000.000', 'US'),
    ('148.185.000.000', 'GB'),
    ('148.186.000.000', 'US'),
    ('148.187.000.000', 'CH'),
    ('148.188.000.000', 'US'),
    ('148.195.000.000', 'AU'),
    ('148.196.000.000', 'CH'),
    ('148.197.000.000', 'GB'),
    ('148.198.000.000', 'AT'),
    ('148.199.000.000', 'US'),
    ('148.200.000.000', 'NL'),
    ('148.201.000.000', 'MX'),
    ('148.223.156.000', 'EC'),
    ('148.223.160.000', 'MX'),
    ('148.235.180.000', 'EC'),
    ('148.235.184.000', 'MX'),
    ('148.251.000.000', 'DE'),
    ('148.252.000.000', 'GB'),
    ('148.254.000.000', 'US'),
    ('148.255.000.000', '--'),
    ('149.000.000.000', 'US'),
    ('149.049.000.000', 'IL'),
    ('149.050.000.000', 'US'),
    ('149.059.000.000', 'NL'),
    ('149.060.000.000', 'US'),
    ('149.099.000.000', 'CA'),
    ('149.100.000.000', 'US'),
    ('149.131.000.000', 'AU'),
    ('149.132.000.000', 'IT'),
    ('149.133.000.000', 'CH'),
    ('149.134.000.000', 'BE'),
    ('149.135.000.000', 'AU'),
    ('149.136.000.000', 'US'),
    ('149.139.000.000', 'IT'),
    ('149.140.000.000', 'US'),
    ('149.144.000.000', 'AU'),
    ('149.145.000.000', 'US'),
    ('149.146.000.000', 'NL'),
    ('149.147.000.000', 'US'),
    ('149.148.000.000', 'AT'),
    ('149.149.000.000', 'US'),
    ('149.153.000.000', 'IE'),
    ('149.154.000.000', 'US'),
    ('149.155.000.000', 'GB'),
    ('149.156.000.000', 'PL'),
    ('149.157.000.000', 'IE'),
    ('149.158.000.000', 'US'),
    ('149.167.000.000', 'AU'),
    ('149.168.000.000', 'US'),
    ('149.170.000.000', 'GB'),
    ('149.171.000.000', 'AU'),
    ('149.172.000.000', 'US'),
    ('149.176.000.000', 'AU'),
    ('149.177.000.000', 'US'),
    ('149.197.000.000', 'FI'),
    ('149.198.000.000', 'US'),
    ('149.200.000.000', 'DE'),
    ('149.210.000.000', 'NL'),
    ('149.211.000.000', 'DE'),
    ('149.212.000.000', 'DK'),
    ('149.213.000.000', 'DE'),
    ('149.221.000.000', 'NL'),
    ('149.222.000.000', 'DE'),
    ('149.223.000.000', 'GB'),
    ('149.224.000.000', 'DE'),
    ('149.244.144.000', 'FR'),
    ('149.244.148.000', 'DE'),
    ('149.251.000.000', 'FR'),
    ('149.252.000.000', 'US'),
    ('149.254.000.000', 'GB'),
    ('149.255.000.000', '--'),
    ('150.000.000.000', 'JP'),
    ('150.040.000.000', 'US'),
    ('150.041.000.000', 'JP'),
    ('150.101.000.000', 'AU'),
    ('150.102.000.000', 'US'),
    ('150.106.000.000', 'NO'),
    ('150.107.000.000', 'AT'),
    ('150.108.000.000', 'US'),
    ('150.126.000.000', 'GB'),
    ('150.127.000.000', 'US'),
    ('150.128.000.000', 'ES'),
    ('150.129.000.000', 'DE'),
    ('150.130.000.000', 'US'),
    ('150.132.000.000', 'SE'),
    ('150.133.000.000', 'US'),
    ('150.138.000.000', '--'),
    ('150.140.000.000', 'GR'),
    ('150.141.000.000', 'US'),
    ('150.145.000.000', 'IT'),
    ('150.147.000.000', 'US'),
    ('150.150.000.000', 'KR'),
    ('150.151.000.000', 'AU'),
    ('150.152.000.000', 'US'),
    ('150.158.000.000', 'BE'),
    ('150.159.000.000', 'US'),
    ('150.161.000.000', 'BR'),
    ('150.166.000.000', 'US'),
    ('150.173.000.000', 'AU'),
    ('150.174.000.000', 'US'),
    ('150.175.000.000', 'FR'),
    ('150.176.000.000', 'US'),
    ('150.178.000.000', 'IT'),
    ('150.179.000.000', 'US'),
    ('150.183.000.000', 'KR'),
    ('150.184.000.000', 'US'),
    ('150.185.000.000', 'VE'),
    ('150.190.000.000', 'US'),
    ('150.191.000.000', 'AU'),
    ('150.192.000.000', 'US'),
    ('150.197.000.000', 'KR'),
    ('150.198.000.000', 'US'),
    ('150.203.000.000', 'AU'),
    ('150.204.000.000', 'GB'),
    ('150.205.000.000', 'CH'),
    ('150.206.000.000', 'NZ'),
    ('150.207.000.000', 'AU'),
    ('150.208.000.000', 'US'),
    ('150.213.000.000', 'CH'),
    ('150.214.000.000', 'ES'),
    ('150.215.000.000', 'US'),
    ('150.217.000.000', 'IT'),
    ('150.218.000.000', 'US'),
    ('150.227.000.000', 'SE'),
    ('150.228.000.000', 'US'),
    ('150.229.000.000', 'AU'),
    ('150.230.000.000', 'US'),
    ('150.236.000.000', 'SE'),
    ('150.237.000.000', 'GB'),
    ('150.238.000.000', 'US'),
    ('150.241.000.000', 'ES'),
    ('150.242.000.000', 'FR'),
    ('150.243.000.000', 'US'),
    ('150.244.000.000', 'ES'),
    ('150.245.000.000', 'US'),
    ('150.251.000.000', 'BE'),
    ('150.252.000.000', 'US'),
    ('150.254.000.000', 'PL'),
    ('150.255.000.000', '--'),
    ('151.000.000.000', 'IT'),
    ('151.013.000.000', 'NL'),
    ('151.013.001.000', 'IT'),
    ('151.013.003.000', 'NL'),
    ('151.013.064.000', 'IT'),
    ('151.013.096.000', 'NL'),
    ('151.014.000.000', 'IT'),
    ('151.023.008.000', 'NL'),
    ('151.023.016.000', 'IT'),
    ('151.023.096.000', 'NL'),
    ('151.024.000.000', 'IT'),
    ('151.082.000.000', 'NL'),
    ('151.083.000.000', 'IT'),
    ('151.101.000.000', 'US'),
    ('151.115.000.000', 'GB'),
    ('151.116.000.000', 'US'),
    ('151.120.000.000', 'CH'),
    ('151.121.000.000', 'US'),
    ('151.127.000.000', 'CH'),
    ('151.128.000.000', 'US'),
    ('151.129.000.000', 'GB'),
    ('151.130.000.000', 'AU'),
    ('151.131.000.000', 'US'),
    ('151.133.000.000', 'GB'),
    ('151.134.000.000', 'US'),
    ('151.135.000.000', 'NZ'),
    ('151.136.000.000', 'DE'),
    ('151.137.000.000', 'US'),
    ('151.156.000.000', 'SE'),
    ('151.157.000.000', 'NO'),
    ('151.158.000.000', 'JP'),
    ('151.159.000.000', 'US'),
    ('151.170.000.000', 'GB'),
    ('151.171.000.000', 'US'),
    ('151.172.000.000', 'JP'),
    ('151.173.000.000', 'US'),
    ('151.175.000.000', 'NO'),
    ('151.176.000.000', 'GB'),
    ('151.177.000.000', 'SE'),
    ('151.178.000.000', 'AU'),
    ('151.179.000.000', 'US'),
    ('151.180.000.000', 'GB'),
    ('151.181.000.000', 'US'),
    ('151.182.000.000', 'GB'),
    ('151.183.000.000', 'CH'),
    ('151.184.000.000', 'US'),
    ('151.187.000.000', 'NO'),
    ('151.188.000.000', 'US'),
    ('151.189.000.000', 'DE'),
    ('151.190.000.000', 'US'),
    ('151.211.000.000', 'GB'),
    ('151.213.000.000', 'US'),
    ('151.216.000.000', '--'),
    ('152.000.000.000', 'US'),
    ('152.066.000.000', 'HU'),
    ('152.067.000.000', 'US'),
    ('152.071.000.000', 'GB'),
    ('152.072.000.000', 'US'),
    ('152.073.000.000', 'DK'),
    ('152.074.000.000', 'CL'),
    ('152.075.000.000', 'US'),
    ('152.076.000.000', 'AU'),
    ('152.077.000.000', 'FR'),
    ('152.078.000.000', 'GB'),
    ('152.079.000.000', 'US'),
    ('152.081.000.000', 'FR'),
    ('152.082.000.000', 'US'),
    ('152.083.000.000', 'AU'),
    ('152.084.000.000', 'BR'),
    ('152.085.000.000', 'US'),
    ('152.088.000.000', 'CH'),
    ('152.089.000.000', 'FR'),
    ('152.090.000.000', 'NO'),
    ('152.091.000.000', 'AU'),
    ('152.092.000.000', 'BR'),
    ('152.093.000.000', 'NO'),
    ('152.095.000.000', 'DK'),
    ('152.096.000.000', 'CH'),
    ('152.097.000.000', 'US'),
    ('152.098.000.000', 'AU'),
    ('152.099.000.000', 'KR'),
    ('152.100.000.000', 'US'),
    ('152.101.000.000', 'HK'),
    ('152.104.128.000', 'CN'),
    ('152.105.000.000', 'GB'),
    ('152.106.000.000', 'ZA'),
    ('152.113.000.000', 'US'),
    ('152.114.000.000', 'GB'),
    ('152.115.000.000', 'DK'),
    ('152.116.000.000', 'US'),
    ('152.118.000.000', 'ID'),
    ('152.119.000.000', 'US'),
    ('152.134.000.000', 'GB'),
    ('152.135.000.000', 'US'),
    ('152.139.000.000', 'CL'),
    ('152.140.000.000', 'US'),
    ('152.143.000.000', 'DE'),
    ('152.144.000.000', 'US'),
    ('152.147.000.000', 'AU'),
    ('152.148.000.000', 'US'),
    ('152.149.000.000', 'KR'),
    ('152.150.000.000', 'GB'),
    ('152.151.000.000', 'US'),
    ('152.152.000.000', 'BE'),
    ('152.153.000.000', 'NZ'),
    ('152.154.000.000', 'US'),
    ('152.160.086.000', 'CA'),
    ('152.160.087.000', 'US'),
    ('152.166.000.000', '--'),
    ('152.168.000.000', 'US'),
    ('152.226.000.000', 'SG'),
    ('152.227.000.000', 'US'),
    ('152.230.000.000', '--'),
    ('153.001.000.000', 'FI'),
    ('153.002.000.000', 'US'),
    ('153.005.000.000', 'YU'),
    ('153.006.000.000', 'US'),
    ('153.015.000.000', 'NO'),
    ('153.016.000.000', 'US'),
    ('153.017.000.000', 'DE'),
    ('153.018.000.000', 'US'),
    ('153.019.000.000', 'PL'),
    ('153.020.000.000', 'SG'),
    ('153.021.000.000', 'US'),
    ('153.044.000.000', 'NO'),
    ('153.045.000.000', 'CH'),
    ('153.047.000.000', 'US'),
    ('153.049.000.000', 'BE'),
    ('153.050.000.000', 'US'),
    ('153.089.000.000', 'BE'),
    ('153.090.000.000', 'US'),
    ('153.092.000.000', 'DE'),
    ('153.099.000.000', 'EU'),
    ('153.100.000.000', 'DE'),
    ('153.101.000.000', 'EU'),
    ('153.102.000.000', 'US'),
    ('153.107.000.000', 'AU'),
    ('153.108.000.000', 'GB'),
    ('153.109.000.000', 'CH'),
    ('153.110.000.000', 'NO'),
    ('153.111.000.000', 'NZ'),
    ('153.112.000.000', 'SE'),
    ('153.113.000.000', 'US'),
    ('153.118.000.000', '--'),
    ('154.000.000.000', 'US'),
    ('154.005.000.000', 'CA'),
    ('154.006.000.000', 'US'),
    ('154.008.000.000', 'GB'),
    ('154.009.000.000', 'US'),
    ('154.010.000.000', 'KR'),
    ('154.011.000.000', 'CA'),
    ('154.012.000.000', 'US'),
    ('154.015.000.000', 'GB'),
    ('154.016.000.000', 'US'),
    ('154.020.000.000', 'CA'),
    ('154.021.000.000', 'US'),
    ('154.032.000.000', 'GB'),
    ('154.033.000.000', 'US'),
    ('154.065.000.000', '--'),
    ('155.001.000.000', 'US'),
    ('155.003.000.000', 'CA'),
    ('155.004.000.000', 'NO'),
    ('155.005.000.000', 'US'),
    ('155.010.000.000', 'CA'),
    ('155.011.000.000', '--'),
    ('155.013.000.000', 'US'),
    ('155.015.000.000', 'CA'),
    ('155.016.000.000', 'GB'),
    ('155.018.000.000', 'US'),
    ('155.032.000.000', 'NZ'),
    ('155.033.000.000', 'US'),
    ('155.054.000.000', 'ES'),
    ('155.055.000.000', 'NO'),
    ('155.056.000.000', 'DE'),
    ('155.057.000.000', 'US'),
    ('155.059.000.000', 'NZ'),
    ('155.060.000.000', 'AU'),
    ('155.061.000.000', 'US'),
    ('155.062.000.000', 'CA'),
    ('155.063.000.000', 'US'),
    ('155.066.000.000', 'GB'),
    ('155.067.000.000', 'US'),
    ('155.069.000.000', 'SG'),
    ('155.070.000.000', 'US'),
    ('155.071.000.000', 'AU'),
    ('155.072.000.000', 'US'),
    ('155.073.000.000', 'DK'),
    ('155.074.000.000', 'US'),
    ('155.089.000.000', 'FR'),
    ('155.090.000.000', 'US'),
    ('155.105.000.000', 'CH'),
    ('155.106.000.000', 'US'),
    ('155.131.000.000', 'GB'),
    ('155.132.000.000', 'FR'),
    ('155.133.000.000', 'DE'),
    ('155.134.000.000', 'US'),
    ('155.136.000.000', 'GB'),
    ('155.137.000.000', 'DK'),
    ('155.138.000.000', 'US'),
    ('155.140.000.000', 'GB'),
    ('155.141.000.000', 'US'),
    ('155.143.000.000', 'AU'),
    ('155.145.000.000', 'GB'),
    ('155.146.000.000', 'US'),
    ('155.158.000.000', 'PL'),
    ('155.159.000.000', 'ZA'),
    ('155.160.000.000', 'JP'),
    ('155.161.000.000', 'US'),
    ('155.185.000.000', 'IT'),
    ('155.186.000.000', 'US'),
    ('155.187.000.000', 'AU'),
    ('155.188.000.000', 'US'),
    ('155.192.000.000', 'GB'),
    ('155.193.000.000', 'US'),
    ('155.194.000.000', 'CA'),
    ('155.195.000.000', 'US'),
    ('155.196.000.000', '--'),
    ('155.197.000.000', 'US'),
    ('155.198.000.000', 'GB'),
    ('155.199.000.000', 'US'),
    ('155.202.000.000', 'GB'),
    ('155.203.000.000', 'US'),
    ('155.204.000.000', 'NL'),
    ('155.205.000.000', 'AU'),
    ('155.206.000.000', 'US'),
    ('155.207.000.000', 'GR'),
    ('155.208.000.000', 'CH'),
    ('155.209.000.000', 'NO'),
    ('155.210.000.000', 'ES'),
    ('155.211.000.000', 'BR'),
    ('155.212.000.000', 'US'),
    ('155.223.000.000', 'TR'),
    ('155.224.000.000', 'US'),
    ('155.227.000.000', 'NO'),
    ('155.228.000.000', 'CH'),
    ('155.229.000.000', 'US'),
    ('155.230.000.000', 'KR'),
    ('155.231.000.000', 'GB'),
    ('155.232.000.000', 'ZA'),
    ('155.241.000.000', 'US'),
    ('155.245.000.000', 'GB'),
    ('155.246.000.000', 'US'),
    ('155.249.000.000', 'GB'),
    ('155.250.000.000', 'DE'),
    ('155.251.000.000', 'US'),
    ('155.253.000.000', 'IT'),
    ('155.254.000.000', 'US'),
    ('155.255.000.000', '--'),
    ('156.000.000.000', 'US'),
    ('156.008.000.000', 'ZA'),
    ('156.009.000.000', 'US'),
    ('156.010.000.000', 'FI'),
    ('156.011.000.000', 'CA'),
    ('156.012.000.000', 'US'),
    ('156.013.000.000', 'NZ'),
    ('156.014.000.000', 'IT'),
    ('156.015.000.000', 'US'),
    ('156.016.000.000', 'AU'),
    ('156.017.000.000', 'PL'),
    ('156.018.000.000', 'FR'),
    ('156.019.000.000', 'US'),
    ('156.022.000.000', 'AU'),
    ('156.023.000.000', 'US'),
    ('156.025.000.000', 'CH'),
    ('156.026.000.000', 'US'),
    ('156.028.000.000', 'FR'),
    ('156.029.000.000', 'US'),
    ('156.031.000.000', 'BN'),
    ('156.032.000.000', 'US'),
    ('156.034.000.000', 'CA'),
    ('156.035.000.000', 'ES'),
    ('156.036.000.000', 'US'),
    ('156.043.000.000', 'GB'),
    ('156.044.000.000', 'CA'),
    ('156.045.000.000', 'US'),
    ('156.048.000.000', 'GB'),
    ('156.049.000.000', 'SE'),
    ('156.050.000.000', 'AU'),
    ('156.051.000.000', 'SE'),
    ('156.052.000.000', 'NO'),
    ('156.053.000.000', 'US'),
    ('156.054.000.000', 'IT'),
    ('156.055.000.000', 'US'),
    ('156.057.000.000', 'CA'),
    ('156.058.000.000', 'AT'),
    ('156.059.000.000', 'NZ'),
    ('156.060.000.000', 'US'),
    ('156.061.000.000', 'GB'),
    ('156.062.000.000', 'NZ'),
    ('156.063.000.000', 'US'),
    ('156.067.000.000', 'DE'),
    ('156.068.000.000', 'US'),
    ('156.069.000.000', 'NZ'),
    ('156.070.000.000', 'US'),
    ('156.079.000.000', 'CA'),
    ('156.080.000.000', 'US'),
    ('156.083.000.000', 'NL'),
    ('156.084.000.000', 'US'),
    ('156.097.000.000', 'CL'),
    ('156.098.000.000', 'US'),
    ('156.106.000.000', 'CH'),
    ('156.107.000.000', 'US'),
    ('156.112.000.000', 'DE'),
    ('156.114.000.000', 'GB'),
    ('156.115.000.000', 'CH'),
    ('156.116.000.000', 'NO'),
    ('156.117.000.000', 'US'),
    ('156.118.000.000', 'FR'),
    ('156.119.000.000', 'US'),
    ('156.133.000.000', 'LU'),
    ('156.134.000.000', 'US'),
    ('156.135.000.000', 'CH'),
    ('156.136.000.000', 'US'),
    ('156.147.000.000', 'KR'),
    ('156.148.000.000', 'IT'),
    ('156.149.000.000', 'NZ'),
    ('156.150.000.000', 'NL'),
    ('156.151.000.000', 'US'),
    ('156.154.000.000', '--'),
    ('157.000.000.000', 'JP'),
    ('157.015.000.000', 'US'),
    ('157.016.000.000', 'JP'),
    ('157.021.000.000', 'US'),
    ('157.023.000.000', 'FR'),
    ('157.024.000.000', 'FI'),
    ('157.025.000.000', 'PL'),
    ('157.026.000.000', 'CH'),
    ('157.027.000.000', 'IT'),
    ('157.030.000.000', 'US'),
    ('157.032.000.000', 'ID'),
    ('157.054.000.000', 'US'),
    ('157.061.000.000', '--'),
    ('157.062.000.000', 'US'),
    ('157.063.000.000', 'JP'),
    ('157.083.000.000', 'GB'),
    ('157.085.000.000', 'AU'),
    ('157.086.000.000', 'BR'),
    ('157.087.000.000', 'US'),
    ('157.088.000.000', 'ES'),
    ('157.089.000.000', 'US'),
    ('157.092.000.000', 'AR'),
    ('157.093.000.000', 'US'),
    ('157.094.000.000', 'FI'),
    ('157.095.000.000', 'US'),
    ('157.096.000.000', 'SE'),
    ('157.097.000.000', 'CA'),
    ('157.098.000.000', 'US'),
    ('157.099.000.000', 'FR'),
    ('157.100.000.000', 'EC'),
    ('157.101.000.000', 'JP'),
    ('157.121.000.000', 'US'),
    ('157.122.000.000', '--'),
    ('157.123.000.000', 'US'),
    ('157.124.000.000', 'FI'),
    ('157.125.000.000', 'SE'),
    ('157.126.000.000', 'US'),
    ('157.128.000.000', 'AU'),
    ('157.129.000.000', 'FI'),
    ('157.130.000.000', 'US'),
    ('157.136.000.000', 'FR'),
    ('157.137.000.000', 'US'),
    ('157.138.000.000', 'IT'),
    ('157.139.000.000', 'US'),
    ('157.140.000.000', 'GB'),
    ('157.141.000.000', 'US'),
    ('157.144.000.000', 'FI'),
    ('157.145.000.000', 'US'),
    ('157.155.000.000', 'AU'),
    ('157.156.000.000', 'US'),
    ('157.157.000.000', 'IS'),
    ('157.158.000.000', 'PL'),
    ('157.159.000.000', 'FR'),
    ('157.160.000.000', 'US'),
    ('157.161.000.000', 'CH'),
    ('157.162.000.000', 'DE'),
    ('157.164.000.000', 'BE'),
    ('157.165.000.000', 'US'),
    ('157.167.000.000', 'AT'),
    ('157.169.000.000', 'FR'),
    ('157.170.000.000', 'US'),
    ('157.171.000.000', 'SE'),
    ('157.172.000.000', 'FR'),
    ('157.173.000.000', 'GB'),
    ('157.174.000.000', 'US'),
    ('157.177.000.000', 'AT'),
    ('157.178.000.000', 'US'),
    ('157.179.000.000', 'TH'),
    ('157.180.000.000', 'SE'),
    ('157.181.000.000', 'HU'),
    ('157.182.000.000', 'US'),
    ('157.186.000.000', 'RU'),
    ('157.187.000.000', 'US'),
    ('157.190.000.000', 'IE'),
    ('157.191.000.000', 'US'),
    ('157.192.000.000', 'JP'),
    ('157.193.000.000', 'BE'),
    ('157.194.000.000', 'US'),
    ('157.197.000.000', 'KR'),
    ('157.198.000.000', 'US'),
    ('157.200.000.000', 'FI'),
    ('157.201.000.000', 'US'),
    ('157.203.000.000', 'GB'),
    ('157.204.000.000', 'US'),
    ('157.205.000.000', 'JP'),
    ('157.206.000.000', 'US'),
    ('157.211.000.000', 'AU'),
    ('157.212.000.000', 'US'),
    ('157.227.000.000', 'IN'),
    ('157.228.000.000', 'GB'),
    ('157.229.000.000', 'US'),
    ('157.236.000.000', 'GB'),
    ('157.237.000.000', 'NO'),
    ('157.238.000.000', 'US'),
    ('157.243.000.000', 'FR'),
    ('157.244.000.000', 'CA'),
    ('157.245.000.000', 'US'),
    ('157.245.048.000', 'AU'),
    ('157.245.064.000', 'US'),
    ('157.247.000.000', 'AT'),
    ('157.248.000.000', 'US'),
    ('157.249.000.000', 'NO'),
    ('157.250.000.000', 'US'),
    ('157.253.000.000', 'CO'),
    ('157.254.000.000', 'US'),
    ('157.255.000.000', '--'),
    ('158.000.000.000', 'US'),
    ('158.036.000.000', 'NO'),
    ('158.040.000.000', 'AU'),
    ('158.041.000.000', 'GB'),
    ('158.042.000.000', 'ES'),
    ('158.043.000.000', 'GB'),
    ('158.044.000.000', 'KR'),
    ('158.045.000.000', 'AU'),
    ('158.046.000.000', '--'),
    ('158.047.000.000', 'IT'),
    ('158.048.000.000', 'US'),
    ('158.049.000.000', 'ES'),
    ('158.050.000.000', 'FR'),
    ('158.051.000.000', 'CA'),
    ('158.052.000.000', 'US'),
    ('158.054.000.000', 'AU'),
    ('158.055.000.000', 'US'),
    ('158.064.000.000', 'LU'),
    ('158.065.000.000', 'US'),
    ('158.066.000.000', 'PL'),
    ('158.067.000.000', 'US'),
    ('158.075.000.000', 'PL'),
    ('158.076.000.000', 'US'),
    ('158.089.000.000', 'AU'),
    ('158.090.000.000', 'FI'),
    ('158.091.000.000', 'US'),
    ('158.092.000.000', 'SE'),
    ('158.093.000.000', 'US'),
    ('158.094.000.000', 'GB'),
    ('158.095.000.000', 'US'),
    ('158.097.000.000', 'MX'),
    ('158.098.000.000', 'US'),
    ('158.099.000.000', 'ES'),
    ('158.100.000.000', 'US'),
    ('158.102.000.000', 'IT'),
    ('158.103.000.000', 'US'),
    ('158.105.000.000', 'SE'),
    ('158.106.000.000', 'US'),
    ('158.108.000.000', 'TH'),
    ('158.109.000.000', 'ES'),
    ('158.110.000.000', 'IT'),
    ('158.111.000.000', 'US'),
    ('158.112.000.000', 'NO'),
    ('158.113.000.000', 'US'),
    ('158.116.252.000', 'FR'),
    ('158.116.253.000', 'US'),
    ('158.119.000.000', 'GB'),
    ('158.120.000.000', 'US'),
    ('158.124.000.000', 'GB'),
    ('158.126.000.000', 'SE'),
    ('158.127.000.000', 'FI'),
    ('158.128.000.000', 'CA'),
    ('158.129.000.000', 'LT'),
    ('158.130.000.000', 'US'),
    ('158.131.000.000', 'FI'),
    ('158.132.000.000', 'HK'),
    ('158.133.000.000', 'CH'),
    ('158.134.000.000', 'US'),
    ('158.139.000.000', 'CA'),
    ('158.140.000.000', 'US'),
    ('158.141.000.000', 'CA'),
    ('158.142.000.000', 'US'),
    ('158.143.000.000', 'GB'),
    ('158.144.000.000', 'IN'),
    ('158.145.000.000', 'US'),
    ('158.148.000.000', '--'),
    ('158.149.000.000', 'NO'),
    ('158.151.000.000', 'US'),
    ('158.152.000.000', 'GB'),
    ('158.153.000.000', 'US'),
    ('158.156.000.000', 'FR'),
    ('158.157.000.000', 'US'),
    ('158.160.000.000', 'VE'),
    ('158.161.000.000', 'BN'),
    ('158.162.000.000', 'PT'),
    ('158.163.000.000', 'CA'),
    ('158.164.000.000', 'US'),
    ('158.166.000.000', 'LU'),
    ('158.170.000.000', 'CL'),
    ('158.171.000.000', 'US'),
    ('158.172.000.000', 'ES'),
    ('158.173.000.000', 'NL'),
    ('158.174.000.000', 'GB'),
    ('158.182.000.000', 'HK'),
    ('158.183.000.000', 'US'),
    ('158.190.000.000', 'FR'),
    ('158.193.000.000', 'SK'),
    ('158.194.000.000', 'CZ'),
    ('158.195.000.000', 'SK'),
    ('158.196.000.000', 'CZ'),
    ('158.197.000.000', 'SK'),
    ('158.198.000.000', 'JP'),
    ('158.218.000.000', 'GB'),
    ('158.219.000.000', 'US'),
    ('158.220.000.000', 'CH'),
    ('158.221.000.000', 'US'),
    ('158.223.000.000', 'GB'),
    ('158.224.000.000', 'US'),
    ('158.225.000.000', 'DE'),
    ('158.226.000.000', 'CH'),
    ('158.227.000.000', 'ES'),
    ('158.228.000.000', 'US'),
    ('158.230.000.000', 'GB'),
    ('158.231.000.000', 'FR'),
    ('158.232.000.000', 'CH'),
    ('158.233.000.000', 'FI'),
    ('158.234.000.000', 'GB'),
    ('158.235.000.000', 'US'),
    ('158.248.000.000', 'SE'),
    ('158.249.000.000', 'HU'),
    ('158.250.000.000', 'DE'),
    ('158.251.000.000', 'CL'),
    ('158.252.000.000', 'US'),
    ('159.006.000.000', 'CA'),
    ('159.007.000.000', 'SE'),
    ('159.008.000.000', 'CH'),
    ('159.009.000.000', 'US'),
    ('159.012.000.000', 'CH'),
    ('159.013.000.000', 'AU'),
    ('159.014.000.000', 'US'),
    ('159.015.000.000', 'GB'),
    ('159.016.000.000', 'MX'),
    ('159.017.000.000', 'US'),
    ('159.018.000.000', 'CA'),
    ('159.019.000.000', 'US'),
    ('159.020.000.000', 'BE'),
    ('159.021.000.000', 'US'),
    ('159.022.000.000', 'CH'),
    ('159.023.000.000', 'ES'),
    ('159.024.000.000', 'US'),
    ('159.025.000.000', 'DE'),
    ('159.026.000.000', 'US'),
    ('159.029.000.000', 'CH'),
    ('159.030.000.000', 'GB'),
    ('159.031.000.000', 'FR'),
    ('159.032.000.000', 'CA'),
    ('159.034.000.000', 'GB'),
    ('159.035.000.000', 'US'),
    ('159.038.000.000', 'SE'),
    ('159.039.000.000', 'US'),
    ('159.046.000.000', 'NL'),
    ('159.047.000.000', 'US'),
    ('159.050.000.000', 'FR'),
    ('159.051.000.000', 'DE'),
    ('159.052.000.000', 'AU'),
    ('159.053.000.000', 'US'),
    ('159.055.000.000', 'CA'),
    ('159.056.000.000', 'US'),
    ('159.058.000.000', 'NO'),
    ('159.059.000.000', 'US'),
    ('159.059.007.000', 'GB'),
    ('159.059.008.000', 'US'),
    ('159.060.000.000', 'NL'),
    ('159.061.000.000', 'US'),
    ('159.072.000.000', 'SE'),
    ('159.073.000.000', 'AU'),
    ('159.074.000.000', 'US'),
    ('159.080.000.000', 'JP'),
    ('159.081.000.000', 'NO'),
    ('159.082.000.000', 'US'),
    ('159.084.000.000', 'FR'),
    ('159.085.000.000', 'US'),
    ('159.086.000.000', '--'),
    ('159.087.000.000', 'US'),
    ('159.089.000.000', 'CA'),
    ('159.090.000.000', 'VE'),
    ('159.091.000.000', 'US'),
    ('159.092.000.000', 'GB'),
    ('159.093.000.000', 'RU'),
    ('159.094.000.000', 'US'),
    ('159.095.000.000', 'FR'),
    ('159.096.000.000', 'US'),
    ('159.100.000.000', 'GB'),
    ('159.102.000.000', 'US'),
    ('159.103.000.000', 'CH'),
    ('159.103.208.000', 'NL'),
    ('159.103.209.000', 'CH'),
    ('159.104.000.000', 'GB'),
    ('159.105.000.000', 'US'),
    ('159.107.000.000', 'SE'),
    ('159.108.000.000', 'US'),
    ('159.109.000.000', 'FR'),
    ('159.110.000.000', 'US'),
    ('159.111.000.000', 'AU'),
    ('159.112.000.000', 'US'),
    ('159.114.000.000', 'GB'),
    ('159.115.000.000', 'US'),
    ('159.117.000.000', 'NZ'),
    ('159.118.000.000', 'US'),
    ('159.122.000.000', 'CH'),
    ('159.123.000.000', 'US'),
    ('159.128.000.000', 'CM'),
    ('159.129.000.000', 'US'),
    ('159.130.000.000', 'NO'),
    ('159.131.000.000', 'US'),
    ('159.134.000.000', 'IE'),
    ('159.135.000.000', 'US'),
    ('159.144.000.000', 'SE'),
    ('159.145.000.000', 'US'),
    ('159.146.000.000', '--'),
    ('159.147.000.000', 'GB'),
    ('159.148.000.000', 'LV'),
    ('159.149.000.000', 'IT'),
    ('159.150.000.000', 'US'),
    ('159.151.000.000', 'FR'),
    ('159.152.000.000', 'FI'),
    ('159.153.000.000', 'US'),
    ('159.154.000.000', 'DE'),
    ('159.155.000.000', 'US'),
    ('159.156.000.000', 'GB'),
    ('159.157.000.000', 'US'),
    ('159.159.000.000', 'CA'),
    ('159.160.000.000', '--'),
    ('159.161.000.000', 'US'),
    ('159.162.000.000', 'NO'),
    ('159.163.000.000', 'CA'),
    ('159.164.000.000', 'US'),
    ('159.167.000.000', 'GB'),
    ('159.168.000.000', 'CH'),
    ('159.169.000.000', 'US'),
    ('159.170.000.000', 'GB'),
    ('159.171.000.000', 'NO'),
    ('159.172.000.000', 'US'),
    ('159.173.000.000', 'FR'),
    ('159.174.000.000', 'US'),
    ('159.175.000.000', 'CA'),
    ('159.176.000.000', 'US'),
    ('159.177.000.000', 'CA'),
    ('159.178.000.000', 'US'),
    ('159.179.000.000', 'CH'),
    ('159.180.000.000', 'GB'),
    ('159.181.000.000', 'US'),
    ('159.190.000.000', 'SE'),
    ('159.191.000.000', 'US'),
    ('159.193.000.000', 'SE'),
    ('159.194.000.000', 'NO'),
    ('159.195.000.000', 'DK'),
    ('159.196.000.000', 'AU'),
    ('159.197.000.000', 'GB'),
    ('159.198.000.000', 'US'),
    ('159.200.000.000', 'SE'),
    ('159.201.000.000', 'US'),
    ('159.205.000.000', '--'),
    ('159.206.000.000', 'CA'),
    ('159.207.000.000', 'AU'),
    ('159.208.000.000', 'CA'),
    ('159.209.000.000', 'US'),
    ('159.210.000.000', 'IT'),
    ('159.211.000.000', 'JP'),
    ('159.212.000.000', 'US'),
    ('159.213.000.000', 'IT'),
    ('159.214.000.000', 'US'),
    ('159.216.000.000', 'NO'),
    ('159.217.000.000', 'FR'),
    ('159.218.000.000', 'US'),
    ('159.219.000.000', 'GB'),
    ('159.220.000.000', 'US'),
    ('159.224.000.000', '--'),
    ('159.225.000.000', 'US'),
    ('159.226.000.000', 'CN'),
    ('159.227.000.000', 'US'),
    ('159.228.000.000', 'JP'),
    ('159.229.000.000', 'US'),
    ('159.231.000.000', 'CA'),
    ('159.232.000.000', 'CH'),
    ('159.233.000.000', 'US'),
    ('159.236.000.000', 'GB'),
    ('159.237.000.000', 'ES'),
    ('159.238.000.000', 'US'),
    ('159.239.000.000', 'GB'),
    ('159.240.000.000', 'US'),
    ('159.241.000.000', 'CH'),
    ('159.242.000.000', 'US'),
    ('159.244.000.000', 'GB'),
    ('159.246.000.000', 'US'),
    ('159.248.000.000', 'AU'),
    ('159.249.000.000', 'CA'),
    ('159.250.000.000', 'US'),
    ('159.253.000.000', '--'),
    ('159.254.000.000', 'GB'),
    ('159.255.000.000', '--'),
    ('160.000.000.000', 'US'),
    ('160.004.000.000', 'NZ'),
    ('160.005.000.000', 'GB'),
    ('160.006.000.000', 'IE'),
    ('160.007.000.000', 'US'),
    ('160.008.000.000', 'SE'),
    ('160.009.000.000', 'GB'),
    ('160.010.000.000', 'US'),
    ('160.011.000.000', 'JP'),
    ('160.031.000.000', 'US'),
    ('160.038.000.000', 'GB'),
    ('160.039.000.000', 'US'),
    ('160.040.000.000', 'GR'),
    ('160.041.000.000', 'US'),
    ('160.044.000.000', 'DE'),
    ('160.052.000.000', 'AT'),
    ('160.053.000.000', 'CH'),
    ('160.054.000.000', 'DE'),
    ('160.059.000.000', 'CH'),
    ('160.060.000.000', 'DE'),
    ('160.061.000.000', 'CH'),
    ('160.064.000.000', 'AU'),
    ('160.065.000.000', 'US'),
    ('160.066.000.000', 'IT'),
    ('160.067.000.000', 'NO'),
    ('160.069.000.000', 'US'),
    ('160.070.000.000', 'DE'),
    ('160.071.000.000', 'FI'),
    ('160.072.000.000', 'CA'),
    ('160.073.000.000', 'US'),
    ('160.074.000.000', 'JP'),
    ('160.075.000.000', 'TR'),
    ('160.076.000.000', 'US'),
    ('160.078.000.000', 'IT'),
    ('160.079.000.000', 'US'),
    ('160.080.000.000', 'IT'),
    ('160.081.000.000', 'US'),
    ('160.085.000.000', 'CH'),
    ('160.086.000.000', 'US'),
    ('160.092.000.000', 'FR'),
    ('160.093.000.000', 'US'),
    ('160.096.000.000', 'SG'),
    ('160.097.000.000', 'IT'),
    ('160.098.000.000', 'CH'),
    ('160.099.000.000', 'YU'),
    ('160.100.000.000', 'GB'),
    ('160.101.000.000', 'US'),
    ('160.103.000.000', 'FR'),
    ('160.104.000.000', 'GB'),
    ('160.105.000.000', '--'),
    ('160.106.000.000', 'CA'),
    ('160.107.000.000', 'US'),
    ('160.109.000.000', 'GB'),
    ('160.111.000.000', 'US'),
    ('160.113.000.000', '--'),
    ('160.114.000.000', 'HU'),
    ('160.115.000.000', 'ZA'),
    ('160.117.000.000', 'US'),
    ('160.118.000.000', 'ZA'),
    ('160.119.000.000', '--'),
    ('160.120.000.000', 'ZA'),
    ('160.125.000.000', 'US'),
    ('160.160.000.000', '--'),
    ('160.180.000.000', 'IT'),
    ('160.181.000.000', '--'),
    ('160.184.000.000', 'JP'),
    ('160.205.000.000', 'US'),
    ('160.206.000.000', 'AU'),
    ('160.207.000.000', 'US'),
    ('160.210.000.000', 'IS'),
    ('160.211.000.000', 'DE'),
    ('160.212.000.000', 'US'),
    ('160.213.000.000', 'GB'),
    ('160.214.000.000', 'ES'),
    ('160.215.000.000', 'JP'),
    ('160.216.000.000', 'CZ'),
    ('160.219.000.000', 'CH'),
    ('160.220.000.000', 'IT'),
    ('160.221.000.000', 'BE'),
    ('160.222.000.000', 'AU'),
    ('160.223.000.000', 'CA'),
    ('160.224.000.000', '--'),
    ('160.227.000.000', 'US'),
    ('160.228.000.000', 'FR'),
    ('160.229.000.000', 'US'),
    ('160.233.000.000', 'JP'),
    ('160.253.000.000', 'US'),
    ('160.255.000.000', '--'),
    ('161.001.000.000', 'US'),
    ('161.002.000.000', 'GB'),
    ('161.003.000.000', 'FR'),
    ('161.004.000.000', 'NO'),
    ('161.005.000.000', 'AT'),
    ('161.006.000.000', 'US'),
    ('161.008.000.000', 'RU'),
    ('161.009.000.000', 'TR'),
    ('161.010.000.000', '--'),
    ('161.011.000.000', 'US'),
    ('161.012.000.000', 'GB'),
    ('161.013.000.000', 'US'),
    ('161.017.000.000', 'GB'),
    ('161.018.000.000', '--'),
    ('161.019.000.000', 'CA'),
    ('161.020.000.000', 'CH'),
    ('161.021.000.000', 'US'),
    ('161.023.000.000', 'GB'),
    ('161.024.000.000', 'BR'),
    ('161.025.000.000', 'CL'),
    ('161.026.000.000', 'US'),
    ('161.027.000.000', 'IT'),
    ('161.028.000.000', 'US'),
    ('161.029.000.000', 'NZ'),
    ('161.030.000.000', 'GB'),
    ('161.031.000.000', 'US'),
    ('161.035.000.000', 'GB'),
    ('161.036.000.000', 'US'),
    ('161.037.000.000', 'ES'),
    ('161.038.000.000', 'US'),
    ('161.041.000.000', 'FI'),
    ('161.042.000.000', 'DE'),
    ('161.043.000.000', 'AU'),
    ('161.044.000.000', 'US'),
    ('161.048.000.000', 'FR'),
    ('161.049.000.000', 'US'),
    ('161.050.000.000', 'AU'),
    ('161.051.000.000', 'US'),
    ('161.051.224.000', 'GB'),
    ('161.051.239.000', '--'),
    ('161.051.240.000', 'US'),
    ('161.052.000.000', 'SE'),
    ('161.053.000.000', 'HR'),
    ('161.054.000.000', 'SE'),
    ('161.055.000.000', 'US'),
    ('161.056.000.000', '--'),
    ('161.057.000.000', 'US'),
    ('161.059.000.000', 'BE'),
    ('161.060.000.000', 'US'),
    ('161.062.000.000', 'CH'),
    ('161.063.000.000', 'US'),
    ('161.064.000.000', 'HK'),
    ('161.065.000.000', 'NZ'),
    ('161.067.000.000', 'ES'),
    ('161.068.000.000', 'US'),
    ('161.071.000.000', 'GB'),
    ('161.072.000.000', 'ES'),
    ('161.073.000.000', 'GB'),
    ('161.075.000.000', 'JP'),
    ('161.076.000.000', 'GB'),
    ('161.077.000.000', 'US'),
    ('161.078.000.000', 'CH'),
    ('161.079.000.000', 'BR'),
    ('161.080.000.000', 'US'),
    ('161.083.000.000', 'NL'),
    ('161.093.000.000', 'JP'),
    ('161.097.000.000', 'US'),
    ('161.104.000.000', 'FR'),
    ('161.107.000.000', 'US'),
    ('161.110.000.000', 'AT'),
    ('161.111.000.000', 'ES'),
    ('161.112.000.000', 'GB'),
    ('161.113.000.000', 'US'),
    ('161.116.000.000', 'ES'),
    ('161.117.000.000', 'AU'),
    ('161.118.000.000', 'JP'),
    ('161.119.000.000', 'US'),
    ('161.122.000.000', 'KR'),
    ('161.123.000.000', 'BG'),
    ('161.124.000.000', 'US'),
    ('161.126.000.000', 'SG'),
    ('161.127.000.000', 'US'),
    ('161.131.000.000', 'CL'),
    ('161.132.000.000', 'PE'),
    ('161.133.000.000', 'US'),
    ('161.138.000.000', '--'),
    ('161.139.000.000', 'MY'),
    ('161.140.000.000', '--'),
    ('161.141.000.000', 'CA'),
    ('161.142.000.000', 'MY'),
    ('161.143.000.000', 'AU'),
    ('161.144.000.000', 'US'),
    ('161.146.000.000', 'AU'),
    ('161.147.000.000', 'IT'),
    ('161.148.000.000', 'BR'),
    ('161.149.000.000', 'US'),
    ('161.152.000.000', 'AU'),
    ('161.153.000.000', 'US'),
    ('161.158.000.000', 'NL'),
    ('161.159.000.000', 'US'),
    ('161.184.000.000', 'CA'),
    ('161.185.000.000', 'US'),
    ('161.187.000.000', 'CA'),
    ('161.188.000.000', 'US'),
    ('161.190.000.000', 'AR'),
    ('161.191.000.000', 'US'),
    ('161.196.000.000', 'VE'),
    ('161.197.000.000', 'US'),
    ('161.200.000.000', 'TH'),
    ('161.201.000.000', 'US'),
    ('161.207.000.000', 'CN'),
    ('161.208.000.000', 'US'),
    ('161.212.000.000', 'NZ'),
    ('161.213.000.000', 'US'),
    ('161.216.000.000', 'CA'),
    ('161.217.000.000', 'US'),
    ('161.229.000.000', 'SG'),
    ('161.230.000.000', 'GB'),
    ('161.231.000.000', 'US'),
    ('161.238.000.000', 'CL'),
    ('161.239.000.000', 'US'),
    ('161.246.000.000', 'TH'),
    ('161.247.000.000', 'US'),
    ('161.248.000.000', 'JP'),
    ('161.249.000.000', 'US'),
    ('161.252.000.000', 'KW'),
    ('161.253.000.000', 'US'),
    ('161.255.000.000', '--'),
    ('162.000.000.000', 'US'),
    ('162.004.000.000', 'JP'),
    ('162.005.000.000', 'US'),
    ('162.011.000.000', 'GB'),
    ('162.012.000.000', 'US'),
    ('162.021.000.000', 'CH'),
    ('162.022.000.000', 'US'),
    ('162.023.000.000', 'CH'),
    ('162.024.000.000', 'US'),
    ('162.025.000.000', 'AT'),
    ('162.026.000.000', 'GB'),
    ('162.027.000.000', 'US'),
    ('162.038.000.000', 'FR'),
    ('162.039.000.000', 'US'),
    ('162.053.000.000', 'CA'),
    ('162.054.000.000', 'US'),
    ('162.072.000.000', '--'),
    ('162.073.000.000', 'CA'),
    ('162.074.000.000', 'US'),
    ('162.085.000.000', 'CA'),
    ('162.086.000.000', 'CH'),
    ('162.087.000.000', 'US'),
    ('162.104.000.000', '--'),
    ('162.105.000.000', 'CN'),
    ('162.106.000.000', 'CA'),
    ('162.107.000.000', 'US'),
    ('162.112.000.000', 'NZ'),
    ('162.113.000.000', 'US'),
    ('162.122.000.000', 'VE'),
    ('162.123.000.000', 'US'),
    ('162.139.000.000', 'CA'),
    ('162.140.000.000', 'US'),
    ('162.144.000.000', 'AU'),
    ('162.148.000.000', '--'),
    ('163.001.000.000', 'GB'),
    ('163.002.000.000', 'US'),
    ('163.003.000.000', 'SE'),
    ('163.004.000.000', 'US'),
    ('163.005.000.000', 'FR'),
    ('163.006.000.000', 'US'),
    ('163.007.000.000', 'NZ'),
    ('163.008.000.000', 'AU'),
    ('163.009.000.000', 'FR'),
    ('163.010.000.000', 'AR'),
    ('163.011.000.000', 'US'),
    ('163.013.000.000', 'TW'),
    ('163.033.000.000', 'US'),
    ('163.034.000.000', 'NO'),
    ('163.035.000.000', 'US'),
    ('163.042.000.000', 'JP'),
    ('163.062.000.000', 'FR'),
    ('163.117.000.000', 'ES'),
    ('163.118.000.000', 'US'),
    ('163.119.000.000', 'GB'),
    ('163.120.000.000', 'US'),
    ('163.121.000.000', 'EG'),
    ('163.122.000.000', 'IN'),
    ('163.123.000.000', 'CA'),
    ('163.124.000.000', 'US'),
    ('163.127.000.000', 'AU'),
    ('163.129.000.000', 'US'),
    ('163.130.000.000', 'JP'),
    ('163.150.000.000', 'US'),
    ('163.152.000.000', 'KR'),
    ('163.153.000.000', 'US'),
    ('163.155.000.000', 'CA'),
    ('163.156.000.000', 'GB'),
    ('163.157.000.000', 'SE'),
    ('163.158.000.000', 'CH'),
    ('163.159.000.000', 'SI'),
    ('163.160.000.000', 'GB'),
    ('163.161.000.000', 'CH'),
    ('163.162.000.000', 'IT'),
    ('163.163.000.000', 'BE'),
    ('163.164.000.000', 'GB'),
    ('163.165.000.000', 'BE'),
    ('163.165.192.000', 'DE'),
    ('163.165.200.000', 'NL'),
    ('163.165.204.000', 'DE'),
    ('163.166.000.000', 'GB'),
    ('163.168.000.000', 'CH'),
    ('163.169.000.000', 'GB'),
    ('163.173.000.000', 'FR'),
    ('163.174.000.000', 'NO'),
    ('163.175.000.000', 'NL'),
    ('163.176.000.000', 'US'),
    ('163.177.000.000', '--'),
    ('163.178.000.000', 'CR'),
    ('163.179.000.000', 'US'),
    ('163.180.000.000', 'KR'),
    ('163.181.000.000', 'US'),
    ('163.189.000.000', 'AU'),
    ('163.190.000.000', 'US'),
    ('163.195.000.000', 'ZA'),
    ('163.204.000.000', 'US'),
    ('163.208.000.000', 'JP'),
    ('163.228.000.000', 'US'),
    ('163.232.000.000', 'AU'),
    ('163.234.000.000', 'US'),
    ('163.239.000.000', 'KR'),
    ('163.240.000.000', 'US'),
    ('163.247.000.000', 'CL'),
    ('163.248.000.000', 'US'),
    ('163.250.000.000', 'CL'),
    ('163.251.000.000', 'US'),
    ('164.000.000.000', 'NL'),
    ('164.001.000.000', 'FR'),
    ('164.003.000.000', 'AT'),
    ('164.004.000.000', 'SE'),
    ('164.005.000.000', 'FI'),
    ('164.006.000.000', 'GB'),
    ('164.007.000.000', 'FR'),
    ('164.008.000.000', 'SI'),
    ('164.009.000.000', 'SE'),
    ('164.011.000.000', 'GB'),
    ('164.013.000.000', 'FI'),
    ('164.014.000.000', 'CH'),
    ('164.015.000.000', 'BE'),
    ('164.016.000.000', 'DE'),
    ('164.035.000.000', 'BE'),
    ('164.036.000.000', 'GB'),
    ('164.037.000.000', 'SE'),
    ('164.038.000.000', 'GB'),
    ('164.040.000.000', 'NL'),
    ('164.041.000.000', 'BR'),
    ('164.042.000.000', 'PR'),
    ('164.043.000.000', 'JP'),
    ('164.044.000.000', 'US'),
    ('164.046.000.000', 'JP'),
    ('164.047.000.000', 'US'),
    ('164.048.000.000', 'SE'),
    ('164.049.000.000', 'US'),
    ('164.053.000.000', 'AU'),
    ('164.053.055.000', 'HK'),
    ('164.053.056.000', 'AU'),
    ('164.054.000.000', 'US'),
    ('164.059.000.000', 'DE'),
    ('164.062.000.000', 'US'),
    ('164.069.000.000', 'JP'),
    ('164.072.000.000', 'US'),
    ('164.073.000.000', 'UY'),
    ('164.074.000.000', 'US'),
    ('164.075.000.000', 'AU'),
    ('164.076.000.000', 'US'),
    ('164.077.000.000', 'CL'),
    ('164.078.000.000', 'SG'),
    ('164.079.000.000', 'US'),
    ('164.080.000.000', 'AU'),
    ('164.081.000.000', 'FR'),
    ('164.082.000.000', 'US'),
    ('164.085.000.000', 'BR'),
    ('164.086.000.000', 'US'),
    ('164.088.000.000', 'ZA'),
    ('164.089.000.000', 'US'),
    ('164.096.000.000', 'CL'),
    ('164.097.000.000', 'AU'),
    ('164.098.000.000', 'CL'),
    ('164.099.000.000', 'US'),
    ('164.100.000.000', 'IN'),
    ('164.101.000.000', 'US'),
    ('164.102.000.000', 'CA'),
    ('164.103.000.000', 'US'),
    ('164.108.000.000', 'AU'),
    ('164.109.000.000', 'US'),
    ('164.112.000.000', 'AU'),
    ('164.113.000.000', 'US'),
    ('164.115.000.000', 'TH'),
    ('164.116.000.000', 'US'),
    ('164.124.000.000', 'KR'),
    ('164.126.000.000', '--'),
    ('164.128.000.000', 'CH'),
    ('164.129.000.000', 'FR'),
    ('164.130.000.000', 'IT'),
    ('164.131.000.000', 'FR'),
    ('164.132.000.000', 'IT'),
    ('164.133.000.000', 'DE'),
    ('164.134.000.000', 'GB'),
    ('164.135.000.000', 'SE'),
    ('164.136.000.000', 'GB'),
    ('164.138.000.000', 'FR'),
    ('164.139.000.000', 'DE'),
    ('164.140.000.000', 'NL'),
    ('164.141.000.000', 'FI'),
    ('164.142.000.000', 'IT'),
    ('164.143.000.000', 'GB'),
    ('164.143.248.000', 'US'),
    ('164.143.252.000', 'GB'),
    ('164.144.000.000', 'US'),
    ('164.146.000.000', 'ZA'),
    ('164.152.000.000', 'US'),
    ('164.155.000.000', 'ZA'),
    ('164.156.000.000', 'US'),
    ('164.160.000.000', 'JP'),
    ('164.164.000.000', 'IN'),
    ('164.165.000.000', 'US'),
    ('164.166.000.000', 'CA'),
    ('164.167.000.000', 'US'),
    ('164.172.000.000', '--'),
    ('164.178.000.000', 'CA'),
    ('164.179.000.000', 'US'),
    ('165.000.000.000', '--'),
    ('165.001.000.000', 'US'),
    ('165.003.000.000', 'ZA'),
    ('165.006.000.000', 'US'),
    ('165.008.000.000', 'ZA'),
    ('165.012.000.000', 'AU'),
    ('165.013.000.000', 'US'),
    ('165.014.000.000', 'JP'),
    ('165.019.000.000', 'US'),
    ('165.021.000.000', 'SG'),
    ('165.022.000.000', 'US'),
    ('165.023.000.000', 'CA'),
    ('165.024.000.000', 'US'),
    ('165.025.000.000', 'ZA'),
    ('165.026.000.000', 'US'),
    ('165.031.000.000', 'AU'),
    ('165.032.000.000', 'US'),
    ('165.067.000.000', 'AU'),
    ('165.068.000.000', 'US'),
    ('165.069.000.000', 'AU'),
    ('165.070.000.000', 'US'),
    ('165.076.000.000', 'JP'),
    ('165.077.000.000', 'US'),
    ('165.078.000.000', 'CA'),
    ('165.079.000.000', 'US'),
    ('165.084.000.000', 'NZ'),
    ('165.085.000.000', 'US'),
    ('165.086.000.000', 'AU'),
    ('165.087.000.000', 'US'),
    ('165.093.000.000', 'JP'),
    ('165.094.000.000', 'US'),
    ('165.096.000.000', 'JP'),
    ('165.097.000.000', 'US'),
    ('165.098.000.000', 'NI'),
    ('165.099.000.000', 'JP'),
    ('165.103.000.000', 'US'),
    ('165.108.000.000', 'JP'),
    ('165.109.000.000', 'US'),
    ('165.114.000.000', 'NL'),
    ('165.115.000.000', 'CA'),
    ('165.116.000.000', 'US'),
    ('165.118.000.000', 'AU'),
    ('165.119.000.000', 'US'),
    ('165.132.000.000', 'KR'),
    ('165.134.000.000', 'US'),
    ('165.136.000.000', 'GB'),
    ('165.137.000.000', 'US'),
    ('165.141.000.000', 'KR'),
    ('165.142.000.000', 'AU'),
    ('165.143.000.000', 'ZA'),
    ('165.150.000.000', 'US'),
    ('165.154.000.000', 'CA'),
    ('165.155.000.000', 'US'),
    ('165.165.000.000', 'ZA'),
    ('165.166.000.000', 'US'),
    ('165.172.000.000', 'CA'),
    ('165.173.000.000', 'US'),
    ('165.178.000.000', 'CA'),
    ('165.179.000.000', 'US'),
    ('165.180.000.000', 'ZA'),
    ('165.181.000.000', 'US'),
    ('165.182.000.000', 'CL'),
    ('165.184.000.000', 'US'),
    ('165.185.000.000', 'CA'),
    ('165.186.000.000', 'KR'),
    ('165.187.000.000', 'AU'),
    ('165.188.000.000', 'US'),
    ('165.191.000.000', 'AU'),
    ('165.192.000.000', 'US'),
    ('165.194.000.000', 'KR'),
    ('165.195.000.000', 'US'),
    ('165.202.000.000', 'HK'),
    ('165.203.000.000', 'US'),
    ('165.205.000.000', 'NZ'),
    ('165.206.000.000', 'US'),
    ('165.209.000.000', 'TH'),
    ('165.210.000.000', '--'),
    ('165.212.000.000', 'US'),
    ('165.213.000.000', 'KR'),
    ('165.214.000.000', 'US'),
    ('165.220.000.000', 'PH'),
    ('165.221.000.000', 'US'),
    ('165.222.000.000', 'HK'),
    ('165.223.000.000', 'US'),
    ('165.228.000.000', 'AU'),
    ('165.229.000.000', 'KR'),
    ('165.230.000.000', 'US'),
    ('165.231.000.000', 'GN'),
    ('165.232.000.000', 'US'),
    ('165.233.000.000', 'ZA'),
    ('165.234.000.000', 'US'),
    ('165.240.000.000', 'AU'),
    ('165.241.000.000', 'JP'),
    ('165.243.000.000', 'KR'),
    ('165.245.000.000', 'US'),
    ('165.246.000.000', 'KR'),
    ('165.247.000.000', 'US'),
    ('166.049.128.000', 'GB'),
    ('166.050.000.000', 'US'),
    ('166.064.000.000', 'AU'),
    ('166.065.000.000', 'NZ'),
    ('166.066.000.000', 'US'),
    ('166.075.000.000', 'CL'),
    ('166.076.000.000', 'US'),
    ('166.079.000.000', 'KR'),
    ('166.080.000.000', 'US'),
    ('166.081.000.000', 'HK'),
    ('166.082.000.000', 'US'),
    ('166.083.000.000', 'NZ'),
    ('166.084.000.000', 'US'),
    ('166.085.000.000', 'ZA'),
    ('166.086.000.000', 'US'),
    ('166.087.000.000', 'SA'),
    ('166.088.000.000', 'US'),
    ('166.100.000.000', 'JP'),
    ('166.101.000.000', 'US'),
    ('166.103.000.000', 'KR'),
    ('166.105.000.000', 'US'),
    ('166.110.000.000', 'CL'),
    ('166.111.000.000', 'CN'),
    ('166.112.000.000', 'US'),
    ('166.114.000.000', 'BO'),
    ('166.115.000.000', 'US'),
    ('166.118.000.000', 'JP'),
    ('166.120.000.000', 'AU'),
    ('166.121.000.000', 'SG'),
    ('166.122.000.000', 'US'),
    ('166.125.000.000', 'KR'),
    ('166.126.000.000', 'US'),
    ('167.011.000.000', 'CA'),
    ('167.012.000.000', 'US'),
    ('167.017.000.000', 'CA'),
    ('167.018.000.000', 'US'),
    ('167.026.000.000', 'CA'),
    ('167.027.000.000', 'US'),
    ('167.028.000.000', 'CL'),
    ('167.029.000.000', 'US'),
    ('167.030.000.000', 'AU'),
    ('167.031.000.000', 'US'),
    ('167.032.000.000', 'CA'),
    ('167.064.000.000', 'US'),
    ('167.074.000.000', 'CA'),
    ('167.075.000.000', 'US'),
    ('167.081.000.000', 'NL'),
    ('167.082.000.000', 'US'),
    ('167.092.000.000', 'CA'),
    ('167.093.000.000', 'US'),
    ('167.103.000.000', 'AU'),
    ('167.104.000.000', 'US'),
    ('167.108.000.000', '--'),
    ('167.109.000.000', 'US'),
    ('167.111.000.000', 'SA'),
    ('167.112.000.000', 'US'),
    ('167.123.000.000', 'AU'),
    ('167.124.000.000', 'US'),
    ('167.125.000.000', 'CA'),
    ('167.126.000.000', 'US'),
    ('167.129.000.000', 'CA'),
    ('167.130.000.000', 'AU'),
    ('167.131.000.000', 'US'),
    ('167.134.000.000', 'VE'),
    ('167.135.000.000', 'US'),
    ('167.139.000.000', 'CN'),
    ('167.140.000.000', 'US'),
    ('167.157.000.000', 'BO'),
    ('167.158.000.000', 'US'),
    ('167.162.000.000', 'AU'),
    ('167.163.000.000', 'US'),
    ('167.169.000.000', 'JP'),
    ('167.170.000.000', 'US'),
    ('167.172.000.000', 'GB'),
    ('167.173.000.000', 'US'),
    ('167.175.000.000', 'VE'),
    ('167.176.000.000', 'US'),
    ('167.179.000.000', 'NZ'),
    ('167.180.000.000', 'US'),
    ('167.189.000.000', 'AU'),
    ('167.190.000.000', 'US'),
    ('167.203.000.000', 'GB'),
    ('167.204.000.000', 'US'),
    ('167.205.000.000', 'ID'),
    ('167.206.000.000', 'US'),
    ('167.227.000.000', 'CA'),
    ('167.228.000.000', 'US'),
    ('167.252.000.000', 'AR'),
    ('167.253.000.000', 'US'),
    ('168.070.000.000', 'HK'),
    ('168.071.000.000', 'US'),
    ('168.076.000.000', 'ZA'),
    ('168.077.000.000', 'PA'),
    ('168.078.000.000', 'KR'),
    ('168.079.000.000', 'JP'),
    ('168.080.000.000', 'ZA'),
    ('168.082.000.000', 'US'),
    ('168.083.000.000', 'AR'),
    ('168.084.000.000', 'US'),
    ('168.089.000.000', 'ZA'),
    ('168.090.000.000', '--'),
    ('168.091.000.000', 'US'),
    ('168.095.000.000', 'TW'),
    ('168.096.000.000', 'AR'),
    ('168.097.000.000', 'US'),
    ('168.101.000.000', 'AR'),
    ('168.102.000.000', 'US'),
    ('168.106.000.000', 'HK'),
    ('168.107.000.000', 'US'),
    ('168.115.000.000', 'KR'),
    ('168.116.000.000', 'US'),
    ('168.120.000.000', 'TH'),
    ('168.121.000.000', '--'),
    ('168.122.000.000', 'US'),
    ('168.123.000.000', 'GU'),
    ('168.124.000.000', 'US'),
    ('168.126.000.000', 'KR'),
    ('168.127.000.000', 'US'),
    ('168.128.000.000', 'ZA'),
    ('168.129.000.000', 'US'),
    ('168.130.000.000', 'AU'),
    ('168.131.000.000', 'KR'),
    ('168.132.000.000', 'AU'),
    ('168.133.000.000', 'US'),
    ('168.134.000.000', 'AU'),
    ('168.135.000.000', 'US'),
    ('168.139.000.000', 'TR'),
    ('168.140.000.000', 'AU'),
    ('168.141.000.000', 'US'),
    ('168.142.000.000', 'ZA'),
    ('168.143.000.000', 'US'),
    ('168.144.000.000', 'CA'),
    ('168.145.000.000', 'US'),
    ('168.152.000.000', 'AU'),
    ('168.154.000.000', 'KR'),
    ('168.155.000.000', 'ZA'),
    ('168.156.000.000', 'US'),
    ('168.160.000.000', 'CN'),
    ('168.161.000.000', 'US'),
    ('168.164.000.000', 'ZA'),
    ('168.165.000.000', 'MX'),
    ('168.166.000.000', 'US'),
    ('168.167.000.000', 'ZA'),
    ('168.168.000.000', 'US'),
    ('168.172.000.000', 'ZA'),
    ('168.173.000.000', 'US'),
    ('168.176.000.000', 'CO'),
    ('168.177.000.000', 'US'),
    ('168.186.000.000', 'AU'),
    ('168.187.000.000', 'KW'),
    ('168.188.000.000', 'KR'),
    ('168.189.000.000', 'US'),
    ('168.194.000.000', '--'),
    ('168.198.000.000', 'AU'),
    ('168.199.000.000', 'US'),
    ('168.202.000.000', 'IT'),
    ('168.203.000.000', 'US'),
    ('168.206.000.000', 'ZA'),
    ('168.207.000.000', 'US'),
    ('168.209.000.000', 'ZA'),
    ('168.211.000.000', '--'),
    ('168.212.000.000', 'US'),
    ('168.217.000.000', 'AU'),
    ('168.218.000.000', 'US'),
    ('168.219.000.000', 'KR'),
    ('168.220.000.000', 'US'),
    ('168.226.000.000', 'AR'),
    ('168.227.000.000', '--'),
    ('168.229.000.000', 'US'),
    ('168.231.000.000', 'CL'),
    ('168.232.000.000', '--'),
    ('168.233.000.000', 'US'),
    ('168.234.000.000', 'GT'),
    ('168.235.000.000', 'US'),
    ('168.243.000.000', 'SV'),
    ('168.244.000.000', 'US'),
    ('168.248.000.000', 'KP'),
    ('168.250.000.000', 'US'),
    ('168.252.000.000', 'AU'),
    ('168.253.000.000', 'US'),
    ('168.255.000.000', 'MX'),
    ('169.000.000.000', 'US'),
    ('169.071.050.000', 'GB'),
    ('169.071.051.000', 'US'),
    ('169.129.000.000', 'ZA'),
    ('169.130.000.000', 'US'),
    ('169.140.000.000', 'KR'),
    ('169.141.000.000', 'US'),
    ('169.158.000.000', 'CU'),
    ('169.159.000.000', '--'),
    ('169.160.000.000', 'US'),
    ('169.201.000.000', 'AU'),
    ('169.202.000.000', 'ZA'),
    ('169.203.000.000', 'US'),
    ('169.208.000.000', 'AU'),
    ('169.222.000.000', 'JP'),
    ('169.222.160.000', 'AU'),
    ('169.223.000.000', 'TH'),
    ('169.223.255.000', '--'),
    ('169.224.000.000', 'US'),
    ('170.018.000.000', 'CL'),
    ('170.019.000.000', 'US'),
    ('170.025.000.000', 'MX'),
    ('170.026.000.000', 'US'),
    ('170.038.000.000', 'MY'),
    ('170.039.000.000', 'US'),
    ('170.051.000.000', 'AR'),
    ('170.052.000.000', 'US'),
    ('170.060.000.000', 'CH'),
    ('170.061.000.000', 'US'),
    ('170.066.000.000', 'BR'),
    ('170.067.000.000', 'US'),
    ('170.070.000.000', 'MX'),
    ('170.071.000.000', 'US'),
    ('170.080.000.000', '--'),
    ('170.084.000.000', 'US'),
    ('170.095.000.000', 'SG'),
    ('170.096.000.000', 'US'),
    ('170.155.000.000', 'AR'),
    ('170.156.000.000', 'US'),
    ('170.157.000.000', 'AU'),
    ('170.158.000.000', 'US'),
    ('170.169.000.000', 'MX'),
    ('170.170.000.000', 'US'),
    ('170.179.000.000', 'VE'),
    ('170.180.000.000', 'US'),
    ('170.210.000.000', 'AR'),
    ('170.211.000.000', 'US'),
    ('170.236.000.000', 'CH'),
    ('170.238.000.000', '--'),
    ('170.240.000.000', 'US'),
    ('170.244.000.000', '--'),
    ('170.248.000.000', 'US'),
    ('170.254.000.000', '--'),
    ('170.255.000.000', 'BE'),
    ('171.000.000.000', '--'),
    ('171.016.000.000', 'FR'),
    ('171.017.000.000', 'DE'),
    ('171.018.000.000', 'FR'),
    ('171.019.000.000', 'HU'),
    ('171.020.000.000', 'DK'),
    ('171.021.000.000', 'NL'),
    ('171.022.000.000', 'GB'),
    ('171.023.000.000', 'NO'),
    ('171.024.000.000', 'DE'),
    ('171.025.000.000', 'CH'),
    ('171.025.127.000', '--'),
    ('171.025.128.000', 'SE'),
    ('171.025.143.000', '--'),
    ('171.025.144.000', 'SE'),
    ('171.025.151.000', '--'),
    ('171.025.152.000', 'SE'),
    ('171.025.159.000', '--'),
    ('171.025.160.000', 'NO'),
    ('171.025.164.000', 'NL'),
    ('171.026.000.000', 'BE'),
    ('171.027.000.000', 'CH'),
    ('171.028.000.000', 'GB'),
    ('171.031.000.000', 'HU'),
    ('171.032.000.000', 'SE'),
    ('171.033.000.000', 'CH'),
    ('171.033.064.000', 'NL'),
    ('171.034.000.000', '--'),
    ('171.064.000.000', 'US'),
    ('171.080.000.000', '--'),
    ('171.128.000.000', 'US'),
    ('172.000.000.000', '--'),
    ('172.016.000.000', 'TW'),
    ('172.016.001.000', 'NL'),
    ('172.017.000.000', 'TW'),
    ('172.017.001.000', 'NL'),
    ('172.017.250.000', 'SG'),
    ('172.017.251.000', 'NL'),
    ('172.028.000.000', 'TW'),
    ('172.028.001.000', 'NL'),
    ('172.032.000.000', '--'),
    ('172.128.000.000', 'US'),
    ('173.000.000.000', '--'),
    ('188.000.000.000', 'EU'),
    ('188.001.000.000', 'DE'),
    ('188.002.000.000', 'EU'),
    ('189.000.000.000', '--'),
    ('191.255.000.000', 'US'),
    ('192.005.028.000', 'GB'),
    ('192.005.031.000', 'US'),
    ('192.005.036.000', 'SE'),
    ('192.005.037.000', 'US'),
    ('192.005.050.000', 'SE'),
    ('192.005.051.000', '--'),
    ('192.005.052.000', 'US'),
    ('192.005.057.000', '--'),
    ('192.005.059.000', 'FR'),
    ('192.005.063.000', 'US'),
    ('192.005.090.000', 'KR'),
    ('192.005.091.000', 'US'),
    ('192.005.096.000', 'CA'),
    ('192.005.097.000', 'IT'),
    ('192.005.098.000', 'US'),
    ('192.005.142.000', 'FR'),
    ('192.005.143.000', 'US'),
    ('192.005.144.000', 'CA'),
    ('192.005.145.000', 'DE'),
    ('192.005.146.000', 'US'),
    ('192.005.162.000', 'AT'),
    ('192.005.163.000', 'US'),
    ('192.005.204.000', 'CA'),
    ('192.005.206.000', 'US'),
    ('192.005.216.000', 'JP'),
    ('192.005.217.000', 'US'),
    ('192.005.239.000', 'GB'),
    ('192.005.240.000', 'AU'),
    ('192.005.241.000', '--'),
    ('192.005.242.000', 'US'),
    ('192.005.254.000', 'GB'),
    ('192.005.255.000', '--'),
    ('192.006.000.000', 'GB'),
    ('192.006.001.000', 'US'),
    ('192.006.004.000', 'AT'),
    ('192.006.005.000', 'US'),
    ('192.006.010.000', 'GB'),
    ('192.006.011.000', 'US'),
    ('192.006.034.000', 'GB'),
    ('192.006.035.000', 'US'),
    ('192.006.057.000', 'CH'),
    ('192.006.058.000', 'US'),
    ('192.006.059.000', 'CH'),
    ('192.006.060.000', 'US'),
    ('192.006.070.000', 'CH'),
    ('192.006.071.000', 'US'),
    ('192.006.072.000', 'DE'),
    ('192.006.073.000', 'US'),
    ('192.006.076.000', 'DE'),
    ('192.006.077.000', 'US'),
    ('192.006.084.000', 'NL'),
    ('192.006.085.000', 'US'),
    ('192.006.093.000', 'DE'),
    ('192.006.094.000', 'US'),
    ('192.006.111.000', 'FR'),
    ('192.006.112.000', 'US'),
    ('192.006.126.000', 'GB'),
    ('192.006.127.000', 'US'),
    ('192.006.141.000', 'FR'),
    ('192.006.142.000', 'US'),
    ('192.006.149.000', 'AU'),
    ('192.006.150.000', 'US'),
    ('192.006.176.000', 'DE'),
    ('192.006.177.000', 'NL'),
    ('192.006.178.000', 'US'),
    ('192.006.179.000', 'GB'),
    ('192.006.180.000', 'US'),
    ('192.012.000.000', '--'),
    ('192.012.001.000', 'GB'),
    ('192.012.002.000', '--'),
    ('192.012.003.000', 'US'),
    ('192.012.047.000', 'IT'),
    ('192.012.048.000', 'US'),
    ('192.012.054.000', 'NL'),
    ('192.012.055.000', '--'),
    ('192.012.056.000', 'US'),
    ('192.012.062.000', 'CA'),
    ('192.012.063.000', 'US'),
    ('192.012.072.000', 'GB'),
    ('192.012.074.000', 'US'),
    ('192.012.076.000', 'AU'),
    ('192.012.077.000', 'IT'),
    ('192.012.078.000', 'US'),
    ('192.012.081.000', 'DE'),
    ('192.012.082.000', 'US'),
    ('192.012.096.000', 'FR'),
    ('192.012.097.000', 'US'),
    ('192.012.098.000', 'CA'),
    ('192.012.099.000', 'GB'),
    ('192.012.100.000', 'US'),
    ('192.012.104.000', '--'),
    ('192.012.108.000', 'US'),
    ('192.012.128.000', '--'),
    ('192.012.129.000', 'CA'),
    ('192.012.130.000', 'US'),
    ('192.012.172.000', '--'),
    ('192.012.173.000', 'US'),
    ('192.012.174.000', 'CA'),
    ('192.012.184.000', 'US'),
    ('192.012.192.000', 'IT'),
    ('192.012.195.000', 'US'),
    ('192.012.215.000', 'CA'),
    ('192.012.216.000', 'US'),
    ('192.012.217.000', 'CH'),
    ('192.012.219.000', '--'),
    ('192.012.220.000', 'US'),
    ('192.012.231.000', 'GB'),
    ('192.012.232.000', 'PT'),
    ('192.012.233.000', 'US'),
    ('192.012.235.000', 'SE'),
    ('192.012.236.000', 'US'),
    ('192.012.247.000', 'CH'),
    ('192.012.248.000', 'US'),
    ('192.012.250.000', 'GB'),
    ('192.012.251.000', 'US'),
    ('192.016.123.000', 'SE'),
    ('192.016.155.000', 'CH'),
    ('192.016.167.000', 'US'),
    ('192.016.178.000', 'JP'),
    ('192.016.180.000', 'AU'),
    ('192.016.181.000', 'US'),
    ('192.016.183.000', 'NL'),
    ('192.016.203.000', 'US'),
    ('192.016.205.000', 'CA'),
    ('192.017.000.000', 'US'),
    ('192.018.195.000', 'GB'),
    ('192.018.196.000', 'US'),
    ('192.018.240.000', 'NL'),
    ('192.018.242.000', 'US'),
    ('192.025.019.000', 'DE'),
    ('192.025.020.000', 'US'),
    ('192.025.022.000', 'GB'),
    ('192.025.023.000', 'US'),
    ('192.025.033.000', 'CA'),
    ('192.025.034.000', 'US'),
    ('192.025.105.000', 'CA'),
    ('192.025.106.000', 'US'),
    ('192.025.137.000', 'NL'),
    ('192.025.138.000', 'US'),
    ('192.026.009.000', 'JP'),
    ('192.026.010.000', 'US'),
    ('192.026.028.000', 'CH'),
    ('192.026.045.000', 'GB'),
    ('192.026.046.000', 'CH'),
    ('192.026.048.000', 'US'),
    ('192.026.091.000', 'JP'),
    ('192.026.092.000', 'US'),
    ('192.026.093.000', 'JP'),
    ('192.026.095.000', 'US'),
    ('192.026.096.000', 'JP'),
    ('192.026.097.000', 'US'),
    ('192.026.098.000', '--'),
    ('192.026.100.000', 'US'),
    ('192.026.104.000', 'FI'),
    ('192.026.136.000', 'US'),
    ('192.026.137.000', '--'),
    ('192.026.144.000', 'US'),
    ('192.026.154.000', 'NL'),
    ('192.026.174.000', 'DE'),
    ('192.026.194.000', 'US'),
    ('192.026.210.000', 'CA'),
    ('192.026.213.000', 'US'),
    ('192.026.215.000', 'AU'),
    ('192.026.231.000', 'PT'),
    ('192.026.232.000', 'AU'),
    ('192.026.233.000', 'US'),
    ('192.026.234.000', 'GB'),
    ('192.026.235.000', 'CA'),
    ('192.026.236.000', 'PT'),
    ('192.026.237.000', 'AT'),
    ('192.026.239.000', 'PT'),
    ('192.026.240.000', 'US'),
    ('192.029.146.000', 'IT'),
    ('192.029.147.000', 'US'),
    ('192.030.142.000', 'CA'),
    ('192.030.143.000', 'US'),
    ('192.030.149.000', 'CA'),
    ('192.030.150.000', 'US'),
    ('192.030.188.000', 'GB'),
    ('192.030.189.000', 'US'),
    ('192.030.202.000', 'CA'),
    ('192.030.203.000', 'US'),
    ('192.030.226.000', 'CA'),
    ('192.030.227.000', 'US'),
    ('192.031.006.000', 'CA'),
    ('192.031.007.000', 'US'),
    ('192.031.014.000', 'DE'),
    ('192.031.015.000', '--'),
    ('192.031.016.000', 'US'),
    ('192.031.023.000', 'BE'),
    ('192.031.024.000', 'US'),
    ('192.031.026.000', 'GB'),
    ('192.031.027.000', 'FR'),
    ('192.031.028.000', 'US'),
    ('192.031.031.000', 'GB'),
    ('192.031.032.000', 'US'),
    ('192.031.040.000', 'BE'),
    ('192.031.041.000', 'US'),
    ('192.031.052.000', '--'),
    ('192.031.062.000', 'GB'),
    ('192.031.063.000', 'US'),
    ('192.031.102.000', 'DE'),
    ('192.031.103.000', '--'),
    ('192.031.104.000', 'US'),
    ('192.031.116.000', 'JP'),
    ('192.031.128.000', '--'),
    ('192.031.144.000', 'US'),
    ('192.031.165.000', '--'),
    ('192.031.166.000', 'NL'),
    ('192.031.172.000', 'US'),
    ('192.031.180.000', 'CA'),
    ('192.031.181.000', 'US'),
    ('192.031.182.000', '--'),
    ('192.031.191.000', 'US'),
    ('192.031.197.000', 'JP'),
    ('192.031.207.000', 'US'),
    ('192.031.208.000', '--'),
    ('192.031.209.000', 'US'),
    ('192.031.211.000', 'FR'),
    ('192.031.212.000', 'US'),
    ('192.031.224.000', 'CA'),
    ('192.031.225.000', 'US'),
    ('192.031.228.000', '--'),
    ('192.031.229.000', 'US'),
    ('192.031.231.000', 'NL'),
    ('192.031.232.000', 'US'),
    ('192.031.252.000', 'FR'),
    ('192.031.253.000', 'US'),
    ('192.031.255.000', '--'),
    ('192.032.000.000', 'US'),
    ('192.033.010.000', 'ZA'),
    ('192.033.011.000', '--'),
    ('192.033.012.000', 'US'),
    ('192.033.015.000', 'FR'),
    ('192.033.016.000', 'GB'),
    ('192.033.017.000', '--'),
    ('192.033.019.000', 'US'),
    ('192.033.024.000', '--'),
    ('192.033.032.000', 'US'),
    ('192.033.036.000', 'NL'),
    ('192.033.037.000', 'US'),
    ('192.033.087.000', 'CH'),
    ('192.033.112.000', 'US'),
    ('192.033.113.000', 'FR'),
    ('192.033.115.000', 'US'),
    ('192.033.118.000', 'CH'),
    ('192.033.128.000', 'US'),
    ('192.033.130.000', 'GB'),
    ('192.033.131.000', 'NL'),
    ('192.033.132.000', '--'),
    ('192.033.134.000', 'US'),
    ('192.033.135.000', 'JP'),
    ('192.033.136.000', 'US'),
    ('192.033.143.000', 'FR'),
    ('192.033.183.000', 'US'),
    ('192.033.192.000', 'CH'),
    ('192.033.232.000', 'US'),
    ('192.033.252.000', '--'),
    ('192.033.253.000', 'US'),
    ('192.033.254.000', 'DE'),
    ('192.033.255.000', '--'),
    ('192.034.000.000', 'US'),
    ('192.034.018.000', 'DE'),
    ('192.034.019.000', 'GB'),
    ('192.034.020.000', 'US'),
    ('192.034.050.000', 'GB'),
    ('192.034.051.000', 'US'),
    ('192.034.070.000', 'CA'),
    ('192.034.071.000', 'US'),
    ('192.034.116.000', 'NL'),
    ('192.034.117.000', 'US'),
    ('192.034.179.000', 'FI'),
    ('192.034.180.000', 'US'),
    ('192.034.181.000', 'CA'),
    ('192.034.196.000', 'US'),
    ('192.034.199.000', 'CA'),
    ('192.034.200.000', 'US'),
    ('192.034.203.000', 'SE'),
    ('192.034.204.000', 'US'),
    ('192.035.000.000', 'DE'),
    ('192.035.020.000', 'US'),
    ('192.035.059.000', 'AU'),
    ('192.035.060.000', 'US'),
    ('192.035.061.000', '--'),
    ('192.035.062.000', 'US'),
    ('192.035.063.000', 'DE'),
    ('192.035.073.000', 'US'),
    ('192.035.090.000', 'DE'),
    ('192.035.091.000', 'US'),
    ('192.035.094.000', 'GB'),
    ('192.035.095.000', 'US'),
    ('192.035.108.000', 'GB'),
    ('192.035.109.000', 'US'),
    ('192.035.138.000', 'GB'),
    ('192.035.139.000', '--'),
    ('192.035.140.000', 'US'),
    ('192.035.144.000', 'CA'),
    ('192.035.145.000', 'US'),
    ('192.035.146.000', 'IT'),
    ('192.035.147.000', 'US'),
    ('192.035.149.000', 'DE'),
    ('192.035.154.000', 'US'),
    ('192.035.172.000', 'GB'),
    ('192.035.173.000', 'US'),
    ('192.035.181.000', '--'),
    ('192.035.182.000', 'US'),
    ('192.035.183.000', 'NL'),
    ('192.035.193.000', 'US'),
    ('192.035.197.000', 'GB'),
    ('192.035.199.000', '--'),
    ('192.035.204.000', 'US'),
    ('192.035.205.000', 'GB'),
    ('192.035.207.000', 'IE'),
    ('192.035.208.000', 'US'),
    ('192.035.229.000', 'DE'),
    ('192.035.230.000', 'US'),
    ('192.035.240.000', 'AT'),
    ('192.035.245.000', 'US'),
    ('192.035.246.000', 'PT'),
    ('192.035.247.000', 'NL'),
    ('192.035.248.000', 'AU'),
    ('192.035.249.000', '--'),
    ('192.035.251.000', 'US'),
    ('192.035.252.000', 'CA'),
    ('192.035.253.000', 'US'),
    ('192.035.255.000', '--'),
    ('192.036.000.000', 'SE'),
    ('192.037.000.000', 'NL'),
    ('192.037.001.000', 'CH'),
    ('192.038.000.000', 'DK'),
    ('192.039.000.000', 'US'),
    ('192.039.166.000', 'AT'),
    ('192.039.167.000', 'US'),
    ('192.040.069.000', 'FI'),
    ('192.040.081.000', 'US'),
    ('192.040.218.000', 'FI'),
    ('192.040.219.000', 'US'),
    ('192.040.228.000', 'FI'),
    ('192.040.229.000', 'US'),
    ('192.040.254.000', 'CA'),
    ('192.040.255.000', 'US'),
    ('192.041.102.000', 'GB'),
    ('192.041.132.000', 'CH'),
    ('192.041.137.000', 'US'),
    ('192.041.138.000', '--'),
    ('192.041.139.000', 'US'),
    ('192.041.140.000', 'NL'),
    ('192.041.141.000', 'CH'),
    ('192.041.146.000', 'AU'),
    ('192.041.147.000', 'DE'),
    ('192.041.148.000', 'CA'),
    ('192.041.149.000', 'CH'),
    ('192.041.161.000', 'US'),
    ('192.041.170.000', 'TH'),
    ('192.041.171.000', 'US'),
    ('192.041.178.000', 'JP'),
    ('192.041.198.000', 'US'),
    ('192.041.200.000', '--'),
    ('192.041.201.000', 'CA'),
    ('192.041.202.000', 'US'),
    ('192.041.203.000', 'AU'),
    ('192.041.204.000', 'US'),
    ('192.041.206.000', 'ID'),
    ('192.041.207.000', 'US'),
    ('192.041.210.000', 'GB'),
    ('192.041.211.000', 'US'),
    ('192.041.216.000', 'NL'),
    ('192.041.217.000', 'US'),
    ('192.041.218.000', 'IT'),
    ('192.041.219.000', 'US'),
    ('192.041.226.000', '--'),
    ('192.041.227.000', 'DE'),
    ('192.041.228.000', 'US'),
    ('192.042.000.000', '--'),
    ('192.042.001.000', 'DE'),
    ('192.042.002.000', 'US'),
    ('192.042.005.000', 'CA'),
    ('192.042.007.000', 'US'),
    ('192.042.042.000', 'CH'),
    ('192.042.048.000', 'US'),
    ('192.042.052.000', 'AU'),
    ('192.042.053.000', 'GB'),
    ('192.042.054.000', 'CA'),
    ('192.042.055.000', 'US'),
    ('192.042.060.000', 'AU'),
    ('192.042.063.000', 'DE'),
    ('192.042.065.000', 'NO'),
    ('192.042.066.000', 'US'),
    ('192.042.068.000', 'CA'),
    ('192.042.069.000', 'US'),
    ('192.042.071.000', '--'),
    ('192.042.072.000', 'US'),
    ('192.042.084.000', 'JP'),
    ('192.042.087.000', 'GB'),
    ('192.042.088.000', 'US'),
    ('192.042.090.000', 'CA'),
    ('192.042.091.000', 'US'),
    ('192.042.096.000', '--'),
    ('192.042.097.000', 'US'),
    ('192.042.099.000', 'ZA'),
    ('192.042.100.000', 'GB'),
    ('192.042.101.000', 'US'),
    ('192.042.102.000', 'FR'),
    ('192.042.103.000', 'JP'),
    ('192.042.108.000', 'US'),
    ('192.042.112.000', 'NL'),
    ('192.042.133.000', 'US'),
    ('192.042.143.000', 'DE'),
    ('192.042.144.000', 'US'),
    ('192.042.151.000', 'AU'),
    ('192.042.152.000', 'US'),
    ('192.042.176.000', '--'),
    ('192.042.179.000', 'US'),
    ('192.042.180.000', 'CH'),
    ('192.042.202.000', 'CA'),
    ('192.042.205.000', '--'),
    ('192.042.206.000', 'CA'),
    ('192.042.207.000', 'US'),
    ('192.042.237.000', 'JP'),
    ('192.042.238.000', 'US'),
    ('192.042.244.000', 'DE'),
    ('192.042.245.000', 'IT'),
    ('192.042.246.000', '--'),
    ('192.042.247.000', 'NL'),
    ('192.042.248.000', 'US'),
    ('192.042.253.000', 'DE'),
    ('192.042.254.000', 'US'),
    ('192.042.255.000', '--'),
    ('192.043.000.000', 'US'),
    ('192.043.162.000', 'SE'),
    ('192.043.172.000', 'US'),
    ('192.043.174.000', 'JP'),
    ('192.043.175.000', 'US'),
    ('192.043.185.000', 'AU'),
    ('192.043.187.000', '--'),
    ('192.043.188.000', 'US'),
    ('192.043.189.000', 'JP'),
    ('192.043.190.000', 'US'),
    ('192.043.192.000', 'CH'),
    ('192.043.197.000', 'US'),
    ('192.043.198.000', 'AU'),
    ('192.043.199.000', 'US'),
    ('192.043.201.000', 'JP'),
    ('192.043.203.000', 'US'),
    ('192.043.206.000', '--'),
    ('192.043.207.000', 'AU'),
    ('192.043.210.000', 'NL'),
    ('192.043.211.000', 'US'),
    ('192.043.212.000', 'NL'),
    ('192.043.213.000', 'US'),
    ('192.043.215.000', '--'),
    ('192.043.216.000', 'US'),
    ('192.043.219.000', 'CA'),
    ('192.043.220.000', 'US'),
    ('192.043.224.000', 'JP'),
    ('192.043.225.000', 'US'),
    ('192.043.226.000', 'AU'),
    ('192.043.230.000', '--'),
    ('192.043.234.000', 'GB'),
    ('192.043.235.000', 'US'),
    ('192.043.238.000', '--'),
    ('192.043.239.000', 'AU'),
    ('192.043.240.000', 'US'),
    ('192.043.245.000', 'CA'),
    ('192.043.246.000', '--'),
    ('192.043.247.000', 'US'),
    ('192.044.000.000', 'DE'),
    ('192.044.041.000', 'FR'),
    ('192.044.081.000', 'DE'),
    ('192.044.091.000', 'US'),
    ('192.044.240.000', 'SE'),
    ('192.044.252.000', 'US'),
    ('192.046.069.000', 'FI'),
    ('192.046.071.000', 'BE'),
    ('192.046.072.000', 'US'),
    ('192.046.188.000', 'DE'),
    ('192.046.191.000', 'US'),
    ('192.046.243.000', 'CA'),
    ('192.046.244.000', 'US'),
    ('192.047.000.000', 'JP'),
    ('192.047.242.000', 'US'),
    ('192.047.244.000', 'CH'),
    ('192.047.250.000', 'US'),
    ('192.048.031.000', 'DE'),
    ('192.048.032.000', 'US'),
    ('192.048.098.000', 'FR'),
    ('192.048.099.000', 'US'),
    ('192.048.101.000', '--'),
    ('192.048.104.000', 'US'),
    ('192.048.105.000', '--'),
    ('192.048.106.000', 'US'),
    ('192.048.107.000', 'DE'),
    ('192.048.108.000', 'US'),
    ('192.048.109.000', 'AU'),
    ('192.048.111.000', 'US'),
    ('192.048.140.000', '--'),
    ('192.048.141.000', 'CA'),
    ('192.048.142.000', '--'),
    ('192.048.143.000', 'US'),
    ('192.048.145.000', 'DE'),
    ('192.048.146.000', 'US'),
    ('192.048.224.000', 'DE'),
    ('192.048.225.000', 'US'),
    ('192.048.230.000', '--'),
    ('192.048.231.000', 'DE'),
    ('192.048.232.000', 'US'),
    ('192.048.233.000', '--'),
    ('192.048.234.000', 'CA'),
    ('192.048.235.000', 'US'),
    ('192.048.236.000', '--'),
    ('192.048.238.000', 'US'),
    ('192.048.239.000', '--'),
    ('192.048.240.000', 'US'),
    ('192.048.248.000', 'AU'),
    ('192.048.249.000', 'US'),
    ('192.048.251.000', 'DE'),
    ('192.048.252.000', 'US'),
    ('192.048.253.000', 'ZA'),
    ('192.048.254.000', 'US'),
    ('192.048.255.000', '--'),
    ('192.049.000.000', 'FI'),
    ('192.050.000.000', 'JP'),
    ('192.051.000.000', 'NO'),
    ('192.051.016.000', 'JP'),
    ('192.052.000.000', 'DE'),
    ('192.052.051.000', 'US'),
    ('192.052.072.000', 'AU'),
    ('192.052.074.000', '--'),
    ('192.052.076.000', 'US'),
    ('192.052.108.000', 'CA'),
    ('192.052.109.000', '--'),
    ('192.052.110.000', 'US'),
    ('192.052.114.000', '--'),
    ('192.052.116.000', 'US'),
    ('192.052.118.000', '--'),
    ('192.052.119.000', 'JP'),
    ('192.052.151.000', 'US'),
    ('192.052.152.000', 'NL'),
    ('192.052.153.000', 'US'),
    ('192.052.158.000', '--'),
    ('192.052.159.000', 'DE'),
    ('192.052.161.000', 'GB'),
    ('192.052.162.000', '--'),
    ('192.052.163.000', 'US'),
    ('192.052.166.000', '--'),
    ('192.052.170.000', 'US'),
    ('192.052.171.000', 'AU'),
    ('192.052.177.000', 'US'),
    ('192.052.185.000', 'AU'),
    ('192.052.186.000', 'US'),
    ('192.052.188.000', '--'),
    ('192.052.190.000', 'US'),
    ('192.052.196.000', 'AU'),
    ('192.052.198.000', 'US'),
    ('192.052.221.000', 'NL'),
    ('192.052.224.000', 'US'),
    ('192.052.232.000', 'DZ'),
    ('192.052.233.000', 'US'),
    ('192.052.239.000', 'CA'),
    ('192.052.240.000', 'US'),
    ('192.052.250.000', '--'),
    ('192.052.252.000', 'US'),
    ('192.052.253.000', 'GB'),
    ('192.052.254.000', 'FR'),
    ('192.052.255.000', '--'),
    ('192.053.000.000', 'US'),
    ('192.053.001.000', 'BE'),
    ('192.053.003.000', 'US'),
    ('192.053.083.000', 'DE'),
    ('192.053.084.000', 'US'),
    ('192.053.103.000', 'DE'),
    ('192.053.104.000', 'CH'),
    ('192.053.105.000', 'US'),
    ('192.053.157.000', 'FI'),
    ('192.053.158.000', 'US'),
    ('192.054.031.000', 'DE'),
    ('192.054.081.000', 'US'),
    ('192.054.104.000', 'DE'),
    ('192.054.105.000', 'AU'),
    ('192.054.107.000', 'US'),
    ('192.054.110.000', 'FR'),
    ('192.054.111.000', 'US'),
    ('192.054.113.000', 'DE'),
    ('192.054.114.000', 'US'),
    ('192.054.115.000', 'DK'),
    ('192.054.121.000', 'CA'),
    ('192.054.122.000', 'CH'),
    ('192.054.123.000', '--'),
    ('192.054.124.000', 'US'),
    ('192.054.125.000', 'DE'),
    ('192.054.129.000', 'US'),
    ('192.054.130.000', 'NZ'),
    ('192.054.131.000', 'US'),
    ('192.054.132.000', 'CH'),
    ('192.054.133.000', 'US'),
    ('192.054.135.000', 'AU'),
    ('192.054.136.000', '--'),
    ('192.054.137.000', 'AU'),
    ('192.054.138.000', 'US'),
    ('192.054.139.000', 'DE'),
    ('192.054.140.000', 'FR'),
    ('192.054.220.000', 'AT'),
    ('192.054.221.000', 'DE'),
    ('192.054.222.000', 'US'),
    ('192.054.225.000', 'SE'),
    ('192.054.226.000', 'US'),
    ('192.054.227.000', '--'),
    ('192.054.228.000', 'US'),
    ('192.054.242.000', 'CA'),
    ('192.054.243.000', 'US'),
    ('192.054.244.000', 'CH'),
    ('192.054.245.000', 'GB'),
    ('192.054.246.000', 'US'),
    ('192.054.247.000', 'JP'),
    ('192.054.248.000', 'US'),
    ('192.054.251.000', 'AU'),
    ('192.054.252.000', '--'),
    ('192.054.253.000', 'US'),
    ('192.054.254.000', 'DE'),
    ('192.054.255.000', '--'),
    ('192.055.000.000', 'US'),
    ('192.055.084.000', 'DE'),
    ('192.055.085.000', '--'),
    ('192.055.086.000', 'US'),
    ('192.055.089.000', 'DE'),
    ('192.055.090.000', 'US'),
    ('192.055.096.000', '--'),
    ('192.055.097.000', 'US'),
    ('192.055.098.000', 'AU'),
    ('192.055.100.000', 'US'),
    ('192.055.101.000', 'IT'),
    ('192.055.102.000', 'US'),
    ('192.055.104.000', '--'),
    ('192.055.105.000', 'NL'),
    ('192.055.106.000', 'US'),
    ('192.055.109.000', 'NL'),
    ('192.055.110.000', 'JP'),
    ('192.055.111.000', 'US'),
    ('192.055.112.000', 'AU'),
    ('192.055.113.000', 'US'),
    ('192.055.115.000', 'NL'),
    ('192.055.116.000', 'US'),
    ('192.055.118.000', 'JP'),
    ('192.055.119.000', '--'),
    ('192.055.120.000', 'US'),
    ('192.055.129.000', 'NL'),
    ('192.055.130.000', '--'),
    ('192.055.131.000', 'US'),
    ('192.055.132.000', 'GB'),
    ('192.055.133.000', 'US'),
    ('192.055.188.000', 'DE'),
    ('192.055.189.000', 'US'),
    ('192.055.190.000', 'AU'),
    ('192.055.191.000', '--'),
    ('192.055.192.000', 'NL'),
    ('192.055.193.000', 'GB'),
    ('192.055.194.000', 'CA'),
    ('192.055.195.000', 'US'),
    ('192.055.197.000', 'DE'),
    ('192.055.198.000', 'AU'),
    ('192.055.199.000', 'US'),
    ('192.055.205.000', '--'),
    ('192.055.206.000', 'CA'),
    ('192.055.207.000', 'US'),
    ('192.055.209.000', 'AU'),
    ('192.055.210.000', 'US'),
    ('192.055.212.000', 'GB'),
    ('192.055.213.000', 'US'),
    ('192.055.215.000', '--'),
    ('192.055.216.000', 'CA'),
    ('192.055.217.000', '--'),
    ('192.055.218.000', 'US'),
    ('192.055.219.000', '--'),
    ('192.055.220.000', 'JP'),
    ('192.055.221.000', 'US'),
    ('192.055.224.000', 'CA'),
    ('192.055.225.000', '--'),
    ('192.055.226.000', 'US'),
    ('192.055.232.000', 'AU'),
    ('192.055.233.000', 'US'),
    ('192.055.238.000', 'JP'),
    ('192.055.239.000', 'US'),
    ('192.055.241.000', '--'),
    ('192.055.243.000', 'CA'),
    ('192.055.244.000', 'DE'),
    ('192.055.245.000', '--'),
    ('192.055.246.000', 'US'),
    ('192.055.247.000', '--'),
    ('192.055.248.000', 'US'),
    ('192.055.250.000', '--'),
    ('192.056.000.000', 'US'),
    ('192.056.014.000', 'AT'),
    ('192.056.015.000', 'US'),
    ('192.056.020.000', 'FR'),
    ('192.056.021.000', 'US'),
    ('192.056.051.000', 'CA'),
    ('192.056.052.000', 'US'),
    ('192.056.100.000', 'FI'),
    ('192.056.101.000', 'US'),
    ('192.056.128.000', 'FI'),
    ('192.056.129.000', 'US'),
    ('192.056.150.000', 'DE'),
    ('192.056.151.000', 'US'),
    ('192.056.244.000', 'CA'),
    ('192.056.245.000', 'US'),
    ('192.058.009.000', 'JP'),
    ('192.058.019.000', 'US'),
    ('192.058.028.000', 'LU'),
    ('192.058.036.000', 'US'),
    ('192.058.041.000', 'FI'),
    ('192.058.090.000', '--'),
    ('192.058.093.000', 'IT'),
    ('192.058.094.000', 'GB'),
    ('192.058.095.000', '--'),
    ('192.058.096.000', 'JP'),
    ('192.058.102.000', 'US'),
    ('192.058.121.000', 'CA'),
    ('192.058.122.000', 'US'),
    ('192.058.132.000', 'AU'),
    ('192.058.137.000', '--'),
    ('192.058.144.000', 'US'),
    ('192.058.193.000', '--'),
    ('192.058.194.000', 'CA'),
    ('192.058.195.000', 'US'),
    ('192.058.197.000', 'SE'),
    ('192.058.198.000', '--'),
    ('192.058.199.000', 'US'),
    ('192.058.213.000', 'CA'),
    ('192.058.214.000', '--'),
    ('192.058.215.000', 'US'),
    ('192.058.218.000', 'IT'),
    ('192.058.219.000', '--'),
    ('192.058.220.000', 'US'),
    ('192.058.230.000', 'DE'),
    ('192.058.231.000', 'US'),
    ('192.058.245.000', 'CA'),
    ('192.058.246.000', 'US'),
    ('192.062.100.000', 'GB'),
    ('192.062.101.000', 'US'),
    ('192.064.028.000', 'AT'),
    ('192.064.029.000', 'US'),
    ('192.064.038.000', 'CA'),
    ('192.064.039.000', 'US'),
    ('192.064.044.000', 'ES'),
    ('192.064.046.000', 'US'),
    ('192.064.100.000', 'BE'),
    ('192.064.104.000', 'US'),
    ('192.064.125.000', 'SE'),
    ('192.064.126.000', 'US'),
    ('192.064.159.000', 'CA'),
    ('192.064.160.000', 'US'),
    ('192.064.161.000', 'CA'),
    ('192.064.165.000', 'US'),
    ('192.064.202.000', 'DE'),
    ('192.064.203.000', 'US'),
    ('192.064.216.000', 'FI'),
    ('192.064.217.000', 'US'),
    ('192.065.050.000', '--'),
    ('192.065.051.000', 'NL'),
    ('192.065.071.000', 'US'),
    ('192.065.081.000', '--'),
    ('192.065.082.000', 'AU'),
    ('192.065.092.000', 'CH'),
    ('192.065.095.000', 'US'),
    ('192.065.096.000', 'NL'),
    ('192.065.097.000', 'US'),
    ('192.065.130.000', 'AU'),
    ('192.065.131.000', 'IT'),
    ('192.065.132.000', 'GB'),
    ('192.065.133.000', '--'),
    ('192.065.135.000', 'US'),
    ('192.065.138.000', '--'),
    ('192.065.139.000', 'DE'),
    ('192.065.140.000', 'US'),
    ('192.065.144.000', 'GB'),
    ('192.065.147.000', 'US'),
    ('192.065.152.000', 'VE'),
    ('192.065.153.000', 'GB'),
    ('192.065.154.000', '--'),
    ('192.065.171.000', 'US'),
    ('192.065.172.000', 'GB'),
    ('192.065.173.000', 'US'),
    ('192.065.176.000', 'PR'),
    ('192.065.177.000', 'US'),
    ('192.065.178.000', '--'),
    ('192.065.179.000', 'US'),
    ('192.065.181.000', '--'),
    ('192.065.182.000', 'AU'),
    ('192.065.183.000', 'CH'),
    ('192.065.198.000', 'US'),
    ('192.065.217.000', 'AU'),
    ('192.065.218.000', 'US'),
    ('192.065.219.000', 'GB'),
    ('192.065.232.000', '--'),
    ('192.065.244.000', 'US'),
    ('192.065.248.000', 'NZ'),
    ('192.065.249.000', 'US'),
    ('192.065.250.000', 'AU'),
    ('192.065.251.000', 'US'),
    ('192.066.000.000', 'DK'),
    ('192.067.000.000', '--'),
    ('192.067.001.000', 'AU'),
    ('192.067.002.000', '--'),
    ('192.067.003.000', 'IE'),
    ('192.067.004.000', 'GB'),
    ('192.067.005.000', '--'),
    ('192.067.006.000', 'US'),
    ('192.067.007.000', '--'),
    ('192.067.008.000', 'US'),
    ('192.067.009.000', 'CA'),
    ('192.067.010.000', '--'),
    ('192.067.011.000', 'US'),
    ('192.067.012.000', 'AU'),
    ('192.067.013.000', 'US'),
    ('192.067.024.000', '--'),
    ('192.067.039.000', 'GB'),
    ('192.067.040.000', '--'),
    ('192.067.041.000', 'US'),
    ('192.067.043.000', 'GB'),
    ('192.067.044.000', 'US'),
    ('192.067.045.000', 'CA'),
    ('192.067.046.000', 'US'),
    ('192.067.047.000', 'GB'),
    ('192.067.048.000', 'US'),
    ('192.067.050.000', 'GB'),
    ('192.067.051.000', 'US'),
    ('192.067.052.000', 'GB'),
    ('192.067.053.000', 'US'),
    ('192.067.054.000', '--'),
    ('192.067.055.000', 'DE'),
    ('192.067.056.000', 'US'),
    ('192.067.058.000', 'SE'),
    ('192.067.060.000', 'US'),
    ('192.067.064.000', '--'),
    ('192.067.067.000', 'US'),
    ('192.067.068.000', '--'),
    ('192.067.069.000', 'US'),
    ('192.067.070.000', 'JP'),
    ('192.067.071.000', 'US'),
    ('192.067.076.000', 'PT'),
    ('192.067.077.000', 'US'),
    ('192.067.079.000', 'ES'),
    ('192.067.080.000', 'US'),
    ('192.067.084.000', 'AU'),
    ('192.067.086.000', 'US'),
    ('192.067.087.000', 'GB'),
    ('192.067.088.000', '--'),
    ('192.067.090.000', 'US'),
    ('192.067.094.000', 'GB'),
    ('192.067.095.000', 'US'),
    ('192.067.100.000', 'GB'),
    ('192.067.105.000', 'CA'),
    ('192.067.107.000', 'US'),
    ('192.067.135.000', 'GB'),
    ('192.067.136.000', 'US'),
    ('192.067.160.000', '--'),
    ('192.067.165.000', 'US'),
    ('192.067.167.000', 'DE'),
    ('192.067.168.000', 'NZ'),
    ('192.067.169.000', '--'),
    ('192.067.170.000', 'DE'),
    ('192.067.171.000', 'AU'),
    ('192.067.172.000', 'US'),
    ('192.067.188.000', 'DE'),
    ('192.067.209.000', 'US'),
    ('192.067.217.000', 'AU'),
    ('192.067.218.000', 'DE'),
    ('192.067.219.000', 'US'),
    ('192.067.220.000', 'NL'),
    ('192.067.222.000', '--'),
    ('192.067.223.000', 'IE'),
    ('192.067.224.000', 'US'),
    ('192.067.230.000', 'DE'),
    ('192.067.234.000', 'US'),
    ('192.067.248.000', 'AU'),
    ('192.067.249.000', 'GR'),
    ('192.067.250.000', '--'),
    ('192.067.251.000', 'US'),
    ('192.068.000.000', 'DE'),
    ('192.068.004.000', 'AT'),
    ('192.068.005.000', 'DE'),
    ('192.068.020.000', 'US'),
    ('192.068.023.000', 'GB'),
    ('192.068.024.000', 'US'),
    ('192.068.029.000', '--'),
    ('192.068.030.000', 'US'),
    ('192.068.031.000', 'NL'),
    ('192.068.051.000', 'DE'),
    ('192.068.052.000', 'US'),
    ('192.068.053.000', 'CA'),
    ('192.068.075.000', 'US'),
    ('192.068.076.000', 'NO'),
    ('192.068.108.000', 'US'),
    ('192.068.110.000', 'JP'),
    ('192.068.112.000', 'US'),
    ('192.068.128.000', '--'),
    ('192.068.131.000', 'CA'),
    ('192.068.132.000', 'AU'),
    ('192.068.133.000', 'US'),
    ('192.068.137.000', 'CA'),
    ('192.068.138.000', 'TN'),
    ('192.068.139.000', 'AU'),
    ('192.068.140.000', 'US'),
    ('192.068.149.000', '--'),
    ('192.068.150.000', 'US'),
    ('192.068.151.000', 'GB'),
    ('192.068.154.000', 'US'),
    ('192.068.164.000', 'DE'),
    ('192.068.170.000', 'GB'),
    ('192.068.171.000', 'AU'),
    ('192.068.173.000', 'US'),
    ('192.068.174.000', 'GB'),
    ('192.068.175.000', 'US'),
    ('192.068.176.000', 'IT'),
    ('192.068.177.000', 'US'),
    ('192.068.178.000', 'PT'),
    ('192.068.179.000', 'AU'),
    ('192.068.180.000', 'US'),
    ('192.068.182.000', 'NL'),
    ('192.068.183.000', 'US'),
    ('192.068.184.000', 'CA'),
    ('192.068.185.000', 'US'),
    ('192.068.186.000', 'PT'),
    ('192.068.187.000', 'US'),
    ('192.068.209.000', 'PT'),
    ('192.068.210.000', 'US'),
    ('192.068.211.000', 'DE'),
    ('192.068.216.000', 'PT'),
    ('192.068.217.000', 'US'),
    ('192.068.221.000', 'PT'),
    ('192.068.222.000', 'US'),
    ('192.068.224.000', 'PT'),
    ('192.068.225.000', 'US'),
    ('192.068.229.000', 'CA'),
    ('192.068.230.000', 'NL'),
    ('192.068.231.000', 'DE'),
    ('192.068.234.000', '--'),
    ('192.068.235.000', 'JP'),
    ('192.068.250.000', 'NL'),
    ('192.068.253.000', 'US'),
    ('192.068.254.000', 'DE'),
    ('192.068.255.000', '--'),
    ('192.069.000.000', 'US'),
    ('192.069.064.000', 'BE'),
    ('192.069.065.000', 'US'),
    ('192.069.074.000', 'CA'),
    ('192.069.075.000', 'US'),
    ('192.069.101.000', 'CA'),
    ('192.069.102.000', 'US'),
    ('192.069.116.000', 'AU'),
    ('192.069.117.000', 'US'),
    ('192.069.149.000', 'CA'),
    ('192.069.159.000', 'US'),
    ('192.069.234.000', 'DE'),
    ('192.069.235.000', 'US'),
    ('192.070.000.000', 'FR'),
    ('192.070.055.000', 'US'),
    ('192.070.056.000', 'FR'),
    ('192.070.120.000', 'US'),
    ('192.070.133.000', 'TR'),
    ('192.070.135.000', 'AU'),
    ('192.070.136.000', 'IT'),
    ('192.070.137.000', 'US'),
    ('192.070.140.000', 'DE'),
    ('192.070.160.000', 'US'),
    ('192.070.172.000', 'CA'),
    ('192.070.173.000', 'US'),
    ('192.070.174.000', 'AU'),
    ('192.070.175.000', 'US'),
    ('192.070.176.000', 'CA'),
    ('192.070.178.000', 'US'),
    ('192.070.179.000', 'JP'),
    ('192.070.184.000', 'US'),
    ('192.070.216.000', 'AU'),
    ('192.070.217.000', 'US'),
    ('192.070.219.000', 'AU'),
    ('192.070.220.000', 'US'),
    ('192.070.224.000', 'CA'),
    ('192.070.225.000', 'US'),
    ('192.070.237.000', 'ZA'),
    ('192.070.238.000', 'US'),
    ('192.070.242.000', 'GB'),
    ('192.070.243.000', '--'),
    ('192.070.244.000', 'US'),
    ('192.071.000.000', 'SE'),
    ('192.072.000.000', '--'),
    ('192.072.001.000', 'US'),
    ('192.072.003.000', 'TW'),
    ('192.072.132.000', 'CH'),
    ('192.072.133.000', 'TW'),
    ('192.072.253.000', 'US'),
    ('192.072.255.000', '--'),
    ('192.073.000.000', 'US'),
    ('192.073.005.000', 'CA'),
    ('192.073.006.000', 'US'),
    ('192.073.012.000', 'AU'),
    ('192.073.013.000', 'US'),
    ('192.073.018.000', '--'),
    ('192.073.019.000', 'GB'),
    ('192.073.021.000', 'NZ'),
    ('192.073.022.000', 'AU'),
    ('192.073.023.000', '--'),
    ('192.073.024.000', 'ID'),
    ('192.073.026.000', 'US'),
    ('192.073.034.000', 'DE'),
    ('192.073.035.000', 'CH'),
    ('192.073.045.000', 'US'),
    ('192.073.066.000', 'AU'),
    ('192.073.067.000', 'US'),
    ('192.073.205.000', 'CA'),
    ('192.073.206.000', 'US'),
    ('192.073.226.000', 'BE'),
    ('192.073.227.000', 'US'),
    ('192.073.229.000', 'GB'),
    ('192.073.230.000', 'US'),
    ('192.073.232.000', '--'),
    ('192.074.000.000', 'DE'),
    ('192.074.127.000', 'US'),
    ('192.074.139.000', 'AU'),
    ('192.074.209.000', 'US'),
    ('192.074.220.000', '--'),
    ('192.075.000.000', 'CA'),
    ('192.075.192.000', '--'),
    ('192.075.198.000', 'US'),
    ('192.075.199.000', '--'),
    ('192.075.200.000', 'CA'),
    ('192.075.250.000', 'CM'),
    ('192.075.251.000', 'CA'),
    ('192.076.000.000', 'GB'),
    ('192.076.036.000', 'US'),
    ('192.076.120.000', '--'),
    ('192.076.121.000', 'US'),
    ('192.076.122.000', 'AU'),
    ('192.076.123.000', 'DE'),
    ('192.076.173.000', 'US'),
    ('192.076.176.000', 'DE'),
    ('192.076.177.000', 'US'),
    ('192.076.237.000', 'GB'),
    ('192.076.238.000', 'US'),
    ('192.076.241.000', 'DE'),
    ('192.076.242.000', 'PT'),
    ('192.076.243.000', 'AT'),
    ('192.076.245.000', 'DE'),
    ('192.076.249.000', 'US'),
    ('192.076.252.000', 'JP'),
    ('192.077.000.000', 'US'),
    ('192.077.008.000', 'AU'),
    ('192.077.009.000', 'US'),
    ('192.077.011.000', 'CH'),
    ('192.077.012.000', 'US'),
    ('192.077.017.000', 'AU'),
    ('192.077.018.000', 'US'),
    ('192.077.020.000', '--'),
    ('192.077.023.000', 'US'),
    ('192.077.046.000', 'CA'),
    ('192.077.076.000', 'US'),
    ('192.077.114.000', 'DE'),
    ('192.077.116.000', 'US'),
    ('192.077.120.000', 'FI'),
    ('192.077.124.000', 'US'),
    ('192.077.132.000', 'GB'),
    ('192.077.139.000', 'US'),
    ('192.077.140.000', 'ES'),
    ('192.077.142.000', 'US'),
    ('192.078.110.000', 'DE'),
    ('192.078.112.000', 'US'),
    ('192.078.116.000', 'CA'),
    ('192.078.117.000', 'US'),
    ('192.078.144.000', 'DE'),
    ('192.078.149.000', 'US'),
    ('192.078.154.000', 'AT'),
    ('192.078.155.000', 'US'),
    ('192.078.185.000', 'BE'),
    ('192.078.188.000', 'US'),
    ('192.080.020.000', 'PT'),
    ('192.080.022.000', 'US'),
    ('192.080.024.000', 'CL'),
    ('192.080.025.000', '--'),
    ('192.080.027.000', 'US'),
    ('192.080.028.000', '--'),
    ('192.080.029.000', 'US'),
    ('192.080.031.000', 'CH'),
    ('192.080.043.000', 'US'),
    ('192.080.045.000', '--'),
    ('192.080.046.000', 'GB'),
    ('192.080.047.000', 'US'),
    ('192.080.051.000', 'DE'),
    ('192.080.052.000', 'US'),
    ('192.080.096.000', '--'),
    ('192.080.207.000', 'US'),
    ('192.080.209.000', 'BR'),
    ('192.080.210.000', 'US'),
    ('192.081.059.000', 'BE'),
    ('192.081.060.000', 'US'),
    ('192.081.061.000', 'GB'),
    ('192.081.063.000', 'US'),
    ('192.081.085.000', 'CA'),
    ('192.081.086.000', 'US'),
    ('192.081.109.000', 'NO'),
    ('192.081.110.000', 'US'),
    ('192.081.121.000', 'DE'),
    ('192.081.122.000', 'US'),
    ('192.081.123.000', 'FI'),
    ('192.081.124.000', 'US'),
    ('192.081.194.000', 'SE'),
    ('192.081.195.000', 'US'),
    ('192.081.230.000', 'DE'),
    ('192.081.231.000', 'US'),
    ('192.081.234.000', 'GB'),
    ('192.081.235.000', 'US'),
    ('192.082.104.000', 'CA'),
    ('192.082.105.000', 'US'),
    ('192.082.117.000', 'CA'),
    ('192.082.118.000', 'US'),
    ('192.082.121.000', 'GB'),
    ('192.082.122.000', 'US'),
    ('192.082.124.000', 'CH'),
    ('192.082.125.000', 'US'),
    ('192.082.127.000', 'PT'),
    ('192.082.128.000', 'CA'),
    ('192.082.132.000', 'JP'),
    ('192.082.133.000', '--'),
    ('192.082.139.000', 'US'),
    ('192.082.140.000', 'AU'),
    ('192.082.141.000', 'US'),
    ('192.082.142.000', 'ZA'),
    ('192.082.143.000', 'AU'),
    ('192.082.144.000', '--'),
    ('192.082.147.000', 'US'),
    ('192.082.150.000', 'CA'),
    ('192.082.151.000', 'US'),
    ('192.082.152.000', '--'),
    ('192.082.153.000', 'GB'),
    ('192.082.154.000', 'US'),
    ('192.082.157.000', 'AT'),
    ('192.082.159.000', 'US'),
    ('192.082.161.000', 'AU'),
    ('192.082.162.000', 'US'),
    ('192.082.214.000', 'PT'),
    ('192.082.215.000', 'US'),
    ('192.082.220.000', 'IT'),
    ('192.082.222.000', 'AU'),
    ('192.082.223.000', 'US'),
    ('192.082.230.000', 'AU'),
    ('192.082.231.000', 'US'),
    ('192.082.241.000', 'DE'),
    ('192.082.242.000', 'GB'),
    ('192.082.244.000', 'PA'),
    ('192.082.245.000', '--'),
    ('192.083.000.000', 'FI'),
    ('192.083.080.000', '--'),
    ('192.083.101.000', 'CA'),
    ('192.083.102.000', 'GB'),
    ('192.083.103.000', '--'),
    ('192.083.104.000', 'JP'),
    ('192.083.105.000', 'US'),
    ('192.083.110.000', 'GB'),
    ('192.083.111.000', 'US'),
    ('192.083.118.000', 'AU'),
    ('192.083.120.000', 'US'),
    ('192.083.121.000', 'CA'),
    ('192.083.122.000', 'CN'),
    ('192.083.123.000', 'AU'),
    ('192.083.124.000', '--'),
    ('192.083.157.000', 'JP'),
    ('192.083.158.000', 'US'),
    ('192.083.160.000', 'FR'),
    ('192.083.161.000', 'US'),
    ('192.083.164.000', '--'),
    ('192.083.165.000', 'GB'),
    ('192.083.166.000', 'TW'),
    ('192.083.169.000', 'CN'),
    ('192.083.170.000', 'TW'),
    ('192.083.197.000', 'US'),
    ('192.083.198.000', 'AU'),
    ('192.083.199.000', 'US'),
    ('192.083.200.000', 'NL'),
    ('192.083.201.000', '--'),
    ('192.083.202.000', 'GB'),
    ('192.083.203.000', 'US'),
    ('192.083.205.000', '--'),
    ('192.083.206.000', 'US'),
    ('192.083.207.000', 'GB'),
    ('192.083.217.000', 'JP'),
    ('192.083.220.000', 'US'),
    ('192.083.222.000', '--'),
    ('192.083.223.000', 'CH'),
    ('192.083.224.000', 'AU'),
    ('192.083.225.000', 'US'),
    ('192.083.229.000', 'DE'),
    ('192.083.230.000', 'US'),
    ('192.083.231.000', 'AU'),
    ('192.083.232.000', 'US'),
    ('192.083.237.000', 'AU'),
    ('192.083.239.000', 'US'),
    ('192.083.247.000', 'CA'),
    ('192.083.248.000', 'US'),
    ('192.084.004.000', '--'),
    ('192.084.005.000', 'GB'),
    ('192.084.006.000', '--'),
    ('192.084.007.000', 'US'),
    ('192.084.013.000', 'PT'),
    ('192.084.014.000', 'US'),
    ('192.084.015.000', 'PT'),
    ('192.084.016.000', 'US'),
    ('192.084.027.000', 'AT'),
    ('192.084.028.000', 'US'),
    ('192.084.030.000', 'NL'),
    ('192.084.031.000', 'US'),
    ('192.084.032.000', 'NO'),
    ('192.084.034.000', 'US'),
    ('192.084.062.000', 'PT'),
    ('192.084.063.000', 'US'),
    ('192.084.071.000', 'JP'),
    ('192.084.074.000', 'US'),
    ('192.084.075.000', 'GB'),
    ('192.084.085.000', 'US'),
    ('192.084.086.000', 'CH'),
    ('192.084.087.000', 'IT'),
    ('192.084.088.000', 'US'),
    ('192.084.089.000', 'AU'),
    ('192.084.090.000', 'SI'),
    ('192.084.091.000', 'HR'),
    ('192.084.093.000', 'YU'),
    ('192.084.098.000', 'SI'),
    ('192.084.099.000', 'YU'),
    ('192.084.105.000', 'HR'),
    ('192.084.107.000', 'YU'),
    ('192.084.110.000', '--'),
    ('192.084.111.000', 'US'),
    ('192.084.126.000', '--'),
    ('192.084.127.000', 'IT'),
    ('192.084.157.000', 'US'),
    ('192.084.166.000', 'CH'),
    ('192.084.167.000', 'US'),
    ('192.084.173.000', 'GB'),
    ('192.084.174.000', 'US'),
    ('192.084.176.000', 'FI'),
    ('192.084.208.000', 'US'),
    ('192.084.212.000', 'GB'),
    ('192.084.213.000', 'US'),
    ('192.084.219.000', 'AU'),
    ('192.084.220.000', 'DE'),
    ('192.084.221.000', 'AT'),
    ('192.084.222.000', 'US'),
    ('192.084.225.000', '--'),
    ('192.084.226.000', 'HU'),
    ('192.084.230.000', 'AU'),
    ('192.084.231.000', 'US'),
    ('192.084.237.000', 'AU'),
    ('192.084.239.000', 'US'),
    ('192.084.241.000', 'AU'),
    ('192.084.243.000', 'US'),
    ('192.084.244.000', 'ZA'),
    ('192.084.245.000', 'DE'),
    ('192.084.248.000', 'US'),
    ('192.084.253.000', 'NZ'),
    ('192.084.254.000', 'US'),
    ('192.084.255.000', '--'),
    ('192.085.000.000', 'US'),
    ('192.085.093.000', 'DE'),
    ('192.085.094.000', 'US'),
    ('192.085.104.000', 'DE'),
    ('192.085.105.000', 'US'),
    ('192.086.000.000', '--'),
    ('192.086.001.000', 'MX'),
    ('192.086.002.000', 'US'),
    ('192.086.011.000', 'RU'),
    ('192.086.012.000', 'NZ'),
    ('192.086.013.000', 'US'),
    ('192.086.014.000', 'PL'),
    ('192.086.015.000', 'US'),
    ('192.086.018.000', 'GB'),
    ('192.086.019.000', 'US'),
    ('192.086.025.000', 'IL'),
    ('192.086.026.000', 'US'),
    ('192.086.027.000', 'GB'),
    ('192.086.028.000', 'US'),
    ('192.086.089.000', 'IL'),
    ('192.086.090.000', 'US'),
    ('192.086.125.000', 'NL'),
    ('192.086.127.000', 'GB'),
    ('192.086.128.000', 'US'),
    ('192.086.129.000', 'AU'),
    ('192.086.130.000', '--'),
    ('192.086.131.000', 'US'),
    ('192.086.132.000', 'SG'),
    ('192.086.134.000', 'GB'),
    ('192.086.135.000', 'US'),
    ('192.086.137.000', 'GB'),
    ('192.086.138.000', 'PT'),
    ('192.086.139.000', 'US'),
    ('192.086.160.000', '--'),
    ('192.086.162.000', 'US'),
    ('192.086.163.000', 'DE'),
    ('192.086.164.000', 'US'),
    ('192.086.165.000', 'AU'),
    ('192.086.166.000', 'CH'),
    ('192.086.167.000', 'FR'),
    ('192.086.168.000', 'US'),
    ('192.086.169.000', 'GB'),
    ('192.086.170.000', 'US'),
    ('192.086.254.000', 'SE'),
    ('192.086.255.000', '--'),
    ('192.087.000.000', 'NL'),
    ('192.088.000.000', '--'),
    ('192.088.001.000', 'CH'),
    ('192.088.002.000', 'US'),
    ('192.088.004.000', 'DE'),
    ('192.088.005.000', 'US'),
    ('192.088.006.000', 'AU'),
    ('192.088.008.000', 'US'),
    ('192.088.009.000', 'GB'),
    ('192.088.011.000', 'US'),
    ('192.088.015.000', 'DE'),
    ('192.088.016.000', '--'),
    ('192.088.017.000', 'PT'),
    ('192.088.018.000', '--'),
    ('192.088.021.000', 'US'),
    ('192.088.023.000', 'AT'),
    ('192.088.025.000', 'US'),
    ('192.088.050.000', 'GB'),
    ('192.088.051.000', 'US'),
    ('192.088.080.000', 'JP'),
    ('192.088.081.000', 'US'),
    ('192.088.083.000', 'GB'),
    ('192.088.085.000', 'NZ'),
    ('192.088.086.000', 'FI'),
    ('192.088.087.000', 'US'),
    ('192.088.097.000', 'DE'),
    ('192.088.099.000', 'US'),
    ('192.088.101.000', 'JP'),
    ('192.088.103.000', 'US'),
    ('192.088.108.000', 'DE'),
    ('192.088.109.000', '--'),
    ('192.088.110.000', 'US'),
    ('192.088.118.000', 'GB'),
    ('192.088.119.000', 'NZ'),
    ('192.088.120.000', 'US'),
    ('192.088.121.000', '--'),
    ('192.088.122.000', 'US'),
    ('192.088.123.000', 'PT'),
    ('192.088.124.000', 'US'),
    ('192.088.128.000', 'GB'),
    ('192.088.129.000', 'US'),
    ('192.088.130.000', 'GB'),
    ('192.088.131.000', 'US'),
    ('192.088.133.000', 'GB'),
    ('192.088.134.000', '--'),
    ('192.088.136.000', 'US'),
    ('192.088.178.000', '--'),
    ('192.088.184.000', 'US'),
    ('192.088.187.000', 'AU'),
    ('192.088.188.000', 'US'),
    ('192.088.190.000', 'NZ'),
    ('192.088.191.000', 'US'),
    ('192.088.196.000', 'IT'),
    ('192.088.197.000', 'US'),
    ('192.088.198.000', '--'),
    ('192.088.199.000', 'US'),
    ('192.088.204.000', 'DE'),
    ('192.088.205.000', 'US'),
    ('192.088.238.000', 'GB'),
    ('192.088.239.000', 'DE'),
    ('192.088.240.000', 'US'),
    ('192.088.250.000', 'PT'),
    ('192.089.000.000', 'FI'),
    ('192.089.003.000', 'SE'),
    ('192.089.004.000', 'FI'),
    ('192.089.099.000', 'ES'),
    ('192.089.100.000', 'FI'),
    ('192.089.159.000', 'BE'),
    ('192.089.160.000', 'FI'),
    ('192.090.000.000', 'US'),
    ('192.090.215.000', 'FR'),
    ('192.090.216.000', 'US'),
    ('192.091.140.000', 'BG'),
    ('192.091.142.000', 'US'),
    ('192.091.177.000', 'PT'),
    ('192.091.178.000', 'US'),
    ('192.091.179.000', 'AU'),
    ('192.091.180.000', 'US'),
    ('192.091.185.000', 'AU'),
    ('192.091.186.000', 'RU'),
    ('192.091.187.000', 'US'),
    ('192.091.189.000', 'NO'),
    ('192.091.190.000', 'US'),
    ('192.091.191.000', 'GB'),
    ('192.091.192.000', 'US'),
    ('192.091.198.000', '--'),
    ('192.091.199.000', 'GB'),
    ('192.091.200.000', 'BE'),
    ('192.091.201.000', 'GB'),
    ('192.091.202.000', 'US'),
    ('192.091.210.000', 'CA'),
    ('192.091.211.000', 'GB'),
    ('192.091.212.000', 'US'),
    ('192.091.213.000', 'AU'),
    ('192.091.214.000', 'SE'),
    ('192.091.234.000', '--'),
    ('192.091.235.000', 'US'),
    ('192.091.236.000', 'CH'),
    ('192.091.248.000', 'US'),
    ('192.091.254.000', 'HK'),
    ('192.091.255.000', '--'),
    ('192.092.008.000', 'US'),
    ('192.092.015.000', 'NZ'),
    ('192.092.016.000', 'US'),
    ('192.092.022.000', 'BE'),
    ('192.092.023.000', 'US'),
    ('192.092.075.000', 'FI'),
    ('192.092.076.000', 'US'),
    ('192.092.077.000', 'NL'),
    ('192.092.078.000', 'US'),
    ('192.092.082.000', 'GB'),
    ('192.092.083.000', 'US'),
    ('192.092.085.000', '--'),
    ('192.092.086.000', 'FR'),
    ('192.092.087.000', '--'),
    ('192.092.088.000', 'US'),
    ('192.092.104.000', 'IT'),
    ('192.092.107.000', 'US'),
    ('192.092.108.000', 'NL'),
    ('192.092.109.000', 'GB'),
    ('192.092.110.000', 'US'),
    ('192.092.116.000', 'FI'),
    ('192.092.117.000', '--'),
    ('192.092.118.000', 'US'),
    ('192.092.125.000', 'AT'),
    ('192.092.126.000', 'IT'),
    ('192.092.127.000', 'NL'),
    ('192.092.128.000', 'CH'),
    ('192.092.129.000', 'BG'),
    ('192.092.130.000', 'BE'),
    ('192.092.131.000', 'NL'),
    ('192.092.133.000', 'PT'),
    ('192.092.134.000', 'NL'),
    ('192.092.135.000', 'PT'),
    ('192.092.136.000', 'NL'),
    ('192.092.138.000', 'AT'),
    ('192.092.139.000', 'CH'),
    ('192.092.141.000', 'AT'),
    ('192.092.142.000', 'PT'),
    ('192.092.155.000', 'GR'),
    ('192.092.157.000', 'GB'),
    ('192.092.158.000', 'US'),
    ('192.092.200.000', '--'),
    ('192.092.215.000', 'US'),
    ('192.092.216.000', 'NO'),
    ('192.092.217.000', 'US'),
    ('192.092.219.000', 'DK'),
    ('192.092.240.000', '--'),
    ('192.093.000.000', 'FR'),
    ('192.094.000.000', 'US'),
    ('192.094.024.000', 'PT'),
    ('192.094.025.000', 'US'),
    ('192.094.028.000', 'AT'),
    ('192.094.029.000', 'US'),
    ('192.094.041.000', 'AU'),
    ('192.094.042.000', 'US'),
    ('192.094.057.000', 'AT'),
    ('192.094.058.000', 'GB'),
    ('192.094.059.000', 'US'),
    ('192.094.061.000', 'ZA'),
    ('192.094.062.000', 'AU'),
    ('192.094.065.000', 'US'),
    ('192.094.067.000', 'GR'),
    ('192.094.069.000', 'US'),
    ('192.094.070.000', '--'),
    ('192.094.072.000', 'US'),
    ('192.094.076.000', 'DE'),
    ('192.094.077.000', 'US'),
    ('192.094.110.000', '--'),
    ('192.094.111.000', 'GB'),
    ('192.094.116.000', 'US'),
    ('192.094.117.000', 'GB'),
    ('192.094.118.000', 'US'),
    ('192.094.122.000', 'BN'),
    ('192.094.123.000', 'US'),
    ('192.094.124.000', '--'),
    ('192.094.125.000', 'US'),
    ('192.094.126.000', 'CA'),
    ('192.094.127.000', 'US'),
    ('192.094.156.000', 'DK'),
    ('192.094.163.000', 'ES'),
    ('192.094.164.000', 'US'),
    ('192.094.169.000', 'NZ'),
    ('192.094.170.000', 'US'),
    ('192.094.172.000', 'GB'),
    ('192.094.173.000', 'US'),
    ('192.094.174.000', 'HK'),
    ('192.094.175.000', 'FR'),
    ('192.094.200.000', 'AU'),
    ('192.094.201.000', 'US'),
    ('192.094.203.000', '--'),
    ('192.094.207.000', 'US'),
    ('192.094.208.000', 'AU'),
    ('192.094.210.000', 'ZA'),
    ('192.094.211.000', 'US'),
    ('192.094.212.000', 'IT'),
    ('192.094.213.000', 'US'),
    ('192.094.220.000', 'JP'),
    ('192.094.221.000', 'RU'),
    ('192.094.222.000', 'US'),
    ('192.094.226.000', 'AT'),
    ('192.094.227.000', 'AU'),
    ('192.094.228.000', 'US'),
    ('192.094.233.000', 'CH'),
    ('192.094.234.000', 'DE'),
    ('192.094.235.000', 'GB'),
    ('192.094.236.000', 'US'),
    ('192.094.238.000', 'JP'),
    ('192.094.239.000', 'AT'),
    ('192.094.240.000', 'ZA'),
    ('192.094.242.000', 'US'),
    ('192.094.243.000', 'AU'),
    ('192.094.245.000', 'US'),
    ('192.094.246.000', 'ZA'),
    ('192.094.247.000', 'US'),
    ('192.094.252.000', '--'),
    ('192.095.055.000', 'FI'),
    ('192.095.056.000', '--'),
    ('192.095.065.000', 'US'),
    ('192.095.066.000', '--'),
    ('192.096.000.000', 'ZA'),
    ('192.097.000.000', 'US'),
    ('192.097.218.000', 'CA'),
    ('192.097.219.000', 'US'),
    ('192.098.000.000', 'FI'),
    ('192.098.046.000', 'JP'),
    ('192.098.047.000', 'FI'),
    ('192.098.049.000', 'EE'),
    ('192.098.050.000', 'FI'),
    ('192.099.000.000', '--'),
    ('192.100.001.000', 'ZA'),
    ('192.100.002.000', 'KR'),
    ('192.100.003.000', 'US'),
    ('192.100.018.000', 'FR'),
    ('192.100.019.000', 'US'),
    ('192.100.022.000', 'AU'),
    ('192.100.023.000', 'AT'),
    ('192.100.026.000', 'US'),
    ('192.100.052.000', 'GB'),
    ('192.100.053.000', 'NZ'),
    ('192.100.054.000', 'US'),
    ('192.100.061.000', 'GB'),
    ('192.100.062.000', 'US'),
    ('192.100.063.000', 'NO'),
    ('192.100.064.000', 'US'),
    ('192.100.072.000', '--'),
    ('192.100.076.000', 'US'),
    ('192.100.077.000', 'TH'),
    ('192.100.078.000', 'GB'),
    ('192.100.079.000', 'US'),
    ('192.100.080.000', 'AU'),
    ('192.100.081.000', 'US'),
    ('192.100.082.000', '--'),
    ('192.100.083.000', 'US'),
    ('192.100.096.000', 'DE'),
    ('192.100.099.000', 'GB'),
    ('192.100.100.000', 'US'),
    ('192.100.101.000', 'GB'),
    ('192.100.102.000', 'FI'),
    ('192.100.134.000', 'US'),
    ('192.100.135.000', 'GB'),
    ('192.100.141.000', 'US'),
    ('192.100.144.000', 'GB'),
    ('192.100.145.000', 'US'),
    ('192.100.154.000', 'GB'),
    ('192.100.155.000', 'MX'),
    ('192.101.000.000', '--'),
    ('192.101.001.000', 'ES'),
    ('192.101.002.000', 'US'),
    ('192.101.004.000', 'RU'),
    ('192.101.005.000', 'GB'),
    ('192.101.006.000', 'US'),
    ('192.101.008.000', 'ES'),
    ('192.101.009.000', '--'),
    ('192.101.011.000', 'GB'),
    ('192.101.012.000', 'US'),
    ('192.101.016.000', 'NZ'),
    ('192.101.017.000', 'US'),
    ('192.101.028.000', 'DE'),
    ('192.101.029.000', 'US'),
    ('192.101.033.000', '--'),
    ('192.101.034.000', 'GB'),
    ('192.101.035.000', 'US'),
    ('192.101.040.000', 'FI'),
    ('192.101.042.000', 'US'),
    ('192.101.075.000', 'DE'),
    ('192.101.076.000', 'US'),
    ('192.101.081.000', 'DE'),
    ('192.101.091.000', 'TH'),
    ('192.101.092.000', 'US'),
    ('192.101.118.000', 'PT'),
    ('192.101.119.000', 'US'),
    ('192.101.134.000', 'AU'),
    ('192.101.135.000', 'US'),
    ('192.101.137.000', 'GB'),
    ('192.101.138.000', 'US'),
    ('192.101.142.000', 'EG'),
    ('192.101.143.000', 'US'),
    ('192.101.160.000', 'ES'),
    ('192.101.169.000', 'PR'),
    ('192.101.170.000', 'BE'),
    ('192.101.171.000', 'US'),
    ('192.101.176.000', 'CH'),
    ('192.101.177.000', 'US'),
    ('192.101.179.000', 'DE'),
    ('192.101.181.000', 'US'),
    ('192.101.183.000', 'AU'),
    ('192.101.184.000', 'US'),
    ('192.101.192.000', 'FI'),
    ('192.101.193.000', 'US'),
    ('192.101.197.000', 'DE'),
    ('192.101.199.000', 'US'),
    ('192.101.252.000', 'BE'),
    ('192.101.253.000', 'US'),
    ('192.101.254.000', 'AU'),
    ('192.101.255.000', '--'),
    ('192.102.001.000', 'AT'),
    ('192.102.002.000', 'US'),
    ('192.102.006.000', 'HU'),
    ('192.102.008.000', 'GB'),
    ('192.102.009.000', 'ZA'),
    ('192.102.010.000', 'US'),
    ('192.102.011.000', 'CA'),
    ('192.102.012.000', 'US'),
    ('192.102.013.000', 'CA'),
    ('192.102.014.000', 'US'),
    ('192.102.017.000', 'AT'),
    ('192.102.018.000', 'FI'),
    ('192.102.033.000', 'US'),
    ('192.102.034.000', 'FI'),
    ('192.102.082.000', 'GB'),
    ('192.102.083.000', 'TH'),
    ('192.102.084.000', 'PE'),
    ('192.102.085.000', '--'),
    ('192.102.086.000', 'US'),
    ('192.102.089.000', 'DE'),
    ('192.102.090.000', 'US'),
    ('192.102.092.000', 'NZ'),
    ('192.102.093.000', 'US'),
    ('192.102.095.000', 'CH'),
    ('192.102.096.000', 'US'),
    ('192.102.146.000', 'DE'),
    ('192.102.178.000', 'US'),
    ('192.102.214.000', 'GB'),
    ('192.102.215.000', 'US'),
    ('192.102.224.000', 'FR'),
    ('192.102.225.000', 'PL'),
    ('192.102.226.000', 'US'),
    ('192.102.227.000', 'GB'),
    ('192.102.229.000', 'RU'),
    ('192.102.230.000', 'US'),
    ('192.102.239.000', 'AU'),
    ('192.102.240.000', 'US'),
    ('192.102.250.000', 'AU'),
    ('192.102.252.000', 'US'),
    ('192.102.254.000', 'NZ'),
    ('192.102.255.000', '--'),
    ('192.103.001.000', 'US'),
    ('192.103.002.000', 'LU'),
    ('192.103.003.000', 'US'),
    ('192.103.007.000', 'FR'),
    ('192.103.008.000', 'US'),
    ('192.103.012.000', '--'),
    ('192.103.013.000', 'US'),
    ('192.103.014.000', 'AE'),
    ('192.103.015.000', 'US'),
    ('192.103.020.000', 'GR'),
    ('192.103.021.000', 'US'),
    ('192.103.023.000', 'DE'),
    ('192.103.024.000', 'US'),
    ('192.103.027.000', 'DE'),
    ('192.103.028.000', 'GB'),
    ('192.103.040.000', 'DE'),
    ('192.103.041.000', 'US'),
    ('192.103.042.000', 'JP'),
    ('192.103.043.000', 'US'),
    ('192.103.046.000', 'AU'),
    ('192.103.047.000', 'US'),
    ('192.103.085.000', 'FI'),
    ('192.103.117.000', 'US'),
    ('192.103.130.000', 'AU'),
    ('192.103.131.000', '--'),
    ('192.103.132.000', 'AU'),
    ('192.103.133.000', 'US'),
    ('192.103.137.000', 'GB'),
    ('192.103.140.000', 'US'),
    ('192.103.147.000', 'PT'),
    ('192.103.148.000', 'US'),
    ('192.104.015.000', 'KR'),
    ('192.104.016.000', 'US'),
    ('192.104.020.000', '--'),
    ('192.104.021.000', 'US'),
    ('192.104.023.000', 'IT'),
    ('192.104.024.000', 'US'),
    ('192.104.028.000', 'GB'),
    ('192.104.030.000', 'US'),
    ('192.104.035.000', 'PT'),
    ('192.104.038.000', '--'),
    ('192.104.039.000', 'US'),
    ('192.104.040.000', 'JP'),
    ('192.104.041.000', 'CH'),
    ('192.104.042.000', 'US'),
    ('192.104.043.000', 'AU'),
    ('192.104.046.000', 'US'),
    ('192.104.048.000', 'PT'),
    ('192.104.049.000', '--'),
    ('192.104.050.000', 'US'),
    ('192.104.053.000', 'GB'),
    ('192.104.054.000', 'US'),
    ('192.104.055.000', 'NL'),
    ('192.104.057.000', 'NO'),
    ('192.104.059.000', 'US'),
    ('192.104.072.000', 'CH'),
    ('192.104.073.000', '--'),
    ('192.104.074.000', 'US'),
    ('192.104.077.000', 'DE'),
    ('192.104.078.000', 'US'),
    ('192.104.080.000', 'JP'),
    ('192.104.081.000', 'US'),
    ('192.104.082.000', 'GB'),
    ('192.104.083.000', 'US'),
    ('192.104.112.000', '--'),
    ('192.104.136.000', 'US'),
    ('192.104.140.000', 'NL'),
    ('192.104.141.000', 'US'),
    ('192.104.142.000', 'NL'),
    ('192.104.143.000', 'US'),
    ('192.104.147.000', 'GR'),
    ('192.104.148.000', 'US'),
    ('192.104.154.000', 'IE'),
    ('192.104.155.000', 'FR'),
    ('192.104.156.000', 'US'),
    ('192.104.160.000', '--'),
    ('192.104.163.000', 'US'),
    ('192.104.167.000', 'BE'),
    ('192.104.169.000', 'US'),
    ('192.104.172.000', 'JP'),
    ('192.104.173.000', 'US'),
    ('192.104.232.000', 'JP'),
    ('192.104.234.000', 'US'),
    ('192.104.238.000', 'GB'),
    ('192.104.239.000', 'US'),
    ('192.104.245.000', 'FR'),
    ('192.104.246.000', 'JP'),
    ('192.104.248.000', 'DK'),
    ('192.104.249.000', 'US'),
    ('192.104.251.000', 'CH'),
    ('192.104.252.000', 'NZ'),
    ('192.104.253.000', 'US'),
    ('192.104.255.000', '--'),
    ('192.105.000.000', 'US'),
    ('192.105.010.000', 'NZ'),
    ('192.105.011.000', 'US'),
    ('192.105.075.000', 'DE'),
    ('192.105.076.000', 'US'),
    ('192.105.104.000', 'CA'),
    ('192.105.109.000', 'US'),
    ('192.105.170.000', 'FI'),
    ('192.105.171.000', 'US'),
    ('192.105.195.000', 'BE'),
    ('192.105.196.000', 'US'),
    ('192.105.254.000', 'GB'),
    ('192.105.255.000', 'US'),
    ('192.106.000.000', 'IT'),
    ('192.107.000.000', '--'),
    ('192.107.001.000', 'NO'),
    ('192.107.002.000', 'GB'),
    ('192.107.003.000', 'US'),
    ('192.107.004.000', 'GB'),
    ('192.107.006.000', 'US'),
    ('192.107.009.000', 'AU'),
    ('192.107.010.000', 'NZ'),
    ('192.107.011.000', 'GB'),
    ('192.107.014.000', 'US'),
    ('192.107.049.000', 'GB'),
    ('192.107.050.000', 'US'),
    ('192.107.051.000', 'IT'),
    ('192.107.101.000', 'AU'),
    ('192.107.102.000', 'US'),
    ('192.107.104.000', 'NI'),
    ('192.107.105.000', 'US'),
    ('192.107.110.000', 'IE'),
    ('192.107.111.000', 'US'),
    ('192.107.112.000', 'NZ'),
    ('192.107.114.000', 'NO'),
    ('192.107.115.000', 'US'),
    ('192.107.120.000', '--'),
    ('192.107.122.000', 'PT'),
    ('192.107.123.000', 'DE'),
    ('192.107.124.000', 'AT'),
    ('192.107.126.000', 'GB'),
    ('192.107.130.000', 'US'),
    ('192.107.131.000', 'CA'),
    ('192.107.132.000', 'DE'),
    ('192.107.133.000', '--'),
    ('192.107.134.000', 'US'),
    ('192.107.168.000', 'GB'),
    ('192.107.169.000', 'US'),
    ('192.107.171.000', 'NZ'),
    ('192.107.173.000', 'US'),
    ('192.107.174.000', 'GB'),
    ('192.107.175.000', 'US'),
    ('192.107.177.000', 'GR'),
    ('192.107.178.000', 'GB'),
    ('192.107.179.000', 'US'),
    ('192.107.187.000', 'SE'),
    ('192.107.188.000', 'US'),
    ('192.107.200.000', 'FI'),
    ('192.107.232.000', 'AT'),
    ('192.107.234.000', 'US'),
    ('192.107.235.000', 'DE'),
    ('192.107.237.000', 'US'),
    ('192.108.023.000', 'DE'),
    ('192.108.093.000', 'US'),
    ('192.108.095.000', 'TR'),
    ('192.108.096.000', 'US'),
    ('192.108.099.000', 'AU'),
    ('192.108.100.000', 'NO'),
    ('192.108.102.000', 'US'),
    ('192.108.107.000', 'SE'),
    ('192.108.109.000', 'US'),
    ('192.108.113.000', 'AU'),
    ('192.108.114.000', 'GR'),
    ('192.108.115.000', 'FR'),
    ('192.108.120.000', 'GB'),
    ('192.108.121.000', 'AT'),
    ('192.108.122.000', 'US'),
    ('192.108.125.000', 'SK'),
    ('192.108.126.000', 'CZ'),
    ('192.108.127.000', '--'),
    ('192.108.128.000', 'CZ'),
    ('192.108.130.000', 'SK'),
    ('192.108.132.000', 'CZ'),
    ('192.108.133.000', 'SK'),
    ('192.108.134.000', 'CZ'),
    ('192.108.138.000', 'SK'),
    ('192.108.142.000', 'CZ'),
    ('192.108.143.000', 'SK'),
    ('192.108.145.000', 'CZ'),
    ('192.108.148.000', 'SK'),
    ('192.108.150.000', 'CZ'),
    ('192.108.155.000', 'SK'),
    ('192.108.156.000', 'CZ'),
    ('192.108.162.000', 'SK'),
    ('192.108.171.000', 'CZ'),
    ('192.108.173.000', 'SK'),
    ('192.108.174.000', 'CZ'),
    ('192.108.175.000', 'US'),
    ('192.108.195.000', 'SE'),
    ('192.108.215.000', 'US'),
    ('192.108.230.000', 'TH'),
    ('192.108.231.000', 'US'),
    ('192.108.232.000', 'GB'),
    ('192.108.233.000', 'US'),
    ('192.108.234.000', 'CH'),
    ('192.108.235.000', 'US'),
    ('192.108.238.000', 'AT'),
    ('192.108.239.000', 'US'),
    ('192.109.000.000', 'DE'),
    ('192.109.122.000', 'DK'),
    ('192.109.123.000', 'DE'),
    ('192.109.154.000', 'FR'),
    ('192.109.155.000', 'DE'),
    ('192.109.156.000', 'SE'),
    ('192.109.157.000', 'IT'),
    ('192.109.158.000', 'GB'),
    ('192.109.159.000', 'DE'),
    ('192.109.173.000', 'SG'),
    ('192.109.174.000', 'DE'),
    ('192.109.191.000', 'AT'),
    ('192.109.194.000', 'IN'),
    ('192.109.195.000', 'DE'),
    ('192.109.214.000', 'CH'),
    ('192.109.216.000', 'DE'),
    ('192.109.242.000', 'ZA'),
    ('192.109.243.000', 'DE'),
    ('192.110.000.000', 'US'),
    ('192.110.037.000', 'CA'),
    ('192.110.038.000', 'US'),
    ('192.110.085.000', 'CA'),
    ('192.110.086.000', 'US'),
    ('192.110.090.000', 'CA'),
    ('192.110.091.000', 'US'),
    ('192.110.095.000', 'CA'),
    ('192.110.096.000', 'US'),
    ('192.110.106.000', 'CA'),
    ('192.110.107.000', 'US'),
    ('192.110.116.000', 'CA'),
    ('192.110.117.000', 'US'),
    ('192.110.192.000', '--'),
    ('192.110.223.000', 'US'),
    ('192.110.241.000', 'GB'),
    ('192.110.242.000', 'US'),
    ('192.111.032.000', 'AU'),
    ('192.111.033.000', 'NO'),
    ('192.111.034.000', 'US'),
    ('192.111.037.000', '--'),
    ('192.111.039.000', 'IE'),
    ('192.111.040.000', 'US'),
    ('192.111.044.000', 'CZ'),
    ('192.111.045.000', 'US'),
    ('192.111.047.000', 'DE'),
    ('192.111.048.000', 'CH'),
    ('192.111.049.000', 'US'),
    ('192.111.054.000', '--'),
    ('192.111.086.000', 'US'),
    ('192.111.088.000', 'GB'),
    ('192.111.089.000', 'US'),
    ('192.111.101.000', 'PT'),
    ('192.111.102.000', 'NZ'),
    ('192.111.103.000', 'CH'),
    ('192.111.104.000', 'AT'),
    ('192.111.105.000', 'AU'),
    ('192.111.106.000', 'US'),
    ('192.111.124.000', 'NO'),
    ('192.111.126.000', 'US'),
    ('192.111.127.000', 'DE'),
    ('192.111.128.000', '--'),
    ('192.111.160.000', 'US'),
    ('192.111.229.000', 'BR'),
    ('192.111.231.000', 'US'),
    ('192.111.252.000', 'AT'),
    ('192.111.253.000', 'US'),
    ('192.111.255.000', '--'),
    ('192.112.000.000', 'US'),
    ('192.112.029.000', '--'),
    ('192.112.030.000', 'PT'),
    ('192.112.033.000', 'US'),
    ('192.112.035.000', '--'),
    ('192.112.036.000', 'US'),
    ('192.112.045.000', 'PT'),
    ('192.112.046.000', 'US'),
    ('192.112.049.000', 'GB'),
    ('192.112.050.000', 'US'),
    ('192.112.061.000', 'AT'),
    ('192.112.062.000', 'US'),
    ('192.112.069.000', '--'),
    ('192.112.070.000', 'ES'),
    ('192.112.080.000', 'US'),
    ('192.112.098.000', 'GB'),
    ('192.112.099.000', 'DK'),
    ('192.112.100.000', 'GB'),
    ('192.112.101.000', 'US'),
    ('192.112.204.000', 'FI'),
    ('192.112.205.000', 'US'),
    ('192.112.206.000', 'SE'),
    ('192.112.207.000', 'US'),
    ('192.112.208.000', 'DE'),
    ('192.112.209.000', 'US'),
    ('192.112.213.000', 'DE'),
    ('192.112.214.000', 'CH'),
    ('192.112.215.000', 'AU'),
    ('192.112.216.000', 'US'),
    ('192.112.247.000', 'ES'),
    ('192.112.248.000', 'US'),
    ('192.112.254.000', 'CH'),
    ('192.112.255.000', '--'),
    ('192.113.000.000', 'NL'),
    ('192.114.000.000', 'IL'),
    ('192.119.000.000', '--'),
    ('192.119.001.000', 'US'),
    ('192.119.002.000', '--'),
    ('192.120.000.000', 'US'),
    ('192.120.009.000', 'AU'),
    ('192.120.016.000', 'US'),
    ('192.120.047.000', 'FI'),
    ('192.120.050.000', 'US'),
    ('192.120.059.000', 'ES'),
    ('192.120.060.000', 'US'),
    ('192.120.120.000', 'SE'),
    ('192.120.121.000', 'US'),
    ('192.120.215.000', 'CH'),
    ('192.120.216.000', 'FI'),
    ('192.120.217.000', 'US'),
    ('192.120.231.000', 'FI'),
    ('192.120.232.000', 'US'),
    ('192.120.241.000', 'SE'),
    ('192.120.242.000', 'US'),
    ('192.121.000.000', 'SE'),
    ('192.121.155.000', 'NL'),
    ('192.121.156.000', 'FR'),
    ('192.121.157.000', 'CH'),
    ('192.121.158.000', 'DE'),
    ('192.121.159.000', 'AT'),
    ('192.121.160.000', 'SE'),
    ('192.121.251.000', 'EE'),
    ('192.121.253.000', 'SE'),
    ('192.122.000.000', 'GB'),
    ('192.122.096.000', 'US'),
    ('192.122.101.000', 'GB'),
    ('192.122.117.000', 'US'),
    ('192.122.118.000', 'GB'),
    ('192.122.131.000', 'SG'),
    ('192.122.141.000', 'GB'),
    ('192.122.147.000', 'US'),
    ('192.122.149.000', '--'),
    ('192.122.151.000', 'GB'),
    ('192.122.171.000', 'NZ'),
    ('192.122.172.000', 'US'),
    ('192.122.176.000', 'AU'),
    ('192.122.177.000', 'US'),
    ('192.122.180.000', 'NZ'),
    ('192.122.181.000', 'US'),
    ('192.122.201.000', '--'),
    ('192.122.206.000', 'AT'),
    ('192.122.207.000', 'US'),
    ('192.122.210.000', 'AU'),
    ('192.122.211.000', 'US'),
    ('192.122.214.000', 'GB'),
    ('192.122.215.000', '--'),
    ('192.122.216.000', 'IE'),
    ('192.122.235.000', 'US'),
    ('192.122.238.000', 'PT'),
    ('192.122.243.000', 'US'),
    ('192.122.254.000', 'NO'),
    ('192.122.255.000', '--'),
    ('192.123.000.000', 'US'),
    ('192.124.010.000', 'AU'),
    ('192.124.015.000', 'US'),
    ('192.124.024.000', 'NZ'),
    ('192.124.025.000', 'DE'),
    ('192.124.029.000', '--'),
    ('192.124.031.000', 'US'),
    ('192.124.032.000', 'AT'),
    ('192.124.033.000', 'US'),
    ('192.124.039.000', 'BE'),
    ('192.124.040.000', 'US'),
    ('192.124.044.000', '--'),
    ('192.124.045.000', 'US'),
    ('192.124.046.000', 'GB'),
    ('192.124.047.000', 'US'),
    ('192.124.112.000', 'DE'),
    ('192.124.113.000', 'US'),
    ('192.124.115.000', 'DE'),
    ('192.124.116.000', 'PL'),
    ('192.124.117.000', 'AU'),
    ('192.124.118.000', 'US'),
    ('192.124.152.000', 'AU'),
    ('192.124.153.000', 'US'),
    ('192.124.154.000', 'CN'),
    ('192.124.155.000', 'AT'),
    ('192.124.156.000', 'US'),
    ('192.124.160.000', 'NZ'),
    ('192.124.161.000', 'US'),
    ('192.124.168.000', 'RU'),
    ('192.124.220.000', 'US'),
    ('192.124.235.000', 'DE'),
    ('192.126.000.000', 'FI'),
    ('192.126.065.000', 'US'),
    ('192.126.069.000', '--'),
    ('192.127.000.000', 'US'),
    ('192.128.002.000', 'GB'),
    ('192.128.003.000', 'US'),
    ('192.129.000.000', '--'),
    ('192.129.001.000', 'DE'),
    ('192.129.003.000', 'RO'),
    ('192.129.005.000', 'DE'),
    ('192.129.062.000', 'US'),
    ('192.129.080.000', 'AT'),
    ('192.129.081.000', 'US'),
    ('192.129.087.000', 'TR'),
    ('192.129.088.000', 'US'),
    ('192.129.098.000', 'DE'),
    ('192.129.099.000', 'US'),
    ('192.129.112.000', '--'),
    ('192.130.000.000', 'FI'),
    ('192.130.014.000', 'BE'),
    ('192.130.016.000', 'FI'),
    ('192.130.018.000', 'BE'),
    ('192.130.019.000', 'FI'),
    ('192.130.188.000', 'SG'),
    ('192.130.189.000', 'FI'),
    ('192.131.000.000', 'US'),
    ('192.131.013.000', 'AU'),
    ('192.131.014.000', 'US'),
    ('192.131.020.000', 'DE'),
    ('192.131.021.000', '--'),
    ('192.131.022.000', 'US'),
    ('192.131.025.000', 'SE'),
    ('192.131.027.000', 'AU'),
    ('192.131.031.000', 'US'),
    ('192.131.079.000', 'GB'),
    ('192.131.080.000', 'US'),
    ('192.131.083.000', 'GB'),
    ('192.131.084.000', 'US'),
    ('192.131.089.000', 'GB'),
    ('192.131.090.000', 'AU'),
    ('192.131.093.000', 'US'),
    ('192.131.094.000', 'CA'),
    ('192.131.095.000', 'US'),
    ('192.131.096.000', 'FI'),
    ('192.131.097.000', 'CA'),
    ('192.131.098.000', 'US'),
    ('192.131.108.000', 'GB'),
    ('192.131.109.000', 'US'),
    ('192.131.110.000', '--'),
    ('192.131.111.000', 'US'),
    ('192.131.132.000', 'LU'),
    ('192.131.133.000', 'US'),
    ('192.131.134.000', '--'),
    ('192.131.135.000', 'US'),
    ('192.131.136.000', 'CA'),
    ('192.131.143.000', 'US'),
    ('192.131.233.000', 'NZ'),
    ('192.131.234.000', '--'),
    ('192.131.235.000', 'US'),
    ('192.131.251.000', 'AU'),
    ('192.131.253.000', 'US'),
    ('192.131.255.000', '--'),
    ('192.132.000.000', 'US'),
    ('192.132.008.000', 'JP'),
    ('192.132.009.000', 'GB'),
    ('192.132.010.000', 'IT'),
    ('192.132.011.000', 'NO'),
    ('192.132.012.000', 'US'),
    ('192.132.015.000', 'KR'),
    ('192.132.016.000', 'US'),
    ('192.132.019.000', 'CA'),
    ('192.132.020.000', 'US'),
    ('192.132.028.000', '--'),
    ('192.132.029.000', 'US'),
    ('192.132.030.000', '--'),
    ('192.132.031.000', 'JP'),
    ('192.132.032.000', '--'),
    ('192.132.034.000', 'IT'),
    ('192.132.035.000', 'BR'),
    ('192.132.036.000', 'US'),
    ('192.132.041.000', 'AU'),
    ('192.132.042.000', 'US'),
    ('192.132.053.000', 'PT'),
    ('192.132.054.000', 'US'),
    ('192.132.055.000', 'PT'),
    ('192.132.056.000', 'US'),
    ('192.132.060.000', 'CA'),
    ('192.132.061.000', '--'),
    ('192.132.064.000', 'US'),
    ('192.132.093.000', 'AU'),
    ('192.132.094.000', 'US'),
    ('192.132.099.000', 'GB'),
    ('192.132.100.000', 'US'),
    ('192.132.102.000', 'AU'),
    ('192.132.103.000', 'US'),
    ('192.132.239.000', 'GB'),
    ('192.132.240.000', 'US'),
    ('192.132.241.000', 'CA'),
    ('192.132.242.000', 'US'),
    ('192.132.243.000', '--'),
    ('192.132.244.000', 'IL'),
    ('192.132.245.000', 'AT'),
    ('192.132.246.000', 'US'),
    ('192.132.247.000', 'KR'),
    ('192.132.252.000', 'CH'),
    ('192.132.253.000', 'AU'),
    ('192.132.254.000', 'US'),
    ('192.132.255.000', '--'),
    ('192.133.000.000', 'US'),
    ('192.133.010.000', 'TH'),
    ('192.133.011.000', 'US'),
    ('192.133.014.000', 'AU'),
    ('192.133.015.000', 'PT'),
    ('192.133.016.000', 'US'),
    ('192.133.021.000', 'AU'),
    ('192.133.022.000', 'US'),
    ('192.133.028.000', 'IT'),
    ('192.133.029.000', 'US'),
    ('192.133.031.000', 'NZ'),
    ('192.133.032.000', 'NO'),
    ('192.133.033.000', 'US'),
    ('192.133.036.000', 'IL'),
    ('192.133.037.000', 'US'),
    ('192.133.041.000', 'AU'),
    ('192.133.042.000', 'US'),
    ('192.133.045.000', '--'),
    ('192.133.046.000', 'US'),
    ('192.133.047.000', 'JP'),
    ('192.133.048.000', 'US'),
    ('192.133.053.000', 'NL'),
    ('192.133.054.000', 'PT'),
    ('192.133.056.000', 'US'),
    ('192.133.058.000', 'GB'),
    ('192.133.059.000', 'US'),
    ('192.133.064.000', 'NO'),
    ('192.133.065.000', 'US'),
    ('192.133.066.000', 'NZ'),
    ('192.133.067.000', 'SG'),
    ('192.133.068.000', 'US'),
    ('192.133.076.000', '--'),
    ('192.133.080.000', 'US'),
    ('192.133.090.000', 'GB'),
    ('192.133.091.000', 'US'),
    ('192.133.101.000', '--'),
    ('192.133.102.000', 'US'),
    ('192.133.103.000', 'BE'),
    ('192.133.104.000', 'US'),
    ('192.133.106.000', '--'),
    ('192.133.108.000', 'PT'),
    ('192.133.109.000', 'GB'),
    ('192.133.110.000', 'FI'),
    ('192.133.112.000', '--'),
    ('192.133.116.000', 'US'),
    ('192.133.121.000', 'SE'),
    ('192.133.122.000', 'US'),
    ('192.133.131.000', 'GB'),
    ('192.133.132.000', 'US'),
    ('192.133.136.000', '--'),
    ('192.133.144.000', 'US'),
    ('192.133.244.000', 'GB'),
    ('192.133.245.000', 'US'),
    ('192.133.247.000', '--'),
    ('192.133.250.000', 'ZA'),
    ('192.133.251.000', 'US'),
    ('192.134.000.000', 'FR'),
    ('192.134.143.000', 'CM'),
    ('192.134.144.000', 'FR'),
    ('192.135.000.000', 'US'),
    ('192.135.007.000', 'DE'),
    ('192.135.008.000', 'IT'),
    ('192.135.038.000', 'US'),
    ('192.135.046.000', 'NO'),
    ('192.135.047.000', 'US'),
    ('192.135.048.000', 'CA'),
    ('192.135.049.000', 'US'),
    ('192.135.050.000', '--'),
    ('192.135.051.000', 'DE'),
    ('192.135.052.000', 'GB'),
    ('192.135.054.000', '--'),
    ('192.135.063.000', 'AT'),
    ('192.135.064.000', 'US'),
    ('192.135.066.000', 'GB'),
    ('192.135.067.000', 'US'),
    ('192.135.068.000', 'GB'),
    ('192.135.069.000', 'US'),
    ('192.135.077.000', 'CA'),
    ('192.135.078.000', 'US'),
    ('192.135.082.000', 'NL'),
    ('192.135.083.000', 'CA'),
    ('192.135.084.000', 'US'),
    ('192.135.089.000', 'JP'),
    ('192.135.112.000', 'US'),
    ('192.135.129.000', 'PT'),
    ('192.135.130.000', 'US'),
    ('192.135.133.000', 'AT'),
    ('192.135.134.000', 'US'),
    ('192.135.143.000', 'NO'),
    ('192.135.144.000', 'US'),
    ('192.135.145.000', 'CH'),
    ('192.135.165.000', 'IT'),
    ('192.135.166.000', 'GR'),
    ('192.135.167.000', 'BE'),
    ('192.135.169.000', 'US'),
    ('192.135.175.000', 'FR'),
    ('192.135.176.000', 'US'),
    ('192.135.185.000', 'BE'),
    ('192.135.186.000', 'US'),
    ('192.135.187.000', 'PT'),
    ('192.135.188.000', 'US'),
    ('192.135.200.000', '--'),
    ('192.135.205.000', 'US'),
    ('192.135.206.000', '--'),
    ('192.135.207.000', 'AU'),
    ('192.135.209.000', 'US'),
    ('192.135.210.000', 'AU'),
    ('192.135.211.000', 'US'),
    ('192.135.218.000', '--'),
    ('192.135.219.000', 'PT'),
    ('192.135.220.000', 'US'),
    ('192.135.222.000', 'JP'),
    ('192.135.223.000', '--'),
    ('192.135.224.000', 'US'),
    ('192.135.225.000', 'IE'),
    ('192.135.226.000', 'US'),
    ('192.135.231.000', 'GB'),
    ('192.135.235.000', 'US'),
    ('192.135.253.000', 'NO'),
    ('192.135.254.000', 'PL'),
    ('192.135.255.000', '--'),
    ('192.136.000.000', 'US'),
    ('192.136.007.000', 'MT'),
    ('192.136.008.000', 'US'),
    ('192.136.009.000', 'FI'),
    ('192.136.010.000', 'US'),
    ('192.136.018.000', 'GB'),
    ('192.136.019.000', 'BE'),
    ('192.136.020.000', 'US'),
    ('192.136.023.000', 'NL'),
    ('192.136.024.000', 'US'),
    ('192.136.027.000', 'CA'),
    ('192.136.028.000', 'US'),
    ('192.136.029.000', 'GB'),
    ('192.136.030.000', 'FR'),
    ('192.136.031.000', 'PT'),
    ('192.136.032.000', 'US'),
    ('192.136.036.000', '--'),
    ('192.136.037.000', 'US'),
    ('192.136.039.000', 'AU'),
    ('192.136.040.000', 'GB'),
    ('192.136.041.000', 'CH'),
    ('192.136.042.000', 'NI'),
    ('192.136.048.000', 'US'),
    ('192.136.049.000', 'PT'),
    ('192.136.050.000', 'US'),
    ('192.136.051.000', 'NL'),
    ('192.136.052.000', 'PT'),
    ('192.136.053.000', 'SN'),
    ('192.136.054.000', 'FR'),
    ('192.136.055.000', 'BF'),
    ('192.136.057.000', 'NE'),
    ('192.136.058.000', 'SN'),
    ('192.136.059.000', 'PF'),
    ('192.136.060.000', 'US'),
    ('192.136.061.000', 'RU'),
    ('192.136.062.000', 'US'),
    ('192.136.071.000', 'FI'),
    ('192.136.080.000', '--'),
    ('192.136.104.000', 'US'),
    ('192.136.113.000', '--'),
    ('192.136.114.000', 'CA'),
    ('192.136.116.000', '--'),
    ('192.136.118.000', 'US'),
    ('192.136.141.000', 'IN'),
    ('192.136.144.000', 'US'),
    ('192.136.154.000', 'GB'),
    ('192.136.156.000', 'US'),
    ('192.136.157.000', '--'),
    ('192.137.000.000', 'US'),
    ('192.137.024.000', 'CA'),
    ('192.137.025.000', 'US'),
    ('192.137.031.000', 'CN'),
    ('192.137.032.000', 'US'),
    ('192.137.043.000', 'PR'),
    ('192.137.044.000', 'US'),
    ('192.137.062.000', 'NL'),
    ('192.137.063.000', 'US'),
    ('192.137.064.000', 'NL'),
    ('192.137.074.000', 'ES'),
    ('192.137.075.000', 'GB'),
    ('192.137.076.000', 'CH'),
    ('192.137.077.000', 'FR'),
    ('192.137.086.000', 'AU'),
    ('192.137.087.000', 'ES'),
    ('192.137.088.000', 'US'),
    ('192.137.089.000', 'NO'),
    ('192.137.090.000', 'GB'),
    ('192.137.095.000', 'ES'),
    ('192.137.096.000', 'AU'),
    ('192.137.097.000', 'US'),
    ('192.137.098.000', 'GB'),
    ('192.137.100.000', 'ES'),
    ('192.137.101.000', 'DE'),
    ('192.137.102.000', 'US'),
    ('192.137.126.000', 'AU'),
    ('192.137.127.000', 'GB'),
    ('192.137.128.000', 'CA'),
    ('192.137.129.000', 'US'),
    ('192.137.144.000', 'DK'),
    ('192.137.145.000', 'GB'),
    ('192.137.148.000', 'CH'),
    ('192.137.150.000', 'US'),
    ('192.137.156.000', 'HK'),
    ('192.137.157.000', 'US'),
    ('192.137.158.000', 'CA'),
    ('192.137.159.000', 'FR'),
    ('192.137.161.000', 'SE'),
    ('192.137.165.000', 'US'),
    ('192.137.168.000', 'CH'),
    ('192.137.169.000', 'US'),
    ('192.137.171.000', 'SE'),
    ('192.137.172.000', 'AU'),
    ('192.137.173.000', 'US'),
    ('192.137.184.000', 'CH'),
    ('192.137.185.000', 'MX'),
    ('192.137.186.000', 'CH'),
    ('192.137.188.000', 'US'),
    ('192.137.199.000', 'SE'),
    ('192.137.201.000', 'ES'),
    ('192.137.202.000', 'US'),
    ('192.137.204.000', 'GB'),
    ('192.137.205.000', 'US'),
    ('192.137.211.000', 'CH'),
    ('192.137.216.000', 'US'),
    ('192.137.234.000', 'SE'),
    ('192.137.235.000', 'NL'),
    ('192.137.236.000', 'CH'),
    ('192.137.243.000', 'US'),
    ('192.137.247.000', 'CA'),
    ('192.137.250.000', 'US'),
    ('192.138.000.000', 'GB'),
    ('192.138.016.000', '--'),
    ('192.138.024.000', 'US'),
    ('192.138.086.000', 'PT'),
    ('192.138.087.000', 'US'),
    ('192.138.100.000', 'AU'),
    ('192.138.101.000', 'US'),
    ('192.138.105.000', 'NO'),
    ('192.138.109.000', 'SE'),
    ('192.138.118.000', 'SG'),
    ('192.138.126.000', 'US'),
    ('192.138.128.000', 'CA'),
    ('192.138.131.000', 'US'),
    ('192.138.155.000', 'NO'),
    ('192.138.156.000', 'GB'),
    ('192.138.159.000', 'US'),
    ('192.138.164.000', 'AU'),
    ('192.138.165.000', 'US'),
    ('192.138.183.000', 'IT'),
    ('192.138.184.000', 'US'),
    ('192.138.185.000', 'CA'),
    ('192.138.187.000', 'US'),
    ('192.138.188.000', 'SG'),
    ('192.138.189.000', 'US'),
    ('192.138.192.000', 'GB'),
    ('192.138.193.000', 'US'),
    ('192.138.204.000', 'PT'),
    ('192.138.205.000', 'US'),
    ('192.138.228.000', 'AT'),
    ('192.138.229.000', 'GB'),
    ('192.138.230.000', 'CH'),
    ('192.138.233.000', 'US'),
    ('192.138.248.000', 'GB'),
    ('192.138.249.000', 'US'),
    ('192.138.251.000', 'NZ'),
    ('192.138.252.000', 'US'),
    ('192.139.000.000', 'CA'),
    ('192.139.078.000', 'FR'),
    ('192.139.079.000', 'CA'),
    ('192.139.133.000', 'US'),
    ('192.139.138.000', 'CA'),
    ('192.139.139.000', '--'),
    ('192.139.140.000', 'CA'),
    ('192.140.000.000', 'FR'),
    ('192.142.233.000', 'FI'),
    ('192.142.234.000', 'FR'),
    ('192.143.112.000', 'FI'),
    ('192.143.113.000', 'FR'),
    ('192.146.000.000', 'US'),
    ('192.146.117.000', 'DK'),
    ('192.146.118.000', 'FI'),
    ('192.146.119.000', 'FR'),
    ('192.146.120.000', 'US'),
    ('192.146.123.000', 'GB'),
    ('192.146.124.000', 'ES'),
    ('192.146.127.000', 'US'),
    ('192.146.130.000', '--'),
    ('192.146.132.000', 'AT'),
    ('192.146.133.000', 'NZ'),
    ('192.146.134.000', 'HU'),
    ('192.146.136.000', 'GB'),
    ('192.146.142.000', 'US'),
    ('192.146.150.000', 'NZ'),
    ('192.146.151.000', 'US'),
    ('192.146.152.000', 'FI'),
    ('192.146.153.000', 'US'),
    ('192.146.156.000', 'CA'),
    ('192.146.157.000', 'BR'),
    ('192.146.158.000', 'US'),
    ('192.146.163.000', 'NO'),
    ('192.146.171.000', 'US'),
    ('192.146.172.000', 'ES'),
    ('192.146.173.000', 'IT'),
    ('192.146.182.000', 'FR'),
    ('192.146.183.000', 'US'),
    ('192.146.184.000', 'JP'),
    ('192.146.185.000', 'DE'),
    ('192.146.186.000', 'US'),
    ('192.146.187.000', 'ES'),
    ('192.146.188.000', 'US'),
    ('192.146.189.000', 'AU'),
    ('192.146.190.000', '--'),
    ('192.146.191.000', 'US'),
    ('192.146.193.000', 'NO'),
    ('192.146.194.000', 'US'),
    ('192.146.200.000', 'AU'),
    ('192.146.201.000', 'US'),
    ('192.146.204.000', 'CZ'),
    ('192.146.205.000', 'US'),
    ('192.146.218.000', 'NZ'),
    ('192.146.220.000', 'US'),
    ('192.146.227.000', 'NO'),
    ('192.146.228.000', 'GB'),
    ('192.146.229.000', 'BR'),
    ('192.146.230.000', '--'),
    ('192.146.232.000', 'AU'),
    ('192.146.233.000', 'FR'),
    ('192.146.235.000', 'US'),
    ('192.146.237.000', 'UY'),
    ('192.146.238.000', 'NO'),
    ('192.146.240.000', 'US'),
    ('192.146.242.000', 'IT'),
    ('192.146.243.000', 'US'),
    ('192.146.251.000', 'AU'),
    ('192.146.254.000', 'US'),
    ('192.146.255.000', '--'),
    ('192.147.001.000', 'GB'),
    ('192.147.003.000', 'US'),
    ('192.147.023.000', 'GB'),
    ('192.147.024.000', 'US'),
    ('192.147.034.000', 'IS'),
    ('192.147.035.000', 'US'),
    ('192.147.036.000', 'GB'),
    ('192.147.037.000', 'PL'),
    ('192.147.038.000', 'US'),
    ('192.147.042.000', 'PL'),
    ('192.147.043.000', 'US'),
    ('192.147.076.000', 'PT'),
    ('192.147.079.000', 'FR'),
    ('192.147.080.000', 'US'),
    ('192.147.114.000', 'AU'),
    ('192.147.115.000', 'US'),
    ('192.147.141.000', 'PL'),
    ('192.147.142.000', 'US'),
    ('192.147.148.000', 'GB'),
    ('192.147.149.000', 'US'),
    ('192.147.150.000', 'GB'),
    ('192.147.151.000', 'NZ'),
    ('192.147.154.000', 'US'),
    ('192.147.155.000', 'PT'),
    ('192.147.156.000', 'US'),
    ('192.147.158.000', 'FI'),
    ('192.147.159.000', 'US'),
    ('192.147.210.000', 'BR'),
    ('192.147.211.000', 'US'),
    ('192.147.212.000', 'GB'),
    ('192.147.213.000', 'CA'),
    ('192.147.214.000', 'US'),
    ('192.147.215.000', 'FI'),
    ('192.147.217.000', 'GB'),
    ('192.147.218.000', 'BR'),
    ('192.147.219.000', 'GB'),
    ('192.147.220.000', 'US'),
    ('192.147.228.000', 'GB'),
    ('192.147.229.000', 'US'),
    ('192.147.231.000', '--'),
    ('192.147.232.000', 'US'),
    ('192.147.235.000', 'AU'),
    ('192.147.236.000', 'US'),
    ('192.147.246.000', 'AU'),
    ('192.147.247.000', 'IT'),
    ('192.147.248.000', 'US'),
    ('192.147.251.000', 'EU'),
    ('192.147.252.000', 'US'),
    ('192.147.253.000', 'AU'),
    ('192.147.254.000', 'US'),
    ('192.147.255.000', '--'),
    ('192.148.000.000', 'US'),
    ('192.148.033.000', 'SE'),
    ('192.148.093.000', 'US'),
    ('192.148.103.000', 'PT'),
    ('192.148.104.000', 'US'),
    ('192.148.112.000', 'AU'),
    ('192.148.166.000', 'RU'),
    ('192.148.167.000', 'ES'),
    ('192.148.168.000', 'US'),
    ('192.148.175.000', 'MX'),
    ('192.148.176.000', 'US'),
    ('192.148.177.000', 'GB'),
    ('192.148.187.000', 'US'),
    ('192.148.192.000', 'NL'),
    ('192.148.193.000', 'IT'),
    ('192.148.194.000', 'GB'),
    ('192.148.195.000', 'US'),
    ('192.148.198.000', 'GB'),
    ('192.148.200.000', 'NL'),
    ('192.148.201.000', 'ES'),
    ('192.148.216.000', 'GB'),
    ('192.148.217.000', 'CA'),
    ('192.148.218.000', 'US'),
    ('192.148.219.000', '--'),
    ('192.148.220.000', 'IT'),
    ('192.148.221.000', 'NZ'),
    ('192.148.222.000', 'US'),
    ('192.148.223.000', 'AU'),
    ('192.148.231.000', 'US'),
    ('192.149.000.000', '--'),
    ('192.149.001.000', 'US'),
    ('192.149.003.000', 'PL'),
    ('192.149.004.000', 'US'),
    ('192.149.005.000', 'FI'),
    ('192.149.006.000', 'DE'),
    ('192.149.008.000', 'US'),
    ('192.149.015.000', 'GB'),
    ('192.149.016.000', 'US'),
    ('192.149.017.000', '--'),
    ('192.149.018.000', 'US'),
    ('192.149.019.000', 'ES'),
    ('192.149.020.000', 'AU'),
    ('192.149.021.000', 'US'),
    ('192.149.023.000', '--'),
    ('192.149.024.000', 'US'),
    ('192.149.027.000', 'AT'),
    ('192.149.028.000', 'US'),
    ('192.149.029.000', 'NL'),
    ('192.149.034.000', 'US'),
    ('192.149.035.000', 'NL'),
    ('192.149.036.000', 'AU'),
    ('192.149.037.000', 'US'),
    ('192.149.039.000', '--'),
    ('192.149.040.000', 'US'),
    ('192.149.041.000', 'FR'),
    ('192.149.042.000', 'US'),
    ('192.149.053.000', 'CA'),
    ('192.149.054.000', 'AU'),
    ('192.149.055.000', 'US'),
    ('192.149.057.000', 'GB'),
    ('192.149.058.000', '--'),
    ('192.149.059.000', 'FR'),
    ('192.149.060.000', 'GB'),
    ('192.149.061.000', 'US'),
    ('192.149.062.000', '--'),
    ('192.149.074.000', 'US'),
    ('192.149.076.000', '--'),
    ('192.149.077.000', 'FR'),
    ('192.149.078.000', 'NO'),
    ('192.149.080.000', 'CA'),
    ('192.149.081.000', 'US'),
    ('192.149.088.000', '--'),
    ('192.149.089.000', 'US'),
    ('192.149.090.000', 'DE'),
    ('192.149.091.000', '--'),
    ('192.149.092.000', 'US'),
    ('192.149.096.000', '--'),
    ('192.149.097.000', 'US'),
    ('192.149.098.000', 'CA'),
    ('192.149.099.000', 'US'),
    ('192.149.100.000', 'NO'),
    ('192.149.101.000', 'US'),
    ('192.149.102.000', 'NO'),
    ('192.149.103.000', 'US'),
    ('192.149.110.000', 'IT'),
    ('192.149.111.000', 'GB'),
    ('192.149.112.000', 'US'),
    ('192.149.117.000', 'GB'),
    ('192.149.118.000', 'NL'),
    ('192.149.119.000', 'GB'),
    ('192.149.122.000', 'US'),
    ('192.149.123.000', 'CA'),
    ('192.149.124.000', 'US'),
    ('192.149.126.000', 'DE'),
    ('192.149.127.000', 'US'),
    ('192.149.149.000', 'AU'),
    ('192.149.150.000', 'US'),
    ('192.149.202.000', 'GU'),
    ('192.149.203.000', 'US'),
    ('192.149.209.000', 'JP'),
    ('192.149.210.000', '--'),
    ('192.149.211.000', 'US'),
    ('192.149.227.000', 'NL'),
    ('192.149.228.000', 'US'),
    ('192.149.232.000', 'AT'),
    ('192.149.233.000', 'US'),
    ('192.149.234.000', '--'),
    ('192.149.235.000', 'US'),
    ('192.149.238.000', 'GB'),
    ('192.149.239.000', 'HK'),
    ('192.149.240.000', 'US'),
    ('192.150.057.000', 'SE'),
    ('192.150.066.000', 'US'),
    ('192.150.069.000', 'SE'),
    ('192.150.073.000', 'US'),
    ('192.150.074.000', 'SE'),
    ('192.150.081.000', 'US'),
    ('192.150.082.000', 'SE'),
    ('192.150.083.000', 'US'),
    ('192.150.084.000', 'SE'),
    ('192.150.087.000', 'US'),
    ('192.150.089.000', 'GB'),
    ('192.150.090.000', 'US'),
    ('192.150.092.000', 'GB'),
    ('192.150.093.000', 'US'),
    ('192.150.094.000', 'NL'),
    ('192.150.095.000', 'US'),
    ('192.150.096.000', 'AU'),
    ('192.150.097.000', 'US'),
    ('192.150.104.000', 'PL'),
    ('192.150.105.000', 'DE'),
    ('192.150.106.000', 'GB'),
    ('192.150.107.000', 'AU'),
    ('192.150.108.000', 'US'),
    ('192.150.124.000', 'NO'),
    ('192.150.125.000', 'US'),
    ('192.150.126.000', 'GT'),
    ('192.150.127.000', 'US'),
    ('192.150.129.000', 'AU'),
    ('192.150.140.000', 'GB'),
    ('192.150.141.000', 'US'),
    ('192.150.142.000', '--'),
    ('192.150.143.000', 'US'),
    ('192.150.144.000', 'NZ'),
    ('192.150.145.000', 'US'),
    ('192.150.146.000', 'IT'),
    ('192.150.147.000', 'US'),
    ('192.150.177.000', 'GB'),
    ('192.150.185.000', '--'),
    ('192.150.186.000', 'US'),
    ('192.150.188.000', 'NO'),
    ('192.150.189.000', 'DE'),
    ('192.150.191.000', 'US'),
    ('192.150.192.000', 'PT'),
    ('192.150.194.000', 'IT'),
    ('192.150.197.000', 'NO'),
    ('192.150.198.000', 'GB'),
    ('192.150.199.000', 'US'),
    ('192.150.200.000', 'AU'),
    ('192.150.201.000', 'US'),
    ('192.150.202.000', 'AU'),
    ('192.150.203.000', 'AT'),
    ('192.150.204.000', 'GB'),
    ('192.150.205.000', 'RU'),
    ('192.150.206.000', 'US'),
    ('192.150.207.000', 'GB'),
    ('192.150.209.000', 'NO'),
    ('192.150.210.000', 'US'),
    ('192.150.211.000', '--'),
    ('192.150.212.000', 'GB'),
    ('192.150.213.000', '--'),
    ('192.150.216.000', 'US'),
    ('192.150.218.000', 'NZ'),
    ('192.150.221.000', 'US'),
    ('192.150.223.000', 'NO'),
    ('192.150.224.000', 'US'),
    ('192.150.227.000', 'GB'),
    ('192.150.234.000', 'AU'),
    ('192.150.238.000', 'HU'),
    ('192.150.239.000', 'US'),
    ('192.150.244.000', '--'),
    ('192.150.245.000', 'US'),
    ('192.150.246.000', 'AU'),
    ('192.150.247.000', 'US'),
    ('192.150.248.000', 'GB'),
    ('192.150.249.000', 'TH'),
    ('192.150.252.000', 'NO'),
    ('192.150.253.000', 'US'),
    ('192.150.254.000', 'NO'),
    ('192.150.255.000', '--'),
    ('192.151.000.000', 'US'),
    ('192.151.054.000', 'CH'),
    ('192.151.055.000', 'US'),
    ('192.151.109.000', 'CA'),
    ('192.151.110.000', 'US'),
    ('192.151.111.000', 'NL'),
    ('192.151.113.000', 'US'),
    ('192.151.129.000', 'IN'),
    ('192.151.130.000', '--'),
    ('192.152.000.000', 'US'),
    ('192.152.006.000', 'NO'),
    ('192.152.007.000', 'US'),
    ('192.152.014.000', 'GB'),
    ('192.152.015.000', 'US'),
    ('192.152.017.000', 'GB'),
    ('192.152.018.000', 'US'),
    ('192.152.026.000', 'DE'),
    ('192.152.028.000', 'US'),
    ('192.152.042.000', 'FR'),
    ('192.152.043.000', 'US'),
    ('192.152.044.000', 'GB'),
    ('192.152.045.000', 'US'),
    ('192.152.047.000', 'PT'),
    ('192.152.048.000', 'GB'),
    ('192.152.052.000', 'US'),
    ('192.152.054.000', 'AT'),
    ('192.152.055.000', 'US'),
    ('192.152.061.000', 'GB'),
    ('192.152.063.000', 'AT'),
    ('192.152.064.000', 'US'),
    ('192.152.068.000', 'FI'),
    ('192.152.069.000', 'JP'),
    ('192.152.070.000', 'US'),
    ('192.152.082.000', 'DE'),
    ('192.152.083.000', 'US'),
    ('192.152.086.000', 'AU'),
    ('192.152.088.000', 'US'),
    ('192.152.097.000', 'CA'),
    ('192.152.098.000', 'CH'),
    ('192.152.099.000', 'US'),
    ('192.152.107.000', 'CA'),
    ('192.152.108.000', 'US'),
    ('192.152.110.000', '--'),
    ('192.152.111.000', 'NO'),
    ('192.152.112.000', 'GB'),
    ('192.152.113.000', 'US'),
    ('192.152.118.000', '--'),
    ('192.152.119.000', 'AU'),
    ('192.152.120.000', 'US'),
    ('192.152.122.000', 'GB'),
    ('192.152.123.000', 'US'),
    ('192.152.124.000', 'BE'),
    ('192.152.125.000', 'US'),
    ('192.152.141.000', 'IT'),
    ('192.152.142.000', 'US'),
    ('192.152.144.000', 'AU'),
    ('192.152.145.000', 'US'),
    ('192.152.146.000', 'AU'),
    ('192.152.147.000', 'US'),
    ('192.152.151.000', 'DE'),
    ('192.152.152.000', '--'),
    ('192.152.154.000', 'US'),
    ('192.152.156.000', 'GB'),
    ('192.152.157.000', 'US'),
    ('192.152.164.000', 'PR'),
    ('192.152.165.000', 'CA'),
    ('192.152.166.000', 'IT'),
    ('192.152.167.000', 'FR'),
    ('192.152.168.000', 'US'),
    ('192.152.174.000', 'PT'),
    ('192.152.175.000', 'US'),
    ('192.152.184.000', 'GB'),
    ('192.152.188.000', 'US'),
    ('192.152.192.000', '--'),
    ('192.152.194.000', 'US'),
    ('192.152.195.000', 'CA'),
    ('192.152.196.000', 'US'),
    ('192.152.197.000', 'AU'),
    ('192.152.198.000', 'US'),
    ('192.152.212.000', 'JP'),
    ('192.152.213.000', '--'),
    ('192.152.215.000', 'US'),
    ('192.152.241.000', 'GB'),
    ('192.152.242.000', 'US'),
    ('192.152.244.000', 'GB'),
    ('192.152.245.000', 'US'),
    ('192.152.248.000', 'CA'),
    ('192.152.249.000', 'US'),
    ('192.152.253.000', 'GB'),
    ('192.152.254.000', 'AT'),
    ('192.152.255.000', '--'),
    ('192.153.001.000', 'US'),
    ('192.153.002.000', 'GB'),
    ('192.153.004.000', 'US'),
    ('192.153.006.000', 'JP'),
    ('192.153.007.000', 'US'),
    ('192.153.009.000', 'AU'),
    ('192.153.010.000', 'US'),
    ('192.153.012.000', 'GB'),
    ('192.153.013.000', 'PT'),
    ('192.153.014.000', 'US'),
    ('192.153.018.000', 'HU'),
    ('192.153.020.000', 'US'),
    ('192.153.088.000', 'BR'),
    ('192.153.089.000', 'CH'),
    ('192.153.090.000', 'US'),
    ('192.153.093.000', 'AU'),
    ('192.153.094.000', 'US'),
    ('192.153.095.000', 'JP'),
    ('192.153.115.000', 'US'),
    ('192.153.116.000', 'HU'),
    ('192.153.117.000', 'US'),
    ('192.153.119.000', 'CL'),
    ('192.153.120.000', 'BR'),
    ('192.153.121.000', 'US'),
    ('192.153.127.000', 'PL'),
    ('192.153.128.000', 'US'),
    ('192.153.153.000', 'GB'),
    ('192.153.154.000', 'US'),
    ('192.153.155.000', 'BR'),
    ('192.153.156.000', 'US'),
    ('192.153.158.000', 'AU'),
    ('192.153.159.000', 'US'),
    ('192.153.166.000', 'GB'),
    ('192.153.167.000', 'CR'),
    ('192.153.168.000', 'BE'),
    ('192.153.169.000', 'US'),
    ('192.153.171.000', 'RU'),
    ('192.153.172.000', 'US'),
    ('192.153.173.000', 'AT'),
    ('192.153.183.000', 'US'),
    ('192.153.188.000', 'SE'),
    ('192.153.189.000', 'GB'),
    ('192.153.190.000', 'US'),
    ('192.153.194.000', 'NO'),
    ('192.153.195.000', 'US'),
    ('192.153.196.000', 'AU'),
    ('192.153.198.000', 'US'),
    ('192.153.213.000', 'GB'),
    ('192.153.214.000', 'US'),
    ('192.153.217.000', 'CA'),
    ('192.153.218.000', 'US'),
    ('192.153.220.000', 'CA'),
    ('192.153.221.000', 'PH'),
    ('192.153.229.000', 'US'),
    ('192.153.251.000', 'NZ'),
    ('192.153.252.000', 'US'),
    ('192.154.016.000', 'SG'),
    ('192.154.032.000', 'US'),
    ('192.154.132.000', '--'),
    ('192.155.000.000', 'NO'),
    ('192.155.008.000', 'US'),
    ('192.155.072.000', '--'),
    ('192.155.128.000', 'US'),
    ('192.155.160.000', '--'),
    ('192.156.000.000', 'US'),
    ('192.156.132.000', 'BE'),
    ('192.156.133.000', 'US'),
    ('192.156.140.000', 'JP'),
    ('192.156.160.000', 'US'),
    ('192.156.162.000', 'GB'),
    ('192.156.163.000', 'US'),
    ('192.156.164.000', '--'),
    ('192.156.165.000', 'NZ'),
    ('192.156.166.000', 'US'),
    ('192.156.167.000', 'GB'),
    ('192.156.168.000', 'US'),
    ('192.156.199.000', 'BM'),
    ('192.156.200.000', 'US'),
    ('192.156.207.000', 'AU'),
    ('192.156.209.000', 'US'),
    ('192.156.210.000', 'PT'),
    ('192.156.211.000', 'US'),
    ('192.156.213.000', 'IT'),
    ('192.156.214.000', 'US'),
    ('192.156.216.000', '--'),
    ('192.156.217.000', 'GB'),
    ('192.156.218.000', 'US'),
    ('192.156.220.000', 'JP'),
    ('192.156.221.000', 'US'),
    ('192.156.225.000', 'NZ'),
    ('192.156.226.000', 'US'),
    ('192.156.227.000', 'BE'),
    ('192.156.228.000', 'US'),
    ('192.156.232.000', '--'),
    ('192.156.234.000', 'US'),
    ('192.156.235.000', '--'),
    ('192.156.239.000', 'GB'),
    ('192.156.240.000', 'US'),
    ('192.156.244.000', '--'),
    ('192.156.248.000', 'LU'),
    ('192.156.249.000', 'AU'),
    ('192.156.250.000', 'US'),
    ('192.156.251.000', '--'),
    ('192.156.252.000', 'US'),
    ('192.157.000.000', 'NO'),
    ('192.157.004.000', 'US'),
    ('192.157.006.000', '--'),
    ('192.157.008.000', 'SE'),
    ('192.157.018.000', '--'),
    ('192.157.031.000', 'US'),
    ('192.157.040.000', '--'),
    ('192.157.064.000', 'US'),
    ('192.157.080.000', '--'),
    ('192.157.128.000', 'US'),
    ('192.157.129.000', 'NO'),
    ('192.157.130.000', 'US'),
    ('192.157.138.000', 'JP'),
    ('192.157.139.000', 'DE'),
    ('192.157.141.000', 'GB'),
    ('192.157.142.000', 'US'),
    ('192.157.143.000', 'CA'),
    ('192.157.146.000', 'US'),
    ('192.157.150.000', 'JP'),
    ('192.157.153.000', 'CH'),
    ('192.157.154.000', 'DE'),
    ('192.157.159.000', 'CA'),
    ('192.157.160.000', 'US'),
    ('192.157.162.000', 'HK'),
    ('192.157.163.000', 'US'),
    ('192.157.164.000', 'CA'),
    ('192.157.165.000', 'AT'),
    ('192.157.166.000', 'US'),
    ('192.157.168.000', 'AT'),
    ('192.157.169.000', 'GB'),
    ('192.157.171.000', 'DE'),
    ('192.157.172.000', 'GB'),
    ('192.157.173.000', 'CA'),
    ('192.157.174.000', 'GB'),
    ('192.157.175.000', 'US'),
    ('192.157.176.000', 'GB'),
    ('192.157.177.000', 'US'),
    ('192.157.185.000', 'IT'),
    ('192.157.186.000', 'CA'),
    ('192.157.187.000', 'GB'),
    ('192.157.188.000', 'US'),
    ('192.157.189.000', 'CH'),
    ('192.157.190.000', 'ZA'),
    ('192.157.191.000', 'HK'),
    ('192.157.192.000', '--'),
    ('192.158.000.000', 'US'),
    ('192.158.067.000', 'GB'),
    ('192.158.068.000', 'US'),
    ('192.159.016.000', 'SG'),
    ('192.159.032.000', 'US'),
    ('192.159.040.000', '--'),
    ('192.159.070.000', 'FI'),
    ('192.159.071.000', 'CA'),
    ('192.159.072.000', 'US'),
    ('192.159.073.000', 'GB'),
    ('192.159.074.000', 'US'),
    ('192.159.077.000', 'IT'),
    ('192.159.078.000', 'US'),
    ('192.159.084.000', 'ES'),
    ('192.159.086.000', 'US'),
    ('192.159.090.000', 'BE'),
    ('192.159.091.000', '--'),
    ('192.159.092.000', 'US'),
    ('192.159.093.000', '--'),
    ('192.159.094.000', 'CA'),
    ('192.159.095.000', 'DE'),
    ('192.159.096.000', 'US'),
    ('192.159.099.000', 'GB'),
    ('192.159.104.000', 'US'),
    ('192.159.105.000', 'NL'),
    ('192.159.106.000', 'CA'),
    ('192.159.107.000', 'US'),
    ('192.159.108.000', 'NO'),
    ('192.159.109.000', 'IE'),
    ('192.159.110.000', 'US'),
    ('192.159.111.000', 'CA'),
    ('192.159.112.000', 'US'),
    ('192.159.116.000', 'BR'),
    ('192.159.118.000', 'IE'),
    ('192.159.119.000', '--'),
    ('192.159.120.000', 'US'),
    ('192.159.121.000', 'FR'),
    ('192.159.122.000', 'FI'),
    ('192.159.123.000', '--'),
    ('192.159.128.000', 'US'),
    ('192.159.144.000', '--'),
    ('192.160.000.000', 'US'),
    ('192.160.007.000', 'CA'),
    ('192.160.008.000', 'US'),
    ('192.160.010.000', 'IE'),
    ('192.160.011.000', 'US'),
    ('192.160.015.000', 'SI'),
    ('192.160.016.000', 'AU'),
    ('192.160.017.000', 'US'),
    ('192.160.019.000', 'AU'),
    ('192.160.020.000', 'US'),
    ('192.160.021.000', 'TR'),
    ('192.160.022.000', 'LU'),
    ('192.160.023.000', 'SE'),
    ('192.160.024.000', '--'),
    ('192.160.025.000', 'US'),
    ('192.160.027.000', 'IT'),
    ('192.160.028.000', 'US'),
    ('192.160.029.000', 'PG'),
    ('192.160.030.000', 'US'),
    ('192.160.033.000', 'ES'),
    ('192.160.034.000', 'US'),
    ('192.160.037.000', 'IT'),
    ('192.160.038.000', 'US'),
    ('192.160.045.000', 'BR'),
    ('192.160.046.000', 'US'),
    ('192.160.048.000', '--'),
    ('192.160.049.000', 'US'),
    ('192.160.050.000', 'BR'),
    ('192.160.051.000', 'US'),
    ('192.160.065.000', 'DE'),
    ('192.160.066.000', '--'),
    ('192.160.067.000', 'AT'),
    ('192.160.068.000', 'US'),
    ('192.160.071.000', 'AU'),
    ('192.160.072.000', 'US'),
    ('192.160.095.000', 'CH'),
    ('192.160.097.000', 'US'),
    ('192.160.109.000', 'GB'),
    ('192.160.110.000', 'PL'),
    ('192.160.111.000', 'BR'),
    ('192.160.112.000', 'US'),
    ('192.160.123.000', 'FR'),
    ('192.160.124.000', 'US'),
    ('192.160.126.000', 'NO'),
    ('192.160.127.000', 'US'),
    ('192.160.128.000', 'BR'),
    ('192.160.129.000', 'US'),
    ('192.160.142.000', 'DE'),
    ('192.160.143.000', 'GB'),
    ('192.160.144.000', 'US'),
    ('192.160.152.000', 'NL'),
    ('192.160.153.000', 'US'),
    ('192.160.155.000', 'AU'),
    ('192.160.156.000', 'IT'),
    ('192.160.157.000', 'US'),
    ('192.160.160.000', 'IT'),
    ('192.160.161.000', 'JP'),
    ('192.160.162.000', 'US'),
    ('192.160.167.000', 'CA'),
    ('192.160.168.000', 'US'),
    ('192.160.169.000', 'AU'),
    ('192.160.172.000', 'HU'),
    ('192.160.173.000', 'US'),
    ('192.160.174.000', 'PR'),
    ('192.160.177.000', 'GB'),
    ('192.160.180.000', 'US'),
    ('192.160.185.000', 'GB'),
    ('192.160.186.000', 'US'),
    ('192.160.188.000', 'BR'),
    ('192.160.189.000', 'US'),
    ('192.160.194.000', 'GB'),
    ('192.160.196.000', 'US'),
    ('192.160.205.000', 'AU'),
    ('192.160.206.000', 'US'),
    ('192.160.224.000', 'NO'),
    ('192.160.226.000', 'NZ'),
    ('192.160.227.000', 'US'),
    ('192.160.229.000', 'AU'),
    ('192.160.230.000', 'US'),
    ('192.160.231.000', 'AT'),
    ('192.160.233.000', 'RU'),
    ('192.160.234.000', 'US'),
    ('192.160.245.000', 'PT'),
    ('192.160.252.000', 'IL'),
    ('192.160.253.000', 'US'),
    ('192.160.255.000', '--'),
    ('192.161.000.000', 'US'),
    ('192.161.064.000', 'BE'),
    ('192.161.066.000', '--'),
    ('192.161.128.000', 'NZ'),
    ('192.161.130.000', '--'),
    ('192.162.000.000', 'EU'),
    ('192.162.016.000', 'RO'),
    ('192.162.017.000', 'EU'),
    ('192.163.000.000', 'US'),
    ('192.163.032.000', 'FI'),
    ('192.163.160.000', '--'),
    ('192.164.000.000', 'AT'),
    ('192.165.000.000', 'SE'),
    ('192.166.000.000', 'DE'),
    ('192.167.000.000', 'IT'),
    ('192.168.000.000', 'I0'),
    ('192.169.000.000', 'US'),
    ('192.169.032.000', 'SG'),
    ('192.169.048.000', '--'),
    ('192.169.064.000', 'US'),
    ('192.169.066.000', '--'),
    ('192.170.000.000', 'US'),
    ('192.170.058.000', 'AU'),
    ('192.170.061.000', 'US'),
    ('192.170.096.000', 'CH'),
    ('192.170.103.000', 'US'),
    ('192.170.104.000', 'CH'),
    ('192.170.128.000', 'US'),
    ('192.170.129.000', '--'),
    ('192.171.000.000', 'EU'),
    ('192.171.006.000', '--'),
    ('192.171.007.000', 'US'),
    ('192.171.018.000', '--'),
    ('192.171.064.000', 'US'),
    ('192.171.128.000', 'GB'),
    ('192.172.000.000', 'US'),
    ('192.172.227.000', 'JP'),
    ('192.172.229.000', '--'),
    ('192.172.232.000', 'JP'),
    ('192.172.247.000', 'US'),
    ('192.172.250.000', 'CA'),
    ('192.172.251.000', 'US'),
    ('192.172.253.000', 'LU'),
    ('192.172.254.000', 'CA'),
    ('192.172.255.000', '--'),
    ('192.173.000.000', 'GB'),
    ('192.173.008.000', 'US'),
    ('192.173.016.000', 'NZ'),
    ('192.173.032.000', 'US'),
    ('192.173.064.000', '--'),
    ('192.173.128.000', 'GB'),
    ('192.173.136.000', '--'),
    ('192.174.000.000', 'US'),
    ('192.174.064.000', 'AT'),
    ('192.174.072.000', '--'),
    ('192.174.128.000', 'JP'),
    ('192.175.000.000', 'US'),
    ('192.175.032.000', 'FI'),
    ('192.175.048.000', '--'),
    ('192.175.064.000', 'US'),
    ('192.175.096.000', '--'),
    ('192.175.128.000', 'US'),
    ('192.176.000.000', 'SE'),
    ('192.177.000.000', '--'),
    ('192.184.004.000', 'US'),
    ('192.184.005.000', '--'),
    ('192.187.000.000', 'US'),
    ('192.187.016.000', 'ES'),
    ('192.187.032.000', 'US'),
    ('192.187.096.000', '--'),
    ('192.187.128.000', 'US'),
    ('192.188.008.000', '--'),
    ('192.188.010.000', 'PT'),
    ('192.188.011.000', 'BR'),
    ('192.188.012.000', 'US'),
    ('192.188.043.000', 'NZ'),
    ('192.188.044.000', 'EC'),
    ('192.188.061.000', 'US'),
    ('192.188.063.000', 'GB'),
    ('192.188.065.000', 'FR'),
    ('192.188.066.000', 'US'),
    ('192.188.069.000', 'GB'),
    ('192.188.070.000', 'US'),
    ('192.188.071.000', 'NZ'),
    ('192.188.072.000', 'US'),
    ('192.188.073.000', 'JP'),
    ('192.188.093.000', 'US'),
    ('192.188.095.000', '--'),
    ('192.188.096.000', 'GB'),
    ('192.188.097.000', 'US'),
    ('192.188.101.000', 'AU'),
    ('192.188.102.000', 'US'),
    ('192.188.105.000', 'NO'),
    ('192.188.106.000', 'US'),
    ('192.188.107.000', 'AU'),
    ('192.188.108.000', 'US'),
    ('192.188.115.000', 'AU'),
    ('192.188.116.000', 'RU'),
    ('192.188.117.000', 'GB'),
    ('192.188.118.000', 'US'),
    ('192.188.121.000', 'AT'),
    ('192.188.122.000', 'GB'),
    ('192.188.123.000', 'US'),
    ('192.188.125.000', 'GB'),
    ('192.188.126.000', 'US'),
    ('192.188.127.000', 'IE'),
    ('192.188.128.000', 'AU'),
    ('192.188.129.000', 'GB'),
    ('192.188.130.000', 'US'),
    ('192.188.132.000', 'GB'),
    ('192.188.133.000', 'US'),
    ('192.188.136.000', 'DE'),
    ('192.188.137.000', 'US'),
    ('192.188.145.000', 'GB'),
    ('192.188.146.000', 'US'),
    ('192.188.151.000', 'AU'),
    ('192.188.152.000', 'US'),
    ('192.188.157.000', 'GB'),
    ('192.188.159.000', 'US'),
    ('192.188.164.000', 'ZA'),
    ('192.188.168.000', 'CA'),
    ('192.188.170.000', 'CN'),
    ('192.188.171.000', 'TW'),
    ('192.188.172.000', 'TH'),
    ('192.188.173.000', 'PR'),
    ('192.188.174.000', 'PH'),
    ('192.188.175.000', 'ID'),
    ('192.188.176.000', 'US'),
    ('192.188.185.000', 'NZ'),
    ('192.188.186.000', 'AU'),
    ('192.188.187.000', 'RU'),
    ('192.188.188.000', 'US'),
    ('192.188.189.000', 'RU'),
    ('192.188.190.000', 'US'),
    ('192.188.194.000', 'EC'),
    ('192.188.198.000', 'US'),
    ('192.188.233.000', 'PL'),
    ('192.188.238.000', 'US'),
    ('192.188.241.000', 'NZ'),
    ('192.188.242.000', 'HU'),
    ('192.188.248.000', 'BE'),
    ('192.188.249.000', 'US'),
    ('192.188.251.000', '--'),
    ('192.188.252.000', 'US'),
    ('192.189.000.000', '--'),
    ('192.189.001.000', 'GB'),
    ('192.189.002.000', '--'),
    ('192.189.003.000', 'US'),
    ('192.189.008.000', 'GB'),
    ('192.189.012.000', '--'),
    ('192.189.013.000', 'US'),
    ('192.189.014.000', 'DE'),
    ('192.189.015.000', 'US'),
    ('192.189.021.000', '--'),
    ('192.189.022.000', 'CA'),
    ('192.189.023.000', 'GB'),
    ('192.189.024.000', 'JP'),
    ('192.189.025.000', '--'),
    ('192.189.030.000', 'US'),
    ('192.189.034.000', 'NZ'),
    ('192.189.035.000', 'US'),
    ('192.189.036.000', '--'),
    ('192.189.041.000', 'GB'),
    ('192.189.042.000', 'US'),
    ('192.189.051.000', 'AT'),
    ('192.189.052.000', 'GB'),
    ('192.189.053.000', 'US'),
    ('192.189.054.000', 'AU'),
    ('192.189.055.000', 'GB'),
    ('192.189.056.000', 'US'),
    ('192.189.066.000', 'FR'),
    ('192.189.067.000', 'CA'),
    ('192.189.069.000', 'GB'),
    ('192.189.070.000', 'IL'),
    ('192.189.071.000', 'US'),
    ('192.189.073.000', 'NL'),
    ('192.189.074.000', 'US'),
    ('192.189.075.000', 'ZA'),
    ('192.189.076.000', 'DE'),
    ('192.189.077.000', 'US'),
    ('192.189.078.000', '--'),
    ('192.189.079.000', 'US'),
    ('192.189.094.000', 'AU'),
    ('192.189.095.000', 'US'),
    ('192.189.119.000', 'GB'),
    ('192.189.120.000', 'US'),
    ('192.189.136.000', 'AU'),
    ('192.189.137.000', 'US'),
    ('192.189.139.000', 'ZA'),
    ('192.189.141.000', 'US'),
    ('192.189.148.000', 'AU'),
    ('192.189.149.000', 'US'),
    ('192.189.151.000', 'DE'),
    ('192.189.152.000', '--'),
    ('192.189.154.000', 'IT'),
    ('192.189.155.000', 'US'),
    ('192.189.156.000', 'CA'),
    ('192.189.157.000', 'GB'),
    ('192.189.158.000', 'US'),
    ('192.189.159.000', 'AU'),
    ('192.189.160.000', 'GB'),
    ('192.189.161.000', 'US'),
    ('192.189.166.000', 'GB'),
    ('192.189.171.000', 'US'),
    ('192.189.200.000', '--'),
    ('192.189.202.000', 'GB'),
    ('192.189.204.000', 'US'),
    ('192.189.208.000', 'AU'),
    ('192.189.212.000', 'US'),
    ('192.189.223.000', 'PH'),
    ('192.189.224.000', 'US'),
    ('192.189.229.000', 'AU'),
    ('192.189.234.000', 'US'),
    ('192.189.251.000', 'DE'),
    ('192.189.252.000', 'US'),
    ('192.190.030.000', 'BR'),
    ('192.190.032.000', 'US'),
    ('192.190.042.000', '--'),
    ('192.190.044.000', 'GB'),
    ('192.190.045.000', 'US'),
    ('192.190.058.000', 'NO'),
    ('192.190.060.000', 'US'),
    ('192.190.061.000', 'AU'),
    ('192.190.062.000', 'US'),
    ('192.190.064.000', 'GB'),
    ('192.190.065.000', 'US'),
    ('192.190.066.000', 'AU'),
    ('192.190.067.000', 'GB'),
    ('192.190.068.000', 'US'),
    ('192.190.069.000', 'FR'),
    ('192.190.070.000', 'US'),
    ('192.190.075.000', 'CA'),
    ('192.190.076.000', 'US'),
    ('192.190.080.000', '--'),
    ('192.190.095.000', 'NO'),
    ('192.190.096.000', 'US'),
    ('192.190.108.000', 'NZ'),
    ('192.190.109.000', 'US'),
    ('192.190.129.000', 'FR'),
    ('192.190.133.000', 'US'),
    ('192.190.173.000', 'HU'),
    ('192.190.174.000', 'PT'),
    ('192.190.175.000', 'US'),
    ('192.190.180.000', 'AU'),
    ('192.190.182.000', 'GB'),
    ('192.190.184.000', 'US'),
    ('192.190.190.000', 'NO'),
    ('192.190.194.000', 'US'),
    ('192.190.201.000', 'GB'),
    ('192.190.203.000', 'US'),
    ('192.190.204.000', 'SG'),
    ('192.190.206.000', '--'),
    ('192.190.208.000', 'AU'),
    ('192.190.216.000', 'US'),
    ('192.190.220.000', '--'),
    ('192.190.224.000', 'US'),
    ('192.190.233.000', 'FR'),
    ('192.190.237.000', 'US'),
    ('192.190.240.000', 'GB'),
    ('192.190.241.000', 'US'),
    ('192.190.242.000', 'FR'),
    ('192.190.243.000', 'US'),
    ('192.190.247.000', 'GB'),
    ('192.190.250.000', 'US'),
    ('192.191.002.000', 'CA'),
    ('192.191.003.000', 'US'),
    ('192.191.006.000', 'PR'),
    ('192.191.007.000', 'US'),
    ('192.191.011.000', 'CA'),
    ('192.191.012.000', 'US'),
    ('192.191.016.000', 'PR'),
    ('192.191.017.000', 'US'),
    ('192.191.023.000', 'PR'),
    ('192.191.024.000', 'US'),
    ('192.191.026.000', 'CA'),
    ('192.191.028.000', 'US'),
    ('192.191.039.000', 'PR'),
    ('192.191.040.000', 'US'),
    ('192.191.079.000', 'CA'),
    ('192.191.080.000', 'US'),
    ('192.191.090.000', 'CA'),
    ('192.191.091.000', 'US'),
    ('192.191.100.000', 'CA'),
    ('192.191.101.000', 'PR'),
    ('192.191.102.000', 'US'),
    ('192.191.138.000', 'CA'),
    ('192.191.139.000', 'US'),
    ('192.191.143.000', 'CA'),
    ('192.191.144.000', 'US'),
    ('192.191.151.000', 'PR'),
    ('192.191.152.000', 'US'),
    ('192.191.160.000', 'PR'),
    ('192.191.161.000', 'CA'),
    ('192.191.162.000', 'US'),
    ('192.191.169.000', 'PR'),
    ('192.191.170.000', 'US'),
    ('192.191.185.000', 'PR'),
    ('192.191.186.000', 'CA'),
    ('192.191.187.000', 'PR'),
    ('192.191.188.000', 'CA'),
    ('192.191.189.000', 'PR'),
    ('192.191.190.000', 'US'),
    ('192.191.196.000', 'PR'),
    ('192.191.197.000', 'US'),
    ('192.191.200.000', 'CA'),
    ('192.191.201.000', 'US'),
    ('192.191.217.000', 'CA'),
    ('192.191.218.000', 'US'),
    ('192.191.225.000', 'CA'),
    ('192.191.226.000', 'US'),
    ('192.191.227.000', 'CA'),
    ('192.191.228.000', 'US'),
    ('192.191.231.000', 'CA'),
    ('192.191.232.000', 'US'),
    ('192.191.233.000', 'CA'),
    ('192.191.234.000', 'US'),
    ('192.191.235.000', 'CA'),
    ('192.191.236.000', 'US'),
    ('192.191.237.000', 'CA'),
    ('192.191.238.000', 'US'),
    ('192.192.000.000', 'TW'),
    ('192.192.098.000', 'CH'),
    ('192.192.099.000', 'TW'),
    ('192.193.000.000', 'US'),
    ('192.194.000.000', 'FI'),
    ('192.194.161.000', 'GB'),
    ('192.194.162.000', 'FI'),
    ('192.194.202.000', 'DE'),
    ('192.194.203.000', 'FI'),
    ('192.195.000.000', '--'),
    ('192.195.001.000', 'GB'),
    ('192.195.002.000', 'AU'),
    ('192.195.003.000', 'US'),
    ('192.195.008.000', 'RU'),
    ('192.195.009.000', 'US'),
    ('192.195.010.000', 'AU'),
    ('192.195.011.000', 'US'),
    ('192.195.012.000', 'NZ'),
    ('192.195.015.000', 'US'),
    ('192.195.034.000', 'AU'),
    ('192.195.035.000', 'US'),
    ('192.195.036.000', '--'),
    ('192.195.037.000', 'US'),
    ('192.195.039.000', 'KR'),
    ('192.195.041.000', 'US'),
    ('192.195.042.000', 'IE'),
    ('192.195.043.000', 'GB'),
    ('192.195.044.000', 'AU'),
    ('192.195.056.000', 'MX'),
    ('192.195.058.000', 'US'),
    ('192.195.063.000', 'GB'),
    ('192.195.067.000', 'US'),
    ('192.195.072.000', 'PL'),
    ('192.195.073.000', 'US'),
    ('192.195.077.000', '--'),
    ('192.195.080.000', 'US'),
    ('192.195.098.000', 'DE'),
    ('192.195.099.000', 'US'),
    ('192.195.102.000', 'AU'),
    ('192.195.103.000', 'US'),
    ('192.195.105.000', 'GB'),
    ('192.195.106.000', 'PL'),
    ('192.195.107.000', 'US'),
    ('192.195.110.000', 'IT'),
    ('192.195.111.000', 'US'),
    ('192.195.112.000', 'AU'),
    ('192.195.113.000', 'US'),
    ('192.195.116.000', 'GB'),
    ('192.195.119.000', 'US'),
    ('192.195.134.000', 'SE'),
    ('192.195.149.000', 'US'),
    ('192.195.152.000', 'AU'),
    ('192.195.153.000', 'US'),
    ('192.195.170.000', 'AU'),
    ('192.195.171.000', 'US'),
    ('192.195.183.000', 'NL'),
    ('192.195.184.000', 'DE'),
    ('192.195.185.000', 'US'),
    ('192.195.186.000', 'NZ'),
    ('192.195.187.000', 'US'),
    ('192.195.195.000', 'PT'),
    ('192.195.196.000', 'US'),
    ('192.195.197.000', 'AU'),
    ('192.195.198.000', 'US'),
    ('192.195.219.000', 'NZ'),
    ('192.195.220.000', 'US'),
    ('192.195.233.000', 'AU'),
    ('192.195.234.000', 'US'),
    ('192.195.236.000', 'GB'),
    ('192.195.237.000', 'BR'),
    ('192.195.238.000', 'US'),
    ('192.196.000.000', 'FR'),
    ('192.197.000.000', 'CA'),
    ('192.197.144.000', 'US'),
    ('192.197.148.000', 'CA'),
    ('192.197.199.000', 'US'),
    ('192.197.201.000', 'CA'),
    ('192.197.220.000', 'US'),
    ('192.197.225.000', 'CA'),
    ('192.198.000.000', '--'),
    ('192.198.004.000', 'US'),
    ('192.198.008.000', 'BR'),
    ('192.198.016.000', 'US'),
    ('192.198.080.000', '--'),
    ('192.198.128.000', 'US'),
    ('192.198.192.000', '--'),
    ('192.199.000.000', 'US'),
    ('192.199.016.000', 'PT'),
    ('192.199.032.000', 'AU'),
    ('192.199.048.000', '--'),
    ('192.199.064.000', 'US'),
    ('192.199.192.000', '--'),
    ('192.200.000.000', 'US'),
    ('192.200.064.000', 'NZ'),
    ('192.200.080.000', '--'),
    ('192.200.128.000', 'US'),
    ('192.200.136.000', '--'),
    ('192.201.000.000', 'US'),
    ('192.203.037.000', 'NZ'),
    ('192.203.038.000', 'AU'),
    ('192.203.040.000', 'US'),
    ('192.203.080.000', 'RU'),
    ('192.203.081.000', 'NZ'),
    ('192.203.096.000', 'US'),
    ('192.203.098.000', '--'),
    ('192.203.099.000', 'NZ'),
    ('192.203.104.000', 'US'),
    ('192.203.106.000', 'CA'),
    ('192.203.108.000', 'FI'),
    ('192.203.110.000', 'US'),
    ('192.203.138.000', 'KR'),
    ('192.203.147.000', 'US'),
    ('192.203.154.000', 'NZ'),
    ('192.203.155.000', 'US'),
    ('192.203.156.000', 'AU'),
    ('192.203.158.000', 'CL'),
    ('192.203.159.000', 'US'),
    ('192.203.176.000', 'AU'),
    ('192.203.177.000', 'MX'),
    ('192.203.178.000', 'US'),
    ('192.203.183.000', 'HK'),
    ('192.203.186.000', 'US'),
    ('192.203.193.000', 'AU'),
    ('192.203.194.000', 'US'),
    ('192.203.197.000', 'CA'),
    ('192.203.198.000', 'US'),
    ('192.203.203.000', 'CA'),
    ('192.203.204.000', 'US'),
    ('192.203.208.000', 'NZ'),
    ('192.203.210.000', 'US'),
    ('192.203.213.000', 'AU'),
    ('192.203.214.000', 'US'),
    ('192.203.216.000', 'NZ'),
    ('192.203.217.000', 'US'),
    ('192.203.219.000', '--'),
    ('192.203.220.000', 'US'),
    ('192.203.227.000', 'SA'),
    ('192.203.228.000', 'US'),
    ('192.203.232.000', 'MO'),
    ('192.203.233.000', 'US'),
    ('192.203.235.000', 'AU'),
    ('192.203.236.000', 'US'),
    ('192.203.247.000', 'TH'),
    ('192.203.248.000', 'US'),
    ('192.203.253.000', 'NZ'),
    ('192.203.254.000', '--'),
    ('192.204.000.000', 'US'),
    ('192.206.000.000', '--'),
    ('192.206.001.000', 'CA'),
    ('192.206.002.000', 'US'),
    ('192.206.004.000', '--'),
    ('192.206.008.000', 'US'),
    ('192.206.028.000', 'CA'),
    ('192.206.029.000', 'US'),
    ('192.206.072.000', '--'),
    ('192.206.074.000', 'US'),
    ('192.206.077.000', 'GB'),
    ('192.206.082.000', 'US'),
    ('192.206.086.000', 'IL'),
    ('192.206.087.000', 'US'),
    ('192.206.092.000', 'CA'),
    ('192.206.096.000', 'US'),
    ('192.206.102.000', 'HK'),
    ('192.206.103.000', 'US'),
    ('192.206.108.000', 'AU'),
    ('192.206.109.000', 'US'),
    ('192.206.110.000', '--'),
    ('192.206.112.000', 'US'),
    ('192.206.117.000', 'AU'),
    ('192.206.118.000', 'US'),
    ('192.206.146.000', 'CA'),
    ('192.206.152.000', 'NZ'),
    ('192.206.158.000', 'US'),
    ('192.206.181.000', 'CA'),
    ('192.206.182.000', 'US'),
    ('192.206.183.000', '--'),
    ('192.206.184.000', 'US'),
    ('192.206.217.000', 'CA'),
    ('192.206.219.000', 'US'),
    ('192.206.222.000', 'IL'),
    ('192.206.227.000', 'US'),
    ('192.207.012.000', '--'),
    ('192.207.013.000', 'US'),
    ('192.207.014.000', 'GB'),
    ('192.207.015.000', 'US'),
    ('192.207.031.000', 'NL'),
    ('192.207.032.000', 'US'),
    ('192.207.033.000', 'AU'),
    ('192.207.034.000', '--'),
    ('192.207.036.000', 'AU'),
    ('192.207.037.000', 'US'),
    ('192.207.040.000', 'EC'),
    ('192.207.043.000', 'US'),
    ('192.207.048.000', 'PR'),
    ('192.207.049.000', 'US'),
    ('192.207.064.000', 'TH'),
    ('192.207.065.000', 'EC'),
    ('192.207.069.000', 'US'),
    ('192.207.076.000', 'CA'),
    ('192.207.077.000', 'US'),
    ('192.207.091.000', 'HK'),
    ('192.207.092.000', 'US'),
    ('192.207.096.000', 'AU'),
    ('192.207.099.000', 'US'),
    ('192.207.113.000', 'AU'),
    ('192.207.114.000', 'US'),
    ('192.207.119.000', 'AU'),
    ('192.207.122.000', 'US'),
    ('192.207.138.000', 'CA'),
    ('192.207.139.000', 'US'),
    ('192.207.141.000', 'GB'),
    ('192.207.142.000', 'LU'),
    ('192.207.143.000', 'NZ'),
    ('192.207.144.000', 'US'),
    ('192.207.146.000', 'CL'),
    ('192.207.147.000', 'US'),
    ('192.207.151.000', 'AU'),
    ('192.207.159.000', 'US'),
    ('192.207.161.000', 'AU'),
    ('192.207.162.000', 'US'),
    ('192.207.165.000', 'AU'),
    ('192.207.166.000', 'US'),
    ('192.207.179.000', 'IT'),
    ('192.207.180.000', 'US'),
    ('192.207.183.000', 'GT'),
    ('192.207.184.000', 'US'),
    ('192.207.187.000', 'AU'),
    ('192.207.188.000', 'US'),
    ('192.207.194.000', 'BR'),
    ('192.207.196.000', 'PT'),
    ('192.207.197.000', 'AU'),
    ('192.207.199.000', 'US'),
    ('192.207.200.000', 'BR'),
    ('192.207.207.000', 'US'),
    ('192.207.242.000', 'TH'),
    ('192.207.243.000', 'US'),
    ('192.207.244.000', 'EC'),
    ('192.207.245.000', 'US'),
    ('192.207.248.000', 'AU'),
    ('192.207.249.000', 'US'),
    ('192.207.252.000', '--'),
    ('192.207.253.000', 'US'),
    ('192.207.254.000', 'TH'),
    ('192.207.255.000', '--'),
    ('192.208.000.000', 'CA'),
    ('192.208.016.000', 'US'),
    ('192.208.160.000', '--'),
    ('192.208.222.000', 'FI'),
    ('192.208.223.000', '--'),
    ('192.209.000.000', 'US'),
    ('192.210.000.000', 'CA'),
    ('192.210.016.000', '--'),
    ('192.210.032.000', 'US'),
    ('192.210.048.000', '--'),
    ('192.210.064.000', 'US'),
    ('192.210.128.000', '--'),
    ('192.211.000.000', 'US'),
    ('192.211.128.000', '--'),
    ('192.212.000.000', 'US'),
    ('192.212.224.000', 'NO'),
    ('192.212.225.000', 'US'),
    ('192.213.000.000', 'CA'),
    ('192.213.001.000', 'US'),
    ('192.214.128.000', '--'),
    ('192.215.000.000', 'US'),
    ('192.218.000.000', 'JP'),
    ('192.219.000.000', 'CA'),
    ('192.220.000.000', 'US'),
    ('192.222.000.000', 'CA'),
    ('192.222.016.000', 'US'),
    ('192.222.128.000', '--'),
    ('192.223.000.000', 'US'),
    ('192.223.064.000', 'BR'),
    ('192.223.128.000', 'US'),
    ('192.224.003.000', 'CA'),
    ('192.224.004.000', 'US'),
    ('192.224.013.000', 'CA'),
    ('192.224.014.000', 'US'),
    ('192.224.027.000', 'CA'),
    ('192.224.028.000', 'US'),
    ('192.224.035.000', 'CA'),
    ('192.224.036.000', 'US'),
    ('192.224.043.000', 'VI'),
    ('192.224.044.000', 'US'),
    ('192.224.047.000', 'CA'),
    ('192.224.048.000', 'US'),
    ('192.224.054.000', 'CA'),
    ('192.224.055.000', 'US'),
    ('192.224.061.000', 'PR'),
    ('192.224.062.000', 'US'),
    ('192.224.078.000', 'CA'),
    ('192.224.079.000', 'US'),
    ('192.224.081.000', 'CA'),
    ('192.224.082.000', 'US'),
    ('192.224.085.000', 'CA'),
    ('192.224.087.000', 'US'),
    ('192.224.089.000', 'CA'),
    ('192.224.093.000', 'US'),
    ('192.224.094.000', 'CA'),
    ('192.224.095.000', 'US'),
    ('192.224.104.000', 'CA'),
    ('192.224.107.000', 'US'),
    ('192.224.121.000', 'CA'),
    ('192.224.122.000', 'US'),
    ('192.224.123.000', 'CA'),
    ('192.224.125.000', 'US'),
    ('192.224.126.000', 'CA'),
    ('192.224.127.000', 'US'),
    ('192.224.141.000', 'CA'),
    ('192.224.142.000', 'US'),
    ('192.224.158.000', 'CA'),
    ('192.224.159.000', 'US'),
    ('192.224.161.000', 'CA'),
    ('192.224.163.000', 'US'),
    ('192.224.171.000', 'CA'),
    ('192.224.175.000', 'US'),
    ('192.224.176.000', 'CA'),
    ('192.224.177.000', 'US'),
    ('192.224.181.000', 'CA'),
    ('192.224.182.000', 'US'),
    ('192.224.202.000', 'PR'),
    ('192.224.203.000', 'US'),
    ('192.224.204.000', 'DE'),
    ('192.224.205.000', 'US'),
    ('192.224.211.000', 'CA'),
    ('192.224.212.000', 'US'),
    ('192.224.214.000', 'CA'),
    ('192.224.215.000', 'US'),
    ('192.224.219.000', 'CA'),
    ('192.224.220.000', 'US'),
    ('192.224.221.000', 'CA'),
    ('192.224.222.000', 'US'),
    ('192.224.227.000', 'CA'),
    ('192.224.228.000', 'US'),
    ('192.224.240.000', 'PR'),
    ('192.224.241.000', 'US'),
    ('192.224.243.000', 'CA'),
    ('192.224.244.000', 'US'),
    ('192.224.246.000', 'CA'),
    ('192.224.247.000', 'US'),
    ('192.224.254.000', 'CA'),
    ('192.224.255.000', 'US'),
    ('192.226.032.000', 'CA'),
    ('192.226.064.000', 'US'),
    ('192.226.128.000', '--'),
    ('192.227.000.000', 'PH'),
    ('192.227.016.000', 'US'),
    ('192.227.128.000', '--'),
    ('192.228.000.000', 'CA'),
    ('192.228.032.000', 'US'),
    ('192.228.080.000', '--'),
    ('192.228.128.000', 'MY'),
    ('192.229.000.000', 'US'),
    ('192.229.064.000', '--'),
    ('192.230.000.000', 'US'),
    ('192.230.016.000', 'NZ'),
    ('192.230.032.000', '--'),
    ('192.231.000.000', 'US'),
    ('192.231.015.000', 'NZ'),
    ('192.231.016.000', 'US'),
    ('192.231.034.000', 'AU'),
    ('192.231.035.000', '--'),
    ('192.231.036.000', 'US'),
    ('192.231.059.000', 'AU'),
    ('192.231.060.000', 'US'),
    ('192.231.066.000', 'CA'),
    ('192.231.067.000', 'AT'),
    ('192.231.068.000', 'US'),
    ('192.231.077.000', 'AU'),
    ('192.231.078.000', 'US'),
    ('192.231.082.000', 'DE'),
    ('192.231.083.000', 'US'),
    ('192.231.084.000', '--'),
    ('192.231.085.000', 'NZ'),
    ('192.231.086.000', 'US'),
    ('192.231.089.000', 'CA'),
    ('192.231.090.000', 'US'),
    ('192.231.092.000', 'PR'),
    ('192.231.098.000', 'US'),
    ('192.231.110.000', 'CL'),
    ('192.231.111.000', 'US'),
    ('192.231.114.000', 'BR'),
    ('192.231.122.000', 'US'),
    ('192.231.127.000', 'AU'),
    ('192.231.128.000', 'US'),
    ('192.231.134.000', '--'),
    ('192.231.135.000', 'AU'),
    ('192.231.138.000', 'US'),
    ('192.231.140.000', 'CL'),
    ('192.231.141.000', 'US'),
    ('192.231.144.000', 'AU'),
    ('192.231.145.000', 'US'),
    ('192.231.166.000', 'AU'),
    ('192.231.169.000', 'SG'),
    ('192.231.171.000', 'US'),
    ('192.231.172.000', 'CA'),
    ('192.231.175.000', 'BR'),
    ('192.231.177.000', 'US'),
    ('192.231.183.000', 'NZ'),
    ('192.231.184.000', 'US'),
    ('192.231.193.000', 'AU'),
    ('192.231.194.000', 'US'),
    ('192.231.203.000', 'AU'),
    ('192.231.204.000', 'US'),
    ('192.231.211.000', 'AU'),
    ('192.231.213.000', 'US'),
    ('192.231.216.000', 'AU'),
    ('192.231.217.000', 'US'),
    ('192.231.218.000', 'AU'),
    ('192.231.219.000', 'US'),
    ('192.231.237.000', 'MZ'),
    ('192.231.238.000', 'US'),
    ('192.231.247.000', 'CA'),
    ('192.231.248.000', 'NZ'),
    ('192.231.249.000', '--'),
    ('192.231.252.000', 'US'),
    ('192.231.254.000', 'ZA'),
    ('192.231.255.000', '--'),
    ('192.232.000.000', 'US'),
    ('192.232.032.000', 'AU'),
    ('192.232.064.000', 'US'),
    ('192.232.128.000', 'AU'),
    ('192.232.160.000', '--'),
    ('192.233.000.000', 'US'),
    ('192.234.023.000', 'CA'),
    ('192.234.024.000', 'US'),
    ('192.234.058.000', 'JP'),
    ('192.234.059.000', 'US'),
    ('192.234.098.000', 'CA'),
    ('192.234.099.000', 'US'),
    ('192.234.105.000', '--'),
    ('192.234.106.000', 'US'),
    ('192.234.107.000', 'IT'),
    ('192.234.113.000', '--'),
    ('192.234.114.000', 'US'),
    ('192.234.118.000', '--'),
    ('192.234.120.000', 'US'),
    ('192.234.171.000', 'CA'),
    ('192.234.172.000', 'US'),
    ('192.234.221.000', '--'),
    ('192.234.222.000', 'US'),
    ('192.234.223.000', 'CA'),
    ('192.234.230.000', 'US'),
    ('192.234.231.000', 'AU'),
    ('192.234.232.000', 'US'),
    ('192.234.245.000', 'AU'),
    ('192.234.246.000', 'US'),
    ('192.234.254.000', 'CA'),
    ('192.234.255.000', '--'),
    ('192.235.000.000', 'US'),
    ('192.235.064.000', '--'),
    ('192.236.000.000', 'US'),
    ('192.236.064.000', '--'),
    ('192.237.000.000', 'CA'),
    ('192.237.032.000', 'US'),
    ('192.237.067.000', 'GB'),
    ('192.237.068.000', 'HK'),
    ('192.237.070.000', 'NL'),
    ('192.237.071.000', 'CA'),
    ('192.237.073.000', 'DE'),
    ('192.237.074.000', 'US'),
    ('192.237.076.000', 'CA'),
    ('192.237.077.000', 'US'),
    ('192.237.080.000', 'DE'),
    ('192.237.081.000', 'GB'),
    ('192.237.083.000', 'US'),
    ('192.237.089.000', 'FR'),
    ('192.237.090.000', 'CH'),
    ('192.237.091.000', 'US'),
    ('192.237.095.000', 'ES'),
    ('192.237.097.000', 'US'),
    ('192.237.099.000', 'LU'),
    ('192.237.100.000', 'US'),
    ('192.237.105.000', 'IT'),
    ('192.237.107.000', 'US'),
    ('192.237.110.000', 'DE'),
    ('192.237.111.000', 'ZA'),
    ('192.237.112.000', 'US'),
    ('192.237.113.000', 'FR'),
    ('192.237.114.000', 'CA'),
    ('192.237.116.000', 'US'),
    ('192.237.119.000', 'JP'),
    ('192.237.120.000', 'US'),
    ('192.237.121.000', 'GB'),
    ('192.237.125.000', 'US'),
    ('192.237.128.000', '--'),
    ('192.238.000.000', 'AU'),
    ('192.238.016.000', 'US'),
    ('192.238.024.000', '--'),
    ('192.238.032.000', 'US'),
    ('192.238.128.000', '--'),
    ('192.239.000.000', 'US'),
    ('192.240.016.000', 'AU'),
    ('192.240.032.000', 'US'),
    ('192.240.048.000', '--'),
    ('192.240.064.000', 'US'),
    ('192.240.096.000', '--'),
    ('192.240.128.000', 'US'),
    ('192.240.160.000', '--'),
    ('192.241.000.000', 'US'),
    ('192.241.064.000', '--'),
    ('192.242.000.000', 'US'),
    ('192.244.000.000', 'JP'),
    ('192.245.000.000', 'US'),
    ('192.245.011.000', 'AU'),
    ('192.245.012.000', 'US'),
    ('192.245.013.000', 'AU'),
    ('192.245.015.000', 'US'),
    ('192.245.024.000', 'CA'),
    ('192.245.025.000', 'US'),
    ('192.245.030.000', 'BR'),
    ('192.245.031.000', 'US'),
    ('192.245.034.000', 'AU'),
    ('192.245.036.000', 'NZ'),
    ('192.245.037.000', 'US'),
    ('192.245.051.000', 'CA'),
    ('192.245.052.000', 'US'),
    ('192.245.058.000', 'SG'),
    ('192.245.060.000', 'CL'),
    ('192.245.061.000', 'US'),
    ('192.245.073.000', 'NZ'),
    ('192.245.081.000', 'US'),
    ('192.245.091.000', 'CA'),
    ('192.245.092.000', 'US'),
    ('192.245.094.000', 'NZ'),
    ('192.245.095.000', 'US'),
    ('192.245.105.000', 'AU'),
    ('192.245.113.000', 'US'),
    ('192.245.121.000', 'BO'),
    ('192.245.122.000', 'US'),
    ('192.245.148.000', 'DZ'),
    ('192.245.149.000', 'US'),
    ('192.245.152.000', 'UA'),
    ('192.245.153.000', 'US'),
    ('192.245.155.000', 'HK'),
    ('192.245.156.000', 'US'),
    ('192.245.169.000', 'PL'),
    ('192.245.170.000', 'US'),
    ('192.245.172.000', 'CA'),
    ('192.245.173.000', 'US'),
    ('192.245.181.000', '--'),
    ('192.245.182.000', 'US'),
    ('192.245.183.000', 'CA'),
    ('192.245.184.000', 'US'),
    ('192.245.185.000', 'NZ'),
    ('192.245.186.000', 'US'),
    ('192.245.192.000', 'AU'),
    ('192.245.193.000', '--'),
    ('192.245.194.000', 'US'),
    ('192.245.196.000', 'HK'),
    ('192.245.197.000', 'US'),
    ('192.245.208.000', 'HK'),
    ('192.245.209.000', 'US'),
    ('192.245.210.000', 'AU'),
    ('192.245.218.000', 'US'),
    ('192.245.219.000', 'AU'),
    ('192.245.220.000', 'NZ'),
    ('192.245.221.000', 'US'),
    ('192.245.225.000', 'GB'),
    ('192.245.226.000', 'US'),
    ('192.245.228.000', 'CA'),
    ('192.245.229.000', 'US'),
    ('192.245.249.000', 'KR'),
    ('192.245.252.000', 'US'),
    ('192.246.007.000', 'AU'),
    ('192.246.008.000', 'US'),
    ('192.246.073.000', 'AU'),
    ('192.246.074.000', 'US'),
    ('192.247.000.000', 'GB'),
    ('192.247.016.000', 'US'),
    ('192.247.096.000', '--'),
    ('192.247.128.000', 'US'),
    ('192.248.000.000', 'LK'),
    ('192.248.128.000', 'US'),
    ('192.249.016.000', 'KR'),
    ('192.249.032.000', 'US'),
    ('192.249.064.000', '--'),
    ('192.250.000.000', 'US'),
    ('192.250.016.000', '--'),
    ('192.250.022.000', 'US'),
    ('192.250.024.000', 'NL'),
    ('192.250.029.000', '--'),
    ('192.250.030.000', 'US'),
    ('192.250.192.000', '--'),
    ('192.251.000.000', 'US'),
    ('192.251.026.000', 'CA'),
    ('192.251.031.000', 'US'),
    ('192.251.039.000', 'CL'),
    ('192.251.040.000', 'US'),
    ('192.251.052.000', 'CA'),
    ('192.251.056.000', 'US'),
    ('192.251.061.000', 'SA'),
    ('192.251.066.000', 'US'),
    ('192.251.091.000', 'CA'),
    ('192.251.092.000', 'US'),
    ('192.251.148.000', 'AU'),
    ('192.251.149.000', 'US'),
    ('192.251.164.000', 'CA'),
    ('192.251.165.000', 'US'),
    ('192.251.166.000', 'CA'),
    ('192.251.167.000', 'US'),
    ('192.251.195.000', 'AU'),
    ('192.251.196.000', 'CA'),
    ('192.251.197.000', 'US'),
    ('192.251.198.000', '--'),
    ('192.251.201.000', 'AU'),
    ('192.251.202.000', 'GH'),
    ('192.251.203.000', 'US'),
    ('192.251.204.000', 'AU'),
    ('192.251.208.000', 'US'),
    ('192.251.226.000', 'DE'),
    ('192.251.227.000', 'TH'),
    ('192.251.229.000', 'AU'),
    ('192.251.230.000', 'NZ'),
    ('192.251.231.000', 'CA'),
    ('192.251.232.000', 'US'),
    ('192.251.240.000', '--'),
    ('192.252.000.000', 'US'),
    ('193.000.000.000', 'NL'),
    ('193.000.014.000', 'GB'),
    ('193.000.015.000', 'NL'),
    ('193.000.032.000', 'CH'),
    ('193.000.056.000', 'DK'),
    ('193.000.061.000', 'TR'),
    ('193.000.062.000', 'CH'),
    ('193.000.064.000', 'PL'),
    ('193.000.128.000', 'FR'),
    ('193.000.224.000', 'GR'),
    ('193.000.228.000', 'DE'),
    ('193.000.232.000', 'CH'),
    ('193.000.234.000', 'DE'),
    ('193.001.000.000', 'IE'),
    ('193.002.000.000', 'SI'),
    ('193.003.000.000', 'DK'),
    ('193.004.000.000', 'IS'),
    ('193.005.000.000', 'CH'),
    ('193.005.026.000', 'LI'),
    ('193.005.028.000', 'CH'),
    ('193.005.096.000', 'FR'),
    ('193.005.097.000', 'ES'),
    ('193.005.098.000', 'IT'),
    ('193.005.099.000', 'MC'),
    ('193.005.100.000', 'LU'),
    ('193.005.101.000', 'DE'),
    ('193.005.103.000', 'CH'),
    ('193.006.000.000', 'HU'),
    ('193.007.000.000', 'DE'),
    ('193.008.000.000', 'CH'),
    ('193.009.000.000', 'EU'),
    ('193.009.008.000', 'BE'),
    ('193.009.012.000', 'SI'),
    ('193.009.013.000', 'HR'),
    ('193.009.014.000', 'YU'),
    ('193.009.015.000', 'GB'),
    ('193.009.016.000', 'DK'),
    ('193.009.032.000', 'DE'),
    ('193.009.048.000', 'NL'),
    ('193.009.054.000', 'SE'),
    ('193.009.055.000', 'NL'),
    ('193.009.058.000', 'SE'),
    ('193.009.060.000', 'NL'),
    ('193.009.064.000', 'EU'),
    ('193.009.112.000', 'FI'),
    ('193.009.113.000', 'FR'),
    ('193.009.114.000', 'IT'),
    ('193.009.115.000', 'NL'),
    ('193.009.116.000', 'NO'),
    ('193.009.117.000', 'SE'),
    ('193.009.118.000', 'DK'),
    ('193.009.119.000', 'GB'),
    ('193.009.120.000', 'EU'),
    ('193.009.124.000', 'HU'),
    ('193.009.128.000', 'EU'),
    ('193.009.148.000', 'GR'),
    ('193.009.149.000', 'HU'),
    ('193.009.150.000', 'PL'),
    ('193.009.151.000', 'AT'),
    ('193.009.152.000', 'GB'),
    ('193.009.158.000', 'EU'),
    ('193.009.160.000', 'DK'),
    ('193.009.255.000', 'AT'),
    ('193.010.000.000', 'SE'),
    ('193.016.000.000', 'DE'),
    ('193.016.084.000', 'NO'),
    ('193.016.085.000', 'DE'),
    ('193.016.214.000', 'AT'),
    ('193.016.216.000', 'DE'),
    ('193.017.025.000', 'CH'),
    ('193.017.026.000', 'DE'),
    ('193.023.055.000', 'SE'),
    ('193.023.056.000', 'DE'),
    ('193.026.046.000', 'RU'),
    ('193.026.047.000', 'DE'),
    ('193.028.237.000', 'GB'),
    ('193.028.238.000', 'DE'),
    ('193.032.000.000', 'GB'),
    ('193.040.000.000', 'EE'),
    ('193.041.000.000', 'GB'),
    ('193.041.002.000', 'TR'),
    ('193.041.004.000', 'UA'),
    ('193.041.006.000', 'IT'),
    ('193.041.008.000', 'DE'),
    ('193.041.012.000', 'DK'),
    ('193.041.014.000', 'ES'),
    ('193.041.016.000', 'IE'),
    ('193.041.024.000', 'ES'),
    ('193.041.032.000', 'SE'),
    ('193.041.033.000', 'LV'),
    ('193.041.034.000', 'GB'),
    ('193.041.035.000', 'SI'),
    ('193.041.036.000', 'DE'),
    ('193.041.038.000', 'FR'),
    ('193.041.039.000', 'NO'),
    ('193.041.040.000', 'LT'),
    ('193.041.041.000', 'AT'),
    ('193.041.042.000', 'BE'),
    ('193.041.043.000', 'ES'),
    ('193.041.044.000', 'FR'),
    ('193.041.045.000', 'LV'),
    ('193.041.046.000', 'ES'),
    ('193.041.047.000', 'FR'),
    ('193.041.048.000', 'UA'),
    ('193.041.052.000', 'DE'),
    ('193.041.056.000', 'GR'),
    ('193.041.060.000', 'UA'),
    ('193.041.064.000', 'BG'),
    ('193.041.068.000', 'NL'),
    ('193.041.071.000', 'FR'),
    ('193.041.076.000', 'IT'),
    ('193.041.080.000', 'UA'),
    ('193.041.081.000', 'LT'),
    ('193.041.082.000', 'DE'),
    ('193.041.083.000', 'FR'),
    ('193.041.084.000', 'IT'),
    ('193.041.086.000', 'RU'),
    ('193.041.087.000', 'DE'),
    ('193.041.088.000', 'UA'),
    ('193.041.089.000', 'SI'),
    ('193.041.090.000', 'CH'),
    ('193.041.091.000', 'IT'),
    ('193.041.092.000', 'GB'),
    ('193.041.093.000', 'GR'),
    ('193.041.094.000', 'AT'),
    ('193.041.095.000', 'FR'),
    ('193.041.096.000', 'GB'),
    ('193.041.104.000', 'CH'),
    ('193.041.112.000', 'PL'),
    ('193.041.114.000', 'PT'),
    ('193.041.116.000', 'MD'),
    ('193.041.118.000', 'SE'),
    ('193.041.120.000', 'PL'),
    ('193.041.124.000', 'DE'),
    ('193.041.126.000', 'RO'),
    ('193.041.128.000', 'UA'),
    ('193.041.132.000', 'DE'),
    ('193.041.136.000', 'CH'),
    ('193.041.140.000', 'RU'),
    ('193.041.144.000', 'DE'),
    ('193.041.146.000', 'DZ'),
    ('193.041.148.000', 'CH'),
    ('193.041.150.000', 'GR'),
    ('193.041.152.000', 'GB'),
    ('193.041.156.000', 'DK'),
    ('193.041.158.000', 'BE'),
    ('193.041.160.000', 'UA'),
    ('193.041.164.000', 'GB'),
    ('193.041.168.000', 'SE'),
    ('193.041.172.000', 'UA'),
    ('193.041.176.000', 'IT'),
    ('193.041.180.000', 'FR'),
    ('193.041.182.000', 'BG'),
    ('193.041.184.000', 'UA'),
    ('193.041.188.000', 'BG'),
    ('193.041.192.000', 'EU'),
    ('193.041.193.000', 'CH'),
    ('193.041.194.000', 'FR'),
    ('193.041.195.000', 'LV'),
    ('193.041.196.000', 'US'),
    ('193.041.197.000', 'LT'),
    ('193.041.198.000', 'IT'),
    ('193.041.199.000', 'DE'),
    ('193.041.201.000', 'AT'),
    ('193.041.202.000', 'IL'),
    ('193.041.203.000', 'SK'),
    ('193.041.204.000', 'LV'),
    ('193.041.205.000', 'IT'),
    ('193.041.206.000', 'BG'),
    ('193.041.207.000', 'EU'),
    ('193.041.208.000', 'IL'),
    ('193.041.210.000', 'DK'),
    ('193.041.212.000', 'DE'),
    ('193.041.214.000', 'SE'),
    ('193.041.216.000', 'RO'),
    ('193.041.218.000', 'UA'),
    ('193.041.220.000', 'GB'),
    ('193.041.222.000', 'FR'),
    ('193.041.224.000', 'SE'),
    ('193.041.225.000', 'US'),
    ('193.041.226.000', 'RU'),
    ('193.041.227.000', 'ES'),
    ('193.041.228.000', 'AT'),
    ('193.041.229.000', 'GR'),
    ('193.041.230.000', 'PL'),
    ('193.041.232.000', 'AT'),
    ('193.041.233.000', 'BE'),
    ('193.041.234.000', 'ES'),
    ('193.041.235.000', 'IT'),
    ('193.041.237.000', 'LU'),
    ('193.041.238.000', 'FR'),
    ('193.041.239.000', 'UA'),
    ('193.041.240.000', 'ES'),
    ('193.041.244.000', 'RO'),
    ('193.041.252.000', 'DE'),
    ('193.042.000.000', 'IE'),
    ('193.042.001.000', 'IT'),
    ('193.042.210.000', 'EU'),
    ('193.042.228.000', 'PL'),
    ('193.042.232.000', 'IT'),
    ('193.042.248.000', 'NL'),
    ('193.043.000.000', 'EU'),
    ('193.043.001.000', 'IT'),
    ('193.043.008.000', 'EU'),
    ('193.043.014.000', 'IT'),
    ('193.043.024.000', 'EU'),
    ('193.043.028.000', 'IT'),
    ('193.043.029.000', 'DE'),
    ('193.043.030.000', 'IT'),
    ('193.043.064.000', 'GB'),
    ('193.043.065.000', 'IT'),
    ('193.043.077.000', 'EU'),
    ('193.043.080.000', 'IT'),
    ('193.043.088.000', 'EU'),
    ('193.043.096.000', 'IT'),
    ('193.043.102.000', 'VA'),
    ('193.043.104.000', 'IT'),
    ('193.043.125.000', 'EU'),
    ('193.043.126.000', 'IT'),
    ('193.043.127.000', 'EU'),
    ('193.043.128.000', 'VA'),
    ('193.043.134.000', 'IT'),
    ('193.043.148.000', 'EU'),
    ('193.043.152.000', 'IT'),
    ('193.043.158.000', 'EU'),
    ('193.043.160.000', 'IT'),
    ('193.043.180.000', 'EU'),
    ('193.043.184.000', 'IT'),
    ('193.043.208.000', 'EU'),
    ('193.044.000.000', 'SE'),
    ('193.045.014.000', 'DE'),
    ('193.045.015.000', 'SE'),
    ('193.045.039.000', 'FI'),
    ('193.045.040.000', 'SE'),
    ('193.045.066.000', 'GB'),
    ('193.045.069.000', 'SE'),
    ('193.045.140.000', 'GB'),
    ('193.045.141.000', 'SE'),
    ('193.045.142.000', 'PL'),
    ('193.045.143.000', 'SE'),
    ('193.045.189.000', 'GB'),
    ('193.045.190.000', 'SE'),
    ('193.046.000.000', 'AT'),
    ('193.046.060.000', 'EU'),
    ('193.046.092.000', 'AT'),
    ('193.047.000.000', 'CH'),
    ('193.048.000.000', 'FR'),
    ('193.053.000.000', 'CH'),
    ('193.053.001.000', 'BE'),
    ('193.053.008.000', 'EU'),
    ('193.053.009.000', 'BE'),
    ('193.053.022.000', 'PT'),
    ('193.053.023.000', 'DE'),
    ('193.053.024.000', 'BE'),
    ('193.053.080.000', 'AT'),
    ('193.053.081.000', 'BE'),
    ('193.053.083.000', 'GB'),
    ('193.053.086.000', 'BE'),
    ('193.053.087.000', 'GB'),
    ('193.053.090.000', 'BE'),
    ('193.053.093.000', 'DE'),
    ('193.053.094.000', 'BE'),
    ('193.053.105.000', 'GR'),
    ('193.053.106.000', 'FR'),
    ('193.053.107.000', 'BE'),
    ('193.053.125.000', 'EU'),
    ('193.053.126.000', 'BE'),
    ('193.053.255.000', 'GB'),
    ('193.054.000.000', 'FR'),
    ('193.056.034.000', 'EU'),
    ('193.056.035.000', 'FR'),
    ('193.056.040.000', 'EU'),
    ('193.056.042.000', 'FR'),
    ('193.056.116.000', 'EU'),
    ('193.056.118.000', 'FR'),
    ('193.056.124.000', 'EU'),
    ('193.056.125.000', 'FR'),
    ('193.057.012.000', 'EU'),
    ('193.057.013.000', 'FR'),
    ('193.057.088.000', 'EU'),
    ('193.057.089.000', 'FR'),
    ('193.057.180.000', 'EU'),
    ('193.057.181.000', 'FR'),
    ('193.057.242.000', 'EU'),
    ('193.057.243.000', 'FR'),
    ('193.058.000.000', 'GB'),
    ('193.058.001.000', 'BE'),
    ('193.058.064.000', 'GB'),
    ('193.058.070.000', 'GR'),
    ('193.058.072.000', 'CZ'),
    ('193.058.080.000', 'BE'),
    ('193.058.091.000', 'EU'),
    ('193.058.092.000', 'BE'),
    ('193.058.173.000', 'CH'),
    ('193.058.186.000', 'EU'),
    ('193.058.188.000', 'GB'),
    ('193.058.192.000', 'SK'),
    ('193.058.198.000', 'GB'),
    ('193.058.200.000', 'DE'),
    ('193.058.204.000', 'NL'),
    ('193.058.209.000', 'CH'),
    ('193.058.210.000', 'AT'),
    ('193.058.216.000', 'CH'),
    ('193.058.224.000', 'BE'),
    ('193.058.232.000', 'EU'),
    ('193.059.000.000', 'PL'),
    ('193.060.000.000', 'GB'),
    ('193.064.000.000', 'FI'),
    ('193.067.000.000', 'NL'),
    ('193.068.000.000', 'BG'),
    ('193.068.032.000', 'HU'),
    ('193.068.064.000', 'LV'),
    ('193.068.096.000', 'BG'),
    ('193.069.000.000', 'NO'),
    ('193.070.000.000', 'IT'),
    ('193.071.000.000', 'NO'),
    ('193.072.000.000', 'CH'),
    ('193.072.116.000', 'DE'),
    ('193.072.117.000', 'CH'),
    ('193.072.229.000', 'DE'),
    ('193.072.230.000', 'CH'),
    ('193.074.000.000', 'BE'),
    ('193.074.011.000', '--'),
    ('193.074.012.000', 'EU'),
    ('193.074.014.000', 'BE'),
    ('193.074.021.000', 'EU'),
    ('193.074.023.000', 'BE'),
    ('193.074.027.000', 'EU'),
    ('193.074.029.000', 'BE'),
    ('193.074.031.000', 'EU'),
    ('193.074.032.000', 'BE'),
    ('193.074.064.000', 'EU'),
    ('193.074.065.000', 'BE'),
    ('193.074.070.000', 'EU'),
    ('193.074.080.000', 'BE'),
    ('193.074.088.000', 'EU'),
    ('193.074.092.000', 'BE'),
    ('193.074.098.000', 'EU'),
    ('193.074.099.000', '--'),
    ('193.074.100.000', 'BE'),
    ('193.074.101.000', 'EU'),
    ('193.074.102.000', 'BE'),
    ('193.074.105.000', 'EU'),
    ('193.074.106.000', 'BE'),
    ('193.074.107.000', 'EU'),
    ('193.074.108.000', 'BE'),
    ('193.074.115.000', '--'),
    ('193.074.116.000', 'BE'),
    ('193.074.118.000', 'EU'),
    ('193.074.120.000', 'BE'),
    ('193.074.121.000', 'EU'),
    ('193.074.122.000', 'BE'),
    ('193.074.137.000', 'EU'),
    ('193.074.138.000', 'BE'),
    ('193.074.143.000', 'EU'),
    ('193.074.144.000', 'BE'),
    ('193.074.145.000', 'EU'),
    ('193.074.146.000', 'BE'),
    ('193.074.148.000', 'EU'),
    ('193.074.149.000', 'BE'),
    ('193.074.185.000', 'EU'),
    ('193.074.186.000', 'BE'),
    ('193.074.202.000', 'EU'),
    ('193.074.204.000', 'BE'),
    ('193.074.211.000', 'EU'),
    ('193.074.212.000', 'BE'),
    ('193.074.213.000', 'EU'),
    ('193.074.214.000', 'BE'),
    ('193.074.216.000', 'EU'),
    ('193.074.218.000', 'BE'),
    ('193.074.229.000', 'EU'),
    ('193.074.230.000', 'NL'),
    ('193.074.232.000', 'BE'),
    ('193.074.236.000', 'EU'),
    ('193.074.240.000', 'BE'),
    ('193.074.246.000', 'EU'),
    ('193.074.247.000', 'BE'),
    ('193.074.248.000', 'EU'),
    ('193.074.249.000', 'BE'),
    ('193.074.251.000', 'EU'),
    ('193.074.252.000', 'BE'),
    ('193.074.255.000', 'EU'),
    ('193.075.000.000', 'NO'),
    ('193.075.128.000', 'BE'),
    ('193.076.000.000', 'IT'),
    ('193.077.000.000', 'EU'),
    ('193.077.001.000', 'SI'),
    ('193.077.013.000', 'EU'),
    ('193.077.014.000', 'SI'),
    ('193.077.029.000', 'EU'),
    ('193.077.031.000', 'SI'),
    ('193.077.054.000', 'EU'),
    ('193.077.058.000', 'SI'),
    ('193.077.062.000', 'EU'),
    ('193.077.065.000', 'SI'),
    ('193.077.070.000', 'EU'),
    ('193.077.071.000', 'SI'),
    ('193.077.106.000', 'EU'),
    ('193.077.108.000', 'SI'),
    ('193.077.111.000', 'EU'),
    ('193.077.112.000', 'SI'),
    ('193.077.119.000', 'EU'),
    ('193.077.120.000', 'SI'),
    ('193.077.127.000', 'EU'),
    ('193.077.128.000', 'SI'),
    ('193.077.150.000', 'EU'),
    ('193.077.153.000', 'SI'),
    ('193.077.203.000', 'EU'),
    ('193.077.204.000', 'SI'),
    ('193.077.212.000', 'EU'),
    ('193.077.213.000', 'SI'),
    ('193.077.219.000', 'EU'),
    ('193.077.221.000', 'SI'),
    ('193.077.224.000', 'EU'),
    ('193.077.225.000', 'SI'),
    ('193.077.233.000', 'EU'),
    ('193.077.237.000', 'SI'),
    ('193.077.239.000', 'EU'),
    ('193.077.241.000', 'SI'),
    ('193.078.000.000', 'NL'),
    ('193.080.000.000', 'AT'),
    ('193.080.025.000', 'PL'),
    ('193.080.026.000', 'CZ'),
    ('193.080.027.000', 'AT'),
    ('193.080.204.000', 'SI'),
    ('193.080.205.000', 'AT'),
    ('193.082.000.000', 'GB'),
    ('193.082.255.000', 'MT'),
    ('193.083.000.000', 'AT'),
    ('193.084.000.000', 'CZ'),
    ('193.084.224.000', 'GB'),
    ('193.084.240.000', 'CZ'),
    ('193.087.000.000', 'SK'),
    ('193.088.000.000', 'DK'),
    ('193.090.000.000', 'NO'),
    ('193.091.000.000', 'PL'),
    ('193.091.032.000', 'BE'),
    ('193.091.035.000', 'LU'),
    ('193.091.037.000', 'BE'),
    ('193.091.038.000', 'LU'),
    ('193.091.046.000', 'BE'),
    ('193.091.048.000', 'MT'),
    ('193.091.064.000', 'HU'),
    ('193.091.096.000', 'BE'),
    ('193.091.128.000', 'NO'),
    ('193.092.000.000', 'GR'),
    ('193.093.000.000', 'LU'),
    ('193.094.000.000', 'FI'),
    ('193.095.000.000', 'TN'),
    ('193.095.128.000', 'IE'),
    ('193.095.192.000', 'SI'),
    ('193.096.000.000', 'DE'),
    ('193.097.191.000', 'GB'),
    ('193.097.192.000', 'DE'),
    ('193.100.140.000', 'CH'),
    ('193.100.142.000', 'DE'),
    ('193.104.000.000', 'FR'),
    ('193.108.000.000', 'SE'),
    ('193.108.008.000', 'DE'),
    ('193.108.016.000', 'UA'),
    ('193.108.017.000', 'SE'),
    ('193.108.018.000', 'GB'),
    ('193.108.019.000', 'DE'),
    ('193.108.020.000', 'FR'),
    ('193.108.022.000', 'AT'),
    ('193.108.023.000', 'GH'),
    ('193.108.024.000', 'BG'),
    ('193.108.025.000', 'IT'),
    ('193.108.026.000', 'CH'),
    ('193.108.027.000', 'NL'),
    ('193.108.028.000', 'GH'),
    ('193.108.029.000', 'LV'),
    ('193.108.030.000', 'FR'),
    ('193.108.032.000', 'BG'),
    ('193.108.034.000', 'PL'),
    ('193.108.036.000', 'UA'),
    ('193.108.040.000', 'AT'),
    ('193.108.042.000', 'SE'),
    ('193.108.044.000', 'BG'),
    ('193.108.046.000', 'UA'),
    ('193.108.052.000', 'RO'),
    ('193.108.056.000', 'UA'),
    ('193.108.060.000', 'IT'),
    ('193.108.064.000', 'CZ'),
    ('193.108.072.000', 'GB'),
    ('193.108.088.000', 'EU'),
    ('193.108.096.000', 'GB'),
    ('193.108.098.000', 'NL'),
    ('193.108.099.000', 'EU'),
    ('193.108.100.000', 'AT'),
    ('193.108.102.000', 'UA'),
    ('193.108.106.000', 'CZ'),
    ('193.108.110.000', 'FR'),
    ('193.108.112.000', 'UA'),
    ('193.108.132.000', 'SK'),
    ('193.108.134.000', 'JO'),
    ('193.108.136.000', 'CH'),
    ('193.108.138.000', 'AT'),
    ('193.108.140.000', 'FR'),
    ('193.108.142.000', 'ES'),
    ('193.108.144.000', 'LV'),
    ('193.108.148.000', 'GB'),
    ('193.108.152.000', 'EU'),
    ('193.108.156.000', 'GB'),
    ('193.108.160.000', 'GR'),
    ('193.108.162.000', 'UA'),
    ('193.108.164.000', 'DE'),
    ('193.108.166.000', 'FR'),
    ('193.108.168.000', 'GB'),
    ('193.108.170.000', 'UA'),
    ('193.108.172.000', 'DE'),
    ('193.108.174.000', 'ES'),
    ('193.108.176.000', 'DE'),
    ('193.108.177.000', 'PL'),
    ('193.108.178.000', 'FR'),
    ('193.108.179.000', 'DE'),
    ('193.108.180.000', 'FR'),
    ('193.108.181.000', 'DE'),
    ('193.108.182.000', 'RU'),
    ('193.108.183.000', 'AT'),
    ('193.108.184.000', 'DE'),
    ('193.108.185.000', 'LV'),
    ('193.108.186.000', 'IT'),
    ('193.108.187.000', 'CH'),
    ('193.108.188.000', 'GB'),
    ('193.108.189.000', 'DK'),
    ('193.108.190.000', 'DE'),
    ('193.108.191.000', 'GB'),
    ('193.108.193.000', 'DE'),
    ('193.108.194.000', 'PL'),
    ('193.108.195.000', 'IL'),
    ('193.108.196.000', 'SE'),
    ('193.108.197.000', 'FR'),
    ('193.108.199.000', 'GB'),
    ('193.108.201.000', 'BE'),
    ('193.108.202.000', 'PL'),
    ('193.108.203.000', 'FR'),
    ('193.108.204.000', 'IT'),
    ('193.108.206.000', 'PL'),
    ('193.108.207.000', 'RU'),
    ('193.108.208.000', 'NO'),
    ('193.108.209.000', 'UA'),
    ('193.108.210.000', 'NL'),
    ('193.108.211.000', 'IL'),
    ('193.108.212.000', 'AT'),
    ('193.108.213.000', 'TR'),
    ('193.108.214.000', 'UG'),
    ('193.108.215.000', 'BE'),
    ('193.108.216.000', 'FR'),
    ('193.108.217.000', 'DE'),
    ('193.108.218.000', 'GB'),
    ('193.108.219.000', 'EU'),
    ('193.108.220.000', 'PL'),
    ('193.108.221.000', 'IT'),
    ('193.108.222.000', 'DE'),
    ('193.108.223.000', 'SE'),
    ('193.108.224.000', 'DK'),
    ('193.108.226.000', 'UA'),
    ('193.108.228.000', 'PL'),
    ('193.108.230.000', 'RU'),
    ('193.108.232.000', 'CH'),
    ('193.108.234.000', 'RO'),
    ('193.108.236.000', 'UA'),
    ('193.108.238.000', 'IT'),
    ('193.108.240.000', 'UA'),
    ('193.108.244.000', 'GB'),
    ('193.108.248.000', 'UA'),
    ('193.108.252.000', 'UG'),
    ('193.109.000.000', 'FR'),
    ('193.109.004.000', 'DE'),
    ('193.109.008.000', 'UA'),
    ('193.109.012.000', 'RU'),
    ('193.109.016.000', 'IS'),
    ('193.109.032.000', 'IT'),
    ('193.109.048.000', 'CH'),
    ('193.109.050.000', 'GB'),
    ('193.109.052.000', 'CH'),
    ('193.109.054.000', 'BG'),
    ('193.109.056.000', 'DK'),
    ('193.109.058.000', 'LU'),
    ('193.109.060.000', 'UA'),
    ('193.109.062.000', 'BE'),
    ('193.109.064.000', 'DE'),
    ('193.109.066.000', 'KE'),
    ('193.109.068.000', 'GB'),
    ('193.109.070.000', 'UA'),
    ('193.109.072.000', 'BE'),
    ('193.109.074.000', 'AT'),
    ('193.109.076.000', 'RU'),
    ('193.109.078.000', 'TZ'),
    ('193.109.080.000', 'UA'),
    ('193.109.081.000', 'GB'),
    ('193.109.082.000', 'IL'),
    ('193.109.083.000', 'GB'),
    ('193.109.084.000', 'UA'),
    ('193.109.085.000', 'LV'),
    ('193.109.086.000', 'SE'),
    ('193.109.087.000', 'FR'),
    ('193.109.088.000', 'AT'),
    ('193.109.089.000', 'RU'),
    ('193.109.090.000', 'IT'),
    ('193.109.091.000', 'PL'),
    ('193.109.093.000', 'UA'),
    ('193.109.094.000', 'GB'),
    ('193.109.095.000', 'EU'),
    ('193.109.096.000', 'DE'),
    ('193.109.100.000', 'UA'),
    ('193.109.104.000', 'IT'),
    ('193.109.108.000', 'UA'),
    ('193.109.112.000', 'IT'),
    ('193.109.113.000', 'EU'),
    ('193.109.114.000', 'RU'),
    ('193.109.115.000', 'PL'),
    ('193.109.116.000', 'GB'),
    ('193.109.117.000', 'IT'),
    ('193.109.118.000', 'EU'),
    ('193.109.119.000', 'FR'),
    ('193.109.120.000', 'ES'),
    ('193.109.122.000', 'NL'),
    ('193.109.123.000', 'PL'),
    ('193.109.124.000', 'SI'),
    ('193.109.125.000', 'BE'),
    ('193.109.127.000', 'PL'),
    ('193.109.128.000', 'UA'),
    ('193.109.130.000', 'LU'),
    ('193.109.132.000', 'DE'),
    ('193.109.134.000', 'TR'),
    ('193.109.136.000', 'NL'),
    ('193.109.138.000', 'DE'),
    ('193.109.140.000', 'AT'),
    ('193.109.142.000', 'FR'),
    ('193.109.144.000', 'UA'),
    ('193.109.148.000', 'CH'),
    ('193.109.160.000', 'UA'),
    ('193.109.172.000', 'SE'),
    ('193.109.176.000', 'CZ'),
    ('193.109.184.000', 'BE'),
    ('193.109.192.000', 'GB'),
    ('193.109.200.000', 'IT'),
    ('193.109.208.000', 'LU'),
    ('193.109.209.000', 'SE'),
    ('193.109.210.000', 'NO'),
    ('193.109.211.000', 'LV'),
    ('193.109.212.000', 'PL'),
    ('193.109.213.000', 'GR'),
    ('193.109.214.000', 'DE'),
    ('193.109.215.000', 'GB'),
    ('193.109.216.000', 'CH'),
    ('193.109.217.000', 'NO'),
    ('193.109.218.000', 'SA'),
    ('193.109.219.000', 'GB'),
    ('193.109.221.000', 'DE'),
    ('193.109.223.000', 'PL'),
    ('193.109.224.000', 'EU'),
    ('193.109.225.000', 'PL'),
    ('193.109.227.000', 'SI'),
    ('193.109.228.000', 'BE'),
    ('193.109.229.000', 'ES'),
    ('193.109.231.000', 'DE'),
    ('193.109.232.000', 'AT'),
    ('193.109.233.000', 'IT'),
    ('193.109.234.000', 'BE'),
    ('193.109.235.000', 'LT'),
    ('193.109.236.000', 'DE'),
    ('193.109.240.000', 'UA'),
    ('193.109.242.000', 'DE'),
    ('193.109.244.000', 'PL'),
    ('193.109.246.000', 'SE'),
    ('193.109.248.000', 'UA'),
    ('193.109.250.000', 'FR'),
    ('193.109.252.000', 'HU'),
    ('193.109.254.000', 'GB'),
    ('193.110.000.000', 'RU'),
    ('193.110.002.000', 'NG'),
    ('193.110.004.000', 'RU'),
    ('193.110.006.000', 'DE'),
    ('193.110.008.000', 'LV'),
    ('193.110.010.000', 'AT'),
    ('193.110.012.000', 'SE'),
    ('193.110.014.000', 'SI'),
    ('193.110.016.000', 'UA'),
    ('193.110.024.000', 'DE'),
    ('193.110.028.000', 'AT'),
    ('193.110.032.000', 'FI'),
    ('193.110.040.000', 'DE'),
    ('193.110.048.000', 'NL'),
    ('193.110.056.000', 'HU'),
    ('193.110.064.000', 'FI'),
    ('193.110.068.000', 'HR'),
    ('193.110.072.000', 'UA'),
    ('193.110.076.000', 'FR'),
    ('193.110.081.000', 'BE'),
    ('193.110.082.000', 'BG'),
    ('193.110.083.000', 'IT'),
    ('193.110.084.000', 'DK'),
    ('193.110.085.000', 'CH'),
    ('193.110.086.000', 'GR'),
    ('193.110.087.000', 'DK'),
    ('193.110.088.000', 'GB'),
    ('193.110.089.000', 'UA'),
    ('193.110.090.000', 'DE'),
    ('193.110.091.000', 'GB'),
    ('193.110.092.000', 'BE'),
    ('193.110.093.000', 'GB'),
    ('193.110.094.000', 'AT'),
    ('193.110.095.000', 'CH'),
    ('193.110.096.000', 'FR'),
    ('193.110.098.000', 'PL'),
    ('193.110.100.000', 'UA'),
    ('193.110.102.000', 'DE'),
    ('193.110.104.000', 'CD'),
    ('193.110.106.000', 'UA'),
    ('193.110.108.000', 'FI'),
    ('193.110.112.000', 'UA'),
    ('193.110.116.000', 'DE'),
    ('193.110.120.000', 'PL'),
    ('193.110.124.000', 'UA'),
    ('193.110.128.000', 'ES'),
    ('193.110.129.000', 'AT'),
    ('193.110.130.000', 'BE'),
    ('193.110.131.000', 'CH'),
    ('193.110.132.000', 'BG'),
    ('193.110.133.000', 'DE'),
    ('193.110.134.000', 'UA'),
    ('193.110.135.000', 'GB'),
    ('193.110.136.000', 'AT'),
    ('193.110.137.000', 'PL'),
    ('193.110.138.000', 'GB'),
    ('193.110.139.000', 'DE'),
    ('193.110.140.000', 'FR'),
    ('193.110.141.000', 'DE'),
    ('193.110.142.000', 'PL'),
    ('193.110.143.000', 'GB'),
    ('193.110.144.000', 'UA'),
    ('193.110.145.000', 'SI'),
    ('193.110.146.000', 'FR'),
    ('193.110.147.000', 'NL'),
    ('193.110.148.000', 'FR'),
    ('193.110.149.000', 'GB'),
    ('193.110.150.000', 'DE'),
    ('193.110.151.000', 'IT'),
    ('193.110.152.000', 'FR'),
    ('193.110.153.000', 'DE'),
    ('193.110.154.000', 'ES'),
    ('193.110.155.000', 'MT'),
    ('193.110.156.000', 'UA'),
    ('193.110.157.000', 'NL'),
    ('193.110.158.000', 'BE'),
    ('193.110.159.000', 'BG'),
    ('193.110.160.000', 'UA'),
    ('193.110.164.000', 'LV'),
    ('193.110.166.000', 'DK'),
    ('193.110.168.000', 'UA'),
    ('193.110.170.000', 'TR'),
    ('193.110.172.000', 'UA'),
    ('193.110.178.000', 'DE'),
    ('193.110.180.000', 'GB'),
    ('193.110.182.000', 'AT'),
    ('193.110.184.000', 'UA'),
    ('193.110.186.000', 'SK'),
    ('193.110.188.000', 'UA'),
    ('193.110.190.000', 'BE'),
    ('193.110.192.000', 'DE'),
    ('193.110.196.000', 'DK'),
    ('193.110.200.000', 'IT'),
    ('193.110.204.000', 'DE'),
    ('193.110.208.000', 'TR'),
    ('193.110.216.000', 'BG'),
    ('193.110.224.000', 'FI'),
    ('193.110.228.000', 'PL'),
    ('193.110.232.000', 'NL'),
    ('193.110.236.000', 'EU'),
    ('193.111.000.000', 'UA'),
    ('193.111.002.000', 'RU'),
    ('193.111.004.000', 'GB'),
    ('193.111.006.000', 'UA'),
    ('193.111.010.000', 'TJ'),
    ('193.111.012.000', 'BE'),
    ('193.111.014.000', 'FR'),
    ('193.111.016.000', 'UA'),
    ('193.111.018.000', 'ES'),
    ('193.111.020.000', 'IT'),
    ('193.111.022.000', 'EU'),
    ('193.111.032.000', 'NL'),
    ('193.111.033.000', 'GB'),
    ('193.111.034.000', 'DE'),
    ('193.111.035.000', 'GB'),
    ('193.111.036.000', 'EU'),
    ('193.112.000.000', 'GB'),
    ('193.120.000.000', 'IE'),
    ('193.120.078.000', 'US'),
    ('193.120.080.000', 'IE'),
    ('193.121.000.000', 'BE'),
    ('193.121.001.000', 'EU'),
    ('193.121.002.000', 'BE'),
    ('193.121.013.000', 'EU'),
    ('193.121.014.000', 'BE'),
    ('193.121.033.000', 'EU'),
    ('193.121.034.000', 'BE'),
    ('193.121.036.000', '--'),
    ('193.121.037.000', 'BE'),
    ('193.121.042.000', 'EU'),
    ('193.121.043.000', 'BE'),
    ('193.121.044.000', 'EU'),
    ('193.121.047.000', 'BE'),
    ('193.121.048.000', 'EU'),
    ('193.121.050.000', 'BE'),
    ('193.121.051.000', 'EU'),
    ('193.121.053.000', 'BE'),
    ('193.121.054.000', 'EU'),
    ('193.121.056.000', 'BE'),
    ('193.121.061.000', 'EU'),
    ('193.121.062.000', '--'),
    ('193.121.063.000', 'EU'),
    ('193.121.064.000', 'BE'),
    ('193.121.066.000', 'EU'),
    ('193.121.067.000', 'BE'),
    ('193.121.070.000', 'EU'),
    ('193.121.071.000', 'BE'),
    ('193.121.080.000', 'EU'),
    ('193.121.090.000', 'BE'),
    ('193.121.091.000', 'EU'),
    ('193.121.094.000', 'BE'),
    ('193.121.096.000', 'EU'),
    ('193.121.101.000', 'BE'),
    ('193.121.102.000', 'EU'),
    ('193.121.104.000', 'BE'),
    ('193.121.106.000', 'EU'),
    ('193.121.109.000', 'BE'),
    ('193.121.110.000', 'EU'),
    ('193.121.111.000', 'BE'),
    ('193.121.114.000', 'EU'),
    ('193.121.117.000', 'BE'),
    ('193.121.118.000', 'EU'),
    ('193.121.120.000', 'BE'),
    ('193.121.122.000', 'EU'),
    ('193.121.124.000', 'BE'),
    ('193.121.127.000', 'EU'),
    ('193.121.128.000', 'BE'),
    ('193.121.129.000', 'EU'),
    ('193.121.130.000', 'BE'),
    ('193.121.132.000', 'EU'),
    ('193.121.133.000', 'BE'),
    ('193.121.134.000', 'EU'),
    ('193.121.135.000', 'BE'),
    ('193.121.136.000', 'EU'),
    ('193.121.139.000', 'BE'),
    ('193.121.140.000', 'EU'),
    ('193.121.141.000', 'BE'),
    ('193.121.145.000', 'EU'),
    ('193.121.146.000', 'BE'),
    ('193.121.148.000', 'EU'),
    ('193.121.152.000', 'BE'),
    ('193.121.154.000', 'EU'),
    ('193.121.155.000', 'BE'),
    ('193.121.157.000', 'EU'),
    ('193.121.160.000', 'BE'),
    ('193.121.164.000', 'EU'),
    ('193.121.167.000', 'BE'),
    ('193.121.169.000', 'EU'),
    ('193.121.171.000', 'BE'),
    ('193.121.172.000', 'EU'),
    ('193.121.173.000', 'BE'),
    ('193.121.174.000', 'EU'),
    ('193.121.177.000', 'BE'),
    ('193.121.178.000', 'EU'),
    ('193.121.179.000', 'BE'),
    ('193.121.181.000', 'EU'),
    ('193.121.182.000', 'BE'),
    ('193.121.186.000', 'EU'),
    ('193.121.188.000', 'BE'),
    ('193.121.191.000', 'EU'),
    ('193.121.193.000', 'BE'),
    ('193.121.201.000', 'EU'),
    ('193.121.202.000', 'BE'),
    ('193.121.203.000', 'EU'),
    ('193.121.205.000', 'BE'),
    ('193.121.206.000', 'EU'),
    ('193.121.208.000', 'BE'),
    ('193.121.210.000', 'EU'),
    ('193.121.214.000', 'BE'),
    ('193.121.215.000', 'EU'),
    ('193.121.216.000', 'BE'),
    ('193.121.217.000', 'EU'),
    ('193.121.219.000', 'BE'),
    ('193.121.220.000', 'EU'),
    ('193.121.221.000', 'BE'),
    ('193.121.224.000', 'EU'),
    ('193.121.226.000', 'BE'),
    ('193.121.230.000', 'EU'),
    ('193.121.231.000', 'BE'),
    ('193.121.236.000', 'EU'),
    ('193.121.237.000', 'BE'),
    ('193.121.238.000', 'EU'),
    ('193.121.240.000', 'BE'),
    ('193.121.243.000', 'EU'),
    ('193.121.244.000', 'BE'),
    ('193.121.245.000', 'EU'),
    ('193.121.248.000', 'BE'),
    ('193.121.249.000', 'EU'),
    ('193.121.252.000', 'BE'),
    ('193.121.253.000', 'EU'),
    ('193.122.000.000', 'GB'),
    ('193.124.000.000', 'RU'),
    ('193.124.048.000', 'UA'),
    ('193.124.049.000', 'RU'),
    ('193.124.050.000', 'UA'),
    ('193.124.051.000', 'RU'),
    ('193.124.054.000', 'UA'),
    ('193.124.070.000', 'RU'),
    ('193.124.073.000', 'UA'),
    ('193.124.080.000', 'RU'),
    ('193.124.112.000', 'EE'),
    ('193.124.113.000', 'RU'),
    ('193.124.115.000', 'KZ'),
    ('193.124.116.000', 'RU'),
    ('193.124.228.000', 'UA'),
    ('193.124.230.000', 'RU'),
    ('193.125.030.000', 'UA'),
    ('193.125.031.000', 'RU'),
    ('193.125.078.000', 'UA'),
    ('193.125.080.000', 'RU'),
    ('193.125.087.000', 'UA'),
    ('193.125.088.000', 'RU'),
    ('193.125.166.000', 'KZ'),
    ('193.125.167.000', 'RU'),
    ('193.125.169.000', 'KZ'),
    ('193.125.170.000', 'RU'),
    ('193.125.176.000', 'KZ'),
    ('193.125.177.000', 'RU'),
    ('193.126.000.000', 'PT'),
    ('193.127.000.000', 'ES'),
    ('193.127.002.000', 'EU'),
    ('193.127.003.000', 'ES'),
    ('193.127.004.000', 'EU'),
    ('193.127.011.000', 'ES'),
    ('193.127.012.000', 'EU'),
    ('193.127.014.000', 'ES'),
    ('193.127.020.000', 'EU'),
    ('193.127.030.000', 'ES'),
    ('193.127.031.000', 'EU'),
    ('193.127.032.000', 'ES'),
    ('193.127.035.000', 'EU'),
    ('193.127.036.000', 'ES'),
    ('193.127.039.000', 'EU'),
    ('193.127.040.000', 'ES'),
    ('193.127.042.000', 'EU'),
    ('193.127.043.000', 'ES'),
    ('193.127.045.000', 'EU'),
    ('193.127.048.000', 'ES'),
    ('193.127.050.000', 'EU'),
    ('193.127.052.000', 'ES'),
    ('193.127.054.000', 'EU'),
    ('193.127.056.000', 'ES'),
    ('193.127.058.000', 'EU'),
    ('193.127.060.000', 'ES'),
    ('193.127.064.000', 'EU'),
    ('193.127.065.000', 'ES'),
    ('193.127.066.000', 'EU'),
    ('193.127.070.000', 'ES'),
    ('193.127.071.000', 'EU'),
    ('193.127.073.000', 'ES'),
    ('193.127.077.000', 'EU'),
    ('193.127.080.000', 'ES'),
    ('193.127.081.000', 'EU'),
    ('193.127.082.000', 'ES'),
    ('193.127.083.000', 'EU'),
    ('193.127.084.000', 'ES'),
    ('193.127.090.000', 'EU'),
    ('193.127.091.000', 'ES'),
    ('193.127.093.000', 'EU'),
    ('193.127.095.000', 'ES'),
    ('193.127.097.000', 'EU'),
    ('193.127.098.000', 'ES'),
    ('193.127.100.000', 'EU'),
    ('193.127.202.000', 'ES'),
    ('193.127.203.000', 'EU'),
    ('193.127.204.000', 'ES'),
    ('193.127.206.000', 'EU'),
    ('193.127.209.000', 'ES'),
    ('193.127.211.000', 'EU'),
    ('193.127.221.000', 'ES'),
    ('193.127.224.000', 'EU'),
    ('193.128.000.000', 'GB'),
    ('193.131.064.000', 'IT'),
    ('193.131.066.000', 'GB'),
    ('193.131.100.000', 'HU'),
    ('193.131.104.000', 'GB'),
    ('193.134.000.000', 'CH'),
    ('193.136.000.000', 'PT'),
    ('193.138.000.000', 'EU'),
    ('193.138.001.000', 'SI'),
    ('193.138.006.000', 'EU'),
    ('193.138.009.000', 'SI'),
    ('193.138.010.000', 'DE'),
    ('193.138.028.000', 'EU'),
    ('193.138.032.000', 'SI'),
    ('193.138.064.000', 'EU'),
    ('193.139.000.000', 'FR'),
    ('193.140.000.000', 'TR'),
    ('193.141.000.000', 'DE'),
    ('193.142.000.000', 'FI'),
    ('193.144.000.000', 'ES'),
    ('193.148.000.000', 'EU'),
    ('193.148.001.000', 'ES'),
    ('193.148.006.000', 'EU'),
    ('193.148.008.000', 'ES'),
    ('193.148.011.000', 'GB'),
    ('193.148.012.000', 'ES'),
    ('193.148.015.000', 'NL'),
    ('193.148.016.000', 'ES'),
    ('193.148.038.000', 'IT'),
    ('193.148.040.000', 'ES'),
    ('193.148.044.000', 'EU'),
    ('193.148.048.000', 'CH'),
    ('193.148.056.000', 'ES'),
    ('193.148.062.000', 'CH'),
    ('193.148.064.000', 'ES'),
    ('193.149.000.000', 'EU'),
    ('193.149.001.000', 'ES'),
    ('193.149.002.000', 'EU'),
    ('193.149.004.000', 'ES'),
    ('193.149.008.000', 'DE'),
    ('193.149.016.000', 'ES'),
    ('193.149.032.000', 'DE'),
    ('193.149.064.000', 'GB'),
    ('193.149.096.000', 'FR'),
    ('193.149.128.000', 'DK'),
    ('193.149.192.000', 'BE'),
    ('193.149.195.000', 'CH'),
    ('193.149.196.000', 'BE'),
    ('193.149.208.000', 'CH'),
    ('193.149.214.000', 'DE'),
    ('193.149.217.000', 'AT'),
    ('193.149.220.000', 'BE'),
    ('193.149.225.000', 'CH'),
    ('193.149.228.000', 'BE'),
    ('193.149.230.000', 'EU'),
    ('193.149.232.000', 'CH'),
    ('193.149.240.000', 'BE'),
    ('193.150.000.000', 'RU'),
    ('193.150.128.000', 'GB'),
    ('193.150.152.000', 'NL'),
    ('193.150.165.000', 'TR'),
    ('193.150.166.000', 'DE'),
    ('193.150.168.000', 'PL'),
    ('193.150.169.000', 'FR'),
    ('193.150.170.000', 'ES'),
    ('193.150.171.000', 'DE'),
    ('193.150.172.000', 'GR'),
    ('193.150.174.000', 'CH'),
    ('193.150.180.000', 'GB'),
    ('193.150.192.000', 'SE'),
    ('193.151.000.000', 'EU'),
    ('193.151.128.000', 'FR'),
    ('193.151.240.000', 'EU'),
    ('193.152.000.000', 'ES'),
    ('193.154.000.000', 'AT'),
    ('193.155.000.000', 'DE'),
    ('193.156.000.000', 'NO'),
    ('193.156.027.000', 'RU'),
    ('193.156.028.000', 'NO'),
    ('193.156.034.000', 'PK'),
    ('193.156.035.000', 'NO'),
    ('193.158.000.000', 'DE'),
    ('193.160.000.000', 'NO'),
    ('193.160.144.000', 'DE'),
    ('193.160.145.000', 'DK'),
    ('193.160.146.000', 'NO'),
    ('193.162.000.000', 'DK'),
    ('193.164.000.000', 'NL'),
    ('193.164.001.000', 'PL'),
    ('193.164.007.000', 'NL'),
    ('193.164.016.000', 'PL'),
    ('193.164.032.000', 'SE'),
    ('193.164.092.000', 'NL'),
    ('193.164.096.000', 'GB'),
    ('193.164.224.000', 'AT'),
    ('193.164.226.000', 'GR'),
    ('193.164.228.000', 'FR'),
    ('193.164.233.000', 'CH'),
    ('193.164.242.000', 'GB'),
    ('193.164.244.000', 'CH'),
    ('193.164.246.000', 'DE'),
    ('193.164.248.000', 'DK'),
    ('193.164.252.000', 'EU'),
    ('193.165.000.000', 'CZ'),
    ('193.166.000.000', 'FI'),
    ('193.168.000.000', 'NL'),
    ('193.168.001.000', 'LU'),
    ('193.168.006.000', 'NL'),
    ('193.168.008.000', 'LU'),
    ('193.168.054.000', 'NL'),
    ('193.168.055.000', 'LU'),
    ('193.168.128.000', 'DE'),
    ('193.169.000.000', 'GB'),
    ('193.170.000.000', 'AT'),
    ('193.172.000.000', 'NL'),
    ('193.173.076.000', 'US'),
    ('193.173.077.000', 'NL'),
    ('193.174.000.000', 'DE'),
    ('193.174.004.000', 'IT'),
    ('193.174.005.000', 'DE'),
    ('193.176.000.000', 'NL'),
    ('193.178.000.000', 'EU'),
    ('193.178.001.000', 'IE'),
    ('193.178.034.000', 'EU'),
    ('193.178.036.000', 'IE'),
    ('193.178.043.000', 'EU'),
    ('193.178.044.000', 'IE'),
    ('193.178.060.000', 'SE'),
    ('193.178.064.000', 'IE'),
    ('193.178.117.000', 'EU'),
    ('193.178.118.000', 'IE'),
    ('193.178.120.000', 'GB'),
    ('193.178.124.000', 'UA'),
    ('193.178.128.000', 'SE'),
    ('193.178.131.000', 'GR'),
    ('193.178.132.000', 'CH'),
    ('193.178.133.000', 'FI'),
    ('193.178.134.000', 'FR'),
    ('193.178.135.000', 'RU'),
    ('193.178.136.000', 'FR'),
    ('193.178.139.000', 'GB'),
    ('193.178.140.000', 'FR'),
    ('193.178.141.000', 'IT'),
    ('193.178.142.000', 'DE'),
    ('193.178.143.000', 'PL'),
    ('193.178.144.000', 'UA'),
    ('193.178.148.000', 'AT'),
    ('193.178.150.000', 'LV'),
    ('193.178.152.000', 'BG'),
    ('193.178.154.000', 'FR'),
    ('193.178.156.000', 'CH'),
    ('193.178.158.000', 'RU'),
    ('193.178.160.000', 'AT'),
    ('193.178.161.000', 'PL'),
    ('193.178.162.000', 'EU'),
    ('193.178.163.000', 'DE'),
    ('193.178.164.000', 'PL'),
    ('193.178.165.000', 'RO'),
    ('193.178.166.000', 'BG'),
    ('193.178.167.000', 'PL'),
    ('193.178.168.000', 'HU'),
    ('193.178.169.000', 'DE'),
    ('193.178.171.000', 'RO'),
    ('193.178.172.000', 'UA'),
    ('193.178.173.000', 'GB'),
    ('193.178.174.000', 'BE'),
    ('193.178.175.000', 'DK'),
    ('193.178.176.000', 'LV'),
    ('193.178.184.000', 'DE'),
    ('193.178.191.000', 'UA'),
    ('193.178.192.000', 'LV'),
    ('193.178.196.000', 'DE'),
    ('193.178.200.000', 'BE'),
    ('193.178.204.000', 'IT'),
    ('193.178.208.000', 'AT'),
    ('193.178.209.000', 'BE'),
    ('193.178.210.000', 'FR'),
    ('193.178.213.000', 'PL'),
    ('193.178.215.000', 'GB'),
    ('193.178.216.000', 'IT'),
    ('193.178.217.000', 'GB'),
    ('193.178.218.000', 'TR'),
    ('193.178.219.000', 'LU'),
    ('193.178.220.000', 'IL'),
    ('193.178.221.000', 'SE'),
    ('193.178.222.000', 'BG'),
    ('193.178.223.000', 'GB'),
    ('193.178.224.000', 'RO'),
    ('193.178.226.000', 'DE'),
    ('193.178.228.000', 'UA'),
    ('193.178.230.000', 'IT'),
    ('193.178.232.000', 'LV'),
    ('193.178.234.000', 'IT'),
    ('193.178.236.000', 'UA'),
    ('193.178.238.000', 'GB'),
    ('193.178.240.000', 'PL'),
    ('193.178.244.000', 'IT'),
    ('193.178.248.000', 'UA'),
    ('193.178.252.000', 'IT'),
    ('193.179.000.000', 'CZ'),
    ('193.180.000.000', 'SE'),
    ('193.184.000.000', 'FI'),
    ('193.184.149.000', 'NO'),
    ('193.184.150.000', 'FI'),
    ('193.186.000.000', 'AT'),
    ('193.188.000.000', 'EU'),
    ('193.188.001.000', 'SA'),
    ('193.188.005.000', 'KW'),
    ('193.188.006.000', 'AE'),
    ('193.188.007.000', 'MA'),
    ('193.188.008.000', 'OM'),
    ('193.188.012.000', 'BH'),
    ('193.188.014.000', 'SA'),
    ('193.188.032.000', 'MT'),
    ('193.188.048.000', 'KW'),
    ('193.188.064.000', 'JO'),
    ('193.188.096.000', 'BH'),
    ('193.188.128.000', 'LB'),
    ('193.188.132.000', 'GB'),
    ('193.188.134.000', 'BG'),
    ('193.188.135.000', 'LB'),
    ('193.188.137.000', 'HU'),
    ('193.188.138.000', 'LB'),
    ('193.188.140.000', 'HU'),
    ('193.188.142.000', 'KW'),
    ('193.188.154.000', 'DE'),
    ('193.188.156.000', 'EU'),
    ('193.188.158.000', 'DE'),
    ('193.188.160.000', 'KW'),
    ('193.188.192.000', 'HU'),
    ('193.188.195.000', 'GB'),
    ('193.188.196.000', 'DE'),
    ('193.188.198.000', 'TR'),
    ('193.188.200.000', 'SA'),
    ('193.188.201.000', 'SE'),
    ('193.188.204.000', 'GB'),
    ('193.188.208.000', 'CH'),
    ('193.188.224.000', 'DK'),
    ('193.188.225.000', 'CH'),
    ('193.188.248.000', 'EU'),
    ('193.189.000.000', 'NG'),
    ('193.189.066.000', 'EU'),
    ('193.189.128.000', 'NG'),
    ('193.189.129.000', 'EU'),
    ('193.189.150.000', 'DE'),
    ('193.189.160.000', 'SI'),
    ('193.189.192.000', 'FR'),
    ('193.189.194.000', 'CH'),
    ('193.189.224.000', 'DE'),
    ('193.189.245.000', 'CH'),
    ('193.189.246.000', 'DE'),
    ('193.190.000.000', 'BE'),
    ('193.192.000.000', 'EU'),
    ('193.192.001.000', 'PT'),
    ('193.192.012.000', 'IE'),
    ('193.192.013.000', 'GB'),
    ('193.192.014.000', 'DE'),
    ('193.192.015.000', 'IE'),
    ('193.192.016.000', 'CH'),
    ('193.192.032.000', 'GB'),
    ('193.192.096.000', 'TR'),
    ('193.192.128.000', 'RU'),
    ('193.192.160.000', 'PL'),
    ('193.192.192.000', 'GB'),
    ('193.192.224.000', 'CH'),
    ('193.193.000.000', 'IT'),
    ('193.193.032.000', 'GB'),
    ('193.193.064.000', 'PL'),
    ('193.193.096.000', 'GB'),
    ('193.193.128.000', 'CH'),
    ('193.193.160.000', 'NO'),
    ('193.193.161.000', 'NL'),
    ('193.193.162.000', 'BG'),
    ('193.193.165.000', 'IE'),
    ('193.193.169.000', 'GB'),
    ('193.193.170.000', 'SK'),
    ('193.193.171.000', 'NL'),
    ('193.193.172.000', 'IT'),
    ('193.193.174.000', 'DE'),
    ('193.193.181.000', 'PL'),
    ('193.193.182.000', 'BG'),
    ('193.193.183.000', 'IT'),
    ('193.193.184.000', 'GR'),
    ('193.193.186.000', 'EU'),
    ('193.193.188.000', 'GB'),
    ('193.193.190.000', 'DE'),
    ('193.193.192.000', 'UA'),
    ('193.193.224.000', 'KZ'),
    ('193.194.000.000', 'EU'),
    ('193.194.001.000', 'MA'),
    ('193.194.006.000', 'DE'),
    ('193.194.016.000', 'IT'),
    ('193.194.021.000', 'EU'),
    ('193.194.022.000', 'GB'),
    ('193.194.032.000', 'MA'),
    ('193.194.064.000', 'DZ'),
    ('193.194.096.000', 'EU'),
    ('193.194.128.000', 'GH'),
    ('193.194.129.000', 'DE'),
    ('193.194.130.000', 'RO'),
    ('193.194.132.000', 'FR'),
    ('193.194.136.000', 'NL'),
    ('193.194.137.000', 'DE'),
    ('193.194.138.000', 'CH'),
    ('193.194.140.000', 'BG'),
    ('193.194.142.000', 'DE'),
    ('193.194.146.000', 'AT'),
    ('193.194.147.000', 'GB'),
    ('193.194.148.000', 'DE'),
    ('193.194.150.000', 'GB'),
    ('193.194.152.000', 'FR'),
    ('193.194.153.000', 'RU'),
    ('193.194.155.000', 'PT'),
    ('193.194.156.000', 'BG'),
    ('193.194.157.000', 'DE'),
    ('193.194.158.000', 'BE'),
    ('193.194.159.000', 'HU'),
    ('193.194.160.000', 'GH'),
    ('193.194.192.000', 'SE'),
    ('193.195.000.000', 'GB'),
    ('193.196.000.000', 'DE'),
    ('193.198.000.000', 'HR'),
    ('193.199.000.000', 'FI'),
    ('193.200.000.000', 'BG'),
    ('193.201.000.000', 'EU'),
    ('193.202.008.000', 'BE'),
    ('193.202.016.000', 'EU'),
    ('193.202.024.000', 'FR'),
    ('193.202.025.000', 'DE'),
    ('193.202.027.000', 'GB'),
    ('193.202.028.000', 'DE'),
    ('193.202.029.000', 'SE'),
    ('193.202.030.000', 'DE'),
    ('193.202.031.000', 'GB'),
    ('193.202.032.000', 'US'),
    ('193.202.040.000', 'PT'),
    ('193.202.041.000', 'GB'),
    ('193.202.042.000', 'CH'),
    ('193.202.043.000', 'BG'),
    ('193.202.044.000', 'AT'),
    ('193.202.045.000', 'NL'),
    ('193.202.046.000', 'CH'),
    ('193.202.062.000', 'EU'),
    ('193.202.064.000', 'BE'),
    ('193.202.065.000', 'EU'),
    ('193.202.066.000', 'BE'),
    ('193.202.074.000', 'FR'),
    ('193.202.077.000', 'BE'),
    ('193.202.079.000', 'PT'),
    ('193.202.080.000', 'CH'),
    ('193.202.091.000', 'BG'),
    ('193.202.092.000', 'IT'),
    ('193.202.093.000', 'GB'),
    ('193.202.094.000', 'ES'),
    ('193.202.095.000', 'DE'),
    ('193.202.096.000', 'NL'),
    ('193.202.105.000', 'EU'),
    ('193.202.128.000', 'DE'),
    ('193.202.192.000', 'GB'),
    ('193.202.240.000', 'CH'),
    ('193.203.000.000', 'AT'),
    ('193.203.001.000', 'MK'),
    ('193.203.002.000', 'YU'),
    ('193.203.004.000', 'MK'),
    ('193.203.005.000', 'GB'),
    ('193.203.006.000', 'YU'),
    ('193.203.020.000', 'EU'),
    ('193.203.022.000', 'YU'),
    ('193.203.030.000', 'CH'),
    ('193.203.032.000', 'AT'),
    ('193.203.064.000', 'GB'),
    ('193.203.096.000', 'DE'),
    ('193.203.128.000', 'IE'),
    ('193.203.160.000', 'DE'),
    ('193.203.192.000', 'GB'),
    ('193.203.224.000', 'MK'),
    ('193.203.225.000', 'NL'),
    ('193.203.227.000', 'AT'),
    ('193.203.228.000', 'IT'),
    ('193.203.236.000', 'UA'),
    ('193.203.238.000', 'DE'),
    ('193.203.240.000', 'GB'),
    ('193.204.000.000', 'IT'),
    ('193.208.000.000', 'FI'),
    ('193.208.106.000', 'NO'),
    ('193.208.107.000', 'FI'),
    ('193.208.150.000', 'NL'),
    ('193.208.151.000', 'FI'),
    ('193.208.159.000', 'BE'),
    ('193.208.160.000', 'FI'),
    ('193.209.022.000', 'DK'),
    ('193.209.023.000', 'FI'),
    ('193.209.030.000', 'SE'),
    ('193.209.031.000', 'FI'),
    ('193.209.135.000', 'CH'),
    ('193.209.136.000', 'NL'),
    ('193.209.137.000', 'FI'),
    ('193.210.000.000', 'NL'),
    ('193.210.001.000', 'FI'),
    ('193.210.035.000', 'DE'),
    ('193.210.036.000', 'FI'),
    ('193.210.071.000', 'GB'),
    ('193.210.072.000', 'FI'),
    ('193.210.118.000', 'GB'),
    ('193.210.119.000', 'FI'),
    ('193.210.147.000', 'BE'),
    ('193.210.148.000', 'FI'),
    ('193.210.149.000', 'BE'),
    ('193.210.150.000', 'CH'),
    ('193.210.152.000', 'FI'),
    ('193.210.160.000', 'BE'),
    ('193.210.195.000', 'LU'),
    ('193.210.197.000', 'BE'),
    ('193.210.208.000', 'FI'),
    ('193.211.077.000', 'FR'),
    ('193.211.078.000', 'CH'),
    ('193.211.079.000', 'FI'),
    ('193.212.000.000', 'NO'),
    ('193.218.000.000', 'EU'),
    ('193.218.001.000', 'GR'),
    ('193.218.007.000', 'SK'),
    ('193.218.008.000', 'FR'),
    ('193.218.016.000', 'DE'),
    ('193.218.033.000', 'GR'),
    ('193.218.082.000', 'EU'),
    ('193.218.084.000', 'GR'),
    ('193.218.094.000', 'SK'),
    ('193.218.096.000', 'GR'),
    ('193.218.098.000', 'HU'),
    ('193.218.099.000', 'GB'),
    ('193.218.100.000', 'CH'),
    ('193.218.105.000', 'FR'),
    ('193.218.106.000', 'GR'),
    ('193.218.113.000', 'TR'),
    ('193.218.114.000', 'GP'),
    ('193.218.115.000', 'PL'),
    ('193.218.116.000', 'AT'),
    ('193.218.118.000', 'GR'),
    ('193.218.126.000', 'DE'),
    ('193.218.128.000', 'IT'),
    ('193.218.160.000', 'GB'),
    ('193.218.192.000', 'BE'),
    ('193.218.200.000', 'TR'),
    ('193.218.201.000', 'EU'),
    ('193.218.203.000', 'GR'),
    ('193.218.204.000', 'EU'),
    ('193.218.205.000', 'DE'),
    ('193.218.222.000', 'GB'),
    ('193.218.223.000', 'GR'),
    ('193.219.000.000', 'GB'),
    ('193.219.001.000', 'LT'),
    ('193.219.015.000', 'GB'),
    ('193.219.016.000', 'DK'),
    ('193.219.028.000', 'PL'),
    ('193.219.029.000', 'GB'),
    ('193.219.030.000', 'EU'),
    ('193.219.032.000', 'LT'),
    ('193.219.096.000', 'PT'),
    ('193.219.128.000', 'LT'),
    ('193.219.208.000', 'TR'),
    ('193.219.209.000', 'LT'),
    ('193.219.212.000', 'UG'),
    ('193.219.214.000', 'LT'),
    ('193.220.002.000', 'NO'),
    ('193.220.016.000', 'GN'),
    ('193.220.017.000', 'LT'),
    ('193.220.024.000', 'MZ'),
    ('193.220.025.000', 'LT'),
    ('193.220.028.000', 'MW'),
    ('193.220.029.000', 'LT'),
    ('193.220.032.000', 'ZW'),
    ('193.220.035.000', 'LT'),
    ('193.220.040.000', 'ZW'),
    ('193.220.041.000', 'LT'),
    ('193.220.044.000', 'ZW'),
    ('193.220.045.000', 'LT'),
    ('193.220.048.000', 'NP'),
    ('193.220.049.000', 'LT'),
    ('193.220.054.000', 'SK'),
    ('193.220.055.000', 'MD'),
    ('193.220.057.000', 'UA'),
    ('193.220.063.000', 'LT'),
    ('193.220.067.000', 'UA'),
    ('193.220.068.000', 'AL'),
    ('193.220.069.000', 'MD'),
    ('193.220.070.000', 'LT'),
    ('193.220.072.000', 'UA'),
    ('193.220.073.000', 'LT'),
    ('193.220.074.000', 'AL'),
    ('193.220.075.000', 'LT'),
    ('193.220.080.000', 'TZ'),
    ('193.220.089.000', 'LT'),
    ('193.220.090.000', 'TZ'),
    ('193.220.093.000', 'LT'),
    ('193.220.095.000', 'RO'),
    ('193.220.096.000', 'UA'),
    ('193.220.097.000', 'LT'),
    ('193.220.100.000', 'NO'),
    ('193.220.104.000', 'LT'),
    ('193.220.112.000', 'YU'),
    ('193.220.113.000', 'LT'),
    ('193.220.116.000', 'NO'),
    ('193.220.118.000', 'LT'),
    ('193.220.120.000', 'MK'),
    ('193.220.121.000', 'BA'),
    ('193.220.122.000', 'LT'),
    ('193.220.124.000', 'TJ'),
    ('193.220.125.000', 'UA'),
    ('193.220.127.000', 'LT'),
    ('193.220.128.000', 'UA'),
    ('193.220.135.000', '--'),
    ('193.220.136.000', 'UA'),
    ('193.220.137.000', 'LT'),
    ('193.220.160.000', 'NO'),
    ('193.220.171.000', 'LT'),
    ('193.220.255.000', 'GB'),
    ('193.221.000.000', 'BE'),
    ('193.221.016.000', 'SE'),
    ('193.221.082.000', 'EU'),
    ('193.221.084.000', 'GB'),
    ('193.221.093.000', 'CH'),
    ('193.221.096.000', 'FR'),
    ('193.221.112.000', 'EU'),
    ('193.221.128.000', 'NL'),
    ('193.221.160.000', 'BE'),
    ('193.221.192.000', 'GB'),
    ('193.221.208.000', 'IE'),
    ('193.221.212.000', 'NL'),
    ('193.221.218.000', 'CZ'),
    ('193.221.219.000', 'BE'),
    ('193.222.000.000', 'CH'),
    ('193.223.216.000', 'GB'),
    ('193.223.217.000', 'CH'),
    ('193.224.000.000', 'HU'),
    ('193.226.000.000', 'RO'),
    ('193.226.064.000', 'MD'),
    ('193.226.080.000', 'RO'),
    ('193.226.192.000', 'HU'),
    ('193.227.000.000', 'EG'),
    ('193.227.064.000', 'IT'),
    ('193.227.096.000', 'GB'),
    ('193.227.100.000', 'KW'),
    ('193.227.104.000', 'GB'),
    ('193.227.105.000', 'CY'),
    ('193.227.113.000', 'GB'),
    ('193.227.128.000', 'EG'),
    ('193.227.129.000', 'HU'),
    ('193.227.130.000', 'EG'),
    ('193.227.136.000', 'FR'),
    ('193.227.144.000', 'EG'),
    ('193.227.160.000', 'LB'),
    ('193.227.192.000', 'DE'),
    ('193.227.196.000', 'HU'),
    ('193.227.200.000', 'GB'),
    ('193.227.202.000', 'DE'),
    ('193.227.204.000', 'NO'),
    ('193.227.206.000', 'UA'),
    ('193.227.212.000', 'IT'),
    ('193.227.216.000', 'PL'),
    ('193.227.224.000', 'DE'),
    ('193.228.000.000', 'AT'),
    ('193.229.000.000', 'FI'),
    ('193.230.000.000', 'RO'),
    ('193.232.000.000', 'RU'),
    ('193.232.065.000', 'UA'),
    ('193.232.066.000', 'RU'),
    ('193.232.092.000', 'BY'),
    ('193.232.093.000', 'UA'),
    ('193.232.094.000', 'RU'),
    ('193.232.160.000', 'DE'),
    ('193.232.161.000', 'UZ'),
    ('193.232.162.000', 'RU'),
    ('193.232.224.000', 'KZ'),
    ('193.232.226.000', 'RU'),
    ('193.232.228.000', 'AM'),
    ('193.232.230.000', 'RU'),
    ('193.232.248.000', 'BY'),
    ('193.232.252.000', 'RU'),
    ('193.233.224.000', 'BY'),
    ('193.233.228.000', 'RU'),
    ('193.234.000.000', 'SE'),
    ('193.236.000.000', 'AO'),
    ('193.236.008.000', 'PT'),
    ('193.237.000.000', 'GB'),
    ('193.238.000.000', 'EU'),
    ('193.240.000.000', 'GB'),
    ('193.241.000.000', 'SE'),
    ('193.242.000.000', 'GB'),
    ('193.242.001.000', 'FR'),
    ('193.242.080.000', 'NL'),
    ('193.242.088.000', 'SY'),
    ('193.242.090.000', 'NL'),
    ('193.242.096.000', 'GB'),
    ('193.242.128.000', 'BE'),
    ('193.242.192.000', 'FR'),
    ('193.242.224.000', 'GB'),
    ('193.242.240.000', 'GR'),
    ('193.243.000.000', 'GB'),
    ('193.243.161.000', 'DE'),
    ('193.243.162.000', 'AT'),
    ('193.243.164.000', 'NL'),
    ('193.243.166.000', 'DE'),
    ('193.243.167.000', 'HU'),
    ('193.243.168.000', 'DK'),
    ('193.243.176.000', 'GB'),
    ('193.243.183.000', 'NO'),
    ('193.243.184.000', 'DE'),
    ('193.243.192.000', 'TR'),
    ('193.243.224.000', 'GB'),
    ('193.244.000.000', 'BE'),
    ('193.246.000.000', 'CH'),
    ('193.246.206.000', 'LI'),
    ('193.246.207.000', 'CH'),
    ('193.247.045.000', 'LI'),
    ('193.247.046.000', 'CH'),
    ('193.248.000.000', 'FR'),
    ('193.251.130.000', 'CI'),
    ('193.251.132.000', 'FR'),
    ('193.251.134.000', 'JP'),
    ('193.251.135.000', 'FR'),
    ('193.251.136.000', 'KM'),
    ('193.251.137.000', 'CF'),
    ('193.251.138.000', 'CI'),
    ('193.251.139.000', 'LB'),
    ('193.251.140.000', 'MG'),
    ('193.251.143.000', 'DJ'),
    ('193.251.144.000', 'DZ'),
    ('193.251.145.000', 'FR'),
    ('193.251.146.000', 'MR'),
    ('193.251.147.000', 'TD'),
    ('193.251.148.000', 'FR'),
    ('193.251.149.000', 'CF'),
    ('193.251.150.000', 'FR'),
    ('193.251.152.000', 'DZ'),
    ('193.251.153.000', 'GQ'),
    ('193.251.154.000', 'FR'),
    ('193.251.155.000', 'CM'),
    ('193.251.156.000', 'LB'),
    ('193.251.158.000', 'FR'),
    ('193.251.159.000', 'CI'),
    ('193.251.160.000', 'GP'),
    ('193.251.161.000', 'CI'),
    ('193.251.162.000', 'GP'),
    ('193.251.166.000', 'LB'),
    ('193.251.167.000', 'DJ'),
    ('193.251.168.000', 'CI'),
    ('193.251.169.000', 'DZ'),
    ('193.251.170.000', 'EG'),
    ('193.251.174.000', 'DZ'),
    ('193.251.176.000', 'FR'),
    ('193.251.224.000', 'BW'),
    ('193.251.226.000', 'FR'),
    ('193.251.227.000', 'NE'),
    ('193.251.229.000', 'FR'),
    ('193.252.016.000', 'GB'),
    ('193.252.018.000', 'FR'),
    ('193.253.000.000', '--'),
    ('193.253.001.000', 'BE'),
    ('193.253.002.000', 'FR'),
    ('193.253.158.000', 'US'),
    ('193.253.160.000', 'FR'),
    ('193.254.000.000', 'GB'),
    ('193.254.001.000', 'AL'),
    ('193.254.004.000', 'SE'),
    ('193.254.008.000', 'CH'),
    ('193.254.018.000', 'DE'),
    ('193.254.024.000', 'IT'),
    ('193.254.027.000', 'GB'),
    ('193.254.029.000', 'BG'),
    ('193.254.030.000', 'DE'),
    ('193.254.031.000', 'GB'),
    ('193.254.032.000', 'RO'),
    ('193.254.064.000', 'EU'),
    ('193.254.108.000', 'DE'),
    ('193.254.109.000', 'EU'),
    ('193.254.128.000', 'DE'),
    ('193.254.176.000', 'EU'),
    ('193.255.000.000', 'TR'),
    ('194.000.000.000', 'EU'),
    ('194.001.000.000', 'SK'),
    ('194.002.000.000', 'FR'),
    ('194.005.051.000', 'DE'),
    ('194.005.052.000', 'FR'),
    ('194.005.063.000', 'DE'),
    ('194.005.064.000', 'FR'),
    ('194.006.000.000', 'GB'),
    ('194.006.055.000', 'DE'),
    ('194.006.056.000', 'GB'),
    ('194.006.128.000', 'FR'),
    ('194.006.160.000', 'CH'),
    ('194.006.192.000', 'GB'),
    ('194.006.224.000', 'MA'),
    ('194.006.225.000', 'EU'),
    ('194.007.000.000', 'BE'),
    ('194.007.083.000', 'LU'),
    ('194.007.084.000', 'BE'),
    ('194.007.192.000', 'LU'),
    ('194.007.198.000', 'BE'),
    ('194.007.199.000', 'LU'),
    ('194.007.203.000', 'BE'),
    ('194.007.204.000', 'LU'),
    ('194.007.208.000', 'BE'),
    ('194.007.209.000', 'LU'),
    ('194.007.210.000', 'BE'),
    ('194.008.000.000', 'DE'),
    ('194.008.001.000', 'LV'),
    ('194.008.014.000', 'RU'),
    ('194.008.016.000', 'LV'),
    ('194.008.028.000', 'EU'),
    ('194.008.032.000', 'LV'),
    ('194.008.045.000', 'PL'),
    ('194.008.047.000', 'FR'),
    ('194.008.048.000', 'EU'),
    ('194.008.064.000', 'DE'),
    ('194.008.069.000', 'BE'),
    ('194.008.070.000', 'DE'),
    ('194.008.128.000', 'AT'),
    ('194.008.160.000', 'RU'),
    ('194.008.192.000', 'DE'),
    ('194.008.224.000', 'GB'),
    ('194.009.000.000', 'IE'),
    ('194.009.064.000', 'EU'),
    ('194.009.066.000', 'HU'),
    ('194.009.068.000', 'EU'),
    ('194.009.096.000', 'DK'),
    ('194.009.117.000', 'DE'),
    ('194.009.167.000', 'RO'),
    ('194.009.168.000', 'DE'),
    ('194.009.170.000', 'LV'),
    ('194.009.172.000', 'GB'),
    ('194.009.174.000', 'TR'),
    ('194.009.175.000', 'LV'),
    ('194.009.176.000', 'BE'),
    ('194.009.180.000', 'AT'),
    ('194.009.182.000', 'DE'),
    ('194.009.184.000', 'FR'),
    ('194.009.188.000', 'GB'),
    ('194.009.192.000', 'DE'),
    ('194.009.208.000', 'GB'),
    ('194.009.220.000', 'IT'),
    ('194.009.222.000', 'FR'),
    ('194.009.223.000', 'PL'),
    ('194.009.224.000', 'FI'),
    ('194.010.000.000', 'GB'),
    ('194.010.005.000', 'NL'),
    ('194.010.006.000', 'DE'),
    ('194.010.007.000', 'GB'),
    ('194.010.029.000', 'AT'),
    ('194.010.030.000', 'BE'),
    ('194.010.031.000', 'DK'),
    ('194.010.032.000', 'FI'),
    ('194.010.033.000', 'FR'),
    ('194.010.034.000', 'DE'),
    ('194.010.035.000', 'NL'),
    ('194.010.036.000', 'IT'),
    ('194.010.037.000', 'NO'),
    ('194.010.038.000', 'ES'),
    ('194.010.039.000', 'SE'),
    ('194.010.040.000', 'CH'),
    ('194.010.041.000', 'NL'),
    ('194.010.042.000', 'DK'),
    ('194.010.043.000', 'NL'),
    ('194.010.044.000', 'GB'),
    ('194.010.045.000', 'BE'),
    ('194.010.046.000', 'CH'),
    ('194.010.048.000', 'BE'),
    ('194.010.058.000', 'GB'),
    ('194.010.059.000', 'FR'),
    ('194.010.060.000', 'DE'),
    ('194.010.062.000', 'FR'),
    ('194.010.068.000', 'DK'),
    ('194.010.069.000', 'BE'),
    ('194.010.070.000', 'GB'),
    ('194.010.084.000', 'NL'),
    ('194.010.085.000', 'BE'),
    ('194.010.086.000', 'GB'),
    ('194.010.113.000', 'BE'),
    ('194.010.114.000', 'GB'),
    ('194.010.118.000', 'NL'),
    ('194.010.119.000', 'GB'),
    ('194.010.134.000', 'DE'),
    ('194.010.135.000', 'DK'),
    ('194.010.136.000', 'AT'),
    ('194.010.138.000', 'DE'),
    ('194.010.139.000', 'HU'),
    ('194.010.140.000', 'BE'),
    ('194.010.142.000', 'GB'),
    ('194.010.143.000', 'BE'),
    ('194.010.144.000', 'GB'),
    ('194.010.145.000', 'BE'),
    ('194.010.146.000', 'NL'),
    ('194.010.147.000', 'BE'),
    ('194.010.148.000', 'GB'),
    ('194.010.149.000', 'CH'),
    ('194.010.150.000', 'BE'),
    ('194.010.151.000', 'NO'),
    ('194.010.152.000', 'IT'),
    ('194.010.160.000', 'GB'),
    ('194.010.162.000', 'IE'),
    ('194.010.163.000', 'NL'),
    ('194.010.164.000', 'GB'),
    ('194.010.165.000', 'CH'),
    ('194.010.166.000', 'GB'),
    ('194.010.168.000', 'DE'),
    ('194.010.184.000', 'GB'),
    ('194.010.185.000', 'BE'),
    ('194.010.186.000', 'GB'),
    ('194.010.187.000', 'DE'),
    ('194.010.192.000', 'PL'),
    ('194.010.193.000', 'NL'),
    ('194.010.194.000', 'CH'),
    ('194.010.195.000', 'AT'),
    ('194.010.196.000', 'FR'),
    ('194.010.200.000', 'BE'),
    ('194.010.202.000', 'GB'),
    ('194.010.204.000', 'BE'),
    ('194.010.205.000', 'GB'),
    ('194.010.206.000', 'BE'),
    ('194.010.207.000', 'GB'),
    ('194.010.208.000', 'AT'),
    ('194.010.212.000', 'DE'),
    ('194.010.224.000', 'GB'),
    ('194.010.240.000', 'DE'),
    ('194.010.244.000', 'BE'),
    ('194.010.245.000', 'DE'),
    ('194.010.246.000', 'FR'),
    ('194.010.247.000', 'GB'),
    ('194.010.248.000', 'FR'),
    ('194.011.000.000', 'CH'),
    ('194.011.224.000', 'BE'),
    ('194.011.225.000', 'CH'),
    ('194.012.000.000', 'EU'),
    ('194.012.128.000', 'CH'),
    ('194.012.192.000', 'DE'),
    ('194.012.224.000', 'BG'),
    ('194.013.000.000', 'NL'),
    ('194.013.135.000', 'DE'),
    ('194.013.136.000', 'NL'),
    ('194.014.000.000', 'SE'),
    ('194.015.000.000', 'DE'),
    ('194.016.000.000', 'SE'),
    ('194.019.000.000', 'NO'),
    ('194.019.064.000', 'DK'),
    ('194.019.065.000', 'NO'),
    ('194.019.072.000', 'SE'),
    ('194.019.074.000', 'NO'),
    ('194.019.092.000', 'DK'),
    ('194.019.093.000', 'NO'),
    ('194.019.114.000', 'SE'),
    ('194.019.116.000', 'NO'),
    ('194.019.128.000', 'DK'),
    ('194.019.144.000', 'SE'),
    ('194.019.148.000', 'DK'),
    ('194.019.194.000', 'SE'),
    ('194.019.195.000', 'DK'),
    ('194.019.200.000', 'SE'),
    ('194.019.202.000', 'DK'),
    ('194.019.215.000', 'US'),
    ('194.019.216.000', 'DK'),
    ('194.019.217.000', 'SE'),
    ('194.019.218.000', 'DK'),
    ('194.019.222.000', 'SE'),
    ('194.019.223.000', 'DK'),
    ('194.019.224.000', 'LV'),
    ('194.020.000.000', 'IT'),
    ('194.021.034.000', 'SE'),
    ('194.021.036.000', 'IT'),
    ('194.021.122.000', 'SM'),
    ('194.021.123.000', 'IT'),
    ('194.022.000.000', 'NL'),
    ('194.022.032.000', 'DE'),
    ('194.022.048.000', 'SE'),
    ('194.022.056.000', 'LU'),
    ('194.022.064.000', 'NO'),
    ('194.022.096.000', 'SE'),
    ('194.023.066.000', 'FI'),
    ('194.023.067.000', 'SE'),
    ('194.023.068.000', 'FI'),
    ('194.023.069.000', 'SE'),
    ('194.023.227.000', 'DE'),
    ('194.023.228.000', 'SE'),
    ('194.023.238.000', 'DE'),
    ('194.023.239.000', 'SE'),
    ('194.023.240.000', 'DE'),
    ('194.023.242.000', 'SE'),
    ('194.024.000.000', 'CH'),
    ('194.024.128.000', 'AT'),
    ('194.024.160.000', 'HU'),
    ('194.024.192.000', 'DE'),
    ('194.024.224.000', 'CZ'),
    ('194.025.000.000', 'DE'),
    ('194.026.000.000', 'NL'),
    ('194.026.022.000', 'GR'),
    ('194.026.024.000', 'NL'),
    ('194.026.114.000', 'GB'),
    ('194.026.115.000', 'NL'),
    ('194.026.117.000', 'GB'),
    ('194.026.118.000', 'NL'),
    ('194.026.158.000', 'DE'),
    ('194.026.160.000', 'NL'),
    ('194.027.000.000', 'TR'),
    ('194.028.000.000', 'IT'),
    ('194.029.000.000', 'CH'),
    ('194.029.032.000', 'EU'),
    ('194.029.064.000', 'BE'),
    ('194.029.066.000', 'ES'),
    ('194.029.068.000', 'IT'),
    ('194.029.070.000', 'EU'),
    ('194.029.071.000', 'GB'),
    ('194.029.072.000', 'GR'),
    ('194.029.096.000', 'IR'),
    ('194.029.097.000', 'BE'),
    ('194.029.099.000', 'AT'),
    ('194.029.100.000', 'GR'),
    ('194.029.104.000', 'DE'),
    ('194.029.112.000', 'EU'),
    ('194.029.128.000', 'PL'),
    ('194.029.180.000', 'EU'),
    ('194.029.192.000', 'FI'),
    ('194.029.200.000', 'NO'),
    ('194.029.204.000', 'IT'),
    ('194.029.205.000', 'UA'),
    ('194.029.206.000', 'NL'),
    ('194.029.207.000', 'DK'),
    ('194.029.208.000', 'TR'),
    ('194.029.216.000', 'GB'),
    ('194.029.224.000', 'DE'),
    ('194.030.000.000', 'ES'),
    ('194.030.128.000', 'CY'),
    ('194.030.160.000', 'EU'),
    ('194.030.192.000', 'GR'),
    ('194.031.000.000', 'DE'),
    ('194.032.000.000', 'GB'),
    ('194.037.000.000', 'AT'),
    ('194.038.000.000', 'SE'),
    ('194.038.064.000', 'CH'),
    ('194.038.096.000', 'HU'),
    ('194.038.128.000', 'PT'),
    ('194.038.160.000', 'CH'),
    ('194.039.000.000', 'DE'),
    ('194.039.207.000', 'FR'),
    ('194.039.208.000', 'DE'),
    ('194.040.000.000', 'CH'),
    ('194.041.000.000', 'NL'),
    ('194.041.001.000', 'GB'),
    ('194.041.002.000', 'EU'),
    ('194.041.004.000', 'IT'),
    ('194.041.008.000', 'EU'),
    ('194.041.009.000', 'IT'),
    ('194.041.010.000', 'GB'),
    ('194.041.012.000', 'BE'),
    ('194.041.016.000', 'FI'),
    ('194.041.032.000', 'ES'),
    ('194.041.033.000', 'FI'),
    ('194.041.034.000', 'DE'),
    ('194.041.036.000', 'EU'),
    ('194.041.037.000', 'DE'),
    ('194.041.040.000', 'NL'),
    ('194.041.041.000', 'SE'),
    ('194.041.043.000', 'GB'),
    ('194.041.053.000', 'NL'),
    ('194.041.055.000', 'SE'),
    ('194.041.056.000', 'GB'),
    ('194.041.057.000', 'DE'),
    ('194.041.058.000', 'FI'),
    ('194.041.059.000', 'FR'),
    ('194.041.060.000', 'AT'),
    ('194.041.062.000', 'NL'),
    ('194.041.063.000', 'CH'),
    ('194.041.096.000', 'BE'),
    ('194.041.112.000', 'CH'),
    ('194.041.121.000', 'NL'),
    ('194.041.128.000', 'CH'),
    ('194.042.000.000', 'CY'),
    ('194.042.040.000', 'PL'),
    ('194.042.041.000', 'IT'),
    ('194.042.043.000', 'PL'),
    ('194.042.047.000', 'DK'),
    ('194.042.048.000', 'CH'),
    ('194.042.049.000', 'EU'),
    ('194.042.050.000', 'GR'),
    ('194.042.055.000', 'DE'),
    ('194.042.056.000', 'FI'),
    ('194.042.064.000', 'DE'),
    ('194.042.096.000', 'AT'),
    ('194.042.128.000', 'CY'),
    ('194.042.160.000', 'CH'),
    ('194.042.163.000', 'GB'),
    ('194.042.164.000', 'IT'),
    ('194.042.165.000', 'BE'),
    ('194.042.171.000', 'AT'),
    ('194.042.176.000', 'DE'),
    ('194.042.192.000', 'UA'),
    ('194.042.208.000', 'NL'),
    ('194.042.210.000', 'BE'),
    ('194.042.212.000', 'LU'),
    ('194.042.213.000', 'ES'),
    ('194.042.215.000', 'GB'),
    ('194.042.216.000', 'US'),
    ('194.042.217.000', 'FR'),
    ('194.042.218.000', 'BE'),
    ('194.042.219.000', 'AS'),
    ('194.042.220.000', 'BE'),
    ('194.042.224.000', 'GB'),
    ('194.044.000.000', 'UA'),
    ('194.045.000.000', 'DE'),
    ('194.046.000.000', 'GB'),
    ('194.047.000.000', 'SE'),
    ('194.048.000.000', 'AT'),
    ('194.049.000.000', 'DE'),
    ('194.050.000.000', 'CZ'),
    ('194.050.191.000', 'DE'),
    ('194.050.192.000', 'CZ'),
    ('194.051.000.000', 'FR'),
    ('194.051.026.000', 'MC'),
    ('194.051.027.000', 'FR'),
    ('194.051.163.000', 'BJ'),
    ('194.051.164.000', 'FR'),
    ('194.051.165.000', 'MG'),
    ('194.051.166.000', 'FR'),
    ('194.051.177.000', 'ES'),
    ('194.051.178.000', 'FR'),
    ('194.052.000.000', 'SE'),
    ('194.052.170.000', 'NO'),
    ('194.052.176.000', 'SE'),
    ('194.052.245.000', 'NO'),
    ('194.052.246.000', 'SE'),
    ('194.052.247.000', 'NO'),
    ('194.052.250.000', 'SE'),
    ('194.053.000.000', 'NL'),
    ('194.053.076.000', 'FR'),
    ('194.053.080.000', 'NL'),
    ('194.053.172.000', 'BE'),
    ('194.053.173.000', 'NL'),
    ('194.053.175.000', 'GB'),
    ('194.053.176.000', 'NL'),
    ('194.054.000.000', 'AE'),
    ('194.054.032.000', 'TR'),
    ('194.054.064.000', 'KE'),
    ('194.054.076.000', 'TH'),
    ('194.054.077.000', 'AT'),
    ('194.054.080.000', 'CH'),
    ('194.054.087.000', 'AT'),
    ('194.054.088.000', 'NO'),
    ('194.054.089.000', 'AT'),
    ('194.054.090.000', 'NO'),
    ('194.054.091.000', 'AT'),
    ('194.054.096.000', 'NO'),
    ('194.054.128.000', 'EU'),
    ('194.054.192.000', 'KW'),
    ('194.055.000.000', 'DE'),
    ('194.056.000.000', 'CH'),
    ('194.057.000.000', 'FR'),
    ('194.058.000.000', 'RU'),
    ('194.058.082.000', 'UA'),
    ('194.058.084.000', 'RU'),
    ('194.058.175.000', 'UA'),
    ('194.058.176.000', 'RU'),
    ('194.059.000.000', 'DE'),
    ('194.060.000.000', 'GB'),
    ('194.063.160.000', 'GR'),
    ('194.063.248.000', 'NO'),
    ('194.064.000.000', 'DE'),
    ('194.065.000.000', 'PT'),
    ('194.065.087.000', 'GW'),
    ('194.065.088.000', 'PT'),
    ('194.066.000.000', 'GB'),
    ('194.067.000.000', 'RU'),
    ('194.067.030.000', 'KZ'),
    ('194.067.031.000', 'RU'),
    ('194.067.032.000', 'UZ'),
    ('194.067.033.000', 'RU'),
    ('194.067.075.000', 'BY'),
    ('194.067.076.000', 'RU'),
    ('194.067.091.000', 'UA'),
    ('194.067.092.000', 'RU'),
    ('194.067.192.000', 'BY'),
    ('194.067.194.000', 'RU'),
    ('194.067.204.000', 'UA'),
    ('194.067.206.000', 'RU'),
    ('194.067.216.000', 'GE'),
    ('194.067.219.000', 'RU'),
    ('194.067.221.000', 'KZ'),
    ('194.067.223.000', 'RU'),
    ('194.068.000.000', 'SE'),
    ('194.068.129.000', 'FR'),
    ('194.068.130.000', 'SE'),
    ('194.069.000.000', 'DE'),
    ('194.069.001.000', 'AE'),
    ('194.069.002.000', 'CH'),
    ('194.069.006.000', 'SE'),
    ('194.069.016.000', 'NL'),
    ('194.069.032.000', 'EU'),
    ('194.069.036.000', 'DE'),
    ('194.069.038.000', 'CH'),
    ('194.069.039.000', 'DE'),
    ('194.069.042.000', 'GB'),
    ('194.069.044.000', 'SE'),
    ('194.069.045.000', 'FR'),
    ('194.069.046.000', 'DE'),
    ('194.069.048.000', 'BE'),
    ('194.069.056.000', 'DE'),
    ('194.069.060.000', 'CH'),
    ('194.069.064.000', 'GB'),
    ('194.069.065.000', 'CH'),
    ('194.069.066.000', 'GB'),
    ('194.069.073.000', 'FR'),
    ('194.069.074.000', 'GB'),
    ('194.069.128.000', 'DE'),
    ('194.069.143.000', 'EU'),
    ('194.069.144.000', 'GB'),
    ('194.069.160.000', 'CH'),
    ('194.069.168.000', 'GB'),
    ('194.069.169.000', 'IE'),
    ('194.069.170.000', 'CH'),
    ('194.069.171.000', 'DE'),
    ('194.069.176.000', 'SE'),
    ('194.069.177.000', 'EU'),
    ('194.069.178.000', 'CH'),
    ('194.069.180.000', 'SE'),
    ('194.069.181.000', 'CH'),
    ('194.069.184.000', 'NL'),
    ('194.069.192.000', 'IT'),
    ('194.069.194.000', 'FR'),
    ('194.069.196.000', 'CH'),
    ('194.069.198.000', 'IE'),
    ('194.069.200.000', 'NO'),
    ('194.069.203.000', 'EU'),
    ('194.069.224.000', 'ES'),
    ('194.070.000.000', 'GB'),
    ('194.071.000.000', 'SE'),
    ('194.072.000.000', 'GB'),
    ('194.072.033.000', 'ES'),
    ('194.072.034.000', 'GB'),
    ('194.072.036.000', 'CH'),
    ('194.072.037.000', 'GB'),
    ('194.072.038.000', 'ES'),
    ('194.072.039.000', 'GB'),
    ('194.072.067.000', 'ES'),
    ('194.072.068.000', 'GB'),
    ('194.072.077.000', 'ES'),
    ('194.072.078.000', 'GB'),
    ('194.072.079.000', 'ES'),
    ('194.072.080.000', 'GB'),
    ('194.072.088.000', 'NL'),
    ('194.072.090.000', 'GB'),
    ('194.072.103.000', 'ES'),
    ('194.072.104.000', 'GB'),
    ('194.072.126.000', 'NL'),
    ('194.072.127.000', 'GB'),
    ('194.072.128.000', 'CH'),
    ('194.072.129.000', 'GB'),
    ('194.072.131.000', 'US'),
    ('194.072.132.000', 'GB'),
    ('194.072.142.000', 'IE'),
    ('194.072.143.000', 'GB'),
    ('194.072.152.000', 'ES'),
    ('194.072.154.000', 'GB'),
    ('194.072.157.000', 'ES'),
    ('194.072.158.000', 'GB'),
    ('194.072.168.000', 'NL'),
    ('194.072.176.000', 'GB'),
    ('194.072.184.000', 'LB'),
    ('194.072.186.000', 'GB'),
    ('194.072.224.000', 'ES'),
    ('194.072.225.000', 'GB'),
    ('194.072.250.000', 'ES'),
    ('194.072.251.000', 'GB'),
    ('194.073.017.000', 'NL'),
    ('194.073.018.000', 'GB'),
    ('194.073.019.000', 'NL'),
    ('194.073.020.000', 'GB'),
    ('194.073.024.000', 'EU'),
    ('194.073.026.000', 'ES'),
    ('194.073.027.000', 'EU'),
    ('194.073.029.000', 'ES'),
    ('194.073.030.000', 'EU'),
    ('194.073.032.000', 'GB'),
    ('194.073.060.000', 'NL'),
    ('194.073.061.000', 'GB'),
    ('194.073.068.000', 'ES'),
    ('194.073.070.000', 'GB'),
    ('194.073.074.000', 'NL'),
    ('194.073.075.000', 'GB'),
    ('194.073.092.000', 'ES'),
    ('194.073.094.000', 'IT'),
    ('194.073.096.000', 'GB'),
    ('194.073.128.000', 'ES'),
    ('194.073.129.000', 'GB'),
    ('194.073.138.000', 'FR'),
    ('194.073.139.000', 'GB'),
    ('194.073.145.000', 'IE'),
    ('194.073.146.000', 'GB'),
    ('194.073.197.000', 'DE'),
    ('194.073.198.000', 'GB'),
    ('194.073.199.000', 'DE'),
    ('194.073.200.000', 'GB'),
    ('194.073.202.000', 'FR'),
    ('194.073.203.000', 'GB'),
    ('194.073.219.000', 'DE'),
    ('194.073.220.000', 'GB'),
    ('194.073.250.000', 'CH'),
    ('194.073.252.000', 'GB'),
    ('194.074.003.000', 'ES'),
    ('194.074.004.000', 'GB'),
    ('194.074.015.000', 'DE'),
    ('194.074.016.000', 'GB'),
    ('194.074.024.000', 'ES'),
    ('194.074.025.000', 'GB'),
    ('194.074.028.000', 'PK'),
    ('194.074.029.000', 'GB'),
    ('194.074.032.000', 'ES'),
    ('194.074.033.000', 'GB'),
    ('194.074.036.000', 'BE'),
    ('194.074.037.000', 'GB'),
    ('194.074.039.000', 'DE'),
    ('194.074.040.000', 'GB'),
    ('194.074.042.000', 'ES'),
    ('194.074.043.000', 'GB'),
    ('194.074.044.000', 'ES'),
    ('194.074.046.000', 'GB'),
    ('194.074.050.000', 'BE'),
    ('194.074.051.000', 'GB'),
    ('194.074.080.000', 'NL'),
    ('194.074.084.000', 'EU'),
    ('194.074.085.000', 'NL'),
    ('194.074.087.000', 'EU'),
    ('194.074.088.000', 'ES'),
    ('194.074.089.000', 'EU'),
    ('194.074.097.000', 'NO'),
    ('194.074.098.000', 'EU'),
    ('194.074.100.000', 'SE'),
    ('194.074.101.000', 'EU'),
    ('194.074.104.000', 'BE'),
    ('194.074.106.000', 'EU'),
    ('194.074.107.000', 'BE'),
    ('194.074.109.000', 'EU'),
    ('194.074.110.000', 'FR'),
    ('194.074.111.000', 'BE'),
    ('194.074.112.000', 'FR'),
    ('194.074.114.000', 'EU'),
    ('194.074.120.000', 'CH'),
    ('194.074.122.000', 'EU'),
    ('194.074.130.000', 'IT'),
    ('194.074.131.000', 'EU'),
    ('194.074.137.000', 'DE'),
    ('194.074.138.000', 'EU'),
    ('194.074.143.000', 'DE'),
    ('194.074.144.000', 'GB'),
    ('194.074.152.000', 'EU'),
    ('194.074.160.000', 'ES'),
    ('194.074.162.000', 'EU'),
    ('194.074.187.000', 'ES'),
    ('194.074.188.000', 'EU'),
    ('194.074.192.000', 'GB'),
    ('194.075.000.000', 'ES'),
    ('194.075.002.000', 'EU'),
    ('194.075.003.000', 'ES'),
    ('194.075.004.000', 'EU'),
    ('194.075.006.000', 'ES'),
    ('194.075.007.000', 'EU'),
    ('194.075.016.000', 'ES'),
    ('194.075.018.000', 'EU'),
    ('194.075.026.000', 'DE'),
    ('194.075.029.000', 'EU'),
    ('194.075.032.000', 'GB'),
    ('194.075.040.000', 'IT'),
    ('194.075.041.000', 'EU'),
    ('194.075.048.000', 'GB'),
    ('194.075.050.000', 'EU'),
    ('194.075.052.000', 'GB'),
    ('194.075.053.000', 'EU'),
    ('194.075.054.000', 'GB'),
    ('194.075.055.000', 'EU'),
    ('194.075.056.000', 'LU'),
    ('194.075.057.000', 'EU'),
    ('194.075.079.000', 'ES'),
    ('194.075.080.000', 'EU'),
    ('194.075.096.000', 'GB'),
    ('194.075.104.000', 'EU'),
    ('194.075.126.000', 'IT'),
    ('194.075.127.000', 'EU'),
    ('194.075.128.000', 'GB'),
    ('194.075.192.000', 'EU'),
    ('194.075.200.000', 'CH'),
    ('194.075.202.000', 'EU'),
    ('194.075.218.000', 'FR'),
    ('194.075.219.000', 'EU'),
    ('194.075.220.000', 'FR'),
    ('194.075.221.000', 'GB'),
    ('194.075.222.000', 'EU'),
    ('194.075.223.000', 'FR'),
    ('194.075.224.000', 'GB'),
    ('194.076.000.000', 'DE'),
    ('194.078.000.000', 'BE'),
    ('194.079.000.000', 'FR'),
    ('194.079.013.000', 'NL'),
    ('194.079.014.000', 'FR'),
    ('194.079.028.000', 'GB'),
    ('194.079.030.000', 'FR'),
    ('194.079.064.000', 'PT'),
    ('194.079.096.000', 'EG'),
    ('194.079.128.000', 'FR'),
    ('194.079.192.000', 'IT'),
    ('194.079.224.000', 'NL'),
    ('194.079.240.000', 'GB'),
    ('194.079.244.000', 'DE'),
    ('194.079.250.000', 'NL'),
    ('194.079.252.000', 'GR'),
    ('194.079.254.000', 'NL'),
    ('194.080.000.000', 'GB'),
    ('194.084.000.000', 'RU'),
    ('194.084.006.000', 'TM'),
    ('194.084.007.000', 'RU'),
    ('194.084.015.000', 'KZ'),
    ('194.084.016.000', 'RU'),
    ('194.084.074.000', 'BY'),
    ('194.084.075.000', 'RU'),
    ('194.084.145.000', 'BY'),
    ('194.084.146.000', 'RU'),
    ('194.084.160.000', 'KZ'),
    ('194.084.161.000', 'RU'),
    ('194.084.163.000', 'GE'),
    ('194.084.164.000', 'RU'),
    ('194.084.208.000', 'TM'),
    ('194.084.209.000', 'RU'),
    ('194.084.221.000', 'AM'),
    ('194.084.222.000', 'RU'),
    ('194.084.244.000', 'UZ'),
    ('194.084.245.000', 'RU'),
    ('194.085.012.000', 'AZ'),
    ('194.085.013.000', 'RU'),
    ('194.085.016.000', 'KZ'),
    ('194.085.021.000', 'RU'),
    ('194.085.254.000', 'BY'),
    ('194.086.000.000', 'FI'),
    ('194.087.000.000', 'RU'),
    ('194.087.112.000', 'KZ'),
    ('194.087.116.000', 'RU'),
    ('194.088.008.000', 'EU'),
    ('194.088.016.000', 'DE'),
    ('194.088.027.000', 'GB'),
    ('194.088.028.000', 'SE'),
    ('194.088.032.000', 'HU'),
    ('194.088.049.000', 'RO'),
    ('194.088.050.000', 'HU'),
    ('194.088.064.000', 'GB'),
    ('194.088.096.000', 'BE'),
    ('194.088.128.000', 'GB'),
    ('194.088.160.000', 'DE'),
    ('194.088.192.000', 'EU'),
    ('194.088.224.000', 'IT'),
    ('194.089.000.000', 'FI'),
    ('194.089.004.000', 'DE'),
    ('194.089.005.000', 'DK'),
    ('194.089.006.000', 'FI'),
    ('194.089.053.000', 'ES'),
    ('194.089.054.000', 'FI'),
    ('194.089.056.000', 'SE'),
    ('194.089.057.000', 'FI'),
    ('194.089.218.000', 'ES'),
    ('194.089.219.000', 'GB'),
    ('194.089.220.000', 'FI'),
    ('194.089.221.000', 'DE'),
    ('194.089.223.000', 'IT'),
    ('194.089.224.000', 'FI'),
    ('194.090.000.000', 'IL'),
    ('194.091.000.000', 'IT'),
    ('194.091.221.000', 'BE'),
    ('194.091.222.000', 'IT'),
    ('194.092.000.000', 'PL'),
    ('194.093.000.000', 'EU'),
    ('194.093.004.000', 'GB'),
    ('194.093.005.000', 'EU'),
    ('194.093.064.000', 'DK'),
    ('194.093.065.000', 'IT'),
    ('194.093.066.000', 'NL'),
    ('194.093.067.000', 'ES'),
    ('194.093.068.000', 'GB'),
    ('194.093.069.000', 'FI'),
    ('194.093.070.000', 'PT'),
    ('194.093.071.000', 'SE'),
    ('194.093.072.000', 'AT'),
    ('194.093.073.000', 'SE'),
    ('194.093.076.000', 'AT'),
    ('194.093.080.000', 'SE'),
    ('194.093.092.000', 'ES'),
    ('194.093.096.000', 'CH'),
    ('194.093.099.000', 'EU'),
    ('194.093.103.000', 'DE'),
    ('194.093.112.000', 'CH'),
    ('194.093.123.000', 'DE'),
    ('194.093.124.000', 'FR'),
    ('194.093.128.000', 'GB'),
    ('194.093.160.000', 'UA'),
    ('194.093.192.000', 'DE'),
    ('194.096.000.000', 'AT'),
    ('194.097.000.000', 'DE'),
    ('194.098.000.000', 'FR'),
    ('194.098.249.000', 'MC'),
    ('194.098.250.000', 'FR'),
    ('194.099.000.000', 'DE'),
    ('194.100.000.000', 'FI'),
    ('194.101.000.000', 'GB'),
    ('194.102.032.000', 'RO'),
    ('194.102.152.000', 'MD'),
    ('194.102.154.000', 'RO'),
    ('194.103.000.000', 'SE'),
    ('194.104.000.000', 'NL'),
    ('194.105.000.000', 'RO'),
    ('194.105.032.000', 'MT'),
    ('194.105.048.000', 'IT'),
    ('194.105.056.000', 'LV'),
    ('194.105.058.000', 'GB'),
    ('194.105.059.000', 'IT'),
    ('194.105.060.000', 'DK'),
    ('194.105.061.000', 'IT'),
    ('194.105.062.000', 'GB'),
    ('194.105.096.000', 'EU'),
    ('194.105.128.000', 'GB'),
    ('194.105.192.000', 'RU'),
    ('194.105.224.000', 'IS'),
    ('194.106.000.000', 'ES'),
    ('194.106.032.000', 'GB'),
    ('194.106.064.000', 'MT'),
    ('194.106.096.000', 'EE'),
    ('194.106.128.000', 'IE'),
    ('194.106.160.000', 'YU'),
    ('194.106.192.000', 'EU'),
    ('194.106.208.000', 'AZ'),
    ('194.106.212.000', 'EU'),
    ('194.106.224.000', 'AT'),
    ('194.108.000.000', 'CZ'),
    ('194.109.000.000', 'NL'),
    ('194.110.000.000', 'FI'),
    ('194.111.175.000', 'NL'),
    ('194.111.176.000', 'FI'),
    ('194.111.212.000', 'RU'),
    ('194.111.213.000', 'FI'),
    ('194.111.233.000', 'SE'),
    ('194.111.235.000', 'FI'),
    ('194.111.237.000', 'RU'),
    ('194.111.238.000', 'FI'),
    ('194.112.016.000', 'DE'),
    ('194.112.032.000', 'GB'),
    ('194.112.064.000', 'DE'),
    ('194.112.095.000', 'FR'),
    ('194.112.096.000', 'DE'),
    ('194.112.128.000', 'AT'),
    ('194.113.000.000', 'DE'),
    ('194.114.152.000', 'SE'),
    ('194.115.000.000', 'DE'),
    ('194.116.000.000', 'IT'),
    ('194.116.064.000', 'EU'),
    ('194.117.000.000', 'PT'),
    ('194.117.050.000', 'EU'),
    ('194.117.064.000', 'RU'),
    ('194.117.096.000', 'DE'),
    ('194.117.098.000', 'US'),
    ('194.117.099.000', 'DE'),
    ('194.117.100.000', 'JP'),
    ('194.117.101.000', 'DE'),
    ('194.117.104.000', 'AU'),
    ('194.117.105.000', 'DE'),
    ('194.117.108.000', 'MU'),
    ('194.117.109.000', 'US'),
    ('194.117.110.000', 'DE'),
    ('194.117.113.000', 'DK'),
    ('194.117.114.000', 'CA'),
    ('194.117.115.000', 'DE'),
    ('194.117.116.000', 'ES'),
    ('194.117.117.000', 'BE'),
    ('194.117.118.000', 'GB'),
    ('194.117.119.000', 'DE'),
    ('194.117.128.000', 'GB'),
    ('194.117.160.000', 'SE'),
    ('194.117.192.000', 'FR'),
    ('194.117.224.000', 'EU'),
    ('194.118.000.000', 'AT'),
    ('194.119.000.000', 'FR'),
    ('194.119.128.000', 'GB'),
    ('194.119.192.000', 'IT'),
    ('194.119.224.000', 'BE'),
    ('194.120.000.000', 'DE'),
    ('194.121.068.000', 'CH'),
    ('194.121.069.000', 'DE'),
    ('194.124.000.000', 'CH'),
    ('194.125.000.000', 'IE'),
    ('194.125.224.000', 'UA'),
    ('194.125.228.000', 'GB'),
    ('194.125.232.000', 'TR'),
    ('194.125.236.000', 'RU'),
    ('194.125.240.000', 'LV'),
    ('194.125.242.000', 'IT'),
    ('194.125.244.000', 'UA'),
    ('194.125.246.000', 'GB'),
    ('194.125.248.000', 'UA'),
    ('194.125.250.000', 'CH'),
    ('194.125.252.000', 'GR'),
    ('194.125.254.000', 'AT'),
    ('194.126.000.000', 'LB'),
    ('194.126.032.000', 'KW'),
    ('194.126.064.000', 'GB'),
    ('194.126.096.000', 'EE'),
    ('194.126.128.000', 'MC'),
    ('194.126.129.000', 'FR'),
    ('194.126.130.000', 'NL'),
    ('194.126.131.000', 'DE'),
    ('194.126.133.000', 'NL'),
    ('194.126.136.000', 'LB'),
    ('194.126.144.000', 'EU'),
    ('194.127.000.000', 'DE'),
    ('194.128.000.000', 'GB'),
    ('194.128.011.000', 'EU'),
    ('194.128.012.000', 'GB'),
    ('194.128.017.000', 'EU'),
    ('194.128.018.000', 'GB'),
    ('194.128.027.000', 'EU'),
    ('194.128.031.000', 'GB'),
    ('194.128.034.000', 'EU'),
    ('194.128.036.000', 'GB'),
    ('194.128.045.000', 'EU'),
    ('194.128.046.000', 'GB'),
    ('194.128.072.000', 'EU'),
    ('194.128.073.000', 'GB'),
    ('194.128.087.000', 'EU'),
    ('194.128.088.000', 'GB'),
    ('194.128.094.000', 'EU'),
    ('194.128.095.000', 'GB'),
    ('194.128.096.000', 'EU'),
    ('194.128.097.000', 'GB'),
    ('194.128.111.000', 'EU'),
    ('194.128.112.000', 'GB'),
    ('194.128.136.000', 'EU'),
    ('194.128.138.000', 'GB'),
    ('194.128.149.000', 'EU'),
    ('194.128.150.000', 'GB'),
    ('194.128.158.000', 'EU'),
    ('194.128.159.000', 'GB'),
    ('194.128.162.000', 'EU'),
    ('194.128.164.000', 'GB'),
    ('194.128.181.000', 'EU'),
    ('194.128.182.000', 'GB'),
    ('194.128.198.000', 'EU'),
    ('194.128.199.000', 'GB'),
    ('194.128.200.000', 'EU'),
    ('194.128.201.000', 'GB'),
    ('194.128.225.000', 'EU'),
    ('194.128.226.000', 'GB'),
    ('194.129.008.000', 'EU'),
    ('194.129.009.000', 'GB'),
    ('194.129.015.000', 'EU'),
    ('194.129.016.000', 'GB'),
    ('194.129.022.000', 'EU'),
    ('194.129.023.000', 'GB'),
    ('194.129.038.000', 'EU'),
    ('194.129.039.000', 'GB'),
    ('194.129.055.000', 'EU'),
    ('194.129.056.000', 'GB'),
    ('194.129.064.000', 'EU'),
    ('194.129.096.000', 'GB'),
    ('194.129.098.000', 'EU'),
    ('194.129.099.000', 'GB'),
    ('194.129.110.000', 'EU'),
    ('194.129.112.000', 'GB'),
    ('194.129.130.000', 'EU'),
    ('194.129.131.000', 'GB'),
    ('194.129.146.000', 'EU'),
    ('194.129.147.000', 'GB'),
    ('194.129.149.000', 'EU'),
    ('194.129.151.000', 'GB'),
    ('194.129.164.000', 'EU'),
    ('194.129.165.000', 'GB'),
    ('194.129.166.000', 'EU'),
    ('194.129.168.000', 'GB'),
    ('194.129.176.000', 'EU'),
    ('194.129.178.000', 'GB'),
    ('194.129.181.000', 'EU'),
    ('194.129.182.000', 'GB'),
    ('194.129.192.000', 'EU'),
    ('194.129.194.000', 'GB'),
    ('194.129.195.000', 'EU'),
    ('194.129.196.000', 'GB'),
    ('194.129.212.000', 'EU'),
    ('194.129.213.000', 'GB'),
    ('194.129.214.000', 'EU'),
    ('194.129.215.000', 'GB'),
    ('194.129.217.000', 'EU'),
    ('194.129.218.000', 'GB'),
    ('194.129.223.000', 'EU'),
    ('194.129.224.000', 'GB'),
    ('194.129.231.000', 'EU'),
    ('194.129.232.000', 'GB'),
    ('194.129.233.000', 'EU'),
    ('194.129.234.000', 'GB'),
    ('194.129.241.000', 'EU'),
    ('194.129.242.000', 'GB'),
    ('194.129.249.000', 'EU'),
    ('194.129.250.000', 'GB'),
    ('194.129.254.000', 'EU'),
    ('194.129.255.000', 'GB'),
    ('194.130.004.000', 'EU'),
    ('194.130.006.000', 'GB'),
    ('194.130.030.000', 'EU'),
    ('194.130.032.000', 'GB'),
    ('194.130.033.000', 'EU'),
    ('194.130.034.000', 'GB'),
    ('194.130.038.000', 'EU'),
    ('194.130.039.000', 'GB'),
    ('194.130.044.000', 'EU'),
    ('194.130.045.000', 'GB'),
    ('194.130.047.000', 'EU'),
    ('194.130.049.000', 'GB'),
    ('194.130.057.000', 'EU'),
    ('194.130.058.000', 'GB'),
    ('194.130.060.000', 'EU'),
    ('194.130.061.000', 'GB'),
    ('194.130.077.000', 'EU'),
    ('194.130.078.000', 'GB'),
    ('194.130.117.000', 'EU'),
    ('194.130.118.000', 'GB'),
    ('194.130.125.000', 'EU'),
    ('194.130.126.000', 'GB'),
    ('194.130.134.000', 'EU'),
    ('194.130.135.000', 'GB'),
    ('194.130.136.000', 'EU'),
    ('194.130.137.000', 'GB'),
    ('194.130.145.000', 'EU'),
    ('194.130.148.000', 'GB'),
    ('194.130.152.000', 'ZM'),
    ('194.130.160.000', 'GB'),
    ('194.130.169.000', 'EU'),
    ('194.130.170.000', 'GB'),
    ('194.130.176.000', 'EU'),
    ('194.130.178.000', 'GB'),
    ('194.130.212.000', 'EU'),
    ('194.130.213.000', 'GB'),
    ('194.130.241.000', 'EU'),
    ('194.130.242.000', 'GB'),
    ('194.130.249.000', 'EU'),
    ('194.130.250.000', 'GB'),
    ('194.130.254.000', 'EU'),
    ('194.131.000.000', 'GB'),
    ('194.131.008.000', 'EU'),
    ('194.131.009.000', 'GB'),
    ('194.131.011.000', 'EU'),
    ('194.131.014.000', 'GB'),
    ('194.131.067.000', 'EU'),
    ('194.131.068.000', 'GB'),
    ('194.131.097.000', 'EU'),
    ('194.131.099.000', 'GB'),
    ('194.131.102.000', 'EU'),
    ('194.131.104.000', 'GB'),
    ('194.131.150.000', 'EU'),
    ('194.131.152.000', 'GB'),
    ('194.131.156.000', 'EU'),
    ('194.131.158.000', 'GB'),
    ('194.131.180.000', 'EU'),
    ('194.131.182.000', 'GB'),
    ('194.131.186.000', 'EU'),
    ('194.131.188.000', 'GB'),
    ('194.131.197.000', 'EU'),
    ('194.131.200.000', 'GB'),
    ('194.131.208.000', 'EU'),
    ('194.131.209.000', 'GB'),
    ('194.131.216.000', 'EU'),
    ('194.131.217.000', 'GB'),
    ('194.131.220.000', 'EU'),
    ('194.131.221.000', 'GB'),
    ('194.131.228.000', 'EU'),
    ('194.131.229.000', 'GB'),
    ('194.131.235.000', 'EU'),
    ('194.131.236.000', 'GB'),
    ('194.131.240.000', 'EU'),
    ('194.131.248.000', 'GB'),
    ('194.131.249.000', 'EU'),
    ('194.131.250.000', 'GB'),
    ('194.131.252.000', 'EU'),
    ('194.131.253.000', 'GB'),
    ('194.132.000.000', 'SE'),
    ('194.133.000.000', 'IT'),
    ('194.133.004.000', 'US'),
    ('194.133.007.000', 'GB'),
    ('194.133.008.000', 'FR'),
    ('194.133.009.000', 'ES'),
    ('194.133.010.000', 'US'),
    ('194.133.011.000', 'MC'),
    ('194.133.013.000', 'GB'),
    ('194.133.014.000', 'FR'),
    ('194.133.015.000', 'GB'),
    ('194.133.022.000', 'EG'),
    ('194.133.023.000', 'FR'),
    ('194.133.024.000', 'GB'),
    ('194.133.026.000', 'FR'),
    ('194.133.027.000', 'DE'),
    ('194.133.028.000', 'FR'),
    ('194.133.030.000', 'GB'),
    ('194.133.031.000', 'EG'),
    ('194.133.032.000', 'QA'),
    ('194.133.040.000', 'BE'),
    ('194.133.041.000', 'DE'),
    ('194.133.042.000', 'BE'),
    ('194.133.043.000', 'US'),
    ('194.133.044.000', 'GB'),
    ('194.133.046.000', 'IE'),
    ('194.133.047.000', 'GB'),
    ('194.133.049.000', 'SL'),
    ('194.133.050.000', 'US'),
    ('194.133.052.000', 'SE'),
    ('194.133.053.000', 'GB'),
    ('194.133.055.000', 'EU'),
    ('194.133.056.000', 'GB'),
    ('194.133.057.000', 'US'),
    ('194.133.058.000', 'EU'),
    ('194.133.060.000', 'BE'),
    ('194.133.062.000', 'GB'),
    ('194.133.063.000', 'ES'),
    ('194.133.065.000', 'TR'),
    ('194.133.066.000', 'FR'),
    ('194.133.067.000', 'US'),
    ('194.133.068.000', 'EU'),
    ('194.133.069.000', 'RU'),
    ('194.133.070.000', 'GB'),
    ('194.133.071.000', 'US'),
    ('194.133.075.000', 'ES'),
    ('194.133.077.000', 'GB'),
    ('194.133.078.000', 'FR'),
    ('194.133.079.000', 'LK'),
    ('194.133.080.000', 'US'),
    ('194.133.081.000', 'GB'),
    ('194.133.084.000', 'US'),
    ('194.133.085.000', 'GB'),
    ('194.133.087.000', 'FR'),
    ('194.133.088.000', 'IR'),
    ('194.133.089.000', 'GB'),
    ('194.133.090.000', 'MC'),
    ('194.133.092.000', 'GB'),
    ('194.133.094.000', 'FR'),
    ('194.133.095.000', 'US'),
    ('194.133.098.000', 'FR'),
    ('194.133.099.000', 'DE'),
    ('194.133.100.000', 'GB'),
    ('194.133.101.000', 'IE'),
    ('194.133.102.000', 'FR'),
    ('194.133.103.000', 'GB'),
    ('194.133.104.000', 'ES'),
    ('194.133.105.000', 'DE'),
    ('194.133.108.000', 'FR'),
    ('194.133.109.000', 'GB'),
    ('194.133.110.000', 'FR'),
    ('194.133.111.000', 'GB'),
    ('194.133.112.000', 'FR'),
    ('194.133.113.000', 'GB'),
    ('194.133.114.000', 'ES'),
    ('194.133.115.000', 'EU'),
    ('194.133.118.000', 'IT'),
    ('194.133.119.000', 'FR'),
    ('194.133.121.000', 'AO'),
    ('194.133.122.000', 'ZW'),
    ('194.133.123.000', 'EU'),
    ('194.133.124.000', 'SL'),
    ('194.133.125.000', 'FR'),
    ('194.133.126.000', 'GB'),
    ('194.133.128.000', 'EU'),
    ('194.133.132.000', 'GB'),
    ('194.133.133.000', 'BE'),
    ('194.133.134.000', 'GB'),
    ('194.133.135.000', 'IE'),
    ('194.133.136.000', 'FR'),
    ('194.133.138.000', 'DE'),
    ('194.133.139.000', 'FR'),
    ('194.133.140.000', 'GB'),
    ('194.133.143.000', 'IT'),
    ('194.133.159.000', 'ZW'),
    ('194.133.160.000', 'TR'),
    ('194.133.176.000', 'GB'),
    ('194.133.177.000', 'EU'),
    ('194.133.184.000', 'IL'),
    ('194.133.192.000', 'US'),
    ('194.133.240.000', 'TR'),
    ('194.133.250.000', 'EU'),
    ('194.133.253.000', 'TR'),
    ('194.133.254.000', 'EU'),
    ('194.133.255.000', 'TR'),
    ('194.134.000.000', 'NL'),
    ('194.135.000.000', 'RU'),
    ('194.135.118.000', 'KZ'),
    ('194.135.119.000', 'RU'),
    ('194.135.223.000', 'UA'),
    ('194.135.224.000', 'RU'),
    ('194.135.241.000', 'UA'),
    ('194.135.242.000', 'RU'),
    ('194.135.243.000', 'UA'),
    ('194.135.244.000', 'RU'),
    ('194.135.245.000', 'UA'),
    ('194.135.246.000', 'RU'),
    ('194.135.249.000', 'UA'),
    ('194.135.250.000', 'RU'),
    ('194.135.252.000', 'UA'),
    ('194.135.253.000', 'RU'),
    ('194.135.254.000', 'UA'),
    ('194.136.000.000', 'FI'),
    ('194.137.000.000', 'SE'),
    ('194.137.001.000', 'FI'),
    ('194.137.007.000', 'SE'),
    ('194.137.008.000', 'FI'),
    ('194.137.026.000', 'BE'),
    ('194.137.028.000', 'FI'),
    ('194.137.061.000', 'BE'),
    ('194.137.062.000', 'FI'),
    ('194.137.063.000', 'BE'),
    ('194.137.064.000', 'FI'),
    ('194.137.136.000', 'BE'),
    ('194.137.137.000', 'FI'),
    ('194.137.228.000', 'ES'),
    ('194.137.229.000', 'NL'),
    ('194.137.230.000', 'FI'),
    ('194.138.000.000', 'DE'),
    ('194.140.000.000', 'ES'),
    ('194.140.096.000', 'DE'),
    ('194.140.128.000', 'ES'),
    ('194.140.192.000', 'HU'),
    ('194.140.224.000', 'IT'),
    ('194.141.000.000', 'BG'),
    ('194.142.000.000', 'FI'),
    ('194.142.054.000', 'GB'),
    ('194.142.055.000', 'FI'),
    ('194.142.152.000', 'DE'),
    ('194.142.153.000', 'NL'),
    ('194.142.154.000', 'FI'),
    ('194.142.155.000', 'BE'),
    ('194.142.156.000', 'FI'),
    ('194.142.184.000', 'SE'),
    ('194.142.186.000', 'FI'),
    ('194.143.000.000', 'NO'),
    ('194.143.128.000', 'IT'),
    ('194.143.160.000', 'GB'),
    ('194.143.192.000', 'ES'),
    ('194.143.224.000', 'HU'),
    ('194.144.000.000', 'IS'),
    ('194.144.094.000', 'US'),
    ('194.144.097.000', 'IS'),
    ('194.145.000.000', 'GB'),
    ('194.145.032.000', 'FI'),
    ('194.145.053.000', 'FR'),
    ('194.145.059.000', 'PT'),
    ('194.145.063.000', 'BG'),
    ('194.145.064.000', 'DE'),
    ('194.145.096.000', 'PL'),
    ('194.145.112.000', 'FR'),
    ('194.145.113.000', 'IT'),
    ('194.145.114.000', 'EU'),
    ('194.145.121.000', 'PT'),
    ('194.145.122.000', 'DE'),
    ('194.145.125.000', 'SE'),
    ('194.145.126.000', 'DE'),
    ('194.145.127.000', 'GR'),
    ('194.145.128.000', 'IE'),
    ('194.145.136.000', 'SK'),
    ('194.145.140.000', 'ES'),
    ('194.145.142.000', 'DE'),
    ('194.145.144.000', 'FR'),
    ('194.145.145.000', 'SE'),
    ('194.145.146.000', 'DE'),
    ('194.145.147.000', 'GB'),
    ('194.145.150.000', 'DE'),
    ('194.145.152.000', 'EU'),
    ('194.145.252.000', 'DE'),
    ('194.146.000.000', 'FR'),
    ('194.146.105.000', 'EU'),
    ('194.147.000.000', 'CH'),
    ('194.147.068.000', 'LI'),
    ('194.147.070.000', 'CH'),
    ('194.148.015.000', 'LI'),
    ('194.148.016.000', 'CH'),
    ('194.148.058.000', 'US'),
    ('194.148.059.000', 'CH'),
    ('194.149.000.000', 'HU'),
    ('194.149.064.000', 'RU'),
    ('194.149.070.000', 'EU'),
    ('194.149.072.000', 'ES'),
    ('194.149.076.000', 'IE'),
    ('194.149.080.000', 'NL'),
    ('194.149.088.000', 'FR'),
    ('194.149.090.000', 'EU'),
    ('194.149.091.000', 'RU'),
    ('194.149.092.000', 'DE'),
    ('194.149.095.000', 'RU'),
    ('194.149.096.000', 'CZ'),
    ('194.149.128.000', 'MK'),
    ('194.149.160.000', 'FR'),
    ('194.149.192.000', 'ES'),
    ('194.149.224.000', 'RU'),
    ('194.149.228.000', 'PL'),
    ('194.149.232.000', 'IT'),
    ('194.149.234.000', 'RU'),
    ('194.149.236.000', 'GR'),
    ('194.149.238.000', 'DK'),
    ('194.149.240.000', 'FR'),
    ('194.149.241.000', 'DE'),
    ('194.149.242.000', 'FR'),
    ('194.149.243.000', 'DE'),
    ('194.149.244.000', 'IT'),
    ('194.149.245.000', 'DE'),
    ('194.150.000.000', 'FR'),
    ('194.150.064.000', 'EU'),
    ('194.151.000.000', 'NL'),
    ('194.152.000.000', 'SI'),
    ('194.152.032.000', 'DE'),
    ('194.152.064.000', 'GB'),
    ('194.152.096.000', 'AT'),
    ('194.152.128.000', 'HU'),
    ('194.152.131.000', 'LY'),
    ('194.152.132.000', 'HU'),
    ('194.152.160.000', 'AT'),
    ('194.152.192.000', 'HR'),
    ('194.153.000.000', 'GB'),
    ('194.153.032.000', 'SE'),
    ('194.153.072.000', 'NO'),
    ('194.153.073.000', 'IT'),
    ('194.153.074.000', 'NL'),
    ('194.153.075.000', 'GB'),
    ('194.153.078.000', 'FR'),
    ('194.153.079.000', 'LV'),
    ('194.153.080.000', 'FR'),
    ('194.153.081.000', 'GR'),
    ('194.153.083.000', 'DE'),
    ('194.153.084.000', 'SE'),
    ('194.153.085.000', 'MT'),
    ('194.153.086.000', 'EU'),
    ('194.153.088.000', 'FR'),
    ('194.153.098.000', 'AT'),
    ('194.153.099.000', 'IT'),
    ('194.153.100.000', 'ES'),
    ('194.153.102.000', 'IT'),
    ('194.153.104.000', 'DE'),
    ('194.153.106.000', 'US'),
    ('194.153.108.000', 'FR'),
    ('194.153.111.000', 'AT'),
    ('194.153.112.000', 'GB'),
    ('194.153.120.000', 'AT'),
    ('194.153.128.000', 'UA'),
    ('194.153.130.000', 'DE'),
    ('194.153.131.000', 'IT'),
    ('194.153.132.000', 'PT'),
    ('194.153.133.000', 'PL'),
    ('194.153.134.000', 'GB'),
    ('194.153.145.000', 'BG'),
    ('194.153.146.000', 'DE'),
    ('194.153.148.000', 'UA'),
    ('194.153.150.000', 'DE'),
    ('194.153.153.000', 'UG'),
    ('194.153.154.000', 'EU'),
    ('194.153.156.000', 'DK'),
    ('194.153.157.000', 'EU'),
    ('194.153.160.000', 'DE'),
    ('194.153.168.000', 'GB'),
    ('194.153.170.000', 'PL'),
    ('194.153.171.000', 'LV'),
    ('194.153.172.000', 'IT'),
    ('194.153.176.000', 'CH'),
    ('194.153.184.000', 'DE'),
    ('194.153.186.000', 'GR'),
    ('194.153.187.000', 'IT'),
    ('194.153.188.000', 'CH'),
    ('194.153.190.000', 'DE'),
    ('194.153.192.000', 'IT'),
    ('194.153.214.000', 'FR'),
    ('194.153.216.000', 'PL'),
    ('194.153.217.000', 'AT'),
    ('194.153.218.000', 'NL'),
    ('194.153.219.000', 'DE'),
    ('194.153.220.000', 'AT'),
    ('194.153.224.000', 'RO'),
    ('194.154.000.000', 'GB'),
    ('194.154.048.000', 'PT'),
    ('194.154.052.000', 'GB'),
    ('194.154.064.000', 'RU'),
    ('194.154.070.000', 'KZ'),
    ('194.154.071.000', 'RU'),
    ('194.154.092.000', 'AZ'),
    ('194.154.093.000', 'UZ'),
    ('194.154.094.000', 'RU'),
    ('194.154.096.000', 'GB'),
    ('194.154.128.000', 'CY'),
    ('194.154.145.000', 'GR'),
    ('194.154.146.000', 'CY'),
    ('194.154.159.000', 'GR'),
    ('194.154.160.000', 'GB'),
    ('194.154.175.000', 'NL'),
    ('194.154.176.000', 'GB'),
    ('194.154.192.000', 'LU'),
    ('194.154.224.000', 'SK'),
    ('194.155.000.000', 'GB'),
    ('194.156.000.000', 'DE'),
    ('194.157.000.000', 'FI'),
    ('194.158.000.000', 'CH'),
    ('194.158.032.000', 'MT'),
    ('194.158.055.000', 'GB'),
    ('194.158.056.000', 'MT'),
    ('194.158.064.000', 'AD'),
    ('194.158.096.000', 'FR'),
    ('194.158.128.000', 'AT'),
    ('194.158.160.000', 'NL'),
    ('194.158.192.000', 'BY'),
    ('194.158.224.000', 'CH'),
    ('194.159.000.000', 'GB'),
    ('194.159.043.000', 'FR'),
    ('194.159.044.000', 'GB'),
    ('194.159.064.000', 'DE'),
    ('194.159.065.000', 'FR'),
    ('194.159.066.000', 'GB'),
    ('194.159.173.000', 'NL'),
    ('194.159.174.000', 'GB'),
    ('194.160.000.000', 'SK'),
    ('194.161.000.000', 'GB'),
    ('194.161.036.000', 'DE'),
    ('194.161.037.000', 'GB'),
    ('194.161.038.000', 'CH'),
    ('194.161.039.000', 'EU'),
    ('194.161.040.000', 'GB'),
    ('194.161.041.000', 'DE'),
    ('194.161.042.000', 'GB'),
    ('194.161.048.000', 'DE'),
    ('194.161.064.000', 'FR'),
    ('194.161.084.000', 'BE'),
    ('194.161.085.000', 'FR'),
    ('194.161.086.000', 'DE'),
    ('194.161.094.000', 'FR'),
    ('194.161.096.000', 'BE'),
    ('194.161.101.000', 'FR'),
    ('194.161.102.000', 'DE'),
    ('194.161.103.000', 'BE'),
    ('194.161.104.000', 'NL'),
    ('194.161.108.000', 'BE'),
    ('194.161.109.000', 'NL'),
    ('194.161.112.000', 'CH'),
    ('194.161.113.000', 'GB'),
    ('194.161.114.000', 'CH'),
    ('194.161.116.000', 'GB'),
    ('194.161.120.000', 'IT'),
    ('194.161.128.000', 'ES'),
    ('194.161.136.000', 'EU'),
    ('194.161.137.000', 'HU'),
    ('194.161.138.000', 'DK'),
    ('194.161.140.000', 'AT'),
    ('194.161.141.000', 'ES'),
    ('194.161.142.000', 'SE'),
    ('194.161.143.000', 'DK'),
    ('194.161.149.000', 'IL'),
    ('194.161.150.000', 'SE'),
    ('194.161.151.000', 'DE'),
    ('194.161.152.000', 'DK'),
    ('194.161.154.000', 'FR'),
    ('194.161.155.000', 'DE'),
    ('194.161.176.000', 'IT'),
    ('194.161.177.000', 'GB'),
    ('194.161.184.000', 'NL'),
    ('194.161.191.000', 'GB'),
    ('194.161.208.000', 'DE'),
    ('194.161.224.000', 'GB'),
    ('194.162.000.000', 'DE'),
    ('194.162.224.000', 'GB'),
    ('194.162.229.000', 'DE'),
    ('194.162.231.000', 'GB'),
    ('194.162.232.000', 'DE'),
    ('194.163.000.000', 'AT'),
    ('194.163.001.000', 'DE'),
    ('194.163.008.000', 'AT'),
    ('194.163.009.000', 'DE'),
    ('194.163.010.000', 'AT'),
    ('194.163.013.000', 'DE'),
    ('194.163.014.000', 'AT'),
    ('194.163.016.000', 'DE'),
    ('194.164.000.000', 'GB'),
    ('194.164.100.000', 'US'),
    ('194.164.101.000', 'GB'),
    ('194.164.162.000', 'AE'),
    ('194.164.164.000', 'GB'),
    ('194.165.000.000', 'IR'),
    ('194.165.033.000', 'CH'),
    ('194.165.064.000', 'NL'),
    ('194.165.096.000', 'SI'),
    ('194.165.128.000', 'JO'),
    ('194.165.160.000', 'IE'),
    ('194.165.192.000', 'GB'),
    ('194.165.213.000', 'US'),
    ('194.165.215.000', 'GB'),
    ('194.165.224.000', 'SE'),
    ('194.166.000.000', 'AT'),
    ('194.167.000.000', 'FR'),
    ('194.168.000.000', 'GB'),
    ('194.168.136.000', 'US'),
    ('194.168.137.000', 'GB'),
    ('194.170.000.000', 'AE'),
    ('194.171.000.000', 'NL'),
    ('194.172.000.000', 'DE'),
    ('194.176.032.000', 'LT'),
    ('194.176.064.000', 'GB'),
    ('194.176.096.000', 'ES'),
    ('194.176.128.000', 'GB'),
    ('194.176.160.000', 'RO'),
    ('194.176.192.000', 'GB'),
    ('194.176.224.000', 'HU'),
    ('194.177.000.000', 'ES'),
    ('194.177.010.000', 'EU'),
    ('194.177.032.000', 'LU'),
    ('194.177.064.000', 'IT'),
    ('194.177.128.000', 'AT'),
    ('194.177.160.000', 'GB'),
    ('194.177.192.000', 'GR'),
    ('194.177.224.000', 'GL'),
    ('194.178.000.000', 'NL'),
    ('194.179.000.000', 'ES'),
    ('194.179.128.000', 'IT'),
    ('194.180.000.000', 'DE'),
    ('194.181.000.000', 'PL'),
    ('194.182.000.000', 'DK'),
    ('194.182.235.000', 'FO'),
    ('194.182.236.000', 'DK'),
    ('194.183.000.000', 'IT'),
    ('194.183.032.000', 'PL'),
    ('194.183.064.000', 'SM'),
    ('194.183.096.000', 'NL'),
    ('194.183.099.000', 'EU'),
    ('194.183.100.000', 'NL'),
    ('194.183.104.000', 'EU'),
    ('194.183.106.000', 'NL'),
    ('194.183.107.000', 'EU'),
    ('194.183.108.000', 'NL'),
    ('194.183.115.000', 'EU'),
    ('194.183.116.000', 'NL'),
    ('194.183.121.000', 'EU'),
    ('194.183.122.000', 'NL'),
    ('194.183.123.000', 'EU'),
    ('194.183.124.000', 'NL'),
    ('194.183.125.000', 'EU'),
    ('194.183.126.000', 'NL'),
    ('194.183.128.000', 'AT'),
    ('194.183.142.000', 'LI'),
    ('194.183.143.000', 'AT'),
    ('194.183.160.000', 'UA'),
    ('194.183.192.000', 'FR'),
    ('194.183.224.000', 'BE'),
    ('194.183.248.000', 'LU'),
    ('194.183.251.000', 'BE'),
    ('194.184.000.000', 'IT'),
    ('194.185.240.000', 'MC'),
    ('194.185.241.000', 'IT'),
    ('194.186.000.000', 'RU'),
    ('194.186.007.000', 'KZ'),
    ('194.186.008.000', 'RU'),
    ('194.186.015.000', 'KZ'),
    ('194.186.016.000', 'RU'),
    ('194.186.096.000', 'UA'),
    ('194.186.100.000', 'RU'),
    ('194.186.101.000', 'UA'),
    ('194.186.102.000', 'RU'),
    ('194.186.116.000', 'UZ'),
    ('194.186.120.000', 'RU'),
    ('194.186.142.000', 'UA'),
    ('194.186.143.000', 'RU'),
    ('194.186.150.000', 'UA'),
    ('194.186.154.000', 'RU'),
    ('194.186.155.000', 'AZ'),
    ('194.186.156.000', 'RU'),
    ('194.186.232.000', 'KZ'),
    ('194.186.239.000', 'RU'),
    ('194.186.242.000', 'KZ'),
    ('194.186.243.000', 'RU'),
    ('194.187.000.000', 'NO'),
    ('194.188.000.000', 'FI'),
    ('194.189.000.000', 'GB'),
    ('194.190.000.000', 'RU'),
    ('194.190.014.000', 'UA'),
    ('194.190.015.000', 'RU'),
    ('194.190.036.000', 'UA'),
    ('194.190.037.000', 'RU'),
    ('194.191.000.000', 'CH'),
    ('194.192.000.000', 'DK'),
    ('194.193.000.000', 'GB'),
    ('194.193.153.000', 'NL'),
    ('194.193.154.000', 'GB'),
    ('194.194.000.000', 'DE'),
    ('194.194.001.000', 'GB'),
    ('194.194.017.000', 'IE'),
    ('194.194.018.000', 'DE'),
    ('194.194.019.000', 'GB'),
    ('194.194.041.000', 'AT'),
    ('194.194.042.000', 'FR'),
    ('194.194.044.000', 'DE'),
    ('194.194.054.000', 'GB'),
    ('194.194.056.000', 'DE'),
    ('194.194.058.000', 'IL'),
    ('194.194.059.000', 'EU'),
    ('194.194.060.000', 'AT'),
    ('194.194.061.000', 'CH'),
    ('194.194.062.000', 'GB'),
    ('194.194.064.000', 'FR'),
    ('194.194.074.000', 'GB'),
    ('194.194.076.000', 'FR'),
    ('194.194.080.000', 'DE'),
    ('194.194.094.000', 'GB'),
    ('194.194.096.000', 'DE'),
    ('194.194.132.000', 'FR'),
    ('194.194.138.000', 'GB'),
    ('194.194.139.000', 'FR'),
    ('194.194.140.000', 'AT'),
    ('194.194.144.000', 'FR'),
    ('194.194.158.000', 'YU'),
    ('194.194.159.000', 'FR'),
    ('194.194.176.000', 'NL'),
    ('194.194.181.000', 'GB'),
    ('194.194.182.000', 'NL'),
    ('194.194.187.000', 'GB'),
    ('194.194.190.000', 'CH'),
    ('194.194.191.000', 'DE'),
    ('194.194.192.000', 'IT'),
    ('194.194.193.000', 'AT'),
    ('194.194.194.000', 'GB'),
    ('194.194.197.000', 'DE'),
    ('194.194.198.000', 'IT'),
    ('194.194.199.000', 'FR'),
    ('194.194.200.000', 'ES'),
    ('194.194.203.000', 'DE'),
    ('194.194.204.000', 'ES'),
    ('194.194.206.000', 'FR'),
    ('194.194.208.000', 'BE'),
    ('194.194.209.000', 'DE'),
    ('194.194.210.000', 'GB'),
    ('194.194.213.000', 'CH'),
    ('194.194.214.000', 'GB'),
    ('194.194.216.000', 'DK'),
    ('194.194.221.000', 'NL'),
    ('194.194.222.000', 'DK'),
    ('194.194.224.000', 'AT'),
    ('194.194.226.000', 'SE'),
    ('194.194.227.000', 'NO'),
    ('194.194.228.000', 'AT'),
    ('194.194.231.000', 'NL'),
    ('194.194.232.000', 'DK'),
    ('194.194.236.000', 'DE'),
    ('194.194.238.000', 'FR'),
    ('194.194.239.000', 'EU'),
    ('194.194.240.000', 'FI'),
    ('194.194.241.000', 'CH'),
    ('194.194.242.000', 'GB'),
    ('194.194.243.000', 'NO'),
    ('194.194.244.000', 'EU'),
    ('194.194.245.000', 'NO'),
    ('194.194.246.000', 'IL'),
    ('194.194.248.000', 'NO'),
    ('194.194.249.000', 'AT'),
    ('194.194.250.000', 'IL'),
    ('194.194.252.000', 'CH'),
    ('194.194.254.000', 'AT'),
    ('194.195.000.000', 'DE'),
    ('194.196.000.000', 'GB'),
    ('194.196.002.000', 'FR'),
    ('194.196.003.000', 'BE'),
    ('194.196.004.000', 'NL'),
    ('194.196.005.000', 'BE'),
    ('194.196.006.000', 'ES'),
    ('194.196.007.000', 'RU'),
    ('194.196.008.000', 'DE'),
    ('194.196.010.000', 'EU'),
    ('194.196.011.000', 'DE'),
    ('194.196.012.000', 'IT'),
    ('194.196.013.000', 'FR'),
    ('194.196.014.000', 'IT'),
    ('194.196.015.000', 'HU'),
    ('194.196.016.000', 'CZ'),
    ('194.196.017.000', 'DK'),
    ('194.196.018.000', 'BE'),
    ('194.196.019.000', 'GR'),
    ('194.196.020.000', 'GB'),
    ('194.196.022.000', 'SK'),
    ('194.196.023.000', 'IT'),
    ('194.196.024.000', 'GB'),
    ('194.196.026.000', 'DE'),
    ('194.196.028.000', 'CY'),
    ('194.196.029.000', 'BE'),
    ('194.196.030.000', 'IT'),
    ('194.196.031.000', 'BE'),
    ('194.196.032.000', 'EU'),
    ('194.196.039.000', 'GB'),
    ('194.196.042.000', 'EU'),
    ('194.196.043.000', 'BE'),
    ('194.196.044.000', 'SK'),
    ('194.196.046.000', 'ZA'),
    ('194.196.047.000', 'AT'),
    ('194.196.048.000', 'EU'),
    ('194.196.049.000', 'IT'),
    ('194.196.050.000', 'ES'),
    ('194.196.052.000', 'BE'),
    ('194.196.053.000', 'DK'),
    ('194.196.054.000', 'CZ'),
    ('194.196.056.000', 'NL'),
    ('194.196.057.000', 'GB'),
    ('194.196.058.000', 'CH'),
    ('194.196.059.000', 'GB'),
    ('194.196.060.000', 'CH'),
    ('194.196.061.000', 'IT'),
    ('194.196.062.000', 'GR'),
    ('194.196.064.000', 'EU'),
    ('194.196.066.000', 'GB'),
    ('194.196.067.000', 'SE'),
    ('194.196.068.000', 'GB'),
    ('194.196.069.000', 'NO'),
    ('194.196.070.000', 'SI'),
    ('194.196.071.000', 'BE'),
    ('194.196.072.000', 'RU'),
    ('194.196.073.000', 'GB'),
    ('194.196.074.000', 'EU'),
    ('194.196.075.000', 'BE'),
    ('194.196.076.000', 'DE'),
    ('194.196.077.000', 'SI'),
    ('194.196.078.000', 'BE'),
    ('194.196.079.000', 'IE'),
    ('194.196.080.000', 'GB'),
    ('194.196.081.000', 'DE'),
    ('194.196.084.000', 'ES'),
    ('194.196.085.000', 'EU'),
    ('194.196.086.000', 'AT'),
    ('194.196.088.000', 'GB'),
    ('194.196.089.000', 'SI'),
    ('194.196.090.000', 'DE'),
    ('194.196.091.000', 'BE'),
    ('194.196.092.000', 'DE'),
    ('194.196.093.000', 'NL'),
    ('194.196.094.000', 'EU'),
    ('194.196.096.000', 'AT'),
    ('194.196.097.000', 'NL'),
    ('194.196.099.000', 'AT'),
    ('194.196.100.000', 'GB'),
    ('194.196.102.000', 'DE'),
    ('194.196.104.000', 'FR'),
    ('194.196.105.000', 'EU'),
    ('194.196.106.000', 'GB'),
    ('194.196.107.000', 'GR'),
    ('194.196.108.000', 'DE'),
    ('194.196.109.000', 'PT'),
    ('194.196.110.000', 'GB'),
    ('194.196.111.000', 'EU'),
    ('194.196.113.000', 'GB'),
    ('194.196.114.000', 'EU'),
    ('194.196.116.000', 'DE'),
    ('194.196.117.000', 'SK'),
    ('194.196.118.000', 'GB'),
    ('194.196.120.000', 'IT'),
    ('194.196.122.000', 'DK'),
    ('194.196.123.000', 'CZ'),
    ('194.196.125.000', 'EU'),
    ('194.196.126.000', 'HU'),
    ('194.196.127.000', 'EU'),
    ('194.196.128.000', 'SI'),
    ('194.196.129.000', 'GB'),
    ('194.196.130.000', 'IT'),
    ('194.196.131.000', 'BE'),
    ('194.196.132.000', 'CH'),
    ('194.196.134.000', 'EU'),
    ('194.196.135.000', 'IT'),
    ('194.196.136.000', 'EU'),
    ('194.196.138.000', 'CH'),
    ('194.196.139.000', 'ES'),
    ('194.196.140.000', 'SK'),
    ('194.196.143.000', 'GB'),
    ('194.196.144.000', 'EU'),
    ('194.196.145.000', 'CZ'),
    ('194.196.146.000', 'EU'),
    ('194.196.148.000', 'IE'),
    ('194.196.149.000', 'IT'),
    ('194.196.150.000', 'EU'),
    ('194.196.152.000', 'DE'),
    ('194.196.153.000', 'CZ'),
    ('194.196.154.000', 'GB'),
    ('194.196.155.000', 'SK'),
    ('194.196.156.000', 'EU'),
    ('194.196.160.000', 'GB'),
    ('194.196.161.000', 'GR'),
    ('194.196.162.000', 'GB'),
    ('194.196.165.000', 'NL'),
    ('194.196.166.000', 'GB'),
    ('194.196.168.000', 'EU'),
    ('194.196.176.000', 'ZA'),
    ('194.196.182.000', 'DE'),
    ('194.196.183.000', 'NO'),
    ('194.196.184.000', 'DE'),
    ('194.196.185.000', 'EU'),
    ('194.196.186.000', 'AT'),
    ('194.196.187.000', 'FR'),
    ('194.196.188.000', 'DE'),
    ('194.196.191.000', 'EU'),
    ('194.196.196.000', 'AT'),
    ('194.196.197.000', 'CH'),
    ('194.196.199.000', 'EU'),
    ('194.196.200.000', 'GB'),
    ('194.196.201.000', 'EU'),
    ('194.196.202.000', 'HU'),
    ('194.196.203.000', 'GB'),
    ('194.196.206.000', 'EU'),
    ('194.196.208.000', 'FR'),
    ('194.196.210.000', 'NL'),
    ('194.196.212.000', 'EU'),
    ('194.196.213.000', 'BE'),
    ('194.196.214.000', 'EU'),
    ('194.196.215.000', 'CZ'),
    ('194.196.216.000', 'SK'),
    ('194.196.218.000', 'EU'),
    ('194.196.220.000', 'FR'),
    ('194.196.221.000', 'ZA'),
    ('194.196.222.000', 'FR'),
    ('194.196.223.000', 'EU'),
    ('194.196.224.000', 'BE'),
    ('194.196.225.000', 'EU'),
    ('194.196.226.000', 'ES'),
    ('194.196.227.000', 'HU'),
    ('194.196.228.000', 'PL'),
    ('194.196.229.000', 'EU'),
    ('194.196.234.000', 'GB'),
    ('194.196.235.000', 'DE'),
    ('194.196.236.000', 'NL'),
    ('194.196.238.000', 'CH'),
    ('194.196.240.000', 'EU'),
    ('194.196.246.000', 'IE'),
    ('194.196.247.000', 'DE'),
    ('194.196.249.000', 'SE'),
    ('194.196.250.000', 'EU'),
    ('194.196.251.000', 'CZ'),
    ('194.196.252.000', 'EU'),
    ('194.196.253.000', 'GB'),
    ('194.196.254.000', 'FR'),
    ('194.197.000.000', 'FI'),
    ('194.197.004.000', 'SE'),
    ('194.197.008.000', 'FI'),
    ('194.197.061.000', 'BE'),
    ('194.197.062.000', 'FI'),
    ('194.197.084.000', 'SE'),
    ('194.197.085.000', 'FI'),
    ('194.197.199.000', 'BE'),
    ('194.197.200.000', 'FI'),
    ('194.197.209.000', 'DE'),
    ('194.197.210.000', 'BE'),
    ('194.197.211.000', 'FI'),
    ('194.197.218.000', 'NL'),
    ('194.197.219.000', 'FI'),
    ('194.198.000.000', 'SE'),
    ('194.198.018.000', 'NO'),
    ('194.198.024.000', 'SE'),
    ('194.198.030.000', 'NO'),
    ('194.198.031.000', 'SE'),
    ('194.198.032.000', 'NO'),
    ('194.198.033.000', 'SE'),
    ('194.198.038.000', 'NO'),
    ('194.198.041.000', 'SE'),
    ('194.198.042.000', 'NO'),
    ('194.198.043.000', 'SE'),
    ('194.198.116.000', 'NO'),
    ('194.198.117.000', 'SE'),
    ('194.198.118.000', 'NO'),
    ('194.198.119.000', 'SE'),
    ('194.198.121.000', 'NO'),
    ('194.198.122.000', 'SE'),
    ('194.198.123.000', 'NO'),
    ('194.198.124.000', 'SE'),
    ('194.198.125.000', 'NO'),
    ('194.198.126.000', 'SE'),
    ('194.198.148.000', 'DK'),
    ('194.198.149.000', 'SE'),
    ('194.199.000.000', 'FR'),
    ('194.200.000.000', 'GB'),
    ('194.201.253.000', 'KE'),
    ('194.201.254.000', 'GB'),
    ('194.204.000.000', 'EE'),
    ('194.204.064.000', 'CH'),
    ('194.204.096.000', 'MT'),
    ('194.204.128.000', 'PL'),
    ('194.204.192.000', 'MA'),
    ('194.205.000.000', 'GB'),
    ('194.205.022.000', 'NL'),
    ('194.205.023.000', 'GB'),
    ('194.206.000.000', 'FR'),
    ('194.206.073.000', 'CF'),
    ('194.206.074.000', 'FR'),
    ('194.206.216.000', 'CH'),
    ('194.206.217.000', 'FR'),
    ('194.207.000.000', 'GB'),
    ('194.208.000.000', 'AT'),
    ('194.208.053.000', 'CH'),
    ('194.208.054.000', 'AT'),
    ('194.208.055.000', 'LI'),
    ('194.208.057.000', 'AT'),
    ('194.208.060.000', 'CH'),
    ('194.208.065.000', 'AT'),
    ('194.208.066.000', 'CH'),
    ('194.208.067.000', 'AT'),
    ('194.208.069.000', 'LI'),
    ('194.208.070.000', 'AT'),
    ('194.208.076.000', 'LI'),
    ('194.208.077.000', 'AT'),
    ('194.209.000.000', 'CH'),
    ('194.210.000.000', 'PT'),
    ('194.211.000.000', 'FI'),
    ('194.212.000.000', 'CZ'),
    ('194.213.000.000', 'EU'),
    ('194.213.032.000', 'CZ'),
    ('194.213.064.000', 'SE'),
    ('194.213.096.000', 'IT'),
    ('194.213.128.000', 'NO'),
    ('194.213.192.000', 'CZ'),
    ('194.214.000.000', 'FR'),
    ('194.214.107.000', 'MG'),
    ('194.214.108.000', 'FR'),
    ('194.214.253.000', 'PF'),
    ('194.215.000.000', 'FI'),
    ('194.215.043.000', 'SE'),
    ('194.215.044.000', 'FI'),
    ('194.215.046.000', 'SE'),
    ('194.215.047.000', 'FI'),
    ('194.215.174.000', 'NL'),
    ('194.215.175.000', 'FI'),
    ('194.215.180.000', 'GB'),
    ('194.215.181.000', 'FI'),
    ('194.215.197.000', 'SE'),
    ('194.215.198.000', 'FI'),
    ('194.215.243.000', 'RU'),
    ('194.215.244.000', 'FI'),
    ('194.216.000.000', 'GB'),
    ('194.218.000.000', 'SE'),
    ('194.218.038.000', 'DE'),
    ('194.218.039.000', 'SE'),
    ('194.218.231.000', 'US'),
    ('194.218.232.000', 'SE'),
    ('194.219.000.000', 'GR'),
    ('194.220.000.000', 'RU'),
    ('194.220.007.000', 'KZ'),
    ('194.220.008.000', 'RU'),
    ('194.220.011.000', 'UA'),
    ('194.220.012.000', 'RU'),
    ('194.220.017.000', 'UA'),
    ('194.220.018.000', 'RU'),
    ('194.220.045.000', 'UA'),
    ('194.220.046.000', 'RU'),
    ('194.220.058.000', 'UA'),
    ('194.220.060.000', 'RU'),
    ('194.220.133.000', 'UA'),
    ('194.220.134.000', 'RU'),
    ('194.220.139.000', 'UA'),
    ('194.220.140.000', 'RU'),
    ('194.220.161.000', 'UA'),
    ('194.220.162.000', 'RU'),
    ('194.220.172.000', 'UA'),
    ('194.220.173.000', 'RU'),
    ('194.221.000.000', 'DE'),
    ('194.222.000.000', 'GB'),
    ('194.224.000.000', 'ES'),
    ('194.225.000.000', 'IR'),
    ('194.226.000.000', 'RU'),
    ('194.226.120.000', 'BY'),
    ('194.226.127.000', 'RU'),
    ('194.226.128.000', 'KZ'),
    ('194.226.132.000', 'RU'),
    ('194.226.133.000', 'KZ'),
    ('194.226.137.000', 'RU'),
    ('194.226.138.000', 'KZ'),
    ('194.226.144.000', 'RU'),
    ('194.227.000.000', 'GB'),
    ('194.228.000.000', 'CZ'),
    ('194.228.038.000', 'CR'),
    ('194.228.039.000', 'CZ'),
    ('194.229.000.000', 'NL'),
    ('194.230.000.000', 'CH'),
    ('194.231.000.000', 'DE'),
    ('194.232.000.000', 'AT'),
    ('194.233.000.000', 'DE'),
    ('194.234.000.000', 'EU'),
    ('194.234.012.000', 'DK'),
    ('194.234.021.000', 'EU'),
    ('194.234.027.000', 'DK'),
    ('194.234.028.000', 'EU'),
    ('194.234.033.000', 'DK'),
    ('194.234.034.000', 'EU'),
    ('194.234.036.000', 'DK'),
    ('194.234.037.000', 'EU'),
    ('194.234.038.000', 'DK'),
    ('194.234.040.000', 'EU'),
    ('194.234.042.000', 'DK'),
    ('194.234.043.000', 'EU'),
    ('194.234.057.000', 'DK'),
    ('194.234.059.000', 'EU'),
    ('194.234.065.000', 'NO'),
    ('194.234.066.000', 'EU'),
    ('194.234.067.000', 'NO'),
    ('194.234.068.000', 'EU'),
    ('194.234.069.000', 'NO'),
    ('194.234.070.000', 'EU'),
    ('194.234.086.000', 'NO'),
    ('194.234.089.000', 'EU'),
    ('194.234.100.000', 'NO'),
    ('194.234.102.000', 'EU'),
    ('194.234.103.000', 'NO'),
    ('194.234.104.000', 'EU'),
    ('194.234.105.000', 'NO'),
    ('194.234.106.000', 'EU'),
    ('194.234.112.000', 'NO'),
    ('194.234.115.000', 'EU'),
    ('194.234.123.000', 'NO'),
    ('194.234.125.000', 'EU'),
    ('194.234.126.000', 'NO'),
    ('194.234.128.000', 'FI'),
    ('194.234.141.000', 'EU'),
    ('194.234.143.000', 'FI'),
    ('194.234.154.000', 'EU'),
    ('194.234.155.000', 'FI'),
    ('194.234.158.000', 'EU'),
    ('194.234.160.000', 'DK'),
    ('194.234.162.000', 'EU'),
    ('194.234.170.000', 'DK'),
    ('194.234.172.000', 'EU'),
    ('194.234.173.000', 'DK'),
    ('194.234.175.000', 'EU'),
    ('194.234.178.000', 'DK'),
    ('194.234.179.000', 'EU'),
    ('194.234.194.000', 'NO'),
    ('194.234.195.000', 'EU'),
    ('194.234.200.000', 'NO'),
    ('194.234.205.000', 'EU'),
    ('194.234.210.000', 'NO'),
    ('194.234.211.000', 'EU'),
    ('194.234.214.000', 'NO'),
    ('194.234.216.000', 'EU'),
    ('194.234.226.000', 'NO'),
    ('194.234.229.000', 'EU'),
    ('194.234.232.000', 'NO'),
    ('194.234.234.000', 'EU'),
    ('194.234.236.000', 'NO'),
    ('194.234.237.000', 'EU'),
    ('194.234.240.000', 'NO'),
    ('194.234.241.000', 'EU'),
    ('194.234.255.000', 'NO'),
    ('194.235.000.000', 'EU'),
    ('194.235.001.000', 'CH'),
    ('194.235.004.000', 'EU'),
    ('194.235.005.000', 'CH'),
    ('194.235.011.000', 'EU'),
    ('194.235.029.000', 'CH'),
    ('194.235.031.000', 'EU'),
    ('194.235.032.000', 'BE'),
    ('194.235.036.000', 'IT'),
    ('194.235.038.000', 'CH'),
    ('194.235.041.000', 'EU'),
    ('194.235.042.000', 'CH'),
    ('194.235.044.000', 'EU'),
    ('194.235.045.000', 'CH'),
    ('194.235.051.000', 'EU'),
    ('194.235.052.000', 'CH'),
    ('194.235.053.000', 'EU'),
    ('194.235.054.000', 'CH'),
    ('194.235.055.000', 'EU'),
    ('194.235.057.000', 'CH'),
    ('194.235.059.000', 'EU'),
    ('194.235.060.000', 'CH'),
    ('194.235.064.000', 'EU'),
    ('194.235.069.000', 'NL'),
    ('194.235.071.000', 'EU'),
    ('194.235.074.000', 'NL'),
    ('194.235.079.000', 'EU'),
    ('194.235.080.000', 'NL'),
    ('194.235.081.000', 'EU'),
    ('194.235.085.000', 'NL'),
    ('194.235.087.000', 'EU'),
    ('194.235.092.000', 'NL'),
    ('194.235.097.000', 'EU'),
    ('194.235.098.000', 'ES'),
    ('194.235.099.000', 'EU'),
    ('194.235.102.000', 'ES'),
    ('194.235.103.000', 'CH'),
    ('194.235.104.000', 'IT'),
    ('194.235.106.000', 'CH'),
    ('194.235.107.000', 'EU'),
    ('194.235.109.000', 'RO'),
    ('194.235.110.000', 'NL'),
    ('194.235.111.000', 'EU'),
    ('194.235.116.000', 'NL'),
    ('194.235.118.000', 'EU'),
    ('194.235.119.000', 'NL'),
    ('194.235.120.000', 'EU'),
    ('194.235.123.000', 'NL'),
    ('194.235.128.000', 'EU'),
    ('194.235.129.000', 'PT'),
    ('194.235.135.000', 'EU'),
    ('194.235.136.000', 'PT'),
    ('194.235.140.000', 'IT'),
    ('194.235.141.000', 'EU'),
    ('194.235.143.000', 'CH'),
    ('194.235.152.000', 'EU'),
    ('194.235.161.000', 'IT'),
    ('194.235.168.000', 'EU'),
    ('194.235.171.000', 'CH'),
    ('194.235.172.000', 'EU'),
    ('194.235.174.000', 'CH'),
    ('194.235.175.000', 'EU'),
    ('194.235.192.000', 'LU'),
    ('194.235.195.000', 'EU'),
    ('194.235.197.000', 'LU'),
    ('194.235.203.000', 'EU'),
    ('194.235.208.000', 'LU'),
    ('194.235.209.000', 'NL'),
    ('194.235.227.000', 'CH'),
    ('194.235.231.000', 'NL'),
    ('194.235.232.000', 'EU'),
    ('194.235.234.000', 'NL'),
    ('194.235.235.000', 'EU'),
    ('194.235.236.000', 'NL'),
    ('194.235.237.000', 'RO'),
    ('194.235.241.000', 'EU'),
    ('194.235.242.000', 'AT'),
    ('194.235.243.000', 'EU'),
    ('194.235.244.000', 'RO'),
    ('194.235.246.000', 'NL'),
    ('194.235.248.000', 'CH'),
    ('194.235.254.000', 'RO'),
    ('194.235.255.000', 'CH'),
    ('194.236.000.000', 'SE'),
    ('194.236.177.000', 'GB'),
    ('194.236.178.000', 'SE'),
    ('194.237.204.000', 'GB'),
    ('194.237.206.000', 'SE'),
    ('194.237.210.000', 'GB'),
    ('194.237.212.000', 'SE'),
    ('194.237.214.000', 'DK'),
    ('194.237.216.000', 'SE'),
    ('194.238.000.000', 'GB'),
    ('194.239.000.000', 'DK'),
    ('194.240.000.000', 'FI'),
    ('194.242.000.000', 'IT'),
    ('194.242.032.000', 'TR'),
    ('194.242.033.000', 'RU'),
    ('194.242.034.000', 'CH'),
    ('194.242.035.000', 'AT'),
    ('194.242.036.000', 'SI'),
    ('194.242.037.000', 'AT'),
    ('194.242.038.000', 'DK'),
    ('194.242.039.000', 'PL'),
    ('194.242.040.000', 'DK'),
    ('194.242.041.000', 'AT'),
    ('194.242.042.000', 'DK'),
    ('194.242.043.000', 'FR'),
    ('194.242.045.000', 'DE'),
    ('194.242.047.000', 'FR'),
    ('194.242.048.000', 'IT'),
    ('194.242.050.000', 'DK'),
    ('194.242.051.000', 'CH'),
    ('194.242.052.000', 'PL'),
    ('194.242.053.000', 'UA'),
    ('194.242.054.000', 'NL'),
    ('194.242.055.000', 'EU'),
    ('194.242.056.000', 'ES'),
    ('194.242.057.000', 'GB'),
    ('194.242.058.000', 'BE'),
    ('194.242.059.000', 'UA'),
    ('194.242.061.000', 'IT'),
    ('194.242.062.000', 'PL'),
    ('194.242.063.000', 'CH'),
    ('194.242.064.000', 'NL'),
    ('194.242.096.000', 'EU'),
    ('194.242.128.000', 'GB'),
    ('194.242.160.000', 'FR'),
    ('194.242.192.000', 'IT'),
    ('194.244.008.000', 'GR'),
    ('194.244.009.000', 'IT'),
    ('194.244.017.000', 'EU'),
    ('194.244.018.000', 'IT'),
    ('194.245.000.000', 'DE'),
    ('194.247.000.000', 'IT'),
    ('194.247.032.000', 'GB'),
    ('194.247.096.000', 'NL'),
    ('194.247.128.000', 'RU'),
    ('194.247.160.000', 'IT'),
    ('194.247.192.000', 'YU'),
    ('194.247.215.000', 'CY'),
    ('194.247.216.000', 'YU'),
    ('194.247.224.000', 'GB'),
    ('194.248.000.000', 'NO'),
    ('194.249.000.000', 'SI'),
    ('194.250.000.000', 'FR'),
    ('194.251.000.000', 'FI'),
    ('194.251.080.000', 'SE'),
    ('194.251.081.000', 'FI'),
    ('194.251.082.000', 'SE'),
    ('194.251.083.000', 'FI'),
    ('194.251.155.000', 'NL'),
    ('194.251.156.000', 'FI'),
    ('194.251.170.000', 'SE'),
    ('194.251.171.000', 'FI'),
    ('194.251.239.000', 'BE'),
    ('194.251.240.000', 'FI'),
    ('194.252.040.000', 'EE'),
    ('194.252.041.000', 'FI'),
    ('194.252.059.000', 'DE'),
    ('194.252.060.000', 'FI'),
    ('194.253.000.000', 'GB'),
    ('194.253.021.000', 'DE'),
    ('194.253.022.000', 'GB'),
    ('194.253.023.000', 'NL'),
    ('194.253.024.000', 'GB'),
    ('194.253.042.000', 'IE'),
    ('194.253.043.000', 'ZA'),
    ('194.253.044.000', 'GB'),
    ('194.253.045.000', 'BE'),
    ('194.253.046.000', 'FR'),
    ('194.253.048.000', 'SE'),
    ('194.253.049.000', 'BE'),
    ('194.253.050.000', 'GB'),
    ('194.253.051.000', 'FR'),
    ('194.253.052.000', 'DE'),
    ('194.253.053.000', 'BE'),
    ('194.253.054.000', 'DE'),
    ('194.253.056.000', 'GB'),
    ('194.253.058.000', 'CH'),
    ('194.253.060.000', 'BE'),
    ('194.253.062.000', 'GB'),
    ('194.253.063.000', 'AT'),
    ('194.253.064.000', 'ES'),
    ('194.253.066.000', 'NL'),
    ('194.253.068.000', 'BE'),
    ('194.253.071.000', 'SE'),
    ('194.253.072.000', 'GB'),
    ('194.253.080.000', 'BE'),
    ('194.253.081.000', 'NO'),
    ('194.253.082.000', 'SE'),
    ('194.253.083.000', 'IT'),
    ('194.253.086.000', 'IL'),
    ('194.253.088.000', 'CH'),
    ('194.253.089.000', 'BE'),
    ('194.253.090.000', 'CH'),
    ('194.253.093.000', 'BE'),
    ('194.253.094.000', 'GB'),
    ('194.253.095.000', 'BE'),
    ('194.253.096.000', 'DE'),
    ('194.253.120.000', 'NL'),
    ('194.253.122.000', 'NO'),
    ('194.253.123.000', 'DE'),
    ('194.253.124.000', 'FR'),
    ('194.253.125.000', 'BE'),
    ('194.253.126.000', 'FR'),
    ('194.253.128.000', 'AT'),
    ('194.253.130.000', 'DK'),
    ('194.253.131.000', 'DE'),
    ('194.253.132.000', 'BE'),
    ('194.253.133.000', 'GB'),
    ('194.253.134.000', 'DE'),
    ('194.253.135.000', 'GB'),
    ('194.253.136.000', 'IT'),
    ('194.253.142.000', 'GB'),
    ('194.253.143.000', 'NL'),
    ('194.253.144.000', 'CH'),
    ('194.253.146.000', 'FR'),
    ('194.253.147.000', 'NL'),
    ('194.253.148.000', 'DE'),
    ('194.253.150.000', 'GB'),
    ('194.253.151.000', 'BE'),
    ('194.253.158.000', 'CH'),
    ('194.253.159.000', 'DE'),
    ('194.253.160.000', 'DK'),
    ('194.253.167.000', 'DE'),
    ('194.253.168.000', 'NL'),
    ('194.253.169.000', 'ZA'),
    ('194.253.170.000', 'NL'),
    ('194.253.175.000', 'FR'),
    ('194.253.176.000', 'ES'),
    ('194.253.177.000', 'AT'),
    ('194.253.178.000', 'ZA'),
    ('194.253.179.000', 'RO'),
    ('194.253.180.000', 'GB'),
    ('194.253.181.000', 'AT'),
    ('194.253.186.000', 'DE'),
    ('194.253.187.000', 'FR'),
    ('194.253.188.000', 'BE'),
    ('194.253.189.000', 'ES'),
    ('194.253.190.000', 'IT'),
    ('194.253.191.000', 'GB'),
    ('194.253.192.000', 'BE'),
    ('194.253.224.000', 'FR'),
    ('194.253.250.000', 'GB'),
    ('194.253.252.000', 'DE'),
    ('194.253.253.000', 'DK'),
    ('194.253.254.000', 'DE'),
    ('194.254.000.000', 'PF'),
    ('194.254.001.000', 'FR'),
    ('194.255.000.000', 'DK'),
    ('194.255.007.000', 'SE'),
    ('194.255.008.000', 'DE'),
    ('194.255.011.000', 'DK'),
    ('194.255.127.000', 'SE'),
    ('194.255.128.000', 'DK'),
    ('194.255.236.000', 'SE'),
    ('195.000.000.000', 'BE'),
    ('195.000.128.000', 'NO'),
    ('195.000.170.000', 'SI'),
    ('195.000.171.000', 'NO'),
    ('195.000.211.000', 'SE'),
    ('195.000.212.000', 'NO'),
    ('195.001.000.000', 'GB'),
    ('195.001.001.000', 'NO'),
    ('195.002.000.000', 'AT'),
    ('195.002.032.000', 'DE'),
    ('195.002.040.000', 'EU'),
    ('195.002.064.000', 'RU'),
    ('195.002.096.000', 'LV'),
    ('195.002.128.000', 'GB'),
    ('195.002.160.000', 'DE'),
    ('195.002.192.000', 'CH'),
    ('195.002.224.000', 'DE'),
    ('195.003.000.000', 'FR'),
    ('195.003.064.000', 'AT'),
    ('195.003.128.000', 'IL'),
    ('195.004.000.000', 'DE'),
    ('195.005.000.000', 'UA'),
    ('195.005.064.000', 'ES'),
    ('195.005.096.000', 'BE'),
    ('195.005.128.000', 'RU'),
    ('195.005.160.000', 'FR'),
    ('195.007.000.000', 'RO'),
    ('195.007.016.000', 'IT'),
    ('195.007.020.000', 'DK'),
    ('195.007.032.000', 'IE'),
    ('195.007.064.000', 'SE'),
    ('195.007.096.000', 'FR'),
    ('195.007.128.000', 'NL'),
    ('195.007.160.000', 'RU'),
    ('195.007.192.000', 'NL'),
    ('195.007.224.000', 'GB'),
    ('195.008.000.000', 'PT'),
    ('195.008.001.000', 'MZ'),
    ('195.008.002.000', 'CV'),
    ('195.008.004.000', 'MZ'),
    ('195.008.008.000', 'ST'),
    ('195.008.009.000', 'MZ'),
    ('195.008.010.000', 'PT'),
    ('195.008.012.000', 'ST'),
    ('195.008.013.000', 'CV'),
    ('195.008.014.000', 'GW'),
    ('195.008.016.000', 'AO'),
    ('195.008.018.000', 'PT'),
    ('195.008.032.000', 'HU'),
    ('195.008.064.000', 'GB'),
    ('195.008.128.000', 'PL'),
    ('195.008.160.000', 'GB'),
    ('195.008.192.000', 'IL'),
    ('195.008.224.000', 'DE'),
    ('195.009.000.000', 'RU'),
    ('195.009.051.000', 'KZ'),
    ('195.009.052.000', 'RU'),
    ('195.009.055.000', 'KZ'),
    ('195.009.056.000', 'RU'),
    ('195.009.087.000', 'UA'),
    ('195.009.088.000', 'RU'),
    ('195.009.191.000', 'KZ'),
    ('195.009.192.000', 'RU'),
    ('195.009.205.000', 'KZ'),
    ('195.009.206.000', 'RU'),
    ('195.009.247.000', 'UA'),
    ('195.009.248.000', 'RU'),
    ('195.010.000.000', 'EU'),
    ('195.010.001.000', 'BE'),
    ('195.010.004.000', 'EU'),
    ('195.010.009.000', 'IT'),
    ('195.010.010.000', 'EU'),
    ('195.010.013.000', 'NL'),
    ('195.010.014.000', 'EU'),
    ('195.010.064.000', 'LU'),
    ('195.010.096.000', 'GB'),
    ('195.010.128.000', 'FI'),
    ('195.010.192.000', 'DE'),
    ('195.010.224.000', 'GB'),
    ('195.012.032.000', 'RU'),
    ('195.012.096.000', 'KZ'),
    ('195.012.128.000', 'SK'),
    ('195.012.160.000', 'LT'),
    ('195.012.192.000', 'AT'),
    ('195.012.224.000', 'GB'),
    ('195.013.000.000', 'BE'),
    ('195.013.032.000', 'FR'),
    ('195.013.038.000', 'PL'),
    ('195.013.040.000', 'UA'),
    ('195.013.044.000', 'DE'),
    ('195.013.046.000', 'PL'),
    ('195.013.047.000', 'UA'),
    ('195.013.048.000', 'EU'),
    ('195.013.064.000', 'GB'),
    ('195.013.128.000', 'LV'),
    ('195.014.000.000', 'GB'),
    ('195.014.032.000', 'RU'),
    ('195.014.064.000', 'GB'),
    ('195.014.096.000', 'IT'),
    ('195.014.128.000', 'CY'),
    ('195.014.153.000', 'LB'),
    ('195.014.156.000', 'CY'),
    ('195.014.160.000', 'LT'),
    ('195.014.192.000', 'DE'),
    ('195.015.000.000', 'CH'),
    ('195.016.000.000', 'BE'),
    ('195.016.032.000', 'RU'),
    ('195.016.064.000', 'GB'),
    ('195.016.096.000', 'RU'),
    ('195.016.128.000', 'ES'),
    ('195.016.160.000', 'GB'),
    ('195.016.178.000', 'US'),
    ('195.016.179.000', 'GB'),
    ('195.016.181.000', 'FR'),
    ('195.016.184.000', 'GB'),
    ('195.016.185.000', 'CH'),
    ('195.016.186.000', 'ES'),
    ('195.016.192.000', 'FI'),
    ('195.016.224.000', 'AT'),
    ('195.017.000.000', 'SE'),
    ('195.017.129.000', 'IE'),
    ('195.017.140.000', 'SE'),
    ('195.017.141.000', 'IE'),
    ('195.017.142.000', 'SE'),
    ('195.017.160.000', 'GB'),
    ('195.017.161.000', 'SE'),
    ('195.017.162.000', 'GB'),
    ('195.017.163.000', 'SE'),
    ('195.017.164.000', 'GB'),
    ('195.017.167.000', 'SE'),
    ('195.017.169.000', 'GB'),
    ('195.017.170.000', 'SE'),
    ('195.018.000.000', 'IT'),
    ('195.018.032.000', 'RU'),
    ('195.018.064.000', 'NL'),
    ('195.018.128.000', 'NO'),
    ('195.018.170.000', 'SE'),
    ('195.018.175.000', 'NO'),
    ('195.019.000.000', 'RU'),
    ('195.020.000.000', 'GB'),
    ('195.020.032.000', 'NL'),
    ('195.020.064.000', 'DE'),
    ('195.020.096.000', 'EU'),
    ('195.020.128.000', 'UA'),
    ('195.020.160.000', 'SK'),
    ('195.020.168.000', 'NL'),
    ('195.020.170.000', 'SK'),
    ('195.020.172.000', 'CZ'),
    ('195.020.174.000', 'SK'),
    ('195.020.192.000', 'DE'),
    ('195.022.000.000', 'PT'),
    ('195.022.032.000', 'CZ'),
    ('195.022.064.000', 'SE'),
    ('195.022.096.000', 'IT'),
    ('195.022.128.000', 'EU'),
    ('195.022.160.000', 'LT'),
    ('195.022.192.000', 'IT'),
    ('195.022.193.000', 'CU'),
    ('195.022.194.000', 'IT'),
    ('195.022.198.000', 'SY'),
    ('195.022.199.000', 'AL'),
    ('195.022.200.000', 'LB'),
    ('195.022.204.000', 'IT'),
    ('195.022.206.000', 'AL'),
    ('195.022.208.000', 'IT'),
    ('195.022.224.000', 'MD'),
    ('195.023.000.000', 'PT'),
    ('195.024.000.000', 'DK'),
    ('195.024.032.000', 'BG'),
    ('195.024.064.000', 'CH'),
    ('195.024.096.000', 'DE'),
    ('195.024.128.000', 'UA'),
    ('195.024.160.000', 'SE'),
    ('195.024.192.000', 'CM'),
    ('195.024.224.000', 'RU'),
    ('195.025.000.000', 'FR'),
    ('195.026.000.000', 'EU'),
    ('195.026.032.000', 'GB'),
    ('195.026.064.000', 'BE'),
    ('195.026.096.000', 'GB'),
    ('195.026.128.000', 'MK'),
    ('195.026.160.000', 'RU'),
    ('195.026.192.000', 'AT'),
    ('195.026.224.000', 'GB'),
    ('195.027.000.000', 'DE'),
    ('195.027.023.000', 'GB'),
    ('195.027.026.000', 'DE'),
    ('195.027.134.000', 'GB'),
    ('195.027.139.000', 'DE'),
    ('195.028.032.000', 'RU'),
    ('195.028.064.000', 'SK'),
    ('195.028.160.000', 'GB'),
    ('195.028.192.000', 'FR'),
    ('195.028.224.000', 'CH'),
    ('195.029.000.000', 'HR'),
    ('195.030.000.000', 'DE'),
    ('195.030.204.000', 'FR'),
    ('195.030.205.000', 'GB'),
    ('195.030.206.000', 'FR'),
    ('195.030.208.000', 'GB'),
    ('195.030.209.000', 'DE'),
    ('195.031.000.000', 'IT'),
    ('195.032.128.000', 'DE'),
    ('195.033.000.000', 'GB'),
    ('195.033.004.000', 'NL'),
    ('195.033.064.000', 'FR'),
    ('195.033.065.000', 'NL'),
    ('195.033.092.000', 'JO'),
    ('195.033.093.000', 'NL'),
    ('195.033.096.000', 'GB'),
    ('195.033.097.000', 'NL'),
    ('195.033.098.000', 'GB'),
    ('195.033.100.000', 'NL'),
    ('195.033.192.000', 'TR'),
    ('195.034.000.000', 'RU'),
    ('195.034.064.000', 'GB'),
    ('195.034.096.000', 'BG'),
    ('195.034.128.000', 'AT'),
    ('195.034.160.000', 'DE'),
    ('195.034.192.000', 'GB'),
    ('195.034.224.000', 'RU'),
    ('195.035.000.000', 'DE'),
    ('195.035.064.000', 'BE'),
    ('195.035.065.000', 'UA'),
    ('195.035.066.000', 'PT'),
    ('195.035.067.000', 'GB'),
    ('195.035.068.000', 'RU'),
    ('195.035.072.000', 'DE'),
    ('195.035.080.000', 'PL'),
    ('195.035.081.000', 'LU'),
    ('195.035.082.000', 'SE'),
    ('195.035.084.000', 'UA'),
    ('195.035.086.000', 'SE'),
    ('195.035.087.000', 'DE'),
    ('195.035.090.000', 'GB'),
    ('195.035.092.000', 'GR'),
    ('195.035.096.000', 'PT'),
    ('195.035.097.000', 'SE'),
    ('195.035.098.000', 'DE'),
    ('195.035.099.000', 'IT'),
    ('195.035.100.000', 'CH'),
    ('195.035.105.000', 'GR'),
    ('195.035.106.000', 'FR'),
    ('195.035.107.000', 'LV'),
    ('195.035.108.000', 'DE'),
    ('195.035.110.000', 'BE'),
    ('195.035.112.000', 'CH'),
    ('195.035.114.000', 'LV'),
    ('195.035.116.000', 'RU'),
    ('195.035.118.000', 'RO'),
    ('195.035.119.000', 'CH'),
    ('195.035.120.000', 'GB'),
    ('195.035.121.000', 'CH'),
    ('195.035.122.000', 'SI'),
    ('195.035.123.000', 'GB'),
    ('195.035.126.000', 'GR'),
    ('195.035.127.000', 'DE'),
    ('195.035.128.000', 'NL'),
    ('195.036.000.000', 'IT'),
    ('195.036.064.000', 'DE'),
    ('195.036.128.000', 'FR'),
    ('195.037.000.000', 'DE'),
    ('195.038.000.000', 'SE'),
    ('195.038.008.000', 'DE'),
    ('195.038.012.000', 'PL'),
    ('195.038.016.000', 'UA'),
    ('195.038.019.000', 'GB'),
    ('195.038.020.000', 'EU'),
    ('195.038.024.000', 'DE'),
    ('195.038.028.000', 'GB'),
    ('195.038.030.000', 'MT'),
    ('195.038.031.000', 'PL'),
    ('195.038.032.000', 'RU'),
    ('195.038.064.000', 'GB'),
    ('195.038.096.000', 'HU'),
    ('195.038.128.000', 'DE'),
    ('195.038.160.000', 'KG'),
    ('195.038.192.000', 'NL'),
    ('195.039.000.000', 'CZ'),
    ('195.039.128.000', 'KW'),
    ('195.039.192.000', 'EU'),
    ('195.040.000.000', 'GB'),
    ('195.041.000.000', 'DK'),
    ('195.042.000.000', 'FR'),
    ('195.042.064.000', 'RU'),
    ('195.042.124.000', 'UA'),
    ('195.042.128.000', 'RU'),
    ('195.042.192.000', 'SE'),
    ('195.042.224.000', 'NL'),
    ('195.042.230.000', 'AT'),
    ('195.042.231.000', 'FR'),
    ('195.042.232.000', 'DE'),
    ('195.042.236.000', 'GB'),
    ('195.042.240.000', 'NL'),
    ('195.042.249.000', 'PL'),
    ('195.042.250.000', 'FR'),
    ('195.042.252.000', 'DE'),
    ('195.043.000.000', 'EG'),
    ('195.043.032.000', 'SK'),
    ('195.043.064.000', 'LT'),
    ('195.043.096.000', 'LU'),
    ('195.043.100.000', 'BE'),
    ('195.043.101.000', 'LU'),
    ('195.043.106.000', 'BE'),
    ('195.043.107.000', 'LU'),
    ('195.043.128.000', 'SE'),
    ('195.043.129.000', 'DK'),
    ('195.043.160.000', 'IT'),
    ('195.043.182.000', 'EU'),
    ('195.043.184.000', 'IT'),
    ('195.043.191.000', 'EU'),
    ('195.043.192.000', 'SE'),
    ('195.044.000.000', 'GB'),
    ('195.045.000.000', 'IT'),
    ('195.046.000.000', 'GR'),
    ('195.046.032.000', 'EU'),
    ('195.046.064.000', 'SK'),
    ('195.046.096.000', 'RU'),
    ('195.046.128.000', 'TR'),
    ('195.046.160.000', 'RU'),
    ('195.046.192.000', 'FR'),
    ('195.046.224.000', 'LU'),
    ('195.047.000.000', 'CZ'),
    ('195.047.128.000', 'DK'),
    ('195.047.192.000', 'EU'),
    ('195.048.000.000', 'CH'),
    ('195.049.128.000', 'EU'),
    ('195.050.000.000', 'BY'),
    ('195.050.032.000', 'DK'),
    ('195.050.064.000', 'GB'),
    ('195.050.128.000', 'DE'),
    ('195.050.192.000', 'EE'),
    ('195.050.224.000', 'CH'),
    ('195.051.000.000', 'DE'),
    ('195.051.048.000', 'FR'),
    ('195.051.049.000', 'GB'),
    ('195.051.050.000', 'DE'),
    ('195.051.051.000', 'FR'),
    ('195.051.052.000', 'DE'),
    ('195.051.053.000', 'FR'),
    ('195.051.054.000', 'DE'),
    ('195.051.064.000', 'NL'),
    ('195.051.072.000', 'BE'),
    ('195.051.076.000', 'CH'),
    ('195.051.078.000', 'GB'),
    ('195.051.080.000', 'BE'),
    ('195.051.088.000', 'ZA'),
    ('195.051.092.000', 'NL'),
    ('195.051.096.000', 'FR'),
    ('195.051.112.000', 'ES'),
    ('195.051.116.000', 'NL'),
    ('195.051.117.000', 'FR'),
    ('195.051.118.000', 'BE'),
    ('195.051.120.000', 'IT'),
    ('195.051.128.000', 'GB'),
    ('195.051.131.000', 'DE'),
    ('195.051.132.000', 'GB'),
    ('195.051.143.000', 'SE'),
    ('195.051.144.000', 'GB'),
    ('195.051.154.000', 'DE'),
    ('195.051.155.000', 'IT'),
    ('195.051.156.000', 'ZA'),
    ('195.051.160.000', 'DE'),
    ('195.051.168.000', 'FR'),
    ('195.051.176.000', 'NL'),
    ('195.051.192.000', 'DK'),
    ('195.051.205.000', 'EU'),
    ('195.051.206.000', 'DK'),
    ('195.051.207.000', 'SE'),
    ('195.051.208.000', 'AT'),
    ('195.051.214.000', 'NL'),
    ('195.051.215.000', 'AT'),
    ('195.051.216.000', 'SE'),
    ('195.051.217.000', 'EU'),
    ('195.051.218.000', 'SE'),
    ('195.051.222.000', 'GB'),
    ('195.051.223.000', 'BE'),
    ('195.051.224.000', 'CH'),
    ('195.051.225.000', 'AT'),
    ('195.051.227.000', 'CH'),
    ('195.051.228.000', 'EU'),
    ('195.051.229.000', 'IE'),
    ('195.051.230.000', 'AT'),
    ('195.051.234.000', 'DE'),
    ('195.051.235.000', 'AT'),
    ('195.051.236.000', 'CH'),
    ('195.051.238.000', 'BE'),
    ('195.051.239.000', 'AT'),
    ('195.051.242.000', 'CH'),
    ('195.051.243.000', 'BY'),
    ('195.051.244.000', 'AT'),
    ('195.051.245.000', 'ZA'),
    ('195.051.246.000', 'BE'),
    ('195.051.247.000', 'GR'),
    ('195.051.248.000', 'GB'),
    ('195.051.249.000', 'DE'),
    ('195.051.250.000', 'CH'),
    ('195.051.251.000', 'DE'),
    ('195.051.252.000', 'FR'),
    ('195.051.253.000', 'BE'),
    ('195.051.255.000', 'GB'),
    ('195.052.000.000', 'DE'),
    ('195.052.072.000', 'GB'),
    ('195.052.074.000', 'DE'),
    ('195.052.075.000', 'GB'),
    ('195.052.076.000', 'DE'),
    ('195.053.000.000', 'ES'),
    ('195.054.000.000', 'RU'),
    ('195.054.032.000', 'IT'),
    ('195.054.064.000', 'DK'),
    ('195.054.096.000', 'SE'),
    ('195.054.160.000', 'AT'),
    ('195.054.192.000', 'RU'),
    ('195.054.224.000', 'GB'),
    ('195.055.000.000', 'ES'),
    ('195.056.000.000', 'HU'),
    ('195.057.000.000', 'ES'),
    ('195.058.000.000', 'RU'),
    ('195.058.053.000', 'TJ'),
    ('195.058.054.000', 'RU'),
    ('195.058.064.000', 'GB'),
    ('195.058.096.000', 'SE'),
    ('195.058.128.000', 'GB'),
    ('195.058.160.000', 'AT'),
    ('195.058.192.000', 'GB'),
    ('195.058.224.000', 'UA'),
    ('195.059.000.000', 'GB'),
    ('195.060.032.000', 'DE'),
    ('195.060.128.000', 'IT'),
    ('195.060.160.000', 'PT'),
    ('195.060.192.000', 'IT'),
    ('195.061.000.000', 'ES'),
    ('195.061.001.000', 'EU'),
    ('195.061.007.000', 'ES'),
    ('195.061.008.000', 'EU'),
    ('195.061.010.000', 'ES'),
    ('195.061.013.000', 'EU'),
    ('195.061.014.000', 'ES'),
    ('195.061.016.000', 'EU'),
    ('195.061.019.000', 'ES'),
    ('195.061.020.000', 'EU'),
    ('195.061.021.000', 'ES'),
    ('195.061.022.000', 'EU'),
    ('195.061.024.000', 'ES'),
    ('195.061.025.000', 'EU'),
    ('195.061.026.000', 'ES'),
    ('195.061.027.000', 'EU'),
    ('195.061.029.000', 'US'),
    ('195.061.030.000', 'ES'),
    ('195.061.031.000', 'EU'),
    ('195.061.032.000', 'CH'),
    ('195.061.034.000', 'EU'),
    ('195.061.035.000', 'CH'),
    ('195.061.037.000', 'EU'),
    ('195.061.039.000', 'CH'),
    ('195.061.040.000', 'EU'),
    ('195.061.041.000', 'CH'),
    ('195.061.042.000', 'EU'),
    ('195.061.043.000', 'CH'),
    ('195.061.052.000', 'EU'),
    ('195.061.053.000', 'CH'),
    ('195.061.057.000', 'EU'),
    ('195.061.059.000', 'CH'),
    ('195.061.062.000', 'EU'),
    ('195.061.064.000', 'PT'),
    ('195.061.070.000', 'EU'),
    ('195.061.071.000', 'PT'),
    ('195.061.076.000', 'EU'),
    ('195.061.078.000', 'PT'),
    ('195.061.096.000', 'FR'),
    ('195.061.097.000', 'NL'),
    ('195.061.104.000', 'EU'),
    ('195.061.105.000', 'NL'),
    ('195.061.107.000', 'EU'),
    ('195.061.108.000', 'NL'),
    ('195.061.109.000', 'EU'),
    ('195.061.110.000', 'NL'),
    ('195.061.111.000', 'EU'),
    ('195.061.113.000', 'NL'),
    ('195.061.117.000', 'EU'),
    ('195.061.118.000', 'NL'),
    ('195.061.119.000', 'EU'),
    ('195.061.120.000', 'NL'),
    ('195.061.122.000', 'EU'),
    ('195.061.126.000', 'NL'),
    ('195.061.127.000', 'EU'),
    ('195.061.128.000', 'BE'),
    ('195.061.129.000', 'EU'),
    ('195.061.130.000', 'BE'),
    ('195.061.133.000', 'IT'),
    ('195.061.134.000', 'EU'),
    ('195.061.135.000', 'BE'),
    ('195.061.136.000', 'EU'),
    ('195.061.137.000', 'BE'),
    ('195.061.142.000', 'EU'),
    ('195.061.143.000', 'BE'),
    ('195.061.144.000', 'RO'),
    ('195.061.149.000', 'MD'),
    ('195.061.150.000', 'EU'),
    ('195.061.151.000', 'RO'),
    ('195.061.157.000', 'BE'),
    ('195.061.158.000', 'US'),
    ('195.061.159.000', 'EU'),
    ('195.061.160.000', 'AT'),
    ('195.061.192.000', 'IT'),
    ('195.061.201.000', 'EU'),
    ('195.061.202.000', 'IT'),
    ('195.061.204.000', 'EU'),
    ('195.061.205.000', 'IT'),
    ('195.061.218.000', 'EU'),
    ('195.061.224.000', 'LU'),
    ('195.061.226.000', 'BE'),
    ('195.061.227.000', 'LU'),
    ('195.061.231.000', 'EU'),
    ('195.062.032.000', 'IT'),
    ('195.062.064.000', 'US'),
    ('195.062.068.000', 'EU'),
    ('195.062.096.000', 'DE'),
    ('195.062.128.000', 'LV'),
    ('195.062.160.000', 'IT'),
    ('195.062.192.000', 'GB'),
    ('195.062.224.000', 'IT'),
    ('195.063.000.000', 'DE'),
    ('195.063.115.000', 'AT'),
    ('195.063.116.000', 'DE'),
    ('195.063.148.000', 'AT'),
    ('195.063.151.000', 'DE'),
    ('195.064.000.000', 'AT'),
    ('195.064.032.000', 'NL'),
    ('195.064.096.000', 'DE'),
    ('195.064.128.000', 'TR'),
    ('195.064.192.000', 'RU'),
    ('195.064.224.000', 'UA'),
    ('195.065.000.000', 'CH'),
    ('195.065.109.000', 'LI'),
    ('195.065.110.000', 'CH'),
    ('195.065.124.000', 'LI'),
    ('195.065.125.000', 'CH'),
    ('195.066.000.000', 'NL'),
    ('195.066.032.000', 'SE'),
    ('195.066.064.000', 'DE'),
    ('195.066.096.000', 'GR'),
    ('195.066.128.000', 'CH'),
    ('195.066.160.000', 'YU'),
    ('195.066.192.000', 'UA'),
    ('195.066.224.000', 'GB'),
    ('195.067.000.000', 'SE'),
    ('195.068.000.000', 'FR'),
    ('195.068.128.000', 'RU'),
    ('195.068.192.000', 'EU'),
    ('195.069.000.000', 'NO'),
    ('195.069.064.000', 'EU'),
    ('195.070.000.000', 'CH'),
    ('195.070.032.000', 'HU'),
    ('195.070.064.000', 'GB'),
    ('195.070.096.000', 'AT'),
    ('195.070.128.000', 'CZ'),
    ('195.070.160.000', 'NO'),
    ('195.070.192.000', 'RU'),
    ('195.070.224.000', 'AT'),
    ('195.071.000.000', 'DE'),
    ('195.071.155.000', 'GB'),
    ('195.071.156.000', 'DE'),
    ('195.071.157.000', 'ES'),
    ('195.071.158.000', 'DE'),
    ('195.072.000.000', 'SK'),
    ('195.072.032.000', 'GB'),
    ('195.072.064.000', 'BE'),
    ('195.072.096.000', 'DE'),
    ('195.072.112.000', 'BG'),
    ('195.072.113.000', 'GB'),
    ('195.072.116.000', 'IL'),
    ('195.072.128.000', 'GB'),
    ('195.072.192.000', 'IT'),
    ('195.072.224.000', 'RU'),
    ('195.073.000.000', 'DE'),
    ('195.074.000.000', 'FI'),
    ('195.074.032.000', 'TR'),
    ('195.074.064.000', 'GB'),
    ('195.074.160.000', 'DE'),
    ('195.074.175.000', 'EU'),
    ('195.074.192.000', 'BE'),
    ('195.074.224.000', 'GR'),
    ('195.075.000.000', 'AT'),
    ('195.075.008.000', 'IT'),
    ('195.075.010.000', 'EU'),
    ('195.075.011.000', 'IT'),
    ('195.075.012.000', 'EU'),
    ('195.075.014.000', 'IT'),
    ('195.075.016.000', 'CH'),
    ('195.075.018.000', 'EU'),
    ('195.075.020.000', 'CH'),
    ('195.075.022.000', 'EU'),
    ('195.075.024.000', 'FR'),
    ('195.075.029.000', 'CH'),
    ('195.075.030.000', 'EU'),
    ('195.075.032.000', 'RU'),
    ('195.075.033.000', 'EU'),
    ('195.075.034.000', 'RU'),
    ('195.075.036.000', 'EU'),
    ('195.075.040.000', 'GR'),
    ('195.075.041.000', 'EU'),
    ('195.075.042.000', 'GR'),
    ('195.075.047.000', 'EU'),
    ('195.075.048.000', 'SK'),
    ('195.075.049.000', 'EU'),
    ('195.075.050.000', 'SK'),
    ('195.075.051.000', 'EU'),
    ('195.075.057.000', 'GR'),
    ('195.075.058.000', 'CH'),
    ('195.075.060.000', 'ES'),
    ('195.075.064.000', 'CZ'),
    ('195.075.066.000', 'EU'),
    ('195.075.068.000', 'CZ'),
    ('195.075.069.000', 'EU'),
    ('195.075.071.000', 'BG'),
    ('195.075.072.000', 'EU'),
    ('195.075.074.000', 'CZ'),
    ('195.075.076.000', 'EU'),
    ('195.075.080.000', 'GB'),
    ('195.075.095.000', 'DE'),
    ('195.075.100.000', 'EU'),
    ('195.075.102.000', 'DE'),
    ('195.075.103.000', 'EU'),
    ('195.075.104.000', 'DE'),
    ('195.075.109.000', 'EU'),
    ('195.075.110.000', 'DE'),
    ('195.075.112.000', 'EU'),
    ('195.075.113.000', 'DE'),
    ('195.075.114.000', 'EU'),
    ('195.075.116.000', 'DE'),
    ('195.075.128.000', 'ZA'),
    ('195.075.130.000', 'EU'),
    ('195.075.131.000', 'ZA'),
    ('195.075.136.000', 'CH'),
    ('195.075.137.000', 'EU'),
    ('195.075.138.000', 'CH'),
    ('195.075.139.000', 'EU'),
    ('195.075.140.000', 'CZ'),
    ('195.075.141.000', 'EU'),
    ('195.075.144.000', 'IT'),
    ('195.075.148.000', 'EU'),
    ('195.075.150.000', 'IT'),
    ('195.075.152.000', 'EU'),
    ('195.075.153.000', 'ZA'),
    ('195.075.160.000', 'CH'),
    ('195.075.164.000', 'EU'),
    ('195.075.165.000', 'CH'),
    ('195.075.166.000', 'EU'),
    ('195.075.168.000', 'ES'),
    ('195.075.169.000', 'EU'),
    ('195.075.170.000', 'ES'),
    ('195.075.176.000', 'NL'),
    ('195.075.180.000', 'BE'),
    ('195.075.184.000', 'EU'),
    ('195.075.185.000', 'DK'),
    ('195.075.187.000', 'BE'),
    ('195.075.188.000', 'SE'),
    ('195.075.191.000', 'EU'),
    ('195.075.194.000', 'NL'),
    ('195.075.200.000', 'CH'),
    ('195.075.201.000', 'NO'),
    ('195.075.202.000', 'TR'),
    ('195.075.203.000', 'EU'),
    ('195.075.204.000', 'GB'),
    ('195.075.205.000', 'PT'),
    ('195.075.206.000', 'FI'),
    ('195.075.207.000', 'HR'),
    ('195.075.208.000', 'EU'),
    ('195.075.210.000', 'CH'),
    ('195.075.211.000', 'EU'),
    ('195.075.214.000', 'SI'),
    ('195.075.216.000', 'PK'),
    ('195.075.218.000', 'BE'),
    ('195.075.221.000', 'IE'),
    ('195.075.222.000', 'TR'),
    ('195.075.223.000', 'HU'),
    ('195.075.224.000', 'NL'),
    ('195.075.234.000', 'EU'),
    ('195.075.236.000', 'TR'),
    ('195.075.237.000', 'HU'),
    ('195.075.238.000', 'TR'),
    ('195.075.240.000', 'IE'),
    ('195.075.241.000', 'NL'),
    ('195.075.244.000', 'EU'),
    ('195.075.245.000', 'RU'),
    ('195.075.246.000', 'EU'),
    ('195.075.247.000', 'PK'),
    ('195.075.248.000', 'FI'),
    ('195.075.249.000', 'EU'),
    ('195.075.250.000', 'ES'),
    ('195.075.251.000', 'EU'),
    ('195.075.253.000', 'AT'),
    ('195.075.255.000', 'GR'),
    ('195.076.000.000', 'ES'),
    ('195.078.000.000', 'MC'),
    ('195.078.032.000', 'IT'),
    ('195.078.038.000', 'EU'),
    ('195.078.064.000', 'DK'),
    ('195.078.096.000', 'FR'),
    ('195.078.128.000', 'SE'),
    ('195.078.160.000', 'DE'),
    ('195.078.165.000', 'BE'),
    ('195.078.166.000', '--'),
    ('195.078.167.000', 'BE'),
    ('195.078.168.000', 'DE'),
    ('195.078.185.000', '--'),
    ('195.078.188.000', 'DE'),
    ('195.078.192.000', 'IT'),
    ('195.078.224.000', 'GB'),
    ('195.079.000.000', 'AT'),
    ('195.079.008.000', 'IT'),
    ('195.079.013.000', 'NL'),
    ('195.079.014.000', 'GB'),
    ('195.079.016.000', 'CH'),
    ('195.079.023.000', 'FR'),
    ('195.079.032.000', 'RU'),
    ('195.079.033.000', 'AT'),
    ('195.079.038.000', 'BE'),
    ('195.079.040.000', 'IT'),
    ('195.079.041.000', 'GR'),
    ('195.079.042.000', 'DK'),
    ('195.079.044.000', 'GB'),
    ('195.079.048.000', 'CH'),
    ('195.079.054.000', 'GB'),
    ('195.079.056.000', 'AT'),
    ('195.079.058.000', 'BE'),
    ('195.079.060.000', 'NL'),
    ('195.079.062.000', 'GB'),
    ('195.079.096.000', 'DE'),
    ('195.079.120.000', 'GB'),
    ('195.079.127.000', 'FR'),
    ('195.079.128.000', 'ZA'),
    ('195.079.130.000', 'NL'),
    ('195.079.133.000', 'DE'),
    ('195.079.134.000', 'ES'),
    ('195.079.135.000', 'DE'),
    ('195.079.136.000', 'ES'),
    ('195.079.144.000', 'NL'),
    ('195.079.148.000', 'BE'),
    ('195.079.152.000', 'DK'),
    ('195.079.156.000', 'SE'),
    ('195.079.160.000', 'NL'),
    ('195.079.184.000', 'BE'),
    ('195.079.190.000', 'IT'),
    ('195.079.192.000', 'FR'),
    ('195.079.195.000', 'EU'),
    ('195.079.196.000', 'FR'),
    ('195.079.197.000', 'NO'),
    ('195.079.198.000', 'IE'),
    ('195.079.199.000', 'PT'),
    ('195.079.200.000', 'IL'),
    ('195.079.201.000', 'AT'),
    ('195.079.202.000', 'NO'),
    ('195.079.203.000', 'AT'),
    ('195.079.204.000', 'HU'),
    ('195.079.205.000', 'AT'),
    ('195.079.207.000', 'FR'),
    ('195.079.212.000', 'IE'),
    ('195.079.213.000', 'NO'),
    ('195.079.214.000', 'FI'),
    ('195.079.215.000', 'FR'),
    ('195.079.216.000', 'IT'),
    ('195.079.217.000', 'ES'),
    ('195.079.218.000', 'IE'),
    ('195.079.219.000', 'HU'),
    ('195.079.220.000', 'PK'),
    ('195.079.221.000', 'GB'),
    ('195.079.222.000', 'PT'),
    ('195.079.223.000', 'GB'),
    ('195.079.228.000', 'FR'),
    ('195.079.229.000', 'GB'),
    ('195.079.230.000', 'FR'),
    ('195.079.232.000', 'EU'),
    ('195.079.233.000', 'NL'),
    ('195.079.234.000', 'BE'),
    ('195.079.240.000', 'AT'),
    ('195.079.248.000', 'EU'),
    ('195.079.254.000', 'DE'),
    ('195.079.255.000', 'NL'),
    ('195.080.000.000', 'GB'),
    ('195.080.096.000', 'EE'),
    ('195.080.128.000', 'FR'),
    ('195.080.160.000', 'SK'),
    ('195.080.192.000', 'DE'),
    ('195.080.224.000', 'EU'),
    ('195.081.000.000', 'NL'),
    ('195.081.002.000', 'EU'),
    ('195.081.006.000', 'NL'),
    ('195.081.010.000', 'EU'),
    ('195.081.012.000', 'NL'),
    ('195.081.013.000', 'EU'),
    ('195.081.017.000', 'NL'),
    ('195.081.018.000', 'EU'),
    ('195.081.019.000', 'NL'),
    ('195.081.020.000', 'EU'),
    ('195.081.022.000', 'NL'),
    ('195.081.023.000', 'EU'),
    ('195.081.024.000', 'NL'),
    ('195.081.025.000', 'EU'),
    ('195.081.026.000', 'NL'),
    ('195.081.035.000', 'EU'),
    ('195.081.036.000', 'NL'),
    ('195.081.042.000', 'EU'),
    ('195.081.046.000', 'NL'),
    ('195.081.056.000', 'EU'),
    ('195.081.058.000', 'NL'),
    ('195.081.066.000', 'EU'),
    ('195.082.000.000', 'KZ'),
    ('195.082.032.000', 'DE'),
    ('195.082.096.000', 'GB'),
    ('195.082.128.000', 'ES'),
    ('195.082.160.000', 'PL'),
    ('195.082.192.000', 'DK'),
    ('195.082.224.000', 'AT'),
    ('195.083.000.000', 'FR'),
    ('195.084.000.000', 'SE'),
    ('195.085.000.000', 'DK'),
    ('195.085.128.000', 'NL'),
    ('195.085.192.000', 'EU'),
    ('195.086.000.000', 'NL'),
    ('195.087.000.000', 'TR'),
    ('195.088.000.000', 'DE'),
    ('195.089.000.000', 'GB'),
    ('195.089.003.000', 'LB'),
    ('195.089.004.000', 'CH'),
    ('195.089.008.000', 'BE'),
    ('195.089.009.000', 'CH'),
    ('195.089.020.000', 'ES'),
    ('195.089.023.000', 'GB'),
    ('195.089.024.000', 'CH'),
    ('195.089.027.000', 'GB'),
    ('195.089.028.000', 'CH'),
    ('195.089.035.000', 'IT'),
    ('195.089.036.000', 'CH'),
    ('195.089.040.000', 'GB'),
    ('195.090.000.000', 'DE'),
    ('195.090.032.000', 'GB'),
    ('195.090.033.000', 'EU'),
    ('195.090.034.000', 'FR'),
    ('195.090.036.000', 'BE'),
    ('195.090.037.000', 'IL'),
    ('195.090.038.000', 'FR'),
    ('195.090.040.000', 'EU'),
    ('195.090.043.000', 'US'),
    ('195.090.045.000', 'EU'),
    ('195.090.046.000', 'US'),
    ('195.090.055.000', 'EU'),
    ('195.090.064.000', 'NL'),
    ('195.090.069.000', 'GB'),
    ('195.090.070.000', 'NL'),
    ('195.090.071.000', 'DE'),
    ('195.090.072.000', 'NL'),
    ('195.090.073.000', 'GR'),
    ('195.090.074.000', 'NL'),
    ('195.090.075.000', 'DE'),
    ('195.090.076.000', 'BE'),
    ('195.090.080.000', 'NL'),
    ('195.090.081.000', 'GB'),
    ('195.090.082.000', 'NL'),
    ('195.090.083.000', 'BE'),
    ('195.090.087.000', 'GE'),
    ('195.090.089.000', 'NL'),
    ('195.090.091.000', 'GR'),
    ('195.090.092.000', 'NL'),
    ('195.090.096.000', 'JO'),
    ('195.090.128.000', 'RU'),
    ('195.090.192.000', 'DE'),
    ('195.091.000.000', 'SK'),
    ('195.091.128.000', 'RU'),
    ('195.092.000.000', 'GB'),
    ('195.093.000.000', 'US'),
    ('195.093.128.000', 'GB'),
    ('195.094.000.000', 'YE'),
    ('195.094.032.000', 'CH'),
    ('195.094.064.000', 'DE'),
    ('195.094.096.000', 'FI'),
    ('195.094.128.000', 'IT'),
    ('195.094.192.000', 'PL'),
    ('195.094.224.000', 'RU'),
    ('195.095.000.000', 'BE'),
    ('195.095.096.000', 'LU'),
    ('195.095.097.000', 'BE'),
    ('195.095.108.000', 'LU'),
    ('195.095.109.000', 'BE'),
    ('195.095.110.000', 'LU'),
    ('195.095.111.000', 'BE'),
    ('195.095.116.000', 'LU'),
    ('195.095.118.000', 'BE'),
    ('195.095.122.000', 'LU'),
    ('195.095.124.000', 'BE'),
    ('195.095.126.000', 'LU'),
    ('195.095.127.000', 'BE'),
    ('195.095.128.000', 'NL'),
    ('195.095.192.000', 'EU'),
    ('195.096.000.000', 'AT'),
    ('195.096.032.000', 'DE'),
    ('195.096.064.000', 'RU'),
    ('195.096.096.000', 'NL'),
    ('195.096.128.000', 'IT'),
    ('195.096.144.000', 'IR'),
    ('195.096.145.000', 'IT'),
    ('195.096.150.000', 'IR'),
    ('195.096.151.000', 'IT'),
    ('195.096.160.000', 'RU'),
    ('195.096.192.000', 'IT'),
    ('195.096.224.000', 'BG'),
    ('195.097.000.000', 'GR'),
    ('195.097.128.000', 'DK'),
    ('195.097.192.000', 'GB'),
    ('195.098.000.000', 'SK'),
    ('195.098.032.000', 'RU'),
    ('195.098.096.000', 'FR'),
    ('195.098.128.000', 'SK'),
    ('195.098.160.000', 'RU'),
    ('195.098.192.000', 'DE'),
    ('195.098.224.000', 'FR'),
    ('195.099.000.000', 'GB'),
    ('195.099.008.000', 'EU'),
    ('195.099.015.000', 'DE'),
    ('195.099.016.000', 'EU'),
    ('195.099.026.000', 'IT'),
    ('195.099.028.000', 'EU'),
    ('195.099.032.000', 'NL'),
    ('195.099.033.000', 'EU'),
    ('195.099.035.000', 'NL'),
    ('195.099.040.000', 'GB'),
    ('195.099.064.000', 'EU'),
    ('195.099.065.000', 'GB'),
    ('195.099.066.000', 'NL'),
    ('195.099.067.000', 'EU'),
    ('195.099.070.000', 'ES'),
    ('195.099.071.000', 'EU'),
    ('195.099.088.000', 'GB'),
    ('195.099.089.000', 'BE'),
    ('195.099.090.000', 'EU'),
    ('195.099.093.000', 'BE'),
    ('195.099.096.000', 'GB'),
    ('195.099.099.000', 'IT'),
    ('195.099.100.000', 'GB'),
    ('195.099.104.000', 'NL'),
    ('195.099.105.000', 'GB'),
    ('195.099.112.000', 'EU'),
    ('195.099.120.000', 'GB'),
    ('195.099.135.000', 'IT'),
    ('195.099.136.000', 'GB'),
    ('195.099.192.000', 'EU'),
    ('195.099.207.000', 'DE'),
    ('195.099.208.000', 'EU'),
    ('195.099.216.000', 'GB'),
    ('195.099.224.000', 'EU'),
    ('195.099.226.000', 'FR'),
    ('195.099.227.000', 'EU'),
    ('195.099.229.000', 'FR'),
    ('195.099.230.000', 'EU'),
    ('195.099.240.000', 'GB'),
    ('195.099.248.000', 'EU'),
    ('195.100.000.000', 'SE'),
    ('195.101.000.000', 'FR'),
    ('195.101.216.000', 'MC'),
    ('195.101.217.000', 'FR'),
    ('195.102.000.000', 'GB'),
    ('195.103.000.000', 'IT'),
    ('195.104.000.000', 'GB'),
    ('195.108.000.000', 'NL'),
    ('195.110.000.000', 'DE'),
    ('195.110.032.000', 'HU'),
    ('195.110.064.000', 'GB'),
    ('195.110.096.000', 'IT'),
    ('195.110.160.000', 'GB'),
    ('195.110.192.000', 'AT'),
    ('195.110.224.000', 'FR'),
    ('195.111.000.000', 'HU'),
    ('195.112.000.000', 'GB'),
    ('195.112.064.000', 'CH'),
    ('195.112.096.000', 'RU'),
    ('195.112.128.000', 'TR'),
    ('195.112.160.000', 'DE'),
    ('195.112.161.000', 'FR'),
    ('195.112.164.000', 'US'),
    ('195.112.165.000', 'DE'),
    ('195.112.166.000', 'FR'),
    ('195.112.167.000', 'HK'),
    ('195.112.168.000', 'GR'),
    ('195.112.169.000', 'BE'),
    ('195.112.170.000', 'DE'),
    ('195.112.172.000', 'US'),
    ('195.112.173.000', 'AR'),
    ('195.112.174.000', 'US'),
    ('195.112.175.000', 'GB'),
    ('195.112.176.000', 'TW'),
    ('195.112.177.000', 'SG'),
    ('195.112.178.000', 'DE'),
    ('195.112.184.000', '--'),
    ('195.112.185.000', 'DE'),
    ('195.112.186.000', 'DO'),
    ('195.112.187.000', 'BR'),
    ('195.112.188.000', 'CA'),
    ('195.112.189.000', 'AR'),
    ('195.112.190.000', 'DE'),
    ('195.112.192.000', 'LB'),
    ('195.112.224.000', 'RU'),
    ('195.113.000.000', 'CZ'),
    ('195.114.000.000', 'SK'),
    ('195.114.032.000', 'LV'),
    ('195.114.064.000', 'FR'),
    ('195.114.096.000', 'UA'),
    ('195.114.160.000', 'PL'),
    ('195.114.192.000', 'ES'),
    ('195.114.207.000', 'DE'),
    ('195.114.208.000', 'ES'),
    ('195.114.224.000', 'NL'),
    ('195.115.000.000', 'FR'),
    ('195.116.000.000', 'PL'),
    ('195.116.039.000', 'GB'),
    ('195.116.040.000', 'PL'),
    ('195.118.000.000', 'NL'),
    ('195.118.004.000', 'GB'),
    ('195.118.005.000', 'NL'),
    ('195.118.016.000', 'FI'),
    ('195.118.017.000', 'IE'),
    ('195.118.018.000', 'SE'),
    ('195.118.019.000', 'ES'),
    ('195.118.020.000', 'PT'),
    ('195.118.021.000', 'IL'),
    ('195.118.022.000', 'ZA'),
    ('195.118.024.000', 'ES'),
    ('195.118.027.000', 'ZA'),
    ('195.118.028.000', 'SE'),
    ('195.118.030.000', 'ZA'),
    ('195.118.032.000', 'DE'),
    ('195.118.059.000', 'GB'),
    ('195.118.060.000', 'DE'),
    ('195.118.064.000', 'FR'),
    ('195.118.080.000', 'DE'),
    ('195.118.096.000', 'CH'),
    ('195.118.099.000', 'BE'),
    ('195.118.100.000', 'DE'),
    ('195.118.101.000', 'BE'),
    ('195.118.102.000', 'IT'),
    ('195.118.107.000', 'DE'),
    ('195.118.109.000', 'GB'),
    ('195.118.110.000', 'CZ'),
    ('195.118.111.000', 'NL'),
    ('195.118.112.000', 'AT'),
    ('195.118.116.000', 'FR'),
    ('195.118.120.000', 'DK'),
    ('195.118.126.000', 'NL'),
    ('195.118.128.000', 'GB'),
    ('195.118.158.000', 'EU'),
    ('195.118.159.000', 'GB'),
    ('195.118.192.000', 'ES'),
    ('195.118.194.000', 'IT'),
    ('195.118.200.000', 'SE'),
    ('195.118.201.000', 'ZA'),
    ('195.118.202.000', 'IT'),
    ('195.118.203.000', 'ZA'),
    ('195.118.204.000', 'SE'),
    ('195.118.205.000', 'HR'),
    ('195.118.206.000', 'SI'),
    ('195.118.207.000', 'ZA'),
    ('195.118.208.000', 'BE'),
    ('195.118.214.000', 'SE'),
    ('195.118.216.000', 'GB'),
    ('195.118.221.000', 'FR'),
    ('195.118.224.000', 'SE'),
    ('195.118.226.000', 'IT'),
    ('195.118.228.000', 'GB'),
    ('195.118.229.000', 'ES'),
    ('195.118.230.000', 'IT'),
    ('195.118.231.000', 'FR'),
    ('195.118.232.000', 'DE'),
    ('195.118.237.000', 'FR'),
    ('195.118.238.000', 'GB'),
    ('195.118.240.000', 'DK'),
    ('195.118.242.000', 'GB'),
    ('195.118.243.000', 'BE'),
    ('195.118.244.000', 'EU'),
    ('195.118.245.000', 'GB'),
    ('195.118.246.000', 'DK'),
    ('195.118.252.000', 'AT'),
    ('195.118.255.000', 'BE'),
    ('195.119.000.000', 'NO'),
    ('195.119.002.000', 'EU'),
    ('195.119.004.000', 'NO'),
    ('195.119.006.000', 'EU'),
    ('195.119.064.000', 'FI'),
    ('195.119.066.000', 'EU'),
    ('195.119.067.000', 'FI'),
    ('195.119.076.000', 'EU'),
    ('195.119.096.000', 'CH'),
    ('195.119.098.000', 'EU'),
    ('195.119.105.000', 'CH'),
    ('195.119.109.000', 'EU'),
    ('195.119.110.000', 'CH'),
    ('195.119.115.000', 'EU'),
    ('195.119.119.000', 'CH'),
    ('195.119.123.000', 'EU'),
    ('195.119.128.000', 'GR'),
    ('195.119.129.000', 'EU'),
    ('195.119.130.000', 'GR'),
    ('195.119.131.000', 'EU'),
    ('195.119.148.000', 'GR'),
    ('195.119.149.000', 'EU'),
    ('195.119.150.000', 'GR'),
    ('195.119.151.000', 'EU'),
    ('195.119.183.000', 'CZ'),
    ('195.119.184.000', 'EU'),
    ('195.119.185.000', 'CZ'),
    ('195.119.188.000', 'EU'),
    ('195.119.189.000', 'CZ'),
    ('195.119.190.000', 'EU'),
    ('195.119.191.000', 'CZ'),
    ('195.119.192.000', 'EU'),
    ('195.119.207.000', 'ES'),
    ('195.119.208.000', 'EU'),
    ('195.120.000.000', 'IT'),
    ('195.121.000.000', 'NL'),
    ('195.122.000.000', 'LV'),
    ('195.122.032.000', 'GB'),
    ('195.122.064.000', 'IT'),
    ('195.122.096.000', 'BE'),
    ('195.122.128.000', 'DE'),
    ('195.122.132.000', 'GB'),
    ('195.122.133.000', 'DE'),
    ('195.122.140.000', 'GB'),
    ('195.122.141.000', 'DE'),
    ('195.122.168.000', 'GB'),
    ('195.122.169.000', 'DE'),
    ('195.122.176.000', 'GB'),
    ('195.122.177.000', 'DE'),
    ('195.122.192.000', 'CZ'),
    ('195.122.224.000', 'RU'),
    ('195.123.000.000', 'UA'),
    ('195.124.000.000', 'DE'),
    ('195.125.015.000', 'CH'),
    ('195.125.016.000', 'DE'),
    ('195.126.056.000', 'LY'),
    ('195.126.058.000', 'DE'),
    ('195.128.000.000', 'SA'),
    ('195.128.032.000', 'EU'),
    ('195.128.064.000', 'RU'),
    ('195.128.096.000', 'EU'),
    ('195.128.128.000', 'RU'),
    ('195.128.160.000', 'EU'),
    ('195.128.192.000', 'CZ'),
    ('195.128.224.000', 'EU'),
    ('195.129.000.000', 'DE'),
    ('195.129.001.000', 'EU'),
    ('195.129.002.000', 'NL'),
    ('195.129.003.000', 'EU'),
    ('195.129.013.000', 'FR'),
    ('195.129.015.000', 'GB'),
    ('195.129.016.000', 'EU'),
    ('195.129.018.000', 'GB'),
    ('195.129.020.000', 'EU'),
    ('195.129.026.000', 'IT'),
    ('195.129.028.000', 'GB'),
    ('195.129.032.000', 'EU'),
    ('195.129.033.000', 'CH'),
    ('195.129.036.000', 'IE'),
    ('195.129.037.000', 'BE'),
    ('195.129.038.000', 'NL'),
    ('195.129.039.000', 'CH'),
    ('195.129.040.000', 'EU'),
    ('195.129.045.000', 'IT'),
    ('195.129.046.000', 'EU'),
    ('195.129.048.000', 'IT'),
    ('195.129.052.000', 'SE'),
    ('195.129.053.000', 'EU'),
    ('195.129.064.000', 'CH'),
    ('195.129.065.000', 'EU'),
    ('195.129.066.000', 'IT'),
    ('195.129.067.000', 'BE'),
    ('195.129.068.000', 'GB'),
    ('195.129.070.000', 'EU'),
    ('195.129.074.000', 'CH'),
    ('195.129.075.000', 'EU'),
    ('195.129.078.000', 'HU'),
    ('195.129.080.000', 'IE'),
    ('195.129.081.000', 'EU'),
    ('195.129.088.000', 'IT'),
    ('195.129.090.000', 'EU'),
    ('195.129.118.000', 'CH'),
    ('195.129.119.000', 'EU'),
    ('195.130.000.000', 'GB'),
    ('195.130.032.000', 'BA'),
    ('195.130.064.000', 'GR'),
    ('195.130.128.000', 'BE'),
    ('195.130.160.000', 'CH'),
    ('195.130.192.000', 'IT'),
    ('195.130.204.000', 'DE'),
    ('195.130.205.000', 'IT'),
    ('195.131.000.000', 'RU'),
    ('195.132.000.000', 'FR'),
    ('195.133.000.000', 'RU'),
    ('195.134.000.000', 'GB'),
    ('195.134.032.000', 'NO'),
    ('195.134.064.000', 'GR'),
    ('195.134.128.000', 'CH'),
    ('195.134.160.000', 'FR'),
    ('195.134.224.000', 'FI'),
    ('195.135.000.000', 'IT'),
    ('195.135.128.000', 'DE'),
    ('195.135.192.000', 'EU'),
    ('195.136.000.000', 'PL'),
    ('195.137.000.000', 'GB'),
    ('195.137.013.000', 'NG'),
    ('195.137.015.000', 'GB'),
    ('195.137.128.000', 'IT'),
    ('195.137.160.000', 'EU'),
    ('195.138.000.000', 'PT'),
    ('195.138.032.000', 'DE'),
    ('195.138.064.000', 'UA'),
    ('195.138.096.000', 'MD'),
    ('195.138.128.000', 'BG'),
    ('195.138.160.000', 'UA'),
    ('195.138.192.000', 'BE'),
    ('195.138.209.000', 'US'),
    ('195.138.210.000', 'BE'),
    ('195.138.223.000', 'AU'),
    ('195.138.224.000', 'GB'),
    ('195.139.000.000', 'NO'),
    ('195.140.000.000', 'DE'),
    ('195.140.128.000', 'EU'),
    ('195.141.000.000', 'CH'),
    ('195.141.139.000', 'LI'),
    ('195.141.140.000', 'CH'),
    ('195.141.238.000', 'LI'),
    ('195.141.240.000', 'CH'),
    ('195.142.000.000', 'TR'),
    ('195.143.000.000', 'DE'),
    ('195.144.000.000', 'GB'),
    ('195.144.032.000', 'CH'),
    ('195.144.064.000', 'BE'),
    ('195.144.096.000', 'CZ'),
    ('195.144.128.000', 'GB'),
    ('195.144.160.000', 'CH'),
    ('195.144.192.000', 'RU'),
    ('195.145.000.000', 'DE'),
    ('195.145.208.000', 'TM'),
    ('195.145.209.000', 'DE'),
    ('195.145.214.000', 'RU'),
    ('195.145.215.000', 'DE'),
    ('195.145.251.000', 'GE'),
    ('195.145.252.000', 'DE'),
    ('195.146.000.000', 'SK'),
    ('195.146.032.000', 'IR'),
    ('195.146.064.000', 'RU'),
    ('195.146.096.000', 'CZ'),
    ('195.146.128.000', 'SK'),
    ('195.146.160.000', 'GB'),
    ('195.146.192.000', 'FR'),
    ('195.146.210.000', 'BE'),
    ('195.146.211.000', 'FR'),
    ('195.146.212.000', 'BE'),
    ('195.146.213.000', 'FR'),
    ('195.146.214.000', 'BE'),
    ('195.146.215.000', 'FR'),
    ('195.146.217.000', 'BE'),
    ('195.146.218.000', 'FR'),
    ('195.146.220.000', 'BE'),
    ('195.146.221.000', 'FR'),
    ('195.146.222.000', 'BE'),
    ('195.146.224.000', 'FR'),
    ('195.147.000.000', 'GB'),
    ('195.148.000.000', 'FI'),
    ('195.149.000.000', 'GB'),
    ('195.149.064.000', 'EU'),
    ('195.149.128.000', 'SE'),
    ('195.149.192.000', 'EU'),
    ('195.150.000.000', 'PL'),
    ('195.151.000.000', 'RU'),
    ('195.151.026.000', 'KG'),
    ('195.151.027.000', 'RU'),
    ('195.151.052.000', 'BY'),
    ('195.151.053.000', 'RU'),
    ('195.151.070.000', 'UZ'),
    ('195.151.071.000', 'RU'),
    ('195.151.094.000', 'AM'),
    ('195.151.095.000', 'RU'),
    ('195.151.109.000', 'UZ'),
    ('195.151.110.000', 'RU'),
    ('195.152.000.000', 'GB'),
    ('195.154.000.000', 'FR'),
    ('195.154.196.000', 'US'),
    ('195.154.197.000', 'FR'),
    ('195.155.000.000', 'TR'),
    ('195.156.000.000', 'FI'),
    ('195.157.000.000', 'GB'),
    ('195.158.000.000', 'UZ'),
    ('195.158.032.000', 'DE'),
    ('195.158.064.000', 'MT'),
    ('195.158.128.000', 'DE'),
    ('195.158.192.000', 'JO'),
    ('195.158.224.000', 'US'),
    ('195.158.225.000', 'SE'),
    ('195.158.227.000', 'DK'),
    ('195.158.228.000', 'SE'),
    ('195.158.229.000', 'US'),
    ('195.158.230.000', 'BE'),
    ('195.158.232.000', 'GB'),
    ('195.158.233.000', 'BE'),
    ('195.158.234.000', 'NL'),
    ('195.158.235.000', 'DK'),
    ('195.158.236.000', 'DE'),
    ('195.158.237.000', 'CH'),
    ('195.158.238.000', 'FR'),
    ('195.158.239.000', 'DK'),
    ('195.158.241.000', 'IT'),
    ('195.158.242.000', 'DK'),
    ('195.158.244.000', 'DE'),
    ('195.158.245.000', 'AT'),
    ('195.158.246.000', 'CH'),
    ('195.158.247.000', 'SE'),
    ('195.158.248.000', 'DK'),
    ('195.158.252.000', 'BE'),
    ('195.158.253.000', 'DK'),
    ('195.158.254.000', 'BE'),
    ('195.158.255.000', 'DK'),
    ('195.159.000.000', 'NO'),
    ('195.160.000.000', 'CH'),
    ('195.160.160.000', 'EU'),
    ('195.161.000.000', 'RU'),
    ('195.162.000.000', 'DE'),
    ('195.162.032.000', 'RU'),
    ('195.162.064.000', 'SE'),
    ('195.162.096.000', 'GB'),
    ('195.162.128.000', 'CH'),
    ('195.162.192.000', 'BE'),
    ('195.162.224.000', 'DE'),
    ('195.163.000.000', 'SE'),
    ('195.163.182.000', 'FI'),
    ('195.163.186.000', 'SE'),
    ('195.164.000.000', 'PL'),
    ('195.165.000.000', 'FI'),
    ('195.165.076.000', 'NL'),
    ('195.165.077.000', 'FI'),
    ('195.165.179.000', 'RU'),
    ('195.165.180.000', 'FI'),
    ('195.166.000.000', 'GB'),
    ('195.166.064.000', 'DE'),
    ('195.166.065.000', 'GB'),
    ('195.166.099.000', 'CH'),
    ('195.166.100.000', 'GB'),
    ('195.166.112.000', 'SE'),
    ('195.166.113.000', 'DE'),
    ('195.166.114.000', 'IT'),
    ('195.166.115.000', 'EU'),
    ('195.166.117.000', 'US'),
    ('195.166.118.000', 'GB'),
    ('195.166.120.000', 'US'),
    ('195.166.121.000', 'GB'),
    ('195.166.122.000', 'DE'),
    ('195.166.123.000', 'GB'),
    ('195.166.160.000', 'RU'),
    ('195.166.192.000', 'GI'),
    ('195.166.224.000', 'NG'),
    ('195.167.000.000', 'GR'),
    ('195.167.128.000', 'GB'),
    ('195.167.217.000', 'DE'),
    ('195.167.220.000', 'GB'),
    ('195.168.000.000', 'SK'),
    ('195.169.000.000', 'NL'),
    ('195.170.000.000', 'GR'),
    ('195.170.032.000', 'RU'),
    ('195.170.064.000', 'AT'),
    ('195.170.096.000', 'DE'),
    ('195.170.128.000', 'FI'),
    ('195.170.160.000', 'DE'),
    ('195.170.192.000', 'RU'),
    ('195.171.000.000', 'GB'),
    ('195.171.032.000', 'EU'),
    ('195.171.036.000', 'BE'),
    ('195.171.037.000', 'EU'),
    ('195.171.039.000', 'BE'),
    ('195.171.040.000', 'GB'),
    ('195.171.044.000', 'EU'),
    ('195.171.046.000', 'IT'),
    ('195.171.047.000', 'EU'),
    ('195.171.057.000', 'IT'),
    ('195.171.058.000', 'EU'),
    ('195.171.063.000', 'FR'),
    ('195.171.064.000', 'GB'),
    ('195.171.084.000', 'BE'),
    ('195.171.085.000', 'EU'),
    ('195.171.086.000', 'BE'),
    ('195.171.087.000', 'EU'),
    ('195.171.096.000', 'GB'),
    ('195.171.100.000', 'EU'),
    ('195.171.104.000', 'GB'),
    ('195.171.108.000', 'EU'),
    ('195.171.110.000', 'GB'),
    ('195.174.000.000', 'TR'),
    ('195.176.000.000', 'CH'),
    ('195.177.000.000', 'DE'),
    ('195.177.064.000', 'EU'),
    ('195.177.128.000', 'DE'),
    ('195.177.192.000', 'EU'),
    ('195.178.000.000', 'DE'),
    ('195.178.032.000', 'YU'),
    ('195.178.064.000', 'CZ'),
    ('195.178.096.000', 'RU'),
    ('195.178.128.000', 'UA'),
    ('195.178.160.000', 'SE'),
    ('195.178.192.000', 'RU'),
    ('195.178.224.000', 'SE'),
    ('195.179.000.000', 'DE'),
    ('195.179.030.000', 'AT'),
    ('195.179.031.000', 'DE'),
    ('195.179.116.000', 'CH'),
    ('195.179.117.000', 'DE'),
    ('195.179.126.000', 'LI'),
    ('195.179.127.000', 'DE'),
    ('195.179.129.000', 'GB'),
    ('195.179.130.000', 'DE'),
    ('195.179.145.000', 'AT'),
    ('195.179.150.000', 'DE'),
    ('195.179.151.000', 'AT'),
    ('195.179.152.000', 'DE'),
    ('195.181.000.000', 'DK'),
    ('195.182.000.000', 'GB'),
    ('195.182.032.000', 'DE'),
    ('195.182.064.000', 'LT'),
    ('195.182.096.000', 'DE'),
    ('195.182.128.000', 'RU'),
    ('195.182.160.000', 'GB'),
    ('195.182.192.000', 'LV'),
    ('195.182.224.000', 'IT'),
    ('195.183.000.000', 'AT'),
    ('195.183.008.000', 'IT'),
    ('195.183.016.000', 'CH'),
    ('195.183.024.000', 'FR'),
    ('195.183.032.000', 'RU'),
    ('195.183.033.000', 'FR'),
    ('195.183.034.000', 'DE'),
    ('195.183.036.000', 'NL'),
    ('195.183.037.000', 'IT'),
    ('195.183.038.000', 'GB'),
    ('195.183.039.000', 'NO'),
    ('195.183.040.000', 'EU'),
    ('195.183.041.000', 'ZA'),
    ('195.183.042.000', 'BE'),
    ('195.183.043.000', 'EU'),
    ('195.183.044.000', 'GB'),
    ('195.183.048.000', 'DE'),
    ('195.183.049.000', 'GB'),
    ('195.183.064.000', 'PL'),
    ('195.183.065.000', 'NO'),
    ('195.183.066.000', 'GB'),
    ('195.183.084.000', 'HU'),
    ('195.183.085.000', 'GB'),
    ('195.183.096.000', 'DE'),
    ('195.183.128.000', 'ZA'),
    ('195.183.136.000', 'ES'),
    ('195.183.137.000', 'ZA'),
    ('195.183.138.000', 'ES'),
    ('195.183.139.000', 'IE'),
    ('195.183.140.000', 'ES'),
    ('195.183.142.000', 'FR'),
    ('195.183.143.000', 'DE'),
    ('195.183.144.000', 'NL'),
    ('195.183.148.000', 'BE'),
    ('195.183.152.000', 'DK'),
    ('195.183.156.000', 'SE'),
    ('195.183.160.000', 'DE'),
    ('195.183.164.000', 'CH'),
    ('195.183.168.000', 'IT'),
    ('195.183.176.000', 'DE'),
    ('195.183.180.000', 'GB'),
    ('195.183.192.000', 'SE'),
    ('195.183.193.000', 'IE'),
    ('195.183.194.000', 'ZA'),
    ('195.183.198.000', 'AT'),
    ('195.183.202.000', 'ZA'),
    ('195.183.206.000', 'CH'),
    ('195.183.208.000', 'GB'),
    ('195.183.216.000', 'DE'),
    ('195.183.221.000', 'BE'),
    ('195.183.228.000', 'DE'),
    ('195.183.241.000', 'IT'),
    ('195.183.248.000', 'CH'),
    ('195.184.000.000', 'HU'),
    ('195.184.032.000', 'DK'),
    ('195.184.064.000', 'GB'),
    ('195.184.096.000', 'DK'),
    ('195.184.128.000', 'BE'),
    ('195.184.130.000', 'GB'),
    ('195.184.132.000', 'DE'),
    ('195.184.133.000', 'FR'),
    ('195.184.134.000', 'DE'),
    ('195.184.136.000', 'SE'),
    ('195.184.138.000', 'IT'),
    ('195.184.139.000', 'AT'),
    ('195.184.141.000', 'NL'),
    ('195.184.142.000', 'GB'),
    ('195.184.143.000', 'IT'),
    ('195.184.144.000', 'NO'),
    ('195.184.145.000', 'BE'),
    ('195.184.146.000', 'AT'),
    ('195.184.148.000', 'FR'),
    ('195.184.149.000', 'SE'),
    ('195.184.150.000', 'DE'),
    ('195.184.151.000', 'CH'),
    ('195.184.152.000', 'DK'),
    ('195.184.153.000', 'AT'),
    ('195.184.154.000', 'DE'),
    ('195.184.155.000', 'FR'),
    ('195.184.156.000', 'ES'),
    ('195.184.157.000', 'ZA'),
    ('195.184.158.000', 'IE'),
    ('195.184.159.000', 'ES'),
    ('195.184.160.000', 'HU'),
    ('195.184.192.000', 'UA'),
    ('195.184.224.000', 'GB'),
    ('195.185.000.000', 'DE'),
    ('195.185.081.000', 'AT'),
    ('195.185.084.000', 'DE'),
    ('195.185.156.000', 'LU'),
    ('195.185.157.000', 'DE'),
    ('195.185.183.000', 'LU'),
    ('195.185.184.000', 'DE'),
    ('195.185.187.000', 'US'),
    ('195.185.188.000', 'DE'),
    ('195.186.000.000', 'CH'),
    ('195.187.000.000', 'PL'),
    ('195.188.000.000', 'GB'),
    ('195.189.000.000', 'DE'),
    ('195.190.032.000', 'GR'),
    ('195.190.064.000', 'DE'),
    ('195.190.096.000', 'RU'),
    ('195.190.128.000', 'EU'),
    ('195.190.160.000', 'CH'),
    ('195.190.192.000', 'SE'),
    ('195.190.224.000', 'NL'),
    ('195.191.000.000', 'IT'),
    ('195.192.000.000', 'DK'),
    ('195.193.000.000', 'NL'),
    ('195.194.000.000', 'GB'),
    ('195.196.000.000', 'SE'),
    ('195.197.000.000', 'FI'),
    ('195.197.232.000', 'EE'),
    ('195.197.240.000', 'FI'),
    ('195.198.000.000', 'SE'),
    ('195.199.000.000', 'HU'),
    ('195.200.000.000', 'GB'),
    ('195.200.032.000', 'DE'),
    ('195.200.064.000', 'GR'),
    ('195.200.096.000', 'FR'),
    ('195.200.128.000', 'GB'),
    ('195.200.160.000', 'FR'),
    ('195.200.192.000', 'RU'),
    ('195.200.224.000', 'CA'),
    ('195.200.225.000', 'IR'),
    ('195.200.231.000', 'CA'),
    ('195.200.233.000', 'EU'),
    ('195.201.000.000', 'RU'),
    ('195.202.000.000', 'FR'),
    ('195.202.032.000', 'DE'),
    ('195.202.064.000', 'KE'),
    ('195.202.096.000', 'DE'),
    ('195.202.128.000', 'AT'),
    ('195.202.192.000', 'CH'),
    ('195.203.000.000', 'DE'),
    ('195.203.011.000', 'FR'),
    ('195.203.012.000', 'EU'),
    ('195.203.025.000', 'DE'),
    ('195.203.031.000', 'FR'),
    ('195.203.033.000', 'DE'),
    ('195.203.034.000', 'IT'),
    ('195.203.035.000', 'DE'),
    ('195.203.047.000', 'IT'),
    ('195.203.049.000', 'DE'),
    ('195.203.056.000', 'EU'),
    ('195.203.069.000', 'DE'),
    ('195.204.000.000', 'NO'),
    ('195.204.013.000', 'SE'),
    ('195.204.014.000', 'NO'),
    ('195.204.019.000', 'SE'),
    ('195.204.020.000', 'NO'),
    ('195.205.000.000', 'PL'),
    ('195.206.000.000', 'IT'),
    ('195.206.032.000', 'RU'),
    ('195.206.064.000', 'NL'),
    ('195.206.074.000', 'GR'),
    ('195.206.075.000', 'NL'),
    ('195.206.085.000', 'EU'),
    ('195.206.086.000', 'DE'),
    ('195.206.087.000', 'NL'),
    ('195.206.096.000', 'AT'),
    ('195.206.104.000', 'LU'),
    ('195.206.108.000', 'SE'),
    ('195.206.109.000', 'EU'),
    ('195.206.128.000', 'DE'),
    ('195.206.152.000', 'CH'),
    ('195.206.153.000', 'DE'),
    ('195.206.160.000', 'GB'),
    ('195.206.224.000', 'UA'),
    ('195.207.000.000', 'BE'),
    ('195.208.000.000', 'BY'),
    ('195.208.008.000', 'RU'),
    ('195.210.000.000', 'CH'),
    ('195.210.032.000', 'GB'),
    ('195.210.064.000', 'IT'),
    ('195.210.128.000', 'RU'),
    ('195.210.192.000', 'SI'),
    ('195.211.000.000', 'DE'),
    ('195.212.000.000', 'GB'),
    ('195.212.009.000', 'EU'),
    ('195.212.010.000', 'GB'),
    ('195.212.016.000', 'EU'),
    ('195.212.018.000', 'DE'),
    ('195.212.023.000', 'DK'),
    ('195.212.024.000', 'GB'),
    ('195.212.025.000', 'EU'),
    ('195.212.026.000', 'GB'),
    ('195.212.027.000', 'IT'),
    ('195.212.028.000', 'GB'),
    ('195.212.032.000', 'EU'),
    ('195.212.033.000', 'DK'),
    ('195.212.035.000', 'NO'),
    ('195.212.036.000', 'FI'),
    ('195.212.038.000', 'DK'),
    ('195.212.040.000', 'NL'),
    ('195.212.043.000', 'EU'),
    ('195.212.044.000', 'DE'),
    ('195.212.047.000', 'AT'),
    ('195.212.048.000', 'LU'),
    ('195.212.049.000', 'BE'),
    ('195.212.056.000', 'DK'),
    ('195.212.057.000', 'EU'),
    ('195.212.058.000', 'DE'),
    ('195.212.061.000', 'EU'),
    ('195.212.062.000', 'AT'),
    ('195.212.063.000', 'EU'),
    ('195.212.064.000', 'DE'),
    ('195.212.083.000', 'EU'),
    ('195.212.084.000', 'DE'),
    ('195.212.088.000', 'EU'),
    ('195.212.090.000', 'DE'),
    ('195.212.094.000', 'EU'),
    ('195.212.095.000', 'DE'),
    ('195.212.096.000', 'AT'),
    ('195.212.100.000', 'DE'),
    ('195.212.101.000', 'EU'),
    ('195.212.102.000', 'AT'),
    ('195.212.103.000', 'IT'),
    ('195.212.104.000', 'FR'),
    ('195.212.107.000', 'EU'),
    ('195.212.108.000', 'FR'),
    ('195.212.109.000', 'EU'),
    ('195.212.110.000', 'FR'),
    ('195.212.112.000', 'CH'),
    ('195.212.114.000', 'EU'),
    ('195.212.115.000', 'CH'),
    ('195.212.120.000', 'IT'),
    ('195.212.121.000', 'CH'),
    ('195.212.122.000', 'FR'),
    ('195.212.123.000', 'EU'),
    ('195.212.124.000', 'CH'),
    ('195.212.128.000', 'EU'),
    ('195.212.134.000', 'SK'),
    ('195.212.135.000', 'EU'),
    ('195.212.136.000', 'SK'),
    ('195.212.137.000', 'EU'),
    ('195.212.138.000', 'SK'),
    ('195.212.139.000', 'EU'),
    ('195.212.140.000', 'IT'),
    ('195.212.142.000', 'HU'),
    ('195.212.143.000', 'NL'),
    ('195.212.146.000', 'EU'),
    ('195.212.154.000', 'RU'),
    ('195.212.156.000', 'EU'),
    ('195.212.157.000', 'RU'),
    ('195.212.158.000', 'EU'),
    ('195.212.159.000', 'RU'),
    ('195.212.160.000', 'EU'),
    ('195.212.162.000', 'FR'),
    ('195.212.163.000', 'GB'),
    ('195.212.164.000', 'ES'),
    ('195.212.169.000', 'EU'),
    ('195.212.170.000', 'IT'),
    ('195.212.172.000', 'ES'),
    ('195.212.176.000', 'DE'),
    ('195.212.178.000', 'ES'),
    ('195.212.179.000', 'DE'),
    ('195.212.181.000', 'EU'),
    ('195.212.182.000', 'DE'),
    ('195.212.185.000', 'IT'),
    ('195.212.186.000', 'DE'),
    ('195.212.187.000', 'CH'),
    ('195.212.188.000', 'EU'),
    ('195.212.190.000', 'FR'),
    ('195.212.191.000', 'DE'),
    ('195.212.192.000', 'CZ'),
    ('195.212.193.000', 'EU'),
    ('195.212.194.000', 'GB'),
    ('195.212.196.000', 'DK'),
    ('195.212.197.000', 'EU'),
    ('195.212.198.000', 'CZ'),
    ('195.212.202.000', 'CY'),
    ('195.212.203.000', 'CZ'),
    ('195.212.206.000', 'EU'),
    ('195.212.210.000', 'CZ'),
    ('195.212.211.000', 'EU'),
    ('195.212.212.000', 'CZ'),
    ('195.212.214.000', 'EU'),
    ('195.212.216.000', 'CZ'),
    ('195.212.217.000', 'EU'),
    ('195.212.222.000', 'CZ'),
    ('195.212.224.000', 'EU'),
    ('195.212.225.000', 'DE'),
    ('195.212.226.000', 'RU'),
    ('195.212.227.000', 'PT'),
    ('195.212.228.000', 'SE'),
    ('195.212.229.000', 'EU'),
    ('195.212.230.000', 'TR'),
    ('195.212.231.000', 'EU'),
    ('195.212.232.000', 'ES'),
    ('195.212.240.000', 'GR'),
    ('195.212.243.000', 'EU'),
    ('195.212.245.000', 'GR'),
    ('195.212.248.000', 'ES'),
    ('195.212.252.000', 'AT'),
    ('195.212.254.000', 'GR'),
    ('195.212.255.000', 'EU'),
    ('195.213.000.000', 'DK'),
    ('195.213.001.000', 'NO'),
    ('195.213.002.000', 'GB'),
    ('195.213.008.000', 'NL'),
    ('195.213.009.000', 'CH'),
    ('195.213.010.000', 'AT'),
    ('195.213.011.000', 'FR'),
    ('195.213.012.000', 'DE'),
    ('195.213.013.000', 'GB'),
    ('195.213.015.000', 'NL'),
    ('195.213.016.000', 'GB'),
    ('195.213.017.000', 'NL'),
    ('195.213.018.000', 'AT'),
    ('195.213.020.000', 'BE'),
    ('195.213.021.000', 'AT'),
    ('195.213.023.000', 'GB'),
    ('195.213.027.000', 'ZA'),
    ('195.213.028.000', 'FR'),
    ('195.213.029.000', 'CH'),
    ('195.213.030.000', 'GB'),
    ('195.213.032.000', 'DK'),
    ('195.213.033.000', 'GB'),
    ('195.213.034.000', 'AT'),
    ('195.213.035.000', 'CH'),
    ('195.213.036.000', 'AT'),
    ('195.213.037.000', 'BE'),
    ('195.213.038.000', 'IL'),
    ('195.213.039.000', 'BE'),
    ('195.213.040.000', 'ES'),
    ('195.213.041.000', 'CH'),
    ('195.213.042.000', 'GB'),
    ('195.213.043.000', 'AT'),
    ('195.213.044.000', 'IL'),
    ('195.213.045.000', 'IE'),
    ('195.213.046.000', 'AT'),
    ('195.213.047.000', 'DE'),
    ('195.213.048.000', 'BE'),
    ('195.213.052.000', 'NO'),
    ('195.213.053.000', 'LU'),
    ('195.213.054.000', 'AT'),
    ('195.213.055.000', 'BE'),
    ('195.213.056.000', 'AT'),
    ('195.213.057.000', 'CH'),
    ('195.213.058.000', 'BE'),
    ('195.213.061.000', 'GB'),
    ('195.213.062.000', 'BE'),
    ('195.213.063.000', 'IT'),
    ('195.213.067.000', 'GB'),
    ('195.213.068.000', 'IT'),
    ('195.213.069.000', 'IL'),
    ('195.213.070.000', 'PT'),
    ('195.213.071.000', 'NL'),
    ('195.213.072.000', 'GB'),
    ('195.213.073.000', 'IT'),
    ('195.213.074.000', 'NO'),
    ('195.213.076.000', 'AT'),
    ('195.213.077.000', 'GB'),
    ('195.213.079.000', 'LU'),
    ('195.213.080.000', 'DK'),
    ('195.213.081.000', 'IL'),
    ('195.213.082.000', 'AT'),
    ('195.213.083.000', 'RU'),
    ('195.213.084.000', 'NL'),
    ('195.213.086.000', 'GB'),
    ('195.213.087.000', 'BE'),
    ('195.213.088.000', 'CH'),
    ('195.213.089.000', 'NL'),
    ('195.213.090.000', 'AT'),
    ('195.213.091.000', 'IE'),
    ('195.213.092.000', 'IT'),
    ('195.213.093.000', 'CH'),
    ('195.213.094.000', 'PT'),
    ('195.213.095.000', 'FR'),
    ('195.213.098.000', 'GB'),
    ('195.213.099.000', 'ES'),
    ('195.213.100.000', 'FR'),
    ('195.213.101.000', 'BE'),
    ('195.213.102.000', 'GB'),
    ('195.213.103.000', 'ZA'),
    ('195.213.104.000', 'IT'),
    ('195.213.105.000', 'NL'),
    ('195.213.106.000', 'SE'),
    ('195.213.107.000', 'AT'),
    ('195.213.109.000', 'IL'),
    ('195.213.110.000', 'FR'),
    ('195.213.112.000', 'GB'),
    ('195.213.114.000', 'US'),
    ('195.213.115.000', 'FI'),
    ('195.213.116.000', 'IT'),
    ('195.213.117.000', 'ZA'),
    ('195.213.118.000', 'NL'),
    ('195.213.119.000', 'DK'),
    ('195.213.120.000', 'AT'),
    ('195.213.121.000', 'LU'),
    ('195.213.122.000', 'NL'),
    ('195.213.123.000', 'CH'),
    ('195.213.124.000', 'FR'),
    ('195.213.125.000', 'DE'),
    ('195.213.126.000', 'FR'),
    ('195.213.127.000', 'IT'),
    ('195.213.128.000', 'DE'),
    ('195.213.132.000', 'AT'),
    ('195.213.133.000', 'GB'),
    ('195.213.134.000', 'FR'),
    ('195.213.135.000', 'IT'),
    ('195.213.136.000', 'DE'),
    ('195.213.137.000', 'BE'),
    ('195.213.138.000', 'GB'),
    ('195.213.139.000', 'BE'),
    ('195.213.140.000', 'DE'),
    ('195.213.142.000', 'AT'),
    ('195.213.143.000', 'DE'),
    ('195.213.147.000', 'CH'),
    ('195.213.148.000', 'AT'),
    ('195.213.150.000', 'DE'),
    ('195.213.151.000', 'LU'),
    ('195.213.152.000', 'AT'),
    ('195.213.154.000', 'LU'),
    ('195.213.155.000', 'IT'),
    ('195.213.156.000', 'AT'),
    ('195.213.157.000', 'DE'),
    ('195.213.158.000', 'CH'),
    ('195.213.159.000', 'GB'),
    ('195.213.160.000', 'NL'),
    ('195.213.164.000', 'BE'),
    ('195.213.165.000', 'NL'),
    ('195.213.166.000', 'GB'),
    ('195.213.167.000', 'AT'),
    ('195.213.168.000', 'SE'),
    ('195.213.170.000', 'IE'),
    ('195.213.171.000', 'SE'),
    ('195.213.173.000', 'DE'),
    ('195.213.174.000', 'SE'),
    ('195.213.176.000', 'GB'),
    ('195.213.177.000', 'NO'),
    ('195.213.178.000', 'AT'),
    ('195.213.179.000', 'NO'),
    ('195.213.180.000', 'FI'),
    ('195.213.184.000', 'AT'),
    ('195.213.185.000', 'CH'),
    ('195.213.186.000', 'SE'),
    ('195.213.187.000', 'GB'),
    ('195.213.188.000', 'CH'),
    ('195.213.190.000', 'FR'),
    ('195.213.191.000', 'NL'),
    ('195.213.192.000', 'GB'),
    ('195.213.194.000', 'FR'),
    ('195.213.195.000', 'RU'),
    ('195.213.197.000', 'AT'),
    ('195.213.198.000', 'GB'),
    ('195.213.199.000', 'PT'),
    ('195.213.200.000', 'NL'),
    ('195.213.204.000', 'DE'),
    ('195.213.206.000', 'AT'),
    ('195.213.208.000', 'DE'),
    ('195.213.209.000', 'FI'),
    ('195.213.210.000', 'FR'),
    ('195.213.211.000', 'BE'),
    ('195.213.212.000', 'SE'),
    ('195.213.213.000', 'IT'),
    ('195.213.214.000', 'DE'),
    ('195.213.215.000', 'FI'),
    ('195.213.216.000', 'FR'),
    ('195.213.217.000', 'AT'),
    ('195.213.218.000', 'DE'),
    ('195.213.219.000', 'IR'),
    ('195.213.220.000', 'DK'),
    ('195.213.221.000', 'IT'),
    ('195.213.222.000', 'SE'),
    ('195.213.223.000', 'AT'),
    ('195.213.224.000', 'NL'),
    ('195.213.225.000', 'IL'),
    ('195.213.226.000', 'RU'),
    ('195.213.227.000', 'IL'),
    ('195.213.228.000', 'GB'),
    ('195.213.230.000', 'ES'),
    ('195.213.231.000', 'IL'),
    ('195.213.232.000', 'AT'),
    ('195.213.233.000', 'DK'),
    ('195.213.234.000', 'AT'),
    ('195.213.235.000', 'CZ'),
    ('195.213.236.000', 'HU'),
    ('195.213.237.000', 'AT'),
    ('195.213.238.000', 'ZA'),
    ('195.213.239.000', 'IT'),
    ('195.213.240.000', 'AT'),
    ('195.213.241.000', 'IT'),
    ('195.213.242.000', 'AT'),
    ('195.213.243.000', 'DE'),
    ('195.213.244.000', 'AT'),
    ('195.213.245.000', 'ES'),
    ('195.213.247.000', 'FR'),
    ('195.213.248.000', 'US'),
    ('195.213.249.000', 'HU'),
    ('195.213.250.000', 'DE'),
    ('195.213.251.000', 'NL'),
    ('195.213.252.000', 'SE'),
    ('195.213.253.000', 'AT'),
    ('195.213.255.000', 'FR'),
    ('195.214.000.000', 'DE'),
    ('195.214.052.000', 'CZ'),
    ('195.214.053.000', 'US'),
    ('195.214.054.000', 'DE'),
    ('195.214.056.000', 'US'),
    ('195.214.057.000', 'DE'),
    ('195.214.060.000', 'US'),
    ('195.214.061.000', 'DE'),
    ('195.214.096.000', 'GB'),
    ('195.214.128.000', 'TR'),
    ('195.214.192.000', 'EU'),
    ('195.215.000.000', 'DK'),
    ('195.216.000.000', 'GB'),
    ('195.216.032.000', 'SE'),
    ('195.216.064.000', 'CH'),
    ('195.216.096.000', 'PL'),
    ('195.216.128.000', 'IT'),
    ('195.216.160.000', 'LV'),
    ('195.216.192.000', 'DK'),
    ('195.216.224.000', 'IT'),
    ('195.217.000.000', 'GB'),
    ('195.218.000.000', 'LU'),
    ('195.218.032.000', 'GB'),
    ('195.218.064.000', 'FI'),
    ('195.218.096.000', 'IE'),
    ('195.218.105.000', 'GB'),
    ('195.218.106.000', 'IE'),
    ('195.218.128.000', 'RU'),
    ('195.218.134.000', 'AZ'),
    ('195.218.135.000', 'RU'),
    ('195.218.172.000', 'AZ'),
    ('195.218.173.000', 'RU'),
    ('195.218.179.000', 'AZ'),
    ('195.218.180.000', 'RU'),
    ('195.219.000.000', 'GB'),
    ('195.219.005.000', 'CZ'),
    ('195.219.006.000', 'GB'),
    ('195.219.013.000', 'ES'),
    ('195.219.014.000', 'GB'),
    ('195.219.016.000', 'PR'),
    ('195.219.017.000', 'FR'),
    ('195.219.018.000', 'CZ'),
    ('195.219.019.000', 'DE'),
    ('195.219.020.000', 'FR'),
    ('195.219.023.000', 'NO'),
    ('195.219.024.000', 'GB'),
    ('195.219.025.000', 'ES'),
    ('195.219.026.000', 'GB'),
    ('195.219.027.000', 'IT'),
    ('195.219.028.000', 'EU'),
    ('195.219.029.000', 'PK'),
    ('195.219.030.000', 'GB'),
    ('195.219.032.000', 'FR'),
    ('195.219.035.000', 'EU'),
    ('195.219.036.000', 'FR'),
    ('195.219.038.000', 'DE'),
    ('195.219.039.000', 'FR'),
    ('195.219.040.000', 'EU'),
    ('195.219.041.000', 'DE'),
    ('195.219.042.000', 'FR'),
    ('195.219.048.000', 'GB'),
    ('195.219.049.000', 'IR'),
    ('195.219.050.000', 'FR'),
    ('195.219.055.000', 'ES'),
    ('195.219.056.000', 'EU'),
    ('195.219.057.000', 'FR'),
    ('195.219.059.000', 'RO'),
    ('195.219.060.000', 'FR'),
    ('195.219.063.000', 'IT'),
    ('195.219.064.000', 'DE'),
    ('195.219.065.000', 'AT'),
    ('195.219.066.000', 'NL'),
    ('195.219.067.000', 'FR'),
    ('195.219.068.000', 'DE'),
    ('195.219.072.000', 'PL'),
    ('195.219.073.000', 'PK'),
    ('195.219.074.000', 'CH'),
    ('195.219.075.000', 'PH'),
    ('195.219.076.000', 'EU'),
    ('195.219.077.000', 'CH'),
    ('195.219.078.000', 'US'),
    ('195.219.079.000', 'IR'),
    ('195.219.080.000', 'NL'),
    ('195.219.081.000', 'DE'),
    ('195.219.082.000', 'IR'),
    ('195.219.083.000', 'DE'),
    ('195.219.084.000', 'IT'),
    ('195.219.085.000', 'ES'),
    ('195.219.086.000', 'EG'),
    ('195.219.088.000', 'SE'),
    ('195.219.089.000', 'IT'),
    ('195.219.090.000', 'NO'),
    ('195.219.091.000', 'IT'),
    ('195.219.092.000', 'DK'),
    ('195.219.093.000', 'ES'),
    ('195.219.094.000', 'DK'),
    ('195.219.095.000', 'ES'),
    ('195.219.096.000', 'GB'),
    ('195.219.099.000', 'EU'),
    ('195.219.100.000', 'ES'),
    ('195.219.101.000', 'GB'),
    ('195.219.102.000', 'DK'),
    ('195.219.103.000', 'US'),
    ('195.219.104.000', 'IT'),
    ('195.219.107.000', 'SD'),
    ('195.219.108.000', 'IT'),
    ('195.219.109.000', 'GB'),
    ('195.219.110.000', 'SD'),
    ('195.219.112.000', 'ES'),
    ('195.219.114.000', 'IT'),
    ('195.219.115.000', 'ES'),
    ('195.219.116.000', 'IT'),
    ('195.219.118.000', 'ES'),
    ('195.219.122.000', 'IT'),
    ('195.219.124.000', 'SD'),
    ('195.219.125.000', 'IT'),
    ('195.219.128.000', 'IR'),
    ('195.219.129.000', 'CZ'),
    ('195.219.130.000', 'ES'),
    ('195.219.131.000', 'DE'),
    ('195.219.132.000', 'ES'),
    ('195.219.136.000', 'US'),
    ('195.219.138.000', 'DK'),
    ('195.219.142.000', 'NL'),
    ('195.219.143.000', 'ES'),
    ('195.219.144.000', 'DE'),
    ('195.219.145.000', 'FR'),
    ('195.219.147.000', 'IR'),
    ('195.219.148.000', 'DE'),
    ('195.219.150.000', 'IT'),
    ('195.219.151.000', 'ES'),
    ('195.219.153.000', 'FR'),
    ('195.219.154.000', 'ML'),
    ('195.219.155.000', 'DK'),
    ('195.219.156.000', 'US'),
    ('195.219.157.000', 'ES'),
    ('195.219.158.000', 'GB'),
    ('195.219.160.000', 'PK'),
    ('195.219.164.000', 'GB'),
    ('195.219.165.000', 'DK'),
    ('195.219.166.000', 'NO'),
    ('195.219.168.000', 'NP'),
    ('195.219.169.000', 'DE'),
    ('195.219.170.000', 'RU'),
    ('195.219.171.000', 'DK'),
    ('195.219.172.000', 'CH'),
    ('195.219.176.000', 'IR'),
    ('195.219.177.000', 'FR'),
    ('195.219.179.000', 'DE'),
    ('195.219.184.000', 'IT'),
    ('195.219.185.000', 'EU'),
    ('195.219.186.000', 'DE'),
    ('195.219.188.000', 'EU'),
    ('195.220.000.000', 'FR'),
    ('195.222.000.000', 'EE'),
    ('195.222.032.000', 'BA'),
    ('195.222.064.000', 'BY'),
    ('195.222.088.000', 'SE'),
    ('195.222.096.000', 'DE'),
    ('195.222.128.000', 'RU'),
    ('195.222.192.000', 'DE'),
    ('195.223.000.000', 'IT'),
    ('195.224.000.000', 'GB'),
    ('195.224.025.000', 'US'),
    ('195.224.026.000', 'GB'),
    ('195.224.034.000', 'US'),
    ('195.224.035.000', 'GB'),
    ('195.224.062.000', 'US'),
    ('195.224.063.000', 'GB'),
    ('195.224.165.000', 'US'),
    ('195.224.166.000', 'GB'),
    ('195.224.206.000', 'US'),
    ('195.224.207.000', 'GB'),
    ('195.225.000.000', 'NO'),
    ('195.225.032.000', 'EU'),
    ('195.226.000.000', 'CH'),
    ('195.226.032.000', 'GB'),
    ('195.226.064.000', 'DE'),
    ('195.226.128.000', 'GB'),
    ('195.226.160.000', 'DE'),
    ('195.226.192.000', 'IT'),
    ('195.226.224.000', 'KW'),
    ('195.227.000.000', 'DE'),
    ('195.228.000.000', 'HU'),
    ('195.229.000.000', 'AE'),
    ('195.229.005.000', 'TZ'),
    ('195.229.006.000', 'IR'),
    ('195.229.008.000', 'TZ'),
    ('195.229.009.000', 'SO'),
    ('195.229.011.000', 'TZ'),
    ('195.229.012.000', 'PK'),
    ('195.229.015.000', 'AE'),
    ('195.230.000.000', 'BG'),
    ('195.230.032.000', 'AT'),
    ('195.230.064.000', 'RU'),
    ('195.230.096.000', 'CH'),
    ('195.230.128.000', 'UA'),
    ('195.230.160.000', 'AT'),
    ('195.230.192.000', 'IT'),
    ('195.231.000.000', 'DK'),
    ('195.232.000.000', 'DE'),
    ('195.232.001.000', 'GB'),
    ('195.232.032.000', 'DE'),
    ('195.232.033.000', 'GB'),
    ('195.232.048.000', 'DE'),
    ('195.232.064.000', 'FR'),
    ('195.232.080.000', 'GB'),
    ('195.232.081.000', 'DE'),
    ('195.232.082.000', 'GB'),
    ('195.232.090.000', 'CH'),
    ('195.232.091.000', 'DE'),
    ('195.232.092.000', 'GB'),
    ('195.232.100.000', 'FR'),
    ('195.232.101.000', 'DE'),
    ('195.232.102.000', 'GB'),
    ('195.232.104.000', 'DE'),
    ('195.232.105.000', 'FR'),
    ('195.232.106.000', 'GB'),
    ('195.232.108.000', 'DE'),
    ('195.232.110.000', 'FR'),
    ('195.232.112.000', 'GB'),
    ('195.232.114.000', 'DE'),
    ('195.232.118.000', 'AT'),
    ('195.232.119.000', 'GB'),
    ('195.232.128.000', 'DE'),
    ('195.234.000.000', 'DK'),
    ('195.234.032.000', 'EU'),
    ('195.235.000.000', 'ES'),
    ('195.236.000.000', 'FI'),
    ('195.238.000.000', 'BE'),
    ('195.238.032.000', 'DE'),
    ('195.238.064.000', 'UA'),
    ('195.238.096.000', 'GB'),
    ('195.238.128.000', 'DE'),
    ('195.238.160.000', 'GB'),
    ('195.238.192.000', 'FI'),
    ('195.238.224.000', 'DE'),
    ('195.239.000.000', 'RU'),
    ('195.240.000.000', 'NL'),
    ('195.242.000.000', 'RU'),
    ('195.242.032.000', 'SE'),
    ('195.242.064.000', 'FR'),
    ('195.242.128.000', 'GR'),
    ('195.242.160.000', 'FR'),
    ('195.242.192.000', 'FI'),
    ('195.242.224.000', 'EU'),
    ('195.243.000.000', 'DE'),
    ('195.244.000.000', 'NL'),
    ('195.244.032.000', 'TR'),
    ('195.244.064.000', 'FI'),
    ('195.244.096.000', 'DE'),
    ('195.244.128.000', 'LV'),
    ('195.244.160.000', 'BE'),
    ('195.244.192.000', 'GI'),
    ('195.244.224.000', 'DE'),
    ('195.245.064.000', 'EU'),
    ('195.245.128.000', 'PT'),
    ('195.245.192.000', 'EU'),
    ('195.246.000.000', 'SI'),
    ('195.246.032.000', 'EG'),
    ('195.246.064.000', 'CH'),
    ('195.246.096.000', 'GB'),
    ('195.246.128.000', 'FR'),
    ('195.246.160.000', 'DE'),
    ('195.246.192.000', 'IT'),
    ('195.246.197.000', 'SE'),
    ('195.246.198.000', 'DK'),
    ('195.246.199.000', 'UA'),
    ('195.246.200.000', 'PL'),
    ('195.246.201.000', 'GB'),
    ('195.246.202.000', 'DE'),
    ('195.246.208.000', 'IT'),
    ('195.246.216.000', 'DE'),
    ('195.246.220.000', 'IT'),
    ('195.246.224.000', 'ES'),
    ('195.247.000.000', 'DE'),
    ('195.247.001.000', '--'),
    ('195.247.002.000', 'BE'),
    ('195.247.006.000', 'DE'),
    ('195.247.007.000', 'BE'),
    ('195.247.008.000', 'DE'),
    ('195.247.010.000', 'BE'),
    ('195.247.012.000', 'DE'),
    ('195.247.013.000', 'BE'),
    ('195.247.016.000', 'DE'),
    ('195.247.017.000', 'BE'),
    ('195.247.024.000', 'DE'),
    ('195.247.025.000', 'BE'),
    ('195.247.028.000', 'DE'),
    ('195.247.029.000', 'BE'),
    ('195.247.032.000', 'DE'),
    ('195.247.034.000', 'BE'),
    ('195.247.048.000', 'DE'),
    ('195.247.050.000', '--'),
    ('195.247.051.000', 'BE'),
    ('195.247.052.000', 'DE'),
    ('195.247.053.000', 'BE'),
    ('195.247.054.000', '--'),
    ('195.247.055.000', 'BE'),
    ('195.247.056.000', 'DE'),
    ('195.247.058.000', 'BE'),
    ('195.247.061.000', 'DE'),
    ('195.247.062.000', 'BE'),
    ('195.247.064.000', 'DE'),
    ('195.247.065.000', 'BE'),
    ('195.247.130.000', 'DE'),
    ('195.247.132.000', 'BE'),
    ('195.247.133.000', '--'),
    ('195.247.134.000', 'DE'),
    ('195.247.135.000', 'BE'),
    ('195.247.145.000', 'DE'),
    ('195.247.146.000', 'BE'),
    ('195.247.160.000', 'DE'),
    ('195.247.162.000', 'BE'),
    ('195.247.165.000', 'DE'),
    ('195.247.166.000', 'BE'),
    ('195.247.167.000', 'DE'),
    ('195.247.169.000', 'BE'),
    ('195.247.172.000', 'DE'),
    ('195.247.173.000', 'BE'),
    ('195.247.192.000', 'DE'),
    ('195.247.198.000', 'BE'),
    ('195.247.208.000', 'DE'),
    ('195.247.210.000', '--'),
    ('195.247.211.000', 'DE'),
    ('195.247.214.000', 'BE'),
    ('195.247.224.000', 'DE'),
    ('195.247.230.000', 'BE'),
    ('195.247.232.000', 'DE'),
    ('195.247.233.000', 'BE'),
    ('195.247.234.000', 'DE'),
    ('195.247.236.000', 'BE'),
    ('195.247.237.000', 'DE'),
    ('195.247.240.000', '--'),
    ('195.247.241.000', 'DE'),
    ('195.247.242.000', 'BE'),
    ('195.247.243.000', '--'),
    ('195.247.244.000', 'BE'),
    ('195.247.246.000', '--'),
    ('195.247.247.000', 'DE'),
    ('195.247.253.000', 'BE'),
    ('195.247.254.000', 'DE'),
    ('195.247.255.000', 'BE'),
    ('195.248.000.000', 'FR'),
    ('195.248.032.000', 'AT'),
    ('195.248.064.000', 'JO'),
    ('195.248.096.000', 'GB'),
    ('195.248.128.000', 'DE'),
    ('195.248.160.000', 'UA'),
    ('195.248.192.000', 'GB'),
    ('195.248.193.000', 'FK'),
    ('195.248.194.000', 'GB'),
    ('195.249.000.000', 'DK'),
    ('195.250.000.000', 'IT'),
    ('195.250.032.000', 'GB'),
    ('195.250.064.000', 'AM'),
    ('195.250.096.000', 'YU'),
    ('195.250.128.000', 'CZ'),
    ('195.250.160.000', 'EE'),
    ('195.250.192.000', 'SI'),
    ('195.250.224.000', 'IT'),
    ('195.251.000.000', 'GR'),
    ('195.252.000.000', 'SE'),
    ('195.252.064.000', 'BA'),
    ('195.252.065.000', 'YU'),
    ('195.252.068.000', 'BA'),
    ('195.252.069.000', 'YU'),
    ('195.252.072.000', 'BA'),
    ('195.252.073.000', 'YU'),
    ('195.252.077.000', 'BA'),
    ('195.252.079.000', 'YU'),
    ('195.252.128.000', 'DE'),
    ('195.253.023.000', 'CH'),
    ('195.253.024.000', 'DE'),
    ('195.254.128.000', 'TR'),
    ('195.254.160.000', 'KG'),
    ('195.254.192.000', 'NO'),
    ('195.254.224.000', 'IT'),
    ('195.255.000.000', 'FI'),
    ('196.000.000.000', '--'),
    ('196.001.001.000', 'IN'),
    ('196.001.002.000', 'PR'),
    ('196.001.003.000', 'SA'),
    ('196.001.004.000', '--'),
    ('196.001.005.000', 'RU'),
    ('196.001.006.000', 'SA'),
    ('196.001.007.000', 'MU'),
    ('196.001.008.000', 'ZA'),
    ('196.001.064.000', 'SA'),
    ('196.001.068.000', 'IN'),
    ('196.001.069.000', 'KW'),
    ('196.001.071.000', 'NA'),
    ('196.001.072.000', 'US'),
    ('196.001.074.000', 'ZA'),
    ('196.001.092.000', 'SN'),
    ('196.001.101.000', 'ZA'),
    ('196.001.104.000', 'IN'),
    ('196.001.107.000', 'BM'),
    ('196.001.108.000', 'IN'),
    ('196.001.112.000', 'CU'),
    ('196.001.113.000', 'IN'),
    ('196.001.115.000', '--'),
    ('196.001.116.000', 'GN'),
    ('196.001.118.000', 'GH'),
    ('196.001.119.000', '--'),
    ('196.001.120.000', 'GN'),
    ('196.001.122.000', '--'),
    ('196.001.128.000', 'ZA'),
    ('196.001.130.000', 'BW'),
    ('196.001.134.000', 'IN'),
    ('196.001.135.000', 'CU'),
    ('196.001.136.000', 'JM'),
    ('196.001.141.000', 'PR'),
    ('196.001.142.000', 'JM'),
    ('196.001.143.000', '--'),
    ('196.001.160.000', 'VG'),
    ('196.001.161.000', 'VC'),
    ('196.001.162.000', 'BB'),
    ('196.001.168.000', 'KN'),
    ('196.001.169.000', 'VC'),
    ('196.001.170.000', 'VG'),
    ('196.001.171.000', 'BB'),
    ('196.001.176.000', '--'),
    ('196.002.000.000', 'JM'),
    ('196.002.002.000', '--'),
    ('196.002.004.000', 'SY'),
    ('196.002.008.000', '--'),
    ('196.002.016.000', 'ZA'),
    ('196.002.064.000', 'ZW'),
    ('196.002.096.000', '--'),
    ('196.002.128.000', 'ZA'),
    ('196.002.160.000', '--'),
    ('196.003.000.000', 'JM'),
    ('196.003.008.000', 'PR'),
    ('196.003.016.000', 'AN'),
    ('196.003.032.000', 'US'),
    ('196.003.052.000', 'IT'),
    ('196.003.053.000', 'US'),
    ('196.003.057.000', '--'),
    ('196.003.064.000', 'GB'),
    ('196.003.065.000', 'IN'),
    ('196.003.066.000', 'SA'),
    ('196.003.067.000', 'AE'),
    ('196.003.072.000', 'PK'),
    ('196.003.073.000', 'GD'),
    ('196.003.074.000', 'DO'),
    ('196.003.090.000', 'CM'),
    ('196.003.091.000', 'IR'),
    ('196.003.092.000', 'ZA'),
    ('196.003.094.000', 'NA'),
    ('196.003.095.000', 'JM'),
    ('196.003.096.000', 'MZ'),
    ('196.003.104.000', 'JM'),
    ('196.003.105.000', '--'),
    ('196.003.106.000', 'DO'),
    ('196.003.107.000', 'ZA'),
    ('196.003.109.000', 'MU'),
    ('196.003.110.000', 'ZA'),
    ('196.003.132.000', 'TT'),
    ('196.003.148.000', 'ZA'),
    ('196.003.152.000', 'CU'),
    ('196.003.153.000', 'JM'),
    ('196.003.154.000', 'ZA'),
    ('196.003.180.000', '--'),
    ('196.003.184.000', 'JM'),
    ('196.003.192.000', 'BB'),
    ('196.003.224.000', 'ZA'),
    ('196.004.050.000', 'GB'),
    ('196.004.051.000', 'ZA'),
    ('196.004.080.000', 'ZW'),
    ('196.004.081.000', 'ZA'),
    ('196.007.123.000', 'ZW'),
    ('196.007.124.000', 'ZA'),
    ('196.007.224.000', 'ZW'),
    ('196.007.225.000', 'ZA'),
    ('196.007.235.000', 'ZW'),
    ('196.007.236.000', 'ZA'),
    ('196.011.040.000', 'ZW'),
    ('196.011.041.000', 'ZA'),
    ('196.011.059.000', 'ZW'),
    ('196.011.060.000', 'NA'),
    ('196.011.061.000', 'ZA'),
    ('196.012.000.000', 'PR'),
    ('196.012.016.000', 'ZA'),
    ('196.012.032.000', 'IN'),
    ('196.012.064.000', 'BM'),
    ('196.012.128.000', '--'),
    ('196.012.160.000', 'PR'),
    ('196.012.163.000', 'US'),
    ('196.012.168.000', 'PR'),
    ('196.012.169.000', 'US'),
    ('196.012.175.000', 'PR'),
    ('196.012.187.000', 'US'),
    ('196.012.192.000', '--'),
    ('196.013.000.000', 'ZA'),
    ('196.013.168.000', 'SZ'),
    ('196.013.169.000', 'ZA'),
    ('196.015.008.000', '--'),
    ('196.015.016.000', 'IN'),
    ('196.015.032.000', 'SA'),
    ('196.015.064.000', 'ZA'),
    ('196.020.000.000', 'NA'),
    ('196.020.032.000', '--'),
    ('196.021.000.000', 'ZA'),
    ('196.022.064.000', 'GB'),
    ('196.022.080.000', 'SZ'),
    ('196.022.081.000', 'ZA'),
    ('196.024.000.000', 'LS'),
    ('196.024.004.000', 'ZA'),
    ('196.024.064.000', 'SZ'),
    ('196.024.068.000', 'ZA'),
    ('196.027.000.000', 'JO'),
    ('196.027.002.000', 'EG'),
    ('196.027.004.000', 'VE'),
    ('196.027.012.000', 'CL'),
    ('196.027.013.000', 'CA'),
    ('196.027.015.000', 'US'),
    ('196.027.018.000', 'CA'),
    ('196.027.019.000', 'US'),
    ('196.027.020.000', 'GH'),
    ('196.027.021.000', 'MU'),
    ('196.027.022.000', 'ET'),
    ('196.027.023.000', 'PR'),
    ('196.027.025.000', 'CO'),
    ('196.027.026.000', 'ES'),
    ('196.027.027.000', 'DO'),
    ('196.027.028.000', 'US'),
    ('196.027.030.000', 'MX'),
    ('196.027.031.000', 'US'),
    ('196.027.056.000', 'PE'),
    ('196.027.057.000', 'US'),
    ('196.027.064.000', '--'),
    ('196.028.000.000', 'ZA'),
    ('196.028.007.000', 'SZ'),
    ('196.028.008.000', 'ZA'),
    ('196.028.009.000', '--'),
    ('196.028.016.000', 'ZA'),
    ('196.028.048.000', 'US'),
    ('196.028.050.000', 'PR'),
    ('196.028.051.000', 'US'),
    ('196.028.062.000', 'PR'),
    ('196.028.064.000', 'ZA'),
    ('196.029.032.000', 'ZW'),
    ('196.029.040.000', '--'),
    ('196.029.064.000', 'TT'),
    ('196.029.096.000', '--'),
    ('196.029.128.000', 'ZA'),
    ('196.029.160.000', '--'),
    ('196.029.192.000', 'AO'),
    ('196.029.208.000', '--'),
    ('196.029.240.000', 'ZA'),
    ('196.032.000.000', 'JM'),
    ('196.032.008.000', '--'),
    ('196.032.032.000', 'TT'),
    ('196.032.064.000', 'AR'),
    ('196.032.096.000', '--'),
    ('196.032.128.000', 'PR'),
    ('196.032.150.000', 'DO'),
    ('196.032.151.000', 'PR'),
    ('196.032.160.000', '--'),
    ('196.033.000.000', 'ZA'),
    ('196.040.000.000', 'CR'),
    ('196.040.128.000', '--'),
    ('196.041.000.000', 'ZA'),
    ('196.041.032.000', 'TZ'),
    ('196.041.047.000', 'KE'),
    ('196.041.048.000', 'TZ'),
    ('196.041.064.000', 'ZA'),
    ('196.041.096.000', '--'),
    ('196.041.128.000', 'ZA'),
    ('196.042.000.000', 'PR'),
    ('196.042.064.000', '--'),
    ('196.043.000.000', 'ZA'),
    ('196.043.064.000', '--'),
    ('196.044.000.000', 'ZA'),
    ('196.044.128.000', 'NA'),
    ('196.044.144.000', '--'),
    ('196.044.160.000', 'TZ'),
    ('196.044.176.000', '--'),
    ('196.044.192.000', 'ZA'),
    ('196.045.000.000', '--'),
    ('196.087.008.000', 'TR'),
    ('196.087.009.000', '--'),
    ('196.106.035.000', 'FR'),
    ('196.106.036.000', '--'),
    ('196.215.096.000', 'DK'),
    ('196.215.097.000', '--'),
    ('196.216.001.000', 'US'),
    ('196.216.002.000', '--'),
    ('197.000.000.000', 'US'),
    ('197.162.099.000', 'GB'),
    ('197.162.100.000', 'US'),
    ('198.000.000.000', '--'),
    ('198.001.000.000', 'US'),
    ('198.001.064.000', '--'),
    ('198.002.000.000', 'US'),
    ('198.002.016.000', 'CL'),
    ('198.002.032.000', '--'),
    ('198.003.000.000', 'US'),
    ('198.004.064.000', 'GB'),
    ('198.004.066.000', 'US'),
    ('198.004.200.000', 'GB'),
    ('198.004.204.000', 'US'),
    ('198.006.225.000', 'GB'),
    ('198.006.226.000', 'US'),
    ('198.011.000.000', 'SA'),
    ('198.011.004.000', 'US'),
    ('198.011.008.000', '--'),
    ('198.011.016.000', 'US'),
    ('198.011.128.000', '--'),
    ('198.012.000.000', 'US'),
    ('198.012.032.000', 'BR'),
    ('198.012.064.000', '--'),
    ('198.013.000.000', 'US'),
    ('198.013.128.000', '--'),
    ('198.014.000.000', 'US'),
    ('198.015.016.000', 'AU'),
    ('198.015.064.000', '--'),
    ('198.016.000.000', 'US'),
    ('198.016.032.000', '--'),
    ('198.017.001.000', 'JP'),
    ('198.017.002.000', 'US'),
    ('198.017.003.000', '--'),
    ('198.017.005.000', 'US'),
    ('198.017.007.000', 'CN'),
    ('198.017.008.000', 'US'),
    ('198.017.042.000', '--'),
    ('198.017.043.000', 'CA'),
    ('198.017.044.000', 'US'),
    ('198.017.058.000', 'CA'),
    ('198.017.059.000', 'US'),
    ('198.017.060.000', '--'),
    ('198.017.062.000', 'US'),
    ('198.017.070.000', 'SG'),
    ('198.017.071.000', 'US'),
    ('198.017.077.000', 'GB'),
    ('198.017.078.000', 'US'),
    ('198.017.096.000', 'CA'),
    ('198.017.097.000', 'US'),
    ('198.017.106.000', 'AU'),
    ('198.017.107.000', 'US'),
    ('198.017.110.000', '--'),
    ('198.017.112.000', 'AU'),
    ('198.017.116.000', 'US'),
    ('198.017.117.000', 'IT'),
    ('198.017.118.000', 'JP'),
    ('198.017.119.000', '--'),
    ('198.017.120.000', 'BR'),
    ('198.017.122.000', 'US'),
    ('198.017.140.000', 'CA'),
    ('198.017.141.000', 'US'),
    ('198.017.180.000', 'NL'),
    ('198.017.183.000', 'US'),
    ('198.017.228.000', 'SG'),
    ('198.017.229.000', 'US'),
    ('198.017.231.000', 'BR'),
    ('198.017.233.000', '--'),
    ('198.017.234.000', 'US'),
    ('198.017.240.000', 'AU'),
    ('198.017.242.000', 'US'),
    ('198.020.000.000', '--'),
    ('198.020.008.000', 'CA'),
    ('198.020.016.000', 'US'),
    ('198.020.032.000', 'CA'),
    ('198.020.064.000', '--'),
    ('198.021.000.000', 'US'),
    ('198.021.128.000', '--'),
    ('198.022.001.000', 'US'),
    ('198.022.002.000', 'CA'),
    ('198.022.005.000', 'US'),
    ('198.022.034.000', 'AU'),
    ('198.022.035.000', 'TH'),
    ('198.022.036.000', '--'),
    ('198.022.037.000', 'NZ'),
    ('198.022.038.000', 'US'),
    ('198.022.046.000', '--'),
    ('198.022.047.000', 'AU'),
    ('198.022.051.000', 'DE'),
    ('198.022.052.000', 'US'),
    ('198.022.060.000', '--'),
    ('198.022.061.000', 'AU'),
    ('198.022.062.000', 'US'),
    ('198.022.071.000', 'GB'),
    ('198.022.072.000', 'US'),
    ('198.022.093.000', 'DE'),
    ('198.022.098.000', '--'),
    ('198.022.099.000', 'US'),
    ('198.022.102.000', 'CA'),
    ('198.022.103.000', 'US'),
    ('198.022.188.000', 'CA'),
    ('198.022.189.000', 'US'),
    ('198.022.237.000', 'CA'),
    ('198.022.238.000', 'US'),
    ('198.022.250.000', 'CL'),
    ('198.022.252.000', 'US'),
    ('198.023.064.000', '--'),
    ('198.024.000.000', 'US'),
    ('198.024.032.000', '--'),
    ('198.025.000.000', 'US'),
    ('198.025.218.000', 'DE'),
    ('198.025.219.000', 'US'),
    ('198.027.004.000', 'NZ'),
    ('198.027.009.000', '--'),
    ('198.027.016.000', 'US'),
    ('198.027.064.000', '--'),
    ('198.028.000.000', 'US'),
    ('198.033.000.000', 'CA'),
    ('198.035.000.000', 'US'),
    ('198.036.032.000', 'SA'),
    ('198.036.048.000', '--'),
    ('198.036.064.000', 'US'),
    ('198.038.000.000', 'CA'),
    ('198.038.004.000', 'US'),
    ('198.038.048.000', '--'),
    ('198.038.064.000', 'US'),
    ('198.038.080.000', '--'),
    ('198.038.128.000', 'US'),
    ('198.041.016.000', 'NZ'),
    ('198.041.032.000', 'CL'),
    ('198.041.048.000', '--'),
    ('198.041.064.000', 'US'),
    ('198.041.080.000', '--'),
    ('198.042.000.000', 'US'),
    ('198.042.004.000', 'CA'),
    ('198.042.005.000', 'US'),
    ('198.042.018.000', 'CA'),
    ('198.042.019.000', 'US'),
    ('198.042.022.000', 'CA'),
    ('198.042.023.000', 'US'),
    ('198.042.025.000', 'CA'),
    ('198.042.026.000', 'US'),
    ('198.042.036.000', 'CA'),
    ('198.042.037.000', 'US'),
    ('198.042.047.000', 'CA'),
    ('198.042.048.000', 'US'),
    ('198.042.055.000', 'CA'),
    ('198.042.056.000', 'US'),
    ('198.042.057.000', 'CA'),
    ('198.042.058.000', 'US'),
    ('198.042.073.000', 'CA'),
    ('198.042.074.000', 'US'),
    ('198.042.075.000', 'CA'),
    ('198.042.076.000', 'US'),
    ('198.042.081.000', 'CA'),
    ('198.042.082.000', 'US'),
    ('198.042.083.000', 'CA'),
    ('198.042.084.000', 'US'),
    ('198.042.090.000', 'CA'),
    ('198.042.091.000', 'US'),
    ('198.042.096.000', 'CA'),
    ('198.042.098.000', 'US'),
    ('198.042.106.000', 'CA'),
    ('198.042.107.000', 'US'),
    ('198.042.123.000', 'CA'),
    ('198.042.124.000', 'US'),
    ('198.042.131.000', 'CA'),
    ('198.042.133.000', 'US'),
    ('198.042.137.000', 'CA'),
    ('198.042.139.000', 'US'),
    ('198.042.144.000', 'CA'),
    ('198.042.145.000', 'US'),
    ('198.042.147.000', 'CA'),
    ('198.042.148.000', 'US'),
    ('198.042.149.000', 'CA'),
    ('198.042.151.000', 'US'),
    ('198.042.156.000', 'CA'),
    ('198.042.157.000', 'US'),
    ('198.042.161.000', 'CA'),
    ('198.042.162.000', 'US'),
    ('198.042.170.000', 'CA'),
    ('198.042.171.000', 'US'),
    ('198.042.176.000', 'CA'),
    ('198.042.177.000', 'US'),
    ('198.042.193.000', 'CA'),
    ('198.042.194.000', 'US'),
    ('198.042.202.000', 'CA'),
    ('198.042.203.000', 'US'),
    ('198.042.204.000', 'CA'),
    ('198.042.205.000', 'US'),
    ('198.042.206.000', 'CA'),
    ('198.042.207.000', 'US'),
    ('198.042.208.000', 'CA'),
    ('198.042.210.000', 'US'),
    ('198.042.212.000', 'CA'),
    ('198.042.216.000', 'US'),
    ('198.042.217.000', 'CA'),
    ('198.042.218.000', 'US'),
    ('198.042.224.000', 'CA'),
    ('198.042.226.000', 'US'),
    ('198.042.227.000', 'CA'),
    ('198.042.228.000', 'US'),
    ('198.042.234.000', 'CA'),
    ('198.042.238.000', 'US'),
    ('198.042.245.000', 'CA'),
    ('198.042.246.000', 'US'),
    ('198.042.254.000', 'CA'),
    ('198.042.255.000', 'US'),
    ('198.048.000.000', 'NZ'),
    ('198.048.004.000', 'US'),
    ('198.048.048.000', '--'),
    ('198.048.064.000', 'US'),
    ('198.048.096.000', '--'),
    ('198.049.001.000', 'US'),
    ('198.049.002.000', 'HK'),
    ('198.049.003.000', 'NZ'),
    ('198.049.004.000', 'US'),
    ('198.049.032.000', 'AU'),
    ('198.049.040.000', 'US'),
    ('198.049.048.000', '--'),
    ('198.049.080.000', 'US'),
    ('198.049.086.000', '--'),
    ('198.049.087.000', 'AU'),
    ('198.049.088.000', 'US'),
    ('198.049.112.000', 'TH'),
    ('198.049.114.000', 'US'),
    ('198.049.124.000', 'AU'),
    ('198.049.125.000', 'US'),
    ('198.049.128.000', 'BR'),
    ('198.049.134.000', 'US'),
    ('198.049.135.000', '--'),
    ('198.049.136.000', 'US'),
    ('198.049.138.000', '--'),
    ('198.049.141.000', 'CA'),
    ('198.049.142.000', 'US'),
    ('198.049.164.000', 'AR'),
    ('198.049.165.000', 'US'),
    ('198.049.175.000', 'CA'),
    ('198.049.176.000', 'US'),
    ('198.049.193.000', 'BE'),
    ('198.049.194.000', 'US'),
    ('198.049.229.000', 'GU'),
    ('198.049.230.000', 'US'),
    ('198.049.232.000', 'JP'),
    ('198.049.233.000', 'US'),
    ('198.049.240.000', 'JP'),
    ('198.049.241.000', 'US'),
    ('198.049.243.000', '--'),
    ('198.049.244.000', 'US'),
    ('198.050.016.000', 'BR'),
    ('198.050.024.000', '--'),
    ('198.050.032.000', 'US'),
    ('198.050.096.000', '--'),
    ('198.051.000.000', 'US'),
    ('198.051.004.000', 'AU'),
    ('198.051.008.000', 'US'),
    ('198.051.012.000', 'SA'),
    ('198.051.013.000', 'US'),
    ('198.051.071.000', 'CO'),
    ('198.051.072.000', 'US'),
    ('198.051.099.000', 'HK'),
    ('198.051.100.000', 'AU'),
    ('198.051.101.000', 'ID'),
    ('198.051.102.000', 'US'),
    ('198.051.104.000', '--'),
    ('198.051.108.000', 'US'),
    ('198.051.112.000', 'CA'),
    ('198.051.118.000', 'US'),
    ('198.051.132.000', '--'),
    ('198.051.140.000', 'US'),
    ('198.051.143.000', 'SY'),
    ('198.051.147.000', 'US'),
    ('198.051.151.000', 'CA'),
    ('198.051.152.000', 'US'),
    ('198.051.156.000', 'CA'),
    ('198.051.157.000', 'US'),
    ('198.051.158.000', '--'),
    ('198.051.159.000', 'US'),
    ('198.051.186.000', 'AU'),
    ('198.051.187.000', 'US'),
    ('198.051.195.000', 'NZ'),
    ('198.051.196.000', 'AU'),
    ('198.051.197.000', 'US'),
    ('198.051.210.000', 'AU'),
    ('198.051.212.000', 'US'),
    ('198.052.032.000', 'CA'),
    ('198.052.043.000', 'BB'),
    ('198.052.044.000', 'CA'),
    ('198.052.048.000', '--'),
    ('198.052.064.000', 'US'),
    ('198.052.096.000', '--'),
    ('198.053.000.000', 'CA'),
    ('198.054.000.000', 'ZA'),
    ('198.054.142.000', 'NA'),
    ('198.054.146.000', 'ZA'),
    ('198.055.000.000', 'US'),
    ('198.055.016.000', 'PR'),
    ('198.055.032.000', 'US'),
    ('198.055.048.000', '--'),
    ('198.055.064.000', 'US'),
    ('198.055.096.000', '--'),
    ('198.055.128.000', 'US'),
    ('198.056.016.000', 'PH'),
    ('198.056.032.000', 'US'),
    ('198.056.128.000', '--'),
    ('198.057.000.000', 'US'),
    ('198.057.064.000', 'CA'),
    ('198.057.080.000', '--'),
    ('198.058.000.000', 'JM'),
    ('198.058.002.000', 'US'),
    ('198.058.008.000', 'BR'),
    ('198.058.016.000', 'US'),
    ('198.058.040.000', '--'),
    ('198.058.064.000', 'US'),
    ('198.058.072.000', '--'),
    ('198.059.000.000', 'US'),
    ('198.061.000.000', 'NZ'),
    ('198.061.004.000', 'US'),
    ('198.061.008.000', 'AU'),
    ('198.061.016.000', 'US'),
    ('198.061.096.000', '--'),
    ('198.062.000.000', 'US'),
    ('198.062.016.000', 'CA'),
    ('198.062.032.000', 'US'),
    ('198.062.094.000', 'CA'),
    ('198.062.095.000', 'US'),
    ('198.062.112.000', 'CA'),
    ('198.062.113.000', 'US'),
    ('198.062.158.000', 'CA'),
    ('198.062.160.000', 'US'),
    ('198.062.175.000', 'CA'),
    ('198.062.176.000', 'US'),
    ('198.062.196.000', 'CA'),
    ('198.062.198.000', 'US'),
    ('198.065.158.000', 'FR'),
    ('198.065.159.000', 'US'),
    ('198.067.132.000', 'RU'),
    ('198.067.133.000', 'US'),
    ('198.070.052.000', 'CA'),
    ('198.070.053.000', 'US'),
    ('198.071.128.000', '--'),
    ('198.072.000.000', 'US'),
    ('198.072.128.000', '--'),
    ('198.073.000.000', 'CA'),
    ('198.073.038.000', 'US'),
    ('198.073.039.000', 'CA'),
    ('198.073.165.000', 'FI'),
    ('198.073.166.000', 'CA'),
    ('198.073.222.000', 'US'),
    ('198.073.225.000', 'CA'),
    ('198.073.253.000', 'US'),
    ('198.073.254.000', 'CA'),
    ('198.074.000.000', 'US'),
    ('198.077.074.000', 'AS'),
    ('198.077.076.000', 'US'),
    ('198.080.052.000', 'CA'),
    ('198.080.056.000', 'US'),
    ('198.080.113.000', 'GB'),
    ('198.080.118.000', 'US'),
    ('198.080.120.000', 'GB'),
    ('198.080.121.000', 'US'),
    ('198.080.122.000', 'GB'),
    ('198.080.124.000', 'US'),
    ('198.081.031.000', 'GB'),
    ('198.081.032.000', 'US'),
    ('198.089.008.000', 'CA'),
    ('198.089.016.000', 'US'),
    ('198.089.048.000', '--'),
    ('198.089.064.000', 'US'),
    ('198.089.096.000', '--'),
    ('198.089.128.000', 'US'),
    ('198.096.000.000', 'CA'),
    ('198.097.000.000', 'US'),
    ('198.097.070.000', 'SG'),
    ('198.097.071.000', 'US'),
    ('198.097.088.000', '--'),
    ('198.097.091.000', 'GB'),
    ('198.097.092.000', 'US'),
    ('198.097.129.000', 'BE'),
    ('198.097.130.000', 'US'),
    ('198.097.132.000', 'CN'),
    ('198.097.133.000', 'US'),
    ('198.097.209.000', 'SG'),
    ('198.097.210.000', 'US'),
    ('198.097.211.000', '--'),
    ('198.097.224.000', 'US'),
    ('198.099.002.000', 'CA'),
    ('198.099.004.000', 'US'),
    ('198.099.170.000', 'CA'),
    ('198.099.171.000', 'US'),
    ('198.099.173.000', 'HK'),
    ('198.099.174.000', 'US'),
    ('198.099.218.000', 'CA'),
    ('198.099.222.000', 'US'),
    ('198.100.128.000', 'CA'),
    ('198.100.136.000', '--'),
    ('198.101.000.000', 'US'),
    ('198.101.064.000', '--'),
    ('198.102.000.000', 'US'),
    ('198.102.174.000', 'CA'),
    ('198.102.175.000', 'US'),
    ('198.102.224.000', 'CA'),
    ('198.102.228.000', 'US'),
    ('198.103.000.000', 'CA'),
    ('198.104.000.000', 'US'),
    ('198.105.017.000', 'CA'),
    ('198.105.026.000', '--'),
    ('198.105.032.000', 'US'),
    ('198.105.048.000', '--'),
    ('198.105.064.000', 'US'),
    ('198.105.080.000', '--'),
    ('198.105.128.000', 'US'),
    ('198.112.006.000', 'JP'),
    ('198.112.007.000', 'US'),
    ('198.116.025.000', 'KE'),
    ('198.116.026.000', 'US'),
    ('198.116.030.000', 'ES'),
    ('198.116.031.000', 'US'),
    ('198.133.032.000', 'CA'),
    ('198.133.073.000', 'US'),
    ('198.133.075.000', '--'),
    ('198.133.076.000', 'US'),
    ('198.133.080.000', 'GB'),
    ('198.133.086.000', 'US'),
    ('198.133.162.000', 'CA'),
    ('198.133.165.000', 'US'),
    ('198.133.173.000', '--'),
    ('198.133.174.000', 'CA'),
    ('198.133.175.000', 'US'),
    ('198.133.226.000', 'GB'),
    ('198.133.227.000', 'US'),
    ('198.133.231.000', 'CA'),
    ('198.133.232.000', 'US'),
    ('198.134.171.000', 'CA'),
    ('198.134.172.000', 'US'),
    ('198.134.219.000', 'CA'),
    ('198.134.220.000', 'US'),
    ('198.135.072.000', 'CA'),
    ('198.135.073.000', 'US'),
    ('198.135.074.000', '--'),
    ('198.135.075.000', 'US'),
    ('198.135.107.000', 'CA'),
    ('198.135.108.000', 'US'),
    ('198.135.116.000', 'CA'),
    ('198.135.118.000', 'US'),
    ('198.135.167.000', 'GB'),
    ('198.135.168.000', 'US'),
    ('198.135.216.000', 'CA'),
    ('198.135.217.000', 'US'),
    ('198.137.064.000', 'NL'),
    ('198.137.067.000', 'US'),
    ('198.137.069.000', 'GB'),
    ('198.137.070.000', 'CA'),
    ('198.137.071.000', 'US'),
    ('198.137.082.000', 'AU'),
    ('198.137.084.000', 'US'),
    ('198.137.085.000', 'CH'),
    ('198.137.086.000', 'GB'),
    ('198.137.087.000', 'JP'),
    ('198.137.090.000', 'BE'),
    ('198.137.092.000', 'GB'),
    ('198.137.094.000', 'US'),
    ('198.137.095.000', 'JP'),
    ('198.137.097.000', 'US'),
    ('198.137.098.000', 'FR'),
    ('198.137.099.000', 'SE'),
    ('198.137.100.000', 'DE'),
    ('198.137.102.000', 'CH'),
    ('198.137.103.000', 'NL'),
    ('198.137.104.000', 'CA'),
    ('198.137.105.000', 'GB'),
    ('198.137.107.000', 'DE'),
    ('198.137.108.000', 'US'),
    ('198.137.116.000', 'GB'),
    ('198.137.120.000', 'CA'),
    ('198.137.121.000', 'DE'),
    ('198.137.122.000', 'FR'),
    ('198.137.124.000', 'US'),
    ('198.137.125.000', 'GB'),
    ('198.137.126.000', 'ES'),
    ('198.137.127.000', 'US'),
    ('198.140.151.000', 'CA'),
    ('198.140.152.000', 'US'),
    ('198.142.000.000', 'AU'),
    ('198.143.000.000', 'US'),
    ('198.145.254.000', 'AU'),
    ('198.145.255.000', 'US'),
    ('198.148.231.000', 'CA'),
    ('198.148.232.000', 'US'),
    ('198.148.239.000', 'CA'),
    ('198.148.240.000', 'US'),
    ('198.151.132.000', 'MX'),
    ('198.151.133.000', 'US'),
    ('198.161.000.000', 'CA'),
    ('198.161.080.000', 'US'),
    ('198.161.081.000', 'CA'),
    ('198.163.184.000', 'US'),
    ('198.163.208.000', 'CA'),
    ('198.170.000.000', 'US'),
    ('198.175.111.000', 'JP'),
    ('198.175.112.000', 'US'),
    ('198.178.187.000', 'KR'),
    ('198.178.188.000', 'JP'),
    ('198.178.189.000', 'AU'),
    ('198.178.190.000', 'US'),
    ('198.180.065.000', 'GB'),
    ('198.180.066.000', 'US'),
    ('198.180.067.000', 'CH'),
    ('198.180.068.000', 'US'),
    ('198.180.080.000', 'GB'),
    ('198.180.095.000', 'DE'),
    ('198.180.099.000', 'IT'),
    ('198.180.100.000', 'GB'),
    ('198.180.102.000', 'DE'),
    ('198.180.105.000', 'CH'),
    ('198.180.106.000', 'DE'),
    ('198.180.107.000', 'US'),
    ('198.180.121.000', 'CA'),
    ('198.180.123.000', 'GB'),
    ('198.180.124.000', 'AU'),
    ('198.180.125.000', 'FR'),
    ('198.180.126.000', 'SG'),
    ('198.180.127.000', 'NL'),
    ('198.180.128.000', 'US'),
    ('198.182.170.000', 'BM'),
    ('198.182.171.000', 'US'),
    ('198.184.161.000', 'BR'),
    ('198.184.162.000', 'US'),
    ('198.184.197.000', 'CA'),
    ('198.184.198.000', 'US'),
    ('198.186.235.000', 'BM'),
    ('198.186.236.000', 'US'),
    ('198.187.171.000', 'BM'),
    ('198.187.172.000', 'US'),
    ('198.200.000.000', 'PH'),
    ('198.200.016.000', 'US'),
    ('198.200.032.000', '--'),
    ('198.200.128.000', 'US'),
    ('198.204.071.000', 'PR'),
    ('198.204.073.000', 'US'),
    ('198.207.016.000', 'BM'),
    ('198.207.024.000', '--'),
    ('198.207.032.000', 'US'),
    ('198.213.051.000', 'MX'),
    ('198.213.052.000', 'US'),
    ('198.231.064.000', 'CA'),
    ('198.231.128.000', 'US'),
    ('198.235.000.000', 'CA'),
    ('198.235.179.000', 'US'),
    ('198.235.180.000', 'CA'),
    ('198.236.000.000', 'US'),
    ('198.240.202.000', 'CH'),
    ('198.240.203.000', 'US'),
    ('198.240.212.000', 'CH'),
    ('198.240.216.000', 'US'),
    ('198.245.064.000', '--'),
    ('198.245.128.000', 'US'),
    ('198.245.139.000', 'PR'),
    ('198.245.140.000', 'US'),
    ('198.245.160.000', 'BB'),
    ('198.245.161.000', 'US'),
    ('198.246.229.000', 'BB'),
    ('198.246.231.000', 'US'),
    ('198.249.001.000', 'CA'),
    ('198.249.002.000', 'US'),
    ('198.249.005.000', 'CA'),
    ('198.249.006.000', 'US'),
    ('198.249.015.000', 'CA'),
    ('198.249.016.000', 'US'),
    ('198.249.017.000', 'CA'),
    ('198.249.019.000', 'US'),
    ('198.249.032.000', 'CA'),
    ('198.249.034.000', 'US'),
    ('198.249.036.000', 'CA'),
    ('198.249.037.000', 'US'),
    ('198.249.039.000', 'CA'),
    ('198.249.040.000', 'US'),
    ('198.249.052.000', 'CA'),
    ('198.249.054.000', 'US'),
    ('198.249.061.000', 'CA'),
    ('198.249.063.000', 'US'),
    ('198.249.070.000', 'CA'),
    ('198.249.071.000', 'US'),
    ('198.249.084.000', 'CA'),
    ('198.249.085.000', 'US'),
    ('198.249.088.000', 'CA'),
    ('198.249.089.000', 'US'),
    ('198.249.091.000', 'CA'),
    ('198.249.092.000', 'US'),
    ('198.249.096.000', 'CA'),
    ('198.249.097.000', 'US'),
    ('198.249.103.000', 'VG'),
    ('198.249.104.000', 'US'),
    ('198.249.109.000', 'CA'),
    ('198.249.110.000', 'US'),
    ('198.249.111.000', 'CA'),
    ('198.249.112.000', 'US'),
    ('198.249.115.000', 'CA'),
    ('198.249.116.000', 'US'),
    ('198.249.124.000', 'CA'),
    ('198.249.125.000', 'US'),
    ('198.249.128.000', 'CA'),
    ('198.249.129.000', 'US'),
    ('198.249.134.000', 'CA'),
    ('198.249.136.000', 'US'),
    ('198.249.152.000', 'CA'),
    ('198.249.153.000', 'US'),
    ('198.249.154.000', 'CA'),
    ('198.249.156.000', 'US'),
    ('198.249.157.000', 'CA'),
    ('198.249.158.000', 'US'),
    ('198.249.159.000', 'CA'),
    ('198.249.164.000', 'US'),
    ('198.249.166.000', 'CA'),
    ('198.249.167.000', 'US'),
    ('198.249.170.000', 'CA'),
    ('198.249.174.000', 'US'),
    ('198.249.177.000', 'CA'),
    ('198.249.178.000', 'US'),
    ('198.249.180.000', 'CA'),
    ('198.249.181.000', 'US'),
    ('198.249.183.000', 'CA'),
    ('198.249.184.000', 'US'),
    ('198.249.189.000', 'CA'),
    ('198.249.190.000', 'US'),
    ('198.249.196.000', 'CA'),
    ('198.249.197.000', 'US'),
    ('198.249.198.000', 'CA'),
    ('198.249.199.000', 'US'),
    ('198.249.200.000', 'CA'),
    ('198.249.201.000', 'US'),
    ('198.249.204.000', 'CA'),
    ('198.249.205.000', 'US'),
    ('198.249.209.000', 'CA'),
    ('198.249.214.000', 'US'),
    ('198.249.216.000', 'CA'),
    ('198.249.218.000', 'US'),
    ('198.249.222.000', 'CA'),
    ('198.249.224.000', 'US'),
    ('198.249.229.000', 'CA'),
    ('198.249.232.000', 'US'),
    ('198.249.236.000', 'CA'),
    ('198.249.238.000', 'US'),
    ('198.249.242.000', 'CA'),
    ('198.249.246.000', 'US'),
    ('198.249.248.000', 'CA'),
    ('198.249.250.000', 'US'),
    ('198.249.251.000', 'CA'),
    ('198.249.252.000', 'US'),
    ('198.249.253.000', 'CA'),
    ('198.249.254.000', 'US'),
    ('199.006.000.000', '--'),
    ('199.006.016.000', 'US'),
    ('199.006.036.000', 'GB'),
    ('199.006.037.000', 'US'),
    ('199.006.064.000', 'GB'),
    ('199.006.069.000', 'NO'),
    ('199.006.072.000', 'SG'),
    ('199.006.073.000', 'US'),
    ('199.006.078.000', 'DK'),
    ('199.006.079.000', 'CA'),
    ('199.006.080.000', 'IT'),
    ('199.006.084.000', 'FR'),
    ('199.006.085.000', 'HK'),
    ('199.006.088.000', 'NL'),
    ('199.006.089.000', 'FR'),
    ('199.006.092.000', 'FI'),
    ('199.006.095.000', 'US'),
    ('199.006.106.000', 'JP'),
    ('199.006.107.000', 'US'),
    ('199.007.064.000', '--'),
    ('199.008.000.000', 'US'),
    ('199.010.114.000', 'GB'),
    ('199.010.115.000', 'US'),
    ('199.022.000.000', 'CA'),
    ('199.026.000.000', 'US'),
    ('199.026.234.000', 'PA'),
    ('199.026.235.000', 'US'),
    ('199.027.064.000', '--'),
    ('199.028.000.000', 'US'),
    ('199.029.071.000', 'KW'),
    ('199.029.072.000', 'US'),
    ('199.043.000.000', 'CA'),
    ('199.043.004.000', 'US'),
    ('199.043.008.000', 'CA'),
    ('199.044.000.000', 'US'),
    ('199.045.064.000', 'CA'),
    ('199.045.128.000', 'US'),
    ('199.060.000.000', 'CA'),
    ('199.060.020.000', 'US'),
    ('199.060.026.000', 'CA'),
    ('199.061.000.000', 'US'),
    ('199.071.000.000', 'CA'),
    ('199.071.006.000', 'US'),
    ('199.071.008.000', 'CA'),
    ('199.071.150.000', 'US'),
    ('199.071.151.000', 'CA'),
    ('199.072.000.000', 'US'),
    ('199.074.252.000', 'BM'),
    ('199.074.253.000', 'US'),
    ('199.074.255.000', '--'),
    ('199.075.000.000', 'US'),
    ('199.084.000.000', 'CA'),
    ('199.086.000.000', 'US'),
    ('199.089.129.000', '--'),
    ('199.089.130.000', 'US'),
    ('199.089.131.000', 'CZ'),
    ('199.089.132.000', 'US'),
    ('199.089.210.000', 'TR'),
    ('199.089.211.000', 'PL'),
    ('199.089.212.000', 'HU'),
    ('199.089.213.000', 'US'),
    ('199.095.150.000', 'NL'),
    ('199.095.151.000', 'US'),
    ('199.095.178.000', 'EG'),
    ('199.095.180.000', 'GB'),
    ('199.095.181.000', 'UZ'),
    ('199.095.182.000', 'US'),
    ('199.095.248.000', 'GB'),
    ('199.095.249.000', 'US'),
    ('199.098.159.000', 'KW'),
    ('199.098.160.000', 'US'),
    ('199.102.064.000', '--'),
    ('199.103.000.000', 'US'),
    ('199.103.064.000', 'GB'),
    ('199.103.068.000', 'SG'),
    ('199.103.069.000', 'US'),
    ('199.103.073.000', 'ES'),
    ('199.103.074.000', 'LU'),
    ('199.103.075.000', 'DE'),
    ('199.103.080.000', 'US'),
    ('199.103.081.000', 'ES'),
    ('199.103.082.000', 'GB'),
    ('199.103.084.000', 'NL'),
    ('199.103.085.000', '--'),
    ('199.103.086.000', 'GB'),
    ('199.103.087.000', 'FR'),
    ('199.103.089.000', '--'),
    ('199.103.090.000', 'GB'),
    ('199.103.092.000', 'FR'),
    ('199.103.093.000', 'DE'),
    ('199.103.094.000', 'US'),
    ('199.103.096.000', 'DE'),
    ('199.103.100.000', '--'),
    ('199.103.102.000', 'CL'),
    ('199.103.103.000', 'JP'),
    ('199.103.104.000', 'AT'),
    ('199.103.106.000', 'CH'),
    ('199.103.107.000', 'DE'),
    ('199.103.108.000', 'US'),
    ('199.103.114.000', 'GB'),
    ('199.103.118.000', '--'),
    ('199.103.119.000', 'IT'),
    ('199.103.120.000', 'US'),
    ('199.103.122.000', 'GB'),
    ('199.103.123.000', 'FR'),
    ('199.103.126.000', 'BE'),
    ('199.103.127.000', 'DE'),
    ('199.103.128.000', 'US'),
    ('199.105.084.000', 'IT'),
    ('199.105.086.000', 'US'),
    ('199.105.087.000', 'IT'),
    ('199.105.088.000', 'US'),
    ('199.108.096.000', 'DE'),
    ('199.108.160.000', 'US'),
    ('199.126.000.000', 'CA'),
    ('199.126.007.000', 'US'),
    ('199.126.008.000', 'CA'),
    ('199.127.000.000', 'US'),
    ('199.127.064.000', '--'),
    ('199.128.000.000', 'US'),
    ('199.161.200.000', 'CA'),
    ('199.161.202.000', 'US'),
    ('199.161.218.000', 'CA'),
    ('199.161.219.000', 'US'),
    ('199.162.230.000', 'CA'),
    ('199.162.231.000', 'US'),
    ('199.164.129.000', 'CA'),
    ('199.164.130.000', 'US'),
    ('199.165.208.000', 'GB'),
    ('199.165.212.000', 'US'),
    ('199.166.000.000', 'CA'),
    ('199.166.248.000', 'US'),
    ('199.166.251.000', 'CA'),
    ('199.167.000.000', 'US'),
    ('199.167.016.000', '--'),
    ('199.168.000.000', 'US'),
    ('199.172.192.000', 'BM'),
    ('199.173.000.000', 'US'),
    ('199.175.000.000', 'CA'),
    ('199.176.000.000', 'US'),
    ('199.185.000.000', 'CA'),
    ('199.185.016.000', 'US'),
    ('199.185.028.000', 'CA'),
    ('199.185.139.000', 'GB'),
    ('199.185.140.000', 'CA'),
    ('199.185.230.000', 'US'),
    ('199.185.232.000', 'CA'),
    ('199.186.000.000', 'US'),
    ('199.186.025.000', 'CL'),
    ('199.186.035.000', 'US'),
    ('199.187.128.000', '--'),
    ('199.188.000.000', 'US'),
    ('199.194.001.000', 'CA'),
    ('199.194.002.000', 'US'),
    ('199.194.003.000', 'CA'),
    ('199.194.007.000', 'US'),
    ('199.194.009.000', 'CA'),
    ('199.194.010.000', 'US'),
    ('199.194.012.000', 'CA'),
    ('199.194.013.000', 'US'),
    ('199.194.017.000', 'CA'),
    ('199.194.018.000', 'US'),
    ('199.194.021.000', 'CA'),
    ('199.194.022.000', 'US'),
    ('199.194.026.000', 'CA'),
    ('199.194.027.000', 'US'),
    ('199.194.028.000', 'CA'),
    ('199.194.029.000', 'US'),
    ('199.194.031.000', 'CA'),
    ('199.194.032.000', 'US'),
    ('199.194.035.000', 'CA'),
    ('199.194.037.000', 'US'),
    ('199.194.041.000', 'CA'),
    ('199.194.043.000', 'US'),
    ('199.194.049.000', 'CA'),
    ('199.194.050.000', 'US'),
    ('199.194.052.000', 'CA'),
    ('199.194.053.000', 'US'),
    ('199.194.058.000', 'CA'),
    ('199.194.059.000', 'US'),
    ('199.194.063.000', 'CA'),
    ('199.194.064.000', 'US'),
    ('199.194.068.000', 'CA'),
    ('199.194.069.000', 'US'),
    ('199.194.070.000', 'CA'),
    ('199.194.071.000', 'US'),
    ('199.194.072.000', 'CA'),
    ('199.194.073.000', 'US'),
    ('199.194.074.000', 'CA'),
    ('199.194.075.000', 'US'),
    ('199.194.076.000', 'CA'),
    ('199.194.078.000', 'US'),
    ('199.194.079.000', 'CA'),
    ('199.194.080.000', 'US'),
    ('199.194.082.000', 'CA'),
    ('199.194.083.000', 'US'),
    ('199.194.086.000', 'CA'),
    ('199.194.087.000', 'US'),
    ('199.194.088.000', 'CA'),
    ('199.194.093.000', 'US'),
    ('199.194.094.000', 'CA'),
    ('199.194.095.000', 'US'),
    ('199.194.099.000', 'CA'),
    ('199.194.100.000', 'US'),
    ('199.194.101.000', 'CA'),
    ('199.194.102.000', 'US'),
    ('199.194.106.000', 'CA'),
    ('199.194.107.000', 'US'),
    ('199.194.108.000', 'CA'),
    ('199.194.110.000', 'US'),
    ('199.194.113.000', 'CA'),
    ('199.194.115.000', 'US'),
    ('199.194.120.000', 'CA'),
    ('199.194.121.000', 'US'),
    ('199.194.124.000', 'CA'),
    ('199.194.125.000', 'US'),
    ('199.194.126.000', 'CA'),
    ('199.194.127.000', 'US'),
    ('199.194.128.000', 'CA'),
    ('199.194.130.000', 'US'),
    ('199.194.131.000', 'CA'),
    ('199.194.132.000', 'US'),
    ('199.194.134.000', 'CA'),
    ('199.194.136.000', 'US'),
    ('199.194.137.000', 'CA'),
    ('199.194.139.000', 'US'),
    ('199.194.140.000', 'CA'),
    ('199.194.141.000', 'US'),
    ('199.194.145.000', 'CA'),
    ('199.194.147.000', 'US'),
    ('199.194.148.000', 'CA'),
    ('199.194.149.000', 'US'),
    ('199.194.155.000', 'CA'),
    ('199.194.156.000', 'US'),
    ('199.194.171.000', 'PR'),
    ('199.194.172.000', 'US'),
    ('199.194.184.000', 'CA'),
    ('199.194.185.000', 'US'),
    ('199.194.189.000', 'CA'),
    ('199.194.190.000', 'US'),
    ('199.194.219.000', 'CA'),
    ('199.194.220.000', 'US'),
    ('199.194.221.000', 'PR'),
    ('199.194.222.000', 'US'),
    ('199.194.223.000', 'CA'),
    ('199.194.224.000', 'US'),
    ('199.194.225.000', 'CA'),
    ('199.194.226.000', 'US'),
    ('199.194.227.000', 'CA'),
    ('199.194.228.000', 'US'),
    ('199.194.229.000', 'CA'),
    ('199.194.231.000', 'US'),
    ('199.194.239.000', 'CA'),
    ('199.194.240.000', 'US'),
    ('199.194.242.000', 'CA'),
    ('199.194.243.000', 'US'),
    ('199.195.128.000', '--'),
    ('199.196.000.000', 'US'),
    ('199.198.000.000', 'CA'),
    ('199.199.000.000', 'US'),
    ('199.202.000.000', 'CA'),
    ('199.202.199.000', 'US'),
    ('199.202.200.000', 'CA'),
    ('199.203.000.000', 'US'),
    ('199.203.004.000', 'IL'),
    ('199.203.005.000', 'US'),
    ('199.203.007.000', 'IL'),
    ('199.203.013.000', 'US'),
    ('199.203.016.000', 'IL'),
    ('199.203.068.000', 'US'),
    ('199.203.069.000', 'IL'),
    ('199.203.082.000', 'US'),
    ('199.203.083.000', 'IL'),
    ('199.203.105.000', 'US'),
    ('199.203.106.000', 'IL'),
    ('199.203.127.000', 'US'),
    ('199.203.130.000', 'IL'),
    ('199.203.139.000', 'US'),
    ('199.203.140.000', 'IL'),
    ('199.203.145.000', 'US'),
    ('199.203.146.000', 'IL'),
    ('199.203.147.000', 'US'),
    ('199.203.199.000', 'IL'),
    ('199.203.210.000', 'US'),
    ('199.203.213.000', 'IL'),
    ('199.203.214.000', 'US'),
    ('199.203.216.000', 'IL'),
    ('199.203.217.000', 'US'),
    ('199.203.222.000', 'IL'),
    ('199.203.223.000', 'US'),
    ('199.203.252.000', 'IL'),
    ('199.203.254.000', 'US'),
    ('199.203.255.000', 'IL'),
    ('199.204.000.000', 'US'),
    ('199.211.072.000', 'PR'),
    ('199.211.075.000', 'US'),
    ('199.211.116.000', 'JM'),
    ('199.211.117.000', 'US'),
    ('199.211.223.000', 'DE'),
    ('199.211.225.000', 'US'),
    ('199.212.000.000', 'CA'),
    ('199.212.062.000', 'US'),
    ('199.212.063.000', 'CA'),
    ('199.212.218.000', 'US'),
    ('199.212.224.000', 'CA'),
    ('199.217.000.000', 'US'),
    ('199.228.022.000', 'CA'),
    ('199.228.023.000', 'AU'),
    ('199.228.024.000', 'BR'),
    ('199.228.029.000', 'US'),
    ('199.228.030.000', 'CA'),
    ('199.228.033.000', 'BR'),
    ('199.228.040.000', 'US'),
    ('199.228.049.000', 'CA'),
    ('199.228.052.000', 'US'),
    ('199.228.070.000', 'CA'),
    ('199.228.074.000', 'US'),
    ('199.228.114.000', 'CA'),
    ('199.228.115.000', 'US'),
    ('199.228.116.000', 'CA'),
    ('199.228.122.000', 'US'),
    ('199.228.124.000', 'DE'),
    ('199.228.126.000', 'US'),
    ('199.228.138.000', 'DE'),
    ('199.228.139.000', 'US'),
    ('199.228.140.000', 'LU'),
    ('199.228.141.000', 'US'),
    ('199.228.157.000', 'DE'),
    ('199.228.160.000', 'RU'),
    ('199.228.161.000', 'CA'),
    ('199.228.164.000', 'US'),
    ('199.228.170.000', 'DE'),
    ('199.228.172.000', 'US'),
    ('199.228.175.000', 'CA'),
    ('199.228.176.000', 'US'),
    ('199.228.183.000', 'SG'),
    ('199.228.184.000', 'US'),
    ('199.228.187.000', 'AU'),
    ('199.228.189.000', 'US'),
    ('199.228.195.000', 'AU'),
    ('199.228.196.000', 'US'),
    ('199.228.200.000', 'NL'),
    ('199.228.201.000', 'CH'),
    ('199.228.202.000', 'DE'),
    ('199.228.203.000', 'DK'),
    ('199.228.204.000', 'NO'),
    ('199.228.205.000', 'BE'),
    ('199.228.206.000', 'IT'),
    ('199.228.207.000', 'FR'),
    ('199.228.208.000', 'US'),
    ('199.228.217.000', 'VE'),
    ('199.228.218.000', 'US'),
    ('199.228.220.000', 'DE'),
    ('199.228.221.000', 'US'),
    ('199.228.222.000', 'CA'),
    ('199.228.224.000', 'US'),
    ('199.228.225.000', 'BR'),
    ('199.228.226.000', 'US'),
    ('199.228.230.000', 'CA'),
    ('199.228.231.000', 'US'),
    ('199.228.240.000', 'JP'),
    ('199.228.248.000', 'US'),
    ('199.228.249.000', 'CA'),
    ('199.228.251.000', 'US'),
    ('199.229.190.000', 'GB'),
    ('199.229.191.000', 'US'),
    ('199.229.224.000', '--'),
    ('199.230.000.000', 'US'),
    ('199.233.171.000', 'CA'),
    ('199.233.172.000', 'US'),
    ('199.233.183.000', 'CA'),
    ('199.233.185.000', 'US'),
    ('199.233.224.000', '--'),
    ('199.234.000.000', 'US'),
    ('199.235.000.000', 'CA'),
    ('199.236.000.000', 'US'),
    ('199.243.000.000', 'CA'),
    ('199.244.000.000', 'US'),
    ('199.245.236.000', 'CA'),
    ('199.245.237.000', 'US'),
    ('199.246.000.000', 'CA'),
    ('199.248.000.000', 'US'),
    ('199.248.144.000', 'AR'),
    ('199.248.145.000', 'US'),
    ('199.254.152.000', 'CA'),
    ('199.254.153.000', 'US'),
    ('199.254.235.000', 'CA'),
    ('199.254.236.000', 'US'),
    ('199.255.000.000', '--'),
    ('200.000.000.000', 'CO'),
    ('200.000.008.000', 'BR'),
    ('200.000.016.000', '--'),
    ('200.000.032.000', 'BR'),
    ('200.000.064.000', '--'),
    ('200.000.066.000', 'CL'),
    ('200.000.067.000', 'BR'),
    ('200.000.073.000', 'EC'),
    ('200.000.079.000', 'AR'),
    ('200.000.081.000', 'BR'),
    ('200.000.082.000', 'CL'),
    ('200.000.083.000', 'MX'),
    ('200.000.085.000', 'BR'),
    ('200.000.088.000', 'MX'),
    ('200.000.089.000', 'BR'),
    ('200.000.094.000', 'US'),
    ('200.000.095.000', 'MX'),
    ('200.000.096.000', 'AR'),
    ('200.000.100.000', 'BR'),
    ('200.000.103.000', 'MX'),
    ('200.000.107.000', 'PE'),
    ('200.000.108.000', 'CL'),
    ('200.000.109.000', 'MX'),
    ('200.000.110.000', 'PE'),
    ('200.000.111.000', 'MX'),
    ('200.000.114.000', 'BR'),
    ('200.000.115.000', 'CL'),
    ('200.000.118.000', 'PE'),
    ('200.000.120.000', 'CL'),
    ('200.000.125.000', 'MX'),
    ('200.000.136.000', 'PE'),
    ('200.000.137.000', 'US'),
    ('200.000.139.000', 'VE'),
    ('200.000.140.000', 'CL'),
    ('200.000.142.000', 'PE'),
    ('200.000.143.000', 'MX'),
    ('200.000.144.000', 'CL'),
    ('200.000.164.000', 'PE'),
    ('200.000.176.000', 'AR'),
    ('200.000.216.000', 'US'),
    ('200.000.224.000', 'AR'),
    ('200.001.000.000', 'VE'),
    ('200.001.016.000', 'CL'),
    ('200.001.032.000', 'AR'),
    ('200.001.064.000', 'CO'),
    ('200.001.128.000', 'CL'),
    ('200.001.144.000', 'VE'),
    ('200.001.152.000', 'NI'),
    ('200.001.153.000', 'GT'),
    ('200.001.154.000', 'DO'),
    ('200.001.156.000', 'SR'),
    ('200.001.160.000', 'BM'),
    ('200.001.161.000', 'EC'),
    ('200.001.162.000', 'VE'),
    ('200.001.172.000', 'EC'),
    ('200.001.173.000', 'CO'),
    ('200.001.174.000', '--'),
    ('200.001.175.000', 'CO'),
    ('200.001.176.000', 'PE'),
    ('200.001.184.000', 'VE'),
    ('200.001.192.000', 'CO'),
    ('200.001.200.000', '--'),
    ('200.001.224.000', 'AR'),
    ('200.002.000.000', '--'),
    ('200.002.008.000', 'VE'),
    ('200.002.016.000', 'CL'),
    ('200.002.032.000', 'UY'),
    ('200.002.064.000', 'CO'),
    ('200.002.072.000', 'CL'),
    ('200.002.128.000', '--'),
    ('200.002.192.000', 'CL'),
    ('200.002.224.000', '--'),
    ('200.003.000.000', 'VE'),
    ('200.003.016.000', 'BR'),
    ('200.003.032.000', 'AR'),
    ('200.003.128.000', 'CO'),
    ('200.003.194.000', '--'),
    ('200.003.224.000', 'HN'),
    ('200.003.241.000', '--'),
    ('200.003.244.000', 'CO'),
    ('200.003.248.000', '--'),
    ('200.004.000.000', 'MX'),
    ('200.004.016.000', 'CO'),
    ('200.004.032.000', 'MX'),
    ('200.004.160.000', '--'),
    ('200.004.192.000', 'PE'),
    ('200.005.000.000', 'PR'),
    ('200.005.009.000', 'BR'),
    ('200.005.010.000', '--'),
    ('200.005.011.000', 'PR'),
    ('200.005.012.000', 'CU'),
    ('200.005.016.000', 'VE'),
    ('200.005.032.000', 'AR'),
    ('200.005.040.000', 'VE'),
    ('200.005.048.000', '--'),
    ('200.005.064.000', 'AR'),
    ('200.005.128.000', 'VE'),
    ('200.005.192.000', 'AR'),
    ('200.006.000.000', 'EC'),
    ('200.006.033.000', 'CL'),
    ('200.006.034.000', 'EC'),
    ('200.006.035.000', 'BR'),
    ('200.006.049.000', '--'),
    ('200.006.064.000', 'CL'),
    ('200.006.080.000', '--'),
    ('200.006.128.000', 'BR'),
    ('200.006.136.000', '--'),
    ('200.007.000.000', 'BR'),
    ('200.007.016.000', 'CL'),
    ('200.007.032.000', '--'),
    ('200.007.064.000', 'EC'),
    ('200.007.096.000', '--'),
    ('200.009.000.000', 'BR'),
    ('200.009.003.000', 'CL'),
    ('200.009.004.000', 'PY'),
    ('200.009.008.000', 'MX'),
    ('200.009.016.000', 'CO'),
    ('200.009.032.000', 'CR'),
    ('200.009.064.000', 'CL'),
    ('200.009.065.000', 'BR'),
    ('200.009.072.000', '--'),
    ('200.009.073.000', 'CL'),
    ('200.009.074.000', 'GT'),
    ('200.009.075.000', 'AR'),
    ('200.009.076.000', 'BR'),
    ('200.009.079.000', 'CL'),
    ('200.009.082.000', 'US'),
    ('200.009.084.000', 'BR'),
    ('200.009.096.000', 'EC'),
    ('200.009.097.000', 'CL'),
    ('200.009.102.000', 'BR'),
    ('200.009.108.000', 'CL'),
    ('200.009.112.000', 'BR'),
    ('200.009.115.000', 'JM'),
    ('200.009.116.000', 'BR'),
    ('200.009.122.000', 'CL'),
    ('200.009.123.000', 'BR'),
    ('200.009.128.000', 'CL'),
    ('200.009.129.000', 'BR'),
    ('200.009.141.000', 'CL'),
    ('200.009.143.000', 'BR'),
    ('200.009.145.000', 'CL'),
    ('200.009.147.000', 'AR'),
    ('200.009.148.000', 'BR'),
    ('200.009.150.000', 'CL'),
    ('200.009.154.000', '--'),
    ('200.009.158.000', 'BR'),
    ('200.009.165.000', 'BO'),
    ('200.009.169.000', 'BR'),
    ('200.009.176.000', 'EC'),
    ('200.009.177.000', 'CL'),
    ('200.009.181.000', 'BR'),
    ('200.009.187.000', 'NI'),
    ('200.009.193.000', 'CL'),
    ('200.009.194.000', 'AR'),
    ('200.009.195.000', 'CL'),
    ('200.009.199.000', 'BR'),
    ('200.009.201.000', 'CL'),
    ('200.009.202.000', 'BR'),
    ('200.009.204.000', 'CL'),
    ('200.009.206.000', 'BR'),
    ('200.009.208.000', 'AR'),
    ('200.009.209.000', 'CR'),
    ('200.009.210.000', 'VE'),
    ('200.009.211.000', 'CO'),
    ('200.009.212.000', 'AR'),
    ('200.009.214.000', 'BR'),
    ('200.009.215.000', 'CL'),
    ('200.009.216.000', 'TT'),
    ('200.009.219.000', 'AR'),
    ('200.009.220.000', 'BR'),
    ('200.009.225.000', 'CL'),
    ('200.009.226.000', 'BR'),
    ('200.009.228.000', 'CL'),
    ('200.009.229.000', 'BR'),
    ('200.009.230.000', 'CL'),
    ('200.009.234.000', 'BR'),
    ('200.009.235.000', 'AR'),
    ('200.009.238.000', 'CL'),
    ('200.009.242.000', 'AR'),
    ('200.009.247.000', 'CL'),
    ('200.009.248.000', 'EC'),
    ('200.009.249.000', 'BR'),
    ('200.009.253.000', 'AR'),
    ('200.009.255.000', '--'),
    ('200.010.000.000', 'CL'),
    ('200.010.004.000', 'BR'),
    ('200.010.008.000', 'CL'),
    ('200.010.032.000', 'BR'),
    ('200.010.064.000', 'PE'),
    ('200.010.096.000', 'AR'),
    ('200.010.130.000', 'PE'),
    ('200.010.132.000', 'BR'),
    ('200.010.139.000', 'AR'),
    ('200.010.141.000', 'BR'),
    ('200.010.142.000', 'DO'),
    ('200.010.143.000', 'MX'),
    ('200.010.144.000', 'BR'),
    ('200.010.145.000', 'CL'),
    ('200.010.146.000', 'BR'),
    ('200.010.147.000', 'EC'),
    ('200.010.152.000', 'JM'),
    ('200.010.153.000', 'BR'),
    ('200.010.155.000', 'US'),
    ('200.010.156.000', 'BR'),
    ('200.010.160.000', 'US'),
    ('200.010.161.000', 'AR'),
    ('200.010.162.000', 'DO'),
    ('200.010.163.000', 'BR'),
    ('200.010.165.000', 'BM'),
    ('200.010.167.000', 'CL'),
    ('200.010.173.000', 'BR'),
    ('200.010.182.000', 'CL'),
    ('200.010.183.000', 'BR'),
    ('200.010.184.000', 'CL'),
    ('200.010.185.000', 'BR'),
    ('200.010.186.000', 'AR'),
    ('200.010.187.000', 'BR'),
    ('200.010.188.000', 'PE'),
    ('200.010.189.000', 'BR'),
    ('200.010.190.000', 'CL'),
    ('200.010.191.000', 'BR'),
    ('200.010.194.000', 'BZ'),
    ('200.010.195.000', 'CL'),
    ('200.010.196.000', 'AR'),
    ('200.010.197.000', 'MX'),
    ('200.010.199.000', '--'),
    ('200.010.200.000', 'MX'),
    ('200.010.201.000', 'AR'),
    ('200.010.203.000', 'PA'),
    ('200.010.204.000', '--'),
    ('200.010.207.000', 'AR'),
    ('200.010.208.000', 'CL'),
    ('200.010.209.000', 'BR'),
    ('200.010.211.000', 'CL'),
    ('200.010.212.000', 'MX'),
    ('200.010.219.000', 'AR'),
    ('200.010.220.000', 'CL'),
    ('200.010.227.000', 'BR'),
    ('200.010.228.000', 'PY'),
    ('200.010.232.000', 'CL'),
    ('200.010.233.000', 'MX'),
    ('200.010.234.000', 'CL'),
    ('200.010.235.000', '--'),
    ('200.010.236.000', 'CL'),
    ('200.010.239.000', 'MX'),
    ('200.010.241.000', 'GT'),
    ('200.010.242.000', 'CL'),
    ('200.010.243.000', 'MX'),
    ('200.010.245.000', 'BR'),
    ('200.010.246.000', 'MX'),
    ('200.010.250.000', 'PE'),
    ('200.010.251.000', 'CL'),
    ('200.010.254.000', 'VE'),
    ('200.010.255.000', 'CL'),
    ('200.011.000.000', 'BR'),
    ('200.011.032.000', 'PE'),
    ('200.011.064.000', 'CL'),
    ('200.011.128.000', 'VE'),
    ('200.012.000.000', 'BR'),
    ('200.012.016.000', 'CL'),
    ('200.012.032.000', 'GT'),
    ('200.012.064.000', 'MX'),
    ('200.012.129.000', 'CL'),
    ('200.012.131.000', 'BR'),
    ('200.012.132.000', 'CL'),
    ('200.012.133.000', 'AR'),
    ('200.012.139.000', 'BR'),
    ('200.012.140.000', 'CL'),
    ('200.012.153.000', '--'),
    ('200.012.154.000', 'AR'),
    ('200.012.155.000', 'UY'),
    ('200.012.157.000', 'BR'),
    ('200.012.158.000', 'MX'),
    ('200.012.167.000', 'CR'),
    ('200.012.168.000', 'VE'),
    ('200.012.169.000', 'EC'),
    ('200.012.170.000', 'CO'),
    ('200.012.171.000', '--'),
    ('200.012.172.000', 'SV'),
    ('200.012.175.000', 'CO'),
    ('200.012.192.000', '--'),
    ('200.012.193.000', 'VE'),
    ('200.012.194.000', '--'),
    ('200.012.224.000', 'US'),
    ('200.012.225.000', 'GT'),
    ('200.012.226.000', 'US'),
    ('200.012.228.000', 'NI'),
    ('200.012.229.000', 'US'),
    ('200.012.231.000', 'NI'),
    ('200.012.232.000', 'SV'),
    ('200.012.234.000', 'NI'),
    ('200.012.235.000', 'US'),
    ('200.012.237.000', 'NI'),
    ('200.012.238.000', 'US'),
    ('200.012.240.000', '--'),
    ('200.013.008.000', 'BR'),
    ('200.013.016.000', 'MX'),
    ('200.013.132.000', '--'),
    ('200.013.160.000', 'SV'),
    ('200.013.176.000', '--'),
    ('200.013.192.000', 'CO'),
    ('200.014.000.000', 'CL'),
    ('200.014.008.000', 'VE'),
    ('200.014.016.000', 'MX'),
    ('200.014.032.000', 'BR'),
    ('200.014.040.000', '--'),
    ('200.014.064.000', 'CL'),
    ('200.014.112.000', 'CO'),
    ('200.014.114.000', 'CL'),
    ('200.014.120.000', '--'),
    ('200.014.128.000', 'CL'),
    ('200.014.205.000', 'CO'),
    ('200.014.207.000', 'CL'),
    ('200.014.231.000', 'CO'),
    ('200.014.240.000', 'CL'),
    ('200.015.000.000', 'US'),
    ('200.016.000.000', 'PE'),
    ('200.016.008.000', 'ZA'),
    ('200.016.016.000', 'AR'),
    ('200.016.032.000', 'MX'),
    ('200.016.064.000', 'AR'),
    ('200.016.088.000', 'US'),
    ('200.016.089.000', '--'),
    ('200.016.096.000', 'AR'),
    ('200.017.000.000', 'BR'),
    ('200.021.000.000', 'CO'),
    ('200.022.000.000', 'CL'),
    ('200.023.000.000', 'MX'),
    ('200.023.029.000', 'US'),
    ('200.023.033.000', 'MX'),
    ('200.024.000.000', 'CO'),
    ('200.024.064.000', 'EC'),
    ('200.024.065.000', 'CO'),
    ('200.024.112.000', '--'),
    ('200.024.128.000', 'PA'),
    ('200.024.136.000', 'AU'),
    ('200.024.137.000', 'PA'),
    ('200.024.144.000', '--'),
    ('200.024.160.000', 'PE'),
    ('200.024.192.000', 'EC'),
    ('200.024.224.000', 'CL'),
    ('200.024.240.000', '--'),
    ('200.025.000.000', 'CO'),
    ('200.025.128.000', '--'),
    ('200.026.000.000', 'AR'),
    ('200.026.128.000', '--'),
    ('200.027.000.000', 'CL'),
    ('200.030.000.000', 'BR'),
    ('200.030.008.000', 'VE'),
    ('200.030.012.000', 'US'),
    ('200.030.020.000', 'PR'),
    ('200.030.024.000', 'US'),
    ('200.030.025.000', 'MX'),
    ('200.030.028.000', 'VE'),
    ('200.030.031.000', 'US'),
    ('200.030.032.000', 'CL'),
    ('200.030.036.000', 'NI'),
    ('200.030.037.000', 'PR'),
    ('200.030.038.000', 'GT'),
    ('200.030.040.000', 'SZ'),
    ('200.030.042.000', 'CO'),
    ('200.030.046.000', 'CL'),
    ('200.030.048.000', 'NI'),
    ('200.030.053.000', 'PR'),
    ('200.030.054.000', 'CO'),
    ('200.030.055.000', 'VE'),
    ('200.030.060.000', 'CL'),
    ('200.030.064.000', 'CO'),
    ('200.030.128.000', 'GT'),
    ('200.030.160.000', '--'),
    ('200.030.192.000', 'CL'),
    ('200.031.000.000', 'US'),
    ('200.031.001.000', 'AR'),
    ('200.031.004.000', 'VE'),
    ('200.031.006.000', 'EC'),
    ('200.031.007.000', 'US'),
    ('200.031.008.000', 'EC'),
    ('200.031.011.000', 'US'),
    ('200.031.012.000', 'CO'),
    ('200.031.024.000', 'AR'),
    ('200.031.026.000', 'EC'),
    ('200.031.032.000', 'CL'),
    ('200.031.064.000', 'CO'),
    ('200.031.080.000', '--'),
    ('200.031.096.000', 'PE'),
    ('200.031.112.000', '--'),
    ('200.031.128.000', 'VE'),
    ('200.031.144.000', '--'),
    ('200.031.160.000', 'SV'),
    ('200.031.176.000', '--'),
    ('200.031.192.000', 'CO'),
    ('200.031.208.000', '--'),
    ('200.032.000.000', 'AR'),
    ('200.032.064.000', 'VE'),
    ('200.032.065.000', 'MX'),
    ('200.032.068.000', 'EC'),
    ('200.032.070.000', 'US'),
    ('200.032.071.000', 'EC'),
    ('200.032.072.000', 'CL'),
    ('200.032.077.000', 'HN'),
    ('200.032.078.000', 'MX'),
    ('200.032.079.000', 'US'),
    ('200.032.080.000', 'CO'),
    ('200.032.084.000', 'AR'),
    ('200.032.090.000', 'US'),
    ('200.032.091.000', 'AR'),
    ('200.032.092.000', 'US'),
    ('200.032.093.000', 'AR'),
    ('200.032.160.000', '--'),
    ('200.033.000.000', 'MX'),
    ('200.035.000.000', 'VE'),
    ('200.036.000.000', 'MX'),
    ('200.037.000.000', 'PE'),
    ('200.038.000.000', 'MX'),
    ('200.040.000.000', 'UY'),
    ('200.041.000.000', 'EC'),
    ('200.041.004.000', 'GT'),
    ('200.041.008.000', 'CL'),
    ('200.041.009.000', 'SV'),
    ('200.041.010.000', 'PY'),
    ('200.041.011.000', 'EC'),
    ('200.041.012.000', 'VE'),
    ('200.041.013.000', 'CO'),
    ('200.041.014.000', 'AR'),
    ('200.041.031.000', 'US'),
    ('200.041.032.000', 'AR'),
    ('200.041.048.000', 'CO'),
    ('200.041.049.000', 'US'),
    ('200.041.050.000', 'AR'),
    ('200.041.051.000', 'VE'),
    ('200.041.052.000', 'CL'),
    ('200.041.053.000', 'HN'),
    ('200.041.054.000', 'SV'),
    ('200.041.056.000', 'HN'),
    ('200.041.057.000', 'VE'),
    ('200.041.058.000', 'AR'),
    ('200.041.067.000', 'US'),
    ('200.041.068.000', 'AR'),
    ('200.041.076.000', 'CO'),
    ('200.041.080.000', 'HN'),
    ('200.041.081.000', 'EC'),
    ('200.041.082.000', 'PY'),
    ('200.041.083.000', 'CO'),
    ('200.041.084.000', 'GT'),
    ('200.041.088.000', 'VE'),
    ('200.041.089.000', 'EC'),
    ('200.041.090.000', 'US'),
    ('200.041.092.000', 'EC'),
    ('200.041.093.000', 'VE'),
    ('200.041.094.000', 'SV'),
    ('200.041.096.000', 'PE'),
    ('200.041.100.000', 'HN'),
    ('200.041.101.000', 'US'),
    ('200.041.104.000', 'PE'),
    ('200.041.112.000', 'VE'),
    ('200.041.114.000', 'EC'),
    ('200.041.115.000', 'US'),
    ('200.041.116.000', 'VE'),
    ('200.041.117.000', 'US'),
    ('200.041.120.000', 'AR'),
    ('200.041.240.000', 'CL'),
    ('200.041.244.000', 'AR'),
    ('200.044.000.000', 'VE'),
    ('200.045.000.000', 'AR'),
    ('200.046.000.000', 'PA'),
    ('200.047.000.000', 'AR'),
    ('200.047.079.000', 'VE'),
    ('200.047.080.000', 'AR'),
    ('200.047.150.000', 'VE'),
    ('200.047.152.000', 'AR'),
    ('200.047.156.000', 'CO'),
    ('200.047.159.000', 'MX'),
    ('200.047.160.000', 'AR'),
    ('200.047.172.000', 'CO'),
    ('200.047.178.000', 'AR'),
    ('200.047.179.000', 'MX'),
    ('200.047.180.000', 'VE'),
    ('200.047.184.000', 'MX'),
    ('200.047.185.000', 'PE'),
    ('200.047.187.000', 'MX'),
    ('200.047.189.000', 'AR'),
    ('200.047.209.000', 'PE'),
    ('200.047.210.000', 'AR'),
    ('200.047.215.000', 'VE'),
    ('200.047.216.000', 'CO'),
    ('200.047.221.000', 'AR'),
    ('200.047.222.000', 'PE'),
    ('200.047.224.000', '--'),
    ('200.048.000.000', 'PE'),
    ('200.049.000.000', 'AR'),
    ('200.050.000.000', 'PR'),
    ('200.050.008.000', 'DO'),
    ('200.050.012.000', 'PR'),
    ('200.050.013.000', 'AN'),
    ('200.050.014.000', 'PR'),
    ('200.050.016.000', 'DO'),
    ('200.050.020.000', 'AN'),
    ('200.050.021.000', 'PR'),
    ('200.050.032.000', 'CL'),
    ('200.050.064.000', 'BB'),
    ('200.050.096.000', 'CL'),
    ('200.050.128.000', 'BB'),
    ('200.050.144.000', 'CL'),
    ('200.050.160.000', 'AR'),
    ('200.050.176.000', '--'),
    ('200.050.192.000', 'HT'),
    ('200.050.224.000', '--'),
    ('200.051.000.000', 'AR'),
    ('200.051.144.000', 'UY'),
    ('200.051.164.000', 'AR'),
    ('200.051.172.000', 'CL'),
    ('200.051.176.000', 'AR'),
    ('200.052.000.000', 'MX'),
    ('200.052.084.000', 'US'),
    ('200.052.085.000', 'MX'),
    ('200.054.000.000', 'CL'),
    ('200.055.000.000', 'AR'),
    ('200.055.064.000', '--'),
    ('200.056.000.000', 'MX'),
    ('200.058.000.000', 'US'),
    ('200.058.016.000', 'BR'),
    ('200.058.017.000', 'US'),
    ('200.058.023.000', 'AR'),
    ('200.058.031.000', 'US'),
    ('200.058.048.000', 'BR'),
    ('200.058.049.000', 'US'),
    ('200.058.050.000', 'BR'),
    ('200.058.051.000', 'US'),
    ('200.058.052.000', 'AR'),
    ('200.058.056.000', 'US'),
    ('200.058.064.000', '--'),
    ('200.059.000.000', 'AR'),
    ('200.060.000.000', 'PE'),
    ('200.061.000.000', 'AR'),
    ('200.061.076.000', 'UY'),
    ('200.061.079.000', 'PE'),
    ('200.061.083.000', 'AR'),
    ('200.061.085.000', 'UY'),
    ('200.061.086.000', 'AR'),
    ('200.061.088.000', 'UY'),
    ('200.061.097.000', 'AR'),
    ('200.061.098.000', 'UY'),
    ('200.061.099.000', 'PE'),
    ('200.061.103.000', 'UY'),
    ('200.061.104.000', 'AR'),
    ('200.061.110.000', 'UY'),
    ('200.061.112.000', 'AR'),
    ('200.061.117.000', 'PY'),
    ('200.061.118.000', 'AR'),
    ('200.061.122.000', 'UY'),
    ('200.061.128.000', 'AR'),
    ('200.061.192.000', 'US'),
    ('200.061.224.000', '--'),
    ('200.062.000.000', 'US'),
    ('200.062.008.000', 'VE'),
    ('200.062.032.000', 'GT'),
    ('200.062.040.000', 'US'),
    ('200.062.064.000', '--'),
    ('200.062.128.000', 'PE'),
    ('200.063.000.000', 'AR'),
    ('200.064.000.000', 'MX'),
    ('200.068.000.000', 'CL'),
    ('200.068.064.000', '--'),
    ('200.068.128.000', 'CO'),
    ('200.068.179.000', 'EC'),
    ('200.068.180.000', 'CO'),
    ('200.068.192.000', 'AR'),
    ('200.068.224.000', '--'),
    ('200.069.000.000', 'AR'),
    ('200.069.156.000', 'VN'),
    ('200.069.158.000', 'AR'),
    ('200.069.160.000', '--'),
    ('200.069.192.000', 'AR'),
    ('200.071.000.000', '--'),
    ('200.072.000.000', 'CL'),
    ('200.073.064.000', '--'),
    ('200.073.128.000', 'AR'),
    ('200.073.192.000', '--'),
    ('200.074.000.000', 'CL'),
    ('200.074.032.000', '--'),
    ('200.074.128.000', 'CO'),
    ('200.074.160.000', 'CL'),
    ('200.074.176.000', '--'),
    ('200.074.192.000', 'VE'),
    ('200.074.224.000', '--'),
    ('200.075.000.000', 'CL'),
    ('200.075.032.000', 'CO'),
    ('200.075.080.000', '--'),
    ('200.075.096.000', 'VE'),
    ('200.075.144.000', '--'),
    ('200.075.160.000', 'BO'),
    ('200.075.176.000', '--'),
    ('200.075.192.000', 'PA'),
    ('200.075.224.000', '--'),
    ('200.076.000.000', 'MX'),
    ('200.080.000.000', 'AR'),
    ('200.081.032.000', '--'),
    ('200.081.064.000', 'PY'),
    ('200.081.072.000', 'AR'),
    ('200.081.096.000', '--'),
    ('200.081.128.000', 'AR'),
    ('200.082.064.000', '--'),
    ('200.082.128.000', 'VE'),
    ('200.082.144.000', '--'),
    ('200.083.000.000', 'CL'),
    ('200.084.000.000', 'VE'),
    ('200.085.000.000', 'SV'),
    ('200.085.016.000', '--'),
    ('200.085.032.000', 'PY'),
    ('200.085.048.000', '--'),
    ('200.096.000.000', 'BR'),
    ('200.104.000.000', '--'),
    ('200.128.000.000', 'BR'),
    ('200.204.000.000', 'US'),
    ('200.204.008.000', 'BR'),
    ('201.000.000.000', 'TH'),
    ('201.000.001.000', 'US'),
    ('202.000.000.000', 'AU'),
    ('202.000.010.000', 'NZ'),
    ('202.000.011.000', 'AU'),
    ('202.000.016.000', 'PH'),
    ('202.000.032.000', 'NZ'),
    ('202.000.064.000', 'AU'),
    ('202.000.065.000', 'JP'),
    ('202.000.067.000', 'AU'),
    ('202.000.071.000', 'SG'),
    ('202.000.072.000', 'JP'),
    ('202.000.074.000', 'AU'),
    ('202.000.076.000', 'JP'),
    ('202.000.077.000', 'HK'),
    ('202.000.079.000', 'TH'),
    ('202.000.080.000', 'PG'),
    ('202.000.081.000', 'ID'),
    ('202.000.082.000', 'AU'),
    ('202.000.084.000', 'NZ'),
    ('202.000.085.000', 'AU'),
    ('202.000.088.000', 'SG'),
    ('202.000.090.000', 'AU'),
    ('202.000.091.000', 'PH'),
    ('202.000.092.000', 'AU'),
    ('202.000.093.000', 'JP'),
    ('202.000.094.000', 'MY'),
    ('202.000.095.000', 'AU'),
    ('202.000.097.000', 'NZ'),
    ('202.000.098.000', 'AU'),
    ('202.000.100.000', 'HK'),
    ('202.000.101.000', 'AU'),
    ('202.000.103.000', 'ID'),
    ('202.000.104.000', 'HK'),
    ('202.000.105.000', 'AU'),
    ('202.000.110.000', 'CN'),
    ('202.000.111.000', 'TH'),
    ('202.000.112.000', 'HK'),
    ('202.000.113.000', 'AU'),
    ('202.000.116.000', 'ID'),
    ('202.000.117.000', 'TH'),
    ('202.000.121.000', 'NZ'),
    ('202.000.122.000', 'HK'),
    ('202.000.124.000', 'NZ'),
    ('202.000.126.000', 'SG'),
    ('202.000.128.000', 'HK'),
    ('202.000.148.000', 'AU'),
    ('202.000.149.000', 'SG'),
    ('202.000.151.000', 'NZ'),
    ('202.000.152.000', 'SG'),
    ('202.000.153.000', 'NZ'),
    ('202.000.154.000', 'AU'),
    ('202.000.156.000', 'NC'),
    ('202.000.160.000', 'HK'),
    ('202.000.181.000', 'AU'),
    ('202.000.182.000', 'HK'),
    ('202.000.184.000', 'AU'),
    ('202.000.188.000', 'FR'),
    ('202.000.192.000', 'US'),
    ('202.001.000.000', 'AU'),
    ('202.001.005.000', 'SG'),
    ('202.001.006.000', 'HK'),
    ('202.001.008.000', 'NZ'),
    ('202.001.016.000', 'AU'),
    ('202.001.032.000', 'PG'),
    ('202.001.064.000', 'SG'),
    ('202.001.114.000', 'AU'),
    ('202.001.128.000', 'SG'),
    ('202.001.160.000', 'SB'),
    ('202.001.192.000', 'MV'),
    ('202.001.208.000', 'AU'),
    ('202.001.232.000', 'HK'),
    ('202.001.240.000', 'PG'),
    ('202.002.000.000', 'AU'),
    ('202.002.004.000', 'NZ'),
    ('202.002.016.000', 'AU'),
    ('202.002.032.000', 'HK'),
    ('202.002.052.000', 'TW'),
    ('202.002.056.000', 'AU'),
    ('202.002.064.000', 'HK'),
    ('202.002.088.000', 'AU'),
    ('202.002.096.000', 'TV'),
    ('202.002.128.000', 'JP'),
    ('202.002.133.000', 'AU'),
    ('202.002.134.000', 'HK'),
    ('202.002.135.000', 'SG'),
    ('202.002.136.000', 'TW'),
    ('202.002.137.000', 'IN'),
    ('202.002.138.000', 'PH'),
    ('202.002.139.000', 'IN'),
    ('202.002.140.000', 'SG'),
    ('202.002.141.000', 'HK'),
    ('202.002.142.000', 'SG'),
    ('202.002.143.000', 'HK'),
    ('202.002.145.000', 'KR'),
    ('202.002.146.000', 'HK'),
    ('202.002.147.000', 'JP'),
    ('202.002.148.000', 'CN'),
    ('202.002.149.000', 'MY'),
    ('202.002.150.000', 'JP'),
    ('202.002.152.000', 'KR'),
    ('202.002.153.000', 'JP'),
    ('202.002.154.000', 'PH'),
    ('202.002.155.000', 'AU'),
    ('202.002.156.000', 'PH'),
    ('202.002.157.000', 'AU'),
    ('202.002.159.000', 'MY'),
    ('202.002.160.000', 'JP'),
    ('202.002.161.000', '--'),
    ('202.002.162.000', 'SG'),
    ('202.002.163.000', 'JP'),
    ('202.002.165.000', 'SG'),
    ('202.002.166.000', 'MY'),
    ('202.002.167.000', 'AU'),
    ('202.002.168.000', 'MY'),
    ('202.002.169.000', 'JP'),
    ('202.002.171.000', 'SG'),
    ('202.002.172.000', 'PH'),
    ('202.002.173.000', 'JP'),
    ('202.002.174.000', 'AU'),
    ('202.002.175.000', 'JP'),
    ('202.002.176.000', 'AU'),
    ('202.002.177.000', 'JP'),
    ('202.002.178.000', 'TW'),
    ('202.002.179.000', 'JP'),
    ('202.002.181.000', 'TW'),
    ('202.002.182.000', 'JP'),
    ('202.002.183.000', 'IN'),
    ('202.002.184.000', 'TH'),
    ('202.002.188.000', 'ID'),
    ('202.002.189.000', 'JP'),
    ('202.002.191.000', 'PH'),
    ('202.002.192.000', 'TW'),
    ('202.002.195.000', 'JP'),
    ('202.002.197.000', 'AU'),
    ('202.002.198.000', 'ID'),
    ('202.002.199.000', 'AU'),
    ('202.002.204.000', 'JP'),
    ('202.002.205.000', 'TH'),
    ('202.002.206.000', 'SG'),
    ('202.002.207.000', 'HK'),
    ('202.002.208.000', 'JP'),
    ('202.002.212.000', 'HK'),
    ('202.002.213.000', 'JP'),
    ('202.002.214.000', 'SG'),
    ('202.002.219.000', 'HK'),
    ('202.002.220.000', 'JP'),
    ('202.002.224.000', 'NZ'),
    ('202.002.225.000', 'HK'),
    ('202.002.228.000', 'TH'),
    ('202.002.229.000', 'SG'),
    ('202.002.231.000', 'TH'),
    ('202.002.232.000', 'TW'),
    ('202.002.234.000', 'JP'),
    ('202.002.235.000', 'TH'),
    ('202.002.236.000', 'HK'),
    ('202.002.237.000', 'JP'),
    ('202.002.239.000', 'IN'),
    ('202.002.240.000', 'JP'),
    ('202.002.241.000', 'MY'),
    ('202.002.242.000', 'HK'),
    ('202.002.243.000', 'JP'),
    ('202.002.244.000', 'CN'),
    ('202.002.252.000', 'JP'),
    ('202.002.254.000', 'MY'),
    ('202.002.255.000', 'JP'),
    ('202.003.000.000', 'AU'),
    ('202.003.006.000', 'HK'),
    ('202.003.008.000', 'AU'),
    ('202.003.013.000', 'HK'),
    ('202.003.016.000', 'NZ'),
    ('202.003.032.000', 'AU'),
    ('202.003.096.000', 'ID'),
    ('202.003.128.000', 'PF'),
    ('202.003.129.000', 'AU'),
    ('202.003.144.000', 'PK'),
    ('202.003.160.000', 'TW'),
    ('202.003.192.000', 'ID'),
    ('202.003.224.000', 'PF'),
    ('202.004.000.000', 'PH'),
    ('202.004.016.000', 'NZ'),
    ('202.004.025.000', 'TW'),
    ('202.004.026.000', 'HK'),
    ('202.004.028.000', 'AU'),
    ('202.004.032.000', 'WS'),
    ('202.004.064.000', 'AU'),
    ('202.004.096.000', 'BD'),
    ('202.004.128.000', 'CN'),
    ('202.004.160.000', 'IN'),
    ('202.004.192.000', 'HK'),
    ('202.004.224.000', 'AU'),
    ('202.004.252.000', 'CN'),
    ('202.005.000.000', 'AU'),
    ('202.005.004.000', 'TW'),
    ('202.005.006.000', 'AU'),
    ('202.005.016.000', 'HK'),
    ('202.005.032.000', 'BD'),
    ('202.005.064.000', 'MY'),
    ('202.005.080.000', 'AU'),
    ('202.005.128.000', 'PK'),
    ('202.005.160.000', 'AU'),
    ('202.005.192.000', 'MN'),
    ('202.005.224.000', 'TW'),
    ('202.006.000.000', 'HK'),
    ('202.006.002.000', 'AU'),
    ('202.006.005.000', 'NZ'),
    ('202.006.008.000', 'AU'),
    ('202.006.084.000', 'NZ'),
    ('202.006.088.000', 'AU'),
    ('202.006.090.000', 'TH'),
    ('202.006.091.000', 'AU'),
    ('202.006.095.000', 'KR'),
    ('202.006.096.000', 'AU'),
    ('202.006.098.000', 'JP'),
    ('202.006.099.000', 'AU'),
    ('202.006.100.000', 'TH'),
    ('202.006.102.000', 'SG'),
    ('202.006.103.000', 'JP'),
    ('202.006.104.000', 'AU'),
    ('202.006.107.000', 'TH'),
    ('202.006.108.000', 'AU'),
    ('202.006.109.000', 'NZ'),
    ('202.006.111.000', 'TH'),
    ('202.006.112.000', 'AU'),
    ('202.006.192.000', 'HK'),
    ('202.006.208.000', 'AU'),
    ('202.006.252.000', 'JP'),
    ('202.007.000.000', 'NZ'),
    ('202.007.002.000', 'AU'),
    ('202.007.004.000', 'NZ'),
    ('202.007.008.000', 'AU'),
    ('202.007.032.000', 'NZ'),
    ('202.007.052.000', 'AU'),
    ('202.007.060.000', 'NZ'),
    ('202.007.064.000', 'AU'),
    ('202.007.128.000', 'HK'),
    ('202.007.144.000', 'AU'),
    ('202.008.000.000', 'SG'),
    ('202.008.006.000', 'AU'),
    ('202.008.008.000', 'NZ'),
    ('202.008.013.000', 'AU'),
    ('202.008.064.000', 'TH'),
    ('202.008.076.000', 'AU'),
    ('202.008.094.000', 'SG'),
    ('202.008.096.000', 'AU'),
    ('202.008.128.000', 'JP'),
    ('202.008.160.000', 'TW'),
    ('202.008.192.000', 'AU'),
    ('202.008.224.000', 'PH'),
    ('202.009.000.000', 'AU'),
    ('202.009.064.000', 'MY'),
    ('202.009.112.000', 'AU'),
    ('202.009.128.000', 'IN'),
    ('202.009.208.000', 'AU'),
    ('202.010.032.000', 'ID'),
    ('202.010.064.000', 'AU'),
    ('202.011.000.000', 'JP'),
    ('202.012.000.000', 'NZ'),
    ('202.012.001.000', 'AU'),
    ('202.012.002.000', 'SG'),
    ('202.012.003.000', 'NZ'),
    ('202.012.004.000', 'HK'),
    ('202.012.008.000', 'JP'),
    ('202.012.016.000', 'AU'),
    ('202.012.017.000', 'PH'),
    ('202.012.019.000', 'US'),
    ('202.012.020.000', 'ID'),
    ('202.012.021.000', 'US'),
    ('202.012.022.000', 'AU'),
    ('202.012.026.000', 'BN'),
    ('202.012.027.000', 'JP'),
    ('202.012.029.000', 'AU'),
    ('202.012.030.000', 'JP'),
    ('202.012.031.000', 'AU'),
    ('202.012.070.000', 'NZ'),
    ('202.012.071.000', 'AU'),
    ('202.012.073.000', 'TH'),
    ('202.012.075.000', 'AU'),
    ('202.012.076.000', 'NZ'),
    ('202.012.086.000', 'AU'),
    ('202.012.091.000', 'NZ'),
    ('202.012.092.000', 'AU'),
    ('202.012.094.000', 'SG'),
    ('202.012.096.000', 'NZ'),
    ('202.012.097.000', 'TH'),
    ('202.012.098.000', 'AU'),
    ('202.012.101.000', 'NZ'),
    ('202.012.106.000', 'AU'),
    ('202.012.108.000', 'NZ'),
    ('202.012.109.000', 'AU'),
    ('202.012.116.000', 'TH'),
    ('202.012.117.000', 'AU'),
    ('202.012.122.000', 'NZ'),
    ('202.012.125.000', 'AU'),
    ('202.013.000.000', 'JP'),
    ('202.014.000.000', 'AU'),
    ('202.014.008.000', 'TW'),
    ('202.014.016.000', 'NZ'),
    ('202.014.064.000', 'AU'),
    ('202.014.067.000', 'HK'),
    ('202.014.069.000', 'AU'),
    ('202.014.073.000', 'NZ'),
    ('202.014.076.000', 'AU'),
    ('202.014.080.000', 'HK'),
    ('202.014.081.000', 'AU'),
    ('202.014.082.000', 'NZ'),
    ('202.014.085.000', 'AU'),
    ('202.014.088.000', 'CN'),
    ('202.014.089.000', 'AU'),
    ('202.014.090.000', 'TH'),
    ('202.014.095.000', 'AU'),
    ('202.014.096.000', 'NZ'),
    ('202.014.098.000', 'AU'),
    ('202.014.099.000', 'NZ'),
    ('202.014.101.000', 'AU'),
    ('202.014.102.000', 'NZ'),
    ('202.014.103.000', 'KR'),
    ('202.014.104.000', 'AU'),
    ('202.014.106.000', 'NZ'),
    ('202.014.110.000', 'AU'),
    ('202.014.114.000', 'NZ'),
    ('202.014.116.000', 'HK'),
    ('202.014.117.000', 'TH'),
    ('202.014.118.000', 'AU'),
    ('202.014.127.000', 'NZ'),
    ('202.014.128.000', 'AU'),
    ('202.014.135.000', 'NZ'),
    ('202.014.137.000', 'AU'),
    ('202.014.140.000', 'NZ'),
    ('202.014.143.000', 'AU'),
    ('202.014.149.000', 'NZ'),
    ('202.014.151.000', 'AU'),
    ('202.014.153.000', 'SG'),
    ('202.014.155.000', 'AU'),
    ('202.014.162.000', 'TH'),
    ('202.014.165.000', 'KR'),
    ('202.014.166.000', 'AU'),
    ('202.014.167.000', 'NZ'),
    ('202.014.169.000', 'AU'),
    ('202.014.216.000', 'NZ'),
    ('202.014.219.000', 'AU'),
    ('202.014.222.000', 'HK'),
    ('202.014.223.000', 'AU'),
    ('202.014.224.000', 'NZ'),
    ('202.014.229.000', 'AU'),
    ('202.014.235.000', 'CN'),
    ('202.014.239.000', 'AU'),
    ('202.014.252.000', 'NZ'),
    ('202.014.255.000', 'AU'),
    ('202.015.000.000', 'JP'),
    ('202.020.000.000', 'NZ'),
    ('202.020.008.000', 'AU'),
    ('202.020.032.000', 'NZ'),
    ('202.020.066.000', 'HK'),
    ('202.020.067.000', 'TH'),
    ('202.020.069.000', 'AU'),
    ('202.020.076.000', 'NZ'),
    ('202.020.081.000', 'AU'),
    ('202.020.082.000', 'KR'),
    ('202.020.087.000', 'TH'),
    ('202.020.088.000', 'HK'),
    ('202.020.090.000', 'JP'),
    ('202.020.091.000', 'NZ'),
    ('202.020.094.000', 'HK'),
    ('202.020.096.000', 'NZ'),
    ('202.020.098.000', 'HK'),
    ('202.020.099.000', 'KR'),
    ('202.020.100.000', 'HK'),
    ('202.020.102.000', 'NZ'),
    ('202.020.105.000', 'TH'),
    ('202.020.106.000', 'ID'),
    ('202.020.110.000', 'AU'),
    ('202.020.111.000', 'HK'),
    ('202.020.112.000', 'GU'),
    ('202.020.113.000', 'NZ'),
    ('202.020.114.000', 'SG'),
    ('202.020.115.000', 'AU'),
    ('202.020.117.000', 'HK'),
    ('202.020.119.000', 'KR'),
    ('202.020.120.000', 'CN'),
    ('202.020.121.000', 'NZ'),
    ('202.020.123.000', 'JP'),
    ('202.020.125.000', 'HK'),
    ('202.020.128.000', 'KR'),
    ('202.021.008.000', 'AU'),
    ('202.021.016.000', 'NZ'),
    ('202.021.032.000', 'LK'),
    ('202.021.064.000', 'NZ'),
    ('202.021.112.000', 'JP'),
    ('202.021.128.000', 'HK'),
    ('202.021.129.000', 'AU'),
    ('202.021.130.000', 'NZ'),
    ('202.021.134.000', 'AU'),
    ('202.021.138.000', 'NZ'),
    ('202.021.140.000', 'TH'),
    ('202.021.141.000', 'NZ'),
    ('202.021.144.000', 'TH'),
    ('202.021.145.000', 'AU'),
    ('202.021.146.000', 'SG'),
    ('202.021.147.000', 'IN'),
    ('202.021.148.000', 'MY'),
    ('202.021.149.000', 'TH'),
    ('202.021.150.000', 'JP'),
    ('202.021.154.000', 'SG'),
    ('202.021.155.000', 'NZ'),
    ('202.021.158.000', 'AU'),
    ('202.021.160.000', 'JP'),
    ('202.021.176.000', 'AU'),
    ('202.021.192.000', 'SG'),
    ('202.022.000.000', 'NZ'),
    ('202.022.008.000', 'TH'),
    ('202.022.016.000', 'NZ'),
    ('202.022.031.000', 'AU'),
    ('202.022.032.000', 'TH'),
    ('202.022.064.000', 'JP'),
    ('202.022.128.000', 'NC'),
    ('202.022.160.000', 'AU'),
    ('202.022.176.000', 'GU'),
    ('202.022.178.000', 'AU'),
    ('202.022.179.000', 'GU'),
    ('202.022.192.000', 'BD'),
    ('202.022.208.000', 'AU'),
    ('202.022.248.000', 'CN'),
    ('202.023.000.000', 'JP'),
    ('202.027.000.000', 'NZ'),
    ('202.027.016.000', 'SG'),
    ('202.027.032.000', 'NZ'),
    ('202.028.000.000', 'TH'),
    ('202.030.000.000', 'KR'),
    ('202.032.000.000', 'JP'),
    ('202.036.000.000', 'NZ'),
    ('202.038.000.000', 'CN'),
    ('202.038.016.000', 'HK'),
    ('202.038.032.000', 'SG'),
    ('202.038.048.000', 'AU'),
    ('202.038.064.000', 'CN'),
    ('202.038.139.000', 'AU'),
    ('202.038.140.000', 'CN'),
    ('202.038.144.000', 'AU'),
    ('202.038.146.000', 'CN'),
    ('202.038.148.000', 'AU'),
    ('202.038.149.000', 'CN'),
    ('202.038.151.000', 'SG'),
    ('202.038.152.000', 'CN'),
    ('202.038.157.000', 'AU'),
    ('202.038.160.000', 'CN'),
    ('202.038.162.000', 'AU'),
    ('202.038.164.000', 'CN'),
    ('202.038.178.000', 'AU'),
    ('202.038.192.000', 'CN'),
    ('202.039.000.000', 'TW'),
    ('202.040.000.000', 'HK'),
    ('202.040.049.000', 'NZ'),
    ('202.040.050.000', 'HK'),
    ('202.040.163.000', 'AU'),
    ('202.040.164.000', 'HK'),
    ('202.040.172.000', 'AU'),
    ('202.040.192.000', 'HK'),
    ('202.040.224.000', 'SG'),
    ('202.041.000.000', 'IN'),
    ('202.041.001.000', 'AU'),
    ('202.041.004.000', 'IN'),
    ('202.041.014.000', 'AU'),
    ('202.041.016.000', 'IN'),
    ('202.041.130.000', 'US'),
    ('202.041.131.000', 'IN'),
    ('202.041.134.000', 'AU'),
    ('202.041.160.000', 'HK'),
    ('202.041.192.000', 'IN'),
    ('202.041.193.000', 'AU'),
    ('202.041.224.000', 'IN'),
    ('202.041.240.000', 'AU'),
    ('202.042.000.000', 'SG'),
    ('202.042.164.000', 'DE'),
    ('202.042.165.000', 'SG'),
    ('202.043.000.000', 'AU'),
    ('202.043.032.000', 'IN'),
    ('202.043.064.000', 'TW'),
    ('202.043.128.000', 'PH'),
    ('202.043.160.000', 'ID'),
    ('202.043.192.000', 'PH'),
    ('202.043.224.000', 'AU'),
    ('202.043.248.000', 'ID'),
    ('202.044.000.000', 'TH'),
    ('202.044.052.000', 'AU'),
    ('202.044.060.000', 'TH'),
    ('202.044.075.000', 'AU'),
    ('202.044.096.000', 'TH'),
    ('202.044.097.000', 'AU'),
    ('202.044.112.000', 'IO'),
    ('202.044.116.000', 'AU'),
    ('202.044.128.000', 'TH'),
    ('202.044.137.000', 'AU'),
    ('202.044.138.000', 'TH'),
    ('202.044.152.000', 'AU'),
    ('202.044.192.000', 'TH'),
    ('202.045.000.000', 'DE'),
    ('202.045.001.000', 'HK'),
    ('202.045.003.000', 'AU'),
    ('202.045.004.000', 'HK'),
    ('202.045.006.000', 'AU'),
    ('202.045.008.000', 'HK'),
    ('202.045.010.000', 'AU'),
    ('202.045.015.000', 'HK'),
    ('202.045.096.000', 'AU'),
    ('202.045.128.000', 'HK'),
    ('202.045.129.000', 'AU'),
    ('202.045.160.000', 'HK'),
    ('202.046.000.000', 'ID'),
    ('202.046.019.000', 'AU'),
    ('202.046.020.000', 'ID'),
    ('202.046.022.000', 'AU'),
    ('202.046.024.000', 'ID'),
    ('202.046.032.000', 'AU'),
    ('202.046.064.000', 'ID'),
    ('202.046.112.000', 'AU'),
    ('202.046.128.000', 'ID'),
    ('202.046.132.000', 'AU'),
    ('202.046.144.000', 'ID'),
    ('202.046.160.000', 'NZ'),
    ('202.046.192.000', 'IN'),
    ('202.046.208.000', 'AU'),
    ('202.046.240.000', 'ID'),
    ('202.047.000.000', 'PH'),
    ('202.047.016.000', 'AU'),
    ('202.047.064.000', 'ID'),
    ('202.047.080.000', 'AU'),
    ('202.047.125.000', 'PH'),
    ('202.047.127.000', 'AU'),
    ('202.047.128.000', 'PH'),
    ('202.047.130.000', 'DE'),
    ('202.047.131.000', 'PH'),
    ('202.047.134.000', 'AU'),
    ('202.047.136.000', 'PH'),
    ('202.047.142.000', 'AU'),
    ('202.047.160.000', 'MY'),
    ('202.047.192.000', 'ID'),
    ('202.047.224.000', 'TH'),
    ('202.048.000.000', 'JP'),
    ('202.049.000.000', 'NZ'),
    ('202.051.000.000', 'NP'),
    ('202.051.004.000', 'AU'),
    ('202.051.032.000', 'IN'),
    ('202.051.064.000', 'NP'),
    ('202.051.096.000', 'ID'),
    ('202.051.128.000', 'LK'),
    ('202.051.160.000', 'AU'),
    ('202.051.192.000', 'ID'),
    ('202.051.240.000', 'AU'),
    ('202.051.252.000', 'ID'),
    ('202.052.000.000', 'NP'),
    ('202.052.002.000', 'AU'),
    ('202.052.032.000', 'IN'),
    ('202.052.064.000', 'TW'),
    ('202.052.128.000', 'HK'),
    ('202.052.160.000', 'AU'),
    ('202.052.192.000', 'HK'),
    ('202.052.208.000', 'AU'),
    ('202.052.224.000', 'NP'),
    ('202.053.004.000', 'AU'),
    ('202.053.064.000', 'IN'),
    ('202.053.112.000', 'AU'),
    ('202.053.128.000', 'HK'),
    ('202.053.160.000', 'BD'),
    ('202.053.176.000', 'AU'),
    ('202.053.224.000', 'ID'),
    ('202.054.000.000', 'IN'),
    ('202.055.032.000', 'CN'),
    ('202.055.033.000', 'HK'),
    ('202.055.035.000', 'CN'),
    ('202.055.045.000', 'HK'),
    ('202.055.047.000', 'CN'),
    ('202.055.048.000', 'AU'),
    ('202.055.064.000', 'SG'),
    ('202.055.096.000', 'AU'),
    ('202.055.128.000', 'ID'),
    ('202.055.144.000', 'AU'),
    ('202.055.160.000', 'ID'),
    ('202.055.176.000', 'AU'),
    ('202.055.192.000', 'IN'),
    ('202.055.224.000', 'TW'),
    ('202.056.000.000', 'IN'),
    ('202.056.004.000', 'AU'),
    ('202.056.064.000', 'SG'),
    ('202.056.080.000', 'AU'),
    ('202.056.096.000', 'PH'),
    ('202.056.128.000', 'SG'),
    ('202.056.152.000', 'MY'),
    ('202.056.154.000', 'PH'),
    ('202.056.156.000', 'MY'),
    ('202.056.158.000', 'TH'),
    ('202.056.160.000', 'IN'),
    ('202.056.176.000', 'AU'),
    ('202.056.192.000', 'IN'),
    ('202.057.000.000', 'ID'),
    ('202.057.006.000', 'AU'),
    ('202.057.016.000', 'ID'),
    ('202.057.032.000', 'PH'),
    ('202.057.128.000', 'TH'),
    ('202.057.192.000', 'HK'),
    ('202.057.224.000', 'AU'),
    ('202.057.240.000', 'HK'),
    ('202.058.000.000', 'LA'),
    ('202.058.001.000', 'AU'),
    ('202.058.064.000', 'ID'),
    ('202.058.080.000', 'AU'),
    ('202.058.096.000', 'PH'),
    ('202.058.105.000', 'US'),
    ('202.058.106.000', 'PH'),
    ('202.058.128.000', 'PG'),
    ('202.058.132.000', 'AU'),
    ('202.058.160.000', 'IN'),
    ('202.058.192.000', 'ID'),
    ('202.058.208.000', 'AU'),
    ('202.058.240.000', 'PH'),
    ('202.059.000.000', 'TO'),
    ('202.059.001.000', 'AU'),
    ('202.059.064.000', 'PK'),
    ('202.059.096.000', 'AU'),
    ('202.059.128.000', 'PH'),
    ('202.059.160.000', 'ID'),
    ('202.059.176.000', 'AU'),
    ('202.059.224.000', 'TH'),
    ('202.060.000.000', 'MU'),
    ('202.060.008.000', 'AU'),
    ('202.060.032.000', 'HK'),
    ('202.060.064.000', 'TW'),
    ('202.060.096.000', 'HK'),
    ('202.060.112.000', 'AU'),
    ('202.060.128.000', 'IN'),
    ('202.060.160.000', 'HK'),
    ('202.060.176.000', 'AU'),
    ('202.060.192.000', 'TH'),
    ('202.060.208.000', 'AU'),
    ('202.060.224.000', 'HK'),
    ('202.061.000.000', 'PG'),
    ('202.061.001.000', 'AU'),
    ('202.061.032.000', 'TW'),
    ('202.061.064.000', 'PH'),
    ('202.061.096.000', 'HK'),
    ('202.061.128.000', 'AU'),
    ('202.062.000.000', 'FJ'),
    ('202.062.008.000', 'AU'),
    ('202.062.064.000', 'IN'),
    ('202.062.096.000', 'AU'),
    ('202.062.118.000', 'FJ'),
    ('202.062.128.000', 'AU'),
    ('202.062.192.000', 'HK'),
    ('202.062.224.000', 'AU'),
    ('202.063.000.000', 'HK'),
    ('202.063.032.000', 'SG'),
    ('202.063.033.000', 'LK'),
    ('202.063.034.000', 'SG'),
    ('202.063.048.000', 'AU'),
    ('202.063.096.000', 'IN'),
    ('202.063.128.000', 'SG'),
    ('202.063.160.000', 'AU'),
    ('202.063.192.000', 'PK'),
    ('202.063.224.000', 'AU'),
    ('202.063.254.000', 'SB'),
    ('202.064.000.000', 'HK'),
    ('202.065.010.000', 'AU'),
    ('202.065.032.000', 'CK'),
    ('202.065.064.000', 'AU'),
    ('202.065.096.000', 'HK'),
    ('202.065.112.000', 'AU'),
    ('202.065.128.000', 'IN'),
    ('202.065.160.000', 'HK'),
    ('202.065.176.000', 'AU'),
    ('202.065.192.000', 'HK'),
    ('202.065.224.000', 'ID'),
    ('202.065.240.000', 'AU'),
    ('202.065.248.000', 'HK'),
    ('202.066.128.000', 'CN'),
    ('202.066.192.000', 'HK'),
    ('202.067.004.000', 'AU'),
    ('202.067.032.000', 'ID'),
    ('202.067.048.000', 'AU'),
    ('202.067.128.000', 'HK'),
    ('202.068.064.000', 'AU'),
    ('202.068.096.000', 'HK'),
    ('202.068.128.000', 'IN'),
    ('202.068.160.000', 'AU'),
    ('202.068.192.000', 'HK'),
    ('202.068.208.000', 'AU'),
    ('202.068.224.000', 'HK'),
    ('202.069.004.000', 'AU'),
    ('202.069.032.000', 'PK'),
    ('202.069.048.000', 'AU'),
    ('202.069.064.000', 'HK'),
    ('202.069.096.000', 'AU'),
    ('202.069.128.000', 'HK'),
    ('202.069.132.000', 'AU'),
    ('202.069.160.000', 'PH'),
    ('202.069.176.000', 'AU'),
    ('202.069.192.000', 'LK'),
    ('202.069.208.000', 'AU'),
    ('202.069.240.000', 'HK'),
    ('202.070.024.000', 'CN'),
    ('202.070.025.000', 'HK'),
    ('202.070.032.000', 'MN'),
    ('202.070.048.000', 'ID'),
    ('202.070.064.000', 'NP'),
    ('202.070.096.000', 'AU'),
    ('202.070.128.000', 'HK'),
    ('202.070.160.000', 'AU'),
    ('202.070.192.000', 'IN'),
    ('202.070.208.000', 'AU'),
    ('202.070.240.000', 'HK'),
    ('202.071.032.000', 'AU'),
    ('202.071.096.000', 'MY'),
    ('202.071.112.000', 'AU'),
    ('202.071.128.000', 'IN'),
    ('202.071.160.000', 'AU'),
    ('202.071.192.000', 'HK'),
    ('202.072.032.000', 'ID'),
    ('202.072.048.000', 'AU'),
    ('202.072.064.000', 'PH'),
    ('202.072.080.000', 'AU'),
    ('202.072.192.000', 'ID'),
    ('202.072.208.000', 'AU'),
    ('202.072.224.000', 'ID'),
    ('202.072.240.000', 'AU'),
    ('202.072.252.000', 'HK'),
    ('202.073.004.000', 'AU'),
    ('202.073.016.000', 'ID'),
    ('202.073.032.000', 'SG'),
    ('202.073.048.000', 'AU'),
    ('202.073.064.000', 'HK'),
    ('202.073.096.000', 'AU'),
    ('202.073.128.000', 'HK'),
    ('202.073.132.000', 'AU'),
    ('202.073.160.000', 'PH'),
    ('202.073.224.000', 'ID'),
    ('202.073.240.000', 'HK'),
    ('202.074.004.000', 'AU'),
    ('202.074.032.000', 'TH'),
    ('202.074.064.000', 'AU'),
    ('202.074.080.000', 'HK'),
    ('202.074.128.000', 'AU'),
    ('202.074.192.000', 'NZ'),
    ('202.074.208.000', 'AU'),
    ('202.074.254.000', 'HK'),
    ('202.075.004.000', 'AU'),
    ('202.075.016.000', 'ID'),
    ('202.075.032.000', 'MY'),
    ('202.075.048.000', 'AU'),
    ('202.075.064.000', 'HK'),
    ('202.075.096.000', 'ID'),
    ('202.075.112.000', 'AU'),
    ('202.075.128.000', 'MY'),
    ('202.075.192.000', 'IN'),
    ('202.075.208.000', 'AU'),
    ('202.075.252.000', 'HK'),
    ('202.076.128.000', 'AU'),
    ('202.076.192.000', 'IN'),
    ('202.076.208.000', 'AU'),
    ('202.076.252.000', 'HK'),
    ('202.077.064.000', 'ID'),
    ('202.077.080.000', 'AU'),
    ('202.077.096.000', 'ID'),
    ('202.077.128.000', 'HK'),
    ('202.077.244.000', 'ID'),
    ('202.077.245.000', 'HK'),
    ('202.078.008.000', 'AU'),
    ('202.078.064.000', 'PH'),
    ('202.078.128.000', 'NZ'),
    ('202.078.160.000', 'AU'),
    ('202.078.192.000', 'HK'),
    ('202.078.208.000', 'AU'),
    ('202.078.252.000', 'HK'),
    ('202.079.016.000', 'AU'),
    ('202.079.032.000', 'NP'),
    ('202.079.064.000', 'SG'),
    ('202.079.128.000', 'PH'),
    ('202.079.160.000', 'AU'),
    ('202.079.192.000', 'SG'),
    ('202.079.224.000', 'AU'),
    ('202.079.252.000', 'HK'),
    ('202.080.032.000', 'VU'),
    ('202.080.048.000', 'AU'),
    ('202.080.096.000', 'AP'),
    ('202.080.112.000', 'AU'),
    ('202.080.128.000', 'TW'),
    ('202.080.176.000', 'AU'),
    ('202.080.224.000', 'TH'),
    ('202.081.000.000', 'HK'),
    ('202.081.004.000', 'AU'),
    ('202.081.032.000', 'ID'),
    ('202.081.048.000', 'AU'),
    ('202.081.160.000', 'PH'),
    ('202.081.176.000', 'AU'),
    ('202.081.192.000', 'IN'),
    ('202.081.208.000', 'AU'),
    ('202.081.240.000', 'HK'),
    ('202.082.008.000', 'AU'),
    ('202.082.010.000', 'HK'),
    ('202.083.000.000', 'AU'),
    ('202.083.004.000', 'HK'),
    ('202.083.016.000', 'AU'),
    ('202.083.032.000', 'NZ'),
    ('202.083.064.000', 'AU'),
    ('202.083.128.000', 'JP'),
    ('202.083.160.000', 'AU'),
    ('202.083.192.000', 'HK'),
    ('202.083.208.000', 'AU'),
    ('202.083.252.000', 'HK'),
    ('202.084.018.000', 'AU'),
    ('202.084.032.000', 'BD'),
    ('202.084.048.000', 'AU'),
    ('202.084.064.000', 'HK'),
    ('202.084.080.000', 'AU'),
    ('202.084.128.000', 'HK'),
    ('202.084.146.000', 'TW'),
    ('202.084.148.000', 'HK'),
    ('202.084.191.000', 'TW'),
    ('202.084.192.000', 'HK'),
    ('202.085.208.000', 'AU'),
    ('202.085.224.000', 'HK'),
    ('202.085.240.000', 'AU'),
    ('202.085.248.000', 'HK'),
    ('202.086.004.000', 'AU'),
    ('202.086.064.000', 'HK'),
    ('202.086.096.000', 'AU'),
    ('202.086.128.000', 'IN'),
    ('202.086.192.000', 'AU'),
    ('202.086.252.000', 'HK'),
    ('202.087.004.000', 'AU'),
    ('202.087.032.000', 'IN'),
    ('202.087.064.000', 'AU'),
    ('202.087.080.000', 'PK'),
    ('202.087.128.000', 'NC'),
    ('202.087.160.000', 'AU'),
    ('202.087.192.000', 'ID'),
    ('202.087.208.000', 'AU'),
    ('202.087.252.000', 'HK'),
    ('202.088.032.000', 'AU'),
    ('202.088.096.000', 'HK'),
    ('202.088.128.000', 'IN'),
    ('202.088.176.000', 'AU'),
    ('202.088.200.000', 'HK'),
    ('202.088.208.000', 'AU'),
    ('202.088.224.000', 'IN'),
    ('202.088.240.000', 'AU'),
    ('202.089.000.000', 'HK'),
    ('202.089.004.000', 'AU'),
    ('202.089.032.000', 'NZ'),
    ('202.089.064.000', 'IN'),
    ('202.089.080.000', 'AU'),
    ('202.089.096.000', 'PH'),
    ('202.089.128.000', 'NZ'),
    ('202.089.160.000', 'AU'),
    ('202.089.192.000', 'IN'),
    ('202.089.208.000', 'AU'),
    ('202.089.252.000', 'HK'),
    ('202.090.000.000', 'CN'),
    ('202.090.004.000', 'AU'),
    ('202.090.064.000', 'TW'),
    ('202.090.096.000', 'AU'),
    ('202.090.128.000', 'PH'),
    ('202.090.160.000', 'AU'),
    ('202.090.192.000', 'IN'),
    ('202.090.208.000', 'AU'),
    ('202.090.252.000', 'CN'),
    ('202.091.004.000', 'AU'),
    ('202.091.064.000', 'IN'),
    ('202.091.096.000', 'AU'),
    ('202.091.128.000', 'CN'),
    ('202.091.132.000', 'AU'),
    ('202.091.160.000', 'PH'),
    ('202.091.176.000', 'AU'),
    ('202.091.224.000', 'HK'),
    ('202.092.000.000', 'CN'),
    ('202.092.004.000', 'AU'),
    ('202.092.128.000', 'HK'),
    ('202.092.160.000', 'AU'),
    ('202.092.192.000', 'ID'),
    ('202.092.208.000', 'AU'),
    ('202.092.252.000', 'CN'),
    ('202.093.004.000', 'AU'),
    ('202.093.032.000', 'ID'),
    ('202.093.048.000', 'AU'),
    ('202.093.064.000', 'PH'),
    ('202.093.096.000', 'AU'),
    ('202.093.128.000', 'IN'),
    ('202.093.160.000', 'AU'),
    ('202.093.192.000', 'HK'),
    ('202.093.208.000', 'AU'),
    ('202.093.252.000', 'CN'),
    ('202.094.032.000', 'AU'),
    ('202.094.160.000', 'MY'),
    ('202.094.176.000', 'AU'),
    ('202.094.192.000', 'TW'),
    ('202.094.208.000', 'AU'),
    ('202.095.000.000', 'CN'),
    ('202.095.032.000', 'HK'),
    ('202.095.048.000', 'AU'),
    ('202.095.064.000', 'SG'),
    ('202.095.065.000', 'AU'),
    ('202.095.066.000', 'SG'),
    ('202.095.103.000', 'AU'),
    ('202.095.104.000', 'SG'),
    ('202.095.106.000', 'AU'),
    ('202.095.107.000', 'SG'),
    ('202.095.112.000', 'AU'),
    ('202.095.113.000', 'SG'),
    ('202.095.128.000', 'ID'),
    ('202.095.160.000', 'JP'),
    ('202.095.176.000', 'AU'),
    ('202.095.192.000', 'HK'),
    ('202.095.208.000', 'AU'),
    ('202.095.224.000', 'PH'),
    ('202.095.240.000', 'AU'),
    ('202.095.252.000', 'CN'),
    ('202.121.013.000', 'MY'),
    ('202.121.014.000', 'CN'),
    ('202.122.008.000', 'AU'),
    ('202.122.032.000', 'CN'),
    ('202.122.040.000', 'AU'),
    ('202.122.064.000', 'HK'),
    ('202.122.096.000', 'AU'),
    ('202.122.128.000', 'CN'),
    ('202.122.129.000', 'AU'),
    ('202.122.192.000', 'HK'),
    ('202.123.000.000', 'MU'),
    ('202.123.032.000', 'IN'),
    ('202.123.048.000', 'AU'),
    ('202.123.064.000', 'HK'),
    ('202.123.096.000', 'AU'),
    ('202.123.128.000', 'GU'),
    ('202.123.160.000', 'HK'),
    ('202.123.176.000', 'AU'),
    ('202.123.192.000', 'HK'),
    ('202.123.224.000', 'AU'),
    ('202.124.000.000', 'HK'),
    ('202.124.016.000', 'AU'),
    ('202.124.128.000', 'PH'),
    ('202.124.144.000', 'AU'),
    ('202.124.160.000', 'LK'),
    ('202.124.176.000', 'AU'),
    ('202.124.192.000', 'PK'),
    ('202.124.208.000', 'AU'),
    ('202.125.080.000', 'IN'),
    ('202.125.096.000', 'TH'),
    ('202.125.112.000', 'AU'),
    ('202.125.128.000', 'PK'),
    ('202.125.160.000', 'AU'),
    ('202.126.000.000', 'SG'),
    ('202.126.001.000', 'JP'),
    ('202.126.002.000', 'SG'),
    ('202.126.003.000', 'AU'),
    ('202.126.004.000', 'SG'),
    ('202.126.016.000', 'AU'),
    ('202.126.128.000', 'SG'),
    ('202.126.192.000', 'AU'),
    ('202.127.000.000', 'CN'),
    ('202.127.008.000', 'AU'),
    ('202.127.012.000', 'CN'),
    ('202.127.032.000', 'AU'),
    ('202.127.040.000', 'CN'),
    ('202.127.064.000', 'HK'),
    ('202.127.080.000', 'AU'),
    ('202.127.096.000', 'ID'),
    ('202.127.112.000', 'AU'),
    ('202.127.128.000', 'CN'),
    ('202.127.168.000', 'AU'),
    ('202.127.192.000', 'CN'),
    ('202.127.216.000', 'AU'),
    ('202.128.000.000', 'GU'),
    ('202.128.032.000', 'HK'),
    ('202.128.048.000', 'AU'),
    ('202.128.064.000', 'GU'),
    ('202.128.096.000', 'AU'),
    ('202.128.128.000', 'HK'),
    ('202.128.133.000', 'KR'),
    ('202.128.135.000', 'HK'),
    ('202.128.136.000', 'KR'),
    ('202.128.144.000', 'HK'),
    ('202.128.160.000', 'SG'),
    ('202.128.224.000', 'HK'),
    ('202.129.000.000', 'TH'),
    ('202.129.064.000', 'AU'),
    ('202.129.192.000', 'TW'),
    ('202.130.000.000', 'CN'),
    ('202.130.032.000', 'TW'),
    ('202.130.064.000', 'HK'),
    ('202.130.192.000', 'AU'),
    ('202.130.224.000', 'CN'),
    ('202.131.000.000', 'MN'),
    ('202.131.008.000', 'AU'),
    ('202.131.032.000', 'HK'),
    ('202.131.048.000', 'AU'),
    ('202.131.064.000', 'HK'),
    ('202.131.080.000', 'AU'),
    ('202.131.096.000', 'IN'),
    ('202.131.160.000', 'AU'),
    ('202.131.208.000', 'CN'),
    ('202.131.224.000', 'MN'),
    ('202.132.000.000', 'TW'),
    ('202.133.000.000', 'AU'),
    ('202.133.032.000', 'PK'),
    ('202.133.048.000', 'AU'),
    ('202.133.064.000', 'PK'),
    ('202.133.080.000', 'AU'),
    ('202.133.128.000', 'TH'),
    ('202.133.192.000', 'AU'),
    ('202.133.224.000', 'TW'),
    ('202.134.000.000', 'ID'),
    ('202.134.004.000', 'PH'),
    ('202.134.032.000', 'IN'),
    ('202.134.048.000', 'AU'),
    ('202.134.064.000', 'HK'),
    ('202.134.128.000', 'GB'),
    ('202.134.144.000', 'AU'),
    ('202.134.192.000', 'IN'),
    ('202.134.208.000', 'AU'),
    ('202.134.224.000', 'PH'),
    ('202.135.000.000', 'JP'),
    ('202.135.008.000', 'MY'),
    ('202.135.009.000', 'HK'),
    ('202.135.010.000', 'JP'),
    ('202.135.011.000', 'HK'),
    ('202.135.012.000', 'JP'),
    ('202.135.016.000', 'AU'),
    ('202.135.017.000', 'JP'),
    ('202.135.019.000', 'AU'),
    ('202.135.020.000', 'JP'),
    ('202.135.023.000', 'ID'),
    ('202.135.024.000', 'MY'),
    ('202.135.025.000', 'JP'),
    ('202.135.028.000', 'ID'),
    ('202.135.029.000', 'JP'),
    ('202.135.031.000', 'AU'),
    ('202.135.032.000', 'JP'),
    ('202.135.033.000', 'HK'),
    ('202.135.037.000', 'JP'),
    ('202.135.049.000', 'ID'),
    ('202.135.050.000', 'HK'),
    ('202.135.054.000', 'ID'),
    ('202.135.056.000', 'HK'),
    ('202.135.057.000', 'JP'),
    ('202.135.066.000', 'MY'),
    ('202.135.070.000', 'JP'),
    ('202.135.079.000', 'MY'),
    ('202.135.080.000', 'PH'),
    ('202.135.081.000', 'JP'),
    ('202.135.082.000', 'HK'),
    ('202.135.083.000', 'PH'),
    ('202.135.084.000', 'JP'),
    ('202.135.088.000', 'HK'),
    ('202.135.089.000', 'JP'),
    ('202.135.090.000', 'HK'),
    ('202.135.092.000', 'JP'),
    ('202.135.094.000', 'AU'),
    ('202.135.095.000', 'JP'),
    ('202.135.096.000', 'HK'),
    ('202.135.099.000', 'JP'),
    ('202.135.100.000', 'MY'),
    ('202.135.101.000', 'PH'),
    ('202.135.102.000', 'JP'),
    ('202.135.107.000', 'HK'),
    ('202.135.109.000', 'JP'),
    ('202.135.110.000', 'HK'),
    ('202.135.111.000', 'ID'),
    ('202.135.112.000', 'JP'),
    ('202.135.113.000', 'NZ'),
    ('202.135.114.000', 'ID'),
    ('202.135.115.000', 'JP'),
    ('202.135.116.000', 'NZ'),
    ('202.135.117.000', 'HK'),
    ('202.135.118.000', 'JP'),
    ('202.135.119.000', 'HK'),
    ('202.135.120.000', 'AU'),
    ('202.135.121.000', 'JP'),
    ('202.135.122.000', 'MY'),
    ('202.135.127.000', 'JP'),
    ('202.135.129.000', 'ID'),
    ('202.135.130.000', 'HK'),
    ('202.135.133.000', 'JP'),
    ('202.135.136.000', 'AU'),
    ('202.135.137.000', 'JP'),
    ('202.135.138.000', 'HK'),
    ('202.135.141.000', 'KR'),
    ('202.135.142.000', 'AU'),
    ('202.135.143.000', 'MY'),
    ('202.135.144.000', 'HK'),
    ('202.135.145.000', 'JP'),
    ('202.135.147.000', 'AU'),
    ('202.135.148.000', 'HK'),
    ('202.135.149.000', 'AU'),
    ('202.135.150.000', 'HK'),
    ('202.135.152.000', 'AU'),
    ('202.135.153.000', 'HK'),
    ('202.135.155.000', 'ID'),
    ('202.135.156.000', 'AU'),
    ('202.135.157.000', 'HK'),
    ('202.135.158.000', 'JP'),
    ('202.135.159.000', 'ID'),
    ('202.135.160.000', 'HK'),
    ('202.135.161.000', 'ID'),
    ('202.135.162.000', 'HK'),
    ('202.135.165.000', 'AU'),
    ('202.135.166.000', 'HK'),
    ('202.135.167.000', 'PH'),
    ('202.135.168.000', 'JP'),
    ('202.135.169.000', 'HK'),
    ('202.135.170.000', 'MY'),
    ('202.135.171.000', 'JP'),
    ('202.135.173.000', 'AU'),
    ('202.135.174.000', 'HK'),
    ('202.135.175.000', 'KR'),
    ('202.135.176.000', 'AU'),
    ('202.135.177.000', 'HK'),
    ('202.135.179.000', 'AU'),
    ('202.135.180.000', 'HK'),
    ('202.135.182.000', 'NZ'),
    ('202.135.183.000', 'JP'),
    ('202.135.185.000', 'MY'),
    ('202.135.186.000', 'JP'),
    ('202.135.187.000', 'HK'),
    ('202.135.188.000', 'AU'),
    ('202.135.189.000', 'HK'),
    ('202.135.190.000', 'NZ'),
    ('202.135.191.000', 'HK'),
    ('202.135.192.000', 'NZ'),
    ('202.135.193.000', 'JP'),
    ('202.135.195.000', 'AU'),
    ('202.135.196.000', 'JP'),
    ('202.135.198.000', 'HK'),
    ('202.135.200.000', 'JP'),
    ('202.135.203.000', 'MY'),
    ('202.135.204.000', 'SG'),
    ('202.135.205.000', 'JP'),
    ('202.135.206.000', 'AU'),
    ('202.135.210.000', 'HK'),
    ('202.135.214.000', 'JP'),
    ('202.135.215.000', 'SG'),
    ('202.135.217.000', 'AU'),
    ('202.135.220.000', 'JP'),
    ('202.135.221.000', 'SG'),
    ('202.135.222.000', 'HK'),
    ('202.135.223.000', 'JP'),
    ('202.135.225.000', 'HK'),
    ('202.135.226.000', 'JP'),
    ('202.135.227.000', 'HK'),
    ('202.135.228.000', 'JP'),
    ('202.135.229.000', 'PH'),
    ('202.135.230.000', 'JP'),
    ('202.135.231.000', 'NZ'),
    ('202.135.232.000', 'HK'),
    ('202.135.233.000', 'JP'),
    ('202.135.234.000', 'AU'),
    ('202.135.235.000', 'PH'),
    ('202.135.236.000', 'AI'),
    ('202.135.237.000', 'AU'),
    ('202.135.238.000', 'ID'),
    ('202.135.239.000', 'JP'),
    ('202.135.240.000', 'PH'),
    ('202.135.241.000', 'AU'),
    ('202.135.245.000', 'PH'),
    ('202.135.246.000', 'AU'),
    ('202.135.248.000', 'ID'),
    ('202.135.249.000', 'AU'),
    ('202.135.250.000', 'HK'),
    ('202.135.251.000', 'PH'),
    ('202.135.252.000', 'HK'),
    ('202.135.254.000', 'PH'),
    ('202.135.255.000', 'ID'),
    ('202.136.000.000', 'SG'),
    ('202.136.013.000', 'TH'),
    ('202.136.014.000', 'SG'),
    ('202.136.015.000', 'MY'),
    ('202.136.016.000', 'AU'),
    ('202.136.064.000', 'ID'),
    ('202.136.096.000', 'AU'),
    ('202.136.128.000', 'IN'),
    ('202.136.160.000', 'SG'),
    ('202.136.192.000', 'AU'),
    ('202.136.252.000', 'CN'),
    ('202.137.000.000', 'ID'),
    ('202.137.032.000', 'AU'),
    ('202.137.128.000', 'LA'),
    ('202.137.160.000', 'AU'),
    ('202.137.252.000', 'MY'),
    ('202.138.000.000', 'AU'),
    ('202.138.096.000', 'IN'),
    ('202.138.128.000', 'PH'),
    ('202.138.192.000', 'AU'),
    ('202.139.199.000', 'JP'),
    ('202.139.208.000', 'AU'),
    ('202.140.000.000', 'JP'),
    ('202.140.032.000', 'IN'),
    ('202.140.048.000', 'AU'),
    ('202.140.064.000', 'HK'),
    ('202.140.128.000', 'IN'),
    ('202.140.160.000', 'HK'),
    ('202.140.176.000', 'AU'),
    ('202.140.224.000', 'HK'),
    ('202.141.000.000', 'IN'),
    ('202.141.160.000', 'BD'),
    ('202.141.192.000', 'AU'),
    ('202.142.000.000', 'IN'),
    ('202.142.004.000', 'AU'),
    ('202.142.064.000', 'IN'),
    ('202.142.160.000', 'AU'),
    ('202.142.224.000', 'IN'),
    ('202.143.002.000', 'AU'),
    ('202.143.032.000', 'ID'),
    ('202.143.064.000', 'AU'),
    ('202.143.096.000', 'ID'),
    ('202.143.112.000', 'AU'),
    ('202.143.128.000', 'TW'),
    ('202.143.160.000', 'AU'),
    ('202.143.224.000', 'IN'),
    ('202.144.128.000', 'BT'),
    ('202.144.160.000', 'AU'),
    ('202.144.224.000', 'HK'),
    ('202.145.000.000', 'ID'),
    ('202.145.016.000', 'AU'),
    ('202.145.032.000', 'TW'),
    ('202.146.000.000', 'ID'),
    ('202.146.006.000', 'AU'),
    ('202.146.032.000', 'ID'),
    ('202.146.064.000', 'AU'),
    ('202.146.096.000', 'HK'),
    ('202.146.128.000', 'ID'),
    ('202.146.160.000', 'AU'),
    ('202.146.224.000', 'ID'),
    ('202.147.000.000', 'AU'),
    ('202.147.192.000', 'ID'),
    ('202.147.208.000', 'AU'),
    ('202.147.224.000', 'ID'),
    ('202.148.064.000', 'AU'),
    ('202.148.128.000', 'NZ'),
    ('202.148.160.000', 'AU'),
    ('202.149.000.000', 'ID'),
    ('202.149.032.000', 'AU'),
    ('202.149.064.000', 'ID'),
    ('202.149.096.000', 'AU'),
    ('202.149.128.000', 'ID'),
    ('202.149.160.000', 'AU'),
    ('202.149.208.000', 'IN'),
    ('202.149.224.000', 'AU'),
    ('202.149.240.000', 'ID'),
    ('202.150.016.000', 'AU'),
    ('202.150.032.000', 'ID'),
    ('202.150.048.000', 'AU'),
    ('202.150.064.000', 'ID'),
    ('202.150.096.000', 'AU'),
    ('202.150.128.000', 'ID'),
    ('202.150.176.000', 'AU'),
    ('202.150.224.000', 'ID'),
    ('202.151.004.000', 'AU'),
    ('202.151.032.000', 'ID'),
    ('202.151.033.000', 'AU'),
    ('202.151.064.000', 'GU'),
    ('202.151.096.000', 'AU'),
    ('202.151.192.000', 'MY'),
    ('202.152.000.000', 'ID'),
    ('202.152.048.000', 'AU'),
    ('202.152.064.000', 'BN'),
    ('202.152.096.000', 'AU'),
    ('202.152.128.000', 'ID'),
    ('202.152.176.000', 'AU'),
    ('202.152.224.000', 'ID'),
    ('202.153.000.000', 'TH'),
    ('202.153.004.000', 'AU'),
    ('202.153.032.000', 'IN'),
    ('202.153.048.000', 'AU'),
    ('202.153.096.000', 'HK'),
    ('202.153.112.000', 'US'),
    ('202.153.113.000', 'HK'),
    ('202.153.115.000', 'US'),
    ('202.153.116.000', 'HK'),
    ('202.153.128.000', 'ID'),
    ('202.153.160.000', 'IN'),
    ('202.153.192.000', 'AU'),
    ('202.153.224.000', 'ID'),
    ('202.154.037.000', 'AU'),
    ('202.154.038.000', 'ID'),
    ('202.154.046.000', 'AU'),
    ('202.154.047.000', 'ID'),
    ('202.154.049.000', 'AU'),
    ('202.154.050.000', 'ID'),
    ('202.154.064.000', 'AU'),
    ('202.154.128.000', 'NZ'),
    ('202.154.160.000', 'AU'),
    ('202.154.192.000', 'TW'),
    ('202.154.224.000', 'PK'),
    ('202.155.000.000', 'ID'),
    ('202.155.033.000', 'KH'),
    ('202.155.034.000', 'ID'),
    ('202.155.160.000', 'AU'),
    ('202.156.000.000', 'SG'),
    ('202.157.000.000', 'ID'),
    ('202.157.002.000', 'AU'),
    ('202.157.064.000', 'IN'),
    ('202.157.096.000', 'JP'),
    ('202.157.128.000', 'SG'),
    ('202.157.192.000', 'AU'),
    ('202.157.224.000', 'TW'),
    ('202.158.000.000', 'ID'),
    ('202.158.144.000', 'AU'),
    ('202.159.000.000', 'ID'),
    ('202.159.129.000', 'TW'),
    ('202.159.144.000', 'ID'),
    ('202.160.000.000', 'BN'),
    ('202.160.048.000', 'AU'),
    ('202.160.064.000', 'TW'),
    ('202.160.096.000', 'AU'),
    ('202.160.192.000', 'SG'),
    ('202.160.239.000', 'IN'),
    ('202.160.240.000', 'SG'),
    ('202.160.248.000', 'US'),
    ('202.160.249.000', 'SG'),
    ('202.160.252.000', 'PK'),
    ('202.160.253.000', 'SG'),
    ('202.160.254.000', 'ID'),
    ('202.160.255.000', 'SG'),
    ('202.161.000.000', 'AU'),
    ('202.161.032.000', 'SG'),
    ('202.161.064.000', 'AU'),
    ('202.161.128.000', 'US'),
    ('202.161.160.000', 'HK'),
    ('202.161.176.000', 'AU'),
    ('202.161.224.000', 'HK'),
    ('202.162.000.000', 'MY'),
    ('202.162.032.000', 'ID'),
    ('202.162.048.000', 'AU'),
    ('202.162.064.000', 'TW'),
    ('202.162.096.000', 'AU'),
    ('202.162.128.000', 'IN'),
    ('202.162.160.000', 'AU'),
    ('202.162.192.000', 'ID'),
    ('202.162.224.000', 'IN'),
    ('202.163.000.000', 'HK'),
    ('202.163.032.000', 'AU'),
    ('202.163.064.000', 'PK'),
    ('202.163.128.000', 'AU'),
    ('202.163.192.000', 'PH'),
    ('202.164.000.000', 'ID'),
    ('202.164.032.000', 'IN'),
    ('202.164.048.000', 'AU'),
    ('202.164.096.000', 'IN'),
    ('202.164.128.000', 'PH'),
    ('202.164.192.000', 'AU'),
    ('202.165.032.000', 'ID'),
    ('202.165.048.000', 'AU'),
    ('202.165.128.000', 'TW'),
    ('202.165.144.000', 'AU'),
    ('202.165.192.000', 'PG'),
    ('202.165.208.000', 'AU'),
    ('202.165.224.000', 'PK'),
    ('202.166.000.000', 'SG'),
    ('202.166.160.000', 'TW'),
    ('202.167.000.000', 'GU'),
    ('202.167.001.000', 'JP'),
    ('202.167.003.000', 'PH'),
    ('202.167.004.000', 'JP'),
    ('202.167.005.000', 'AU'),
    ('202.167.006.000', 'HK'),
    ('202.167.010.000', 'PH'),
    ('202.167.011.000', 'HK'),
    ('202.167.012.000', 'JP'),
    ('202.167.014.000', 'US'),
    ('202.167.015.000', 'AU'),
    ('202.167.020.000', 'ID'),
    ('202.167.021.000', 'MY'),
    ('202.167.022.000', 'SG'),
    ('202.167.023.000', 'HK'),
    ('202.167.024.000', 'AU'),
    ('202.167.028.000', 'PH'),
    ('202.167.030.000', 'JP'),
    ('202.167.031.000', 'KR'),
    ('202.167.032.000', 'PH'),
    ('202.167.034.000', 'HK'),
    ('202.167.035.000', 'AU'),
    ('202.167.051.000', 'JP'),
    ('202.167.053.000', 'HK'),
    ('202.167.054.000', 'TW'),
    ('202.167.055.000', 'HK'),
    ('202.167.056.000', 'KR'),
    ('202.167.057.000', 'PH'),
    ('202.167.058.000', 'TW'),
    ('202.167.059.000', 'HK'),
    ('202.167.061.000', 'MY'),
    ('202.167.062.000', 'JP'),
    ('202.167.064.000', 'HK'),
    ('202.167.066.000', 'AU'),
    ('202.167.067.000', 'HK'),
    ('202.167.075.000', 'TW'),
    ('202.167.076.000', 'HK'),
    ('202.167.077.000', 'JP'),
    ('202.167.078.000', 'HK'),
    ('202.167.080.000', 'TW'),
    ('202.167.081.000', 'HK'),
    ('202.167.082.000', 'KR'),
    ('202.167.083.000', 'TW'),
    ('202.167.084.000', 'HK'),
    ('202.167.085.000', 'JP'),
    ('202.167.087.000', 'TW'),
    ('202.167.089.000', 'PK'),
    ('202.167.090.000', 'TW'),
    ('202.167.091.000', 'PH'),
    ('202.167.092.000', 'US'),
    ('202.167.093.000', 'HK'),
    ('202.167.095.000', 'JP'),
    ('202.167.096.000', 'PH'),
    ('202.167.097.000', 'ID'),
    ('202.167.098.000', 'AU'),
    ('202.167.099.000', 'KR'),
    ('202.167.100.000', 'US'),
    ('202.167.101.000', 'JP'),
    ('202.167.103.000', 'HK'),
    ('202.167.112.000', 'VN'),
    ('202.167.128.000', 'AU'),
    ('202.167.144.000', 'HK'),
    ('202.167.150.000', 'US'),
    ('202.167.151.000', 'HK'),
    ('202.167.152.000', 'US'),
    ('202.167.155.000', 'HK'),
    ('202.167.157.000', 'US'),
    ('202.167.159.000', 'SG'),
    ('202.167.160.000', 'TW'),
    ('202.167.161.000', 'HK'),
    ('202.167.162.000', 'SG'),
    ('202.167.163.000', 'US'),
    ('202.167.208.000', 'AU'),
    ('202.168.000.000', 'PH'),
    ('202.168.002.000', 'AU'),
    ('202.168.032.000', 'HK'),
    ('202.168.048.000', 'AU'),
    ('202.168.192.000', 'TW'),
    ('202.168.208.000', 'AU'),
    ('202.168.224.000', 'BD'),
    ('202.169.000.000', 'HK'),
    ('202.169.016.000', 'AU'),
    ('202.169.032.000', 'ID'),
    ('202.169.048.000', 'AU'),
    ('202.169.128.000', 'IN'),
    ('202.169.192.000', 'AU'),
    ('202.169.224.000', 'SG'),
    ('202.170.000.000', 'HK'),
    ('202.170.032.000', 'FJ'),
    ('202.170.048.000', 'AU'),
    ('202.170.064.000', 'MN'),
    ('202.170.096.000', 'AU'),
    ('202.170.128.000', 'IN'),
    ('202.170.176.000', 'AU'),
    ('202.170.224.000', 'ID'),
    ('202.171.016.000', 'AU'),
    ('202.171.064.000', 'NC'),
    ('202.171.080.000', 'AU'),
    ('202.171.128.000', 'PH'),
    ('202.171.144.000', 'AU'),
    ('202.171.192.000', 'MY'),
    ('202.171.208.000', 'AU'),
    ('202.171.252.000', 'MO'),
    ('202.172.004.000', 'AU'),
    ('202.172.032.000', 'SG'),
    ('202.172.048.000', 'AU'),
    ('202.172.208.000', 'SG'),
    ('202.173.000.000', 'MO'),
    ('202.173.004.000', 'AU'),
    ('202.173.032.000', 'TW'),
    ('202.173.064.000', 'ID'),
    ('202.173.096.000', 'AU'),
    ('202.174.000.000', 'MO'),
    ('202.174.004.000', 'AU'),
    ('202.174.064.000', 'TW'),
    ('202.174.096.000', 'AU'),
    ('202.174.128.000', 'HK'),
    ('202.174.160.000', 'AU'),
    ('202.175.000.000', 'MO'),
    ('202.175.128.000', 'AU'),
    ('202.176.000.000', 'SG'),
    ('202.176.001.000', 'JP'),
    ('202.176.004.000', 'AU'),
    ('202.176.224.000', 'CN'),
    ('202.177.000.000', 'HK'),
    ('202.177.040.000', 'AU'),
    ('202.177.128.000', 'IN'),
    ('202.177.192.000', 'US'),
    ('202.177.208.000', 'AU'),
    ('202.177.224.000', 'IN'),
    ('202.178.000.000', 'MY'),
    ('202.178.080.000', 'AU'),
    ('202.178.128.000', 'TW'),
    ('202.179.000.000', 'MN'),
    ('202.179.032.000', 'AU'),
    ('202.179.064.000', 'IN'),
    ('202.179.096.000', 'AU'),
    ('202.179.128.000', 'PK'),
    ('202.179.160.000', 'AU'),
    ('202.179.192.000', 'JP'),
    ('202.179.208.000', 'AU'),
    ('202.180.000.000', 'ID'),
    ('202.180.032.000', 'AU'),
    ('202.180.064.000', 'NZ'),
    ('202.180.128.000', 'HK'),
    ('202.180.176.000', 'AU'),
    ('202.181.032.000', 'HK'),
    ('202.181.064.000', 'AU'),
    ('202.181.128.000', 'HK'),
    ('202.182.000.000', 'TH'),
    ('202.182.032.000', 'AU'),
    ('202.182.224.000', 'HK'),
    ('202.183.000.000', 'ID'),
    ('202.183.032.000', 'PH'),
    ('202.183.048.000', 'AU'),
    ('202.183.064.000', 'IN'),
    ('202.183.080.000', 'HK'),
    ('202.183.096.000', 'AU'),
    ('202.183.128.000', 'TH'),
    ('202.184.000.000', 'MY'),
    ('202.189.064.000', 'AU'),
    ('202.189.096.000', 'HK'),
    ('202.189.128.000', 'KR'),
    ('202.189.144.000', 'AU'),
    ('202.189.224.000', 'PH'),
    ('202.190.000.000', 'MY'),
    ('202.191.000.000', 'DE'),
    ('202.191.001.000', 'AU'),
    ('202.191.064.000', 'IN'),
    ('202.191.096.000', 'AU'),
    ('202.191.128.000', 'MY'),
    ('202.192.000.000', 'CN'),
    ('202.192.242.000', 'TW'),
    ('202.192.243.000', 'CN'),
    ('202.208.000.000', 'JP'),
    ('203.000.000.000', 'AU'),
    ('203.012.118.000', 'NP'),
    ('203.012.119.000', 'AU'),
    ('203.020.052.000', 'US'),
    ('203.020.054.000', 'AU'),
    ('203.026.179.000', 'NZ'),
    ('203.026.180.000', 'AU'),
    ('203.031.120.000', 'US'),
    ('203.031.121.000', 'AU'),
    ('203.041.055.000', 'VN'),
    ('203.041.056.000', 'AU'),
    ('203.056.235.000', 'US'),
    ('203.056.236.000', 'AU'),
    ('203.057.126.000', 'US'),
    ('203.057.128.000', 'AU'),
    ('203.064.000.000', 'TW'),
    ('203.076.000.000', 'AU'),
    ('203.076.064.000', 'TW'),
    ('203.076.096.000', 'AU'),
    ('203.076.128.000', 'HK'),
    ('203.076.160.000', 'LK'),
    ('203.076.176.000', 'AU'),
    ('203.077.000.000', 'TW'),
    ('203.077.128.000', 'HK'),
    ('203.077.160.000', 'AU'),
    ('203.077.192.000', 'IN'),
    ('203.077.208.000', 'AU'),
    ('203.077.224.000', 'ID'),
    ('203.078.000.000', 'TW'),
    ('203.078.004.000', 'AU'),
    ('203.078.032.000', 'HK'),
    ('203.078.048.000', 'AU'),
    ('203.078.064.000', 'HK'),
    ('203.078.096.000', 'AU'),
    ('203.078.128.000', 'IN'),
    ('203.078.160.000', 'AU'),
    ('203.078.224.000', 'PH'),
    ('203.079.000.000', 'TW'),
    ('203.079.032.000', 'AU'),
    ('203.079.064.000', 'NZ'),
    ('203.079.128.000', 'TW'),
    ('203.080.000.000', 'HK'),
    ('203.080.004.000', 'AU'),
    ('203.080.064.000', 'HK'),
    ('203.080.160.000', 'AU'),
    ('203.080.176.000', 'HK'),
    ('203.081.002.000', 'AU'),
    ('203.081.016.000', 'CN'),
    ('203.081.032.000', 'SG'),
    ('203.081.048.000', 'AU'),
    ('203.081.064.000', 'MM'),
    ('203.081.096.000', 'AU'),
    ('203.081.128.000', 'IN'),
    ('203.081.160.000', 'AU'),
    ('203.081.192.000', 'PK'),
    ('203.081.208.000', 'AU'),
    ('203.081.252.000', 'HK'),
    ('203.082.002.000', 'AU'),
    ('203.082.032.000', 'PH'),
    ('203.082.048.000', 'AU'),
    ('203.082.064.000', 'MY'),
    ('203.082.096.000', 'AU'),
    ('203.082.128.000', 'JP'),
    ('203.082.160.000', 'AU'),
    ('203.082.192.000', 'BD'),
    ('203.082.208.000', 'AU'),
    ('203.082.252.000', 'HK'),
    ('203.083.004.000', 'AU'),
    ('203.083.064.000', 'HK'),
    ('203.083.128.000', 'AU'),
    ('203.083.252.000', 'HK'),
    ('203.084.064.000', 'AU'),
    ('203.084.128.000', 'HK'),
    ('203.084.130.000', 'AU'),
    ('203.084.192.000', 'PH'),
    ('203.084.224.000', 'AU'),
    ('203.085.000.000', 'HK'),
    ('203.086.004.000', 'AU'),
    ('203.086.096.000', 'IN'),
    ('203.086.128.000', 'HK'),
    ('203.086.192.000', 'AU'),
    ('203.086.252.000', 'HK'),
    ('203.087.000.000', 'AU'),
    ('203.087.128.000', 'PH'),
    ('203.087.160.000', 'AU'),
    ('203.087.192.000', 'SG'),
    ('203.087.208.000', 'AU'),
    ('203.087.224.000', 'CN'),
    ('203.088.004.000', 'AU'),
    ('203.088.128.000', 'IN'),
    ('203.088.160.000', 'AU'),
    ('203.088.192.000', 'HK'),
    ('203.088.208.000', 'AU'),
    ('203.089.000.000', 'CN'),
    ('203.089.004.000', 'AU'),
    ('203.089.128.000', 'PK'),
    ('203.089.160.000', 'AU'),
    ('203.090.000.000', 'CN'),
    ('203.090.004.000', 'AU'),
    ('203.090.064.000', 'IN'),
    ('203.090.112.000', 'AU'),
    ('203.090.192.000', 'PH'),
    ('203.090.208.000', 'AU'),
    ('203.090.224.000', 'HK'),
    ('203.091.000.000', 'CN'),
    ('203.091.004.000', 'AU'),
    ('203.091.128.000', 'HK'),
    ('203.091.130.000', 'IR'),
    ('203.091.131.000', 'HK'),
    ('203.091.133.000', 'BD'),
    ('203.091.134.000', 'SA'),
    ('203.091.135.000', 'PK'),
    ('203.091.136.000', 'HK'),
    ('203.091.137.000', 'ID'),
    ('203.091.138.000', 'HK'),
    ('203.091.144.000', 'IR'),
    ('203.091.146.000', 'HK'),
    ('203.091.148.000', 'IR'),
    ('203.091.149.000', 'HK'),
    ('203.091.160.000', 'AU'),
    ('203.092.000.000', 'CN'),
    ('203.092.004.000', 'AU'),
    ('203.092.064.000', 'SG'),
    ('203.092.112.000', 'AU'),
    ('203.092.128.000', 'MY'),
    ('203.092.160.000', 'AU'),
    ('203.092.192.000', 'IN'),
    ('203.092.208.000', 'AU'),
    ('203.093.000.000', 'CN'),
    ('203.094.032.000', 'AU'),
    ('203.094.064.000', 'LK'),
    ('203.094.128.000', 'AU'),
    ('203.094.192.000', 'IN'),
    ('203.095.000.000', 'CN'),
    ('203.095.008.000', 'AU'),
    ('203.095.064.000', 'SG'),
    ('203.095.096.000', 'AU'),
    ('203.095.128.000', 'TW'),
    ('203.096.000.000', 'NZ'),
    ('203.098.064.000', 'AU'),
    ('203.098.128.000', 'HK'),
    ('203.098.224.000', 'NR'),
    ('203.099.000.000', 'NZ'),
    ('203.099.040.000', 'HK'),
    ('203.099.064.000', 'NZ'),
    ('203.099.072.000', 'HK'),
    ('203.099.096.000', 'ID'),
    ('203.099.128.000', 'HK'),
    ('203.099.255.000', 'WS'),
    ('203.100.000.000', 'AU'),
    ('203.100.032.000', 'HK'),
    ('203.100.224.000', 'AU'),
    ('203.101.128.000', 'TH'),
    ('203.101.160.000', 'HK'),
    ('203.101.224.000', 'AU'),
    ('203.104.016.000', 'HK'),
    ('203.104.032.000', 'IN'),
    ('203.104.048.000', 'HK'),
    ('203.104.064.000', 'PH'),
    ('203.104.096.000', 'HK'),
    ('203.104.128.000', 'JP'),
    ('203.105.000.000', 'HK'),
    ('203.105.128.000', 'BD'),
    ('203.105.160.000', 'HK'),
    ('203.105.224.000', 'TW'),
    ('203.106.000.000', 'MY'),
    ('203.107.000.000', 'TW'),
    ('203.107.064.000', 'HK'),
    ('203.107.128.000', 'TH'),
    ('203.108.000.000', 'AU'),
    ('203.109.000.000', 'ID'),
    ('203.109.032.000', 'HK'),
    ('203.109.064.000', 'IN'),
    ('203.109.096.000', 'HK'),
    ('203.109.128.000', 'NZ'),
    ('203.109.168.000', 'AU'),
    ('203.109.170.000', 'NZ'),
    ('203.109.172.000', 'AU'),
    ('203.109.176.000', 'NZ'),
    ('203.109.190.000', 'NC'),
    ('203.109.192.000', 'NZ'),
    ('203.109.210.000', 'NC'),
    ('203.109.211.000', 'NZ'),
    ('203.109.212.000', 'AU'),
    ('203.109.213.000', 'NZ'),
    ('203.109.215.000', 'AU'),
    ('203.109.221.000', 'NZ'),
    ('203.109.226.000', 'AU'),
    ('203.109.227.000', 'NZ'),
    ('203.109.231.000', 'AU'),
    ('203.109.234.000', 'NZ'),
    ('203.109.243.000', 'AU'),
    ('203.109.244.000', 'NZ'),
    ('203.110.064.000', 'LA'),
    ('203.110.080.000', 'HK'),
    ('203.110.128.000', 'AU'),
    ('203.110.160.000', 'HK'),
    ('203.110.248.000', 'AU'),
    ('203.111.192.000', 'SG'),
    ('203.111.208.000', 'HK'),
    ('203.112.000.000', 'JP'),
    ('203.112.032.000', 'HK'),
    ('203.112.064.000', 'ID'),
    ('203.112.080.000', 'HK'),
    ('203.112.096.000', 'AU'),
    ('203.112.128.000', 'IN'),
    ('203.112.160.000', 'HK'),
    ('203.112.192.000', 'BD'),
    ('203.112.208.000', 'HK'),
    ('203.112.224.000', 'MY'),
    ('203.113.000.000', 'TH'),
    ('203.113.096.000', 'HK'),
    ('203.114.000.000', 'SG'),
    ('203.114.064.000', 'PH'),
    ('203.114.096.000', 'HK'),
    ('203.114.224.000', 'TH'),
    ('203.115.000.000', 'LK'),
    ('203.115.064.000', 'HK'),
    ('203.115.096.000', 'IN'),
    ('203.115.128.000', 'HK'),
    ('203.115.208.000', 'MY'),
    ('203.116.000.000', 'SG'),
    ('203.118.064.000', 'HK'),
    ('203.120.000.000', 'SG'),
    ('203.121.000.000', 'MY'),
    ('203.121.128.000', 'TH'),
    ('203.121.160.000', 'HK'),
    ('203.122.000.000', 'IN'),
    ('203.122.064.000', 'HK'),
    ('203.123.000.000', 'SG'),
    ('203.123.032.000', 'HK'),
    ('203.123.064.000', 'AU'),
    ('203.123.096.000', 'HK'),
    ('203.123.128.000', 'IN'),
    ('203.123.192.000', 'HK'),
    ('203.123.224.000', 'SG'),
    ('203.123.225.000', 'ID'),
    ('203.123.238.000', 'SG'),
    ('203.123.240.000', 'ID'),
    ('203.123.241.000', 'SG'),
    ('203.123.251.000', 'ID'),
    ('203.123.255.000', 'SG'),
    ('203.124.004.000', 'HK'),
    ('203.124.096.000', 'SG'),
    ('203.124.128.000', 'IN'),
    ('203.124.160.000', 'HK'),
    ('203.124.192.000', 'IN'),
    ('203.125.000.000', 'HK'),
    ('203.125.128.000', 'SG'),
    ('203.126.196.000', 'BD'),
    ('203.126.197.000', 'SG'),
    ('203.126.205.000', 'PH'),
    ('203.126.206.000', 'SG'),
    ('203.127.001.000', 'ID'),
    ('203.127.002.000', 'SG'),
    ('203.127.025.000', 'BD'),
    ('203.127.026.000', 'SG'),
    ('203.127.225.000', 'PH'),
    ('203.127.226.000', 'SG'),
    ('203.128.000.000', 'PK'),
    ('203.128.032.000', 'HK'),
    ('203.128.064.000', 'ID'),
    ('203.128.096.000', 'HK'),
    ('203.128.128.000', 'CN'),
    ('203.128.160.000', 'HK'),
    ('203.128.252.000', 'PK'),
    ('203.129.004.000', 'HK'),
    ('203.129.128.000', 'AU'),
    ('203.129.160.000', 'HK'),
    ('203.129.192.000', 'IN'),
    ('203.130.000.000', 'PK'),
    ('203.130.016.000', 'HK'),
    ('203.130.064.000', 'IN'),
    ('203.130.096.000', 'HK'),
    ('203.130.128.000', 'TH'),
    ('203.130.160.000', 'HK'),
    ('203.130.192.000', 'ID'),
    ('203.131.000.000', 'AU'),
    ('203.131.064.000', 'PH'),
    ('203.131.080.000', 'HK'),
    ('203.131.128.000', 'JP'),
    ('203.131.160.000', 'HK'),
    ('203.131.192.000', 'JP'),
    ('203.131.208.000', 'HK'),
    ('203.132.000.000', 'AU'),
    ('203.132.032.000', 'HK'),
    ('203.132.084.000', 'AU'),
    ('203.132.128.000', 'IN'),
    ('203.132.160.000', 'HK'),
    ('203.132.224.000', 'AU'),
    ('203.133.000.000', 'TW'),
    ('203.133.128.000', 'HK'),
    ('203.133.252.000', 'PK'),
    ('203.134.000.000', 'AU'),
    ('203.134.192.000', 'HK'),
    ('203.134.252.000', 'PK'),
    ('203.135.064.000', 'TW'),
    ('203.135.096.000', 'HK'),
    ('203.135.224.000', 'TW'),
    ('203.136.000.000', 'JP'),
    ('203.142.000.000', 'LK'),
    ('203.142.004.000', 'HK'),
    ('203.142.128.000', 'US'),
    ('203.142.160.000', 'HK'),
    ('203.142.224.000', 'AU'),
    ('203.143.000.000', 'LK'),
    ('203.143.064.000', 'AU'),
    ('203.143.096.000', 'HK'),
    ('203.143.128.000', 'SG'),
    ('203.143.160.000', 'HK'),
    ('203.143.224.000', 'AU'),
    ('203.144.032.000', 'NZ'),
    ('203.144.048.000', 'HK'),
    ('203.144.064.000', 'KH'),
    ('203.144.080.000', 'HK'),
    ('203.144.096.000', 'IN'),
    ('203.144.128.000', 'TH'),
    ('203.145.032.000', 'HK'),
    ('203.145.128.000', 'IN'),
    ('203.145.192.000', 'HK'),
    ('203.145.224.000', 'US'),
    ('203.145.232.000', 'SG'),
    ('203.145.233.000', 'US'),
    ('203.145.240.000', 'JP'),
    ('203.145.241.000', 'US'),
    ('203.146.000.000', 'TH'),
    ('203.147.064.000', 'HK'),
    ('203.147.112.000', 'SE'),
    ('203.147.128.000', 'AU'),
    ('203.148.000.000', 'IN'),
    ('203.148.032.000', 'HK'),
    ('203.148.064.000', 'PH'),
    ('203.148.080.000', 'HK'),
    ('203.148.128.000', 'TH'),
    ('203.149.064.000', 'AU'),
    ('203.149.080.000', 'HK'),
    ('203.149.128.000', 'TW'),
    ('203.150.000.000', 'TH'),
    ('203.152.064.000', 'HK'),
    ('203.152.096.000', 'NZ'),
    ('203.152.128.000', 'IN'),
    ('203.152.160.000', 'HK'),
    ('203.152.224.000', 'AU'),
    ('203.153.000.000', 'ID'),
    ('203.153.004.000', 'HK'),
    ('203.153.128.000', 'TH'),
    ('203.153.144.000', 'HK'),
    ('203.153.224.000', 'AU'),
    ('203.154.000.000', 'TH'),
    ('203.156.000.000', 'HK'),
    ('203.157.000.000', 'TH'),
    ('203.158.008.000', 'HK'),
    ('203.158.096.000', 'TH'),
    ('203.160.000.000', 'VN'),
    ('203.160.002.000', 'HK'),
    ('203.160.128.000', 'SG'),
    ('203.160.144.000', 'HK'),
    ('203.160.224.000', 'TW'),
    ('203.161.000.000', 'VN'),
    ('203.161.004.000', 'HK'),
    ('203.161.064.000', 'AU'),
    ('203.161.128.000', 'TW'),
    ('203.161.160.000', 'HK'),
    ('203.162.000.000', 'VN'),
    ('203.162.144.000', 'HK'),
    ('203.163.000.000', 'IN'),
    ('203.163.002.000', 'HK'),
    ('203.163.004.000', 'SG'),
    ('203.163.006.000', 'TW'),
    ('203.163.007.000', 'MY'),
    ('203.163.008.000', 'SG'),
    ('203.163.009.000', 'HK'),
    ('203.163.010.000', 'PH'),
    ('203.163.011.000', 'HK'),
    ('203.163.012.000', 'SG'),
    ('203.163.013.000', 'HK'),
    ('203.163.014.000', 'TH'),
    ('203.163.015.000', 'MY'),
    ('203.163.016.000', 'JP'),
    ('203.163.017.000', 'AU'),
    ('203.163.018.000', 'HK'),
    ('203.163.019.000', 'SG'),
    ('203.163.020.000', 'PH'),
    ('203.163.021.000', 'IN'),
    ('203.163.022.000', 'JP'),
    ('203.163.024.000', 'TW'),
    ('203.163.026.000', 'ID'),
    ('203.163.027.000', 'NZ'),
    ('203.163.028.000', 'AU'),
    ('203.163.029.000', 'HK'),
    ('203.163.034.000', 'TW'),
    ('203.163.035.000', 'TH'),
    ('203.163.036.000', 'JP'),
    ('203.163.037.000', 'AU'),
    ('203.163.038.000', 'PH'),
    ('203.163.039.000', 'SG'),
    ('203.163.040.000', 'JP'),
    ('203.163.041.000', 'KR'),
    ('203.163.042.000', 'HK'),
    ('203.163.045.000', 'TH'),
    ('203.163.046.000', 'SG'),
    ('203.163.048.000', 'TW'),
    ('203.163.049.000', 'JP'),
    ('203.163.050.000', 'IN'),
    ('203.163.053.000', 'JP'),
    ('203.163.054.000', 'IN'),
    ('203.163.055.000', 'JP'),
    ('203.163.056.000', 'CN'),
    ('203.163.058.000', 'SG'),
    ('203.163.059.000', 'IN'),
    ('203.163.060.000', 'JP'),
    ('203.163.061.000', 'TH'),
    ('203.163.062.000', 'JP'),
    ('203.163.063.000', 'HK'),
    ('203.163.064.000', 'SG'),
    ('203.163.065.000', 'AU'),
    ('203.163.066.000', 'ID'),
    ('203.163.067.000', 'AU'),
    ('203.163.068.000', 'NZ'),
    ('203.163.069.000', 'PH'),
    ('203.163.070.000', 'NZ'),
    ('203.163.072.000', 'HK'),
    ('203.163.073.000', 'SG'),
    ('203.163.074.000', 'AU'),
    ('203.163.075.000', 'ID'),
    ('203.163.077.000', 'HK'),
    ('203.163.078.000', 'MY'),
    ('203.163.079.000', 'AU'),
    ('203.163.080.000', 'SG'),
    ('203.163.081.000', 'ID'),
    ('203.163.082.000', 'HK'),
    ('203.163.083.000', 'TW'),
    ('203.163.084.000', 'KR'),
    ('203.163.085.000', 'MY'),
    ('203.163.086.000', 'NZ'),
    ('203.163.087.000', 'TW'),
    ('203.163.088.000', 'ID'),
    ('203.163.089.000', 'TW'),
    ('203.163.093.000', 'PH'),
    ('203.163.095.000', 'ID'),
    ('203.163.097.000', 'SG'),
    ('203.163.098.000', 'NZ'),
    ('203.163.099.000', 'KR'),
    ('203.163.101.000', 'MY'),
    ('203.163.102.000', 'HK'),
    ('203.163.103.000', 'MY'),
    ('203.163.104.000', 'KR'),
    ('203.163.105.000', 'MY'),
    ('203.163.107.000', 'HK'),
    ('203.163.108.000', 'TW'),
    ('203.163.111.000', 'SG'),
    ('203.163.113.000', 'ID'),
    ('203.163.114.000', 'MY'),
    ('203.163.116.000', 'KR'),
    ('203.163.117.000', 'HK'),
    ('203.163.118.000', 'PH'),
    ('203.163.119.000', 'MY'),
    ('203.163.120.000', 'ID'),
    ('203.163.121.000', 'MY'),
    ('203.163.122.000', 'JP'),
    ('203.163.128.000', 'IN'),
    ('203.163.192.000', 'TW'),
    ('203.163.224.000', 'HK'),
    ('203.164.000.000', 'AU'),
    ('203.165.000.000', 'JP'),
    ('203.166.000.000', 'AU'),
    ('203.166.128.000', 'SG'),
    ('203.166.160.000', 'HK'),
    ('203.166.224.000', 'AU'),
    ('203.167.000.000', 'PH'),
    ('203.167.032.000', 'HK'),
    ('203.167.064.000', 'PH'),
    ('203.167.128.000', 'NZ'),
    ('203.168.000.000', 'PH'),
    ('203.168.032.000', 'HK'),
    ('203.168.064.000', 'IN'),
    ('203.168.080.000', 'HK'),
    ('203.169.000.000', 'PH'),
    ('203.169.004.000', 'HK'),
    ('203.169.064.000', 'SG'),
    ('203.169.128.000', 'HK'),
    ('203.170.000.000', 'PH'),
    ('203.170.016.000', 'HK'),
    ('203.170.064.000', 'PK'),
    ('203.170.080.000', 'HK'),
    ('203.170.128.000', 'TH'),
    ('203.171.000.000', 'PH'),
    ('203.171.004.000', 'HK'),
    ('203.171.096.000', 'AU'),
    ('203.171.128.000', 'NZ'),
    ('203.171.129.000', 'JP'),
    ('203.171.144.000', 'AU'),
    ('203.171.145.000', 'SG'),
    ('203.171.146.000', 'HK'),
    ('203.171.148.000', 'NZ'),
    ('203.171.149.000', 'JP'),
    ('203.171.150.000', 'SG'),
    ('203.171.151.000', 'JP'),
    ('203.171.152.000', 'SG'),
    ('203.171.153.000', 'JP'),
    ('203.171.160.000', 'HK'),
    ('203.171.252.000', 'IN'),
    ('203.172.000.000', 'PH'),
    ('203.172.032.000', 'HK'),
    ('203.173.000.000', 'AU'),
    ('203.173.064.000', 'JP'),
    ('203.173.080.000', 'HK'),
    ('203.173.128.000', 'NZ'),
    ('203.173.180.000', 'AU'),
    ('203.173.184.000', 'NZ'),
    ('203.174.000.000', 'PH'),
    ('203.174.004.000', 'HK'),
    ('203.174.064.000', 'JP'),
    ('203.174.080.000', 'HK'),
    ('203.174.128.000', 'AU'),
    ('203.174.192.000', 'HK'),
    ('203.175.000.000', 'PH'),
    ('203.175.004.000', 'HK'),
    ('203.175.064.000', 'PK'),
    ('203.175.080.000', 'HK'),
    ('203.175.128.000', 'IN'),
    ('203.175.160.000', 'HK'),
    ('203.176.000.000', 'PH'),
    ('203.176.056.000', 'US'),
    ('203.176.060.000', 'PH'),
    ('203.176.088.000', 'AR'),
    ('203.176.089.000', 'PH'),
    ('203.176.096.000', 'HK'),
    ('203.177.000.000', 'PH'),
    ('203.177.080.000', 'HK'),
    ('203.177.252.000', 'PH'),
    ('203.178.000.000', 'JP'),
    ('203.184.000.000', 'CN'),
    ('203.184.004.000', 'HK'),
    ('203.184.064.000', 'AU'),
    ('203.184.080.000', 'HK'),
    ('203.185.064.000', 'TH'),
    ('203.185.160.000', 'HK'),
    ('203.185.192.000', 'AU'),
    ('203.186.000.000', 'HK'),
    ('203.187.000.000', 'TW'),
    ('203.187.128.000', 'HK'),
    ('203.187.192.000', 'IN'),
    ('203.187.208.000', 'HK'),
    ('203.188.000.000', 'IN'),
    ('203.188.032.000', 'HK'),
    ('203.188.128.000', 'AU'),
    ('203.188.160.000', 'HK'),
    ('203.188.252.000', 'BD'),
    ('203.189.002.000', 'HK'),
    ('203.189.064.000', 'LK'),
    ('203.189.080.000', 'HK'),
    ('203.189.128.000', 'KH'),
    ('203.189.144.000', 'HK'),
    ('203.189.224.000', 'BD'),
    ('203.190.004.000', 'HK'),
    ('203.190.013.000', 'IN'),
    ('203.190.032.000', 'BD'),
    ('203.190.036.000', 'IN'),
    ('203.190.064.000', 'PH'),
    ('203.190.080.000', 'IN'),
    ('203.190.160.000', 'HK'),
    ('203.190.192.000', 'AU'),
    ('203.190.208.000', 'HK'),
    ('203.190.254.000', 'BD'),
    ('203.191.002.000', 'HK'),
    ('203.191.032.000', 'BD'),
    ('203.191.034.000', 'HK'),
    ('203.191.064.000', 'BD'),
    ('203.191.096.000', 'HK'),
    ('203.191.128.000', 'BD'),
    ('203.191.132.000', 'HK'),
    ('203.191.160.000', 'AU'),
    ('203.191.176.000', 'HK'),
    ('203.191.192.000', 'AU'),
    ('203.191.208.000', 'HK'),
    ('203.191.252.000', 'BD'),
    ('203.192.000.000', 'CN'),
    ('203.192.032.000', 'TH'),
    ('203.192.048.000', 'HK'),
    ('203.192.128.000', 'JP'),
    ('203.192.135.000', 'HK'),
    ('203.192.136.000', 'JP'),
    ('203.192.184.000', 'SG'),
    ('203.192.185.000', 'IN'),
    ('203.192.186.000', 'TH'),
    ('203.192.187.000', 'IN'),
    ('203.192.188.000', 'JP'),
    ('203.192.192.000', 'IN'),
    ('203.192.224.000', 'HK'),
    ('203.193.131.000', 'IN'),
    ('203.193.134.000', 'HK'),
    ('203.193.137.000', 'IN'),
    ('203.193.138.000', 'HK'),
    ('203.193.139.000', 'IN'),
    ('203.193.140.000', 'HK'),
    ('203.193.141.000', 'IN'),
    ('203.193.142.000', 'HK'),
    ('203.193.143.000', 'IN'),
    ('203.193.147.000', 'HK'),
    ('203.193.176.000', 'IN'),
    ('203.193.192.000', 'HK'),
    ('203.194.000.000', 'AU'),
    ('203.194.064.000', 'JP'),
    ('203.194.096.000', 'HK'),
    ('203.194.128.000', 'SG'),
    ('203.194.142.000', 'HK'),
    ('203.194.178.000', 'SG'),
    ('203.194.180.000', 'HK'),
    ('203.194.182.000', 'SG'),
    ('203.194.186.000', 'HK'),
    ('203.194.187.000', 'SG'),
    ('203.194.188.000', 'HK'),
    ('203.194.216.000', 'SG'),
    ('203.194.220.000', 'HK'),
    ('203.194.221.000', 'SG'),
    ('203.194.223.000', 'HK'),
    ('203.194.224.000', 'SG'),
    ('203.194.225.000', 'HK'),
    ('203.195.128.000', 'IN'),
    ('203.195.224.000', 'HK'),
    ('203.196.000.000', 'CN'),
    ('203.196.008.000', 'HK'),
    ('203.196.064.000', 'IN'),
    ('203.196.080.000', 'HK'),
    ('203.196.128.000', 'IN'),
    ('203.196.160.000', 'HK'),
    ('203.196.224.000', 'IN'),
    ('203.198.000.000', 'HK'),
    ('203.199.000.000', 'IN'),
    ('203.201.000.000', 'AU'),
    ('203.203.000.000', 'TW'),
    ('203.205.000.000', 'JP'),
    ('203.205.112.000', 'AU'),
    ('203.207.000.000', 'TW'),
    ('203.207.016.000', 'AU'),
    ('203.207.064.000', 'CN'),
    ('203.208.019.000', 'AU'),
    ('203.208.128.000', 'SG'),
    ('203.208.133.000', 'HK'),
    ('203.208.134.000', 'SG'),
    ('203.208.136.000', 'US'),
    ('203.208.138.000', 'SG'),
    ('203.208.170.000', 'AU'),
    ('203.208.172.000', 'SG'),
    ('203.209.000.000', 'TH'),
    ('203.209.064.000', 'AU'),
    ('203.209.128.000', 'HK'),
    ('203.209.144.000', 'AU'),
    ('203.210.000.000', 'HK'),
    ('203.210.016.000', 'AU'),
    ('203.211.000.000', 'TW'),
    ('203.211.032.000', 'AU'),
    ('203.211.128.000', 'SG'),
    ('203.211.160.000', 'AU'),
    ('203.212.000.000', 'CN'),
    ('203.212.016.000', 'AU'),
    ('203.212.064.000', 'IN'),
    ('203.212.080.000', 'AU'),
    ('203.215.064.000', 'PH'),
    ('203.215.096.000', 'AU'),
    ('203.215.160.000', 'PK'),
    ('203.215.192.000', 'AU'),
    ('203.215.240.000', 'HK'),
    ('203.216.000.000', 'JP'),
    ('203.216.160.000', 'AU'),
    ('203.217.096.000', 'TW'),
    ('203.217.192.000', 'AU'),
    ('203.218.000.000', 'HK'),
    ('203.219.000.000', 'AU'),
    ('203.222.042.000', 'HK'),
    ('203.222.044.000', 'AU'),
    ('203.222.046.000', 'KR'),
    ('203.222.047.000', 'AU'),
    ('203.222.192.000', 'HK'),
    ('203.222.208.000', 'AU'),
    ('203.223.000.000', 'US'),
    ('203.223.016.000', 'AU'),
    ('203.223.032.000', 'KH'),
    ('203.223.048.000', 'AU'),
    ('203.223.064.000', 'JP'),
    ('203.223.080.000', 'AU'),
    ('203.223.128.000', 'MY'),
    ('203.223.160.000', 'AU'),
    ('203.224.000.000', 'KR'),
    ('204.000.000.000', 'US'),
    ('204.004.134.000', 'GB'),
    ('204.004.135.000', 'US'),
    ('204.006.040.000', 'FR'),
    ('204.006.045.000', 'US'),
    ('204.008.000.000', '--'),
    ('204.012.128.000', 'ZA'),
    ('204.012.144.000', '--'),
    ('204.017.000.000', 'US'),
    ('204.017.168.000', 'CA'),
    ('204.017.169.000', 'US'),
    ('204.019.000.000', 'CA'),
    ('204.020.000.000', 'US'),
    ('204.029.161.000', 'CA'),
    ('204.029.162.000', 'US'),
    ('204.029.163.000', '--'),
    ('204.029.164.000', 'US'),
    ('204.040.000.000', 'CA'),
    ('204.042.000.000', 'US'),
    ('204.048.000.000', 'CA'),
    ('204.048.008.000', 'US'),
    ('204.050.000.000', 'CA'),
    ('204.051.000.000', 'US'),
    ('204.051.064.000', '--'),
    ('204.052.000.000', 'US'),
    ('204.052.208.000', 'IL'),
    ('204.052.209.000', 'US'),
    ('204.058.136.000', 'MX'),
    ('204.058.140.000', 'US'),
    ('204.069.208.000', 'CA'),
    ('204.069.209.000', 'US'),
    ('204.069.210.000', '--'),
    ('204.069.211.000', 'US'),
    ('204.069.214.000', '--'),
    ('204.069.216.000', 'US'),
    ('204.071.012.000', 'GB'),
    ('204.071.014.000', 'US'),
    ('204.077.078.000', 'CA'),
    ('204.077.079.000', 'US'),
    ('204.079.000.000', 'CA'),
    ('204.079.001.000', 'US'),
    ('204.079.004.000', 'BE'),
    ('204.079.005.000', 'DE'),
    ('204.079.006.000', 'US'),
    ('204.079.008.000', 'CA'),
    ('204.079.009.000', 'US'),
    ('204.079.010.000', 'DE'),
    ('204.079.011.000', 'US'),
    ('204.079.012.000', 'CH'),
    ('204.079.013.000', 'IE'),
    ('204.079.022.000', 'US'),
    ('204.079.023.000', 'HK'),
    ('204.079.026.000', 'GB'),
    ('204.079.027.000', 'DE'),
    ('204.079.028.000', 'LU'),
    ('204.079.049.000', 'DE'),
    ('204.079.051.000', 'AT'),
    ('204.079.052.000', 'CH'),
    ('204.079.053.000', 'GB'),
    ('204.079.055.000', 'DE'),
    ('204.079.056.000', 'CA'),
    ('204.079.057.000', 'SE'),
    ('204.079.058.000', 'DE'),
    ('204.079.062.000', 'TW'),
    ('204.079.064.000', 'GB'),
    ('204.079.065.000', 'DK'),
    ('204.079.066.000', 'ES'),
    ('204.079.067.000', 'JP'),
    ('204.079.068.000', 'DE'),
    ('204.079.069.000', 'US'),
    ('204.079.070.000', 'DE'),
    ('204.079.071.000', 'US'),
    ('204.079.072.000', 'NO'),
    ('204.079.073.000', 'CH'),
    ('204.079.074.000', 'JP'),
    ('204.079.075.000', 'DE'),
    ('204.079.079.000', 'NL'),
    ('204.079.080.000', 'DE'),
    ('204.079.083.000', 'GB'),
    ('204.079.084.000', 'DE'),
    ('204.079.085.000', 'US'),
    ('204.079.086.000', 'BE'),
    ('204.079.087.000', 'US'),
    ('204.079.090.000', 'NL'),
    ('204.079.091.000', 'US'),
    ('204.079.093.000', 'JP'),
    ('204.079.094.000', 'FI'),
    ('204.079.095.000', 'IT'),
    ('204.079.096.000', 'CH'),
    ('204.079.097.000', 'GB'),
    ('204.079.098.000', 'DE'),
    ('204.079.099.000', 'CA'),
    ('204.079.100.000', 'IT'),
    ('204.079.101.000', 'US'),
    ('204.079.102.000', 'DE'),
    ('204.079.103.000', 'BE'),
    ('204.079.105.000', 'AU'),
    ('204.079.106.000', 'DE'),
    ('204.079.107.000', 'US'),
    ('204.079.108.000', 'GR'),
    ('204.079.109.000', 'FR'),
    ('204.079.110.000', 'JP'),
    ('204.079.111.000', 'DE'),
    ('204.079.112.000', 'BE'),
    ('204.079.114.000', 'IT'),
    ('204.079.115.000', 'US'),
    ('204.079.116.000', 'BE'),
    ('204.079.117.000', 'GB'),
    ('204.079.119.000', 'US'),
    ('204.079.120.000', 'CA'),
    ('204.079.123.000', 'US'),
    ('204.079.126.000', 'JP'),
    ('204.079.127.000', 'US'),
    ('204.079.128.000', 'DE'),
    ('204.079.129.000', 'CA'),
    ('204.079.130.000', 'IT'),
    ('204.079.133.000', 'AU'),
    ('204.079.134.000', 'GB'),
    ('204.079.135.000', 'FI'),
    ('204.079.136.000', 'FR'),
    ('204.079.137.000', 'US'),
    ('204.079.141.000', 'GB'),
    ('204.079.142.000', 'US'),
    ('204.079.144.000', 'GB'),
    ('204.079.146.000', 'SE'),
    ('204.079.147.000', 'DE'),
    ('204.079.150.000', 'US'),
    ('204.079.157.000', 'JP'),
    ('204.079.159.000', 'NO'),
    ('204.079.160.000', 'GB'),
    ('204.079.161.000', 'CH'),
    ('204.079.164.000', 'US'),
    ('204.079.165.000', 'CA'),
    ('204.079.166.000', 'CH'),
    ('204.079.168.000', 'DE'),
    ('204.079.169.000', 'HK'),
    ('204.079.170.000', 'BE'),
    ('204.079.171.000', 'DE'),
    ('204.079.172.000', 'US'),
    ('204.079.173.000', 'FR'),
    ('204.079.174.000', 'US'),
    ('204.079.177.000', 'DE'),
    ('204.079.179.000', 'US'),
    ('204.079.182.000', 'HK'),
    ('204.079.184.000', 'CZ'),
    ('204.079.185.000', 'US'),
    ('204.079.186.000', 'NL'),
    ('204.079.187.000', 'DE'),
    ('204.079.188.000', 'US'),
    ('204.079.189.000', 'HK'),
    ('204.079.190.000', 'US'),
    ('204.079.191.000', 'SE'),
    ('204.079.192.000', 'NO'),
    ('204.079.194.000', 'GB'),
    ('204.079.195.000', 'US'),
    ('204.079.198.000', 'GB'),
    ('204.079.199.000', 'US'),
    ('204.079.204.000', 'BE'),
    ('204.079.205.000', 'US'),
    ('204.079.207.000', 'GB'),
    ('204.079.208.000', 'FR'),
    ('204.079.211.000', 'GB'),
    ('204.079.212.000', 'CA'),
    ('204.079.213.000', 'GB'),
    ('204.079.216.000', 'US'),
    ('204.079.218.000', 'JP'),
    ('204.079.219.000', 'NO'),
    ('204.079.220.000', 'US'),
    ('204.079.224.000', 'LU'),
    ('204.079.226.000', 'US'),
    ('204.079.228.000', 'FR'),
    ('204.079.229.000', 'CH'),
    ('204.079.230.000', 'US'),
    ('204.079.232.000', 'NO'),
    ('204.079.235.000', 'DE'),
    ('204.079.237.000', 'US'),
    ('204.079.240.000', 'IT'),
    ('204.079.241.000', 'US'),
    ('204.079.243.000', 'GB'),
    ('204.079.244.000', 'CA'),
    ('204.079.246.000', 'NL'),
    ('204.079.247.000', 'SG'),
    ('204.079.250.000', 'HK'),
    ('204.079.252.000', 'US'),
    ('204.079.253.000', 'NL'),
    ('204.080.000.000', 'US'),
    ('204.080.143.000', 'MX'),
    ('204.080.144.000', 'US'),
    ('204.081.000.000', 'CA'),
    ('204.083.132.000', 'US'),
    ('204.083.134.000', 'CA'),
    ('204.084.000.000', 'US'),
    ('204.087.129.000', 'CA'),
    ('204.087.130.000', 'US'),
    ('204.087.169.000', 'CL'),
    ('204.087.170.000', 'US'),
    ('204.087.179.000', 'ZA'),
    ('204.087.180.000', 'US'),
    ('204.087.205.000', 'MX'),
    ('204.087.206.000', 'US'),
    ('204.089.196.000', 'IT'),
    ('204.089.197.000', 'US'),
    ('204.089.206.000', 'MX'),
    ('204.089.207.000', 'US'),
    ('204.090.181.000', 'NL'),
    ('204.090.183.000', 'US'),
    ('204.092.000.000', 'CA'),
    ('204.092.006.000', 'US'),
    ('204.092.007.000', 'CA'),
    ('204.092.078.000', 'GB'),
    ('204.092.079.000', 'CA'),
    ('204.092.087.000', 'US'),
    ('204.092.088.000', 'CA'),
    ('204.092.094.000', 'US'),
    ('204.092.095.000', 'CA'),
    ('204.092.217.000', 'US'),
    ('204.092.218.000', 'CA'),
    ('204.093.000.000', 'US'),
    ('204.093.128.000', '--'),
    ('204.094.000.000', 'US'),
    ('204.094.120.000', 'CA'),
    ('204.094.124.000', 'US'),
    ('204.094.138.000', 'EC'),
    ('204.094.140.000', 'US'),
    ('204.095.131.000', 'PA'),
    ('204.095.132.000', 'US'),
    ('204.097.192.000', 'CA'),
    ('204.097.208.000', 'US'),
    ('204.101.000.000', 'CA'),
    ('204.102.000.000', 'US'),
    ('204.104.111.000', 'DE'),
    ('204.104.112.000', 'US'),
    ('204.104.159.000', 'DE'),
    ('204.104.160.000', 'US'),
    ('204.104.171.000', 'DE'),
    ('204.104.172.000', 'US'),
    ('204.112.000.000', 'CA'),
    ('204.113.000.000', 'US'),
    ('204.117.119.000', 'CA'),
    ('204.117.120.000', 'US'),
    ('204.117.176.000', 'JM'),
    ('204.117.180.000', 'US'),
    ('204.120.229.000', 'PA'),
    ('204.120.230.000', 'VE'),
    ('204.120.231.000', 'US'),
    ('204.120.232.000', 'VE'),
    ('204.120.233.000', 'US'),
    ('204.120.234.000', 'PA'),
    ('204.120.235.000', 'US'),
    ('204.120.252.000', 'HN'),
    ('204.120.253.000', 'US'),
    ('204.124.104.000', 'MX'),
    ('204.124.108.000', 'US'),
    ('204.125.015.000', 'CA'),
    ('204.125.016.000', 'US'),
    ('204.125.023.000', 'CA'),
    ('204.125.024.000', 'US'),
    ('204.125.092.000', 'CA'),
    ('204.125.095.000', 'US'),
    ('204.125.097.000', 'CA'),
    ('204.125.098.000', 'US'),
    ('204.125.099.000', 'CA'),
    ('204.125.100.000', 'US'),
    ('204.125.105.000', 'CA'),
    ('204.125.106.000', 'US'),
    ('204.125.108.000', 'CA'),
    ('204.125.110.000', 'US'),
    ('204.125.114.000', 'CA'),
    ('204.125.115.000', 'US'),
    ('204.125.118.000', 'CA'),
    ('204.125.119.000', 'US'),
    ('204.125.130.000', 'CA'),
    ('204.125.131.000', 'US'),
    ('204.125.132.000', 'CA'),
    ('204.125.133.000', 'US'),
    ('204.125.135.000', 'CA'),
    ('204.125.136.000', 'US'),
    ('204.125.140.000', 'CA'),
    ('204.125.141.000', 'US'),
    ('204.125.143.000', 'CA'),
    ('204.125.144.000', 'US'),
    ('204.125.150.000', 'CA'),
    ('204.125.151.000', 'US'),
    ('204.125.199.000', 'CA'),
    ('204.125.200.000', 'US'),
    ('204.125.210.000', 'CA'),
    ('204.125.211.000', 'US'),
    ('204.125.241.000', 'CA'),
    ('204.125.242.000', 'US'),
    ('204.125.247.000', 'CA'),
    ('204.125.248.000', 'US'),
    ('204.125.254.000', 'CA'),
    ('204.125.255.000', 'US'),
    ('204.126.010.000', '--'),
    ('204.126.012.000', 'MX'),
    ('204.126.014.000', 'US'),
    ('204.126.128.000', 'DO'),
    ('204.126.130.000', 'US'),
    ('204.126.140.000', 'MX'),
    ('204.126.142.000', 'US'),
    ('204.130.167.000', 'CA'),
    ('204.130.168.000', 'US'),
    ('204.138.000.000', 'CA'),
    ('204.138.114.000', 'US'),
    ('204.138.115.000', 'CA'),
    ('204.139.000.000', 'US'),
    ('204.140.070.000', 'BE'),
    ('204.140.071.000', 'US'),
    ('204.140.073.000', 'GB'),
    ('204.140.074.000', 'US'),
    ('204.140.076.000', 'DE'),
    ('204.140.077.000', 'GB'),
    ('204.140.078.000', 'LU'),
    ('204.140.079.000', 'US'),
    ('204.140.080.000', 'DE'),
    ('204.140.084.000', 'FR'),
    ('204.140.086.000', 'IT'),
    ('204.140.095.000', 'US'),
    ('204.140.097.000', 'GB'),
    ('204.140.098.000', 'US'),
    ('204.140.102.000', 'SG'),
    ('204.140.103.000', 'CA'),
    ('204.140.109.000', 'NL'),
    ('204.140.127.000', 'US'),
    ('204.144.078.000', 'PR'),
    ('204.144.079.000', 'US'),
    ('204.145.136.000', 'CA'),
    ('204.145.137.000', 'US'),
    ('204.145.201.000', 'MX'),
    ('204.145.202.000', 'US'),
    ('204.145.229.000', 'CA'),
    ('204.145.230.000', 'US'),
    ('204.146.053.000', 'GB'),
    ('204.146.054.000', 'US'),
    ('204.148.008.000', 'CA'),
    ('204.148.010.000', 'US'),
    ('204.148.057.000', 'DE'),
    ('204.148.062.000', 'US'),
    ('204.148.112.000', 'GB'),
    ('204.148.113.000', 'US'),
    ('204.149.030.000', 'CA'),
    ('204.149.031.000', 'US'),
    ('204.149.048.000', 'DE'),
    ('204.149.052.000', 'US'),
    ('204.149.176.000', 'DE'),
    ('204.149.192.000', 'US'),
    ('204.151.111.000', 'DE'),
    ('204.151.112.000', 'US'),
    ('204.151.179.000', 'DE'),
    ('204.151.184.000', 'US'),
    ('204.152.014.000', 'NA'),
    ('204.152.016.000', 'US'),
    ('204.152.028.000', 'GB'),
    ('204.152.029.000', 'US'),
    ('204.152.192.000', '--'),
    ('204.153.000.000', 'US'),
    ('204.153.024.000', 'MX'),
    ('204.153.026.000', '--'),
    ('204.153.028.000', 'US'),
    ('204.154.064.000', 'DE'),
    ('204.154.069.000', 'ZA'),
    ('204.154.070.000', 'PT'),
    ('204.154.071.000', 'DE'),
    ('204.154.072.000', 'US'),
    ('204.157.004.000', 'CA'),
    ('204.157.005.000', 'US'),
    ('204.157.226.000', 'CA'),
    ('204.157.228.000', 'US'),
    ('204.158.222.000', 'MX'),
    ('204.158.224.000', 'US'),
    ('204.168.075.000', '--'),
    ('204.168.076.000', 'US'),
    ('204.174.000.000', 'CA'),
    ('204.174.239.000', 'US'),
    ('204.174.240.000', 'CA'),
    ('204.175.000.000', 'US'),
    ('204.179.064.000', 'VE'),
    ('204.179.080.000', 'US'),
    ('204.183.032.000', 'ES'),
    ('204.183.033.000', 'US'),
    ('204.183.050.000', 'BS'),
    ('204.183.051.000', 'US'),
    ('204.183.118.000', 'BR'),
    ('204.183.119.000', 'US'),
    ('204.187.000.000', 'CA'),
    ('204.187.070.000', 'US'),
    ('204.187.076.000', 'CA'),
    ('204.188.000.000', 'US'),
    ('204.188.114.000', 'CL'),
    ('204.188.120.000', 'US'),
    ('204.188.136.000', 'PA'),
    ('204.188.144.000', 'US'),
    ('204.188.160.000', 'AG'),
    ('204.188.176.000', 'US'),
    ('204.191.000.000', 'CA'),
    ('204.192.000.000', 'US'),
    ('204.209.000.000', 'CA'),
    ('204.210.000.000', 'US'),
    ('204.215.214.000', 'VE'),
    ('204.215.215.000', 'US'),
    ('204.218.000.000', 'DE'),
    ('204.220.000.000', 'US'),
    ('204.222.028.000', 'IT'),
    ('204.222.032.000', 'US'),
    ('204.224.001.000', 'CA'),
    ('204.224.002.000', 'US'),
    ('204.224.042.000', 'CA'),
    ('204.224.043.000', 'US'),
    ('204.224.108.000', 'CA'),
    ('204.224.109.000', 'US'),
    ('204.224.117.000', 'CA'),
    ('204.224.118.000', 'US'),
    ('204.224.123.000', 'CA'),
    ('204.224.124.000', 'US'),
    ('204.224.134.000', 'CA'),
    ('204.224.135.000', 'US'),
    ('204.224.185.000', 'CA'),
    ('204.224.186.000', 'US'),
    ('204.224.192.000', 'CA'),
    ('204.224.193.000', 'US'),
    ('204.224.237.000', 'CA'),
    ('204.224.238.000', 'US'),
    ('204.224.252.000', 'CA'),
    ('204.224.253.000', 'US'),
    ('204.225.000.000', 'CA'),
    ('204.225.172.000', 'US'),
    ('204.225.173.000', 'CA'),
    ('204.227.000.000', 'US'),
    ('204.231.002.000', 'HK'),
    ('204.231.003.000', 'JP'),
    ('204.231.004.000', 'FR'),
    ('204.231.006.000', 'CA'),
    ('204.231.010.000', 'HK'),
    ('204.231.011.000', 'NO'),
    ('204.231.012.000', 'ES'),
    ('204.231.013.000', 'AT'),
    ('204.231.017.000', 'HK'),
    ('204.231.020.000', 'NL'),
    ('204.231.023.000', 'US'),
    ('204.231.024.000', 'SG'),
    ('204.231.025.000', 'US'),
    ('204.231.045.000', 'NO'),
    ('204.231.047.000', 'HK'),
    ('204.231.048.000', 'US'),
    ('204.231.049.000', 'NL'),
    ('204.231.050.000', 'ES'),
    ('204.231.051.000', 'US'),
    ('204.231.052.000', 'CH'),
    ('204.231.054.000', 'US'),
    ('204.231.061.000', 'CH'),
    ('204.231.062.000', 'US'),
    ('204.231.064.000', 'DE'),
    ('204.231.065.000', 'US'),
    ('204.231.066.000', 'FR'),
    ('204.231.067.000', 'US'),
    ('204.231.068.000', 'FI'),
    ('204.231.070.000', 'CA'),
    ('204.231.072.000', 'FR'),
    ('204.231.074.000', 'US'),
    ('204.231.075.000', 'GB'),
    ('204.231.077.000', 'US'),
    ('204.231.085.000', 'GB'),
    ('204.231.089.000', 'US'),
    ('204.231.090.000', 'CA'),
    ('204.231.092.000', 'US'),
    ('204.231.095.000', 'DE'),
    ('204.231.096.000', 'JP'),
    ('204.231.097.000', 'IT'),
    ('204.231.098.000', 'DE'),
    ('204.231.102.000', 'US'),
    ('204.231.103.000', 'BE'),
    ('204.231.108.000', 'US'),
    ('204.231.114.000', 'SG'),
    ('204.231.126.000', 'US'),
    ('204.231.133.000', 'CA'),
    ('204.231.134.000', 'MN'),
    ('204.231.136.000', 'DE'),
    ('204.231.138.000', 'US'),
    ('204.231.139.000', 'GB'),
    ('204.231.141.000', 'CA'),
    ('204.231.142.000', 'US'),
    ('204.231.170.000', 'SG'),
    ('204.231.171.000', 'US'),
    ('204.231.180.000', 'CL'),
    ('204.231.182.000', 'US'),
    ('204.231.224.000', 'GB'),
    ('204.231.225.000', 'NL'),
    ('204.231.227.000', 'US'),
    ('204.231.228.000', 'DE'),
    ('204.231.229.000', 'US'),
    ('204.231.230.000', 'JP'),
    ('204.231.231.000', 'US'),
    ('204.231.232.000', 'GB'),
    ('204.231.233.000', 'US'),
    ('204.231.236.000', 'BE'),
    ('204.231.237.000', 'IT'),
    ('204.231.238.000', 'GB'),
    ('204.231.239.000', 'ES'),
    ('204.231.240.000', 'IE'),
    ('204.231.241.000', 'US'),
    ('204.231.251.000', 'JP'),
    ('204.231.253.000', 'GB'),
    ('204.231.254.000', 'US'),
    ('204.231.255.000', 'IE'),
    ('204.232.000.000', 'US'),
    ('204.235.032.000', 'ZA'),
    ('204.235.048.000', 'US'),
    ('204.236.032.000', '--'),
    ('204.238.000.000', 'US'),
    ('204.239.000.000', 'CA'),
    ('204.239.011.000', 'US'),
    ('204.239.012.000', 'CA'),
    ('204.240.000.000', 'US'),
    ('204.244.000.000', 'CA'),
    ('204.245.000.000', 'US'),
    ('204.252.015.000', 'MX'),
    ('204.252.016.000', 'US'),
    ('204.253.196.000', 'JM'),
    ('204.253.198.000', 'HT'),
    ('204.253.200.000', 'US'),
    ('204.254.085.000', 'CL'),
    ('204.254.086.000', 'US'),
    ('205.136.011.000', 'BM'),
    ('205.136.012.000', 'US'),
    ('205.136.018.000', 'PY'),
    ('205.136.019.000', 'US'),
    ('205.136.031.000', 'BM'),
    ('205.136.032.000', 'US'),
    ('205.136.040.000', 'BM'),
    ('205.136.041.000', 'US'),
    ('205.136.060.000', 'PH'),
    ('205.136.062.000', 'US'),
    ('205.136.083.000', 'AG'),
    ('205.136.085.000', 'US'),
    ('205.136.238.000', 'KY'),
    ('205.136.241.000', 'US'),
    ('205.137.121.000', 'GB'),
    ('205.137.124.000', 'US'),
    ('205.139.032.000', 'ES'),
    ('205.139.033.000', 'US'),
    ('205.150.000.000', 'CA'),
    ('205.150.068.000', 'US'),
    ('205.150.069.000', 'CA'),
    ('205.150.125.000', 'US'),
    ('205.150.126.000', 'CA'),
    ('205.150.173.000', 'US'),
    ('205.150.174.000', 'CA'),
    ('205.152.000.000', 'US'),
    ('205.156.177.000', 'GB'),
    ('205.156.178.000', 'US'),
    ('205.159.079.000', 'ZA'),
    ('205.159.080.000', 'US'),
    ('205.160.080.000', 'ES'),
    ('205.160.084.000', 'US'),
    ('205.160.164.000', 'DO'),
    ('205.160.168.000', 'US'),
    ('205.160.233.000', 'AG'),
    ('205.160.234.000', 'US'),
    ('205.160.237.000', 'CA'),
    ('205.160.240.000', 'US'),
    ('205.161.168.000', 'ES'),
    ('205.161.169.000', 'US'),
    ('205.162.112.000', 'CA'),
    ('205.162.120.000', 'US'),
    ('205.162.128.000', 'GU'),
    ('205.162.136.000', 'US'),
    ('205.162.188.000', 'MX'),
    ('205.162.189.000', 'US'),
    ('205.166.251.000', 'MX'),
    ('205.166.252.000', 'US'),
    ('205.178.128.000', 'CA'),
    ('205.178.140.000', 'US'),
    ('205.178.141.000', 'CA'),
    ('205.178.143.000', 'NZ'),
    ('205.178.144.000', 'CA'),
    ('205.178.155.000', 'US'),
    ('205.178.156.000', 'CA'),
    ('205.178.158.000', 'US'),
    ('205.178.159.000', 'CA'),
    ('205.178.165.000', 'US'),
    ('205.178.166.000', 'CA'),
    ('205.178.167.000', 'US'),
    ('205.178.169.000', 'CA'),
    ('205.178.178.000', 'US'),
    ('205.178.179.000', 'CA'),
    ('205.178.192.000', '--'),
    ('205.179.000.000', 'US'),
    ('205.180.174.000', 'VE'),
    ('205.180.175.000', 'US'),
    ('205.180.243.000', 'AU'),
    ('205.180.244.000', 'US'),
    ('205.181.063.000', 'CH'),
    ('205.181.064.000', 'US'),
    ('205.181.176.000', 'HU'),
    ('205.181.177.000', 'US'),
    ('205.183.192.000', 'GB'),
    ('205.183.193.000', 'US'),
    ('205.183.254.000', 'GB'),
    ('205.183.255.000', 'US'),
    ('205.189.000.000', 'CA'),
    ('205.189.002.000', 'US'),
    ('205.189.004.000', 'CA'),
    ('205.189.034.000', 'US'),
    ('205.189.035.000', 'CA'),
    ('205.189.112.000', 'US'),
    ('205.189.117.000', 'CA'),
    ('205.190.000.000', 'US'),
    ('205.190.011.000', 'CA'),
    ('205.190.012.000', 'US'),
    ('205.190.022.000', 'CA'),
    ('205.190.024.000', 'US'),
    ('205.190.027.000', 'CA'),
    ('205.190.028.000', 'US'),
    ('205.190.069.000', 'CA'),
    ('205.190.070.000', 'US'),
    ('205.190.074.000', 'CA'),
    ('205.190.075.000', 'US'),
    ('205.190.102.000', 'CA'),
    ('205.190.103.000', 'US'),
    ('205.190.107.000', 'CA'),
    ('205.190.108.000', 'US'),
    ('205.190.116.000', 'CA'),
    ('205.190.118.000', 'US'),
    ('205.190.158.000', 'PR'),
    ('205.190.159.000', 'US'),
    ('205.190.168.000', 'CA'),
    ('205.190.169.000', 'US'),
    ('205.190.185.000', 'CA'),
    ('205.190.186.000', 'US'),
    ('205.190.187.000', 'CA'),
    ('205.190.188.000', 'US'),
    ('205.190.214.000', 'CA'),
    ('205.190.215.000', 'US'),
    ('205.190.216.000', 'CA'),
    ('205.190.217.000', 'US'),
    ('205.190.218.000', 'CA'),
    ('205.190.219.000', 'US'),
    ('205.190.221.000', 'CA'),
    ('205.190.222.000', 'US'),
    ('205.190.231.000', 'CA'),
    ('205.190.233.000', 'US'),
    ('205.192.000.000', 'CA'),
    ('205.196.000.000', 'US'),
    ('205.199.001.000', 'CA'),
    ('205.199.002.000', 'US'),
    ('205.200.000.000', 'CA'),
    ('205.201.000.000', 'US'),
    ('205.201.064.000', '--'),
    ('205.202.000.000', 'US'),
    ('205.205.000.000', 'CA'),
    ('205.208.048.000', 'US'),
    ('205.208.049.000', 'CA'),
    ('205.208.128.000', 'US'),
    ('205.208.129.000', 'CA'),
    ('205.208.133.000', 'US'),
    ('205.208.134.000', 'CA'),
    ('205.208.141.000', 'US'),
    ('205.208.142.000', 'CA'),
    ('205.208.145.000', 'US'),
    ('205.208.146.000', 'CA'),
    ('205.208.149.000', 'US'),
    ('205.208.150.000', 'CA'),
    ('205.208.154.000', 'US'),
    ('205.208.155.000', 'CA'),
    ('205.208.171.000', 'US'),
    ('205.208.175.000', 'CA'),
    ('205.208.179.000', 'US'),
    ('205.208.181.000', 'CA'),
    ('205.208.187.000', 'US'),
    ('205.208.188.000', 'CA'),
    ('205.208.191.000', 'US'),
    ('205.209.000.000', 'CA'),
    ('205.210.036.000', 'US'),
    ('205.210.037.000', 'CA'),
    ('205.210.224.000', 'US'),
    ('205.210.225.000', 'CA'),
    ('205.212.000.000', 'US'),
    ('205.214.192.000', 'BB'),
    ('205.214.203.000', 'KN'),
    ('205.214.204.000', 'TC'),
    ('205.214.205.000', 'VC'),
    ('205.214.206.000', 'VG'),
    ('205.214.207.000', 'GD'),
    ('205.214.208.000', 'BB'),
    ('205.214.210.000', 'GD'),
    ('205.214.212.000', 'BB'),
    ('205.214.215.000', 'KN'),
    ('205.214.217.000', 'BB'),
    ('205.214.224.000', '--'),
    ('205.215.000.000', 'US'),
    ('205.216.143.000', 'ES'),
    ('205.216.144.000', 'US'),
    ('205.218.246.000', 'NI'),
    ('205.218.255.000', 'US'),
    ('205.219.255.000', 'HR'),
    ('205.220.000.000', 'US'),
    ('205.230.132.000', 'GU'),
    ('205.230.133.000', 'US'),
    ('205.231.116.000', 'MX'),
    ('205.231.120.000', 'US'),
    ('205.233.000.000', 'CA'),
    ('205.233.147.000', 'US'),
    ('205.233.148.000', 'CA'),
    ('205.234.000.000', 'US'),
    ('205.234.032.000', '--'),
    ('205.235.000.000', 'EC'),
    ('205.235.008.000', 'US'),
    ('205.236.000.000', 'CA'),
    ('205.236.051.000', 'US'),
    ('205.236.052.000', 'CA'),
    ('205.236.075.000', 'US'),
    ('205.236.076.000', 'CA'),
    ('205.238.000.000', 'US'),
    ('205.240.152.000', 'EC'),
    ('205.240.156.000', 'US'),
    ('205.241.012.000', 'MX'),
    ('205.241.013.000', 'US'),
    ('205.241.034.000', 'UG'),
    ('205.241.040.000', 'US'),
    ('205.244.032.000', 'DO'),
    ('205.244.036.000', 'SZ'),
    ('205.244.040.000', 'US'),
    ('205.244.042.000', 'ES'),
    ('205.244.044.000', 'US'),
    ('205.244.054.000', 'NL'),
    ('205.244.056.000', 'US'),
    ('205.244.153.000', 'ES'),
    ('205.244.154.000', 'US'),
    ('205.245.128.000', 'KY'),
    ('205.245.130.000', 'US'),
    ('205.245.140.000', 'BE'),
    ('205.245.142.000', 'LU'),
    ('205.245.144.000', 'US'),
    ('205.246.032.000', 'CA'),
    ('205.246.040.000', 'US'),
    ('205.248.000.000', 'SG'),
    ('205.248.006.000', 'GB'),
    ('205.248.010.000', 'US'),
    ('205.248.024.000', 'BE'),
    ('205.248.026.000', 'FR'),
    ('205.248.027.000', 'US'),
    ('205.248.028.000', 'BE'),
    ('205.248.029.000', 'US'),
    ('205.248.037.000', 'NL'),
    ('205.248.038.000', 'US'),
    ('205.248.039.000', 'IE'),
    ('205.248.040.000', 'KR'),
    ('205.248.041.000', 'US'),
    ('205.248.047.000', 'DE'),
    ('205.248.048.000', 'TW'),
    ('205.248.049.000', 'DE'),
    ('205.248.050.000', 'US'),
    ('205.248.052.000', 'KR'),
    ('205.248.053.000', 'FR'),
    ('205.248.054.000', 'CH'),
    ('205.248.056.000', 'NL'),
    ('205.248.057.000', 'US'),
    ('205.248.059.000', 'FR'),
    ('205.248.060.000', 'US'),
    ('205.248.065.000', 'NO'),
    ('205.248.066.000', 'US'),
    ('205.248.067.000', 'MX'),
    ('205.248.068.000', 'TW'),
    ('205.248.070.000', 'GB'),
    ('205.248.072.000', 'US'),
    ('205.248.073.000', 'GB'),
    ('205.248.074.000', 'US'),
    ('205.248.075.000', 'GB'),
    ('205.248.077.000', 'US'),
    ('205.248.078.000', 'GB'),
    ('205.248.080.000', 'US'),
    ('205.248.130.000', 'JP'),
    ('205.248.133.000', 'US'),
    ('205.248.134.000', 'CA'),
    ('205.248.135.000', 'US'),
    ('205.248.137.000', 'GB'),
    ('205.248.144.000', 'US'),
    ('205.248.147.000', 'GB'),
    ('205.248.148.000', 'US'),
    ('205.248.154.000', 'GB'),
    ('205.248.156.000', 'US'),
    ('205.248.164.000', 'FR'),
    ('205.248.165.000', 'US'),
    ('205.248.177.000', 'DK'),
    ('205.248.180.000', 'BE'),
    ('205.248.181.000', 'CA'),
    ('205.248.182.000', 'GB'),
    ('205.248.190.000', 'US'),
    ('205.248.191.000', 'GB'),
    ('205.248.192.000', 'ES'),
    ('205.248.197.000', 'US'),
    ('205.248.198.000', 'GB'),
    ('205.248.200.000', 'US'),
    ('205.248.204.000', 'DE'),
    ('205.248.208.000', 'US'),
    ('205.248.209.000', 'FR'),
    ('205.248.210.000', 'DE'),
    ('205.248.211.000', 'CA'),
    ('205.248.212.000', 'US'),
    ('205.248.217.000', 'GB'),
    ('205.248.219.000', 'BE'),
    ('205.248.220.000', 'US'),
    ('205.248.224.000', 'IT'),
    ('205.248.225.000', 'US'),
    ('205.248.226.000', 'CA'),
    ('205.248.227.000', 'GB'),
    ('205.248.228.000', 'US'),
    ('205.248.229.000', 'GB'),
    ('205.248.230.000', 'NL'),
    ('205.248.231.000', 'GB'),
    ('205.248.232.000', 'US'),
    ('205.248.237.000', 'FR'),
    ('205.248.238.000', 'US'),
    ('205.248.242.000', 'HK'),
    ('205.248.243.000', 'US'),
    ('205.248.245.000', 'GB'),
    ('205.248.247.000', 'JP'),
    ('205.248.248.000', 'BE'),
    ('205.248.249.000', 'FR'),
    ('205.248.252.000', 'SE'),
    ('205.248.253.000', 'GB'),
    ('205.248.254.000', 'HK'),
    ('205.248.255.000', 'IT'),
    ('205.249.000.000', 'US'),
    ('205.250.000.000', 'CA'),
    ('205.252.000.000', 'US'),
    ('206.012.000.000', 'CA'),
    ('206.013.000.000', 'US'),
    ('206.022.014.000', 'CA'),
    ('206.022.015.000', 'US'),
    ('206.022.019.000', 'CA'),
    ('206.022.021.000', 'US'),
    ('206.022.023.000', 'CA'),
    ('206.022.024.000', 'US'),
    ('206.022.029.000', 'CA'),
    ('206.022.030.000', 'US'),
    ('206.022.105.000', 'CA'),
    ('206.022.106.000', 'US'),
    ('206.022.115.000', 'CA'),
    ('206.022.117.000', 'US'),
    ('206.022.126.000', 'CA'),
    ('206.022.127.000', 'US'),
    ('206.022.134.000', 'CA'),
    ('206.022.135.000', 'US'),
    ('206.022.172.000', 'CA'),
    ('206.022.173.000', 'US'),
    ('206.022.184.000', 'CA'),
    ('206.022.186.000', 'US'),
    ('206.022.189.000', 'CA'),
    ('206.022.193.000', 'US'),
    ('206.022.195.000', 'CA'),
    ('206.022.196.000', 'US'),
    ('206.022.204.000', 'CA'),
    ('206.022.205.000', 'US'),
    ('206.028.140.000', 'MZ'),
    ('206.028.142.000', 'US'),
    ('206.028.184.000', 'PA'),
    ('206.028.190.000', 'US'),
    ('206.029.144.000', 'PA'),
    ('206.029.160.000', 'US'),
    ('206.031.176.000', 'CL'),
    ('206.031.180.000', 'US'),
    ('206.037.116.000', 'IT'),
    ('206.037.118.000', 'US'),
    ('206.037.184.000', 'KR'),
    ('206.037.185.000', 'JP'),
    ('206.037.186.000', 'US'),
    ('206.045.000.000', 'CA'),
    ('206.046.000.000', 'US'),
    ('206.047.000.000', 'CA'),
    ('206.048.000.000', 'US'),
    ('206.048.020.000', 'AW'),
    ('206.048.024.000', 'US'),
    ('206.048.049.000', 'VE'),
    ('206.048.050.000', 'US'),
    ('206.048.100.000', 'AW'),
    ('206.048.104.000', 'US'),
    ('206.048.129.000', 'CL'),
    ('206.048.131.000', 'US'),
    ('206.048.144.000', 'CL'),
    ('206.048.145.000', 'US'),
    ('206.048.146.000', 'CL'),
    ('206.048.150.000', 'US'),
    ('206.048.160.000', 'DO'),
    ('206.048.164.000', 'US'),
    ('206.048.168.000', 'KR'),
    ('206.048.172.000', 'US'),
    ('206.048.232.000', 'DO'),
    ('206.048.234.000', 'US'),
    ('206.048.236.000', 'MX'),
    ('206.048.237.000', 'US'),
    ('206.049.032.000', 'VE'),
    ('206.049.033.000', 'SZ'),
    ('206.049.034.000', 'CA'),
    ('206.049.038.000', 'CO'),
    ('206.049.040.000', 'CL'),
    ('206.049.044.000', 'VE'),
    ('206.049.048.000', 'CL'),
    ('206.049.050.000', 'US'),
    ('206.049.052.000', 'MX'),
    ('206.049.054.000', 'PA'),
    ('206.049.058.000', 'MX'),
    ('206.049.060.000', 'PW'),
    ('206.049.062.000', 'MR'),
    ('206.049.063.000', 'US'),
    ('206.049.065.000', 'CA'),
    ('206.049.066.000', 'US'),
    ('206.049.067.000', 'CU'),
    ('206.049.068.000', 'US'),
    ('206.049.069.000', 'VE'),
    ('206.049.070.000', 'DO'),
    ('206.049.071.000', 'VE'),
    ('206.049.072.000', 'MX'),
    ('206.049.073.000', 'US'),
    ('206.049.074.000', 'LK'),
    ('206.049.075.000', 'AW'),
    ('206.049.076.000', 'CO'),
    ('206.049.077.000', 'VE'),
    ('206.049.078.000', 'MX'),
    ('206.049.079.000', 'PR'),
    ('206.049.080.000', 'SV'),
    ('206.049.081.000', 'PH'),
    ('206.049.084.000', 'ID'),
    ('206.049.085.000', 'US'),
    ('206.049.086.000', 'ID'),
    ('206.049.087.000', 'VE'),
    ('206.049.088.000', 'MX'),
    ('206.049.089.000', 'FM'),
    ('206.049.090.000', 'SK'),
    ('206.049.091.000', 'MX'),
    ('206.049.092.000', 'TW'),
    ('206.049.093.000', 'US'),
    ('206.049.094.000', 'IL'),
    ('206.049.095.000', 'LK'),
    ('206.049.096.000', 'VE'),
    ('206.049.097.000', 'BY'),
    ('206.049.098.000', 'VE'),
    ('206.049.099.000', 'BR'),
    ('206.049.100.000', 'CA'),
    ('206.049.101.000', 'OM'),
    ('206.049.103.000', 'US'),
    ('206.049.104.000', 'CO'),
    ('206.049.108.000', 'US'),
    ('206.049.109.000', 'OM'),
    ('206.049.111.000', 'US'),
    ('206.049.112.000', 'LK'),
    ('206.049.113.000', 'US'),
    ('206.049.114.000', 'PR'),
    ('206.049.116.000', 'US'),
    ('206.049.117.000', 'PR'),
    ('206.049.119.000', 'AG'),
    ('206.049.120.000', 'CO'),
    ('206.049.121.000', 'BW'),
    ('206.049.122.000', 'IT'),
    ('206.049.124.000', 'US'),
    ('206.049.128.000', 'VE'),
    ('206.049.136.000', 'US'),
    ('206.049.137.000', 'FM'),
    ('206.049.138.000', 'US'),
    ('206.049.139.000', 'CO'),
    ('206.049.144.000', 'NI'),
    ('206.049.154.000', 'VE'),
    ('206.049.155.000', 'HT'),
    ('206.049.156.000', 'SV'),
    ('206.049.157.000', 'TG'),
    ('206.049.158.000', 'PR'),
    ('206.049.160.000', 'VE'),
    ('206.049.161.000', 'US'),
    ('206.049.176.000', 'CO'),
    ('206.049.184.000', 'AR'),
    ('206.049.192.000', 'VE'),
    ('206.049.196.000', 'VN'),
    ('206.049.197.000', 'VE'),
    ('206.049.200.000', 'MX'),
    ('206.049.208.000', 'PE'),
    ('206.049.216.000', 'US'),
    ('206.049.217.000', 'CL'),
    ('206.049.224.000', 'US'),
    ('206.051.000.000', 'CA'),
    ('206.052.000.000', 'US'),
    ('206.055.135.000', 'IT'),
    ('206.055.136.000', 'US'),
    ('206.055.164.000', '--'),
    ('206.055.192.000', 'US'),
    ('206.061.002.000', 'MX'),
    ('206.061.004.000', 'US'),
    ('206.065.032.000', 'MX'),
    ('206.065.036.000', 'US'),
    ('206.065.181.000', 'IL'),
    ('206.065.182.000', 'US'),
    ('206.066.085.000', 'BS'),
    ('206.066.086.000', 'US'),
    ('206.067.040.000', 'MX'),
    ('206.067.041.000', 'US'),
    ('206.071.100.000', 'CA'),
    ('206.071.103.000', 'US'),
    ('206.073.002.000', 'CL'),
    ('206.073.003.000', 'US'),
    ('206.073.006.000', 'FR'),
    ('206.073.007.000', 'US'),
    ('206.073.011.000', 'IT'),
    ('206.073.012.000', 'US'),
    ('206.073.015.000', 'JP'),
    ('206.073.016.000', 'NL'),
    ('206.073.017.000', 'DK'),
    ('206.073.018.000', 'BE'),
    ('206.073.019.000', 'US'),
    ('206.073.022.000', 'ZA'),
    ('206.073.023.000', 'ES'),
    ('206.073.024.000', 'FR'),
    ('206.073.025.000', 'GB'),
    ('206.073.026.000', 'SE'),
    ('206.073.027.000', 'US'),
    ('206.073.031.000', 'IE'),
    ('206.073.032.000', 'US'),
    ('206.073.034.000', 'ZA'),
    ('206.073.035.000', 'US'),
    ('206.073.039.000', 'PE'),
    ('206.073.040.000', 'US'),
    ('206.073.042.000', 'SE'),
    ('206.073.043.000', 'US'),
    ('206.073.045.000', 'IN'),
    ('206.073.046.000', 'US'),
    ('206.073.052.000', 'VE'),
    ('206.073.053.000', 'FI'),
    ('206.073.055.000', 'US'),
    ('206.073.062.000', 'ID'),
    ('206.073.063.000', 'US'),
    ('206.073.065.000', 'SG'),
    ('206.073.066.000', 'US'),
    ('206.073.069.000', 'FI'),
    ('206.073.070.000', 'US'),
    ('206.073.071.000', 'IE'),
    ('206.073.077.000', 'US'),
    ('206.073.078.000', 'IE'),
    ('206.073.079.000', 'US'),
    ('206.073.084.000', 'IT'),
    ('206.073.085.000', 'FR'),
    ('206.073.086.000', 'ES'),
    ('206.073.087.000', 'US'),
    ('206.073.089.000', 'FR'),
    ('206.073.090.000', 'US'),
    ('206.073.100.000', 'CH'),
    ('206.073.101.000', 'GB'),
    ('206.073.102.000', 'AR'),
    ('206.073.103.000', 'CA'),
    ('206.073.104.000', 'US'),
    ('206.073.106.000', 'CA'),
    ('206.073.107.000', 'US'),
    ('206.073.108.000', 'NL'),
    ('206.073.109.000', 'US'),
    ('206.073.110.000', 'JP'),
    ('206.073.111.000', 'NL'),
    ('206.073.112.000', 'US'),
    ('206.073.116.000', 'IT'),
    ('206.073.117.000', 'BE'),
    ('206.073.118.000', 'IE'),
    ('206.073.119.000', 'US'),
    ('206.073.120.000', 'DE'),
    ('206.073.121.000', 'AU'),
    ('206.073.122.000', 'US'),
    ('206.073.128.000', 'MX'),
    ('206.073.129.000', 'US'),
    ('206.073.131.000', 'GB'),
    ('206.073.135.000', 'US'),
    ('206.073.137.000', 'ES'),
    ('206.073.138.000', 'US'),
    ('206.073.139.000', 'GB'),
    ('206.073.140.000', 'US'),
    ('206.073.141.000', 'DE'),
    ('206.073.142.000', 'US'),
    ('206.073.143.000', 'BE'),
    ('206.073.150.000', 'US'),
    ('206.073.151.000', 'DE'),
    ('206.073.152.000', 'GB'),
    ('206.073.153.000', 'DK'),
    ('206.073.154.000', 'US'),
    ('206.073.158.000', 'GR'),
    ('206.073.159.000', 'US'),
    ('206.073.160.000', 'SE'),
    ('206.073.161.000', 'DE'),
    ('206.073.162.000', 'GB'),
    ('206.073.163.000', 'FR'),
    ('206.073.164.000', 'US'),
    ('206.073.165.000', 'GB'),
    ('206.073.166.000', 'US'),
    ('206.073.167.000', 'DE'),
    ('206.073.168.000', 'US'),
    ('206.073.169.000', 'DE'),
    ('206.073.170.000', 'US'),
    ('206.073.172.000', 'CH'),
    ('206.073.173.000', 'SG'),
    ('206.073.174.000', 'US'),
    ('206.073.175.000', 'FR'),
    ('206.073.176.000', 'FI'),
    ('206.073.177.000', 'FR'),
    ('206.073.178.000', 'US'),
    ('206.073.179.000', 'GB'),
    ('206.073.180.000', 'US'),
    ('206.073.181.000', 'DE'),
    ('206.073.182.000', 'FR'),
    ('206.073.183.000', 'US'),
    ('206.073.184.000', 'DK'),
    ('206.073.185.000', 'IE'),
    ('206.073.186.000', 'DE'),
    ('206.073.187.000', 'US'),
    ('206.073.190.000', 'HK'),
    ('206.073.191.000', 'US'),
    ('206.073.194.000', 'MX'),
    ('206.073.195.000', 'US'),
    ('206.073.198.000', 'MY'),
    ('206.073.199.000', 'AU'),
    ('206.073.200.000', 'US'),
    ('206.073.201.000', 'GB'),
    ('206.073.202.000', 'US'),
    ('206.073.203.000', 'IE'),
    ('206.073.204.000', 'US'),
    ('206.073.206.000', 'ID'),
    ('206.073.207.000', 'HK'),
    ('206.073.208.000', 'US'),
    ('206.073.211.000', 'KR'),
    ('206.073.212.000', 'DE'),
    ('206.073.213.000', 'US'),
    ('206.073.215.000', 'GB'),
    ('206.073.216.000', 'US'),
    ('206.073.219.000', 'DE'),
    ('206.073.220.000', 'CH'),
    ('206.073.221.000', 'BE'),
    ('206.073.222.000', 'DE'),
    ('206.073.223.000', 'SE'),
    ('206.073.224.000', 'US'),
    ('206.073.227.000', 'PH'),
    ('206.073.228.000', 'US'),
    ('206.073.233.000', 'DE'),
    ('206.073.234.000', 'TW'),
    ('206.073.235.000', 'US'),
    ('206.073.237.000', 'GB'),
    ('206.073.238.000', 'JP'),
    ('206.073.239.000', 'US'),
    ('206.073.241.000', 'GB'),
    ('206.073.242.000', 'ES'),
    ('206.073.243.000', 'US'),
    ('206.073.246.000', 'BR'),
    ('206.073.247.000', 'GB'),
    ('206.073.248.000', 'US'),
    ('206.073.249.000', 'DO'),
    ('206.073.250.000', 'DE'),
    ('206.073.251.000', 'LU'),
    ('206.073.252.000', 'US'),
    ('206.073.253.000', 'JP'),
    ('206.073.254.000', 'US'),
    ('206.075.000.000', 'CA'),
    ('206.076.000.000', 'US'),
    ('206.082.128.000', 'JM'),
    ('206.082.129.000', 'PK'),
    ('206.082.130.000', 'BF'),
    ('206.082.131.000', 'CA'),
    ('206.082.132.000', 'US'),
    ('206.082.133.000', 'QA'),
    ('206.082.134.000', 'US'),
    ('206.082.135.000', 'CA'),
    ('206.082.136.000', 'AN'),
    ('206.082.139.000', 'PK'),
    ('206.082.140.000', 'IL'),
    ('206.082.141.000', 'PK'),
    ('206.082.142.000', 'US'),
    ('206.082.143.000', 'PA'),
    ('206.082.144.000', '--'),
    ('206.082.160.000', 'US'),
    ('206.082.164.000', '--'),
    ('206.082.192.000', 'US'),
    ('206.083.008.000', '--'),
    ('206.083.032.000', 'CA'),
    ('206.083.040.000', '--'),
    ('206.083.064.000', 'US'),
    ('206.083.136.000', '--'),
    ('206.083.160.000', 'US'),
    ('206.083.192.000', '--'),
    ('206.083.224.000', 'US'),
    ('206.083.228.000', '--'),
    ('206.084.000.000', 'US'),
    ('206.084.064.000', 'CL'),
    ('206.084.096.000', 'US'),
    ('206.087.000.000', 'CA'),
    ('206.088.000.000', 'US'),
    ('206.088.094.000', 'CA'),
    ('206.088.095.000', 'US'),
    ('206.088.124.000', 'CA'),
    ('206.088.125.000', 'US'),
    ('206.089.006.000', 'CA'),
    ('206.089.007.000', 'US'),
    ('206.089.035.000', 'CA'),
    ('206.089.036.000', 'US'),
    ('206.089.038.000', 'CA'),
    ('206.089.039.000', 'US'),
    ('206.089.041.000', 'CA'),
    ('206.089.043.000', 'US'),
    ('206.089.045.000', 'CA'),
    ('206.089.047.000', 'US'),
    ('206.089.056.000', 'CA'),
    ('206.089.057.000', 'US'),
    ('206.089.113.000', 'CA'),
    ('206.089.114.000', 'US'),
    ('206.089.122.000', 'CA'),
    ('206.089.123.000', 'US'),
    ('206.089.129.000', 'CA'),
    ('206.089.130.000', 'US'),
    ('206.089.151.000', 'CA'),
    ('206.089.152.000', 'US'),
    ('206.089.178.000', 'CA'),
    ('206.089.179.000', 'US'),
    ('206.089.209.000', 'CA'),
    ('206.089.210.000', 'US'),
    ('206.089.241.000', 'CA'),
    ('206.089.242.000', 'US'),
    ('206.089.245.000', 'CA'),
    ('206.089.247.000', 'US'),
    ('206.092.050.000', 'CA'),
    ('206.092.051.000', 'US'),
    ('206.092.110.000', 'CA'),
    ('206.092.111.000', 'US'),
    ('206.092.127.000', 'CA'),
    ('206.092.128.000', 'US'),
    ('206.092.132.000', 'CA'),
    ('206.092.133.000', 'US'),
    ('206.092.136.000', 'CA'),
    ('206.092.138.000', 'US'),
    ('206.092.139.000', 'CA'),
    ('206.092.140.000', 'US'),
    ('206.092.148.000', 'CA'),
    ('206.092.149.000', 'US'),
    ('206.092.151.000', 'CA'),
    ('206.092.152.000', 'US'),
    ('206.092.172.000', 'CA'),
    ('206.092.173.000', 'US'),
    ('206.092.178.000', 'CA'),
    ('206.092.181.000', 'US'),
    ('206.092.228.000', 'CA'),
    ('206.092.229.000', 'US'),
    ('206.093.116.000', 'CA'),
    ('206.093.117.000', 'US'),
    ('206.093.119.000', 'CA'),
    ('206.093.120.000', 'US'),
    ('206.094.006.000', 'CA'),
    ('206.094.007.000', 'US'),
    ('206.094.039.000', 'CA'),
    ('206.094.040.000', 'US'),
    ('206.094.091.000', 'CA'),
    ('206.094.092.000', 'US'),
    ('206.094.185.000', 'CA'),
    ('206.094.186.000', 'US'),
    ('206.094.213.000', 'CA'),
    ('206.094.214.000', 'US'),
    ('206.094.215.000', 'CA'),
    ('206.094.216.000', 'US'),
    ('206.094.222.000', 'CA'),
    ('206.094.223.000', 'US'),
    ('206.095.026.000', 'CA'),
    ('206.095.028.000', 'US'),
    ('206.095.032.000', 'CA'),
    ('206.095.033.000', 'US'),
    ('206.095.072.000', 'CA'),
    ('206.095.073.000', 'US'),
    ('206.097.024.000', 'PA'),
    ('206.097.025.000', 'US'),
    ('206.097.026.000', 'PA'),
    ('206.097.032.000', 'US'),
    ('206.098.253.000', 'GN'),
    ('206.099.000.000', 'US'),
    ('206.099.044.000', 'UY'),
    ('206.099.056.000', 'US'),
    ('206.099.120.000', 'PA'),
    ('206.099.127.000', 'US'),
    ('206.099.198.000', 'PK'),
    ('206.099.199.000', 'US'),
    ('206.100.199.000', 'HR'),
    ('206.100.200.000', 'US'),
    ('206.100.205.000', 'HR'),
    ('206.100.206.000', 'US'),
    ('206.100.230.000', 'MX'),
    ('206.100.231.000', 'US'),
    ('206.101.068.000', 'PH'),
    ('206.101.070.000', 'US'),
    ('206.101.197.000', 'PH'),
    ('206.101.198.000', 'US'),
    ('206.102.001.000', 'IN'),
    ('206.102.002.000', 'US'),
    ('206.103.010.000', 'IN'),
    ('206.103.014.000', 'US'),
    ('206.103.030.000', 'EG'),
    ('206.103.032.000', 'US'),
    ('206.105.174.000', 'PR'),
    ('206.105.176.000', 'US'),
    ('206.105.216.000', 'ES'),
    ('206.105.220.000', 'US'),
    ('206.106.140.000', 'CA'),
    ('206.106.144.000', 'US'),
    ('206.106.255.000', 'CA'),
    ('206.107.000.000', 'US'),
    ('206.107.148.000', 'UG'),
    ('206.107.152.000', 'US'),
    ('206.108.000.000', 'CA'),
    ('206.109.000.000', 'US'),
    ('206.109.050.000', 'CN'),
    ('206.109.051.000', 'US'),
    ('206.112.060.000', 'CA'),
    ('206.112.061.000', 'US'),
    ('206.112.131.000', 'CA'),
    ('206.112.132.000', 'US'),
    ('206.113.212.000', 'CA'),
    ('206.113.224.000', 'US'),
    ('206.114.000.000', 'CO'),
    ('206.114.032.000', 'US'),
    ('206.116.000.000', 'CA'),
    ('206.117.000.000', 'US'),
    ('206.123.000.000', 'CA'),
    ('206.124.000.000', 'US'),
    ('206.127.198.000', 'IN'),
    ('206.127.199.000', 'US'),
    ('206.127.207.000', 'IN'),
    ('206.127.208.000', 'US'),
    ('206.128.112.000', 'PA'),
    ('206.128.120.000', 'US'),
    ('206.128.192.000', 'PA'),
    ('206.128.208.000', 'AG'),
    ('206.128.210.000', 'KN'),
    ('206.128.211.000', 'AG'),
    ('206.128.215.000', 'LC'),
    ('206.128.216.000', 'PA'),
    ('206.128.220.000', 'US'),
    ('206.130.000.000', 'CA'),
    ('206.131.000.000', 'US'),
    ('206.137.097.000', 'CL'),
    ('206.137.100.000', 'US'),
    ('206.138.016.000', 'BS'),
    ('206.138.032.000', 'US'),
    ('206.138.104.000', 'PE'),
    ('206.138.112.000', 'US'),
    ('206.142.100.000', 'PH'),
    ('206.142.102.000', 'US'),
    ('206.142.244.000', 'PH'),
    ('206.142.245.000', 'US'),
    ('206.143.128.000', 'JP'),
    ('206.144.000.000', 'US'),
    ('206.150.065.000', 'MX'),
    ('206.150.066.000', 'US'),
    ('206.151.048.000', 'PA'),
    ('206.151.064.000', 'US'),
    ('206.151.136.000', 'PH'),
    ('206.151.140.000', 'US'),
    ('206.152.001.000', 'HT'),
    ('206.152.002.000', 'US'),
    ('206.152.015.000', 'HT'),
    ('206.152.016.000', 'US'),
    ('206.153.053.000', 'PR'),
    ('206.153.054.000', 'US'),
    ('206.154.021.000', 'MX'),
    ('206.154.022.000', 'US'),
    ('206.154.048.000', 'PA'),
    ('206.154.056.000', 'US'),
    ('206.155.162.000', 'SN'),
    ('206.155.164.000', 'US'),
    ('206.162.045.000', 'RU'),
    ('206.162.046.000', 'US'),
    ('206.162.128.000', 'CA'),
    ('206.162.192.000', 'US'),
    ('206.162.224.000', '--'),
    ('206.163.000.000', 'US'),
    ('206.163.224.000', 'CA'),
    ('206.163.240.000', '--'),
    ('206.164.000.000', 'US'),
    ('206.167.000.000', 'CA'),
    ('206.167.001.000', 'US'),
    ('206.167.002.000', 'CA'),
    ('206.167.057.000', 'US'),
    ('206.167.058.000', 'CA'),
    ('206.167.070.000', 'US'),
    ('206.167.072.000', 'CA'),
    ('206.168.000.000', 'US'),
    ('206.168.117.000', 'CO'),
    ('206.168.118.000', 'US'),
    ('206.172.000.000', 'CA'),
    ('206.173.000.000', 'US'),
    ('206.174.000.000', '--'),
    ('206.175.000.000', 'US'),
    ('206.177.000.000', 'CA'),
    ('206.180.000.000', 'US'),
    ('206.180.192.000', 'CA'),
    ('206.180.208.000', '--'),
    ('206.180.224.000', 'US'),
    ('206.180.240.000', '--'),
    ('206.181.000.000', 'US'),
    ('206.182.000.000', 'GB'),
    ('206.182.008.000', 'BE'),
    ('206.182.009.000', 'DE'),
    ('206.182.010.000', 'ES'),
    ('206.182.011.000', 'DE'),
    ('206.182.013.000', 'US'),
    ('206.182.015.000', 'IE'),
    ('206.182.016.000', 'FR'),
    ('206.182.018.000', 'NL'),
    ('206.182.019.000', 'SE'),
    ('206.182.020.000', 'FR'),
    ('206.182.021.000', 'US'),
    ('206.182.028.000', 'FI'),
    ('206.182.029.000', 'US'),
    ('206.182.030.000', 'TW'),
    ('206.182.031.000', 'US'),
    ('206.182.033.000', 'AT'),
    ('206.182.034.000', 'US'),
    ('206.182.041.000', 'ES'),
    ('206.182.042.000', 'GB'),
    ('206.182.043.000', 'DE'),
    ('206.182.044.000', 'US'),
    ('206.182.045.000', 'MA'),
    ('206.182.046.000', 'NO'),
    ('206.182.047.000', 'ZA'),
    ('206.182.048.000', 'FR'),
    ('206.182.049.000', 'US'),
    ('206.182.050.000', 'IT'),
    ('206.182.051.000', 'US'),
    ('206.182.052.000', 'DE'),
    ('206.182.053.000', 'US'),
    ('206.182.054.000', 'ES'),
    ('206.182.055.000', 'US'),
    ('206.182.056.000', 'FR'),
    ('206.182.057.000', 'US'),
    ('206.182.060.000', 'GB'),
    ('206.182.061.000', 'US'),
    ('206.182.062.000', 'IT'),
    ('206.182.063.000', 'US'),
    ('206.182.064.000', 'SE'),
    ('206.182.065.000', 'US'),
    ('206.182.066.000', 'GB'),
    ('206.182.067.000', 'US'),
    ('206.182.069.000', 'IT'),
    ('206.182.070.000', 'US'),
    ('206.182.073.000', 'GB'),
    ('206.182.074.000', 'ES'),
    ('206.182.075.000', 'ZA'),
    ('206.182.076.000', 'AU'),
    ('206.182.077.000', 'CH'),
    ('206.182.078.000', 'DE'),
    ('206.182.079.000', 'US'),
    ('206.182.083.000', 'BE'),
    ('206.182.084.000', 'US'),
    ('206.182.085.000', 'NL'),
    ('206.182.086.000', 'FR'),
    ('206.182.087.000', 'CH'),
    ('206.182.088.000', 'NO'),
    ('206.182.089.000', 'DK'),
    ('206.182.090.000', 'LU'),
    ('206.182.091.000', 'GB'),
    ('206.182.092.000', 'IL'),
    ('206.182.093.000', 'US'),
    ('206.182.094.000', 'BE'),
    ('206.182.095.000', '--'),
    ('206.182.096.000', 'US'),
    ('206.182.100.000', 'FR'),
    ('206.182.101.000', 'DE'),
    ('206.182.102.000', 'FR'),
    ('206.182.104.000', 'US'),
    ('206.182.105.000', 'FR'),
    ('206.182.106.000', 'US'),
    ('206.182.108.000', 'JP'),
    ('206.182.109.000', 'US'),
    ('206.182.111.000', 'AT'),
    ('206.182.112.000', 'NL'),
    ('206.182.114.000', 'US'),
    ('206.182.115.000', 'BE'),
    ('206.182.116.000', 'US'),
    ('206.182.117.000', 'HK'),
    ('206.182.118.000', 'US'),
    ('206.182.119.000', 'BE'),
    ('206.182.120.000', 'DE'),
    ('206.182.121.000', 'US'),
    ('206.182.122.000', 'DE'),
    ('206.182.123.000', 'US'),
    ('206.182.124.000', 'IT'),
    ('206.182.125.000', 'US'),
    ('206.182.127.000', 'IT'),
    ('206.182.128.000', 'US'),
    ('206.182.130.000', 'BR'),
    ('206.182.131.000', 'US'),
    ('206.182.133.000', 'MC'),
    ('206.182.134.000', 'US'),
    ('206.182.136.000', 'CA'),
    ('206.182.139.000', 'US'),
    ('206.182.155.000', 'CA'),
    ('206.182.156.000', 'US'),
    ('206.182.185.000', 'DE'),
    ('206.182.186.000', 'AT'),
    ('206.182.187.000', 'US'),
    ('206.182.189.000', 'NO'),
    ('206.182.190.000', 'US'),
    ('206.182.195.000', 'AU'),
    ('206.182.196.000', 'US'),
    ('206.182.198.000', 'SG'),
    ('206.182.199.000', 'AU'),
    ('206.182.200.000', 'BR'),
    ('206.182.201.000', 'JP'),
    ('206.182.202.000', 'ID'),
    ('206.182.203.000', 'US'),
    ('206.182.206.000', 'HK'),
    ('206.182.207.000', 'US'),
    ('206.182.210.000', 'SG'),
    ('206.182.211.000', 'US'),
    ('206.182.221.000', 'IT'),
    ('206.182.222.000', 'US'),
    ('206.182.223.000', 'JP'),
    ('206.182.224.000', 'NL'),
    ('206.182.225.000', 'US'),
    ('206.182.226.000', 'KR'),
    ('206.182.227.000', 'US'),
    ('206.182.233.000', 'DE'),
    ('206.182.234.000', 'US'),
    ('206.182.235.000', 'HK'),
    ('206.182.236.000', 'IT'),
    ('206.182.237.000', 'US'),
    ('206.182.239.000', 'SE'),
    ('206.182.240.000', 'DK'),
    ('206.182.242.000', 'US'),
    ('206.182.243.000', 'CA'),
    ('206.182.244.000', 'NO'),
    ('206.182.245.000', 'PH'),
    ('206.182.246.000', 'US'),
    ('206.182.247.000', 'DE'),
    ('206.182.248.000', 'US'),
    ('206.182.250.000', 'JP'),
    ('206.182.251.000', 'FR'),
    ('206.182.252.000', 'CN'),
    ('206.182.253.000', 'US'),
    ('206.182.255.000', 'FR'),
    ('206.183.000.000', 'US'),
    ('206.185.172.000', 'CA'),
    ('206.185.173.000', 'US'),
    ('206.186.000.000', 'CA'),
    ('206.187.000.000', 'US'),
    ('206.189.207.000', 'SG'),
    ('206.189.208.000', 'US'),
    ('206.191.000.000', 'CA'),
    ('206.191.030.000', 'US'),
    ('206.191.031.000', 'CA'),
    ('206.191.051.000', 'US'),
    ('206.191.052.000', 'CA'),
    ('206.191.128.000', 'US'),
    ('206.197.151.000', 'CA'),
    ('206.197.152.000', 'US'),
    ('206.199.110.000', 'MX'),
    ('206.199.111.000', 'US'),
    ('206.199.149.000', 'MX'),
    ('206.199.150.000', 'US'),
    ('206.220.132.000', 'HK'),
    ('206.220.136.000', 'US'),
    ('206.221.080.000', 'BR'),
    ('206.221.096.000', 'US'),
    ('206.221.208.000', '--'),
    ('206.221.224.000', 'US'),
    ('206.221.240.000', 'CA'),
    ('206.222.000.000', 'US'),
    ('206.222.064.000', 'CA'),
    ('206.222.096.000', 'US'),
    ('206.223.097.000', 'CA'),
    ('206.223.098.000', 'US'),
    ('206.223.113.000', 'CA'),
    ('206.223.114.000', 'US'),
    ('206.223.124.000', 'CO'),
    ('206.223.125.000', '--'),
    ('206.223.128.000', 'US'),
    ('206.223.130.000', 'PE'),
    ('206.223.131.000', '--'),
    ('206.223.132.000', 'US'),
    ('206.223.136.000', 'ZA'),
    ('206.223.137.000', '--'),
    ('206.224.000.000', 'US'),
    ('206.224.032.000', 'PA'),
    ('206.224.064.000', 'US'),
    ('206.225.128.000', 'HK'),
    ('206.225.132.000', '--'),
    ('206.225.160.000', 'US'),
    ('206.225.164.000', '--'),
    ('206.225.192.000', 'US'),
    ('206.228.036.000', 'VE'),
    ('206.228.040.000', 'US'),
    ('206.228.042.000', 'ES'),
    ('206.228.045.000', 'US'),
    ('206.231.068.000', 'EC'),
    ('206.231.072.000', 'US'),
    ('206.231.112.000', 'CA'),
    ('206.231.128.000', 'US'),
    ('206.231.192.000', 'CA'),
    ('206.231.224.000', 'US'),
    ('206.235.085.000', 'CA'),
    ('206.235.088.000', 'US'),
    ('206.235.200.000', 'CA'),
    ('206.235.208.000', 'US'),
    ('206.235.248.000', 'CA'),
    ('206.236.000.000', 'US'),
    ('206.241.202.000', 'BM'),
    ('206.241.204.000', 'US'),
    ('206.248.000.000', 'CA'),
    ('206.249.000.000', 'US'),
    ('206.250.194.000', 'GB'),
    ('206.250.195.000', 'US'),
    ('207.000.112.000', 'PH'),
    ('207.000.128.000', 'US'),
    ('207.001.121.000', 'KR'),
    ('207.001.122.000', 'US'),
    ('207.002.004.000', 'PH'),
    ('207.002.008.000', 'US'),
    ('207.002.012.000', 'PH'),
    ('207.002.016.000', 'US'),
    ('207.002.058.000', 'ID'),
    ('207.002.061.000', 'US'),
    ('207.002.096.000', 'BM'),
    ('207.002.101.000', 'US'),
    ('207.002.173.000', 'KW'),
    ('207.002.174.000', 'US'),
    ('207.003.062.000', '--'),
    ('207.003.063.000', 'US'),
    ('207.003.112.000', 'UY'),
    ('207.003.128.000', 'US'),
    ('207.003.136.000', 'MX'),
    ('207.003.137.000', 'US'),
    ('207.006.000.000', 'CA'),
    ('207.007.000.000', 'US'),
    ('207.007.128.000', '--'),
    ('207.008.000.000', 'US'),
    ('207.008.172.000', 'AU'),
    ('207.008.173.000', 'US'),
    ('207.013.118.000', 'EC'),
    ('207.013.120.000', 'US'),
    ('207.017.130.000', 'FR'),
    ('207.017.132.000', 'US'),
    ('207.017.191.000', 'MX'),
    ('207.017.192.000', 'US'),
    ('207.017.216.000', 'PE'),
    ('207.017.224.000', 'US'),
    ('207.019.252.000', 'PH'),
    ('207.020.000.000', 'US'),
    ('207.023.000.000', 'CA'),
    ('207.024.000.000', 'US'),
    ('207.024.026.000', 'GB'),
    ('207.024.027.000', 'US'),
    ('207.024.030.000', 'GB'),
    ('207.024.032.000', 'US'),
    ('207.025.102.000', 'JP'),
    ('207.025.103.000', 'US'),
    ('207.034.000.000', 'CA'),
    ('207.036.000.000', 'US'),
    ('207.036.011.000', 'PR'),
    ('207.036.021.000', 'US'),
    ('207.038.130.000', 'JM'),
    ('207.038.131.000', 'US'),
    ('207.041.240.000', 'CA'),
    ('207.042.000.000', 'US'),
    ('207.042.132.000', 'AG'),
    ('207.042.133.000', 'AI'),
    ('207.042.134.000', 'LC'),
    ('207.042.135.000', 'DM'),
    ('207.042.136.000', 'US'),
    ('207.042.176.000', 'HN'),
    ('207.042.192.000', 'US'),
    ('207.043.040.000', 'PA'),
    ('207.043.041.000', 'US'),
    ('207.043.043.000', 'PA'),
    ('207.043.044.000', 'US'),
    ('207.043.055.000', 'PA'),
    ('207.043.056.000', 'US'),
    ('207.047.000.000', '--'),
    ('207.048.000.000', 'US'),
    ('207.050.128.000', 'PA'),
    ('207.050.144.000', 'US'),
    ('207.050.224.000', 'SN'),
    ('207.050.238.000', 'US'),
    ('207.050.240.000', 'UY'),
    ('207.050.248.000', 'US'),
    ('207.052.224.000', 'CA'),
    ('207.052.225.000', 'US'),
    ('207.054.096.000', 'CA'),
    ('207.054.128.000', 'US'),
    ('207.054.192.000', '--'),
    ('207.055.000.000', 'US'),
    ('207.061.000.000', 'CA'),
    ('207.061.096.000', 'US'),
    ('207.061.097.000', 'CA'),
    ('207.062.000.000', 'US'),
    ('207.071.045.000', 'GB'),
    ('207.071.046.000', 'US'),
    ('207.076.096.000', 'CL'),
    ('207.076.100.000', 'US'),
    ('207.076.217.000', 'UM'),
    ('207.076.218.000', 'US'),
    ('207.079.128.000', 'CL'),
    ('207.079.144.000', 'US'),
    ('207.079.208.000', 'PE'),
    ('207.079.224.000', 'US'),
    ('207.081.000.000', 'CA'),
    ('207.082.000.000', 'US'),
    ('207.083.064.000', 'SG'),
    ('207.083.065.000', 'US'),
    ('207.083.096.000', 'AR'),
    ('207.083.097.000', 'US'),
    ('207.083.160.000', 'BR'),
    ('207.083.161.000', 'US'),
    ('207.095.242.000', 'CH'),
    ('207.095.243.000', 'US'),
    ('207.096.128.000', 'CA'),
    ('207.097.000.000', 'US'),
    ('207.102.000.000', 'CA'),
    ('207.103.000.000', 'US'),
    ('207.107.000.000', 'CA'),
    ('207.107.026.000', 'US'),
    ('207.107.027.000', 'CA'),
    ('207.108.000.000', 'US'),
    ('207.111.029.000', 'CA'),
    ('207.111.030.000', 'US'),
    ('207.112.000.000', 'CA'),
    ('207.112.006.000', 'US'),
    ('207.112.007.000', 'CA'),
    ('207.112.128.000', 'US'),
    ('207.112.236.000', 'CA'),
    ('207.112.238.000', 'US'),
    ('207.115.096.000', 'CA'),
    ('207.115.112.000', '--'),
    ('207.115.128.000', 'US'),
    ('207.117.000.000', 'JP'),
    ('207.117.001.000', 'DE'),
    ('207.117.002.000', 'GB'),
    ('207.117.003.000', 'US'),
    ('207.117.004.000', 'CH'),
    ('207.117.005.000', 'US'),
    ('207.117.006.000', 'AT'),
    ('207.117.007.000', 'MX'),
    ('207.117.008.000', 'SG'),
    ('207.117.009.000', 'HK'),
    ('207.117.010.000', 'US'),
    ('207.117.011.000', 'GB'),
    ('207.117.012.000', 'SG'),
    ('207.117.013.000', 'US'),
    ('207.117.015.000', 'NO'),
    ('207.117.016.000', 'FR'),
    ('207.117.017.000', 'SG'),
    ('207.117.019.000', 'HK'),
    ('207.117.020.000', 'US'),
    ('207.117.022.000', 'HK'),
    ('207.117.023.000', 'US'),
    ('207.117.024.000', 'JP'),
    ('207.117.025.000', 'CA'),
    ('207.117.026.000', 'US'),
    ('207.117.028.000', 'DO'),
    ('207.117.029.000', 'US'),
    ('207.117.031.000', 'IT'),
    ('207.117.032.000', 'US'),
    ('207.117.033.000', 'ZA'),
    ('207.117.035.000', 'US'),
    ('207.117.037.000', 'BR'),
    ('207.117.038.000', 'US'),
    ('207.117.041.000', 'JP'),
    ('207.117.042.000', 'US'),
    ('207.117.052.000', 'DE'),
    ('207.117.053.000', 'US'),
    ('207.117.061.000', 'GB'),
    ('207.117.063.000', 'US'),
    ('207.117.066.000', 'HK'),
    ('207.117.067.000', 'FR'),
    ('207.117.068.000', 'US'),
    ('207.117.071.000', 'HK'),
    ('207.117.072.000', 'US'),
    ('207.117.073.000', 'FR'),
    ('207.117.074.000', 'ES'),
    ('207.117.075.000', 'JP'),
    ('207.117.076.000', 'CH'),
    ('207.117.078.000', 'BE'),
    ('207.117.079.000', 'FI'),
    ('207.117.080.000', 'US'),
    ('207.117.093.000', 'BR'),
    ('207.117.094.000', 'US'),
    ('207.117.095.000', 'IT'),
    ('207.117.100.000', 'US'),
    ('207.117.109.000', 'IT'),
    ('207.117.111.000', 'HK'),
    ('207.117.112.000', 'JP'),
    ('207.117.113.000', 'KR'),
    ('207.117.114.000', 'SE'),
    ('207.117.115.000', 'DK'),
    ('207.117.116.000', 'US'),
    ('207.117.118.000', 'CL'),
    ('207.117.119.000', 'NO'),
    ('207.117.120.000', 'US'),
    ('207.117.121.000', 'RU'),
    ('207.117.122.000', 'MX'),
    ('207.117.125.000', 'US'),
    ('207.117.146.000', 'SE'),
    ('207.117.147.000', 'US'),
    ('207.117.155.000', 'ZA'),
    ('207.117.156.000', 'US'),
    ('207.117.157.000', 'ID'),
    ('207.117.159.000', 'NO'),
    ('207.117.160.000', 'CH'),
    ('207.117.161.000', 'IE'),
    ('207.117.162.000', 'SG'),
    ('207.117.163.000', 'DK'),
    ('207.117.164.000', 'SG'),
    ('207.117.165.000', 'CN'),
    ('207.117.166.000', 'ZA'),
    ('207.117.167.000', 'BE'),
    ('207.117.168.000', 'US'),
    ('207.117.173.000', 'TH'),
    ('207.117.174.000', 'SG'),
    ('207.117.178.000', 'US'),
    ('207.117.179.000', 'AU'),
    ('207.117.183.000', 'FR'),
    ('207.117.184.000', 'AU'),
    ('207.117.186.000', 'JP'),
    ('207.117.187.000', 'CA'),
    ('207.117.188.000', 'SG'),
    ('207.117.189.000', 'US'),
    ('207.117.192.000', 'DE'),
    ('207.117.194.000', 'BE'),
    ('207.117.195.000', 'AU'),
    ('207.117.196.000', 'GB'),
    ('207.117.197.000', 'FR'),
    ('207.117.198.000', 'US'),
    ('207.117.201.000', 'IT'),
    ('207.117.204.000', 'BE'),
    ('207.117.205.000', 'HK'),
    ('207.117.206.000', 'ES'),
    ('207.117.208.000', 'IL'),
    ('207.117.209.000', 'GB'),
    ('207.117.210.000', 'MX'),
    ('207.117.211.000', 'PH'),
    ('207.117.212.000', 'MX'),
    ('207.117.213.000', 'PH'),
    ('207.117.214.000', 'MX'),
    ('207.117.215.000', 'BE'),
    ('207.117.216.000', 'GR'),
    ('207.117.217.000', 'CA'),
    ('207.117.218.000', 'IT'),
    ('207.117.219.000', 'US'),
    ('207.117.230.000', 'ES'),
    ('207.117.231.000', 'US'),
    ('207.117.232.000', 'AU'),
    ('207.117.233.000', 'US'),
    ('207.117.234.000', 'JP'),
    ('207.117.235.000', 'MX'),
    ('207.117.236.000', 'BR'),
    ('207.117.237.000', 'LU'),
    ('207.117.238.000', 'DE'),
    ('207.117.243.000', 'US'),
    ('207.118.000.000', '--'),
    ('207.120.000.000', 'US'),
    ('207.121.022.000', 'DE'),
    ('207.121.024.000', 'US'),
    ('207.121.101.000', 'GB'),
    ('207.121.104.000', 'US'),
    ('207.122.110.000', 'FR'),
    ('207.122.112.000', 'US'),
    ('207.123.092.000', 'AU'),
    ('207.123.093.000', 'US'),
    ('207.124.066.000', 'TO'),
    ('207.124.067.000', 'US'),
    ('207.124.073.000', 'TO'),
    ('207.124.074.000', 'US'),
    ('207.124.114.000', '--'),
    ('207.124.115.000', 'US'),
    ('207.124.231.000', 'SV'),
    ('207.124.234.000', 'US'),
    ('207.124.238.000', 'SV'),
    ('207.124.240.000', 'US'),
    ('207.134.000.000', 'CA'),
    ('207.135.000.000', 'US'),
    ('207.136.064.000', 'CA'),
    ('207.136.128.000', 'US'),
    ('207.139.000.000', 'CA'),
    ('207.139.021.000', 'AG'),
    ('207.139.022.000', 'CA'),
    ('207.139.090.000', 'FR'),
    ('207.139.091.000', 'CA'),
    ('207.139.100.000', 'US'),
    ('207.139.101.000', 'CA'),
    ('207.140.000.000', 'US'),
    ('207.142.198.000', 'CA'),
    ('207.142.199.000', 'US'),
    ('207.148.000.000', 'CA'),
    ('207.148.192.000', 'US'),
    ('207.148.224.000', '--'),
    ('207.149.000.000', 'US'),
    ('207.153.000.000', 'CA'),
    ('207.153.064.000', 'US'),
    ('207.155.102.000', 'CA'),
    ('207.155.103.000', 'US'),
    ('207.161.000.000', 'CA'),
    ('207.162.128.000', 'US'),
    ('207.164.000.000', 'CA'),
    ('207.165.000.000', 'US'),
    ('207.167.000.000', 'CA'),
    ('207.167.032.000', 'US'),
    ('207.167.192.000', 'CA'),
    ('207.168.000.000', 'US'),
    ('207.168.122.000', 'AU'),
    ('207.168.124.000', 'US'),
    ('207.174.179.000', 'FR'),
    ('207.174.180.000', 'US'),
    ('207.174.226.000', '--'),
    ('207.174.227.000', 'US'),
    ('207.174.229.000', '--'),
    ('207.174.230.000', 'US'),
    ('207.175.140.000', 'MP'),
    ('207.175.142.000', 'US'),
    ('207.175.157.000', 'MP'),
    ('207.175.158.000', 'US'),
    ('207.175.200.000', 'MP'),
    ('207.175.201.000', 'GU'),
    ('207.175.202.000', 'US'),
    ('207.176.128.000', 'CA'),
    ('207.176.132.000', 'US'),
    ('207.176.133.000', 'CA'),
    ('207.176.235.000', 'US'),
    ('207.176.236.000', 'CA'),
    ('207.177.000.000', 'US'),
    ('207.179.014.000', 'CA'),
    ('207.179.015.000', 'US'),
    ('207.179.128.000', 'CA'),
    ('207.179.192.000', 'US'),
    ('207.181.064.000', 'CA'),
    ('207.181.128.000', 'US'),
    ('207.183.032.000', 'CA'),
    ('207.183.064.000', 'US'),
    ('207.188.064.000', 'CA'),
    ('207.188.096.000', '--'),
    ('207.188.128.000', 'US'),
    ('207.194.000.000', 'CA'),
    ('207.195.128.000', 'US'),
    ('207.196.081.000', 'JM'),
    ('207.196.082.000', 'US'),
    ('207.200.128.000', 'CA'),
    ('207.200.160.000', 'US'),
    ('207.200.176.000', '--'),
    ('207.200.192.000', 'US'),
    ('207.204.213.000', 'CA'),
    ('207.204.214.000', 'US'),
    ('207.209.000.000', 'GB'),
    ('207.209.001.000', 'DE'),
    ('207.209.003.000', 'TW'),
    ('207.209.004.000', 'GB'),
    ('207.209.005.000', 'NO'),
    ('207.209.006.000', 'BE'),
    ('207.209.007.000', 'AU'),
    ('207.209.008.000', 'DE'),
    ('207.209.009.000', 'CH'),
    ('207.209.010.000', 'US'),
    ('207.209.011.000', 'NO'),
    ('207.209.012.000', 'KR'),
    ('207.209.013.000', 'US'),
    ('207.209.014.000', 'CA'),
    ('207.209.016.000', 'US'),
    ('207.209.018.000', 'PT'),
    ('207.209.019.000', 'FR'),
    ('207.209.022.000', 'NZ'),
    ('207.209.023.000', 'US'),
    ('207.209.024.000', 'AU'),
    ('207.209.025.000', 'FR'),
    ('207.209.026.000', 'NL'),
    ('207.209.027.000', 'CL'),
    ('207.209.028.000', 'GB'),
    ('207.209.030.000', 'FR'),
    ('207.209.031.000', 'US'),
    ('207.209.036.000', 'IT'),
    ('207.209.037.000', 'US'),
    ('207.209.038.000', 'GB'),
    ('207.209.043.000', 'CH'),
    ('207.209.044.000', 'FI'),
    ('207.209.045.000', 'NL'),
    ('207.209.046.000', 'NO'),
    ('207.209.048.000', 'NL'),
    ('207.209.049.000', 'DE'),
    ('207.209.051.000', 'FR'),
    ('207.209.052.000', 'DE'),
    ('207.209.053.000', 'BE'),
    ('207.209.054.000', 'US'),
    ('207.209.055.000', 'AR'),
    ('207.209.056.000', 'DK'),
    ('207.209.057.000', 'ID'),
    ('207.209.058.000', 'PR'),
    ('207.209.059.000', 'DK'),
    ('207.209.060.000', 'NL'),
    ('207.209.061.000', 'NO'),
    ('207.209.062.000', 'US'),
    ('207.209.063.000', 'GB'),
    ('207.209.064.000', 'IE'),
    ('207.209.065.000', 'IT'),
    ('207.209.066.000', 'GB'),
    ('207.209.067.000', 'US'),
    ('207.209.068.000', 'IE'),
    ('207.209.069.000', 'US'),
    ('207.209.070.000', 'BR'),
    ('207.209.071.000', 'NO'),
    ('207.209.072.000', 'SE'),
    ('207.209.073.000', 'BR'),
    ('207.209.074.000', 'US'),
    ('207.209.075.000', 'BR'),
    ('207.209.077.000', 'US'),
    ('207.209.080.000', 'BE'),
    ('207.209.081.000', 'TR'),
    ('207.209.082.000', 'BE'),
    ('207.209.083.000', 'NZ'),
    ('207.209.084.000', 'US'),
    ('207.209.087.000', 'SG'),
    ('207.209.088.000', 'CN'),
    ('207.209.089.000', 'JP'),
    ('207.209.090.000', 'US'),
    ('207.209.091.000', 'AU'),
    ('207.209.092.000', 'BE'),
    ('207.209.093.000', 'US'),
    ('207.209.095.000', 'ES'),
    ('207.209.096.000', 'NL'),
    ('207.209.097.000', 'US'),
    ('207.209.099.000', 'MY'),
    ('207.209.100.000', 'US'),
    ('207.209.101.000', 'FI'),
    ('207.209.102.000', 'US'),
    ('207.209.104.000', 'JP'),
    ('207.209.105.000', 'US'),
    ('207.209.106.000', 'PH'),
    ('207.209.107.000', 'GB'),
    ('207.209.108.000', 'US'),
    ('207.209.109.000', 'IE'),
    ('207.209.110.000', 'US'),
    ('207.209.111.000', 'HK'),
    ('207.209.113.000', 'AU'),
    ('207.209.114.000', 'SG'),
    ('207.209.115.000', 'US'),
    ('207.209.116.000', 'SE'),
    ('207.209.117.000', 'NL'),
    ('207.209.118.000', 'US'),
    ('207.209.119.000', 'BR'),
    ('207.209.120.000', 'SG'),
    ('207.209.121.000', 'EC'),
    ('207.209.122.000', 'HK'),
    ('207.209.123.000', 'SG'),
    ('207.209.124.000', 'US'),
    ('207.209.125.000', 'DE'),
    ('207.209.126.000', 'US'),
    ('207.209.127.000', 'GB'),
    ('207.209.129.000', 'ES'),
    ('207.209.130.000', 'DE'),
    ('207.209.131.000', 'GB'),
    ('207.209.132.000', 'US'),
    ('207.209.133.000', 'FR'),
    ('207.209.134.000', 'BE'),
    ('207.209.135.000', 'PH'),
    ('207.209.136.000', 'US'),
    ('207.209.139.000', 'NO'),
    ('207.209.141.000', 'US'),
    ('207.209.144.000', 'CH'),
    ('207.209.145.000', 'AU'),
    ('207.209.146.000', 'NO'),
    ('207.209.147.000', 'ES'),
    ('207.209.148.000', 'BE'),
    ('207.209.149.000', 'FR'),
    ('207.209.150.000', 'SG'),
    ('207.209.151.000', 'BE'),
    ('207.209.152.000', 'CA'),
    ('207.209.153.000', 'US'),
    ('207.209.154.000', 'SE'),
    ('207.209.155.000', 'HK'),
    ('207.209.156.000', 'US'),
    ('207.209.157.000', 'NL'),
    ('207.209.158.000', 'US'),
    ('207.209.159.000', 'NL'),
    ('207.209.160.000', 'FI'),
    ('207.209.161.000', 'ES'),
    ('207.209.162.000', 'ZA'),
    ('207.209.163.000', 'GB'),
    ('207.209.164.000', 'MX'),
    ('207.209.165.000', 'DE'),
    ('207.209.166.000', 'JP'),
    ('207.209.167.000', 'DE'),
    ('207.209.168.000', 'US'),
    ('207.209.169.000', 'PH'),
    ('207.209.170.000', 'SG'),
    ('207.209.171.000', 'SE'),
    ('207.209.172.000', 'ES'),
    ('207.209.173.000', 'US'),
    ('207.209.174.000', 'SE'),
    ('207.209.175.000', 'NO'),
    ('207.209.176.000', 'NL'),
    ('207.209.177.000', 'FI'),
    ('207.209.178.000', 'IL'),
    ('207.209.179.000', 'CH'),
    ('207.209.180.000', 'US'),
    ('207.209.181.000', 'JP'),
    ('207.209.182.000', 'US'),
    ('207.209.183.000', 'BE'),
    ('207.209.184.000', 'BW'),
    ('207.209.185.000', 'ZA'),
    ('207.209.186.000', 'US'),
    ('207.209.187.000', 'NO'),
    ('207.209.188.000', 'PT'),
    ('207.209.190.000', 'US'),
    ('207.209.191.000', 'CL'),
    ('207.209.192.000', 'SE'),
    ('207.209.193.000', 'JP'),
    ('207.209.199.000', 'ID'),
    ('207.209.200.000', 'JP'),
    ('207.209.202.000', 'US'),
    ('207.209.203.000', 'JP'),
    ('207.209.204.000', 'IT'),
    ('207.209.205.000', 'GB'),
    ('207.209.206.000', 'US'),
    ('207.209.208.000', 'HK'),
    ('207.209.209.000', 'US'),
    ('207.209.210.000', 'KR'),
    ('207.209.211.000', 'CH'),
    ('207.209.212.000', 'DK'),
    ('207.209.213.000', 'FR'),
    ('207.209.214.000', 'ES'),
    ('207.209.215.000', 'IL'),
    ('207.209.216.000', 'ES'),
    ('207.209.217.000', 'NL'),
    ('207.209.218.000', 'TW'),
    ('207.209.219.000', 'DE'),
    ('207.209.220.000', 'US'),
    ('207.209.221.000', 'BE'),
    ('207.209.223.000', 'SE'),
    ('207.209.225.000', 'FR'),
    ('207.209.226.000', 'PH'),
    ('207.209.227.000', 'DK'),
    ('207.209.228.000', 'BE'),
    ('207.209.229.000', 'SG'),
    ('207.209.230.000', 'US'),
    ('207.209.232.000', 'BE'),
    ('207.209.233.000', 'GB'),
    ('207.209.234.000', 'US'),
    ('207.209.240.000', 'BR'),
    ('207.209.241.000', 'PT'),
    ('207.209.242.000', 'DK'),
    ('207.209.243.000', 'US'),
    ('207.209.255.000', 'JP'),
    ('207.210.000.000', 'CA'),
    ('207.211.000.000', 'US'),
    ('207.216.000.000', 'CA'),
    ('207.217.000.000', 'US'),
    ('207.219.000.000', 'CA'),
    ('207.219.053.000', 'US'),
    ('207.219.054.000', 'CA'),
    ('207.219.142.000', 'US'),
    ('207.219.143.000', 'CA'),
    ('207.219.194.000', 'US'),
    ('207.219.196.000', 'CA'),
    ('207.220.000.000', 'US'),
    ('207.221.253.000', 'FR'),
    ('207.221.254.000', 'US'),
    ('207.222.044.000', 'GU'),
    ('207.222.048.000', 'US'),
    ('207.223.217.000', 'CA'),
    ('207.223.218.000', 'US'),
    ('207.227.024.000', 'CA'),
    ('207.227.032.000', 'US'),
    ('207.228.064.000', 'CA'),
    ('207.228.128.000', 'BM'),
    ('207.228.192.000', 'US'),
    ('207.229.000.000', 'CA'),
    ('207.229.064.000', 'US'),
    ('207.230.050.000', 'KW'),
    ('207.230.051.000', 'US'),
    ('207.230.224.000', 'CA'),
    ('207.231.000.000', 'US'),
    ('207.231.192.000', 'CA'),
    ('207.232.000.000', 'IL'),
    ('207.232.020.000', 'US'),
    ('207.232.023.000', 'IL'),
    ('207.232.024.000', 'US'),
    ('207.232.026.000', 'IL'),
    ('207.232.027.000', 'US'),
    ('207.232.096.000', 'CA'),
    ('207.232.128.000', 'US'),
    ('207.234.133.000', 'EC'),
    ('207.234.135.000', 'US'),
    ('207.234.159.000', 'EC'),
    ('207.234.160.000', 'US'),
    ('207.234.183.000', 'EC'),
    ('207.234.184.000', 'US'),
    ('207.234.196.000', 'EC'),
    ('207.234.197.000', 'US'),
    ('207.234.228.000', 'EC'),
    ('207.234.229.000', 'US'),
    ('207.234.241.000', 'EC'),
    ('207.234.242.000', 'US'),
    ('207.236.000.000', 'CA'),
    ('207.236.043.000', 'US'),
    ('207.236.044.000', 'CA'),
    ('207.237.000.000', 'US'),
    ('207.240.014.000', 'AU'),
    ('207.240.015.000', 'US'),
    ('207.241.144.000', '--'),
    ('207.241.160.000', 'US'),
    ('207.241.168.000', 'AL'),
    ('207.241.169.000', 'US'),
    ('207.241.170.000', 'BA'),
    ('207.241.173.000', 'RO'),
    ('207.241.174.000', 'AL'),
    ('207.241.175.000', 'JM'),
    ('207.241.177.000', 'US'),
    ('207.243.058.000', 'EC'),
    ('207.243.060.000', 'US'),
    ('207.243.146.000', 'EC'),
    ('207.243.147.000', 'US'),
    ('207.244.107.000', 'CA'),
    ('207.244.108.000', 'US'),
    ('207.244.136.000', '--'),
    ('207.244.192.000', 'US'),
    ('207.244.218.000', 'VI'),
    ('207.244.220.000', 'US'),
    ('207.245.000.000', 'CA'),
    ('207.245.058.000', 'US'),
    ('207.245.059.000', 'CA'),
    ('207.245.064.000', 'US'),
    ('207.245.192.000', 'CA'),
    ('207.246.000.000', 'US'),
    ('207.246.148.000', 'CA'),
    ('207.246.149.000', 'US'),
    ('207.248.000.000', 'MX'),
    ('207.250.000.000', 'US'),
    ('207.252.000.000', 'IT'),
    ('207.252.001.000', 'US'),
    ('207.253.000.000', 'CA'),
    ('207.254.000.000', 'US'),
    ('207.255.000.000', '--'),
    ('208.000.000.000', 'US'),
    ('208.000.224.000', 'AG'),
    ('208.000.232.000', 'US'),
    ('208.001.048.000', 'PH'),
    ('208.001.056.000', 'US'),
    ('208.001.190.000', 'UG'),
    ('208.001.191.000', 'US'),
    ('208.006.072.000', 'CA'),
    ('208.006.080.000', 'US'),
    ('208.009.005.000', 'JM'),
    ('208.009.006.000', 'US'),
    ('208.009.120.000', 'JM'),
    ('208.009.128.000', 'US'),
    ('208.014.231.000', 'KN'),
    ('208.014.232.000', 'US'),
    ('208.014.236.000', 'KN'),
    ('208.014.237.000', 'US'),
    ('208.027.182.000', 'VI'),
    ('208.027.188.000', 'US'),
    ('208.028.048.000', 'CA'),
    ('208.028.064.000', 'US'),
    ('208.030.096.000', 'VI'),
    ('208.030.112.000', 'US'),
    ('208.031.002.000', 'MA'),
    ('208.031.003.000', 'US'),
    ('208.038.000.000', 'CA'),
    ('208.038.064.000', 'US'),
    ('208.038.096.000', '--'),
    ('208.038.128.000', 'US'),
    ('208.038.192.000', '--'),
    ('208.039.000.000', 'US'),
    ('208.045.234.000', 'PA'),
    ('208.045.240.000', 'US'),
    ('208.052.008.000', 'HT'),
    ('208.052.012.000', 'US'),
    ('208.052.017.000', 'BO'),
    ('208.052.018.000', 'US'),
    ('208.052.019.000', 'BO'),
    ('208.052.020.000', 'US'),
    ('208.052.021.000', 'BO'),
    ('208.052.022.000', 'HT'),
    ('208.052.038.000', 'US'),
    ('208.052.050.000', 'PY'),
    ('208.052.054.000', 'US'),
    ('208.052.068.000', 'JM'),
    ('208.052.078.000', 'US'),
    ('208.052.080.000', 'BO'),
    ('208.052.086.000', 'US'),
    ('208.052.088.000', 'BO'),
    ('208.052.092.000', 'NA'),
    ('208.052.093.000', 'US'),
    ('208.052.192.000', '--'),
    ('208.053.000.000', 'US'),
    ('208.064.000.000', '--'),
    ('208.128.000.000', 'US'),
    ('208.130.114.000', 'GY'),
    ('208.130.118.000', 'US'),
    ('208.131.032.000', 'JM'),
    ('208.131.034.000', 'US'),
    ('208.132.241.000', 'RW'),
    ('208.132.242.000', 'US'),
    ('208.133.200.000', 'CR'),
    ('208.133.204.000', 'US'),
    ('208.133.206.000', 'CR'),
    ('208.133.207.000', 'US'),
    ('208.134.038.000', 'RW'),
    ('208.134.039.000', 'US'),
    ('208.135.019.000', 'CL'),
    ('208.135.020.000', 'US'),
    ('208.135.022.000', 'CL'),
    ('208.135.024.000', 'US'),
    ('208.136.052.000', 'NL'),
    ('208.136.056.000', 'US'),
    ('208.136.062.000', 'CA'),
    ('208.136.064.000', 'US'),
    ('208.136.102.000', 'WS'),
    ('208.136.103.000', 'US'),
    ('208.138.016.000', 'JM'),
    ('208.138.048.000', 'US'),
    ('208.138.168.000', 'PA'),
    ('208.138.176.000', 'US'),
    ('208.138.216.000', 'PR'),
    ('208.138.220.000', 'US'),
    ('208.138.222.000', 'PR'),
    ('208.138.223.000', 'US'),
    ('208.139.096.000', 'HK'),
    ('208.139.128.000', 'US'),
    ('208.139.164.000', 'PF'),
    ('208.139.165.000', 'US'),
    ('208.141.102.000', 'PK'),
    ('208.141.103.000', 'US'),
    ('208.142.136.000', 'PH'),
    ('208.142.152.000', 'US'),
    ('208.142.160.000', 'PH'),
    ('208.142.168.000', 'US'),
    ('208.143.230.000', 'AN'),
    ('208.143.231.000', 'US'),
    ('208.144.188.000', 'EC'),
    ('208.144.192.000', 'US'),
    ('208.144.224.000', 'BZ'),
    ('208.144.225.000', 'US'),
    ('208.144.228.000', 'BZ'),
    ('208.144.229.000', 'US'),
    ('208.144.230.000', 'ML'),
    ('208.144.231.000', 'US'),
    ('208.147.000.000', 'TH'),
    ('208.147.008.000', 'US'),
    ('208.147.018.000', 'WS'),
    ('208.147.019.000', 'US'),
    ('208.148.044.000', 'GA'),
    ('208.148.049.000', 'US'),
    ('208.148.168.000', 'MW'),
    ('208.148.170.000', 'US'),
    ('208.150.128.000', 'PH'),
    ('208.150.144.000', 'US'),
    ('208.151.064.000', 'HK'),
    ('208.151.096.000', 'US'),
    ('208.153.064.000', 'MZ'),
    ('208.153.065.000', 'US'),
    ('208.153.068.000', 'TZ'),
    ('208.153.070.000', 'MG'),
    ('208.153.072.000', 'US'),
    ('208.153.096.000', 'GY'),
    ('208.153.100.000', 'US'),
    ('208.155.152.000', 'PH'),
    ('208.155.156.000', 'US'),
    ('208.157.144.000', 'KY'),
    ('208.157.152.000', 'TC'),
    ('208.157.156.000', 'US'),
    ('208.158.000.000', 'AI'),
    ('208.158.001.000', 'AG'),
    ('208.158.003.000', 'KN'),
    ('208.158.004.000', 'AR'),
    ('208.158.005.000', 'AG'),
    ('208.158.007.000', 'AR'),
    ('208.158.009.000', 'AG'),
    ('208.158.012.000', 'KN'),
    ('208.158.013.000', 'LC'),
    ('208.158.014.000', 'KN'),
    ('208.158.015.000', 'LC'),
    ('208.158.016.000', 'US'),
    ('208.159.007.000', 'EG'),
    ('208.159.008.000', 'US'),
    ('208.159.058.000', 'HU'),
    ('208.159.059.000', 'US'),
    ('208.159.176.000', 'SE'),
    ('208.159.177.000', 'GB'),
    ('208.159.178.000', 'US'),
    ('208.159.224.000', 'GB'),
    ('208.159.228.000', 'SD'),
    ('208.159.229.000', 'GB'),
    ('208.159.237.000', 'NL'),
    ('208.159.238.000', 'US'),
    ('208.159.239.000', 'BV'),
    ('208.159.240.000', 'GB'),
    ('208.159.245.000', 'AN'),
    ('208.159.246.000', 'US'),
    ('208.159.248.000', 'IT'),
    ('208.159.249.000', 'GB'),
    ('208.160.000.000', 'US'),
    ('208.160.072.000', 'PH'),
    ('208.160.078.000', 'US'),
    ('208.160.128.000', 'EG'),
    ('208.160.136.000', 'US'),
    ('208.160.144.000', 'CM'),
    ('208.160.148.000', 'US'),
    ('208.160.224.000', 'PH'),
    ('208.161.000.000', 'US'),
    ('208.161.224.000', 'GB'),
    ('208.161.225.000', 'IT'),
    ('208.161.226.000', 'AT'),
    ('208.161.227.000', 'GB'),
    ('208.161.232.000', 'NL'),
    ('208.161.233.000', 'US'),
    ('208.161.234.000', 'GB'),
    ('208.161.236.000', 'NL'),
    ('208.161.237.000', 'GB'),
    ('208.161.239.000', 'NL'),
    ('208.161.240.000', 'IE'),
    ('208.161.241.000', 'GB'),
    ('208.161.242.000', 'IE'),
    ('208.161.243.000', 'GB'),
    ('208.161.244.000', 'US'),
    ('208.161.248.000', 'DE'),
    ('208.161.249.000', 'GB'),
    ('208.162.000.000', 'PH'),
    ('208.162.032.000', 'US'),
    ('208.163.032.000', 'JM'),
    ('208.163.064.000', 'US'),
    ('208.163.096.000', 'GB'),
    ('208.163.100.000', 'US'),
    ('208.163.102.000', 'FR'),
    ('208.163.103.000', 'GB'),
    ('208.163.105.000', 'BE'),
    ('208.163.106.000', 'GB'),
    ('208.163.107.000', 'BE'),
    ('208.163.108.000', 'GB'),
    ('208.163.109.000', 'BE'),
    ('208.163.110.000', 'GB'),
    ('208.163.111.000', 'BE'),
    ('208.163.112.000', 'ES'),
    ('208.163.113.000', 'GB'),
    ('208.163.115.000', 'ES'),
    ('208.163.120.000', 'US'),
    ('208.163.121.000', 'ES'),
    ('208.163.122.000', 'GB'),
    ('208.163.123.000', 'ES'),
    ('208.163.124.000', 'GB'),
    ('208.163.128.000', 'US'),
    ('208.163.192.000', 'GB'),
    ('208.163.201.000', 'DE'),
    ('208.163.202.000', 'GB'),
    ('208.163.208.000', 'FR'),
    ('208.163.209.000', 'GB'),
    ('208.163.217.000', 'DE'),
    ('208.163.218.000', 'GB'),
    ('208.163.228.000', 'US'),
    ('208.163.229.000', 'GB'),
    ('208.163.231.000', 'US'),
    ('208.163.232.000', 'GB'),
    ('208.163.234.000', 'ES'),
    ('208.163.235.000', 'GB'),
    ('208.163.237.000', 'ES'),
    ('208.163.239.000', 'GB'),
    ('208.163.240.000', 'IT'),
    ('208.163.241.000', 'GB'),
    ('208.163.245.000', 'IT'),
    ('208.163.246.000', 'GB'),
    ('208.164.002.000', 'IT'),
    ('208.164.003.000', 'GB'),
    ('208.164.004.000', 'IT'),
    ('208.164.006.000', 'GB'),
    ('208.164.008.000', 'AU'),
    ('208.164.009.000', 'NL'),
    ('208.164.010.000', 'GB'),
    ('208.164.011.000', 'US'),
    ('208.164.012.000', 'GB'),
    ('208.164.016.000', 'US'),
    ('208.164.017.000', 'GB'),
    ('208.164.018.000', 'PH'),
    ('208.164.019.000', 'GB'),
    ('208.164.025.000', 'ES'),
    ('208.164.026.000', 'GB'),
    ('208.164.032.000', 'US'),
    ('208.164.176.000', 'BJ'),
    ('208.164.182.000', 'US'),
    ('208.164.192.000', 'MM'),
    ('208.164.200.000', 'US'),
    ('208.165.048.000', 'CR'),
    ('208.165.064.000', 'US'),
    ('208.166.032.000', 'PA'),
    ('208.166.048.000', 'US'),
    ('208.167.032.000', 'MZ'),
    ('208.167.036.000', 'US'),
    ('208.167.192.000', 'PA'),
    ('208.167.208.000', 'US'),
    ('208.167.224.000', 'HK'),
    ('208.168.000.000', 'US'),
    ('208.168.066.000', 'EG'),
    ('208.168.068.000', 'US'),
    ('208.168.072.000', 'CL'),
    ('208.168.074.000', 'US'),
    ('208.168.142.000', 'CA'),
    ('208.168.144.000', 'US'),
    ('208.168.211.000', 'EC'),
    ('208.168.213.000', 'HT'),
    ('208.168.214.000', 'EC'),
    ('208.168.215.000', 'HT'),
    ('208.168.216.000', 'US'),
    ('208.169.144.000', 'PH'),
    ('208.169.160.000', 'US'),
    ('208.169.228.000', 'GY'),
    ('208.169.232.000', 'US'),
    ('208.169.244.000', 'EG'),
    ('208.169.248.000', 'US'),
    ('208.181.000.000', 'CA'),
    ('208.182.000.000', 'US'),
    ('208.194.251.000', 'PK'),
    ('208.194.252.000', 'US'),
    ('208.195.116.000', 'MX'),
    ('208.195.120.000', 'US'),
    ('208.196.050.000', 'LK'),
    ('208.196.052.000', 'US'),
    ('208.196.137.000', 'CA'),
    ('208.196.138.000', 'US'),
    ('208.196.155.000', 'BS'),
    ('208.196.156.000', 'US'),
    ('208.196.247.000', 'BS'),
    ('208.196.248.000', 'US'),
    ('208.197.136.000', 'CL'),
    ('208.197.140.000', 'US'),
    ('208.198.180.000', 'MC'),
    ('208.198.181.000', 'US'),
    ('208.204.110.000', 'CA'),
    ('208.204.111.000', 'US'),
    ('208.206.212.000', 'NL'),
    ('208.206.213.000', 'US'),
    ('208.207.002.000', 'CA'),
    ('208.207.003.000', 'US'),
    ('208.207.092.000', 'PK'),
    ('208.207.094.000', 'US'),
    ('208.208.120.000', 'KE'),
    ('208.208.122.000', 'US'),
    ('208.209.045.000', 'PY'),
    ('208.209.046.000', 'US'),
    ('208.209.110.000', 'CH'),
    ('208.209.111.000', 'US'),
    ('208.210.122.000', 'AZ'),
    ('208.210.123.000', 'US'),
    ('208.210.216.000', 'DE'),
    ('208.210.217.000', 'US'),
    ('208.214.208.000', 'CO'),
    ('208.214.216.000', 'US'),
    ('208.217.032.000', 'CO'),
    ('208.217.048.000', 'US'),
    ('208.218.061.000', 'CO'),
    ('208.218.062.000', 'US'),
    ('208.218.085.000', 'PH'),
    ('208.218.086.000', 'US'),
    ('208.218.168.000', 'AE'),
    ('208.218.176.000', 'US'),
    ('208.220.028.000', 'LI'),
    ('208.220.030.000', 'US'),
    ('208.220.224.000', 'AZ'),
    ('208.220.232.000', 'US'),
    ('208.221.031.000', 'CI'),
    ('208.221.032.000', 'US'),
    ('208.221.129.000', 'CO'),
    ('208.221.131.000', 'US'),
    ('208.221.140.000', 'CO'),
    ('208.221.141.000', 'US'),
    ('208.221.192.000', 'EC'),
    ('208.221.196.000', 'US'),
    ('208.221.248.000', 'CA'),
    ('208.221.249.000', 'US'),
    ('208.222.000.000', 'AE'),
    ('208.222.032.000', 'US'),
    ('208.222.054.000', 'RO'),
    ('208.222.055.000', 'US'),
    ('208.224.122.000', 'TG'),
    ('208.224.123.000', 'US'),
    ('208.224.176.000', 'ZM'),
    ('208.224.192.000', 'US'),
    ('208.232.094.000', 'PK'),
    ('208.232.096.000', 'AR'),
    ('208.232.112.000', 'US'),
    ('208.232.224.000', 'PH'),
    ('208.232.229.000', 'US'),
    ('208.233.006.000', 'BD'),
    ('208.233.008.000', 'US'),
    ('208.235.196.000', 'EC'),
    ('208.235.200.000', 'US'),
    ('208.235.224.000', 'PH'),
    ('208.235.232.000', 'US'),
    ('208.237.032.000', 'JO'),
    ('208.237.033.000', 'US'),
    ('208.237.107.000', 'CA'),
    ('208.237.108.000', 'US'),
    ('208.237.252.000', 'CO'),
    ('208.237.254.000', 'US'),
    ('208.238.046.000', 'JM'),
    ('208.238.047.000', 'HT'),
    ('208.238.048.000', 'US'),
    ('208.240.106.000', 'MX'),
    ('208.240.109.000', 'US'),
    ('208.240.136.000', 'PK'),
    ('208.240.140.000', 'US'),
    ('208.240.211.000', 'CA'),
    ('208.240.212.000', 'US'),
    ('208.241.076.000', 'GU'),
    ('208.241.077.000', 'US'),
    ('208.241.221.000', 'RO'),
    ('208.241.222.000', 'US'),
    ('208.242.128.000', 'PK'),
    ('208.242.132.000', 'US'),
    ('208.243.226.000', 'NG'),
    ('208.243.229.000', 'US'),
    ('208.244.040.000', 'JM'),
    ('208.244.042.000', 'US'),
    ('208.244.071.000', 'PK'),
    ('208.244.072.000', 'US'),
    ('208.245.197.000', 'UY'),
    ('208.245.198.000', 'US'),
    ('208.246.026.000', '--'),
    ('208.246.027.000', 'TT'),
    ('208.246.028.000', 'US'),
    ('208.246.140.000', 'BS'),
    ('208.246.144.000', 'US'),
    ('208.247.024.000', 'CO'),
    ('208.247.027.000', 'US'),
    ('208.249.146.000', 'PK'),
    ('208.249.148.000', 'US'),
    ('208.249.249.000', 'PA'),
    ('208.250.000.000', 'US'),
    ('208.251.139.000', 'PY'),
    ('208.251.140.000', 'US'),
    ('208.253.158.000', 'DK'),
    ('208.253.159.000', 'US'),
    ('208.253.234.000', 'KR'),
    ('208.253.235.000', 'US'),
    ('209.005.000.000', 'CA'),
    ('209.006.000.000', 'US'),
    ('209.013.000.000', 'AR'),
    ('209.014.000.000', 'US'),
    ('209.017.128.000', 'CA'),
    ('209.017.183.000', 'US'),
    ('209.017.184.000', 'CA'),
    ('209.017.192.000', 'US'),
    ('209.020.000.000', 'CA'),
    ('209.020.064.000', 'US'),
    ('209.020.236.000', 'BG'),
    ('209.020.237.000', 'US'),
    ('209.022.169.000', 'JP'),
    ('209.022.171.000', 'US'),
    ('209.025.035.000', 'BM'),
    ('209.025.040.000', 'SV'),
    ('209.025.044.000', 'US'),
    ('209.025.081.000', 'BM'),
    ('209.025.082.000', 'US'),
    ('209.025.085.000', 'PH'),
    ('209.025.086.000', 'US'),
    ('209.025.129.000', 'RU'),
    ('209.025.130.000', 'US'),
    ('209.025.132.000', 'AU'),
    ('209.025.133.000', 'US'),
    ('209.025.134.000', 'CA'),
    ('209.025.135.000', 'US'),
    ('209.025.136.000', 'RU'),
    ('209.025.137.000', 'US'),
    ('209.025.138.000', 'CA'),
    ('209.025.139.000', 'US'),
    ('209.025.148.000', 'ID'),
    ('209.025.149.000', 'MY'),
    ('209.025.150.000', 'US'),
    ('209.025.153.000', 'NL'),
    ('209.025.154.000', 'US'),
    ('209.025.159.000', 'DK'),
    ('209.025.160.000', 'US'),
    ('209.025.161.000', 'PR'),
    ('209.025.162.000', 'US'),
    ('209.025.164.000', 'AU'),
    ('209.025.165.000', 'US'),
    ('209.025.166.000', 'TW'),
    ('209.025.167.000', 'US'),
    ('209.025.168.000', 'CA'),
    ('209.025.169.000', 'US'),
    ('209.025.170.000', 'ES'),
    ('209.025.171.000', 'PR'),
    ('209.025.172.000', 'CA'),
    ('209.025.174.000', 'US'),
    ('209.025.176.000', 'MY'),
    ('209.025.177.000', 'US'),
    ('209.025.183.000', 'RU'),
    ('209.025.184.000', 'US'),
    ('209.025.191.000', 'PR'),
    ('209.025.192.000', 'US'),
    ('209.025.204.000', 'RU'),
    ('209.025.205.000', 'US'),
    ('209.025.207.000', 'DE'),
    ('209.025.209.000', 'US'),
    ('209.025.212.000', 'RU'),
    ('209.025.213.000', 'CA'),
    ('209.025.214.000', 'US'),
    ('209.025.215.000', 'PR'),
    ('209.025.216.000', 'US'),
    ('209.025.217.000', 'GB'),
    ('209.025.218.000', 'US'),
    ('209.025.220.000', 'AU'),
    ('209.025.221.000', 'BG'),
    ('209.025.222.000', 'US'),
    ('209.025.234.000', 'PR'),
    ('209.025.235.000', 'US'),
    ('209.027.052.000', 'KY'),
    ('209.027.056.000', 'US'),
    ('209.027.058.000', 'BM'),
    ('209.027.059.000', 'US'),
    ('209.027.060.000', 'KY'),
    ('209.027.065.000', 'BM'),
    ('209.027.066.000', 'US'),
    ('209.027.090.000', 'EC'),
    ('209.027.094.000', 'US'),
    ('209.027.102.000', 'PH'),
    ('209.027.103.000', 'US'),
    ('209.027.140.000', 'BM'),
    ('209.027.144.000', 'US'),
    ('209.028.001.000', 'MX'),
    ('209.028.002.000', 'US'),
    ('209.028.008.000', 'IT'),
    ('209.028.009.000', 'ZA'),
    ('209.028.010.000', 'US'),
    ('209.028.015.000', 'MX'),
    ('209.028.016.000', 'US'),
    ('209.028.021.000', 'AU'),
    ('209.028.022.000', 'US'),
    ('209.028.023.000', 'VE'),
    ('209.028.024.000', 'US'),
    ('209.028.025.000', 'CO'),
    ('209.028.026.000', 'JP'),
    ('209.028.027.000', 'TH'),
    ('209.028.028.000', 'JP'),
    ('209.028.029.000', 'TW'),
    ('209.028.030.000', 'JP'),
    ('209.028.031.000', 'KR'),
    ('209.028.032.000', 'PH'),
    ('209.028.033.000', 'NZ'),
    ('209.028.034.000', 'US'),
    ('209.028.035.000', 'HK'),
    ('209.028.036.000', 'US'),
    ('209.028.037.000', 'AU'),
    ('209.028.038.000', 'TH'),
    ('209.028.039.000', 'HK'),
    ('209.028.040.000', 'US'),
    ('209.028.041.000', 'AU'),
    ('209.028.042.000', 'MY'),
    ('209.028.043.000', 'SG'),
    ('209.028.044.000', 'AU'),
    ('209.028.045.000', 'JP'),
    ('209.028.046.000', 'ES'),
    ('209.028.047.000', 'US'),
    ('209.028.050.000', 'NL'),
    ('209.028.051.000', 'SE'),
    ('209.028.052.000', 'HK'),
    ('209.028.053.000', 'US'),
    ('209.028.054.000', 'TH'),
    ('209.028.055.000', 'HK'),
    ('209.028.056.000', 'US'),
    ('209.028.058.000', 'MY'),
    ('209.028.059.000', 'JP'),
    ('209.028.060.000', 'US'),
    ('209.028.061.000', 'BR'),
    ('209.028.062.000', 'AU'),
    ('209.028.063.000', 'BR'),
    ('209.028.064.000', 'CA'),
    ('209.028.065.000', 'US'),
    ('209.028.071.000', 'GB'),
    ('209.028.074.000', 'CH'),
    ('209.028.075.000', 'US'),
    ('209.028.077.000', 'DE'),
    ('209.028.082.000', 'US'),
    ('209.028.088.000', 'GB'),
    ('209.028.089.000', 'US'),
    ('209.028.090.000', 'GB'),
    ('209.028.092.000', 'FR'),
    ('209.028.093.000', 'CH'),
    ('209.028.094.000', 'GB'),
    ('209.028.095.000', 'IT'),
    ('209.028.096.000', 'CH'),
    ('209.028.097.000', 'US'),
    ('209.028.098.000', 'DE'),
    ('209.028.099.000', 'DK'),
    ('209.028.100.000', 'ES'),
    ('209.028.101.000', 'BE'),
    ('209.028.102.000', 'GB'),
    ('209.028.103.000', 'US'),
    ('209.028.104.000', 'SE'),
    ('209.028.105.000', 'DE'),
    ('209.028.106.000', 'US'),
    ('209.028.107.000', 'FR'),
    ('209.028.108.000', 'US'),
    ('209.028.112.000', 'GB'),
    ('209.028.113.000', 'DE'),
    ('209.028.114.000', 'SG'),
    ('209.028.115.000', 'BE'),
    ('209.028.116.000', 'US'),
    ('209.028.118.000', 'BE'),
    ('209.028.119.000', 'DE'),
    ('209.028.120.000', 'US'),
    ('209.028.122.000', 'DE'),
    ('209.028.123.000', 'IR'),
    ('209.028.124.000', 'US'),
    ('209.028.125.000', 'NL'),
    ('209.028.126.000', 'US'),
    ('209.028.130.000', 'EC'),
    ('209.028.131.000', 'US'),
    ('209.028.132.000', 'CH'),
    ('209.028.133.000', 'US'),
    ('209.028.134.000', 'AR'),
    ('209.028.135.000', 'US'),
    ('209.028.140.000', 'BE'),
    ('209.028.141.000', 'SE'),
    ('209.028.146.000', 'DE'),
    ('209.028.147.000', 'BE'),
    ('209.028.148.000', 'NL'),
    ('209.028.149.000', 'IE'),
    ('209.028.151.000', 'US'),
    ('209.028.152.000', 'NL'),
    ('209.028.153.000', 'CH'),
    ('209.028.154.000', 'ES'),
    ('209.028.155.000', 'DE'),
    ('209.028.157.000', 'SE'),
    ('209.028.158.000', 'DK'),
    ('209.028.159.000', 'GB'),
    ('209.028.161.000', 'IT'),
    ('209.028.162.000', 'DK'),
    ('209.028.163.000', 'US'),
    ('209.028.164.000', 'NO'),
    ('209.028.165.000', 'US'),
    ('209.028.166.000', 'FR'),
    ('209.028.167.000', 'US'),
    ('209.028.168.000', 'PT'),
    ('209.028.169.000', 'GB'),
    ('209.028.170.000', 'RU'),
    ('209.028.171.000', 'SE'),
    ('209.028.172.000', 'ZA'),
    ('209.028.173.000', 'DE'),
    ('209.028.174.000', 'IT'),
    ('209.028.175.000', 'FI'),
    ('209.028.177.000', 'LU'),
    ('209.028.178.000', 'IT'),
    ('209.028.179.000', 'IL'),
    ('209.028.181.000', 'RU'),
    ('209.028.182.000', 'CH'),
    ('209.028.183.000', 'SE'),
    ('209.028.184.000', 'PT'),
    ('209.028.185.000', 'DE'),
    ('209.028.186.000', 'BE'),
    ('209.028.190.000', 'NL'),
    ('209.028.191.000', 'US'),
    ('209.028.192.000', 'GB'),
    ('209.028.193.000', 'FI'),
    ('209.028.194.000', 'NO'),
    ('209.028.195.000', 'DE'),
    ('209.028.196.000', 'NO'),
    ('209.028.197.000', 'DE'),
    ('209.028.198.000', 'FI'),
    ('209.028.199.000', 'IT'),
    ('209.028.200.000', 'CH'),
    ('209.028.201.000', 'NO'),
    ('209.028.202.000', 'GB'),
    ('209.028.203.000', 'DE'),
    ('209.028.204.000', 'GR'),
    ('209.028.205.000', 'ZA'),
    ('209.028.206.000', 'SE'),
    ('209.028.208.000', 'GB'),
    ('209.028.209.000', 'ZA'),
    ('209.028.210.000', 'IT'),
    ('209.028.211.000', 'ES'),
    ('209.028.213.000', 'IE'),
    ('209.028.214.000', 'NE'),
    ('209.028.216.000', 'BE'),
    ('209.028.217.000', 'IL'),
    ('209.028.220.000', 'NL'),
    ('209.028.221.000', 'FR'),
    ('209.028.222.000', 'SE'),
    ('209.028.224.000', 'GB'),
    ('209.028.227.000', 'BE'),
    ('209.028.228.000', 'FR'),
    ('209.028.229.000', 'IT'),
    ('209.028.230.000', 'GB'),
    ('209.028.231.000', 'GR'),
    ('209.028.232.000', 'IE'),
    ('209.028.233.000', 'NO'),
    ('209.028.234.000', 'GB'),
    ('209.028.235.000', 'CH'),
    ('209.028.237.000', 'GB'),
    ('209.028.239.000', 'DE'),
    ('209.028.240.000', 'AU'),
    ('209.028.241.000', 'SG'),
    ('209.028.242.000', 'MY'),
    ('209.028.243.000', 'AU'),
    ('209.028.244.000', 'JP'),
    ('209.028.246.000', 'SG'),
    ('209.028.247.000', 'HK'),
    ('209.028.248.000', 'AU'),
    ('209.028.249.000', 'JP'),
    ('209.028.250.000', 'PH'),
    ('209.028.252.000', 'KR'),
    ('209.028.253.000', 'JP'),
    ('209.028.254.000', 'HK'),
    ('209.028.255.000', 'KR'),
    ('209.029.000.000', 'CA'),
    ('209.030.000.000', 'US'),
    ('209.035.121.000', 'CA'),
    ('209.035.122.000', 'US'),
    ('209.037.084.000', 'CO'),
    ('209.037.085.000', 'SV'),
    ('209.037.086.000', 'EC'),
    ('209.037.087.000', 'US'),
    ('209.039.118.000', 'GH'),
    ('209.039.119.000', 'SA'),
    ('209.039.120.000', 'US'),
    ('209.041.128.000', 'CA'),
    ('209.041.160.000', 'US'),
    ('209.042.096.000', 'CA'),
    ('209.042.128.000', 'US'),
    ('209.045.000.000', 'PE'),
    ('209.045.128.000', 'US'),
    ('209.047.000.000', 'CA'),
    ('209.047.044.000', 'US'),
    ('209.047.045.000', 'CA'),
    ('209.047.157.000', 'US'),
    ('209.047.158.000', 'CA'),
    ('209.047.164.000', 'US'),
    ('209.047.165.000', 'CA'),
    ('209.047.204.000', 'US'),
    ('209.047.205.000', 'CA'),
    ('209.047.232.000', 'US'),
    ('209.047.233.000', 'CA'),
    ('209.048.000.000', 'US'),
    ('209.050.064.000', 'CA'),
    ('209.050.096.000', 'US'),
    ('209.050.235.000', '--'),
    ('209.050.236.000', 'US'),
    ('209.050.237.000', '--'),
    ('209.050.238.000', 'US'),
    ('209.050.239.000', '--'),
    ('209.050.240.000', 'US'),
    ('209.052.000.000', 'CA'),
    ('209.052.169.000', 'US'),
    ('209.052.170.000', 'CA'),
    ('209.054.000.000', 'US'),
    ('209.054.168.000', 'AU'),
    ('209.054.172.000', 'US'),
    ('209.054.176.000', 'CA'),
    ('209.054.178.000', 'US'),
    ('209.058.004.000', 'CA'),
    ('209.058.005.000', 'US'),
    ('209.058.008.000', 'PY'),
    ('209.058.010.000', 'LY'),
    ('209.058.011.000', 'US'),
    ('209.058.012.000', 'OM'),
    ('209.058.013.000', 'US'),
    ('209.058.014.000', 'CA'),
    ('209.058.015.000', 'LK'),
    ('209.058.016.000', 'TC'),
    ('209.058.017.000', 'US'),
    ('209.058.018.000', 'PY'),
    ('209.058.019.000', 'CO'),
    ('209.058.020.000', 'AN'),
    ('209.058.021.000', 'US'),
    ('209.058.022.000', 'AN'),
    ('209.058.024.000', 'BD'),
    ('209.058.025.000', 'CA'),
    ('209.058.026.000', 'GH'),
    ('209.058.027.000', 'US'),
    ('209.058.028.000', 'GD'),
    ('209.058.029.000', 'US'),
    ('209.058.031.000', 'PH'),
    ('209.058.032.000', 'US'),
    ('209.058.033.000', 'PK'),
    ('209.058.034.000', 'MX'),
    ('209.058.036.000', 'AN'),
    ('209.058.037.000', 'MX'),
    ('209.058.038.000', 'PR'),
    ('209.058.039.000', 'PK'),
    ('209.058.040.000', 'QA'),
    ('209.058.042.000', 'PR'),
    ('209.058.043.000', 'US'),
    ('209.058.044.000', 'TC'),
    ('209.058.045.000', 'US'),
    ('209.058.046.000', 'AN'),
    ('209.058.047.000', 'CO'),
    ('209.058.048.000', 'DO'),
    ('209.058.053.000', 'LB'),
    ('209.058.054.000', 'US'),
    ('209.058.055.000', 'NC'),
    ('209.058.056.000', 'US'),
    ('209.058.057.000', 'JM'),
    ('209.058.058.000', 'US'),
    ('209.058.060.000', 'PR'),
    ('209.058.062.000', 'LK'),
    ('209.058.063.000', 'US'),
    ('209.058.066.000', 'NG'),
    ('209.058.067.000', 'US'),
    ('209.058.068.000', 'CA'),
    ('209.058.071.000', 'PR'),
    ('209.058.072.000', 'TO'),
    ('209.058.074.000', 'CO'),
    ('209.058.076.000', 'CA'),
    ('209.058.077.000', 'MY'),
    ('209.058.078.000', 'AR'),
    ('209.058.080.000', 'LB'),
    ('209.058.081.000', 'US'),
    ('209.058.083.000', 'CA'),
    ('209.058.084.000', 'US'),
    ('209.058.087.000', 'ZM'),
    ('209.058.088.000', 'US'),
    ('209.058.089.000', 'MX'),
    ('209.058.090.000', 'US'),
    ('209.058.093.000', 'CA'),
    ('209.058.094.000', 'TZ'),
    ('209.058.095.000', 'CA'),
    ('209.058.096.000', 'CO'),
    ('209.058.097.000', 'UG'),
    ('209.058.098.000', 'RW'),
    ('209.058.099.000', 'GD'),
    ('209.058.100.000', 'CA'),
    ('209.058.101.000', 'US'),
    ('209.058.102.000', 'PR'),
    ('209.058.103.000', 'US'),
    ('209.058.104.000', 'AN'),
    ('209.058.105.000', 'CA'),
    ('209.058.108.000', 'US'),
    ('209.058.109.000', 'PR'),
    ('209.058.110.000', 'CA'),
    ('209.058.111.000', 'PR'),
    ('209.058.112.000', 'CA'),
    ('209.058.115.000', 'US'),
    ('209.058.116.000', 'LB'),
    ('209.058.117.000', 'EG'),
    ('209.058.118.000', 'US'),
    ('209.058.120.000', 'LY'),
    ('209.058.123.000', 'US'),
    ('209.058.124.000', 'DO'),
    ('209.058.125.000', 'CO'),
    ('209.058.126.000', 'PR'),
    ('209.058.128.000', 'US'),
    ('209.059.000.000', '--'),
    ('209.060.000.000', 'US'),
    ('209.061.134.000', 'DK'),
    ('209.061.135.000', 'US'),
    ('209.061.142.000', 'IN'),
    ('209.061.144.000', 'US'),
    ('209.061.146.000', 'IN'),
    ('209.061.147.000', 'DE'),
    ('209.061.148.000', 'US'),
    ('209.061.150.000', 'BH'),
    ('209.061.151.000', 'AU'),
    ('209.061.152.000', 'US'),
    ('209.061.162.000', 'IN'),
    ('209.061.163.000', 'US'),
    ('209.061.167.000', 'MX'),
    ('209.061.168.000', 'US'),
    ('209.061.169.000', 'GU'),
    ('209.061.170.000', 'US'),
    ('209.061.178.000', 'MY'),
    ('209.061.179.000', 'US'),
    ('209.061.180.000', 'MX'),
    ('209.061.181.000', 'US'),
    ('209.064.036.000', 'CO'),
    ('209.064.038.000', 'US'),
    ('209.068.160.000', 'CA'),
    ('209.068.192.000', 'US'),
    ('209.071.192.000', 'CA'),
    ('209.072.000.000', 'US'),
    ('209.073.225.000', 'IL'),
    ('209.073.226.000', 'US'),
    ('209.078.239.000', 'CA'),
    ('209.078.240.000', 'US'),
    ('209.082.000.000', 'CA'),
    ('209.082.128.000', 'US'),
    ('209.085.107.000', 'DE'),
    ('209.085.108.000', 'US'),
    ('209.085.241.000', 'CA'),
    ('209.085.242.000', 'US'),
    ('209.087.000.000', 'CA'),
    ('209.087.064.000', 'US'),
    ('209.087.128.000', 'CA'),
    ('209.087.144.000', 'US'),
    ('209.087.176.000', '--'),
    ('209.087.192.000', 'CA'),
    ('209.088.000.000', 'US'),
    ('209.088.001.000', 'CL'),
    ('209.088.002.000', 'AW'),
    ('209.088.003.000', 'CL'),
    ('209.088.004.000', 'HN'),
    ('209.088.007.000', 'NI'),
    ('209.088.008.000', 'CO'),
    ('209.088.016.000', 'NA'),
    ('209.088.022.000', 'CL'),
    ('209.088.023.000', 'AR'),
    ('209.088.024.000', 'US'),
    ('209.088.048.000', 'CO'),
    ('209.088.064.000', 'AG'),
    ('209.088.068.000', 'AI'),
    ('209.088.069.000', 'AG'),
    ('209.088.070.000', 'LC'),
    ('209.088.071.000', 'KN'),
    ('209.088.072.000', 'ZA'),
    ('209.088.080.000', 'PR'),
    ('209.088.088.000', 'ZW'),
    ('209.088.096.000', 'VE'),
    ('209.088.097.000', 'ZW'),
    ('209.088.098.000', 'CO'),
    ('209.088.099.000', 'US'),
    ('209.088.100.000', 'CL'),
    ('209.088.101.000', 'VE'),
    ('209.088.102.000', 'CL'),
    ('209.088.103.000', 'VE'),
    ('209.088.104.000', 'CO'),
    ('209.088.106.000', 'US'),
    ('209.088.109.000', 'CL'),
    ('209.088.110.000', 'VE'),
    ('209.088.111.000', 'HN'),
    ('209.088.112.000', 'ZA'),
    ('209.088.120.000', 'US'),
    ('209.088.121.000', 'MR'),
    ('209.088.125.000', 'DO'),
    ('209.088.127.000', 'HN'),
    ('209.088.128.000', 'AW'),
    ('209.088.136.000', 'BS'),
    ('209.088.142.000', 'CO'),
    ('209.088.144.000', 'CL'),
    ('209.088.145.000', 'VE'),
    ('209.088.146.000', 'EG'),
    ('209.088.155.000', 'IL'),
    ('209.088.159.000', 'CL'),
    ('209.088.162.000', 'US'),
    ('209.088.163.000', 'NG'),
    ('209.088.164.000', 'US'),
    ('209.088.166.000', 'PR'),
    ('209.088.168.000', 'CO'),
    ('209.088.172.000', 'IL'),
    ('209.088.200.000', 'CL'),
    ('209.088.208.000', 'US'),
    ('209.088.216.000', 'GU'),
    ('209.088.220.000', 'US'),
    ('209.088.224.000', 'GT'),
    ('209.088.228.000', 'VE'),
    ('209.088.232.000', 'AG'),
    ('209.088.234.000', 'LC'),
    ('209.088.235.000', 'AG'),
    ('209.088.237.000', 'AI'),
    ('209.088.238.000', 'KN'),
    ('209.088.239.000', 'AG'),
    ('209.088.240.000', 'US'),
    ('209.088.242.000', 'TG'),
    ('209.088.245.000', 'US'),
    ('209.088.247.000', 'PR'),
    ('209.088.248.000', 'US'),
    ('209.088.249.000', 'PR'),
    ('209.088.250.000', 'US'),
    ('209.088.251.000', 'HN'),
    ('209.088.252.000', 'US'),
    ('209.089.000.000', 'CA'),
    ('209.090.000.000', 'US'),
    ('209.090.128.000', 'CA'),
    ('209.090.192.000', 'US'),
    ('209.091.064.000', 'CA'),
    ('209.091.192.000', 'PR'),
    ('209.092.000.000', 'US'),
    ('209.093.004.000', 'BR'),
    ('209.093.005.000', 'US'),
    ('209.093.013.000', 'CO'),
    ('209.093.014.000', 'MX'),
    ('209.093.015.000', 'US'),
    ('209.093.016.000', 'CL'),
    ('209.093.017.000', 'US'),
    ('209.093.018.000', 'CA'),
    ('209.093.019.000', 'US'),
    ('209.093.027.000', 'MX'),
    ('209.093.028.000', 'US'),
    ('209.093.033.000', 'IT'),
    ('209.093.034.000', 'NO'),
    ('209.093.035.000', 'US'),
    ('209.093.036.000', 'SE'),
    ('209.093.037.000', 'US'),
    ('209.093.038.000', 'DE'),
    ('209.093.039.000', 'IL'),
    ('209.093.040.000', 'US'),
    ('209.093.042.000', 'FI'),
    ('209.093.043.000', 'DE'),
    ('209.093.044.000', 'GB'),
    ('209.093.045.000', 'DE'),
    ('209.093.046.000', 'NO'),
    ('209.093.047.000', 'TW'),
    ('209.093.048.000', 'US'),
    ('209.093.049.000', 'GB'),
    ('209.093.050.000', 'IT'),
    ('209.093.051.000', 'GB'),
    ('209.093.052.000', 'FR'),
    ('209.093.053.000', 'IT'),
    ('209.093.054.000', 'DE'),
    ('209.093.055.000', 'LU'),
    ('209.093.056.000', 'SE'),
    ('209.093.057.000', 'GB'),
    ('209.093.058.000', 'PT'),
    ('209.093.059.000', 'CH'),
    ('209.093.060.000', 'ES'),
    ('209.093.061.000', 'US'),
    ('209.093.062.000', 'CH'),
    ('209.093.063.000', 'FR'),
    ('209.093.064.000', 'US'),
    ('209.093.065.000', 'DE'),
    ('209.093.066.000', 'US'),
    ('209.093.067.000', 'AT'),
    ('209.093.068.000', 'CH'),
    ('209.093.069.000', 'US'),
    ('209.093.070.000', 'GB'),
    ('209.093.071.000', 'DE'),
    ('209.093.072.000', 'IL'),
    ('209.093.073.000', 'US'),
    ('209.093.075.000', 'NL'),
    ('209.093.076.000', 'US'),
    ('209.093.078.000', 'GR'),
    ('209.093.079.000', 'US'),
    ('209.093.080.000', 'AT'),
    ('209.093.081.000', 'CH'),
    ('209.093.082.000', 'GB'),
    ('209.093.085.000', 'DK'),
    ('209.093.086.000', 'US'),
    ('209.093.089.000', 'IE'),
    ('209.093.091.000', 'SE'),
    ('209.093.092.000', 'FR'),
    ('209.093.093.000', 'US'),
    ('209.093.094.000', 'DE'),
    ('209.093.095.000', 'GB'),
    ('209.093.096.000', 'US'),
    ('209.093.100.000', 'JP'),
    ('209.093.102.000', 'SG'),
    ('209.093.103.000', 'US'),
    ('209.093.106.000', 'TH'),
    ('209.093.107.000', 'JP'),
    ('209.093.108.000', 'US'),
    ('209.093.110.000', 'CN'),
    ('209.093.111.000', 'HK'),
    ('209.093.112.000', 'AU'),
    ('209.093.113.000', 'JP'),
    ('209.093.114.000', 'CH'),
    ('209.093.115.000', 'TH'),
    ('209.093.116.000', 'US'),
    ('209.093.117.000', 'PH'),
    ('209.093.118.000', 'US'),
    ('209.093.120.000', 'MY'),
    ('209.093.121.000', 'PH'),
    ('209.093.122.000', 'SG'),
    ('209.093.123.000', 'US'),
    ('209.093.126.000', 'PH'),
    ('209.093.127.000', 'US'),
    ('209.093.131.000', 'BR'),
    ('209.093.132.000', 'US'),
    ('209.093.134.000', 'GB'),
    ('209.093.135.000', 'US'),
    ('209.093.141.000', 'CA'),
    ('209.093.142.000', 'US'),
    ('209.093.152.000', 'VE'),
    ('209.093.153.000', 'US'),
    ('209.093.156.000', 'MX'),
    ('209.093.157.000', 'US'),
    ('209.093.158.000', 'CL'),
    ('209.093.159.000', 'KR'),
    ('209.093.160.000', 'ID'),
    ('209.093.161.000', 'US'),
    ('209.093.163.000', 'SG'),
    ('209.093.164.000', 'US'),
    ('209.093.166.000', 'PH'),
    ('209.093.167.000', 'US'),
    ('209.093.168.000', 'KR'),
    ('209.093.169.000', 'HK'),
    ('209.093.170.000', 'US'),
    ('209.093.171.000', 'KR'),
    ('209.093.172.000', 'JP'),
    ('209.093.173.000', 'TW'),
    ('209.093.174.000', 'AU'),
    ('209.093.175.000', 'JP'),
    ('209.093.176.000', 'KR'),
    ('209.093.177.000', 'US'),
    ('209.093.178.000', 'CN'),
    ('209.093.179.000', 'TH'),
    ('209.093.180.000', 'ID'),
    ('209.093.181.000', 'KR'),
    ('209.093.182.000', 'ID'),
    ('209.093.183.000', 'SG'),
    ('209.093.184.000', 'JP'),
    ('209.093.185.000', 'CH'),
    ('209.093.186.000', 'HK'),
    ('209.093.187.000', 'ID'),
    ('209.093.188.000', 'NZ'),
    ('209.093.189.000', 'CN'),
    ('209.093.192.000', 'US'),
    ('209.093.194.000', 'BR'),
    ('209.093.195.000', 'US'),
    ('209.093.197.000', 'BR'),
    ('209.093.198.000', 'US'),
    ('209.093.201.000', 'BR'),
    ('209.093.202.000', 'US'),
    ('209.093.209.000', 'BR'),
    ('209.093.210.000', 'US'),
    ('209.093.223.000', 'MX'),
    ('209.093.224.000', 'US'),
    ('209.093.226.000', 'TH'),
    ('209.093.227.000', 'JP'),
    ('209.093.228.000', 'US'),
    ('209.093.232.000', 'GB'),
    ('209.093.234.000', 'PH'),
    ('209.093.235.000', 'GB'),
    ('209.093.236.000', 'TH'),
    ('209.093.237.000', 'JP'),
    ('209.093.238.000', 'US'),
    ('209.093.239.000', 'MY'),
    ('209.093.240.000', 'CA'),
    ('209.093.241.000', 'US'),
    ('209.093.242.000', 'TH'),
    ('209.093.243.000', 'TW'),
    ('209.093.244.000', 'US'),
    ('209.093.245.000', 'KR'),
    ('209.093.246.000', 'US'),
    ('209.093.247.000', 'JP'),
    ('209.093.248.000', 'US'),
    ('209.093.250.000', 'TH'),
    ('209.093.251.000', 'US'),
    ('209.093.253.000', 'JP'),
    ('209.093.254.000', 'KR'),
    ('209.093.255.000', 'PH'),
    ('209.094.000.000', 'US'),
    ('209.094.192.000', 'TT'),
    ('209.094.224.000', 'US'),
    ('209.095.132.000', 'SE'),
    ('209.095.133.000', 'ES'),
    ('209.095.134.000', 'SE'),
    ('209.095.135.000', 'US'),
    ('209.095.136.000', 'SE'),
    ('209.095.139.000', 'US'),
    ('209.095.140.000', 'SE'),
    ('209.095.142.000', 'US'),
    ('209.095.143.000', 'SE'),
    ('209.095.144.000', 'US'),
    ('209.095.153.000', 'CA'),
    ('209.095.154.000', 'US'),
    ('209.095.159.000', 'SE'),
    ('209.095.160.000', 'US'),
    ('209.098.119.000', 'BE'),
    ('209.098.120.000', 'US'),
    ('209.099.224.000', 'AR'),
    ('209.099.240.000', 'US'),
    ('209.101.078.000', 'AU'),
    ('209.101.080.000', 'US'),
    ('209.101.084.000', 'NG'),
    ('209.101.085.000', 'US'),
    ('209.101.086.000', 'BS'),
    ('209.101.087.000', 'US'),
    ('209.103.000.000', 'CA'),
    ('209.103.064.000', 'US'),
    ('209.104.064.000', 'CA'),
    ('209.104.128.000', 'US'),
    ('209.105.192.000', 'CA'),
    ('209.105.224.000', '--'),
    ('209.106.000.000', 'US'),
    ('209.107.096.000', 'CA'),
    ('209.107.128.000', 'US'),
    ('209.107.192.000', '--'),
    ('209.108.000.000', 'US'),
    ('209.112.000.000', 'CA'),
    ('209.112.023.000', 'US'),
    ('209.112.024.000', 'CA'),
    ('209.112.064.000', 'US'),
    ('209.115.128.000', 'CA'),
    ('209.116.000.000', 'US'),
    ('209.120.181.000', '--'),
    ('209.120.182.000', 'US'),
    ('209.121.000.000', 'CA'),
    ('209.122.000.000', 'US'),
    ('209.124.032.000', '--'),
    ('209.124.064.000', 'US'),
    ('209.124.100.000', 'NI'),
    ('209.124.102.000', 'SV'),
    ('209.124.105.000', 'US'),
    ('209.124.108.000', 'AN'),
    ('209.124.110.000', 'SV'),
    ('209.124.112.000', '--'),
    ('209.124.128.000', 'US'),
    ('209.126.135.000', 'BE'),
    ('209.126.136.000', 'US'),
    ('209.126.192.000', '--'),
    ('209.127.000.000', 'US'),
    ('209.127.010.000', 'PA'),
    ('209.127.011.000', 'US'),
    ('209.127.018.000', 'PA'),
    ('209.127.019.000', 'US'),
    ('209.127.027.000', 'VE'),
    ('209.127.028.000', 'US'),
    ('209.127.055.000', 'PA'),
    ('209.127.056.000', 'US'),
    ('209.127.058.000', 'VE'),
    ('209.127.059.000', 'US'),
    ('209.127.062.000', 'NI'),
    ('209.127.063.000', 'US'),
    ('209.127.080.000', 'VE'),
    ('209.127.084.000', 'US'),
    ('209.127.103.000', 'PA'),
    ('209.127.104.000', 'US'),
    ('209.127.119.000', 'PA'),
    ('209.127.128.000', 'US'),
    ('209.128.000.000', 'CA'),
    ('209.128.064.000', 'US'),
    ('209.132.081.000', 'NL'),
    ('209.132.082.000', 'US'),
    ('209.132.083.000', 'NL'),
    ('209.132.084.000', 'US'),
    ('209.132.192.000', 'HK'),
    ('209.132.193.000', 'US'),
    ('209.132.194.000', 'HK'),
    ('209.132.199.000', 'US'),
    ('209.132.209.000', 'GR'),
    ('209.132.210.000', 'US'),
    ('209.135.064.000', 'CA'),
    ('209.135.128.000', 'US'),
    ('209.137.176.000', '--'),
    ('209.137.192.000', 'US'),
    ('209.137.224.000', '--'),
    ('209.138.000.000', 'US'),
    ('209.139.192.000', 'CA'),
    ('209.139.226.000', 'US'),
    ('209.139.228.000', 'CA'),
    ('209.140.000.000', 'US'),
    ('209.145.096.000', '--'),
    ('209.145.128.000', 'US'),
    ('209.146.128.000', 'CA'),
    ('209.146.187.000', 'US'),
    ('209.146.188.000', 'CA'),
    ('209.146.249.000', 'US'),
    ('209.146.250.000', 'CA'),
    ('209.147.000.000', 'US'),
    ('209.148.006.000', 'GB'),
    ('209.148.007.000', 'US'),
    ('209.148.064.000', 'CA'),
    ('209.148.096.000', '--'),
    ('209.148.128.000', 'CA'),
    ('209.149.000.000', 'US'),
    ('209.151.000.000', 'CA'),
    ('209.151.032.000', 'US'),
    ('209.151.128.000', 'CA'),
    ('209.151.144.000', '--'),
    ('209.151.160.000', 'US'),
    ('209.153.192.000', 'CA'),
    ('209.153.200.000', 'US'),
    ('209.153.204.000', 'CA'),
    ('209.153.234.000', 'VA'),
    ('209.153.235.000', 'CA'),
    ('209.153.247.000', 'US'),
    ('209.153.248.000', 'CA'),
    ('209.154.000.000', 'US'),
    ('209.161.192.000', 'CA'),
    ('209.162.000.000', 'US'),
    ('209.162.160.000', 'CA'),
    ('209.162.176.000', '--'),
    ('209.162.192.000', 'US'),
    ('209.162.224.000', 'CA'),
    ('209.162.240.000', '--'),
    ('209.163.000.000', 'US'),
    ('209.163.232.000', 'DE'),
    ('209.163.233.000', 'US'),
    ('209.163.239.000', 'CA'),
    ('209.163.240.000', 'US'),
    ('209.163.245.000', 'AU'),
    ('209.163.246.000', 'US'),
    ('209.163.248.000', 'DE'),
    ('209.163.249.000', 'ID'),
    ('209.163.250.000', 'US'),
    ('209.165.228.000', 'CA'),
    ('209.165.240.000', '--'),
    ('209.166.000.000', 'US'),
    ('209.167.000.000', 'CA'),
    ('209.167.008.000', 'US'),
    ('209.167.010.000', 'CA'),
    ('209.167.024.000', 'US'),
    ('209.167.025.000', 'CA'),
    ('209.167.042.000', 'US'),
    ('209.167.043.000', 'CA'),
    ('209.167.096.000', 'US'),
    ('209.167.097.000', 'CA'),
    ('209.167.103.000', 'GB'),
    ('209.167.104.000', 'CA'),
    ('209.167.112.000', 'GB'),
    ('209.167.113.000', 'CA'),
    ('209.167.176.000', 'US'),
    ('209.167.177.000', 'CA'),
    ('209.167.185.000', 'US'),
    ('209.167.186.000', 'CA'),
    ('209.167.192.000', 'US'),
    ('209.167.193.000', 'CA'),
    ('209.168.000.000', 'US'),
    ('209.168.128.000', '--'),
    ('209.170.000.000', 'US'),
    ('209.170.068.000', 'SE'),
    ('209.170.074.000', 'US'),
    ('209.170.076.000', 'SE'),
    ('209.170.080.000', 'GB'),
    ('209.170.081.000', 'SE'),
    ('209.170.082.000', 'US'),
    ('209.170.087.000', 'SE'),
    ('209.170.094.000', 'US'),
    ('209.170.097.000', 'CA'),
    ('209.170.098.000', 'US'),
    ('209.170.100.000', 'SE'),
    ('209.170.108.000', 'US'),
    ('209.170.112.000', 'SE'),
    ('209.170.124.000', 'US'),
    ('209.170.125.000', 'SE'),
    ('209.170.128.000', 'US'),
    ('209.171.000.000', 'CA'),
    ('209.172.000.000', 'US'),
    ('209.182.036.000', 'NL'),
    ('209.182.037.000', 'US'),
    ('209.182.060.000', 'IN'),
    ('209.182.061.000', 'US'),
    ('209.182.062.000', 'DE'),
    ('209.182.063.000', 'SG'),
    ('209.182.064.000', 'US'),
    ('209.182.096.000', '--'),
    ('209.182.128.000', 'US'),
    ('209.183.000.000', 'CA'),
    ('209.183.032.000', 'US'),
    ('209.183.128.000', 'CA'),
    ('209.183.160.000', 'US'),
    ('209.183.176.000', '--'),
    ('209.183.192.000', 'US'),
    ('209.188.000.000', '--'),
    ('209.188.064.000', 'CA'),
    ('209.188.096.000', 'US'),
    ('209.188.112.000', '--'),
    ('209.188.128.000', 'US'),
    ('209.195.064.000', 'CA'),
    ('209.195.128.000', 'US'),
    ('209.196.224.000', 'CA'),
    ('209.196.240.000', '--'),
    ('209.197.000.000', 'US'),
    ('209.197.128.000', 'CA'),
    ('209.197.192.000', 'US'),
    ('209.198.192.000', 'BZ'),
    ('209.198.193.000', 'NI'),
    ('209.198.195.000', 'HN'),
    ('209.198.196.000', 'US'),
    ('209.198.197.000', 'PA'),
    ('209.198.198.000', 'TT'),
    ('209.198.200.000', 'MX'),
    ('209.198.202.000', 'US'),
    ('209.198.204.000', 'AR'),
    ('209.198.205.000', 'US'),
    ('209.198.206.000', 'BO'),
    ('209.198.207.000', 'AR'),
    ('209.198.208.000', 'BO'),
    ('209.198.210.000', 'MX'),
    ('209.198.211.000', 'CL'),
    ('209.198.215.000', 'US'),
    ('209.198.216.000', 'BS'),
    ('209.198.217.000', 'US'),
    ('209.198.219.000', 'NI'),
    ('209.198.220.000', 'BZ'),
    ('209.198.221.000', 'BO'),
    ('209.198.222.000', 'US'),
    ('209.198.224.000', 'DO'),
    ('209.198.225.000', 'BB'),
    ('209.198.226.000', 'US'),
    ('209.198.229.000', 'NI'),
    ('209.198.230.000', 'BZ'),
    ('209.198.231.000', 'NI'),
    ('209.198.232.000', 'CO'),
    ('209.198.233.000', 'BZ'),
    ('209.198.234.000', 'US'),
    ('209.198.236.000', 'NI'),
    ('209.198.237.000', 'UY'),
    ('209.198.238.000', 'PE'),
    ('209.198.239.000', 'BO'),
    ('209.198.240.000', 'NG'),
    ('209.198.242.000', 'US'),
    ('209.198.243.000', 'CM'),
    ('209.198.244.000', 'US'),
    ('209.198.245.000', 'LB'),
    ('209.198.246.000', 'US'),
    ('209.198.247.000', 'GH'),
    ('209.198.248.000', 'KE'),
    ('209.198.249.000', 'US'),
    ('209.198.250.000', 'KE'),
    ('209.198.252.000', 'US'),
    ('209.198.255.000', 'PK'),
    ('209.199.000.000', 'US'),
    ('209.200.000.000', '--'),
    ('209.201.000.000', 'US'),
    ('209.202.000.000', 'CA'),
    ('209.202.128.000', 'US'),
    ('209.203.000.000', 'ZA'),
    ('209.203.064.000', 'US'),
    ('209.203.193.000', 'CR'),
    ('209.203.194.000', 'US'),
    ('209.203.213.000', 'CR'),
    ('209.203.214.000', 'US'),
    ('209.203.222.000', 'CR'),
    ('209.203.223.000', 'US'),
    ('209.205.000.000', 'CA'),
    ('209.205.064.000', 'US'),
    ('209.205.065.000', 'CO'),
    ('209.205.067.000', 'US'),
    ('209.205.069.000', 'CO'),
    ('209.205.071.000', 'US'),
    ('209.205.072.000', 'CO'),
    ('209.205.073.000', 'US'),
    ('209.205.075.000', 'CO'),
    ('209.205.077.000', 'US'),
    ('209.205.079.000', 'CO'),
    ('209.205.081.000', 'US'),
    ('209.205.082.000', 'CO'),
    ('209.205.083.000', 'US'),
    ('209.205.084.000', 'CO'),
    ('209.205.085.000', 'EC'),
    ('209.205.095.000', 'US'),
    ('209.205.097.000', 'CO'),
    ('209.205.098.000', 'US'),
    ('209.205.102.000', 'EC'),
    ('209.205.104.000', 'CO'),
    ('209.205.105.000', 'US'),
    ('209.205.109.000', 'EC'),
    ('209.205.110.000', 'US'),
    ('209.212.032.000', 'CA'),
    ('209.212.064.000', 'US'),
    ('209.212.096.000', 'ZA'),
    ('209.212.128.000', 'US'),
    ('209.213.224.000', 'CA'),
    ('209.213.240.000', '--'),
    ('209.214.000.000', 'US'),
    ('209.216.124.000', 'CA'),
    ('209.216.125.000', 'US'),
    ('209.216.128.000', 'CA'),
    ('209.216.160.000', 'US'),
    ('209.216.176.000', '--'),
    ('209.216.192.000', 'US'),
    ('209.217.064.000', 'CA'),
    ('209.217.091.000', 'US'),
    ('209.217.092.000', 'CA'),
    ('209.217.128.000', 'US'),
    ('209.221.064.000', 'CA'),
    ('209.221.128.000', 'US'),
    ('209.221.224.000', 'BZ'),
    ('209.221.227.000', 'US'),
    ('209.221.240.000', '--'),
    ('209.222.000.000', 'US'),
    ('209.222.224.000', 'CA'),
    ('209.222.240.000', '--'),
    ('209.223.000.000', 'US'),
    ('209.223.153.000', 'CR'),
    ('209.223.154.000', 'US'),
    ('209.226.000.000', 'CA'),
    ('209.227.000.000', 'US'),
    ('209.227.195.000', 'IT'),
    ('209.227.196.000', 'US'),
    ('209.227.203.000', 'CY'),
    ('209.227.204.000', 'US'),
    ('209.227.222.000', 'CA'),
    ('209.227.223.000', 'IT'),
    ('209.227.224.000', 'US'),
    ('209.236.034.000', 'GT'),
    ('209.236.035.000', 'US'),
    ('209.237.108.000', 'IE'),
    ('209.237.109.000', 'US'),
    ('209.239.000.000', 'CA'),
    ('209.239.032.000', 'US'),
    ('209.239.054.000', 'IN'),
    ('209.239.055.000', 'US'),
    ('209.239.073.000', 'BS'),
    ('209.239.074.000', 'GB'),
    ('209.239.075.000', 'RO'),
    ('209.239.076.000', 'AL'),
    ('209.239.077.000', 'US'),
    ('209.239.078.000', 'BG'),
    ('209.239.080.000', 'CO'),
    ('209.239.081.000', 'US'),
    ('209.239.084.000', 'BS'),
    ('209.239.085.000', 'US'),
    ('209.239.094.000', 'CO'),
    ('209.239.095.000', 'US'),
    ('209.239.102.000', 'PH'),
    ('209.239.104.000', 'US'),
    ('209.240.023.000', 'IN'),
    ('209.240.024.000', 'US'),
    ('209.240.032.000', 'CA'),
    ('209.240.048.000', '--'),
    ('209.240.064.000', 'US'),
    ('209.240.140.000', 'IN'),
    ('209.240.141.000', 'US'),
    ('209.242.135.000', 'MX'),
    ('209.242.136.000', 'US'),
    ('209.242.141.000', 'MX'),
    ('209.242.142.000', 'US'),
    ('209.242.143.000', 'MX'),
    ('209.242.144.000', 'US'),
    ('209.242.149.000', 'MX'),
    ('209.242.150.000', 'US'),
    ('209.242.155.000', 'MX'),
    ('209.242.158.000', 'US'),
    ('209.242.160.000', 'MX'),
    ('209.242.164.000', 'US'),
    ('209.242.176.000', '--'),
    ('209.242.192.000', 'US'),
    ('209.247.073.000', 'CA'),
    ('209.247.074.000', 'US'),
    ('209.250.128.000', 'CA'),
    ('209.250.192.000', 'US'),
    ('210.000.000.000', 'AU'),
    ('210.000.128.000', 'HK'),
    ('210.001.000.000', 'TH'),
    ('210.001.064.000', 'AU'),
    ('210.002.000.000', 'JP'),
    ('210.003.000.000', 'HK'),
    ('210.004.000.000', 'IN'),
    ('210.004.024.000', 'SG'),
    ('210.004.028.000', 'IN'),
    ('210.004.064.000', 'AU'),
    ('210.004.128.000', 'TH'),
    ('210.004.160.000', 'AU'),
    ('210.005.000.000', 'CN'),
    ('210.005.032.000', 'AU'),
    ('210.006.000.000', 'HK'),
    ('210.007.000.000', 'AU'),
    ('210.007.096.000', 'HK'),
    ('210.007.097.000', 'GB'),
    ('210.007.098.000', 'US'),
    ('210.007.100.000', 'HK'),
    ('210.007.102.000', 'US'),
    ('210.007.103.000', 'GB'),
    ('210.007.104.000', 'HK'),
    ('210.007.108.000', 'GB'),
    ('210.007.112.000', 'SG'),
    ('210.007.114.000', 'GB'),
    ('210.007.128.000', 'AU'),
    ('210.007.129.000', 'GB'),
    ('210.007.132.000', 'AU'),
    ('210.007.133.000', 'GB'),
    ('210.007.136.000', 'AU'),
    ('210.007.137.000', 'GB'),
    ('210.007.152.000', 'AU'),
    ('210.007.153.000', 'NL'),
    ('210.007.154.000', 'GB'),
    ('210.007.156.000', 'AU'),
    ('210.007.160.000', 'GB'),
    ('210.007.192.000', 'US'),
    ('210.007.200.000', 'GB'),
    ('210.007.224.000', 'JP'),
    ('210.007.225.000', 'GB'),
    ('210.007.248.000', 'US'),
    ('210.007.250.000', 'GB'),
    ('210.007.254.000', 'JP'),
    ('210.008.000.000', 'AU'),
    ('210.012.000.000', 'CN'),
    ('210.014.000.000', 'PH'),
    ('210.014.048.000', 'AU'),
    ('210.014.160.000', 'CN'),
    ('210.015.192.000', 'AU'),
    ('210.016.000.000', 'PH'),
    ('210.016.128.000', 'AU'),
    ('210.016.224.000', 'HK'),
    ('210.016.240.000', 'AU'),
    ('210.017.000.000', 'TW'),
    ('210.017.128.000', 'HK'),
    ('210.017.160.000', 'AU'),
    ('210.018.000.000', 'IN'),
    ('210.018.128.000', 'AU'),
    ('210.019.000.000', 'MY'),
    ('210.020.000.000', 'JP'),
    ('210.021.000.000', 'CN'),
    ('210.023.000.000', 'SG'),
    ('210.023.016.000', 'AU'),
    ('210.023.096.000', 'PH'),
    ('210.023.128.000', 'AU'),
    ('210.023.192.000', 'PH'),
    ('210.024.000.000', 'SG'),
    ('210.025.000.000', 'CN'),
    ('210.048.000.000', 'NZ'),
    ('210.048.128.000', 'AU'),
    ('210.048.192.000', 'MY'),
    ('210.048.208.000', 'AU'),
    ('210.051.000.000', 'CN'),
    ('210.054.000.000', 'NZ'),
    ('210.056.000.000', 'PK'),
    ('210.056.032.000', 'NZ'),
    ('210.056.048.000', 'AU'),
    ('210.056.192.000', 'SG'),
    ('210.057.000.000', 'HK'),
    ('210.057.016.000', 'JP'),
    ('210.057.020.000', 'HK'),
    ('210.057.021.000', 'JP'),
    ('210.057.022.000', 'HK'),
    ('210.057.049.000', 'JP'),
    ('210.057.052.000', 'HK'),
    ('210.057.053.000', 'JP'),
    ('210.057.054.000', 'HK'),
    ('210.057.055.000', 'JP'),
    ('210.057.056.000', 'HK'),
    ('210.057.060.000', 'JP'),
    ('210.057.063.000', 'HK'),
    ('210.057.064.000', 'JP'),
    ('210.057.070.000', 'HK'),
    ('210.057.096.000', 'JP'),
    ('210.057.188.000', 'HK'),
    ('210.057.199.000', 'JP'),
    ('210.057.208.000', 'AU'),
    ('210.058.000.000', 'TW'),
    ('210.072.000.000', 'CN'),
    ('210.079.000.000', 'JP'),
    ('210.079.016.000', 'AU'),
    ('210.079.224.000', 'CN'),
    ('210.080.000.000', 'US'),
    ('210.080.010.000', 'HK'),
    ('210.080.011.000', 'US'),
    ('210.080.012.000', 'HK'),
    ('210.080.014.000', 'US'),
    ('210.080.017.000', 'HK'),
    ('210.080.018.000', 'JP'),
    ('210.080.019.000', 'HK'),
    ('210.080.020.000', 'JP'),
    ('210.080.024.000', 'HK'),
    ('210.080.027.000', 'US'),
    ('210.080.048.000', 'AU'),
    ('210.080.052.000', 'US'),
    ('210.080.064.000', 'TW'),
    ('210.080.080.000', 'AU'),
    ('210.080.096.000', 'KR'),
    ('210.080.112.000', 'AU'),
    ('210.080.192.000', 'JP'),
    ('210.082.000.000', 'CN'),
    ('210.084.000.000', 'AU'),
    ('210.085.000.000', 'TW'),
    ('210.086.000.000', 'NZ'),
    ('210.086.128.000', 'AU'),
    ('210.087.248.000', 'HK'),
    ('210.088.000.000', 'JP'),
    ('210.089.032.000', 'AU'),
    ('210.090.000.000', 'KR'),
    ('210.128.000.000', 'JP'),
    ('210.160.128.000', 'CN'),
    ('210.160.224.000', 'JP'),
    ('210.164.087.000', 'CN'),
    ('210.164.102.000', 'JP'),
    ('210.164.104.000', 'CN'),
    ('210.164.116.000', 'JP'),
    ('210.164.118.000', 'CN'),
    ('210.164.139.000', 'JP'),
    ('210.176.000.000', 'HK'),
    ('210.178.000.000', 'KR'),
    ('210.184.000.000', 'HK'),
    ('210.185.000.000', 'NZ'),
    ('210.185.032.000', 'AU'),
    ('210.186.000.000', 'MY'),
    ('210.188.000.000', 'JP'),
    ('210.192.000.000', 'TW'),
    ('210.192.096.000', 'CN'),
    ('210.192.128.000', 'TW'),
    ('210.193.000.000', 'SG'),
    ('210.193.032.000', 'AU'),
    ('210.194.000.000', 'JP'),
    ('210.195.000.000', 'MY'),
    ('210.196.000.000', 'JP'),
    ('210.200.000.000', 'TW'),
    ('210.203.128.000', 'TH'),
    ('210.203.192.000', 'TW'),
    ('210.210.133.000', 'AU'),
    ('210.212.000.000', 'IN'),
    ('210.213.000.000', 'JP'),
    ('210.213.002.000', 'CH'),
    ('210.213.003.000', 'HK'),
    ('210.213.004.000', 'TW'),
    ('210.213.005.000', 'PH'),
    ('210.213.006.000', 'HK'),
    ('210.213.007.000', 'JP'),
    ('210.213.008.000', 'PH'),
    ('210.213.010.000', 'JP'),
    ('210.213.011.000', 'CN'),
    ('210.213.012.000', 'PH'),
    ('210.213.016.000', 'US'),
    ('210.213.032.000', 'AU'),
    ('210.214.000.000', 'IN'),
    ('210.215.000.000', 'AU'),
    ('210.216.000.000', 'KR'),
    ('210.224.000.000', 'JP'),
    ('210.240.000.000', 'TW'),
    ('210.245.000.000', 'AU'),
    ('210.248.000.000', 'JP'),
    ('211.014.021.000', 'CN'),
    ('211.016.000.000', 'JP'),
    ('211.020.000.000', 'TW'),
    ('211.024.000.000', 'MY'),
    ('211.024.128.000', 'CN'),
    ('211.026.000.000', 'AU'),
    ('211.026.064.000', 'CN'),
    ('211.028.000.000', 'AU'),
    ('211.029.064.000', 'CN'),
    ('211.032.000.000', 'KR'),
    ('211.064.000.000', 'CN'),
    ('211.072.000.000', 'TW'),
    ('211.075.112.000', 'CN'),
    ('211.075.120.000', 'TW'),
    ('211.080.000.000', 'CN'),
    ('211.104.000.000', 'KR'),
    ('211.120.000.000', 'JP'),
    ('211.136.000.000', 'CN'),
    ('211.168.000.000', 'KR'),
    ('212.000.000.000', 'GB'),
    ('212.000.001.000', 'DE'),
    ('212.000.016.000', 'EU'),
    ('212.000.064.000', 'RU'),
    ('212.000.096.000', 'ES'),
    ('212.000.097.000', 'GB'),
    ('212.000.098.000', 'ES'),
    ('212.000.101.000', 'IT'),
    ('212.000.102.000', 'ES'),
    ('212.000.128.000', 'SD'),
    ('212.000.160.000', 'PT'),
    ('212.000.192.000', 'MD'),
    ('212.000.224.000', 'NL'),
    ('212.001.010.000', 'IT'),
    ('212.001.015.000', 'NL'),
    ('212.001.032.000', 'DE'),
    ('212.001.064.000', 'UA'),
    ('212.001.128.000', 'GB'),
    ('212.001.160.000', 'NL'),
    ('212.001.192.000', 'GB'),
    ('212.001.224.000', 'RU'),
    ('212.002.000.000', 'GB'),
    ('212.002.032.000', 'DE'),
    ('212.002.096.000', 'PL'),
    ('212.002.128.000', 'IT'),
    ('212.002.160.000', 'IE'),
    ('212.002.192.000', 'TR'),
    ('212.002.224.000', 'SA'),
    ('212.003.000.000', 'SE'),
    ('212.003.032.000', 'US'),
    ('212.003.060.000', 'GB'),
    ('212.003.061.000', 'US'),
    ('212.003.065.000', 'HU'),
    ('212.003.096.000', 'UA'),
    ('212.003.128.000', 'DE'),
    ('212.003.160.000', 'GB'),
    ('212.003.192.000', 'IL'),
    ('212.003.224.000', 'BE'),
    ('212.004.000.000', 'IT'),
    ('212.004.032.000', 'NO'),
    ('212.004.064.000', 'CH'),
    ('212.004.096.000', 'ES'),
    ('212.004.128.000', 'RU'),
    ('212.004.160.000', 'DE'),
    ('212.004.192.000', 'NL'),
    ('212.004.193.000', 'GB'),
    ('212.004.194.000', 'NL'),
    ('212.004.195.000', 'DE'),
    ('212.004.196.000', 'CH'),
    ('212.004.197.000', 'FR'),
    ('212.004.198.000', 'GB'),
    ('212.004.199.000', 'EU'),
    ('212.004.200.000', 'DE'),
    ('212.004.201.000', 'AT'),
    ('212.004.202.000', 'DE'),
    ('212.004.203.000', 'BE'),
    ('212.004.204.000', 'ES'),
    ('212.004.205.000', 'CH'),
    ('212.004.206.000', 'DE'),
    ('212.004.207.000', 'SE'),
    ('212.004.208.000', 'GB'),
    ('212.004.209.000', 'CH'),
    ('212.004.210.000', 'GB'),
    ('212.004.211.000', 'US'),
    ('212.004.212.000', 'IE'),
    ('212.004.214.000', 'CH'),
    ('212.004.215.000', 'BE'),
    ('212.004.216.000', 'CY'),
    ('212.004.224.000', 'DE'),
    ('212.005.064.000', 'RU'),
    ('212.005.128.000', 'BG'),
    ('212.005.160.000', 'RU'),
    ('212.005.192.000', 'SK'),
    ('212.005.224.000', 'RU'),
    ('212.006.032.000', 'DE'),
    ('212.007.000.000', 'EE'),
    ('212.007.032.000', 'ES'),
    ('212.007.064.000', 'IT'),
    ('212.007.096.000', 'AT'),
    ('212.007.128.000', 'DE'),
    ('212.007.192.000', 'BG'),
    ('212.007.224.000', 'RU'),
    ('212.008.000.000', 'DE'),
    ('212.008.032.000', 'UA'),
    ('212.008.064.000', 'ES'),
    ('212.008.128.000', 'CH'),
    ('212.008.160.000', 'BE'),
    ('212.008.189.000', 'GB'),
    ('212.008.190.000', 'BE'),
    ('212.008.192.000', 'DE'),
    ('212.008.224.000', 'RU'),
    ('212.009.000.000', 'GB'),
    ('212.009.032.000', 'DK'),
    ('212.009.064.000', 'ES'),
    ('212.009.096.000', 'GB'),
    ('212.009.128.000', 'AT'),
    ('212.009.160.000', 'DE'),
    ('212.009.192.000', 'GB'),
    ('212.009.224.000', 'UA'),
    ('212.010.000.000', 'DK'),
    ('212.011.000.000', 'FR'),
    ('212.011.064.000', 'IT'),
    ('212.011.096.000', 'CZ'),
    ('212.011.128.000', 'RU'),
    ('212.011.160.000', 'SA'),
    ('212.011.175.000', 'KW'),
    ('212.011.176.000', 'SA'),
    ('212.011.192.000', 'RU'),
    ('212.011.224.000', 'DE'),
    ('212.012.000.000', 'RU'),
    ('212.012.032.000', 'DE'),
    ('212.012.064.000', 'RU'),
    ('212.012.096.000', 'DE'),
    ('212.012.128.000', 'TR'),
    ('212.012.160.000', 'SA'),
    ('212.012.192.000', 'IT'),
    ('212.012.224.000', 'EG'),
    ('212.013.000.000', 'IT'),
    ('212.013.032.000', 'PT'),
    ('212.013.064.000', 'MK'),
    ('212.013.096.000', 'RU'),
    ('212.013.128.000', 'KZ'),
    ('212.013.162.000', 'KG'),
    ('212.013.163.000', 'KZ'),
    ('212.013.192.000', 'GB'),
    ('212.013.224.000', 'SI'),
    ('212.014.000.000', 'PL'),
    ('212.014.064.000', 'DE'),
    ('212.014.096.000', 'ES'),
    ('212.014.128.000', 'IT'),
    ('212.014.160.000', 'RU'),
    ('212.014.224.000', 'PS'),
    ('212.015.000.000', 'TR'),
    ('212.015.032.000', 'GB'),
    ('212.015.096.000', 'RU'),
    ('212.015.128.000', 'UA'),
    ('212.015.160.000', 'IT'),
    ('212.015.192.000', 'DE'),
    ('212.015.224.000', 'ES'),
    ('212.016.000.000', 'RU'),
    ('212.016.032.000', 'AT'),
    ('212.016.064.000', 'FR'),
    ('212.016.096.000', 'FI'),
    ('212.016.128.000', 'PT'),
    ('212.016.160.000', 'SE'),
    ('212.016.192.000', 'RU'),
    ('212.016.224.000', 'DE'),
    ('212.017.000.000', 'RU'),
    ('212.017.032.000', 'IE'),
    ('212.017.064.000', 'AT'),
    ('212.017.128.000', 'NO'),
    ('212.017.160.000', 'FI'),
    ('212.017.192.000', 'IT'),
    ('212.017.224.000', 'DE'),
    ('212.018.032.000', 'SI'),
    ('212.018.048.000', 'HR'),
    ('212.018.049.000', 'SI'),
    ('212.018.064.000', 'DE'),
    ('212.018.096.000', 'CH'),
    ('212.018.128.000', 'NO'),
    ('212.018.160.000', 'PT'),
    ('212.018.192.000', 'DE'),
    ('212.018.224.000', 'GB'),
    ('212.019.000.000', 'RU'),
    ('212.019.032.000', 'DE'),
    ('212.019.064.000', 'GB'),
    ('212.019.096.000', 'IT'),
    ('212.019.128.000', 'KZ'),
    ('212.019.160.000', 'FR'),
    ('212.019.192.000', 'NL'),
    ('212.020.000.000', 'RU'),
    ('212.020.064.000', 'CZ'),
    ('212.020.128.000', 'DE'),
    ('212.020.192.000', 'NO'),
    ('212.020.224.000', 'GB'),
    ('212.021.032.000', 'DE'),
    ('212.021.096.000', 'GB'),
    ('212.021.128.000', 'BG'),
    ('212.021.160.000', 'DE'),
    ('212.021.192.000', 'IT'),
    ('212.021.198.000', 'US'),
    ('212.021.224.000', 'ES'),
    ('212.022.000.000', 'GB'),
    ('212.022.032.000', 'ES'),
    ('212.022.064.000', 'RU'),
    ('212.022.096.000', 'GB'),
    ('212.022.128.000', 'IT'),
    ('212.022.160.000', 'KE'),
    ('212.022.192.000', 'GB'),
    ('212.022.224.000', 'GI'),
    ('212.022.233.000', 'GB'),
    ('212.022.234.000', 'GI'),
    ('212.023.000.000', 'GB'),
    ('212.023.062.000', 'NL'),
    ('212.023.063.000', 'GB'),
    ('212.023.064.000', 'RU'),
    ('212.023.096.000', 'DE'),
    ('212.023.160.000', 'FR'),
    ('212.023.224.000', 'CH'),
    ('212.024.000.000', 'IT'),
    ('212.024.032.000', 'RU'),
    ('212.024.064.000', 'GB'),
    ('212.024.096.000', 'AT'),
    ('212.024.118.000', 'ES'),
    ('212.024.120.000', 'AT'),
    ('212.024.128.000', 'CZ'),
    ('212.024.160.000', 'HU'),
    ('212.024.192.000', 'LU'),
    ('212.024.224.000', 'SA'),
    ('212.025.000.000', 'CH'),
    ('212.025.032.000', 'DE'),
    ('212.025.064.000', 'IL'),
    ('212.025.128.000', 'ES'),
    ('212.025.160.000', 'IT'),
    ('212.025.192.000', 'BE'),
    ('212.025.193.000', 'FR'),
    ('212.025.194.000', 'NL'),
    ('212.025.224.000', 'GB'),
    ('212.026.000.000', 'SA'),
    ('212.026.128.000', 'UA'),
    ('212.026.160.000', 'SK'),
    ('212.026.192.000', 'NL'),
    ('212.026.224.000', 'RU'),
    ('212.027.032.000', 'FR'),
    ('212.027.064.000', 'AT'),
    ('212.027.128.000', 'DE'),
    ('212.027.160.000', 'CH'),
    ('212.027.190.000', 'DE'),
    ('212.027.191.000', 'CH'),
    ('212.027.192.000', 'CZ'),
    ('212.027.224.000', 'EE'),
    ('212.028.000.000', 'GB'),
    ('212.028.032.000', 'DE'),
    ('212.028.064.000', 'RU'),
    ('212.028.096.000', 'DE'),
    ('212.028.128.000', 'CH'),
    ('212.028.160.000', 'IT'),
    ('212.028.192.000', 'SE'),
    ('212.028.224.000', 'DE'),
    ('212.029.064.000', 'TR'),
    ('212.029.128.000', 'IT'),
    ('212.029.160.000', 'NL'),
    ('212.029.192.000', 'IL'),
    ('212.030.000.000', 'GB'),
    ('212.030.032.000', 'GR'),
    ('212.030.064.000', 'SI'),
    ('212.030.096.000', 'FR'),
    ('212.030.128.000', 'RU'),
    ('212.030.192.000', 'IS'),
    ('212.030.224.000', 'GB'),
    ('212.031.000.000', 'TR'),
    ('212.031.032.000', 'ES'),
    ('212.031.064.000', 'AT'),
    ('212.031.096.000', 'CY'),
    ('212.031.106.000', 'LB'),
    ('212.031.113.000', 'CY'),
    ('212.031.117.000', 'SY'),
    ('212.031.118.000', 'CY'),
    ('212.031.121.000', 'LB'),
    ('212.031.122.000', 'CY'),
    ('212.031.128.000', 'FR'),
    ('212.031.160.000', 'SE'),
    ('212.031.166.000', 'DK'),
    ('212.031.190.000', 'SE'),
    ('212.031.191.000', 'DK'),
    ('212.031.192.000', 'ES'),
    ('212.031.208.000', 'US'),
    ('212.031.209.000', 'NL'),
    ('212.031.210.000', 'US'),
    ('212.031.211.000', 'ES'),
    ('212.031.213.000', 'US'),
    ('212.031.214.000', 'GB'),
    ('212.031.216.000', 'US'),
    ('212.031.224.000', 'IT'),
    ('212.031.251.000', 'US'),
    ('212.031.253.000', 'IT'),
    ('212.032.000.000', 'GB'),
    ('212.032.128.000', 'SE'),
    ('212.032.192.000', 'RU'),
    ('212.032.224.000', 'NL'),
    ('212.033.000.000', 'TR'),
    ('212.033.032.000', 'AT'),
    ('212.033.064.000', 'PL'),
    ('212.033.096.000', 'EU'),
    ('212.033.128.000', 'NO'),
    ('212.033.160.000', 'SA'),
    ('212.033.192.000', 'JO'),
    ('212.033.224.000', 'RU'),
    ('212.034.000.000', 'JO'),
    ('212.034.032.000', 'RU'),
    ('212.034.064.000', 'DE'),
    ('212.034.128.000', 'ES'),
    ('212.034.160.000', 'DE'),
    ('212.034.192.000', 'IT'),
    ('212.035.000.000', 'BE'),
    ('212.035.032.000', 'CH'),
    ('212.035.064.000', 'JO'),
    ('212.035.096.000', 'BE'),
    ('212.035.128.000', 'RO'),
    ('212.035.160.000', 'UA'),
    ('212.035.192.000', 'IT'),
    ('212.035.224.000', 'GB'),
    ('212.036.000.000', 'BG'),
    ('212.036.032.000', 'GB'),
    ('212.036.067.000', 'EU'),
    ('212.036.096.000', 'GB'),
    ('212.036.188.000', 'DE'),
    ('212.036.189.000', 'GB'),
    ('212.036.190.000', 'DE'),
    ('212.036.192.000', 'LB'),
    ('212.036.224.000', 'DE'),
    ('212.037.000.000', 'SE'),
    ('212.037.032.000', 'DE'),
    ('212.037.064.000', 'GR'),
    ('212.037.096.000', 'SE'),
    ('212.037.128.000', 'NL'),
    ('212.037.160.000', 'GB'),
    ('212.037.192.000', 'FR'),
    ('212.037.224.000', 'NO'),
    ('212.038.000.000', 'DE'),
    ('212.038.032.000', 'IT'),
    ('212.038.064.000', 'GB'),
    ('212.038.096.000', 'RU'),
    ('212.038.112.000', 'AZ'),
    ('212.038.114.000', 'RU'),
    ('212.038.116.000', 'AZ'),
    ('212.038.120.000', 'RU'),
    ('212.038.128.000', 'JO'),
    ('212.038.160.000', 'GB'),
    ('212.038.192.000', 'CH'),
    ('212.038.196.000', 'PL'),
    ('212.038.197.000', 'CH'),
    ('212.038.199.000', 'DE'),
    ('212.038.216.000', 'CH'),
    ('212.038.224.000', 'FI'),
    ('212.039.000.000', 'IT'),
    ('212.039.032.000', 'SE'),
    ('212.039.064.000', 'BG'),
    ('212.039.096.000', 'BA'),
    ('212.039.128.000', 'FR'),
    ('212.039.160.000', 'GB'),
    ('212.039.192.000', 'AT'),
    ('212.039.224.000', 'GB'),
    ('212.040.000.000', 'CH'),
    ('212.040.032.000', 'UA'),
    ('212.040.064.000', 'HU'),
    ('212.040.128.000', 'FR'),
    ('212.040.160.000', 'DE'),
    ('212.040.192.000', 'RU'),
    ('212.040.224.000', 'ES'),
    ('212.041.000.000', 'RU'),
    ('212.041.032.000', 'GB'),
    ('212.041.064.000', 'DE'),
    ('212.041.128.000', 'NL'),
    ('212.041.160.000', 'EU'),
    ('212.041.192.000', 'IT'),
    ('212.041.224.000', 'AT'),
    ('212.042.000.000', 'GB'),
    ('212.042.032.000', 'RU'),
    ('212.042.064.000', 'UA'),
    ('212.042.096.000', 'KG'),
    ('212.042.128.000', 'CH'),
    ('212.042.160.000', 'GB'),
    ('212.042.192.000', 'AM'),
    ('212.042.224.000', 'DE'),
    ('212.043.000.000', 'KW'),
    ('212.043.032.000', 'CH'),
    ('212.043.064.000', 'DE'),
    ('212.043.096.000', 'IT'),
    ('212.043.128.000', 'CH'),
    ('212.043.160.000', 'GB'),
    ('212.043.192.000', 'FR'),
    ('212.044.000.000', 'GB'),
    ('212.044.064.000', 'RU'),
    ('212.044.092.000', 'SE'),
    ('212.044.096.000', 'ES'),
    ('212.044.097.000', 'CU'),
    ('212.044.108.000', 'ES'),
    ('212.044.109.000', 'CU'),
    ('212.044.113.000', 'ES'),
    ('212.044.124.000', 'CU'),
    ('212.044.127.000', 'ES'),
    ('212.044.128.000', 'RU'),
    ('212.044.160.000', 'DE'),
    ('212.044.224.000', 'FR'),
    ('212.045.000.000', 'RU'),
    ('212.045.032.000', 'NL'),
    ('212.045.064.000', 'TR'),
    ('212.045.096.000', 'IT'),
    ('212.045.160.000', 'NO'),
    ('212.045.192.000', 'CH'),
    ('212.045.224.000', 'PL'),
    ('212.046.000.000', 'RU'),
    ('212.046.032.000', 'SA'),
    ('212.046.064.000', 'GB'),
    ('212.046.096.000', 'DE'),
    ('212.046.124.000', 'GB'),
    ('212.046.125.000', 'DE'),
    ('212.046.128.000', 'GB'),
    ('212.046.160.000', 'SA'),
    ('212.046.192.000', 'RU'),
    ('212.047.000.000', 'CZ'),
    ('212.047.032.000', 'IT'),
    ('212.047.064.000', 'GB'),
    ('212.047.096.000', 'LT'),
    ('212.047.128.000', 'AZ'),
    ('212.047.160.000', 'CH'),
    ('212.047.192.000', 'LT'),
    ('212.047.193.000', 'EE'),
    ('212.047.214.000', 'LV'),
    ('212.047.215.000', 'EE'),
    ('212.047.224.000', 'FR'),
    ('212.048.000.000', 'IT'),
    ('212.048.032.000', 'NL'),
    ('212.048.064.000', 'PT'),
    ('212.048.096.000', 'DE'),
    ('212.048.128.000', 'RU'),
    ('212.048.160.000', 'IT'),
    ('212.048.192.000', 'RU'),
    ('212.048.224.000', 'TR'),
    ('212.049.000.000', 'EE'),
    ('212.049.032.000', 'IT'),
    ('212.049.064.000', 'KE'),
    ('212.049.096.000', 'RU'),
    ('212.049.128.000', 'ES'),
    ('212.049.192.000', 'GB'),
    ('212.050.000.000', 'BG'),
    ('212.050.032.000', 'TR'),
    ('212.050.064.000', 'IT'),
    ('212.050.096.000', 'EG'),
    ('212.050.128.000', 'FI'),
    ('212.050.160.000', 'GB'),
    ('212.050.192.000', 'FI'),
    ('212.050.224.000', 'GB'),
    ('212.051.000.000', 'DE'),
    ('212.051.032.000', 'ES'),
    ('212.051.064.000', 'HU'),
    ('212.051.128.000', 'IT'),
    ('212.051.160.000', 'FR'),
    ('212.051.192.000', 'PL'),
    ('212.051.224.000', 'AT'),
    ('212.052.000.000', 'NL'),
    ('212.052.032.000', 'DE'),
    ('212.052.064.000', 'IT'),
    ('212.052.128.000', 'BF'),
    ('212.052.160.000', 'HU'),
    ('212.052.192.000', 'AT'),
    ('212.052.224.000', 'DE'),
    ('212.053.000.000', 'BE'),
    ('212.053.032.000', 'RU'),
    ('212.053.064.000', 'GB'),
    ('212.053.096.000', 'CH'),
    ('212.053.124.000', 'GB'),
    ('212.053.128.000', 'DE'),
    ('212.054.000.000', 'FI'),
    ('212.054.032.000', 'NL'),
    ('212.054.064.000', 'DK'),
    ('212.054.096.000', 'RO'),
    ('212.054.128.000', 'PT'),
    ('212.054.160.000', 'GB'),
    ('212.054.192.000', 'GR'),
    ('212.054.224.000', 'IT'),
    ('212.055.000.000', 'ES'),
    ('212.055.032.000', 'FO'),
    ('212.055.064.000', 'GB'),
    ('212.055.096.000', 'DE'),
    ('212.055.128.000', 'PT'),
    ('212.055.192.000', 'CH'),
    ('212.055.224.000', 'SK'),
    ('212.056.000.000', 'BG'),
    ('212.056.032.000', 'GB'),
    ('212.056.128.000', 'MT'),
    ('212.056.160.000', 'IT'),
    ('212.056.192.000', 'MD'),
    ('212.056.224.000', 'LU'),
    ('212.057.000.000', 'TR'),
    ('212.057.032.000', 'GB'),
    ('212.057.064.000', 'DE'),
    ('212.057.096.000', 'RU'),
    ('212.057.192.000', 'GB'),
    ('212.058.000.000', 'TR'),
    ('212.058.032.000', 'GB'),
    ('212.058.064.000', 'DE'),
    ('212.058.096.000', 'GE'),
    ('212.058.128.000', 'GB'),
    ('212.058.160.000', 'NL'),
    ('212.058.192.000', 'RU'),
    ('212.058.224.000', 'GB'),
    ('212.059.000.000', 'LT'),
    ('212.059.032.000', 'DE'),
    ('212.059.064.000', 'GB'),
    ('212.059.128.000', 'CH'),
    ('212.059.192.000', 'ES'),
    ('212.059.224.000', 'IT'),
    ('212.060.000.000', 'DE'),
    ('212.060.032.000', 'CH'),
    ('212.060.064.000', 'GM'),
    ('212.060.096.000', 'DE'),
    ('212.060.160.000', 'AT'),
    ('212.060.192.000', 'DE'),
    ('212.061.000.000', 'NL'),
    ('212.062.000.000', 'GB'),
    ('212.062.004.000', 'CH'),
    ('212.062.005.000', 'GB'),
    ('212.062.006.000', 'CH'),
    ('212.062.007.000', 'GB'),
    ('212.062.012.000', 'CH'),
    ('212.062.016.000', 'GB'),
    ('212.062.019.000', 'CH'),
    ('212.062.021.000', 'GB'),
    ('212.062.024.000', 'CH'),
    ('212.062.027.000', 'GB'),
    ('212.062.028.000', 'CH'),
    ('212.062.032.000', 'YU'),
    ('212.062.064.000', 'DE'),
    ('212.062.096.000', 'SA'),
    ('212.062.100.000', 'CH'),
    ('212.062.128.000', 'FR'),
    ('212.062.192.000', 'DE'),
    ('212.062.224.000', 'NO'),
    ('212.063.000.000', 'FI'),
    ('212.063.032.000', 'DE'),
    ('212.063.096.000', 'IT'),
    ('212.063.128.000', 'DE'),
    ('212.063.161.000', 'BE'),
    ('212.063.162.000', 'DE'),
    ('212.063.163.000', 'FR'),
    ('212.063.164.000', 'DE'),
    ('212.063.166.000', 'FR'),
    ('212.063.167.000', 'DE'),
    ('212.063.171.000', 'PT'),
    ('212.063.172.000', 'DE'),
    ('212.063.173.000', 'IT'),
    ('212.063.174.000', 'DE'),
    ('212.063.177.000', 'BR'),
    ('212.063.178.000', 'US'),
    ('212.063.180.000', 'TR'),
    ('212.063.181.000', 'TW'),
    ('212.063.182.000', 'DE'),
    ('212.063.184.000', 'US'),
    ('212.063.185.000', 'DE'),
    ('212.063.186.000', '--'),
    ('212.063.187.000', 'US'),
    ('212.063.188.000', 'DE'),
    ('212.063.189.000', 'US'),
    ('212.063.190.000', 'CA'),
    ('212.063.191.000', 'JP'),
    ('212.063.192.000', 'NL'),
    ('212.063.224.000', 'BE'),
    ('212.064.000.000', 'NL'),
    ('212.064.128.000', 'SA'),
    ('212.064.160.000', 'ES'),
    ('212.064.192.000', 'TR'),
    ('212.064.224.000', 'DE'),
    ('212.064.229.000', 'AT'),
    ('212.065.000.000', 'DE'),
    ('212.065.032.000', 'BE'),
    ('212.065.064.000', 'LU'),
    ('212.065.065.000', 'EU'),
    ('212.065.096.000', 'DE'),
    ('212.065.128.000', 'TR'),
    ('212.065.160.000', 'PL'),
    ('212.065.192.000', 'CZ'),
    ('212.066.000.000', 'DE'),
    ('212.066.032.000', 'UA'),
    ('212.066.064.000', 'LU'),
    ('212.066.096.000', 'IT'),
    ('212.066.128.000', 'DE'),
    ('212.066.160.000', 'ES'),
    ('212.066.192.000', 'FI'),
    ('212.066.224.000', 'IT'),
    ('212.067.000.000', 'RU'),
    ('212.067.032.000', 'FR'),
    ('212.067.064.000', 'CZ'),
    ('212.067.096.000', 'GB'),
    ('212.067.117.000', 'NL'),
    ('212.067.118.000', 'GB'),
    ('212.067.120.000', 'CH'),
    ('212.067.128.000', 'GB'),
    ('212.067.160.000', 'NL'),
    ('212.067.177.000', 'BE'),
    ('212.067.180.000', 'NL'),
    ('212.067.186.000', 'FR'),
    ('212.067.188.000', 'NL'),
    ('212.067.189.000', 'DE'),
    ('212.067.191.000', 'NL'),
    ('212.067.192.000', 'GB'),
    ('212.067.224.000', 'AT'),
    ('212.068.000.000', 'FI'),
    ('212.068.032.000', 'AT'),
    ('212.068.064.000', 'DE'),
    ('212.068.128.000', 'IL'),
    ('212.068.160.000', 'UA'),
    ('212.068.192.000', 'BE'),
    ('212.069.000.000', 'BA'),
    ('212.069.032.000', 'GB'),
    ('212.069.064.000', 'PL'),
    ('212.069.096.000', 'RU'),
    ('212.069.128.000', 'IT'),
    ('212.069.160.000', 'AT'),
    ('212.069.192.000', 'GB'),
    ('212.070.000.000', 'DK'),
    ('212.070.032.000', 'SA'),
    ('212.070.064.000', 'GB'),
    ('212.070.096.000', 'AT'),
    ('212.070.128.000', 'GB'),
    ('212.070.160.000', 'LV'),
    ('212.070.192.000', 'GR'),
    ('212.070.224.000', 'IT'),
    ('212.071.000.000', 'BE'),
    ('212.071.032.000', 'SA'),
    ('212.071.064.000', 'NO'),
    ('212.071.096.000', 'CH'),
    ('212.071.128.000', 'CZ'),
    ('212.071.192.000', 'DE'),
    ('212.071.224.000', 'IT'),
    ('212.071.240.000', 'ES'),
    ('212.071.241.000', 'IT'),
    ('212.071.252.000', 'GB'),
    ('212.071.253.000', 'IT'),
    ('212.072.000.000', 'OM'),
    ('212.072.032.000', 'NL'),
    ('212.072.064.000', 'DE'),
    ('212.072.096.000', 'SI'),
    ('212.072.128.000', 'GE'),
    ('212.072.160.000', 'DE'),
    ('212.072.192.000', 'BG'),
    ('212.072.224.000', 'NL'),
    ('212.073.000.000', 'SE'),
    ('212.073.032.000', 'ES'),
    ('212.073.064.000', 'AM'),
    ('212.073.096.000', 'RU'),
    ('212.073.128.000', 'DE'),
    ('212.073.160.000', 'SE'),
    ('212.073.192.000', 'FR'),
    ('212.073.220.000', 'US'),
    ('212.073.221.000', 'FR'),
    ('212.073.227.000', 'GB'),
    ('212.073.228.000', 'FR'),
    ('212.074.000.000', 'GB'),
    ('212.074.032.000', 'CH'),
    ('212.074.064.000', 'GB'),
    ('212.074.068.000', 'BE'),
    ('212.074.069.000', 'ES'),
    ('212.074.070.000', 'CH'),
    ('212.074.071.000', 'IT'),
    ('212.074.072.000', 'AT'),
    ('212.074.073.000', 'SE'),
    ('212.074.074.000', 'US'),
    ('212.074.075.000', 'GB'),
    ('212.074.128.000', 'CH'),
    ('212.074.192.000', 'DE'),
    ('212.074.224.000', 'RU'),
    ('212.074.234.000', 'UA'),
    ('212.074.235.000', 'RU'),
    ('212.075.000.000', 'IT'),
    ('212.075.032.000', 'DE'),
    ('212.075.064.000', 'SE'),
    ('212.075.096.000', 'PL'),
    ('212.075.128.000', 'HU'),
    ('212.075.160.000', 'ES'),
    ('212.075.192.000', 'IT'),
    ('212.075.224.000', 'GR'),
    ('212.076.000.000', 'KZ'),
    ('212.076.032.000', 'PL'),
    ('212.076.064.000', 'SA'),
    ('212.076.096.000', 'HU'),
    ('212.076.128.000', 'DE'),
    ('212.076.160.000', 'RU'),
    ('212.076.192.000', 'DE'),
    ('212.076.224.000', 'BE'),
    ('212.077.000.000', 'VA'),
    ('212.077.032.000', 'LI'),
    ('212.077.064.000', 'IT'),
    ('212.077.096.000', 'PL'),
    ('212.077.128.000', 'IL'),
    ('212.077.160.000', 'DE'),
    ('212.077.192.000', 'QA'),
    ('212.077.224.000', 'DE'),
    ('212.078.000.000', 'IT'),
    ('212.078.032.000', 'FR'),
    ('212.078.064.000', 'GB'),
    ('212.078.096.000', 'DE'),
    ('212.078.128.000', 'ES'),
    ('212.078.160.000', 'NL'),
    ('212.078.192.000', 'SE'),
    ('212.078.224.000', 'PL'),
    ('212.079.000.000', 'DE'),
    ('212.079.064.000', 'BE'),
    ('212.079.071.000', 'DE'),
    ('212.079.086.000', 'BE'),
    ('212.079.088.000', 'DE'),
    ('212.079.096.000', 'TR'),
    ('212.079.128.000', 'ES'),
    ('212.079.160.000', 'DE'),
    ('212.079.177.000', 'GE'),
    ('212.079.178.000', 'DE'),
    ('212.079.224.000', 'NL'),
    ('212.080.000.000', 'BE'),
    ('212.080.032.000', 'DE'),
    ('212.080.064.000', 'CZ'),
    ('212.080.096.000', 'CH'),
    ('212.080.128.000', 'ES'),
    ('212.080.160.000', 'GB'),
    ('212.080.164.000', 'ES'),
    ('212.080.166.000', 'GB'),
    ('212.080.168.000', 'ES'),
    ('212.080.172.000', 'GB'),
    ('212.080.173.000', 'ES'),
    ('212.080.174.000', 'NL'),
    ('212.080.175.000', 'GB'),
    ('212.080.176.000', 'FR'),
    ('212.080.177.000', 'ES'),
    ('212.080.178.000', 'IT'),
    ('212.080.179.000', 'GB'),
    ('212.080.180.000', 'CH'),
    ('212.080.188.000', 'DE'),
    ('212.080.189.000', 'ES'),
    ('212.080.190.000', 'GB'),
    ('212.080.192.000', 'IT'),
    ('212.080.224.000', 'DE'),
    ('212.081.000.000', 'SK'),
    ('212.081.032.000', 'SE'),
    ('212.081.064.000', 'FR'),
    ('212.081.128.000', 'ES'),
    ('212.082.000.000', 'GB'),
    ('212.082.032.000', 'DE'),
    ('212.082.064.000', 'GB'),
    ('212.082.068.000', 'NL'),
    ('212.082.069.000', 'GB'),
    ('212.082.096.000', 'DE'),
    ('212.082.128.000', 'FR'),
    ('212.082.160.000', 'DE'),
    ('212.082.192.000', 'UA'),
    ('212.082.224.000', 'DE'),
    ('212.083.000.000', 'RU'),
    ('212.083.032.000', 'DE'),
    ('212.083.064.000', 'NL'),
    ('212.083.096.000', 'FI'),
    ('212.083.128.000', 'FR'),
    ('212.083.192.000', 'NL'),
    ('212.084.032.000', 'IT'),
    ('212.084.064.000', 'DE'),
    ('212.084.096.000', 'GB'),
    ('212.084.128.000', 'DE'),
    ('212.084.160.000', 'GB'),
    ('212.084.192.000', 'DE'),
    ('212.085.000.000', 'GB'),
    ('212.085.032.000', 'ES'),
    ('212.085.064.000', 'SE'),
    ('212.085.096.000', 'PL'),
    ('212.085.128.000', 'FR'),
    ('212.085.160.000', 'IT'),
    ('212.085.192.000', 'EU'),
    ('212.085.224.000', 'GB'),
    ('212.086.000.000', 'FI'),
    ('212.086.032.000', 'DE'),
    ('212.086.064.000', 'GB'),
    ('212.086.096.000', 'UA'),
    ('212.086.128.000', 'DE'),
    ('212.086.224.000', 'UA'),
    ('212.087.000.000', 'PL'),
    ('212.087.032.000', 'DE'),
    ('212.087.064.000', 'GB'),
    ('212.087.128.000', 'DE'),
    ('212.087.160.000', 'GB'),
    ('212.087.192.000', 'ES'),
    ('212.087.224.000', 'PL'),
    ('212.088.000.000', 'AT'),
    ('212.088.032.000', 'GB'),
    ('212.088.064.000', 'DK'),
    ('212.088.096.000', 'UG'),
    ('212.088.128.000', 'DE'),
    ('212.088.160.000', 'AT'),
    ('212.088.192.000', 'DE'),
    ('212.088.224.000', 'BE'),
    ('212.089.000.000', 'ES'),
    ('212.089.032.000', 'NO'),
    ('212.089.064.000', 'GB'),
    ('212.089.096.000', 'DE'),
    ('212.089.160.000', 'GR'),
    ('212.089.192.000', 'DE'),
    ('212.089.224.000', 'SK'),
    ('212.090.000.000', 'IT'),
    ('212.090.032.000', 'GB'),
    ('212.090.064.000', 'FI'),
    ('212.090.096.000', 'UA'),
    ('212.090.128.000', 'DE'),
    ('212.090.160.000', 'UA'),
    ('212.090.192.000', 'CH'),
    ('212.090.224.000', 'CZ'),
    ('212.091.000.000', 'GB'),
    ('212.091.032.000', 'IT'),
    ('212.091.096.000', 'HR'),
    ('212.091.128.000', 'SE'),
    ('212.091.160.000', 'BG'),
    ('212.091.192.000', 'RU'),
    ('212.091.224.000', 'DE'),
    ('212.092.000.000', 'HU'),
    ('212.092.032.000', 'ES'),
    ('212.092.064.000', 'NL'),
    ('212.092.096.000', 'RU'),
    ('212.092.192.000', 'GB'),
    ('212.092.224.000', 'IT'),
    ('212.093.000.000', 'DE'),
    ('212.093.032.000', 'DK'),
    ('212.093.064.000', 'GB'),
    ('212.093.096.000', 'LV'),
    ('212.093.128.000', 'RO'),
    ('212.093.160.000', 'SA'),
    ('212.093.224.000', 'SI'),
    ('212.094.000.000', 'SE'),
    ('212.094.032.000', 'CH'),
    ('212.094.064.000', 'FI'),
    ('212.094.096.000', 'RU'),
    ('212.094.128.000', 'IT'),
    ('212.094.160.000', 'FR'),
    ('212.094.224.000', 'DE'),
    ('212.095.000.000', 'AT'),
    ('212.095.032.000', 'DE'),
    ('212.095.064.000', 'FR'),
    ('212.095.096.000', 'DE'),
    ('212.095.128.000', 'GB'),
    ('212.095.160.000', 'BG'),
    ('212.095.192.000', 'ES'),
    ('212.095.224.000', 'GB'),
    ('212.096.000.000', 'GH'),
    ('212.096.002.000', 'NG'),
    ('212.096.005.000', 'GH'),
    ('212.096.028.000', 'NG'),
    ('212.096.031.000', 'GH'),
    ('212.096.032.000', 'DE'),
    ('212.096.064.000', 'FR'),
    ('212.096.096.000', 'RU'),
    ('212.096.128.000', 'DE'),
    ('212.096.160.000', 'CZ'),
    ('212.096.192.000', 'RU'),
    ('212.096.224.000', 'DE'),
    ('212.097.000.000', 'HU'),
    ('212.097.032.000', 'IT'),
    ('212.097.064.000', 'GB'),
    ('212.097.096.000', 'DE'),
    ('212.097.128.000', 'DK'),
    ('212.097.160.000', 'ES'),
    ('212.097.192.000', 'DK'),
    ('212.098.000.000', 'TR'),
    ('212.098.032.000', 'CH'),
    ('212.098.064.000', 'DE'),
    ('212.098.128.000', 'LB'),
    ('212.098.160.000', 'BY'),
    ('212.098.192.000', 'TR'),
    ('212.099.000.000', 'DE'),
    ('212.099.226.000', 'DK'),
    ('212.099.227.000', 'DE'),
    ('212.100.000.000', 'GB'),
    ('212.100.025.000', 'EU'),
    ('212.100.032.000', 'DE'),
    ('212.100.064.000', 'NG'),
    ('212.100.096.000', 'GB'),
    ('212.100.128.000', 'RU'),
    ('212.100.160.000', 'BE'),
    ('212.100.192.000', 'SA'),
    ('212.100.224.000', 'US'),
    ('212.100.230.000', 'GB'),
    ('212.100.231.000', 'US'),
    ('212.100.232.000', 'GB'),
    ('212.101.000.000', 'CH'),
    ('212.101.032.000', 'DE'),
    ('212.101.064.000', 'ES'),
    ('212.101.074.000', 'US'),
    ('212.101.075.000', 'ES'),
    ('212.101.096.000', 'TR'),
    ('212.101.128.000', 'CH'),
    ('212.101.192.000', 'DE'),
    ('212.101.224.000', 'RU'),
    ('212.102.000.000', 'SA'),
    ('212.102.032.000', 'IT'),
    ('212.102.096.000', 'GB'),
    ('212.102.128.000', 'YU'),
    ('212.102.160.000', 'DE'),
    ('212.102.192.000', 'GB'),
    ('212.102.224.000', 'DE'),
    ('212.103.000.000', 'FR'),
    ('212.103.032.000', 'DE'),
    ('212.103.064.000', 'CH'),
    ('212.103.096.000', 'DE'),
    ('212.103.128.000', 'SI'),
    ('212.103.160.000', 'EG'),
    ('212.103.192.000', 'IT'),
    ('212.103.224.000', 'GB'),
    ('212.104.000.000', 'IT'),
    ('212.104.064.000', 'GR'),
    ('212.104.096.000', 'EU'),
    ('212.104.128.000', 'GB'),
    ('212.104.160.000', 'IT'),
    ('212.104.192.000', 'NL'),
    ('212.105.000.000', 'SE'),
    ('212.105.128.000', 'BE'),
    ('212.105.160.000', 'GB'),
    ('212.105.192.000', 'DE'),
    ('212.105.224.000', 'HU'),
    ('212.106.000.000', 'PL'),
    ('212.106.032.000', 'GB'),
    ('212.106.064.000', 'EU'),
    ('212.106.096.000', 'GB'),
    ('212.106.128.000', 'PL'),
    ('212.106.192.000', 'ES'),
    ('212.107.000.000', 'GR'),
    ('212.107.032.000', 'EE'),
    ('212.107.064.000', 'FR'),
    ('212.107.076.000', 'GB'),
    ('212.107.077.000', 'FR'),
    ('212.107.083.000', 'GB'),
    ('212.107.084.000', 'FR'),
    ('212.107.096.000', 'SA'),
    ('212.107.128.000', 'GB'),
    ('212.107.160.000', 'DE'),
    ('212.107.192.000', 'RU'),
    ('212.107.224.000', 'SE'),
    ('212.108.000.000', 'NL'),
    ('212.108.010.000', 'GB'),
    ('212.108.012.000', 'NL'),
    ('212.108.014.000', 'US'),
    ('212.108.016.000', 'NL'),
    ('212.108.032.000', 'AT'),
    ('212.108.064.000', 'GB'),
    ('212.108.096.000', 'RU'),
    ('212.108.128.000', 'TR'),
    ('212.108.160.000', 'DE'),
    ('212.108.192.000', 'HU'),
    ('212.109.000.000', 'SE'),
    ('212.109.032.000', 'UA'),
    ('212.109.064.000', 'CH'),
    ('212.109.096.000', 'TR'),
    ('212.109.128.000', 'PL'),
    ('212.109.160.000', 'DE'),
    ('212.109.192.000', 'RU'),
    ('212.109.224.000', 'TR'),
    ('212.110.000.000', 'IT'),
    ('212.110.064.000', 'MK'),
    ('212.110.096.000', 'DE'),
    ('212.110.128.000', 'UA'),
    ('212.110.160.000', 'IT'),
    ('212.110.192.000', 'DE'),
    ('212.110.225.000', 'RU'),
    ('212.110.227.000', 'KZ'),
    ('212.110.228.000', 'AZ'),
    ('212.110.229.000', 'UZ'),
    ('212.110.230.000', 'KZ'),
    ('212.110.232.000', 'GE'),
    ('212.110.233.000', 'UZ'),
    ('212.110.234.000', 'RU'),
    ('212.110.238.000', 'UA'),
    ('212.110.239.000', 'KZ'),
    ('212.110.241.000', 'UZ'),
    ('212.110.242.000', 'AR'),
    ('212.110.243.000', 'RU'),
    ('212.110.248.000', 'TJ'),
    ('212.110.249.000', 'AZ'),
    ('212.110.250.000', 'RU'),
    ('212.110.251.000', 'DE'),
    ('212.111.000.000', 'CZ'),
    ('212.111.032.000', 'GB'),
    ('212.111.064.000', 'RU'),
    ('212.111.096.000', 'ES'),
    ('212.111.128.000', 'GB'),
    ('212.111.192.000', 'UA'),
    ('212.111.224.000', 'DE'),
    ('212.112.000.000', 'SE'),
    ('212.112.064.000', 'IT'),
    ('212.112.096.000', 'KG'),
    ('212.112.128.000', 'DK'),
    ('212.112.160.000', 'SE'),
    ('212.112.165.000', 'DK'),
    ('212.112.166.000', 'SE'),
    ('212.112.167.000', 'DK'),
    ('212.112.170.000', 'SE'),
    ('212.112.182.000', 'DK'),
    ('212.112.183.000', 'SE'),
    ('212.112.186.000', 'DK'),
    ('212.112.187.000', 'SE'),
    ('212.112.189.000', 'DK'),
    ('212.112.190.000', 'SE'),
    ('212.112.192.000', 'DE'),
    ('212.113.000.000', 'GB'),
    ('212.113.030.000', 'US'),
    ('212.113.031.000', 'GB'),
    ('212.113.032.000', 'UA'),
    ('212.113.064.000', 'BE'),
    ('212.113.096.000', 'RU'),
    ('212.113.128.000', 'PT'),
    ('212.113.192.000', 'GB'),
    ('212.113.224.000', 'DE'),
    ('212.114.000.000', 'TJ'),
    ('212.114.002.000', 'RU'),
    ('212.114.032.000', 'GB'),
    ('212.114.064.000', 'DE'),
    ('212.114.096.000', 'GR'),
    ('212.114.108.000', 'DE'),
    ('212.114.109.000', 'GR'),
    ('212.114.128.000', 'DE'),
    ('212.115.000.000', 'TR'),
    ('212.115.032.000', 'GB'),
    ('212.115.064.000', 'IT'),
    ('212.115.096.000', 'ES'),
    ('212.115.128.000', 'NL'),
    ('212.115.224.000', 'UA'),
    ('212.116.000.000', 'DE'),
    ('212.116.032.000', 'FI'),
    ('212.116.064.000', 'SE'),
    ('212.116.093.000', 'DK'),
    ('212.116.096.000', 'GB'),
    ('212.116.128.000', 'BG'),
    ('212.116.160.000', 'IL'),
    ('212.116.192.000', 'SA'),
    ('212.116.224.000', 'KZ'),
    ('212.117.000.000', 'GB'),
    ('212.117.032.000', 'NL'),
    ('212.117.064.000', 'DE'),
    ('212.117.096.000', 'CH'),
    ('212.117.128.000', 'IL'),
    ('212.117.160.000', 'GB'),
    ('212.117.192.000', 'CH'),
    ('212.117.224.000', 'GB'),
    ('212.117.226.000', 'EU'),
    ('212.117.227.000', 'GB'),
    ('212.117.232.000', 'EU'),
    ('212.117.240.000', 'NL'),
    ('212.117.243.000', 'EU'),
    ('212.117.248.000', 'SE'),
    ('212.117.249.000', 'DE'),
    ('212.117.250.000', 'SE'),
    ('212.117.251.000', 'DE'),
    ('212.117.252.000', 'EU'),
    ('212.117.254.000', 'DE'),
    ('212.117.255.000', 'EU'),
    ('212.118.000.000', 'JO'),
    ('212.118.032.000', 'DE'),
    ('212.118.064.000', 'SI'),
    ('212.118.096.000', 'SA'),
    ('212.118.160.000', 'DE'),
    ('212.118.224.000', 'NL'),
    ('212.118.228.000', 'GB'),
    ('212.118.230.000', 'CH'),
    ('212.118.232.000', 'GB'),
    ('212.119.001.000', 'EU'),
    ('212.119.002.000', 'GB'),
    ('212.119.008.000', 'DE'),
    ('212.119.010.000', 'FR'),
    ('212.119.013.000', 'DE'),
    ('212.119.016.000', 'GB'),
    ('212.119.032.000', 'RU'),
    ('212.119.064.000', 'SA'),
    ('212.119.096.000', 'RU'),
    ('212.119.128.000', 'AT'),
    ('212.119.160.000', 'RU'),
    ('212.120.000.000', 'MK'),
    ('212.120.032.000', 'DE'),
    ('212.120.064.000', 'NL'),
    ('212.120.128.000', 'IE'),
    ('212.120.132.000', 'GB'),
    ('212.120.133.000', 'IE'),
    ('212.120.137.000', 'GB'),
    ('212.120.138.000', 'IE'),
    ('212.120.152.000', 'GB'),
    ('212.120.153.000', 'IE'),
    ('212.120.154.000', 'GB'),
    ('212.120.158.000', 'IE'),
    ('212.120.160.000', 'RU'),
    ('212.120.192.000', 'GR'),
    ('212.120.224.000', 'GI'),
    ('212.121.000.000', 'GB'),
    ('212.121.064.000', 'IT'),
    ('212.121.096.000', 'GB'),
    ('212.121.102.000', 'NL'),
    ('212.121.103.000', 'GB'),
    ('212.121.128.000', 'DE'),
    ('212.121.160.000', 'FR'),
    ('212.121.192.000', 'DE'),
    ('212.121.194.000', 'AT'),
    ('212.121.205.000', 'DE'),
    ('212.121.206.000', 'CH'),
    ('212.121.207.000', 'AT'),
    ('212.121.217.000', 'DE'),
    ('212.121.218.000', 'AT'),
    ('212.121.224.000', 'EU'),
    ('212.122.000.000', 'RU'),
    ('212.122.032.000', 'BE'),
    ('212.122.064.000', 'LT'),
    ('212.122.096.000', 'ES'),
    ('212.122.128.000', 'DE'),
    ('212.122.160.000', 'BG'),
    ('212.122.164.000', 'CZ'),
    ('212.122.167.000', 'BG'),
    ('212.122.168.000', 'CZ'),
    ('212.122.192.000', 'PL'),
    ('212.122.224.000', 'EG'),
    ('212.123.000.000', 'BE'),
    ('212.123.032.000', 'DE'),
    ('212.123.064.000', 'IT'),
    ('212.123.096.000', 'DE'),
    ('212.123.128.000', 'NL'),
    ('212.123.233.000', 'BG'),
    ('212.123.234.000', 'NL'),
    ('212.124.000.000', 'FR'),
    ('212.124.032.000', 'DE'),
    ('212.124.064.000', 'BG'),
    ('212.124.096.000', 'NL'),
    ('212.124.128.000', 'AT'),
    ('212.124.160.000', 'YU'),
    ('212.124.192.000', 'AT'),
    ('212.124.224.000', 'GB'),
    ('212.124.227.000', 'US'),
    ('212.124.228.000', 'GB'),
    ('212.124.234.000', 'FR'),
    ('212.124.235.000', 'DE'),
    ('212.124.236.000', 'GR'),
    ('212.124.237.000', 'AT'),
    ('212.124.238.000', 'US'),
    ('212.124.240.000', 'GB'),
    ('212.124.241.000', 'AT'),
    ('212.125.000.000', 'TR'),
    ('212.125.032.000', 'DE'),
    ('212.125.064.000', 'GB'),
    ('212.125.096.000', 'DE'),
    ('212.125.128.000', 'NL'),
    ('212.125.160.000', 'NO'),
    ('212.126.000.000', 'PL'),
    ('212.126.032.000', 'GB'),
    ('212.126.064.000', 'AT'),
    ('212.126.096.000', 'GB'),
    ('212.126.160.000', 'CH'),
    ('212.126.192.000', 'DE'),
    ('212.126.224.000', 'EU'),
    ('212.127.000.000', 'GB'),
    ('212.127.003.000', 'FI'),
    ('212.127.004.000', 'GB'),
    ('212.127.024.000', 'GI'),
    ('212.127.027.000', 'GB'),
    ('212.127.032.000', 'DE'),
    ('212.127.064.000', 'PL'),
    ('212.127.096.000', 'TR'),
    ('212.127.128.000', 'NL'),
    ('212.128.000.000', 'ES'),
    ('212.129.000.000', 'FR'),
    ('212.129.064.000', 'IE'),
    ('212.129.096.000', 'EU'),
    ('212.129.128.000', 'NL'),
    ('212.130.000.000', 'DK'),
    ('212.131.000.000', 'IT'),
    ('212.132.000.000', 'GB'),
    ('212.133.000.000', 'IE'),
    ('212.133.001.000', 'FR'),
    ('212.133.004.000', 'NL'),
    ('212.133.006.000', 'SE'),
    ('212.133.007.000', 'GB'),
    ('212.133.009.000', 'ES'),
    ('212.133.010.000', 'EU'),
    ('212.133.011.000', 'DE'),
    ('212.133.014.000', 'GB'),
    ('212.133.016.000', 'ES'),
    ('212.133.017.000', 'RU'),
    ('212.133.018.000', 'GB'),
    ('212.133.020.000', 'FR'),
    ('212.133.021.000', 'IT'),
    ('212.133.022.000', 'GB'),
    ('212.133.023.000', 'DE'),
    ('212.133.024.000', 'GB'),
    ('212.133.025.000', 'NL'),
    ('212.133.026.000', 'CH'),
    ('212.133.027.000', 'NL'),
    ('212.133.028.000', 'GB'),
    ('212.133.029.000', 'FR'),
    ('212.133.030.000', 'NL'),
    ('212.133.031.000', 'DE'),
    ('212.133.032.000', 'IS'),
    ('212.133.033.000', 'ES'),
    ('212.133.034.000', 'GB'),
    ('212.133.036.000', 'FR'),
    ('212.133.041.000', 'GB'),
    ('212.133.042.000', 'IT'),
    ('212.133.043.000', 'GB'),
    ('212.133.044.000', 'US'),
    ('212.133.046.000', 'DE'),
    ('212.133.047.000', 'NL'),
    ('212.133.048.000', 'ES'),
    ('212.133.049.000', 'GB'),
    ('212.133.052.000', 'ES'),
    ('212.133.053.000', 'GB'),
    ('212.133.056.000', 'ES'),
    ('212.133.057.000', 'GB'),
    ('212.133.059.000', 'SE'),
    ('212.133.060.000', 'GB'),
    ('212.133.061.000', 'ES'),
    ('212.133.064.000', 'NL'),
    ('212.133.068.000', 'ES'),
    ('212.133.096.000', 'NL'),
    ('212.133.100.000', 'ES'),
    ('212.133.128.000', 'TR'),
    ('212.134.000.000', 'GB'),
    ('212.136.000.000', 'NL'),
    ('212.137.000.000', 'GB'),
    ('212.138.000.000', 'SA'),
    ('212.139.000.000', 'GB'),
    ('212.141.000.000', 'IT'),
    ('212.142.000.000', 'NL'),
    ('212.142.096.000', 'GB'),
    ('212.142.128.000', 'ES'),
    ('212.143.000.000', 'IL'),
    ('212.144.000.000', 'DE'),
    ('212.145.000.000', 'ES'),
    ('212.146.000.000', 'FI'),
    ('212.146.064.000', 'RO'),
    ('212.146.128.000', 'TR'),
    ('212.147.000.000', 'CH'),
    ('212.147.128.000', 'IE'),
    ('212.148.000.000', 'GB'),
    ('212.149.000.000', 'DE'),
    ('212.149.064.000', 'FI'),
    ('212.150.000.000', 'IL'),
    ('212.151.000.000', 'SE'),
    ('212.152.000.000', 'CH'),
    ('212.152.032.000', 'RU'),
    ('212.152.064.000', 'GR'),
    ('212.152.128.000', 'AT'),
    ('212.153.000.000', 'NL'),
    ('212.153.077.000', 'US'),
    ('212.153.078.000', 'NL'),
    ('212.154.000.000', 'TR'),
    ('212.154.128.000', 'KZ'),
    ('212.155.000.000', 'FR'),
    ('212.156.000.000', 'TR'),
    ('212.157.000.000', 'FR'),
    ('212.158.000.000', 'GB'),
    ('212.158.082.000', 'ES'),
    ('212.158.083.000', 'GB'),
    ('212.158.128.000', 'RU'),
    ('212.159.000.000', 'GB'),
    ('212.159.192.000', 'NL'),
    ('212.159.208.000', 'EU'),
    ('212.159.224.000', 'NL'),
    ('212.159.235.000', 'EU'),
    ('212.160.000.000', 'PL'),
    ('212.161.000.000', 'GB'),
    ('212.161.128.000', 'CH'),
    ('212.162.000.000', 'DE'),
    ('212.162.034.000', 'GB'),
    ('212.162.035.000', 'DE'),
    ('212.162.061.000', 'US'),
    ('212.162.062.000', 'DE'),
    ('212.162.064.000', 'IT'),
    ('212.162.128.000', 'SA'),
    ('212.162.160.000', 'SE'),
    ('212.162.192.000', 'GB'),
    ('212.162.195.000', 'IN'),
    ('212.162.197.000', 'GB'),
    ('212.162.225.000', 'TZ'),
    ('212.162.226.000', 'GB'),
    ('212.163.000.000', 'ES'),
    ('212.164.000.000', 'RU'),
    ('212.165.000.000', 'AT'),
    ('212.165.032.000', 'EU'),
    ('212.166.000.000', 'BE'),
    ('212.166.064.000', 'ES'),
    ('212.166.096.000', 'AT'),
    ('212.166.128.000', 'ES'),
    ('212.166.184.000', 'DE'),
    ('212.166.185.000', 'ES'),
    ('212.166.190.000', 'DE'),
    ('212.166.191.000', 'ES'),
    ('212.166.192.000', 'DE'),
    ('212.166.194.000', 'ES'),
    ('212.166.195.000', 'DE'),
    ('212.166.196.000', 'ES'),
    ('212.166.200.000', 'DE'),
    ('212.166.204.000', 'ES'),
    ('212.166.205.000', 'DE'),
    ('212.166.206.000', 'ES'),
    ('212.167.000.000', 'GB'),
    ('212.167.004.000', 'EU'),
    ('212.167.008.000', 'GB'),
    ('212.167.009.000', 'IL'),
    ('212.167.010.000', 'GB'),
    ('212.167.011.000', 'DE'),
    ('212.167.012.000', 'GB'),
    ('212.167.013.000', 'DE'),
    ('212.167.014.000', 'EU'),
    ('212.167.016.000', 'US'),
    ('212.167.020.000', 'EU'),
    ('212.168.000.000', 'DE'),
    ('212.169.000.000', 'GB'),
    ('212.169.064.000', 'NO'),
    ('212.169.128.000', 'DE'),
    ('212.170.000.000', 'ES'),
    ('212.171.000.000', 'IT'),
    ('212.172.000.000', 'DE'),
    ('212.172.051.000', 'IT'),
    ('212.172.052.000', 'DE'),
    ('212.172.060.000', 'US'),
    ('212.172.061.000', 'DE'),
    ('212.172.116.000', 'LU'),
    ('212.172.118.000', 'FR'),
    ('212.172.120.000', 'DE'),
    ('212.172.121.000', 'AT'),
    ('212.172.124.000', 'DE'),
    ('212.172.146.000', 'GB'),
    ('212.172.153.000', 'DE'),
    ('212.172.155.000', 'GB'),
    ('212.172.157.000', 'DE'),
    ('212.172.160.000', 'AT'),
    ('212.172.168.000', 'FR'),
    ('212.172.169.000', 'DE'),
    ('212.172.176.000', 'LU'),
    ('212.172.180.000', 'DE'),
    ('212.172.223.000', 'SE'),
    ('212.172.224.000', 'DE'),
    ('212.172.226.000', 'CH'),
    ('212.172.227.000', 'DE'),
    ('212.173.000.000', 'GB'),
    ('212.174.000.000', 'TR'),
    ('212.176.000.000', 'RU'),
    ('212.176.022.000', 'BY'),
    ('212.176.023.000', 'RU'),
    ('212.177.000.000', 'IT'),
    ('212.178.000.000', 'NL'),
    ('212.179.000.000', 'IL'),
    ('212.180.000.000', 'FR'),
    ('212.180.128.000', 'PL'),
    ('212.181.000.000', 'SE'),
    ('212.182.000.000', 'PL'),
    ('212.182.128.000', 'NL'),
    ('212.182.160.000', 'EU'),
    ('212.182.192.000', 'FI'),
    ('212.183.000.000', 'AT'),
    ('212.183.128.000', 'GB'),
    ('212.183.160.000', 'IT'),
    ('212.183.192.000', 'ES'),
    ('212.184.000.000', 'DE'),
    ('212.185.178.000', 'GE'),
    ('212.185.180.000', 'DE'),
    ('212.186.000.000', 'AT'),
    ('212.186.112.000', 'NO'),
    ('212.186.120.000', 'AT'),
    ('212.186.176.000', 'FR'),
    ('212.186.192.000', 'AT'),
    ('212.186.224.000', 'FR'),
    ('212.186.232.000', 'NO'),
    ('212.187.000.000', 'NL'),
    ('212.187.128.000', 'GB'),
    ('212.187.168.000', 'DE'),
    ('212.187.172.000', 'GB'),
    ('212.187.198.000', 'FR'),
    ('212.187.199.000', 'GB'),
    ('212.187.226.000', 'US'),
    ('212.187.228.000', 'GB'),
    ('212.187.230.000', 'US'),
    ('212.187.231.000', 'GB'),
    ('212.187.239.000', 'US'),
    ('212.187.240.000', 'GB'),
    ('212.187.243.000', 'US'),
    ('212.187.244.000', 'GB'),
    ('212.188.000.000', 'RU'),
    ('212.188.128.000', 'GB'),
    ('212.189.000.000', 'NL'),
    ('212.190.000.000', 'BE'),
    ('212.190.115.000', 'LU'),
    ('212.190.116.000', 'BE'),
    ('212.191.000.000', 'PL'),
    ('212.192.000.000', 'RU'),
    ('212.194.000.000', 'FR'),
    ('212.196.000.000', 'GB'),
    ('212.197.000.000', 'SK'),
    ('212.197.128.000', 'AT'),
    ('212.197.136.000', 'CH'),
    ('212.197.137.000', 'DE'),
    ('212.197.192.000', 'FR'),
    ('212.197.198.000', 'GB'),
    ('212.197.199.000', 'DE'),
    ('212.197.200.000', 'FR'),
    ('212.197.201.000', 'BE'),
    ('212.197.202.000', 'FR'),
    ('212.197.204.000', 'GB'),
    ('212.197.206.000', 'FR'),
    ('212.197.207.000', 'GB'),
    ('212.197.208.000', 'FR'),
    ('212.197.211.000', 'BE'),
    ('212.197.212.000', 'FR'),
    ('212.197.218.000', 'NL'),
    ('212.197.220.000', 'FR'),
    ('212.197.230.000', 'BE'),
    ('212.197.231.000', 'NL'),
    ('212.197.235.000', 'BE'),
    ('212.197.236.000', 'FR'),
    ('212.197.238.000', 'BE'),
    ('212.197.240.000', 'FR'),
    ('212.197.242.000', 'BE'),
    ('212.197.248.000', 'NL'),
    ('212.197.254.000', 'FR'),
    ('212.197.255.000', 'NL'),
    ('212.198.000.000', 'FR'),
    ('212.199.000.000', 'IL'),
    ('212.200.000.000', 'YU'),
    ('212.201.000.000', 'DE'),
    ('212.203.000.000', 'NL'),
    ('212.203.032.000', 'EU'),
    ('212.204.000.000', 'DE'),
    ('212.204.128.000', 'NL'),
    ('212.204.140.000', 'BE'),
    ('212.204.144.000', 'NL'),
    ('212.204.168.000', 'BE'),
    ('212.204.172.000', 'NL'),
    ('212.205.000.000', 'GR'),
    ('212.206.000.000', 'NL'),
    ('212.207.000.000', 'GB'),
    ('212.208.000.000', 'FR'),
    ('212.208.129.000', 'MC'),
    ('212.208.130.000', 'FR'),
    ('212.209.000.000', 'SE'),
    ('212.209.039.000', 'FI'),
    ('212.209.040.000', 'SE'),
    ('212.209.218.000', 'EU'),
    ('212.209.219.000', 'SE'),
    ('212.210.000.000', 'IT'),
    ('212.211.000.000', 'GB'),
    ('212.211.036.000', 'DE'),
    ('212.211.040.000', 'GB'),
    ('212.211.052.000', 'FR'),
    ('212.211.053.000', 'GB'),
    ('212.211.064.000', 'DE'),
    ('212.211.076.000', 'GB'),
    ('212.211.079.000', 'DE'),
    ('212.211.095.000', 'GB'),
    ('212.211.128.000', 'DE'),
    ('212.212.000.000', 'GB'),
    ('212.213.000.000', 'FI'),
    ('212.213.004.000', 'SE'),
    ('212.213.008.000', 'FI'),
    ('212.214.000.000', 'SE'),
    ('212.215.000.000', 'CH'),
    ('212.215.128.000', 'NL'),
    ('212.216.000.000', 'IT'),
    ('212.217.000.000', 'MA'),
    ('212.217.128.000', 'SE'),
    ('212.218.000.000', 'DE'),
    ('212.219.000.000', 'GB'),
    ('212.220.000.000', 'RU'),
    ('212.221.000.000', 'BE'),
    ('212.221.044.000', 'NL'),
    ('212.221.045.000', 'BE'),
    ('212.221.053.000', 'NL'),
    ('212.221.054.000', 'BE'),
    ('212.221.057.000', 'NL'),
    ('212.221.058.000', 'BE'),
    ('212.221.060.000', 'LU'),
    ('212.221.061.000', 'BE'),
    ('212.221.070.000', 'LU'),
    ('212.221.072.000', 'BE'),
    ('212.221.075.000', 'LU'),
    ('212.221.076.000', 'BE'),
    ('212.221.128.000', 'DE'),
    ('212.222.073.000', 'NL'),
    ('212.222.074.000', 'DE'),
    ('212.222.112.000', 'BE'),
    ('212.222.113.000', 'DE'),
    ('212.222.122.000', 'SE'),
    ('212.222.123.000', 'DE'),
    ('212.222.184.000', 'NL'),
    ('212.222.187.000', 'DE'),
    ('212.222.250.000', 'AT'),
    ('212.222.251.000', 'DE'),
    ('212.224.064.000', 'GB'),
    ('212.224.128.000', 'BE'),
    ('212.225.000.000', 'GB'),
    ('212.225.128.000', 'FR'),
    ('212.226.000.000', 'FI'),
    ('212.226.103.000', 'EU'),
    ('212.226.104.000', 'FI'),
    ('212.226.119.000', 'EU'),
    ('212.226.120.000', 'FI'),
    ('212.226.177.000', 'EU'),
    ('212.226.180.000', 'FI'),
    ('212.226.183.000', 'EU'),
    ('212.226.200.000', 'FI'),
    ('212.226.202.000', 'EU'),
    ('212.226.212.000', 'FI'),
    ('212.226.213.000', 'EU'),
    ('212.226.216.000', 'FI'),
    ('212.227.000.000', 'DE'),
    ('212.228.000.000', 'GB'),
    ('212.230.000.000', 'ES'),
    ('212.232.000.000', 'BE'),
    ('212.232.016.000', 'FR'),
    ('212.232.128.000', 'CH'),
    ('212.233.000.000', 'BE'),
    ('212.233.064.000', 'RU'),
    ('212.233.128.000', 'FR'),
    ('212.234.168.000', 'MC'),
    ('212.234.169.000', 'FR'),
    ('212.234.201.000', 'MC'),
    ('212.234.202.000', 'FR'),
    ('212.235.000.000', 'IL'),
    ('212.235.064.000', 'EU'),
    ('212.236.000.000', 'AT'),
    ('212.237.000.000', 'DK'),
    ('212.238.000.000', 'NL'),
    ('212.239.000.000', 'IT'),
    ('212.239.056.000', 'AT'),
    ('212.239.057.000', 'IT'),
    ('212.239.128.000', 'BE'),
    ('212.240.000.000', 'GB'),
    ('212.241.000.000', 'FR'),
    ('212.241.032.000', 'NL'),
    ('212.241.064.000', 'AT'),
    ('212.241.128.000', 'GB'),
    ('212.242.000.000', 'DK'),
    ('212.243.000.000', 'CH'),
    ('212.243.080.000', 'GB'),
    ('212.243.081.000', 'CH'),
    ('212.243.188.000', 'LI'),
    ('212.243.189.000', 'CH'),
    ('212.244.000.000', 'PL'),
    ('212.245.000.000', 'IT'),
    ('212.246.000.000', 'FI'),
    ('212.247.000.000', 'SE'),
    ('212.248.000.000', 'RU'),
    ('212.248.128.000', 'GB'),
    ('212.249.000.000', 'CH'),
    ('212.250.000.000', 'GB'),
    ('212.251.000.000', 'GR'),
    ('212.251.128.000', 'PT'),
    ('212.252.000.000', 'TR'),
    ('212.254.000.000', 'CH'),
    ('212.255.000.000', 'DE'),
    ('212.255.088.000', 'FR'),
    ('212.255.089.000', 'DE'),
    ('213.000.000.000', 'ES'),
    ('213.001.000.000', 'GB'),
    ('213.002.216.000', 'IT'),
    ('213.002.220.000', 'GB'),
    ('213.003.000.000', 'CH'),
    ('213.004.000.000', 'ES'),
    ('213.005.000.000', 'GR'),
    ('213.006.000.000', 'DE'),
    ('213.008.000.000', 'IL'),
    ('213.009.000.000', 'DE'),
    ('213.009.128.000', 'ES'),
    ('213.010.000.000', 'NL'),
    ('213.011.000.000', 'FR'),
    ('213.011.002.000', 'GB'),
    ('213.011.003.000', 'FR'),
    ('213.011.174.000', 'CA'),
    ('213.011.175.000', 'FR'),
    ('213.012.000.000', 'GB'),
    ('213.013.000.000', 'PT'),
    ('213.014.000.000', 'TR'),
    ('213.015.000.000', 'SE'),
    ('213.015.132.000', 'FI'),
    ('213.015.139.000', 'SE'),
    ('213.015.140.000', 'FI'),
    ('213.015.142.000', 'SE'),
    ('213.016.000.000', 'GP'),
    ('213.016.005.000', 'FR'),
    ('213.016.008.000', 'GP'),
    ('213.016.009.000', 'FR'),
    ('213.016.016.000', 'MQ'),
    ('213.016.020.000', 'FR'),
    ('213.016.032.000', 'BG'),
    ('213.016.064.000', 'HU'),
    ('213.016.128.000', 'GR'),
    ('213.017.000.000', 'NL'),
    ('213.017.128.000', 'PL'),
    ('213.018.000.000', 'GB'),
    ('213.019.000.000', 'FR'),
    ('213.019.128.000', 'NL'),
    ('213.019.131.000', 'IR'),
    ('213.019.132.000', 'NL'),
    ('213.019.134.000', 'IR'),
    ('213.019.135.000', 'NL'),
    ('213.019.141.000', 'IR'),
    ('213.019.142.000', 'NL'),
    ('213.019.148.000', 'IR'),
    ('213.019.160.000', 'NL'),
    ('213.019.164.000', 'IR'),
    ('213.019.168.000', 'NL'),
    ('213.020.000.000', 'DE'),
    ('213.020.240.000', 'FR'),
    ('213.020.241.000', 'DE'),
    ('213.021.128.000', 'IT'),
    ('213.021.192.000', 'LV'),
    ('213.022.000.000', 'PT'),
    ('213.023.000.000', 'DE'),
    ('213.023.128.000', 'EU'),
    ('213.024.000.000', 'RU'),
    ('213.025.000.000', 'PL'),
    ('213.026.000.000', 'IT'),
    ('213.027.000.000', 'GB'),
    ('213.028.000.000', 'FI'),
    ('213.028.121.000', 'RU'),
    ('213.028.122.000', 'FI'),
    ('213.029.000.000', 'IR'),
    ('213.030.000.000', 'PT'),
    ('213.030.128.000', 'FR'),
    ('213.030.192.000', 'DE'),
    ('213.031.000.000', 'BE'),
    ('213.031.009.000', 'ES'),
    ('213.031.011.000', 'BE'),
    ('213.031.012.000', 'FR'),
    ('213.031.013.000', 'BE'),
    ('213.031.192.000', 'NL'),
    ('213.031.196.000', 'BE'),
    ('213.031.200.000', 'GR'),
    ('213.031.201.000', 'BE'),
    ('213.031.205.000', 'AT'),
    ('213.031.206.000', 'BE'),
    ('213.032.000.000', 'DK'),
    ('213.033.000.000', 'AT'),
    ('213.033.104.000', 'LI'),
    ('213.033.105.000', 'AT'),
    ('213.033.128.000', 'RU'),
    ('213.034.000.000', 'NL'),
    ('213.035.060.000', 'BE'),
    ('213.035.065.000', 'NL'),
    ('213.035.128.000', 'EU'),
    ('213.036.000.000', 'FR'),
    ('213.036.239.000', 'ES'),
    ('213.038.000.000', 'GB'),
    ('213.038.222.000', 'US'),
    ('213.038.224.000', 'GB'),
    ('213.039.000.000', 'FR'),
    ('213.039.029.000', 'CH'),
    ('213.039.030.000', 'FR'),
    ('213.039.064.000', 'CH'),
    ('213.039.077.000', 'FR'),
    ('213.039.112.000', 'CH'),
    ('213.039.115.000', 'FR'),
    ('213.039.116.000', 'CH'),
    ('213.039.128.000', 'EU'),
    ('213.040.000.000', 'GB'),
    ('213.041.000.000', 'FR'),
    ('213.041.128.000', 'EU'),
    ('213.042.000.000', 'AE'),
    ('213.043.000.000', 'TR'),
    ('213.044.000.000', 'FR'),
    ('213.045.000.000', 'IT'),
    ('213.046.000.000', 'NL'),
    ('213.046.162.000', 'BE'),
    ('213.046.163.000', 'FR'),
    ('213.046.164.000', 'NL'),
    ('213.046.166.000', 'HU'),
    ('213.046.167.000', 'NL'),
    ('213.046.170.000', 'RO'),
    ('213.046.171.000', 'NL'),
    ('213.046.172.000', 'CZ'),
    ('213.046.173.000', 'AT'),
    ('213.046.174.000', 'GB'),
    ('213.046.175.000', 'NL'),
    ('213.046.176.000', 'SE'),
    ('213.046.177.000', 'NO'),
    ('213.046.178.000', 'PL'),
    ('213.046.179.000', 'DE'),
    ('213.046.180.000', 'NL'),
    ('213.046.226.000', 'AT'),
    ('213.046.228.000', 'SE'),
    ('213.046.230.000', 'GB'),
    ('213.046.231.000', 'NL'),
    ('213.046.237.000', 'GB'),
    ('213.046.238.000', 'NL'),
    ('213.047.000.000', 'AT'),
    ('213.048.000.000', 'GB'),
    ('213.049.000.000', 'EU'),
    ('213.049.001.000', 'BE'),
    ('213.049.045.000', 'EU'),
    ('213.050.000.000', 'SE'),
    ('213.051.000.000', 'NL'),
    ('213.052.000.000', 'ES'),
    ('213.052.128.000', 'GB'),
    ('213.053.000.000', 'NL'),
    ('213.054.000.000', 'DE'),
    ('213.055.000.000', 'GB'),
    ('213.055.064.000', 'ET'),
    ('213.055.128.000', 'CH'),
    ('213.056.000.000', 'FR'),
    ('213.056.194.000', 'US'),
    ('213.056.195.000', 'FR'),
    ('213.057.000.000', 'IL'),
    ('213.057.183.000', 'IT'),
    ('213.057.184.000', 'IL'),
    ('213.058.000.000', 'PT'),
    ('213.059.000.000', 'RU'),
    ('213.059.148.000', 'AM'),
    ('213.059.152.000', 'RU'),
    ('213.060.000.000', 'ES'),
    ('213.061.000.000', 'DE'),
    ('213.061.005.000', 'SE'),
    ('213.061.006.000', 'US'),
    ('213.061.007.000', 'DE'),
    ('213.062.002.000', 'CH'),
    ('213.062.004.000', 'DE'),
    ('213.062.009.000', 'HU'),
    ('213.062.010.000', 'FI'),
    ('213.062.011.000', 'EU'),
    ('213.062.012.000', 'DE'),
    ('213.062.013.000', 'EU'),
    ('213.062.014.000', 'TR'),
    ('213.062.015.000', 'DE'),
    ('213.062.016.000', 'EU'),
    ('213.062.032.000', 'GB'),
    ('213.062.041.000', 'EU'),
    ('213.062.042.000', 'GB'),
    ('213.062.053.000', 'EU'),
    ('213.062.054.000', 'GB'),
    ('213.062.064.000', 'FR'),
    ('213.062.066.000', 'CH'),
    ('213.062.068.000', 'FR'),
    ('213.062.072.000', 'CH'),
    ('213.062.080.000', 'EU'),
    ('213.062.092.000', 'CZ'),
    ('213.062.094.000', 'EU'),
    ('213.062.096.000', 'FR'),
    ('213.062.100.000', 'DE'),
    ('213.062.104.000', 'GB'),
    ('213.062.109.000', 'BE'),
    ('213.062.110.000', 'GB'),
    ('213.062.112.000', 'FR'),
    ('213.062.113.000', 'EU'),
    ('213.062.128.000', 'NL'),
    ('213.062.143.000', 'EU'),
    ('213.062.144.000', 'DK'),
    ('213.062.148.000', 'EU'),
    ('213.062.160.000', 'IT'),
    ('213.062.166.000', 'NO'),
    ('213.062.167.000', 'EU'),
    ('213.062.168.000', 'IT'),
    ('213.062.176.000', 'AT'),
    ('213.062.181.000', 'EU'),
    ('213.062.184.000', 'GB'),
    ('213.062.188.000', 'EU'),
    ('213.062.190.000', 'GB'),
    ('213.062.192.000', 'GR'),
    ('213.062.194.000', 'EU'),
    ('213.062.195.000', 'BE'),
    ('213.062.200.000', 'EU'),
    ('213.062.208.000', 'SE'),
    ('213.062.215.000', 'EU'),
    ('213.062.216.000', 'ES'),
    ('213.062.217.000', 'BE'),
    ('213.062.218.000', 'ES'),
    ('213.062.219.000', 'EU'),
    ('213.062.224.000', 'PL'),
    ('213.062.225.000', 'EU'),
    ('213.062.230.000', 'HU'),
    ('213.062.232.000', 'BE'),
    ('213.062.240.000', 'ZA'),
    ('213.062.242.000', 'DE'),
    ('213.062.248.000', 'NL'),
    ('213.063.000.000', 'PT'),
    ('213.064.000.000', 'SE'),
    ('213.068.000.000', 'DE'),
    ('213.069.241.000', 'CH'),
    ('213.069.242.000', 'DE'),
    ('213.072.000.000', 'GB'),
    ('213.073.000.000', 'DE'),
    ('213.073.032.000', 'ES'),
    ('213.073.064.000', 'DE'),
    ('213.073.128.000', 'NL'),
    ('213.074.000.000', 'TR'),
    ('213.075.000.000', 'NL'),
    ('213.076.000.000', 'PL'),
    ('213.078.000.000', 'GB'),
    ('213.079.000.000', 'DE'),
    ('213.079.032.000', 'EU'),
    ('213.079.128.000', 'SE'),
    ('213.080.128.000', 'RU'),
    ('213.081.000.000', 'GB'),
    ('213.081.128.000', 'SK'),
    ('213.082.000.000', 'IT'),
    ('213.083.000.000', 'DE'),
    ('213.083.064.000', 'EU'),
    ('213.084.000.000', 'NL'),
    ('213.085.000.000', 'RU'),
    ('213.085.057.000', 'BY'),
    ('213.085.058.000', 'RU'),
    ('213.085.128.000', 'EU'),
    ('213.086.000.000', 'GB'),
    ('213.087.000.000', 'RU'),
    ('213.088.000.000', 'IT'),
    ('213.088.128.000', 'SE'),
    ('213.088.184.000', 'NO'),
    ('213.088.189.000', 'SE'),
    ('213.088.190.000', 'NO'),
    ('213.088.192.000', 'SE'),
    ('213.090.000.000', 'AT'),
    ('213.090.072.000', 'US'),
    ('213.090.073.000', 'AT'),
    ('213.090.128.000', 'FR'),
    ('213.090.158.000', 'GB'),
    ('213.090.159.000', 'FR'),
    ('213.091.128.000', 'EU'),
    ('213.092.000.000', 'IT'),
    ('213.092.128.000', 'EU'),
    ('213.093.000.000', 'NL'),
    ('213.094.000.000', 'ES'),
    ('213.094.064.000', 'EU'),
    ('213.095.000.000', 'DE'),
    ('213.096.000.000', 'ES'),
    ('213.100.000.000', 'SE'),
    ('213.102.000.000', 'EU'),
    ('213.104.000.000', 'GB'),
    ('213.105.178.000', 'IE'),
    ('213.105.179.000', 'GB'),
    ('213.105.180.000', 'IE'),
    ('213.105.181.000', 'GB'),
    ('213.112.000.000', 'SE'),
    ('213.116.000.000', 'EU'),
    ('213.116.006.000', 'SE'),
    ('213.116.009.000', 'EU'),
    ('213.116.019.000', 'NL'),
    ('213.116.020.000', 'EU'),
    ('213.116.031.000', 'AT'),
    ('213.116.037.000', 'EU'),
    ('213.116.039.000', 'AT'),
    ('213.116.040.000', 'IE'),
    ('213.116.048.000', 'EU'),
    ('213.116.096.000', 'NL'),
    ('213.116.186.000', 'EU'),
    ('213.116.188.000', 'IE'),
    ('213.116.189.000', 'EU'),
    ('213.116.190.000', 'NL'),
    ('213.116.199.000', 'EU'),
    ('213.116.214.000', 'SE'),
    ('213.117.000.000', 'NL'),
    ('213.117.064.000', 'EU'),
    ('213.117.096.000', 'NL'),
    ('213.117.104.000', 'EU'),
    ('213.117.160.000', 'FR'),
    ('213.117.174.000', 'EU'),
    ('213.117.182.000', 'FR'),
    ('213.117.183.000', 'EU'),
    ('213.118.000.000', 'BE'),
    ('213.120.000.000', 'GB'),
    ('213.124.000.000', 'NL'),
    ('213.128.000.000', 'DE'),
    ('213.128.032.000', 'FR'),
    ('213.128.064.000', 'DE'),
    ('213.128.096.000', 'EU'),
    ('213.128.128.000', 'DE'),
    ('213.128.160.000', 'ES'),
    ('213.128.192.000', 'RU'),
    ('213.128.224.000', 'EU'),
    ('213.129.000.000', 'DK'),
    ('213.129.032.000', 'GB'),
    ('213.129.096.000', 'EU'),
    ('213.129.128.000', 'PT'),
    ('213.129.160.000', 'ES'),
    ('213.129.192.000', 'NL'),
    ('213.129.224.000', 'EU'),
    ('213.130.000.000', 'UA'),
    ('213.130.032.000', 'GB'),
    ('213.130.064.000', 'BG'),
    ('213.130.096.000', 'EU'),
    ('213.130.128.000', 'GB'),
    ('213.130.160.000', 'NL'),
    ('213.130.192.000', 'SE'),
    ('213.130.193.000', 'FI'),
    ('213.130.224.000', 'EU'),
    ('213.131.000.000', 'RU'),
    ('213.131.032.000', 'GE'),
    ('213.131.064.000', 'EG'),
    ('213.131.096.000', 'EU'),
    ('213.131.128.000', 'SE'),
    ('213.131.160.000', 'GB'),
    ('213.131.192.000', 'DE'),
    ('213.131.224.000', 'EU'),
    ('213.132.000.000', 'DK'),
    ('213.132.032.000', 'AE'),
    ('213.132.064.000', 'RU'),
    ('213.132.096.000', 'EU'),
    ('213.132.128.000', 'BE'),
    ('213.132.160.000', 'FR'),
    ('213.132.192.000', 'NL'),
    ('213.132.224.000', 'EU'),
    ('213.133.000.000', 'DK'),
    ('213.133.032.000', 'NL'),
    ('213.133.064.000', 'GB'),
    ('213.133.096.000', 'EU'),
    ('213.133.128.000', 'GB'),
    ('213.133.160.000', 'UA'),
    ('213.133.192.000', 'GB'),
    ('213.133.224.000', 'EU'),
    ('213.134.000.000', 'HU'),
    ('213.134.032.000', 'ES'),
    ('213.134.064.000', 'IT'),
    ('213.134.096.000', 'EU'),
    ('213.134.128.000', 'PL'),
    ('213.134.192.000', 'RU'),
    ('213.134.224.000', 'EU'),
    ('213.135.000.000', 'DE'),
    ('213.135.032.000', 'PL'),
    ('213.135.064.000', 'RU'),
    ('213.135.096.000', 'EU'),
    ('213.135.128.000', 'RU'),
    ('213.135.160.000', 'SE'),
    ('213.135.192.000', 'IT'),
    ('213.135.224.000', 'EU'),
    ('213.136.000.000', 'NL'),
    ('213.136.032.000', 'SE'),
    ('213.136.064.000', 'DE'),
    ('213.136.096.000', 'EU'),
    ('213.136.128.000', 'IT'),
    ('213.136.193.000', 'SA'),
    ('213.136.224.000', 'EU'),
    ('213.137.000.000', 'GB'),
    ('213.137.032.000', 'BG'),
    ('213.137.064.000', 'IL'),
    ('213.137.096.000', 'EU'),
    ('213.137.128.000', 'MC'),
    ('213.137.160.000', 'BE'),
    ('213.137.162.000', 'EU'),
    ('213.137.170.000', 'AT'),
    ('213.137.172.000', 'FR'),
    ('213.137.174.000', 'EU'),
    ('213.137.176.000', 'FR'),
    ('213.137.177.000', 'EU'),
    ('213.137.178.000', 'FR'),
    ('213.137.180.000', 'IE'),
    ('213.137.182.000', 'EU'),
    ('213.137.184.000', 'DE'),
    ('213.137.185.000', 'EU'),
    ('213.137.186.000', 'DE'),
    ('213.137.187.000', 'EU'),
    ('213.137.188.000', 'CH'),
    ('213.137.190.000', 'EU'),
    ('213.137.192.000', 'DE'),
    ('213.137.224.000', 'EU'),
    ('213.138.000.000', 'TR'),
    ('213.138.032.000', 'DE'),
    ('213.138.064.000', 'RU'),
    ('213.138.096.000', 'EU'),
    ('213.138.128.000', 'FI'),
    ('213.138.160.000', 'IT'),
    ('213.138.192.000', 'RU'),
    ('213.138.224.000', 'EU'),
    ('213.139.000.000', 'ES'),
    ('213.139.032.000', 'JO'),
    ('213.139.064.000', 'DE'),
    ('213.139.096.000', 'EU'),
    ('213.139.128.000', 'DE'),
    ('213.139.160.000', 'FI'),
    ('213.139.192.000', 'TR'),
    ('213.139.224.000', 'EU'),
    ('213.140.000.000', 'IT'),
    ('213.140.032.000', 'ES'),
    ('213.140.064.000', 'IT'),
    ('213.140.096.000', 'EU'),
    ('213.140.128.000', 'GR'),
    ('213.140.160.000', 'FI'),
    ('213.140.192.000', 'IT'),
    ('213.140.224.000', 'EU'),
    ('213.141.000.000', 'PT'),
    ('213.141.032.000', 'ES'),
    ('213.141.064.000', 'SE'),
    ('213.141.096.000', 'EU'),
    ('213.141.128.000', 'DK'),
    ('213.141.137.000', 'SE'),
    ('213.141.138.000', 'DK'),
    ('213.141.139.000', 'NO'),
    ('213.141.140.000', 'DK'),
    ('213.141.147.000', 'SE'),
    ('213.141.150.000', 'DK'),
    ('213.141.160.000', 'KZ'),
    ('213.141.192.000', 'RU'),
    ('213.141.224.000', 'EU'),
    ('213.142.000.000', 'SE'),
    ('213.142.012.000', 'DK'),
    ('213.142.016.000', 'SE'),
    ('213.142.032.000', 'AT'),
    ('213.142.064.000', 'NO'),
    ('213.142.096.000', 'EU'),
    ('213.142.128.000', 'GR'),
    ('213.142.160.000', 'CH'),
    ('213.142.192.000', 'RU'),
    ('213.142.224.000', 'EU'),
    ('213.143.000.000', 'GB'),
    ('213.143.032.000', 'ES'),
    ('213.143.064.000', 'SI'),
    ('213.143.096.000', 'EU'),
    ('213.143.128.000', 'GB'),
    ('213.143.160.000', 'FI'),
    ('213.143.192.000', 'DE'),
    ('213.143.224.000', 'EU'),
    ('213.144.000.000', 'DE'),
    ('213.144.032.000', 'ES'),
    ('213.144.064.000', 'IT'),
    ('213.144.096.000', 'EU'),
    ('213.144.128.000', 'CH'),
    ('213.144.160.000', 'IT'),
    ('213.144.224.000', 'EU'),
    ('213.145.000.000', 'IT'),
    ('213.145.032.000', 'RU'),
    ('213.145.064.000', 'DE'),
    ('213.145.096.000', 'EU'),
    ('213.145.128.000', 'KG'),
    ('213.145.160.000', 'NO'),
    ('213.145.192.000', 'ES'),
    ('213.145.224.000', 'EU'),
    ('213.146.000.000', 'CH'),
    ('213.146.032.000', 'PL'),
    ('213.146.064.000', 'SE'),
    ('213.146.096.000', 'EU'),
    ('213.146.128.000', 'GB'),
    ('213.146.160.000', 'DE'),
    ('213.146.189.000', 'CH'),
    ('213.146.190.000', 'DE'),
    ('213.146.192.000', 'PT'),
    ('213.146.224.000', 'EU'),
    ('213.147.000.000', 'DE'),
    ('213.147.032.000', 'RU'),
    ('213.147.064.000', 'KE'),
    ('213.147.096.000', 'EU'),
    ('213.147.128.000', 'RU'),
    ('213.147.160.000', 'AT'),
    ('213.147.224.000', 'EU'),
    ('213.148.000.000', 'RU'),
    ('213.148.032.000', 'GB'),
    ('213.148.064.000', 'TR'),
    ('213.148.096.000', 'EU'),
    ('213.148.128.000', 'DE'),
    ('213.148.160.000', 'RU'),
    ('213.148.192.000', 'GB'),
    ('213.148.224.000', 'EU'),
    ('213.149.000.000', 'PL'),
    ('213.149.032.000', 'HR'),
    ('213.149.064.000', 'DE'),
    ('213.149.096.000', 'EU'),
    ('213.149.128.000', 'ES'),
    ('213.149.160.000', 'CY'),
    ('213.149.192.000', 'NO'),
    ('213.149.224.000', 'EU'),
    ('213.150.000.000', 'AT'),
    ('213.150.032.000', 'DK'),
    ('213.150.064.000', 'RU'),
    ('213.150.096.000', 'EU'),
    ('213.150.128.000', 'SE'),
    ('213.150.160.000', 'TN'),
    ('213.150.192.000', 'ES'),
    ('213.150.224.000', 'EU'),
    ('213.151.000.000', 'IL'),
    ('213.151.032.000', 'BE'),
    ('213.151.064.000', 'CZ'),
    ('213.151.096.000', 'EU'),
    ('213.151.128.000', 'NO'),
    ('213.151.160.000', 'FR'),
    ('213.151.192.000', 'SK'),
    ('213.151.224.000', 'EU'),
    ('213.152.000.000', 'GR'),
    ('213.152.032.000', 'GB'),
    ('213.152.064.000', 'EG'),
    ('213.152.096.000', 'EU'),
    ('213.152.128.000', 'RU'),
    ('213.152.160.000', 'IT'),
    ('213.152.195.000', 'SM'),
    ('213.152.196.000', 'IT'),
    ('213.152.224.000', 'EU'),
    ('213.153.000.000', 'IE'),
    ('213.153.032.000', 'AT'),
    ('213.153.064.000', 'DE'),
    ('213.153.096.000', 'EU'),
    ('213.153.128.000', 'TR'),
    ('213.154.000.000', 'GB'),
    ('213.154.032.000', 'EG'),
    ('213.154.064.000', 'SN'),
    ('213.154.096.000', 'EU'),
    ('213.154.128.000', 'RO'),
    ('213.154.160.000', 'RU'),
    ('213.154.192.000', 'UA'),
    ('213.154.224.000', 'EU'),
    ('213.155.000.000', 'DE'),
    ('213.155.032.000', 'IR'),
    ('213.155.064.000', 'DE'),
    ('213.155.096.000', 'EU'),
    ('213.155.128.000', 'GB'),
    ('213.155.160.000', 'PL'),
    ('213.155.192.000', 'IT'),
    ('213.155.224.000', 'EU'),
    ('213.156.000.000', 'NL'),
    ('213.156.032.000', 'IT'),
    ('213.156.064.000', 'UA'),
    ('213.156.096.000', 'EU'),
    ('213.156.128.000', 'RU'),
    ('213.156.141.000', 'BY'),
    ('213.156.142.000', 'RU'),
    ('213.156.160.000', 'DE'),
    ('213.156.192.000', 'RU'),
    ('213.156.224.000', 'EU'),
    ('213.157.000.000', 'DE'),
    ('213.157.032.000', 'KZ'),
    ('213.157.064.000', 'FI'),
    ('213.157.066.000', 'DE'),
    ('213.157.068.000', 'FI'),
    ('213.157.069.000', 'DE'),
    ('213.157.096.000', 'EU'),
    ('213.157.128.000', 'AT'),
    ('213.157.160.000', 'RO'),
    ('213.157.180.000', 'HU'),
    ('213.157.182.000', 'RO'),
    ('213.157.192.000', 'GE'),
    ('213.157.224.000', 'EU'),
    ('213.158.000.000', 'RU'),
    ('213.158.032.000', 'AT'),
    ('213.158.064.000', 'IT'),
    ('213.158.096.000', 'EU'),
    ('213.158.128.000', 'CH'),
    ('213.158.160.000', 'EG'),
    ('213.158.192.000', 'PL'),
    ('213.158.224.000', 'EU'),
    ('213.159.000.000', 'NL'),
    ('213.159.032.000', 'TR'),
    ('213.159.064.000', 'RU'),
    ('213.159.096.000', 'EU'),
    ('213.159.128.000', 'IE'),
    ('213.159.160.000', 'DK'),
    ('213.159.192.000', 'IT'),
    ('213.159.224.000', 'EU'),
    ('213.160.000.000', 'DE'),
    ('213.160.032.000', 'CH'),
    ('213.160.064.000', 'DE'),
    ('213.160.096.000', 'EU'),
    ('213.160.128.000', 'UA'),
    ('213.160.160.000', 'SK'),
    ('213.160.192.000', 'DE'),
    ('213.160.193.000', 'NL'),
    ('213.160.195.000', 'GB'),
    ('213.160.197.000', 'NL'),
    ('213.160.198.000', 'GB'),
    ('213.160.200.000', 'NL'),
    ('213.160.201.000', 'AT'),
    ('213.160.202.000', 'NL'),
    ('213.160.203.000', 'GB'),
    ('213.160.204.000', 'NL'),
    ('213.160.205.000', 'GB'),
    ('213.160.207.000', 'NL'),
    ('213.160.208.000', 'SE'),
    ('213.160.209.000', 'GB'),
    ('213.160.210.000', 'SE'),
    ('213.160.211.000', 'NL'),
    ('213.160.214.000', 'GB'),
    ('213.160.215.000', 'NL'),
    ('213.160.216.000', 'GB'),
    ('213.160.220.000', 'AT'),
    ('213.160.221.000', 'GB'),
    ('213.160.223.000', 'AT'),
    ('213.160.224.000', 'EU'),
    ('213.161.000.000', 'SI'),
    ('213.161.032.000', 'FI'),
    ('213.161.064.000', 'GB'),
    ('213.161.078.000', 'IE'),
    ('213.161.079.000', 'GB'),
    ('213.161.096.000', 'EU'),
    ('213.161.128.000', 'TR'),
    ('213.161.160.000', 'NO'),
    ('213.161.192.000', 'FR'),
    ('213.161.224.000', 'EU'),
    ('213.162.000.000', 'CH'),
    ('213.162.032.000', 'FR'),
    ('213.162.064.000', 'AT'),
    ('213.162.096.000', 'EU'),
    ('213.162.128.000', 'SE'),
    ('213.162.160.000', 'NL'),
    ('213.162.192.000', 'ES'),
    ('213.162.224.000', 'EU'),
    ('213.163.000.000', 'HU'),
    ('213.163.064.000', 'GB'),
    ('213.163.096.000', 'EU'),
    ('213.163.128.000', 'SE'),
    ('213.163.160.000', 'FR'),
    ('213.163.192.000', 'GB'),
    ('213.163.224.000', 'EU'),
    ('213.164.000.000', 'AT'),
    ('213.164.032.000', 'ES'),
    ('213.164.064.000', 'DE'),
    ('213.164.096.000', 'EU'),
    ('213.164.128.000', 'DE'),
    ('213.164.160.000', 'ES'),
    ('213.164.192.000', 'BE'),
    ('213.164.224.000', 'EU'),
    ('213.165.000.000', 'GB'),
    ('213.165.032.000', 'SA'),
    ('213.165.064.000', 'DE'),
    ('213.165.096.000', 'EU'),
    ('213.165.128.000', 'GB'),
    ('213.165.160.000', 'MT'),
    ('213.165.192.000', 'RU'),
    ('213.165.224.000', 'EU'),
    ('213.166.000.000', 'GB'),
    ('213.166.032.000', 'LU'),
    ('213.166.064.000', 'GB'),
    ('213.166.096.000', 'EU'),
    ('213.166.128.000', 'SA'),
    ('213.166.160.000', 'DE'),
    ('213.166.192.000', 'FR'),
    ('213.166.224.000', 'EU'),
    ('213.167.000.000', 'FR'),
    ('213.167.032.000', 'RU'),
    ('213.167.064.000', 'GB'),
    ('213.167.070.000', 'US'),
    ('213.167.071.000', 'GB'),
    ('213.167.075.000', 'KY'),
    ('213.167.076.000', 'GB'),
    ('213.167.096.000', 'EU'),
    ('213.167.128.000', 'IS'),
    ('213.167.160.000', 'DE'),
    ('213.167.192.000', 'IT'),
    ('213.167.224.000', 'EU'),
    ('213.168.000.000', 'EE'),
    ('213.168.032.000', 'ES'),
    ('213.168.064.000', 'DE'),
    ('213.168.128.000', 'RU'),
    ('213.168.160.000', 'CZ'),
    ('213.168.192.000', 'DE'),
    ('213.168.224.000', 'EU'),
    ('213.169.000.000', 'FI'),
    ('213.169.032.000', 'BG'),
    ('213.169.064.000', 'UA'),
    ('213.169.096.000', 'EU'),
    ('213.169.128.000', 'CY'),
    ('213.169.160.000', 'FR'),
    ('213.169.192.000', 'NL'),
    ('213.170.000.000', 'GB'),
    ('213.170.032.000', 'ES'),
    ('213.170.033.000', 'GB'),
    ('213.170.034.000', 'ES'),
    ('213.170.035.000', 'GB'),
    ('213.170.036.000', 'ES'),
    ('213.170.040.000', 'GB'),
    ('213.170.041.000', 'ES'),
    ('213.170.048.000', 'CH'),
    ('213.170.052.000', 'NL'),
    ('213.170.053.000', 'GB'),
    ('213.170.054.000', 'CH'),
    ('213.170.056.000', 'ES'),
    ('213.170.058.000', 'NL'),
    ('213.170.059.000', 'ES'),
    ('213.170.062.000', 'GB'),
    ('213.170.064.000', 'RU'),
    ('213.170.096.000', 'EU'),
    ('213.170.128.000', 'GB'),
    ('213.170.160.000', 'DE'),
    ('213.170.192.000', 'GR'),
    ('213.170.224.000', 'EU'),
    ('213.171.000.000', 'DE'),
    ('213.171.032.000', 'RU'),
    ('213.171.064.000', 'NL'),
    ('213.171.096.000', 'EU'),
    ('213.171.128.000', 'NL'),
    ('213.171.160.000', 'IT'),
    ('213.171.192.000', 'GB'),
    ('213.171.224.000', 'EU'),
    ('213.172.000.000', 'RU'),
    ('213.172.032.000', 'ES'),
    ('213.172.064.000', 'AZ'),
    ('213.172.096.000', 'EU'),
    ('213.172.128.000', 'GH'),
    ('213.172.160.000', 'PL'),
    ('213.172.192.000', 'NO'),
    ('213.172.224.000', 'EU'),
    ('213.173.000.000', 'DE'),
    ('213.173.064.000', 'AT'),
    ('213.173.096.000', 'EU'),
    ('213.173.128.000', 'FI'),
    ('213.173.160.000', 'CH'),
    ('213.173.192.000', 'PL'),
    ('213.173.224.000', 'EU'),
    ('213.174.000.000', 'BG'),
    ('213.174.032.000', 'DE'),
    ('213.174.064.000', 'EU'),
    ('213.174.074.000', 'DK'),
    ('213.174.076.000', 'DE'),
    ('213.174.077.000', 'NL'),
    ('213.174.078.000', 'ES'),
    ('213.174.079.000', 'DE'),
    ('213.174.082.000', 'GB'),
    ('213.174.083.000', 'SE'),
    ('213.174.084.000', 'AT'),
    ('213.174.085.000', 'NL'),
    ('213.174.086.000', 'SE'),
    ('213.174.087.000', 'DK'),
    ('213.174.089.000', 'AT'),
    ('213.174.090.000', 'NL'),
    ('213.174.092.000', 'DK'),
    ('213.174.093.000', 'NL'),
    ('213.174.094.000', 'DK'),
    ('213.174.096.000', 'EU'),
    ('213.174.128.000', 'CH'),
    ('213.174.160.000', 'IT'),
    ('213.174.192.000', 'GB'),
    ('213.174.224.000', 'EU'),
    ('213.175.000.000', 'IT'),
    ('213.175.032.000', 'CZ'),
    ('213.175.064.000', 'LV'),
    ('213.175.128.000', 'AT'),
    ('213.175.160.000', 'LB'),
    ('213.175.192.000', 'GB'),
    ('213.175.224.000', 'EU'),
    ('213.176.000.000', 'IR'),
    ('213.176.128.000', 'IS'),
    ('213.176.160.000', 'ES'),
    ('213.176.192.000', 'DE'),
    ('213.176.224.000', 'EU'),
    ('213.177.000.000', 'GB'),
    ('213.177.002.000', 'CH'),
    ('213.177.032.000', 'GB'),
    ('213.177.064.000', 'BE'),
    ('213.177.096.000', 'EU'),
    ('213.177.128.000', 'BE'),
    ('213.177.192.000', 'GB'),
    ('213.177.211.000', 'DE'),
    ('213.177.212.000', 'GB'),
    ('213.177.217.000', 'NL'),
    ('213.177.218.000', 'GB'),
    ('213.177.219.000', 'NL'),
    ('213.177.220.000', 'GB'),
    ('213.177.224.000', 'EU'),
    ('213.178.000.000', 'DE'),
    ('213.178.032.000', 'IT'),
    ('213.178.064.000', 'DE'),
    ('213.178.096.000', 'EU'),
    ('213.178.128.000', 'GB'),
    ('213.178.160.000', 'DE'),
    ('213.178.192.000', 'IT'),
    ('213.178.224.000', 'EU'),
    ('213.179.000.000', 'SE'),
    ('213.179.032.000', 'NO'),
    ('213.179.064.000', 'DE'),
    ('213.179.096.000', 'EU'),
    ('213.179.128.000', 'DE'),
    ('213.179.160.000', 'DZ'),
    ('213.179.192.000', 'DE'),
    ('213.179.224.000', 'EU'),
    ('213.180.000.000', 'EE'),
    ('213.180.032.000', 'CZ'),
    ('213.180.064.000', 'SE'),
    ('213.180.096.000', 'EU'),
    ('213.180.128.000', 'PL'),
    ('213.180.160.000', 'CH'),
    ('213.180.192.000', 'RU'),
    ('213.180.224.000', 'EU'),
    ('213.181.000.000', 'RU'),
    ('213.181.032.000', 'BE'),
    ('213.181.056.000', 'DE'),
    ('213.181.057.000', 'EU'),
    ('213.181.058.000', 'BE'),
    ('213.181.064.000', 'NG'),
    ('213.181.096.000', 'EU'),
    ('213.181.128.000', 'BE'),
    ('213.181.129.000', 'NL'),
    ('213.181.132.000', 'BE'),
    ('213.181.134.000', 'NL'),
    ('213.181.136.000', 'BE'),
    ('213.181.141.000', 'NL'),
    ('213.181.142.000', 'BE'),
    ('213.181.143.000', 'NL'),
    ('213.181.144.000', 'BE'),
    ('213.181.145.000', 'NL'),
    ('213.181.146.000', 'BE'),
    ('213.181.147.000', 'NL'),
    ('213.181.152.000', 'BE'),
    ('213.181.153.000', 'LU'),
    ('213.181.156.000', 'BE'),
    ('213.181.157.000', 'NL'),
    ('213.181.160.000', 'SA'),
    ('213.181.192.000', 'PL'),
    ('213.181.224.000', 'EU'),
    ('213.182.000.000', 'DE'),
    ('213.182.032.000', 'FR'),
    ('213.182.064.000', 'GB'),
    ('213.182.096.000', 'EU'),
    ('213.182.128.000', 'DE'),
    ('213.182.160.000', 'RU'),
    ('213.182.192.000', 'LV'),
    ('213.182.224.000', 'EU'),
    ('213.183.000.000', 'DE'),
    ('213.183.032.000', 'IL'),
    ('213.183.064.000', 'DE'),
    ('213.183.096.000', 'EU'),
    ('213.183.128.000', 'IT'),
    ('213.183.160.000', 'DE'),
    ('213.183.224.000', 'EU'),
    ('213.184.000.000', 'PL'),
    ('213.184.032.000', 'EE'),
    ('213.184.064.000', 'RU'),
    ('213.184.096.000', 'EU'),
    ('213.184.128.000', 'RU'),
    ('213.184.160.000', 'SA'),
    ('213.184.192.000', 'NO'),
    ('213.184.224.000', 'EU'),
    ('213.185.000.000', 'IT'),
    ('213.185.032.000', 'FI'),
    ('213.185.064.000', 'DE'),
    ('213.185.096.000', 'EU'),
    ('213.185.128.000', 'DE'),
    ('213.185.160.000', 'AT'),
    ('213.185.192.000', 'GB'),
    ('213.185.224.000', 'HR'),
    ('213.186.000.000', 'GB'),
    ('213.186.032.000', 'FR'),
    ('213.186.064.000', 'PL'),
    ('213.186.096.000', 'EU'),
    ('213.186.128.000', 'TR'),
    ('213.186.160.000', 'JO'),
    ('213.186.192.000', 'UA'),
    ('213.186.224.000', 'EU'),
    ('213.187.000.000', 'DE'),
    ('213.187.032.000', 'GB'),
    ('213.187.064.000', 'DE'),
    ('213.187.096.000', 'EU'),
    ('213.187.128.000', 'NL'),
    ('213.187.133.000', 'SA'),
    ('213.187.135.000', 'NL'),
    ('213.187.160.000', 'NO'),
    ('213.187.192.000', 'SE'),
    ('213.187.224.000', 'EU'),
    ('213.188.000.000', 'NO'),
    ('213.188.032.000', 'CH'),
    ('213.188.064.000', 'FR'),
    ('213.188.096.000', 'EU'),
    ('213.188.128.000', 'NO'),
    ('213.188.160.000', 'FR'),
    ('213.188.192.000', 'IT'),
    ('213.188.224.000', 'EU'),
    ('213.189.000.000', 'NL'),
    ('213.189.032.000', 'IL'),
    ('213.189.064.000', 'KW'),
    ('213.189.096.000', 'EU'),
    ('213.189.128.000', 'CH'),
    ('213.189.160.000', 'BE'),
    ('213.189.192.000', 'RU'),
    ('213.189.224.000', 'EU'),
    ('213.190.032.000', 'LT'),
    ('213.190.064.000', 'FR'),
    ('213.190.096.000', 'EU'),
    ('213.190.128.000', 'IE'),
    ('213.190.160.000', 'SE'),
    ('213.190.192.000', 'PT'),
    ('213.190.224.000', 'EU'),
    ('213.191.000.000', 'DE'),
    ('213.191.096.000', 'EU'),
    ('213.191.128.000', 'HR'),
    ('213.191.160.000', 'EU'),
    ('213.191.161.000', 'ER'),
    ('213.191.162.000', 'EU'),
    ('213.191.192.000', 'BG'),
    ('213.191.224.000', 'EU'),
    ('213.192.000.000', 'IT'),
    ('213.192.064.000', 'PL'),
    ('213.192.128.000', 'FI'),
    ('213.192.192.000', 'EU'),
    ('213.193.000.000', 'FR'),
    ('213.193.018.000', 'DE'),
    ('213.193.027.000', 'FR'),
    ('213.193.032.000', 'ZM'),
    ('213.193.034.000', 'KE'),
    ('213.193.064.000', 'CH'),
    ('213.193.128.000', 'BE'),
    ('213.193.192.000', 'EU'),
    ('213.194.000.000', 'NL'),
    ('213.194.064.000', 'TR'),
    ('213.194.128.000', 'ES'),
    ('213.194.192.000', 'EU'),
    ('213.195.000.000', 'FR'),
    ('213.195.064.000', 'ES'),
    ('213.195.128.000', 'PL'),
    ('213.195.192.000', 'EU'),
    ('213.196.000.000', 'NL'),
    ('213.196.064.000', 'DE'),
    ('213.196.128.000', 'CH'),
    ('213.196.192.000', 'EU'),
    ('213.197.000.000', 'NL'),
    ('213.197.064.000', 'HU'),
    ('213.197.128.000', 'LT'),
    ('213.197.160.000', 'EU'),
    ('213.198.000.000', 'DE'),
    ('213.198.128.000', 'IT'),
    ('213.198.192.000', 'EU'),
    ('213.199.000.000', 'IT'),
    ('213.199.032.000', 'EU'),
    ('213.199.064.000', 'SE'),
    ('213.199.128.000', 'GB'),
    ('213.199.192.000', 'EU'),
    ('213.200.000.000', 'CH'),
    ('213.200.032.000', 'UA'),
    ('213.200.064.000', 'DE'),
    ('213.200.092.000', 'US'),
    ('213.200.093.000', 'DE'),
    ('213.200.128.000', 'SE'),
    ('213.200.192.000', 'EU'),
    ('213.201.000.000', 'ES'),
    ('213.201.128.000', 'NL'),
    ('213.201.192.000', 'EU'),
    ('213.202.000.000', 'TR'),
    ('213.202.032.000', 'CH'),
    ('213.202.064.000', 'HR'),
    ('213.202.128.000', 'IE'),
    ('213.202.192.000', 'EU'),
    ('213.203.000.000', 'NO'),
    ('213.203.064.000', 'FR'),
    ('213.203.128.000', 'IT'),
    ('213.203.192.000', 'EU'),
    ('213.204.000.000', 'IT'),
    ('213.204.032.000', 'FI'),
    ('213.204.064.000', 'TR'),
    ('213.204.128.000', 'SE'),
    ('213.204.192.000', 'EU'),
    ('213.205.000.000', 'IT'),
    ('213.205.064.000', 'PT'),
    ('213.205.096.000', 'EU'),
    ('213.205.128.000', 'GB'),
    ('213.205.192.000', 'EU'),
    ('213.206.000.000', 'GB'),
    ('213.206.014.000', 'DE'),
    ('213.206.017.000', 'GB'),
    ('213.206.018.000', 'NL'),
    ('213.206.021.000', 'GB'),
    ('213.206.022.000', 'FR'),
    ('213.206.025.000', 'GB'),
    ('213.206.032.000', 'DE'),
    ('213.206.064.000', 'NL'),
    ('213.206.128.000', 'GB'),
    ('213.206.160.000', 'EU'),
    ('213.207.000.000', 'NL'),
    ('213.207.064.000', 'CH'),
    ('213.207.128.000', 'CY'),
    ('213.207.192.000', 'EU'),
    ('213.208.000.000', 'AT'),
    ('213.208.032.000', 'DE'),
    ('213.208.033.000', 'KZ'),
    ('213.208.034.000', 'DE'),
    ('213.208.062.000', 'GB'),
    ('213.208.128.000', 'AT'),
    ('213.208.160.000', 'EU'),
    ('213.209.000.000', 'IT'),
    ('213.209.064.000', 'DE'),
    ('213.209.160.000', 'EU'),
    ('213.210.000.000', 'GB'),
    ('213.210.064.000', 'RU'),
    ('213.210.128.000', 'CZ'),
    ('213.210.192.000', 'EU'),
    ('213.211.000.000', 'ES'),
    ('213.211.032.000', 'EU'),
    ('213.211.064.000', 'KZ'),
    ('213.211.128.000', 'NL'),
    ('213.211.192.000', 'EU'),
    ('213.212.000.000', 'SE'),
    ('213.212.064.000', 'GB'),
    ('213.212.128.000', 'IT'),
    ('213.212.192.000', 'EU'),
    ('213.213.000.000', 'IT'),
    ('213.213.128.000', 'IS'),
    ('213.213.160.000', 'EU'),
    ('213.214.000.000', 'DE'),
    ('213.214.032.000', 'EU'),
    ('213.214.064.000', 'IT'),
    ('213.214.128.000', 'FI'),
    ('213.214.192.000', 'EU'),
    ('213.215.000.000', 'FR'),
    ('213.215.064.000', 'SK'),
    ('213.215.128.000', 'IT'),
    ('213.215.192.000', 'EU'),
    ('213.216.000.000', 'DE'),
    ('213.216.032.000', 'EU'),
    ('213.216.064.000', 'PL'),
    ('213.216.128.000', 'CH'),
    ('213.216.131.000', 'GB'),
    ('213.216.132.000', 'CH'),
    ('213.216.138.000', 'GB'),
    ('213.216.141.000', 'CH'),
    ('213.216.142.000', 'GB'),
    ('213.216.145.000', 'CH'),
    ('213.216.147.000', 'GB'),
    ('213.216.148.000', 'CH'),
    ('213.216.192.000', 'EU'),
    ('213.217.000.000', 'DE'),
    ('213.217.032.000', 'IR'),
    ('213.217.064.000', 'DE'),
    ('213.217.128.000', 'IT'),
    ('213.217.192.000', 'EU'),
    ('213.218.000.000', 'DE'),
    ('213.218.032.000', 'IT'),
    ('213.218.064.000', 'NL'),
    ('213.218.080.000', 'CH'),
    ('213.218.128.000', 'DE'),
    ('213.218.160.000', 'EU'),
    ('213.219.000.000', 'GB'),
    ('213.219.064.000', 'EE'),
    ('213.219.128.000', 'BE'),
    ('213.219.144.000', 'GB'),
    ('213.219.145.000', 'BE'),
    ('213.219.192.000', 'EU'),
    ('213.220.000.000', 'ES'),
    ('213.220.064.000', 'IS'),
    ('213.220.128.000', 'DE'),
    ('213.220.192.000', 'EU'),
    ('213.221.000.000', 'RU'),
    ('213.221.032.000', 'FR'),
    ('213.221.033.000', 'RU'),
    ('213.221.064.000', 'DE'),
    ('213.221.128.000', 'CH'),
    ('213.221.160.000', 'GB'),
    ('213.221.192.000', 'EU'),
    ('213.222.000.000', 'NL'),
    ('213.222.032.000', 'BG'),
    ('213.222.064.000', 'FR'),
    ('213.222.128.000', 'HU'),
    ('213.222.192.000', 'EU'),
    ('213.223.000.000', 'FR'),
    ('213.224.000.000', 'BE'),
    ('213.225.000.000', 'AT'),
    ('213.225.064.000', 'NO'),
    ('213.225.128.000', 'GB'),
    ('213.225.160.000', 'FR'),
    ('213.225.192.000', 'EU'),
    ('213.226.000.000', 'BG'),
    ('213.226.032.000', 'EU'),
    ('213.226.064.000', 'SE'),
    ('213.226.128.000', 'LT'),
    ('213.226.160.000', 'EU'),
    ('213.227.000.000', 'ES'),
    ('213.227.064.000', 'PL'),
    ('213.227.128.000', 'NL'),
    ('213.227.160.000', 'EU'),
    ('213.228.000.000', 'FR'),
    ('213.228.064.000', 'RU'),
    ('213.228.128.000', 'PT'),
    ('213.228.192.000', 'EU'),
    ('213.229.000.000', 'AT'),
    ('213.229.064.000', 'NL'),
    ('213.229.088.000', 'GB'),
    ('213.229.128.000', 'ES'),
    ('213.229.192.000', 'EU'),
    ('213.230.000.000', 'SA'),
    ('213.230.032.000', 'CH'),
    ('213.230.064.000', 'GB'),
    ('213.230.128.000', 'IT'),
    ('213.230.160.000', 'NO'),
    ('213.230.192.000', 'EU'),
    ('213.231.000.000', 'PL'),
    ('213.231.064.000', 'ES'),
    ('213.231.192.000', 'EU'),
    ('213.232.000.000', 'TR'),
    ('213.232.064.000', 'GB'),
    ('213.232.096.000', 'FR'),
    ('213.232.097.000', 'GB'),
    ('213.232.128.000', 'CH'),
    ('213.232.192.000', 'EU'),
    ('213.233.000.000', 'IT'),
    ('213.233.064.000', 'RO'),
    ('213.233.128.000', 'IE'),
    ('213.233.160.000', 'EU'),
    ('213.234.000.000', 'ES'),
    ('213.234.032.000', 'GB'),
    ('213.234.064.000', 'NO'),
    ('213.234.128.000', 'IT'),
    ('213.234.192.000', 'EU'),
    ('213.235.000.000', 'GB'),
    ('213.235.012.000', 'IE'),
    ('213.235.013.000', 'GB'),
    ('213.235.038.000', 'IE'),
    ('213.235.040.000', 'GB'),
    ('213.235.064.000', 'EU'),
    ('213.235.128.000', 'CZ'),
    ('213.235.192.000', 'EU'),
    ('213.236.000.000', 'ES'),
    ('213.236.032.000', 'TR'),
    ('213.236.064.000', 'NL'),
    ('213.236.128.000', 'NO'),
    ('213.237.000.000', 'DK'),
    ('213.237.192.000', 'EU'),
    ('213.238.000.000', 'SA'),
    ('213.238.032.000', 'DE'),
    ('213.238.064.000', 'PL'),
    ('213.238.128.000', 'TR'),
    ('213.238.192.000', 'EU'),
    ('213.239.000.000', 'IT'),
    ('213.239.001.000', 'SE'),
    ('213.239.002.000', 'IE'),
    ('213.239.003.000', 'ES'),
    ('213.239.004.000', 'GB'),
    ('213.239.008.000', 'CH'),
    ('213.239.009.000', 'NL'),
    ('213.239.010.000', 'GB'),
    ('213.239.013.000', 'FR'),
    ('213.239.014.000', 'GB'),
    ('213.239.016.000', 'NL'),
    ('213.239.017.000', 'CH'),
    ('213.239.018.000', 'GB'),
    ('213.239.020.000', 'CH'),
    ('213.239.022.000', 'ES'),
    ('213.239.023.000', 'DE'),
    ('213.239.024.000', 'GB'),
    ('213.239.054.000', 'NL'),
    ('213.239.056.000', 'GB'),
    ('213.239.062.000', 'CH'),
    ('213.239.064.000', 'NO'),
    ('213.239.128.000', 'NL'),
    ('213.239.192.000', 'EU'),
    ('213.240.000.000', 'YU'),
    ('213.240.064.000', 'CH'),
    ('213.240.128.000', 'DE'),
    ('213.240.192.000', 'EU'),
    ('213.241.000.000', 'PL'),
    ('213.241.128.000', 'DE'),
    ('213.242.000.000', 'RU'),
    ('213.242.064.000', 'FR'),
    ('213.242.128.000', 'SE'),
    ('213.242.192.000', 'EU'),
    ('213.243.000.000', 'TR'),
    ('213.243.064.000', 'RU'),
    ('213.243.128.000', 'FI'),
    ('213.243.192.000', 'EU'),
    ('213.244.000.000', 'FR'),
    ('213.244.032.000', 'EU'),
    ('213.244.064.000', 'PS'),
    ('213.244.128.000', 'NL'),
    ('213.244.179.000', 'US'),
    ('213.244.180.000', 'NL'),
    ('213.244.184.000', 'CA'),
    ('213.244.188.000', 'NL'),
    ('213.244.192.000', 'EU'),
    ('213.245.000.000', 'FR'),
    ('213.246.000.000', 'IT'),
    ('213.246.032.000', 'FR'),
    ('213.246.064.000', 'CZ'),
    ('213.246.128.000', 'GB'),
    ('213.246.192.000', 'EU'),
    ('213.247.000.000', 'EG'),
    ('213.247.032.000', 'EU'),
    ('213.247.064.000', 'IL'),
    ('213.247.106.000', 'FR'),
    ('213.247.128.000', 'RU'),
    ('213.247.192.000', 'EU'),
    ('213.248.000.000', 'RU'),
    ('213.248.030.000', 'SZ'),
    ('213.248.032.000', 'EU'),
    ('213.248.106.000', 'SE'),
    ('213.248.108.000', 'HU'),
    ('213.248.109.000', 'EU'),
    ('213.248.110.000', 'FR'),
    ('213.248.111.000', 'EU'),
    ('213.248.112.000', 'SE'),
    ('213.248.113.000', 'EU'),
    ('213.248.114.000', 'GB'),
    ('213.248.115.000', 'EU'),
    ('213.248.118.000', 'GB'),
    ('213.248.120.000', 'DE'),
    ('213.248.122.000', 'EU'),
    ('213.248.128.000', 'TR'),
    ('213.248.192.000', 'EU'),
    ('213.249.000.000', 'GR'),
    ('213.249.064.000', 'BE'),
    ('213.249.128.000', 'GB'),
    ('213.249.192.000', 'EU'),
    ('213.250.000.000', 'SI'),
    ('213.250.064.000', 'FI'),
    ('213.250.128.000', 'ES'),
    ('213.250.192.000', 'EU'),
    ('213.251.000.000', 'NL'),
    ('213.251.064.000', 'BE'),
    ('213.251.128.000', 'GB'),
    ('213.251.192.000', 'EU'),
    ('213.252.000.000', 'DE'),
    ('213.252.064.000', 'RU'),
    ('213.252.128.000', 'DE'),
    ('213.252.192.000', 'EU'),
    ('213.253.000.000', 'GB'),
    ('213.253.064.000', 'SI'),
    ('213.253.068.000', 'HR'),
    ('213.253.069.000', 'SI'),
    ('213.253.128.000', 'GB'),
    ('213.253.192.000', 'HU'),
    ('213.254.000.000', 'IT'),
    ('213.254.032.000', 'DE'),
    ('213.254.064.000', 'ES'),
    ('213.254.128.000', 'TR'),
    ('213.254.160.000', 'GB'),
    ('213.254.192.000', 'EU'),
    ('213.255.000.000', 'IT'),
    ('213.255.128.000', 'EG'),
    ('213.255.160.000', 'EU'),
    ('214.000.000.000', 'US'),
    ('216.000.048.000', 'ZA'),
    ('216.000.049.000', 'US'),
    ('216.000.050.000', 'ZA'),
    ('216.000.051.000', 'US'),
    ('216.000.052.000', 'ZA'),
    ('216.000.054.000', 'US'),
    ('216.002.176.000', 'ZA'),
    ('216.002.184.000', 'US'),
    ('216.004.160.000', 'ZA'),
    ('216.004.164.000', 'US'),
    ('216.005.000.000', 'ZA'),
    ('216.005.008.000', 'US'),
    ('216.005.192.000', 'ZA'),
    ('216.005.200.000', 'US'),
    ('216.006.000.000', 'CR'),
    ('216.006.001.000', 'LK'),
    ('216.006.002.000', 'US'),
    ('216.006.003.000', 'DZ'),
    ('216.006.004.000', 'MX'),
    ('216.006.005.000', 'US'),
    ('216.006.008.000', 'CA'),
    ('216.006.012.000', 'MX'),
    ('216.006.014.000', 'CA'),
    ('216.006.016.000', 'US'),
    ('216.006.017.000', 'EG'),
    ('216.006.018.000', 'BO'),
    ('216.006.020.000', 'US'),
    ('216.006.021.000', 'PR'),
    ('216.006.022.000', 'GH'),
    ('216.006.023.000', 'US'),
    ('216.006.024.000', 'TZ'),
    ('216.006.028.000', 'MX'),
    ('216.006.030.000', 'CA'),
    ('216.006.031.000', 'US'),
    ('216.006.034.000', 'PA'),
    ('216.006.036.000', 'US'),
    ('216.006.037.000', 'CA'),
    ('216.006.038.000', 'EG'),
    ('216.006.040.000', 'CA'),
    ('216.006.042.000', 'US'),
    ('216.006.043.000', 'CA'),
    ('216.006.048.000', 'US'),
    ('216.006.050.000', 'GH'),
    ('216.006.052.000', 'AN'),
    ('216.006.053.000', 'LK'),
    ('216.006.054.000', 'CA'),
    ('216.006.057.000', 'AR'),
    ('216.006.058.000', 'US'),
    ('216.006.060.000', 'GH'),
    ('216.006.062.000', 'CA'),
    ('216.006.063.000', 'US'),
    ('216.006.064.000', 'CO'),
    ('216.006.088.000', 'PE'),
    ('216.006.092.000', 'CO'),
    ('216.006.094.000', 'US'),
    ('216.006.095.000', 'IN'),
    ('216.006.096.000', 'AM'),
    ('216.006.097.000', 'US'),
    ('216.006.098.000', 'CA'),
    ('216.006.100.000', 'CO'),
    ('216.006.104.000', 'PH'),
    ('216.006.108.000', 'PR'),
    ('216.006.109.000', 'DZ'),
    ('216.006.110.000', 'LY'),
    ('216.006.111.000', 'GD'),
    ('216.006.112.000', 'CA'),
    ('216.006.116.000', 'GD'),
    ('216.006.117.000', 'MX'),
    ('216.006.118.000', 'US'),
    ('216.006.121.000', 'AN'),
    ('216.006.122.000', 'US'),
    ('216.006.124.000', 'CA'),
    ('216.006.125.000', 'US'),
    ('216.006.192.000', 'CA'),
    ('216.006.208.000', '--'),
    ('216.007.000.000', 'US'),
    ('216.007.192.000', 'CA'),
    ('216.007.224.000', '--'),
    ('216.008.000.000', 'US'),
    ('216.008.128.000', 'CA'),
    ('216.008.192.000', '--'),
    ('216.009.000.000', 'US'),
    ('216.013.000.000', 'CA'),
    ('216.013.035.000', 'US'),
    ('216.013.036.000', 'CA'),
    ('216.013.138.000', 'US'),
    ('216.013.139.000', 'CA'),
    ('216.013.183.000', 'US'),
    ('216.013.184.000', 'CA'),
    ('216.013.197.000', 'US'),
    ('216.013.200.000', 'CA'),
    ('216.014.000.000', 'US'),
    ('216.014.192.000', 'JP'),
    ('216.014.208.000', '--'),
    ('216.014.224.000', 'US'),
    ('216.014.240.000', '--'),
    ('216.015.000.000', 'US'),
    ('216.015.131.000', 'DE'),
    ('216.015.132.000', 'US'),
    ('216.015.133.000', 'GB'),
    ('216.015.134.000', 'IN'),
    ('216.015.135.000', 'US'),
    ('216.015.138.000', 'IN'),
    ('216.015.139.000', 'US'),
    ('216.015.150.000', 'DE'),
    ('216.015.151.000', 'US'),
    ('216.015.157.000', 'IN'),
    ('216.015.158.000', 'US'),
    ('216.015.160.000', 'DE'),
    ('216.015.161.000', 'US'),
    ('216.015.177.000', 'TW'),
    ('216.015.178.000', 'US'),
    ('216.015.179.000', 'IN'),
    ('216.015.180.000', 'MY'),
    ('216.015.181.000', 'TW'),
    ('216.015.182.000', 'US'),
    ('216.015.185.000', 'IN'),
    ('216.015.186.000', 'TW'),
    ('216.015.187.000', 'MY'),
    ('216.015.188.000', 'US'),
    ('216.015.192.000', 'GB'),
    ('216.015.193.000', 'US'),
    ('216.015.199.000', 'MY'),
    ('216.015.200.000', 'US'),
    ('216.015.203.000', 'CA'),
    ('216.015.204.000', 'US'),
    ('216.015.207.000', 'BE'),
    ('216.015.208.000', 'US'),
    ('216.015.209.000', 'CA'),
    ('216.015.210.000', 'US'),
    ('216.015.215.000', 'IN'),
    ('216.015.216.000', 'US'),
    ('216.015.220.000', 'KW'),
    ('216.015.221.000', 'US'),
    ('216.015.222.000', 'CA'),
    ('216.015.223.000', 'HK'),
    ('216.015.224.000', 'US'),
    ('216.015.225.000', 'CA'),
    ('216.015.227.000', 'US'),
    ('216.015.228.000', 'CA'),
    ('216.015.232.000', 'IN'),
    ('216.015.233.000', 'US'),
    ('216.015.234.000', 'CA'),
    ('216.015.236.000', 'DK'),
    ('216.015.237.000', 'IN'),
    ('216.015.238.000', 'US'),
    ('216.015.239.000', 'IN'),
    ('216.015.240.000', 'CA'),
    ('216.015.243.000', 'US'),
    ('216.015.245.000', 'CA'),
    ('216.015.246.000', 'US'),
    ('216.015.248.000', 'CA'),
    ('216.015.250.000', 'US'),
    ('216.015.254.000', 'CA'),
    ('216.015.255.000', 'US'),
    ('216.016.208.000', '--'),
    ('216.016.224.000', 'CA'),
    ('216.016.240.000', '--'),
    ('216.017.000.000', 'US'),
    ('216.018.000.000', 'CA'),
    ('216.018.128.000', 'US'),
    ('216.019.064.000', 'CA'),
    ('216.019.080.000', '--'),
    ('216.019.096.000', 'US'),
    ('216.021.128.000', 'CA'),
    ('216.021.160.000', 'US'),
    ('216.021.176.000', '--'),
    ('216.021.192.000', 'US'),
    ('216.022.172.000', 'NL'),
    ('216.022.173.000', 'US'),
    ('216.022.221.000', 'TH'),
    ('216.022.223.000', 'US'),
    ('216.023.128.000', 'CA'),
    ('216.023.133.000', 'US'),
    ('216.023.135.000', 'CA'),
    ('216.023.143.000', 'US'),
    ('216.023.145.000', 'CA'),
    ('216.023.155.000', 'US'),
    ('216.026.096.000', 'CA'),
    ('216.026.128.000', 'US'),
    ('216.026.192.000', 'CA'),
    ('216.026.224.000', '--'),
    ('216.027.000.000', 'US'),
    ('216.036.128.000', 'CA'),
    ('216.036.192.000', 'US'),
    ('216.038.000.000', 'CA'),
    ('216.038.032.000', 'US'),
    ('216.046.000.000', 'CA'),
    ('216.046.032.000', 'US'),
    ('216.046.128.000', 'CA'),
    ('216.046.160.000', 'US'),
    ('216.048.144.000', '--'),
    ('216.048.160.000', 'CA'),
    ('216.048.176.000', '--'),
    ('216.048.192.000', 'US'),
    ('216.052.224.000', 'PH'),
    ('216.052.226.000', 'US'),
    ('216.053.187.000', 'GE'),
    ('216.053.188.000', 'US'),
    ('216.053.191.000', 'GE'),
    ('216.053.192.000', 'US'),
    ('216.055.192.000', 'CA'),
    ('216.056.000.000', 'US'),
    ('216.057.006.000', 'CA'),
    ('216.057.008.000', 'US'),
    ('216.057.012.000', 'CA'),
    ('216.057.014.000', 'US'),
    ('216.057.056.000', 'CA'),
    ('216.057.060.000', 'US'),
    ('216.057.064.000', '--'),
    ('216.057.128.000', 'US'),
    ('216.057.240.000', '--'),
    ('216.058.000.000', 'CA'),
    ('216.058.128.000', 'US'),
    ('216.060.122.000', 'IS'),
    ('216.060.123.000', 'US'),
    ('216.065.001.000', 'GB'),
    ('216.065.002.000', 'US'),
    ('216.065.004.000', 'RU'),
    ('216.065.005.000', 'US'),
    ('216.065.006.000', 'TW'),
    ('216.065.007.000', 'US'),
    ('216.065.024.000', 'PR'),
    ('216.065.025.000', 'US'),
    ('216.065.026.000', 'RU'),
    ('216.065.027.000', 'US'),
    ('216.065.029.000', 'AU'),
    ('216.065.030.000', 'US'),
    ('216.065.043.000', 'PR'),
    ('216.065.044.000', 'US'),
    ('216.065.046.000', 'IL'),
    ('216.065.047.000', 'US'),
    ('216.065.050.000', 'FI'),
    ('216.065.051.000', 'CA'),
    ('216.065.052.000', 'US'),
    ('216.065.054.000', 'TW'),
    ('216.065.055.000', 'US'),
    ('216.065.075.000', 'GB'),
    ('216.065.076.000', 'US'),
    ('216.065.077.000', 'CA'),
    ('216.065.078.000', 'TW'),
    ('216.065.079.000', 'US'),
    ('216.065.080.000', 'RU'),
    ('216.065.081.000', 'GB'),
    ('216.065.082.000', 'US'),
    ('216.065.084.000', 'CA'),
    ('216.065.085.000', 'US'),
    ('216.065.088.000', 'CA'),
    ('216.065.089.000', 'US'),
    ('216.065.104.000', 'RU'),
    ('216.065.105.000', 'US'),
    ('216.065.107.000', 'SZ'),
    ('216.065.108.000', 'US'),
    ('216.065.109.000', 'CA'),
    ('216.065.110.000', 'US'),
    ('216.065.117.000', 'QA'),
    ('216.065.118.000', 'US'),
    ('216.065.119.000', 'GB'),
    ('216.065.120.000', 'QA'),
    ('216.065.121.000', 'US'),
    ('216.065.126.000', 'PR'),
    ('216.065.127.000', 'US'),
    ('216.065.197.000', 'CA'),
    ('216.065.198.000', 'US'),
    ('216.065.199.000', 'CA'),
    ('216.065.201.000', 'US'),
    ('216.065.224.000', '--'),
    ('216.066.000.000', 'US'),
    ('216.066.128.000', 'CA'),
    ('216.067.000.000', 'US'),
    ('216.072.004.000', 'CO'),
    ('216.072.008.000', 'CL'),
    ('216.072.024.000', 'CU'),
    ('216.072.028.000', 'GT'),
    ('216.072.032.000', 'IL'),
    ('216.072.044.000', 'VE'),
    ('216.072.046.000', 'US'),
    ('216.072.047.000', 'CO'),
    ('216.072.063.000', 'HN'),
    ('216.072.064.000', 'ID'),
    ('216.072.067.000', 'CO'),
    ('216.072.069.000', 'US'),
    ('216.072.070.000', 'IL'),
    ('216.072.072.000', 'US'),
    ('216.072.074.000', 'PR'),
    ('216.072.078.000', 'HN'),
    ('216.072.079.000', 'CO'),
    ('216.072.082.000', 'HN'),
    ('216.072.088.000', 'VE'),
    ('216.072.089.000', 'VN'),
    ('216.072.092.000', 'VE'),
    ('216.072.093.000', 'VN'),
    ('216.072.096.000', 'US'),
    ('216.072.100.000', 'PR'),
    ('216.072.104.000', 'NG'),
    ('216.072.112.000', 'PA'),
    ('216.072.113.000', 'HN'),
    ('216.072.116.000', 'CO'),
    ('216.072.117.000', 'IL'),
    ('216.072.118.000', 'HN'),
    ('216.072.119.000', 'SV'),
    ('216.072.124.000', 'GT'),
    ('216.072.125.000', 'US'),
    ('216.072.127.000', 'VE'),
    ('216.072.129.000', 'VN'),
    ('216.072.132.000', 'VE'),
    ('216.072.135.000', 'CO'),
    ('216.072.144.000', 'AR'),
    ('216.072.152.000', 'VE'),
    ('216.072.156.000', 'CO'),
    ('216.072.158.000', 'VE'),
    ('216.072.160.000', 'CL'),
    ('216.072.192.000', 'US'),
    ('216.072.194.000', 'HN'),
    ('216.072.196.000', 'SZ'),
    ('216.072.197.000', 'CO'),
    ('216.072.205.000', 'US'),
    ('216.072.213.000', 'CO'),
    ('216.072.222.000', 'PA'),
    ('216.072.224.000', 'US'),
    ('216.072.225.000', 'CR'),
    ('216.072.226.000', 'VE'),
    ('216.072.227.000', 'CO'),
    ('216.072.231.000', 'EC'),
    ('216.072.232.000', 'CO'),
    ('216.072.235.000', 'US'),
    ('216.072.236.000', 'VE'),
    ('216.072.237.000', 'BS'),
    ('216.072.238.000', 'US'),
    ('216.075.096.000', '--'),
    ('216.075.128.000', 'US'),
    ('216.075.160.000', 'CA'),
    ('216.075.176.000', '--'),
    ('216.075.192.000', 'US'),
    ('216.075.208.000', '--'),
    ('216.076.000.000', 'US'),
    ('216.081.000.000', 'CA'),
    ('216.081.032.000', 'US'),
    ('216.081.048.000', '--'),
    ('216.081.064.000', 'US'),
    ('216.083.000.000', 'CA'),
    ('216.083.032.000', 'US'),
    ('216.083.048.000', '--'),
    ('216.083.064.000', 'US'),
    ('216.086.096.000', 'CA'),
    ('216.086.128.000', 'US'),
    ('216.094.000.000', 'CA'),
    ('216.094.044.000', 'US'),
    ('216.094.045.000', 'GB'),
    ('216.094.046.000', 'CA'),
    ('216.094.049.000', 'US'),
    ('216.094.050.000', 'CA'),
    ('216.094.057.000', 'IL'),
    ('216.094.058.000', 'CA'),
    ('216.094.103.000', 'US'),
    ('216.094.104.000', 'CA'),
    ('216.094.172.000', 'CH'),
    ('216.094.173.000', 'CA'),
    ('216.094.177.000', 'US'),
    ('216.094.178.000', 'CA'),
    ('216.094.181.000', 'US'),
    ('216.094.182.000', 'CA'),
    ('216.094.191.000', 'US'),
    ('216.094.193.000', 'CA'),
    ('216.095.228.000', 'US'),
    ('216.095.229.000', 'CA'),
    ('216.096.000.000', 'US'),
    ('216.098.032.000', 'CA'),
    ('216.098.048.000', '--'),
    ('216.098.064.000', 'US'),
    ('216.099.096.000', 'CA'),
    ('216.099.112.000', '--'),
    ('216.099.128.000', 'US'),
    ('216.104.080.000', '--'),
    ('216.104.096.000', 'CA'),
    ('216.104.128.000', 'US'),
    ('216.108.000.000', 'CA'),
    ('216.108.192.000', 'US'),
    ('216.108.208.000', '--'),
    ('216.109.000.000', 'US'),
    ('216.109.159.000', 'ES'),
    ('216.109.160.000', 'US'),
    ('216.109.176.000', '--'),
    ('216.109.192.000', 'US'),
    ('216.110.033.000', 'CA'),
    ('216.110.034.000', 'DE'),
    ('216.110.035.000', 'US'),
    ('216.110.041.000', 'FR'),
    ('216.110.042.000', 'US'),
    ('216.110.046.000', 'GB'),
    ('216.110.048.000', 'US'),
    ('216.110.096.000', '--'),
    ('216.110.128.000', 'US'),
    ('216.110.192.000', '--'),
    ('216.111.000.000', 'US'),
    ('216.113.000.000', 'CA'),
    ('216.113.128.000', 'US'),
    ('216.113.160.000', '--'),
    ('216.113.192.000', 'CA'),
    ('216.113.224.000', '--'),
    ('216.114.000.000', 'US'),
    ('216.123.000.000', 'CA'),
    ('216.123.024.000', 'US'),
    ('216.123.025.000', 'CA'),
    ('216.123.044.000', 'ZA'),
    ('216.123.045.000', 'CA'),
    ('216.123.091.000', 'US'),
    ('216.123.092.000', 'CA'),
    ('216.123.160.000', 'US'),
    ('216.123.161.000', 'CA'),
    ('216.124.000.000', 'US'),
    ('216.126.000.000', 'CA'),
    ('216.126.032.000', 'US'),
    ('216.126.064.000', 'CA'),
    ('216.126.128.000', 'US'),
    ('216.127.033.000', 'CA'),
    ('216.127.034.000', 'US'),
    ('216.127.048.000', '--'),
    ('216.127.064.000', 'US'),
    ('216.129.000.000', 'CA'),
    ('216.129.128.000', 'TZ'),
    ('216.129.133.000', 'US'),
    ('216.129.156.000', 'MZ'),
    ('216.129.159.000', 'NG'),
    ('216.129.160.000', 'US'),
    ('216.129.176.000', '--'),
    ('216.129.192.000', 'CA'),
    ('216.129.197.000', 'US'),
    ('216.129.198.000', 'CA'),
    ('216.129.224.000', '--'),
    ('216.130.000.000', 'US'),
    ('216.130.064.000', 'CA'),
    ('216.130.096.000', '--'),
    ('216.130.128.000', 'US'),
    ('216.130.192.000', 'CA'),
    ('216.130.204.000', 'US'),
    ('216.130.207.000', 'CA'),
    ('216.130.218.000', 'AN'),
    ('216.130.219.000', 'CA'),
    ('216.130.222.000', 'HU'),
    ('216.130.224.000', '--'),
    ('216.131.000.000', 'US'),
    ('216.131.065.000', 'TR'),
    ('216.131.066.000', 'US'),
    ('216.131.076.000', 'CA'),
    ('216.131.077.000', 'US'),
    ('216.131.083.000', 'GB'),
    ('216.131.084.000', 'BY'),
    ('216.131.085.000', 'US'),
    ('216.131.087.000', 'TR'),
    ('216.131.088.000', 'US'),
    ('216.131.090.000', 'GB'),
    ('216.131.092.000', 'US'),
    ('216.133.174.000', 'NG'),
    ('216.133.175.000', 'US'),
    ('216.137.064.000', '--'),
    ('216.137.128.000', 'US'),
    ('216.137.160.000', 'CA'),
    ('216.137.176.000', '--'),
    ('216.137.192.000', 'US'),
    ('216.138.192.000', 'CA'),
    ('216.139.000.000', 'US'),
    ('216.139.158.000', 'IL'),
    ('216.139.159.000', 'US'),
    ('216.139.160.000', 'PY'),
    ('216.139.162.000', 'NI'),
    ('216.139.164.000', 'US'),
    ('216.139.165.000', 'NG'),
    ('216.139.171.000', 'US'),
    ('216.139.173.000', 'NG'),
    ('216.139.174.000', 'US'),
    ('216.139.177.000', 'NG'),
    ('216.139.179.000', 'US'),
    ('216.147.006.000', '--'),
    ('216.147.007.000', 'US'),
    ('216.147.131.000', 'NG'),
    ('216.147.133.000', 'GW'),
    ('216.147.134.000', 'US'),
    ('216.147.136.000', 'ML'),
    ('216.147.138.000', 'US'),
    ('216.147.144.000', 'RW'),
    ('216.147.152.000', 'US'),
    ('216.147.176.000', '--'),
    ('216.147.192.000', 'US'),
    ('216.152.144.000', '--'),
    ('216.152.160.000', 'AN'),
    ('216.152.176.000', '--'),
    ('216.152.192.000', 'CA'),
    ('216.152.208.000', '--'),
    ('216.152.224.000', 'US'),
    ('216.152.240.000', '--'),
    ('216.153.000.000', 'US'),
    ('216.154.000.000', 'CA'),
    ('216.154.192.000', 'US'),
    ('216.155.064.000', 'CL'),
    ('216.155.096.000', 'US'),
    ('216.157.128.000', '--'),
    ('216.158.000.000', 'US'),
    ('216.162.064.000', 'CA'),
    ('216.162.080.000', '--'),
    ('216.162.096.000', 'US'),
    ('216.162.224.000', 'CA'),
    ('216.162.240.000', '--'),
    ('216.163.000.000', 'US'),
    ('216.163.192.000', 'CA'),
    ('216.163.208.000', 'US'),
    ('216.168.096.000', 'CA'),
    ('216.168.128.000', 'US'),
    ('216.168.144.000', 'CA'),
    ('216.168.160.000', 'US'),
    ('216.171.064.000', 'GB'),
    ('216.171.080.000', '--'),
    ('216.171.096.000', 'US'),
    ('216.171.112.000', '--'),
    ('216.171.128.000', 'US'),
    ('216.172.055.000', 'CA'),
    ('216.172.056.000', 'US'),
    ('216.174.128.000', 'CA'),
    ('216.174.160.000', 'US'),
    ('216.174.176.000', '--'),
    ('216.174.192.000', 'US'),
    ('216.176.064.000', '--'),
    ('216.176.128.000', 'US'),
    ('216.176.206.000', 'VG'),
    ('216.176.207.000', 'US'),
    ('216.176.208.000', 'CA'),
    ('216.176.224.000', 'US'),
    ('216.176.240.000', '--'),
    ('216.177.000.000', 'US'),
    ('216.183.000.000', 'CA'),
    ('216.183.032.000', 'US'),
    ('216.183.048.000', '--'),
    ('216.183.064.000', 'US'),
    ('216.183.128.000', 'CA'),
    ('216.183.160.000', 'US'),
    ('216.185.064.000', 'CA'),
    ('216.185.096.000', 'US'),
    ('216.187.066.000', 'CA'),
    ('216.187.087.000', 'US'),
    ('216.187.088.000', 'CA'),
    ('216.187.101.000', 'US'),
    ('216.187.102.000', 'CA'),
    ('216.187.108.000', 'US'),
    ('216.187.109.000', 'CA'),
    ('216.187.121.000', 'US'),
    ('216.187.122.000', 'CA'),
    ('216.187.123.000', 'US'),
    ('216.187.124.000', 'CA'),
    ('216.187.128.000', 'US'),
    ('216.188.020.000', 'SG'),
    ('216.188.021.000', 'US'),
    ('216.188.022.000', 'AU'),
    ('216.188.023.000', 'DE'),
    ('216.188.024.000', 'US'),
    ('216.191.000.000', 'CA'),
    ('216.191.028.000', 'US'),
    ('216.191.029.000', 'CA'),
    ('216.191.080.000', 'US'),
    ('216.191.084.000', 'CA'),
    ('216.192.000.000', 'US'),
    ('216.194.032.000', '--'),
    ('216.194.064.000', 'CA'),
    ('216.194.096.000', '--'),
    ('216.194.128.000', 'AR'),
    ('216.194.132.000', 'BR'),
    ('216.194.134.000', 'AR'),
    ('216.194.135.000', 'BR'),
    ('216.194.136.000', 'MX'),
    ('216.194.140.000', 'PE'),
    ('216.194.142.000', 'PH'),
    ('216.194.144.000', '--'),
    ('216.194.192.000', 'US'),
    ('216.198.128.000', 'CA'),
    ('216.198.160.000', 'US'),
    ('216.198.195.000', 'MY'),
    ('216.198.196.000', 'US'),
    ('216.198.197.000', 'IN'),
    ('216.198.198.000', 'CA'),
    ('216.198.199.000', 'HK'),
    ('216.198.200.000', 'US'),
    ('216.198.210.000', 'BE'),
    ('216.198.211.000', 'US'),
    ('216.198.212.000', 'CA'),
    ('216.198.214.000', 'US'),
    ('216.198.216.000', 'CA'),
    ('216.198.217.000', 'IN'),
    ('216.198.218.000', 'CA'),
    ('216.198.219.000', 'IN'),
    ('216.198.221.000', 'US'),
    ('216.198.222.000', 'TW'),
    ('216.198.223.000', 'US'),
    ('216.198.224.000', 'IN'),
    ('216.198.225.000', 'JP'),
    ('216.198.226.000', 'US'),
    ('216.198.230.000', 'BE'),
    ('216.198.231.000', 'CA'),
    ('216.198.232.000', 'US'),
    ('216.198.233.000', 'CA'),
    ('216.198.234.000', 'US'),
    ('216.198.235.000', 'BE'),
    ('216.198.236.000', 'IN'),
    ('216.198.238.000', 'US'),
    ('216.198.240.000', 'CA'),
    ('216.198.242.000', 'US'),
    ('216.198.243.000', 'CA'),
    ('216.198.244.000', 'US'),
    ('216.198.246.000', 'CA'),
    ('216.198.251.000', 'IN'),
    ('216.198.252.000', 'CA'),
    ('216.198.253.000', 'US'),
    ('216.198.255.000', 'GB'),
    ('216.199.000.000', 'US'),
    ('216.200.120.000', 'GB'),
    ('216.200.121.000', 'US'),
    ('216.201.068.000', 'PE'),
    ('216.201.072.000', 'PA'),
    ('216.201.080.000', '--'),
    ('216.201.096.000', 'CA'),
    ('216.201.108.000', 'US'),
    ('216.201.109.000', 'CA'),
    ('216.201.112.000', '--'),
    ('216.201.128.000', 'US'),
    ('216.202.104.000', 'GU'),
    ('216.202.105.000', 'MP'),
    ('216.202.112.000', 'US'),
    ('216.208.000.000', 'CA'),
    ('216.208.039.000', 'US'),
    ('216.208.040.000', 'CA'),
    ('216.210.128.000', 'US'),
    ('216.211.000.000', 'CA'),
    ('216.211.128.000', 'US'),
    ('216.218.000.000', 'CA'),
    ('216.218.064.000', 'US'),
    ('216.218.096.000', '--'),
    ('216.218.128.000', 'US'),
    ('216.218.163.000', 'IL'),
    ('216.218.164.000', 'US'),
    ('216.218.175.000', 'CA'),
    ('216.218.176.000', 'US'),
    ('216.218.192.000', 'GB'),
    ('216.218.193.000', 'US'),
    ('216.218.223.000', 'DE'),
    ('216.218.224.000', 'US'),
    ('216.218.226.000', 'OM'),
    ('216.218.227.000', 'US'),
    ('216.218.229.000', 'VG'),
    ('216.218.230.000', 'US'),
    ('216.218.253.000', 'AU'),
    ('216.218.254.000', 'US'),
    ('216.219.000.000', 'PA'),
    ('216.219.008.000', 'EC'),
    ('216.219.014.000', 'US'),
    ('216.219.018.000', 'EC'),
    ('216.219.020.000', 'PA'),
    ('216.219.030.000', 'PY'),
    ('216.219.032.000', 'US'),
    ('216.219.036.000', 'AN'),
    ('216.219.037.000', 'EC'),
    ('216.219.038.000', 'PA'),
    ('216.219.044.000', 'PY'),
    ('216.219.048.000', 'PA'),
    ('216.219.050.000', 'US'),
    ('216.219.052.000', 'PY'),
    ('216.219.053.000', 'EC'),
    ('216.219.054.000', 'US'),
    ('216.219.055.000', 'EC'),
    ('216.219.056.000', 'VE'),
    ('216.219.057.000', 'PA'),
    ('216.219.059.000', 'US'),
    ('216.219.060.000', 'PA'),
    ('216.219.062.000', 'US'),
    ('216.220.032.000', 'CA'),
    ('216.220.064.000', 'US'),
    ('216.221.016.000', '--'),
    ('216.221.032.000', 'CA'),
    ('216.221.096.000', 'US'),
    ('216.221.192.000', 'CA'),
    ('216.221.224.000', 'US'),
    ('216.223.064.000', 'CA'),
    ('216.223.160.000', '--'),
    ('216.223.192.000', 'US'),
    ('216.226.032.000', 'CA'),
    ('216.226.064.000', 'US'),
    ('216.226.096.000', '--'),
    ('216.226.097.000', 'CA'),
    ('216.226.098.000', '--'),
    ('216.226.128.000', 'US'),
    ('216.226.139.000', 'BS'),
    ('216.226.140.000', 'US'),
    ('216.226.176.000', '--'),
    ('216.226.192.000', 'US'),
    ('216.226.193.000', 'AU'),
    ('216.226.194.000', 'PH'),
    ('216.226.195.000', 'AU'),
    ('216.226.197.000', 'PH'),
    ('216.226.198.000', 'AU'),
    ('216.226.200.000', 'BO'),
    ('216.226.201.000', 'NI'),
    ('216.226.202.000', 'PY'),
    ('216.226.204.000', 'US'),
    ('216.226.205.000', 'HN'),
    ('216.226.206.000', 'US'),
    ('216.226.207.000', 'UY'),
    ('216.226.208.000', 'CI'),
    ('216.226.209.000', 'US'),
    ('216.226.210.000', 'NG'),
    ('216.226.212.000', 'HN'),
    ('216.226.214.000', 'US'),
    ('216.226.216.000', 'CL'),
    ('216.226.217.000', 'US'),
    ('216.226.218.000', 'AR'),
    ('216.226.219.000', 'US'),
    ('216.226.220.000', 'PH'),
    ('216.226.221.000', 'AU'),
    ('216.226.222.000', 'US'),
    ('216.226.227.000', 'BO'),
    ('216.226.229.000', 'US'),
    ('216.226.230.000', 'CO'),
    ('216.226.232.000', 'HN'),
    ('216.226.238.000', 'CO'),
    ('216.226.240.000', 'PH'),
    ('216.226.245.000', 'BJ'),
    ('216.226.246.000', 'PH'),
    ('216.226.247.000', 'AU'),
    ('216.226.248.000', 'US'),
    ('216.230.128.000', 'GT'),
    ('216.230.160.000', 'US'),
    ('216.230.176.000', '--'),
    ('216.230.192.000', 'US'),
    ('216.232.000.000', 'CA'),
    ('216.233.000.000', 'US'),
    ('216.234.032.000', 'CA'),
    ('216.234.064.000', 'US'),
    ('216.234.144.000', '--'),
    ('216.234.160.000', 'CA'),
    ('216.234.192.000', 'US'),
    ('216.235.000.000', 'CA'),
    ('216.235.016.000', '--'),
    ('216.235.032.000', 'US'),
    ('216.236.192.000', 'IN'),
    ('216.236.198.000', 'US'),
    ('216.236.203.000', 'IN'),
    ('216.236.205.000', 'NG'),
    ('216.236.206.000', 'PK'),
    ('216.236.208.000', 'US'),
    ('216.236.240.000', '--'),
    ('216.237.000.000', 'US'),
    ('216.239.064.000', 'CA'),
    ('216.239.096.000', 'US'),
    ('216.239.112.000', '--'),
    ('216.239.128.000', 'US'),
    ('216.240.000.000', 'CA'),
    ('216.240.016.000', '--'),
    ('216.240.032.000', 'US'),
    ('216.240.192.000', 'CA'),
    ('216.240.208.000', 'US'),
    ('216.240.224.000', 'CA'),
    ('216.240.240.000', 'US'),
    ('216.241.000.000', 'CL'),
    ('216.241.032.000', 'US'),
    ('216.241.048.000', '--'),
    ('216.241.064.000', 'US'),
    ('216.241.224.000', 'CA'),
    ('216.241.240.000', 'US'),
    ('216.244.128.000', 'PE'),
    ('216.244.192.000', 'AR'),
    ('216.245.000.000', 'US'),
    ('216.248.224.000', 'CA'),
    ('216.248.240.000', '--'),
    ('216.249.000.000', 'CA'),
    ('216.249.016.000', 'US'),
    ('216.249.032.000', 'BM'),
    ('216.249.048.000', '--'),
    ('216.249.064.000', 'US'),
    ('216.250.096.000', 'CA'),
    ('216.250.112.000', '--'),
    ('216.250.128.000', 'US'),
    ('216.250.192.000', 'PH'),
    ('216.250.193.000', 'UY'),
    ('216.250.194.000', 'NI'),
    ('216.250.195.000', 'US'),
    ('216.250.196.000', 'PY'),
    ('216.250.204.000', 'PE'),
    ('216.250.206.000', 'TR'),
    ('216.250.207.000', 'PY'),
    ('216.250.208.000', 'EC'),
    ('216.250.212.000', 'TT'),
    ('216.250.213.000', 'US'),
    ('216.250.215.000', 'UG'),
    ('216.250.216.000', 'US'),
    ('216.250.217.000', 'NC'),
    ('216.250.220.000', 'US'),
    ('216.250.221.000', 'NG'),
    ('216.250.222.000', 'US'),
    ('216.251.066.000', 'MX'),
    ('216.251.067.000', 'US'),
    ('216.251.073.000', 'MX'),
    ('216.251.074.000', 'US'),
    ('216.251.075.000', 'MX'),
    ('216.251.077.000', 'US'),
    ('216.251.112.000', '--'),
    ('216.251.128.000', 'CA'),
    ('216.251.160.000', 'US'),
    ('216.252.128.000', 'PR'),
    ('216.252.130.000', 'US'),
    ('216.252.131.000', 'JM'),
    ('216.252.132.000', 'AR'),
    ('216.252.133.000', 'US'),
    ('216.252.135.000', 'BB'),
    ('216.252.136.000', 'US'),
    ('216.252.138.000', 'SV'),
    ('216.252.139.000', 'US'),
    ('216.252.140.000', 'AU'),
    ('216.252.142.000', 'US'),
    ('216.252.144.000', 'PH'),
    ('216.252.145.000', 'AU'),
    ('216.252.146.000', 'US'),
    ('216.252.147.000', 'AU'),
    ('216.252.148.000', 'PH'),
    ('216.252.149.000', 'US'),
    ('216.252.153.000', 'RO'),
    ('216.252.154.000', 'US'),
    ('216.252.155.000', 'EG'),
    ('216.252.156.000', 'BG'),
    ('216.252.158.000', 'US'),
    ('216.252.162.000', 'IN'),
    ('216.252.164.000', 'CM'),
    ('216.252.165.000', 'PK'),
    ('216.252.166.000', 'US'),
    ('216.252.170.000', 'PK'),
    ('216.252.174.000', 'US'),
    ('216.252.176.000', 'NG'),
    ('216.252.178.000', 'BJ'),
    ('216.252.179.000', 'ML'),
    ('216.252.180.000', 'US'),
    ('216.252.182.000', 'CI'),
    ('216.252.183.000', 'GN'),
    ('216.252.184.000', 'US'),
    ('216.252.185.000', 'PK'),
    ('216.252.186.000', 'KE'),
    ('216.252.187.000', 'PK'),
    ('216.252.188.000', 'US'),
    ('216.252.189.000', 'KE'),
    ('216.252.190.000', 'YU'),
    ('216.252.191.000', 'UA'),
    ('216.252.192.000', 'BS'),
    ('216.252.193.000', 'HT'),
    ('216.252.194.000', 'US'),
    ('216.252.196.000', 'NI'),
    ('216.252.197.000', 'BZ'),
    ('216.252.198.000', 'PR'),
    ('216.252.199.000', 'VE'),
    ('216.252.202.000', 'PA'),
    ('216.252.204.000', 'US'),
    ('216.252.205.000', 'EC'),
    ('216.252.206.000', 'HT'),
    ('216.252.208.000', 'PH'),
    ('216.252.209.000', 'US'),
    ('216.252.211.000', 'AU'),
    ('216.252.213.000', 'PH'),
    ('216.252.214.000', 'AU'),
    ('216.252.215.000', 'US'),
    ('216.252.216.000', 'AU'),
    ('216.252.217.000', 'CM'),
    ('216.252.218.000', 'NP'),
    ('216.252.219.000', 'US'),
    ('216.252.223.000', 'AU'),
    ('216.252.224.000', 'TG'),
    ('216.252.226.000', 'CM'),
    ('216.252.227.000', 'CI'),
    ('216.252.228.000', 'GH'),
    ('216.252.230.000', 'US'),
    ('216.252.231.000', 'NG'),
    ('216.252.232.000', 'US'),
    ('216.252.233.000', 'EG'),
    ('216.252.234.000', 'RO'),
    ('216.252.235.000', 'CM'),
    ('216.252.236.000', 'US'),
    ('216.252.237.000', 'EG'),
    ('216.252.238.000', 'RO'),
    ('216.252.239.000', 'US'),
    ('216.252.240.000', 'MG'),
    ('216.252.242.000', 'US'),
    ('216.252.244.000', 'PH'),
    ('216.252.245.000', 'PK'),
    ('216.252.246.000', 'ZW'),
    ('216.252.248.000', 'US'),
    ('216.252.249.000', 'ZM'),
    ('216.252.250.000', 'US'),
    ('216.252.252.000', 'MW'),
    ('216.252.253.000', 'US'),
    ('216.252.255.000', 'KE'),
    ('216.253.000.000', 'US'),
    ('216.254.128.000', 'CA'),
    ('216.255.000.000', 'US'),
    ('216.255.160.000', '--'),
    ('216.255.192.000', 'US'),
    ('216.255.208.000', '--'),
    ('216.255.224.000', 'JP'),
    ('216.255.240.000', '--'),
    ('217.000.000.000', 'DE'),
    ('217.008.000.000', 'GB'),
    ('217.008.032.000', 'SE'),
    ('217.008.048.000', 'EU'),
    ('217.008.064.000', 'SA'),
    ('217.008.080.000', 'EU'),
    ('217.008.096.000', 'NL'),
    ('217.008.112.000', 'EU'),
    ('217.008.128.000', 'NO'),
    ('217.008.160.000', 'PL'),
    ('217.008.192.000', 'CH'),
    ('217.008.224.000', 'GB'),
    ('217.008.240.000', 'EU'),
    ('217.009.000.000', 'UA'),
    ('217.009.016.000', 'EU'),
    ('217.009.032.000', 'DE'),
    ('217.009.048.000', 'EU'),
    ('217.009.064.000', 'IT'),
    ('217.009.080.000', 'EU'),
    ('217.009.096.000', 'DE'),
    ('217.009.128.000', 'IS'),
    ('217.009.144.000', 'EU'),
    ('217.009.160.000', 'PL'),
    ('217.009.192.000', 'GB'),
    ('217.009.208.000', 'EU'),
    ('217.009.224.000', 'BG'),
    ('217.009.240.000', 'EU'),
    ('217.010.000.000', 'DE'),
    ('217.010.016.000', 'EU'),
    ('217.010.032.000', 'RU'),
    ('217.010.048.000', 'EU'),
    ('217.010.064.000', 'DE'),
    ('217.010.080.000', 'EU'),
    ('217.010.096.000', 'SE'),
    ('217.010.112.000', 'EU'),
    ('217.010.128.000', 'GB'),
    ('217.010.144.000', 'EU'),
    ('217.010.160.000', 'GB'),
    ('217.010.164.000', 'BD'),
    ('217.010.166.000', 'NG'),
    ('217.010.167.000', 'GB'),
    ('217.010.192.000', 'RO'),
    ('217.010.224.000', 'GB'),
    ('217.010.240.000', 'EU'),
    ('217.011.000.000', 'IT'),
    ('217.011.016.000', 'EU'),
    ('217.011.032.000', 'CH'),
    ('217.011.048.000', 'EU'),
    ('217.011.064.000', 'IT'),
    ('217.011.080.000', 'EU'),
    ('217.011.096.000', 'ES'),
    ('217.011.128.000', 'PL'),
    ('217.011.144.000', 'EU'),
    ('217.011.160.000', 'FR'),
    ('217.011.192.000', 'DE'),
    ('217.011.208.000', 'EU'),
    ('217.011.224.000', 'CZ'),
    ('217.011.240.000', 'SK'),
    ('217.011.241.000', 'CZ'),
    ('217.011.244.000', 'SK'),
    ('217.011.248.000', 'CZ'),
    ('217.011.249.000', 'SK'),
    ('217.011.250.000', 'CZ'),
    ('217.012.000.000', 'GB'),
    ('217.012.016.000', 'EU'),
    ('217.012.032.000', 'IE'),
    ('217.012.048.000', 'EU'),
    ('217.012.064.000', 'GB'),
    ('217.012.080.000', 'EU'),
    ('217.012.096.000', 'RU'),
    ('217.012.112.000', 'EU'),
    ('217.012.128.000', 'IT'),
    ('217.012.144.000', 'EU'),
    ('217.012.160.000', 'IT'),
    ('217.012.176.000', 'EU'),
    ('217.012.192.000', 'UA'),
    ('217.012.208.000', 'EU'),
    ('217.012.224.000', 'DE'),
    ('217.012.240.000', 'EU'),
    ('217.013.000.000', 'NO'),
    ('217.013.032.000', 'HU'),
    ('217.013.048.000', 'EU'),
    ('217.013.064.000', 'DE'),
    ('217.013.080.000', 'EU'),
    ('217.013.096.000', 'RO'),
    ('217.013.112.000', 'EU'),
    ('217.013.128.000', 'GB'),
    ('217.013.144.000', 'EU'),
    ('217.013.160.000', 'DE'),
    ('217.013.176.000', 'EU'),
    ('217.013.192.000', 'DE'),
    ('217.013.193.000', 'AT'),
    ('217.013.197.000', 'DE'),
    ('217.013.200.000', 'AT'),
    ('217.013.201.000', 'DE'),
    ('217.013.204.000', 'AT'),
    ('217.013.208.000', 'EU'),
    ('217.013.224.000', 'SE'),
    ('217.013.240.000', 'EU'),
    ('217.014.000.000', 'NO'),
    ('217.014.016.000', 'EU'),
    ('217.014.032.000', 'DE'),
    ('217.014.038.000', 'AT'),
    ('217.014.048.000', 'EU'),
    ('217.014.064.000', 'CH'),
    ('217.014.080.000', 'EU'),
    ('217.014.096.000', 'AZ'),
    ('217.014.112.000', 'EU'),
    ('217.014.128.000', 'GB'),
    ('217.014.144.000', 'EU'),
    ('217.014.160.000', 'DE'),
    ('217.014.176.000', 'EU'),
    ('217.014.192.000', 'RU'),
    ('217.014.208.000', 'EU'),
    ('217.014.224.000', 'AT'),
    ('217.014.240.000', 'EU'),
    ('217.015.000.000', 'AT'),
    ('217.015.016.000', 'EU'),
    ('217.015.032.000', 'ES'),
    ('217.015.048.000', 'EU'),
    ('217.015.064.000', 'GB'),
    ('217.015.080.000', 'EU'),
    ('217.015.096.000', 'MT'),
    ('217.015.112.000', 'EU'),
    ('217.015.128.000', 'RU'),
    ('217.015.144.000', 'EU'),
    ('217.015.160.000', 'GB'),
    ('217.015.176.000', 'EU'),
    ('217.015.192.000', 'GB'),
    ('217.015.208.000', 'EU'),
    ('217.015.224.000', 'DE'),
    ('217.015.240.000', 'EU'),
    ('217.016.000.000', 'US'),
    ('217.016.002.000', 'CY'),
    ('217.016.016.000', 'EU'),
    ('217.016.032.000', 'NL'),
    ('217.016.035.000', 'AT'),
    ('217.016.048.000', 'EU'),
    ('217.016.064.000', 'MK'),
    ('217.016.096.000', 'DK'),
    ('217.016.112.000', 'EU'),
    ('217.016.128.000', 'HR'),
    ('217.016.144.000', 'EU'),
    ('217.016.160.000', 'DE'),
    ('217.016.176.000', 'EU'),
    ('217.016.192.000', 'SE'),
    ('217.016.208.000', 'EU'),
    ('217.016.224.000', 'CY'),
    ('217.016.225.000', 'GR'),
    ('217.016.240.000', 'EU'),
    ('217.017.000.000', 'NO'),
    ('217.017.016.000', 'EU'),
    ('217.017.032.000', 'PL'),
    ('217.017.048.000', 'EU'),
    ('217.017.064.000', 'DK'),
    ('217.017.080.000', 'EU'),
    ('217.017.096.000', 'FR'),
    ('217.017.112.000', 'EU'),
    ('217.017.128.000', 'NL'),
    ('217.017.144.000', 'EU'),
    ('217.017.160.000', 'RU'),
    ('217.017.192.000', 'DE'),
    ('217.017.208.000', 'EU'),
    ('217.017.224.000', 'BH'),
    ('217.018.000.000', 'IT'),
    ('217.018.016.000', 'EU'),
    ('217.018.032.000', 'ES'),
    ('217.018.048.000', 'EU'),
    ('217.018.064.000', 'NL'),
    ('217.018.080.000', 'EU'),
    ('217.018.096.000', 'IT'),
    ('217.018.112.000', 'EU'),
    ('217.018.128.000', 'RU'),
    ('217.018.160.000', 'ES'),
    ('217.018.176.000', 'EU'),
    ('217.018.192.000', 'NO'),
    ('217.018.208.000', 'EU'),
    ('217.018.224.000', 'DK'),
    ('217.018.240.000', 'EU'),
    ('217.019.000.000', 'RO'),
    ('217.019.016.000', 'EU'),
    ('217.019.032.000', 'AT'),
    ('217.019.048.000', 'EU'),
    ('217.019.064.000', 'GR'),
    ('217.019.080.000', 'EU'),
    ('217.019.096.000', 'PL'),
    ('217.019.112.000', 'EU'),
    ('217.019.128.000', 'GB'),
    ('217.019.144.000', 'EU'),
    ('217.019.160.000', 'DE'),
    ('217.019.176.000', 'EU'),
    ('217.019.192.000', 'FR'),
    ('217.019.208.000', 'EU'),
    ('217.019.224.000', 'GB'),
    ('217.019.240.000', 'EU'),
    ('217.020.000.000', 'IT'),
    ('217.020.016.000', 'EU'),
    ('217.020.032.000', 'GB'),
    ('217.020.048.000', 'EU'),
    ('217.020.064.000', 'DK'),
    ('217.020.080.000', 'EU'),
    ('217.020.096.000', 'SE'),
    ('217.020.112.000', 'EU'),
    ('217.020.128.000', 'HU'),
    ('217.020.144.000', 'EU'),
    ('217.020.160.000', 'UA'),
    ('217.020.176.000', 'EU'),
    ('217.020.192.000', 'CH'),
    ('217.020.208.000', 'EU'),
    ('217.020.224.000', 'EG'),
    ('217.020.240.000', 'EU'),
    ('217.021.000.000', 'PS'),
    ('217.021.016.000', 'EU'),
    ('217.021.032.000', 'BY'),
    ('217.021.048.000', 'US'),
    ('217.021.050.000', 'BY'),
    ('217.021.064.000', 'IL'),
    ('217.021.068.000', 'TR'),
    ('217.021.072.000', 'KE'),
    ('217.021.075.000', 'PL'),
    ('217.021.081.000', 'TZ'),
    ('217.021.093.000', 'KE'),
    ('217.021.096.000', 'DE'),
    ('217.021.112.000', 'EU'),
    ('217.021.128.000', 'GB'),
    ('217.021.144.000', 'EU'),
    ('217.021.160.000', 'LV'),
    ('217.021.176.000', 'EU'),
    ('217.021.192.000', 'DE'),
    ('217.021.208.000', 'EU'),
    ('217.021.224.000', 'SE'),
    ('217.021.240.000', 'EU'),
    ('217.022.000.000', 'GB'),
    ('217.022.016.000', 'EU'),
    ('217.022.032.000', 'DK'),
    ('217.022.048.000', 'EU'),
    ('217.022.064.000', 'NL'),
    ('217.022.080.000', 'EU'),
    ('217.022.096.000', 'ES'),
    ('217.022.112.000', 'EU'),
    ('217.022.128.000', 'DE'),
    ('217.022.144.000', 'EU'),
    ('217.022.160.000', 'RU'),
    ('217.022.176.000', 'EU'),
    ('217.022.192.000', 'DE'),
    ('217.022.208.000', 'EU'),
    ('217.022.224.000', 'IT'),
    ('217.022.240.000', 'EU'),
    ('217.023.000.000', 'PT'),
    ('217.023.016.000', 'EU'),
    ('217.023.032.000', 'JO'),
    ('217.023.048.000', 'EU'),
    ('217.023.064.000', 'RU'),
    ('217.023.096.000', 'DK'),
    ('217.023.107.000', 'NO'),
    ('217.023.108.000', 'DK'),
    ('217.023.111.000', 'ZA'),
    ('217.023.112.000', 'EU'),
    ('217.023.128.000', 'RU'),
    ('217.023.160.000', 'GB'),
    ('217.023.176.000', 'EU'),
    ('217.023.192.000', 'BA'),
    ('217.023.208.000', 'EU'),
    ('217.023.224.000', 'GB'),
    ('217.023.240.000', 'EU'),
    ('217.024.000.000', 'DE'),
    ('217.024.016.000', 'EU'),
    ('217.024.032.000', 'CH'),
    ('217.024.048.000', 'EU'),
    ('217.024.064.000', 'BE'),
    ('217.024.080.000', 'EU'),
    ('217.024.096.000', 'DE'),
    ('217.024.112.000', 'EU'),
    ('217.024.128.000', 'GB'),
    ('217.024.144.000', 'EU'),
    ('217.024.160.000', 'UA'),
    ('217.024.176.000', 'EU'),
    ('217.024.192.000', 'DE'),
    ('217.024.208.000', 'EU'),
    ('217.024.224.000', 'DE'),
    ('217.024.240.000', 'EU'),
    ('217.025.000.000', 'GB'),
    ('217.025.016.000', 'EU'),
    ('217.025.032.000', 'GB'),
    ('217.025.048.000', 'EU'),
    ('217.025.064.000', 'DE'),
    ('217.025.080.000', 'EU'),
    ('217.025.096.000', 'FI'),
    ('217.025.112.000', 'EU'),
    ('217.025.128.000', 'DE'),
    ('217.025.144.000', 'EU'),
    ('217.025.160.000', 'UA'),
    ('217.025.176.000', 'EU'),
    ('217.025.192.000', 'UA'),
    ('217.025.208.000', 'EU'),
    ('217.025.224.000', 'CH'),
    ('217.025.240.000', 'EU'),
    ('217.026.000.000', 'RU'),
    ('217.026.016.000', 'EU'),
    ('217.026.032.000', 'CH'),
    ('217.026.048.000', 'EU'),
    ('217.026.064.000', 'YU'),
    ('217.026.080.000', 'EU'),
    ('217.026.096.000', 'NO'),
    ('217.026.112.000', 'EU'),
    ('217.026.128.000', 'SE'),
    ('217.026.144.000', 'EU'),
    ('217.026.160.000', 'MD'),
    ('217.026.176.000', 'EU'),
    ('217.026.192.000', 'FR'),
    ('217.026.208.000', 'EU'),
    ('217.026.224.000', 'IT'),
    ('217.026.240.000', 'EU'),
    ('217.027.000.000', 'DE'),
    ('217.027.016.000', 'EU'),
    ('217.027.032.000', 'CY'),
    ('217.027.040.000', 'RU'),
    ('217.027.044.000', 'GR'),
    ('217.027.046.000', 'GB'),
    ('217.027.048.000', 'EU'),
    ('217.027.064.000', 'IT'),
    ('217.027.096.000', 'CH'),
    ('217.027.112.000', 'EU'),
    ('217.027.128.000', 'DE'),
    ('217.027.144.000', 'EU'),
    ('217.027.160.000', 'SE'),
    ('217.027.176.000', 'EU'),
    ('217.027.192.000', 'DE'),
    ('217.027.208.000', 'EU'),
    ('217.027.224.000', 'GB'),
    ('217.027.240.000', 'EU'),
    ('217.028.000.000', 'IT'),
    ('217.028.016.000', 'EU'),
    ('217.028.032.000', 'SE'),
    ('217.028.048.000', 'EU'),
    ('217.028.064.000', 'FR'),
    ('217.028.080.000', 'EU'),
    ('217.028.096.000', 'DE'),
    ('217.028.112.000', 'EU'),
    ('217.028.128.000', 'GB'),
    ('217.028.144.000', 'EU'),
    ('217.028.160.000', 'DK'),
    ('217.028.176.000', 'EU'),
    ('217.028.192.000', 'SE'),
    ('217.028.208.000', 'EU'),
    ('217.028.224.000', 'DE'),
    ('217.028.240.000', 'EU'),
    ('217.029.000.000', 'DE'),
    ('217.029.016.000', 'EU'),
    ('217.029.032.000', 'DE'),
    ('217.029.048.000', 'EU'),
    ('217.029.064.000', 'IT'),
    ('217.029.080.000', 'EU'),
    ('217.029.096.000', 'DE'),
    ('217.029.112.000', 'EU'),
    ('217.029.128.000', 'EG'),
    ('217.029.144.000', 'EU'),
    ('217.029.160.000', 'IT'),
    ('217.029.176.000', 'EU'),
    ('217.029.192.000', 'GB'),
    ('217.029.208.000', 'EU'),
    ('217.029.224.000', 'GB'),
    ('217.029.240.000', 'EU'),
    ('217.030.000.000', 'IT'),
    ('217.030.016.000', 'EU'),
    ('217.030.032.000', 'DK'),
    ('217.030.048.000', 'EU'),
    ('217.030.064.000', 'CZ'),
    ('217.030.080.000', 'EU'),
    ('217.030.096.000', 'MT'),
    ('217.030.112.000', 'EU'),
    ('217.030.128.000', 'PL'),
    ('217.030.160.000', 'GR'),
    ('217.030.176.000', 'EU'),
    ('217.030.192.000', 'IT'),
    ('217.030.208.000', 'EU'),
    ('217.030.224.000', 'DE'),
    ('217.030.240.000', 'EU'),
    ('217.031.000.000', 'GB'),
    ('217.031.016.000', 'EU'),
    ('217.031.032.000', 'ES'),
    ('217.031.048.000', 'EU'),
    ('217.031.064.000', 'LU'),
    ('217.031.080.000', 'EU'),
    ('217.031.096.000', 'NO'),
    ('217.031.112.000', 'EU'),
    ('217.031.128.000', 'GB'),
    ('217.031.144.000', 'EU'),
    ('217.031.160.000', 'SE'),
    ('217.031.176.000', 'EU'),
    ('217.031.224.000', 'TR'),
    ('217.031.240.000', 'EU'),
    ('217.032.000.000', 'GB'),
    ('217.048.000.000', 'DE'),
    ('217.052.000.000', 'EG'),
    ('217.056.000.000', 'IT'),
    ('217.060.000.000', 'DK'),
    ('217.062.000.000', 'NL'),
    ('217.064.000.000', 'FI'),
    ('217.064.016.000', 'EU'),
    ('217.064.032.000', 'GB'),
    ('217.064.048.000', 'EU'),
    ('217.064.064.000', 'DE'),
    ('217.064.080.000', 'EU'),
    ('217.064.096.000', 'ML'),
    ('217.064.112.000', 'EU'),
    ('217.064.128.000', 'GB'),
    ('217.064.144.000', 'EU'),
    ('217.064.160.000', 'DE'),
    ('217.064.176.000', 'EU'),
    ('217.064.192.000', 'IT'),
    ('217.064.208.000', 'EU'),
    ('217.064.224.000', 'GB'),
    ('217.064.240.000', 'EU'),
    ('217.065.000.000', 'ES'),
    ('217.065.016.000', 'EU'),
    ('217.065.032.000', 'NL'),
    ('217.065.064.000', 'IT'),
    ('217.065.080.000', 'EU'),
    ('217.065.096.000', 'HU'),
    ('217.065.128.000', 'DE'),
    ('217.065.144.000', 'EU'),
    ('217.065.192.000', 'YU'),
    ('217.065.208.000', 'EU'),
    ('217.065.224.000', 'NO'),
    ('217.065.240.000', 'EU'),
    ('217.066.000.000', 'BE'),
    ('217.066.016.000', 'EU'),
    ('217.066.032.000', 'GB'),
    ('217.066.048.000', 'EU'),
    ('217.066.064.000', 'RU'),
    ('217.066.096.000', 'UA'),
    ('217.066.112.000', 'EU'),
    ('217.066.128.000', 'DE'),
    ('217.066.144.000', 'EU'),
    ('217.066.160.000', 'CZ'),
    ('217.066.175.000', 'SK'),
    ('217.066.186.000', '--'),
    ('217.066.187.000', 'CZ'),
    ('217.066.192.000', 'IR'),
    ('217.066.224.000', 'PS'),
    ('217.067.000.000', 'RU'),
    ('217.067.016.000', 'EU'),
    ('217.067.032.000', 'DE'),
    ('217.067.048.000', 'EU'),
    ('217.067.064.000', 'BE'),
    ('217.067.080.000', 'EU'),
    ('217.067.096.000', 'DE'),
    ('217.067.112.000', 'EU'),
    ('217.067.128.000', 'IE'),
    ('217.067.144.000', 'EU'),
    ('217.067.160.000', 'GB'),
    ('217.067.176.000', 'EU'),
    ('217.067.192.000', 'PL'),
    ('217.067.208.000', 'EU'),
    ('217.067.224.000', 'NL'),
    ('217.067.240.000', 'EU'),
    ('217.068.000.000', 'DE'),
    ('217.068.016.000', 'EU'),
    ('217.068.032.000', 'SE'),
    ('217.068.048.000', 'EU'),
    ('217.068.064.000', 'GB'),
    ('217.068.080.000', 'EU'),
    ('217.068.096.000', 'NO'),
    ('217.068.128.000', 'GB'),
    ('217.068.144.000', 'EU'),
    ('217.068.160.000', 'DE'),
    ('217.068.192.000', 'US'),
    ('217.068.196.000', 'DE'),
    ('217.068.208.000', 'EU'),
    ('217.068.224.000', 'CH'),
    ('217.068.240.000', 'EU'),
    ('217.069.000.000', 'GR'),
    ('217.069.016.000', 'EU'),
    ('217.069.032.000', 'GB'),
    ('217.069.048.000', 'EU'),
    ('217.069.064.000', 'DE'),
    ('217.069.080.000', 'EU'),
    ('217.069.096.000', 'CZ'),
    ('217.069.112.000', 'EU'),
    ('217.069.128.000', 'DE'),
    ('217.069.144.000', 'EU'),
    ('217.069.160.000', 'DE'),
    ('217.069.176.000', 'EU'),
    ('217.069.192.000', 'RU'),
    ('217.069.224.000', 'DE'),
    ('217.070.000.000', 'ES'),
    ('217.070.016.000', 'EU'),
    ('217.070.032.000', 'SE'),
    ('217.070.048.000', 'EU'),
    ('217.070.064.000', 'PT'),
    ('217.070.080.000', 'EU'),
    ('217.070.096.000', 'RU'),
    ('217.070.128.000', 'DE'),
    ('217.070.144.000', 'EU'),
    ('217.070.160.000', 'DE'),
    ('217.070.176.000', 'EU'),
    ('217.070.192.000', 'DE'),
    ('217.070.208.000', 'EU'),
    ('217.070.224.000', 'NO'),
    ('217.070.226.000', 'NL'),
    ('217.070.233.000', 'NO'),
    ('217.070.240.000', 'EU'),
    ('217.071.000.000', 'GB'),
    ('217.071.016.000', 'EU'),
    ('217.071.032.000', 'EE'),
    ('217.071.048.000', 'EU'),
    ('217.071.064.000', 'IT'),
    ('217.071.080.000', 'EU'),
    ('217.071.096.000', 'FR'),
    ('217.071.098.000', 'EU'),
    ('217.071.101.000', 'FR'),
    ('217.071.102.000', 'ES'),
    ('217.071.104.000', 'DE'),
    ('217.071.109.000', 'EU'),
    ('217.071.128.000', 'NL'),
    ('217.071.130.000', 'GB'),
    ('217.071.132.000', 'IE'),
    ('217.071.134.000', 'HU'),
    ('217.071.135.000', 'NL'),
    ('217.071.136.000', 'SE'),
    ('217.071.138.000', 'DE'),
    ('217.071.140.000', 'GB'),
    ('217.071.144.000', 'EU'),
    ('217.071.160.000', 'NL'),
    ('217.071.176.000', 'EU'),
    ('217.071.192.000', 'ES'),
    ('217.071.208.000', 'EU'),
    ('217.071.224.000', 'GB'),
    ('217.071.240.000', 'EU'),
    ('217.072.000.000', 'RU'),
    ('217.072.016.000', 'EU'),
    ('217.072.032.000', 'IT'),
    ('217.072.048.000', 'EU'),
    ('217.072.064.000', 'SI'),
    ('217.072.096.000', 'IT'),
    ('217.072.112.000', 'EU'),
    ('217.072.128.000', 'DE'),
    ('217.072.144.000', 'EU'),
    ('217.072.160.000', 'GB'),
    ('217.072.176.000', 'EU'),
    ('217.072.192.000', 'DE'),
    ('217.072.208.000', 'EU'),
    ('217.072.224.000', 'BE'),
    ('217.072.240.000', 'EU'),
    ('217.073.000.000', 'SE'),
    ('217.073.016.000', 'EU'),
    ('217.073.032.000', 'DE'),
    ('217.073.048.000', 'EU'),
    ('217.073.064.000', 'DE'),
    ('217.073.080.000', 'EU'),
    ('217.073.096.000', 'SE'),
    ('217.073.112.000', 'EU'),
    ('217.073.128.000', 'UA'),
    ('217.073.144.000', 'EU'),
    ('217.073.160.000', 'RO'),
    ('217.073.176.000', 'EU'),
    ('217.073.192.000', 'RU'),
    ('217.073.208.000', 'EU'),
    ('217.073.224.000', 'IT'),
    ('217.073.240.000', 'EU'),
    ('217.074.000.000', 'DE'),
    ('217.074.016.000', 'EU'),
    ('217.074.032.000', 'RU'),
    ('217.074.048.000', 'EU'),
    ('217.074.064.000', 'PL'),
    ('217.074.080.000', 'EU'),
    ('217.074.096.000', 'FR'),
    ('217.074.112.000', 'EU'),
    ('217.074.128.000', 'RU'),
    ('217.074.144.000', 'EU'),
    ('217.074.160.000', 'RU'),
    ('217.074.176.000', 'EU'),
    ('217.074.192.000', 'DE'),
    ('217.074.208.000', 'EU'),
    ('217.074.224.000', 'DE'),
    ('217.074.240.000', 'EU'),
    ('217.075.000.000', 'IE'),
    ('217.075.016.000', 'EU'),
    ('217.075.032.000', 'NL'),
    ('217.075.048.000', 'EU'),
    ('217.075.064.000', 'SK'),
    ('217.075.080.000', 'EU'),
    ('217.075.096.000', 'SE'),
    ('217.075.112.000', 'EU'),
    ('217.075.128.000', 'BG'),
    ('217.075.144.000', 'EU'),
    ('217.075.160.000', 'GB'),
    ('217.075.176.000', 'EU'),
    ('217.075.192.000', 'BA'),
    ('217.075.208.000', 'EU'),
    ('217.075.224.000', 'ES'),
    ('217.075.240.000', 'EU'),
    ('217.076.000.000', 'IT'),
    ('217.076.016.000', 'EU'),
    ('217.076.032.000', 'RU'),
    ('217.076.048.000', 'EU'),
    ('217.076.064.000', 'GB'),
    ('217.076.080.000', 'EU'),
    ('217.076.096.000', 'DE'),
    ('217.076.112.000', 'EU'),
    ('217.076.128.000', 'ES'),
    ('217.076.144.000', 'EU'),
    ('217.076.160.000', 'AT'),
    ('217.076.176.000', 'EU'),
    ('217.076.192.000', 'UA'),
    ('217.076.208.000', 'EU'),
    ('217.076.224.000', 'BE'),
    ('217.076.240.000', 'EU'),
    ('217.077.000.000', 'GB'),
    ('217.077.016.000', 'EU'),
    ('217.077.032.000', 'NO'),
    ('217.077.048.000', 'EU'),
    ('217.077.064.000', 'GA'),
    ('217.077.080.000', 'EU'),
    ('217.077.096.000', 'RU'),
    ('217.077.112.000', 'EU'),
    ('217.077.128.000', 'NL'),
    ('217.077.160.000', 'CZ'),
    ('217.077.176.000', 'EU'),
    ('217.077.192.000', 'FI'),
    ('217.077.208.000', 'EU'),
    ('217.077.224.000', 'FR'),
    ('217.077.240.000', 'DE'),
    ('217.078.000.000', 'IE'),
    ('217.078.016.000', 'EU'),
    ('217.078.032.000', 'SE'),
    ('217.078.048.000', 'EU'),
    ('217.078.064.000', 'NG'),
    ('217.078.080.000', 'EU'),
    ('217.078.096.000', 'NO'),
    ('217.078.112.000', 'EU'),
    ('217.078.128.000', 'DE'),
    ('217.078.144.000', 'EU'),
    ('217.078.160.000', 'DE'),
    ('217.078.176.000', 'EU'),
    ('217.078.192.000', 'FI'),
    ('217.078.224.000', 'GR'),
    ('217.078.240.000', 'EU'),
    ('217.079.000.000', 'DE'),
    ('217.079.016.000', 'EU'),
    ('217.079.032.000', 'BG'),
    ('217.079.048.000', 'EU'),
    ('217.079.064.000', 'BG'),
    ('217.079.080.000', 'EU'),
    ('217.079.096.000', 'GB'),
    ('217.079.112.000', 'EU'),
    ('217.079.128.000', 'HU'),
    ('217.079.144.000', 'EU'),
    ('217.079.160.000', 'GB'),
    ('217.079.176.000', 'EU'),
    ('217.079.192.000', 'DE'),
    ('217.079.197.000', 'GB'),
    ('217.079.208.000', 'EU'),
    ('217.079.224.000', 'DE'),
    ('217.079.240.000', 'EU'),
    ('217.080.000.000', 'DE'),
    ('217.096.000.000', 'PL'),
    ('217.100.000.000', 'NL'),
    ('217.106.000.000', 'RU'),
    ('217.106.219.000', 'GE'),
    ('217.106.220.000', 'RU'),
    ('217.106.244.000', 'GE'),
    ('217.106.245.000', 'RU'),
    ('217.108.000.000', 'FR'),
    ('217.110.000.000', 'DE'),
    ('217.110.056.000', 'SE'),
    ('217.110.057.000', 'DE'),
    ('217.110.058.000', 'SE'),
    ('217.110.059.000', 'DE'),
    ('217.110.203.000', 'SE'),
    ('217.110.204.000', 'DE'),
    ('217.112.005.000', 'FR'),
    ('217.112.016.000', 'EU'),
    ('217.112.032.000', 'CH'),
    ('217.112.048.000', 'EU'),
    ('217.112.064.000', 'IT'),
    ('217.112.080.000', 'EU'),
    ('217.112.096.000', 'ES'),
    ('217.112.112.000', 'EU'),
    ('217.112.128.000', 'CZ'),
    ('217.112.144.000', 'EU'),
    ('217.112.160.000', 'CZ'),
    ('217.112.176.000', 'EU'),
    ('217.112.192.000', 'PT'),
    ('217.112.208.000', 'EU'),
    ('217.112.224.000', 'FR'),
    ('217.112.240.000', 'EU'),
    ('217.113.000.000', 'AM'),
    ('217.113.016.000', 'EU'),
    ('217.113.032.000', 'DE'),
    ('217.113.048.000', 'EU'),
    ('217.113.064.000', 'NL'),
    ('217.113.065.000', 'CG'),
    ('217.113.066.000', 'NL'),
    ('217.113.080.000', 'EU'),
    ('217.113.096.000', 'AT'),
    ('217.113.112.000', 'EU'),
    ('217.113.128.000', 'FR'),
    ('217.113.144.000', 'EU'),
    ('217.113.160.000', 'GB'),
    ('217.113.161.000', 'NL'),
    ('217.113.162.000', 'GB'),
    ('217.113.176.000', 'EU'),
    ('217.113.192.000', 'FR'),
    ('217.113.208.000', 'EU'),
    ('217.113.224.000', 'PL'),
    ('217.113.240.000', 'EU'),
    ('217.114.000.000', 'RU'),
    ('217.114.016.000', 'EU'),
    ('217.114.032.000', 'RU'),
    ('217.114.048.000', 'EU'),
    ('217.114.064.000', 'DE'),
    ('217.114.080.000', 'EU'),
    ('217.114.096.000', 'NL'),
    ('217.114.112.000', 'EU'),
    ('217.114.128.000', 'DE'),
    ('217.114.144.000', 'EU'),
    ('217.114.160.000', 'IE'),
    ('217.114.176.000', 'EU'),
    ('217.114.192.000', 'GB'),
    ('217.114.208.000', 'EU'),
    ('217.114.224.000', 'DE'),
    ('217.114.240.000', 'EU'),
    ('217.115.000.000', 'ES'),
    ('217.115.002.000', 'US'),
    ('217.115.003.000', 'GB'),
    ('217.115.004.000', 'ES'),
    ('217.115.016.000', 'EU'),
    ('217.115.032.000', 'SE'),
    ('217.115.064.000', 'DE'),
    ('217.115.080.000', 'EU'),
    ('217.115.096.000', 'GB'),
    ('217.115.112.000', 'EU'),
    ('217.115.128.000', 'DE'),
    ('217.115.160.000', 'FR'),
    ('217.115.176.000', 'EU'),
    ('217.115.192.000', 'NL'),
    ('217.115.208.000', 'EU'),
    ('217.115.224.000', 'NL'),
    ('217.115.240.000', 'EU'),
    ('217.116.000.000', 'ES'),
    ('217.116.016.000', 'EU'),
    ('217.116.032.000', 'HU'),
    ('217.116.038.000', 'DE'),
    ('217.116.039.000', 'HU'),
    ('217.116.048.000', 'EU'),
    ('217.116.064.000', 'AT'),
    ('217.116.080.000', 'EU'),
    ('217.116.096.000', 'PL'),
    ('217.116.112.000', 'EU'),
    ('217.116.128.000', 'RU'),
    ('217.116.160.000', 'FI'),
    ('217.116.176.000', 'EU'),
    ('217.116.192.000', 'GB'),
    ('217.116.208.000', 'EU'),
    ('217.116.224.000', 'DK'),
    ('217.116.228.000', 'NL'),
    ('217.116.229.000', 'AT'),
    ('217.116.230.000', 'DK'),
    ('217.116.240.000', 'EU'),
    ('217.117.000.000', 'NG'),
    ('217.117.016.000', 'EU'),
    ('217.117.032.000', 'BE'),
    ('217.117.064.000', 'UA'),
    ('217.117.080.000', 'EU'),
    ('217.117.096.000', 'DE'),
    ('217.117.112.000', 'EU'),
    ('217.117.128.000', 'PL'),
    ('217.117.144.000', 'EU'),
    ('217.117.160.000', 'CH'),
    ('217.117.176.000', 'EU'),
    ('217.117.192.000', 'LU'),
    ('217.117.208.000', 'EU'),
    ('217.117.224.000', 'NL'),
    ('217.117.240.000', 'EU'),
    ('217.118.000.000', 'IT'),
    ('217.118.016.000', 'EU'),
    ('217.118.032.000', 'NO'),
    ('217.118.048.000', 'EU'),
    ('217.118.064.000', 'RU'),
    ('217.118.080.000', 'EU'),
    ('217.118.096.000', 'SK'),
    ('217.118.112.000', 'EU'),
    ('217.118.128.000', 'GB'),
    ('217.118.144.000', 'EU'),
    ('217.118.160.000', 'NL'),
    ('217.118.176.000', 'EU'),
    ('217.118.192.000', 'CH'),
    ('217.118.208.000', 'EU'),
    ('217.118.224.000', 'FR'),
    ('217.118.240.000', 'EU'),
    ('217.119.000.000', 'NL'),
    ('217.119.016.000', 'EU'),
    ('217.119.032.000', 'FI'),
    ('217.119.048.000', 'EU'),
    ('217.119.064.000', 'PL'),
    ('217.119.080.000', 'EU'),
    ('217.119.096.000', 'DE'),
    ('217.119.112.000', 'EU'),
    ('217.119.128.000', 'IT'),
    ('217.119.144.000', 'EU'),
    ('217.119.160.000', 'SE'),
    ('217.119.176.000', 'EU'),
    ('217.119.192.000', 'DE'),
    ('217.119.208.000', 'EU'),
    ('217.119.224.000', 'NL'),
    ('217.119.240.000', 'EU'),
    ('217.120.000.000', 'NL'),
    ('217.124.000.000', 'ES'),
    ('217.128.000.000', 'FR'),
    ('217.129.000.000', 'PT'),
    ('217.130.000.000', 'ES'),
    ('217.131.000.000', 'TR'),
    ('217.132.000.000', 'EU'),
    ('217.133.000.000', 'IT'),
    ('217.134.000.000', 'GB'),
    ('217.136.000.000', 'BE'),
    ('217.137.000.000', 'GB'),
    ('217.138.000.000', 'EU'),
    ('217.138.001.000', 'MT'),
    ('217.138.002.000', 'US'),
    ('217.138.005.000', 'MT'),
    ('217.138.035.000', 'GD'),
    ('217.138.036.000', 'MT'),
    ('217.138.040.000', 'GB'),
    ('217.138.041.000', 'MT'),
    ('217.139.000.000', 'EG'),
    ('217.140.000.000', 'NL'),
    ('217.140.016.000', 'ES'),
    ('217.140.032.000', 'GB'),
    ('217.140.064.000', 'FR'),
    ('217.140.096.000', 'DE'),
    ('217.140.128.000', 'EU'),
    ('217.141.000.000', 'IT'),
    ('217.142.000.000', 'SE'),
    ('217.144.000.000', 'JO'),
    ('217.144.016.000', 'EU'),
    ('217.144.032.000', 'DE'),
    ('217.144.048.000', 'EU'),
    ('217.144.064.000', 'UA'),
    ('217.144.080.000', 'EU'),
    ('217.144.096.000', 'RU'),
    ('217.144.112.000', 'EU'),
    ('217.144.128.000', 'NO'),
    ('217.144.144.000', 'EU'),
    ('217.144.160.000', 'DE'),
    ('217.144.165.000', 'IT'),
    ('217.144.166.000', 'BE'),
    ('217.144.167.000', 'DE'),
    ('217.144.176.000', 'EU'),
    ('217.144.192.000', 'PL'),
    ('217.144.224.000', '--'),
    ('217.144.225.000', 'NO'),
    ('217.144.227.000', 'BE'),
    ('217.144.228.000', 'NO'),
    ('217.144.229.000', 'BE'),
    ('217.144.232.000', 'NO'),
    ('217.144.234.000', 'BE'),
    ('217.144.235.000', 'NO'),
    ('217.144.237.000', 'BE'),
    ('217.144.239.000', 'NO'),
    ('217.144.240.000', 'EU'),
    ('217.145.000.000', 'MT'),
    ('217.145.016.000', 'EU'),
    ('217.145.032.000', 'BE'),
    ('217.145.048.000', 'EU'),
    ('217.145.064.000', 'GB'),
    ('217.145.080.000', 'EU'),
    ('217.145.096.000', 'DE'),
    ('217.145.112.000', 'EU'),
    ('217.145.128.000', 'DE'),
    ('217.145.144.000', 'EU'),
    ('217.145.160.000', 'BG'),
    ('217.145.176.000', 'EU'),
    ('217.145.192.000', 'SK'),
    ('217.145.208.000', 'EU'),
    ('217.145.224.000', 'GB'),
    ('217.145.240.000', 'EU'),
    ('217.146.000.000', 'US'),
    ('217.146.004.000', 'LR'),
    ('217.146.005.000', 'NG'),
    ('217.146.010.000', 'GB'),
    ('217.146.011.000', 'NG'),
    ('217.146.017.000', 'GB'),
    ('217.146.032.000', 'RU'),
    ('217.146.048.000', 'EU'),
    ('217.146.064.000', 'IT'),
    ('217.146.080.000', 'EU'),
    ('217.146.096.000', 'GB'),
    ('217.146.112.000', 'EU'),
    ('217.146.128.000', 'DE'),
    ('217.146.144.000', 'EU'),
    ('217.146.160.000', 'PL'),
    ('217.146.176.000', 'EU'),
    ('217.146.192.000', 'RU'),
    ('217.146.208.000', 'EU'),
    ('217.146.224.000', 'FR'),
    ('217.146.240.000', 'EU'),
    ('217.147.000.000', 'RU'),
    ('217.147.016.000', 'EU'),
    ('217.147.032.000', 'LT'),
    ('217.147.048.000', 'EU'),
    ('217.147.064.000', 'GB'),
    ('217.147.067.000', 'DE'),
    ('217.147.080.000', 'EU'),
    ('217.147.096.000', 'DE'),
    ('217.147.112.000', 'EU'),
    ('217.147.128.000', 'IT'),
    ('217.147.144.000', 'EU'),
    ('217.147.160.000', 'UA'),
    ('217.147.176.000', 'EU'),
    ('217.147.192.000', 'FR'),
    ('217.147.208.000', 'EU'),
    ('217.147.224.000', 'GE'),
    ('217.147.240.000', 'EU'),
    ('217.148.000.000', 'CH'),
    ('217.148.016.000', 'EU'),
    ('217.148.032.000', 'GB'),
    ('217.148.048.000', 'EU'),
    ('217.148.064.000', 'ES'),
    ('217.148.080.000', 'EU'),
    ('217.148.096.000', 'IT'),
    ('217.148.112.000', 'EU'),
    ('217.148.128.000', 'DE'),
    ('217.148.144.000', 'EU'),
    ('217.148.160.000', 'NL'),
    ('217.148.176.000', 'EU'),
    ('217.148.192.000', 'RU'),
    ('217.148.208.000', 'EU'),
    ('217.148.224.000', 'DE'),
    ('217.148.240.000', 'EU'),
    ('217.149.000.000', 'ES'),
    ('217.149.016.000', 'EU'),
    ('217.149.032.000', 'NL'),
    ('217.149.048.000', 'EU'),
    ('217.149.064.000', 'NL'),
    ('217.149.080.000', 'EU'),
    ('217.149.096.000', 'GB'),
    ('217.149.112.000', 'EU'),
    ('217.149.128.000', 'CZ'),
    ('217.149.144.000', 'EU'),
    ('217.149.176.000', 'GB'),
    ('217.149.192.000', 'NL'),
    ('217.149.208.000', 'EU'),
    ('217.149.224.000', 'AT'),
    ('217.149.240.000', 'EU'),
    ('217.150.000.000', 'RU'),
    ('217.150.064.000', 'SE'),
    ('217.150.096.000', 'GB'),
    ('217.150.112.000', 'EU'),
    ('217.150.128.000', 'HU'),
    ('217.150.144.000', 'EU'),
    ('217.150.160.000', 'SE'),
    ('217.150.176.000', 'EU'),
    ('217.150.192.000', 'RU'),
    ('217.150.208.000', 'EU'),
    ('217.150.224.000', 'GR'),
    ('217.150.240.000', 'EU'),
    ('217.151.000.000', 'FR'),
    ('217.151.016.000', 'EU'),
    ('217.151.032.000', 'GB'),
    ('217.151.048.000', 'EU'),
    ('217.151.064.000', 'RU'),
    ('217.151.080.000', 'EU'),
    ('217.151.096.000', 'GB'),
    ('217.151.112.000', 'EU'),
    ('217.151.128.000', 'RU'),
    ('217.151.144.000', 'EU'),
    ('217.151.160.000', 'IS'),
    ('217.151.176.000', 'EU'),
    ('217.151.192.000', 'SE'),
    ('217.151.208.000', 'DE'),
    ('217.151.225.000', 'RU'),
    ('217.151.229.000', 'DE'),
    ('217.151.230.000', 'AM'),
    ('217.151.234.000', 'TJ'),
    ('217.151.236.000', 'DE'),
    ('217.151.240.000', 'EU'),
    ('217.152.000.000', 'FI'),
    ('217.153.000.000', 'PL'),
    ('217.153.128.000', 'EU'),
    ('217.154.000.000', 'GB'),
    ('217.155.000.000', 'NL'),
    ('217.156.000.000', 'RO'),
    ('217.156.128.000', 'EU'),
    ('217.156.135.000', 'GB'),
    ('217.157.000.000', 'DK'),
    ('217.158.000.000', 'GB'),
    ('217.159.000.000', 'DE'),
    ('217.159.128.000', 'EU'),
    ('217.160.000.000', 'DE'),
    ('217.161.000.000', 'GB'),
    ('217.161.004.000', 'CH'),
    ('217.161.008.000', 'US'),
    ('217.161.009.000', 'GB'),
    ('217.161.016.000', 'IR'),
    ('217.161.018.000', 'GB'),
    ('217.161.026.000', 'US'),
    ('217.161.028.000', 'GB'),
    ('217.162.000.000', 'CH'),
    ('217.163.000.000', 'GB'),
    ('217.164.000.000', 'AE'),
    ('217.166.000.000', 'NL'),
    ('217.167.000.000', 'FR'),
    ('217.168.000.000', 'ES'),
    ('217.168.016.000', 'EU'),
    ('217.168.032.000', 'CH'),
    ('217.168.048.000', 'EU'),
    ('217.168.064.000', 'RU'),
    ('217.168.080.000', 'EU'),
    ('217.168.096.000', 'FR'),
    ('217.168.112.000', 'EU'),
    ('217.168.128.000', 'PL'),
    ('217.168.144.000', 'EU'),
    ('217.168.160.000', 'MT'),
    ('217.168.176.000', 'EU'),
    ('217.168.192.000', 'PL'),
    ('217.168.208.000', 'EU'),
    ('217.168.224.000', 'IT'),
    ('217.168.240.000', 'EU'),
    ('217.169.000.000', 'GB'),
    ('217.169.048.000', 'EU'),
    ('217.169.064.000', 'FI'),
    ('217.169.080.000', 'EU'),
    ('217.169.096.000', 'IT'),
    ('217.169.128.000', 'CH'),
    ('217.169.144.000', 'EU'),
    ('217.169.160.000', 'GB'),
    ('217.169.176.000', 'EU'),
    ('217.169.192.000', 'TR'),
    ('217.169.208.000', 'EU'),
    ('217.169.224.000', 'NL'),
    ('217.169.240.000', 'EU'),
    ('217.170.000.000', 'NL'),
    ('217.170.016.000', 'EU'),
    ('217.170.032.000', 'NL'),
    ('217.170.048.000', 'EU'),
    ('217.170.064.000', 'RU'),
    ('217.170.096.000', 'DE'),
    ('217.170.112.000', 'EU'),
    ('217.170.128.000', 'NO'),
    ('217.170.144.000', 'EU'),
    ('217.170.160.000', 'IT'),
    ('217.170.176.000', 'EU'),
    ('217.170.192.000', 'GR'),
    ('217.170.208.000', 'EU'),
    ('217.170.224.000', 'IT'),
    ('217.170.240.000', 'EU'),
    ('217.171.000.000', 'RU'),
    ('217.171.016.000', 'EU'),
    ('217.171.032.000', 'IT'),
    ('217.171.048.000', 'EU'),
    ('217.171.064.000', 'RU'),
    ('217.171.080.000', 'EU'),
    ('217.171.096.000', 'GB'),
    ('217.171.112.000', 'EU'),
    ('217.171.128.000', 'GB'),
    ('217.171.144.000', 'EU'),
    ('217.171.160.000', 'IT'),
    ('217.171.176.000', 'EU'),
    ('217.171.192.000', 'DE'),
    ('217.171.208.000', 'EU'),
    ('217.171.224.000', 'RU'),
    ('217.171.240.000', 'EU'),
    ('217.172.000.000', 'IT'),
    ('217.172.016.000', 'EU'),
    ('217.172.064.000', 'ES'),
    ('217.172.080.000', 'EU'),
    ('217.172.096.000', 'CH'),
    ('217.172.112.000', 'EU'),
    ('217.172.128.000', 'IT'),
    ('217.172.144.000', 'EU'),
    ('217.172.160.000', 'DE'),
    ('217.172.192.000', 'IT'),
    ('217.172.224.000', 'PL'),
    ('217.172.240.000', 'EU'),
    ('217.173.000.000', 'RU'),
    ('217.173.016.000', 'EU'),
    ('217.173.032.000', 'HU'),
    ('217.173.048.000', 'EU'),
    ('217.173.064.000', 'GB'),
    ('217.173.080.000', 'EU'),
    ('217.173.096.000', 'IE'),
    ('217.173.101.000', 'GB'),
    ('217.173.102.000', 'IE'),
    ('217.173.106.000', 'GB'),
    ('217.173.108.000', 'IE'),
    ('217.173.112.000', 'EU'),
    ('217.173.128.000', 'DE'),
    ('217.173.152.000', 'NL'),
    ('217.173.160.000', 'DE'),
    ('217.173.176.000', 'EU'),
    ('217.173.192.000', 'PL'),
    ('217.173.208.000', 'EU'),
    ('217.173.224.000', 'LI'),
    ('217.173.240.000', 'EU'),
    ('217.174.000.000', 'BE'),
    ('217.174.016.000', 'EU'),
    ('217.174.032.000', 'TR'),
    ('217.174.048.000', 'EU'),
    ('217.174.064.000', 'SE'),
    ('217.174.080.000', 'EU'),
    ('217.174.096.000', 'RU'),
    ('217.174.112.000', 'EU'),
    ('217.174.128.000', 'GB'),
    ('217.174.144.000', 'EU'),
    ('217.174.160.000', 'SL'),
    ('217.174.176.000', 'EU'),
    ('217.174.192.000', 'FR'),
    ('217.174.208.000', 'EU'),
    ('217.174.224.000', 'TM'),
    ('217.174.240.000', 'EU'),
    ('217.175.000.000', 'DE'),
    ('217.175.001.000', 'NL'),
    ('217.175.002.000', 'DE'),
    ('217.175.016.000', 'EU'),
    ('217.175.032.000', 'FR'),
    ('217.175.033.000', 'NL'),
    ('217.175.034.000', 'FR'),
    ('217.175.048.000', 'EU'),
    ('217.175.064.000', 'NL'),
    ('217.175.066.000', 'GB'),
    ('217.175.079.000', 'NL'),
    ('217.175.080.000', 'EU'),
    ('217.175.096.000', 'DE'),
    ('217.175.112.000', 'EU'),
    ('217.175.128.000', 'RU'),
    ('217.175.160.000', 'FR'),
    ('217.175.167.000', 'MQ'),
    ('217.175.168.000', 'FR'),
    ('217.175.169.000', 'RE'),
    ('217.175.170.000', 'FR'),
    ('217.175.176.000', 'EU'),
    ('217.175.192.000', 'AT'),
    ('217.175.208.000', 'EU'),
    ('217.175.224.000', 'DE'),
    ('217.175.226.000', 'AT'),
    ('217.175.227.000', 'DE'),
    ('217.175.233.000', 'US'),
    ('217.175.234.000', 'DM'),
    ('217.175.235.000', 'DE'),
    ('217.175.239.000', 'US'),
    ('217.175.240.000', 'DE'),
    ('217.175.243.000', 'AT'),
    ('217.175.244.000', 'DE'),
    ('217.176.000.000', 'GB'),
    ('217.184.000.000', 'DE'),
    ('217.192.000.000', 'CH'),
    ('217.194.000.000', 'IT'),
    ('217.194.016.000', 'EU'),
    ('217.194.032.000', 'DE'),
    ('217.194.048.000', 'EU'),
    ('217.194.064.000', 'DE'),
    ('217.194.080.000', 'EU'),
    ('217.194.096.000', 'NL'),
    ('217.194.112.000', 'EU'),
    ('217.194.128.000', 'GB'),
    ('217.194.130.000', 'UA'),
    ('217.194.132.000', 'GB'),
    ('217.194.144.000', 'EU'),
    ('217.194.160.000', 'HU'),
    ('217.194.176.000', 'EU'),
    ('217.194.192.000', 'IL'),
    ('217.194.208.000', 'EU'),
    ('217.194.224.000', 'DE'),
    ('217.194.240.000', 'EU'),
    ('217.195.000.000', 'DE'),
    ('217.195.016.000', 'EU'),
    ('217.195.032.000', 'DE'),
    ('217.195.034.000', 'AT'),
    ('217.195.035.000', 'DE'),
    ('217.195.048.000', 'EU'),
    ('217.195.064.000', 'RU'),
    ('217.195.112.000', 'EU'),
    ('217.195.128.000', 'GR'),
    ('217.195.144.000', 'EU'),
    ('217.195.160.000', 'CZ'),
    ('217.195.176.000', 'EU'),
    ('217.195.192.000', 'TR'),
    ('217.195.208.000', 'EU'),
    ('217.195.224.000', 'NL'),
    ('217.195.240.000', 'EU'),
    ('217.196.000.000', 'GB'),
    ('217.196.016.000', 'EU'),
    ('217.196.032.000', 'NL'),
    ('217.196.048.000', 'EU'),
    ('217.196.064.000', 'AT'),
    ('217.196.080.000', 'EU'),
    ('217.196.096.000', 'RU'),
    ('217.196.128.000', 'HU'),
    ('217.196.144.000', 'EU'),
    ('217.196.160.000', 'UA'),
    ('217.196.175.000', 'SE'),
    ('217.196.176.000', 'EU'),
    ('217.196.192.000', 'DE'),
    ('217.196.208.000', 'EU'),
    ('217.196.224.000', 'GB'),
    ('217.196.240.000', 'EU'),
    ('217.197.000.000', 'DE'),
    ('217.197.016.000', 'EU'),
    ('217.197.032.000', 'GB'),
    ('217.197.048.000', 'EU'),
    ('217.197.064.000', 'NL'),
    ('217.197.080.000', 'EU'),
    ('217.197.096.000', 'LU'),
    ('217.197.112.000', 'EU'),
    ('217.197.128.000', 'BG'),
    ('217.197.144.000', 'EU'),
    ('217.197.160.000', 'PL'),
    ('217.197.176.000', 'EU'),
    ('217.197.192.000', 'GB'),
    ('217.197.208.000', 'EU'),
    ('217.197.224.000', 'DE'),
    ('217.197.240.000', 'EU'),
    ('217.198.000.000', 'RU'),
    ('217.198.016.000', 'EU'),
    ('217.198.032.000', 'GB'),
    ('217.198.047.000', 'BE'),
    ('217.198.048.000', 'EU'),
    ('217.198.064.000', 'DE'),
    ('217.198.080.000', 'EU'),
    ('217.198.096.000', 'HR'),
    ('217.198.112.000', 'EU'),
    ('217.198.128.000', 'UA'),
    ('217.198.144.000', 'EU'),
    ('217.198.160.000', 'RU'),
    ('217.198.176.000', 'EU'),
    ('217.198.192.000', 'NL'),
    ('217.198.208.000', 'EU'),
    ('217.198.224.000', 'LV'),
    ('217.198.240.000', 'EU'),
    ('217.199.000.000', 'IT'),
    ('217.199.016.000', 'EU'),
    ('217.199.032.000', 'NO'),
    ('217.199.035.000', 'SE'),
    ('217.199.036.000', 'NO'),
    ('217.199.046.000', 'SE'),
    ('217.199.048.000', 'NO'),
    ('217.199.064.000', 'DE'),
    ('217.199.080.000', 'EU'),
    ('217.199.096.000', 'LV'),
    ('217.199.128.000', 'BA'),
    ('217.199.144.000', 'EU'),
    ('217.199.160.000', 'GB'),
    ('217.199.176.000', 'EU'),
    ('217.199.192.000', 'GR'),
    ('217.199.208.000', 'EU'),
    ('217.199.224.000', 'SE'),
    ('217.199.240.000', 'EU'),
    ('217.200.000.000', 'IT'),
    ('217.204.000.000', 'GB'),
    ('217.208.000.000', 'SE'),
    ('217.216.000.000', 'ES'),
    ('217.218.000.000', 'IR'),
    ('217.220.000.000', 'IT'),
    ('217.221.000.000', 'EU'),
    ('217.222.000.000', 'IT'),
    ('217.224.000.000', 'DE'),
    ('218.000.000.000', 'CN'),
    ('218.032.000.000', 'TW'),
    ('218.033.000.000', 'AU'),
    ('218.040.000.000', 'JP'),
    ('218.048.000.000', 'KR'),
    ('218.048.051.000', 'GB'),
    ('218.048.052.000', 'KR'),
    ('218.056.000.000', 'CN'),
    ('218.100.000.000', 'AU'),
    ('218.101.000.000', 'NZ'),
    ('218.101.064.000', 'AU'),
    ('218.102.000.000', 'HK'),
    ('218.104.000.000', 'CN'),
    ('218.109.000.000', 'AU'),
    ('218.112.000.000', 'JP'),
    ('218.144.000.000', 'KR'),
    ('218.160.000.000', 'TW'),
    ('218.166.000.000', 'AU'),
    ('218.176.000.000', 'JP'),
    ('218.184.000.000', 'TW'),
    ('218.185.000.000', 'AU'),
    ('218.186.000.000', 'SG'),
    ('218.186.128.000', 'AU'),
    ('218.188.000.000', 'HK'),
    ('218.188.128.000', 'AU'),
    ('218.192.000.000', 'CN'),
    ('218.206.000.000', 'AU'),
    ('218.216.000.000', 'JP'),
    ('218.232.000.000', 'KR'),
    ('218.234.000.000', 'AU'),
    ('218.240.000.000', 'CN'),
    ('218.246.000.000', 'AU'),
    ('218.248.000.000', 'IN'),
    ('218.249.000.000', 'AU'),
    ('218.252.000.000', 'HK'),
    ('218.252.128.000', 'AU'),
    ('219.000.000.000', 'JP'),
    ('219.003.097.000', 'UA'),
    ('219.003.098.000', 'JP'),
    ('219.064.000.000', 'IN'),
    ('219.066.000.000', 'AU'),
    ('219.068.000.000', 'TW'),
    ('219.068.128.000', 'AU'),
    ('219.072.000.000', 'CN'),
    ('219.073.000.000', 'AU'),
    ('219.076.000.000', 'HK'),
    ('219.076.064.000', 'AU'),
    ('219.096.000.000', 'JP'),
    ('219.128.000.000', 'CN'),
    ('219.160.000.000', 'AU'),
    ('221.000.000.000', 'US'),
    ('221.097.210.000', 'DK'),
    ('221.097.211.000', 'US'),
]

from bisect import bisect_left
def lookup(ipaddr):
    """Return a tuple (country code, country name) for a given IP address."""
    parts = tuple(map(int, ipaddr.split('.')))
    target = ('%03d.%03d.%03d.%03d' % parts, '')
    lo = max(bisect_left(addrmap, target) - 1, 0)
    start, cc = addrmap[lo]
    return cc, countries[cc]

assert lookup("129.97.128.15")[0] == "CA"
assert lookup("217.198.112.1")[0] == "EU"
assert lookup("221.97.211.1")[0] == "US" 
assert lookup("0.0.0.0")[0] == "US"
assert lookup("0.0.0.1")[0] == "US"
assert lookup("0.255.255.255")[0] == "US"
assert lookup("1.0.0.1")[0] == "IN"
assert lookup("1.0.0.255")[0] == "IN"

