; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-- | FileCheck %s

define void @test_load_store(half* %in, half* %out) {
; CHECK-LABEL: test_load_store:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr h0, [x0]
; CHECK-NEXT:    str h0, [x1]
; CHECK-NEXT:    ret
  %val = load half, half* %in
  store half %val, half* %out
  ret void
}

define i16 @test_bitcast_from_half(half* %addr) {
; CHECK-LABEL: test_bitcast_from_half:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrh w0, [x0]
; CHECK-NEXT:    ret
  %val = load half, half* %addr
  %val_int = bitcast half %val to i16
  ret i16 %val_int
}

define i16 @test_reg_bitcast_from_half(half %in) {
; CHECK-LABEL: test_reg_bitcast_from_half:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $h0 killed $h0 def $s0
; CHECK-NEXT:    fmov w0, s0
; CHECK-NEXT:    ret
  %val = bitcast half %in to i16
  ret i16 %val
}

define void @test_bitcast_to_half(half* %addr, i16 %in) {
; CHECK-LABEL: test_bitcast_to_half:
; CHECK:       // %bb.0:
; CHECK-NEXT:    strh w1, [x0]
; CHECK-NEXT:    ret
  %val_fp = bitcast i16 %in to half
  store half %val_fp, half* %addr
  ret void
}

define half @test_reg_bitcast_to_half(i16 %in) {
; CHECK-LABEL: test_reg_bitcast_to_half:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov s0, w0
; CHECK-NEXT:    // kill: def $h0 killed $h0 killed $s0
; CHECK-NEXT:    ret
  %val = bitcast i16 %in to half
  ret half %val
}

define float @test_extend32(half* %addr) {
; CHECK-LABEL: test_extend32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr h0, [x0]
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    ret
  %val16 = load half, half* %addr
  %val32 = fpext half %val16 to float
  ret float %val32
}

define double @test_extend64(half* %addr) {
; CHECK-LABEL: test_extend64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr h0, [x0]
; CHECK-NEXT:    fcvt d0, h0
; CHECK-NEXT:    ret
  %val16 = load half, half* %addr
  %val32 = fpext half %val16 to double
  ret double %val32
}

define void @test_trunc32(float %in, half* %addr) {
; CHECK-LABEL: test_trunc32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    str h0, [x0]
; CHECK-NEXT:    ret
  %val16 = fptrunc float %in to half
  store half %val16, half* %addr
  ret void
}

define void @test_trunc64(double %in, half* %addr) {
; CHECK-LABEL: test_trunc64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvt h0, d0
; CHECK-NEXT:    str h0, [x0]
; CHECK-NEXT:    ret
  %val16 = fptrunc double %in to half
  store half %val16, half* %addr
  ret void
}

define i16 @test_fccmp(i1 %a, i16 %in) {
; CHECK-LABEL: test_fccmp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #24576
; CHECK-NEXT:    fmov s0, w1
; CHECK-NEXT:    movk w8, #15974, lsl #16
; CHECK-NEXT:    mov w9, #16384
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    movk w9, #15428, lsl #16
; CHECK-NEXT:    fmov s1, w8
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    fmov s2, w9
; CHECK-NEXT:    mov w10, #4
; CHECK-NEXT:    fccmp s0, s2, #8, pl
; CHECK-NEXT:    csinc w8, w10, wzr, mi
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cinc w0, w8, pl
; CHECK-NEXT:    ret
  %f16 = bitcast i16 %in to half
  %cmp0 = fcmp ogt half 0xH3333, %f16
  %cmp1 = fcmp ogt half 0xH2222, %f16
  %x = select i1 %cmp0, i16 0, i16 1
  %or = or i1 %cmp1, %cmp0
  %y = select i1 %or, i16 4, i16 1
  %r = add i16 %x, %y
  ret i16 %r
}
