/* sortedmap.c generated by valac 0.56.17, the Vala compiler
 * generated from sortedmap.vala, do not modify */

/* sortedset.vala
 *
 * Copyright (C) 2009-2011  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static GType gee_sorted_map_get_type_once (void);

/**
 * Returns map containing pairs with key strictly lower the the argument.
 */
GeeSortedMap*
gee_sorted_map_head_map (GeeSortedMap* self,
                         gconstpointer before)
{
	GeeSortedMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_MAP_GET_INTERFACE (self);
	if (_iface_->head_map) {
		return _iface_->head_map (self, before);
	}
	return NULL;
}

/**
 * Returns map containing pairs with key equal or larger then the argument.
 */
GeeSortedMap*
gee_sorted_map_tail_map (GeeSortedMap* self,
                         gconstpointer after)
{
	GeeSortedMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_MAP_GET_INTERFACE (self);
	if (_iface_->tail_map) {
		return _iface_->tail_map (self, after);
	}
	return NULL;
}

/**
 * Returns right-open map (i.e. containing all pair which key is strictly
 * lower then the second argument and equal or bigger then the first one).
 *
 * Null as one parameter means that it should include all from this side.
 */
GeeSortedMap*
gee_sorted_map_sub_map (GeeSortedMap* self,
                        gconstpointer before,
                        gconstpointer after)
{
	GeeSortedMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_MAP_GET_INTERFACE (self);
	if (_iface_->sub_map) {
		return _iface_->sub_map (self, before, after);
	}
	return NULL;
}

/**
 * Returns an immutable empty map.
 *
 * @return an immutable empty map
 */
GeeMap*
gee_sorted_map_empty (GType k_type,
                      GBoxedCopyFunc k_dup_func,
                      GDestroyNotify k_destroy_func,
                      GType v_type,
                      GBoxedCopyFunc v_dup_func,
                      GDestroyNotify v_destroy_func)
{
	GeeTreeMap* _tmp0_;
	GeeTreeMap* _tmp1_;
	GeeBidirSortedMap* _tmp2_;
	GeeBidirSortedMap* _tmp3_;
	GeeMap* _tmp4_;
	GeeMap* result;
	_tmp0_ = gee_tree_map_new (k_type, (GBoxedCopyFunc) k_dup_func, (GDestroyNotify) k_destroy_func, v_type, (GBoxedCopyFunc) v_dup_func, (GDestroyNotify) v_destroy_func, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_bidir_sorted_map_get_read_only_view ((GeeAbstractBidirSortedMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GeeMap*) _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

GeeSortedSet*
gee_sorted_map_get_ascending_keys (GeeSortedMap* self)
{
	GeeSortedMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_MAP_GET_INTERFACE (self);
	if (_iface_->get_ascending_keys) {
		return _iface_->get_ascending_keys (self);
	}
	return NULL;
}

GeeSortedSet*
gee_sorted_map_get_ascending_entries (GeeSortedMap* self)
{
	GeeSortedMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_MAP_GET_INTERFACE (self);
	if (_iface_->get_ascending_entries) {
		return _iface_->get_ascending_entries (self);
	}
	return NULL;
}

GeeSortedMap*
gee_sorted_map_get_read_only_view (GeeSortedMap* self)
{
	GeeSortedMapIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_SORTED_MAP_GET_INTERFACE (self);
	if (_iface_->get_read_only_view) {
		return _iface_->get_read_only_view (self);
	}
	return NULL;
}

static void
gee_sorted_map_default_init (GeeSortedMapIface * iface,
                             gpointer iface_data)
{
	/**
	 * Returns the keys in ascending order.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("ascending-keys", "ascending-keys", "ascending-keys", GEE_TYPE_SORTED_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Returns the entries in ascending order.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("ascending-entries", "ascending-entries", "ascending-entries", GEE_TYPE_SORTED_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The read-only view this map.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_SORTED_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
gee_sorted_map_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeSortedMapIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_sorted_map_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_sorted_map_type_id;
	gee_sorted_map_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeSortedMap", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_sorted_map_type_id, GEE_TYPE_MAP);
	return gee_sorted_map_type_id;
}

GType
gee_sorted_map_get_type (void)
{
	static volatile gsize gee_sorted_map_type_id__once = 0;
	if (g_once_init_enter (&gee_sorted_map_type_id__once)) {
		GType gee_sorted_map_type_id;
		gee_sorted_map_type_id = gee_sorted_map_get_type_once ();
		g_once_init_leave (&gee_sorted_map_type_id__once, gee_sorted_map_type_id);
	}
	return gee_sorted_map_type_id__once;
}

