/* Copyright (C) 2008 Xavier Pujol.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#ifndef TOP_ENUM_H
#define TOP_ENUM_H

#include "util.h"

class Enumerator {
public:
  Enumerator(const FloatMatrix& mu, const FloatVect& rdiag,
    const FloatVect& targetcoord, const Float& maxVolume, int minLevel);
  bool enumNext(const Float& maxsqrlength);
  inline const FloatVect& getSubTree() {
    return subTree;
  }
private:
  const FloatMatrix& mu;
  const FloatVect& rdiag;
  const FloatVect& targetcoord;
  int k, kmin, kmax, d;
  FloatVect center, dist;
  FloatVect x, dx, ddx;
  FloatVect subTree;
  Float maxVolume;
  bool svpInitNeeded, solveSVP;
};

#endif
