/* Copyright (C) 2008 Xavier Pujol.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#ifndef SOLVER_H
#define SOLVER_H

#include "util.h"

const double DEF_MAX_VOLUME = 20000000;
const int DEF_MIN_LEVEL = 20;
const double EPS_BEST_DIST = 1.001;
const int DEF_PRECISION = -1;
const int AUTOMATIC_PRECISION = -2;

const double SLV_ETA = 0.51;
const double SLV_DELTA = 0.99;
const double SLV_EPS = 0.03;
const double SLV_RHO = ((1.0 + SLV_ETA) * (1.0 + SLV_ETA) + SLV_EPS) /
  (SLV_DELTA - SLV_ETA * SLV_ETA);

enum EvaluatorType {
  evalFast,
  evalSmart,
  evalExact
};

class Solver {
public:
  Solver() : verbose(1), minLevel(DEF_MIN_LEVEL),
    evaluatorType(evalFast), precision(DEF_PRECISION) {
    maxVolume.set(DEF_MAX_VOLUME);
  }

  inline void solveSVP(const IntMatrix& intMatrix, IntVect& solCoord) {
    IntVect emptyTarget;
    solveCVP(intMatrix, emptyTarget, solCoord);
  }
  void solveCVP(const IntMatrix& intMatrix,
    const IntVect& intTarget, IntVect& solCoord);

  int verbose;
  Float maxVolume;
  int minLevel;
  EvaluatorType evaluatorType;
  int precision;

  double maxError;
  bool validMaxError;
  bool certifiedSol;
};

#endif
