/* Copyright (C) 2005-2008 Damien Stehle.
Copyright (C) 2007 David Cade.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */


#ifndef PROVED_H
#define PROVED_H


template<class ZT, class FT>
class proved//:public LLLmethod<ZT,FT>
{
  int shift;
  int prec;
  int kappa;
  ZZ_mat<ZT>*G;
  ZZ_mat<ZT>*B;
  ZZ_mat<ZT>*U;
  FP_mat<FT>*mu;
  FP_mat<FT>*r;
  FP_NR<FT>*s;
  double eta,delta;
  FP_NR<FT> halfplus, onedotfive, ctt;

protected:
  inline void helper1U(int j,int xx,int kappa,int d, ZZ_mat<ZT>*U);
  inline void helper0XP(int zeros,int kappa,int j,Z_NR<ZT>& ztmp,int n,int d,int kappamax);
  inline void helper0XM(int zeros,int kappa,int j,Z_NR<ZT>& ztmp,int n,int d,int kappamax);
  inline void GSO(int a, int zeros, int kappamax, int n,
		  Z_NR<ZT>& ztmp, FP_NR<FT>& tmp, FP_NR<FT>& rtmp,FP_NR<FT>&max,
		  int aa);
public:
  int Babai (int, int, int, int, 
	      Z_NR<ZT>&, FP_NR<FT>&, FP_NR<FT>&,FP_NR<FT>&,FP_NR<FT>&,FP_NR<FT>&);
  int LLL ();
  proved(ZZ_mat<ZT>*B,int precision=0,double eta=0.51,double delta=0.99);

  ZZ_mat<ZT>* GetBase();
  ~proved();
};
#include "proved.cpp"

#endif
