/* 
Copyright (C) 2005-2008 Damien Stehle.
Copyright (C) 2007 David Cade.

This file is part of the fplll Library.

The fplll Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The fplll Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the fplll Library; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA. */

#include "main.h"

void printhelp(void)
{
  cerr<<"Options  : "<< endl
      << " r <d> <b> : gen_intrel"<<endl
      << " s <d> <b> <b2> : gen_simdioph"<< endl
      << " u <d> <b> : gen_uniform"<< endl
      << " n <d> <b> <q> : gen_ntrulike"<<endl
      << " N <d> <b> <q> : gen_ntrulike2"<<endl
      << " a <d> <f> : gen_ajtai"<<endl
      << " A <d> : gen_ajtai2"<<endl;
}

int main(int argc,char*argv[])
{
  if ((argc<2)||
      ((argv[1][0]!='A')&&(argc<4))||
      ((argv[1][0]=='A')&&(argc<3)))
    {
      printhelp();
      return 1;
    }
  ZZ_mat<mpz_t>* m;
  int d= atoi(argv[2]);
  FP_NR<mpfr_t> *w;
  int i;

  //initialization+filling of the matrix
  switch(argv[1][0])
    {
    case 'r':
      {
	int b=atoi(argv[3]);
	m= new ZZ_mat<mpz_t>(d,d+1);
	m->gen_intrel(b);
	break;
      }
    case 's':
      {
	int b=atoi(argv[3]);
	int b2=atoi(argv[4]);
	m=new ZZ_mat<mpz_t>(d+1,d+1);
	m->gen_simdioph(b,b2);
	break;
      }
    case 'u':
      {
	int b=atoi(argv[3]);
	m=new ZZ_mat<mpz_t>(d,d);
	m->gen_uniform(b);
	break;
      }
    case 'n':
      {
	int b=atoi(argv[3]);
	int q=atoi(argv[4]);
	m=new ZZ_mat<mpz_t>(2*d,2*d);
	m->gen_ntrulike(b,q);
	break;
      }
    case 'N':
      {
	int b=atoi(argv[3]);
	int q=atoi(argv[4]);
	m=new ZZ_mat<mpz_t>(2*d,2*d);
	m->gen_ntrulike2(b,q);
	break;
      }
    case 'a':
      {
	double alpha=atof(argv[3]);
	m=new ZZ_mat<mpz_t>(d,d);
	m->gen_ajtai(alpha);
	break;
      }
    case 'A':
      {
	w = new FP_NR<mpfr_t>[d];

	for (i=0; i<d; i++)
	  mpfr_inp_str ((w[i]).GetData(), stdin, 10, GMP_RNDN);

	m=new ZZ_mat<mpz_t>(d,d);

	m->gen_ajtai2(w);

	delete[] w;

	break;
      }
    default:
      {
	printhelp();
	return 1;
	break;
      }
    }
  m->print();
  delete m;
  return 0;
}
