from __future__ import annotations
from collections.abc import Callable
from typing import Any

class Function:
    def __init__(self, name: str, nargs: int, latex_name: str | None = None, conversions: dict[str, Any] | None = None, evalf_params_first: bool = True, alt_name: str | None = None):
        ...

    def _evalf_try_(self, *args: Any) -> Any:
        ...

    def __hash__(self) -> int:
        ...

    def __repr__(self) -> str:
        ...

    def _latex_(self) -> str:
        ...

    def __richcmp__(self, other: Any, op: int) -> bool:
        ...

    def __call__(self, *args: Any, coerce: bool = True, hold: bool = False) -> Any:
        ...

    def name(self) -> str:
        ...

    def number_of_arguments(self) -> int:
        ...

    def variables(self) -> tuple:
        ...

    def default_variable(self) -> Any:
        ...

    def _is_numerical(self, x: Any) -> bool:
        ...

    def _interface_init_(self, I: Any = None) -> str:
        ...

    def _mathematica_init_(self) -> str:
        ...

    def _sympy_init_(self, I: Any = None) -> str:
        ...

    @property
    def _sympy_(self) -> Callable:
        ...

    def _maxima_init_(self, I: Any = None) -> str:
        ...

    def _fast_callable_(self, etb: Any) -> Any:
        ...

    def _eval_numpy_(self, *args: Any) -> Any:
        ...

    def _eval_mpmath_(self, *args: Any) -> Any:
        ...

class GinacFunction(Function):
    def __init__(self, name: str, nargs: int = 1, latex_name: str | None = None, conversions: dict[str, Any] | None = None, ginac_name: str | None = None, evalf_params_first: bool = True, preserved_arg: int | None = None, alt_name: str | None = None):
        ...

class BuiltinFunction(Function):
    def __init__(self, name: str, nargs: int = 1, latex_name: str | None = None, conversions: dict[str, Any] | None = None, evalf_params_first: bool = True, alt_name: str | None = None, preserved_arg: int | None = None):
        ...

    def _method_arguments(self, arg: Any) -> list:
        ...

    def __call__(self, *args: Any, coerce: bool = True, hold: bool = False, dont_call_method_on_arg: bool = False) -> Any:
        ...

    def _is_registered(self) -> bool:
        ...

    def _evalf_or_eval_(self, *args: Any) -> Any:
        ...

    def __reduce__(self) -> tuple:
        ...

    def __setstate__(self, state: list):
        ...

class SymbolicFunction(Function):
    def __init__(self, name: str, nargs: int = 0, latex_name: str | None = None, conversions: dict[str, Any] | None = None, evalf_params_first: bool = True):
        ...

    def _is_registered(self) -> bool:
        ...

    def _hash_(self) -> int:
        ...

    def __hash__(self) -> int:
        ...

    def __getstate__(self) -> tuple:
        ...

    def __setstate__(self, state: tuple):
        ...

def pickle_wrapper(f: Callable | None) -> bytes | None:
    ...

def unpickle_wrapper(p: bytes | None) -> Callable | None:
    ...
