/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.l;
import com.sun.crypto.provider.m;
import com.sun.crypto.provider.r;
import com.sun.crypto.provider.s;
import com.sun.crypto.provider.t;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

class DHPrivateKey
implements PrivateKey,
javax.crypto.interfaces.DHPrivateKey,
Serializable {
    static final long serialVersionUID = 7565477590005668886L;
    private static final BigInteger PKCS8_VERSION = BigInteger.valueOf(0L);
    private BigInteger x;
    private byte[] key;
    private byte[] encodedKey;
    private BigInteger p;
    private BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    public DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    public DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) throws InvalidKeyException {
        this.x = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new s(2, this.x.toByteArray()).o();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Cannot produce ASN.1 encoding");
        }
    }

    public DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            s s2 = new s(byteArrayInputStream);
            if (s2.e != 48) {
                throw new InvalidKeyException("Key not a SEQUENCE");
            }
            BigInteger bigInteger = s2.g.e().a();
            if (!bigInteger.equals(PKCS8_VERSION)) {
                throw new IOException("version mismatch: (supported: " + PKCS8_VERSION + ", parsed: " + bigInteger);
            }
            s s3 = s2.g.d();
            if (s3.e != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            m m2 = s3.p();
            t t2 = m2.h();
            if (m2.a() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            s s4 = m2.d();
            if (s4.e == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (s4.e != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            s4.g.k();
            this.p = s4.g.e().a();
            this.g = s4.g.e().a();
            if (s4.g.a() != 0) {
                this.l = s4.g.e().c();
            }
            if (s4.g.a() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = s2.g.i();
            this.parseKeyBits();
            this.encodedKey = (byte[])byArray.clone();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = ((PrivateKey)object).getEncoded();
        return Arrays.equals(byArray, byArray2);
    }

    public String getAlgorithm() {
        return "DH";
    }

    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                l l2 = new l();
                l2.a(new r(PKCS8_VERSION.toByteArray()));
                l l3 = new l();
                l3.a(new t(this.DH_data));
                l l4 = new l();
                l4.a(new r(this.p));
                l4.a(new r(this.g));
                if (this.l != 0) {
                    l4.a(new r(this.l));
                }
                s s2 = new s(48, l4.toByteArray());
                l3.a(s2);
                l2.a((byte)48, l3);
                l2.b(this.key);
                l l5 = new l();
                l5.a((byte)48, l2);
                this.encodedKey = l5.toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public BigInteger getX() {
        return this.x;
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        int n3 = 1;
        while (n3 < byArray.length) {
            n2 += byArray[n3] * n3;
            ++n3;
        }
        return n2;
    }

    private void parseKeyBits() throws InvalidKeyException {
        m m2 = new m(this.key);
        try {
            this.x = m2.e().a();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SunJCE Diffie-Hellman Private Key:\nx:\n" + new r(this.x).toString() + "\n" + "p:\n" + new r(this.p).toString() + "\n" + "g:\n" + new r(this.g).toString());
        if (this.l != 0) {
            stringBuffer.append("\nl:\n    " + this.l);
        }
        return stringBuffer.toString();
    }
}

