#!/bin/sh
#
# Make all the zip binary distribution

# Exit on error
set -e
set -x
if [ "x$CCM_SCRIPTS_VERBOSE" = "x1" ]; then
    set -v
fi

if [ "x$CCM_SCRIPTS_HOME" = "x" ]; then
    echo "Please set the CCM_SCRIPTS_HOME environment variable"
    exit 1
fi

if [ "x$CCM_ROOT_DIR" = "x" ]; then
    echo "Please set the CCM_ROOT_DIR environment variable"
    exit 1
fi

echo "Creating RPMs"

cd "$CCM_ROOT_DIR"

if [ "x$CCM_RPM_TEMPLATE" = "x" ]; then
  if [ "x$CCM_SCRIPTS_COMPAT" = "x" ]; then
    CCM_RPM_TEMPLATE="$CCM_SCRIPTS_HOME/pkg/dist/rpm.spec.in"
  else
    CCM_RPM_TEMPLATE="$CCM_SCRIPTS_HOME/pkg/dist/rpm.spec.${CCM_SCRIPTS_COMPAT}.in"
  fi
fi

set -x

cat "$CCM_RPM_TEMPLATE" | "$CCM_SCRIPTS_HOME/bin/interpolate.sh" \
  "PKGVERSION=$CCM_PKGVERSION"  "CCMTYPE=$CCM_TYPE" "PROJECT=$CCM_PROJECT" \
  "REQUIRES=$CCM_REQUIRES" "RPM_DEPENDENCIES=$CCM_RPM_DEPENDENCIES" "NAME=$CCM_APP" > "$RPM_DIR/SPECS/$CCM_PACKAGE.spec"

cp "$CCM_DIST_ZIP_DIR/$CCM_PACKAGE_NAME.zip" "$RPM_DIR/SOURCES/"

rpmbuild --define "_topdir $RPM_DIR" $CCM_RPMBUILD_FLAGS -ba "$RPM_DIR/SPECS/$CCM_PACKAGE.spec"

exit 0;

# End of file
