/*
 * Copyright (C) 2001, 2003 ArsDigita Corporation. All Rights Reserved.
 *
 * The contents of this file are subject to the ArsDigita Public 
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.arsdigita.com/ADPL.txt
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portlets.rssfeed.ui;

import com.arsdigita.util.ui.RequestLocalSelectionModel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portlets.rssfeed.RSSFeedPortlet;
import com.arsdigita.portlets.rssfeed.RSSFeedPortletHelper;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;


public class RSSFeedPortletRenderer extends AbstractPortletRenderer {
    private RSSFeedPortlet m_portlet;
    
    public RSSFeedPortletRenderer(RSSFeedPortlet portlet) {
        m_portlet = portlet;
    }


    public void generateBodyXML(PageState state,
                                Element parent) {
        Element content = parent.newChildElement("portlet:RSSFeed",
                                       "http://www.arsdigita.com/portlet/1.0");
        
        String feed = m_portlet.getURL();
        
        if (feed != null) {
            Element data = RSSFeedPortletHelper.getRSSElement(feed);
            if (data != null) {
                content.addContent(data);
            } else {
                Element error = content.newChildElement(
                    "portlet:RSSFeedError",
                    "http://www.arsdigita.com/portlet/1.0");
                error.setText("There was an error fetching this content feed");
            }
        }
    }
}
