/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.ui.login.UserAuthenticationListener;

import java.util.Map;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class PortalSiteMapDispatcher extends BebopMapDispatcher {

    private static final Logger s_log = Logger.getLogger
        (PortalSiteMapDispatcher.class);

    private static final String XSL_HOOK = "portal-sitemap";


    public PortalSiteMapDispatcher() {
        s_log.warn("PortalSiteMapDispatcher created!");

        Page index = buildSiteMapPage();
        addPage("", index);
        addPage("index.jsp", index);
   } 

    static Page buildSiteMapPage() {
        Page page = PageFactory.buildPage(XSL_HOOK, "Portal Site Map");
        PortalSiteMapPanel sitemapPanel = new PortalSiteMapPanel(page);
        page.add(sitemapPanel);
        page.addRequestListener(new UserAuthenticationListener());
        
        page.lock();
        return page;
    }

}
