/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.test;

import com.arsdigita.kernel.EmailAddress;

public final class TestApps {
    public static final String KM_MANAGER =  "Knowledge Manager";
    public static final String DOC_MANAGER =  "Document Manager";
    public static final String FORUM = "Forum";
    public static final String PORTAL = "test";

    public static final String MANAGERS = "Managers";
    public static final String EDITORS = "Editors";
    public static final String MEMBERS = "Members";

    public static final String DEFAULT_DOMAIN = "redhat.com";

    public static final EmailAddress SWA = new EmailAddress("swa@" + DEFAULT_DOMAIN);
    public static final EmailAddress USER = new EmailAddress("joeuser@" + DEFAULT_DOMAIN);
    public static final EmailAddress MANAGER = new EmailAddress("joemanager@" + DEFAULT_DOMAIN);
    public static final EmailAddress EDITOR = new EmailAddress("joeeditor@" + DEFAULT_DOMAIN);

    private TestApps() {
    }
}
