/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

    /**
     * This class represents the Domain Object Collection for 
     * <code> PortalTab </code>. 
     *
     * @author Jim Parsons
     */

public class PortalTabCollection extends DomainCollection {

    protected PortalTabCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Get the ID for the PortalTab for the current row.
     *
     * @return the id of this PortalTab.
     * @post return != null
     */
    public BigDecimal getID() {
        BigDecimal id = (BigDecimal)m_dataCollection.get("id");

        Assert.assertNotNull(id);

        return id;
    }

    /**
     * Get the current item as a domain object.
     *
     * @return the domain object for the current row.
     * @post return != null
     */
    public DomainObject getDomainObject() {
        DomainObject domainObject = getPortalTab();

        Assert.assertNotNull(domainObject);

        return domainObject;
    }

    /**
     * Get the current item as a PortalTab domain object.
     *
     * @return a Portal domain object.
     * @post return != null
     */
    public PortalTab getPortalTab() {
        DataObject dataObject = m_dataCollection.getDataObject();

        PortalTab portalTab = PortalTab.retrieveTab(dataObject);

        Assert.assertNotNull(portalTab);

        return portalTab;
    }

    /**
     * Get the title for the PortalTab for the current row.
     *
     * @return the title of this PortalTab.
     * @post return != null
     */
    public String getTitle() {
        String title = (String)m_dataCollection.get("title");

        Assert.assertNotNull(title);

        return title;
    }
}
