package com.arsdigita.portalserver; 
import com.arsdigita.db.*;
import com.arsdigita.domain.*;
import com.arsdigita.loader.*;
import com.arsdigita.installer.SQLLoader;
import com.arsdigita.kernel.*;
import com.arsdigita.kernel.permissions.*;
import com.arsdigita.mimetypes.*;
import com.arsdigita.persistence.*;
import com.arsdigita.portal.*;
import com.arsdigita.runtime.*;
import com.arsdigita.util.*;
import com.arsdigita.util.csv.*;
import com.arsdigita.util.jdbc.*;
import com.arsdigita.util.servlet.*;
import com.arsdigita.web.*;
import java.io.*;
import java.net.*;
import java.sql.*;
import java.util.*;
import org.apache.log4j.Logger;

/**
 * Portal Server Loader
 *
 * @author Jim Parsons &lt;jparsons@redhat.com&gt;
 * @version $Revision: #1 $ $Date: 2003/10/24 $
 **/

public class Loader extends PackageLoader {


    private static final Logger s_log = Logger.getLogger(Loader.class);

    public void run(final ScriptContext ctx) {

        new KernelExcursion() {
            public void excurse() {
                setEffectiveParty(Kernel.getSystemParty());

                loadSubsite();
            }
        }.run();

        s_log.warn("Done");
    }


    private void loadSubsite() {
        String stylesheetName = "";
        String sDispatcher = "";

        SiteNode rootNode = SiteNode.getRootSiteNode();

        PackageInstance packageInstance = rootNode.getPackageInstance();
        if (packageInstance == null) {
            throw new IllegalStateException
                ("No package instance mounted at the root node");
        }
        PackageType subsite = packageInstance.getType();

        // getType() returns a disconnected object.  To get a connected object
        // we do a findByKey(key).
        String packageKey = subsite.getKey();
        try {
            subsite = PackageType.findByKey(packageKey);
        } catch (DataObjectNotFoundException e) {
            throw new IllegalStateException
                ("Package Type with key \"" + packageKey + "\" was not found.\n");
        }

        // Create default stylesheet.
        stylesheetName = "/packages/login/xsl/login_ps_en.xsl";

        s_log.warn("Adding stylesheet: " + stylesheetName);
        subsite.addStylesheet(Stylesheet.createStylesheet(stylesheetName));

        // Set subsite dispatcher class.
        subsite.setDispatcherClass("com.arsdigita.portalserver.pslogin.PSSubsiteDispatcher");
    }

}
