package com.arsdigita.portalserver;

import com.arsdigita.db.*;
import com.arsdigita.domain.*;
import com.arsdigita.persistence.*;
import com.arsdigita.persistence.pdl.*;
import com.arsdigita.web.*;
import com.arsdigita.runtime.*;

/**
 * PortalserverInitializer
 *
 * @author Jim Parsons &lt;jparsons@redhat.com&gt;
 * @version $Revision: #18 $ $Date: 2003/10/24 $
 **/

public class Initializer extends CompoundInitializer {


    public Initializer() {
        final String url = RuntimeConfig.getConfig().getJDBCURL();
        final int database = DbHelper.getDatabaseFromURL(url);

        add(new PDLInitializer
            (new ManifestSource
             ("ccm-portalserver.pdl.mf",
              new NameFilter(DbHelper.getDatabaseSuffix(database), "pdl"))));

        add(new LegacyInitializer("com/arsdigita/portalserver/enterprise.init"));
    }


}
