/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;

import com.arsdigita.persistence.*;
import com.arsdigita.domain.*;
import com.arsdigita.kernel.*;
import com.arsdigita.sitenode.*;
import com.arsdigita.web.*;
import java.util.*;

/**
 * ECMPresentationManager
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #4 $ $Date: 2003/08/15 $
 **/

public class ECMPresentationManager extends BasePresentationManager {

    public final static String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ECMPresentationManager.java#4 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    private static Map m_sheets = new HashMap();

    protected synchronized Stylesheet findStylesheet(SiteNode node, Locale l,
                                                     String outputType) {
        TransactionContext ctx =
            SessionManager.getSession().getTransactionContext();

        boolean commit = false;
        if (!ctx.inTxn()) {
            ctx.beginTxn();
            commit = true;
        }

        String key = l + "." + outputType;

        Stylesheet result = (Stylesheet) m_sheets.get(key);

        if (result == null || !result.isValid()) {
            ApplicationType type =
                ApplicationType.retrieveApplicationTypeForApplication(
                                          PortalSite.BASE_DATA_OBJECT_TYPE);
            PackageType pkg = type.getPackageType();
            result = pkg.getStylesheet(l, outputType);
            result.disconnect();
            m_sheets.put(key, result);
        }

        if (commit) {
            ctx.commitTxn();
        }

        return result;
    }

}
