/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;


import com.arsdigita.portalserver.util.GlobalizationUtil; 

import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.xml.Element;

public class ApplicationDirectoryPortlet extends AppPortlet {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ApplicationDirectoryPortlet.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.workspace.ApplicationDirectoryPortlet";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public ApplicationDirectoryPortlet(DataObject dataObject) {
        super(dataObject);
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new ApplicationDirectoryPortletRenderer(this);
    }
}

class ApplicationDirectoryPortletRenderer extends AbstractPortletRenderer {
    private ApplicationDirectoryPortlet m_portlet;

    public ApplicationDirectoryPortletRenderer
        (ApplicationDirectoryPortlet portlet) {
        m_portlet = portlet;
    }

    protected void generateBodyXML(PageState pageState, Element parentElement) {
        PortalSite portalsite = 
              PortalSite.getPortalSiteForAppPortlet(m_portlet);

        if (portalsite == null) {
            return;
        }

        // Variables used cursorwise.
        int counter;
        String title = null;
        String url = null;

        ApplicationCollection apps =
            portalsite.getFullPagePortalSiteApplications();

        GridPanel innerPanel = new GridPanel(1);

        for (counter = 0; apps.next(); counter++) {
            title = apps.getTitle();
            url = apps.getPrimaryURL();
            innerPanel.add(new Link(title, url));
        }

        if (counter == 0) {
            innerPanel.add(new Label(GlobalizationUtil.globalize("cw.workspace.none")));
        }

        innerPanel.generateXML(pageState, parentElement);
    }
}
