/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.ui.admin;


import com.arsdigita.portalserver.util.GlobalizationUtil; 


import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.portalserver.ApplicationAuthenticationListener;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalPage;

import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;

import org.apache.log4j.Category;

public class PortalAdminPage extends PortalPage {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/PortalAdminPage.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    private static Category s_log = Category.getInstance
        (PortalAdminPage.class.getName());

    RequestLocal m_portalsiteRL;

    public PortalAdminPage() {
        super();
 
        this.setClassAttr("portalserveradmin");

        getHeader().setIdAttr("admin");

        m_portalsiteRL = new RequestLocal() {
                protected Object initialValue(PageState ps) {
                    return PortalSite.getCurrentPortalSite(ps.getRequest());
                }
            };

        addRequestListener(new ApplicationAuthenticationListener("admin"));

        lock();
    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();

        navbar.setClassAttr("portalNavbar");

        navbar.add(new Link(new PersonalPortalLinkPrinter()));
        navbar.add(new Link(new CurrentPortalLinkPrinter()));
        navbar.add(new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.configure_workspace")));

        getHeader().add(navbar);
    }

    protected void buildHeader(Container header) {
        Link returnLink = new Link( new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.return_to_workspace")),  "../");

        returnLink.setClassAttr("portalControl");

        header.add(returnLink);
    }

    protected void buildBody(Container body) {
        TabbedPane pane = new TabbedPane();

        pane.setClassAttr("portalserver_admin"); 

        pane.addTab("Layout", new DisplayPane(m_portalsiteRL));
        pane.addTab("Themes", new ThemesPane(m_portalsiteRL));
        pane.addTab("Applications", ApplicationsPane.create(m_portalsiteRL));
        pane.addTab("People", PeoplePane.create(this, m_portalsiteRL));
        pane.addTab("Related Portals",
                    RelatedPortalsPane.create(m_portalsiteRL));
        pane.addTab("Basic Properties", BasicPane.create(m_portalsiteRL));

        body.add(pane);
        body.setClassAttr("portalserver_admin");
    }

    public void addStyleBlock(PageState state, Document parent) {
        PortalSite psite = PortalSite.getCurrentPortalSite(state.getRequest());

        StringBuffer buffer = new StringBuffer();

        buffer.append("<STYLE type=\"text/css\"> <!--");


          buffer.append(" table.globalHeader { background-color: rgb(225,225,225);} ");

        buffer.append(" table.bottomRule { background: rgb(162,30,30);} ");

        buffer.append(" table.topRuleNoTabs { background: rgb(162,30,30);} ");

        buffer.append("--></STYLE>");

        Element rootElement = parent.getRootElement();

        Element styleBlock = rootElement.newChildElement(
                                     "portalserver:styleblock", 
                                     "http://www.redhat.com/portalserver/1.0");

        styleBlock.setCDATASection(buffer.toString());

    }


}
