/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.personal;


import com.arsdigita.portalserver.util.GlobalizationUtil; 

import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.ui.PortalHomePage;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.permissions.UniversalPermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.util.Assert;
import com.arsdigita.bebop.Container;

/**
 * <p><strong>Experimental</strong></p>
 *
 * @author <a href="mailto:justin@arsdigita.com">Justin Ross</a>
 * @version $Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortalHomePage.java#7 $
 */
public class PersonalPortalHomePage extends PortalHomePage {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/personal/PersonalPortalHomePage.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    private final RequestLocal m_adminPermission = new RequestLocal() {
            protected Object initialValue(PageState state) {
                UniversalPermissionDescriptor descriptor =
                    new UniversalPermissionDescriptor
                    (PrivilegeDescriptor.ADMIN,
                     Kernel.getContext().getParty());

                if (PermissionService.checkPermission(descriptor)) {
                    return Boolean.TRUE;
                } else {
                    return Boolean.FALSE;
                }
            }
        };

    public PersonalPortalHomePage() {
        super();
    }

    protected void buildHeader(Container header) {
        // Add a link to edit profile.
        Link profileLink = new Link( new Label(GlobalizationUtil.globalize("cw.workspace.personal.edit_your_profile")),  "/register/edit-profile");
        profileLink.setClassAttr("portalControlProfileLink");
        header.add(profileLink);

        // And to change passwords.
        Link passwordLink = new Link( new Label(GlobalizationUtil.globalize("cw.workspace.personal.change_your_password")),  "/register/change-password");
        passwordLink.setClassAttr("portalControlProfileLink");
        header.add(passwordLink);

        // If the user is an administrator, offer her a link to
        // the Portal admin page.

        Link adminLink = new Link( new Label(GlobalizationUtil.globalize("cw.workspace.personal.site_administration")),  "/portal-admin/") {
                public boolean isVisible(PageState state) {
                    Boolean bool = (Boolean) m_adminPermission.get(state);
                    return bool.booleanValue();
                }
            };

        adminLink.setClassAttr("portalControlProfileLink");
        header.add(adminLink);

        super.buildHeader(header);
    }

    protected void buildTitle() {
        class TitlePrintListener implements PrintListener {
            public void prepare(PrintEvent e) {
                PageState pageState = e.getPageState();

                PortalSite psite = PortalSite.getCurrentPortalSite
                    (pageState.getRequest());

                Assert.assertTrue(psite instanceof PersonalPortal);

                PersonalPortal pp = (PersonalPortal) psite;

                User user = pp.getOwningUser();

                String givenName = user.getPersonName().getGivenName();

                Label target = (Label) e.getTarget();

                if (givenName.endsWith("s")) {
                    target.setLabel(givenName + "' " + pp.getTitle());
                } else {
                    target.setLabel(givenName + "'s " + pp.getTitle());
                }

                // That was notably english only.
            }
        }

        setTitle(new Label(new TitlePrintListener()));
    }

    protected void buildContextBar() {
        DimensionalNavbar navbar = new DimensionalNavbar();

        navbar.add(new Label(GlobalizationUtil.globalize("cw.workspace.personal.personal_workspace")));
        navbar.setClassAttr("portalNavbar");

        getHeader().add(navbar);
    }
}
