/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver.admin;

import com.arsdigita.initializer.Configuration;
import org.apache.log4j.Logger;

import com.arsdigita.persistence.*;
import com.arsdigita.domain.*;
import com.arsdigita.kernel.*;
import com.arsdigita.portalserver.*;
import com.arsdigita.web.*;

/**
 * Initializer
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #8 $ $Date: 2003/10/07 $
 **/

public class Initializer implements com.arsdigita.initializer.Initializer {

    public final static String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/admin/Initializer.java#8 $ by $Author: bche $, $DateTime: 2003/10/07 11:20:18 $";

    private static Logger s_log = Logger.getLogger(Initializer.class);

    private Configuration m_conf = new Configuration();

    public Configuration getConfiguration() {
        return m_conf;
    }

    public void startup() {
        s_log.info("Initializing PortalServer Admin...");

        TransactionContext txn =
            SessionManager.getSession().getTransactionContext();

        txn.beginTxn();

        ApplicationSetup setup = new ApplicationSetup(s_log);

        setup.setApplicationObjectType(PSAdmin.BASE_DATA_OBJECT_TYPE);
        setup.setTitle("Portal Server Site Administration");
        setup.setDescription("Displays common administration tasks.");
        setup.setPortalApplication(false);
        setup.setKey("portal-admin");
        setup.setStylesheet("/packages/portalserver/xsl/portalserver.xsl");
        setup.setDispatcherClass("com.arsdigita.portalserver.admin.ui.Dispatcher");
        setup.setInstantiator(new ACSObjectInstantiator() {
                protected DomainObject doNewInstance(DataObject dataObject) {
                    return new PSAdmin(dataObject);
                }
            });
        setupAdminInstance(setup.run());

        txn.commitTxn();

        s_log.info("Done initializing PortalServer Admin.");
    }

    private void setupAdminInstance(final ApplicationType type) {
        if (!Application.isInstalled(PSAdmin.BASE_DATA_OBJECT_TYPE,
                                     "/portal-admin/")) {
            s_log.info("There is no Portal Admin application instance on " +
                       "/portal-admin/.  Installing now.");

            KernelExcursion ex = new KernelExcursion() {
                protected void excurse() {
                    setParty(Kernel.getSystemParty());
                    Application app = Application.createApplication
                        (type, "portal-admin", "Site Administration", null);

                    app.save();
                }
            };
            ex.run();

            s_log.info("Done installing Portal Admin on /portal-admin/.");
        }
    }

    public void shutdown() {
        // Do nothing.
    }

}
