/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class ThemeCollection extends DomainCollection {

    protected ThemeCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Get the ID for the Theme for the current row.
     *
     * @return the id of this Theme.
     * @post return != null
     */
    public BigDecimal getID() {
        BigDecimal id = (BigDecimal)m_dataCollection.get("id");

        Assert.assertNotNull(id);

        return id;
    }

    /**
     * Get the current item as a domain object.
     *
     * @return the domain object for the current row.
     * @post return != null
     */
    public DomainObject getDomainObject() {
        DomainObject domainObject = getTheme();

        Assert.assertNotNull(domainObject);

        return domainObject;
    }

    /**
     * Get the current item as a Theme domain object.
     *
     * @return a Theme domain object.
     * @post return != null
     */
    public Theme getTheme() {
        DataObject dataObject = m_dataCollection.getDataObject();

        Theme theme = Theme.retrieveTheme(dataObject);

        Assert.assertNotNull(theme);

        return theme;
    }

    /**
     * Get the name for the Theme for the current row.
     *
     * @return the name of this theme.
     * @post return != null
     */
    public String getName() {
        String name = (String)m_dataCollection.get("theme_name");

        Assert.assertNotNull(name);

        return name;
    }

}
