/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;

import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.util.Assert;
import com.arsdigita.persistence.DataCollection;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

/**
 * <p><strong>Experimental</strong></p>
 *
 * @author Justin Ross &lt;<a href="mailto:jross@redhat.com">jross@redhat.com</a>&gt;
 * @version $Id: //portalserver/dev/src/com/arsdigita/portalserver/PortalSiteCollection.java#4 $
 */
public class PortalSiteCollection extends ApplicationCollection {
    public static final String versionId =
        "$Id: //portalserver/dev/src/com/arsdigita/portalserver/PortalSiteCollection.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    private static final Logger s_log = Logger.getLogger
        (PortalSiteCollection.class);

    public PortalSiteCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    public void filterToPortalSite(BigDecimal id) {
        m_dataCollection.addEqualsFilter("id", id);
    }

    public void filterForArchived() {
        m_dataCollection.addEqualsFilter("isArchived", Boolean.TRUE);
    }

    public void filterForUnarchived() {
        m_dataCollection.addEqualsFilter("isArchived", Boolean.FALSE);
    }

    /**
     * Get the current item as a PortalSite domain object.
     *
     * @return a PortalSite domain object.
     * @post return != null
     */
    public PortalSite getPortalSite() {
        PortalSite portalsite = (PortalSite)getDomainObject();

        Assert.assertNotNull(portalsite);

        return portalsite;
    }
}
