/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.portalserver;


import com.arsdigita.portalserver.util.GlobalizationUtil; 

import com.arsdigita.bebop.BlockStylable;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.xml.Element;

public class PortalNavigatorPortlet extends AppPortlet {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/PortalNavigatorPortlet.java#7 $ by $Author: dennis $, $DateTime: 2003/08/15 13:46:34 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.workspace.WorkspaceNavigatorPortlet";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public PortalNavigatorPortlet(DataObject dataObject) {
        super(dataObject);
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new PortalNavigatorPortletRenderer(this);
    }
}

class PortalNavigatorPortletRenderer extends AbstractPortletRenderer {
    private PortalNavigatorPortlet m_portlet;

    public PortalNavigatorPortletRenderer
        (PortalNavigatorPortlet portlet) {
        m_portlet = portlet;
    }

    protected void generateBodyXML(PageState pageState, Element parentElement) {
        PortalSite currentPortal =
            (PortalSite) m_portlet.getParentApplication();

        if (currentPortal == null) {
            return;
        }

        GridPanel panel = new GridPanel(2);

        // Variables used cursorwise.
        int counter;
        String title = null;
        String url = null;

        // Parent Portal

        PortalSite portalsite = PortalSite.getPortalSiteForApplication
            (currentPortal);

        if (portalsite != null) {
            title = portalsite.getTitle();
            url = portalsite.getPrimaryURL();
            panel.add(new Link(title, url));
            Label l = new Label(GlobalizationUtil.globalize("cw.workspace.parent"));
            l.setFontWeight(Label.ITALIC);
            panel.add(l, BlockStylable.RIGHT);
        }

        // Child Portals

        PortalSiteCollection childPortals =
            currentPortal.getChildPortalSites();

        for (counter = 0; childPortals.next(); counter++) {
            title = childPortals.getTitle();
            url = childPortals.getPrimaryURL();
            panel.add(new Link(title, url));
            Label l = new Label(GlobalizationUtil.globalize("cw.workspace.child"));
            l.setFontWeight(Label.ITALIC);
            panel.add(l, BlockStylable.RIGHT);
        }

        // Related portals

        PortalSiteCollection relatedPortals =
            currentPortal.getRelatedPortalSites();

        for (counter = 0; relatedPortals.next(); counter++) {
            title = relatedPortals.getTitle();
            url = relatedPortals.getPrimaryURL();
            panel.add(new Link(title, url));
            panel.add(new Label(""));
        }

        panel.generateXML(pageState, parentElement);
    }
}
